
// We are modularizing this manually because the current modularize setting in Emscripten has some issues:
// https://github.com/kripken/emscripten/issues/5820
// In addition, When you use emcc's modularization, it still expects to export a global object called `Module`,
// which is able to be used/called before the WASM is loaded.
// The modularization below exports a promise that loads and resolves to the actual sql.js module.
// That way, this module can't be used before the WASM is finished loading.

// We are going to define a function that a user will call to start loading initializing our Sql.js library
// However, that function might be called multiple times, and on subsequent calls, we don't actually want it to instantiate a new instance of the Module
// Instead, we want to return the previously loaded module

// TODO: Make this not declare a global if used in the browser
var initSqlJsPromise = undefined;

var initSqlJs = function (moduleConfig) {

    if (initSqlJsPromise){
      return initSqlJsPromise;
    }
    // If we're here, we've never called this function before
    initSqlJsPromise = new Promise(function (resolveModule, reject) {

        // We are modularizing this manually because the current modularize setting in Emscripten has some issues:
        // https://github.com/kripken/emscripten/issues/5820

        // The way to affect the loading of emcc compiled modules is to create a variable called `Module` and add
        // properties to it, like `preRun`, `postRun`, etc
        // We are using that to get notified when the WASM has finished loading.
        // Only then will we return our promise

        // If they passed in a moduleConfig object, use that
        // Otherwise, initialize Module to the empty object
        var Module = typeof moduleConfig !== 'undefined' ? moduleConfig : {};

        // EMCC only allows for a single onAbort function (not an array of functions)
        // So if the user defined their own onAbort function, we remember it and call it
        var originalOnAbortFunction = Module['onAbort'];
        Module['onAbort'] = function (errorThatCausedAbort) {
            reject(new Error(errorThatCausedAbort));
            if (originalOnAbortFunction){
              originalOnAbortFunction(errorThatCausedAbort);
            }
        };

        Module['postRun'] = Module['postRun'] || [];
        Module['postRun'].push(function () {
            // When Emscripted calls postRun, this promise resolves with the built Module
            resolveModule(Module);
        });

        // There is a section of code in the emcc-generated code below that looks like this:
        // (Note that this is lowercase `module`)
        // if (typeof module !== 'undefined') {
        //     module['exports'] = Module;
        // }
        // When that runs, it's going to overwrite our own modularization export efforts in shell-post.js!
        // The only way to tell emcc not to emit it is to pass the MODULARIZE=1 or MODULARIZE_INSTANCE=1 flags,
        // but that carries with it additional unnecessary baggage/bugs we don't want either.
        // So, we have three options:
        // 1) We undefine `module`
        // 2) We remember what `module['exports']` was at the beginning of this function and we restore it later
        // 3) We write a script to remove those lines of code as part of the Make process.
        //
        // Since those are the only lines of code that care about module, we will undefine it. It's the most straightforward
        // of the options, and has the side effect of reducing emcc's efforts to modify the module if its output were to change in the future.
        // That's a nice side effect since we're handling the modularization efforts ourselves
        module = undefined;

        // The emcc-generated code and shell-post.js code goes below,
        // meaning that all of it runs inside of this promise. If anything throws an exception, our promise will abort
var f;f||=typeof Module != 'undefined' ? Module : {};var aa="object"==typeof window,ba="function"==typeof importScripts,ca="object"==typeof process&&"object"==typeof process.versions&&"string"==typeof process.versions.node;"use strict";
f.onRuntimeInitialized=function(){function a(g,k){switch(typeof k){case "boolean":fc(g,k?1:0);break;case "number":gc(g,k);break;case "string":hc(g,k,-1,-1);break;case "object":if(null===k)ib(g);else if(null!=k.length){var n=da(k,ea);ic(g,n,k.length,-1);fa(n)}else xa(g,"Wrong API use : tried to return a value of an unknown type ("+k+").",-1);break;default:ib(g)}}function b(g,k){for(var n=[],r=0;r<g;r+=1){var w=m(k+4*r,"i32"),A=jc(w);if(1===A||2===A)w=kc(w);else if(3===A)w=lc(w);else if(4===A){A=w;
w=mc(A);A=nc(A);for(var N=new Uint8Array(w),M=0;M<w;M+=1)N[M]=p[A+M];w=N}else w=null;n.push(w)}return n}function c(g,k){this.Ka=g;this.db=k;this.Ia=1;this.eb=[]}function d(g,k){this.db=k;k=ha(g)+1;this.Xa=ia(k);if(null===this.Xa)throw Error("Unable to allocate memory for the SQL string");q(g,t,this.Xa,k);this.cb=this.Xa;this.Ta=this.hb=null}function e(g){this.filename="dbfile_"+(4294967295*Math.random()>>>0);if(null!=g){var k=this.filename,n="/",r=k;n&&(n="string"==typeof n?n:ja(n),r=k?x(n+"/"+k):
n);k=ka(!0,!0);r=la(r,(void 0!==k?k:438)&4095|32768,0);if(g){if("string"==typeof g){n=Array(g.length);for(var w=0,A=g.length;w<A;++w)n[w]=g.charCodeAt(w);g=n}ma(r,k|146);n=na(r,577);oa(n,g,0,g.length,0);pa(n);ma(r,k)}}this.handleError(u(this.filename,h));this.db=m(h,"i32");lb(this.db);this.Ya={};this.Ma={}}var h=y(4),l=f.cwrap,u=l("sqlite3_open","number",["string","number"]),z=l("sqlite3_close_v2","number",["number"]),v=l("sqlite3_exec","number",["number","string","number","number","number"]),E=l("sqlite3_changes",
"number",["number"]),H=l("sqlite3_prepare_v2","number",["number","string","number","number","number"]),mb=l("sqlite3_sql","string",["number"]),oc=l("sqlite3_normalized_sql","string",["number"]),nb=l("sqlite3_prepare_v2","number",["number","number","number","number","number"]),pc=l("sqlite3_bind_text","number",["number","number","number","number","number"]),ob=l("sqlite3_bind_blob","number",["number","number","number","number","number"]),qc=l("sqlite3_bind_double","number",["number","number","number"]),
rc=l("sqlite3_bind_int","number",["number","number","number"]),sc=l("sqlite3_bind_parameter_index","number",["number","string"]),tc=l("sqlite3_step","number",["number"]),uc=l("sqlite3_errmsg","string",["number"]),vc=l("sqlite3_column_count","number",["number"]),wc=l("sqlite3_data_count","number",["number"]),xc=l("sqlite3_column_double","number",["number","number"]),pb=l("sqlite3_column_text","string",["number","number"]),yc=l("sqlite3_column_blob","number",["number","number"]),zc=l("sqlite3_column_bytes",
"number",["number","number"]),Ac=l("sqlite3_column_type","number",["number","number"]),Bc=l("sqlite3_column_name","string",["number","number"]),Cc=l("sqlite3_reset","number",["number"]),Dc=l("sqlite3_clear_bindings","number",["number"]),Ec=l("sqlite3_finalize","number",["number"]),qb=l("sqlite3_create_function_v2","number","number string number number number number number number number".split(" ")),jc=l("sqlite3_value_type","number",["number"]),mc=l("sqlite3_value_bytes","number",["number"]),lc=l("sqlite3_value_text",
"string",["number"]),nc=l("sqlite3_value_blob","number",["number"]),kc=l("sqlite3_value_double","number",["number"]),gc=l("sqlite3_result_double","",["number","number"]),ib=l("sqlite3_result_null","",["number"]),hc=l("sqlite3_result_text","",["number","string","number","number"]),ic=l("sqlite3_result_blob","",["number","number","number","number"]),fc=l("sqlite3_result_int","",["number","number"]),xa=l("sqlite3_result_error","",["number","string","number"]),rb=l("sqlite3_aggregate_context","number",
["number","number"]),lb=l("RegisterExtensionFunctions","number",["number"]);c.prototype.bind=function(g){if(!this.Ka)throw"Statement closed";this.reset();return Array.isArray(g)?this.vb(g):null!=g&&"object"===typeof g?this.wb(g):!0};c.prototype.step=function(){if(!this.Ka)throw"Statement closed";this.Ia=1;var g=tc(this.Ka);switch(g){case 100:return!0;case 101:return!1;default:throw this.db.handleError(g);}};c.prototype.qb=function(g){null==g&&(g=this.Ia,this.Ia+=1);return xc(this.Ka,g)};c.prototype.zb=
function(g){null==g&&(g=this.Ia,this.Ia+=1);g=pb(this.Ka,g);if("function"!==typeof BigInt)throw Error("BigInt is not supported");return BigInt(g)};c.prototype.Ab=function(g){null==g&&(g=this.Ia,this.Ia+=1);return pb(this.Ka,g)};c.prototype.getBlob=function(g){null==g&&(g=this.Ia,this.Ia+=1);var k=zc(this.Ka,g);g=yc(this.Ka,g);for(var n=new Uint8Array(k),r=0;r<k;r+=1)n[r]=p[g+r];return n};c.prototype.get=function(g,k){k=k||{};null!=g&&this.bind(g)&&this.step();g=[];for(var n=wc(this.Ka),r=0;r<n;r+=
1)switch(Ac(this.Ka,r)){case 1:var w=k.useBigInt?this.zb(r):this.qb(r);g.push(w);break;case 2:g.push(this.qb(r));break;case 3:g.push(this.Ab(r));break;case 4:g.push(this.getBlob(r));break;default:g.push(null)}return g};c.prototype.getColumnNames=function(){for(var g=[],k=vc(this.Ka),n=0;n<k;n+=1)g.push(Bc(this.Ka,n));return g};c.prototype.getAsObject=function(g,k){g=this.get(g,k);k=this.getColumnNames();for(var n={},r=0;r<k.length;r+=1)n[k[r]]=g[r];return n};c.prototype.getSQL=function(){return mb(this.Ka)};
c.prototype.getNormalizedSQL=function(){return oc(this.Ka)};c.prototype.run=function(g){null!=g&&this.bind(g);this.step();return this.reset()};c.prototype.mb=function(g,k){null==k&&(k=this.Ia,this.Ia+=1);g=qa(g);var n=da(g,ea);this.eb.push(n);this.db.handleError(pc(this.Ka,k,n,g.length-1,0))};c.prototype.ub=function(g,k){null==k&&(k=this.Ia,this.Ia+=1);var n=da(g,ea);this.eb.push(n);this.db.handleError(ob(this.Ka,k,n,g.length,0))};c.prototype.lb=function(g,k){null==k&&(k=this.Ia,this.Ia+=1);this.db.handleError((g===
(g|0)?rc:qc)(this.Ka,k,g))};c.prototype.xb=function(g){null==g&&(g=this.Ia,this.Ia+=1);ob(this.Ka,g,0,0,0)};c.prototype.nb=function(g,k){null==k&&(k=this.Ia,this.Ia+=1);switch(typeof g){case "string":this.mb(g,k);return;case "number":this.lb(g,k);return;case "bigint":this.mb(g.toString(),k);return;case "boolean":this.lb(g+0,k);return;case "object":if(null===g){this.xb(k);return}if(null!=g.length){this.ub(g,k);return}}throw"Wrong API use : tried to bind a value of an unknown type ("+g+").";};c.prototype.wb=
function(g){var k=this;Object.keys(g).forEach(function(n){var r=sc(k.Ka,n);0!==r&&k.nb(g[n],r)});return!0};c.prototype.vb=function(g){for(var k=0;k<g.length;k+=1)this.nb(g[k],k+1);return!0};c.prototype.reset=function(){this.freemem();return 0===Dc(this.Ka)&&0===Cc(this.Ka)};c.prototype.freemem=function(){for(var g;void 0!==(g=this.eb.pop());)fa(g)};c.prototype.free=function(){this.freemem();var g=0===Ec(this.Ka);delete this.db.Ya[this.Ka];this.Ka=0;return g};d.prototype.next=function(){if(null===
this.Xa)return{done:!0};null!==this.Ta&&(this.Ta.free(),this.Ta=null);if(!this.db.db)throw this.fb(),Error("Database closed");var g=ra(),k=y(4);sa(h);sa(k);try{this.db.handleError(nb(this.db.db,this.cb,-1,h,k));this.cb=m(k,"i32");var n=m(h,"i32");if(0===n)return this.fb(),{done:!0};this.Ta=new c(n,this.db);this.db.Ya[n]=this.Ta;return{value:this.Ta,done:!1}}catch(r){throw this.hb=ta(this.cb),this.fb(),r;}finally{ua(g)}};d.prototype.fb=function(){fa(this.Xa);this.Xa=null};d.prototype.getRemainingSQL=
function(){return null!==this.hb?this.hb:ta(this.cb)};"function"===typeof Symbol&&"symbol"===typeof Symbol.iterator&&(d.prototype[Symbol.iterator]=function(){return this});e.prototype.run=function(g,k){if(!this.db)throw"Database closed";if(k){g=this.prepare(g,k);try{g.step()}finally{g.free()}}else this.handleError(v(this.db,g,0,0,h));return this};e.prototype.exec=function(g,k,n){if(!this.db)throw"Database closed";var r=ra(),w=null;try{var A=va(g),N=y(4);for(g=[];0!==m(A,"i8");){sa(h);sa(N);this.handleError(nb(this.db,
A,-1,h,N));var M=m(h,"i32");A=m(N,"i32");if(0!==M){var K=null;w=new c(M,this);for(null!=k&&w.bind(k);w.step();)null===K&&(K={columns:w.getColumnNames(),values:[]},g.push(K)),K.values.push(w.get(null,n));w.free()}}return g}catch(O){throw w&&w.free(),O;}finally{ua(r)}};e.prototype.each=function(g,k,n,r,w){"function"===typeof k&&(r=n,n=k,k=void 0);g=this.prepare(g,k);try{for(;g.step();)n(g.getAsObject(null,w))}finally{g.free()}if("function"===typeof r)return r()};e.prototype.prepare=function(g,k){sa(h);
this.handleError(H(this.db,g,-1,h,0));g=m(h,"i32");if(0===g)throw"Nothing to prepare";var n=new c(g,this);null!=k&&n.bind(k);return this.Ya[g]=n};e.prototype.iterateStatements=function(g){return new d(g,this)};e.prototype["export"]=function(){Object.values(this.Ya).forEach(function(k){k.free()});Object.values(this.Ma).forEach(wa);this.Ma={};this.handleError(z(this.db));var g=ya(this.filename);this.handleError(u(this.filename,h));this.db=m(h,"i32");lb(this.db);return g};e.prototype.close=function(){null!==
this.db&&(Object.values(this.Ya).forEach(function(g){g.free()}),Object.values(this.Ma).forEach(wa),this.Ma={},this.handleError(z(this.db)),za("/"+this.filename),this.db=null)};e.prototype.handleError=function(g){if(0===g)return null;g=uc(this.db);throw Error(g);};e.prototype.getRowsModified=function(){return E(this.db)};e.prototype.create_function=function(g,k){Object.prototype.hasOwnProperty.call(this.Ma,g)&&(wa(this.Ma[g]),delete this.Ma[g]);var n=Aa(function(r,w,A){w=b(w,A);try{var N=k.apply(null,
w)}catch(M){xa(r,M,-1);return}a(r,N)},"viii");this.Ma[g]=n;this.handleError(qb(this.db,g,k.length,1,0,n,0,0,0));return this};e.prototype.create_aggregate=function(g,k){var n=k.init||function(){return null},r=k.finalize||function(K){return K},w=k.step;if(!w)throw"An aggregate function must have a step function in "+g;var A={};Object.hasOwnProperty.call(this.Ma,g)&&(wa(this.Ma[g]),delete this.Ma[g]);k=g+"__finalize";Object.hasOwnProperty.call(this.Ma,k)&&(wa(this.Ma[k]),delete this.Ma[k]);var N=Aa(function(K,
O,Ra){var Y=rb(K,1);Object.hasOwnProperty.call(A,Y)||(A[Y]=n());O=b(O,Ra);O=[A[Y]].concat(O);try{A[Y]=w.apply(null,O)}catch(Gc){delete A[Y],xa(K,Gc,-1)}},"viii"),M=Aa(function(K){var O=rb(K,1);try{var Ra=r(A[O])}catch(Y){delete A[O];xa(K,Y,-1);return}a(K,Ra);delete A[O]},"vi");this.Ma[g]=N;this.Ma[k]=M;this.handleError(qb(this.db,g,w.length-1,1,0,0,N,M,0));return this};f.Database=e};var Ba=Object.assign({},f),Ca="./this.program",B="",Da,Ea;
if(ca){var fs=require("fs"),Fa=require("path");B=__dirname+"/";Ea=a=>{a=Ga(a)?new URL(a):Fa.normalize(a);return fs.readFileSync(a)};Da=a=>{a=Ga(a)?new URL(a):Fa.normalize(a);return new Promise((b,c)=>{fs.readFile(a,void 0,(d,e)=>{d?c(d):b(e.buffer)})})};!f.thisProgram&&1<process.argv.length&&(Ca=process.argv[1].replace(/\\/g,"/"));process.argv.slice(2);"undefined"!=typeof module&&(module.exports=f)}else if(aa||ba)ba?B=self.location.href:"undefined"!=typeof document&&document.currentScript&&(B=document.currentScript.src),
B=B.startsWith("blob:")?"":B.substr(0,B.replace(/[?#].*/,"").lastIndexOf("/")+1),ba&&(Ea=a=>{var b=new XMLHttpRequest;b.open("GET",a,!1);b.responseType="arraybuffer";b.send(null);return new Uint8Array(b.response)}),Da=a=>Ga(a)?new Promise((b,c)=>{var d=new XMLHttpRequest;d.open("GET",a,!0);d.responseType="arraybuffer";d.onload=()=>{(200==d.status||0==d.status&&d.response)&&c(d.response);b(d.status)};d.onerror=b;d.send(null)}):fetch(a,{credentials:"same-origin"}).then(b=>b.ok?b.arrayBuffer():Promise.reject(Error(b.status+
" : "+b.url)));var Ha=f.print||console.log.bind(console),C=f.printErr||console.error.bind(console);Object.assign(f,Ba);Ba=null;f.thisProgram&&(Ca=f.thisProgram);var Ia;f.wasmBinary&&(Ia=f.wasmBinary);function Ja(a){this.exports=(
// EMSCRIPTEN_START_ASM
function instantiate(Ra){function e(f){f.grow=function(b){var a=this.length;this.length=this.length+b;return a};f.set=function(c,d){this[c]=d};f.get=function(c){return this[c]};return f}var g;var h=new Uint8Array(123);for(var c=25;c>=0;--c){h[48+c]=52+c;h[65+c]=c;h[97+c]=26+c}h[43]=62;h[47]=63;function n(o,p,q){var i,j,c=0,k=p,l=q.length,m=p+(l*3>>2)-(q[l-2]=="=")-(q[l-1]=="=");for(;c<l;c+=4){i=h[q.charCodeAt(c+1)];j=h[q.charCodeAt(c+2)];o[k++]=h[q.charCodeAt(c)]<<2|i>>4;if(k<m)o[k++]=i<<4|j>>2;if(k<m)o[k++]=j<<6|h[q.charCodeAt(c+3)]}}function r(s){n(g,1024,"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");n(g,30752,"ZXhwYW5kIDMyLWJ5dGUgawABAgMEBQYHCAkKCwwNDg8QERITFBUWFxgZGhscHR4fICEiIyQlJicoKSorLC0uLzAxMjM0NTY3ODk6Ozw9Pj9AYWJjZGVmZ2hpamtsbW5vcHFyc3R1dnd4eXpbXF1eX2BhYmNkZWZnaGlqa2xtbm9wcXJzdHV2d3h5ent8fX5/gIGCg4SFhoeIiYqLjI2Oj5CRkpOUlZaXmJmam5ydnp+goaKjpKWmp6ipqqusra6vsLGys7S1tre4ubq7vL2+v8DBwsPExcbHyMnKy8zNzs/Q0dLT1NXW19jZ2tvc3d7f4OHi4+Tl5ufo6err7O3u7/Dx8vP09fb3+Pn6+/z9/v8BAAABAQAAAQABAAEBAAEAAAEAAIQAAACFAAAAhgAAAAQFAwUBBQEFAgUCBQEFAQUEBQMFAQUBBQIFAgUBBQEFAgUCBQIFAgUCBQIFAgUCBQQFAwUCBQIFAgUCBQIFAgWpAAAAcAAAAB8ABQFeAAABVAEAAEYAAAAqP1sAJV8AAQ==");n(g,31161,"AQEBAQE=");n(g,31184,"AQCAAEAAAIAAAAAAAAAAAAwMDAwMDAwMDAwAAAAAAAAACgoKCgoKAgICAgICAgICAgICAgICAgICAgKAAAAAQIAqKioqKioiIiIiIiIiIiIiIiIiIiIiIiIiIgAAAAAAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBSRUlOREVYRURFU0NBUEVBQ0hFQ0tFWUJFRk9SRUlHTk9SRUdFWFBMQUlOU1RFQUREQVRBQkFTRUxFQ1RBQkxFRlRIRU5ERUZFUlJBQkxFTFNFWENMVURFTEVURU1QT1JBUllJU05VTExTQVZFUE9JTlRFUlNFQ1RJRVNOT1ROVUxMSUtFWENFUFRSQU5TQUNUSU9OQVRVUkFMVEVSQUlTRVhDTFVTSVZFWElTVFNDT05TVFJBSU5UT0ZGU0VUUklHR0VSQU5HRU5FUkFURURFVEFDSEFWSU5HTE9CRUdJTk5FUkVGRVJFTkNFU1VOSVFVRVJZV0lUSE9VVEVSRUxFQVNFQVRUQUNIQkVUV0VFTk9USElOR1JPVVBTQ0FTQ0FERUZBVUxUQ0FTRUNPTExBVEVDUkVBVEVDVVJSRU5UX0RBVEVJTU1FRElBVEVKT0lOU0VSVE1BVENIUExBTkFMWVpFUFJBR01BVEVSSUFMSVpFREVGRVJSRURJU1RJTkNUVVBEQVRFVkFMVUVTVklSVFVBTFdBWVNXSEVOV0hFUkVDVVJTSVZFQUJPUlRBRlRFUkVOQU1FQU5EUk9QQVJUSVRJT05BVVRPSU5DUkVNRU5UQ0FTVENPTFVNTkNPTU1JVENPTkZMSUNUQ1JPU1NDVVJSRU5UX1RJTUVTVEFNUFJFQ0VESU5HRkFJTEFTVEZJTFRFUkVQTEFDRUZJUlNURk9MTE9XSU5HRlJPTUZVTExJTUlUSUZPUkRFUkVTVFJJQ1RPVEhFUlNPVkVSRVRVUk5JTkdSSUdIVFJPTExCQUNLUk9XU1VOQk9VTkRFRFVOSU9OVVNJTkdWQUNVVU1WSUVXSU5ET1dCWUlOSVRJQUxMWVBSSU1BUlk=");n(g,32084,"AgACAAgACQAOABAAFAAXABkAGQAdACEAJAApAC4AMAA1ADYAOwA+AEEAQwBFAE4AUQBWAFoAWgBeAGMAZQBpAG8AdwB7AHsAewB+AIEAhACJAI4AkgCTAJgAnACgAKgArgC1ALgAuAC7AL0AwwDGAM4A0wDYANsA3gDiAOwA7wD0APQA+AD8AAMBCQEPARUBFQEbARwBIAEnASsBMgE4AUQBTQFPAVUBWgFcAWMBZwFyAXkBegGBAYcBjQGSAZgBnAGfAagBrQGxAbcBuQG8AcUBxwHJAdIB1gHcAeIB6gHvAe8B7wH/AQgCCwIPAhQCGwIgAikCLQIwAjUCNwI7AkMCSQJMAlUCWgJiAmICZgJvAnQCeQJ/AoIChQKIAooCjwKTAg==");n(g,32385,"BwcFBAYEBQMGBwMGBgcHAwgCBgUEBAMKBAcGCQQCBgUJCQQHAwIEBAYLBgIHBQUJBgoEBgIDBwUJBgYEBQUKBgUHBAUHBgcHBgUHAwcEBwYMCQQGBQQHBgwICAIGBgcGBAUJBQUGAwQJDQICBAYGCAURDAcJBAQGBwUJBAQFAgUIBgQJBQgEAwkFBQYEBgICCQMH");n(g,32544,"6gMAAABAAADrAwAAAAAEAPcDAAAAAACA7AMAAAAAQADtAwAAAAABAO4DAAAACAAA7wMAAAAAgADwAwAAAAAAAfEDAAAAAAAC8gMAAAAAABDzAwAAAQAACPQDAAAAAAAE9gMAAAAAACD1AwAAAAAAQPgDAAACAAAA+QMAAIAAAAD6AwAAAAQAAPsDAAAAEAAAAMqaOwDKmjvQBwAA6AMAAPQBAACAsuYOfwAAAAoAAABQwwAA/n8AAOgDAAAAAAAAAwAAAIcAAACIAAAAiQAAAIoAAACLAAAAjAAAAI0AAACOAAAAjwAAAJAAAACRAAAAkgAAAJMAAACUAAAAlQAAAJYAAACXAAAAmAAAAAMAAACvAAAAiAAAAIkAAACKAAAAiwAAAIwAAACwAAAAsQAAALIAAACQAAAAkQAAAJIAAAAAAAAAlAAAAJUAAACWAAAAlwAAAJgAAAABAAAAswAAAIgAAACJAAAAigAAAIsAAACMAAAAtAAAALUAAAC2AAAAkAAAAJEAAACSAAAAAAAAAJQAAACVAAAAlgAAAJcAAACYAAAAAwAAALcAAAC4AAAAuQAAALoAAAC7AAAAvAAAAL0AAAC+AAAAAAAAAL8AAAAAAAAAwA==");n(g,33032,"wQAAAMI=");n(g,33048,"AQAAAM4AAADPAAAA0AAAANEAAADSAAAA0w==");n(g,33124,"2dUF+SChY9c=");n(g,33168,"U1FMaXRlIGZvcm1hdCAzAAABAgMEBQYHCAkKCwwNDg8QERITFBUWFxgZGhscHR4fAAECAwQFBgcICQoLDA0ODwABAgMEBQYHAAECAwABAABCSU5BUlk=");n(g,33264,"zlQAAPhZAABFTwAAdE8AAJ0KAAA3DAAA3CkAAJIKAABWOQAAiiwAAF0kAABkMwAAMgwAAAknAAAzRgAA/TUAAIU6AADkCwAAeyYAAJ85AACRMQAANwoAAN01AAA5CgAAzAYAAD9JAAA4TwAAUE8AAHZJAAAoLAAA5DUAAIgNAAAyOgAANToAAAU7AAAFDwAA0QkAAJ8kAADgCQAA5gkAAEU6AACsCAAAQAcAALgIAAAyTwAAcEkAADlJAABRJgAAVzoAAEpPAABlQAAAtAkAABwtAABhJwAAmC0AAIctAADeOQAAZCYAAEUOAADhOQAAQg4AAOQ5AABgJgAA/RIAAEonAABUJwAAhiwAALcIAABeJAAAQ0UAANQoAADGJwAACzYAAKotAAAcDAAApCUAAF1bAADXMAAAuicAALAtAACPLQAAUkYAADY4AAA9MgAA4gQAAOEEAADZBAAABC8AAMIGAABYJgAAviwAACIEAADWCQAA6CkAAKI1AAClMgAAny0AANsMAADKKwAADC8AACYEAAAGOgAAagoAAIA4AAB2OAAAJgYAAFQ6AABOJgAA0QwAAMEMAABbQAAA7A0AAPAEAABiOQAAxCUAADsOAABwQAAAFDMAADAKAABuJgAA4gUAAOJZAAALLgAAMiwAAL8JAACoJwAArzQAADk9AABWLAAAkAwAAII5AAD8OgAAHQoAAMYtAAA5MwAAZQoAAJw1AACkRgAAnEYAAAk7AADOBgAATDoAAA0KAAAXCgAANjMAAHIuAADzOgAAZy4AAOgEAABIJgAAECQAAB05AACiRQAAA0cAALEUAAA/OAAAGAYAAEwuAADLJAAAHS8AAEtAAAAkLQAAHCQAADgGAACEDAAAljQAAKkmAAB8XAAA+TIAABkuAACBNQAAoS4AAIYuAACsLgAABSwAAFIzAADnBAAAPSwAABYvAABfLAAAySsAAGs2AAA9CgAArgsAAMg1AAC9NQAAsjUAAFVAAACkOQAAAwsAAAkxAAB2JgAAESwAACE3");n(g,34048,"Xk4AAAJPAADBTgAAYEgAAAAAAAABAgACAgABAgEBAQIBAhABAQEBAQECAQEQEBAAAgI=");n(g,34113,"AQIDBAYICAAAAAAAAAEBAgIDAwQEBQUGBgcHCAgJCQoKCwsMDA0NDg4PDxAQERESEhMTFBQVFRYWFxcYGBkZGhobGxwcHR0eHh8fICAhISIiIyMkJCUlJiYnJygoKSkqKisrLCwtLS4uLy8wMDExMjIzMzQ0NTU2Njc3ODg5ORBAAkA=");n(g,34256,"NUkAALxOAAAZSQAATFEAAKxOAAAAAQIDBAYIAAAAAABSNgAA+CoAAGgrAAAhACAAHgAcABo=");n(g,34320,"LzMAABUJAABzMQAAhDMAAKsEAADtLQAAAQEDAAUABgAI");n(g,34376,"AQ==");n(g,34401,"BQwPEhUYGyMmLTUAAAAAYQBkAGQAcgAAAG8AcABjAG8AZABlAAAAcAAxAAAAcAAyAAAAcAAzAAAAcAA0AAAAcAA1AAAAYwBvAG0AbQBlAG4AdAAAAGkAZAAAAHAAYQByAGUAbgB0AAAAbgBvAHQAdQBzAGUAZAAAAGQAZQB0AGEAaQBs");n(g,34544,"NCYAAEc5AACCXAAA1FsAAMVbAABEWwAAz1oAAFELAABxOwAAFwsAAPE8AADTLQAAHRwcHBwcHBwcBwccBwccHBwcHBwcHBwcHBwcHBwcHBwHDwgFBBYYCBESFRQXCxoQAwMDAwMDAwMDAwUTDA4NBgUBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQACAgkcHBwCCAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAICHAocGRwbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxsbGxseGxsbGxsbGxsbGxsbGxsbG1RchlJpHQAAXgBVSAA1I1YPACphNlmHEwAAjAAogQAWawAJAAB7UABOBgBBZ5MAiHMAADAAWhgAEQAbRhcaBTyObnoASVtHkT14SgAxAAspAHEAAABtCm90fQ4yfABkABJ5kDiCi1hTJR5+AABsM4OAACIAAIQAYiYnABQtdV0AAGJ0oSc6KXxDIYQ+Py8CQaMmGIoQdp8Lg6BbgBUVKzJSDYleMxNCeS+IBhxzdqJHCRR3l0VEgk1ZXyiTLwV2fXsDGlF2DiAwmFySIx94nXERZAiPfy4EHkZhB4wtgYtQYJ6VSBsdYyyFV34PMSQ8CiV2ZGRVWCpUpklTVo52lBKRSl2llnYMTEtahpBOT6Q9IkCHeg==");n(g,35141,"BAArAABqcgAAAAIAAI8AAAANAAAAAI0AAHc0AACJDAAAPgCKAIUAACQAABxNAAAAADsALw==");n(g,35203,"RQAAAAAAkgMAOgABSwAAAB8AAAAAAH8AaABAQj8AAAAAAC4AEAg=");n(g,35251,"UWUAcBUHQwBPYHYAAEQAAGMsADcATABfICE5GQBmAABX");n(g,35300,"EABBAAEBAQEDAwEBAwMBEgFJSUlJAUlJSUlJSUEBQUFBAUFBQUFBJiZBIwsBAQMDCwsLCwsLAQMDAwFBAQAAAgIIABAQEAAQABAQAAAQEAAAAAICAgAAEh4gQAAAABAQAEAmJiYmJiYmJiYmQAASQEAQQAAAAEAAQEAQEAAAAAAAQABQAEAEBABAUEAQAAAQAAAAAAAQAAAGEAAEGg==");n(g,35469,"QBBQQAAQEAISEg==");n(g,35496,"1AAAANUAAADWAAAAAAAAANcAAADYAAAA2QAAANoAAADbAAAA3AAAAN0=");n(g,35600,"QgwAAAEQ");n(g,35616,"VDsAAAIUAAAIAAAAAAAAAGcsAAADlQ==");n(g,35648,"8AUAAAQUAAAAgAAAAAAAAM4IAAAFEDgBAAAAAAAAAADvMQAABpU=");n(g,35696,"ui0AAAeU");n(g,35712,"YjgAAAgC");n(g,35728,"5C4AAAQUAAAAACAAAAAAADZEAAAEFAAAEAAAAAAAAABHCQAACRAmAgAAAAAAAAAAAxMAAAoQ");n(g,35792,"ERcAAAQUAAAAAAAAAQAAAK4qAAACGAAADwAAAAAAAABWCQAADBAvAwAAAAAAAAAA5zEAAA2VNwEAAAAAAAAAAEgOAAAEFAAAAAAIAAAAAACaFAAABBQAAAABAAAAAAAA3jAAAA4U");n(g,35904,"xi4AAA9xKwQAAAAAAAAAAB0JAAAQYQAIAAAAAAAAAABODgAABBQAAABAAAAAAAAARwoAAAIY");n(g,35968,"WxUAAAQUAAAEAAAAAAAAAEFEAAAEFAAACAAAAAAAAAA5CQAAERAbBgAAAAAAAAAAYQwAABIQ");n(g,36032,"Dw8AAAQUAAAAAgAAAAAAAHMsAAATAw==");n(g,36064,"kicAABRhFQMAAAAAAAAAAC4JAAAVYSYFAAAAAAAAAABwJwAAFGEVBgEAAAAAAAAAti4AABZx");n(g,36128,"LTkAABeR");n(g,36144,"cQwAABiQ");n(g,36160,"KzcAAAQUAAAAAAAEAAAAADo5AAAakA==");n(g,36192,"VgoAABuR");n(g,36208,"3TEAABw=");n(g,36224,"ZAkAAB0QCQEAAAAAAAAAABsyAAAeIQ==");n(g,36256,"WgoAABuR");n(g,36272,"BDIAAB+U");n(g,36288,"ggkAACAQCQEAAAAAAAAAAPkEAAAEFAAAAAAQAAAAAADYLgAAFnE=");n(g,36336,"IzwAAAQUAAAAAAAABAAAAIARAAAEFAAAACAAAAAAAABsEAAABBQAAAAQAAAAAAAAuyoAAAIUAAABAAAAAAAAACgzAAAhEA==");n(g,36416,"SBUAAAQUAABAAAAAAAAAAHAEAAAiAg==");n(g,36448,"UQwAACMQ");n(g,36464,"lw4AACSV");n(g,36480,"nScAACVhCAYAAAAAAAAAAHcJAAAmIQ8GAAAAAAAAAAB8JwAAJWEIBwEAAAAAAAAATDUAACcU");n(g,36544,"NAQAACgE");n(g,36560,"XxcAACkQ");n(g,36576,"5UYAAAQUAACAAAAAAAAAAJIqAAACFAAABgAAAAAAAABwCgAAKg==");n(g,36624,"gwoAACsBMgMAAAAAAAAAANVGAAAEFAAAAQAACAAAAABxOwAAVCYAAOw3AACsLAAAECcAAFozAAAeMwAAKzAAAFA7AACyNgAA2DUAAFUtAACzMgAAUS4AAEMsAAD8RgAAsjYAANg1AABQLQAAoiIAAIENAABqJwAAUDsAALI2AAAtRAAAtS0AAD4FAACyNgAA0SsAANg1AACORQAAiDAAAMMUAADpLQAAIgYAAMovAADMDAAAvhQAAFQmAACyNgAArDIAAP4rAAA/LgAA7DcAAO06AAAXCwAAKjsAAFQmAACyNgAAEjcAAC8EAACUMAAAhjwAAEM1AACQDgAA7zEAANMIAAADAgE=");n(g,36900,"OwA7ADsAOwAAADsAOwA7AAAAOwA7ADsAOwAAAAAAAAA7AAAAAAA7");n(g,36948,"OwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7AAAAAAAAADsAOw==");n(g,37016,"OwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7ADsAOwA7");n(g,37280,"//3//QD////+/v79+/r/AP3/APv+AP3+//4A/Pr+AAD+/fz8/P39+/78/P/+/fwA/wD+/v39/f7+///+/f4A/v4A//75+/v2AAD9AP7///z+APf8//38//3//v/39vz7//8AAPv9+/4AAP7+APv6+Pr6AP7//f/9+/3//v38/vwAAP3+AP37/f//AP7+AAD9AP4A/vz8+gD+AP7+/Pf7+f37+fgA/vT3+/j+/v8A/f3//f/9+//////9+vv4/Pr3+//7/f39/f39/f3+/fv+/f38+vv+/v79//77//77/fv7/Pv7/P4AAAD9/wD99P8AAP37/QD+/P79/gD9+/r7+v7++/X//gD///0A/v3+/f3+9/j6/fz6/////Pr9AP7//f/9+vn6//j//PgA//3//v3//v36//39+/v6/Pv+AP36///+//7+/gD+/v7//v7///z++//+///+/QD//v8A/v/8/v////////4A/vz+/v3/AP/////+//8A/////////////wD9/wD/AAD///3+APz+AP//");n(g,37696,"cAbFBfgEQgFCAQEAJwXGBdMFLQctBy0H1wEAAAAA1gBFBC0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQcPAQ8BwwTDBNgAWAABAAEAAQABAAEAKABvAAIBaQHVAQACRwJuArUC3AIjA0oDkQMxBEUERQRFBEUERQRFBEUERQRFBEUERQRFBEUERQRFBEUERQRFBFkERQTABL0DvQNjBn4G8QYtBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctBy0HLQctB4kAtQC1ALUAtQC1ALUAtQBeAK4BQgBBAHAAbgEVAhUC5ALpBBUCFQJPAE8AFQKcAZwBnAFNAJwBewBxAHEAcQAWABYANAg0CEgBSAFIAe8A1AHUAdQB1AH3A/cDmQFuAaME0AQVAhUCFQIVAhUCFQIVAhUCFQIVAhUCFQIVAhUCFQIVAhUCFQIVAhUCyQNtAm0CFQKCAhQDFANtBG0ENgM2A0MAqQQ0CDQINAg0CDQINAg0CBsFugO6A0kC2AGAAoMBtwIaAh0CvAIVAhUCFQIVAhUCFQIVAhUCFQIVAt4AFQIVAhUCFQIVAhUCFQIVAhUCFQIVAhUCvQS9BL0EFQIVAhUCNQIVAhUCFQKUA3sEFQIVAggFFQIVAhUCFQIVAhUCFQIVAn8CAAXRAGkEaQRpBGkERALRANEAuQQAA5UDiQIjBTYFlQE2BWcF+QAjBSMF+QAjBZUBZwWhBdAB3QSJBYkFiQUrBSsFKwUrBbgAuAA3BcQFWAPKBdAG0AaBBoEG7QbtBoEGhQaHBgoH9gYRBxEHEQcRB4EGGQeaBocGhwaaBgoH9gaaBvYGmgaBBhkHnQb/BoEGGQcoB4EGGQeBBhkHKAfYBtgG2AYNBzoHOgcoB9gG1QbYBg0H2AbYBrEGQgfvBu8GKAeBBgcHBwcfBx8H4QblBmIHgQbdBuEG6wbuBpoGZgd5B3kHiQeJB4kHNAg0CDQINAg0CDQINAg0CDQINAg0CDQINAg0CDQIzwDEBEsBbALHAyYDMgTbBZgFtwXHBYsFjgUVBugFPgY/BmwGbQZ2BnwGEwbhBZQGtgWGBhsGUwY5BowGjwZNBpAGEgYWBpkGnAZFBjUGowenB5UHCweeB58HmQeaBycHHAcyB5wHnAegBykHogcqB6kHugcuBzsHnAc8B4IHmwecBywHjAePB5AHlgdKB1kHrAdDB84HzAe8B2AHMweRB70HkweNB7AHTQdoB8QHyQfLB1wHYwfNB6EHzwfQB8oH0QelB64H0geLB8YH1geqB9MH1wfUB1oH2gfbB9wH2AfdB98HmAdqB+MH5AeIB94H5wdvB+YH4AfhB+IH5QetB7YHsgfoB7sHrwfpB/IH9Af1B/YH9wfsB4MHhAf8B+YH/gf/BwAIAQgCCAMIBggOCAcICAgJCAoIDAgNCAsIpAeSB50HpgcPCBAIFgglCCgI");n(g,38864,"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");n(g,48848,"vQC9ALwAvgC/AL8AvwC/AL4AvgC+AL4AvgDDAMUAxwDHAMYAxgDEAMQAywDLAM0AzQDOANAA0ADQANEA1QDWANcA1wDXANcA1wDXANcA1wDXANcA1wDXANcA4ADgANwA3ADeAN4A4QDhAOEA4QDiAOIA4gDiAOIA3wDfAOMA4wDjAMoA5QDmAOYA5gDmAOYA6QDaANoA6gDqAOsA6wC+AO0A7QC+AL4AvgDMAMwAzADvAPIA8gDyAPAA8AD8APwA8wDzAPMA/gD0APQA9AD/AP8A9QD1AAEBAQEAAQABAAEAAQAByADIAO4A7gAGAQYBBgEGAQIBAgECAQIBAwEDAQMBCAEEAQQB+QD5AOcA5wDbANsA2wAJAQkBCQH3APcA+AD4APoA+gD6APoAvgD2APYACwELAQsBCwG+AAwBDAEMAQwBvgC+AA8BDwEPAQ8BDwEPARABDQENAQ4BDgEHAQcB2QDZANkA2QDYANgA2ADZANkA2QDZANkA2QDZANkA2QDYANkA2QDZANkA2QDZANkA2QDZABIB2QDZANkA2QDZANkA2QDZANkA2QDZANkAEwETAdkAFAEUAdkA2QDZANkA2QDZABcBFwEYARgBFgEFAf0A/QAVARUBvgAZARkB3QDdAOgA6AAaARoBvgC+AL4AGwEbAb4AvgC+AL4AvgDTANQAvgAdAR8BHwEfASABIAEgASIBIgEeAR4BJAElASUBIwEjASMBIwHZANkA7ADsAOwAvgC+AL4AJwEnAb4AvgC+AL4AvgC+AL4AKAG+AL4AvgAqASwBLQEtAS4BCgEKATEBMQExATAB8QDxADIBMwE0ATQBNAE0ATQBNQE1ATUBOQE7ATsBPAE8AToBOgE9AT0BPgE+AT4B+wARAREBEQE4ATgBNwG5ALoAugC7ALsAuwDAAMAAwADCAMIAvgDLAMkAyQDBAMEA0ADRANIA0gDPAM8A1wDXANcAygDkAOQA5QDpAOsA7wDwAP4A/wAIARAB2QASARYBBQEcARwBHAEcARwB0wAhASEBJAElASYBJgEpASkBKwErASwBLwEvAS8BCgEyATQBAAAAAAAASwAAACQACgBeAAAANAAJAIcAAABeAAEAVgAAAFAAAAAJAAsAJwACAEcAAAB6AAAAQgBDAEQARQBGAAAAAAAAAE1GAACnCAAAkkUAAJwlAABHLgAAlSwAAN9NAAAXTwAA1E4AAAIECAYGAAAAAAByb3dfbnVtYmVyAGRlbnNlX3JhbmsAcmFuawBwZXJjZW50X3JhbmsAY3VtZV9kaXN0AG50aWxlAGxlYWQAbGFnAABuwgAATAAAAFoAAABVAAAAecIAAFkAAABaAAAAVQAAAITCAABZAAAAWgAAAFUAAACJwgAAXAAAAFUAAABaAAAAlsIAAFwAAABWAAAAWgAAAKDCAABMAAAAVQAAAFoAAACmwgAATAAAAFoAAABaAAAAq8IAAEwAAABaAAAAVQAAAENBRERFQgAAaTkAAAgAAAA+RwAAfU8AAINPAAAAAAAAXncAABhJAAAYTgAANEkAALtOAAAYTgAAAwQDBwQEAAAKCgkJCAgHBwcGBgYFBQUEBAQEAwMDAwMDAgICAgICAm50aF92YWx1ZQBmaXJzdF92YWx1ZQA5NwAAAAAAAAAAKzAAAEAAAAA5RgAAQgAAAHE4AABBAAAAZyYAAEMAAAAYFhUXAAAkIBgVFxYtKSgqJyYkIA==");n(g,50160,"PCUAAHElAADXJAAAziUAAAIm");n(g,50192,"OQAAADkAAAA2AAAAOQAAADk=");n(g,50224,"bmF0dXJhbGVmdG91dGVyaWdodGZ1bGxpbm5lcmNyb3Nz");n(g,50273,"BwQGBCgKBSAOBTATBDgXBQEcBQMAAABbOgAAAwAAANYGAAAD");n(g,50320,"MwACAH8AAABhAAIAgAAAAHo=");n(g,50352,"AgAAAGMAAQM7AQgARwACAGsBAgE7AQgARwABALsAAABUAQE=");n(g,50400,"AgABAGMAAQQQAQAARgACAGQABwAxRgAAdwgAAFEuAAAfGBERExQ=");n(g,50448,"VgEAADwBBAB1AAMAVAMBAEYAAAB1AAMACQADAAAAAADvWQAAAQAAAPRZAAABAAAAWTgAAAIAAADVOQAAAwAAAFE4AAACAAAAzTkAAAMAAADIWgAAAAAAAMJa");n(g,50552,"AgABAGQAAAACAAAAYwABAFQBAQAAAAAAb25vZmZhbHNleWVzdHJ1ZXh0cmFmdWxsAAABAgQJDA8UAgIDBQMEBQQBAAAAAQEDAg==");n(g,50644,"6lkAAEk4AADFOQAAJV8AAAMAAAAB");n(g,50676,"3g==");n(g,50692,"XjAAAAAAAAB4AAAApT0AAAAAAgBAMwAAAAAE");n(g,50736,"ZycAAAEAAABtBgAAAgAAACVEAAAGAAAAqwQAAIA=");n(g,50776,"AQAAAAE=");n(g,50792,"3w==");n(g,50808,"bDAAAAAAAABvXAAACQ4AADJbAAAAAAAAi1sAAAAAAAAEAAAAAQ==");n(g,50856,"4A==");n(g,50872,"KAwAAAAAAAACAAAAAQ==");n(g,50896,"4Q==");n(g,50912,"zy8AAAAAAAABAAAAAQ==");n(g,50936,"4g==");n(g,50952,"Xw0AAAAAAACD/90CFQPxACUBhf8//0H/Sf9F/6YA7gCFADH/Of/1/lD/+v/MAOkBQAJWAlH/rgJcA2cC1QL2AwoDDQNZA2gCdwNXAPAAQP+YAXICHANLA1YD7APx/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/vH+8f7x/lAAUwA5AXYDeAOWA6oD/QMKBAwEdQSHBIsEjgSQBJIEmASaBJwEoASsBK4EtQS/BMkEywTUBOQE5gTwBBcFHQUgBSoFLQUwBTkFPAU/BUkFWwVdBWgFagWDBYUFjAWQBZIFsgW+BcEF8f7x/vH+8f7x/vH+8f7x/vH+8f7x/ooAywGMAWL/1gEuASz/CQLJAD3/pP8vAnYCeAJ2AvH+eAKFAz8AlwGeAvH+8f7x/vH+oQChAKEA+wBPAU8D0wNJBBkCTAJqAnQCsAKwAlr/X/+iAhMDGgMfA1QD5AOG/0UDiP/6AwsEnwEXBOkDvgM6BJABSwQLA3EEdgQHATsEeQR+BBEEcwTFAxoEagFRA/ACdQKjAooElQRCBKsEPv84ALkAef/oAAoCMAI7AlkCaQKdAqsCxwJSA30D6AMQBBkEOQQ/BE0EiAFaBGMEgwSJBJcE9wQNBRMFMgU7BT4FQwVRAgIFBgVGBU8FWAUiBcgFywXjBT0EOgX2BfcFzwX7BTAC/AX+Bf8FAgYDBgUGqAWqBdgFzAXNBdEF0gUiBdgF2AXgBQAGHAarBc4F1AXlBdUFuQXrBdYF1wXtBdwF7wXCBQ4GBwYMBhQGHQYeBu4F8wUGBggG9QUJBukFEQYQBkQG5AXmBUgGSQbwBfgFTAYEBhcGGAY4BjcGOwY8Bj0GXQZmBjoGIQYiBkAGIAZKBkEGSwZDBmsGcwYaBiMGdwZ7BmgGfwaCBoAGgwZpBnIGdAZ1Bm8GeAZ5BnoGhAaIBpEGcQaSBpMGJQYuBkcGTwaVBqYGMgYzBmoGbgaJBosGZAayBmUGjQaKBo4Gnga3BsYGxwbSBtMG1gZhBn0GlgbKBsAGxQbIBskGzAa+BsIGzgbPBtQG2QYAAAEAAABFdwAAnCUAAEcuAACnCAAATUYAAGkt");n(g,51824,"MDEyMzQ1Njc4OUFCQ0RFRmxhc3RfdmFsdWUAAAwADgAYAB8AOwB4OQAAAAAAAAAABnNlY29uZAAkINNXAACAPwZtaW51dGUA2TPhVAAAcEIEaG91cgAAALA58FEAAGFFA2RheQAAAABa/KNKAMCoRwVtb250aAAAgGgsSAA0HkoEeWVhcgAAAADkZUbAmfBLCQoNIA==");n(g,52016,"AQEAAQEBAQABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQFpSQMFBwAAAF8xAADDWQAAaUkIBQcAAAAQBAAAw1kAAG5OAwAEAAAAnU0AAGktAABxUQQABAAAAJxNAABpLQAAc1MEAAQAAACXTQAAaS0=");n(g,52329,"AQEAAAE=");n(g,52352,"AQ==");n(g,52576,"Cww=");n(g,52600,"YnRuAGZy");n(g,52624,"aS0AAKAyAAC1NAAAnCUAAJwlAABHLgAARy4AAKcIAACnCAAApwgAAKcIAAB2BQAAyg0AAF53AABedwAAXncAAF53AABOAQAATwEAAFABAABRAQAAUgEAAFMBAABUAQAAAAAAAAEAAAAAAAAAVQEAAFYBAABXAQAAWAEAAFkBAABaAQAAWwEAAFwBAABdAQAAXgEAAF8B");n(g,52784,"diMAAIMjAAAAAAAAGD8AAF48AADXPgAA6j4AAH4EAAC7NAAAejwAAJMjAAA4PgAA9CkAAG4tAAD6NgAAPy0AAAAAAAAGQAAA5zAAAHo+AAAIMAAAlzMAAIw+AAADPwAAAAAAAJE4AAA1NQAAqzgAAMA4AAABAgUKDxQZGRkyMmQAAQMIEiE1TmeAsuRgAQAAYQEAAGIBAAAEAAAAYwEAAGQBAABlAQAAZgEAAGcBAABoAQAAaQEAAGoBAABrAQAAbAEAAG0BAABuAQAAbwEAAHABAABxAQAAcgEAAHMBAAB0AQAAdQEAAHYBAAB3AQAAeAEAAHkBAAB6AQAAAAAAAHsBAAB8AQAAfQEAAH4BAAB/AQ==");n(g,53072,"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");n(g,56032,"dFQAAPJlAABcbAAAkWwAAK5sAAAdbgAAeGwAAN9RAACiXQAAvGYAAPdmAAA2ZgAAoU8AABFQAAAmVAAAjVIAAPtTAADPUgAAKmIAAKBUAACMZgAA91EAACZSAABmZgAAXncAAF53AABWUgAAyWwAACNdAAApawAAxFMAAKBRAABZUwAAClMAAHBOAAACUQAABm0AAJhQAABXUQAAzFwAAAAAAACKAQAAiwEAAIwBAACNAQAAjgE=");n(g,56224,"jwEAAJABAACRAQAAkgEAAJMB");n(g,56256,"AQEBAQEBAQEBAQAAAAAAAAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQAAAAABAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAAAAAAAAQEBAAEBAQABAQEBAQABAQEBAQABAQECAQAAAAAAAIgnAAAJAAAAqgUAAAYAAACaEAAACAAAAJgQAAAKAAAAviUAAAUAAAAPCwAABwAAAEM7AAAKAAAAkzsAAAo=");n(g,56468,"AQ==");n(g,56480,"AQEBAQEBAQEBAQAAAAAAAAABAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQAAAAABAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAAAAAAD7SwAAAgAEAHlPAAADAQMAMEkAAAMBAgAgTAAABAABAFcNAACUAQAAZBAAAJUBAAAbMgAAlgEAAIgnAACXAQAADwsAANUxAAC0IwAA2A8AABEOAAAAAAAAmAEAAJgBAACZAQAAmgEAAJoBAACbAQAAnAEAAJ0BAACeAQAAnwEAAKABAAChAQ==");n(g,56752,"ejAAALAbAQATOQAAFBwBAAAAAgADAAUABgAHAAgACQCZXAAA3GAAAAVOAADNXwAAR1sAAAVdAAA4XwAAfVoAAGxfAADESgAAZFoAAPZbAADmXwAADFwAAA9fAACHTwAA90oAAMhbAADfSgAA8E4AAHRbAACLXwAAvV8AAKBfAAA4XAAABmAAAE9aAABsYAAAOGAAAChfAAD5OAAArloAAIJgAAAaYAAAlFoAAFZgAAD6XgAAUkkAALpNAAA+UQAArVwAAExfAACxTgAAKUkAAJRJAACLSQAAZ04AAEZJAABsTw==");n(g,56992,"+BIAAAEAAQCxAQAA2SsAAAEAAQCyAQAASiwAAAEAAQCzAQAA11sAAAIAAQC0AQAA3FsAAAIAAQC0AQAA3y8AAAEAAQC1AQAA5S8AAAEAAQC2AQAA6y8AAAEAAQC3AQAAizkAAAIAAQC4AQAALRcAAAEAAQC5AQAAZBQAAAEAAQC6AQAA+RIAAAEAAQC7AQAA2isAAAEAAQC8AQAASywAAAEAAQC9AQAALAoAAAEAAQC+AQAA4C8AAAEAAQC/AQAA5i8AAAEAAQDAAQAA7C8AAAEAAQDBAQAAiy8AAAEAAQDCAQAAaiYAAAEAAQDDAQAAlDAAAAEAAQDEAQAAhV8AAAEAAQDFAQAA3CMAAAIAAQDGAQAAGSwAAAEAAQDHAQAA2wkAAAEAAQDIAQAAiDUAAAEAAQDJAQAAzi0AAAEAAQDKAQAAoiMAAAEAAQDLAQAAVS8AAAAAAQHMAQAAjTMAAAIAAQDNAQAA2AUAAAIAAQDOAQAA2AUAAAMAAQDOAQAAriIAAAIAAQDPAQAApSIAAAIAAQDQAQAAoTQAAAEAAQDRAQAAmCQAAAEAAQDSAQAA2i0AAAIAAQDTAQAAOSYAAAIAAQDUAQAAsUUAAAIAAQDVAQAAUyQAAAIAAQDWAQAARQcAAAEAAADXAQAA2AEAAJY5AAABAAAA1wEAANkBAABCOQAAAQAAANoBAADbAQAATywAAAEAAADaAQAA3AEAAL42AAABAAAA2gEAAN0BAADNNgAAAQAAANoBAADeAQ==");n(g,57634,"AQIDAAECAAACAgQFBQABAgYCAwABAAIAAgAAAAAAAAABAgMAAQIAAAICBAUFAAECBgIDAAEAAgAC");n(g,57824,"BAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAgICAgICAgICAgICAgICAgMDAwMDAwMDBAQEBAQEBAQAAAAAgDAAAIAgDgCAIMgDAAAAAID///8A+P//AAD//wAAAAAAAPA/AAAAAAAA+D8AAAAAAAAAAAbQz0Pr/Uw+");n(g,58027,"QAO44j/+gitlRxVnQAAAAAAAADhDAAD6/kIudr86O568mvcMvb39/////98/PFRVVVVVxT+RKxfPVVWlPxfQpGcREYE/AAAAAAAAyELvOfr+Qi7mPyTEgv+9v84/tfQM1whrrD/MUEbSq7KDP4Q6Tpvg11U/");n(g,58158,"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");n(g,62114,"pQJbAPABtQWMBSUBgwYdA5QE/wDHAzEDCwa8AY8BfwPKBCsA2gavAEIDTgPcAQ4EFQChBg0BlAILAjgGZAK8Av8CXQPnBAsHzwLLBe8F2wXhAh4GRQKFAIICbANvBPEA8wMYBdkA2gNMBlQCewGdA70EAABRABUCuwCzA20A/wGFBC8F+QQ4AGUBRgGfALcGqAFzAlMB");n(g,62312,"IQQAAAAAAAAAAC8C");n(g,62344,"NQRHBFYE");n(g,62366,"oAQ=");n(g,62386,"RgVgBW4FYQYAAM8BAAAAAAAAAADJBukG+QYeBzkHSQdeBw==");n(g,62432,"T7thBWes3T8YLURU+yHpP5v2gdILc+8/GC1EVPsh+T/iZS8ifyt6PAdcFDMmpoE8vcvweogHcDwHXBQzJqaRPBgtRFT7Iek/GC1EVPsh6b/SITN/fNkCQNIhM3982QLA");n(g,62543,"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");n(g,65347,"QPsh+T8AAAAALUR0PgAAAICYRvg8AAAAYFHMeDsAAACAgxvwOQAAAEAgJXo4AAAAgCKC4zYAAAAAHfNpNQL/AARkACAAAAT//xAAAQABAAEA//8B/wH//////wH/Af8B/wH/Af8B/wH/Af//////Cv8gAP//A/8B/wT/HgAAAQX//////2MAAAhjAOgDAgAAAP//////AAAAAf8B//////////////8=");n(g,65529,"BA==");n(g,65542,"Af8B//////8AASAABACAAAAI//8B/wH/////////Af8G/wf/CP8J//////+8ArwCAQD//wEAAQD//wAA//////////8=");n(g,65626,"FA==");n(g,65658,"//8BAAr///////////8B/wH/AAAAAAAAAf8B/wH/");n(g,65706,"Af8AAAAAAAAB/wH/AQAAAAEAAAAB//////8AAAAAAf///wAAAAD/////////////KAAK//////8BAAr/////AP//////////");n(g,65878,"Af8B////AQD//////////////////wr//////wz/Df8=");n(g,65920,"AQAAAAEAAAEAAQEA/v//fwAAAACwBAAAKAAAAAAAAQ==");n(g,66112,"FA==");n(g,66124,"+g==");n(g,66171,"QA==");n(g,66188,"/v//f////38=");n(g,66220,"BwAAAAMAAAA0AAAAAAIAAAAAAACOBQAARHkAAHgAAAB5AAAAegAAAHs=");n(g,66280,"fAAAAH0AAAB+AAAAfwAAAIAAAACBAAAAggAAAIMAAAADAAAANAAAAAACAAAAAAAA8zUAAEh5AAB4AAAAeQAAAHoAAAB7");n(g,66368,"fAAAAH0AAAB+AAAAfwAAAIAAAACBAAAAggAAAIMAAAADAAAANAAAAAACAAAAAAAA3DYAAEx5AAB4AAAAeQAAAHoAAAB7");n(g,66456,"fAAAAH0AAAB+AAAAfwAAAIAAAACBAAAAggAAAIMAAAADAAAANAAAAAACAAAAAAAA3y0AAER5AAB4AAAAeQAAAHoAAAB7");n(g,66544,"fAAAAH0AAAB+AAAAfwAAAIAAAACBAAAAggAAAIMAAAAAAABA");n(g,66592,"IywAAJkAAAAAAAAAqTQAAJoAAAAAAAAAbhEAAJsAAAAAAAAA/zkAAJwAAAAAAAAAEQ4AAJ0AAAAAAAAA+w0AAJ4AAAAAAAAAgzMAAJ8AAAAAAAAALi0AAKAAAAAAAAAAYEAAAKEAAAAAAAAAX0A=");n(g,66712,"bFs=");n(g,66724,"DjMAAKIAAAAAAAAADTM=");n(g,66748,"Y1s=");n(g,66760,"JToAAKMAAAAAAAAAeTM=");n(g,66784,"Vy4AAKQAAAAAAAAAYgQAAKUAAAAAAAAAriMAAKYAAAAAAAAAqCMAAKcAAAAAAAAAsycAAKgAAAAAAAAADzsAAKkAAAAAAAAAziYAAKoAAAAAAAAAxyYAAKsAAAAAAAAA0yY=");n(g,66892,"yTEAAKwAAAAAAAAAXi4AAK0AAAAAAAAA9Q0AAK4AAAAAAAAANC0=");n(g,66952,"iSYAAIAmAACNJgAABmEAAAIAAAAAAAAAAAQAAAAAAABoRgAAAAAAAMMAAAAAAAAAxAAAAMUAAADGAAAAxwAAAMgAAADJAAAAygAAAMsAAAAAAAAAzAAAAM0=");n(g,67056,"1kcAAExRAAA1SQAAEkwAALxOAAAZSQ==");n(g,67088,"AgAAAAFIxAABAAAAAAAAAOM=");n(g,67120,"dQYAAAAAAAACAAAAAUjEAAMAAAAAAAAA4w==");n(g,67160,"jzUAAAAAAAACAAAAAUjEAAIAAAAAAAAA4w==");n(g,67200,"wyIAAAAAAAABAAAAAUjEAAQAAAAAAAAA4w==");n(g,67240,"GQQAAAAAAAABAAAAASCA");n(g,67264,"5A==");n(g,67280,"Cz0AAAAAAAABAAAAASCA");n(g,67304,"5Q==");n(g,67320,"aA0AAAAAAAABAAAAAQzAAGMAAAAAAAAA4w==");n(g,67360,"BAUAAAAAAAACAAAAAQzAAGMAAAAAAAAA4w==");n(g,67400,"GjoAAAAAAAABAAAAAQzAAGMAAAAAAAAA4w==");n(g,67440,"BgUAAAAAAAABAAAAAQiAAAEAAAAAAAAA5g==");n(g,67480,"yywAAAAAAAACAAAAAQiAAAEAAAAAAAAA5g==");n(g,67520,"yywAAAAAAAABAAAAAQiAAAIAAAAAAAAA5g==");n(g,67560,"xSwAAAAAAAACAAAAAQiAAAIAAAAAAAAA5g==");n(g,67600,"xSwAAAAAAAABAAAAAQiAAAMAAAAAAAAA5g==");n(g,67640,"zCwAAAAAAAACAAAAAQiAAAMAAAAAAAAA5g==");n(g,67680,"zCwAAAAAAAD/AAAAIQiA");n(g,67704,"5w==");n(g,67720,"+is=");n(g,67732,"IQiA");n(g,67760,"+isAAAAAAAABAAAAIRCACAAAAAAAAAAA6AAAAOkAAADqAAAAAAAAAPorAAAAAAAA/wAAACEIgAABAAAAAAAAAOc=");n(g,67840,"NAY=");n(g,67852,"IQiAAAE=");n(g,67880,"NAYAAAAAAAABAAAAIRCACAEAAAAAAAAA6AAAAOkAAADqAAAAAAAAADQGAAAAAAAAAQAAAIEIgA==");n(g,67944,"6w==");n(g,67960,"ODEAAAAAAAABAAAAgQiA");n(g,67984,"7A==");n(g,68e3,"qjUAAAAAAAABAAAAQQiA");n(g,68024,"7Q==");n(g,68040,"wy8AAAAAAAABAAAAwQiA");n(g,68064,"7g==");n(g,68080,"qC8AAAAAAAACAAAAAQiA");n(g,68104,"7w==");n(g,68120,"tiIAAAAAAAD/AAAAAQiA");n(g,68144,"8A==");n(g,68160,"MTEAAAAAAAD/AAAAAQiA");n(g,68184,"8A==");n(g,68200,"Jw4AAAAAAAABAAAAAQiA");n(g,68224,"8Q==");n(g,68240,"TjkAAAAAAAD/AAAAAQiA");n(g,68264,"8g==");n(g,68280,"PiYAAAAAAAABAAAAAQiA");n(g,68304,"8w==");n(g,68320,"ZxcAAAAAAAABAAAAAQiA");n(g,68344,"9A==");n(g,68360,"LDoAAAAAAAACAAAAAQiA");n(g,68384,"9A==");n(g,68400,"LDoAAAAAAAABAAAAAQiA");n(g,68424,"9Q==");n(g,68440,"kiQAAAAAAAABAAAAAQiA");n(g,68464,"9g==");n(g,68480,"4iMAAAAAAAABAAAAAQiA");n(g,68504,"9w==");n(g,68520,"1AUAAAAAAAABAAAAAQiA");n(g,68544,"+A==");n(g,68560,"0gUAAAAAAAACAAAAAQiA");n(g,68584,"+A==");n(g,68600,"0gUAAAAAAAD/AAAAAQiA");n(g,68624,"+Q==");n(g,68640,"NA4=");n(g,68652,"AQiA");n(g,68680,"NA4AAAAAAAD/AAAAAQiA");n(g,68704,"+g==");n(g,68720,"hg4=");n(g,68732,"AQiA");n(g,68760,"hg4AAAAAAAABAAAAAQiA");n(g,68800,"hg4AAAAAAAACAAAAAQjA");n(g,68824,"4w==");n(g,68840,"XS0=");n(g,68852,"AQCA");n(g,68864,"+w==");n(g,68880,"tywAAAAAAAABAAAAAQCA");n(g,68904,"/A==");n(g,68920,"R0YAAAAAAAACAAAAIQiA");n(g,68944,"/Q==");n(g,68960,"aDE=");n(g,68972,"ASCA");n(g,68984,"4w==");n(g,69e3,"nyo=");n(g,69012,"ASCA");n(g,69024,"/g==");n(g,69040,"YzsAAAAAAAACAAAAAQiA");n(g,69064,"/w==");n(g,69080,"jTAAAAAAAAABAAAAAQiA");n(g,69105,"AQ==");n(g,69120,"BzM=");n(g,69132,"AQCA");n(g,69144,"AQE=");n(g,69160,"izo=");n(g,69172,"AQCA");n(g,69184,"AgE=");n(g,69200,"JRc=");n(g,69212,"AQCA");n(g,69224,"AwE=");n(g,69240,"HxcAAAAAAAADAAAAAQiA");n(g,69264,"BAE=");n(g,69280,"vTkAAAAAAAABAAAAAQiA");n(g,69304,"BQE=");n(g,69320,"PkYAAAAAAAACAAAAAQiA");n(g,69344,"BgE=");n(g,69360,"vCIAAAAAAAADAAAAAQiA");n(g,69384,"BgE=");n(g,69400,"vCIAAAAAAAACAAAAAQiA");n(g,69424,"BgE=");n(g,69440,"zTAAAAAAAAADAAAAAQiA");n(g,69464,"BgE=");n(g,69480,"zTAAAAAAAAABAAAAAQCA");n(g,69504,"BwEAAAgBAAAIAQAACQEAAJEsAAAAAAAAAQAAAAEAgA==");n(g,69544,"BwEAAAoBAAAKAQAACQEAAPktAAAAAAAAAQAAAAEAgA==");n(g,69584,"BwEAAAsBAAALAQAACQEAAIQw");n(g,69612,"AQGACAAAAAAAAAAADAEAAA0BAAANAQAADgEAAF8KAAAAAAAAAQAAAAEAgAgAAAAAAAAAAAwBAAANAQAADQEAAA4BAABfCgAAAAAAAAEAAAABAIA=");n(g,69704,"DwEAABABAAARAQAAEgEAAC4OAAAAAAAAAgAAAAEAgA==");n(g,69744,"DwEAABABAAARAQAAEgEAAC4OAAAAAAAAAgAAAAEAgA==");n(g,69784,"DwEAABABAAARAQAAEgEAAP4wAAAAAAAAAgAAAA0IgACoeQAAAAAAACs=");n(g,69840,"OUYAAAAAAAACAAAABQiAAKx5AAAAAAAAKw==");n(g,69880,"cTgAAAAAAAADAAAABQiAAKx5AAAAAAAAKw==");n(g,69920,"cTgAAAAAAAABAAAAAQiA");n(g,69960,"aTk=");n(g,69972,"AQiA");n(g,7e4,"aTkAAAAAAAABAAAAAQiA");n(g,70024,"EwE=");n(g,70040,"GSwAAAAAAAD/AAAAAQjA");n(g,70064,"4w==");n(g,70080,"aTkAAAAAAAADAAAAAQjAAAUAAAAAAAAA4w==");n(g,70120,"bzEAAAAAAAAJAAAAAQiE");n(g,70144,"FAE=");n(g,70160,"3SoAAAAAAAAHAAAAAQiE");n(g,70184,"FQE=");n(g,70200,"PjcAAAAAAAAHAAAAAQiE");n(g,70224,"FgE=");n(g,70240,"oQkAAAAAAAADAAAAAQiE");n(g,70264,"FwE=");n(g,70280,"yioAAAAAAAACAAAAAQiE");n(g,70304,"GAE=");n(g,70320,"kwU=");n(g,70340,"AQCB");n(g,70352,"GQEAABoBAAAaAQAAWgAAAG7C");n(g,70380,"AQCB");n(g,70392,"GwEAABwBAAAcAQAAWgAAAHnC");n(g,70420,"AQCB");n(g,70432,"HQEAAB4BAAAeAQAAWgAAAITC");n(g,70460,"AQCB");n(g,70472,"HwEAACABAAAgAQAAIQEAAInC");n(g,70500,"AQCB");n(g,70512,"IgEAACMBAAAjAQAAJAEAAJbCAAAAAAAAAQAAAAEAgQ==");n(g,70552,"JQEAACYBAAAmAQAAJwEAAKDCAAAAAAAAAQAAAAEAgQ==");n(g,70592,"KAEAACkBAAAqAQAAKwEAAIDKAAAAAAAAAgAAAAEAgQ==");n(g,70632,"LAEAAC0BAAAuAQAAWgAAAJDDAAAAAAAAAQAAAAEAgQ==");n(g,70672,"LwEAADABAAAuAQAAWgAAAJrDAAAAAAAAAQAAAAEAgQ==");n(g,70712,"WgAAAC4BAAAuAQAAWgAAAKbCAAAAAAAAAgAAAAEAgQ==");n(g,70752,"WgAAAC4BAAAuAQAAWgAAAKbCAAAAAAAAAwAAAAEAgQ==");n(g,70792,"WgAAAC4BAAAuAQAAWgAAAKbCAAAAAAAAAQAAAAEAgQ==");n(g,70832,"WgAAAC4BAAAuAQAAWgAAAKvCAAAAAAAAAgAAAAEAgQ==");n(g,70872,"WgAAAC4BAAAuAQAAWgAAAKvCAAAAAAAAAwAAAAEAgQ==");n(g,70912,"WgAAAC4BAAAuAQAAWgAAAKvC");n(g,70944,"/wAAAAEogACAAQEAAAAAADEB");n(g,70976,"fAUAAAAAAAD/AAAAASiAAIABAQAAAAAAMgE=");n(g,71016,"VDAAAAAAAAD/AAAAASiAAIABAQAAAAAAMwE=");n(g,71056,"dDMAAAAAAAD/AAAAASiAAIABAQAAAAAANAE=");n(g,71096,"QTYAAAAAAAD/AAAAASiAAIABAQAAAAAANQE=");n(g,71136,"MDYAAAAAAAD/AAAAASiAAIABAQAAAAAANgE=");n(g,71176,"JzYAAAAAAAACAAAAASiAAIABAQAAAAAANwE=");n(g,71216,"dzE=");n(g,71228,"ASCA");n(g,71240,"OAE=");n(g,71256,"OTY=");n(g,71268,"ASCA");n(g,71280,"OQE=");n(g,71296,"lyY=");n(g,71308,"ASCA");n(g,71320,"OgE=");n(g,71336,"bDMAAAAAAAABAAAAAYiAAQAAAAAAAAAAOwE=");n(g,71376,"zScAAAAAAAABAAAAAYiAAAgAAAAAAAAAOwE=");n(g,71416,"V0YAAAAAAAD/AAAAAQiQAQAAAAAAAAAAPAE=");n(g,71456,"ZQUAAAAAAAD/AAAAAQiQAQgAAAAAAAAAPAE=");n(g,71496,"cAUAAAAAAAABAAAAAYiA");n(g,71520,"PQE=");n(g,71536,"li8AAAAAAAACAAAAAYiA");n(g,71560,"PQE=");n(g,71576,"li8AAAAAAAABAAAAAYiA");n(g,71600,"PgE=");n(g,71616,"HygAAAAAAAD/AAAAAYiAAQAAAAAAAAAAPwE=");n(g,71656,"0Q0AAAAAAAD/AAAAAYiAAAgAAAAAAAAAPwE=");n(g,71696,"3g0AAAAAAAACAAAAAYiAAQEAAAAAAAAAPwE=");n(g,71736,"6lQAAAAAAAACAAAAAYiAAAIAAAAAAAAAPwE=");n(g,71776,"5lQAAAAAAAD/AAAAAYiQAQAAAAAAAAAAQAE=");n(g,71816,"9AkAAAAAAAD/AAAAAYiQAAgAAAAAAAAAQAE=");n(g,71857,"CgAAAAAAAP8AAAABCJABAAAAAAAAAABBAQ==");n(g,71896,"uA0AAAAAAAD/AAAAAQiQAQgAAAAAAAAAQQE=");n(g,71936,"xA0AAAAAAAACAAAAAYiAAQAAAAAAAAAAQgE=");n(g,71976,"8S8AAAAAAAACAAAAAYiAAAgAAAAAAAAAQgE=");n(g,72016,"/C8AAAAAAAABAAAAAQiQAQAAAAAAAAAAQwE=");n(g,72056,"AjMAAAAAAAD/AAAAAYiAAQAAAAAAAAAAOwE=");n(g,72096,"JDIAAAAAAAD/AAAAAYiAAAgAAAAAAAAAOwE=");n(g,72136,"MDIAAAAAAAD/AAAAAYiQAQAAAAAAAAAARAE=");n(g,72176,"qjkAAAAAAAD/AAAAAYiQAAgAAAAAAAAARAE=");n(g,72216,"tzkAAAAAAAD/AAAAAYiQAQQAAAAAAAAAQAE=");n(g,72256,"6AwAAAAAAAD/AAAAAYiQAAwAAAAAAAAAQAE=");n(g,72296,"8QwAAAAAAAABAAAAAYiA");n(g,72320,"RQE=");n(g,72336,"0zUAAAAAAAACAAAAAYiA");n(g,72360,"RQE=");n(g,72376,"0zUAAAAAAAABAAAAAYiA");n(g,72400,"RgE=");n(g,72416,"HzsAAAAAAAACAAAAAYiA");n(g,72440,"RgE=");n(g,72456,"HzsAAAAAAAABAAAAAQiQAQAAAAAAAAAARwEAAEgBAABJAQAASgEAAEIFAAAAAAAAAQAAAAEIkAEIAAAAAAAAAEcBAABIAQAASQEAAEoBAABTBQAAAAAAAAIAAAABCJABAAAAAAAAAABLAQAATAEAAE0BAABKAQAAkw0AAAAAAAACAAAAAQiQAQgAAAAAAAAASwEAAEwBAABNAQAASgEAAKUN");n(g,72632,"ogEAAKMBAACkAQAAAAAAAKUBAACmAQAApwEAAKgBAACpAQAAqgEAAKsB");n(g,72732,"ogEAAKMBAACkAQAAAAAAAKwBAACmAQAApwEAAKgBAACpAQAAqgEAAKsB");n(g,72824,"ECFR")}var t=new ArrayBuffer(16);var u=new Int32Array(t);var v=new Float32Array(t);var w=new Float64Array(t);function x(y){return u[y]}function z(y,A){u[y]=A}function B(){return w[0]}function C(A){w[0]=A}function D(){throw new Error("abort")}function Qa(s){var E=new ArrayBuffer(22151168);var F=new Int8Array(E);var G=new Int16Array(E);var H=new Int32Array(E);var I=new Uint8Array(E);var J=new Uint16Array(E);var K=new Uint32Array(E);var L=new Float32Array(E);var M=new Float64Array(E);var N=Math.imul;var O=Math.fround;var P=Math.abs;var Q=Math.clz32;var R=Math.min;var S=Math.max;var T=Math.floor;var U=Math.ceil;var V=Math.trunc;var W=Math.sqrt;var X=s.a;var Y=X.a;var Z=X.b;var _=X.c;var $=X.d;var aa=X.e;var ba=X.f;var ca=X.g;var da=X.h;var ea=X.i;var fa=X.j;var ga=X.k;var ha=X.l;var ia=X.m;var ja=X.n;var ka=X.o;var la=X.p;var ma=X.q;var na=X.r;var oa=X.s;var pa=X.t;var qa=X.u;var ra=X.v;var sa=X.w;var ta=X.x;var ua=X.y;var va=X.z;var wa=X.A;var xa=X.B;var ya=X.C;var za=X.D;var Aa=X.E;var Ba=X.F;var Ca=X.G;var Da=X.H;var Ea=5316880;var Fa=0;var Ga=0;var Ha=0;
// EMSCRIPTEN_START_FUNCS
function Rr(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,z=0,A=0,B=0,D=0,E=0,L=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0,ga=0,ha=0,ia=0,ja=0,ka=0,la=0,ma=0,na=0,oa=0,pa=0,qa=0;g=Ea-544|0;Ea=g;o=H[a+88>>2];u=H[a+104>>2];j=H[a>>2];w=I[j+84|0];if(H[a+160>>2]){ru(a)}if(H[j+372>>2]){b=H[j+380>>2];L=b-(K[a+180>>2]%(b>>>0)|0)|0;O=0}else{L=-1;O=-1}a:{b:{c:{d:{e:{if(H[a+36>>2]==7){f=u;break e}H[a+56>>2]=0;H[a+60>>2]=0;H[a+36>>2]=0;H[j+456>>2]=0;if(H[j+296>>2]){i=9;f=u;break b}_=j+492|0;ea=a+164|0;W=a+216|0;fa=j+388|0;A=a+124|0;ga=a+236|0;f=N(H[a+32>>2],20)+u|0;$=g+472|0;aa=g+512|0;ha=g+356|0;ia=g+360|0;while(1){b=R;S=S+1|0;R=S?b:b+1|0;f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{U:{V:{W:{X:{Y:{Z:{_:{$:{aa:{ba:{ca:{da:{ea:{fa:{ga:{ha:{ia:{ja:{ka:{la:{ma:{na:{oa:{pa:{qa:{ra:{sa:{ta:{ua:{va:{wa:{xa:{ya:{za:{Aa:{Ba:{Ca:{Da:{Ea:{Fa:{Ga:{Ha:{Ia:{Ja:{Ka:{La:{Ma:{Na:{Oa:{Pa:{Qa:{Ra:{Sa:{Ta:{Ua:{Va:{Wa:{Xa:{Ya:{Za:{_a:{$a:{ab:{bb:{cb:{db:{eb:{fb:{gb:{hb:{ib:{jb:{kb:{lb:{mb:{nb:{ob:{pb:{qb:{rb:{sb:{tb:{ub:{vb:{wb:{xb:{yb:{zb:{Ab:{Bb:{Cb:{Db:{Eb:{Fb:{Gb:{Hb:{Ib:{Jb:{Kb:{Lb:{Mb:{Nb:{Ob:{Pb:{Qb:{Rb:{Sb:{Tb:{Ub:{Vb:{Wb:{Xb:{Yb:{Zb:{_b:{$b:{ac:{bc:{cc:{dc:{ec:{fc:{gc:{hc:{ic:{jc:{kc:{lc:{mc:{nc:{oc:{pc:{qc:{rc:{sc:{tc:{uc:{vc:{wc:{xc:{yc:{zc:{Ac:{Bc:{Cc:{Dc:{Ec:{c=I[f|0];switch(c|0){case 146:break Na;case 147:break Oa;case 148:break Pa;case 149:break Qa;case 150:break Ra;case 151:break Sa;case 152:break Ta;case 154:break Ua;case 155:break Va;case 156:break Wa;case 46:break Xa;case 47:break Ya;case 48:break Za;case 157:break _a;case 158:break $a;case 49:break ab;case 159:break bb;case 59:break cb;case 160:break db;case 60:break eb;case 61:break fb;case 161:case 162:break hb;case 164:case 165:break ib;case 3:break jb;case 4:break kb;case 5:break lb;case 62:break mb;case 166:break nb;case 167:break ob;case 168:break pb;case 169:break qb;case 170:break rb;case 171:break sb;case 172:break tb;case 173:break ub;case 174:break vb;case 175:break wb;case 6:break xb;case 176:break yb;case 9:break h;case 63:break zb;case 177:break Ab;case 7:break Bb;case 178:break Cb;case 179:break Db;case 65:case 66:break Eb;case 180:break Fb;case 181:break Gb;case 182:break Hb;case 183:break Ib;case 64:break Jb;case 8:case 184:break Kb;case 68:break Lb;case 94:break Mb;case 20:break Nb;case 51:break Ob;case 92:break Pb;case 18:break Qb;case 50:break Rb;case 17:break Sb;case 16:break Tb;case 15:break Ub;case 114:break Vb;case 19:break Wb;case 91:break Xb;case 43:case 44:break Yb;case 14:break Zb;case 90:break _b;case 58:break $b;case 52:case 53:case 54:case 55:case 56:case 57:break ac;case 88:break bc;case 87:break cc;case 13:break dc;case 86:break ec;case 102:case 103:case 104:case 105:break fc;case 85:break gc;case 106:case 107:case 108:case 109:case 110:break hc;case 111:break ic;case 84:break jc;case 83:break kc;case 82:break lc;case 81:break mc;case 80:break nc;case 79:break oc;case 78:break pc;case 77:break qc;case 76:break rc;case 74:case 75:break sc;case 73:break tc;case 117:break uc;case 153:break vc;case 72:break wc;case 71:break xc;case 70:break yc;case 69:break zc;case 12:break Ac;case 11:break Bc;case 67:break Cc;case 10:break Dc;case 163:break Ec;case 95:break C;case 96:break D;case 97:break E;case 98:break F;case 0:break K;case 1:break L;case 2:break M;case 99:break N;case 100:break P;case 112:case 113:break R;case 101:break S;case 115:break T;case 116:case 118:break U;case 119:break V;case 120:break W;case 121:break X;case 122:break Y;case 21:case 22:case 23:case 24:break _;case 124:break aa;case 125:break ba;case 25:break ca;case 27:case 28:case 29:break da;case 26:break ea;case 30:break ha;case 31:break ia;case 126:break ja;case 127:break ka;case 128:break la;case 129:break ma;case 130:break na;case 131:break oa;case 132:break pa;case 133:break qa;case 134:break ra;case 135:break sa;case 136:break ta;case 32:case 137:break ua;case 33:break va;case 36:break wa;case 34:case 35:break xa;case 37:break Ca;case 39:break Da;case 38:break Ea;case 138:break Fa;case 139:break Ga;case 140:break Ha;case 141:case 142:break Ia;case 143:break Ja;case 40:case 41:case 42:case 45:break Ka;case 144:break La;case 145:break Ma;default:break f}}h=H[f+16>>2];break gb}b=N(H[f+4>>2],40)+o|0;d=(f-u|0)/20|0;H[b>>2]=d;H[b+4>>2]=d>>31;G[b+16>>1]=4;break h}b=N(H[f+4>>2],40)+o|0;if(!(I[b+16|0]&4)){break f}f=N(H[b>>2],20)+u|0;break f}d=H[f+12>>2];b=N(H[f+4>>2],40)+o|0;G[b+16>>1]=4;d=d-1|0;H[b>>2]=d;H[b+4>>2]=d>>31;if(!H[f+8>>2]){break f}break i}b=N(H[f+4>>2],40)+o|0;G[b+16>>1]=4;d=H[b>>2];c=(f-u|0)/20|0;H[b>>2]=c;H[b+4>>2]=c>>31;f=N(d,20)+u|0;break f}if(!(F[(N(H[f+12>>2],40)+o|0)+16|0]&1)){break f}}d=H[f+4>>2];b=H[W>>2];if(!(d|!b)){H[a+216>>2]=H[b+4>>2];H[a+224>>2]=H[a+224>>2]-1;d=H[a+44>>2];c=H[a+40>>2];H[j+104>>2]=c;H[j+108>>2]=d;k=H[j+112>>2];e=k+c|0;c=H[j+116>>2]+d|0;H[j+112>>2]=e;H[j+116>>2]=e>>>0<k>>>0?c+1|0:c;b=tu(b);u=H[a+104>>2];d=u;if(H[f+8>>2]==4){b=H[(N(b,20)+d|0)+8>>2]-1|0}f=N(b,20)+d|0;o=H[a+88>>2];break f}H[a+36>>2]=d;F[a+148|0]=H[f+8>>2];if(d){b=J[f+2>>1];Fc:{if(b){H[g+80>>2]=H[(b<<2)+34044>>2];Kc(a,15961,g+80|0);c=H[a+124>>2];b=H[f+16>>2];if(!b){break Fc}H[g+68>>2]=b;H[g+64>>2]=c;c=mb(j,7416,g- -64|0);H[A>>2]=c;break Fc}H[g+48>>2]=H[f+16>>2];Kc(a,8863,g+48|0);c=H[a+124>>2]}b=H[f+4>>2];d=H[a+200>>2];H[g+40>>2]=c;H[g+36>>2]=d;H[g+32>>2]=(f-u|0)/20;Ec(b,8797,g+32|0)}p=5;if((vj(a)|0)==5){break k}p=H[a+36>>2]?1:101;break j}b=Dc(a,f);d=H[f+4>>2];H[b>>2]=d;H[b+4>>2]=d>>31;break f}b=Dc(a,f);d=H[f+16>>2];c=H[d+4>>2];H[b>>2]=H[d>>2];H[b+4>>2]=c;break f}b=Dc(a,f);G[b+16>>1]=8;M[b>>3]=M[H[f+16>>2]>>3];break f}b=Dc(a,f);d=H[f+16>>2];e=bb(d);H[f+4>>2]=e;if((w|0)!=1){if(hd(b,d,-1,-1,1,0)){break s}if(Pd(b,w)){break e}p=0;H[b+24>>2]=0;G[b+16>>1]=J[b+16>>1]|8192;if(I[f+1|0]==250){Za(j,H[f+16>>2])}F[f+1|0]=250;H[f+16>>2]=H[b+8>>2];e=H[b+12>>2];H[f+4>>2]=e}if(H[j+120>>2]<(e|0)){break s}F[f|0]=73}b=Dc(a,f);G[b+16>>1]=8706;H[b+8>>2]=H[f+16>>2];d=H[f+4>>2];F[b+18|0]=w;H[b+12>>2]=d;d=H[f+12>>2];if((d|0)<=0){break f}d=N(d,40)+o|0;if(H[d>>2]!=J[f+2>>1]|H[d+4>>2]){break f}G[b+16>>1]=8720;break f}c=Dc(a,f);b=H[f+8>>2];d=H[f+12>>2];e=H[f+4>>2];H[c+12>>2]=0;k=e?257:1;G[c+16>>1]=k;e=d-b|0;while(1){if((e|0)<=0){break f}b=c+40|0;Xb(b);H[c+52>>2]=0;G[c+56>>1]=k;e=e-1|0;c=b;continue}}b=N(H[f+4>>2],40)+o|0;G[b+16>>1]=J[b+16>>1]&65472|1;break f}b=Dc(a,f);d=H[f+4>>2];c=H[f+16>>2];Gc:{if(!c){tp(b,d);if(!me(b)){break Gc}break e}hd(b,c,d,d>>31,0,0)}F[b+18|0]=w;break f}d=(H[a+100>>2]+N(H[f+4>>2],40)|0)-40|0;if(vp(d)){break s}b=N(H[f+8>>2],40)+o|0;if(I[b+17|0]&144){Xb(b)}c=H[d+16>>2];H[b+16>>2]=c;e=H[d+4>>2];H[b>>2]=H[d>>2];H[b+4>>2]=e;e=H[d+12>>2];H[b+8>>2]=H[d+8>>2];H[b+12>>2]=e;G[b+16>>1]=c&36799|8256;break f}c=N(H[f+8>>2],40)+o|0;e=N(H[f+4>>2],40)+o|0;h=H[f+12>>2];while(1){hw(c,e);if(I[c+17|0]&64){if(fg(c)){break e}}c=c+40|0;e=e+40|0;h=h-1|0;if(h){continue}break}break f}c=N(H[f+8>>2],40)+o|0;e=N(H[f+4>>2],40)+o|0;h=H[f+12>>2];while(1){Gg(c,e,16384);k=J[c+16>>1];if(k&16384){if(fg(c)){break e}k=J[c+16>>1]}if(!(!(k&2048)|!(I[f+2|0]&2))){G[c+16>>1]=k&63487}if(!h){break f}e=e+40|0;c=c+40|0;h=h-1|0;continue}}Gg(N(H[f+8>>2],40)+o|0,N(H[f+4>>2],40)+o|0,16384);break f}b=N(H[f+4>>2],40)+o|0;Bc(N(H[f+8>>2],40)+o|0,H[b>>2],H[b+4>>2]);break f}p=0;i=Vi(a,0);if(!i){break f}break b}H[a+28>>2]=(H[a+28>>2]|1)+2;H[a+120>>2]=N(H[f+4>>2],40)+o;if(I[j+87|0]){break e}if(I[j+94|0]&4){Ia[H[j+212>>2]](4,H[j+216>>2],a,0)|0}H[a+32>>2]=((f-u|0)/20|0)+1;p=100;break j}h=H[f+12>>2];b=N(h,40)+o|0;n=H[f+8>>2];d=N(n,40)+o|0;k=J[d+16>>1];c=N(H[f+4>>2],40)+o|0;m=J[c+16>>1];if((k|m)&1){Xb(b);break f}Hc:{Ic:{if(!(m&18)){if(!Fh(c,w,0)){break Ic}break e}if(!(m&1024)){break Hc}if(me(c)){break e}}m=J[c+16>>1]&-3;k=J[d+16>>1]}Jc:{Kc:{if(!(k&18)){if(!Fh(d,w,0)){break Kc}break e}if(!(k&1024)){break Jc}if(me(d)){break e}}k=J[d+16>>1]&-3}e=H[d+12>>2]+H[c+12>>2]|0;if((e|0)>H[j+120>>2]){break s}h=(h|0)==(n|0);if(mh(b,e+2|0,h)){break e}G[b+16>>1]=J[b+16>>1]&62016|2;if(!h){Va(H[b+8>>2],H[d+8>>2],H[d+12>>2]);G[d+16>>1]=k}Va(H[b+8>>2]+H[d+12>>2]|0,H[c+8>>2],H[c+12>>2]);G[c+16>>1]=m;d=w>>>0>1?e&-2:e;F[d+H[b+8>>2]|0]=0;F[(d+H[b+8>>2]|0)+1|0]=0;F[b+18|0]=w;H[b+12>>2]=d;G[b+16>>1]=J[b+16>>1]|512;break f}h=N(H[f+12>>2],40)+o|0;n=N(H[f+4>>2],40)+o|0;b=J[n+16>>1];l=N(H[f+8>>2],40)+o|0;d=J[l+16>>1];if(b&d&4){break o}if((b|d)&1){break m}if(!(ku(n)&ku(l)&4)){break n}c=I[f|0];break o}b=H[f+4>>2];if(!b){break f}Bc(N(b,40)+o|0,0,0);break f}k=N(H[f+12>>2],40)+o|0;b=N(H[f+8>>2],40)+o|0;c=N(H[f+4>>2],40)+o|0;if((J[b+16>>1]|J[c+16>>1])&1){Xb(k);break f}d=kb(b);b=Ha;e=kb(c);c=Ha;Lc:{Mc:{Nc:{Oc:{h=I[f|0];switch(h-102|0){case 1:break Nc;case 0:break Oc;default:break Mc}}d=d&e;b=b&c;break Lc}d=d|e;b=b|c;break Lc}if(!(c|e)){break Lc}l=-47-h|0;m=h;q=(c|0)<0;h=q;n=h?l:m;l=0-(((e|0)!=0)+c|0)|0;m=e>>>0<=4294967232&h|(c|0)<-1;e=h?m?64:0-e|0:e;c=h?m?0:l:c;if((c|0)>0){c=1}else{c=(c|0)>=0&e>>>0>=64}if(c){b=(n&255)!=104&(b|0)<0;d=0-b|0;b=0-((b|0)!=0)|0;break Lc}if((n&255)==104){h=d;c=e&31;if((e&63)>>>0>=32){b=d<<c;d=0}else{b=(1<<c)-1&h>>>32-c|b<<c;d=h<<c}break Lc}h=d;d=e&31;if((e&63)>>>0>=32){c=0;d=b>>>d|0}else{c=b>>>d|0;d=((1<<d)-1&b)<<32-d|h>>>d}if((b|0)>0|(b|0)>=0){b=c;break Lc}e=64-e|0;b=e&31;if((e&63)>>>0>=32){q=-1<<b;b=0}else{e=(1<<b)-1&-1>>>32-b;b=-1<<b;q=e|b}d=b|d;b=c|q}H[k>>2]=d;H[k+4>>2]=b;G[k+16>>1]=J[k+16>>1]&62016|4;break f}b=N(H[f+4>>2],40)+o|0;Eh(b);d=b;e=H[f+8>>2];c=e+H[b>>2]|0;b=H[b+4>>2]+(e>>31)|0;H[d>>2]=c;H[d+4>>2]=c>>>0<e>>>0?b+1|0:b;break f}Pc:{b=N(H[f+4>>2],40)+o|0;e=J[b+16>>1];if(e&4){break Pc}ve(b,67,w);e=J[b+16>>1];if(e&4){break Pc}if(H[f+8>>2]){break i}i=20;break b}G[b+16>>1]=e&62016|4;break f}b=N(H[f+4>>2],40)+o|0;if(!(I[b+16|0]&36)){break f}ju(b);break f}b=N(H[f+4>>2],40)+o|0;if(I[b+17|0]&4){i=me(b);if(i){break b}}i=iu(b,I[f+8|0],w);break O}n=H[f+12>>2];k=N(n,40)+o|0;e=J[k+16>>1];l=H[f+4>>2];h=N(l,40)+o|0;m=J[h+16>>1];q=e&m;if(q&4){b=H[k>>2];d=H[h>>2];e=H[k+4>>2];k=H[h+4>>2];if(b>>>0>d>>>0&(e|0)>=(k|0)|(e|0)>(k|0)){if(I[c+30984|0]){break i}break p}if(b>>>0<d>>>0&(e|0)<=(k|0)|(e|0)<(k|0)){if(I[c+30972|0]){break i}B=-1;break f}if(I[c+30978|0]){break i}break q}b=J[f+2>>1];Qc:{Rc:{Sc:{d=e|m;Tc:{if(d&1){if(b&128){B=1;if(!(!(q&1)|e&256)){B=0;b=30978;break Qc}if(!(e&1)){break Rc}B=-1;break Tc}if(b&16){break i}break p}b=b&71;Uc:{if(b>>>0>=67){if(!(d&2)){break Uc}if((m&46)==2){nj(h,0);e=J[k+16>>1]}if((e&46)!=2){break Uc}nj(k,0);break Uc}if(!(d&2)|(b|0)!=66){break Uc}Vc:{Wc:{Xc:{if(m&2){G[h+16>>1]=m&65491;break Xc}if(m&44){break Wc}}c=e;break Vc}Fh(h,w,1);m=J[h+16>>1]&-3520|m&3517;c=(l|0)==(n|0)?m|2:e;e=c&65535}Yc:{Zc:{if(e&2){G[k+16>>1]=J[k+16>>1]&65491;break Zc}if(e&44){break Yc}}e=c;break Uc}Fh(k,w,1);e=J[k+16>>1]&-3520|c&3517}B=Dh(k,h,H[f+16>>2]);c=I[f|0];if((B|0)>=0){break Sc}}b=30972;break Qc}if(B){break Rc}B=0;b=30978;break Qc}b=30984}G[k+16>>1]=e;G[h+16>>1]=m;if(I[(c&255)+b|0]){break i}break f}if(B){break f}B=0;break i}c=0;h=0;h=F[f+2|0]&1?H[f-4>>2]+4|0:h;b=H[f+12>>2];d=(b|0)>0?b:0;b=H[f+16>>2];k=b+20|0;n=H[f+8>>2];l=H[f+4>>2];while(1){if((c|0)==(d|0)){break f}m=I[H[b+16>>2]+c|0];e=h?H[(c<<2)+h>>2]:c;q=N(l+e|0,40)+o|0;r=N(e+n|0,40)+o|0;e=Dh(q,r,H[k+(c<<2)>>2]);if(e){d=m&1;e=!(I[H[b+16>>2]+c|0]&2)|!(F[q+16|0]&1|F[r+16|0]&1)?e:0-e|0;B=d?0-e|0:e;break f}else{c=c+1|0;B=0;continue}}}if((B|0)<0){f=(N(H[f+4>>2],20)+u|0)-20|0;break f}if(!B){f=(N(H[f+8>>2],20)+u|0)-20|0;break q}f=(N(H[f+12>>2],20)+u|0)-20|0;break f}b=Ch(N(H[f+4>>2],40)+o|0,2);c=Ch(N(H[f+8>>2],40)+o|0,2);d=N(H[f+12>>2],40)+o|0;b=I[(N(b,3)+c|0)+(I[f|0]==44?34064:34073)|0];if((b|0)==2){G[d+16>>1]=J[d+16>>1]&62016|1;break f}H[d>>2]=b;H[d+4>>2]=0;G[d+16>>1]=J[d+16>>1]&62016|4;break f}c=N(H[f+8>>2],40)+o|0;b=Ch(N(H[f+4>>2],40)+o|0,H[f+12>>2])^H[f+16>>2];Bc(c,b,b>>31);break f}b=N(H[f+8>>2],40)+o|0;d=N(H[f+4>>2],40)+o|0;if(!(F[d+16|0]&1)){Bc(b,!Ch(d,0),0);break f}Xb(b);break f}d=H[f+4>>2];b=N(H[f+8>>2],40)+o|0;Xb(b);d=N(d,40)+o|0;if(F[d+16|0]&1){break f}G[b+16>>1]=4;ma=b,na=kb(d)^-1,H[ma>>2]=na;H[b+4>>2]=Ha^-1;break f}b=H[a+104>>2];d=H[a+216>>2];_c:{if(d){b=(f-b|0)/20|0;c=1<<(b&7);b=H[d+20>>2]+(b>>>3|0)|0;d=I[b|0];if(c&d){break i}F[b|0]=c|d;c=H[H[a+104>>2]+4>>2];break _c}c=H[b+4>>2];if((c|0)==H[f+4>>2]){break i}}H[f+4>>2]=c;break f}if(Ch(N(H[f+4>>2],40)+o|0,H[f+12>>2])){break i}break f}if(!Ch(N(H[f+4>>2],40)+o|0,!H[f+12>>2])){break i}break f}if(F[(N(H[f+4>>2],40)+o|0)+16|0]&1){break i}break f}b=H[f+4>>2];$c:{if((b|0)>=0){d=H[f+12>>2];b=H[H[a+96>>2]+(b<<2)>>2];if((d|0)<J[b+54>>1]){b=H[(b+(d<<2)|0)+84>>2];if(b>>>0>=12){b=b&1?4:8;break $c}b=I[b+34082|0];break $c}b=1<<H[f+16>>2]-1;break $c}b=1<<I[(J[(N(H[f+12>>2],40)+o|0)+16>>1]&63)+31056|0]-1}if(b&J[f+2>>1]){break i}break f}ad:{if(!(F[(N(H[f+4>>2],40)+o|0)+16|0]&1)){if(!(F[(N(H[f+12>>2],40)+o|0)+16|0]&1)){break ad}}Xb(N(H[f+8>>2],40)+o|0);break f}Bc(N(H[f+8>>2],40)+o|0,0,0);break f}if(!(F[(N(H[f+4>>2],40)+o|0)+16|0]&1)){break i}break f}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];if(!b|!I[b+2|0]){break f}Xb(N(H[f+12>>2],40)+o|0);break i}c=H[a+96>>2]+(H[f+4>>2]<<2)|0;r=H[f+8>>2];bd:while(1){l=H[c>>2];while(1){s=H[l+64>>2];cd:{dd:{e=H[a+28>>2];if((e|0)!=H[l+24>>2]){if(I[l+2|0]){if(I[l|0]!=3){break dd}b=H[l+28>>2];if((b|0)<=0){break dd}b=N(b,40)+o|0;d=H[b+12>>2];H[l+72>>2]=d;H[l+76>>2]=d;h=H[b+8>>2];H[l+68>>2]=h;break A}b=H[l+36>>2];if(I[l+3|0]){ed:{d=H[l+8>>2];if(d){d=H[(d+(r<<2)|0)+4>>2];if(d){break ed}}p=0;i=hu(l);if(i){break b}break B}r=d-1|0;c=l+32|0;continue bd}if(!I[b|0]){break B}break cd}if(I[H[l+36>>2]]){break cd}m=J[l+54>>1];break z}Xb(N(H[f+12>>2],40)+o|0);break f}p=0;i=gu(l);if(!i){continue}break}break}break b}b=N(H[f+4>>2],40)+o|0;d=H[(N(H[b>>2],20)+u|0)+8>>2];G[b+16>>1]=0;f=(N(d,20)+u|0)-20|0;break f}b=I[j+94|0];fd:{if(!(b&65)|I[a+149|0]==254){break fd}e=H[f+16>>2];if(!e){e=H[a+200>>2];if(!e){break fd}}if(b&64){d=Ea-160|0;Ea=d;H[d+152>>2]=0;n=H[a>>2];b=H[n+120>>2];G[d+148>>1]=0;H[d+144>>2]=0;H[d+140>>2]=b;H[d+136>>2]=0;H[d+128>>2]=0;H[d+132>>2]=0;gd:{if(H[n+196>>2]>=2){c=e;while(1){l=I[e|0];if(!l){break gd}while(1){hd:{c=c+1|0;if((l|0)==10){break hd}l=I[c|0];if(l){continue}}break}b=d+128|0;sb(b,30509,3);sb(b,e,c-e|0);e=c;continue}}if(J[a+16>>1]){k=1;id:while(1){if(!I[e|0]){break gd}h=0;l=1;q=0;c=e;while(1){jd:{if(l){b=oj(c,d+156|0);if(H[d+156>>2]!=156){break jd}h=b}sb(d+128|0,e,q);if(!h){break gd}b=e+q|0;kd:{if(I[b|0]==63){if((h|0)>=2){cg(b+1|0,d+152|0);c=H[d+152>>2];break kd}H[d+152>>2]=k;c=k;break kd}c=jw(a,b,h);H[d+152>>2]=c}e=c+1|0;k=(e|0)>(k|0)?e:k;e=b+h|0;b=H[a+100>>2]+N(c,40)|0;c=J[b-24>>1];if(c&1){sb(d+128|0,20140,4);continue id}h=b-40|0;if(c&36){b=H[h+4>>2];H[d+80>>2]=H[h>>2];H[d+84>>2]=b;lb(d+128|0,14968,d+80|0);continue id}if(c&8){M[d+64>>3]=M[h>>3];lb(d+128|0,12578,d- -64|0);continue id}if(c&2){c=b-32|0;l=I[n+84|0];if((l|0)!=1){h=d+88|0;Xa(h,0,40);H[d+108>>2]=n;b=H[b-28>>2];hd(h,H[c>>2],b,b>>31,l,0);if((Pd(h,1)|0)==7){H[d+136>>2]=0;F[d+148|0]=7}ma=d,na=yJ(H[d+96>>2],H[d+100>>2],32),H[ma+48>>2]=na;H[d+52>>2]=Ha;lb(d+128|0,28121,d+48|0);_c(d+88|0);continue id}b=H[b-28>>2];H[d+36>>2]=H[c>>2];H[d+32>>2]=b;lb(d+128|0,28121,d+32|0);continue id}if(c&1024){H[d+16>>2]=H[h>>2];lb(d+128|0,25480,d+16|0);continue id}sb(d+128|0,27737,2);c=0;h=H[b-28>>2];h=(h|0)>0?h:0;b=b-32|0;while(1){if((c|0)!=(h|0)){H[d>>2]=I[H[b>>2]+c|0];lb(d+128|0,1599,d);c=c+1|0;continue}break}sb(d+128|0,29050,1);continue id}q=b+q|0;c=b+c|0;l=I[c|0];continue}}}sb(d+128|0,e,bb(e))}if(I[d+148|0]){Tf(d+128|0)}b=Jd(d+128|0);Ea=d+160|0;Ia[H[j+212>>2]](H[j+216>>2],b);Ta(b);break fd}if(H[j+196>>2]>=2){H[g+96>>2]=e;b=mb(j,8821,g+96|0);Ia[H[j+212>>2]](1,H[j+216>>2],a,b)|0;Za(j,b);break fd}Ia[H[j+212>>2]](1,H[j+216>>2],a,e)|0}b=H[f+4>>2];if((b|0)>=H[16547]){if(I[f|0]==184){break f}c=1;b=H[a+108>>2];b=(b|0)<=1?1:b;while(1){if((b|0)!=(c|0)){d=H[a+104>>2]+N(c,20)|0;if(I[d|0]==15){H[d+4>>2]=0}c=c+1|0;continue}break}H[f+4>>2]=0;b=0}H[f+4>>2]=b+1;H[a+188>>2]=H[a+188>>2]+1;break i}b=H[f+4>>2];d=fu(o,f);b=N(b,40)+o|0;c=H[b+8>>2];b=H[b+12>>2]<<3;b=wJ(d,Ha,b,b>>31);if(!(I[((Ha&7)<<29|b>>>3)+c|0]>>>(b&7)&1)){H[a+196>>2]=H[a+196>>2]+1;break i}H[a+192>>2]=H[a+192>>2]+1;break f}b=H[f+4>>2];d=fu(o,f);b=N(b,40)+o|0;c=H[b+8>>2];b=H[b+12>>2]<<3;b=wJ(d,Ha,b,b>>31);d=((Ha&7)<<29|b>>>3)+c|0;F[d|0]=I[d|0]|1<<(b&7);break f}b=N(H[f+8>>2],40)+o|0;d=J[b+16>>1];c=N(H[f+4>>2],40)+o|0;if(F[c+16|0]&1){G[b+16>>1]=d&63487;break f}G[b+16>>1]=d|2048;F[b+19|0]=H[c>>2];break f}b=N(H[f+8>>2],40)+o|0;d=N(H[f+4>>2],40)+o|0;if(I[d+17|0]&8){Bc(b,I[d+19|0],0);break f}Xb(b);break f}b=N(H[f+4>>2],40)+o|0;G[b+16>>1]=J[b+16>>1]&63487;break f}ld:{d=N(H[f+12>>2],40)+o|0;b=H[f+16>>2];if((d|0)==H[b>>2]){m=I[b+26|0];break ld}F[b+24|0]=w;H[b>>2]=d;H[b+12>>2]=a;e=b+28|0;m=I[b+26|0];c=m;while(1){if((c|0)<=0){break ld}c=c-1|0;H[e+(c<<2)>>2]=N(H[f+8>>2]+c|0,40)+o;continue}}G[d+16>>1]=J[d+16>>1]&62016|1;Ia[H[H[b+4>>2]+16>>2]](b,m,b+28|0);c=H[b+20>>2];if(!c){break f}i=p;if((c|0)>0){ma=g,na=$a(d),H[ma+320>>2]=na;Kc(a,8863,g+320|0);i=H[b+20>>2]}$k(j,ga,H[b+16>>2],H[f+4>>2]);p=0;H[b+20>>2]=0;if(!i){break f}break b}d=Dc(a,f);e=H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+4>>2];b=H[e+4>>2];c=H[f+12>>2];if(c){k=H[b+48>>2];c=c>>>0<k>>>0?k:c}else{c=0}H[b+4>>2]=H[e>>2];b=H[b>>2];md:{if(!c){c=H[b+160>>2];break md}H[b+160>>2]=c}H[d>>2]=c;H[d+4>>2]=0;break f}b=Dc(a,f);H[b>>2]=H[H[H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+4>>2]+4>>2]+48>>2];H[b+4>>2]=0;break f}H[g+352>>2]=0;H[g+356>>2]=0;if(I[j+87|0]){break e}i=6;b=H[H[f+16>>2]+8>>2];if(!b){break b}d=H[b>>2];if(!d){break b}if(!H[d+52>>2]){break f}c=0;i=H[f+8>>2];h=(i|0)>0?i:0;e=N(H[f+12>>2],40)+o|0;k=H[a+92>>2];n=I[j+92|0];while(1){if((c|0)!=(h|0)){H[k+(c<<2)>>2]=e;c=c+1|0;e=e+40|0;continue}break}F[j+92|0]=I[f+2|0];i=Ia[H[d+52>>2]](b,i,k,g+352|0)|0;F[j+92|0]=n;gf(a,b);if(!i){if(H[f+4>>2]){b=H[g+356>>2];H[j+40>>2]=H[g+352>>2];H[j+44>>2]=b}c=H[a+44>>2];b=H[a+40>>2]+1|0;c=b?c:c+1|0;H[a+40>>2]=b;H[a+44>>2]=c;break $}if(!(!I[H[f+16>>2]+16|0]|(i&255)!=19)){c=2;p=0;nd:{od:{b=J[f+2>>1];switch(b-4|0){case 0:break f;case 1:break nd;default:break od}}c=b}F[a+148|0]=c;break b}c=H[a+44>>2];b=H[a+40>>2]+1|0;c=b?c:c+1|0;H[a+40>>2]=b;H[a+44>>2]=c;break b}d=H[j+36>>2];b=H[j+32>>2];H[j+32>>2]=b|67108864;H[j+36>>2]=d;d=H[H[f+16>>2]+8>>2];c=N(H[f+4>>2],40)+o|0;i=Pd(c,1);if(i){break b}i=Ia[H[H[d>>2]+76>>2]](d,H[c+8>>2])|0;if(!(b&67108864)){c=H[j+36>>2];H[j+32>>2]=H[j+32>>2]&-67108865;H[j+36>>2]=c}gf(a,d);G[a+152>>1]=J[a+152>>1]&65532;break O}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];if(I[b+2|0]){break f}c=H[b+36>>2];e=H[c>>2];d=H[e>>2];i=Ia[H[d+36>>2]](c)|0;gf(a,e);if(i){break b}p=0;if(!(Ia[H[d+40>>2]](H[b+36>>2])|0)){break h}break g}d=N(H[f+12>>2],40)+o|0;c=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];if(I[c+2|0]){Xb(d);break f}e=H[H[c+36>>2]>>2];i=H[e>>2];b=$;H[b+16>>2]=0;H[b+20>>2]=0;H[b+8>>2]=0;H[b+12>>2]=0;H[b>>2]=0;H[b+4>>2]=0;F[g+488|0]=w;H[g+464>>2]=d;H[g+356>>2]=16777216;H[g+360>>2]=0;H[g+468>>2]=g+352;pd:{if(F[f+2|0]&1){Xb(d);H[d>>2]=0;G[d+16>>1]=1025;break pd}G[d+16>>1]=J[d+16>>1]&62016|1}i=Ia[H[i+44>>2]](H[c+36>>2],g+464|0,H[f+8>>2])|0;gf(a,e);if(H[g+484>>2]>0){ma=g,na=$a(d),H[ma+304>>2]=na;Kc(a,8863,g+304|0);i=H[g+484>>2]}Pd(d,w);p=0;if(!i){break f}break b}c=0;b=N(H[f+12>>2],40)+o|0;d=H[b+40>>2];h=(d|0)>0?d:0;n=b+40|0;b=H[b>>2];l=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];e=H[l+36>>2];m=H[e>>2];k=H[m>>2];i=H[a+92>>2];while(1){if((c|0)!=(h|0)){q=i+(c<<2)|0;c=c+1|0;H[q>>2]=n+N(c,40);continue}break}i=Ia[H[k+32>>2]](e,b,H[f+16>>2],d,i)|0;gf(a,m);if(i){break b}p=0;b=Ia[H[k+40>>2]](e)|0;F[l+2|0]=0;if(b){break i}break f}d=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];b=ub(8,0);if(!b){break e}H[b>>2]=H[d+36>>2];H[b+4>>2]=N(H[f+12>>2],40)+o;d=Dc(a,f);G[d+16>>1]=1;sw(d,b,2455,2);break f}H[g+352>>2]=0;c=N(H[f+8>>2],40)+o|0;Xb(c);d=H[f+16>>2];b=H[d+52>>2];if(!b){break f}e=H[b+8>>2];i=H[e>>2];H[b+12>>2]=H[b+12>>2]+1;i=Ia[H[i+96>>2]](e,H[H[j+16>>2]+(H[f+4>>2]<<4)>>2],H[d>>2],H[f+12>>2],g+352|0)|0;Rf(H[d+52>>2]);b=H[g+352>>2];if(!i){p=0;if(!b){break f}hd(c,b,-1,-1,1,1);break f}Ta(b);break b}H[g+352>>2]=0;i=6;b=H[H[f+16>>2]+8>>2];if(!b){break b}d=H[b>>2];if(!d){break b}i=Ia[H[d+24>>2]](b,g+352|0)|0;gf(a,b);if(i){break b}H[H[g+352>>2]>>2]=b;p=0;c=Fg(a,H[f+4>>2],0,2);if(c){H[c+36>>2]=H[g+352>>2];H[b+4>>2]=H[b+4>>2]+1;break f}Ia[H[d+28>>2]](H[g+352>>2])|0;break e}H[j+200>>2]=H[j+200>>2]+1;p=0;i=0;b=yc(j,H[f+16>>2],H[H[j+16>>2]+(H[f+4>>2]<<4)>>2]);qd:{if(!b|I[b+43|0]!=1){break qd}c=H[b+52>>2];if(!c){break qd}while(1){if(c){if(H[H[c+8>>2]+4>>2]>0){i=6;break qd}else{c=H[c+24>>2];continue}}break}d=du(j,b);c=H[H[d+4>>2]>>2];h=H[c+20>>2];if(!h){h=H[c+16>>2]}H[b+24>>2]=H[b+24>>2]+1;i=Ia[h|0](H[d+8>>2])|0;if(!i){H[d+8>>2]=0;H[b+52>>2]=0;Rf(d)}Cd(j,b)}H[j+200>>2]=H[j+200>>2]-1;if(!i){break f}break b}p=0;b=g+352|0;Xa(b,0,40);H[g+372>>2]=j;i=rj(b,N(H[f+8>>2],40)+o|0);b=$a(b);rd:{if(!b){break rd}sd:{b=yc(j,b,H[H[j+16>>2]+(H[f+4>>2]<<4)>>2]);c=H[H[b+48>>2]>>2];d=Hc(fa,c);td:{if(!d){break td}e=H[d>>2];i=H[e+4>>2];if(!i){break td}if(H[e+20>>2]){break sd}}H[g+288>>2]=c;ma=A,na=mb(j,8337,g+288|0),H[ma>>2]=na;i=1;break rd}i=np(j,b,d,i,A);if(i){break rd}i=0;if(!zd(j,b)){break rd}i=cu(j);if(i){break rd}bu(j,zd(j,b));i=0}_c(g+352|0);if(!i){break f}break b}b=H[f+16>>2];ud:{vd:{d=H[j+384>>2];if(!(H[j+408>>2]|(d|0)<=0)){i=6;break vd}if(!b){break I}e=H[H[b+8>>2]>>2];if(!H[e+56>>2]){i=0;break ud}c=0;d=(d|0)>0?d:0;wd:{while(1){if((c|0)==(d|0)){break wd}i=c<<2;c=c+1|0;if((b|0)!=H[H[j+408>>2]+i>>2]){continue}break}i=0;break vd}i=cu(j);if(i){break vd}i=Ia[H[e+56>>2]](H[b+8>>2])|0;if(i){break ud}d=H[j+504>>2];c=H[j+508>>2];bu(j,b);i=0;d=c+d|0;if(!d){break ud}c=H[e+80>>2];if(!c){break ud}H[b+20>>2]=d;i=Ia[c|0](H[b+8>>2],d-1|0)|0;break ud}if(!b){break O}}gf(a,H[b+8>>2]);break O}c=I[f+12|0];if(!(I[j+36|0]&4?c:1)){break f}p=0;b=H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+4>>2];if(!I[b+9|0]){break f}d=H[f+8>>2];H[H[b+4>>2]+4>>2]=H[b>>2];e=c+1|0;i=Io(b,d,e&255);if(!i){k=H[b+4>>2];c=k+76|0;xd:{while(1){c=H[c>>2];if(c){if((d|0)==H[c+4>>2]&(b|0)==H[c>>2]){break xd}c=c+12|0;continue}break}c=td(16,0);if(!c){break d}H[c>>2]=b;H[c+4>>2]=d;H[c+12>>2]=H[k+76>>2];H[k+76>>2]=c}if(I[c+8|0]>=(e&255)>>>0){break f}F[c+8|0]=e;break f}if((i&255)!=6){break b}H[g+272>>2]=H[f+16>>2];Kc(a,8692,g+272|0);break b}b=H[H[H[a+96>>2]+(H[f+4>>2]<<2)>>2]+36>>2];F[b+1|0]=I[b+1|0]&191;break f}b=H[H[H[a+96>>2]+(H[f+4>>2]<<2)>>2]+36>>2];F[b+1|0]=I[b+1|0]|64;break f}b=H[f+8>>2];if(!H[f+4>>2]){_f(j,b);break f}G[a+152>>1]=J[a+152>>1]&65532|b+1&3;break f}d=H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+4>>2];b=H[d+4>>2];H[b+4>>2]=H[d>>2];p=0;if(!I[b+17|0]){break i}d=H[b+48>>2];c=cb(H[H[b+12>>2]+56>>2]+36|0);e=qx(b,d,c);yd:{if(!(c>>>0<d>>>0&d>>>0>=e>>>0)){i=Ya(74234);break yd}if(!c){break i}i=hg(b,0,0);if(i){break yd}Wp(b);i=gx(b,e,d,0);if(i){break yd}i=Vb(H[H[b+12>>2]+72>>2]);d=H[H[b+12>>2]+56>>2];b=H[b+48>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[d+28|0]=b;F[d+29|0]=b>>>8;F[d+30|0]=b>>>16;F[d+31|0]=b>>>24}if(!i){p=i;break f}if((i|0)==101){break i}break b}p=0;e=H[f+4>>2];b=H[f+8>>2];h=b?N(b,40)+o|0:0;l=0;t=Ea-128|0;Ea=t;zd:{if(!I[j+85|0]){Nf(A,j,10623);c=1;break zd}if(H[j+184>>2]>=2){Nf(A,j,4419);c=1;break zd}i=H[j+60>>2];Ad:{if(!h){c=30558;break Ad}c=1;d=J[h+16>>1];b=d&31;if((d&63)>>>0>=32){b=262144>>>b|0}else{b=((1<<b)-1&262144)<<32-b|262148>>>b}if(!(b&1)){Nf(A,j,13913);break zd}c=$a(h);H[j+60>>2]=H[j+60>>2]&-8|6}ja=I[j+94|0];F[j+94|0]=0;ba=H[j+24>>2];H[j+24>>2]=ba|6;d=H[j+36>>2];T=d;q=H[j+32>>2];H[j+32>>2]=q&-268456450|513;H[j+36>>2]=d&-2;m=1;b=H[j+16>>2]+(e<<4)|0;D=H[b+4>>2];d=H[H[D+4>>2]>>2];if(!I[d+12|0]){m=I[d+16|0]!=0}d=H[b>>2];s=H[j+112>>2];ka=H[j+116>>2];y=H[j+104>>2];la=H[j+108>>2];k=H[j+20>>2];H[t+64>>2]=c;c=Ni(j,A,18030,t- -64|0);H[j+60>>2]=i;Bd:{if(c){break Bd}c=H[j+16>>2];l=c+(k<<4)|0;i=H[l+4>>2];Cd:{if(h){b=H[H[H[i+4>>2]>>2]+64>>2];H[t+80>>2]=0;H[t+84>>2]=0;n=H[b>>2];if(n){if(Ia[H[n+24>>2]](b,t+80|0)|0){break Cd}b=H[t+80>>2];c=H[t+84>>2];if((c|0)>0){b=1}else{b=!!b&(c|0)>=0}if(b){break Cd}c=H[j+16>>2]}H[j+24>>2]=H[j+24>>2]|8;b=I[((e<<4)+c|0)+8|0]|H[j+32>>2]&56}else{b=1}n=Dv(D);aj(i,H[H[(H[j+16>>2]+(e<<4)|0)+12>>2]+80>>2]);Sk(i,Sk(D,0));go(i,b|32);c=fo(j,A,19935);if(c){break Bd}c=zf(D,!h<<1,0);if(c){break Bd}b=H[D+4>>2];if(!(I[H[b>>2]+5|0]!=5|h)){H[j+100>>2]=0}c=7;if(bh(i,H[b+36>>2],n,0)){break Bd}if(!m){if(bh(i,H[j+100>>2],n,0)){break Bd}}if(I[j+87|0]){break Bd}b=F[j+90|0];if((b|0)<0){b=eo(D)}co(i,b);F[j+176|0]=k;H[t+48>>2]=d;c=Ni(j,A,24186,t+48|0);if(c){break Bd}H[t+32>>2]=d;c=Ni(j,A,27599,t+32|0);if(c){break Bd}F[j+176|0]=0;H[t+16>>2]=d;c=Ni(j,A,24035,t+16|0);H[j+24>>2]=H[j+24>>2]&-5;if(c){break Bd}H[t>>2]=d;c=Ni(j,A,26427,t);if(c){break Bd}r=0;while(1){if(r>>>0<=9){b=I[r+34344|0];Bh(D,b,t+68|0);d=r+34345|0;r=r+2|0;c=$j(i,b,H[t+68>>2]+I[d|0]|0);if(!c){continue}break Bd}break}Dd:{if(!h){d=H[D+4>>2];H[d+4>>2]=H[D>>2];b=H[i+4>>2];H[b+4>>2]=H[i>>2];d=H[H[d>>2]+64>>2];c=H[d>>2];Ed:{if(!c){break Ed}e=H[b+48>>2];b=H[b+36>>2];ma=t,na=sJ(e,0,b,b>>31),H[ma+72>>2]=na;H[t+76>>2]=Ha;c=Ia[H[c+40>>2]](d,11,t+72|0)|0;if((c|0)==12){break Ed}if(c){break Bd}}c=t+80|0;Xa(c,0,48);b=H[i>>2];H[t+104>>2]=i;H[t+100>>2]=b;H[t+96>>2]=1;H[t+84>>2]=D;n=0;Z=0;z=Ea-16|0;Ea=z;b=H[c+24>>2];d=H[b+4>>2];H[d+4>>2]=H[b>>2];e=H[c+28>>2];if(!(e>>>0>6|!(1<<e&97))){X=H[d>>2];P=H[H[H[c+4>>2]+4>>2]>>2];Fd:{if(!(!H[c>>2]|I[d+20|0]!=2)){Z=1;e=5;break Fd}if(I[b+8|0]){Z=1;e=0;break Fd}e=zf(b,0,0)}v=H[c+12>>2];Gd:{Hd:{if(!(e|v)){e=7;if((bh(H[c+4>>2],H[H[H[c+24>>2]+4>>2]+36>>2],0,0)|0)==7){break Gd}v=H[c+12>>2];break Hd}if(e){break Gd}}e=0;if(v){break Gd}e=zf(H[c+4>>2],2,c+8|0);if(e){break Gd}H[c+12>>2]=1;e=0}b=H[H[c+4>>2]+4>>2];d=H[b+36>>2];r=H[H[c+24>>2]+4>>2];k=H[r+36>>2];m=I[H[b>>2]+5|0];Id:{if(e){break Id}Jd:{if((m|0)!=5){e=0;if(!(I[P+12|0]?1:I[P+16|0]!=0)){break Id}if((d|0)!=(k|0)){break Jd}break Id}e=0;if((d|0)==(k|0)){break Id}}e=8}r=H[r+48>>2];while(1){Kd:{if((n|0)==2147483647){break Kd}b=H[c+16>>2];if(b>>>0>r>>>0|e){break Kd}e=0;if((b|0)!=((K[16644]/K[H[H[c+24>>2]+4>>2]+36>>2]|0)+1|0)){e=Ia[H[X+220>>2]](X,b,z+8|0,2)|0;if(!e){e=lz(c,b,H[H[z+8>>2]+4>>2],0);jd(H[z+8>>2])}b=H[c+16>>2]}H[c+16>>2]=b+1;n=n+1|0;continue}break}Ld:{Md:{if((e|0)==101){break Md}if(e){break Ld}H[c+36>>2]=r;b=H[c+16>>2];H[c+32>>2]=(r-b|0)+1;if(b>>>0>r>>>0){break Md}e=0;if(H[c+40>>2]){break Ld}b=H[H[H[c+24>>2]+4>>2]>>2];H[c+44>>2]=H[b+96>>2];H[b+96>>2]=c;H[c+40>>2]=1;break Ld}Nd:{if(r){break Nd}b=H[c+4>>2];e=H[b>>2];b=H[b+4>>2];H[b+48>>2]=0;H[b+4>>2]=e;r=1;e=Oq(b);if((e|0)==101){break Nd}if(e){break Ld}}e=$j(H[c+4>>2],1,H[c+8>>2]+1|0);if(e){break Ld}b=H[c>>2];if(b){yf(b)}if((m|0)==5){e=gz(H[c+4>>2],2);if(e){break Ld}}Od:{if((d|0)>(k|0)){b=(d|0)/(k|0)|0;b=((b+r|0)-1|0)/(b|0)|0;v=b-((b|0)==((K[16644]/K[H[H[c+4>>2]+4>>2]+36>>2]|0)+1|0))|0;b=H[P+28>>2];Q=H[P+64>>2];n=r>>31;e=0;while(1){if(!(b>>>0<v>>>0|e)){e=0;Pd:{if(((K[16644]/K[H[H[c+4>>2]+4>>2]+36>>2]|0)+1|0)==(v|0)){break Pd}e=Ia[H[P+220>>2]](P,v,z+8|0,0)|0;if(e){break Pd}e=Vb(H[z+8>>2]);jd(H[z+8>>2])}v=v+1|0;continue}break}v=k>>31;n=sJ(r,n,k,v);r=Ha;if(!e){e=Jq(P,0,1)}ca=H[16644];b=ca+d|0;d=b>>31;U=b>>>0>n>>>0&(d|0)>=(r|0)|(d|0)>(r|0);m=U?n:b;U=U?r:d;d=k+ca|0;b=d>>31;while(1){if(!((b|0)>=(U|0)&d>>>0>=m>>>0|(b|0)>(U|0)|e)){H[z+8>>2]=0;e=(na=X,oa=tJ(d,b,k,v)+1|0,pa=z+8|0,qa=0,ma=H[X+220>>2],Ia[ma](na|0,oa|0,pa|0,qa|0)|0);if(!e){e=Ia[H[H[Q>>2]+12>>2]](Q,H[H[z+8>>2]+4>>2],k,d,b)|0}jd(H[z+8>>2]);b=b+v|0;d=d+k|0;b=d>>>0<k>>>0?b+1|0:b;continue}break}if(e){break Ld}e=Ia[H[H[Q>>2]+24>>2]](Q,z+8|0)|0;if(e){break Ld}b=H[z+12>>2];if(K[z+8>>2]>n>>>0&(b|0)>=(r|0)|(b|0)>(r|0)){e=Ia[H[H[Q>>2]+16>>2]](Q,n,r)|0;if(e){break Ld}}e=Iq(P,0);break Od}H[P+28>>2]=N((k|0)/(d|0)|0,r);e=Jq(P,0,0)}if(e){break Ld}b=Xj(H[c+4>>2],0);e=b?b:101}if(!Z){pm(H[c+24>>2],0);Xj(H[c+24>>2],0)}H[c+28>>2]=(e|0)==3082?7:e}Ea=z+16|0;if(c){d=H[c+20>>2];b=H[c+24>>2];e=H[b+4>>2];H[e+4>>2]=H[b>>2];if(H[c>>2]){H[b+16>>2]=H[b+16>>2]-1}if(H[c+40>>2]){e=H[e>>2]+96|0;while(1){b=e;k=H[b>>2];e=k+44|0;if((c|0)!=(k|0)){continue}break}H[b>>2]=H[c+44>>2]}Kp(H[c+4>>2],0,0);b=H[c+28>>2];b=(b|0)!=101?b:0;e=H[c>>2];Qd:{if(!e){break Qd}Pc(e,b);Dm(H[c>>2]);if(!H[c>>2]){break Qd}Ta(c)}Dm(d)}else{b=0}c=b;if(c){break Dd}b=H[D+4>>2];G[b+24>>1]=J[b+24>>1]&65533}c=ho(i);b=!c;if(!(c|h)){co(D,eo(i));b=1}if(!b|h){break Bd}b=Dv(i);c=bh(D,H[H[i+4>>2]+36>>2],b,1);break Bd}b=H[H[H[t+84>>2]+4>>2]>>2];if(!I[b+12|0]){Lg(b)}break Bd}Nf(A,j,3771);c=1}H[j+112>>2]=s;H[j+116>>2]=ka;H[j+104>>2]=y;H[j+108>>2]=la;H[j+32>>2]=q;H[j+36>>2]=T;H[j+24>>2]=ba;F[j+176|0]=0;F[j+94|0]=ja;bh(D,-1,0,1);F[j+85|0]=1;if(l){rf(H[l+4>>2]);H[l+12>>2]=0;H[l+4>>2]=0}yf(j)}Ea=t+128|0;i=c;if(!c){break f}break b}h=Dc(a,f);c=H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+4>>2];d=H[H[c+4>>2]>>2];b=I[d+5|0];Rd:{if(I[d+17|0]<=2){e=H[f+12>>2];k=(e|0)==-1?b:e;if(!H[H[d+68>>2]>>2]){break Rd}e=H[d+80>>2];i=H[d+84>>2];if((i|0)<0){e=1}else{e=!e&(i|0)<=0}if(e){break Rd}}k=b}i=33044;i=I[d+15|0]|H[d>>2]==66968?i:H[d+184>>2];e=b;Sd:{Td:{Ud:{if((k|0)==5){if(!bb(i)){break Td}if(!Bu(d)|(b|0)==5){break Td}break Ud}if((b|0)==(k|0)){break Td}if((b|0)==5){break Ud}i=p;b=k;break Sd}if(!(H[j+188>>2]<2?I[j+85|0]:0)){H[g+256>>2]=(k|0)==5?9998:12614;Kc(a,10509,g+256|0);break G}Vd:{Wd:{if((k|0)!=5){Xd:{if(!H[d+232>>2]){H[g+352>>2]=0;i=Sf(d,1);if(i){break Vd}b=H[d>>2];i=Ia[H[b+32>>2]](b,H[d+236>>2],0,g+352|0)|0;if(!(i|!H[g+352>>2])){i=Au(d)}if(i){break Vd}if(!H[d+232>>2]){break Xd}}i=zu(d);if(i){break Vd}i=gv(H[d+232>>2],j,I[d+11|0],H[d+168>>2],H[d+224>>2]);H[d+232>>2]=0;if(!i){break Xd}if(I[d+4|0]){break Vd}Jg(d,1);break Vd}yo(d,k);b=1;break Wd}if((b|0)==4){yo(d,2)}b=5;i=p;if(i){break Sd}b=2}i=gz(c,b)}b=k;break Sd}i=p}b=yo(d,i?e:b);G[h+16>>1]=8706;p=0;c=0;c=(b|0)!=6?H[(b<<2)+34320>>2]:c;H[h+8>>2]=c;b=bb(c);F[h+18|0]=1;H[h+12>>2]=b;Pd(h,w);if(!i){break f}break b}H[g+360>>2]=-1;H[g+352>>2]=0;H[g+356>>2]=-1;i=Hv(j,H[f+4>>2],H[f+8>>2],ha,ia);if(i){if((i|0)!=5){break b}H[g+352>>2]=1}e=N(H[f+12>>2],40)+o|0;c=0;while(1){if((c|0)==3){break I}b=H[(g+352|0)+(c<<2)>>2];Bc(e,b,b>>31);e=e+40|0;c=c+1|0;continue}}c=N(H[f+4>>2],40)+o|0;d=H[f+12>>2];Yd:{if(d){b=H[f+16>>2];H[g+380>>2]=0;H[g+372>>2]=0;H[g+376>>2]=0;H[g+364>>2]=0;H[g+368>>2]=0;d=N(d,40)+o|0;Xb(d);H[g+352>>2]=d;H[g+356>>2]=b;H[g+360>>2]=c;F[g+376|0]=I[H[c+20>>2]+84|0];Ia[H[b+24>>2]](g+352|0);c=N(H[f+12>>2],40)+o|0;i=H[g+372>>2];break Yd}i=lu(c,H[f+16>>2])}if(!i){Pd(c,w);break I}ma=g,qa=$a(c),H[ma+240>>2]=qa;Kc(a,8863,g+240|0);break b}d=J[f+2>>1];b=d<<2;h=Nb(j,b+68|0,0);if(!h){break e}H[h+8>>2]=0;b=b+h|0;H[h>>2]=b+28;H[b+52>>2]=0;H[b+48>>2]=j;G[b+44>>1]=1;b=H[f+16>>2];H[h+16>>2]=(f-u|0)/20;H[h+4>>2]=b;F[h+25|0]=0;H[h+12>>2]=a;F[h+26|0]=d;F[h+24|0]=w;H[h+20>>2]=0;H[f+16>>2]=h;G[f>>1]=61859}Zd:{b=N(H[f+12>>2],40)+o|0;if((b|0)==H[h+8>>2]){m=I[h+26|0];break Zd}H[h+8>>2]=b;d=h+28|0;m=I[h+26|0];c=m;while(1){if((c|0)<=0){break Zd}c=c-1|0;H[d+(c<<2)>>2]=N(H[f+8>>2]+c|0,40)+o;continue}}H[b+12>>2]=H[b+12>>2]+1;Ia[H[H[h+4>>2]+(H[f+4>>2]?28:16)>>2]](h,m,h+28|0);b=H[h+20>>2];if(!b){break f}i=p;if((b|0)>0){ma=g,qa=$a(H[h>>2]),H[ma+224>>2]=qa;Kc(a,8863,g+224|0);i=H[h+20>>2]}if(I[h+25|0]){b=H[f-16>>2];if(b){Bc(N(b,40)+o|0,1,0)}F[h+25|0]=0}_c(H[h>>2]);G[H[h>>2]+16>>1]=1;p=0;H[h+20>>2]=0;if(!i){break f}break b}d=N(H[f+4>>2],40)+o|0;b=H[d>>2];e=H[d+4>>2];if(!b&(e|0)==-2147483648){break f}c=b-1|0;H[d>>2]=c;b=e-!b|0;H[d+4>>2]=b;if(!(b|c)){break i}break f}d=N(H[f+4>>2],40)+o|0;b=H[d>>2];c=H[d+4>>2];if(!(b|c)){break f}if(!b&(c|0)<=0|(c|0)<0){break i}H[d>>2]=b-1;H[d+4>>2]=c-!b;break i}d=H[f+4>>2];e=H[f+12>>2];b=Dc(a,f);c=N(d,40)+o|0;d=H[c>>2];c=H[c+4>>2];H[g+352>>2]=d;H[g+356>>2]=c;if(!d&(c|0)<=0|(c|0)<0){d=-1;c=-1}else{c=N(e,40)+o|0;d=H[c>>2];e=d;c=H[c+4>>2];d=!!d&(c|0)>=0|(c|0)>0;c=_k(g+352|0,d?e:0,d?c:0);d=c?-1:H[g+352>>2];c=c?-1:H[g+356>>2]}H[b>>2]=d;H[b+4>>2]=c;break f}d=N(H[f+4>>2],40)+o|0;b=H[d>>2];c=H[d+4>>2];if(!b&(c|0)<=0|(c|0)<0){break f}e=H[f+12>>2];H[d>>2]=b-e;H[d+4>>2]=c-((e>>31)+(b>>>0<e>>>0)|0);break i}c=H[W>>2];if(c){while(1){b=c;c=H[b+4>>2];if(c){continue}break}b=H[b+12>>2]}else{b=o}d=b+N(H[f+4>>2],40)|0;Eh(d);c=N(H[f+8>>2],40)+o|0;Eh(c);b=H[c>>2];c=H[c+4>>2];e=H[d+4>>2];if((c|0)<=(e|0)&K[d>>2]>=b>>>0|(c|0)<(e|0)){break f}H[d>>2]=b;H[d+4>>2]=c;break f}if(H[f+4>>2]){if(H[j+512>>2]|H[j+516>>2]){break f}if(!(H[j+520>>2]|H[j+524>>2])){break i}break f}if(H[a+64>>2]|H[a+68>>2]){break f}if(!(H[j+520>>2]|H[j+524>>2])){break i}break f}if(I[j+34|0]&8){b=H[f+8>>2];c=b;d=b+H[j+520>>2]|0;b=H[j+524>>2]+(b>>31)|0;H[j+520>>2]=d;H[j+524>>2]=c>>>0>d>>>0?b+1|0:b;break f}d=H[f+8>>2];b=d>>31;if(H[f+4>>2]){q=b+H[j+516>>2]|0;b=d+H[j+512>>2]|0;q=b>>>0<d>>>0?q+1|0:q;H[j+512>>2]=b;H[j+516>>2]=q;break f}b=b+H[a+68>>2]|0;c=d;d=d+H[a+64>>2]|0;b=c>>>0>d>>>0?b+1|0:b;H[a+64>>2]=d;H[a+68>>2]=b;break f}c=Dc(a,f);b=H[a+216>>2];Gg(c,(H[b+12>>2]+N(H[f+4>>2],40)|0)+N(H[(H[b+8>>2]+N(H[b+48>>2],20)|0)+4>>2],40)|0,16384);break f}c=H[f+12>>2];b=H[f+16>>2];_d:{if(!J[f+2>>1]){break _d}k=H[b+20>>2];e=W;while(1){d=H[e>>2];if(!d){break _d}e=d+4|0;if((k|0)!=H[d+24>>2]){continue}break}break f}e=H[a+224>>2];if((e|0)<H[j+160>>2]){$d:{ae:{d=N(c,40)+o|0;if(!(I[d+16|0]&16)){c=H[b+12>>2];m=!c+(c+H[b+8>>2]|0)|0;e=N(m,40);c=(e+(((H[b+4>>2]+7|0)/8|0)+(c<<2)|0)|0)+88|0;h=nb(j,c,c>>31);if(!h){break e}_c(d);H[d+36>>2]=3;H[d+12>>2]=c;H[d+8>>2]=h;G[d+16>>1]=4112;H[h+60>>2]=m;H[h>>2]=a;l=H[b+12>>2];H[h+48>>2]=(f-u|0)/20;H[h+64>>2]=l;H[h+12>>2]=H[a+88>>2];H[h+56>>2]=H[a+20>>2];H[h+16>>2]=H[a+96>>2];H[h+44>>2]=H[a+24>>2];H[h+8>>2]=H[a+104>>2];H[h+52>>2]=H[a+108>>2];H[h+24>>2]=H[b+20>>2];c=h+88|0;d=e+c|0;while(1){if((c|0)==(d|0)){break ae}H[c+20>>2]=j;G[c+16>>1]=0;c=c+40|0;continue}}l=H[b+12>>2];h=H[d+8>>2];c=J[h+64>>1];m=H[h+60>>2];break $d}e=H[a+224>>2];c=l}H[a+224>>2]=e+1;H[h+4>>2]=H[a+216>>2];d=H[j+44>>2];H[h+32>>2]=H[j+40>>2];H[h+36>>2]=d;d=H[a+44>>2];H[h+72>>2]=H[a+40>>2];H[h+76>>2]=d;d=H[a>>2];e=H[d+108>>2];H[h+80>>2]=H[d+104>>2];H[h+84>>2]=e;H[h+40>>2]=H[a+236>>2];H[a+216>>2]=h;H[a+40>>2]=0;H[a+44>>2]=0;H[a+236>>2]=0;o=h+88|0;H[a+88>>2]=o;d=N(m,40)+o|0;H[a+96>>2]=d;H[a+24>>2]=c&65535;H[a+20>>2]=m;d=d+(l<<2)|0;H[h+20>>2]=d;Xa(d,0,(H[b+4>>2]+7|0)/8|0);u=H[b>>2];H[a+104>>2]=u;H[a+108>>2]=H[b+4>>2];f=u-20|0;break g}Kc(a,10861,0);break G}b=H[f+12>>2];n=H[f+16>>2];l=N(H[f+4>>2],40)+o|0;if(!(I[l+16|0]&16)){if(au(l)){break e}}m=N(b,40)+o|0;b=m;d=H[b>>2];b=H[b+4>>2];if(n){c=H[l+8>>2];if((n|0)!=H[c+28>>2]){e=H[c+8>>2];if(e){if(!(F[c+26|0]&1)){e=$t(e)}h=c+20|0;be:{ce:{while(1){k=H[h>>2];if(!k){break ce}h=H[k+12>>2];if(h){Zt(h,g+352|0,g+464|0);H[k+12>>2]=0;h=k+8|0;e=xo(H[g+352>>2],e);continue}break}ma=k,qa=Yt(e),H[ma+12>>2]=qa;break be}k=Xt(c);H[h>>2]=k;if(!k){break be}H[k+8>>2]=0;H[k>>2]=0;H[k+4>>2]=0;ma=k,qa=Yt(e),H[ma+12>>2]=qa}H[c+8>>2]=0;H[c+12>>2]=0;G[c+26>>1]=J[c+26>>1]|1}H[c+28>>2]=n}c=c+20|0;while(1){k=H[c>>2];if(k){c=k+12|0;while(1){e=H[c>>2];if(e){c=H[e>>2];h=H[e+4>>2];if(c>>>0<d>>>0&(h|0)<=(b|0)|(b|0)>(h|0)){c=8}else{if(c>>>0<=d>>>0&(b|0)>=(h|0)|(b|0)>(h|0)){break i}c=12}c=c+e|0;continue}break}c=k+8|0;continue}break}if((n|0)<0){break f}d=H[m>>2];b=H[m+4>>2]}Wt(H[l+8>>2],d,b);break f}de:{c=N(H[f+4>>2],40)+o|0;if(!(I[c+16|0]&16)){break de}b=H[c+8>>2];d=J[b+26>>1];if(!(d&2)){if(!(d&1)){ma=b,qa=$t(H[b+8>>2]),H[ma+8>>2]=qa;d=J[b+26>>1]}G[b+26>>1]=d|3}d=H[b+8>>2];if(!d){break de}c=H[d>>2];e=H[d+4>>2];d=H[d+8>>2];H[b+8>>2]=d;if(!d){Vt(b)}Bc(N(H[f+12>>2],40)+o|0,c,e);break g}Xb(c);break h}d=H[f+8>>2];b=N(H[f+4>>2],40)+o|0;if(!(I[b+16|0]&16)){if(au(b)){break e}}d=N(d,40)+o|0;Wt(H[b+8>>2],H[d>>2],H[d+4>>2]);break f}k=N(H[f+12>>2],40)+o|0;n=H[k>>2]+1|0;l=H[(H[j+16>>2]+(J[f+2>>1]<<4)|0)+4>>2];d=H[l+4>>2];c=H[d+4>>2];m=0;e=H[f+16>>2];p=H[e+4>>2];if(!p){m=H[e+8>>2]!=1}q=N(H[f+4>>2],40);h=H[f+8>>2];b=H[c+32>>2];r=H[c+36>>2];H[d+4>>2]=H[l>>2];Xa($,0,68);H[g+464>>2]=d;H[g+540>>2]=j;H[g+468>>2]=H[d>>2];c=H[d+48>>2];F[g+533|0]=1;H[g+520>>2]=100;H[g+524>>2]=1e9;H[g+480>>2]=n;H[g+476>>2]=c;H[g+516>>2]=g+352;ee:{if(!c){break ee}n=td((c>>>3|0)+1|0,0);H[g+472>>2]=n;fe:{if(!n){break fe}l=$i(H[d+36>>2]);H[g+536>>2]=l;if(!l){break fe}l=c;c=(K[16644]/K[d+36>>2]|0)+1|0;if(l>>>0>=c>>>0){n=n+(c>>>3|0)|0;F[n|0]=I[n|0]|1<<(c&7)}if(!m){H[g+496>>2]=30468;c=H[H[d+12>>2]+56>>2];Ut(g+464|0,1,cb(c+32|0),cb(c+36|0));H[g+496>>2]=0}n=e+4|0;ge:{if(!p){break ge}if(I[d+17|0]){e=0;l=(h|0)>0?h:0;c=0;while(1){if((c|0)!=(l|0)){m=H[n+(c<<2)>>2];e=e>>>0>m>>>0?e:m;c=c+1|0;continue}break}c=cb(H[H[d+12>>2]+56>>2]+52|0);if((c|0)==(e|0)){break ge}H[g+212>>2]=c;H[g+208>>2]=e;Oc(g+464|0,24956,g+208|0);break ge}if(!cb(H[H[d+12>>2]+56>>2]- -64|0)){break ge}Oc(g+464|0,10003,0)}c=H[d+4>>2];e=H[c+32>>2];l=H[c+36>>2];H[c+32>>2]=e&-2097153;H[c+36>>2]=l;c=0;while(1){e=H[g+480>>2];if(!(!e|(c|0)>=(h|0))){l=n+(c<<2)|0;e=H[l>>2];if(e){if(!(!I[d+17|0]|(!p|(e|0)==1))){Eg(g+464|0,e,1,0);e=H[l>>2]}H[g+500>>2]=e;wo(g+464|0,e,g+344|0,-1,2147483647)}c=c+1|0;continue}break}c=H[d+4>>2];H[c+32>>2]=b;H[c+36>>2]=r;c=1;if(!p){break ee}while(1){if(!e|K[g+476>>2]<c>>>0){break ee}e=1<<(c&7);b=c>>>3|0;he:{if(!(e&I[b+H[g+472>>2]|0])){if(ma=(Qd(d,c)|0)==(c|0),qa=0,pa=I[d+17|0],pa?ma:qa){break he}H[g+192>>2]=c;Oc(g+464|0,15653,g+192|0);if(!(e&I[b+H[g+472>>2]|0])){break he}}if((Qd(d,c)|0)!=(c|0)|!I[d+17|0]){break he}H[g+176>>2]=c;Oc(g+464|0,16427,g+176|0)}c=c+1|0;e=H[g+480>>2];continue}}H[g+480>>2]=0;H[g+484>>2]=1;H[g+488>>2]=7}d=o+q|0;lf(H[g+536>>2]);Ta(H[g+472>>2]);c=H[g+484>>2];ie:{if(!c){Tf(aa);b=0;break ie}b=Jd(aa)}p=H[g+488>>2];Xb(d);je:{if(c){if(p){break je}e=H[k>>2];c=c-1|0;h=e-c|0;c=H[k+4>>2]-((c>>31)+(c>>>0>e>>>0)|0)|0;H[k>>2]=h;H[k+4>>2]=c;hd(d,b,-1,-1,1,1)}Pd(d,w);break g}Ta(b);break J}d=od(H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+12>>2]+40|0,H[f+16>>2],0);if(!d){break f}ke:{if(H[d+20>>2]!=H[d+24>>2]){break ke}b=St(d);if(!b){break ke}h=b+56|0;while(1){b=h;c=H[b>>2];if(!c){break ke}h=c+32|0;if((c|0)!=(d|0)){continue}break}H[b>>2]=H[h>>2]}Qh(j,d);H[j+24>>2]=H[j+24>>2]|1;break f}d=od(H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+12>>2]+24|0,H[f+16>>2],0);if(d){b=H[d+12>>2];c=H[b+8>>2];le:{me:{if((d|0)==(c|0)){b=b+8|0;break me}while(1){b=c;if(!b){break le}c=H[b+20>>2];if((d|0)!=(c|0)){continue}break}b=b+20|0}H[b>>2]=H[d+20>>2]}Zk(j,d)}H[j+24>>2]=H[j+24>>2]|1;break f}Cd(j,od(H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+12>>2]+8|0,H[f+16>>2],0));H[j+24>>2]=H[j+24>>2]|1;break f}i=Rt(j,H[f+4>>2]);break O}b=H[f+4>>2];ne:{oe:{if(!H[f+16>>2]){Uj(H[(H[j+16>>2]+(b<<4)|0)+12>>2]);H[j+24>>2]=H[j+24>>2]&-17;i=ap(j,b,A,J[f+2>>1]);H[j+24>>2]=H[j+24>>2]|1;G[a+152>>1]=J[a+152>>1]&65532;break oe}H[g+352>>2]=j;H[g+368>>2]=0;H[g+356>>2]=A;H[g+360>>2]=b;b=H[j+16>>2]+(b<<4)|0;H[g+376>>2]=H[H[H[b+4>>2]+4>>2]+48>>2];b=H[b>>2];H[g+168>>2]=H[f+16>>2];H[g+164>>2]=9211;H[g+160>>2]=b;b=mb(j,15048,g+160|0);if(!b){i=7;break ne}F[j+177|0]=1;H[g+372>>2]=0;H[g+364>>2]=0;d=fe(j,b,4,g+352|0,0);i=d?d:H[g+364>>2];if(!(i|H[g+372>>2])){i=Ya(99624)}db(j,b);F[j+177|0]=0}if(!i){break I}}yf(j);if((i|0)!=7){break b}break e}F[j+96|0]=I[j+96|0]+1;H[g+352>>2]=0;b=I[j+94|0];d=H[j+364>>2];if(H[f+4>>2]){F[j+94|0]=0;H[j+364>>2]=0}i=fe(j,H[f+16>>2],0,0,g+352|0);H[j+364>>2]=d;F[j+94|0]=b;F[j+96|0]=I[j+96|0]-1;b=H[g+352>>2];if(!(b|i)){break I}H[g+144>>2]=b;Kc(a,8863,g+144|0);Ta(H[g+352>>2]);if((i|0)!=7){break b}break e}p=0;b=Dc(a,f);H[g+352>>2]=0;i=Pt(H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+4>>2],g+352|0,H[f+12>>2]);if(i){break b}H[b>>2]=H[g+352>>2];H[b+4>>2]=0;break f}d=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];b=H[d+36>>2];if(I[d|0]==1){pu(j,b);break f}p=0;i=Yk(H[b+8>>2],H[b+64>>2],0);if(!i){break f}break b}H[g+352>>2]=0;H[g+356>>2]=0;i=Yk(H[(H[j+16>>2]+(H[f+8>>2]<<4)|0)+4>>2],H[f+4>>2],g+352|0);d=H[f+12>>2];if(!d){break O}k=H[g+356>>2];q=k+H[a+44>>2]|0;b=H[g+352>>2];e=H[a+40>>2];c=b+e|0;H[a+40>>2]=c;H[a+44>>2]=c>>>0<e>>>0?q+1|0:q;if((d|0)<=0){break O}d=N(d,40)+o|0;e=H[d>>2];c=k+H[d+4>>2]|0;k=b;b=b+e|0;c=k>>>0>b>>>0?c+1|0:c;H[d>>2]=b;H[d+4>>2]=c;break O}b=Dc(a,f);G[b+16>>1]=1;if(H[j+188>>2]>(H[j+200>>2]+1|0)){F[a+148|0]=2;i=6;break b}c=H[f+4>>2];h=H[f+12>>2];k=H[(H[j+16>>2]+(h<<4)|0)+4>>2];d=H[k+4>>2];H[d+4>>2]=H[k>>2];e=0;H[g+464>>2]=0;pe:{if(c>>>0>K[d+48>>2]){i=Ya(80307);break pe}i=Yk(k,c,0);if(i){break pe}i=qd(d,c,g+464|0,0);H[g+352>>2]=i;if(i){Eb(H[g+464>>2]);break pe}if(I[d+17|0]){Bh(k,4,g+344|0);m=H[g+344>>2];qe:{if((c|0)==(m|0)){c=H[g+464>>2];Ah(c,g+352|0);Eb(c);i=H[g+352>>2];if(i){break pe}e=0;break qe}Eb(H[g+464>>2]);n=g+340|0;i=qd(d,m,n,0);if(i){break pe}l=H[g+340>>2];i=Eo(d,l,1,0,c,0);Eb(l);if(i){break pe}H[g+340>>2]=0;ma=g,qa=qd(d,m,n,0),H[ma+352>>2]=qa;c=H[g+340>>2];Ah(c,g+352|0);Eb(c);i=H[g+352>>2];if(i){break pe}e=m}c=(K[16644]/K[d+36>>2]|0)+2|0;while(1){i=(c|0)==(m|0);m=m-1|0;if(i){continue}if((Qd(d,m)|0)==(m|0)){continue}break}i=$j(k,4,m);break pe}d=H[g+464>>2];Ah(d,g+352|0);Eb(d);i=H[g+352>>2]}H[b>>2]=e;H[b+4>>2]=e>>31;G[b+16>>1]=4;if(i){break b}p=0;if(!e){break f}d=H[(H[j+16>>2]+(h<<4)|0)+12>>2];c=d+16|0;b=H[f+4>>2];while(1){c=H[c>>2];if(c){k=H[c+8>>2];if(H[k+20>>2]!=(e|0)){continue}H[k+20>>2]=b;continue}break}c=d+32|0;while(1){c=H[c>>2];if(c){d=H[c+8>>2];if(H[d+44>>2]!=(e|0)){continue}H[d+44>>2]=b;continue}break}da=h+1|0;break f}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];H[g+464>>2]=H[b+40>>2];d=H[f+16>>2];F[g+486|0]=c>>>0<42?-1:0;G[g+484>>1]=d;H[g+468>>2]=N(H[f+12>>2],40)+o;b=H[b+36>>2];d=Xh(b);if((d|0)<=0){i=Ya(99344);break b}H[g+376>>2]=0;H[g+372>>2]=j;G[g+368>>1]=0;c=d;d=g+352|0;i=pj(b,c,d);if(i){break b}p=0;b=zh(H[g+364>>2],H[g+360>>2],g+464|0,0);yh(d);if(((F[f|0]&1?b+1|0:0-b|0)|0)>0){break i}break f}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];if(!I[b+3|0]){break f}i=hu(b);break O}c=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];i=Ot(c);if(i){break b}if(!I[c+2|0]){b=H[c+36>>2];d=Xh(b);H[g+376>>2]=0;H[g+372>>2]=j;G[g+368>>1]=0;i=pj(b,d,g+352|0);if(i){break b}b=H[g+360>>2];d=F[b|0];e=d&255;H[g+344>>2]=e;if((d|0)<0){Od(b,g+344|0);e=H[g+344>>2]}re:{se:{if(e>>>0<3){break se}d=H[g+364>>2];if(d>>>0<e>>>0){break se}k=(b+e|0)-1|0;n=F[k|0];h=n&255;H[g+340>>2]=h;if((n|0)<0){Od(k,g+340|0);h=H[g+340>>2]}if((h|0)==7|h-10>>>0<4294967287){break se}k=e;e=I[h+34112|0];if(d>>>0>=k+e>>>0){break re}}yh(g+352|0);i=Ya(89560);break b}Wh(b+(d-e|0)|0,h,g+464|0);b=H[g+464>>2];e=H[g+468>>2];d=e;yh(g+352|0);if(I[f|0]==141){d=H[H[a+96>>2]+(H[f+12>>2]<<2)>>2];H[d+56>>2]=b;H[d+60>>2]=e;G[d+2>>1]=256;p=0;H[d+24>>2]=0;b=H[f+16>>2];H[d+32>>2]=c;H[d+8>>2]=b;break f}c=Dc(a,f);H[c>>2]=b;H[c+4>>2]=d;break I}Xb(N(H[f+8>>2],40)+o|0);break I}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];d=H[b+36>>2];H[g+352>>2]=H[b+40>>2];c=H[f+12>>2];F[g+374|0]=0;G[g+372>>1]=c;H[g+356>>2]=N(H[f+8>>2],40)+o;i=wh(d,g+352|0,g+464|0);if(i){break b}te:{if(!H[g+464>>2]){i=Nt(d,4);if(i){break b}break te}if(!J[f+2>>1]|(H[j+32>>2]&268435457)==1){break te}i=779;Dl(779,99139,10212);break b}H[b+24>>2]=0;H[b+28>>2]=0;break I}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];s=N(H[f+8>>2],40)+o|0;if(I[s+17|0]&4){i=me(s);if(i){break b}}e=H[b+36>>2];b=H[s+8>>2];d=F[b+1|0];h=d&255;H[g+352>>2]=h;if((d|0)<0){Od(b+1|0,g+352|0);h=H[g+352>>2]}ue:{if(!((h|0)==7|h-1>>>0>8)){F[e+68|0]=F[e+68|0]&1;break ue}if(!(!(h&1)|(h|0)<11)){F[e+68|0]=I[e+68|0]&2;break ue}F[e+68|0]=0}r=H[s+12>>2];c=r+8|0;b=r;d=vh(b,b>>31)+b|0;m=d>>31;i=0;b=H[e+4>>2];ve:{if(!b){break ve}we:{if(H[e+44>>2]){n=H[e+56>>2];k=n>>31;if(!(k|n)){break ve}h=b;l=b>>31;b=k;k=c+n|0;b=k>>>0<n>>>0?b+1|0:b;if(h>>>0<k>>>0&(b|0)>=(l|0)|(b|0)>(l|0)){break we}break ve}k=H[e+48>>2];q=b>>>0<k>>>0;h=H[e+52>>2];b=b>>31;if(q&(h|0)>=(b|0)|(b|0)<(h|0)){break we}b=H[e>>2];n=b>>31;if(!H[18236]|((n|0)>=(h|0)&b>>>0>=k>>>0|(h|0)<(n|0))){break ve}}i=Mt(e);H[e+56>>2]=0;H[e+48>>2]=0;H[e+52>>2]=0}q=m+H[e+52>>2]|0;b=d+H[e+48>>2]|0;q=b>>>0<d>>>0?q+1|0:q;H[e+48>>2]=b;H[e+52>>2]=q;if((d|0)>H[e+8>>2]){H[e+8>>2]=d}h=H[e+44>>2];xe:{if(h){k=H[e+40>>2];m=H[e+56>>2];n=c+m|0;d=H[e+60>>2];ye:{if((n|0)<=(d|0)){l=h;break ye}l=n>>31;b=d>>31;while(1){c=b<<1|d>>>31;d=d<<1;b=c;if(n>>>0>d>>>0&(l|0)>=(b|0)|(b|0)<(l|0)){continue}break}m=H[e+4>>2];c=m>>31;q=m;m=d>>>0<m>>>0&(b|0)<=(c|0)|(b|0)<(c|0);d=m?d:q;q=d;T=d>>>0>n>>>0;d=m?b:c;b=d;c=T&(l|0)<=(b|0)|(b|0)>(l|0);b=c?q:n;l=Ld(h,b,c?d:l);if(!l){break d}d=k?k-h|0:-1;ze:{if((d|0)<0){k=H[e+40>>2];break ze}k=d+l|0;H[e+40>>2]=k}H[e+60>>2]=b;H[e+44>>2]=l;m=H[e+56>>2]}H[e+56>>2]=(r+15&-8)+m;h=l+m|0;if(!k){break xe}H[h+4>>2]=k-l;break xe}h=bc(c,0);if(!h){break d}H[h+4>>2]=H[e+40>>2]}Va(h+8|0,H[s+8>>2],H[s+12>>2]);H[h>>2]=H[s+12>>2];H[e+40>>2]=h;break O}b=N(H[f+8>>2],40)+o|0;d=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];h=J[f+2>>1];if(h&1){c=H[a+44>>2];e=H[a+40>>2]+1|0;c=e?c:c+1|0;H[a+40>>2]=e;H[a+44>>2]=c}if(I[b+17|0]&4){i=me(b);if(i){break b}h=J[f+2>>1]}c=H[b+12>>2];H[g+360>>2]=c;H[g+364>>2]=c>>31;H[g+352>>2]=H[b+8>>2];H[g+372>>2]=N(H[f+12>>2],40)+o;G[g+376>>1]=H[f+16>>2];i=Lt(H[d+36>>2],g+352|0,h&138,h&16?H[d+28>>2]:0);H[d+24>>2]=0;break O}c=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];i=Xk(H[c+36>>2]);break Ba}c=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];i=qj(H[c+36>>2]);break Ba}c=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];b=H[c+36>>2];if(I[b+64|0]){H[g+352>>2]=0;i=Kt(H[b+20>>2],g+352|0);if(i|!H[g+352>>2]){break Ba}break za}d=H[b+40>>2];H[b+40>>2]=H[d+4>>2];H[d+4>>2]=0;if(!H[b+44>>2]){Bo(j,d)}if(!H[b+40>>2]){break za}H[c+24>>2]=0;break Aa}H[c+24>>2]=0;if((i|0)==101){break ya}if(i){break b}}p=0;F[c+2|0]=0;b=(J[f+2>>1]<<2)+ea|0;H[b>>2]=H[b>>2]+1;break h}H[c+24>>2]=0}F[c+2|0]=1;p=0;break g}H[a+172>>2]=H[a+172>>2]+1}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];H[g+332>>2]=1;y=H[b+36>>2];T=b;Ae:{Be:{if(I[b|0]==1){if(!I[y+64|0]){b=1;if(!H[y+40>>2]){break Ae}H[g+332>>2]=0;i=Jt(y+72|0,y+40|0);break Be}i=Mt(y);if(i){break b}z=y+72|0;v=0;i=0;n=0;while(1){Ce:{De:{Ee:{Fe:{if(!i){if(I[y+67|0]<=v>>>0){break Fe}m=0;H[g+344>>2]=0;t=z+N(v,80)|0;e=H[t+8>>2];i=e>>31;d=16;b=0;while(1){if(d>>>0<e>>>0&(b|0)<=(i|0)|(b|0)<(i|0)){m=m+1|0;c=b<<4|d>>>28;d=d<<4;b=c;continue}break}H[g+352>>2]=0;H[g+356>>2]=0;if((e|0)<=16){i=It(t,e,g+352|0,g+344|0);q=H[g+344>>2];break Ce}r=0;q=vo(16);i=q?0:7;d=(m|0)<=1?1:m;l=0;while(1){b=H[t+8>>2];if((b|0)<=(r|0)|i){break Ce}H[g+340>>2]=0;b=b-r|0;i=It(t,(b|0)>=16?16:b,g+352|0,g+340|0);if(!i){e=1;i=Ht(t,H[g+340>>2],g+464|0);h=1;c=1;while(1){if((d|0)==(h|0)){k=q;while(1){if(!(e>>>0>=m>>>0|i)){b=H[k+12>>2]+N(((l|0)/(c|0)|0)%16|0,56)|0;h=H[b+48>>2];Ge:{if(!h){i=vo(16);if(!i){i=7;break Ge}i=Ht(t,i,b+48|0);if(i){break Ge}h=H[b+48>>2]}c=(c|0)/16|0;k=H[h+4>>2];i=0}e=e+1|0;continue}break}b=H[g+464>>2];He:{if(!i){H[(H[k+12>>2]+N((l|0)%16|0,56)|0)+48>>2]=b;break He}nu(b)}l=l+1|0}else{h=h+1|0;c=c<<4;continue}break}}r=r+16|0;continue}}Hg(n);break Ee}i=Gt(z,n);H[y+20>>2]=n;if(i){break Ee}i=0;break De}Hg(0)}H[g+332>>2]=0;break Be}Ie:{if(!i){n=q;break Ie}Hg(q)}v=v+1|0;continue}}i=qw(y,g+332|0);H[b+24>>2]=0;F[b+3|0]=0}if(i){break b}b=H[g+332>>2]}F[T+2|0]=b;p=0;if(H[f+8>>2]<=0){break f}if(b){break i}break f}b=H[H[H[a+96>>2]+(H[f+4>>2]<<2)>>2]+36>>2];i=qw(b,g+352|0);if(i){break b}if(H[g+352>>2]){break Z}b=Ft(b);d=Ha;if((d|0)<0){break I}if(H[f+12>>2]>(Kd(b,d)|0)){break Z}break I}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];d=H[b+36>>2];H[g+352>>2]=0;if((c|0)==137){H[b+28>>2]=-1;if(!I[d|0]){break f}}i=uo(d,g+352|0);d=H[g+352>>2];H[b+24>>2]=0;F[b+3|0]=0;F[b+2|0]=d;if(i){break b}p=0;if(H[f+8>>2]<=0){break f}if(d){break Z}break f}b=H[f+4>>2];c=H[H[a+96>>2]+(b<<2)>>2];if(!c){c=Fg(a,b,1,3);if(!c){break e}F[c+4|0]=1;H[c+28>>2]=0;H[c+36>>2]=73316;F[c+5|0]=I[c+5|0]|8}H[c+24>>2]=0;F[c+2|0]=1;if(I[c|0]){break f}al(H[c+36>>2]);break f}b=Dc(a,f);c=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];if(I[c+2|0]){G[b+16>>1]=1;break f}d=b;Je:{if(I[c+3|0]){b=H[c+56>>2];c=H[c+60>>2];break Je}if(I[c|0]==2){c=H[c+36>>2];b=H[c>>2];i=Ia[H[H[b>>2]+48>>2]](c,g+352|0)|0;gf(a,b);if(i){break b}p=0;b=H[g+352>>2];c=H[g+356>>2];break Je}i=Ot(c);if(i){break b}if(I[c+2|0]){G[b+16>>1]=1;break I}p=0;b=bl(H[c+36>>2]);c=Ha}H[d>>2]=b;H[d+4>>2]=c;break f}b=Dc(a,f);c=H[H[H[a+96>>2]+(H[f+4>>2]<<2)>>2]+36>>2];d=Xh(c);if(d>>>0>K[j+120>>2]){break s}i=pj(c,d,b);if(i){break b}p=0;if(H[f+12>>2]|!(I[b+17|0]&64)){break f}if(!fg(b)){break f}break e}b=H[f+8>>2];c=Et(H[H[H[a+96>>2]+(H[f+4>>2]<<2)>>2]+36>>2],g+352|0);b=N(b,40)+o|0;d=H[g+352>>2];if(Yh(b,d)){break d}H[b+12>>2]=d;G[b+16>>1]=J[b+16>>1]&62016|16;Va(H[b+8>>2],c,d);p=0;H[H[H[a+96>>2]+(H[f+12>>2]<<2)>>2]+24>>2]=0;break f}e=H[f+12>>2];b=H[f+16>>2];c=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];d=H[c+40>>2];c=H[c+36>>2];h=H[c+32>>2];if(!h){h=Vk(d);H[c+32>>2]=h;if(!h){break d}G[h+20>>1]=b}e=N(e,40)+o|0;c=Et(c,g+352|0);Si(d,H[g+352>>2],c,h);c=0;b=(b|0)>0?b:0;while(1){if((b|0)!=(c|0)){d=N(c,40);c=c+1|0;if(!(F[(H[h+4>>2]+d|0)+16|0]&1)){continue}break Z}break}p=0;if(Ri(H[e+12>>2],H[e+8>>2],h)){break i}break f}b=H[a+44>>2];d=H[a+40>>2];H[j+104>>2]=d;H[j+108>>2]=b;b=H[j+116>>2]+b|0;c=H[j+112>>2];d=c+d|0;H[j+112>>2]=d;H[j+116>>2]=c>>>0>d>>>0?b+1|0:b;H[a+40>>2]=0;H[a+44>>2]=0;break f}d=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];b=H[f+8>>2];e=0;Ke:{if(I[f+1|0]!=251){k=0;break Ke}k=0;if(!H[j+248>>2]){break Ke}k=H[H[j+16>>2]+(F[d+1|0]<<4)>>2];e=H[f+16>>2];if(!(I[f+2|0]&2)|!I[d+4|0]){break Ke}ma=d,qa=bl(H[d+36>>2]),H[ma+56>>2]=qa;H[d+60>>2]=Ha}i=Nt(H[d+36>>2],I[f+2|0]);H[d+24>>2]=0;H[d+28>>2]=0;if(i){break b}V=V+1|0;p=0;if(!(b&1)){break f}b=H[a+44>>2];c=H[a+40>>2]+1|0;b=c?b:b+1|0;H[a+40>>2]=c;H[a+44>>2]=b;b=H[j+248>>2];if(I[e+28|0]&128|(!b|!e)){break f}Ia[b|0](H[j+244>>2],9,k,H[e>>2],H[d+56>>2],H[d+60>>2]);break f}b=H[a+96>>2];k=H[b+(H[f+8>>2]<<2)>>2];c=H[b+(H[f+4>>2]<<2)>>2];b=H[f+12>>2];if(b){d=N(b,40)+o|0;b=H[d>>2];d=H[d+4>>2]}else{b=0;d=0}e=H[c+36>>2];n=H[e+20>>2];c=H[n+84>>2];s=H[k+36>>2];Ig(s);k=H[s+44>>2];Le:{if(k>>>0<=127){F[c|0]=k;m=c+1|0;break Le}m=ff(c,k,0)+c|0}if(!H[e+112>>2]){m=ff(m,b,d)+m|0}c=J[s+48>>1];k=H[s+40>>2];d=c+k|0;q=H[H[s+116>>2]+60>>2];if(d>>>0>q>>>0){i=Ya(79714);break b}r=H[s+44>>2];h=H[e+116>>2];l=J[h+14>>1];if(!((r|0)!=(c|0)|l>>>0<=c>>>0)){ma=n,qa=(Va(m,k,c)+c|0)-H[n+84>>2]|0,H[ma+88>>2]=qa;break I}H[g+352>>2]=0;y=H[H[s+20>>2]>>2];H[g+464>>2]=0;e=r;if(l>>>0<e>>>0){b=J[h+16>>1];i=b;b=uJ(e-b|0,0-(b>>>0>e>>>0)|0,H[H[h+52>>2]+40>>2]-4|0,0)+b|0;e=(b|0)>(l|0)?i:b}b=(m-H[n+84>>2]|0)+e|0;i=b+4|0;h=b;b=e>>>0<r>>>0;H[n+88>>2]=b?i:h;l=0;if(c>>>0<r>>>0){if(q>>>0<d+4>>>0){i=Ya(79739);break b}l=cb(d)}q=b?e+m|0:0;v=0;while(1){r=r-e|0;while(1){if(c){b=c>>>0>e>>>0?e:c;d=Va(m,k,b);k=b+k|0;m=b+d|0;e=e-b|0;c=c-b|0}else{c=0}Me:{if(!e){i=H[g+352>>2];h=!i;break Me}jd(H[g+464>>2]);h=0;H[g+464>>2]=0;i=Ia[H[y+220>>2]](y,l,g+464|0,2)|0;H[g+352>>2]=i;if(i){break Me}b=H[H[g+464>>2]+4>>2];k=b+4|0;l=cb(b);c=H[H[s+20>>2]+40>>2]-4|0;continue}break}if(!(!q|(!h|!r))){H[g+340>>2]=0;ma=g,qa=jf(n,g+340|0,g+344|0,0,0),H[ma+352>>2]=qa;b=H[g+344>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[q|0]=b;F[q+1|0]=b>>>8;F[q+2|0]=b>>>16;F[q+3|0]=b>>>24;if(!(!I[n+17|0]|!v)){Ad(n,H[g+344>>2],4,H[v+4>>2],g+352|0)}Eb(v);v=H[g+340>>2];if(v){q=H[v+56>>2];F[q|0]=0;F[q+1|0]=0;F[q+2|0]=0;F[q+3|0]=0;m=q+4|0;b=H[n+40>>2]-4|0;e=b>>>0<r>>>0?b:r}i=H[g+352>>2]}if(i?0:r){continue}break}Eb(v);jd(H[g+464>>2]);break O}e=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];b=H[f+8>>2];c=N(H[f+12>>2],40)+o|0;d=H[c>>2];c=H[c+4>>2];l=c;H[g+360>>2]=d;H[g+364>>2]=c;i=N(b,40);k=0;c=0;Ne:{if(I[f+1|0]!=251){break Ne}c=0;if(!H[j+248>>2]){break Ne}k=H[f+16>>2];c=H[H[j+16>>2]+(F[e+1|0]<<4)>>2]}h=i+o|0;n=J[f+2>>1];Oe:{if(!(n&1)){break Oe}b=H[a+44>>2];i=H[a+40>>2]+1|0;b=i?b:b+1|0;H[a+40>>2]=i;H[a+44>>2]=b;if(!(n&32)){break Oe}H[j+40>>2]=d;H[j+44>>2]=l}H[g+368>>2]=H[h+8>>2];H[g+380>>2]=H[h+12>>2];i=0;m=0;m=n&16?H[e+28>>2]:m;i=I[h+17|0]&4?H[h>>2]:i;H[g+352>>2]=0;H[g+384>>2]=i;i=Lt(H[e+36>>2],g+352|0,n&138,m);H[e+24>>2]=0;F[e+3|0]=0;if(i){break b}if(k){Ia[H[j+248>>2]](H[j+244>>2],J[f+2>>1]&4?23:18,c,H[k>>2],d,l)}V=V+1|0;break I}H[g+352>>2]=0;H[g+356>>2]=0;H[g+464>>2]=0;k=Dc(a,f);e=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];if(!(I[e+5|0]&2)){i=uo(H[e+36>>2],g+464|0);if(i){break b}Pe:{if(H[g+464>>2]){H[g+352>>2]=1;H[g+356>>2]=0;break Pe}d=bl(H[e+36>>2]);H[g+352>>2]=d;b=Ha;H[g+356>>2]=b;if((d|0)==-1&(b|0)==2147483647){F[e+5|0]=I[e+5|0]|2;break Pe}d=d+1|0;b=d?b:b+1|0;H[g+352>>2]=d;H[g+356>>2]=b}p=0}d=H[f+12>>2];if(d){c=H[W>>2];if(c){while(1){b=c;c=H[b+4>>2];if(c){continue}break}b=H[b+12>>2]}else{b=o}c=b+N(d,40)|0;Eh(c);i=13;d=H[c>>2];b=H[c+4>>2];if((d|0)==-1&(b|0)==2147483647|I[e+5|0]&2){break b}q=H[g+356>>2];h=q;n=H[g+352>>2];if((h|0)<=(b|0)&n>>>0<=d>>>0|(b|0)>(h|0)){n=d+1|0;b=n?b:b+1|0;q=b;H[g+352>>2]=n;H[g+356>>2]=b}H[c>>2]=n;H[c+4>>2]=q}Qe:{if(I[e+5|0]&2){c=0;while(1){Re:{we(8,g+352|0);q=H[g+356>>2]&1073741823;b=H[g+352>>2]+1|0;q=b?q:q+1|0;H[g+352>>2]=b;H[g+356>>2]=q;b=uh(H[e+36>>2],b,q,0,g+464|0);d=H[g+464>>2];if(b|d){break Re}h=c>>>0<99;c=c+1|0;if(h){continue}}break}if(b){break Qe}p=0;if(!d){break Qe}}H[e+24>>2]=0;F[e+3|0]=0;b=H[g+356>>2];H[k>>2]=H[g+352>>2];H[k+4>>2]=b;break f}i=b?b:13;break b}d=Dc(a,f);c=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];e=c;b=H[c+16>>2];c=H[c+20>>2];k=c;h=b+1|0;c=h?c:c+1|0;H[e+16>>2]=h;H[e+20>>2]=c;H[d>>2]=b;H[d+4>>2]=k;break f}c=H[f+12>>2];break ga}c=H[f+12>>2];b=N(c,40)+o|0;if(I[b+16|0]&36){break ga}d=g+352|0;Va(d,b,40);ve(d,67,w);if(!(J[g+368>>1]&4)){break i}b=H[g+352>>2];c=H[g+356>>2];break fa}d=N(c,40)+o|0;b=H[d>>2];c=H[d+4>>2]}d=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];e=H[d+36>>2];p=0;H[g+336>>2]=0;i=uh(e,b,c,0,g+336|0);H[d+24>>2]=0;H[d+56>>2]=b;H[d+60>>2]=c;G[d+2>>1]=0;b=H[g+336>>2];H[d+28>>2]=b;if(b){if(H[f+8>>2]){p=i;break i}i=Ya(98057);break b}if(!i){break f}break b}if(H[f+16>>2]<=J[H[H[a+96>>2]+(H[f+4>>2]<<2)>>2]+6>>1]){break f}}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];d=N(H[f+12>>2],40)+o|0;H[g+356>>2]=d;c=H[f+16>>2];G[g+372>>1]=c;Se:{if(c&65535){d=H[b+40>>2];F[g+374|0]=0;H[g+352>>2]=d;i=wh(H[b+36>>2],g+352|0,b+28|0);break Se}if(I[d+17|0]&4){if(me(d)){break e}}d=Vk(H[b+40>>2]);if(!d){break e}c=H[g+356>>2];Si(H[b+40>>2],H[c+12>>2],H[c+8>>2],d);F[d+22|0]=0;i=wh(H[b+36>>2],d,b+28|0);db(j,d)}if(i){break b}H[b+24>>2]=0;F[b+3|0]=0;d=H[b+28>>2];F[b+2|0]=(d|0)!=0;c=I[f|0];if((c|0)==29){if(!d){break Z}break I}if(d){break Z}Te:{switch(c-26|0){case 1:c=0;b=H[g+356>>2];d=J[g+372>>1];while(1){if((c|0)==(d|0)){break I}e=N(c,40);c=c+1|0;if(!(F[(b+e|0)+16|0]&1)){continue}break};break Z;case 0:break Te;default:break I}}G[b+6>>1]=H[f+16>>2];break I}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];if(!b|I[b+2|0]){break h}break f}d=H[f+8>>2];b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];c=J[b+6>>1];if((d|0)>(c|0)){G[b+6>>1]=d;break f}d=H[f+12>>2];if((d|0)>=(c|0)){break f}G[b+6>>1]=d;break f}b=H[H[a+96>>2]+(H[f+24>>2]<<2)>>2];if(I[H[b+36>>2]]){break f}k=f+20|0;h=H[f+4>>2];H[g+464>>2]=H[b+40>>2];d=H[f+36>>2];F[g+486|0]=0;G[g+484>>1]=d;H[g+468>>2]=N(H[f+32>>2],40)+o;Ue:{while(1){d=H[b+36>>2];c=Xh(d);if((c|0)<=0){i=Ya(89593);break b}H[g+376>>2]=0;H[g+372>>2]=j;G[g+368>>1]=0;e=c;c=g+352|0;i=pj(d,e,c);if(i){break b}d=zh(H[g+364>>2],H[g+360>>2],g+464|0,0);yh(c);if((d|0)>0){k=J[f+2>>1]?f:k;break Ue}if((d|0)>=0){k=f;break Ue}if((h|0)<=0){break $}H[b+24>>2]=0;h=h-1|0;i=qj(H[b+36>>2]);if(!i){continue}break}if((i|0)!=101){break b}}p=0;f=k;break i}p=0;break f}d=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];H[d+24>>2]=0;G[d+2>>1]=0;Ve:{We:{Xe:{Ye:{if(I[d+4|0]){e=N(H[f+12>>2],40)+o|0;n=J[e+16>>1];if((n&46)==2){nj(e,0)}b=kb(e);h=Ha;k=J[e+16>>1];G[e+16>>1]=n;Ze:{if(k&36){break Ze}if(!(k&8)){if(k&1|c>>>0>22){break i}l=0;i=uo(H[d+36>>2],g+464|0);if(i){break b}break Xe}e=Qi(b,h,M[e>>3]);if((e|0)>0){c=((c&1)+c|0)-1|0;break Ze}c=((e|0)!=0&c)+c|0}k=0;i=uh(H[d+36>>2],b,h,0,g+464|0);H[d+56>>2]=b;H[d+60>>2]=h;if(!i){break Ye}break b}l=1;b=H[d+36>>2];e=I[b+3|0];i=H[d+40>>2];k=H[f+16>>2];F[g+374|0]=c&1?1:-1;G[g+372>>1]=k;H[g+352>>2]=i;i=H[f+12>>2];F[g+378|0]=0;H[g+356>>2]=N(i,40)+o;i=wh(b,g+352|0,g+464|0);if(i){break b}b=e&2;k=b>>>1|0;if(!b){break Ye}if(!I[g+378|0]){break Xe}}b=H[g+464>>2];if(c>>>0>=23){if(b|(c|0)!=24?(b|0)>=0:0){break Ve}i=qj(H[d+36>>2]);if(!i){break Ve}if((i|0)==101){break Z}break b}if(!(b|(c|0)!=21?(b|0)<=0:0)){i=Xk(H[d+36>>2]);if(!i){break Ve}if((i|0)!=101){break b}break Z}b=I[H[d+36>>2]]!=0;break We}k=l;b=H[g+464>>2]}if(b){break Z}}p=0;f=(k?20:0)+f|0;break f}p=0;break i}c=H[a+96>>2];e=H[f+4>>2];b=H[c+(e<<2)>>2];if(b){Wi(a,b);e=H[f+4>>2];c=H[a+96>>2]}H[c+(e<<2)>>2]=0;break f}b=Fg(a,H[f+4>>2],H[f+12>>2],3);if(!b){break e}F[b+2|0]=1;d=H[f+8>>2];H[b+36>>2]=73316;F[b+4|0]=1;H[b+28>>2]=d;break f}b=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];c=b;d=H[b+16>>2];b=H[b+20>>2];e=b;k=d+1|0;b=k?b:b+1|0;H[c+16>>2]=k;H[c+20>>2]=b;if(!(d|e)){break i}break f}d=Fg(a,H[f+4>>2],H[f+8>>2],1);if(!d){break e}b=H[f+16>>2];H[d+40>>2]=b;c=H[f+12>>2];i=J[b+6>>1]<<2;b=nb(j,i+172|0,0);H[d+36>>2]=b;if(!b){break d}e=H[H[j+16>>2]+4>>2];k=b+152|0;H[b+28>>2]=k;Va(k,H[d+40>>2],i+20|0);i=0;H[b+164>>2]=0;if(c){G[b+158>>1]=c}d=H[e+4>>2];H[d+4>>2]=H[e>>2];d=H[d+36>>2];F[b+67|0]=1;H[b+12>>2]=d;F[b+65|0]=0;F[b+66|0]=255;H[b+24>>2]=j;H[b+84>>2]=b;_e:{if(I[j+86|0]==2){break _e}c=N(d,H[16531]);H[b>>2]=c;e=d>>31;n=e;k=H[H[H[j+16>>2]+12>>2]+80>>2];h=k>>31;l=(h|0)<0;e=sJ(l?-1024:d,l?-1:e,k,h);k=Ha;if((k|0)>0){k=1}else{k=(k|0)>=0&e>>>0>=536870912}e=k?536870912:e;H[b+4>>2]=(c|0)>(e|0)?c:e;if(I[65928]){break _e}H[b+60>>2]=d;d=bc(d,n);H[b+44>>2]=d;i=d?0:7}if(J[b+160>>1]>12){break O}d=H[b+172>>2];if(I[H[b+168>>2]]&2|((d|0)!=H[j+8>>2]?d:0)){break O}F[b+68|0]=3;break O}b=H[f+12>>2];if((b|0)>0){b=N(b,40)+o|0;H[b+8>>2]=30558;H[b+12>>2]=0}b=H[f+4>>2];c=H[H[a+96>>2]+(b<<2)>>2];$e:{if(!(!(!c|I[c+5|0]&8)&H[f+8>>2]<=G[c+52>>1])){c=Fg(a,b,H[f+8>>2],0);if(!c){break e}F[c+5|0]=I[c+5|0]|1;i=gj(H[j>>2],0,j,c+8|0,J[f+2>>1]|5,1054);if(i){break b}i=zf(H[c+8>>2],1,0);if(!i){b=H[f+16>>2];H[c+40>>2]=b;af:{if(b){k=0;i=Pt(H[c+8>>2],c+48|0,J[f+2>>1]|2);if(i){break af}i=Uk(H[c+8>>2],H[c+48>>2],4,b,H[c+36>>2]);break af}k=1;H[c+48>>2]=1;i=Uk(H[c+8>>2],1,4,0,H[c+36>>2])}F[c+4|0]=k}F[c+5|0]=I[c+5|0]&251|(J[f+2>>1]!=8)<<2;if(!i){break $e}rf(H[c+8>>2]);break b}H[c+24>>2]=0;H[c+16>>2]=0;H[c+20>>2]=0;i=Yk(H[c+8>>2],H[c+48>>2],0);if(i){break b}}F[c+2|0]=1;break I}d=H[H[a+96>>2]+(H[f+8>>2]<<2)>>2];b=Fg(a,H[f+4>>2],G[d+52>>1],0);if(!b){break e}F[b+2|0]=1;c=I[b+5|0]|1;F[b+5|0]=c;H[b+40>>2]=H[d+40>>2];F[b+4|0]=I[d+4|0];H[b+48>>2]=H[d+48>>2];c=I[d+5|0]&4|c&-5;F[b+5|0]=c;e=H[d+8>>2];F[b+5|0]=c|8;H[b+8>>2]=e;F[d+5|0]=I[d+5|0]|8;p=Uk(H[b+8>>2],H[b+48>>2],4,H[b+40>>2],H[b+36>>2]);break f}e=H[H[a+96>>2]+(H[f+4>>2]<<2)>>2];if(!e|H[e+48>>2]!=H[f+8>>2]){break R}al(H[e+36>>2]);break Q}if((J[a+152>>1]&3)==1){i=516;break b}d=H[f+12>>2];e=H[j+16>>2]+(d<<4)|0;n=H[e+4>>2];b=J[f+2>>1];h=H[f+8>>2];k=0;bf:{if((c|0)!=113){break bf}k=b&8|4;c=I[H[e+12>>2]+76|0];if(c>>>0>=I[a+149|0]){break bf}F[a+149|0]=c}if(b&16){b=N(h,40)+o|0;Eh(b);h=H[b>>2]}b=H[f+4>>2];l=I[f+1|0];cf:{if((l|0)!=253){c=0;e=0;if((l|0)!=248){break cf}c=H[f+16>>2];e=J[c+8>>1];break cf}c=0;e=H[f+16>>2]}e=Fg(a,b,e,0);if(!e){break e}F[e+2|0]=1;F[e+1|0]=d;H[e+48>>2]=h;F[e+5|0]=I[e+5|0]|4;p=Uk(n,h,k,c,H[e+36>>2]);H[e+40>>2]=c;F[e+4|0]=I[f+1|0]!=248}F[H[e+36>>2]+3|0]=I[f+2|0]&3;if(p){break J}break I}b=H[j+16>>2]+(H[f+4>>2]<<4)|0;i=$j(H[b+4>>2],H[f+8>>2],H[f+12>>2]);df:{ef:{switch(H[f+8>>2]-1|0){case 0:H[H[b+12>>2]>>2]=H[f+12>>2]-J[f+2>>1];H[j+24>>2]=H[j+24>>2]|1;e=H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+12>>2]+16|0;ff:while(1){e=H[e>>2];if(!e){break df}b=H[e+8>>2];if(I[b+43|0]){continue}c=b+48|0;while(1){b=H[c>>2];if(!b){continue ff}Pi(j,H[b+28>>2]);H[b+28>>2]=0;Pi(j,H[b+32>>2]);H[b+32>>2]=0;c=b+4|0;continue}};case 1:break ef;default:break df}}F[H[b+12>>2]+76|0]=H[f+12>>2]}if(H[f+4>>2]!=1){break O}_f(j,0);G[a+152>>1]=J[a+152>>1]&65532}if(!i){break I}break b}Bh(H[(H[j+16>>2]+(H[f+4>>2]<<4)|0)+4>>2],H[f+12>>2],g+352|0);b=Dc(a,f);d=H[g+352>>2];H[b>>2]=d;H[b+4>>2]=d>>31;break f}H[g+352>>2]=0;gf:{d=H[f+8>>2];if(!d){break gf}b=H[j+32>>2]&1048576;if(!(b|H[j+36>>2]&2)){break gf}p=b?8:11;break J}c=H[j+16>>2]+(H[f+4>>2]<<4)|0;b=H[c+4>>2];hf:{if(b){p=zf(b,d,g+352|0);if(p){if((p&255)!=5){break J}H[a+36>>2]=p;H[a+32>>2]=(f-u|0)/20;break j}if(!(I[a+152|0]&32)|!H[f+8>>2]|(H[j+188>>2]<2?I[j+85|0]:0)){break hf}e=H[a+48>>2];if(!e){d=H[j+508>>2]+1|0;H[j+508>>2]=d;e=d+H[j+504>>2]|0;H[a+48>>2]=e}p=Ui(j,0,e-1|0);if(!p){d=H[a+48>>2];e=H[b+4>>2];H[e+4>>2]=H[b>>2];p=Dq(H[e>>2],d)}b=H[j+516>>2];H[a+72>>2]=H[j+512>>2];H[a+76>>2]=b;b=H[j+524>>2];H[a+80>>2]=H[j+520>>2];H[a+84>>2]=b}if(p){break J}}if(!J[f+2>>1]|H[g+352>>2]==H[f+12>>2]&H[H[c+12>>2]+4>>2]==H[f+16>>2]){break I}Za(j,H[A>>2]);ma=A,qa=Tb(j,16390),H[ma>>2]=qa;b=H[f+4>>2];if(H[H[(H[j+16>>2]+(b<<4)|0)+12>>2]>>2]!=H[g+352>>2]){lj(j,b)}G[a+152>>1]=J[a+152>>1]&65516|1;p=17;break J}d=H[f+8>>2];b=H[f+4>>2];jf:{if((b|0)!=I[j+85|0]){c=j;kf:{if(d){Wg(j,516);e=1;break kf}if(!(!b|H[j+192>>2]<=0)){i=5;b=4364;break jf}p=Vi(a,1);if(p){break j}e=b}F[c+85|0]=e;p=5;if((vj(a)|0)==5){H[a+32>>2]=(f-u|0)/20;F[j+85|0]=1-b;break k}Gj(j);p=H[a+36>>2]?1:101;break j}i=1;b=b?d?12907:12866:10461}Kc(a,b,0);break b}k=H[f+16>>2];e=0;c=_;d=H[f+4>>2];lf:{if(!d){if(H[j+192>>2]>0){Kc(a,4259,0);i=5;break b}d=bb(k);i=Ui(j,0,H[j+504>>2]+H[j+508>>2]|0);if(i){break b}b=Nb(j,d+33|0,0);if(!b){break lf}c=b+32|0;H[b>>2]=c;Va(c,k,d+1|0);mf:{if(I[j+85|0]){F[j+93|0]=1;F[j+85|0]=0;break mf}H[j+504>>2]=H[j+504>>2]+1}H[b+24>>2]=H[j+492>>2];H[j+492>>2]=b;d=H[j+516>>2];H[b+8>>2]=H[j+512>>2];H[b+12>>2]=d;d=H[j+524>>2];H[b+16>>2]=H[j+520>>2];H[b+20>>2]=d;break lf}while(1){b=H[c>>2];if(!b){break H}if(ab(H[b>>2],k)){c=b+24|0;e=e+1|0;continue}break}if(!((d|0)!=1|H[j+192>>2]<=0)){Kc(a,4310,0);i=5;break b}m=0;l=0;nf:{of:{pf:{if(H[b+24>>2]){break pf}c=I[j+93|0];l=(c|0)!=0;if(!c|(d|0)!=1){break pf}p=Vi(a,1);if(p){break j}F[j+85|0]=1;p=5;if((vj(a)|0)==5){H[a+32>>2]=(f-u|0)/20;F[j+85|0]=0;break k}i=H[a+36>>2];if(!i){break of}F[j+85|0]=0;break b}c=H[j+504>>2];qf:{if((d|0)!=2){break qf}m=H[j+24>>2]&1;k=!m;h=0;while(1){if(H[j+20>>2]<=(h|0)){break qf}i=h<<4;p=0;h=h+1|0;i=ax(H[(H[j+16>>2]+i|0)+4>>2],516,k);if(!i){continue}break}break b}e=(e^-1)+c|0;h=0;while(1){if(H[j+20>>2]>(h|0)){c=h<<4;p=0;h=h+1|0;i=Ao(H[(H[j+16>>2]+c|0)+4>>2],d,e);if(!i){continue}break b}break}if(m){_f(j,0);yf(j);H[j+24>>2]=H[j+24>>2]|1}if(!p){break nf}break J}F[j+93|0]=0;l=1}while(1){c=H[_>>2];if((c|0)!=(b|0)){H[j+492>>2]=H[c+24>>2];Za(j,c);H[j+504>>2]=H[j+504>>2]-1;continue}break}rf:{sf:{if((d|0)==1){H[j+492>>2]=H[b+24>>2];db(j,b);if(l){break sf}H[j+504>>2]=H[j+504>>2]-1;break rf}c=H[b+12>>2];H[j+512>>2]=H[b+8>>2];H[j+516>>2]=c;c=H[b+20>>2];H[j+520>>2]=H[b+16>>2];H[j+524>>2]=c}if((d|0)!=2&l){break lf}}i=Ui(j,d,e);if(i){break b}}if(I[a+151|0]!=3){break I}p=101;break j}i=p;break b}p=0;break f}H[g+128>>2]=k;Kc(a,7594,g+128|0)}i=1;break b}k=H[H[H[a+96>>2]+(H[f+4>>2]<<2)>>2]+36>>2];tf:{if(H[f+12>>2]){d=Ft(k);b=Ha;break tf}p=0;uf:{i=Qf(k);if((i|0)==16){break uf}d=0;b=0;while(1){if(i){break b}if(H[j+296>>2]){break uf}vf:{e=H[k+116>>2];wf:{if(!I[e+8|0]){h=J[e+24>>1];if(I[e+1|0]){break wf}c=h&65535;d=c+d|0;b=c>>>0>d>>>0?b+1|0:b;break wf}e=J[e+24>>1];d=e+d|0;b=d>>>0<e>>>0?b+1|0:b;while(1){if(!I[k+68|0]){break vf}to(k);e=H[k+116>>2];h=J[e+24>>1];c=J[k+70>>1];if(h>>>0<=c>>>0){continue}break}G[k+70>>1]=c+1}c=J[k+70>>1];xf:{if((c|0)==(h&65535)){c=cb((H[e+56>>2]+I[e+9|0]|0)+8|0);break xf}c=H[e+64>>2]+(c<<1)|0;c=cb(H[e+56>>2]+(J[e+26>>1]&(I[c|0]<<8|I[c+1|0]))|0)}i=Dg(k,c);continue}break}i=Qf(k);if(i){break b}break tf}d=0;b=0}c=Dc(a,f);H[c>>2]=d;H[c+4>>2]=b;break g}e=N(H[f+4>>2],40)+o|0;l=e+N(H[f+8>>2],40)|0;d=N(H[f+12>>2],40);k=H[f+16>>2];if(k){h=I[k|0];c=e;while(1){ve(c,h<<24>>24,w);b=k;yf:{if(I[b|0]!=69){break yf}k=J[c+16>>1];if(!(k&4)){break yf}G[c+16>>1]=k&65499|32}c=c+40|0;k=b+1|0;h=I[b+1|0];if(h){continue}break}}s=d+o|0;k=0;n=0;q=0;d=0;b=0;t=l-40|0;h=t;while(1){r=h;y=J[h+16>>1];zf:{if(y&1){H[h+28>>2]=y<<21>>31&10;k=k+1|0;break zf}if(y&36){k=k+1|0;h=H[r>>2];l=H[r+4>>2];c=l>>31;m=c^h;c=c^l;if(!c&m>>>0<=127){if(!(!l&h>>>0>1|(l|0)!=0|I[a+149|0]<4)){H[r+28>>2]=h|8;break zf}H[r+28>>2]=1;d=d+1|0;b=d?b:b+1|0;break zf}if(!c&m>>>0<=32767){H[r+28>>2]=2;d=d+2|0;b=d>>>0<2?b+1|0:b;break zf}if(!c&m>>>0<=8388607){H[r+28>>2]=3;d=d+3|0;b=d>>>0<3?b+1|0:b;break zf}if(!c&m>>>0<=2147483647){H[r+28>>2]=4;d=d+4|0;b=d>>>0<4?b+1|0:b;break zf}if((c|0)==32767|c>>>0<32767){H[r+28>>2]=5;d=d+6|0;b=d>>>0<6?b+1|0:b;break zf}d=d+8|0;b=d>>>0<8?b+1|0:b;if(y&32){H[r+28>>2]=7;M[r>>3]=+(h>>>0)+ +(l|0)*4294967296;G[r+16>>1]=y&65495|8;break zf}H[r+28>>2]=6;break zf}if(y&8){H[r+28>>2]=7;d=d+8|0;b=d>>>0<8?b+1|0:b;k=k+1|0;break zf}m=H[r+12>>2];l=(y>>>1&1|m<<1)+12|0;Af:{if(!(y&1024)){break Af}c=H[r>>2];l=(c<<1)+l|0;if(b|d){if(me(r)){break e}m=H[r>>2]+m|0;break Af}q=(c>>31)+q|0;n=c+n|0;q=n>>>0<c>>>0?q+1|0:q}H[r+28>>2]=l;d=d+m|0;b=d>>>0<m>>>0?b+1|0:b;k=vh(l,0)+k|0}h=r-40|0;if((e|0)!=(r|0)){continue}break}c=d;if((k|0)<=126){d=k+1|0}else{d=k;k=vh(k,0);d=d+k|0;d=((vh(d,d>>31)|0)>(k|0))+d|0}k=d>>31;b=k+b|0;h=c+d|0;c=q+(h>>>0<d>>>0?b+1|0:b)|0;b=h+n|0;c=b>>>0<n>>>0?c+1|0:c;l=H[s+24>>2];m=l>>31;Bf:{if((c|0)<=(m|0)&b>>>0<=l>>>0|(c|0)<(m|0)){H[s+8>>2]=H[s+32>>2];break Bf}m=b;b=H[j+120>>2];m=m>>>0>b>>>0;b=b>>31;if(m&(b|0)<=(c|0)|(b|0)<(c|0)){break s}if(Yh(s,h)){break e}}G[s+16>>1]=16;H[s+12>>2]=h;if(n|q){G[s+16>>1]=1040;H[s>>2]=n}b=H[s+8>>2];Cf:{if((d|0)<=127){F[b|0]=d;h=b+1|0;break Cf}h=ff(b,d,k)+b|0}k=b+d|0;while(1){n=e;c=H[e+28>>2];Df:{if(c>>>0<=7){F[h|0]=c;h=h+1|0;if(!c){break Df}d=H[e>>2];b=H[e+4>>2];Ef:{Ff:{Gf:{Hf:{If:{Jf:{e=I[c+34112|0];switch(e-1|0){case 0:break Ef;case 1:break Ff;case 2:break Gf;case 3:break Hf;case 5:break If;default:break Jf}}c=d<<8|(d&65280)>>>8;F[k+6|0]=c;F[k+7|0]=c>>>8;d=(b&65535)<<16|d>>>16;b=b>>>16|0}c=d<<8|(d&65280)>>>8;F[k+4|0]=c;F[k+5|0]=c>>>8;d=(b&65535)<<16|d>>>16;b=b>>>16|0}F[k+3|0]=d;c=b;b=b>>>8|0;d=(c&255)<<24|d>>>8}F[k+2|0]=d;d=(b&255)<<24|d>>>8;b=b>>>8|0}F[k+1|0]=d;d=(b&255)<<24|d>>>8}F[k|0]=d;k=e+k|0;break Df}if(c>>>0<=127){F[h|0]=c;h=h+1|0;if(c>>>0<14){break Df}b=H[n+12>>2];if((b|0)<=0){break Df}k=Va(k,H[n+8>>2],b)+H[n+12>>2]|0;break Df}h=ff(h,c,0)+h|0;b=H[n+12>>2];if(!b){break Df}k=Va(k,H[n+8>>2],b)+H[n+12>>2]|0}e=n+40|0;if((n|0)!=(t|0)){continue}break}break f}c=N(H[f+4>>2],40)+o|0;h=H[f+16>>2];e=I[h|0];while(1){ve(c,e<<24>>24,w);b=h;Kf:{if(I[b|0]!=69){break Kf}e=J[c+16>>1];if(!(e&4)){break Kf}d=H[c>>2];k=H[c+4>>2];Lf:{if(k+32768>>>0<65536){m=65499;d=32;break Lf}M[c>>3]=+(d>>>0)+ +(k|0)*4294967296;m=65521;d=8}G[c+16>>1]=d|e&m}c=c+40|0;h=b+1|0;e=I[b+1|0];if(e){continue}break}break f}e=N(H[f+4>>2],40)+o|0;k=H[f+16>>2];h=H[k+4>>2];c=0;while(1){if(G[k+34>>1]<=(c|0)){break f}Mf:{Nf:{b=h+N(c,12)|0;d=J[b+10>>1];if(!(d&96)){break Nf}if(d&32){break Mf}if(!H[f+12>>2]){break Nf}e=e+40|0;break Mf}ve(e,F[b+5|0],w);Of:{d=J[e+16>>1];if(d&1){break Of}Pf:{Qf:{Rf:{Sf:{Tf:{n=I[b+4|0]>>>4|0;switch(n-2|0){case 0:break Qf;case 3:break Rf;case 4:break Sf;case 1:case 2:break Tf;default:break Of}}if(d&4){break Of}break Pf}if(d&2){break Of}break Pf}Uf:{Vf:{if(d&4){b=H[e>>2];n=H[e+4>>2];q=n+32768|0;if((q|0)==65536|q>>>0>65536){break Vf}m=65499;b=32;break Uf}if(d&40){break Of}break Pf}M[e>>3]=+(b>>>0)+ +(n|0)*4294967296;m=65523;b=8}G[e+16>>1]=b|d&m;break Of}if(d&16){break Of}}c=H[(n<<2)+67052>>2];e=H[k>>2];H[g+124>>2]=H[b>>2];H[g+120>>2]=e;H[g+116>>2]=c;H[g+112>>2]=H[(I[(d&63)+31056|0]<<2)+34252>>2];Kc(a,6232,g+112|0);i=3091;break b}e=e+40|0}c=c+1|0;continue}}ma=l,qa=Xh(b),H[ma+72>>2]=qa;d=J[b+48>>1];c=H[H[b+116>>2]+60>>2];h=H[b+40>>2];H[l+68>>2]=h;b=c-h|0;H[l+76>>2]=(b|0)<(d|0)?(b|0)>0?b:0:d;e=H[a+28>>2]}H[l+24>>2]=e;b=F[h|0];H[s>>2]=b&255;e=1;if((b|0)<0){e=Od(h,s)}m=0;G[l+54>>1]=0;H[l+44>>2]=e;h=H[s>>2];if(h>>>0>K[l+76>>2]){H[l+76>>2]=0;H[l+68>>2]=0;b=H[s>>2];if(b>>>0>98307){break r}if(b>>>0<=K[l+72>>2]){break z}break r}q=H[l+68>>2];break y}if((m&65535)>>>0>r>>>0){break w}e=H[l+44>>2];h=H[s>>2];if(e>>>0>=h>>>0){break x}q=H[l+68>>2];if(q){break y}p=0;b=g+352|0;Xa(b,0,40);i=pj(H[l+36>>2],H[s>>2],b);if(i){break b}h=H[s>>2];e=H[l+44>>2];m=J[l+54>>1];q=H[g+360>>2]}y=l+84|0;k=h+q|0;e=e+q|0;h=m&65535;d=H[s+(h<<2)>>2];b=0;while(1){n=F[e|0];c=n&255;H[g+464>>2]=c;m=y+(h<<2)|0;H[m>>2]=c;Wf:{if((n|0)>=0){n=I[c+34112|0];e=e+1|0;break Wf}t=Od(e,g+464|0);c=H[g+464>>2];H[m>>2]=c;n=c>>>0>=128?c-12>>>1|0:I[c+34112|0];e=e+t|0}m=h+1|0;t=s+(m<<2)|0;d=d+n|0;b=d>>>0<n>>>0?b+1|0:b;H[t>>2]=d;if(h>>>0<r>>>0){h=m;if(e>>>0<k>>>0){continue}}break}Xf:{if(e>>>0>=k>>>0){if(H[l+72>>2]!=(d|0)|b|e>>>0>k>>>0){break Xf}break v}if(!b&K[l+72>>2]>=d>>>0){break v}}if(!H[s>>2]){m=0;e=k;break v}if(H[l+68>>2]){break r}_c(g+352|0);break r}H[g+464>>2]=0;break u}H[g+464>>2]=H[(l+(r<<2)|0)+84>>2];break t}G[l+54>>1]=m;H[l+44>>2]=e-q;if(H[l+68>>2]){break u}_c(g+352|0);m=J[l+54>>1]}if((m&65535)>>>0>r>>>0){break t}b=N(H[f+12>>2],40)+o|0;if(I[f+1|0]==246){Gg(b,H[f+16>>2],8192);break f}Xb(b);break f}c=N(H[f+12>>2],40)+o|0;if(I[c+17|0]&144){Xb(c)}b=s+(r<<2)|0;if(K[l+76>>2]>=K[b+4>>2]){d=H[l+68>>2]+H[b>>2]|0;b=H[g+464>>2];if(b>>>0<=11){Wh(d,b,c);break f}F[c+18|0]=w;b=b-12>>>1|0;H[c+12>>2]=b;e=b+2|0;Yf:{if((e|0)>H[c+24>>2]){if((b|0)>H[j+120>>2]){break s}G[c+16>>1]=1;if(mh(c,e,0)){break e}k=H[c+8>>2];break Yf}k=H[c+32>>2];H[c+8>>2]=k}Va(k,d,b);F[b+H[c+8>>2]|0]=0;F[(b+H[c+8>>2]|0)+1|0]=0;G[c+16>>1]=J[((H[g+464>>2]&1)<<1)+34094>>1];break f}F[c+18|0]=w;e=H[g+464>>2];Zf:{d=J[f+2>>1]&192;_f:{$f:{if(d){if((d|0)==128){break _f}if(e>>>0<12){break $f}if(!(e&1)|(d|0)==192){break _f}}if(e>>>0>127){break Zf}}if(I[e+34112|0]){break Zf}}Wh(31152,e,c);break f}b=H[b>>2];d=e>>>0>=128?e-12>>>1|0:I[e+34112|0];k=H[c+20>>2];p=18;ag:{if((d|0)>H[k+120>>2]){break ag}n=H[a+28>>2];m=I[c+18|0];bg:{cg:{dg:{if(!(H[l+40>>2]|d>>>0<4001)){eg:{if(I[l+5|0]&16){p=H[l+80>>2];break eg}p=nb(k,32,0);H[l+80>>2]=p;if(!p){break bg}F[l+5|0]=I[l+5|0]|16}h=H[p>>2];fg:{gg:{if(!h){break gg}if(!(H[p+16>>2]!=(r|0)|(n|0)!=H[p+20>>2]|H[p+24>>2]!=(V|0))){k=H[p+8>>2];q=H[p+12>>2];s=zt(H[l+36>>2]);h=H[p>>2];if((k|0)==(s|0)&(Ha|0)==(q|0)){break fg}if(!h){break gg}}Tg(h)}h=so(d+3|0,0);H[p>>2]=h;if(!h){break bg}q=Do(H[l+36>>2],b,d,h);if(q){break cg}b=d+h|0;F[b+2|0]=0;F[b|0]=0;F[b+1|0]=0;H[p+24>>2]=V;H[p+20>>2]=n;H[p+16>>2]=r;ma=p,qa=zt(H[l+36>>2]),H[ma+8>>2]=qa;H[p+12>>2]=Ha}b=h-8|0;p=b;k=H[b>>2];b=H[b+4>>2];k=k+1|0;b=k?b:b+1|0;H[p>>2]=k;H[p+4>>2]=b;if(e&1){q=hd(c,h,d,0,m,9);G[c+16>>1]=J[c+16>>1]|512;break dg}q=hd(c,h,d,0,0,9);break dg}q=At(H[l+36>>2],b,d,c);if(q){break cg}Wh(H[c+8>>2],e,c);q=0;if(!(e&1)|(m|0)!=1){break dg}F[d+H[c+8>>2]|0]=0;G[c+16>>1]=J[c+16>>1]|512}G[c+16>>1]=J[c+16>>1]&49151}p=q;break ag}p=7}if(!p){break f}if((p|0)==18){break s}i=p;if((i|0)!=7){break b}break e}Kc(a,12519,0);i=18;break b}b=H[u+12>>2];if((b|0)>0){f=(N(b,20)+u|0)-20|0;break f}i=Ya(95809);break b}B=0;break f}B=1;break f}e=H[n>>2];d=H[n+4>>2];b=H[l+4>>2];k=H[l>>2];H[g+352>>2]=k;H[g+356>>2]=b;hg:{switch((c&255)-106|0){case 1:if(!e&(d|0)==-2147483648){if((b|0)>0|(b|0)>=0){break n}H[g+352>>2]=k;H[g+356>>2]=b&2147483647;break l}if(!_k(g+352|0,0-e|0,0-(((e|0)!=0)+d|0)|0)){break l}break n;case 2:ig:{if(!!e&(d|0)>=0|(d|0)>0){m=vJ(-1,2147483647,e,d)>>>0<k>>>0;c=Ha;if(m&(c|0)<=(b|0)|(b|0)>(c|0)){break n}c=vJ(0,-2147483648,e,d);m=0-c|0;c=0-(Ha+((c|0)!=0)|0)|0;if((c|0)<=(b|0)&k>>>0>=m>>>0|(b|0)>(c|0)){break ig}break n}if((d|0)>0|(d|0)>=0){break ig}if(!!k&(b|0)>=0|(b|0)>0){c=vJ(0,-2147483648,k,b);m=0-c|0;c=0-(Ha+((c|0)!=0)|0)|0;if((c|0)==(d|0)&e>>>0>=m>>>0|c>>>0<d>>>0){break ig}break n}if((b|0)>0|(b|0)>=0){break ig}if(!e&(d|0)==-2147483648|!k&(b|0)==-2147483648){break n}c=vJ(-1,2147483647,0-e|0,0-(((e|0)!=0)+d|0)|0);m=0-(((k|0)!=0)+b|0)|0;q=Ha;if((m|0)==(q|0)&c>>>0<0-k>>>0|m>>>0>q>>>0){break n}}ma=g,qa=sJ(e,d,k,b),H[ma+352>>2]=qa;H[g+356>>2]=Ha;break l;case 3:if(!(d|e)){break m}if(!k&(b|0)==-2147483648&(d&e)==-1){break n}ma=g,qa=tJ(k,b,e,d),H[ma+352>>2]=qa;H[g+356>>2]=Ha;break l;default:if(!(d|e)){break m}c=b;b=(d&e)==-1;ma=g,qa=uJ(k,c,b?1:e,b?0:d),H[ma+352>>2]=qa;H[g+356>>2]=Ha;break l;case 0:break hg}}if(!_k(g+352|0,e,d)){break l}}E=Db(n);Y=Db(l);jg:{kg:{switch(I[f|0]-106|0){case 0:E=E+Y;break jg;case 1:E=Y-E;break jg;case 2:E=E*Y;break jg;case 3:if(E==0){break m}E=Y/E;break jg;default:break kg}}b=kb(n);c=Ha;d=kb(l);H[g+352>>2]=d;e=Ha;H[g+356>>2]=e;if(!(b|c)){break m}k=b;b=(b&c)==-1;E=+(uJ(d,e,b?1:k,b?0:c)>>>0)+ +(Ha|0)*4294967296}C(+E);b=x(1)|0;d=x(0)|0;if((b&2146435072)==2146435072&(b&1048575|d)!=0){break m}M[h>>3]=E;G[h+16>>1]=J[h+16>>1]&62016|8;break f}Xb(h);break f}b=H[g+356>>2];H[h>>2]=H[g+352>>2];H[h+4>>2]=b;G[h+16>>1]=J[h+16>>1]&62016|4;break f}H[a+36>>2]=5}c=1;break a}f=(N(H[f+8>>2],20)+u|0)-20|0;break f}f=(N(H[f+8>>2],20)+u|0)-20|0}if(H[j+296>>2]){break c}while(1){if((O|0)==(R|0)&L>>>0>S>>>0|O>>>0>R>>>0){break f}b=H[j+372>>2];if(!b){break f}d=H[j+380>>2];L=d+L|0;c=O;O=d>>>0>L>>>0?c+1|0:c;if(!(Ia[b|0](H[j+376>>2])|0)){continue}break}L=-1;O=-1;break c}f=f+20|0;continue}}Ib(j);Kc(a,1150,0)}i=7;break b}i=9}c=0}while(1){lg:{mg:{ng:{og:{if(!c){c=7;pg:{if(I[j+87|0]){break pg}c=i;if((c|0)!=8458){break pg}c=Ya(101652)}if(!(H[a+124>>2]|(c|0)==3082)){ma=g,qa=Sg(c),H[ma+16>>2]=qa;Kc(a,8863,g+16|0)}H[a+36>>2]=c;Am(j,c);b=H[a+200>>2];H[g+8>>2]=H[a+124>>2];H[g+4>>2]=b;H[g>>2]=(f-u|0)/20;Ec(c,7267,g);if(I[a+151|0]==2){vj(a)}qg:{if((c|0)!=11){if((c|0)!=3082){break qg}Ib(j);break qg}if(I[j+85|0]){break qg}d=H[j+36>>2]|2;H[j+32>>2]=H[j+32>>2];H[j+36>>2]=d}p=1;b=da&255;if(!b){da=0;break og}lj(j,b-1|0);break og}if((O|0)==(R|0)&L>>>0>S>>>0|O>>>0>R>>>0){break mg}b=H[j+372>>2];if(!b){break mg}d=H[j+380>>2];L=d+L|0;c=O;O=d>>>0>L>>>0?c+1|0:c;if(Ia[b|0](H[j+376>>2])|0){break ng}}c=1;continue}i=9;L=-1;O=-1;break lg}H[a+180>>2]=H[a+180>>2]+S;Ea=g+544|0;return p}c=0;continue}}
function jj(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,L=0,M=0,O=0,P=0;o=Ea-1296|0;Ea=o;t=H[a>>2];B=H[t+124>>2];if(!H[t+184>>2]){H[t+296>>2]=0}H[a+244>>2]=b;H[a+12>>2]=0;H[o+1264>>2]=o+1252;H[o+64>>2]=0;E=o- -64|0;H[o+56>>2]=E;H[o+60>>2]=a;L=H[t+264>>2];H[t+264>>2]=a;s=-1;while(1){a:{x=oj(b,o+1268|0);B=B-x|0;if((B|0)<0){H[a+12>>2]=18;H[a+36>>2]=H[a+36>>2]+1;break a}c=H[o+1268>>2];b:{if((c|0)<164){s=c;break b}if(H[t+296>>2]){H[a+12>>2]=9;H[a+36>>2]=H[a+36>>2]+1;break a}if((c|0)==183){b=b+x|0;continue}if(!I[b|0]){x=0;c=0;c:{switch(s|0){default:c=1;break;case 1:break c;case 0:break a}}H[o+1268>>2]=c;s=c;break b}d:{e:{switch(c-164|0){case 0:H[o+1288>>2]=b+6;s=59;c=o+1288|0;if((vl(c)|0)!=59){break d}s=(vl(c)|0)==24?164:59;break d;case 1:H[o+1288>>2]=b+4;c=(s|0)!=23;s=59;if(c){break d}c=vl(o+1288|0);s=(c|0)==59?165:(c|0)==22?165:59;break d;case 2:H[o+1288>>2]=b+6;if((s|0)==23){s=166;if((vl(o+1288|0)|0)==22){break d}}s=59;break d;default:break e}}H[o+1292>>2]=x;H[o+1288>>2]=b;H[o+48>>2]=o+1288;Wa(a,29766,o+48|0);break a}H[o+1268>>2]=s}H[a+212>>2]=x;H[a+208>>2]=b;c=I[a+212|0]|I[a+213|0]<<8|(I[a+214|0]<<16|I[a+215|0]<<24);C=c;y=I[a+208|0]|I[a+209|0]<<8|(I[a+210|0]<<16|I[a+211|0]<<24);H[o+1272>>2]=y;H[o+1276>>2]=c;c=J[H[o+56>>2]>>1];f=H[o+60>>2];f:{while(1){e=c&65535;if(e>>>0<=578){i=e<<1;g=J[i+37696>>1];e=s;g:{h:{while(1){c=e&65535;e=c+g<<1;if(J[e+38864>>1]==(c|0)){break h}e=J[(c<<1)+36896>>1];if(e){continue}break}i:{if(!c){break i}c=g+101<<1;if(J[c+38864>>1]!=101){break i}c=c+43440|0;break g}c=i+47648|0;break g}c=e+43440|0}c=J[c>>1]}g=c&65535;if(g>>>0>=1246){if(!(I[g+36034|0]|K[o+56>>2]<K[o+1264>>2])){Tv(o+56|0);break f}c=H[o+1276>>2];H[o+24>>2]=H[o+1272>>2];H[o+28>>2]=c;e=0;c=0;i=0;q=0;h=Ea-768|0;Ea=h;d=H[o+56>>2];j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{U:{V:{W:{X:{Y:{Z:{_:{$:{aa:{ba:{ca:{da:{ea:{fa:{ga:{ha:{ia:{ja:{ka:{la:{ma:{na:{oa:{pa:{qa:{ra:{sa:{ta:{ua:{va:{wa:{xa:{ya:{za:{Aa:{Ba:{Ca:{Da:{Ea:{Fa:{Ga:{Ha:{Ia:{Ja:{Ka:{La:{Ma:{Na:{Oa:{Pa:{Qa:{Ra:{Sa:{Ta:{Ua:{Va:{Wa:{Xa:{Ya:{Za:{_a:{$a:{ab:{bb:{cb:{db:{eb:{fb:{gb:{hb:{ib:{jb:{kb:{lb:{mb:{nb:{ob:{pb:{qb:{rb:{sb:{tb:{ub:{vb:{wb:{xb:{yb:{zb:{Ab:{Bb:{Cb:{Db:{Eb:{Fb:{Gb:{Hb:{Ib:{Jb:{Kb:{Lb:{Mb:{Nb:{Ob:{Pb:{Qb:{Rb:{Sb:{Tb:{Ub:{Vb:{Wb:{Xb:{Yb:{Zb:{_b:{$b:{ac:{bc:{cc:{dc:{ec:{fc:{gc:{hc:{ic:{jc:{kc:{lc:{mc:{nc:{oc:{pc:{qc:{rc:{sc:{tc:{uc:{vc:{wc:{xc:{yc:{zc:{Ac:{Bc:{Cc:{Dc:{Ec:{Fc:{Gc:{Hc:{Ic:{Jc:{Kc:{Lc:{Mc:{Nc:{Oc:{Pc:{Qc:{Rc:{Sc:{Tc:{Uc:{Vc:{Wc:{Xc:{Yc:{Zc:{_c:{$c:{ad:{bd:{cd:{dd:{ed:{fd:{gd:{hd:{id:{jd:{kd:{ld:{md:{nd:{od:{pd:{qd:{rd:{sd:{td:{ud:{vd:{wd:{xd:{yd:{zd:{Ad:{Bd:{Cd:{Dd:{Ed:{Fd:{Gd:{Hd:{Id:{Jd:{Kd:{Ld:{Md:{Nd:{Od:{Pd:{Qd:{Rd:{Sd:{Td:{Ud:{Vd:{Wd:{Xd:{Yd:{Zd:{_d:{$d:{ae:{be:{ce:{de:{ee:{fe:{ge:{he:{ie:{je:{ke:{le:{me:{ne:{D=g-1246|0;switch(D|0){case 109:break Ca;case 110:break Da;case 111:break Ea;case 112:break Fa;case 113:break Ga;case 114:case 129:break Ha;case 116:break Ia;case 117:break Ja;case 118:break Ka;case 119:break La;case 120:break Ma;case 121:break Na;case 122:break Oa;case 123:break Pa;case 124:break Qa;case 125:break Ra;case 126:break Sa;case 127:break Ta;case 128:break Ua;case 130:break Va;case 131:break Wa;case 133:case 143:break Xa;case 134:break Ya;case 135:break Za;case 136:break _a;case 137:break $a;case 138:case 141:break ab;case 139:break bb;case 140:break cb;case 144:case 146:case 151:case 153:case 230:case 231:case 250:break db;case 145:case 152:case 154:case 229:case 249:break eb;case 147:break fb;case 148:break gb;case 149:break hb;case 150:break ib;case 155:break jb;case 156:break kb;case 157:break lb;case 158:break mb;case 159:break nb;case 160:break ob;case 161:break pb;case 162:break qb;case 163:break rb;case 164:break sb;case 165:break tb;case 166:break ub;case 167:break vb;case 168:break wb;case 169:break xb;case 170:break yb;case 173:break zb;case 174:break Ab;case 175:break Bb;case 176:break Cb;case 177:break Db;case 178:break Eb;case 179:break Fb;case 180:break Gb;case 181:case 182:break Hb;case 183:break Ib;case 184:break Jb;case 185:break Kb;case 186:break Lb;case 187:break Mb;case 188:break Nb;case 189:break Ob;case 190:break Pb;case 191:break Qb;case 192:break Rb;case 193:break Sb;case 194:break Tb;case 195:break Ub;case 196:case 197:case 198:case 199:case 200:case 201:case 202:break Vb;case 203:break Wb;case 204:break Xb;case 205:break Yb;case 206:break Zb;case 207:break _b;case 208:break $b;case 209:break ac;case 210:break bc;case 211:break cc;case 212:case 213:break dc;case 214:break ec;case 215:break fc;case 216:case 219:break gc;case 218:break hc;case 221:break ic;case 222:break jc;case 223:break kc;case 224:break lc;case 225:break mc;case 226:break nc;case 227:break oc;case 228:break pc;case 233:break qc;case 234:break rc;case 236:case 241:break sc;case 237:break tc;case 238:case 280:break uc;case 239:break vc;case 242:break wc;case 243:break xc;case 246:break yc;case 247:break zc;case 248:break Ac;case 251:break Bc;case 252:break Cc;case 253:break Dc;case 254:break Ec;case 255:break Fc;case 258:break Gc;case 259:break Hc;case 260:break Ic;case 261:break Jc;case 262:break Kc;case 263:case 264:break Lc;case 265:break Mc;case 266:case 285:break Nc;case 267:case 286:break Oc;case 268:break Pc;case 269:break Qc;case 270:break Rc;case 271:break Sc;case 272:break Tc;case 273:break Uc;case 274:break Vc;case 275:break Wc;case 276:break Xc;case 277:break Yc;case 278:break Zc;case 279:break _c;case 281:break $c;case 282:break ad;case 283:break bd;case 284:break cd;case 287:break dd;case 288:break ed;case 289:break fd;case 290:break gd;case 291:break hd;case 292:break id;case 293:break jd;case 294:break kd;case 295:break ld;case 296:break md;case 297:break nd;case 298:break od;case 299:break pd;case 300:case 301:case 302:break qd;case 303:case 304:break rd;case 305:break sd;case 306:break td;case 307:break ud;case 308:break vd;case 309:break wd;case 310:break xd;case 311:break yd;case 312:break zd;case 313:break Ad;case 314:break Bd;case 315:break Cd;case 316:break Dd;case 317:break Ed;case 318:break Fd;case 319:break Gd;case 320:break Hd;case 323:case 325:case 327:break Id;case 326:break Jd;case 328:break Kd;case 329:break Ld;case 330:case 331:break Md;case 332:break Nd;case 333:break Od;case 334:break Pd;case 336:break Qd;case 337:break Rd;case 338:break Sd;case 339:break Td;case 25:break Ud;case 24:break Vd;case 23:break Wd;case 22:break Xd;case 21:break Yd;case 20:break Zd;case 19:break _d;case 17:break $d;case 16:break ae;case 15:case 18:case 47:case 62:case 72:case 81:case 98:case 244:break be;case 14:break ce;case 13:break de;case 12:break ee;case 11:break fe;case 10:break ge;case 8:case 9:break he;case 5:case 6:case 7:case 321:break ie;case 4:break je;case 3:break ke;case 2:break le;case 26:case 65:case 104:break m;case 1:break me;case 0:break ne;case 27:break n;case 28:break o;case 29:break p;case 30:break q;case 31:break r;case 32:case 67:break s;case 33:break t;case 34:break u;case 35:break v;case 36:break w;case 37:break x;case 38:break y;case 39:break z;case 40:break A;case 41:break B;case 42:break C;case 43:break D;case 44:break E;case 45:break F;case 46:break G;case 48:break H;case 49:break I;case 50:break J;case 51:break K;case 52:break L;case 53:break M;case 54:break N;case 55:break O;case 56:break P;case 57:break Q;case 58:break R;case 59:break S;case 60:break T;case 61:case 76:case 171:break U;case 63:case 80:case 217:case 220:case 245:break V;case 64:break W;case 66:break X;case 68:break Y;case 69:break Z;case 70:break _;case 71:break $;case 73:case 75:break aa;case 74:break ba;case 77:break ca;case 78:case 172:break da;case 79:break ea;case 82:break fa;case 83:break ga;case 84:break ha;case 85:break ia;case 86:break ja;case 87:break ka;case 88:break la;case 89:case 91:break ma;case 90:break na;case 92:break oa;case 93:break pa;case 94:break qa;case 95:break ra;case 96:break sa;case 97:break ta;case 99:case 132:case 142:case 232:case 235:case 240:break ua;case 100:break va;case 101:break wa;case 102:break xa;case 103:case 115:case 256:case 257:break ya;case 105:case 108:break za;case 106:break Aa;case 107:break Ba;default:break j}}if(H[f+240>>2]){break j}F[f+219|0]=1;break j}if(H[f+240>>2]){break j}F[f+219|0]=2;break j}if(I[f+18|0]){break j}e=H[f>>2];oe:{if(H[f+36>>2]){if(!I[e+87|0]){break j}e=7;break oe}pe:{qe:{re:{c=H[f+8>>2];if(c){break re}if(I[e+177|0]){break pe}c=wb(f);if(c){break re}H[f+12>>2]=1;c=0;break qe}se:{if(!I[f+159|0]){break se}i=H[f+144>>2];if(!H[i+96>>2]){break se}Mb(c,83);j=_a(c,36,H[i+92>>2]);k=H[i+100>>2];g=0;while(1){if(H[i+96>>2]>(g|0)){Ua(c,94,H[i+92>>2],g,g+k|0);g=g+1|0;continue}break}Sa(c,84,k,g);Sa(c,39,H[i+92>>2],j+1|0);i=H[c+108>>2];H[(I[H[c>>2]+87|0]?73336:H[c+104>>2]+N(j,20)|0)+8>>2]=i}Mb(c,70);i=H[c+108>>2];H[(I[H[c>>2]+87|0]?73336:H[c+104>>2])+8>>2]=i;g=0;while(1){te:{if(!(H[f+92>>2]>>>g&1)){break te}ke(c,g);i=H[(H[e+16>>2]+(g<<4)|0)+12>>2];gb(c,2,g,H[f+88>>2]>>>g&1,H[i>>2],H[i+4>>2]);if(I[e+177|0]){break te}i=H[c+108>>2];if((i|0)<=0){break te}G[(H[c+104>>2]+N(i,20)|0)-18>>1]=1}g=g+1|0;if((g|0)<H[e+20>>2]){continue}break}g=0;while(1){if(H[f+224>>2]>(g|0)){fb(c,170,0,0,0,zd(e,H[H[f+272>>2]+(g<<2)>>2]),-11);g=g+1|0;continue}break}g=0;H[f+224>>2]=0;ue:{e=H[f+116>>2];if(!e){break ue}i=H[f+8>>2];while(1){if((e|0)<=(g|0)){break ue}e=H[f+120>>2]+(g<<4)|0;fb(i,169,H[e>>2],H[e+4>>2],I[e+8|0],H[e+12>>2],-1);g=g+1|0;e=H[f+116>>2];continue}}ve:{e=H[f+124>>2];if(!e){break ve}j=H[f+8>>2];k=H[f>>2];while(1){if(!e){break ve}i=H[e+12>>2];g=H[e+8>>2];Hd(f,0,g,H[H[(H[k+16>>2]+(g<<4)|0)+12>>2]+72>>2],112);m=i-1|0;Nc(j,m,H[H[e+4>>2]>>2]);g=ag(j,12,49664);if(!g){break ve}H[g+72>>2]=i;H[g+64>>2]=m;H[g+52>>2]=i;H[g+8>>2]=i;H[g+124>>2]=i;H[g+112>>2]=i;G[g+62>>1]=16;H[g+208>>2]=i;H[g+144>>2]=i;m=i+2|0;H[g+12>>2]=m;H[g+148>>2]=m;H[g+88>>2]=i+1;if(!H[f+40>>2]){H[f+40>>2]=1}e=H[e>>2];continue}}we:{e=H[f+68>>2];if(!e){break we}g=0;F[f+23|0]=0;i=e+8|0;while(1){if(H[e>>2]<=(g|0)){break we}j=i+(g<<4)|0;ac(f,H[j>>2],H[j+12>>2]);g=g+1|0;continue}}xe:{if(!I[f+159|0]){break xe}e=H[f+144>>2];g=H[e+96>>2];if(!g){break xe}Sa(c,118,H[e+92>>2],g)}Qb(c,1)}e=1;if(H[f+36>>2]){break oe}dw(c,f)}e=101}H[f+12>>2]=e;break j}e=H[d-8>>2];j=H[f>>2];if(Yb(f,22,19935,0,0)){break j}c=wb(f);if(!c){break j}ye:{if((e|0)==7){break ye}i=(e|0)==9?2:1;g=0;while(1){if(H[j+20>>2]<=(g|0)){break ye}k=H[(H[j+16>>2]+(g<<4)|0)+4>>2];ze:{if(k){e=0;if(F[H[k+4>>2]+24|0]&1){break ze}}e=i}Sa(c,2,g,e);ke(c,g);g=g+1|0;continue}}Mb(c,1);break j}H[d+16>>2]=7;break j}H[d+4>>2]=J[d+2>>1];break j}c=J[d-10>>1]==12;if(Yb(f,22,c?20180:18781,0,0)){break j}e=wb(f);if(!e){break j}Sa(e,1,1,c);break j}Mn(f,0,d+4|0);break j}Mn(f,1,d+4|0);break j}Mn(f,2,d+4|0);break j}Ln(f,d-8|0,d+4|0,H[d-44>>2],0,0,H[d-20>>2]);break j}Ys(f);break j}H[d+16>>2]=0;break j}H[d-20>>2]=1;break j}H[d+4>>2]=!I[H[f>>2]+177|0];break j}Kn(f,d-20|0,d-8|0,H[d+4>>2],0);break j}Kn(f,0,0,0,H[d+4>>2]);fc(H[f>>2],H[d+4>>2]);break j}H[d+16>>2]=0;break j}c=d-20|0;H[c>>2]=H[d+4>>2]|H[c>>2];break j}c=H[d+4>>2];Ae:{e=H[d+8>>2];if((e|0)!=5){break Ae}if(yb(c,15085,5)){break Ae}H[d-8>>2]=640;break j}H[d-8>>2]=0;H[h+4>>2]=c;H[h>>2]=e;Wa(f,6064,h);break j}c=H[d+4>>2];Be:{Ce:{e=H[d+8>>2];if((e|0)!=6){break Ce}if(yb(c,3457,6)){break Ce}c=65536;break Be}H[h+20>>2]=c;H[h+16>>2]=e;Wa(f,6064,h+16|0);c=0}H[d+4>>2]=c;break j}c=I[d+8|0]|I[d+9|0]<<8|(I[d+10|0]<<16|I[d+11|0]<<24);e=c;j=I[d+4|0]|I[d+5|0]<<8|(I[d+6|0]<<16|I[d+7|0]<<24);H[h+712>>2]=j;H[h+716>>2]=c;c=d-8|0;g=I[c+4|0]|I[c+5|0]<<8|(I[c+6|0]<<16|I[c+7|0]<<24);H[h+704>>2]=I[c|0]|I[c+1|0]<<8|(I[c+2|0]<<16|I[c+3|0]<<24);H[h+708>>2]=g;l=H[f+248>>2];if(!l){break j}c=H[f>>2];if(H[c+128>>2]<=G[l+34>>1]){H[h+48>>2]=H[l>>2];Wa(f,6622,h+48|0);break j}if(I[f+220|0]<=1){Xs(h+704|0)}De:{Ee:{if(e>>>0<16){break Ee}if(yb((e+j|0)-6|0,3675,6)){break De}g=j-1|0;e=e-6|0;p=1;while(1){k=65;if(!e){break l}if(F[I[e+g|0]+31152|0]&1){e=e-1|0;continue}break}H[h+716>>2]=e;if(e>>>0<9){break Ee}if(yb((e+j|0)-9|0,15578,9)){break De}e=e-9|0;while(1){if(!e){break l}if(F[I[e+g|0]+31152|0]&1){e=e-1|0;continue}break}H[h+716>>2]=e}if(e>>>0>=3){break De}k=65;p=1;break k}Xs(h+712|0);j=H[h+712>>2];e=H[h+716>>2];p=1;g=0;while(1){if((g|0)==6){k=65;break k}Fe:{if(I[g+50024|0]!=(e|0)){break Fe}if(yb(j,H[(g<<2)+67056>>2],e)){break Fe}p=(g&3)==1?5:1;q=(g<<4)+16|0;k=I[g+49968|0];e=0;break k}g=g+1|0;continue}}H[d-44>>2]=H[d-8>>2];break j}c=d-8|0;e=nb(H[f>>2],100,0);H[c>>2]=e;if(!e){break j}e=Dd(H[f>>2],H[d+4>>2],H[d+8>>2],0);H[H[c>>2]>>2]=e;break j}H[d-32>>2]=H[d-8>>2];break j}c=nb(H[f>>2],100,0);Ge:{if(c){F[c+16|0]=166;H[c+40>>2]=H[d+4>>2];break Ge}eb(H[f>>2],H[d+4>>2])}H[d+4>>2]=c;break j}c=H[d+4>>2];He:{if(c){H[c+40>>2]=H[d-8>>2];break He}eb(H[f>>2],H[d-8>>2])}H[d-8>>2]=H[d+4>>2];break j}H[d-8>>2]=H[d+4>>2];break j}F[d+4|0]=I[d+2|0];break j}F[d-8|0]=I[d-10|0];break j}F[d-8|0]=I[d+4|0];break j}F[d+16|0]=0;break j}c=d-8|0;H[d-4>>2]=H[c>>2];H[c>>2]=J[d+2>>1];break j}H[d-4>>2]=0;H[d-8>>2]=J[d-10>>1];break j}c=d-56|0;O=c,P=Jn(f,H[c>>2],H[d-32>>2],H[d-28>>2],H[d-8>>2],H[d-4>>2],I[d+4|0]),H[O>>2]=P;break j}c=d-20|0;O=c,P=Jn(f,H[c>>2],H[d-8>>2],H[d-4>>2],85,0,I[d+4|0]),H[O>>2]=P;break j}O=d,P=Jn(f,0,90,0,85,0,0),H[O+16>>2]=P;break j}c=d-8|0;O=c,P=Li(f,H[d+4>>2],0,0,c),H[O>>2]=P;break j}c=d-44|0;O=c,P=Li(f,H[d+4>>2],0,H[d-8>>2],c),H[O>>2]=P;break j}O=d-32|0,P=Li(f,H[d+4>>2],0,H[d-8>>2],0),H[O>>2]=P;break j}c=d-56|0;O=c,P=Li(f,H[d+4>>2],H[d-20>>2],H[d-8>>2],c),H[O>>2]=P;break j}O=d-44|0,P=Li(f,H[d+4>>2],H[d-20>>2],H[d-8>>2],0),H[O>>2]=P;break j}e=d-44|0;c=d-8|0;if(H[c>>2]){g=Dd(H[f>>2],H[e>>2],H[d-40>>2],0);H[H[c>>2]>>2]=g;c=H[c>>2]}else{c=0}H[e>>2]=c;break j}c=d-20|0;Ws(f,H[d+4>>2],H[c>>2]);H[H[d+4>>2]+36>>2]=H[c>>2];H[c>>2]=H[d+4>>2];break j}c=d-20|0;O=c,P=Vs(f,H[c>>2],H[d+4>>2]),H[O>>2]=P;break j}O=d,P=Vs(f,0,H[d+4>>2]),H[O+4>>2]=P;break j}g=d-56|0;k=I[d-32|0];i=H[d-8>>2];j=H[d-44>>2];e=H[f>>2];c=nb(e,24,0);Ie:{if(I[e+87|0]){pb(e,j);fc(e,i);break Ie}H[c+4>>2]=j;H[c+8>>2]=i;e=tc(H[f>>2],g);F[c+20|0]=k;H[c>>2]=e}H[g>>2]=c;break j}F[d-20|0]=2;break j}F[d-8|0]=0;break j}F[d+4|0]=1;break j}Us(f,H[d+4>>2]);break j}c=H[d+4>>2];e=H[f+264>>2];Je:{if(!e){H[f+264>>2]=c;c=H[d+8>>2];break Je}c=(c+H[d+8>>2]|0)-e|0}H[f+268>>2]=c;break j}Ts(f);H[f+264>>2]=0;H[f+268>>2]=0;break j}Ln(f,d-32|0,d-20|0,0,0,1,H[d-44>>2]);c=H[f+248>>2];if(!c){break j}F[c+43|0]=1;e=H[f>>2];Qg(f,c,tc(e,d+4|0));Qg(f,c,0);Qg(f,c,Tb(e,H[c>>2]));H[f+204>>2]=(H[d+4>>2]+H[d+8>>2]|0)-H[f+200>>2];g=H[c+48>>2];if(!g){break j}Yb(f,29,H[c>>2],H[g>>2],H[H[H[f>>2]+16>>2]+(Fb(e,H[c+60>>2])<<4)>>2]);break j}Ss(f,d+4|0);break j}Ss(f,0);break j}j=H[f>>2];Ke:{Le:{p=H[d-56>>2];i=df(f,0,p+8|0);if(!i){break Le}e=0;if(Lk(f,i)){break Ke}e=0;if(Rs(f,i,0)){break Ke}e=H[j+16>>2];l=Fb(j,H[i+60>>2]);k=H[e+(l<<4)>>2];if(Yb(f,26,k,H[i>>2],0)){break Le}q=d-20|0;g=tc(j,q);e=0;if(!g){break Ke}n=d+4|0;m=G[i+34>>1];e=(m|0)>0?m:0;while(1){Me:{if((c|0)!=(e|0)){if(ab(H[H[i+4>>2]+N(c,12)>>2],g)){break Me}e=c}Ne:{Oe:{Pe:{if((e|0)==(m|0)){H[h+608>>2]=q;Wa(f,29745,h+608|0);break Pe}m=(l|0)==1;Ki(f,k,m,30558,0);Qs(f,k,m);c=H[f+128>>2];F[(c?c:f)+21|0]=1;c=tc(j,n);if(c){break Oe}}c=0;break Ne}n=I[H[n>>2]];q=H[i>>2];H[h+684>>2]=q;H[h+680>>2]=m;H[h+672>>2]=c;n=I[n+31152|0]&128;H[h+676>>2]=n;H[h+668>>2]=e;H[h+664>>2]=q;H[h+660>>2]=k;H[h+656>>2]=k;kc(f,25698,h+656|0);i=H[i>>2];H[h+640>>2]=n;H[h+636>>2]=c;H[h+632>>2]=e;H[h+628>>2]=i;H[h+624>>2]=k;kc(f,26909,h+624|0);Kk(f,l,1);Ki(f,k,m,13900,1)}e=g;break Ke}c=c+1|0;continue}}e=0}Cc(j,p);Za(j,e);Za(j,c);break j}Ys(f);j=H[d+4>>2];e=H[f>>2];Qe:{if(I[e+87|0]){break Qe}i=df(f,0,j+8|0);if(!i){break Qe}Re:{switch(I[i+43|0]-1|0){case 0:Wa(f,15692,0);break Qe;case 1:Wa(f,1805,0);break Qe;default:break Re}}if(Lk(f,i)){break Qe}c=H[f+128>>2];F[(c?c:f)+21|0]=1;l=Fb(e,H[i+60>>2]);c=nb(e,64,0);if(!c){break Qe}H[f+248>>2]=c;H[c+24>>2]=1;g=G[i+34>>1];G[c+34>>1]=g;O=c,P=nb(e,N((g-1|0)/8|0,96)+96|0,0),H[O+4>>2]=P;H[h+592>>2]=H[i>>2];g=mb(e,6118,h+592|0);H[c>>2]=g;k=H[c+4>>2];if(!k|!g){break Qe}Va(k,H[i+4>>2],N(G[c+34>>1],12));g=0;while(1){if(G[c+34>>1]>(g|0)){k=H[c+4>>2]+N(g,12)|0;m=Tb(e,H[k>>2]);H[k>>2]=m;O=k,P=Cg(m),F[O+7|0]=P;g=g+1|0;continue}break}O=c,P=pc(e,H[i+52>>2],0),H[O+52>>2]=P;H[c+60>>2]=H[(H[e+16>>2]+(l<<4)|0)+12>>2];H[c+44>>2]=H[i+44>>2]}Cc(e,j);break j}w=H[d-32>>2];p=H[f>>2];Se:{if(I[p+87|0]){break Se}l=df(f,0,w+8|0);if(!l){break Se}if(Lk(f,l)){break Se}if(Rs(f,l,1)){break Se}c=d+4|0;j=tc(p,c);if(!j){break Se}q=In(l,j);Te:{if((q|0)<0){H[h+528>>2]=c;Wa(f,29745,h+528|0);break Te}c=J[(H[l+4>>2]+N(q,12)|0)+10>>1];if(c&9){H[h+580>>2]=j;H[h+576>>2]=c&1?18516:20226;Wa(f,29693,h+576|0);break Te}if(G[l+34>>1]<=1){H[h+544>>2]=j;Wa(f,2277,h+544|0);break Te}e=H[p+16>>2];c=Fb(p,H[l+60>>2]);e=H[e+(c<<4)>>2];if(Yb(f,26,e,H[l>>2],j)){break Te}g=(c|0)==1;Ki(f,e,g,30558,0);Qs(f,e,g);H[h+572>>2]=H[l>>2];H[h+568>>2]=q;H[h+564>>2]=c;H[h+560>>2]=e;kc(f,25337,h+560|0);Kk(f,c,2);Ki(f,e,g,10994,1);if(H[f+36>>2]|I[(H[l+4>>2]+N(q,12)|0)+10|0]&32){break Te}e=wb(f);n=H[f+40>>2];H[f+40>>2]=n+1;Hd(f,n,c,l,113);v=_a(e,36,n);g=H[f+44>>2];r=g+1|0;H[f+44>>2]=r;Ue:{if(!(I[l+28|0]&128)){Sa(e,135,n,r);k=g+2|0;c=0;g=H[f+44>>2]+G[l+34>>1]|0;break Ue}c=jc(l);H[f+44>>2]=r+J[c+52>>1];k=g+2|0;g=0;while(1){i=J[c+50>>1];if(i>>>0>g>>>0){Ua(e,94,n,g,g+k|0);g=g+1|0;continue}break}g=H[f+44>>2]}u=g+1|0;H[f+44>>2]=u;g=0;while(1){if(G[l+34>>1]>(g|0)){Ve:{if(I[(H[l+4>>2]+N(g,12)|0)+10|0]&32|(g|0)==(q|0)){break Ve}We:{if(c){m=Re(c,g<<16>>16);z=Re(c,q<<16>>16);if((m|0)<J[c+50>>1]){break Ve}m=(k+m|0)-((m|0)>(z|0))|0;break We}m=i+k|0}Xe:{if(G[l+32>>1]==(g|0)){Sa(e,75,0,m);break Xe}yd(e,l,n,g,m)}i=i+1|0}g=g+1|0;continue}break}if(!i){H[f+44>>2]=H[f+44>>2]+1;Sa(e,75,0,k);i=1}Ua(e,97,k,i,u);Ye:{if(c){gb(e,138,n,u,k,J[c+50>>1]);break Ye}Ua(e,128,n,u,r)}c=H[e+108>>2];if((c|0)>0){G[(H[e+104>>2]+N(c,20)|0)-18>>1]=2}Sa(e,39,n,v+1|0);g=H[e+108>>2];H[(I[H[e>>2]+87|0]?73336:H[e+104>>2]+N(v,20)|0)+8>>2]=g}e=j}Za(p,e);Cc(p,w);break j}e=d-4|0;p=d-8|0;H[e>>2]=H[f+212>>2]+(H[f+208>>2]-H[p>>2]|0);if(H[f+36>>2]){break j}j=H[f>>2];c=H[j+16>>2];g=H[f+248>>2];m=Fb(j,H[g+60>>2]);i=H[c+(m<<4)>>2];l=H[g+4>>2]+N(G[g+34>>1],12)|0;c=Mc(g,l-12|0);k=H[g>>2]+16|0;q=yc(j,k,i);if(Yb(f,26,i,H[q>>2],0)){break j}r=l-2|0;n=J[r>>1];if(n&1){Wa(f,11123,0);break j}if(H[g+8>>2]){Wa(f,11155,0);break j}Ze:{if(!(n&96)){c=c?I[H[c+12>>2]]!=121?c:0:0;if(!(!(I[j+33|0]&64)|(!H[g+48>>2]|!c))){Jk(f,i,k,12990)}if(!(c|!(I[l-8|0]&15))){Jk(f,i,k,20009);break Ze}if(!c){break Ze}H[h+712>>2]=0;if(ij(j,c,1,65,h+712|0)){break j}c=H[h+712>>2];if(!c){Jk(f,i,k,3054)}Uc(c);break Ze}if(!(n&64)){break Ze}Jk(f,i,k,11182)}c=Dd(j,H[p>>2],H[e>>2],0);if(c){e=c+H[e>>2]|0;while(1){_e:{e=e-1|0;if(c>>>0>=e>>>0){break _e}n=I[e|0];if((n|0)!=59&!(F[n+31152|0]&1)){break _e}F[e|0]=0;continue}break}e=H[g+44>>2];H[h+512>>2]=k;H[h+508>>2]=e;H[h+504>>2]=c;H[h+500>>2]=e;H[h+496>>2]=i;kc(f,19672,h+496|0);db(j,c)}c=wb(f);if(!c){break j}e=zb(f);Ua(c,99,m,e,2);ke(c,m);Sa(c,86,e,-2);Sa(c,59,e,H[c+108>>2]+2|0);Ua(c,100,m,2,3);rb(f,e);Kk(f,m,3);if(!(H[g+16>>2]|(I[r|0]&96?I[l-8|0]&15:0)|F[q+30|0]&1)){break j}H[h+484>>2]=i;H[h+480>>2]=k;kc(f,28401,h+480|0);break j}m=H[d-32>>2];k=H[f>>2];$e:{if(I[k+87|0]){break $e}j=df(f,0,m+8|0);if(!j){break $e}c=H[k+16>>2];l=Fb(H[f>>2],H[j+60>>2]);g=H[c+(l<<4)>>2];c=tc(k,d+4|0);if(!c){break $e}af:{bf:{cf:{if(yc(k,c,g)){break cf}if(ef(k,c,g)){break cf}if(!Ps(k,j,c)){break bf}}H[h+464>>2]=c;Wa(f,8222,h+464|0);break af}if(Lk(f,j)){break af}if(Ik(f,c,14316,c)){break af}e=H[j>>2];if(I[j+43|0]==2){H[h+336>>2]=e;Wa(f,15726,h+336|0);break af}if(Yb(f,26,g,e,0)){break af}if(cf(f,j)){break af}if(I[j+43|0]==1){e=zd(k,j);i=H[H[H[e+8>>2]>>2]+76>>2]?e:0}n=wb(f);if(!n){break af}e=H[f+128>>2];F[(e?e:f)+21|0]=1;e=H[j>>2];q=Vv(e);H[h+452>>2]=e;p=(l|0)==1;H[h+448>>2]=p;H[h+444>>2]=c;H[h+440>>2]=e;H[h+436>>2]=g;H[h+432>>2]=g;kc(f,28217,h+432|0);H[h+420>>2]=e;H[h+416>>2]=q;H[h+412>>2]=c;H[h+408>>2]=c;H[h+404>>2]=c;H[h+400>>2]=g;kc(f,22207,h+400|0);if(yc(k,14706,g)){H[h+392>>2]=H[j>>2];H[h+388>>2]=c;H[h+384>>2]=g;kc(f,19614,h+384|0)}if(!p){H[h+372>>2]=c;H[h+368>>2]=g;H[h+364>>2]=e;H[h+360>>2]=c;H[h+356>>2]=e;H[h+352>>2]=g;kc(f,27040,h+352|0)}if(i){e=H[f+44>>2]+1|0;H[f+44>>2]=e;Nc(n,e,c);fb(n,177,e,0,0,i,-11)}Kk(f,l,1);Ki(f,g,p,13900,0)}e=c}Cc(k,m);Za(k,e);break j}Os(f,d-8|0,d+4|0);break j}Os(f,0,0);break j}Ns(f,d-8|0,d+4|0);break j}Ns(f,0,0);break j}c=H[d+4>>2];Ms(f,25,50776,c,0,0,c);break j}c=H[d-32>>2];Ms(f,24,50660,c,c,H[d-8>>2],H[d+4>>2]);break j}c=H[d+4>>2];e=H[f>>2];df:{if(I[e+87|0]){break df}k=H[d-8>>2];if(ze(f)){break df}m=c+8|0;l=H[c+16>>2];i=H[c+12>>2];g=0;ef:{while(1){if(H[e+20>>2]>(g|0)){j=g>>>0<2^g;ff:{if(i){if(!Nk(e,j,i)){break ff}}j=Hc(H[(H[e+16>>2]+(j<<4)|0)+12>>2]+40|0,l);if(j){break ef}}g=g+1|0;continue}break}gf:{if(!k){H[h+320>>2]=m;Wa(f,19264,h+320|0);break gf}Ji(f,i)}F[f+17|0]=1;break df}Ls(f,j)}Cc(e,c);break j}H[d+4>>2]=3;break j}H[d+4>>2]=1;break j}c=sc(H[f>>2],71,d-8|0,1);H[d-56>>2]=c;if(!c){break j}F[c+1|0]=H[d-32>>2];break j}c=ib(f,71,0,0);H[d-32>>2]=c;if(!c){break j}F[c+1|0]=4;break j}i=d-20|0;j=H[i>>2];e=H[d-8>>2];k=H[d+4>>2];g=H[f>>2];c=nb(g,48,0);hf:{if(!c){fc(g,e);break hf}H[c+8>>2]=e;G[c>>1]=2954;O=c,P=Ks(g,j,k),H[O+36>>2]=P}H[i>>2]=c;break j}e=H[d-8>>2];i=H[f>>2];j=d-56|0;c=Gn(f,128,d-32|0,H[j>>2],H[d+4>>2]);if(c){jf:{if(I[f+220|0]>1){g=e;e=0;break jf}g=jb(i,e,1)}F[c+1|0]=11;H[c+20>>2]=g}eb(i,e);H[j>>2]=c;break j}g=H[d-8>>2];m=H[d-68>>2];e=H[d-20>>2];k=H[d-32>>2];j=H[f>>2];l=d-80|0;c=Gn(f,127,d-44|0,H[l>>2],H[d+4>>2]);kf:{if(c){lf:{if(I[f+220|0]>1){i=e;e=0;break lf}i=Ud(j,e,1)}H[c+32>>2]=g;H[c+28>>2]=k;H[c+8>>2]=i;F[c+1|0]=m;if(!g){break kf}Hk(f,H[g>>2]);break kf}re(j,k);Mk(j,g)}fc(j,e);H[l>>2]=c;break j}m=H[d-80>>2];c=H[d-8>>2];e=H[d-32>>2];i=H[d-20>>2];k=H[f>>2];l=d-92|0;j=Gn(f,129,d-68|0,H[l>>2],H[d+4>>2]);if(j){mf:{if(I[f+220|0]>=2){H[j+20>>2]=c;H[j+24>>2]=e;c=0;g=i;e=0;i=0;break mf}O=j,P=pc(k,e,1),H[O+24>>2]=P;O=j,P=jb(k,c,1),H[O+20>>2]=P;g=sh(k,i,1)}F[j+1|0]=m;H[j+16>>2]=g}pb(k,e);eb(k,c);Cc(k,i);H[l>>2]=j;break j}Wa(f,4583,0);break j}Wa(f,4499,0);break j}e=H[d+8>>2];c=d-20|0;H[c>>2]=H[d+4>>2];H[c+4>>2]=e;Wa(f,4668,0);break j}c=H[d-8>>2];H[c+44>>2]=c;break j}c=d-20|0;e=H[d-8>>2];H[H[H[c>>2]+44>>2]+40>>2]=e;H[H[c>>2]+44>>2]=e;break j}H[d-8>>2]=H[d+4>>2];break j}H[d+16>>2]=0;break j}H[d-20>>2]=129;H[d-16>>2]=H[d+4>>2];break j}H[d+8>>2]=0;H[d+4>>2]=J[d+2>>1];break j}H[d+16>>2]=33;break j}H[d-8>>2]=65;break j}H[d+4>>2]=J[d+2>>1];break j}w=d-68|0;r=d-80|0;m=H[d-92>>2];n=H[d-20>>2];e=H[d-40>>2];M=H[d-44>>2];q=H[d-56>>2];l=H[f>>2];i=H[d+4>>2];nf:{of:{pf:{u=d-116|0;v=H[u>>2];qf:{if(v){if(H[d+-64>>2]){Wa(f,13961,0);break of}H[h+704>>2]=r;k=1;if(n){break qf}break pf}k=Lf(f,r,w,h+704|0);if(!n|(k|0)<0){break of}}if(I[l+87|0]){break of}if(!(!I[l+177|0]|(k|0)==1)){Za(l,H[n+12>>2]);H[n+12>>2]=0}g=rh(f,n);k=I[l+177|0]|(H[d+-64>>2]|!g)?k:H[g+60>>2]==H[H[l+16>>2]+28>>2]?1:k;if(I[l+87|0]){break of}c=H[f>>2];H[h+712>>2]=f;c=H[c+16>>2]+(k<<4)|0;H[h+752>>2]=H[c>>2];H[h+744>>2]=H[c+12>>2];H[h+716>>2]=f;H[h+720>>2]=11;H[h+724>>2]=12;H[h+728>>2]=13;c=0;H[h+732>>2]=0;G[h+736>>1]=0;F[h+748|0]=(k|0)==1;H[h+756>>2]=9411;g=H[h+704>>2];H[h+760>>2]=g;j=h+712|0;H[h+740>>2]=j;if(Fn(j,n)){break of}j=0;rf:{p=rh(f,n);if(!p){break rf}if(I[p+43|0]==1){Wa(f,5595,0);break rf}sf:{if(!(I[p+29|0]&16)){break sf}if(!qh(l)){break sf}Wa(f,5555,0);break rf}c=tc(l,g);if(!c){break pf}if(Ik(f,c,9411,H[p>>2])){break of}tf:{if(I[f+220|0]>1){break tf}if(!Hc(H[(H[l+16>>2]+(k<<4)|0)+12>>2]+40|0,c)){break tf}if(!m){H[h+304>>2]=g;Wa(f,3819,h+304|0);break of}ld(f,k);break of}g=H[p>>2];if(!yb(g,18214,7)){Wa(f,14162,0);break nf}m=I[p+43|0];if(!((q|0)==65|(m|0)!=2)){H[h+276>>2]=n+8;H[h+272>>2]=(q|0)==33?20262:19468;Wa(f,19227,h+272|0);break rf}if(!((m|0)==2|(q|0)!=65)){H[h+288>>2]=n+8;Wa(f,19284,h+288|0);break rf}if(I[f+220|0]<=1){z=H[l+16>>2];m=Fb(l,H[p+60>>2]);A=H[z+(m<<4)>>2];j=A;m=(m|0)==1;if(Yb(f,v?5:m?5:7,c,g,v?H[z+16>>2]:j)){break of}j=0;if(Yb(f,18,m?9192:9211,0,A)){break nf}}j=nb(l,36,0);if(!j){break of}H[j>>2]=c;c=Tb(l,H[n+16>>2]);H[j+4>>2]=c;H[j+20>>2]=H[(H[l+16>>2]+(k<<4)|0)+12>>2];g=H[p+60>>2];F[j+9|0]=(q|0)==65?1:(q|0)==33?1:2;F[j+8|0]=M;H[j+24>>2]=g;uf:{if(I[f+220|0]>=2){dd(f,c,H[n+16>>2]);c=i;i=0;break uf}c=jb(l,i,1)}H[j+16>>2]=e;H[j+12>>2]=c;H[f+256>>2]=j;c=0;e=0;break nf}if(I[l+176|0]!=1){break nf}F[l+178|0]=I[l+178|0]|1;break nf}c=0}j=0}Za(l,c);Cc(l,n);re(l,e);eb(l,i);if(!H[f+256>>2]){Qh(l,j)}if(!H[d+-64>>2]){c=H[r+4>>2];H[u>>2]=H[r>>2];H[u+4>>2]=c;break j}c=H[w+4>>2];H[u>>2]=H[w>>2];H[u+4>>2]=c;break j}g=H[d-8>>2];q=H[d-32>>2];j=H[f>>2];e=H[f+256>>2];c=H[d+8>>2];i=H[d+4>>2];H[f+256>>2]=0;vf:{if(H[f+36>>2]|!e){break vf}r=c+(i-q|0)|0;n=H[e>>2];m=Fb(j,H[e+20>>2]);H[e+28>>2]=g;c=e+28|0;while(1){if(g){H[g+4>>2]=e;g=H[g+40>>2];continue}break}H[h+704>>2]=n;g=bb(n);H[h+712>>2]=f;H[h+708>>2]=g;g=H[j+16>>2]+(m<<4)|0;H[h+752>>2]=H[g>>2];g=H[g+12>>2];H[h+756>>2]=9411;H[h+744>>2]=g;F[h+748|0]=(m|0)==1;G[h+736>>1]=0;H[h+732>>2]=0;H[h+728>>2]=13;H[h+724>>2]=12;H[h+720>>2]=11;H[h+716>>2]=f;H[h+760>>2]=h+704;H[h+740>>2]=h+712;k=h+716|0;g=c;while(1){l=H[g>>2];if(l){g=0;if(ec(k,H[l+8>>2])){break vf}if(Jb(k,H[l+20>>2])){break vf}if(hc(k,H[l+24>>2])){break vf}if(Fn(h+712|0,H[l+16>>2])){break vf}i=l+32|0;while(1){p=H[i>>2];if(p){if(hc(k,H[p>>2])){break vf}if(Jb(k,H[p+4>>2])){break vf}if(hc(k,H[p+8>>2])){break vf}i=p+16|0;if(!Jb(k,H[p+12>>2])){continue}break vf}break}g=l+40|0;continue}break}g=0;if(Jb(k,H[e+12>>2])){break vf}wf:{if(I[f+220|0]>=2){H[f+256>>2]=e;e=0;break wf}if(I[j+177|0]){break wf}xf:{if(!qh(j)){break xf}while(1){c=H[c>>2];if(!c){break xf}yf:{i=H[c+12>>2];if(i){if(En(j,i)){break yf}}c=c+40|0;continue}break}i=H[e>>2];H[h+260>>2]=H[c+12>>2];H[h+256>>2]=i;Wa(f,29463,h+256|0);break vf}i=wb(f);if(!i){break vf}kd(f,0,m);c=Dd(j,q,r,0);k=H[H[j+16>>2]+(m<<4)>>2];l=H[e+4>>2];H[h+252>>2]=c;H[h+248>>2]=l;H[h+244>>2]=n;H[h+240>>2]=k;kc(f,27320,h+240|0);Za(j,c);Kf(f,m);H[h+224>>2]=n;oh(i,m,mb(j,28140,h+224|0),0)}if(!I[j+177|0]){break vf}c=od(H[(H[j+16>>2]+(m<<4)|0)+12>>2]+40|0,n,e);if(c){Ib(j);e=c;break vf}c=H[e+24>>2];if((c|0)==H[e+20>>2]){c=Hc(c+8|0,H[e+4>>2]);H[e+32>>2]=H[c+56>>2];H[c+56>>2]=e}e=0}Qh(j,e);Hn(j,g);break j}Ii(f,d-44|0,d-32|0,d-8|0,1);break j}Ii(f,d-32|0,d-20|0,d+4|0,1);break j}Ii(f,d-44|0,d-32|0,d-8|0,0);break j}Ii(f,d-32|0,d-20|0,d+4|0,0);break j}Ii(f,d-8|0,d+4|0,0,0);break j}Js(f,d-8|0,H[d+4>>2]);break j}Js(f,0,H[d+4>>2]);break j}g=H[d+4>>2];i=H[f>>2];zf:{if(I[i+87|0]){break zf}e=H[d-8>>2];if(ze(f)){break zf}c=ef(i,H[g+16>>2],H[g+12>>2]);if(!c){Af:{if(!e){H[h+176>>2]=g+8;Wa(f,19209,h+176|0);break Af}Ji(f,H[g+12>>2]);Gk(f)}F[f+17|0]=1;break zf}if(I[c+55|0]&3){H[h+208>>2]=0;Wa(f,15788,h+208|0);break zf}j=H[c+12>>2];e=Fb(i,H[c+24>>2]);k=(e|0)==1;m=H[H[i+16>>2]+(e<<4)>>2];if(Yb(f,9,k?9192:9211,0,m)){break zf}if(Yb(f,k?12:10,H[c>>2],H[j>>2],m)){break zf}j=wb(f);if(!j){break zf}kd(f,1,e);k=H[H[i+16>>2]+(e<<4)>>2];H[h+196>>2]=H[c>>2];H[h+192>>2]=k;kc(f,27653,h+192|0);Is(f,e,1570,H[c>>2]);Kf(f,e);Hs(f,H[c+44>>2],e);fb(j,152,e,0,0,H[c>>2],0)}Cc(i,g);break j}c=d-20|0;O=c,P=Gs(f,0,c,H[d-8>>2],H[d+4>>2]),H[O>>2]=P;break j}c=d-44|0;O=c,P=Gs(f,H[c>>2],d-20|0,H[d-8>>2],H[d+4>>2]),H[O>>2]=P;break j}H[d+16>>2]=0;break j}H[d+4>>2]=2;break j}c=d-44|0;Hi(f,d-80|0,d-68|0,Gd(f,0,c,0),H[d-20>>2],H[d-116>>2],d-128|0,H[d+4>>2],0,H[d-92>>2],0);if(I[f+220|0]<2){break j}e=H[f+252>>2];if(!e){break j}ue(f,H[e>>2],c);break j}H[d-20>>2]=H[d-8>>2];break j}O=d,P=Yc(H[f>>2],H[d+4>>2]),H[O+4>>2]=P;break j}c=d-20|0;O=c,P=Pb(f,H[c>>2],H[d+4>>2]),H[O>>2]=P;break j}c=d-32|0;e=Yc(H[f>>2],H[d-20>>2]);H[c>>2]=e;O=c,P=Pb(f,e,H[d+4>>2]),H[O>>2]=P;break j}c=d-44|0;e=Pb(f,H[c>>2],H[d-20>>2]);H[c>>2]=e;O=c,P=Pb(f,e,H[d+4>>2]),H[O>>2]=P;break j}g=d-44|0;c=ib(f,157,H[d-32>>2],0);H[g>>2]=c;if(c){e=H[d-20>>2];i=H[d-8>>2];if(i){e=Pb(f,e,i);c=H[g>>2]}H[c+20>>2]=e;Fk(f,H[g>>2]);break j}pb(H[f>>2],H[d-20>>2]);eb(H[f>>2],H[d-8>>2]);break j}c=ib(f,20,0,0);H[d-32>>2]=c;Ag(f,c,H[d-8>>2]);break j}c=Gd(f,0,d-20|0,d-8|0);e=xd(f,0,c,0,0,0,0,0,0);g=H[d+4>>2];if(g){Fs(f,e?c:0,g)}c=d-44|0;g=ib(f,49,H[c>>2],0);H[c>>2]=g;Ag(f,g,e);if(!H[d-32>>2]){break j}O=c,P=ib(f,19,H[c>>2],0),H[O>>2]=P;break j}c=d-44|0;e=ib(f,49,H[c>>2],0);H[c>>2]=e;Ag(f,e,H[d-8>>2]);if(!H[d-32>>2]){break j}O=c,P=ib(f,19,H[c>>2],0),H[O>>2]=P;break j}c=ib(f,138,0,0);H[d-20>>2]=c;Ag(f,c,H[d-8>>2]);break j}e=d-8|0;c=H[e>>2];if(!c){c=d-44|0;Es(f,H[c>>2]);e=c;c=oc(H[f>>2],117,H[d-32>>2]?12960:13493);H[e>>2]=c;if(!c){break j}Ek(c);break j}Bf:{Cf:{if(H[c>>2]!=1){break Cf}Df:{g=H[c+8>>2];if(!ge(g)){c=H[e>>2];break Df}c=H[e>>2];i=d-44|0;if(I[H[i>>2]]==177){break Df}H[c+8>>2]=0;pb(H[f>>2],H[e>>2]);c=ib(f,174,g,0);O=i,P=ib(f,53,H[i>>2],c),H[O>>2]=P;break Bf}if(H[c>>2]!=1|I[g|0]!=138){break Cf}i=d-44|0;c=ib(f,49,H[i>>2],0);H[i>>2]=c;Ag(f,c,H[g+20>>2]);H[g+20>>2]=0;pb(H[f>>2],H[e>>2]);break Bf}i=d-44|0;c=ib(f,49,H[i>>2],0);H[i>>2]=c;if(!c){pb(H[f>>2],H[e>>2]);break Bf}g=H[c+12>>2];if(I[g|0]==177){j=H[e>>2];l=j+8|0;m=H[H[g+20>>2]>>2];e=0;g=0;while(1){Ef:{Ff:{if(H[j>>2]>(g|0)){c=1;k=H[l+(g<<4)>>2];if(I[k|0]==177){c=H[H[k+20>>2]>>2]}if((c|0)==(m|0)){c=xd(f,H[k+20>>2],0,0,0,0,0,512,0);H[k+20>>2]=0;if(!c){break Ef}if(!e){break Ff}H[c+52>>2]=e;F[c|0]=135;break Ff}H[h+168>>2]=m;H[h+160>>2]=c;H[h+164>>2]=(c|0)>1?8864:30558;Wa(f,17275,h+160|0)}if(e){if(H[e+52>>2]){H[e+4>>2]=H[e+4>>2]|1024}$f(H[f>>2],j);Dk(f,e);Ag(f,H[i>>2],e);break Bf}$f(H[f>>2],j);break Bf}e=c}g=g+1|0;continue}}H[c+20>>2]=H[e>>2];Fk(f,H[i>>2])}if(!H[d-32>>2]){break j}c=d-44|0;O=c,P=ib(f,19,H[c>>2],0),H[O>>2]=P;break j}g=Pb(f,Yc(H[f>>2],H[d-20>>2]),H[d+4>>2]);c=d-44|0;e=ib(f,48,H[c>>2],0);H[c>>2]=e;Gf:{if(e){H[e+20>>2]=g;break Gf}pb(H[f>>2],g)}if(!H[d-32>>2]){break j}O=c,P=ib(f,19,H[c>>2],0),H[O>>2]=P;break j}H[d+4>>2]=0;break j}c=d-20|0;e=Yc(H[f>>2],H[c>>2]);O=c,P=te(f,Pb(f,e,H[d+4>>2]),d-8|0,0),H[O>>2]=P;break j}O=d-8|0,P=ib(f,J[d-10>>1]==106?174:173,H[d+4>>2],0),H[O>>2]=P;break j}O=d-8|0,P=ib(f,J[d-10>>1],H[d+4>>2],0),H[O>>2]=P;break j}e=d-44|0;c=ib(f,171,H[e>>2],H[d+4>>2]);H[e>>2]=c;Ck(f,H[d+4>>2],c,51);break j}e=d-56|0;c=ib(f,45,H[e>>2],H[d+4>>2]);H[e>>2]=c;Ck(f,H[d+4>>2],c,50);break j}e=d-32|0;c=ib(f,171,H[e>>2],H[d+4>>2]);H[e>>2]=c;Ck(f,H[d+4>>2],c,51);break j}e=d-20|0;c=ib(f,45,H[e>>2],H[d+4>>2]);H[e>>2]=c;Ck(f,H[d+4>>2],c,50);break j}c=d-20|0;O=c,P=ib(f,51,H[c>>2],0),H[O>>2]=P;break j}c=d-8|0;O=c,P=ib(f,J[d+2>>1],H[c>>2],0),H[O>>2]=P;break j}e=d-28|0;c=H[e>>2];H[e>>2]=c&2147483647;e=d-44|0;g=te(f,Pb(f,Pb(f,Yc(H[f>>2],H[d-20>>2]),H[e>>2]),H[d+4>>2]),d-32|0,0);H[e>>2]=g;if((c|0)<0){g=ib(f,19,g,0);H[e>>2]=g}if(!g){break j}H[g+4>>2]=H[g+4>>2]|256;break j}e=d-4|0;c=H[e>>2];H[e>>2]=c&2147483647;e=d-20|0;g=te(f,Pb(f,Yc(H[f>>2],H[d+4>>2]),H[e>>2]),d-8|0,0);H[e>>2]=g;if((c|0)<0){g=ib(f,19,g,0);H[e>>2]=g}if(!g){break j}H[g+4>>2]=H[g+4>>2]|256;break j}e=H[d+8>>2];g=d-8|0;H[g>>2]=H[d+4>>2];H[g+4>>2]=e;H[d-4>>2]=e|-2147483648;break j}c=d-20|0;O=c,P=ib(f,J[d-10>>1],H[c>>2],H[d+4>>2]),H[O>>2]=P;break j}c=d-20|0;O=c,P=Td(f,H[c>>2],H[d+4>>2]),H[O>>2]=P;break j}c=Pb(f,H[d-32>>2],H[d-8>>2]);g=d-44|0;e=ib(f,177,0,0);H[g>>2]=e;if(e){H[e+20>>2]=c;if(!H[c>>2]){break j}e=H[g>>2];H[e+4>>2]=H[e+4>>2]|H[H[c+8>>2]+4>>2]&4194824;break j}pb(H[f>>2],c);break j}O=d,P=te(f,0,d+4|0,0),H[O+4>>2]=P;break j}c=d-44|0;e=te(f,0,c,0);Dn(f,e,H[d+4>>2]);H[c>>2]=e;break j}e=d-92|0;c=te(f,H[d-56>>2],e,H[d-68>>2]);Dn(f,c,H[d+4>>2]);Ds(f,c,H[d-20>>2]);H[e>>2]=c;break j}c=d-56|0;e=te(f,H[d-20>>2],c,H[d-32>>2]);Dn(f,e,H[d+4>>2]);H[c>>2]=e;break j}c=d-32|0;O=c,P=te(f,0,c,0),H[O>>2]=P;break j}c=d-80|0;e=te(f,H[d-44>>2],c,H[d-56>>2]);Ds(f,e,H[d-8>>2]);H[c>>2]=e;break j}c=d-44|0;O=c,P=te(f,H[d-8>>2],c,H[d-20>>2]),H[O>>2]=P;break j}c=sc(H[f>>2],36,d-8|0,1);H[d-56>>2]=c;Cs(H[f>>2],c,H[d-32>>2],0);break j}c=d-20|0;O=c,P=Bs(f,H[c>>2],d+4|0,1),H[O>>2]=P;break j}Hf:{c=H[d+4>>2];if(!(I[c|0]==35&I[c+1|0]-58>>>0>4294967285)){l=H[d+8>>2];c=H[d+8>>2];H[h+136>>2]=H[d+4>>2];H[h+140>>2]=c;n=Qe(f,156,h+136|0);H[d+4>>2]=n;if(!n){break j}m=H[f>>2];p=H[n+8>>2];e=F[p+1|0];c=e>>31;i=c;If:{if(!(c|e)){e=J[f+216>>1]+1|0;G[f+216>>1]=e;break If}Jf:{Kf:{if(I[p|0]==63){Lf:{if((l|0)==2){g=0;c=e-48|0;e=i-(e>>>0<48)|0;break Lf}g=(bg(p+1|0,h+712|0,l-1|0,1)|0)!=0;c=H[h+712>>2];e=H[h+716>>2]}i=H[m+156>>2];j=!c&(e|0)<=0|(e|0)<0|g;g=i>>31;if(j|((g|0)<=(e|0)&c>>>0>i>>>0|(e|0)>(g|0))){break Hf}e=c<<16>>16;if((e|0)<=G[f+216>>1]){break Kf}G[f+216>>1]=e;g=H[f+236>>2];break Jf}g=H[f+236>>2];e=iw(g,p,l);if(e&65535){break If}e=J[f+216>>1]+1|0;G[f+216>>1]=e;break Jf}g=H[f+236>>2];if(kw(g,e)){break If}}q=((l|0)/4|0)+3|0;c=q;r=c>>31;Mf:{Nf:{if(g){j=H[g+4>>2];k=c+j|0;c=H[g>>2];if((k|0)<=(c|0)){c=g;break Nf}i=c>>31<<1|c>>>31;j=c<<1}else{i=0;j=10}c=j;i=i+r|0;c=c+q|0;i=j>>>0>c>>>0?i+1|0:i;k=c;c=ed(m,g,c<<2,i<<2|c>>>30);if(!c){c=g;break Mf}if(g){j=H[c+4>>2]}else{H[c+4>>2]=2;j=2}H[c>>2]=k;k=j+q|0}g=(j<<2)+c|0;H[g>>2]=e<<16>>16;H[g+4>>2]=q;H[c+4>>2]=k;O=Va(g+8|0,p,l)+l|0,P=0,F[O|0]=P}H[f+236>>2]=c}G[n+32>>1]=e;if(H[m+156>>2]>=e<<16>>16){break j}Wa(f,5822,0);Mg(H[f>>2],n);break j}e=H[d+8>>2];c=H[d+4>>2];H[h+712>>2]=c;H[h+716>>2]=e;if(!I[f+18|0]){H[h+144>>2]=h+712;Wa(f,9027,h+144|0);H[d+4>>2]=0;break j}e=ib(f,176,0,0);H[d+4>>2]=e;if(!e){break j}cg(c+1|0,e+28|0);break j}H[h+128>>2]=i;Wa(f,16631,h+128|0);Mg(H[f>>2],n);break j}c=sc(H[f>>2],155,d+4|0,1);if(c){H[c+36>>2]=H[d+4>>2]-H[f+244>>2]}H[d+4>>2]=c;break j}c=J[d+2>>1];e=H[d+8>>2];H[h+120>>2]=H[d+4>>2];H[h+124>>2]=e;O=d,P=Qe(f,c,h+120|0),H[O+4>>2]=P;break j}c=d-44|0;e=H[c+4>>2];H[h+112>>2]=H[c>>2];H[h+116>>2]=e;e=Qe(f,59,h+112|0);g=d-20|0;i=H[g+4>>2];H[h+104>>2]=H[g>>2];H[h+108>>2]=i;g=Qe(f,59,h+104|0);i=H[d+8>>2];H[h+96>>2]=H[d+4>>2];H[h+100>>2]=i;g=ib(f,141,g,Qe(f,59,h+96|0));if(I[f+220|0]>=2){dd(f,0,e)}O=c,P=ib(f,141,e,g),H[O>>2]=P;break j}c=d-20|0;e=H[c+4>>2];H[h+88>>2]=H[c>>2];H[h+92>>2]=e;e=Qe(f,59,h+88|0);g=H[d+8>>2];H[h+80>>2]=H[d+4>>2];H[h+84>>2]=g;O=c,P=ib(f,141,e,Qe(f,59,h+80|0)),H[O>>2]=P;break j}c=H[d+8>>2];H[h+72>>2]=H[d+4>>2];H[h+76>>2]=c;O=d,P=Qe(f,59,h+72|0),H[O+4>>2]=P;break j}H[d-20>>2]=H[d-8>>2];break j}O=d,P=Cn(f,0,d+4|0),H[O+4>>2]=P;break j}c=d-20|0;O=c,P=Cn(f,H[c>>2],d+4|0),H[O>>2]=P;break j}H[d-20>>2]=H[d-8>>2];break j}H[d+16>>2]=0;break j}Bk(f,H[d+4>>2]);break j}O=d-80|0,P=Gi(H[f>>2],0,0,H[d-20>>2],H[d-8>>2],0),H[O>>2]=P;break j}O=d-44|0,P=Gi(H[f>>2],0,0,0,0,0),H[O>>2]=P;break j}O=d-92|0,P=Gi(H[f>>2],H[d-56>>2],H[d-32>>2],0,0,H[d+4>>2]),H[O>>2]=P;break j}O=d-128|0,P=Gi(H[f>>2],H[d-92>>2],H[d-68>>2],H[d-20>>2],H[d-8>>2],H[d+4>>2]),H[O>>2]=P;break j}H[d-8>>2]=0;Bk(f,H[d+4>>2]);break j}H[d+16>>2]=0;break j}Bn(f,H[d-44>>2],0,H[d-32>>2],H[d-68>>2],0);break j}Bn(f,H[d-32>>2],H[d-8>>2],H[d-20>>2],H[d-56>>2],H[d+4>>2]);break j}O=d-44|0,P=As(f,0,H[d-32>>2],H[d+4>>2]),H[O>>2]=P;break j}c=Yc(H[f>>2],H[d+4>>2]);e=d-20|0;zg(f,c,e,1);H[e>>2]=c;break j}c=d-68|0;O=c,P=As(f,H[c>>2],H[d-32>>2],H[d+4>>2]),H[O>>2]=P;break j}e=d-44|0;c=Pb(f,H[e>>2],H[d+4>>2]);H[e>>2]=c;zg(f,c,d-20|0,1);break j}c=d-56|0;An(f,H[c>>2],d-44|0);e=d-20|0;zs(f,H[e>>2],2446);g=H[d-8>>2];Of:{if(!g){g=H[c>>2];break Of}if(H[g>>2]>=2){g=xd(f,0,g,0,0,0,0,2048,0);H[h+712>>2]=0;H[h+716>>2]=0;g=Pe(f,0,0,0,h+712|0,g,0)}g=ys(f,H[c>>2],g);H[c>>2]=g}zn(f,g,H[e>>2],H[d+4>>2],H[d-68>>2],0);break j}Bk(f,H[d+4>>2]);H[d-32>>2]=H[d-20>>2];break j}Bk(f,H[d+4>>2]);H[d-8>>2]=0;break j}c=d-20|0;An(f,H[c>>2],d-8|0);yn(f,H[c>>2],H[d+4>>2]);break j}O=d-32|0,P=ib(f,148,H[d+4>>2],H[d-20>>2]),H[O>>2]=P;break j}O=d-32|0,P=ib(f,148,H[d-20>>2],H[d+4>>2]),H[O>>2]=P;break j}O=d-8|0,P=ib(f,148,H[d+4>>2],0),H[O>>2]=P;break j}H[d-8>>2]=H[d+4>>2];break j}H[d+16>>2]=0;break j}H[d-8>>2]=1;break j}H[d-8>>2]=0;break j}H[d+16>>2]=-1;break j}H[d+4>>2]=1;break j}H[d+4>>2]=0;break j}e=d-20|0;c=Yc(H[f>>2],H[e>>2]);H[e>>2]=c;xs(c,H[d-8>>2],H[d+4>>2]);break j}e=d-44|0;c=Pb(f,H[e>>2],H[d-20>>2]);H[e>>2]=c;xs(c,H[d-8>>2],H[d+4>>2]);break j}H[d-20>>2]=H[d+4>>2];break j}c=d-8|0;H[c>>2]=0;H[c+4>>2]=1;break j}e=H[d+8>>2];c=d-20|0;H[c>>2]=H[d+4>>2];H[c+4>>2]=e;break j}H[d+16>>2]=0;H[d+20>>2]=0;break j}H[d-32>>2]=0;H[d-28>>2]=H[d-8>>2];break j}H[d-4>>2]=0;H[d-8>>2]=H[d+4>>2];break j}c=d-32|0;O=c,P=xn(f,c,d-20|0,d-8|0),H[O>>2]=P;break j}c=d-20|0;O=c,P=xn(f,c,d-8|0,0),H[O>>2]=P;break j}c=d-8|0;O=c,P=xn(f,c,0,0),H[O>>2]=P;break j}H[d+4>>2]=1;break j}c=d-20|0;e=Gd(f,0,c,0);H[c>>2]=e;if(!e){break j}e=tc(H[f>>2],d+4|0);H[H[c>>2]+20>>2]=e;break j}c=d-44|0;e=Gd(f,0,c,d-20|0);H[c>>2]=e;if(!e){break j}e=tc(H[f>>2],d+4|0);H[H[c>>2]+20>>2]=e;break j}c=d-20|0;O=c,P=Gd(f,0,c,d+4|0),H[O>>2]=P;break j}O=d,P=Gd(f,0,d+4|0,0),H[O+4>>2]=P;break j}e=d-20|0;g=d+4|0;c=Gd(f,0,e,g);if(!(!c|I[f+220|0]<2)){ue(f,H[c+16>>2],g)}H[e>>2]=c;break j}c=d+4|0;e=Gd(f,0,c,0);if(!(!e|I[f+220|0]<2)){ue(f,H[e+16>>2],c)}H[c>>2]=e;break j}H[d+16>>2]=0;H[d+20>>2]=0;break j}c=d-56|0;i=H[c>>2];if(!(i|H[d-4>>2]|(H[d+4>>2]|H[d+8>>2]))){H[c>>2]=H[d-32>>2];break j}g=d-32|0;e=H[g>>2];if(!(!e|H[e>>2]!=1)){e=c;c=Pe(f,i,0,0,d-8|0,0,d+4|0);H[e>>2]=c;if(c){j=c+(H[c>>2]<<6)|0;e=j+-64|0;c=H[g>>2];H[e+16>>2]=H[c+16>>2];H[e+12>>2]=H[c+12>>2];i=H[c+28>>2];H[e+28>>2]=i;e=j-56|0;if(!(!i|!(I[i+5|0]&8))){i=I[e+37|0]|I[e+38|0]<<8|8192;F[e+37|0]=i;F[e+38|0]=i>>>8}if(I[c+45|0]&4){H[e+56>>2]=H[c+64>>2];H[c+64>>2]=0;i=(I[c+45|0]|I[c+46|0]<<8)&65531;F[c+45|0]=i;F[c+46|0]=i>>>8;i=I[e+37|0]|I[e+38|0]<<8|4;F[e+37|0]=i;F[e+38|0]=i>>>8}H[c+28>>2]=0;H[c+12>>2]=0;H[c+16>>2]=0}Cc(H[f>>2],H[g>>2]);break j}ws(e);e=xd(f,0,H[g>>2],0,0,0,0,2048,0);O=c,P=Pe(f,H[c>>2],0,0,d-8|0,e,d+4|0),H[O>>2]=P;break j}c=d-56|0;O=c,P=Pe(f,H[c>>2],0,0,d-8|0,H[d-32>>2],d+4|0),H[O>>2]=P;break j}e=d-80|0;c=Pe(f,H[e>>2],d-68|0,d-56|0,d-8|0,0,d+4|0);H[e>>2]=c;Fs(f,c,H[d-32>>2]);break j}e=d-56|0;c=Pe(f,H[e>>2],d-44|0,d-32|0,d-20|0,0,d+4|0);H[e>>2]=c;An(f,c,d-8|0);break j}c=d-44|0;O=c,P=Pe(f,H[c>>2],d-32|0,d-20|0,d-8|0,0,d+4|0),H[O>>2]=P;break j}c=H[d-8>>2];if(!c){break j}e=H[c>>2];if((e|0)<=0){break j}F[(c+(e<<6)|0)-20|0]=H[d+4>>2];break j}c=H[d+4>>2];H[d-8>>2]=c;ws(c);break j}H[d+16>>2]=0;break j}e=H[d+8>>2];c=d-8|0;H[c>>2]=H[d+4>>2];H[c+4>>2]=e;break j}c=ib(f,180,0,0);if(!(!c|I[c+4|0]&3)){H[c+36>>2]=H[d+4>>2]-H[f+244>>2]}e=d-20|0;g=H[e+4>>2];H[h+64>>2]=H[e>>2];H[h+68>>2]=g;c=ib(f,141,Qe(f,59,h- -64|0),c);e=d-44|0;O=e,P=Pb(f,H[e>>2],c),H[O>>2]=P;break j}c=oc(H[f>>2],180,0);if(!(!c|I[c+4|0]&3)){H[c+36>>2]=H[d+4>>2]-H[f+244>>2]}e=d-20|0;O=e,P=Pb(f,H[e>>2],c),H[O>>2]=P;break j}c=d-44|0;g=Pb(f,H[c>>2],H[d-20>>2]);H[c>>2]=g;if(H[d+8>>2]){zg(f,g,d+4|0,1);g=H[c>>2]}if(!g){break j}c=(H[g>>2]<<4)+g|0;if(H[c-4>>2]){break j}c=c-8|0;O=c,P=wn(H[f>>2],H[d-32>>2],H[d-8>>2]),H[O+4>>2]=P;e=(I[c+9|0]|I[c+10|0]<<8)&65532|1;F[c+9|0]=e;F[c+10|0]=e>>>8;break j}H[d+16>>2]=0;break j}H[d+4>>2]=2;break j}H[d+4>>2]=1;break j}e=d-44|0;c=H[e>>2];g=xd(f,H[d-8>>2],0,0,0,0,0,1536,0);if(c){H[c+4>>2]=H[c+4>>2]&-1025}Pf:{if(!g){g=c;break Pf}H[g+52>>2]=c;F[g|0]=135}H[e>>2]=g;break j}O=d-32|0,P=xd(f,H[d-8>>2],0,0,0,0,0,512,0),H[O>>2]=P;break j}c=xd(f,H[d-80>>2],H[d-68>>2],H[d-56>>2],H[d-44>>2],H[d-32>>2],H[d-8>>2],H[d-92>>2],H[d+4>>2]);H[d-104>>2]=c;if(c){H[c+72>>2]=H[d-20>>2];break j}ao(H[f>>2],H[d-20>>2]);break j}O=d-92|0,P=xd(f,H[d-68>>2],H[d-56>>2],H[d-44>>2],H[d-32>>2],H[d-20>>2],H[d-8>>2],H[d-80>>2],H[d+4>>2]),H[O>>2]=P;break j}H[d-8>>2]=135;break j}H[d+4>>2]=J[d+2>>1];break j}e=d-20|0;c=H[e>>2];Qf:{Rf:{g=H[d+4>>2];if(!g){break Rf}if(H[g+52>>2]){H[h+716>>2]=0;Dk(f,g);g=xd(f,0,Pe(f,0,0,0,h+712|0,g,0),0,0,0,0,0,0);if(!g){break Rf}}i=d-8|0;j=H[i>>2];H[g+52>>2]=c;F[g|0]=j;if(c){H[c+4>>2]=H[c+4>>2]&-1025}H[g+4>>2]=H[g+4>>2]&-1025;if(H[i>>2]==135){break Qf}F[f+22|0]=1;break Qf}fc(H[f>>2],c);g=0}H[e>>2]=g;break j}c=H[d+4>>2];if(!c){break j}Dk(f,c);break j}O=d-32|0,P=vs(f,H[d+4>>2],H[d-8>>2]),H[O>>2]=P;break j}O=d-20|0,P=vs(f,H[d+4>>2],H[d-8>>2]),H[O>>2]=P;break j}H[h+736>>2]=H[12208];c=H[12207];H[h+728>>2]=H[12206];H[h+732>>2]=c;c=H[12205];H[h+720>>2]=H[12204];H[h+724>>2]=c;c=H[12203];H[h+712>>2]=H[12202];H[h+716>>2]=c;Lc(f,H[d+4>>2],h+712|0);fc(H[f>>2],H[d+4>>2]);break j}us(f,H[d+4>>2],1,H[d-8>>2]);break j}e=H[d-56>>2];i=H[d-80>>2];j=H[d-20>>2];c=H[d+4>>2];H[h+700>>2]=0;g=H[f>>2];Sf:{if(G[f+216>>1]>0){Wa(f,3682,0);break Sf}k=d-44|0;m=d-32|0;Ln(f,k,m,i,1,0,e);e=H[f+248>>2];if(H[f+36>>2]|!e){break Sf}H[e+28>>2]=H[e+28>>2]|512;Lf(f,k,m,h+700|0);i=Fb(g,H[e+60>>2]);k=H[f>>2];H[h+712>>2]=f;k=H[k+16>>2]+(i<<4)|0;H[h+752>>2]=H[k>>2];H[h+744>>2]=H[k+12>>2];H[h+716>>2]=f;H[h+720>>2]=11;H[h+724>>2]=12;H[h+728>>2]=13;H[h+732>>2]=0;G[h+736>>1]=0;F[h+748|0]=(i|0)==1;H[h+756>>2]=1851;H[h+760>>2]=H[h+700>>2];H[h+740>>2]=h+712;if(ec(h+716|0,c)){break Sf}H[c+4>>2]=H[c+4>>2]|2097152;Tf:{if(I[f+220|0]>1){i=c;c=0;break Tf}i=Ud(g,c,1)}H[e+44>>2]=i;i=pc(g,j,1);F[e+43|0]=2;H[e+16>>2]=i;if(I[g+87|0]){break Sf}e=H[f+208>>2];i=H[d-92>>2];e=(I[e|0]==59?e:H[f+212>>2]+e|0)-i|0;k=i-1|0;while(1){i=e+k|0;e=e-1|0;if(F[I[i|0]+31152|0]&1){continue}break}H[h+708>>2]=1;H[h+704>>2]=i;Kn(f,0,h+704|0,0,0)}fc(g,c);if(I[f+220|0]>=2){ts(f,j)}pb(g,j);break j}us(f,H[d+4>>2],0,H[d-8>>2]);break j}H[d+4>>2]=5;break j}H[d+4>>2]=4;break j}H[d-20>>2]=H[d+4>>2];break j}H[d+16>>2]=11;break j}ss(f,H[d-68>>2],d-32|0,H[d-20>>2],H[d-8>>2]);rs(f,H[d+4>>2]);break j}qs(f,H[d-20>>2],H[d-32>>2],H[d-8>>2]);break j}Hi(f,0,0,0,H[d-20>>2],H[d+4>>2],0,0,0,0,1);break j}ps(f,H[d-32>>2],H[d+4>>2],H[d-20>>2],0);break j}H[f+84>>2]=0;break j}H[d-8>>2]=0;break j}H[d-8>>2]=1;break j}H[d-8>>2]=H[d+4>>2];break j}H[d-20>>2]=0;break j}H[d-8>>2]=0;break j}H[d+4>>2]=7;break j}H[d+4>>2]=10;break j}H[d-8>>2]=9;break j}H[d-8>>2]=8;break j}H[d-16>>2]=65280;H[d-20>>2]=H[d+4>>2]<<8;break j}H[d-16>>2]=255;H[d-20>>2]=H[d+4>>2];break j}c=d-20|0;H[c>>2]=0;H[c+4>>2]=0;break j}c=d-8|0;H[c>>2]=0;H[c+4>>2]=0;break j}c=d-8|0;H[c>>2]=H[d+4>>2]|H[c>>2]&(H[d+8>>2]^-1);break j}H[d+16>>2]=0;break j}H[d+4>>2]=1;break j}os(f,H[d-20>>2],d+4|0);break j}os(f,H[d-8>>2],0);break j}c=H[f+248>>2];if(!c|I[f+220|0]>1){break j}g=G[c+34>>1];i=H[f>>2];e=tc(i,d+4|0);if(!e){break j}Uf:{if(!Fi(f,e)){break Uf}j=g-1|0;k=N(j,12);ns(i,k+H[c+4>>2]|0,e);g=c+8|0;while(1){g=H[g>>2];if(!g){break Uf}if((j|0)==G[H[g+4>>2]>>1]){O=H[g+32>>2],P=Yf(k+H[c+4>>2]|0),H[O>>2]=P}g=g+20|0;continue}}db(i,e);break j}rs(f,H[d+4>>2]);break j}ss(f,0,d-20|0,H[d-8>>2],H[d+4>>2]);break j}qs(f,H[d-8>>2],H[d-20>>2],H[d+4>>2]);break j}Hi(f,0,0,0,0,H[d+4>>2],0,0,0,0,1);break j}ps(f,0,H[d-8>>2],H[d+4>>2],H[d-20>>2]);break j}c=H[f+248>>2];if(!c){break j}e=G[c+34>>1];if((e|0)<=0){break j}e=H[c+4>>2]+N(e,12)|0;g=e-8|0;F[g|0]=I[g|0]&240|H[d+4>>2]&15;H[c+28>>2]=H[c+28>>2]|2048;if(!(I[e-2|0]&8)){break j}g=c+8|0;while(1){e=H[g>>2];if(!e){break j}if(G[H[e+4>>2]>>1]==(G[c+34>>1]-1|0)){g=I[e+55|0]|I[e+56|0]<<8|8;F[e+55|0]=g;F[e+56|0]=g>>>8}g=e+20|0;continue}}c=H[d+8>>2];H[h+56>>2]=H[d+4>>2];H[h+60>>2]=c;c=Qe(f,117,h+56|0);if(c){Ek(c)}e=c;c=H[d+4>>2];Ei(f,e,c,c+H[d+8>>2]|0);break j}Ei(f,ib(f,173,H[d+4>>2],0),H[d-20>>2],H[d-8>>2]+H[d-4>>2]|0);break j}Ei(f,H[d+4>>2],H[d-20>>2],H[d-8>>2]+H[d-4>>2]|0);break j}Ei(f,H[d-8>>2],H[d-20>>2]+1|0,H[d+4>>2]);break j}c=H[d-8>>2];Ei(f,H[d+4>>2],c,c+H[d-4>>2]|0);break j}c=H[d+8>>2];H[f+80>>2]=H[d+4>>2];H[f+84>>2]=c;break j}c=H[o+28>>2];H[d+16>>2]=H[o+24>>2];H[d+20>>2]=c;break j}H[d+16>>2]=H[o+24>>2];break j}H[d-4>>2]=(H[d+8>>2]+H[d+4>>2]|0)-H[d-8>>2];break j}H[d-52>>2]=(H[d+4>>2]+H[d+8>>2]|0)-H[d-56>>2];break j}H[d-28>>2]=(H[d+4>>2]+H[d+8>>2]|0)-H[d-32>>2];break j}H[d+16>>2]=0;H[d+20>>2]=0;break j}e=0}m=H[h+708>>2];g=0;i=(e|0)!=0;A=i;i=e+i|0;g=A>>>0>i>>>0?1:g;n=i+m|0;i=n>>>0<i>>>0?g+1|0:g;g=n+1|0;i=g?i:i+1|0;i=nd(c,g,i);if(!i){break j}if(I[f+220|0]>=2){ue(f,i,h+704|0)}g=0;n=Va(i,H[h+704>>2],m);F[n+m|0]=0;pf(n);r=Cg(n);i=G[l+34>>1];u=(i|0)>0?i:0;m=H[l+4>>2];w=i>>31;Vf:{Wf:{while(1){if((g|0)!=(u|0)){Xf:{v=m+N(g,12)|0;if((r|0)!=I[v+7|0]){break Xf}if(ab(n,H[v>>2])){break Xf}H[h+32>>2]=n;Wa(f,8281,h+32|0);break Wf}g=g+1|0;continue}break}g=sJ(i,w,12,0);i=Ha;g=g+12|0;i=g>>>0<12?i+1|0:i;g=ed(c,m,g,i);if(g){break Vf}}db(c,n);break j}H[l+4>>2]=g;c=g+N(G[l+34>>1],12)|0;H[c+4>>2]=0;H[c+8>>2]=0;H[c>>2]=n;F[c+7|0]=r;Yf:{if(!e){F[c+6|0]=p;F[c+4|0]=q;break Yf}g=e;e=Va((bb(n)+n|0)+1|0,j,e);F[g+e|0]=0;pf(e);k=Mi(e,c);G[c+10>>1]=J[c+10>>1]|4}F[c+5|0]=k;G[l+34>>1]=J[l+34>>1]+1;G[l+36>>1]=J[l+36>>1]+1;H[f+84>>2]=0}c=N(F[D+37280|0],12)+d|0;e=J[c>>1];H[o+56>>2]=c+12;g=J[(D<<1)+48848>>1];G[c+14>>1]=g;i=c;c=J[(g+G[(e<<1)+50960>>1]<<1)+43440>>1];G[i+12>>1]=c;Ea=h+768|0;continue}break}if(g>>>0<=1242){e=H[o+56>>2];i=e+12|0;H[o+56>>2]=i;if(i>>>0>K[o+1264>>2]){H[o+56>>2]=e;Tv(o+56|0);break f}H[e+16>>2]=y;H[e+20>>2]=C;G[e+14>>1]=s;G[e+12>>1]=g>>>0>578?c+408|0:c;break f}if((g|0)==1244){H[o+56>>2]=H[o+56>>2]-12;break f}H[o+1280>>2]=y;H[o+1284>>2]=C;H[o+1288>>2]=y;H[o+1292>>2]=C;c=H[o+60>>2];Zf:{if(I[y|0]){H[o+32>>2]=o+1288;Wa(c,9027,o+32|0);break Zf}Wa(c,2237,0)}H[o+60>>2]=c;Sv(o+56|0,s&65535,o+1280|0)}b=b+x|0;if(!H[a+12>>2]){continue}}break}while(1){if(K[o+56>>2]>E>>>0){Rv(o+56|0);continue}break}if(I[t+87|0]){H[a+12>>2]=7;c=7}else{c=H[a+12>>2]}e=H[a+4>>2];_f:{if(!e){e=0;if(!c|(c|0)==101){break _f}O=o,P=Sg(c),H[O+16>>2]=P;e=mb(t,8863,o+16|0);H[a+4>>2]=e;c=H[a+12>>2]}H[o+4>>2]=H[a+244>>2];H[o>>2]=e;Ec(c,29452,o);e=1}H[a+244>>2]=b;Ta(H[a+272>>2]);b=H[a+248>>2];if(!(I[a+220|0]|!b)){Cd(t,b)}b=H[a+256>>2];if(!(!b|I[a+220|0]>1)){Qh(t,b)}a=H[a+236>>2];if(a){Wb(t,a)}H[t+264>>2]=L;Ea=o+1296|0;return e}
function Lc(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0;g=Ea-352|0;Ea=g;q=H[a>>2];d=1;o=wb(a);a:{if(H[a+36>>2]|!b){break a}if(Yb(a,21,0,0,0)){break a}if(I[c|0]<=6){e=H[b+48>>2];if(e){id(a,44,e);H[b+48>>2]=0}H[b+4>>2]=H[b+4>>2]&-4194306|4194304}e=0;ee(a,b,0);b:{c:{if(H[a+36>>2]){break c}j=H[b+4>>2];if(j&8388608){f=H[b+32>>2];if(as(f+8|0,f)){b=H[f+20>>2];if(!b){b=H[H[f+24>>2]>>2]}H[g+176>>2]=b;Wa(a,8056,g+176|0);break c}H[b+4>>2]=j&-8388609}if(I[c|0]==9){$r(a,b)}d:{if(!(H[b+52>>2]|!H[b+68>>2]|(I[b+6|0]&16|I[a+220|0]>1))){n=wb(a);p=H[b+44>>2];t=H[b+40>>2];r=H[b+36>>2];k=H[b+32>>2];i=H[a>>2];H[g+192>>2]=0;f=H[b+68>>2];w=H[b+4>>2];j=nb(i,64,0);if(!j){up(i,7);break d}H[g+284>>2]=0;H[g+288>>2]=0;H[g+276>>2]=0;H[g+280>>2]=0;H[g+272>>2]=46;H[g+268>>2]=47;H[g+264>>2]=a;e=g+264|0;ec(e,b);d=H[b+4>>2];if(!(d&8)){H[g+272>>2]=0;H[g+268>>2]=48;hc(e,H[b+48>>2]);d=H[b+4>>2]}H[b+32>>2]=0;H[b+36>>2]=0;H[b+40>>2]=0;H[b+44>>2]=0;H[b+4>>2]=d&-1048585|1048576;l=Bi(a,Bi(a,0,H[f+8>>2],1),H[f+12>>2],1);e:{if(!l){break e}d=H[b+48>>2];if(!d){break e}e=H[d>>2];h=H[l>>2];if((e|0)>(h|0)){break e}H[l>>2]=e;if(!If(l,d,-1)){pb(i,H[b+48>>2]);H[b+48>>2]=0}H[l>>2]=h}d=H[a+40>>2];H[f+48>>2]=d;H[a+40>>2]=d+4;d=g+192|0;qn(a,f,k,H[b+28>>2],j,d);qn(a,f,k,H[b+48>>2],j,d);d=H[g+192>>2];if(d){e=H[d>>2]}else{e=0}H[f+76>>2]=e;e=Bi(a,Bi(a,d,H[f+8>>2],0),H[f+12>>2],0);H[g+192>>2]=e;d=f;while(1){if(d){h=H[H[d+72>>2]+20>>2];f:{if(I[H[d+44>>2]+6|0]&16){qn(a,f,k,h,j,g+192|0);e=H[g+192>>2];if(e){h=H[e>>2]}else{h=0}F[d+96|0]=1;H[d+80>>2]=h;break f}H[d+80>>2]=e?H[e>>2]:0;e=Bi(a,e,h,0);H[g+192>>2]=e}h=H[d+40>>2];if(h){e=Pb(a,e,jb(i,h,0));H[g+192>>2]=e}h=H[a+44>>2];m=h+1|0;H[d+52>>2]=m;h=h+2|0;H[a+44>>2]=h;H[d+56>>2]=h;Sa(n,75,0,m);d=H[d+36>>2];continue}break}if(!e){d=oc(i,155,24816);e=Yc(H[a>>2],d);H[g+192>>2]=e}f=0;d=xd(a,e,k,r,t,p,l,0,0);e=Gd(a,0,0,0);H[b+32>>2]=e;g:{h:{if(e){H[e+28>>2]=d;l=I[e+45|0]|I[e+46|0]<<8|8;F[e+45|0]=l;F[e+46|0]=l>>>8;wk(a,H[b+32>>2]);H[d+4>>2]=H[d+4>>2]|134217792;e=un(a,d,64);H[d+4>>2]=H[d+4>>2]|w&8;if(!e){break h}f=Va(j,e,64);H[f+28>>2]=H[f+28>>2]|16384;H[H[b+32>>2]+24>>2]=f;H[g+272>>2]=0;H[g+276>>2]=0;H[g+288>>2]=0;H[g+280>>2]=0;H[g+284>>2]=0;H[g+272>>2]=49;H[g+264>>2]=0;H[g+268>>2]=0;H[g+276>>2]=50;H[g+268>>2]=51;ec(g+264|0,d);f=1;break g}fc(i,d);f=1}e=j}d=I[i+87|0];id(a,52,e);if(!f|d){break d}}k=H[b+32>>2];d=H[b+4>>2];Xa(g+196|0,0,36);H[g+192>>2]=H[b+48>>2];w=d>>>3&1;j=0;while(1){i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{f=H[b+52>>2];if(!f){if(H[k>>2]<=(j|0)){break s}h=k+8|0;p=j<<6;f=h+p|0;m=H[f+16>>2];i=H[f+20>>2];d=I[f+36|0];u:{if(!(d&72)){break u}if(!on(H[b+36>>2],H[f+40>>2],d&64)|I[q+81|0]&32){break u}e=I[f+36|0];v:{if(!(e&8)){break v}if(e&16){e=e&247;F[f+36|0]=e;break v}F[f+36|0]=e&199;Ai(H[b+36>>2],H[f+40>>2],0);e=I[f+36|0]}d=j;if(!(e&64)){break u}while(1){d=d+1|0;e=H[k>>2];if((d|0)<(e|0)){e=h+(d<<6)|0;l=I[e+36|0];if(!(l&16)){continue}if(l&8){F[e+36|0]=l&239}else{F[e+36|0]=l&199;Ai(H[b+36>>2],H[e+40>>2],1)}continue}break}while(1){if((e|0)<=0){break u}e=e-1|0;l=h+(e<<6)|0;d=I[l+36|0];F[l+36|0]=d&191;if(!(d&16)){continue}break}}if(!i){break j}d=H[H[i+28>>2]>>2];e=G[m+34>>1];if((d|0)!=(e|0)){b=H[m>>2];H[g+8>>2]=d;H[g+4>>2]=b;H[g>>2]=e;Wa(a,17054,g);break d}if(!I[H[f+60>>2]+18|0]&(F[f+38|0]&1)){break j}d=H[i+4>>2];if(d&8){break j}e=H[i+48>>2];w:{if(!e){break w}x:{if(!H[b+48>>2]&H[k>>2]<2|d&134217728|(H[i+60>>2]|I[b+7|0]&8)){break x}if(I[q+82|0]&4){break x}id(a,44,e);H[i+48>>2]=0;break w}if(!(I[b+6|0]&4)|j){break w}d=0;if(I[k+108|0]&34|H[k>>2]==1){break i}}m=H[a>>2];if(H[b+68>>2]|F[m+80|0]&1){break k}k=H[b+32>>2];n=p+k|0;d=H[n+28>>2];if(H[d+68>>2]){break k}r=H[a+260>>2];y=H[n+48>>2];e=H[d+32>>2];f=H[d+60>>2];if(!f){break t}if(H[b+60>>2]|H[f+16>>2]){break k}h=H[b+4>>2];if(h&256){break k}break l}o=H[a>>2];H[g+256>>2]=H[c+24>>2];d=H[c+20>>2];H[g+248>>2]=H[c+16>>2];H[g+252>>2]=d;d=H[c+12>>2];H[g+240>>2]=H[c+8>>2];H[g+244>>2]=d;d=H[c+4>>2];H[g+232>>2]=H[c>>2];H[g+236>>2]=d;k=wb(a);j=I[g+232|0];if((j|0)==12){Sa(k,118,H[g+236>>2],H[H[b+28>>2]>>2]);F[g+232|0]=14;j=14}y:{i=H[b+4>>2];if(!(i&1024)){break y}h=H[b+60>>2];l=!h;q=1;e=b;while(1){if(H[e+68>>2]){break y}d=H[e+52>>2];if(d){q=l+q|0;e=d;continue}break}H[g+160>>2]=q;H[g+164>>2]=(q|0)==1?30558:19359;l=0;gc(a,0,6137,g+160|0);while(1){d=0;if(!e){break n}Hf(a,e,-1,0,0,g+232|0,1,1);if(h){break o}G[e+2>>1]=q;e=H[e+56>>2];continue}}z:{if(!(i&8192)){break z}d=b;while(1){if(!d){break z}if(I[d+5|0]&32){d=H[d+52>>2];continue}break}A:{if(H[b+68>>2]){Wa(a,5856,0);break A}i=H[a+8>>2];e=H[b+32>>2];f=H[H[b+28>>2]>>2];d=0;if(Yb(a,33,0,0,0)){break A}m=H[a+56>>2]-1|0;H[a+56>>2]=m;G[b+2>>1]=320;zi(a,b,m);p=H[b+60>>2];H[b+60>>2]=0;t=H[b+12>>2];q=H[b+8>>2];H[b+8>>2]=0;H[b+12>>2]=0;j=H[e>>2];h=(j|0)>0?j:0;e=e+8|0;l=H[b+48>>2];B:{while(1){j=0;if((d|0)==(h|0)){break B}j=d<<6;d=d+1|0;j=e+j|0;if(!(I[j+37|0]&64)){continue}break}j=H[j+40>>2]}h=H[a+40>>2];d=h+1|0;H[a+40>>2]=d;C:{if(I[b|0]==134){H[a+40>>2]=h+2;e=l?6:5;break C}d=0;e=l?7:8}H[g+280>>2]=0;H[g+284>>2]=0;H[g+272>>2]=0;H[g+276>>2]=0;H[g+268>>2]=h;F[g+264|0]=e;n=H[a+44>>2]+1|0;H[a+44>>2]=n;Ua(i,121,j,n,f);D:{if(l){e=_r(a,b);fb(i,118,h,H[l>>2]+2|0,0,e,-8);H[g+288>>2]=l;break D}Sa(i,118,h,f)}E:{if(!d){f=H[b+4>>2];break E}S=b,T=Sa(i,118,d,0),H[S+20>>2]=T;f=H[b+4>>2]|32;H[b+4>>2]=f}H[b+48>>2]=0;e=b;F:{while(1){d=e;if(f&8){Wa(a,15412,0);break F}F[d|0]=135;e=H[d+52>>2];f=H[e+4>>2];if(f&8192){continue}break}H[e+56>>2]=0;gc(a,1,19836,0);f=Lc(a,e,g+264|0);H[e+56>>2]=b;if(f){break F}r=Sa(i,36,h,m);_a(i,136,j);G:{if(l){Ua(i,94,h,H[l>>2]+1|0,n);break G}Sa(i,134,h,n)}_a(i,130,h);f=H[a+56>>2]-1|0;H[a+56>>2]=f;yi(i,t,f);Hf(a,b,j,0,0,g+232|0,f,m);if(q){Sa(i,61,q,m)}hb(i,f);H[d+52>>2]=0;gc(a,1,19848,0);Lc(a,b,g+264|0);H[d+52>>2]=e;Qb(i,r);hb(i,m)}pb(H[a>>2],H[b+48>>2]);H[b+60>>2]=p;H[b+48>>2]=l}l=0;d=0;break q}m=H[b+48>>2];if(!m){break r}i=H[a+56>>2];s=i-2|0;H[a+56>>2]=s;n=H[a+8>>2];r=H[a>>2];q=H[m>>2];w=I[b|0];if((w|0)==135){break p}f=1;H:while(1){if(I[r+87|0]|H[H[b+28>>2]>>2]<(f|0)){break p}d=0;j=(q|0)>0?q:0;e=m+8|0;while(1){I:{if((d|0)!=(j|0)){if(J[e+12>>1]!=(f|0)){break I}}else{d=j}J:{if((d|0)!=(q|0)){break J}d=oc(r,155,0);if(!d){d=7;break m}H[d+8>>2]=f;H[d+4>>2]=H[d+4>>2]|2048;m=Pb(a,m,d);H[b+48>>2]=m;if(!m){m=0;break J}G[((q<<4)+m|0)+20>>1]=f;q=q+1|0}f=f+1|0;continue H}e=e+16|0;d=d+1|0;continue}}}h=H[b+4>>2];break l}d=H[b+36>>2];if(!(I[q+81|0]&128|(!d|I[d|0]!=44))){H[g+264>>2]=a;H[g+268>>2]=H[a>>2]+87;while(1){H[g+288>>2]=0;H[g+272>>2]=0;H[g+276>>2]=0;H[g+280>>2]=0;d=H[b+32>>2];K:{if(!(!d|H[d>>2]<=0)){e=3;if(I[d+44|0]&64){break K}}e=1}H[g+284>>2]=e;d=g+264|0;Zr(d,H[b+36>>2]);if(H[g+272>>2]){H[g+332>>2]=0;H[g+336>>2]=0;H[g+328>>2]=46;H[g+324>>2]=53;H[g+320>>2]=a;H[g+340>>2]=0;H[g+344>>2]=d;Jb(g+320|0,H[b+36>>2]);Za(H[H[g+264>>2]>>2],H[g+288>>2])}if(H[g+276>>2]){continue}break}}L:{if(!(I[b+4|0]&8)|J[q+80>>1]&513){break L}d=H[b+28>>2];if(H[b+36>>2]|H[d>>2]!=1|(H[b+44>>2]|H[b+40>>2])){break L}if(H[b+48>>2]){break L}d=H[d+8>>2];if(I[d|0]!=168){break L}if(Zb(H[d+8>>2],2655)|H[d+20>>2]){break L}j=H[b+32>>2];if(F[d+7|0]&1|H[j>>2]!=1){break L}e=H[j+28>>2];if(!e|!H[e+52>>2]|I[e+7|0]&4){break L}f=e;while(1){if(H[f+36>>2]|(H[f+52>>2]?I[f|0]!=135:0)|(H[f+60>>2]|I[f+4|0]&8)){break L}f=H[f+52>>2];if(f){continue}break}i=H[a>>2];H[j+28>>2]=0;Cc(i,j);S=b,T=nb(H[a>>2],72,0),H[S+32>>2]=T;k=0;while(1){M:{f=k;if(!e){break M}G[e+2>>1]=0;j=H[e+52>>2];H[e+52>>2]=0;H[e+56>>2]=0;H[e+4>>2]=H[e+4>>2]&-265|8;id(a,44,H[e+28>>2]);k=d;if(j){k=jb(i,d,0)}S=e,T=Yc(H[a>>2],k),H[S+28>>2]=T;k=ib(a,138,0,0);Ag(a,k,e);e=j;if(!f){continue}k=ib(a,106,k,f);continue}break}H[H[b+28>>2]+8>>2]=f;H[b+4>>2]=H[b+4>>2]&-9;if(I[q+87|0]){break d}k=H[b+32>>2]}r=k+8|0;f=0;while(1){N:{O:{if(H[k>>2]>(f|0)){i=r+(f<<6)|0;P:{if(H[i+48>>2]|H[i+52>>2]){break P}d=H[i+8>>2];if(!d){break P}Yb(a,20,d,30558,H[i+4>>2])}p=H[i+20>>2];if(!p){break N}S=a,T=Yr(b)+H[a+228>>2]|0,H[S+228>>2]=T;d=H[q+80>>2];Q:{if(d&4096){break Q}if(F[i+38|0]&1){e=H[i+60>>2];if(!I[e+18|0]|H[e>>2]>1){break Q}}Xr(a,p,H[b+36>>2],k,f);d=H[q+80>>2]}if(d&67108864|(I[i+37|0]|I[i+38|0]<<8)&264){break O}n=H[i+16>>2];m=H[i+20>>2];d=m;while(1){if(d){if(I[d+4|0]&9){break O}e=H[d+52>>2];if(I[d|0]!=135?e:0){break O}j=H[d+68>>2];d=e;if(!j){continue}break O}break}l=H[i+48>>2];t=H[i+52>>2];R:{e=H[m+48>>2];if(!e){break R}d=0;j=H[e>>2];u=(j|0)>0?j:0;s=e+8|0;while(1){if((d|0)==(u|0)){break R}e=J[(s+(d<<4)|0)+12>>1];if(e){e=e-1&65535;j=e>>>0>=63?63:e;e=j&31;if((j&63)>>>0>=32){h=1<<e;j=0}else{j=1<<e;h=j-1&1>>>32-e}l=j|l;t=h|t}d=d+1|0;continue}}d=G[n+34>>1];n=(d|0)>0?d:0;j=0;e=0;while(1){if(!e&(j|0)==(n|0)){break O}d=j&31;S:{if((j&63)>>>0>=32){h=1<<d;s=0}else{s=1<<d;h=s-1&1>>>32-d}d=!e&j>>>0>=63|(e|0)!=0;if(l&(d?0:s)|t&(d?-2147483648:h)){break S}u=j<<4;d=m;while(1){if(!d){break S}h=H[(u+H[d+28>>2]|0)+8>>2];if(I[h|0]!=121){F[h|0]=121;H[h+4>>2]=H[h+4>>2]&-532481;H[d+4>>2]=H[d+4>>2]|16777216}d=H[d+52>>2];continue}}j=j+1|0;e=j?e:e+1|0;continue}}s=H[b+44>>2];j=H[b+40>>2];l=H[b+36>>2];r=H[b+28>>2];d=H[b+4>>2];F[g+232|0]=d&1;T:{if((d&9)!=1){break T}if(If(H[g+192>>2],r,-1)|H[b+68>>2]){break T}H[b+4>>2]=H[b+4>>2]&-2;j=pc(q,r,0);H[b+40>>2]=j;H[b+4>>2]=H[b+4>>2]|8;F[g+232|0]=2}d=H[g+192>>2];if(d){e=Oe(a,d,0,H[r>>2]);d=H[a+40>>2];H[a+40>>2]=d+1;H[g+200>>2]=d;d=fb(o,118,d,(H[H[g+192>>2]>>2]+H[r>>2]|0)+1|0,0,e,-8)}else{d=-1}H[g+212>>2]=d;U:{if(I[c|0]!=12){break U}Sa(o,118,H[c+4>>2],H[r>>2]);if(!(I[b+5|0]&8)){break U}e=r+8|0;m=H[r>>2];d=m;while(1){V:{if((d|0)<2){break V}d=d-1|0;f=e+(d<<4)|0;if(I[f+9|0]&64){break V}eb(q,H[f>>2]);Za(q,H[f+4>>2]);m=H[r>>2]-1|0;H[r>>2]=m;continue}break}d=0;f=(m|0)>0?m:0;while(1){if((d|0)==(f|0)){break U}i=e+(d<<4)|0;if(!(I[i+9|0]&64)){F[H[i>>2]]=121}d=d+1|0;continue}}Q=H[a+56>>2]-1|0;H[a+56>>2]=Q;if(!(I[b+5|0]&64)){G[b+2>>1]=320}if(H[b+60>>2]){zi(a,b,Q)}W:{if(H[b+8>>2]){break W}d=H[g+212>>2];if((d|0)<0){break W}F[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(d,20)|0)|0]=119;F[g+224|0]=I[g+224|0]|1}d=0;X:{if(!(F[b+4|0]&1)){break X}d=H[a+40>>2];H[a+40>>2]=d+1;H[g+236>>2]=d;S=g,T=fb(o,118,d,0,0,Oe(a,H[b+28>>2],0,0),-8),H[S+240>>2]=T;d=3;e=H[o+108>>2];if((e|0)<=0){break X}G[(H[o+104>>2]+N(e,20)|0)-18>>1]=8}F[g+233|0]=d;Y:{Z:{_:{$:{aa:{ba:{ca:{da:{ea:{fa:{ga:{ha:{ia:{ja:{if(!(j|w)){e=0;m=H[b+4>>2]&16384|(I[g+232|0]!=0)<<8;f=H[b+68>>2];ka:{if(!f){break ka}d=H[H[H[H[b+32>>2]+28>>2]+28>>2]>>2];j=wb(a);Sa(j,118,H[f+48>>2],d);d=H[f+48>>2];Sa(j,115,d+1|0,d);d=H[f+48>>2];Sa(j,115,d+2|0,d);d=H[f+48>>2];Sa(j,115,d+3|0,d);d=H[f+8>>2];if(d){d=H[d>>2];i=H[a+44>>2];h=i+1|0;H[f+68>>2]=h;d=d+i|0;H[a+44>>2]=d;Ua(j,75,0,h,d)}d=H[a+44>>2]+1|0;H[a+44>>2]=d;H[f+84>>2]=d;Sa(j,71,1,d);if(!I[f+20|0]){d=f;while(1){if(!d){break ka}i=H[d+44>>2];la:{if(!(!(I[i+5|0]&16)|I[d+17|0]==90)){h=Oe(a,H[H[d+72>>2]+20>>2],0,0);i=H[a+40>>2];H[a+40>>2]=i+1;H[d+60>>2]=i;n=H[a+44>>2];H[d+64>>2]=n+1;H[a+44>>2]=n+3;if(!(!h|I[H[H[d+44>>2]+32>>2]+1|0]!=105)){F[H[h+16>>2]]=1;i=H[d+60>>2]}Sa(j,118,i,2);xc(j,h,-8);Sa(j,71,0,H[d+64>>2]+1|0);break la}i=H[i+32>>2];if(!((i|0)!=50064&(i|0)!=50074)){h=H[a+44>>2];H[d+64>>2]=h+1;i=H[a+40>>2];H[a+40>>2]=i+1;H[d+60>>2]=i;H[a+44>>2]=h+2;Sa(j,115,i,H[f+48>>2]);break la}if((i|0)!=49830&(i|0)!=49835){break la}i=H[a+40>>2];H[a+40>>2]=i+1;H[d+60>>2]=i;Sa(j,115,i,H[f+48>>2])}d=H[d+36>>2];continue}}d=H[a+44>>2];i=d+1|0;H[f+88>>2]=i;d=d+2|0;H[a+44>>2]=d;H[f+92>>2]=d;d=H[a+40>>2];H[a+40>>2]=d+1;H[f+60>>2]=d;Sa(j,71,1,i);Sa(j,71,0,H[f+92>>2]);Sa(j,115,H[f+60>>2],H[f+48>>2])}m=bf(a,k,l,H[g+192>>2],H[b+28>>2],b,m,G[b+2>>1]);if(!m){break Y}d=G[m+50>>1];if((d|0)<G[b+2>>1]){G[b+2>>1]=d}ma:{if(!I[g+232|0]){break ma}d=I[m+47|0];if(!d){break ma}F[g+233|0]=d}e=H[g+192>>2];na:{if(e){d=F[m+45|0];j=(d|0)>0?d:0;H[g+196>>2]=j;if(I[m+48|0]&4){d=m+N(I[m+44|0],96)|0;d=H[d+720>>2]?m+28|0:d+680|0}else{d=m+28|0}H[g+220>>2]=H[d>>2];if((j|0)!=H[e>>2]){break na}H[g+192>>2]=0}d=H[g+212>>2];if((d|0)<0){break na}de(o,d)}if(!f){break ja}B=H[a+56>>2];y=B-3|0;H[a+56>>2]=y;D=H[a+44>>2]+1|0;H[a+44>>2]=D;j=H[b+68>>2];u=H[j+12>>2];k=wb(a);d=H[b+32>>2];A=H[d+48>>2];s=G[H[d+24>>2]+34>>1];x=H[a+56>>2]-1|0;H[a+56>>2]=x;Xa(g+284|0,0,36);H[g+280>>2]=D;H[g+272>>2]=k;H[g+268>>2]=j;H[g+264>>2]=a;M=B-1|0;H[g+276>>2]=M;n=H[j+48>>2];H[g+304>>2]=n;C=n+3|0;H[g+312>>2]=C;d=2;E=n+2|0;H[g+296>>2]=E;oa:{switch(I[j+17|0]-86|0){case 0:if(I[j+16|0]==89){break _}if(!Wr(a,H[j+24>>2])){break _}break aa;case 4:break oa;default:break $}}if(H[j+88>>2]){break _}d=j;while(1){if(d){e=H[H[d+44>>2]+32>>2];if((e|0)==49835|(e|0)==49830|((e|0)==50064|(e|0)==50074)){break _}d=H[d+36>>2];continue}break}if(I[j+18|0]!=88){break aa}if(I[j+16|0]==89){break _}if(!Wr(a,H[j+28>>2])){break _}d=3;break $}pa:{if(j){d=H[b+28>>2];e=d+8|0;d=H[d>>2];while(1){if((d|0)>0){G[e+14>>1]=0;e=e+16|0;d=d-1|0;continue}break}d=H[j>>2];i=j+8|0;e=i;while(1){if((d|0)>0){G[e+14>>1]=0;e=e+16|0;d=d-1|0;continue}break}if(G[b+2>>1]>=67){G[b+2>>1]=66}w=0;e=H[g+192>>2];if(!e){break pa}f=H[j>>2];if((f|0)!=H[e>>2]){break pa}d=0;f=(f|0)>0?f:0;h=e+8|0;while(1){if((d|0)!=(f|0)){m=d<<4;F[(m+i|0)+8|0]=F[(h+m|0)+8|0]&1;d=d+1|0;continue}break}w=!If(j,e,-1);break pa}w=0;G[b+2>>1]=0}p=H[a+56>>2]-1|0;H[a+56>>2]=p;h=nb(q,44,0);if(h){id(a,54,h)}e=0;if(I[q+87|0]){break Y}H[h+40>>2]=H[b+16>>2];H[g+292>>2]=0;H[g+296>>2]=0;H[g+284>>2]=0;H[g+288>>2]=0;H[g+276>>2]=0;H[g+280>>2]=0;H[g+272>>2]=h;H[g+268>>2]=k;H[g+264>>2]=a;d=j?H[j>>2]:0;H[h+16>>2]=j;G[h+2>>1]=d;d=g+264|0;vk(d,r);vk(d,H[g+192>>2]);if(s){if(j){H[g+336>>2]=0;H[g+340>>2]=0;H[g+328>>2]=0;H[g+332>>2]=0;H[g+324>>2]=55;H[g+320>>2]=a;H[g+344>>2]=b;Jb(g+320|0,H[b+44>>2]);l=H[b+36>>2]}mn(g+264|0,s)}H[h+28>>2]=H[h+24>>2];i=0;qa:{if(H[b+40>>2]|H[b+44>>2]|H[h+36>>2]!=1){break qa}f=H[H[h+32>>2]>>2];d=H[f+20>>2];if(!d|H[d>>2]!=1|(F[f+7|0]&1|F[q+82|0]&1)){break qa}f=H[f+8>>2];ra:{if(!ab(f,11258)){m=((af(H[d+8>>2])|0)!=0)<<1;i=1;break ra}if(ab(f,1588)){break qa}m=1;i=2}e=pc(q,d,0);if(!e){e=0;break qa}F[e+16|0]=m}Vr(h,g+264|0);if(I[q+87|0]){break Y}if(j){i=0;d=0;if(H[h+36>>2]!=1){break ca}d=H[h+32>>2];if(H[d+8>>2]<0){break da}f=H[d>>2];if(!f){break da}d=0;if(I[f+5|0]&16){break ca}d=H[f+20>>2];if(!d){break da}d=jb(q,H[d+8>>2],0);i=Pb(a,pc(q,j,0),d);d=i?1280:0;break ca}sa:{if(H[b+36>>2]){break sa}f=H[b+28>>2];if(H[f>>2]!=1){break sa}d=H[b+32>>2];if(H[d>>2]!=1|H[d+28>>2]|(H[b+44>>2]|H[h+36>>2]!=1)){break sa}m=H[d+24>>2];if(I[m+43|0]){break sa}d=H[f+8>>2];if(I[d|0]!=168|(h|0)!=H[d+40>>2]|(!(F[H[H[h+32>>2]+4>>2]+5|0]&1)|H[d+4>>2]&16777220)){break sa}i=Fb(H[a>>2],H[m+60>>2]);l=H[a+40>>2];H[a+40>>2]=l+1;n=H[m+20>>2];ld(a,i);j=0;wd(a,i,H[m+20>>2],0,H[m>>2]);if(I[m+28|0]&128){j=jc(m)}ta:{if(F[H[b+32>>2]+45|0]&1){break ta}f=m+8|0;while(1){d=H[f>>2];if(!d){break ta}ua:{if(I[d+55|0]&4){break ua}f=G[d+48>>1];if(H[d+36>>2]|(f|0)>=G[m+40>>1]|((f|0)>=G[j+48>>1]?j:0)){break ua}j=d}f=d+20|0;continue}}if(j){n=H[j+44>>2];d=uk(a,j)}else{d=0}gb(o,112,l,n,i,1);if(d){Wd(o,-1,d,-8)}d=H[a+44>>2];f=d+1|0;H[h+12>>2]=f;i=d;d=H[h+24>>2];H[a+44>>2]=H[h+36>>2]+(i+d|0);Sa(o,98,l,d+f|0);_a(o,122,l);if(I[a+219|0]!=2){break ea}va:{if(!j){k=H[m>>2];f=30558;d=30558;break va}wa:{if(!(I[m+28|0]&128)){k=H[m>>2];break wa}k=H[m>>2];f=30558;d=30558;if(((I[j+55|0]|I[j+56|0]<<8)&3)==2){break va}}f=H[j>>2];d=29981}H[g+88>>2]=f;H[g+84>>2]=d;H[g+80>>2]=k;gc(a,0,6106,g+80|0);break ea}n=H[h+36>>2];if(!H[h+28>>2]){break ia}f=0;d=(n|0)>0?n:0;while(1){xa:{if((d|0)!=(f|0)){j=H[h+32>>2]+N(f,24)|0;if(F[H[j>>2]+7|0]&1|!(I[H[j+4>>2]+4|0]&32)){break xa}}else{f=d}if((f|0)!=(n|0)){break ha}f=H[a+44>>2]+1|0;H[a+44>>2]=f;m=0;Sa(o,71,0,f);n=H[h+36>>2];d=0;break fa}f=f+1|0;continue}}Hf(a,b,-1,g+192|0,g+232|0,c,H[m+28>>2],H[m+32>>2]);vd(m);e=0;break Z}if((n|0)!=1){break ha}f=0;d=H[h+32>>2];if(H[d+8>>2]<0){n=1;break ga}n=1;m=H[H[d>>2]+20>>2];d=m?1280:0;break fa}f=0}m=0;d=0}j=H[a+44>>2];H[h+12>>2]=j+1;H[a+44>>2]=H[h+24>>2]+(j+n|0);Ur(a,h);d=bf(a,k,l,e,m,b,d|i,0);if(!d){break Y}j=I[d+47|0];Tr(a,f,h,j);ya:{if(!j){break ya}l=H[h+32>>2];if(!l){break ya}ln(a,j,H[l+8>>2],H[l+12>>2])}if(f){Sa(o,71,1,f)}if(!(!I[d+45|0]|(!i|!(I[d+48|0]&4)))){j=d+760|0;f=I[d+44|0];za:{Aa:{while(1){if((f|0)<=0){break Aa}f=f-1|0;i=j+N(f,96)|0;if(!(I[H[i+80>>2]+40|0]&4)){continue}break}f=i+16|0;break za}f=d+32|0}Qb(o,H[f>>2])}vd(d);Sr(a,h)}H[g+192>>2]=0;wc(a,s,p,16);Hf(a,b,-1,0,0,c,p,p);break ba}d=0}f=H[a+40>>2];H[a+40>>2]=f+1;H[h+4>>2]=f;t=Oe(a,j,0,H[h+24>>2]);M=fb(o,119,H[h+4>>2],J[h+2>>1],0,t,-8);E=H[a+56>>2];y=E-2|0;H[a+56>>2]=y;f=H[j>>2];x=H[a+44>>2];v=x+4|0;D=f+v|0;H[a+44>>2]=f+D;z=x+2|0;Sa(o,71,0,z);A=x+5|0;Ua(o,75,0,A,v+H[j>>2]|0);Sa(o,10,v,y);u=bf(a,k,l,j,i,b,d|(w<<9|(I[g+232|0]==2?128:64)),0);if(!u){pb(q,i);break Y}if(H[a+72>>2]){l=H[h+28>>2];H[h+24>>2]=l;if(J[h+2>>1]){f=0;l=(l|0)>0?l:0;k=H[H[b+40>>2]>>2]-1|0;while(1){if((f|0)!=(l|0)){m=G[(H[h+20>>2]+(f<<4)|0)+14>>1];k=(k|0)>(m|0)?k:m;f=f+1|0;continue}break}G[h+2>>1]=k+1}Vr(h,g+264|0)}f=H[a+44>>2];H[h+12>>2]=f+1;H[a+44>>2]=H[h+36>>2]+(f+H[h+24>>2]|0);k=0;C=I[u+47|0];n=0;K=H[j>>2];f=F[u+45|0];L=(f|0)>0?f:0;B=(K|0)==(L|0);if(!B){H[g+96>>2]=I[g+232|0]?H[b+4>>2]&1?18571:18818:18571;f=0;gc(a,0,7355,g+96|0);l=H[h+24>>2];n=(l|0)>0?l:0;m=H[j>>2];l=m;k=l;while(1){if((f|0)!=(n|0)){O=G[(H[h+20>>2]+(f<<4)|0)+14>>1]>=(k|0);k=O+k|0;l=l+O|0;f=f+1|0;continue}break}f=0;k=nc(a,l);Gf(a,j,k,0,0);F[h|0]=1;while(1){if((f|0)<H[h+24>>2]){n=H[h+20>>2]+(f<<4)|0;if(G[n+14>>1]>=(m|0)){ac(a,H[n+4>>2],k+m|0);m=m+1|0}f=f+1|0;continue}break}F[h|0]=0;f=zb(a);Ua(o,97,k,l,f);Sa(o,139,H[h+4>>2],f);rb(a,f);Sc(a,k,l);vd(u);n=H[a+40>>2];H[a+40>>2]=n+1;H[h+8>>2]=n;k=zb(a);Ua(o,121,n,k,l);Sa(o,34,H[h+4>>2],p);F[h+1|0]=1}Ba:{if(!H[a+72>>2]){break Ba}f=0;H[g+344>>2]=0;H[g+336>>2]=0;H[g+340>>2]=0;H[g+328>>2]=0;H[g+332>>2]=0;H[g+320>>2]=0;H[g+324>>2]=0;H[g+324>>2]=56;while(1){if(H[h+36>>2]<=(f|0)){break Ba}Jb(g+320|0,H[H[h+32>>2]+N(f,24)>>2]);f=f+1|0;continue}}Ca:{if(!(!w|I[q+80|0]&4)){if(!(I[u+48|0]&8|(K|0)!=(L|0))){w=H[o+108>>2];break Ca}H[g+192>>2]=0;de(o,H[g+212>>2])}w=H[o+108>>2];if(B){break Ca}Ua(o,133,H[h+4>>2],k,n)}l=D+1|0;k=j+8|0;f=0;while(1){m=H[j>>2];if((f|0)<(m|0)){Da:{if(!B){Ua(o,94,n,f,f+l|0);break Da}F[h|0]=1;ac(a,H[k+(f<<4)>>2],f+l|0)}f=f+1|0;continue}break}if(t){H[t>>2]=H[t>>2]+1}fb(o,90,A,l,m,t,-8);k=H[o+108>>2];f=k+1|0;Ua(o,14,f,0,f);xi(a,l,A,H[j>>2]);f=x+3|0;l=E-1|0;Sa(o,10,f,l);Sa(o,59,z,p);Sa(o,10,v,y);m=H[o+108>>2];H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(k,20)|0)+8>>2]=m;j=x+1|0;Tr(a,j,h,C);Sa(o,71,1,j);Ea:{if(!B){Sa(o,37,H[h+4>>2],w);break Ea}vd(u);de(o,M)}pb(q,i);Sa(o,10,f,l);Qb(o,p);i=H[o+108>>2];Sa(o,71,1,z);_a(o,67,f);hb(o,l);l=H[o+108>>2];Sa(o,59,j,l+2|0);_a(o,67,f);Sr(a,h);l=l+1|0;wc(a,s,l,16);Hf(a,b,-1,g+192|0,g+232|0,c,l,i);_a(o,67,f);hb(o,y);Ur(a,h);Sa(o,71,0,j);_a(o,67,v);if(!d|!C){break ba}d=H[h+32>>2];ln(a,C,H[d+8>>2],H[d+12>>2])}hb(o,p);break Z}d=1}H[g+288>>2]=d}d=H[a+44>>2];z=d+s|0;e=z+2|0;H[a+44>>2]=e;H[g+292>>2]=e;l=0;f=e;h=0;Fa:{switch(I[j+17|0]-86|0){case 0:case 2:f=z+3|0;H[a+44>>2]=f;h=f;break;default:break Fa}}Ga:{switch(I[j+18|0]-86|0){case 0:case 2:f=f+1|0;H[a+44>>2]=f;l=f;break;default:break Ga}}v=d+1|0;d=0;w=0;p=0;t=0;if(I[j+16|0]!=76){i=u?H[u>>2]:0;t=v+H[j+76>>2]|0;p=H[j+8>>2];if(p){t=H[p>>2]+t|0}p=f+i|0;w=p+1|0;H[g+300>>2]=w;p=i+p|0;K=p+1|0;H[g+308>>2]=K;p=i+p|0;L=p+1|0;H[g+316>>2]=L;H[a+44>>2]=i+p;p=f+1|0}f=z+1|0;i=(s|0)>0?s:0;while(1){if((d|0)!=(i|0)){Ua(k,94,A,d,d+v|0);d=d+1|0;continue}break}Ua(k,97,v,s,f);s=0;z=0;d=H[j+8>>2];if(d){i=H[d>>2];z=H[j+76>>2];A=Oe(a,d,0,0);s=H[a+44>>2]+1|0;H[a+44>>2]=s;v=v+z|0;d=Ua(k,90,v,H[j+68>>2],i);xc(k,A,-8);z=d+2|0;Ua(k,14,z,d+4|0,z);z=_a(k,10,s);Ua(k,80,v,H[j+68>>2],i-1|0)}v=n+1|0;Sa(k,127,v,e);Ua(k,128,v,f,e);O=Ua(k,52,H[j+84>>2],0,e);i=wb(a);d=j;f=0;while(1){if(d){A=H[d+44>>2];e=0;Sa(i,75,0,H[d+52>>2]);P=H[H[d+72>>2]+20>>2];if(P){e=H[P>>2]}P=(e|0)<(f|0);Ha:{if(H[j+88>>2]){break Ha}R=H[A+32>>2];if(!((R|0)!=50064&(R|0)!=50074)){Sa(i,71,0,H[d+64>>2]);Sa(i,71,0,H[d+64>>2]+1|0)}if(!(I[A+5|0]&16)){break Ha}A=H[d+60>>2];if(!A){break Ha}_a(i,146,A);Sa(i,71,0,H[d+64>>2]+1|0)}f=P?f:e;d=H[d+36>>2];continue}break}d=H[a+44>>2];H[a+44>>2]=d+f;H[g+284>>2]=d+1;if(h){ac(a,H[j+24>>2],h);kn(a,h,I[j+16|0]==89?3:0)}if(l){ac(a,H[j+28>>2],l);kn(a,l,I[j+16|0]==89?4:1)}Ia:{if(I[j+16|0]!=89){d=I[j+17|0];if(!h){break Ia}e=d&255;if((e|0)!=I[j+18|0]){break Ia}d=Ua(k,(e|0)==86?57:55,h,0,l);e=g+264|0;jn(e,0);_a(k,36,n);Qr(e);_a(k,146,n);Sa(k,9,0,x);e=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(d,20)|0)+8>>2]=e}d=I[j+17|0]}Ja:{Ka:{if((d&255)==86){if(!l|I[j+16|0]==89){break Ka}Ua(k,107,h,l,h);d=I[j+17|0]}if((d&255)==90){break Ja}}_a(k,36,E)}_a(k,36,n);_a(k,36,C);if(!(!p|!u)){Ua(k,80,t,p,H[u>>2]-1|0);Ua(k,80,p,w,H[u>>2]-1|0);Ua(k,80,p,K,H[u>>2]-1|0);Ua(k,80,p,L,H[u>>2]-1|0)}Sa(k,9,0,x);e=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(O,20)|0)+8>>2]=e;if(p){Pr(a,u,t,p,x)}d=I[j+17|0];La:{if((d|0)==86){d=g+264|0;dc(d,3,0,0);if(I[j+18|0]==90){break La}if(I[j+16|0]==89){e=H[a+56>>2]-1|0;H[a+56>>2]=e;f=H[k+108>>2];wi(d,57,n,l,C,e);dc(d,2,h,0);dc(d,1,0,0);Sa(k,9,0,f);hb(k,e);break La}d=g+264|0;dc(d,1,l,0);dc(d,2,h,0);break La}if(I[j+18|0]==88){Ma:{if((d|0)==88){e=I[j+16|0];d=g+264|0;dc(d,3,l,0);if((e|0)!=89){break Ma}dc(d,2,h,0);dc(d,1,0,0);break La}dc(g+264|0,3,l,0)}d=g+264|0;dc(d,1,0,0);dc(d,2,h,0);break La}e=g+264|0;dc(e,3,0,0);if(I[j+18|0]==90){break La}if(I[j+16|0]==89){f=H[k+108>>2];d=0;if(l){d=H[a+56>>2]-1|0;H[a+56>>2]=d;wi(e,57,n,l,C,d)}e=g+264|0;dc(e,1,0,0);dc(e,2,h,0);if(!l){break La}Sa(k,9,0,f);hb(k,d);break La}d=0;if(l){d=Ua(k,59,l,0,1)}e=g+264|0;dc(e,1,0,0);dc(e,2,h,0);if(!l){break La}e=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(d,20)|0)+8>>2]=e}hb(k,x);vd(m);m=0;if(H[j+8>>2]){m=Sa(k,71,0,s);e=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(z,20)|0)+8>>2]=e}H[g+292>>2]=0;i=_a(k,36,v);d=I[j+17|0];Na:{if(I[j+18|0]==88){Oa:{if((d|0)==88){d=I[j+16|0];e=g+264|0;dc(e,3,l,0);if((d|0)!=89){break Oa}dc(e,2,h,0);break Oa}dc(g+264|0,3,l,0)}dc(g+264|0,1,0,0);d=H[k+108>>2];f=I[H[k>>2]+87|0];break Na}e=g+264|0;dc(e,3,0,0);if((d|0)==86){Pa:{if(I[j+16|0]==89){d=H[k+108>>2];f=dc(e,2,h,1);l=dc(e,1,0,1);break Pa}d=H[k+108>>2];if(I[j+18|0]==90){e=g+264|0;l=dc(e,1,h,1);f=dc(e,2,0,1);break Pa}e=g+264|0;l=dc(e,1,l,1);f=dc(e,2,h,1)}Sa(k,9,0,d);d=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(f,20)|0)+8>>2]=d;e=dc(g+264|0,1,0,1);Sa(k,9,0,d);d=H[k+108>>2];f=I[H[k>>2]+87|0];Qa:{if(f){H[18336]=d;e=73336;break Qa}h=N(l,20);l=H[k+104>>2];H[(h+l|0)+8>>2]=d;e=l+N(e,20)|0}H[e+8>>2]=d;break Na}d=H[k+108>>2];e=g+264|0;l=dc(e,1,0,1);dc(e,2,h,0);Sa(k,9,0,d);d=H[k+108>>2];f=I[H[k>>2]+87|0];H[(f?73336:H[k+104>>2]+N(l,20)|0)+8>>2]=d}H[(f&255?73336:H[k+104>>2]+N(i,20)|0)+8>>2]=d;_a(k,146,n);if(H[j+8>>2]){d=H[j+88>>2];if(d){Sa(k,71,1,d);Sa(k,71,0,H[j+92>>2])}e=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(m,20)|0)+4>>2]=e;_a(k,67,s)}e=0;Sa(o,9,0,y);hb(o,M);H[g+220>>2]=0;d=B-2|0;Hf(a,b,-1,g+192|0,g+232|0,c,d,y);hb(o,d);_a(o,67,D);hb(o,y)}if(I[g+233|0]==3){H[g+64>>2]=18818;gc(a,0,7355,g- -64|0)}d=H[g+192>>2];if(d){i=H[r>>2];t=H[g+216>>2];w=H[a+56>>2]-1|0;H[a+56>>2]=w;h=H[a+8>>2];m=H[c+4>>2];r=I[c|0];u=H[b+28>>2];H[g+48>>2]=H[g+196>>2]>0?30361:30558;gc(a,0,18540,g+48|0);f=H[g+208>>2];if(f){Sa(h,10,H[g+204>>2],f);Qb(h,t);hb(h,H[g+208>>2])}k=H[g+200>>2];Ra:{Sa:{Ta:{Ua:{switch(r-9|0){case 0:case 4:break Ta;case 1:break Ua;default:break Sa}}if(!H[b+12>>2]){break Ta}Sa(h,75,0,H[c+12>>2])}n=0;f=H[c+12>>2];break Ra}n=zb(a);if((r&253)==12){i=0;f=zb(a);break Ra}f=nc(a,i)}d=H[d>>2]-H[g+196>>2]|0;l=1;Va:{if(F[g+224|0]&1){l=H[a+44>>2]+1|0;H[a+44>>2]=l;j=H[a+40>>2];H[a+40>>2]=j+1;if(H[g+208>>2]){b=Mb(h,15)}else{b=0}Ua(h,121,j,l,(d+i|0)+1|0);if(b){p=H[h+108>>2];H[(I[H[h>>2]+87|0]?73336:H[h+104>>2]+N(b,20)|0)+8>>2]=p}p=Sa(h,34,k,t);Ua(h,133,k,l,j);l=0;break Va}p=Sa(h,35,k,t);yi(h,H[b+12>>2],w);if(H[b+12>>2]>0){Sa(h,86,H[b+8>>2],-1)}j=k}u=u+8|0;b=0;s=(i|0)>0?i:0;x=d+l|0;d=x-1|0;while(1){if((b|0)==(s|0)){b=i;while(1){if((b|0)>0){b=b-1|0;l=J[(u+(b<<4)|0)+12>>1];Ua(h,94,j,l?l-1|0:d,b+f|0);d=d-!l|0;continue}break}d=p+1|0;Wa:{Xa:{Ya:{Za:{_a:{switch(r-9|0){case 3:case 5:Ua(h,94,j,x,f);Sa(h,127,m,n);Ua(h,128,m,f,n);b=H[h+108>>2];if((b|0)<=0){break Za}G[(H[h+104>>2]+N(b,20)|0)-18>>1]=8;break Za;case 6:b=H[c+8>>2];c=b>>>31|0;j=c+f|0;i=i-c|0;c=zb(a);Ua(h,97,j,i,c);if((b|0)<0){Ua(h,128,m,c,f);break Za}gb(h,138,m,c,f,b);break Za;case 0:Sa(h,84,H[c+12>>2],i);break Za;case 2:break Ya;case 1:break Za;default:break _a}}_a(h,12,H[c+4>>2])}if(!n){break Wa}rb(a,f);break Xa}fb(h,97,f,i,n,H[c+20>>2],i);gb(h,138,m,n,f,i);if(!n){break Wa}Sc(a,f,i)}rb(a,n)}hb(h,w);Sa(h,F[g+224|0]&1?37:39,k,d);b=H[g+204>>2];if(b){_a(h,67,b)}hb(h,t)}else{d=!J[(u+(b<<4)|0)+12>>1]+d|0;b=b+1|0;continue}break}}hb(o,Q);d=H[a+36>>2]>0;break c}d=1;break c}j=H[a+260>>2];H[a+260>>2]=H[i+8>>2];e=H[b+4>>2];$a:{ab:{bb:{h=(I[i+37|0]|I[i+38|0]<<8)&256;cb:{db:{if(!h){break db}d=H[i+60>>2];l=I[d+18|0];if(!l){break cb}if((l|0)==2){break db}if(H[d>>2]>1){break cb}}eb:{if(I[k+44|0]&64|I[H[a>>2]+83|0]&2){break eb}d=H[k>>2];if(Or(k,i,f+1|0,d)){break eb}if(!f){if(I[k+108|0]&2|(d|0)==1){break ab}if(e&268435456){break eb}break ab}l=f;d=i;if(e&268435456){break eb}while(1){if(I[d+36|0]&34){break eb}if(!l){break ab}l=l-1|0;e=d-44|0;d=d+-64|0;if(!H[e>>2]){continue}break}}if(!h){break bb}d=H[i+60>>2]}e=H[d+4>>2];if((e|0)<=0){break bb}Sa(o,10,H[d+8>>2],e);e=H[i+40>>2];i=H[d+12>>2];if((e|0)!=(i|0)){Sa(o,115,e,i)}G[p+2>>1]=J[d+16>>1];break $a}d=Or(k,i,0,f);if(d){e=H[d+24>>2];if(e){Sa(o,10,H[d+28>>2],e)}Sa(o,115,H[i+40>>2],H[d+40>>2]);G[p+2>>1]=J[H[d+20>>2]+2>>1];break $a}d=H[a+44>>2]+1|0;H[a+44>>2]=d;H[i+28>>2]=d;e=Mb(o,9);l=e+1|0;H[i+24>>2]=l;h=I[i+37|0]|I[i+38|0]<<8;d=h|16;F[i+37|0]=d;F[i+38|0]=d>>>8;d=0;if(!(h&8)){d=Mb(o,15)}H[g+268>>2]=H[i+40>>2];F[g+264|0]=12;H[g+280>>2]=0;H[g+284>>2]=0;H[g+272>>2]=0;H[g+276>>2]=0;H[g+32>>2]=i;gc(a,1,19330,g+32|0);Lc(a,p,g+264|0);G[H[i+16>>2]+38>>1]=J[p+2>>1];if(d){H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(d,20)|0)+8>>2]=H[o+108>>2]}Sa(o,67,H[i+28>>2],l);l=H[o+108>>2];H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(e,20)|0)+8>>2]=l;H[a+28>>2]=0;F[a+19|0]=0;if(((I[i+37|0]|I[i+38|0]<<8)&264)!=256){break $a}d=H[i+60>>2];H[d+4>>2]=H[i+24>>2];H[d+8>>2]=H[i+28>>2];H[d+12>>2]=H[i+40>>2];G[d+16>>1]=J[p+2>>1];break $a}d=H[o+108>>2];e=H[a+44>>2]+1|0;H[a+44>>2]=e;H[i+28>>2]=e;l=e;e=d+1|0;Ua(o,11,l,0,e);H[i+24>>2]=e;H[g+268>>2]=H[i+28>>2];F[g+264|0]=13;H[g+280>>2]=0;H[g+284>>2]=0;H[g+272>>2]=0;H[g+276>>2]=0;H[g+16>>2]=i;gc(a,1,19346,g+16|0);Lc(a,p,g+264|0);G[H[i+16>>2]+38>>1]=J[p+2>>1];e=I[i+37|0]|I[i+38|0]<<8|32;F[i+37|0]=e;F[i+38|0]=e>>>8;H[i+32>>2]=H[g+276>>2];Ci(o,H[i+28>>2]);H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(d,20)|0)+8>>2]=H[o+108>>2];H[a+28>>2]=0;F[a+19|0]=0}if(I[q+87|0]){break d}d=Yr(b);H[a+260>>2]=j;H[a+228>>2]=H[a+228>>2]-d}f=f+1|0;continue}}if(!H[f+52>>2]){gc(a,1,18375,0);gc(a,1,18356,0)}fb:{gb:{switch(I[b|0]-134|0){case 1:l=0;H[g+264>>2]=0;H[f+8>>2]=H[b+8>>2];H[f+12>>2]=H[b+12>>2];H[f+60>>2]=H[b+60>>2];d=Lc(a,f,g+232|0);H[f+60>>2]=0;if(d){break n}H[b+52>>2]=0;d=H[f+8>>2];H[b+8>>2]=d;H[b+12>>2]=H[f+12>>2];e=0;hb:{if(!d){break hb}e=_a(k,17,d);d=H[b+12>>2];if(!d){break hb}Ua(k,160,H[b+8>>2],d+1|0,d)}gc(a,1,20145,0);d=Lc(a,b,g+232|0);l=H[b+52>>2];H[b+52>>2]=f;S=b,T=ce(G[b+2>>1],G[f+2>>1]),G[S+2>>1]=T;f=H[b+60>>2];ib:{if(!f){break ib}if(!Ff(H[f+12>>2],g+264|0)){break ib}f=H[g+264>>2];if((f|0)<=0){break ib}j=G[b+2>>1];f=Kd(f,0);if((j|0)<=(f|0)){break ib}G[b+2>>1]=f}if(!e){break fb}f=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(e,20)|0)+8>>2]=f;break fb;case 0:case 2:jb:{if((j|0)==1){e=H[g+236>>2];break jb}e=H[a+40>>2];H[a+40>>2]=e+1;S=b,T=Sa(k,118,e,0),H[S+20>>2]=T;d=hn(b);H[d+4>>2]=H[d+4>>2]|32}H[g+280>>2]=0;H[g+284>>2]=0;H[g+272>>2]=0;H[g+276>>2]=0;H[g+268>>2]=e;F[g+264|0]=1;i=g+264|0;d=Lc(a,f,i);if(d){break o}H[b+52>>2]=0;h=H[b+60>>2];H[b+60>>2]=0;d=I[b|0];F[g+264|0]=(d|0)==136?2:1;S=g,T=vi(d),H[S+128>>2]=T;gc(a,1,20311,g+128|0);d=Lc(a,b,i);H[b+48>>2]=0;l=H[b+52>>2];H[b+52>>2]=f;if(I[b|0]==134){S=b,T=ce(G[b+2>>1],G[f+2>>1]),G[S+2>>1]=T}eb(o,H[b+60>>2]);H[b+8>>2]=0;H[b+12>>2]=0;H[b+60>>2]=h;if(I[o+87|0]|(j|0)==1){break fb}f=H[a+56>>2];j=f-2|0;H[a+56>>2]=j;f=f-1|0;zi(a,b,f);Sa(k,36,e,f);i=H[k+108>>2];Hf(a,b,e,0,0,g+232|0,j,f);hb(k,j);Sa(k,39,e,i);hb(k,f);Sa(k,122,e,0);break fb;default:break gb}}e=H[a+40>>2];H[a+40>>2]=e+2;l=0;S=b,T=Sa(k,118,e,0),H[S+20>>2]=T;d=hn(b);H[d+4>>2]=H[d+4>>2]|32;H[g+280>>2]=0;H[g+284>>2]=0;H[g+272>>2]=0;H[g+276>>2]=0;H[g+268>>2]=e;F[g+264|0]=1;i=g+264|0;d=Lc(a,f,i);if(d){break n}j=e+1|0;d=Sa(k,118,j,0);H[b+52>>2]=0;H[b+24>>2]=d;h=H[b+60>>2];H[b+60>>2]=0;H[g+268>>2]=j;S=g,T=vi(I[b|0]),H[S+112>>2]=T;gc(a,1,20311,g+112|0);d=Lc(a,b,i);l=H[b+52>>2];H[b+52>>2]=f;f=G[f+2>>1];if((f|0)<G[b+2>>1]){G[b+2>>1]=f}eb(o,H[b+60>>2]);H[b+60>>2]=h;if(d){break fb}i=H[a+56>>2];f=i-2|0;H[a+56>>2]=f;i=i-1|0;zi(a,b,i);Sa(k,36,e,i);h=zb(a);m=Sa(k,134,e,h);gb(k,28,j,f,h,0);rb(a,h);Hf(a,b,e,0,0,g+232|0,f,i);hb(k,f);Sa(k,39,e,m);hb(k,i);Sa(k,122,j,0);Sa(k,122,e,0)}if(H[b+56>>2]){break q}lh(a)}if(H[a+36>>2]|!(I[b+4|0]&32)){break n}j=H[H[b+28>>2]>>2];f=Ef(o,j,1);if(!f){d=7;break n}e=0;i=(j|0)>0?j:0;q=f+20|0;while(1){kb:{if((e|0)==(i|0)){i=b;break kb}h=tk(a,b,e);H[q>>2]=h;if(!h){H[q>>2]=H[o+8>>2]}q=q+4|0;e=e+1|0;continue}break}while(1){lb:{if(i){m=i+20|0;e=0;while(1){if((e|0)==2){break lb}n=m+(e<<2)|0;h=H[n>>2];if((h|0)<0){break lb}H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(h,20)|0)+8>>2]=j;H[f>>2]=H[f>>2]+1;Wd(k,h,f,-8);H[n>>2]=-1;e=e+1|0;continue}}Xi(f);break n}i=H[i+52>>2];continue}}j=0;p=0;x=Nb(r,(q<<2)+4|0,0);if(x){H[x>>2]=q;e=m+8|0;f=((q|0)>0?q:0)+1|0;d=1;while(1){if((d|0)!=(f|0)){H[x+(d<<2)>>2]=J[e+12>>1]-1;e=e+16|0;d=d+1|0;continue}break}p=_r(a,b)}o=i-1|0;l=0;mb:{if((w|0)!=135){l=H[a+44>>2]+1|0;d=H[H[b+28>>2]>>2];H[a+44>>2]=l+d;Sa(n,71,0,l);nb:{j=Ef(r,d,1);if(!j){break nb}e=(d|0)>0?d:0;f=j+20|0;d=0;while(1){if((d|0)==(e|0)){break nb}S=f+(d<<2)|0,T=tk(a,b,d),H[S>>2]=T;F[H[j+16>>2]+d|0]=0;d=d+1|0;continue}}d=0;e=b;i=w&254;if((i|0)!=134){break mb}}d=1;i=134;ob:{if(I[r+82|0]&32){break ob}e=b;while(1){f=H[e+52>>2];if(!(!f|(w|0)!=I[e|0])){d=d+1|0;e=f;continue}break}if(d>>>0<4){d=1;break ob}k=2;e=b;while(1)if(d>>>0<=k>>>0){d=1;break mb}else{k=k+2|0;e=H[e+52>>2];continue}}e=b}k=H[e+52>>2];H[e+52>>2]=0;H[k+56>>2]=0;S=k,T=pc(H[a>>2],m,0),H[S+48>>2]=T;gn(a,b,H[b+48>>2],19482);gn(a,k,H[k+48>>2],19482);zi(a,b,o);f=0;h=0;pb:{if((w|0)!=135){break pb}m=H[b+8>>2];if(!m){break pb}f=H[a+44>>2];h=f+2|0;H[a+44>>2]=h;t=H[b+12>>2];f=f+1|0;Sa(n,80,t?t+1|0:m,f);Sa(n,80,f,h)}eb(r,H[b+60>>2]);H[b+60>>2]=0;v=H[a+44>>2];y=v+4|0;H[a+44>>2]=y;H[g+280>>2]=0;H[g+284>>2]=0;H[g+336>>2]=0;H[g+340>>2]=0;H[g+272>>2]=0;H[g+276>>2]=0;m=v+1|0;H[g+268>>2]=m;F[g+264|0]=13;H[g+328>>2]=0;H[g+332>>2]=0;u=v+2|0;H[g+324>>2]=u;F[g+320|0]=13;S=g,T=vi(I[b|0]),H[S+144>>2]=T;gc(a,1,25233,g+144|0);t=Ua(n,11,m,0,H[n+108>>2]+1|0);H[k+8>>2]=f;gc(a,1,18813,0);Lc(a,k,g+264|0);Ci(n,m);f=H[n+108>>2];H[(I[H[n>>2]+87|0]?73336:H[n+104>>2]+N(t,20)|0)+8>>2]=f;t=0;C=Ua(n,11,u,0,f+1|0);f=H[b+8>>2];B=H[b+12>>2];H[b+12>>2]=0;H[b+8>>2]=h;gc(a,1,18794,0);h=g+320|0;Lc(a,b,h);H[b+8>>2]=f;H[b+12>>2]=B;Ci(n,u);f=v+3|0;v=Nr(a,b,g+264|0,c,f,l,j,o);if(d){t=Nr(a,b,h,c,y,l,j,o)}Xi(j);h=o;c=h;if((i|0)!=136){c=Sa(n,10,y,t);h=Sa(n,12,u,h);Qb(n,c);S=b,T=ce(G[b+2>>1],G[k+2>>1]),G[S+2>>1]=T}qb:{if((w|0)==137){j=c;i=G[k+2>>1];if((i|0)>=G[b+2>>1]){break qb}G[b+2>>1]=i;break qb}j=Sa(n,10,f,v);Sa(n,12,m,o);Qb(n,j)}f=Sa(n,10,f,v);Sa(n,12,m,c);Qb(n,s);rb:{if((w|0)==135){c=f;break rb}if((w|0)==137){c=f;f=f+1|0;break rb}c=Sa(n,12,m,c);Qb(n,s)}i=H[n+108>>2];if(d){Sa(n,10,y,t)}Sa(n,12,u,j);Qb(n,s);l=H[n+108>>2];H[(I[H[n>>2]+87|0]?73336:H[n+104>>2]+N(C,20)|0)+8>>2]=l;Sa(n,12,m,h);Sa(n,12,u,j);hb(n,s);fb(n,89,0,0,0,x,-14);fb(n,90,H[g+276>>2],H[g+332>>2],q,p,-8);d=H[n+108>>2];if((d|0)>0){G[(H[n+104>>2]+N(d,20)|0)-18>>1]=1}Ua(n,14,f,c,i);hb(n,o);c=H[e+52>>2];if(c){id(a,57,c)}H[e+52>>2]=k;H[k+56>>2]=e;pb(r,H[k+48>>2]);H[k+48>>2]=0;lh(a);d=H[a+36>>2]!=0;break m}l=0}H[c+12>>2]=H[g+244>>2];H[c+16>>2]=H[g+248>>2];if(!l){break m}id(a,57,l)}if(!H[b+56>>2]){break b}break a}t=H[e>>2];if(!t){break k}l=H[d+4>>2];if(l&1|(H[k>>2]>1|w?f:0)){break k}i=H[b+48>>2];if((H[d+48>>2]?i:0)|(H[d+48>>2]?w:0)){break k}sb:{if(f){if(H[b+36>>2]){break k}if(!(l&8192|h&1)){break sb}break k}if(l&8192){break k}}f=I[n+44|0];u=f&96;tb:{if(!u){t=0;break tb}if(I[H[e+24>>2]+43|0]==1|(t|0)>1){break k}t=1;if(f&16|h&1){break k}}l=(j|0)<=0;if(!(I[e+44|0]&64?l:1)){break k}ub:{if(!H[d+52>>2]){l=0;break ub}if(H[d+48>>2]|w){break k}f=d;if(u|h&1){break k}while(1){if(f){if(I[f+4|0]&9){break k}e=H[f+52>>2];if(I[f|0]!=135?e:0){break k}s=H[f+32>>2];if(H[f+68>>2]|H[s>>2]<=0){break k}f=e;if(!(I[s+44|0]&64)|l){continue}break k}break}vb:{if(!i){break vb}f=0;e=H[i>>2];e=(e|0)>0?e:0;i=i+8|0;while(1){if((e|0)==(f|0)){break vb}l=f<<4;f=f+1|0;if(J[(i+l|0)+12>>1]){continue}break}break k}if(h&8192){break k}e=H[d+28>>2];i=e+8|0;h=0;while(1){if(H[e>>2]>(h|0)){l=h<<4;s=rc(H[l+i>>2]);f=d;while(1){f=H[f+52>>2];if(f){if((rc(H[(l+H[f+28>>2]|0)+8>>2])|0)==(s|0)){continue}break k}break}h=h+1|0;continue}break}l=0;if(H[k>>2]<2){break ub}if(I[m+82|0]&128|H[a+108>>2]>500){break k}e=H[a+40>>2];h=e>>31<<2|e>>>30;e=(e<<2)+4|0;h=e>>>0<4?h+1|0:h;e=nb(m,e,h);if(!e){break ub}H[e>>2]=H[a+40>>2];l=e}e=d+52|0;H[a+260>>2]=H[n+16>>2];Yb(a,21,0,0,0);H[a+260>>2]=r;f=H[n+28>>2];Za(m,H[n+12>>2]);Za(m,H[n+16>>2]);Za(m,H[n+20>>2]);H[n+28>>2]=0;H[n+20>>2]=0;H[n+12>>2]=0;H[n+16>>2]=0;while(1){i=H[e>>2];if(i){d=H[b+52>>2];h=H[n+24>>2];r=H[b+60>>2];s=H[b+48>>2];H[n+24>>2]=0;H[b+60>>2]=0;H[b+48>>2]=0;H[b+52>>2]=0;e=Ud(m,b,0);H[b+48>>2]=s;H[b+60>>2]=r;F[b|0]=135;H[n+24>>2]=h;wb:{if(!e){e=d;break wb}h=H[a+108>>2]+1|0;H[a+108>>2]=h;H[e+16>>2]=h;if(!(I[m+87|0]|!l)){Mr(a,l,H[e+32>>2],j);H[g+272>>2]=0;H[g+276>>2]=0;H[g+280>>2]=0;H[g+284>>2]=0;H[g+272>>2]=46;H[g+264>>2]=0;H[g+268>>2]=0;H[g+288>>2]=l;H[g+268>>2]=58;ec(g+264|0,e)}H[e+52>>2]=d;if(d){H[d+56>>2]=e}H[e+56>>2]=b}H[b+52>>2]=e;e=i+52|0;continue}break}Za(m,l);xb:{if(I[m+87|0]){H[n+28>>2]=f;break xb}d=H[n+24>>2];if(d){e=H[d+24>>2];yb:{if((e|0)==1){e=H[a+128>>2];id(e?e:a,59,d);break yb}H[d+24>>2]=e-1}H[n+24>>2]=0}C=j+1|0;l=-1;i=f;d=b;while(1){zb:{if(!d){break zb}e=k+p|0;v=H[i+32>>2];h=H[v>>2];s=0;s=(b|0)==(d|0)?I[n+44|0]:s;e=I[e+44|0];k=H[d+32>>2];if((h|0)>=2){k=fn(a,k,h-1|0,C);if(!k){break zb}H[d+32>>2]=k}r=e&64;e=0;x=(h|0)>0?h:0;B=v+8|0;h=k+8|0;while(1){if((e|0)!=(x|0)){l=h+(e+j<<6)|0;if(I[l+38|0]&4){re(m,H[l+44>>2])}v=B+(e<<6)|0;l=Va(l,v,64);F[l+36|0]=r|I[l+36|0];l=H[v+40>>2];Xa(v,0,64);e=e+1|0;continue}break}e=h+p|0;F[e+36|0]=r|(I[e+36|0]&64|s);r=H[i+48>>2];if(!(!r|I[d+6|0]&64)){e=0;s=H[r>>2];s=(s|0)>0?s:0;v=r+8|0;while(1){if((e|0)!=(s|0)){G[(v+(e<<4)|0)+12>>1]=0;e=e+1|0;continue}break}H[d+48>>2]=r;H[i+48>>2]=0}e=H[i+36>>2];H[i+36>>2]=0;if(u){kh(e,l,1)}if(e){r=H[d+36>>2];if(r){e=ib(a,44,e,r)}H[d+36>>2]=e}if(!I[m+87|0]){H[g+276>>2]=t;H[g+272>>2]=l;H[g+268>>2]=y;H[g+264>>2]=a;H[g+280>>2]=H[i+28>>2];S=g,T=Lr(i),H[S+284>>2]=T;en(g+264|0,d,0)}H[d+4>>2]=H[d+4>>2]|H[i+4>>2]&256;e=H[i+60>>2];if(e){H[d+60>>2]=e;H[i+60>>2]=0}e=0;while(1){if((e|0)!=(x|0)){r=h+(e+j<<6)|0;if(H[r+16>>2]){H[g+272>>2]=0;H[g+276>>2]=0;H[g+280>>2]=0;H[g+284>>2]=0;H[g+272>>2]=46;H[g+264>>2]=0;H[g+268>>2]=0;H[g+288>>2]=r;H[g+268>>2]=60;H[r+48>>2]=0;H[r+52>>2]=0;ec(g+264|0,d)}e=e+1|0;continue}break}i=H[i+52>>2];d=H[d+52>>2];continue}break}H[g+332>>2]=0;H[g+336>>2]=0;H[g+340>>2]=0;H[g+344>>2]=0;H[g+328>>2]=46;H[g+324>>2]=47;H[g+320>>2]=a;ec(g+320|0,f);fc(m,f)}j=-1;if(H[a+36>>2]){break d}}if(I[q+87|0]){break d}k=H[b+32>>2];if(I[c|0]<9){break j}H[g+192>>2]=H[b+48>>2]}d=j}j=d+1|0;continue}}d=1;e=0}pb(q,e)}lh(a)}Ea=g+352|0;return d}function bf(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;t=Ea-160|0;Ea=t;m=H[a+8>>2];K=H[a>>2];H[t+60>>2]=0;H[t+52>>2]=0;H[t+56>>2]=0;if(d){i=H[d>>2]>63;g=i?g&32511:g;q=i?0:d}d=H[b>>2];a:{b:{if((d|0)>=65){H[t>>2]=64;Wa(a,11230,t);break b}r=g&32?1:d;i=N(r,96);o=(r|0)<=1?856:i+767&-8;l=Nb(K,o+72|0,0);if(I[K+87|0]){Za(K,l);break b}H[l+12>>2]=e;H[l+8>>2]=q;H[l+4>>2]=b;H[l>>2]=a;F[l+44|0]=r;H[l+20>>2]=-1;H[l+24>>2]=-1;d=H[a+56>>2]-1|0;H[a+56>>2]=d;G[l+42>>1]=h;G[l+40>>1]=g;H[l+32>>2]=d;H[l+28>>2]=d;d=G[a+156>>1];H[l+16>>2]=f;H[l+36>>2]=d;j=Xa(l+45|0,0,35);S=Xa(l+760|0,0,i+72|0);H[l+500>>2]=0;H[l+504>>2]=-99;d=l+o|0;H[t+48>>2]=d;L=l+80|0;H[t+44>>2]=L;H[t+40>>2]=l;G[d+48>>1]=3;G[d+44>>1]=0;H[d+52>>2]=d+60;H[d+40>>2]=0;F[l+89|0]=0;H[l+100>>2]=0;H[l+84>>2]=0;H[l+104>>2]=l+112;H[l+92>>2]=0;H[l+96>>2]=8;H[l+80>>2]=l;Gm(L,c,44);c:{if(r){w=l+504|0;x=b+8|0;while(1){c=x+(p<<6)|0;d=H[c+40>>2];i=H[l+500>>2];H[l+500>>2]=i+1;H[w+(i<<2)>>2]=d;d:{if(!(I[c+37|0]&4)){break d}j=H[c+56>>2];if(!j){break d}o=H[c+16>>2];n=j+8|0;d=0;k=0;while(1){if(H[j>>2]<=(k|0)){break d}i=G[o+34>>1];i=(d|0)>(i|0)?d:i;e:{while(1){if((d|0)==(i|0)){break e}if(!(I[(H[o+4>>2]+N(d,12)|0)+10|0]&2)){d=d+1|0;continue}break}i=sc(H[a>>2],167,0,0);if(!i){break d}s=H[c+40>>2];H[i+44>>2]=o;G[i+32>>1]=d;H[i+28>>2]=s;s=H[c+52>>2];X=c,Y=H[c+48>>2]|mr(i),H[X+48>>2]=Y;H[c+52>>2]=Ha|s;i=ib(a,53,i,ib(a,174,jb(H[a>>2],H[n+(k<<4)>>2],0),0));kh(i,H[c+40>>2],I[c+36|0]&24?1:2);be(L,i,1);k=k+1|0;d=d+1|0;continue}break}c=H[o>>2];H[t+36>>2]=k;H[t+32>>2]=c;Wa(a,17018,t+32|0)}p=p+1|0;if((p|0)<H[b>>2]){continue}break}break c}if(q){F[j|0]=H[q>>2]}if(!(!(g&256)|I[K+80|0]&16)){F[l+47|0]=1}gc(a,0,18661,0)}fr(b,L);if(!(!f|!H[f+60>>2])){c=0;f:{if(H[f+40>>2]|I[f+4|0]&9){break f}d=H[f+32>>2];if(H[d>>2]!=1|I[H[d+24>>2]+43|0]!=1){break f}i=H[L+12>>2];j=(i|0)>0?i:0;d=H[d+48>>2];i=H[f+48>>2];while(1){if((c|0)!=(j|0)){o=H[L+24>>2]+N(c,48)|0;if(!(I[o+10|0]&4|I[o+14|0])&(d|0)!=H[o+20>>2]){break f}c=c+1|0;continue}break}g:{if(!i){break g}c=0;o=H[i>>2];o=(o|0)>0?o:0;i=i+8|0;while(1){if((c|0)==(o|0)){break g}j=i+(c<<4)|0;w=H[j>>2];if(I[w|0]!=167|(d|0)!=H[w+28>>2]){break f}c=c+1|0;if(!(I[j+8|0]&2)){continue}break}break f}Tz(L,H[f+8>>2],H[H[f+60>>2]+12>>2],d,73);c=H[f+12>>2];if((c|0)<=0){break f}Tz(L,c,H[H[f+60>>2]+16>>2],d,74)}}h:{i:{if(H[a+36>>2]){break i}U=l+496|0;f=L;d=0;while(1){if(H[f+20>>2]>(d|0)){c=H[f+24>>2]+N(d,48)|0;j:{if(I[c+10|0]&2|(H[c+40>>2]|H[c+44>>2])){break j}f=H[c>>2];if(r){H[t+72>>2]=0;H[t+76>>2]=0;H[t+80>>2]=0;H[t+84>>2]=0;H[t+88>>2]=0;H[t+72>>2]=62;H[t+64>>2]=0;H[t+68>>2]=0;H[t+68>>2]=72;G[t+84>>1]=1;Jb(t- -64|0,f);if(!J[t+84>>1]){break j}}if(I[b+44|0]&64?I[f+4|0]&2:0){break j}wc(a,f,H[l+32>>2],16);G[c+10>>1]=J[c+10>>1]|4}d=d+1|0;f=H[t+44>>2];continue}break}k:{if(!(g&256)){break k}if(I[K+80|0]&16){G[l+40>>1]=J[l+40>>1]&65279;g=g&32511;break k}l:{if(H[b>>2]!=1){break l}c=H[e>>2];i=(c|0)>0?c:0;o=e+8|0;j=H[b+24>>2];f=H[b+48>>2];d=0;m:{while(1){if((d|0)!=(i|0)){c=bd(H[o+(d<<4)>>2]);n:{if(!c){break n}o:{switch(I[c|0]-167|0){case 0:case 2:break o;default:break n}}if((f|0)!=H[c+28>>2]){break n}if(G[c+32>>1]<0){break m}}d=d+1|0;continue}break}d=j+8|0;while(1){c=H[d>>2];if(!c){break l}if(!(H[c+36>>2]|!I[c+54|0])){k=0;while(1){p:{if(J[c+50>>1]<=k>>>0){break p}if(!er(L,f,k,-1,-1,2,c)){j=H[H[c+32>>2]+(k<<2)>>2];d=0;while(1){if(H[e>>2]<=(d|0)){break p}q:{w=H[o+(d<<4)>>2];i=bd(w);r:{if(!i){break r}s:{switch(I[i|0]-167|0){case 0:case 2:break s;default:break r}}if(J[i+32>>1]!=J[H[c+4>>2]+(k<<1)>>1]|(f|0)!=H[i+28>>2]){break r}if(!ab(H[Bf(a,w)>>2],j)){break q}}d=d+1|0;continue}break}if(!mA(c,k)){break p}}k=k+1|0;continue}break}if(J[c+50>>1]==(k|0)){break m}}d=c+20|0;continue}}F[l+47|0]=1;break k}if(q){break k}H[l+8>>2]=e;G[l+40>>1]=J[l+40>>1]|128}t:{u:{v:{w:{x:{y:{f=H[t+40>>2];z:{if(I[f+40|0]&32|(r|0)!=1){break z}o=H[f+4>>2];i=H[o+24>>2];if(I[i+43|0]==1|I[o+45|0]&3){break z}j=H[o+48>>2];c=H[t+48>>2];G[c+46>>1]=0;H[c+40>>2]=0;w=f+80|0;d=Fm(t- -64|0,w,j,-1,130,0);while(1){if(d){if(!(H[d+32>>2]|H[d+36>>2])){break y}d=pi(t- -64|0);continue}break}d=i+8|0;while(1){i=H[d>>2];if(i){A:{if(H[i+36>>2]|!I[i+54|0]){break A}d=J[i+50>>1];if(d>>>0>3){break A}x=I[i+55|0]&8?130:2;k=0;B:{while(1){d=d&65535;if(k>>>0>=d>>>0){break B}d=Fm(t- -64|0,w,j,k,x,i);C:{while(1){if(!d){break C}if(H[d+32>>2]|H[d+36>>2]){d=pi(t- -64|0);continue}break}H[H[c+52>>2]+(k<<2)>>2]=d;k=k+1|0;d=J[i+50>>1];continue}break}d=J[i+50>>1]}if((d|0)!=(k|0)){break A}s=4609;H[c+40>>2]=4609;D:{if(!(I[i+55|0]&32)){if(H[i+64>>2]&H[o+56>>2]|H[i+68>>2]&H[o+60>>2]){break D}}s=4673;H[c+40>>2]=4673}H[c+32>>2]=i;G[c+24>>1]=k;G[c+44>>1]=k;d=39;break x}d=i+20|0;continue}break}s=H[c+40>>2];if(s){break w}f=H[t+40>>2]}n=H[H[f>>2]>>2];c=H[f+4>>2];d=I[f+44|0];H[t+60>>2]=2e4;p=c+8|0;R=p+(d<<6)|0;v=f+496|0;k=H[t+48>>2];o=0;q=0;s=0;while(1){if(p>>>0>=R>>>0){break v}F[k+16|0]=o;H[t+60>>2]=H[t+60>>2]+1e3;X=k,Y=Je(v,H[p+40>>2]),H[X+8>>2]=Y;H[k+12>>2]=Ha;c=I[p+36|0];E:{if(c&98|q){s=c&64?1:s;z=u|z;B=y|B;q=c>>>4&1;break E}z=s?z:0;B=s?B:0;s=(s|0)!=0;q=0}w=0;x=0;F:{G:{f=p;H:{if(I[H[f+16>>2]+43|0]==1){while(1){I:{j=w;i=x;c=f;f=c- -64|0;if(R>>>0<=f>>>0){break I}if(!(i|j)){w=0;x=0;if(!(I[c+100|0]&34)){continue}}w=Je(v,H[c+104>>2])|j;x=i|Ha;continue}break}d=lA(t+40|0,z,B,j,i);break H}j=0;i=0;d=kA(t+40|0,z,B)}J:{if(!d){if(!I[H[t+44>>2]+9|0]){u=u|H[k+8>>2];y=y|H[k+12>>2];break J}d=jA(t+40|0,z,B,j,i)}u=u|H[k+8>>2];y=y|H[k+12>>2];if((d|0)==101){break G}if(d){break u}}if(I[n+87|0]){break v}break F}Ec(28,12337,0)}p=p- -64|0;o=o+1|0;continue}}s=4353;H[c+40>>2]=4353;H[H[c+52>>2]>>2]=d;G[c+24>>1]=1;G[c+44>>1]=1;d=33}G[c+20>>1]=d}G[c+22>>1]=1;H[f+840>>2]=c;H[c+8>>2]=1;H[c+12>>2]=0;G[f+50>>1]=1;H[f+764>>2]=j;d=H[f+8>>2];if(d){F[f+45|0]=H[d>>2]}if(F[f+41|0]&1){F[f+47|0]=1}if(I[t+89|0]<2){break t}H[c+40>>2]=s|2097152;break t}d=0}hA(n,k);if(d){break i}gA(l,0);if(I[K+87|0]){break i}if(H[l+8>>2]){gA(l,J[l+50>>1]+1<<16>>16);if(I[K+87|0]){break h}}if(!(F[l+41|0]&1)){break t}G[l+50>>1]=J[l+50>>1]-30}if(!(H[l+8>>2]|!(I[K+33|0]&16))){z=0;B=0;c=H[l+4>>2];o=c+8|0;c=H[c>>2];c=(c|0)>0?c:0;while(1){if((c|0)!=(z|0)|B){d=o+(z<<6)|0;K:{L:{if(!(F[d+38|0]&1)|I[H[d+60>>2]+18|0]){break L}d=H[d+20>>2];if(!d){break L}if(H[d+48>>2]){break K}}i=H[l+76>>2];d=z&31;if((z&63)>>>0>=32){f=1<<d;p=0}else{p=1<<d;f=p-1&1>>>32-d}H[l+72>>2]=p|H[l+72>>2];H[l+76>>2]=f|i}i=B;z=z+1|0;B=z?i:i+1|0;continue}break}}if(H[a+36>>2]){break h}z=-1;B=-1;d=I[l+44|0];M:{N:{if(!(!e|g&1024|d>>>0<2)){if(F[K+81|0]&1){break N}c=l+496|0;z=_e(c,H[l+12>>2]);B=Ha;d=H[l+8>>2];if(d){z=_e(c,d)|z;B=B|Ha}k=l+760|0;r=I[H[l+4>>2]+44|0]&64;o=I[l+44|0];f=o;w=-1;x=-1;O:while(1){if((f|0)>=2){e=f;f=f-1|0;n=k+N(f,96)|0;c=H[n+80>>2];p=H[l+4>>2]+(I[c+16|0]<<6)|0;if((I[p+44|0]&24)!=8|!(F[l+41|0]&1|I[c+41|0]&16)){continue}i=H[c+8>>2];j=H[c+12>>2];if(z&i|B&j){continue}c=H[l+104>>2];q=c+N(H[l+92>>2],48)|0;d=c;while(1){if(d>>>0<q>>>0){if(i&H[d+40>>2]|j&H[d+44>>2]){s=H[d>>2];if(!(F[s+4|0]&1)|H[s+36>>2]!=H[p+48>>2]){continue O}}P:{if(!r){break P}s=H[d>>2];if(!(I[s+4|0]&2)){break P}if(H[s+36>>2]==H[p+48>>2]){continue O}}d=d+48|0;continue}break}while(1){if(c>>>0<q>>>0){if(i&H[c+40>>2]|j&H[c+44>>2]){G[c+10>>1]=J[c+10>>1]|4}c=c+48|0;continue}break}w=w&(i^-1);x=x&(j^-1);c=o&255;if((c|0)!=(e|0)){Ic(n,k+N(e,96)|0,N(c-e|0,96));o=I[l+44|0]}o=o-1|0;F[l+44|0]=o;continue}break}B=x;d=I[l+44|0];r=d;z=w}if((d&255)>>>0<2){break M}}if(I[K+82|0]&8){break M}c=0;d=0;o=l+760|0;j=I[l+44|0];while(1){Q:{if((c|0)==(j|0)){break Q}e=H[(o+N(c,96)|0)+80>>2];f=H[(H[l+4>>2]+(I[e+16|0]<<6)|0)+24>>2];i=H[f+28>>2];if(!(i&16)){break Q}H[f+28>>2]=i|256;R:{if(!c){break R}i=H[e+40>>2];if((i&8388609)!=8388609|!(i&768)|G[f+38>>1]>=d<<16>>16){break R}H[e+40>>2]=i&-4194369|4194304}c=c+1|0;d=J[e+22>>1]+d|0;continue}break}}c=H[l>>2];G[c+156>>1]=J[c+156>>1]+J[l+50>>1];x=0;S:{if(!(g&4)){break S}f=H[l+840>>2];e=H[f+40>>2];T:{if(e&4096){c=H[b+24>>2];k=1;break T}x=0;if(!(g&8)){break S}c=H[b+24>>2];x=0;if(I[c+43|0]==1){break S}if(!(g&16)){x=0;if(e&8192){break S}}k=2;x=0;if(I[K+83|0]&8){break S}}F[l+46|0]=k;x=0;if(!(e&64)){break S}x=0;if(H[c+28>>2]&128){break S}H[f+40>>2]=e&-65;x=g&8}w=(r|0)>0?r:0;V=b+8|0;n=g&32;u=!h|!n;o=0;k=S;while(1){if((o|0)!=(w|0)){p=(I[k+60|0]<<6)+V|0;c=H[p+16>>2];e=Fb(K,H[c+60>>2]);q=H[k+80>>2];U:{if(I[c+29|0]&64){break U}d=I[c+43|0];if((d|0)==2){break U}f=H[q+40>>2];if(f&1024){fb(m,173,H[p+40>>2],0,0,zd(K,c),-11);break U}if((d|0)==1){break U}if(!(I[p+36|0]&80?0:n|f&64)){d=H[p+40>>2];if(I[l+46|0]){H[l+20>>2]=d;f=113}else{f=112}Hd(a,d,e,c,f);if(!(I[l+46|0]|G[c+34>>1]>63|(I[c+28|0]&224|(I[q+41|0]|I[q+42|0]<<8)&16448))){j=H[p+48>>2];i=H[p+52>>2];d=0;while(1){if(i|j){d=d+1|0;j=(i&1)<<31|j>>>1;i=i>>>1|0;continue}break}Wd(m,-1,d,-3)}d=H[m+108>>2];if((d|0)<=0){break U}G[(H[m+104>>2]+N(d,20)|0)-18>>1]=x;break U}wd(a,e,H[c+20>>2],0,H[c>>2])}V:{if(!(I[q+41|0]&2)){break V}i=H[q+32>>2];W:{X:{Y:{if(!(!(I[c+28|0]&128)|!n)){if(((I[i+55|0]|I[i+56|0]<<8)&3)==2){break Y}}if(I[l+46|0]){d=H[p+16>>2]+8|0;f=h;while(1){d=H[d>>2];if(!d|(d|0)==(i|0)){break X}d=d+20|0;f=f+1|0;continue}}d=101;f=h;if(!u){break W}f=H[a+40>>2];H[a+40>>2]=f+1;if(!(!(I[i+56|0]&16)|F[K+83|0]&1)){r=0;s=a+72|0;R=H[i+12>>2];while(1){Z:{if(J[i+52>>1]<=r>>>0){break Z}d=G[H[i+4>>2]+(r<<1)>>1];_:{$:{if((d|0)==-2){v=(I[p+36|0]&88)!=0;d=H[(H[i+40>>2]+(r<<4)|0)+8>>2];break $}if((d|0)<0){break _}d=H[R+4>>2]+N(d,12)|0;if(!(I[d+10|0]&32)){break _}v=0;d=Mc(R,d)}if(ge(d)){break _}if(I[d|0]==172){y=H[a>>2];E=H[d+8>>2];j=H[d+20>>2];if(j){j=H[j>>2]}else{j=0}j=Te(y,E,j,I[y+84|0],0);if(!j|F[j+7|0]&1){break _}}j=nd(H[a>>2],24,0);if(!j){break Z}H[j+20>>2]=H[a+72>>2];X=j,Y=jb(H[a>>2],d,0),H[X>>2]=Y;d=H[p+40>>2];F[j+16|0]=v;H[j+12>>2]=r;H[j+8>>2]=f;H[j+4>>2]=d;if(jh(H[a>>2],i)){F[j+17|0]=I[H[i+16>>2]+r|0]}H[s>>2]=j;if(H[j+20>>2]){break _}id(a,87,s)}r=r+1|0;continue}break}}d=112;j=H[i+36>>2];if(!j|I[p+36|0]&16){break W}dr(a,i,j,0,f,p);break W}H[k+8>>2]=H[k+4>>2];break V}H[l+24>>2]=f;d=113}H[k+8>>2]=f;Ua(m,d,f,H[i+44>>2],e);Ed(a,i);d=H[q+40>>2];if(F[l+40|0]&1|(!(d&15)|d&1605634)|I[l+47|0]==2){break V}d=H[m+108>>2];if((d|0)<=0){break V}G[(H[m+104>>2]+N(d,20)|0)-18>>1]=2}if((e|0)>=0){ld(a,e)}aa:{if(!(I[p+36|0]&16)){break aa}d=cr(l,20);H[k+56>>2]=d;if(!d){break aa}e=H[a+40>>2];H[a+40>>2]=e+1;H[d>>2]=e;e=H[a+44>>2]+1|0;H[a+44>>2]=e;H[d+4>>2]=e;Sa(m,77,65536,e);e=H[a+44>>2]+1|0;H[a+44>>2]=e;H[d+8>>2]=e;Sa(m,75,0,e);ba:{if(!(I[c+28|0]&128)){Sa(m,118,H[d>>2],1);c=Ef(H[a>>2],1,0);if(!c){break ba}H[c+20>>2]=0;F[H[c+16>>2]]=0;xc(m,c,-8);break ba}d=H[d>>2];c=jc(c);Sa(m,118,d,J[c+50>>1]);Ed(a,c)}H[q+40>>2]=H[q+40>>2]&-65;F[l+47|0]=3;F[l+45|0]=0}k=k+96|0;o=o+1|0;continue}break}H[l+52>>2]=H[m+108>>2];if(I[K+87|0]){break h}R=w;w=0;x=0;while(1){ca:{if((w|0)!=(R|0)|x){if(H[a+36>>2]){break h}n=N(w,96)+S|0;d=H[H[n+80>>2]+40>>2];c=(I[n+60|0]<<6)+V|0;e=I[c+37|0]|I[c+38|0]<<8;da:{if(!(e&16)){break da}if(e&8){Sa(m,10,H[c+28>>2],H[c+24>>2]);break da}e=Mb(m,15);Sa(m,10,H[c+28>>2],H[c+24>>2]);H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(e,20)|0)+8>>2]=H[m+108>>2]}if(d&4210688){ea:{if(d&16384){p=0;j=0;i=0;r=0;u=0;y=0;C=Ea-16|0;Ea=C;k=H[a+8>>2];M=Mb(k,15);e=H[L+24>>2];O=e+N(H[L+12>>2],48)|0;s=H[H[L>>2]+4>>2];c=s+(I[n+60|0]<<6)|0;q=c+8|0;A=H[c+24>>2];v=H[n+80>>2];c=0;fa:{while(1){if(e>>>0<O>>>0){ga:{if(I[e+10|0]&2){break ga}d=H[e>>2];if(!gr(d,s,I[n+60|0])){break ga}r=Td(a,r,jb(H[a>>2],d,0))}ha:{if(!$q(e,q,z,B)){break ha}h=H[e+24>>2];d=h&31;if((h&63)>>>0>=32){f=1<<d;d=0}else{o=1<<d;f=o-1&1>>>32-d;d=o}o=(h|0)>63;d=o?0:d;o=o?-2147483648:f;if(!(p&255)){f=H[A>>2];H[C+4>>2]=H[H[A+4>>2]+N(h,12)>>2];H[C>>2]=f;Ec(284,25096,C)}p=1;if(d&j|i&o){break ha}f=c+1|0;if(oi(H[a>>2],v,f)){break fa}H[H[v+52>>2]+(c<<2)>>2]=e;j=d|j;i=i|o;c=f}e=e+48|0;continue}break}H[v+40>>2]=16961;G[v+24>>1]=c;G[v+44>>1]=c;E=-1;d=-1;if(I[A+43|0]!=2){E=H[q+48>>2]&(j^-1);d=H[q+52>>2]&(i^-1|-2147483648)}e=G[A+34>>1];f=(e|0)>=63?63:e;h=(f|0)>0?f:0;j=0;i=0;while(1){if((h|0)!=(j|0)|i){o=c;f=E;c=j&31;if((j&63)>>>0>=32){c=d>>>c|0}else{c=((1<<c)-1&d)<<32-c|f>>>c}c=o+(c&1)|0;f=i;j=j+1|0;i=j?f:f+1|0;continue}break}p=0;Q=((e-63&H[q+52>>2]>>31)+c|0)+1|0;s=ds(H[a>>2],Q<<16>>16,0,C+12|0);if(!s){break fa}H[v+32>>2]=s;H[s+12>>2]=A;H[s>>2]=1536;c=H[L+24>>2];j=0;i=0;e=0;while(1){if(c>>>0>=O>>>0){while(1){if((h|0)!=(j|0)|i){f=E;c=j&31;if((j&63)>>>0>=32){c=d>>>c|0}else{c=((1<<c)-1&d)<<32-c|f>>>c}if(c&1){G[H[s+4>>2]+(e<<1)>>1]=j;H[H[s+32>>2]+(e<<2)>>2]=33248;e=e+1|0}j=j+1|0;i=j?i:i+1|0;continue}break}}else{ia:{if(!$q(c,q,z,B)){break ia}D=H[c+24>>2];o=D&31;if((D&63)>>>0>=32){f=1<<o;o=0}else{P=1<<o;f=P-1&1>>>32-o;o=P}P=(D|0)>63;o=P?0:o;P=P?-2147483648:f;if(u&o|y&P){break ia}f=H[c>>2];G[H[s+4>>2]+(e<<1)>>1]=D;D=Uh(a,f);if(D){D=H[D>>2]}else{D=33248}u=o|u;y=y|P;H[H[s+32>>2]+(e<<2)>>2]=D;e=e+1|0;f=H[f+12>>2];if(!f){break ia}p=(rc(f)|0)!=66?1:p}c=c+48|0;continue}break}ja:{c=H[q+52>>2];if((c|0)>0){c=1}else{c=(c|0)>=0}if(c){break ja}c=63;while(1){if(G[A+34>>1]<=(c|0)){break ja}G[H[s+4>>2]+(e<<1)>>1]=c;H[H[s+32>>2]+(e<<2)>>2]=33248;c=c+1|0;e=e+1|0;continue}}G[H[s+4>>2]+(e<<1)>>1]=65535;H[H[s+32>>2]+(e<<2)>>2]=33248;c=H[a+40>>2];H[a+40>>2]=c+1;H[n+8>>2]=c;Sa(k,116,c,Q);Ed(a,s);if(!(!(p&255)|I[H[a>>2]+82|0]&8)){Sz(a,H[L>>2],n);c=H[a+44>>2]+1|0;H[a+44>>2]=c;H[n+52>>2]=c;Sa(k,77,1e4,c)}ka:{if(I[q+37|0]&32){c=H[q+28>>2];i=Sa(k,71,0,0);Ua(k,11,c,0,H[q+24>>2]);c=_a(k,12,c);break ka}i=0;c=_a(k,36,H[n+4>>2])}p=0;if(r){p=H[a+56>>2]-1|0;H[a+56>>2]=p;wc(a,r,p,16);H[v+40>>2]=H[v+40>>2]|131072}f=zb(a);d=Vm(a,s,H[n+4>>2],f,0,0,0,0);h=H[n+52>>2];if(h){gb(k,183,h,0,d,J[v+24>>1])}Sa(k,138,H[n+8>>2],f);h=H[k+108>>2];if((h|0)>0){G[(H[k+104>>2]+N(h,20)|0)-18>>1]=16}if(r){hb(k,p)}la:{if(I[q+37|0]&32){e=d+e|0;H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(i,20)|0)+8>>2]=e;Wz(a,c,H[n+4>>2],H[q+32>>2],H[n+8>>2]);Qb(k,c);d=(I[q+37|0]|I[q+38|0]<<8)&65503;F[q+37|0]=d;F[q+38|0]=d>>>8;d=H[k+108>>2];break la}Sa(k,39,H[n+4>>2],c+1|0);d=H[k+108>>2];if((d|0)<=0){break la}G[(H[k+104>>2]+N(d,20)|0)-18>>1]=3}H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(c,20)|0)+8>>2]=d;rb(a,f);d=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(M,20)|0)+8>>2]=d}eb(H[a>>2],r);Ea=C+16|0;break ea}d=w;c=n;o=H[c+80>>2];k=H[l>>2];A=H[k+76>>2];H[k+76>>2]=0;C=H[k+72>>2];H[k+72>>2]=0;D=l+760|0;h=H[k+8>>2];E=Mb(h,15);while(1){Sz(k,l,c);r=H[k+56>>2]-1|0;H[k+56>>2]=r;p=H[c+4>>2];s=H[k+44>>2]+1|0;H[k+44>>2]=s;H[c+52>>2]=s;M=H[l+4>>2];O=I[c+60|0];q=G[H[(M+(O<<6)|0)+24>>2]+38>>1];if((q|0)<=609){e=(q|0)/10|0;v=e<<16>>16;f=q-N(e,10)|0;e=f<<16>>16;i=e>>31;f=f&65535;j=f>>>0>4;u=j?e-2|0:f?e-1|0:0;e=j?i-(e>>>0<2)|0:f?i-!e|0:0;f=u+8|0;e=f>>>0<8?e+1|0:e;i=f;y=f;u=v-3|0;j=u&31;if((u&63)>>>0>=32){f=f<<j;j=0}else{f=(1<<j)-1&y>>>32-j|e<<j;j=y<<j}if((q|0)<30){q=i;j=3-v|0;f=j&31;if((j&63)>>>0>=32){i=0;j=e>>>f|0}else{i=e>>>f|0;j=((1<<f)-1&e)<<32-f|q>>>f}f=i}e=j}else{f=2147483647;e=-1}i=!f&e>>>0>=1e7|(f|0)!=0;e=i?1e7:e;Sa(h,77,!(i?0:f)&e>>>0<=1e4?1e4:e,s);j=_a(h,36,p);f=H[l+104>>2];e=f+N(H[l+92>>2],48)|0;while(1){if(e>>>0>f>>>0){ma:{if(I[f+10|0]&2){break ma}if(!gr(H[f>>2],M,O)){break ma}wc(k,H[f>>2],r,16)}f=f+48|0;continue}break}na:{if(F[o+41|0]&1){e=zb(k);Sa(h,135,p,e);gb(h,183,H[c+52>>2],0,e,1);rb(k,e);break na}q=H[o+32>>2];f=0;e=J[o+24>>1];i=nc(k,e);while(1){if((e|0)!=(f|0)){yr(k,q,p,f,f+i|0);f=f+1|0;continue}break}gb(h,183,H[c+52>>2],0,i,e);Sc(k,i,e)}hb(h,r);Sa(h,39,H[c+4>>2],j+1|0);e=H[h+108>>2];i=I[H[h>>2]+87|0];H[(i?73336:H[h+104>>2]+N(j,20)|0)+8>>2]=e;H[o+40>>2]=H[o+40>>2]&-4194305;oa:{if(I[H[k>>2]+82|0]&16){break oa}c=d+1|0;f=I[l+44|0];j=((c|0)>(f|0)?c:f)-1|0;while(1){if((d|0)==(j|0)){break oa}d=d+1|0;c=D+N(d,96)|0;if(I[(H[l+4>>2]+(I[c+60|0]<<6)|0)+44|0]&72){continue}o=H[c+80>>2];if(!o|(z&H[o>>2]|B&H[o+4>>2]|(H[o+40>>2]&4194308)!=4194304)){continue}break}if((d|0)<(f|0)){continue}}break}H[(i?73336:H[h+104>>2]+N(E,20)|0)+8>>2]=e;H[k+76>>2]=A;H[k+72>>2]=C}if(I[K+87|0]){break h}}fA(a,b,n,g);H[n+32>>2]=H[m+108>>2];j=H[n+80>>2];y=H[a>>2];f=I[n+60|0];h=H[l+4>>2]+(f<<6)|0;v=H[h+48>>2];X=n,Y=(Je(U,v)^-1)&z,H[X+88>>2]=Y;H[n+92>>2]=(Ha^-1)&B;d=H[l+72>>2];c=H[l+76>>2];i=H[a+56>>2];e=i-1|0;H[n+12>>2]=e;H[n+16>>2]=e;Q=i-2|0;H[a+56>>2]=Q;H[n+24>>2]=Q;D=h+8|0;if(!(!f|!(I[D+36|0]&8))){f=H[a+44>>2]+1|0;H[a+44>>2]=f;H[n>>2]=f;Sa(m,71,0,f)}f=d;d=w&31;if((w&63)>>>0>=32){c=c>>>d|0}else{c=((1<<d)-1&c)<<32-d|f>>>d}u=c&1;d=w;while(1){if((d|0)<=0){d=0;break ca}c=N(d,96)+S|0;if(H[c>>2]|H[c+56>>2]){break ca}d=d-1|0;continue}}H[l+56>>2]=H[m+108>>2];break a}f=I[D+37|0]|I[D+38|0]<<8;pa:{qa:{if(f&32){r=0;c=H[D+28>>2];Ua(m,11,c,0,H[D+24>>2]);c=Sa(m,12,c,e);F[n+61|0]=9;H[n+68>>2]=c;break qa}c=H[j+40>>2];if(c&1024){i=J[j+44>>1];e=nc(a,i+2|0);o=e+2|0;r=H[n+12>>2];d=0;while(1){if((d|0)!=(i|0)){c=H[H[j+52>>2]+(d<<2)>>2];ra:{if(!c){break ra}f=d+o|0;if(F[c+12|0]&1){if(H[j+36>>2]&(d>>>0<32?1<<d:0)){h=H[a+40>>2];H[a+40>>2]=h+1;k=H[a+44>>2]+1|0;H[a+44>>2]=k;IA(a,H[c>>2],h);Ua(m,175,h,f,k);break ra}Em(a,c,n,d,u,f);r=H[n+16>>2];break ra}ek(a,H[H[c>>2]+16>>2],f,1);if(!(I[j+28|0]&2)|I[c+15|0]!=74){break ra}Sa(m,71,0,H[H[l+16>>2]+12>>2])}d=d+1|0;continue}break}Sa(m,71,H[j+24>>2],e);Sa(m,71,i,e+1|0);fb(m,6,v,r,e,H[j+32>>2],F[j+28|0]&1?-6:-1);F[j+28|0]=I[j+28|0]&254;if(I[y+87|0]){H[j+32>>2]=0}H[n+64>>2]=v;F[n+61|0]=I[l+46|0]?-69:63;H[n+68>>2]=H[m+108>>2];r=0;d=0;while(1){if((d|0)==(i|0)){break qa}h=H[H[j+52>>2]+(d<<2)>>2];sa:{if(!(!(J[j+30>>1]>>>d&1)|d>>>0>15)){fh(n,h);break sa}if(I[y+87|0]|(!(F[h+12|0]&1)|H[j+36>>2]&(d>>>0<32?1<<d:0))){break sa}c=0;e=H[n+72>>2];e=(e|0)>0?e:0;f=d+o|0;while(1){ta:{if((c|0)!=(e|0)){p=73336;if(!I[H[m>>2]+87|0]){p=H[m+104>>2]+N(H[(H[n+76>>2]+N(c,20)|0)+4>>2],20)|0}k=I[p|0];ua:{if((k|0)!=135){if((k|0)!=94|(f|0)!=H[p+12>>2]){break ta}e=f;c=H[p+8>>2];break ua}if((f|0)!=H[p+8>>2]){break ta}e=H[p+12>>2];c=f}Ua(m,k,H[p+4>>2],c,e)}c=ib(a,53,0,0);if(!I[y+87|0]){e=H[H[h>>2]+12>>2];h=H[h+28>>2];if((h|0)>0){e=H[(H[e+20>>2]+(h<<4)|0)-8>>2]}H[c+12>>2]=e;e=oc(y,176,0);H[c+16>>2]=e;if(e){H[e+28>>2]=f;wc(a,c,H[n+24>>2],16)}H[c+12>>2]=0}eb(y,c);break sa}c=c+1|0;continue}}d=d+1|0;continue}}d=H[(N(d,96)+S|0)+12>>2];va:{wa:{xa:{ya:{za:{if(!(!(c&256)|!(c&5))){d=H[H[j+52>>2]>>2];c=H[a+44>>2]+1|0;H[a+44>>2]=c;d=Em(a,d,n,0,u,c);if((d|0)!=(c|0)){rb(a,c)}c=H[n+16>>2];if(H[n+52>>2]){Sa(m,13,d,c);gb(m,64,H[n+52>>2],c,d,1);eA(a,l,w,c,z,B)}Ua(m,30,v,c,d);break za}if((c&258)==258){k=0;o=0;q=0;if(c&32){q=1;o=H[H[j+52>>2]>>2]}k=c&16?H[H[j+52>>2]+(q<<2)>>2]:k;f=u?o:k;h=u?k:o;Aa:{if(h){c=H[h>>2];d=H[c+16>>2];Ba:{if(Ke(d)){d=zb(a);ek(a,H[c+16>>2],d,1);o=d;c=I[c|0]+1&2|1;break Ba}o=Jc(a,d,t- -64|0);fh(n,h);d=H[t+64>>2];c=I[c|0]-54|0}Ua(m,I[c+50128|0],v,e,o);rb(a,d);break Aa}Sa(m,u?32:36,v,d)}r=0;Ca:{if(!f){d=187;c=0;break Ca}d=H[f>>2];c=H[a+44>>2]+1|0;H[a+44>>2]=c;ek(a,H[d+16>>2],c,1);Da:{Ea:{if(!Ke(H[d+16>>2])){Fa:{switch(I[d|0]-54|0){case 0:case 2:break Fa;default:break Ea}}d=u?55:57;break Da}d=u?56:54;break Ca}d=u?56:54}fh(n,f)}H[n+68>>2]=H[m+108>>2];H[n+64>>2]=v;F[n+61|0]=u^39;if((d|0)==187){break qa}f=H[a+44>>2]+1|0;H[a+44>>2]=f;Sa(m,135,v,f);Ua(m,d,c,e,f);c=H[m+108>>2];if((c|0)<=0){break qa}G[(H[m+104>>2]+N(c,20)|0)-18>>1]=83;break qa}if(c&512){f=J[j+26>>1];h=0;r=0;p=0;d=J[j+24>>1];q=d;if(c&32){r=f;q=d+1|0;p=H[H[j+52>>2]+(d<<2)>>2]}e=J[j+28>>1];E=H[n+8>>2];A=H[j+32>>2];Ga:{if(!(c&16)){q=0;break Ga}q=H[H[j+52>>2]+(q<<2)>>2];if(F[q+11|0]&1){c=H[a+44>>2]+1|0;H[a+44>>2]=c;H[n+44>>2]=c;Sa(m,71,1,c);H[n+48>>2]=H[m+108>>2];c=H[n+44>>2]<<1;H[n+44>>2]=c;H[n+44>>2]=c|u^I[d+H[A+28>>2]|0]==1}r=e>>>0<r>>>0?r:e;if(p){break Ga}c=G[H[A+4>>2]+(d<<1)>>1];Ha:{if((c|0)>=0){if(!(I[(H[H[A+12>>2]+4>>2]+N(c,12)|0)+4|0]&15)){break Ha}break Ga}if((c|0)!=-2){break Ga}}h=1}s=0;c=0;if((H[j+40>>2]&524336)==524288){c=H[a+44>>2]+1|0;H[a+44>>2]=c;H[n+36>>2]=c;if(H[n>>2]){Sa(m,71,0,c)}h=H[a+56>>2]-1|0;H[a+56>>2]=h;H[n+40>>2]=h;r=1;h=1}if((u|0)==(I[d+H[A+28>>2]|0]!=0|0)|d>>>0>=J[A+52>>1]){break wa}o=f&255;i=0;s=h;h=p;break va}if(c&8192){C=H[a+40>>2];H[a+40>>2]=C+1;u=H[a+44>>2]+1|0;H[a+44>>2]=u;E=H[a+56>>2]-1|0;H[a+56>>2]=E;i=H[D+16>>2];M=H[H[j+52>>2]>>2];A=H[M+24>>2];H[n+64>>2]=u;F[n+61|0]=67;c=I[l+44|0];Ia:{if(c>>>0>=2){d=c-w|0;e=Nb(y,d<<6|8,0);if(!e){break pa}d=d&255;H[e>>2]=d;H[e+4>>2]=d;f=Va(e+8|0,D,64);d=1;c=c+W|0;c=(c|0)<=1?1:c;h=H[l+4>>2]+8|0;while(1){if((c|0)==(d|0)){break Ia}Va(f+(d<<6)|0,h+(I[(n+N(d,96)|0)+60|0]<<6)|0,64);d=d+1|0;continue}}e=H[l+4>>2]}h=0;r=0;s=0;if(!(I[l+40|0]&16)){Ja:{if(!(I[i+28|0]&128)){r=H[a+44>>2]+1|0;H[a+44>>2]=r;Sa(m,75,0,r);break Ja}c=jc(i);r=H[a+40>>2];H[a+40>>2]=r+1;Sa(m,118,r,J[c+50>>1]);Ed(a,c)}s=H[a+44>>2]+1|0;H[a+44>>2]=s}P=Sa(m,71,0,u);d=0;p=H[l+92>>2];Ka:{if((p|0)<2){break Ka}while(1){if((d|0)<(p|0)){c=H[l+104>>2]+N(d,48)|0;La:{if((c|0)==(M|0)|J[c+10>>1]&32774|!(J[c+12>>1]&16383)){break La}c=H[c>>2];if(I[c+6|0]&64){break La}h=Td(a,h,jb(y,c,0));p=H[l+92>>2]}d=d+1|0;continue}break}if(!h){h=0;break Ka}h=ib(a,65580,0,h)}o=0;gc(a,1,19439,0);O=0;f=0;while(1){if(H[A+12>>2]>(f|0)){c=H[A+24>>2]+N(f,48)|0;if(!((v|0)!=H[c+20>>2]&!(I[c+13|0]&4))){c=jb(y,H[c>>2],0);Ma:{if(I[y+87|0]){break Ma}d=c;if(h){H[h+12>>2]=c;d=h}H[t+16>>2]=f+1;gc(a,1,17400,t+16|0);p=bf(a,e,d,0,0,0,32,C);if(!p){break Ma}d=0;fA(a,e,p+760|0,0);Na:{if(I[l+40|0]&16){break Na}q=(H[A+12>>2]-1|0)==(f|0)?-1:f;if(!(I[i+28|0]&128)){Sa(m,135,v,s);d=gb(m,47,r,0,s,q);break Na}T=jc(i);j=J[T+50>>1];k=nc(a,j);while(1){if((d|0)!=(j|0)){yd(m,i,v,G[H[T+4>>2]+(d<<1)>>1],d+k|0);d=d+1|0;continue}break}Oa:{Pa:{if(!q){d=0;break Pa}d=gb(m,29,r,0,k,j);if((q|0)<0){break Oa}}Ua(m,97,k,j,s);gb(m,138,r,s,k,j);if(!q){break Oa}q=H[m+108>>2];if((q|0)<=0){break Oa}G[(H[m+104>>2]+N(q,20)|0)-18>>1]=16}Sc(a,k,j)}Sa(m,10,u,E);if(d){H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(d,20)|0)+8>>2]=H[m+108>>2]}d=I[p+48|0];j=H[p+840>>2];k=0;Qa:{if(!(I[j+41|0]&2)|(H[j+32>>2]!=(o|0)?f:0)){break Qa}k=H[j+32>>2];if(!(I[i+28|0]&128)){break Qa}k=((I[k+55|0]|I[k+56|0]<<8)&3)!=2?k:0}if(d&1){F[l+48|0]=I[l+48|0]|1}O=d&2?1:O;vd(p);lh(a);o=k}eb(y,c)}f=f+1|0;continue}break}lh(a);H[n+72>>2]=o;if(o){H[n+8>>2]=C}if(h){H[h+12>>2]=0;he(y,h)}d=H[m+108>>2];H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(P,20)|0)+4>>2]=d;Qb(m,H[n+12>>2]);hb(m,E);H[n+68>>2]=H[m+108>>2];if(I[l+44|0]>=2){db(y,e)}r=0;if(O){break qa}fh(n,M);break qa}if(!(f&64)){break ya}}F[n+61|0]=187;break xa}H[n+64>>2]=v;F[n+61|0]=I[u+50144|0];c=Sa(m,I[u+50146|0],v,d);F[n+63|0]=1;H[n+68>>2]=c+1}r=0;break qa}i=h;h=q;q=p;o=e;e=f}if(!(!(w|x)|!(I[j+42|0]&16))){_a(m,136,E)}O=0;C=dA(a,n,u,r,t- -64|0);p=H[t+64>>2];if(!(!p|!o)){O=Tb(y,d+p|0)}M=H[n+(c?40:16)>>2];P=1;k=1;k=q?(I[q+12|0]&40)!=0:k;P=h?(I[h+12|0]&40)!=0:P;Ra:{if(q){r=H[H[q>>2]+16>>2];f=d+C|0;ek(a,r,f,e);cA(m,n,q);Sa:{if(I[q+10|0]&128){break Sa}if(!af(r)){break Sa}Sa(m,50,f,M)}if(p){bA(r,e,d+p|0)}e=d+e|0;f=1;i=0;if(Ke(r)){k=1;break Ra}fh(n,q);p=H[t+64>>2];break Ra}if(i){k=0;Sa(m,75,0,d+C|0);i=1;e=d+1|0;f=1;break Ra}if(!c){f=(d|0)!=0;i=0;e=d;break Ra}i=0;Sa(m,75,0,d+C|0);f=1;e=d+1|0}br(a,C,e-i|0,p);r=J[j+46>>1];Ta:{if(!(!r|(e|0)!=(r|0))){r=0;break Ta}if(c){Sa(m,71,1,c)}r=H[n+52>>2];if(r){gb(m,64,r,M,C,d);eA(a,l,w,M,z,B)}r=0;f=u|((f?4:0)|(k?2:0));T=I[f+50132|0];Ua:{if(!(H[j+40>>2]&1048576)|(f|0)!=6){break Ua}f=_a(m,124,(G[H[A+8>>2]>>1]+9|0)/10|0);if(!(h|q)){r=f;break Ua}q=H[m+108>>2];if((q|0)>0){G[(H[m+104>>2]+N(q,20)|0)-18>>1]=1}H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(f,20)|0)+8>>2]=q+1}gb(m,T,E,M,C,e);if(!c){break Ta}Sa(m,9,0,H[m+108>>2]+2|0);gb(m,I[(u|(e>>>0<2?2:6))+50132|0],E,M,C,e-k|0)}Va:{if(h){e=H[H[h>>2]+16>>2];f=d+C|0;ek(a,e,f,o);cA(m,n,h);Wa:{if(I[h+10|0]&128){break Wa}if(!af(e)){break Wa}Sa(m,50,f,M)}if(O){bA(e,o,O);br(a,f,o,O)}k=d+o|0;if(Ke(e)){P=1;break Va}fh(n,h);p=H[t+64>>2];break Va}if(!s){k=d;break Va}if(!c){Sa(m,75,0,d+C|0);P=0}k=d+1|0}if(p){Wb(y,p)}if(O){Wb(y,O)}e=H[m+108>>2];H[n+68>>2]=e;Xa:{if(!k){break Xa}if(c){Sa(m,17,c,e+3|0)}gb(m,I[(u<<1|P)+50140|0],E,M,C,k);if(!r){break Xa}H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(r,20)|0)+8>>2]=H[m+108>>2]}if(c){Sa(m,16,c,H[m+108>>2]+2|0);gb(m,I[(u<<1|i)+50140|0],E,M,C,i+k|0)}c=H[j+40>>2];if(c&262144){Ua(m,125,E,d,d);c=H[j+40>>2]}Ya:{if(!(!(c&64)|J[l+40>>1]&4128)){c=1;break Ya}c=H[A+12>>2];Za:{if(!(I[c+28|0]&128)){d=H[l>>2];h=H[d+8>>2];F[l+48|0]=I[l+48|0]|1;c=0;Ua(h,141,E,0,v);if(!(J[l+40>>1]&4128)){break Ya}e=H[d+128>>2];if(H[(e?e:d)+88>>2]){break Ya}e=H[d>>2];i=H[A+12>>2];d=G[i+34>>1];d=(d<<2)+4|0;e=nb(e,d&-4,0);if(!e){break Ya}H[e>>2]=G[i+34>>1];c=e+4|0;d=J[A+52>>1];f=(d>>>0<=1?1:d)-1|0;d=0;while(1){if((d|0)!=(f|0)){o=G[H[A+4>>2]+(d<<1)>>1];k=Gc(i,o);if((o|0)<0){d=d+1|0}else{d=d+1|0;H[c+(k<<2)>>2]=d}continue}break}Wd(h,-1,e,-14);break Za}if((v|0)==(E|0)){break Za}d=0;c=jc(c);e=nc(a,J[c+50>>1]);while(1){f=J[c+50>>1];if(f>>>0>d>>>0){Ua(m,94,E,Re(A,G[H[c+4>>2]+(d<<1)>>1]),d+e|0);d=d+1|0;continue}break}gb(m,28,v,Q,e,f)}c=0}_a:{if(H[n>>2]){break _a}d=H[A+36>>2];if(!d){break _a}aA(d,v,L)}d=H[j+40>>2];$a:{if(d&4096){F[n+61|0]=187;break $a}if(u){F[n+61|0]=38;break $a}F[n+61|0]=39}H[n+64>>2]=E;F[n+62|0]=d>>>16&1;if(!(d&15)){F[n+63|0]=1}r=c?0:A}e=r?1:2;while(1){f=H[l+92>>2];d=H[l+104>>2];o=0;while(1){if((f|0)>0){c=J[d+10>>1];ab:{if(c&6){break ab}h=H[n+88>>2];j=H[n+92>>2];if(h&H[d+40>>2]|j&H[d+44>>2]){F[l+48|0]=I[l+48|0]|2;break ab}i=H[d>>2];k=I[D+36|0];if(k&88){p=H[i+4>>2];if(!(p&3)|(p&1?0:k&8)){break ab}if(Je(U,H[i+36>>2])&h|j&Ha){break ab}}bb:{cb:{if((e|0)==1){if(!$z(i,H[n+4>>2],r)){o=2;break ab}c=J[d+10>>1];break cb}if(e>>>0>2){break bb}}if(!(c&4096)){break bb}o=o?o:3;break ab}k=0;db:{if(!(c&512)){break db}c=H[n+44>>2];if(!c){break db}k=_a(m,c&1|16,c>>>1|0)}wc(a,i,Q,16);if(k){H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(k,20)|0)+8>>2]=H[m+108>>2]}G[d+10>>1]=J[d+10>>1]|4}d=d+48|0;f=f-1|0;continue}break}e=o;if((e|0)>0){continue}break}f=H[l+100>>2];d=H[l+104>>2];while(1){if((f|0)>0){eb:{if(I[d+10|0]&6){break eb}c=J[d+12>>1];if(I[D+36|0]&88|(!(c&130)|!(c&2048)|(v|0)!=H[d+20>>2])){break eb}h=H[d>>2];c=er(L,v,H[d+24>>2],z,B,131,0);if(!c|I[c+10|0]&4){break eb}e=H[c>>2];if(!(!(F[c+12|0]&1)|!(I[e+5|0]&16))&H[H[H[e+20>>2]+28>>2]>>2]>1){break eb}i=t- -64|0;Va(i,e,52);H[t+76>>2]=H[h+12>>2];wc(a,i,Q,16);G[c+10>>1]=J[c+10>>1]|4}d=d+48|0;f=f-1|0;continue}break}e=H[n+56>>2];if(e){fb:{h=H[(H[l+4>>2]+(I[n+60|0]<<6)|0)+24>>2];if(!(I[h+28|0]&128)){f=1;q=nc(a,2);c=q+1|0;Sa(m,135,H[n+4>>2],c);break fb}i=jc(h);f=J[i+50>>1];q=nc(a,f+1|0);c=q+1|0;d=0;while(1){if((d|0)==(f|0)){break fb}yd(m,h,v,G[H[i+4>>2]+(d<<1)>>1],c+d|0);d=d+1|0;continue}}d=gb(m,29,H[e>>2],0,c,f);Ua(m,97,c,f,q);gb(m,138,H[e>>2],q,c,f);gb(m,183,H[e+4>>2],0,c,f);c=H[m+108>>2];if((c|0)>0){G[(H[m+104>>2]+N(c,20)|0)-18>>1]=16}H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(d,20)|0)+8>>2]=c;Sc(a,q,f+1|0)}gb:{c=H[n>>2];hb:{ib:{if(c){H[n+28>>2]=H[m+108>>2];Sa(m,71,1,c);d=H[n+56>>2];if(d){break ib}break hb}d=H[n+56>>2];if(!d){break gb}}Sa(m,74,0,H[d+8>>2]);H[d+12>>2]=H[m+108>>2];F[a+26|0]=I[a+26|0]+1}d=H[l+104>>2];f=0;while(1){if(H[l+100>>2]<=(f|0)){break gb}if(!(I[D+36|0]&64|(I[d+10|0]&6|(H[n+88>>2]&H[d+40>>2]|H[n+92>>2]&H[d+44>>2])!=0))){wc(a,H[d>>2],Q,16);G[d+10>>1]=J[d+10>>1]|4}d=d+48|0;f=f+1|0;continue}}z=H[n+88>>2];B=H[n+92>>2]}H[l+28>>2]=H[n+24>>2];W=W-1|0;w=w+1|0;x=w?x:x+1|0;continue}}if(!l){break b}}G[a+156>>1]=H[l+36>>2];_z(K,l)}l=0}Ea=t+160|0;return l}function Ii(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0;g=Ea-496|0;Ea=g;h=H[a>>2];f=wb(a);a:{if(!f){break a}Sa(f,166,1,1);H[a+44>>2]=2;b=Lf(a,b,c,g+492|0);if((b|0)<0){break a}j=H[h+16>>2];if((b|0)==1){if(pz(a)){break a}}x=tc(h,H[g+492>>2]);if(!x){break a}k=j+(b<<4)|0;b:{if(e){H[g+432>>2]=d;i=mb(h,18910,g+432|0);break b}i=tc(h,d)}e=H[c+4>>2]?H[k>>2]:0;c:{if(Yb(a,19,x,i,e)){break c}H[g+476>>2]=0;H[g+472>>2]=i;H[g+468>>2]=x;H[g+464>>2]=0;H[h+456>>2]=0;d:{e:{if(!e){d=0;break e}d=Bg(h,e);j=0;if((d|0)<0){break d}}j=H[(H[h+16>>2]+(d<<4)|0)+4>>2]}d=1;if(j){d=g+464|0;m=H[j+4>>2];H[m+4>>2]=H[j>>2];j=H[h+456>>2];m=H[H[m>>2]+64>>2];o=H[m>>2];if(o){d=Ia[H[o+40>>2]](m,14,d)|0}else{d=12}H[h+456>>2]=j}if((d|0)!=12){if(!d){Ym(f,1);Df(f,0,0,H[g+464>>2],-1);Xm(f,H[g+464>>2]);Ta(H[g+464>>2]);break c}b=H[g+464>>2];if(b){H[g>>2]=b;Wa(a,8863,g);Ta(H[g+464>>2])}H[a+12>>2]=d;H[a+36>>2]=H[a+36>>2]+1;break c}j=bw(x);if(!j){break c}m=I[j+5|0];if(m&1){if(ze(a)){break c}m=I[j+5|0]}if(!(m&2|(i?m&4:0))){jB(f,j)}p=-1;m=0;f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{switch(I[j+4|0]-1|0){case 12:ke(f,b);if(!i){H[a+44>>2]=H[a+44>>2]+2;a=ag(f,9,50352);H[a+124>>2]=-2e3;H[a+24>>2]=b;H[a+4>>2]=b;break c}c=Se(i);kd(a,0,b);a=(c|0)<0?(c|0)==-2147483648?2147483647:0-c|0:c;Ua(f,100,b,3,a);H[H[k+12>>2]+80>>2]=a;aj(H[k+4>>2],a);break c;case 30:a=H[k+4>>2];if(!i){if(a){a=H[H[a+4>>2]+36>>2];b=a>>31}else{a=0;b=0}ud(f,a,b);break c}b=Se(i);H[h+100>>2]=b;if((bh(a,b,0,0)|0)!=7){break c}Ib(h);break c;case 32:a=H[k+4>>2];H:{if(!i){break H}if(!ab(i,2508)){p=2;break H}p=dj(i,0)}I:{if(H[c+4>>2]){break I}c=0;if((p|0)<0){break I}while(1){if(H[h+20>>2]<=(c|0)){break I}Wm(H[(H[h+16>>2]+(c<<4)|0)+4>>2],p);c=c+1|0;continue}}ud(f,Wm(a,p),0);break c;case 26:H[g+456>>2]=0;H[g+460>>2]=0;ld(a,b);d=H[a+44>>2]+1|0;H[a+44>>2]=d;J:{if((I[x|0]&223)==80){Sa(f,178,b,d);break J}a=0;K:{if(!i){break K}if(Wf(i,g+456|0)){break K}c=H[g+456>>2];e=H[g+460>>2];if((e|0)<0){break K}a=!e&c>>>0>=4294967294|e?-2:c}Ua(f,179,b,d,a)}Sa(f,84,d,1);break c;case 25:L:{M:{N:{O:{if(!i){break O}if(ab(i,12950)){if(ab(i,11810)){break O}b=0}else{b=1}if(H[c+4>>2]){break M}c=2;while(1){if(H[h+20>>2]<=(c|0)){break N}Br(H[H[H[(H[h+16>>2]+(c<<4)|0)+4>>2]+4>>2]>>2],b);c=c+1|0;continue}}b=-1;if(H[c+4>>2]){break M}a=I[h+89|0];break L}F[h+89|0]=b}a=Br(H[H[H[k+4>>2]+4>>2]>>2],b)}Xm(f,(a|0)==1?12950:11810);break c;case 22:P:{Q:{if(!i){break Q}e=0;a=bb(i);while(1){if((e|0)==6){break Q}if(yb(i,H[(e<<2)+34320>>2],a)){e=e+1|0;continue}break}if((e|0)!=2){break P}if(I[h+35|0]&16){break Q}e=2;break P}e=-1;if(H[c+4>>2]){break P}H[c+4>>2]=1;b=0}a=H[h+20>>2];while(1){if((a|0)>0){a=a-1|0;if(!H[(H[h+16>>2]+(a<<4)|0)+4>>2]|(H[c+4>>2]?(a|0)!=(b|0):0)){continue}ke(f,a);Ua(f,4,a,1,e);continue}break};Sa(f,84,1,1);break c;case 23:b=H[H[H[k+4>>2]+4>>2]>>2];H[g+456>>2]=-2;H[g+460>>2]=-1;if(!i){break F}Wf(i,g+456|0);c=H[g+460>>2];d=(c|0)<0;a=d?-1:H[g+456>>2];H[b+176>>2]=a;c=d?-1:c;H[b+180>>2]=c;b=H[b+232>>2];if(!b){break f}H[b+16>>2]=a;H[b+20>>2]=c;break f;case 2:c=H[k+4>>2];if(!i){ud(f,eo(c),0);break c}a=0;R:{if(!ab(i,13816)){break R}a=1;if(!ab(i,11650)){break R}a=2;if(!ab(i,11775)){break R}a=Se(i);a=a>>>0<3?a&255:0}F[h+90|0]=a;if(co(c,a)){break c}c=a-1|0;if(c>>>0>1){break c}d=H[f+108>>2];a=ag(f,5,50400);H[a+92>>2]=c;H[a+84>>2]=b;H[a+48>>2]=d+4;H[a+24>>2]=b;H[a+4>>2]=b;ke(f,b);break c;case 18:H[g+456>>2]=0;S:{T:{if(!i){break T}if(!cg(i,g+456|0)){break T}c=H[g+456>>2];if((c|0)>0){break S}}c=2147483647}kd(a,0,b);Sa(f,71,c,1);a=_a(f,62,b);_a(f,84,1);Sa(f,86,1,-1);Sa(f,59,1,a);b=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(a,20)|0)+8>>2]=b;break c;case 5:if(!i){a=H[H[k+12>>2]+80>>2];ud(f,a,a>>31);break c}a=Se(i);H[H[k+12>>2]+80>>2]=a;aj(H[k+4>>2],a);break c;case 6:if(!i){if(I[h+32|0]&32){a=Sk(H[k+4>>2],0);b=a>>31}else{a=0;b=0}ud(f,a,b);break c}H[g+456>>2]=1;b=cg(i,g+456|0);a=H[g+456>>2];if(b){Sk(H[k+4>>2],a)}a=dj(i,(a|0)!=0);c=H[h+36>>2];a=(a|0)!=0;b=a>>>27|0;H[h+32>>2]=H[h+32>>2]&-33|a<<5;H[h+36>>2]=b|c;Ar(h);break c;case 27:ud(f,0,0);break c;case 38:if(!i){ud(f,I[h+86|0],0);break c}c=I[i|0]-48&255;U:{if(c>>>0<=2){break U}if(!ab(i,14098)){c=1;break U}c=!ab(i,1195)<<1}b=H[a>>2];if(I[b+86|0]==(c|0)){break c}if(iB(a)){break c}F[b+86|0]=c;break c;case 39:if(!i){Xm(f,H[18273]);break c}V:{if(!I[i|0]){break V}b=H[h>>2];if(!(Q=Ia[H[b+32>>2]](b,i,1,g+456|0)|0,R=1,S=H[g+456>>2],S?Q:R)){break V}Wa(a,1097,0);break c}if(I[h+86|0]<=1){iB(a)}Ta(H[18273]);if(I[i|0]){H[g+16>>2]=i;Q=73092,R=Ab(8863,g+16|0),H[Q>>2]=R;break c}H[18273]=0;break c;case 35:if(!i){a=I[k+8|0];ud(f,a-1|0,0-!a|0);break c}if(!I[h+85|0]){Wa(a,10663,0);break c}if((b|0)==1){break c}a=Av(i,0,1);F[k+9|0]=1;a=a+1&7;F[k+8|0]=a>>>0<=1?1:a;Ar(h);break c;case 3:if(!i){jB(f,j);ud(f,(H[j+8>>2]&H[h+32>>2]|H[j+12>>2]&H[h+36>>2])!=0,0);break c}a=H[j+8>>2];b=I[h+85|0];a=b?a:a&-16385;c=H[j+12>>2];c=b?c:c;W:{if(dj(i,0)){d=H[h+36>>2];b=H[h+32>>2];if(a&1&(b&268435456)!=0){break W}H[h+32>>2]=a|b;H[h+36>>2]=c|d;break W}b=H[h+36>>2]&(c^-1);H[h+32>>2]=H[h+32>>2]&(a^-1);H[h+36>>2]=b;if(!c&(a|0)==524288){H[h+520>>2]=0;H[h+524>>2]=0;break W}if(!(a&1)){break W}if(ab(i,3298)){break W}yf(h)}Mb(f,166);Ar(h);break c;case 37:break g;case 19:break h;case 20:break i;case 11:break j;case 8:break k;case 16:break l;case 28:break m;case 31:break n;case 15:break o;case 14:break p;case 7:break q;case 21:break r;case 13:break s;case 1:break u;case 9:break v;case 42:break w;case 41:break x;case 33:break y;case 29:break z;case 34:break B;case 17:break C;case 40:break D;case 0:break E;case 36:break G;default:break A}}if(!i){break c}Ji(a,e);l=of(a,2,i,e);if(!l){break c}k=jc(l);H[a+44>>2]=7;cf(a,l);d=H[l+4>>2];b=0;while(1){o=G[l+34>>1];if((o|0)<=(b|0)){break c}c=J[d+10>>1];X:{Y:{if(!(c&98)){s=0;e=0;break Y}if(!(H[j+8>>2]|H[j+12>>2])){m=m+1|0;break X}if(c&32){s=1;e=2;break Y}s=(c&64)>>>6|0;e=s?3:1}a=c&1;Z:{if(!a|!k){break Z}c=1;a=((o|0)>0?o:0)+1|0;while(1){if((a|0)==(c|0)){break Z}if(G[(H[k+4>>2]+(c<<1)|0)-2>>1]==(b|0)){a=c}else{c=c+1|0;continue}break}}c=Mc(l,d);o=H[j+8>>2]|H[j+12>>2]?12135:12104;r=H[d>>2];q=ql(d,30558);p=0;n=(I[d+4|0]&15)!=0;p=!c|s?p:H[c+8>>2];H[g+56>>2]=e;H[g+52>>2]=a;H[g+48>>2]=p;H[g+44>>2]=n;H[g+40>>2]=q;H[g+36>>2]=r;H[g+32>>2]=b-m;se(f,1,o,g+32|0)}d=d+12|0;b=b+1|0;continue}}a=H[b+176>>2];c=H[b+180>>2];break f}_:{if(!i){break _}if(Wf(i,g+456|0)){break _}a=H[g+456>>2];if(H[g+460>>2]<0){break _}H[h+496>>2]=a&2147483647}a=H[h+496>>2];ud(f,a,a>>31);break c}$:{if(!i){break $}if(Wf(i,g+456|0)){break $}a=H[g+456>>2];if(H[g+460>>2]<0){break $}b=H[8183];a=a&2147483647;H[h+164>>2]=(a|0)>(b|0)?b:a|11?a:1}a=H[h+164>>2];ud(f,a,a>>31);break c}aa:{if(!i){break aa}if(Wf(i,g+456|0)){break aa}b=qp(-1,-1);a=H[g+456>>2];d=H[g+460>>2];c=Ha;if(!a&(d|0)<=0|(d|0)<0|!!(c|b)&((c|0)<=(d|0)&a>>>0>=b>>>0|(c|0)<(d|0))){break aa}qp(a,d)}ud(f,qp(-1,-1),Ha);break c}ba:{if(!i){break ba}if(Wf(i,g+456|0)){break ba}ow(H[g+456>>2],H[g+460>>2])}ud(f,ow(-1,-1),Ha);break c}ca:{if(!i){c=H[h+500>>2];break ca}a=Se(i);H[h+456>>2]=0;b=a;a=(a|0)>0;c=a?b:0;H[h+500>>2]=c;H[h+452>>2]=a?h:0;H[h+448>>2]=a?42:0}ud(f,c,c>>31);break c}da:{if(!i){c=65534;break da}c=Se(i);if(!(c&2)){break c}}l=H[a+40>>2];H[a+40>>2]=l+1;j=e?b:H[h+20>>2]-1|0;o=c&1;r=o|2;while(1){if((b|0)<=(j|0)){ea:{if((b|0)==1){break ea}ld(a,b);q=b<<4;d=H[(q+H[h+16>>2]|0)+12>>2]+16|0;while(1){d=H[d>>2];if(!d){break ea}c=H[d+8>>2];if(!(F[c+29|0]&1)){continue}e=c+8|0;k=J[c+38>>1]+46|0;fa:{while(1){m=H[e>>2];if(m){e=m+20|0;if(I[m+55|0]&128){continue}break fa}break}if(!(k&65535)){break fa}Hd(a,l,b,c,112);Ua(f,33,l,r+H[f+108>>2]|0,k<<16>>16)}e=H[q+H[h+16>>2]>>2];H[g+420>>2]=H[c>>2];H[g+416>>2]=e;c=mb(h,29139,g+416|0);if(o){e=zb(a);fb(f,117,0,e,0,c,-6);Sa(f,84,e,1)}else{fb(f,148,0,0,0,c,-6)}continue}}b=b+1|0;continue}break}Mb(f,166);break c}a=0;ye(h);while(1){if(H[h+20>>2]>(a|0)){b=H[(H[h+16>>2]+(a<<4)|0)+4>>2];if(b){Ia[H[16517]](H[H[H[H[b+4>>2]>>2]+228>>2]+52>>2])}a=a+1|0;continue}break}break c}ga:{ha:{ia:{ja:{if(!i){if(H[h+268>>2]==18){break ja}break ha}c=Se(i);a=(c|0)>0;H[h+272>>2]=a?c:0;H[h+268>>2]=a?18:0;if((c|0)<=0){break ha}break ia}c=H[h+272>>2]}a=c>>31;break ga}c=0;a=0}ud(f,c,a);break c}c=H[c>>2]?b:12;b=0;ka:{if(!i){break ka}b=1;if(!ab(i,11650)){break ka}b=2;if(!ab(i,2596)){break ka}b=ab(i,13188)?0:3}H[a+44>>2]=3;Ua(f,3,c,b,1);Sa(f,84,1,3);break c}H[a+44>>2]=1;c=0;while(1){if((c|0)==42){break t}a=H[(c<<2)+56784>>2];if(!a){break t}Nc(f,1,a);Sa(f,84,1,1);c=c+1|0;continue}}c=H[j+8>>2];ke(f,b);if(!(!i|I[j+5|0]&8)){a=ag(f,2,50552);H[a+28>>2]=c;H[a+24>>2]=b;H[a+4>>2]=b;b=Se(i);G[a+22>>1]=1;H[a+32>>2]=b;if(!(I[h+35|0]&16)|(c|0)!=1){break c}F[a+20|0]=187;break c}a=ag(f,3,50560);H[a+32>>2]=c;H[a+24>>2]=b;H[a+4>>2]=b}a=H[f+108>>2];b=(a|0)<=1?1:a;a=1;la:{while(1){if((a|0)==(b|0)){break la}c=N(a,20);a=a+1|0;d=c;c=H[f+104>>2];if(I[d+c|0]!=166){continue}break}F[c+20|0]=187}break c}if(!i){if(ze(a)){break c}Xm(f,H[(I[H[a>>2]+84|0]<<3)+50480>>2]);break c}if(I[h+24|0]&64){break c}c=50480;ma:{while(1){b=H[c>>2];if(!b){break ma}if(ab(i,b)){c=c+8|0;continue}break}a=I[c+4|0];a=a?a:2;F[H[H[h+16>>2]+12>>2]+77|0]=a;dp(h,a);break c}H[g+400>>2]=i;Wa(a,7991,g+400|0);break c}d=I[x|0];K=H[c>>2];H[a+44>>2]=6;A=100;H[g+456>>2]=100;E=K?b:-1;c=d&223;na:{if(!i){break na}if(cg(i,g+456|0)){b=H[g+456>>2];A=(b|0)<=0?100:b;H[g+456>>2]=A;break na}t=of(a,0,i,(E|0)>=0?H[H[h+16>>2]+(E<<4)>>2]:0);A=H[g+456>>2]}B=(c|0)==81;Sa(f,71,A-1|0,1);O=h+388|0;P=(t|0)!=0;while(1){oa:{pa:{qa:{if(H[h+20>>2]<=(y|0)){break qa}if((y|0)!=(E|0)?K:0){break oa}ld(a,y);b=0;F[a+23|0]=0;l=y<<4;j=H[(l+H[h+16>>2]|0)+12>>2]+16|0;c=j;k=0;while(1){c=H[c>>2];if(c){e=H[c+8>>2];if((e|0)!=(t|0)?t:0){continue}d=e+8|0;b=((H[e+28>>2]^-1)>>>7&1)+b|0;e=0;while(1){d=H[d>>2];if(d){e=e+1|0;d=d+20|0;b=b+1|0;continue}break}k=(e|0)>(k|0)?e:k;continue}break}if(!b){break oa}d=Nb(h,(b+P<<2)+4|0,0);if(!d){break qa}if(t){H[d+4>>2]=0;e=1}else{e=0}c=j;ra:while(1){c=H[c>>2];if(c){b=H[c+8>>2];if((b|0)!=(t|0)?t:0){continue}if(!(I[b+28|0]&128)){e=e+1|0;H[d+(e<<2)>>2]=H[b+20>>2]}b=b+8|0;while(1){b=H[b>>2];if(!b){continue ra}e=e+1|0;H[d+(e<<2)>>2]=H[b+44>>2];b=b+20|0;continue}}break}H[d>>2]=e;b=k+8|0;if((b|0)>H[a+44>>2]){H[a+44>>2]=b}H[a+28>>2]=0;F[a+19|0]=0;fb(f,155,2,e,1,d,-14);b=H[f+108>>2];if((b|0)>0){G[(H[f+104>>2]+N(b,20)|0)-18>>1]=y&255}b=_a(f,50,2);H[g+384>>2]=H[l+H[h+16>>2]>>2];fb(f,117,0,3,0,mb(h,30535,g+384|0),-6);Ua(f,111,2,3,3);ih(f);c=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(b,20)|0)+8>>2]=c;k=j;sa:while(1){k=H[k>>2];if(!k){break pa}n=H[k+8>>2];if(((n|0)!=(t|0)?t:0)|I[n+43|0]){continue}c=0;s=0;z=0;if(!(!(I[n+28|0]&128)|B)){s=jc(n);z=nc(a,J[s+50>>1]);Ua(f,75,1,z,(J[s+50>>1]+z|0)-1|0)}sk(a,n,112,0,1,0,g+452|0,g+448|0);Sa(f,71,0,7);m=n+8|0;b=m;while(1){b=H[b>>2];if(b){Sa(f,71,0,c+8|0);c=c+1|0;b=b+20|0;continue}break}o=H[g+452>>2];Sa(f,36,o,0);C=Sa(f,86,7,1);ta:{if(!(I[n+28|0]&128)){c=0;b=G[n+34>>1];d=(b|0)>0?b:0;b=-1;while(1){if((c|0)!=(d|0)){b=!(I[(H[n+4>>2]+N(c,12)|0)+10|0]&32)+b|0;c=c+1|0;continue}break}b=b-(G[n+32>>1]==(b|0))|0;break ta}b=J[jc(n)+52>>1]-1|0}if((b|0)>=0){Ua(f,94,o,b,3);zr(f,3)}ua:{if(!s|B){break ua}c=gb(f,41,o,0,z,J[s+50>>1]);_a(f,50,z);H[g+368>>2]=H[n>>2];fb(f,117,0,3,0,mb(h,6520,g+368|0),-6);ih(f);b=H[f+108>>2];va:{if(I[H[f>>2]+87|0]){H[18336]=b;c=73336;break va}c=H[f+104>>2]+N(c,20)|0;H[c+8>>2]=b;c=c+20|0}H[c+8>>2]=b;c=0;while(1){if(J[s+50>>1]<=c>>>0){break ua}yr(a,s,o,c,c+z|0);c=c+1|0;continue}}L=H[n+28>>2]&65536;c=0;while(1){wa:{xa:{ya:{za:{if(G[n+34>>1]>(c|0)){if(G[n+32>>1]==(c|0)){break wa}D=N(c,12);u=D+H[n+4>>2]|0;Aa:{if(L){d=I[u+4|0];p=d>>>0>31;b=p;break Aa}d=I[u+4|0];p=0;b=F[u+5|0]>65}q=b;if(!(b|d&15)){break wa}if(I[u+10|0]&32){l=3;yd(f,n,o,c,3);r=5;e=-1;break xa}if(!J[u+8>>1]){break za}H[g+444>>2]=0;ij(h,Mc(n,u),I[h+84|0],I[u+5|0],g+444|0);b=H[g+444>>2];if(!b){break za}d=J[b+16>>1];Uc(b);r=I[(d&63)+31056|0];break ya}b=H[n+16>>2];if(!(!b|I[h+33|0]&2)){b=pc(h,b,0);if(!I[h+87|0]){H[a+52>>2]=o+1;c=H[a+56>>2];d=c-2|0;H[a+56>>2]=d;e=b+8|0;l=c-1|0;c=H[b>>2];while(1){if((c|0)>=2){c=c-1|0;wc(a,H[e+(c<<4)>>2],l,0);continue}break}Le(a,H[e>>2],d,16);hb(f,l);H[a+52>>2]=0;H[g+352>>2]=H[n>>2];fb(f,117,0,3,0,mb(h,6688,g+352|0),-6);ih(f);hb(f,d)}pb(h,b)}if(!B){d=-1;l=0;p=H[g+448>>2];c=m;e=0;while(1){b=H[c>>2];if(b){c=H[a+56>>2]-1|0;H[a+56>>2]=c;if((b|0)!=(s|0)){d=Vm(a,b,o,0,0,g+444|0,e,d);Sa(f,86,l+8|0,1);r=l+p|0;c=gb(f,29,r,c,d,J[b+52>>1]);Nc(f,3,29949);Ua(f,111,7,3,3);Nc(f,4,29886);Ua(f,111,4,3,3);q=Nc(f,4,H[b>>2]);Ua(f,111,4,3,3);u=ih(f);H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(c,20)|0)+8>>2]=H[f+108>>2];if(!(I[n+28|0]&128)){Sa(f,142,r,3);c=Ua(f,53,3,0,(J[b+52>>1]+d|0)-1|0);Nc(f,3,29918);Ua(f,111,7,3,3);Nc(f,4,29907);Qb(f,q-1|0);H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(c,20)|0)+8>>2]=H[f+108>>2]}e=0;c=0;while(1){if(J[b+50>>1]>c>>>0){if(H[H[b+32>>2]+(c<<2)>>2]!=33248){if(!e){e=H[a+56>>2]-1|0;H[a+56>>2]=e}Ua(f,94,r,c,3);Ua(f,52,3,e,c+d|0)}c=c+1|0;continue}break}if(e){c=Mb(f,9);hb(f,e);Nc(f,3,29949);Ua(f,111,7,3,3);Nc(f,4,29859);Qb(f,q-1|0);H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(c,20)|0)+8>>2]=H[f+108>>2]}if(I[b+54|0]){e=H[a+56>>2]-1|0;H[a+56>>2]=e;c=0;while(1){if(J[b+50>>1]>c>>>0){v=G[H[b+4>>2]+(c<<1)>>1];Ba:{if((v|0)>=0){if(I[(H[n+4>>2]+N(v,12)|0)+4|0]&15){break Ba}}Sa(f,50,c+d|0,e)}c=c+1|0;continue}break}c=_a(f,39,r);Qb(f,e);v=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(c,20)|0)+8>>2]=v;gb(f,41,r,e,d,J[b+50>>1]);Nc(f,3,29803);Qb(f,q);hb(f,e)}e=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(u,20)|0)+8>>2]=e;xr(a,H[g+444>>2]);e=b}l=l+1|0;c=b+20|0;continue}break}Sa(f,39,o,C);c=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:(H[f+104>>2]+N(C,20)|0)-20|0)+8>>2]=c;Nc(f,2,29830);b=0;while(1){c=H[m>>2];if(c){if((c|0)!=(s|0)){Sa(f,98,b+p|0,3);d=Ua(f,53,b+8|0,0,3);e=H[f+108>>2];if((e|0)>0){G[(H[f+104>>2]+N(e,20)|0)-18>>1]=144}Nc(f,4,H[c>>2]);Ua(f,111,4,2,3);ih(f);e=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(d,20)|0)+8>>2]=e}b=b+1|0;m=c+20|0;continue}break}if(!s){continue sa}Sc(a,z,J[s+50>>1]);continue sa}Sa(f,39,o,C);H[(I[H[f>>2]+87|0]?73336:(H[f+104>>2]+N(C,20)|0)-20|0)+8>>2]=H[f+108>>2];continue sa}r=5}Ca:{if(I[n+28|0]&128){l=Re(jc(n),c<<16>>16);break Ca}l=Gc(n,c<<16>>16)}e=o}b=H[a+56>>2];v=b-2|0;H[a+56>>2]=v;M=b-1|0;Da:{if(!(I[u+4|0]&15)){break Da}d=gb(f,18,e,v,l,r);w=H[f+108>>2];Ea:{if((e|0)<0){b=d;if((w|0)<=0){break Ea}G[(H[f+104>>2]+N(w,20)|0)-18>>1]=15;break Ea}if((w|0)>0){G[(H[f+104>>2]+N(w,20)|0)-18>>1]=13}Ua(f,94,e,l,3);hB(f,n,c,3);b=Sa(f,51,3,v)}w=H[n>>2];H[g+340>>2]=H[u>>2];H[g+336>>2]=w;fb(f,117,0,3,0,mb(h,6315,g+336|0),-6);if(!q){break Da}Qb(f,M);q=H[f+108>>2];Fa:{if(I[H[f>>2]+87|0]){H[18336]=q;b=73336;break Fa}w=N(d,20);d=H[f+104>>2];H[(w+d|0)+8>>2]=q;b=d+N(b,20)|0}H[b+8>>2]=q}Ga:{Ha:{if(p){gb(f,18,e,v,l,r);b=H[f+108>>2];if((b|0)>0){G[(H[f+104>>2]+N(b,20)|0)-18>>1]=I[(I[u+4|0]>>>4|0)+50431|0]}b=H[(I[u+4|0]>>>2&60)+67052>>2];d=H[n>>2];H[g+296>>2]=H[D+H[n+4>>2]>>2];H[g+292>>2]=d;H[g+288>>2]=b;b=mb(h,6273,g+288|0);break Ha}if(L){break Ga}b=F[u+5|0];if((b|0)==66){gb(f,18,e,v,l,r);b=H[f+108>>2];if((b|0)>0){G[(H[f+104>>2]+N(b,20)|0)-18>>1]=28}b=H[n>>2];H[g+308>>2]=H[D+H[n+4>>2]>>2];H[g+304>>2]=b;b=mb(h,6335,g+304|0);break Ha}if((b|0)<67){break Ga}gb(f,18,e,v,l,r);b=H[f+108>>2];if((b|0)>0){G[(H[f+104>>2]+N(b,20)|0)-18>>1]=27}if((e|0)>=0){yd(f,n,o,c,3)}fb(f,96,3,1,0,20810,-1);gb(f,18,-1,v,3,r);b=H[f+108>>2];if((b|0)>0){G[(H[f+104>>2]+N(b,20)|0)-18>>1]=28}b=H[n>>2];H[g+324>>2]=H[D+H[n+4>>2]>>2];H[g+320>>2]=b;b=mb(h,6295,g+320|0)}fb(f,117,0,3,0,b,-6)}hb(f,M);ih(f);hb(f,v)}c=c+1|0;continue}}}a=ag(f,7,50448);if(a){H[a+116>>2]=15928;F[a+101|0]=255;H[a+56>>2]=11860;F[a+41|0]=255;H[a+8>>2]=1-A}b=H[f+108>>2]-2|0;H[(I[H[f>>2]+87|0]?73336:H[f+104>>2])+12>>2]=b;break c}while(1){j=H[j>>2];if(!j){break oa}b=H[j+8>>2];if(((b|0)!=(t|0)?t:0)|I[b+43|0]!=1){continue}if(G[b+34>>1]<=0){if(!Hc(O,H[H[b+48>>2]>>2])){continue}}cf(a,b);c=H[b+52>>2];if(!c){continue}c=H[c+8>>2];if(!c){continue}c=H[c>>2];if(!c|H[c>>2]<4|!H[c+96>>2]){continue}Ua(f,174,y,3,B);H[b+24>>2]=H[b+24>>2]+1;xc(f,b,-16);b=_a(f,50,3);ih(f);H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(b,20)|0)+8>>2]=H[f+108>>2];continue}}y=y+1|0;continue}}if(!i){break c}a=dj(i,0);b=a?12:4;a=a?50656:31148;c=2;while(1){if((c|0)==4){break c}sl(h,14449,c,1,a,43,0,0,0,0,0);d=Te(h,14449,c,1,0);H[d+4>>2]=b|H[d+4>>2]&-2097157;c=c+1|0;continue}}c=H[a+44>>2];o=c+5|0;H[a+44>>2]=o;n=c+3|0;p=c+2|0;r=c+1|0;l=H[H[(H[h+16>>2]+(b<<4)|0)+12>>2]+16>>2];while(1){if(!l){break c}Ia:{if(i){d=of(a,0,i,e);l=0;break Ia}d=H[l+8>>2];l=H[l>>2]}if(!H[d+48>>2]|(I[d+43|0]|!d)){continue}c=H[h+16>>2];b=Fb(h,H[d+60>>2]);e=H[c+(b<<4)>>2];ld(a,b);wd(a,b,H[d+20>>2],0,H[d>>2]);c=o+G[d+34>>1]|0;if((c|0)>H[a+44>>2]){H[a+44>>2]=c}Hd(a,0,b,d,112);Nc(f,r,H[d>>2]);k=1;m=d+48|0;c=m;while(1){j=H[c>>2];if(j){c=yc(h,H[j+8>>2],e);Ja:{if(!c){break Ja}H[g+456>>2]=0;wd(a,b,H[c+20>>2],0,H[c>>2]);if(ri(a,c,j,g+456|0,0)){break c}q=H[g+456>>2];if(!q){Hd(a,k,b,c,112);break Ja}Ua(f,112,k,H[q+44>>2],b);Ed(a,q)}c=j+4|0;k=k+1|0;continue}break}if(H[a+40>>2]<(k|0)){H[a+40>>2]=k}t=1;q=_a(f,36,0);while(1){j=H[m>>2];if(j){m=yc(h,H[j+8>>2],e);H[g+452>>2]=0;H[g+456>>2]=0;if(m){ri(a,m,j,g+456|0,g+452|0)}k=H[a+56>>2]-1|0;H[a+56>>2]=k;b=H[j+20>>2];c=o+b|0;if((c|0)>H[a+44>>2]){H[a+44>>2]=c}s=j+36|0;c=0;while(1){if((b|0)>(c|0)){b=H[g+452>>2];u=H[(b?b+(c<<2)|0:s+(c<<3)|0)>>2];b=c+o|0;yd(f,d,0,u,b);Sa(f,50,b,k);c=c+1|0;b=H[j+20>>2];continue}break}c=H[g+456>>2];Ka:{if(c){fb(f,96,o,b,0,jh(h,c),H[j+20>>2]);gb(f,29,t,k,o,H[j+20>>2]);break Ka}if(!m){break Ka}Ua(f,30,t,H[f+108>>2]+2|0,o);Qb(f,k)}Sa(f,H[d+28>>2]&128?75:135,0,p);b=H[j+8>>2];H[g+276>>2]=t-1;H[g+272>>2]=b;se(f,n,18586,g+272|0);Sa(f,84,r,4);hb(f,k);Za(h,H[g+452>>2]);m=j+4|0;t=t+1|0;continue}break}Sa(f,39,0,q+1|0);c=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(q,20)|0)+8>>2]=c;continue}}if(!i){break c}d=yc(h,i,e);if(!d|I[d+43|0]){break c}b=H[d+48>>2];if(!b){break c}c=Fb(h,H[d+60>>2]);H[a+44>>2]=8;ld(a,c);p=0;while(1){if(!b){break c}a=b+36|0;c=0;while(1){if(H[b+20>>2]>(c|0)){e=a+(c<<3)|0;j=H[H[d+4>>2]+N(H[e>>2],12)>>2];e=H[e+4>>2];l=H[b+8>>2];k=gB(I[b+26|0]);m=I[b+25|0];H[g+268>>2]=20269;Q=g,R=gB(m),H[Q+264>>2]=R;H[g+260>>2]=k;H[g+256>>2]=e;H[g+252>>2]=j;H[g+248>>2]=l;H[g+244>>2]=c;H[g+240>>2]=p;se(f,1,4230,g+240|0);c=c+1|0;continue}break}p=p+1|0;b=H[b+4>>2];continue}}while(1){if((m|0)==66){break c}H[g+224>>2]=H[(m<<4)+35600>>2];se(f,1,8864,g+224|0);m=m+1|0;continue}}H[a+44>>2]=1;c=h+396|0;while(1){c=H[c>>2];if(!c){break c}H[g+208>>2]=H[H[c+8>>2]+4>>2];se(f,1,8864,g+208|0);continue}}b=H[h+24>>2];H[a+44>>2]=6;b=b>>>5&1;a=0;while(1){if((a|0)!=23){c=(a<<2)+73096|0;while(1){c=H[c>>2];if(c){fB(f,c,1,b);c=c+36|0;continue}break}a=a+1|0;continue}break}c=h+424|0;while(1){c=H[c>>2];if(!c){break c}fB(f,H[c+8>>2],0,b);continue}}H[a+44>>2]=2;c=h+440|0;b=0;while(1){c=H[c>>2];if(!c){break c}H[g+196>>2]=H[H[c+8>>2]>>2];H[g+192>>2]=b;se(f,1,5307,g+192|0);b=b+1|0;continue}}H[a+44>>2]=3;c=0;while(1){if(H[h+20>>2]<=(c|0)){break c}a=H[h+16>>2]+(c<<4)|0;b=H[a+4>>2];if(b){a=H[a>>2];Q=g,R=zv(b),H[Q+184>>2]=R;H[g+180>>2]=a;H[g+176>>2]=c;se(f,1,4239,g+176|0)}c=c+1|0;continue}}if(!i){break c}b=yc(h,i,e);if(!b){break c}c=Fb(h,H[b+60>>2]);H[a+44>>2]=5;ld(a,c);c=b+8|0;b=0;while(1){a=H[c>>2];if(!a){break c}c=I[a+55|0]|I[a+56|0]<<8;d=I[a+54|0];e=H[a>>2];H[g+160>>2]=H[a+36>>2]!=0;H[g+148>>2]=e;H[g+152>>2]=(d|0)!=0;H[g+156>>2]=H[((c&3)<<2)+50420>>2];H[g+144>>2]=b;se(f,1,12111,g+144|0);c=a+20|0;b=b+1|0;continue}}if(!i){break c}b=ef(h,i,e);if(!b){b=of(a,2,i,e);if(!b|!(I[b+28|0]&128)){break c}b=jc(b);if(!b){break c}}c=Fb(h,H[b+24>>2]);d=!(H[j+8>>2]|H[j+12>>2]);l=J[(d?50:52)+b>>1];H[a+44>>2]=d?3:6;k=H[b+12>>2];ld(a,c);c=0;while(1){if((c|0)==(l|0)){break c}d=G[H[b+4>>2]+(c<<1)>>1];if((d|0)>=0){e=H[H[k+4>>2]+N(d,12)>>2]}else{e=0}H[g+136>>2]=e;H[g+132>>2]=d;H[g+128>>2]=c;se(f,1,18580,g+128|0);if(H[j+8>>2]|H[j+12>>2]){d=I[H[b+28>>2]+c|0];e=H[H[b+32>>2]+(c<<2)>>2];H[g+120>>2]=J[b+50>>1]>c>>>0;H[g+116>>2]=e;H[g+112>>2]=d;se(f,4,18585,g+112|0)}Sa(f,84,1,H[a+44>>2]);c=c+1|0;continue}}H[a+44>>2]=6;Ji(a,e);while(1){if(H[h+20>>2]<=(l|0)){break c}a=H[h+16>>2];La:{if(e){if(Zb(e,H[a+(l<<4)>>2])){break La}}j=l<<4;k=H[(j+a|0)+12>>2];a=H[k+12>>2];while(1){b=k+16|0;Ma:{Na:while(1){c=b;if(!a){break Ma}while(1){c=H[c>>2];if(!c){a=0;continue Na}d=H[c+8>>2];if(J[d+34>>1]){continue}break}break}H[g+96>>2]=H[d>>2];b=mb(h,29064,g+96|0);if(b){H[g+456>>2]=0;kp(h,b,g+456|0);Wc(H[g+456>>2]);db(h,b)}if(I[h+87|0]){Wa(H[h+264>>2],1150,0);H[H[h+264>>2]+12>>2]=7}a=a-1|0;k=H[(j+H[h+16>>2]|0)+12>>2];continue}break}b=k+16|0;while(1){b=H[b>>2];if(!b){break La}c=H[b+8>>2];if(i){if(Zb(i,H[c>>2])){continue}}a=1851;Oa:{Pa:{switch(I[c+43|0]-1|0){case 0:a=11761;break Oa;case 1:break Oa;default:break Pa}}a=I[c+29|0]&16?1723:14316}k=H[j+H[h+16>>2]>>2];d=H[c>>2];Qa:{if(yb(d,18214,7)){break Qa}m=d+7|0;if(!ab(m,9218)){d=18119;break Qa}if(ab(m,9199)){break Qa}d=18100}m=G[c+34>>1];c=H[c+28>>2];H[g+84>>2]=c>>>16&1;H[g+80>>2]=c>>>7&1;H[g+76>>2]=m;H[g+72>>2]=a;H[g+68>>2]=d;H[g+64>>2]=k;se(f,1,12143,g- -64|0);continue}}l=l+1|0;continue}}ud(f,a,c)}db(h,x);Za(h,i)}Ea=g+496|0}function Pg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,z=0,A=0,B=0,D=0,E=0,G=0,J=0,K=0,L=0,O=0;f=Ea-272|0;Ea=f;w=I[a+21|0]&2;if(w){u=H[c>>2];c=c+4|0}m=c;E=f+152|0;J=f+176|1;while(1){a:{b:{c:{d:{e:{d=I[b|0];f:{if((d|0)==37){n=b;break f}c=b;if(!d){break e}while(1){g:{n=c+1|0;d=I[c+1|0];if((d|0)==37){break g}c=n;if(d){continue}}break}sb(a,b,n-b|0);h=b;if(!I[n|0]){break e}}h:{i:{j:{k:{l:{m:{n:{o:{p:{e=I[n+1|0];if(e){n=n+1|0;i=-1;o=0;p=0;y=0;s=0;G=0;t=0;A=0;q=0;d=m;q:{while(1){c=e<<24>>24;b=1;r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{g=e&255;switch(g-32|0){case 2:case 4:case 5:case 6:case 7:case 8:case 9:case 15:break q;case 13:break r;case 14:break t;case 10:break u;case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:break v;case 12:break y;case 16:break z;case 1:break A;case 3:break B;case 0:case 11:break C;default:break D}}if((g|0)!=108){break q}c=I[n+1|0];if((c|0)==108){break x}o=1;n=n+1|0;break w}t=e;break s}G=1;break s}s=1;break s}y=1;break s}p=44;break s}o=2;c=I[n+2|0];n=n+2|0}c=c<<24>>24;break q}while(1){g=n+1|0;b=c-48|0;c=F[n+1|0];if((c-48&255)>>>0<=9){c=N(b,10)+c|0;n=g;continue}break}q=b&2147483647;m=c&255;if((m|0)==46){break s}b=A;if((m|0)==108){break r}n=g;break q}E:{if(w){c=ul(u);break E}c=H[d>>2];d=d+4|0}b=(c|0)<0;q=b?(c|0)!=-2147483648?0-c|0:0:c;b=b?1:A;c=I[n+1|0];if((c|0)==46|(c|0)==108){break r}c=c<<24>>24;n=n+1|0;A=b;break q}F:{G:{e=I[n+1|0];if((e|0)!=42){b=n+1|0;n=0;while(1){c=e<<24>>24;if((e-48&255)>>>0>9){break G}n=(N(n,10)+c|0)-48|0;e=I[b+1|0];b=b+1|0;continue}}H:{if(w){c=ul(u);break H}c=H[d>>2];d=d+4|0}i=(c|0)<0?(c|0)==-2147483648?-1:0-c|0:c;b=n+2|0;c=F[n+2|0];break F}i=n&2147483647}if((c|0)!=108){n=b;break q}n=b-1|0}b=A}e=I[n+1|0];A=b;n=n+1|0;if(e){continue}break}c=0}e=0;while(1){if((e|0)==23){break e}b=N(e,6);e=e+1|0;B=b+30560|0;if(F[B|0]!=(c|0)){continue}break}I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{S:{T:{v=I[B+3|0];switch(v|0){case 12:break I;case 11:break K;case 9:case 10:case 14:break L;case 5:case 6:break M;case 8:break N;case 7:break O;case 4:break P;case 1:case 2:case 3:break Q;case 16:break R;case 0:case 15:break S;case 13:break T;default:break e}}p=0;o=1;break R}p=0}U:{if(F[B+2|0]&1){V:{if(w){m=d;b=ul(u);c=Ha;break V}if((o|0)==2){c=d+7&-8;m=c+8|0;b=H[c>>2];c=H[c+4>>2];break V}m=d+4|0;b=H[d>>2];c=b>>31}d=c;c=c>>31;b=b^c;l=b-c|0;r=(d|0)<0?45:t;j=(d^c)-((b>>>0<c>>>0)+c|0)|0;break U}if(w){l=ul(u);m=d;r=0;j=Ha;break U}r=0;W:{if((o|0)==2){b=d+7&-8;m=b+8|0;l=H[b>>2];j=H[b+4>>2];break W}m=d+4|0;l=H[d>>2];j=0}}if(y){b=q-((r&255)!=0)|0;i=(b|0)<(i|0)?i:b}X:{if((i|0)<37){c=f+176|0;b=70;o=0;break X}c=0;d=(i>>>0)/3|0;g=d;b=i+10|0;d=d+b|0;c=g>>>0>d>>>0?1:c;g=d;d=p&255;b=d?g:b;c=gp(a,b,d?c:0);if(!c){break e}o=c}y=(b+c|0)-1|0;h=y;if((v|0)==15){e=vJ(l,j,10,0);d=Ha;b=sJ(e,d,10,0);g=l-b|0;c=j-(Ha+(b>>>0>l>>>0)|0)|0;h=h-2|0;b=(K=(wJ(e,d,10,0)|0)!=1|Ha?g:0,L=0,O=!c&g>>>0<=3,O?K:L)<<1;F[h|0]=I[b+14865|0];F[y-1|0]=I[b+14866|0]}D=I[B+4|0]+30704|0;s=I[B+1|0];b=l;g=j;while(1){h=h-1|0;d=b;e=g;t=vJ(b,e,s,0);c=Ha;K=h,L=I[(b-sJ(t,c,s,0)|0)+D|0],F[K|0]=L;b=t;g=c;if(!e&d>>>0>=s>>>0|e){continue}break}c=y-h|0;while(1){if((c|0)<(i|0)){h=h-1|0;F[h|0]=48;c=c+1|0;continue}break}Y:{if(!(p&255)){break Y}b=c-1|0;e=(b|0)/3|0;b=(b-N(e,3)|0)+1|0;h=h-e|0;c=0;while(1){if((e|0)<=0){break Y}d=c+h|0;F[d|0]=I[d+e|0];b=b-1|0;if(!b){c=c+1|0;F[h+c|0]=p;e=e-1|0;b=3}c=c+1|0;continue}}if(r&255){h=h-1|0;F[h|0]=r}Z:{if(!G|!(j|l)){break Z}b=I[B+5|0];if(!b){break Z}c=b+30737|0;while(1){b=I[c|0];if(!b){break Z}h=h-1|0;F[h|0]=b;c=c+1|0;continue}}i=y-h|0;break a}if(w){k=0;b=H[u+4>>2];if((b|0)>=H[u>>2]){break i}H[u+4>>2]=b+1;k=Db(H[H[u+8>>2]+(b<<2)>>2]);break i}b=d+7&-8;m=b+8|0;k=M[b>>3];break h}o=0;if(w){q=0;i=0;m=d;break a}H[H[d>>2]>>2]=H[a+16>>2];break J}F[f+176|0]=37;h=f+176|0;i=1;o=0;m=d;break a}_:{if(w){c=ep(u);if(c){b=I[c|0];F[f+176|0]=b;e=1;if(b>>>0<192){break _}while(1){b=I[c+1|0];if((b&192)!=128){break _}c=c+1|0;F[(f+176|0)+e|0]=b;e=e+1|0;if((e|0)!=4){continue}break}e=4;break _}F[f+176|0]=0;e=1;break _}b=d+4|0;c=H[d>>2];$:{if(c>>>0<=127){F[f+176|0]=c;e=1;break $}if(c>>>0<=2047){F[f+177|0]=c&63|128;F[f+176|0]=c>>>6|192;e=2;break $}if(c>>>0<=65535){F[f+178|0]=c&63|128;F[f+176|0]=c>>>12|224;F[f+177|0]=c>>>6&63|128;e=3;break $}F[f+179|0]=c&63|128;F[f+178|0]=c>>>6&63|128;F[f+177|0]=c>>>12&63|128;F[f+176|0]=c>>>18&7|240;e=4}d=b}h=f+176|0;s=1;o=0;if((i|0)<2){break k}c=i-1|0;q=q-c|0;if(!(A&255|(q|0)<2)){Sh(a,q-1|0,32);q=0}sb(a,f+176|0,e);b=1;g=0;while(1){if((c|0)<2){break k}l=H[a+8>>2];j=b;m=c-1|0;b=b>>>0<m>>>0&(g|0)<=0|(g|0)<0;m=b?j:m;b=b?g:0;i=sJ(m,b,e,0);t=H[a+16>>2];g=i+t|0;p=Ha;j=p;j=g>>>0<t>>>0?j+1|0:j;if((j|0)>0){g=1}else{g=(j|0)>=0&g>>>0>=l>>>0}if(g){pl(a,i,p)}if(I[a+20|0]){break k}sb(a,H[a+4>>2]+(H[a+16>>2]-i|0)|0,i);j=b<<1|m>>>31;b=m<<1;g=j;c=c-m|0;continue}}if(!w){m=d+4|0;o=0;h=H[d>>2];if(!h){h=30558;break m}if((v|0)!=6){break m}if(H[a+16>>2]|(!H[a+12>>2]|q|(i|0)>=0)){break n}if(I[a+20|0]){o=h;break l}H[a+4>>2]=h;K=a,L=mf(H[a>>2],h),H[K+8>>2]=L;K=a,L=tb(h)&2147483647,H[K+16>>2]=L;F[a+21|0]=I[a+21|0]|4;break o}b=ep(u);h=b?b:30558;o=0;m=d;break m}D=(v|0)==14?34:39;aa:{if(w){p=ep(u);break aa}p=H[d>>2];d=d+4|0}m=d;r=(v|0)==10;t=p?p:r?20140:26086;d=i;e=d>>31;b=0;g=0;l=0;j=0;while(1){ba:{if(!(d|e)){break ba}h=I[b+t|0];if(!h){break ba}ca:{if(!(h>>>0>191&s)){c=g;b=b+1|0;g=b?c:c+1|0;break ca}while(1){c=t;b=b+1|0;g=b?g:g+1|0;if((I[b+c|0]&192)==128){continue}break}}c=(h|0)==(D|0);l=c+l|0;j=c>>>0>l>>>0?j+1|0:j;c=d;d=c-1|0;e=e-!c|0;continue}break}h=f+176|0;o=0;j=g+j|0;d=b+l|0;j=d>>>0<l>>>0?j+1|0:j;c=j;d=d+3|0;c=d>>>0<3?c+1|0:c;if((c|0)>=0&d>>>0>=71|(c|0)>0){o=gp(a,d,c);h=o;if(!h){break e}}d=0;e=0;l=0;j=0;r=r&(p|0)!=0;if(r){F[h|0]=39;l=1}c=b;b=!!b&(g|0)>=0|(g|0)>0;c=b?c:0;p=b?g:0;while(1){if((c|0)!=(d|0)|(e|0)!=(p|0)){i=I[d+t|0];F[h+l|0]=i;g=j;b=l+1|0;g=b?g:g+1|0;if((i|0)!=(D|0)){l=b;j=g}else{F[b+h|0]=D;l=l+2|0;j=l>>>0<2?j+1|0:j}b=e;d=d+1|0;e=d?b:b+1|0;continue}break}if(r){F[h+l|0]=39;l=l+1|0}e=l;F[h+e|0]=0;break j}if(!(F[a+21|0]&1)){break e}m=H[d>>2];if(G){if(!m|I[m+5|0]&8){break J}Vd(a,H[m+8>>2]);Mg(H[a>>2],m);break J}if(!m){break J}b=H[m+4>>2];if(!b){break J}sb(a,H[m>>2],b);c=H[a>>2];if(!c|H[c+68>>2]!=-2){break J}b=H[c+264>>2];if(!b){break J}g=H[b+244>>2];if(!g){break J}b=H[m>>2];if(b>>>0<g>>>0){break J}if(b>>>0>=tb(g)+g>>>0){break J}H[c+68>>2]=b-g}m=d+4|0;break o}if(!(F[a+21|0]&1)){break e}m=d+4|0;d=H[d>>2];c=H[d+12>>2];if(s?0:c){break p}b=H[d+8>>2];if(b){c=H[d+4>>2];if(c){Vd(a,c);sb(a,24838,1);b=H[d+8>>2]}Vd(a,b);break o}if(c){break p}b=H[d+20>>2];c=H[b+16>>2];if(I[b+5|0]&8){H[f+128>>2]=c;lb(a,24892,f+128|0);break o}H[f+112>>2]=c;lb(a,24878,f+112|0);break o}sb(a,29060,1);break e}Vd(a,c)}o=0;q=0;i=0;break a}o=h}if((i|0)<0){break l}if(s){c=h;while(1){da:{if((i|0)<=0){break da}b=I[c|0];if(!b){break da}i=i-1|0;c=c+1|0;if(b>>>0<192){continue}while(1){b=c;c=c+1|0;if((I[b|0]&192)==128){continue}break}c=b;continue}break}e=c-h|0;s=1;break j}c=0;while(1){if((c|0)==(i|0)){break a}if(I[c+h|0]){c=c+1|0;continue}else{i=c;break a}}}e=tb(h)&2147483647;break j}m=d}ea:{if(!s){break ea}c=e;if((q|0)<=0){break ea}while(1){if((c|0)<=0){break ea}c=c-1|0;q=((I[h+c|0]&192)==128)+q|0;continue}}i=e;break a}m=d}h=(i|0)<0?6:(i|0)>=1e8?1e8:i;fa:{ga:{switch(v-1|0){case 0:i=0-h|0;break fa;case 2:i=h>>>0<=1?1:h;h=i;break fa;default:break ga}}i=h+1|0}H[f+148>>2]=E;F[f+137|0]=0;ha:{ia:{ja:{if(k<0){F[f+136|0]=45;k=-k;break ja}F[f+136|0]=43;if(k!=0){break ja}H[f+148>>2]=24816;H[f+140>>2]=1;H[f+144>>2]=1;b=1;break ia}C(+k);c=x(1)|0;b=x(0)|0;ka:{if((c&2146435072)==2146435072){H[f+140>>2]=0;H[f+144>>2]=0;c=!b&(c|0)==2146435072?1:2;F[f+137|0]=c;e=E;break ka}la:{if(I[65930]){Kl(f+96|0,k);b=H[f+104>>2];g=H[f+108>>2];c=0;d=H[f+96>>2];e=H[f+100>>2];ma:{if(k>=1e19){while(1){if((Bj(d,e,b,g,-805586501,-1258532657,596116123,1099578686)|0)>=0){ne(f+80|0,d,e,b,g,-61397127,-42290448,-297213870,1051901938);c=c+100|0;b=H[f+88>>2];g=H[f+92>>2];d=H[f+80>>2];e=H[f+84>>2];continue}break}while(1){if((Bj(d,e,b,g,0,399155200,263089522,1079984926)|0)>=0){ne(f- -64|0,d,e,b,g,-2011384559,-1417843994,-40010789,1071495117);c=c+10|0;b=H[f+72>>2];g=H[f+76>>2];d=H[f+64>>2];e=H[f+68>>2];continue}break}while(1){if((Bj(d,e,b,g,0,0,1175000016,1077810574)|0)<0){break ma}ne(f+48|0,d,e,b,g,-1717986918,-1717986919,-1717986919,1073453465);c=c+1|0;b=H[f+56>>2];g=H[f+60>>2];d=H[f+48>>2];e=H[f+52>>2];continue}}while(1){if((Cj(d,e,b,g,1449991308,193581759,1018374929,1052554611)|0)<0){ne(f,d,e,b,g,1280106687,-827280776,-765899721,1095443610);c=c-100|0;b=H[f+8>>2];g=H[f+12>>2];d=H[f>>2];e=H[f+4>>2];continue}break}while(1){if((Cj(d,e,b,g,0,0,0,1075196205)|0)<0){ne(f+16|0,d,e,b,g,0,0,-234881024,1075849733);c=c-10|0;b=H[f+24>>2];g=H[f+28>>2];d=H[f+16>>2];e=H[f+20>>2];continue}break}while(1){if((Cj(d,e,b,g,0,0,2019396096,1077371717)|0)>=0){break ma}ne(f+32|0,d,e,b,g,0,0,0,1073889280);c=c-1|0;b=H[f+40>>2];g=H[f+44>>2];d=H[f+32>>2];e=H[f+36>>2];continue}}l=0;j=0;r=Ea-16|0;Ea=r;na:{if((g|0)<0){break na}o=g>>>16&32767;if(o>>>0<16383){break na}l=-1;j=-1;if(o-16447>>>0<4294967232){break na}$h(r,d,e,b,g&65535|65536,16495-o|0);l=H[r>>2];j=H[r+4>>2]}Ea=r+16|0;b=l;g=j;break la}H[f+264>>2]=0;H[f+268>>2]=0;M[f+256>>3]=k;c=0;oa:{if(k>0x7ffffffffffffc00){while(1){if(k>9223372036854774e103){je(f+256|0,1e-100,-19991899802602883e-133);c=c+100|0;k=M[f+256>>3];continue}break}while(1){if(k>9223372036854774e13){je(f+256|0,1e-10,-3643219731549774e-42);c=c+10|0;k=M[f+256>>3];continue}break}while(1){if(!(k>0x7ffffffffffffc00)){break oa}je(f+256|0,.1,-5551115123125783e-33);c=c+1|0;k=M[f+256>>3];continue}}while(1){if(k<9223372036854775e-98){je(f+256|0,1e100,-15902891109759918e67);c=c-100|0;k=M[f+256>>3];continue}break}while(1){if(k<92233720.36854775){je(f+256|0,1e10,0);c=c-10|0;k=M[f+256>>3];continue}break}while(1){if(!(k<0xccccccccccccc80)){break oa}je(f+256|0,10,0);c=c-1|0;k=M[f+256>>3];continue}}z=M[f+264>>3];g=z<0;pa:{if(k<0x10000000000000000&k>=0){d=~~k>>>0;if(P(k)>=1){b=~~(k>0?R(T(k*2.3283064365386963e-10),4294967295):U((k-+(~~k>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}break pa}d=0;b=0}if(g){g=d;d=b;k=-z;qa:{if(k<0x10000000000000000&k>=0){l=~~k>>>0;if(P(k)>=1){j=~~(k>0?R(T(k*2.3283064365386963e-10),4294967295):U((k-+(~~k>>>0>>>0))*2.3283064365386963e-10))>>>0}else{j=0}break qa}l=0;j=0}b=g-l|0;g=d-((g>>>0<l>>>0)+j|0)|0;break la}ra:{if(z<0x10000000000000000&z>=0){j=~~z>>>0;if(P(z)>=1){g=~~(z>0?R(T(z*2.3283064365386963e-10),4294967295):U((z-+(~~z>>>0>>>0))*2.3283064365386963e-10))>>>0}else{g=0}break ra}j=0;g=0}g=g+b|0;b=d+j|0;g=b>>>0<d>>>0?g+1|0:g}j=s?26:16;e=23;while(1){if(b|g){d=b;b=vJ(b,g,10,0);g=Ha;K=e+E|0,L=d-sJ(b,g,10,0)|48,F[K|0]=L;e=e-1|0;continue}break}b=23-e|0;H[f+140>>2]=b;c=b+c|0;H[f+144>>2]=c;sa:{ta:{if((i|0)>0){break ta}i=c-i|0;if(!i){c=e+E|0;if(F[c+1|0]<53){break sa}F[c|0]=48;i=1;b=H[f+140>>2]+1|0;H[f+140>>2]=b;H[f+144>>2]=H[f+144>>2]+1;e=e-1|0;break ta}if((i|0)<=0){break sa}}if((b|0)<=(j|0)&(b|0)<=(i|0)){break sa}b=(i|0)<(j|0)?i:j;H[f+140>>2]=b;c=(e+E|0)+1|0;if(F[c+b|0]<53){break sa}ua:{while(1){b=b-1|0;g=c+b|0;d=I[g|0]+1|0;F[g|0]=d;if(d<<24>>24<58){break ua}F[g|0]=48;if(b){continue}break}F[H[f+148>>2]+e|0]=49;b=H[f+140>>2]+1|0;H[f+140>>2]=b;H[f+144>>2]=H[f+144>>2]+1;e=e-1|0;break sa}b=H[f+140>>2]}c=e+E|0;e=c+1|0;H[f+148>>2]=e;while(1){if(!(I[b+c|0]!=48|(b|0)<=0)){b=b-1|0;H[f+140>>2]=b;continue}break}c=I[f+137|0]}va:{switch(c&255){default:if(y){F[e|0]=57;H[f+140>>2]=1;H[f+144>>2]=1e3;b=1e3;break ia}F[f+180|0]=I[12647];H[f+176>>2]=I[12643]|I[12644]<<8|(I[12645]<<16|I[12646]<<24);b=f+176|0;if(I[f+136|0]==45){break c}h=J;if(!(t&255)){break b}F[f+176|0]=t;break c;case 2:break ha;case 0:break va}}b=H[f+144>>2]}e=h-((v|0)==3&(h|0)>0)|0;D=I[f+136|0];i=b-1|0;if((v|0)!=3){l=s}else{b=(b|0)<-3|(e|0)<(i|0);v=b?2:1;e=e-(b?0:i)|0;l=!G}d=(v|0)!=2?i:0;c=(d|0)>0?d:0;j=e>>31;g=e+q|0;j=g>>>0<q>>>0?j+1|0:j;b=j;c=c+g|0;j=c>>>0<g>>>0?b+1|0:b;b=c+15|0;j=b>>>0<15?j+1|0:j;g=j;c=(d+2>>>0)/3|0;h=c;c=b+c|0;g=h>>>0>c>>>0?g+1|0:g;h=c;r=p&255;c=!r|(d|0)<=0;b=c?b:h;c=c?j:g;wa:{if(b>>>0<71&(c|0)<=0|(c|0)<0){h=f+176|0;o=0;break wa}o=gp(a,b,c);h=o;if(!h){break e}}p=h;b=(D|0)==45?45:t;j=b&255;if(j){F[h|0]=b;p=h+1|0}g=(e|0)>0|G|s;b=0;if((d|0)<0){F[p|0]=48;c=p+1|0;break d}while(1){c=p;if((d|0)<0){i=-1;break d}else{i=48;if(H[f+140>>2]>(b|0)){i=I[H[f+148>>2]+b|0];b=b+1|0}F[c|0]=i;p=c+1|0;if(!(!r|((d>>>0)%3|d>>>0<2))){F[c+1|0]=44;p=c+2|0}d=d-1|0;continue}}}h=y?11625:19869;break b}Ea=f+272|0;return}d=g&255;if(d){F[c|0]=46;c=c+1|0}while(1){if(!((e|0)<=0|(i|0)>-2)){F[c|0]=48;e=e-1|0;c=c+1|0;i=i+1|0;continue}break}while(1){if((e|0)>0){i=48;if(H[f+140>>2]>(b|0)){i=I[H[f+148>>2]+b|0];b=b+1|0}e=e-1|0;F[c|0]=i;c=c+1|0;continue}break}xa:{if(!(l&255)|!d){break xa}while(1){ya:{za:{b=c-1|0;switch(I[b|0]-46|0){case 0:break ya;case 2:break za;default:break xa}}F[b|0]=0;c=b;continue}break}if(s){F[c|0]=48;c=c+1|0;break xa}F[b|0]=0;c=b}if((v|0)==2){d=H[f+144>>2];b=(d|0)<=0;F[c+1|0]=b?45:43;F[c|0]=I[I[B+4|0]+30704|0];e=b?1-d|0:d-1|0;if(e>>>0<100){b=c+2|0}else{b=(e>>>0)/100|0;F[c+2|0]=b+48;e=e-N(b,100)|0;b=c+3|0}c=((e&255)>>>0)/10|0;F[b|0]=c|48;F[b+1|0]=e-N(c,10)|48;c=b+2|0}F[c|0]=0;i=c-h|0;if(!y|A&255|(q|0)<=(i|0)){break a}c=q-i|0;e=q;while(1){if((c|0)<=(e|0)){F[e+h|0]=I[(e-c|0)+h|0];e=e-1|0;continue}break}e=(j|0)!=0;while(1)if(c){F[e+h|0]=48;e=e+1|0;c=c-1|0;continue}else{i=q;break a}}h=b}o=0;i=bb(h)}Aa:{Ba:{b=q-i|0;if((b|0)>0){if(A&255){break Ba}Sh(a,b,32)}sb(a,h,i);break Aa}sb(a,h,i);Sh(a,b,32)}if(o){db(H[a>>2],o)}b=n+1|0;continue}}function zA(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0;e=Ea-272|0;Ea=e;h=H[a+24>>2];f=H[h>>2];a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{c=I[b|0];switch(c-45|0){case 1:case 2:case 13:case 15:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:break j;case 4:break l;case 3:case 7:case 8:case 9:case 10:case 11:case 12:break m;case 0:break n;case 14:break q;case 5:case 6:break r;case 30:break s;default:break t}}u:{switch(c-138|0){case 1:case 2:break j;case 0:break l;case 3:break p;default:break u}}v:{switch(c-171|0){case 1:break k;case 0:break n;default:break v}}if((c|0)==20){break l}if(!(I[h+24|0]&46)|(c|0)!=156){break j}Im(f,h,4469,b,b);break j}a=H[h+4>>2];F[b|0]=167;H[b+44>>2]=H[a+24>>2];H[b+28>>2]=H[a+48>>2];G[b+32>>1]=J[b+32>>1]-1;F[b+1|0]=68;break j}c=0;d=h;while(1){if(!(!d|c>>>0>7)){H[(e+208|0)+(c<<2)>>2]=H[d+16>>2];c=c+1|0;d=H[d+12>>2];continue}break}Jb(a,H[b+12>>2]);d=1;if(I[f+220|0]>1){break a}a=H[b+12>>2];if(af(a)){break a}c=h;while(1){if(c){if(!(I[c+26|0]&16)){break a}c=H[c+12>>2];continue}break}c=I[b|0];F[b|0]=155;H[b+8>>2]=(c|0)==51;H[b+4>>2]=H[b+4>>2]|2048;c=0;while(1){if(!(!h|c>>>0>7)){H[h+16>>2]=H[(e+208|0)+(c<<2)>>2];c=c+1|0;h=H[h+12>>2];continue}break}eb(H[f>>2],a);H[b+12>>2]=0;break a}a=H[b+8>>2];c=0;break o}g=H[b+12>>2];if(I[h+24|0]&40){Im(f,h,8999,0,b)}c=0;a=H[b+16>>2];w:{if(I[a|0]==59){break w}c=H[g+8>>2];g=H[a+12>>2];a=H[a+16>>2]}i=a;a=H[i+8>>2];m=H[g+8>>2];if(I[f+220|0]<2){break o}dd(f,b,i);dd(f,b+44|0,g)}o=H[f>>2];H[e+208>>2]=0;H[b+28>>2]=-1;if(!c|I[h+24|0]&6){break i}j=H[o+20>>2];g=(j|0)>0?j:0;while(1){x:{y:{if((d|0)==(g|0)){d=g;break y}l=H[o+16>>2];i=d<<4;if(ab(H[l+i>>2],c)){break x}r=H[(i+l|0)+12>>2]}if((d|0)!=(j|0)){l=c;break i}l=c;if(ab(11276,c)){break i}c=H[o+16>>2];l=H[c>>2];r=H[c+12>>2];break i}d=d+1|0;continue}}c=bd(H[b+16>>2]);if(!c){break m}h=I[c|0];if((h|0)!=170&(h|0)!=59){break m}d=2;if((zA(a,c)|0)==2){break a}if(I[c|0]!=170){break m}F[b+2|0]=I[b|0];F[b|0]=175;d=0;break a}if(I[H[f>>2]+87|0]){break j}a=Qc(H[b+12>>2]);z:{A:{if(I[b|0]==48){h=H[b+20>>2];c=Qc(H[h+8>>2]);if((a|0)!=(c|0)){break z}c=h+24|0;break A}c=b+16|0}c=Qc(H[c>>2])}if((a|0)==(c|0)){break j}Wa(f,15609,0);Mg(H[f>>2],b);break j}if(!(I[b+5|0]&16)){break j}c=H[h+16>>2];B:{if(I[h+24|0]&46){Im(f,h,5845,b,b);break B}ec(a,H[b+20>>2])}if((c|0)!=H[h+16>>2]){H[b+4>>2]=H[b+4>>2]|64}H[h+24>>2]=H[h+24>>2]|64;break j}c=0;j=H[b+20>>2];if(j){d=H[j>>2]}g=H[f>>2];l=I[g+84|0];if(F[b+7|0]&1){c=H[b+44>>2];c=I[c+16|0]!=166?c:0}n=H[h+24>>2];C:{D:{E:{F:{G:{H:{I:{J:{K:{L:{i=H[b+8>>2];g=Te(g,i,d,l,0);M:{if(!g){g=Te(H[f>>2],i,-2,l,0);d=(g|0)!=0;m=!g;break M}i=H[g+20>>2];N:{if(!(I[g+5|0]&4)){break N}H[b+4>>2]=H[b+4>>2]|524288;if((d|0)==2){d=H[j+24>>2];H[e+208>>2]=0;H[e+212>>2]=-1074790400;O:{P:{if(I[d|0]==153){d=H[d+8>>2];Md(d,e+208|0,bb(d),1);t=M[e+208>>3];if(!(t>1)){break P}}H[b+28>>2]=-1;break O}t=t*134217728;Q:{if(P(t)<2147483648){d=~~t;break Q}d=-2147483648}H[b+28>>2]=d;if((d|0)>=0){break N}}H[e+96>>2]=b;Wa(f,24732,e+96|0);H[h+20>>2]=H[h+20>>2]+1;break N}H[b+28>>2]=I[H[g+32>>2]]==117?8388608:125829120}R:{switch(Yb(f,31,0,H[g+32>>2],0)|0){case 1:H[e+80>>2]=b;Wa(f,19104,e+80|0);H[h+20>>2]=H[h+20>>2]+1;default:F[b|0]=121;break h;case 0:break R}}d=H[g+4>>2];if(d&10240){H[b+4>>2]=H[b+4>>2]|1048576}l=H[h+24>>2];S:{if(!(d&2048)){if(!(l&42)){break S}Im(f,h,4993,0,b);d=H[g+4>>2];break S}F[b+2|0]=l&46;if(!(l&262144)){break S}H[b+4>>2]=H[b+4>>2]|1073741824}k=(i|0)!=0;if(!(I[f+18|0]|!(d&262144)|I[H[f>>2]+24|0]&32)){break L}T:{if(!(d&2621440)){m=1;break T}m=1;if(I[f+220|0]>1){break T}XA(f,b,g)}d=1}l=f+220|0;if(I[f+220|0]>=2){break E}if(g){break K}g=0;break J}l=f+220|0;g=0;if(I[f+220|0]>=2){break E}m=1;k=0;break I}if(!c){break J}if(!H[g+24>>2]){break G}}U:{if(!k){break U}i=H[h+24>>2];q=H[g+4>>2]&65536;if(!(!c|i&16384?!(i&1)|!(q?c:1):1)){break U}H[e+4>>2]=b;H[e>>2]=c|q?1716:13128;Wa(f,26631,e);H[h+20>>2]=H[h+20>>2]+1;break D}if(d){break H}}if(I[H[f>>2]+177|0]){break H}H[e+48>>2]=b;Wa(f,19082,e+48|0);H[h+20>>2]=H[h+20>>2]+1;if(k){break F}break D}if(!m){H[e+32>>2]=b;Wa(f,26659,e+32|0);H[h+20>>2]=H[h+20>>2]+1;if(!k){break D}break F}if(k){break F}if(F[b+7|0]&1){H[e+16>>2]=b;Wa(f,26773,e+16|0);H[h+20>>2]=H[h+20>>2]+1;break D}m=0;if(!H[b+12>>2]){break C}lB(f,b);H[h+20>>2]=H[h+20>>2]+1;break C}H[e+64>>2]=b;Wa(f,10386,e- -64|0);H[h+20>>2]=H[h+20>>2]+1;if(!k){break D}}H[h+24>>2]=H[h+24>>2]&(!c^-16385);m=1;break C}m=(I[b+7|0]|k)&1;break C}m=0}hc(a,j);d=1;if(!m){break a}j=H[b+12>>2];if(j){hc(a,H[j+20>>2])}V:{W:{X:{Y:{Z:{if(c){j=H[h+32>>2];if(I[l|0]>1){break W}b=j?H[j+72>>2]:0;l=H[c>>2];_:{if(!(I[c+16|0]|!l)){b=$A(f,b,l);l=H[f>>2];if(!b){break X}C=c,D=pc(l,H[b+8>>2],0),H[C+8>>2]=D;C=c,D=pc(H[f>>2],H[b+12>>2],0),H[C+12>>2]=D;C=c,D=jb(H[f>>2],H[b+24>>2],0),H[C+24>>2]=D;C=c,D=jb(H[f>>2],H[b+28>>2],0),H[C+28>>2]=D;F[c+17|0]=I[b+17|0];F[c+18|0]=I[b+18|0];i=I[b+16|0];F[c+16|0]=i;F[c+20|0]=I[b+20|0];break _}Ws(f,c,b);i=I[c+16|0]}$:{if(!(H[c+24>>2]|H[c+28>>2])|(i&255)!=89){break $}b=H[c+12>>2];if(H[b>>2]==1?b:0){break $}Wa(f,10790,0);break Y}if(!(F[g+6|0]&1)){break Y}if(H[c+40>>2]){break Z}b=H[f>>2];k=H[g+32>>2];i=0;while(1){if((i|0)==8){break Y}l=i<<4;i=i+1|0;l=l+49840|0;if((k|0)!=H[l>>2]){continue}break}eb(b,H[c+24>>2]);eb(b,H[c+28>>2]);F[c+20|0]=0;F[c+18|0]=H[l+12>>2];i=I[l+8|0];F[c+17|0]=i;F[c+16|0]=H[l+4>>2];H[c+24>>2]=0;H[c+28>>2]=0;if((i|0)!=86){break Y}C=c,D=oc(b,155,24033),H[C+24>>2]=D;break Y}F[b+2|0]=0;F[b|0]=168;if(F[b+7|0]&1){Jb(a,H[H[b+44>>2]+40>>2])}c=h;while(1){if(!c){break V}a=H[c+4>>2];H[e+216>>2]=0;H[e+220>>2]=0;H[e+224>>2]=0;H[e+228>>2]=0;H[e+208>>2]=0;H[e+212>>2]=0;H[e+264>>2]=0;H[e+268>>2]=0;H[e+256>>2]=0;H[e+260>>2]=0;H[e+216>>2]=81;H[e+220>>2]=82;H[e+212>>2]=83;H[e+232>>2]=e+248;j=H[f>>2];H[e+252>>2]=a;H[e+248>>2]=j;a=e+208|0;hc(a,H[b+20>>2]);j=H[b+12>>2];if(j){hc(a,H[j+20>>2])}if(F[b+7|0]&1){Jb(e+208|0,H[H[b+44>>2]+40>>2])}a=H[e+264>>2];if(a){Wb(H[f>>2],a)}a=J[e+228>>1];if(!(!a|a&1)){F[b+2|0]=(I[c+28|0]+I[b+2|0]|0)+1;c=H[c+12>>2];continue}break}if(!g){break V}F[b+2|0]=I[b+2|0]+I[c+28|0];H[c+24>>2]=H[c+24>>2]|H[g+4>>2]&134221824^134217744;break V}Wa(f,4930,0)}H[c+44>>2]=g;l=H[f>>2]}if(I[l+87|0]){break j}}hc(a,H[c+8>>2]);hc(a,H[c+12>>2]);Jb(a,H[c+40>>2]);DA(j,c);H[h+24>>2]=H[h+24>>2]|32768}H[h+24>>2]=H[h+24>>2]|n&16385;break a}d=(H[f+36>>2]!=0)<<1;break a}B=f+132|0;z=b+44|0;j=0;q=167;n=h;while(1){aa:{u=H[n+4>>2];if(!u){i=0;break aa}g=u+8|0;i=0;v=0;while(1){ba:{ca:{da:{ea:{if(H[u>>2]>(v|0)){k=H[g+16>>2];if(!(I[g+38|0]&32)){break ea}x=H[H[g+20>>2]+28>>2];y=x+8|0;c=0;d=0;while(1){fa:{if(H[x>>2]>(d|0)){H[e+248>>2]=0;p=y+(d<<4)|0;if(!yA(p,a,m,l,e+248|0)){break fa}ga:{if(!H[e+248>>2]){ha:{if((i|0)<=0){break ha}ia:{if(I[g+38|0]&4){if((sg(H[g+44>>2],a)|0)>=0){break ia}}pb(o,H[e+208>>2]);H[e+208>>2]=0;break ha}w=I[g+36|0];if(!(w&16)){break fa}if(!(w&8)){pb(o,H[e+208>>2]);i=0;H[e+208>>2]=0;break ha}nr(f,e+208|0,j,G[b+32>>1])}c=1;i=i+1|0;break ga}if((i|0)>0){break fa}}G[b+32>>1]=d;w=I[p+9|0]|I[p+10|0]<<8;j=w|64;F[p+9|0]=j;F[p+10|0]=j>>>8;s=s+1|0;j=g;if(!(w&128)){break fa}}if(!m){break ba}if(!c){break da}break ba}d=d+1|0;continue}}if(!j){j=0;break aa}H[b+28>>2]=H[j+40>>2];c=H[j+16>>2];H[b+44>>2]=c;if(I[j+36|0]&72){H[b+4>>2]=H[b+4>>2]|2097152}r=H[c+60>>2];break aa}if(!m){break ca}}ja:{if(!l){break ja}if(H[k+60>>2]!=(r|0)){break ba}if(r){break ja}c=I[l|0]-42|0;if(!c){c=I[l+1|0]}if(c){break ba}}c=H[g+12>>2];if(c){if(ab(m,c)){break ba}if(I[f+220|0]<2){break ca}dd(f,0,z);break ca}if(!ab(m,H[k>>2])){break ca}if(H[k+20>>2]!=1){break ba}ka:{la:{if(yb(m,18214,7)){break la}c=m+7|0;ma:{if(!Tc(H[k>>2]+7|0,9199)){if(!ab(c,18107)){break ma}if(!r){break la}if(!ab(c,9218)){break ma}if(!ab(c,18126)){break ma}break la}if(ab(c,18126)){break la}}c=1;break ka}c=0}if(!c){break ba}}p=Cg(a);c=0;d=G[k+34>>1];x=(d|0)>0?d:0;d=H[k+4>>2];na:{while(1){if((c|0)==(x|0)){break na}oa:{pa:{if((p|0)!=I[d+7|0]){break pa}if(ab(H[d>>2],a)){break pa}qa:{if((i|0)<=0){break qa}ra:{if(I[g+38|0]&4){if((sg(H[g+44>>2],a)|0)>=0){break ra}}pb(o,H[e+208>>2]);H[e+208>>2]=0;break qa}y=I[g+36|0];if(!(y&16)){break pa}if(!(y&8)){pb(o,H[e+208>>2]);i=0;H[e+208>>2]=0;break qa}nr(f,e+208|0,j,G[b+32>>1])}G[b+32>>1]=G[k+32>>1]==(c|0)?-1:c;i=i+1|0;if(!(I[g+38|0]&32)){break oa}fk(g,c);break oa}d=d+12|0;c=c+1|0;continue}break}j=g}if(i){break ba}c=H[k+28>>2]&512;j=c?j:g;s=!(c>>>9|0)+s|0;i=0}g=g- -64|0;v=v+1|0;continue}}sa:{if(i|l){break sa}k=0;c=H[f+132>>2];ta:{if(!c){break ta}d=I[f+158|0];ua:{if(I[f+159|0]){if(!(I[n+25|0]&4)){break ta}if(m){if(ab(m,H[c>>2])){break ta}}k=(d|0)!=128;break ua}va:{if(!m|(d|0)==128){break va}if(ab(1750,m)){break va}k=1;break ua}if(!m|(d|0)==127){break ta}if(ab(14939,m)){break ta}}H[b+28>>2]=k;k=c}wa:{if(!m|!(H[n+24>>2]&512)){break wa}c=H[n+8>>2];if(!c){break wa}if(ab(16418,m)){break wa}k=H[H[c+32>>2]+24>>2];H[b+28>>2]=2}xa:{if(!k){break xa}p=Cg(a);c=0;i=G[k+34>>1];g=(i|0)>0?i:0;s=s+1|0;d=H[k+4>>2];r=H[k+60>>2];ya:{za:{while(1){if((c|0)==(g|0)){break za}Aa:{if((p|0)==I[d+7|0]){if(!ab(H[d>>2],a)){break Aa}}d=d+12|0;c=c+1|0;continue}break}g=G[k+32>>1]==(c|0)?-1:c;if((i|0)>(g|0)){break ya}}if(!fj(a)){break ya}g=I[k+29|0]&2?g:-1}if((g|0)>=(i|0)){break xa}Ba:{Ca:{c=H[b+28>>2];if((c|0)==2){if(I[f+220|0]>=2){H[b+44>>2]=k;G[b+32>>1]=g;i=1;q=167;break Ba}C=b,D=H[H[n+8>>2]+36>>2]+Gc(k,g<<16>>16)|0,H[C+28>>2]=D;i=1;break Ca}H[z>>2]=k;if(I[f+159|0]){G[b+32>>1]=g;F[b+2|0]=167;i=1;C=b,D=((H[n+8>>2]+Gc(k,g<<16>>16)|0)+N(c,G[k+34>>1]+1|0)|0)+1|0,H[C+28>>2]=D;break Ca}G[b+32>>1]=g;Da:{if((g|0)<0){F[b+1|0]=68;break Da}d=g>>>0>31?-1:1<<g;if(!c){H[f+148>>2]=d|H[f+148>>2];break Da}H[f+152>>2]=d|H[f+152>>2]}i=1;q=77;break Ba}q=176}j=0;break sa}i=0}g=(j|0)!=0;Ea:{if(!(!j|((s|0)!=1|i))){c=H[n+24>>2];if(c&40){break Ea}if(!fj(a)){break Ea}d=!((I[j+37|0]|I[j+38|0]<<8)&8192);if(d?I[H[j+16>>2]+29|0]&2:0){break Ea}if(d){G[b+32>>1]=65535}F[b+1|0]=68;g=1;d=1;break d}if(i){break g}c=H[n+24>>2]}Fa:{if(!(c&128)|m){break Fa}d=0;i=H[n+8>>2];k=H[i>>2];v=(k|0)>0?k:0;u=i+8|0;while(1){if((d|0)==(v|0)){break Fa}Ga:{k=u+(d<<4)|0;if(I[k+9|0]&3){break Ga}p=H[k+4>>2];if(Zb(p,a)){break Ga}a=H[k>>2];g=H[a+4>>2];if(!(!(g&16)|c&1)){H[e+192>>2]=p;Wa(f,6781,e+192|0);break c}if(!(!(g&32768)|(c&16384?(h|0)==(n|0):0))){H[e+176>>2]=p;Wa(f,6585,e+176|0);break c}if((Qc(a)|0)!=1){Wa(f,15609,0);break c}xA(f,i,d,b,A);if(I[f+220|0]<2){break b}dd(f,0,b);break b}d=d+1|0;continue}}A=A+1|0;n=H[n+12>>2];if(n){continue}break}c=11012;n=0;if(m){break f}Ha:{if(!(I[b+4|0]&128)){break Ha}Ia:{if(I[o+177|0]){break Ia}d=H[o+32>>2];if(F[h+26|0]&1){if((d&1342177281)==1073741825){break Ia}i=29}else{i=30}if(!(d>>>i&1)){break Ha}}H[e+160>>2]=a;Ec(28,29202,e+160|0);h=H[f+8>>2];Ja:{if(!h){break Ja}d=bb(a);c=Nb(o,d+5|0,0);if(!c){break Ja}H[c>>2]=H[h+208>>2];H[h+208>>2]=c;Va(c+4|0,a,d+1|0)}H[b+44>>2]=0;H[b+48>>2]=0;F[b|0]=117;break h}if(!Ek(b)){break f}}d=1;break a}d=1;c=13939;if((i|0)==1){break d}break e}i=0}Ka:{La:{d=H[e+208>>2];if(d){if(H[d>>2]==(i-1|0)){a=H[b+4>>2];if(!(a&8388608)){break La}H[b+4>>2]=a&-8388609;break Ka}$f(o,d)}Ma:{if(l){H[e+156>>2]=a;H[e+152>>2]=m;H[e+148>>2]=l;H[e+144>>2]=c;Wa(f,6192,e+144|0);break Ma}if(m){H[e+136>>2]=a;H[e+132>>2]=m;H[e+128>>2]=c;Wa(f,6405,e+128|0);break Ma}H[e+116>>2]=a;H[e+112>>2]=c;Wa(f,7774,e+112|0)}Mg(H[f>>2],b);F[f+17|0]=1;H[h+20>>2]=H[h+20>>2]+1;d=0;q=121;break d}eb(o,H[b+12>>2]);H[b+12>>2]=0;eb(o,H[b+16>>2]);H[b+16>>2]=0}nr(f,e+208|0,j,G[b+32>>1]);H[b+8>>2]=14697;F[b|0]=172;H[b+20>>2]=H[e+208>>2];break b}if(!(I[b+6|0]&129)){eb(o,H[b+12>>2]);H[b+12>>2]=0;eb(o,H[b+16>>2]);H[b+16>>2]=0;H[b+4>>2]=H[b+4>>2]|8388608}if(G[b+32>>1]>=0&d&g){a=H[j+52>>2];C=j,D=H[j+48>>2]|mr(b),H[C+48>>2]=D;H[j+52>>2]=Ha|a;F[b|0]=q;break b}F[b|0]=q;if(d){break b}}d=2;break a}d=H[f>>2];Na:{if(!H[d+364>>2]){break Na}c=I[b|0];a=(c|0)!=77;if(a&(c|0)!=167){break Na}c=H[n+4>>2];g=Fb(d,r);if((g|0)<0){break Na}if(a){d=0;a=H[c>>2];a=(a|0)>0?a:0;c=c+8|0;while(1){if((a|0)==(d|0)){break Na}j=d<<6;d=d+1|0;j=c+j|0;if(H[b+28>>2]!=H[j+40>>2]){continue}break}a=j+16|0}else{a=B}a=H[a>>2];if(!a){break Na}d=H[a>>2];Oa:{Pa:{c=G[b+32>>1];if((c|0)>=0){break Pa}c=G[a+32>>1];if((c|0)>=0){break Pa}a=20349;break Oa}a=H[H[a+4>>2]+N(c,12)>>2]}if((wA(f,d,a,g)|0)!=2){break Na}F[b|0]=121}while(1){d=1;H[h+16>>2]=H[h+16>>2]+1;if((h|0)==(n|0)){break a}h=H[h+12>>2];continue}}Ea=e+272|0;return d|0}function lo(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;d=Ea-288|0;Ea=d;V=a+72|0;U=a+120|0;m=H[a+116>>2];P=d+88|0;R=d- -64|0;W=d+15|0;while(1){a:{b:{if(H[m+20>>2]>=0){break b}if(!Pf(m)){break b}b=0;break a}c:{d:{if(!I[m+12|0]){b=0;if((N(H[m+20>>2],3)|0)<=H[H[a+20>>2]+40>>2]<<1){break a}L=I[a+68|0];if(!L){break a}break d}L=I[a+68|0];if(L){break d}b=H[a+20>>2]+8|0;e:{while(1){b=H[b>>2];if(!b){break e}if(!(!(I[b|0]|(a|0)==(b|0))&H[b+116>>2]==H[a+116>>2])){b=b+24|0;continue}break}b=Ya(79084);break a}H[d+24>>2]=0;H[d+240>>2]=0;c=H[m+52>>2];f:{b=Vb(H[m+72>>2]);g:{if(b){e=0;break g}X=d,Y=jf(c,d+24|0,d+240|0,H[m+4>>2],0),H[X+48>>2]=Y;e=H[d+24>>2];b=d+48|0;nt(m,e,b);if(I[c+17|0]){Ad(c,H[d+240>>2],5,H[m+4>>2],b)}b=H[d+48>>2];if(!b){break f}}H[a+124>>2]=0;Eb(e);break a}Va(e+28|0,m+28|0,I[m+12|0]<<1);Va(e+36|0,m+36|0,I[m+12|0]<<2);F[e+12|0]=I[m+12|0];Jh(m,I[H[e+56>>2]]&247);b=H[m+56>>2]+I[m+9|0]|0;c=H[d+240>>2];c=c<<24|(c&65280)<<8|(c>>>8&65280|c>>>24);F[b+8|0]=c;F[b+9|0]=c>>>8;F[b+10|0]=c>>>16;F[b+11|0]=c>>>24;H[a+124>>2]=e;H[a+120>>2]=m;b=0;G[a+70>>1]=0;G[a+72>>1]=0;F[a+68|0]=1;break c}if(H[H[m+72>>2]+32>>2]>=2){b=Ya(79144);break a}b=(L<<24>>24)-1|0;x=J[(b<<1)+V>>1];l=H[(b<<2)+U>>2];b=Vb(H[l+72>>2]);h:{if(b){break h}if(H[l+20>>2]<0){b=Pf(l);if(b){break h}}i:{if(!I[m+2|0]|I[m+12|0]!=1){break i}b=J[m+28>>1];if(H[l+4>>2]==1|(b|0)!=J[m+24>>1]|(x|0)!=J[l+24>>1]){break i}if(!b){b=Ya(77996);break h}c=H[m+52>>2];b=jf(c,d+24|0,d+208|0,0,0);if(b){break h}b=H[m+36>>2];H[d+176>>2]=b;X=d,Y=Ia[H[m+76>>2]](m,b)|0,G[X+144>>1]=Y;g=H[d+24>>2];Jh(g,13);H[d+52>>2]=m;H[d+48>>2]=1;H[d+60>>2]=d+144;H[d+56>>2]=d+176;b=H[m+60>>2];H[d+88>>2]=2;H[d+64>>2]=b;b=mt(d+48|0,0,1,g);H[d+240>>2]=b;if(!b){H[g+20>>2]=(H[c+40>>2]-(J[g+18>>1]+J[d+144>>1]|0)|0)-2;j:{if(!I[c+17|0]){break j}b=d+240|0;Ad(c,H[d+208>>2],5,H[l+4>>2],b);if(J[d+144>>1]<=J[g+16>>1]){break j}Yi(g,g,H[d+176>>2],b)}b=H[m+64>>2]+(J[m+24>>1]<<1)|0;h=H[m+56>>2]+(J[m+26>>1]&(I[b-2|0]<<8|I[b-1|0]))|0;b=0;while(1){k:{c=b+1|0;e=c+h|0;H[d+176>>2]=e;f=b+h|0;if(b>>>0>7){break k}b=c;if(F[f|0]<0){continue}}break}c=f+10|0;f=W;while(1){l:{b=e+1|0;H[d+176>>2]=b;e=F[e|0];F[f|0]=e;f=f+1|0;if((e|0)>=0){break l}e=b;if(b>>>0<c>>>0){continue}}break}b=H[d+240>>2];if(!b){b=d+11|0;b=ko(l,J[l+24>>1],b,f-b|0,0,H[m+4>>2])}c=H[l+56>>2]+I[l+9|0]|0;e=H[d+208>>2];e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);F[c+8|0]=e;F[c+9|0]=e>>>8;F[c+10|0]=e>>>16;F[c+11|0]=e>>>24}Eb(g);break h}M=$i(H[H[a+20>>2]+36>>2]);b=I[a+3|0];H[d+284>>2]=0;F[d+136|0]=0;H[d+132>>2]=0;Xa(d+48|0,0,64);if(M){t=b&1;p=0;b=H[l+56>>2];c=J[l+24>>1];e=I[l+12|0];z=c+e|0;if(z>>>0>=2){p=0;m:{if(!x){break m}p=(t+x|0)-2|0;if((x|0)==(z|0)){break m}p=x-1|0}z=2-t|0}h=c;c=(p-e|0)+z|0;n=(b+I[l+9|0]|0)+8|0;n:{if((h|0)==(c|0)){break n}c=H[l+64>>2]+(c<<1)|0;n=b+(J[l+26>>1]&(I[c|0]<<8|I[c+1|0]))|0}u=H[l+52>>2];B=z+1|0;e=0;h=cb(n);b=z;g=0;o:{while(1){p:{if(!e){f=b<<2;c=f+(d+272|0)|0;e=Oi(u,h,c,0);H[d+284>>2]=e;if(!e){break p}}e=0;Xa(d+272|0,0,(b<<2)+4|0);break o}q:{c=H[c>>2];if(H[c+20>>2]>=0){break q}e=Pf(c);H[d+284>>2]=e;if(!e){break q}e=0;Xa(d+272|0,0,f);break o}g=(J[c+24>>1]+g|0)+4|0;if(b){c=I[l+12|0];b=b-1|0;e=p+b|0;if(!(!c|(e|0)!=J[l+28>>1])){e=b<<2;c=H[l+36>>2];H[e+(d+232|0)>>2]=c;h=cb(c);X=e+(d+144|0)|0,Y=Ia[H[l+76>>2]](l,c)|0,H[X>>2]=Y;e=0;F[l+12|0]=0;continue}f=b<<2;o=f+(d+232|0)|0;c=H[l+64>>2]+(e-c<<1)|0;c=H[l+56>>2]+(J[l+26>>1]&(I[c|0]<<8|I[c+1|0]))|0;H[o>>2]=c;h=cb(c);j=f+(d+144|0)|0;f=Ia[H[l+76>>2]](l,c)|0;H[j>>2]=f;r:{if(!(I[u+24|0]&12)){break r}j=c-H[l+56>>2]|0;if(H[u+40>>2]<(j+f|0)){break r}Va(j+M|0,c,f);H[o>>2]=(c-H[l+56>>2]|0)+M}Tk(l,e-I[l+12|0]|0,f,d+284|0);e=H[d+284>>2];continue}break}H[d+140>>2]=h;b=g+3&2147483644;c=H[u+36>>2]+N(b,6)|0;o=bc(c,c>>31);H[d+56>>2]=o;if(!o){H[d+284>>2]=7;e=0;break o}v=H[d+272>>2];H[d+52>>2]=v;i=o+(b<<2)|0;H[d+60>>2]=i;s=i+(b<<1)|0;S=I[v+8|0];C=S<<2;w=I[v+2|0];e=0;c=0;h=0;while(1){s:{if((h|0)!=(B|0)){k=h<<2;g=H[k+(d+272|0)>>2];j=H[g+56>>2];if(I[j|0]!=I[H[v+56>>2]]){X=d,Y=Ya(78417),H[X+284>>2]=Y;e=0;break o}b=j+J[g+18>>1]|0;D=J[g+26>>1];f=J[g+24>>1];Xa(i+(e<<1)|0,0,f+I[g+12|0]<<1);q=I[g+12|0];if(!q){break s}r=J[g+28>>1];if(r>>>0<=f>>>0){f=0;while(1)if((f|0)==(r|0)){r=g+36|0;f=0;while(1){if((f|0)!=(q|0)){H[o+(e<<2)>>2]=H[r+(f<<2)>>2];f=f+1|0;e=e+1|0;continue}break}H[d+48>>2]=e;break s}else{H[o+(e<<2)>>2]=j+(D&(I[b+1|0]|I[b|0]<<8));f=f+1|0;e=e+1|0;b=b+2|0;continue}}X=d,Y=Ya(78441),H[X+284>>2]=Y;e=0;break o}D=(C+H[u+40>>2]|0)-12|0;b=0;k=0;while(1){t:{if((k|0)==(B|0)){h=0;o=H[d+48>>2];c=B;break t}g=b<<2;e=k<<2;c=H[e+(d+272|0)>>2];H[g+R>>2]=H[c+60>>2];h=g+P|0;g=H[e+(d+176|0)>>2];H[h>>2]=g;if(b){h=b-1|0;o=(g|0)==H[(h<<2)+P>>2]?h:b}else{o=0}if(!w){o=o+1|0;b=o<<2;H[b+R>>2]=H[l+60>>2];H[b+P>>2]=g+1}h=e+(d+144|0)|0;f=D-H[c+20>>2]|0;H[h>>2]=f;j=c+36|0;b=0;while(1){if(b>>>0<I[c+12|0]){f=((Ia[H[c+76>>2]](c,H[j+(b<<2)>>2])|0)+f|0)+2|0;H[h>>2]=f;b=b+1|0;continue}break}H[e+(d+208|0)>>2]=g;b=o+1|0;k=k+1|0;continue}break}while(1){u:{if((c|0)>(h|0)){g=h+2|0;s=h<<2;b=d+208|0;j=s+b|0;f=b;e=h+1|0;b=e<<2;r=f+b|0;f=b;b=d+144|0;i=f+b|0;k=b+s|0;b=H[k>>2];while(1){v:{if((b|0)<=(D|0)){H[k>>2]=b;f=H[j>>2];q=(f|0)>(o|0)?f:o;while(1){if((f|0)==(q|0)){break u}r=d+48|0;g=Mf(r,f)+2|0;b=g+b|0;if((D|0)<(b|0)){break v}H[k>>2]=b;f=f+1|0;w:{if(w){break w}g=0;if((f|0)>=(o|0)){break w}g=Mf(r,f)+2|0}H[i>>2]=H[i>>2]-g;continue}}if((c|0)<=(e|0)){if(h>>>0>=4){H[k>>2]=b;X=d,Y=Ya(78542),H[X+284>>2]=Y;e=0;break o}H[i>>2]=0;H[r>>2]=o;c=g}y=d+48|0;q=H[j>>2];E=q-1|0;A=Mf(y,E)+2|0;f=A;x:{if(w){break x}f=0;if((o|0)<=(q|0)){break x}f=Mf(y,q)+2|0}b=b-A|0;H[i>>2]=f+H[i>>2];H[j>>2]=E;continue}break}H[j>>2]=f;b=h?H[(d+s|0)+204>>2]:0;h=e;if((b|0)<(f|0)){continue}X=d,Y=Ya(78575),H[X+284>>2]=Y;e=0;break o}s=H[d+60>>2];r=c-1|0;i=r;while(1){y:{z:{if((i|0)>0){y=i<<2;b=d+144|0;E=y+b|0;h=H[E>>2];e=b;k=i-1|0;b=k<<2;A=e+b|0;g=H[A>>2];O=b+(d+208|0)|0;b=H[O>>2];f=b-w|0;Mf(d+48|0,f);T=(i|0)!=(r|0)?-2:0;while(1){e=b-1|0;q=Mf(d+48|0,e);j=J[(f<<1)+s>>1];A:{if(!h){j=j+2|0;break A}if(t){break z}j=(h+j|0)+2|0;if((j|0)>((g+T|0)-q|0)){break z}}H[O>>2]=e;f=f-1|0;g=(g-q|0)-2|0;q=(b|0)>1;h=j;b=e;if(q){continue}break}break y}b=0;f=(c|0)>0?c:0;j=x-p|0;h=I[H[v+56>>2]];e=0;while(1){B:{if((b|0)==(f|0)){b=0;q=(e|0)>0?e:0;break B}C:{D:{if(b>>>0<=z>>>0){g=b<<2;i=g+(d+272|0)|0;c=H[i>>2];H[g+(d+240|0)>>2]=c;H[i>>2]=0;g=Vb(H[c+72>>2]);H[d+284>>2]=g;e=e+1|0;if(g|H[H[c+72>>2]+32>>2]==(((b|0)==(j|0)?2:1)|0)){break D}X=d,Y=Ya(78652),H[X+284>>2]=Y;break o}c=jf(u,d+24|0,d+140|0,t?1:H[d+140>>2],0);H[d+284>>2]=c;if(c){break o}c=H[d+24>>2];Jh(c,h);g=b<<2;H[g+(d+176|0)>>2]=o;H[g+(d+240|0)>>2]=c;e=e+1|0;if(!I[u+17|0]){break C}Ad(u,H[c+4>>2],5,H[l+4>>2],d+284|0);if(!H[d+284>>2]){break C}break o}if(g){break o}}b=b+1|0;continue}break}while(1){if((b|0)!=(q|0)){c=b<<2;H[c+(d+112|0)>>2]=H[H[c+(d+240|0)>>2]+4>>2];b=b+1|0;continue}break}g=0;j=e-1|0;t=(j|0)>0?j:0;while(1){c=g;if((c|0)!=(t|0)){f=c;g=c+1|0;b=g;while(1){if((b|0)<(e|0)){i=d+240|0;f=K[H[i+(b<<2)>>2]+4>>2]<K[H[i+(f<<2)>>2]+4>>2]?b:f;b=b+1|0;continue}break}if((c|0)==(f|0)){continue}i=d+240|0;b=H[i+(f<<2)>>2];f=H[b+4>>2];c=H[i+(c<<2)>>2];i=H[c+4>>2];k=H[c+72>>2];x=J[k+28>>1];v=H[u+36>>2];r=H[16644];y=J[H[b+72>>2]+28>>1];G[k+28>>1]=y;Hh(k,((r>>>0)/(v>>>0)|0)+1|0);k=H[b+72>>2];G[k+28>>1]=x;Hh(k,i);k=H[c+72>>2];G[k+28>>1]=y;Hh(k,f);H[c+4>>2]=f;H[b+4>>2]=i;continue}break}c=d+240|0;g=H[c+(j<<2)>>2];b=H[g+4>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[n|0]=b;F[n+1|0]=b>>>8;F[n+2|0]=b>>>16;F[n+3|0]=b>>>24;if(!(h&8|(e|0)==(B|0))){b=H[g+56>>2];c=H[H[(z<<2)+((e|0)>(B|0)?c:d+272|0)>>2]+56>>2];c=I[c+8|0]|I[c+9|0]<<8|(I[c+10|0]<<16|I[c+11|0]<<24);F[b+8|0]=c;F[b+9|0]=c>>>8;F[b+10|0]=c>>>16;F[b+11|0]=c>>>24}if(I[u+17|0]){h=H[d+240>>2];f=I[h+12|0]+J[h+24>>1]|0;i=!w;s=0;c=h;b=0;g=0;while(1){if((g|0)<(o|0)){n=g+i|0;j=H[H[d+56>>2]+(g<<2)>>2];while(1){if((f|0)==(g|0)){b=b+1|0;h=H[((e|0)>(b|0)?d+240|0:d+272|0)+(b<<2)>>2];f=(n+J[h+24>>1]|0)+I[h+12|0]|0;continue}break}E:{if(H[(d+208|0)+(s<<2)>>2]==(g|0)){s=s+1|0;c=H[(d+240|0)+(s<<2)>>2];if(!w){break E}}if(!(H[c+4>>2]!=H[(d+112|0)+(b<<2)>>2]|(b|0)>=(e|0)|j>>>0<K[h+56>>2])){if(j>>>0<K[h+60>>2]){break E}}if(!S){Ad(u,cb(j),5,H[c+4>>2],d+284|0)}if(Mf(d+48|0,g)>>>0>J[c+16>>1]){Yi(c,h,j,d+284|0)}if(H[d+284>>2]){break o}o=H[d+48>>2]}g=g+1|0;continue}break}s=H[d+60>>2]}i=0;x=H[d+56>>2];h=0;F:{G:{while(1){H:{if((h|0)!=(t|0)){c=i+M|0;b=h<<2;f=H[b+(d+208|0)>>2];n=J[(f<<1)+s>>1];k=n+C|0;g=H[x+(f<<2)>>2];j=H[b+(d+240|0)>>2];I:{if(!I[j+8|0]){b=H[j+56>>2];n=I[g|0]|I[g+1|0]<<8|(I[g+2|0]<<16|I[g+3|0]<<24);F[b+8|0]=n;F[b+9|0]=n>>>8;F[b+10|0]=n>>>16;F[b+11|0]=n>>>24;break I}if(w){f=f-1|0;Ia[H[j+80>>2]](j,H[x+(f<<2)>>2],d+24|0);k=ff(c+4|0,H[d+24>>2],H[d+28>>2])+4|0;g=c;c=0;break I}g=g-4|0;if((n|0)!=4){break I}k=Ia[H[l+76>>2]](l,g)|0}i=i+k|0;b=0;while(1){if(!((b|0)==6|H[(b<<2)+P>>2]>(f|0))){b=b+1|0;continue}break}b=H[(b<<2)+R>>2];if(b>>>0<=g>>>0|b>>>0>=g+k>>>0){break H}X=d,Y=Ya(78852),H[X+284>>2]=Y;break o}k=1-e|0;E=(e|0)>(k|0)?e:k;C=!w;r=H[d+52>>2];j=H[d+208>>2];J:{while(1){if((k|0)!=(E|0)){b=k>>31;c=(b^k)-b|0;A=c+(d+132|0)|0;K:{if(I[A|0]){break K}L:{M:{if((k|0)<0){f=c-1|0;b=f<<2;if(H[b+(d+176|0)>>2]>=H[b+(d+208|0)>>2]){break M}break K}if(!k){p=0;g=j;b=0;break L}f=c-1|0}b=o;h=f<<2;g=d+208|0;p=C+H[h+g>>2]|0;g=H[g+(c<<2)>>2]-p|0;if(c>>>0<=z>>>0){b=C+H[h+(d+176|0)>>2]|0}}O=c<<2;i=H[O+(d+240|0)>>2];n=H[i+64>>2];t=I[i+9|0];w=H[i+56>>2];v=I[i+12|0];f=J[i+24>>1];h=f;c=b;if((b|0)<(p|0)){b=lt(i,b,p-b|0,d+48|0);if((b|0)>(f|0)){b=77882;break F}h=H[i+64>>2];Ic(h,h+(b<<1)|0,f<<1);h=f-b|0}f=v+(c+f|0)|0;b=g+p|0;if((f|0)>(b|0)){h=h-lt(i,b,f-b|0,d+48|0)|0}f=t+w|0;b=w+(I[f+5|0]<<8|I[f+6|0])|0;H[d+24>>2]=b;N:{O:{t=n+(g<<1)|0;if(t>>>0>b>>>0|b>>>0>K[i+60>>2]){break O}if((c|0)>(p|0)){n=H[i+64>>2];b=c-p|0;b=(b|0)<(g|0)?b:g;Ic(n+(b<<1)|0,n,h<<1);if(_n(i,t,d+24|0,n,p,b,d+48|0)){break O}h=b+h|0}T=i+28|0;b=0;while(1){if(I[i+12|0]>b>>>0){y=c+J[T+(b<<1)>>1]|0;n=y-p|0;if(!((n|0)<0|(g|0)<=(n|0))){v=H[i+64>>2]+(n<<1)|0;if((h|0)>(n|0)){Ic(v+2|0,v,h-n<<1)}n=d+48|0;Mf(n,y);if(_n(i,t,d+24|0,v,y,1,n)){break O}h=h+1|0}b=b+1|0;continue}break}if(_n(i,t,d+24|0,H[i+64>>2]+(h<<1)|0,h+p|0,g-h|0,d+48|0)){break O}F[i+12|0]=0;G[i+24>>1]=g;F[f+3|0]=g>>>8;F[f+4|0]=I[i+24|0];b=H[d+24>>2]-w|0;b=b<<8|(b&65280)>>>8;F[f+5|0]=b;F[f+6|0]=b>>>8;break N}b=p;f=g;if((g|0)<=0){b=77956;break F}while(1){if((f|0)>0){c=(b<<1)+s|0;if(!J[c>>1]){X=c,Y=Ia[H[r+76>>2]](r,H[x+(b<<2)>>2])|0,G[X>>1]=Y}f=f-1|0;b=b+1|0;continue}break}b=mt(d+48|0,p,g,i);if(b){break J}}F[A|0]=1;H[i+20>>2]=D-H[O+(d+144|0)>>2]}k=k+1|0;continue}break}H[d+284>>2]=0;P:{if(J[l+24>>1]|(L|0)!=1){break P}b=H[d+240>>2];if(H[b+20>>2]<I[l+9|0]){break P}X=d,Y=mo(b,-1),H[X+284>>2]=Y;c=d+284|0;nt(b,l,c);Ah(b,c);break G}if(!I[u+17|0]){break G}b=0;if(S){break G}while(1){if((b|0)==(q|0)){break G}c=H[(d+240|0)+(b<<2)>>2];Ad(u,cb(H[c+56>>2]+8|0),5,H[c+4>>2],d+284|0);b=b+1|0;continue}}H[d+284>>2]=b;break o}b=h+p|0;h=h+1|0;b=ko(l,b,g,k,c,H[j+4>>2]);if(!b){continue}break}H[d+284>>2]=b;break o}c=(e|0)>(B|0)?e:B;b=e;while(1){if((b|0)==(c|0)){break o}Ah(H[(d+272|0)+(b<<2)>>2],d+284|0);b=b+1|0;continue}}X=d,Y=Ya(b),H[X+284>>2]=Y;break o}e=b;j=h}H[E>>2]=j;H[A>>2]=g;b=0;b=(i|0)!=1?H[(d+y|0)+200>>2]:b;i=k;if((b|0)<(e|0)){continue}break}X=d,Y=Ya(78619),H[X+284>>2]=Y;e=0;break o}H[j>>2]=q;c=e;h=c;continue}}f=(j+J[g+18>>1]|0)+(J[g+24>>1]<<1)|0;while(1){if(b>>>0<f>>>0){H[o+(e<<2)>>2]=j+(D&(I[b+1|0]|I[b|0]<<8));e=e+1|0;H[d+48>>2]=e;b=b+2|0;continue}break}H[k+(d+176|0)>>2]=e;if(!(w|h>>>0>=z>>>0)){b=i+(e<<1)|0;f=H[k+(d+144|0)>>2];G[b>>1]=f;j=H[k+(d+232|0)>>2];k=f&65535;j=Va(c+s|0,j,k)+C|0;H[o+(e<<2)>>2]=j;f=J[b>>1]-C|0;G[b>>1]=f;c=c+k|0;Q:{if(!I[g+8|0]){b=H[g+56>>2];b=I[b+8|0]|I[b+9|0]<<8|(I[b+10|0]<<16|I[b+11|0]<<24);F[j|0]=b;F[j+1|0]=b>>>8;F[j+2|0]=b>>>16;F[j+3|0]=b>>>24;break Q}while(1){if((f&65535)>>>0>3){break Q}F[c+s|0]=0;f=J[b>>1]+1|0;G[b>>1]=f;c=c+1|0;continue}}e=e+1|0;H[d+48>>2]=e}h=h+1|0;continue}}b=0;Za(0,H[d+56>>2]);while(1){if((b|0)==(B|0)){b=0;c=(e|0)>0?e:0;while(1){if((b|0)!=(c|0)){Eb(H[(d+240|0)+(b<<2)>>2]);b=b+1|0;continue}break}b=H[d+284>>2]}else{Eb(H[(d+272|0)+(b<<2)>>2]);b=b+1|0;continue}break}}else{b=7}if(Q){lf(Q)}Q=M}F[m+12|0]=0;Eb(m);c=I[a+68|0]-1|0;F[a+68|0]=c;e=H[(c<<24>>24<<2)+U>>2]}m=e;H[a+116>>2]=e;if(!b){continue}}break}if(Q){lf(Q)}Ea=d+288|0;return b}function Nx(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,G=0,J=0,K=0,L=0,M=0,O=0,P=0,Q=0;f=Ea-112|0;Ea=f;H[f+16>>2]=0;H[f+8>>2]=0;H[f+12>>2]=0;v=ub(648,0);a:{if(!v){l=7;break a}H[f+24>>2]=0;H[f+12>>2]=0;e=Lb(a,22,f+24|0,0);H[f+96>>2]=e;if(!e){e=1;d=H[f+24>>2];Cb(d,1,1,0);b:{if((vb(d)|0)==100){k=Ue(d,0);h=Nd(d,0);if(!k){break b}Zd(f+8|0,h,f+96|0);g=H[f+96>>2];if(g){e=0;break b}g=H[f+8>>2];if(g){Va(g,k,h)}H[f+12>>2]=h}g=0}e=(O=ob(d),P=g,Q=e,Q?O:P)}D=v+584|0;J=v+568|0;K=(c|0)<=2?2:c;L=v+108|0;E=v+76|0;M=v- -64|0;r=v+40|0;w=v+56|0;c:{while(1){d:{if((b|0)<=0|e){break d}h=H[a+260>>2];H[f+4>>2]=0;Lb(a,28,f+4|0,0);d=H[f+4>>2];Zc(d,1,K);k=-1;if((vb(d)|0)==100){q=Xc(d,0);o=Ha;k=Fd(d,1)}i=h<<10;m=i>>31;e=ob(d);H[f+20>>2]=e;g=0;e:{if(e){break e}n=H[f+12>>2];if(!n){break e}h=0;d=0;H[f+24>>2]=0;H[f+28>>2]=0;l=H[f+8>>2];H[f+96>>2]=0;e=267;j=n-1|0;f:{if(F[l+j|0]<0){break f}p=l-1|0;g=j>>31&j;g:{while(1){if((j|0)>0){if(F[j+p|0]>=0){g=j;break g}else{j=j-1|0;continue}}break}if((n|0)>0){break f}}h=l-2|0;d=((g|0)>0?1:g)-1|0;while(1){h:{if((g|0)<2){e=d;break h}j=g+h|0;e=g-1|0;g=e;if(F[j|0]<0){continue}}break}H[f+12>>2]=e;h=zc(e+l|0,f+24|0)+e|0;d=h+l|0;e=F[d|0];i:{if((e|0)<0){d=qc(d,f+96|0);break i}H[f+96>>2]=e;d=1}e=(n|0)!=(d+h|0)?267:0;h=H[f+24>>2];d=H[f+28>>2]}H[f+20>>2]=e;j:{if((k|0)>=0){j=uJ(q,o,i,m);g=Ha;m=uJ(h,d,i,m)>>>0>j>>>0;j=Ha;if(m&(j|0)>=(g|0)|(g|0)<(j|0)){break j}}o=(c|0)<(k|0)?k:c;g=H[f+96>>2];k=(g|0)>(o|0)?o:g;G=1;g=1;q=h;o=d;break e}H[f+12>>2]=n;g=0}if((k|0)<=0){break d}l=267;d=i;if((q|0)!=0&(d|0)<=(o|0)|(d|0)<(o|0)|(o|0)<0){break c}i=Xa(v,0,648);H[i+580>>2]=1;k:{if(e){break k}H[f+24>>2]=0;l:{m:{n:{if(Lb(a,8,f+24|0,0)){l=0;break n}h=H[f+24>>2];d=o;e=q+1|0;d=e?d:d+1|0;Cb(h,1,e,d);vb(h);l=0;m=Fd(h,0);e=ob(h);H[f+20>>2]=e;if(!m){break n}if(!g){break m}l=1;if((m|0)!=1){break m}}e=Lb(a,15,f+24|0,0);if(e){break l}h=H[f+24>>2];d=h;j=o;e=q+2|0;j=e>>>0<2?j+1|0:j;Cb(d,1,e,j);d=o;e=q+1|0;d=(e?d:d+1|0)&2147483647;e=(e&-1024)+1024|0;d=e>>>0<1024?d+1|0:d;Cb(h,2,e,d);j=0;if((vb(h)|0)==100){j=(hh(h,0)|0)==5}e=ob(h);H[f+20>>2]=e;if(j){H[i+580>>2]=H[i+580>>2]|2}m=l}if(e){break k}H[f+24>>2]=0;y=Xa(D,0,64);d=k<<2;h=ub(d,0);H[y>>2]=h;if(!h){e=7;break l}Xa(h,0,d);e=Lb(a,12,f+24|0,0);if(e){break l}d=H[f+24>>2];Cb(d,1,q,o);l=0;j=0;while(1){o:{if(j){break o}if((vb(d)|0)!=100|(k|0)<=(l|0)){break o}j=qy(l,0,Xc(d,1),Ha,Xc(d,2),Ha,Xc(d,3),Ha,Ue(d,4),Nd(d,4),H[i+584>>2]+(l<<2)|0);H[i+588>>2]=H[i+588>>2]+1;l=l+1|0;continue}break}e=(O=j,P=ob(d),Q=j,Q?O:P);H[f+20>>2]=e;if(e){break k}e=0;if(H[i+588>>2]!=(k|0)){break k}e=Qj(a,y,J);H[f+20>>2]=e;if(e){break k}l=gi(a,y);H[f+20>>2]=l;p:{q:{r:{if(!(l?(l|0)!=100:0)){if(!(!g|(m|0)<=0)){x=H[i+636>>2];A=H[i+632>>2];H[f+84>>2]=0;e=Lb(a,32,f+84|0,0);if(e){break p}H[f+96>>2]=0;H[f+100>>2]=0;p=H[f+84>>2];d=p;g=o;h=q+1|0;g=h?g:g+1|0;Cb(d,1,h,g);B=m-1|0;Zc(d,2,B);if((vb(d)|0)==100){m=Xc(d,1);s=Ha;k=Xc(d,2);j=Ha;mx(d,3,f+96|0,r);d=H[r>>2];h=H[r+4>>2];if((h|0)<0){H[r>>2]=0-d;H[r+4>>2]=0-(((d|0)!=0)+h|0);d=1;h=0}F[i+48|0]=!(d|h);t=Nd(p,4);u=Ue(p,4);if(!u){ob(p);e=t?7:267;break p}n=H[f+96>>2];h=H[f+100>>2];z=h;e=0;H[f+24>>2]=0;g=Lb(a,34,f+24|0,0);if(!g){d=H[f+24>>2];Cb(d,1,n,h);e=(vb(d)|0)==100;g=ob(d)}H[f+88>>2]=g;if(!e|g){break r}H[f+80>>2]=0;H[f+76>>2]=0;g=_g(a,k,j,f+80|0,f+76|0);H[f+88>>2]=g;j=1;if(!g){g=Pp(f+24|0,H[f+80>>2],H[f+76>>2]);while(1){if(!(!H[f+24>>2]|g)){g=Sl(f+24|0);continue}break}H[f+88>>2]=g;d=H[f+48>>2];h=kx(A,x,d,H[f+52>>2]);Ta(d);j=(h|0)>0?e:0}Ta(H[f+80>>2]);break q}e=ob(p);break p}H[f+24>>2]=0;H[f+96>>2]=0;e=Lb(a,29,f+24|0,0);if(e){break p}d=H[f+24>>2];Cb(d,1,q,o);h=H[i+588>>2];Cb(d,2,h,h>>31);k=0;if((vb(d)|0)==100){k=Fd(d,0)}e=ob(d);if(e){break p}e=Lb(a,10,f+96|0,0);if(e){break p}e=H[f+96>>2];if((vb(e)|0)==100){d=Xc(e,0);H[i+24>>2]=d;g=Ha;H[i+28>>2]=g;h=d;d=k<<4;j=d;h=h+d|0;d=(d>>31)+g|0;H[i+32>>2]=h-1;H[i+36>>2]=(h>>>0<j>>>0?d+1|0:d)-!h}e=ob(e);if(e){break p}e=ig(a,H[i+32>>2],H[i+36>>2],0,0);if(e){break p}H[i+16>>2]=m;H[i>>2]=k;H[i+8>>2]=q;H[i+12>>2]=o;m=k>>31;e=H[i+24>>2];n=H[i+28>>2];h=0;d=0;while(1)if(!d&(h|0)==16){e=0;break p}else{g=(h<<5)+w|0;p=sJ(h,d,k,m);j=n+Ha|0;p=e+p|0;j=p>>>0<e>>>0?j+1|0:j;H[g>>2]=p;H[g+4>>2]=j;h=h+1|0;d=h?d:d+1|0;continue}}$g(y);break c}j=e}s:{if(g){k=g;break s}k=g;if(!j){break s}e=F[u|0];if((e-1&255)>>>0>=15){ob(p);e=267;break p}h=e&255;d=0;H[i+32>>2]=n;H[i+36>>2]=z;H[i+24>>2]=m;H[i+28>>2]=s;H[i+16>>2]=B;H[i+8>>2]=q;H[i+12>>2]=o;k=((n-m|0)+1|0)/16|0;H[i>>2]=k;x=k>>31;while(1){if(!(!d&(h|0)==15)){h=h+1|0;g=h?d:d+1|0;n=(h<<5)+w|0;d=g;g=sJ(h,d,k,x);j=s+Ha|0;g=g+m|0;j=g>>>0<m>>>0?j+1|0:j;H[n>>2]=g;H[n+4>>2]=j;continue}break}d=N(e,k);k=d;g=d+m|0;d=(d>>31)+s|0;h=(e<<5)+w|0;H[h>>2]=g;H[h+4>>2]=g>>>0<k>>>0?d+1|0:d;d=H[a+232>>2];Zd(h+20|0,((d|0)<(t|0)?t:d)+20|0,f+88|0);g=H[f+88>>2];if(!g){Va(H[h+20>>2],u,t);H[h+24>>2]=t;d=t+H[h+20>>2]|0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;F[d+16|0]=0;F[d+17|0]=0;F[d+18|0]=0;F[d+19|0]=0;F[d+8|0]=0;F[d+9|0]=0;F[d+10|0]=0;F[d+11|0]=0;F[d+12|0]=0;F[d+13|0]=0;F[d+14|0]=0;F[d+15|0]=0}k=g;while(1){if((e|0)<0|k){break s}k=0;h=f+24|0;Xa(h,0,48);d=(e<<5)+w|0;j=H[d+20>>2];t:{if(!j){break t}g=Pp(h,j,H[d+24>>2]);while(1){if(!(!H[f+24>>2]|g)){g=Sl(f+24|0);continue}break}H[f+88>>2]=g;h=H[f+52>>2];Zd(d+8|0,h,f+88|0);g=H[f+88>>2];k=g;if(g){break t}if((h|0)>0){Va(H[d+8>>2],H[f+48>>2],h)}H[d+12>>2]=h;if((e|0)<=0){g=0;k=0;break t}H[f+80>>2]=0;H[f+76>>2]=0;k=H[f+44>>2];h=d-32|0;g=H[f+40>>2];H[h>>2]=g;H[h+4>>2]=k;O=f,P=_g(a,g,k,f+80|0,f+76|0),H[O+88>>2]=P;j=d-12|0;d=H[f+76>>2];g=H[a+232>>2];Zd(j,((d|0)>(g|0)?d:g)+20|0,f+88|0);g=H[f+88>>2];if(!g){Va(H[h+20>>2],H[f+80>>2],d);H[h+24>>2]=d;d=d+H[h+20>>2]|0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;F[d+16|0]=0;F[d+17|0]=0;F[d+18|0]=0;F[d+19|0]=0;F[d+8|0]=0;F[d+9|0]=0;F[d+10|0]=0;F[d+11|0]=0;F[d+12|0]=0;F[d+13|0]=0;F[d+14|0]=0;F[d+15|0]=0}Ta(H[f+80>>2]);k=g}Ta(H[f+48>>2]);e=e-1|0;continue}}e=(O=g,P=ob(p),Q=k,Q?O:P)}H[f+20>>2]=e;u:{v:{if(e){break v}if(H[i>>2]){w:{if(l){while(1){n=H[i+644>>2];B=H[i+640>>2];s=H[i+636>>2];u=H[i+632>>2];H[f+96>>2]=0;j=Lj(H[i+64>>2],H[i+68>>2],u,s);d=s-j|0;x:{if((d|0)<=0){e=267;break x}h=(Rd(j,j>>31)+d|0)+Rd(d,0)|0;d=n;z=Rd(d,d>>31)+d|0;g=h+z|0;e=H[i+80>>2];y:{if((e|0)<=0|H[a+232>>2]>=(g+e|0)){break y}k=H[i+56>>2];d=H[i>>2];m=d;l=d+H[i+24>>2]|0;d=H[i+28>>2]+(d>>31)|0;h=H[i+60>>2];d=l>>>0<m>>>0?d+1|0:d;if((h|0)>=(d|0)&k>>>0>=l>>>0|(d|0)<(h|0)){break y}e=ig(a,k,h,H[i+76>>2],e);H[f+96>>2]=e;H[i+4>>2]=H[i+4>>2]+1;h=H[i+56>>2];d=H[i+60>>2];if(!e){e=1;j=j+1|0;while(1){z:{if((e|0)==16){m=0;break z}H[f+24>>2]=0;g=(e<<5)+w|0;x=H[g+12>>2];k=Lj(H[g+8>>2],x,u,j);l=j-k|0;if((l|0)<=0){m=267;break z}m=k>>31;p=m;A=(Rd(k,m)+l|0)+Rd(l,0)|0;C=g;m=H[g+24>>2];A:{B:{if(!(H[a+232>>2]<(A+m|0)?x:0)){t=g+8|0;x=g+20|0;C:{if(m){break C}Zd(x,H[a+232>>2],f+24|0);if(H[f+24>>2]){m=H[g+24>>2];break C}F[H[g+20>>2]]=e;m=mc(H[g+20>>2]+1|0,h,d)+1|0;H[g+24>>2]=m}d=f+24|0;Zd(x,m+A|0,d);Zd(t,j,d);h=0;d=0;m=H[f+24>>2];if(m){break A}m=H[g+24>>2];if(H[g+12>>2]){m=mc(H[g+20>>2]+m|0,k,p)+H[g+24>>2]|0;H[g+24>>2]=m}m=mc(H[g+20>>2]+m|0,l,0)+H[g+24>>2]|0;H[g+24>>2]=m;Va(m+H[g+20>>2]|0,k+u|0,l);H[g+24>>2]=l+H[g+24>>2];Va(H[g+8>>2],u,j);m=0;g=j;break B}m=ig(a,H[g>>2],H[g+4>>2],H[g+20>>2],m);F[H[g+20>>2]]=e;k=H[g+20>>2]+1|0;h=h+1|0;d=h?d:d+1|0;O=g,P=mc(k,h,d)+1|0,H[O+24>>2]=P;k=g;h=H[g>>2];g=H[g+4>>2];d=g;l=h+1|0;g=l?d:d+1|0;H[k>>2]=l;H[k+4>>2]=g;g=0}H[C+12>>2]=g}if(m){break z}e=e+1|0;if(d|h){continue}}break}H[f+96>>2]=m;h=H[w>>2];d=H[w+4>>2]}e=0;H[i+80>>2]=0;H[i+68>>2]=0;h=h+1|0;d=h?d:d+1|0;H[i+56>>2]=h;H[i+60>>2]=d;g=(Rd(s,s>>31)+(s+z|0)|0)+1|0}d=H[r+4>>2]+(g>>31)|0;h=g+H[r>>2]|0;d=h>>>0<g>>>0?d+1|0:d;H[r>>2]=h;H[r+4>>2]=d;Zd(E,g+e|0,f+96|0);e=H[f+96>>2];if(e){break x}if(!H[i+80>>2]){H[i+80>>2]=1;F[H[i+76>>2]]=0}e=jx(E,M,u,s,B,n);if(e){break x}e=gi(a,y)}g=H[i+4>>2];if(!((e|0)!=100|(g|0)<(b|0))){H[f+20>>2]=0;break w}if((e|0)==100){continue}break}H[f+20>>2]=e;if(e){break v}}g=H[i+4>>2]}u=g^-1;k=H[i+588>>2];e=0;n=0;while(1){if(!((k|0)<=0|e)){k=k-1|0;l=0;d=H[i+588>>2];d=(d|0)>0?d:0;g=0;while(1){if((d|0)!=(g|0)){h=g<<2;g=g+1|0;l=H[H[y>>2]+h>>2];if(H[l>>2]!=(k|0)){continue}}break}if(H[l+40>>2]){m=H[l>>2];p=H[l+60>>2];t=H[l+64>>2];H[f+32>>2]=0;h=0;d=0;H[f+24>>2]=0;H[f+28>>2]=0;H[f+104>>2]=0;H[f+96>>2]=0;H[f+100>>2]=0;H[f+88>>2]=0;H[f+92>>2]=0;H[f+84>>2]=0;l=0;s=0;e=Lb(a,32,f+84|0,0);if(!e){e=H[f+84>>2];Cb(e,1,q,o);Zc(e,2,m);if((vb(e)|0)!=100){g=0}else{g=Ue(e,4);j=Nd(e,4);l=Xc(e,1);s=Ha;g=ix(g,j,f+24|0,t,p,f+88|0)}e=(O=g,P=ob(e),Q=g,Q?O:P)}while(1){D:{if(e){break D}g=H[f+88>>2];j=H[f+92>>2];if(!(g|j)){break D}H[f+80>>2]=0;H[f+76>>2]=0;e=_g(a,g,j,f+80|0,f+76|0);E:{if(e){break E}e=ix(H[f+80>>2],H[f+76>>2],f+96|0,t,p,f+88|0);if(e){break E}e=ig(a,g,j,H[f+96>>2],H[f+100>>2])}Ta(H[f+80>>2]);h=g;d=j;continue}break}F:{if(!(d|h)|e){break F}H[f+80>>2]=0;e=Lb(a,17,f+80|0,0);if(e){break F}e=H[f+80>>2];Cb(e,1,l,s);Cb(e,2,h-1|0,d-!h|0);vb(e);e=ob(e)}G:{if(e){break G}H[f+80>>2]=0;e=Lb(a,33,f+80|0,0);if(e){break G}g=H[f+80>>2];Cb(g,1,h,d);dg(g,2,H[f+24>>2],H[f+28>>2],0);Cb(g,3,q,o);Zc(g,4,m);vb(g);e=ob(g);Ae(g,1)}Ta(H[f+24>>2]);Ta(H[f+96>>2]);n=n+1|0}else{e=rx(a,l);if(e){continue}h=H[l>>2];H[f+24>>2]=0;e=Lb(a,30,f+24|0,0);if(e){continue}d=H[f+24>>2];Cb(d,1,q,o);Zc(d,2,h);vb(d);e=ob(d)}continue}break}H:{if(e){break H}e=0;if(H[i+588>>2]==(n|0)){break H}g=0;H[f+24>>2]=0;H[f+96>>2]=0;k=0;l=0;j=0;I:{e=Lb(a,35,f+24|0,0);if(e){break I}d=H[f+24>>2];Cb(d,1,q,o);m=0;while(1){J:{h=vb(d);if((h|0)==100){if((l|0)<(m|0)){e=j;break J}m=m+16|0;e=Fc(j,m<<2,0);if(e){break J}d=7}else{d=0}e=(O=d,P=ob(H[f+24>>2]),Q=(h|0)==100,Q?O:P);if(e){k=H[f+96>>2];break I}e=Lb(a,31,f+96|0,0);k=H[f+96>>2];if(e){break I}Cb(k,2,q,o);e=0;break I}O=(l<<2)+e|0,P=Fd(d,0),H[O>>2]=P;l=l+1|0;j=e;continue}}F[a+240|0]=1;while(1){if(!(g>>>0>=l>>>0|e)){e=0;d=H[(g<<2)+j>>2];if((d|0)!=(g|0)){Zc(k,3,d);Zc(k,1,g);vb(k);e=ob(k)}g=g+1|0;continue}break}F[a+240|0]=0;Ta(j)}b=b+u|0;H[f+20>>2]=e;h=1;if(!n){break u}Zd(f+8|0,H[f+12>>2]+20|0,f+20|0);G=1;e=H[f+20>>2];if(e){break v}h=H[f+8>>2];d=H[f+12>>2];d=mc(h+d|0,q,o)+d|0;O=f,P=mc(d+h|0,n,0)+d|0,H[O+12>>2]=P}e=0}d=H[r>>2];h=0-d|0;d=0-(H[r+4>>2]+((d|0)!=0)|0)|0;H[r>>2]=h;H[r+4>>2]=d;h=0}H[f+24>>2]=e;g=15;K:{while(1){if((g|0)<0){break K}d=(g<<5)+w|0;if(H[d+24>>2]<=0){Ta(H[d+20>>2]);Ta(H[d+8>>2]);g=g-1|0;continue}break}L:{if(g){break L}Zd(L,11,f+24|0);g=1;e=H[f+24>>2];if(e){break L}F[H[i+108>>2]]=1;O=i,P=mc(H[i+108>>2]+1|0,H[i+56>>2],H[i+60>>2])+1|0,H[O+112>>2]=P;e=0}l=0;while(1){if((g|0)!=(l|0)){d=(l<<5)+w|0;k=H[d+24>>2];if(!((k|0)<=0|e)){e=ig(a,H[d>>2],H[d+4>>2],H[d+20>>2],k)}Ta(H[d+20>>2]);Ta(H[d+8>>2]);l=l+1|0;continue}break}k=(g<<5)+w|0;if(!e){g=H[i+12>>2];d=H[i+8>>2]+1|0;g=d?g:g+1|0;m=H[i+16>>2];l=H[i+24>>2];n=H[i+28>>2];p=H[i+56>>2];z=H[i+60>>2];C=H[i+32>>2];s=H[i+36>>2];if(I[i+48|0]){e=0;j=0}else{e=H[r+4>>2];j=H[r>>2]}e=Rp(a,d,g,m,l,n,p,z,C,s,j,e,H[k+20>>2],H[k+24>>2])}Ta(H[k+20>>2]);Ta(H[k+8>>2]);H[f+20>>2]=e}if(I[i+48|0]|!h){break k}d=o;h=q+1|0;d=h?d:d+1|0;ox(a,h,d,H[r>>2],H[r+4>>2]);break k}H[f+20>>2]=e}$g(D);continue}break}l=e}M:{if(!G|l){break M}H[f+24>>2]=0;l=Lb(a,23,f+24|0,0);if(l){break M}a=H[f+24>>2];Cb(a,1,1,0);dg(a,2,H[f+8>>2],H[f+12>>2],0);vb(a);l=ob(a);Ae(a,1)}Ta(v);Ta(H[f+8>>2])}Ea=f+112|0;return l}function Bn(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0;i=Ea-304|0;Ea=i;H[i+140>>2]=0;H[i+136>>2]=0;z=H[a>>2];a:{if(H[a+36>>2]){t=c;break a}H[i+112>>2]=0;t=0;b:{if(!c){break b}if(!(H[c+52>>2]|!(I[c+5|0]&2))){L=H[c+28>>2];H[c+28>>2]=0;fc(z,c);t=0;break b}t=c}j=rh(a,b);if(!j){break a}c=H[j>>2];g=H[z+16>>2];v=Fb(z,H[j+60>>2]);if(Yb(a,18,c,0,H[g+(v<<4)>>2])){break a}B=H[j+28>>2];E=ui(a,j,127,0,i+104|0);M=I[j+43|0];if(cf(a,j)){break a}if(dn(a,j,E)){break a}l=wb(a);if(!l){break a}if(!I[a+18|0]){G[l+152>>1]=J[l+152>>1]|16}kd(a,(t|E)!=0,v);c:{d:{if(H[a+276>>2]|(!t|d|E)|(H[t+64>>2]|I[j+43|0]==1)){break d}h=e;e:{if((h|0)!=11){break e}if(G[j+32>>1]>=0){h=I[j+42|0];if((h|0)!=11){break e}}h=2}c=H[t+32>>2];if(H[c>>2]!=1|H[c+28>>2]|(H[t+36>>2]|H[t+48>>2])){break d}if(H[t+40>>2]|H[t+60>>2]|(H[t+52>>2]|F[t+4|0]&1)){break d}g=H[t+28>>2];if(H[g>>2]!=1|I[H[g+8>>2]]!=180){break d}w=H[a>>2];s=df(a,0,c+8|0);if(!s|H[s+20>>2]==H[j+20>>2]&H[s+60>>2]==H[j+60>>2]){break d}c=H[s+28>>2];g=H[j+28>>2];if(I[s+43|0]|(c^g)&128){break d}m=J[j+34>>1];if(J[j+32>>1]!=J[s+32>>1]|(c&65536?0:g&65536)|(m|0)!=J[s+34>>1]){break d}while(1){if(m<<16>>16>(q|0)){g=N(q,12);c=g+H[j+4>>2]|0;m=J[c+10>>1]&96;g=g+H[s+4>>2]|0;if((m|0)!=(J[g+10>>1]&96)){break d}if(m){if(cc(0,Mc(s,g),Mc(j,c),-1)){break d}}if(I[c+5|0]!=I[g+5|0]){break d}if(Zb(Yf(c),Yf(g))|(I[g+4|0]&15?0:I[c+4|0]&15)){break d}f:{if(!q|J[c+10>>1]&96){break f}c=Mc(j,c);g=Mc(s,g);if((!c|0)==((g|0)!=0|0)){break d}if(!c){break f}if(Tc(H[c+8>>2],H[g+8>>2])){break d}}q=q+1|0;m=J[j+34>>1];continue}break}g=s+8|0;r=j+8|0;c=r;while(1){m=H[c>>2];if(m){o=I[m+54|0]?1:o;c=g;while(1){c=H[c>>2];if(!c){break d}if(!oB(m,c)){c=c+20|0;continue}break}if(!(H[c+44>>2]!=H[m+44>>2]|H[s+60>>2]!=H[j+60>>2])){c=H[16544];if(!c){break d}if(!(Ia[c|0](411)|0)){break d}}c=m+20|0;continue}break}c=H[j+16>>2];if(c){if(If(H[s+16>>2],c,-1)){break d}}m=H[w+36>>2];g:{if(H[w+32>>2]&16384){if(m&1){break d}if(!H[j+48>>2]){break g}break d}if(m&1){break d}}x=Fb(w,H[s+60>>2]);k=wb(a);ld(a,x);n=H[a+40>>2];H[a+40>>2]=n+2;m=0;C=nB(a,v,j);A=zb(a);Sa(k,75,0,A);y=zb(a);p=n+1|0;Hd(a,p,v,j,113);if(!(I[w+24|0]&4|!(o|(H[j+8>>2]?G[j+32>>1]<0:0))&h-3>>>0>4294967293)){c=Sa(k,36,p,0);m=Mb(k,9);o=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(c,20)|0)+8>>2]=o}h:{if(!(I[s+28|0]&128)){Hd(a,n,x,s,112);u=Sa(k,36,n,0);i:{if(G[j+32>>1]>=0){q=Sa(k,135,n,y);if(!(I[w+24|0]&4)){c=Ua(k,31,p,0,y);Cr(a,h,j);h=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(c,20)|0)+8>>2]=h}mB(a,C,y);break i}if(!(H[j+8>>2]|I[w+24|0]&8)){q=Sa(k,127,p,y);break i}q=Sa(k,135,n,y)}h=169;if(I[w+24|0]&4){_a(k,137,p);h=152}Ua(k,129,p,n,y);Ua(k,128,p,A,y);if(!(I[w+24|0]&4)){Wd(k,-1,j,-5)}c=H[k+108>>2];if((c|0)>0){G[(H[k+104>>2]+N(c,20)|0)-18>>1]=h}Sa(k,39,n,q);Sa(k,122,n,0);Sa(k,122,p,0);break h}wd(a,v,H[j+20>>2],1,H[j>>2]);wd(a,x,H[s+20>>2],0,H[s>>2])}while(1){h=g;j:{k:{l:{m:{o=H[r>>2];if(o){while(1){n:{h=H[h>>2];if(!h){break n}if(oB(o,h)){break n}h=h+20|0;continue}break}Ua(k,112,n,H[h+44>>2],x);Ed(a,h);Ua(k,113,p,H[o+44>>2],v);Ed(a,o);c=H[k+108>>2];if((c|0)>0){G[(H[k+104>>2]+N(c,20)|0)-18>>1]=1}r=Sa(k,36,n,0);if(I[w+24|0]&4){q=J[h+52>>1];c=0;while(1){C=(c|0)==(q|0);if(C){break m}if(!Zb(33248,H[H[h+32>>2]+(c<<2)>>2])){c=c+1|0;continue}break}if(C){break m}break l}if(!(I[s+28|0]&128)){break l}c=((I[o+55|0]|I[o+56|0]<<8)&3)==2?9:8;break k}if(u){h=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(u,20)|0)+8>>2]=h}rb(a,y);rb(a,A);if(!m){v=0;h=0;break c}pk(a);Sa(k,70,0,0);h=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(m,20)|0)+8>>2]=h;Sa(k,122,p,0);break d}_a(k,137,p);Sa(k,129,p,n);c=152;break j}c=8}Ua(k,134,n,A,1)}Sa(k,138,p,A);h=H[k+108>>2];if((h|0)>0){G[(H[k+104>>2]+N(h,20)|0)-18>>1]=c}Sa(k,39,n,r+1|0);h=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(r,20)|0)+8>>2]=h;Sa(k,122,n,0);Sa(k,122,p,0);r=o+20|0;continue}}C=nB(a,v,j);c=H[a+44>>2];s=c+1|0;h=s+G[j+34>>1]|0;H[a+44>>2]=h;p=s;if(I[j+43|0]==1){H[a+44>>2]=h+1;p=c+2|0}O=B&128;r=!(J[j+28>>1]&1088);o:{p:{q:{r:{if(!d){o=-1;break r}F[d+4|0]=1;h=0;c=H[d>>2];m=(c|0)>0?c:0;k=d+8|0;while(1)if((h|0)==(m|0)){o=-1;c=0;while(1){if((c|0)==(m|0)){break r}h=0;g=G[j+34>>1];n=(g|0)>0?g:0;g=k+(c<<3)|0;s:{t:{while(1){if((h|0)==(n|0)){break t}u:{u=N(h,12);if(!ab(H[g>>2],H[u+H[j+4>>2]>>2])){H[g+4>>2]=h;n=u+H[j+4>>2]|0;if(!(I[n+10|0]&96)){break u}H[i+96>>2]=H[n>>2];Wa(a,29344,i+96|0);break q}h=h+1|0;continue}break}if(G[j+34>>1]<=(h|0)){break t}r=(c|0)==(h|0)?r:0;o=G[j+32>>1]==(h|0)?c:o;break s}h=H[g>>2];if(fj(h)){r=0;o=c;if(!O){break s}}H[i+84>>2]=h;H[i+80>>2]=b+8;Wa(a,7201,i+80|0);F[a+17|0]=1;break q}c=c+1|0;continue}}else{H[(k+(h<<3)|0)+4>>2]=-1;h=h+1|0;continue}}w=p+1|0;v:{w:{x:{y:{if(t){c=H[a+44>>2]+1|0;H[a+44>>2]=c;h=0;g=H[l+108>>2];Ua(l,11,c,0,g+1|0);H[i+124>>2]=0;H[i+128>>2]=0;H[i+116>>2]=0;H[i+120>>2]=0;H[i+112>>2]=c;F[i+108|0]=13;H[i+120>>2]=r&255?w:0;H[i+124>>2]=G[j+34>>1];if(Lc(a,t,i+108|0)|H[a+36>>2]){break a}A=H[i+120>>2];Ci(l,c);h=H[l+108>>2];H[(I[H[l>>2]+87|0]?73336:H[l+104>>2]+N(g,20)|0)+8>>2]=h;x=H[H[t+28>>2]>>2];if(E){break w}r=wb(a);c=H[r+108>>2];m=0;if(I[j+43|0]==1){m=zd(H[a>>2],j)}n=(c|0)<=1?1:c;c=j+8|0;k=1;while(1){u=0;if((k|0)==(n|0)){break y}h=73336;h=I[H[r>>2]+87|0]?h:H[r+104>>2]+N(k,20)|0;g=I[h|0];z:{if((g|0)!=173){if((g|0)!=112|(v|0)!=H[h+12>>2]){break z}g=c;u=H[h+8>>2];if((u|0)==H[j+20>>2]){break w}while(1){h=H[g>>2];if(!h){break z}g=h+20|0;if((u|0)!=H[h+44>>2]){continue}break}break w}if(H[h+16>>2]==(m|0)){break w}}k=k+1|0;continue}}H[i+188>>2]=0;H[i+192>>2]=0;H[i+180>>2]=0;H[i+184>>2]=0;H[i+172>>2]=0;H[i+176>>2]=0;H[i+164>>2]=0;H[i+168>>2]=0;H[i+160>>2]=a;A=0;x=0;if(L){x=H[L>>2];if(Ne(i+160|0,L)){break x}}u=-1}y=1;break v}h=0;t=0;break a}u=H[a+40>>2];H[a+40>>2]=u+1;c=zb(a);h=zb(a);Sa(l,118,u,x);g=_a(l,12,H[i+112>>2]);Ua(l,97,A,x,c);Sa(l,127,u,h);Ua(l,128,u,c,h);Qb(l,g);m=H[l+108>>2];H[(I[H[l>>2]+87|0]?73336:H[l+104>>2]+N(g,20)|0)+8>>2]=m;rb(a,c);rb(a,h);y=0}A:{if((x|0)<=0|d){break A}g=0;B:{m=H[j+28>>2];o=G[j+32>>1];if(!(m&96)|(o|0)<0){break B}h=o;while(1){if((h|0)<=0){break B}o=o-((I[(H[j+4>>2]+N(h,12)|0)-2|0]&96)!=0)|0;h=h-1|0;continue}}c=G[j+34>>1];C:{if(!(m&98)){break C}m=(c|0)>0?c:0;h=0;while(1){if((h|0)==(m|0)){break C}g=((I[(H[j+4>>2]+N(h,12)|0)+10|0]&98)!=0)+g|0;h=h+1|0;continue}}c=c-g|0;if((c|0)==(x|0)){break A}H[i+72>>2]=x;H[i+68>>2]=c;H[i+64>>2]=b+8;Wa(a,16177,i- -64|0);break q}D:{if(!d){break D}c=H[d>>2];if((c|0)==(x|0)){break D}H[i+52>>2]=c;H[i+48>>2]=x;Wa(a,5195,i+48|0);break q}h=0;v=0;if(!(I[a+18|0]|!(F[z+36|0]&1)|(H[a+132>>2]|I[a+159|0]))){v=H[a+44>>2]+1|0;H[a+44>>2]=v;Sa(l,71,0,v)}if((M|0)==2){break o}c=sk(a,j,113,0,-1,0,i+140|0,i+136|0);h=Nb(z,(c<<2)+8|0,0);if(h){break p}}h=0;break a}g=0;c=(c|0)>0?c:0;k=j+8|0;while(1){if((c|0)!=(g|0)){m=H[k>>2];k=H[a+44>>2]+1|0;H[a+44>>2]=k;H[(g<<2)+h>>2]=k;H[a+44>>2]=H[a+44>>2]+J[m+52>>1];g=g+1|0;k=m+20|0;continue}break}g=H[a+44>>2]+1|0;H[a+44>>2]=g;H[(c<<2)+h>>2]=g}if(f){E:{switch(I[j+43|0]-1|0){case 0:H[i+32>>2]=H[j>>2];Wa(a,29511,i+32|0);break a;case 1:Wa(a,1835,0);break a;default:break E}}if(Hk(a,H[f>>2])){break a}P=H[i+140>>2];H[b+48>>2]=P;Q=i+212|0;R=H[i+136>>2];k=f;while(1){H[k+44>>2]=R;H[k+40>>2]=P;H[k+36>>2]=w;H[k+32>>2]=b;F:{if(!H[k>>2]){break F}B=0;H[i+300>>2]=0;H[i+292>>2]=0;H[i+296>>2]=0;H[i+284>>2]=0;H[i+288>>2]=0;H[i+276>>2]=0;H[i+280>>2]=0;H[i+272>>2]=b;H[i+268>>2]=a;m=k;while(1){if(!m){break F}c=H[m>>2];if(!c){break F}g=i+268|0;if(Ne(g,c)){break a}if(cd(g,H[m+4>>2])){break a}D=H[b+48>>2];G:{c=H[b+24>>2];K=H[m>>2];H:{if(I[c+28|0]&128|H[K>>2]!=1){break H}g=H[K+8>>2];if(I[g|0]!=167){break H}if(J[g+32>>1]==65535){break G}}Xa(i+160|0,0,104);H[i+240>>2]=D;F[i+212|0]=167;H[i+172>>2]=Q;F[i+160|0]=113;S=K+8|0;g=c+8|0;I:{while(1){q=H[g>>2];if(q){J:{if(!I[q+54|0]){break J}n=H[K>>2];if((n|0)!=J[q+50>>1]){break J}c=H[q+36>>2];if(c){g=H[m+4>>2];if(!g){break J}if(cc(a,g,c,D)){break J}n=J[q+50>>1]}r=0;while(1){if((n|0)!=(r|0)){H[i+168>>2]=H[H[q+32>>2]+(r<<2)>>2];c=J[H[q+4>>2]+(r<<1)>>1];K:{if((c|0)==65534){c=H[(H[q+40>>2]+(r<<4)|0)+8>>2];if(I[c|0]==113){break K}H[i+172>>2]=c;c=i+160|0;break K}G[i+244>>1]=c;H[i+172>>2]=Q;c=i+160|0}g=0;while(1){if((g|0)==(n|0)){break J}T=g<<4;g=g+1|0;if(cc(0,H[S+T>>2],c,D)>>>0>1){continue}break}r=r+1|0;continue}break}H[m+28>>2]=q;if((_m(f,q)|0)==(m|0)){break I}F[m+21|0]=1;break I}g=q+20|0;continue}break}q=H[m+28>>2]}if(q){break G}L:{if(!(H[m+16>>2]|B)){F[i+144|0]=0;break L}H[i+16>>2]=B+1;Bd(16,i+144|0,29954,i+16|0)}H[i>>2]=i+144;Wa(a,2746,i);break a}B=B+1|0;m=H[m+16>>2];continue}}k=H[k+16>>2];if(k){continue}break}}M:{if(!y){m=_a(l,36,u);r=H[l+108>>2];break M}if(!t){r=0;m=0;break M}r=_a(l,12,H[i+112>>2]);if((o|0)>=0){Sa(l,80,o+A|0,p)}m=r}B=L+8|0;K=d+8|0;q=0;n=w;k=0;while(1){c=G[j+34>>1];if((k|0)<(c|0)){N:{if(G[j+32>>1]==(k|0)){_a(l,76,n);break N}O:{P:{c=H[j+4>>2]+N(k,12)|0;g=J[c+10>>1];Q:{if(g&98){q=q+1|0;if(g&32){n=n-1|0;break N}if(g&64){if(!(F[i+104|0]&1)){break N}_a(l,76,n);break N}if(d){break Q}lk(a,Mc(j,c),n);break N}if(!d){break P}}g=0;D=H[d>>2];D=(D|0)>0?D:0;while(1){if((g|0)!=(D|0)){if(H[(K+(g<<3)|0)+4>>2]==(k|0)){break O}g=g+1|0;continue}break}lk(a,Mc(j,c),n);break N}if(!x){lk(a,Mc(j,c),n);break N}g=k-q|0}if(!y){Ua(l,94,u,g,n);break N}if(t){if((w|0)==(A|0)){break N}Sa(l,81,g+A|0,n);break N}c=H[B+(g<<4)>>2];g=Me(a,c,n);if((g|0)==(n|0)){break N}Sa(l,H[c+4>>2]&4194304?80:81,g,n)}n=n+1|0;k=k+1|0;continue}break}n=H[a+56>>2]-1|0;H[a+56>>2]=n;if(F[i+104|0]&1){c=nc(a,c+1|0);R:{if((o|0)<0){Sa(l,71,-1,c);break R}S:{if(!y){Ua(l,94,u,o,c);break S}ac(a,H[B+(o<<4)>>2],c)}g=_a(l,51,c);Sa(l,71,-1,c);k=H[l+108>>2];H[(I[H[l>>2]+87|0]?73336:H[l+104>>2]+N(g,20)|0)+8>>2]=k;_a(l,13,c)}g=c+1|0;Ua(l,80,w,g,G[j+36>>1]-1|0);if(I[j+28|0]&96){mk(a,g,j)}if((M|0)!=2){yg(l,j,g)}si(a,E,127,0,1,j,c+(G[j+34>>1]^-1)|0,e,n);Sc(a,c,G[j+34>>1]+1|0)}T:{if((M|0)==2){break T}if(I[j+43|0]==1){Sa(l,75,0,s)}U:{if((o|0)>=0){V:{if(!y){Ua(l,94,u,o,p);break V}if(t){break V}W:{c=H[B+(o<<4)>>2];if(I[c|0]!=121){break W}g=1;if(I[j+43|0]==1){break W}Ua(l,127,H[i+140>>2],p,C);break U}ac(a,c,p)}X:{if(I[j+43|0]!=1){c=_a(l,51,p);Ua(l,127,H[i+140>>2],p,C);g=H[l+108>>2];H[(I[H[l>>2]+87|0]?73336:H[l+104>>2]+N(c,20)|0)+8>>2]=g;break X}Sa(l,50,p,H[l+108>>2]+2|0)}_a(l,13,p);g=0;break U}if(!(!O&I[j+43|0]!=1)){g=0;Sa(l,75,0,p);break U}Ua(l,127,H[i+140>>2],p,C);g=1}mB(a,C,p);if(I[j+28|0]&96){mk(a,w,j)}if(I[j+43|0]==1){c=zd(z,j);cn(a,j);fb(l,7,1,G[j+34>>1]+2|0,s,c,-11);c=H[l+108>>2];if((c|0)>0){G[(H[l+104>>2]+N(c,20)|0)-18>>1]=(e|0)==11?2:e}c=H[a+128>>2];F[(c?c:a)+21|0]=1;break T}H[i+160>>2]=0;c=H[i+140>>2];k=H[i+136>>2];qB(a,j,h,c,k,s,0,(o^-1)>>>31|0,e&255,n,i+160|0,0,f);if(I[z+33|0]&64){$m(a,j,0,s,0,0)}Fr(a,j,c,k,s,h,0,g,!(H[i+160>>2]?H[l+232>>2]:0))}if(v){Sa(l,86,v,1)}if(E){si(a,E,127,0,2,j,(G[j+34>>1]^-1)+p|0,e,n)}hb(l,n);if(!y){Sa(l,39,u,r);e=H[l+108>>2];H[(I[H[l>>2]+87|0]?73336:H[l+104>>2]+N(m,20)|0)+8>>2]=e;_a(l,122,u);break c}if(!t){break c}Qb(l,r);e=H[l+108>>2];H[(I[H[l>>2]+87|0]?73336:H[l+104>>2]+N(m,20)|0)+8>>2]=e}if(!(I[a+18|0]|H[a+132>>2])){pk(a)}if(!v){break a}bn(l,v,15468)}Cc(z,b);pb(z,L);Mk(z,f);fc(z,t);re(z,d);if(h){Wb(z,h)}Ea=i+304|0}function qg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0;t=Ea-16|0;Ea=t;e=H[b>>2];n=H[e>>2];r=H[n>>2];a:{if(I[r+87|0]){break a}d=H[b+24>>2]+N(c,48)|0;i=H[d>>2];H[e+496>>2]=0;w=e+496|0;m=Ze(w,H[i+12>>2]);q=Ha;p=I[i|0];b:{if((p|0)==49){if(SA(n,i)){break a}e=H[i+20>>2];c:{if(I[i+5|0]&16){e=Zq(w,e);f=Ha;break c}e=_e(w,e);f=Ha}H[d+32>>2]=e;H[d+36>>2]=f;g=e|m;j=f|q;break b}e=Ze(w,H[i+16>>2]);H[d+32>>2]=e;f=Ha;H[d+36>>2]=f;if(!H[i+12>>2]|(I[i+5|0]|I[i+6|0]<<8)&1040|H[i+20>>2]){g=zm(w,i);j=Ha;break b}g=e|m;j=f|q}if(H[w>>2]){G[d+10>>1]=J[d+10>>1]|4096}e=H[i+4>>2];d:{if(!(e&3)){break d}f=Je(w,H[i+36>>2]);k=Ha;if(e&1){j=k|j;s=j>>>1|0;g=f|g;v=(j&1)<<31|g>>>1;if((k|0)==(s|0)&f>>>0>v>>>0|k>>>0>s>>>0){B=f-1|0;C=k-!f|0;break d}Wa(n,3224,0);break a}s=j>>>1|0;if((k|0)==(s|0)&f>>>0>((j&1)<<31|g>>>1)>>>0|k>>>0>s>>>0){break d}if(!(!(I[a+44|0]&64)|H[a>>2]<=0)){Wa(n,3224,0);break a}e=e&-4;H[i+4>>2]=e}H[d+40>>2]=g;H[d+44>>2]=j;H[d+16>>2]=-1;H[d+20>>2]=-1;G[d+12>>1]=0;f=p-45|0;e:{f:{if(!(f>>>0>12|!(1<<f&7985))){e=Jf(H[i+12>>2]);f=Jf(H[i+16>>2]);k=m&H[d+32>>2]|q&H[d+36>>2]?2048:16383;h=H[d+28>>2];if((h|0)>0){e=H[(H[e+20>>2]+(h<<4)|0)-8>>2]}if(Oz(a,t,e,p)){H[d+20>>2]=H[t>>2];H[d+24>>2]=H[t+4>>2];L=d,M=Nz(p)&k,G[L+12>>1]=M}if((p|0)==45){G[d+10>>1]=J[d+10>>1]|2048}g:{if(!f){break g}if(!Oz(a,t,f,p)|I[f+4|0]&32){break g}e=i;f=d;h:{if(H[d+20>>2]<0){break h}e=jb(r,e,0);if(I[r+87|0]){eb(r,e);break a}d=be(b,e,3);if(!d){break a}f=H[b+24>>2];pg(b,d,c);d=N(d,48)+f|0;if((p|0)==45){G[d+10>>1]=J[d+10>>1]|2048}f=H[b+24>>2]+N(c,48)|0;G[f+10>>1]=J[f+10>>1]|8;if(I[H[n>>2]+80|0]&128){break h}h=I[e|0];if((h|0)!=53&(h|0)!=45|F[e+4|0]&1){break h}h=rc(H[e+12>>2]);l=rc(H[e+16>>2]);if((h|0)!=(l|0)&((h|0)<67|(l|0)<67)){break h}h=Uh(n,e);if(!(!h|H[h+12>>2]==15)){h=H[e+16>>2];l=Bf(n,H[e+12>>2]);h=Bf(n,h);if(ab(H[l>>2],H[h>>2])){break h}}o=2048;G[f+12>>1]=J[f+12>>1]|2048}h=H[e+12>>2];i:{j:{if(I[h|0]==177){break j}l=H[e+16>>2];if(I[l|0]==177){break j}if((Zf(n,h,l)|0)==(Zf(n,H[e+16>>2],H[e+12>>2])|0)){break i}}H[e+4>>2]=H[e+4>>2]^1024}L=e,M=yJ(H[e+12>>2],H[e+16>>2],32),H[L+12>>2]=M;H[e+16>>2]=Ha;h=I[e|0];if(h>>>0>=54){F[e|0]=(h-54^2)+54}H[d+20>>2]=H[t>>2];h=H[t+4>>2];H[d+40>>2]=g;H[d+44>>2]=j;H[d+32>>2]=m|B;H[d+36>>2]=q|C;H[d+24>>2]=h;L=d,M=k&Nz(I[e|0])+o,G[L+12>>1]=M;d=f;break f}if((p|0)!=50){break f}f=H[i+4>>2];if(f&1){break f}if(af(e)){break f}H[i+8>>2]=13493;F[i|0]=170;H[i+4>>2]=f|536870912;G[d+12>>1]=0;H[d+40>>2]=0;H[d+44>>2]=0;break f}k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{f=I[i|0];switch(f-48|0){case 1:case 2:break e;case 3:break r;case 0:break t;default:break u}}if((f|0)==43){break s}if((f|0)!=172){break e}if(I[b+8|0]!=44){break f}e=H[i+20>>2];if(!e){break f}p=H[n>>2];g=H[e>>2];f=Te(p,H[i+8>>2],g,1,0);if(!f){break f}y=H[f+4>>2];if(!(y&4)){break f}e=H[i+20>>2];f=H[f+8>>2];z=I[f+2|0];k=I[f+1|0];q=I[f|0];if((g|0)>=3){f=H[e+40>>2];if(I[f|0]!=117){break f}f=H[f+8>>2];o=I[f|0];if(!o|(I[f+1|0]|(o|0)==(q|0)|(k|0)==(o|0))){break f}}m=H[e+24>>2];j=Jf(H[e+8>>2]);s=I[j|0];if((s|0)!=156){break p}if(!(I[p+34|0]&128)){break q}break n}if(I[b+8|0]!=44){break f}e=H[i+20>>2]+8|0;f=N(c,48);while(1){if((h|0)==2){break f}d=ib(n,I[h+50086|0],jb(r,H[i+12>>2],0),jb(r,H[e+(h<<4)>>2],0));dk(d,i);d=be(b,d,3);qg(a,b,d);g=H[b+24>>2];pg(b,d,c);h=h+1|0;d=f+g|0;continue}}D=N(c,48);u=D+H[b+24>>2]|0;y=H[u>>2];v=H[b>>2];z=H[v>>2];p=H[z>>2];k=nb(p,424,0);H[u+24>>2]=k;v:{if(!k){break v}G[u+10>>1]=J[u+10>>1]|16;e=Xa(k+32|0,0,384);F[k+9|0]=0;H[k>>2]=v;H[k+20>>2]=0;H[k+4>>2]=0;H[k+24>>2]=e;H[k+12>>2]=0;H[k+16>>2]=8;Gm(k,y,43);fr(a,k);if(I[p+87|0]){break v}s=v+496|0;e=H[k+24>>2];l=H[k+12>>2];f=-1;o=-1;m=-1;q=-1;while(1){if(!(!(f|o)|(l|0)<=0)){d=J[e+12>>1];w:{if(!(d&511)){d=Nb(p,416,0);if(!d){m=0;q=0;break w}H[e+24>>2]=d;H[e+20>>2]=-1;G[e+12>>1]=1024;G[e+10>>1]=J[e+10>>1]|32;g=Xa(d+32|0,0,384);j=H[b>>2];F[d+9|0]=0;H[d>>2]=j;H[d+20>>2]=0;H[d+4>>2]=0;H[d+24>>2]=g;H[d+12>>2]=0;H[d+16>>2]=8;Gm(d,H[e>>2],44);fr(a,d);H[d+4>>2]=b;m=0;q=0;g=0;j=0;x:{if(I[p+87|0]){break x}h=0;A=H[d+12>>2];A=(A|0)>0?A:0;d=H[d+24>>2];while(1){if((h|0)==(A|0)){break x}E=I[H[d>>2]]-45|0;if(!(!(1<<E&7985?E>>>0<=12:0)&J[d+12>>1]!=64)){g=Je(s,H[d+20>>2])|g;j=j|Ha}d=d+48|0;h=h+1|0;continue}}f=f&g;o=j&o;break w}h=J[e+10>>1];if(h&8){break w}g=Je(s,H[e+20>>2]);j=Ha;if(h&2){g=Je(s,H[(H[k+24>>2]+N(H[e+16>>2],48)|0)+20>>2])|g;j=j|Ha}d=d&2;m=d?g&m:0;q=d?j&q:0;f=f&g;o=j&o}l=l-1|0;e=e+48|0;continue}break}H[k+416>>2]=f;H[k+420>>2]=o;e=-1;H[u+20>>2]=-1;G[u+12>>1]=512;y:{if(!(f|o)){break y}F[b+9|0]=1;if(H[k+12>>2]!=2){break y}f=H[k+24>>2];z:while(1){g=Mz(f,x);if(!g){break y}x=x+1|0;h=0;while(1){j=Mz(f+48|0,h);if(!j){continue z}A:{if((J[j+10>>1]|J[g+10>>1])&128){break A}d=J[g+12>>1];if(!(d&62)){break A}f=J[j+12>>1];if(!(f&62)){break A}d=d|f;if(d&65497?d&65509:0){break A}if(cc(0,H[H[g>>2]+12>>2],H[H[j>>2]+12>>2],-1)){break A}if(cc(0,H[H[g>>2]+16>>2],H[H[j>>2]+16>>2],-1)){break A}j=jb(H[H[H[b>>2]>>2]>>2],H[g>>2],0);if(!j){break A}l=d&d+63?d&24?8:32:d;d=53;while(1){f=d;d=d+1|0;if((l|0)!=2<<f-53){continue}break}F[j|0]=f;qg(a,b,be(b,j,3))}h=h+1|0;f=H[k+24>>2];continue}}}if(!(m|q)){break v}f=0;while(1){if(!(K>>>0>1|f)){h=H[k+12>>2];d=H[k+24>>2];while(1){if((h|0)<=0){break v}h=h-1|0;G[d+10>>1]=J[d+10>>1]&65471;B:{g=H[d+20>>2];if((g|0)!=(e|0)){if(Je(s,g)&m|q&Ha){break B}}d=d+48|0;continue}break}j=H[H[d>>2]+12>>2];f=1;l=H[d+24>>2];o=(l|0)!=-2;while(1){if(!(!f|(h|0)<0)){C:{D:{if((g|0)!=H[d+20>>2]){G[d+10>>1]=J[d+10>>1]&65471;break D}f=0;if((l|0)!=H[d+24>>2]){break C}e=H[d>>2];if(!o){if(cc(z,H[e+12>>2],j,-1)){break C}e=H[d>>2]}e=rc(H[e+16>>2]);if((rc(H[H[d>>2]+12>>2])|0)!=(e|0)?e:0){break C}G[d+10>>1]=J[d+10>>1]|64}f=1}d=d+48|0;h=h-1|0;continue}break}K=K+1|0;e=g;continue}break}if(!f){break v}d=H[k+24>>2];h=H[k+12>>2];e=0;f=0;while(1){if((h|0)>0){if(I[d+10|0]&64){f=jb(p,H[H[d>>2]+16>>2],0);e=Pb(H[v>>2],e,f);f=H[H[d>>2]+12>>2]}h=h-1|0;d=d+48|0;continue}break}d=ib(z,49,jb(p,f,0),0);if(d){dk(d,y);H[d+20>>2]=e;e=be(b,d,3);qg(a,b,e);pg(b,e,c);break v}pb(p,e)}d=D+H[b+24>>2]|0;break f}f=H[i+12>>2];if(I[f|0]!=167|(e&1|G[f+32>>1]<0)){break f}g=be(b,ib(n,54,jb(r,f,0),sc(r,121,0,0)),131);if(!g){break f}e=H[b+24>>2]+N(g,48)|0;H[e+32>>2]=0;H[e+36>>2]=0;H[e+20>>2]=H[f+28>>2];d=G[f+32>>1];G[e+12>>1]=4;H[e+24>>2]=d;pg(b,g,c);d=H[b+24>>2]+N(c,48)|0;G[d+10>>1]=J[d+10>>1]|8;f=H[d+44>>2];H[e+40>>2]=H[d+40>>2];H[e+44>>2]=f;break f}f=G[j+32>>1];u=PA(H[n+240>>2],f);E:{if(!u){break E}g=J[u+16>>1];e=g&31;if((g&63)>>>0>=32){e=262144>>>e|0}else{e=((1<<e)-1&262144)<<32-e|262148>>>e}if(!(e&1)){break E}l=$a(u)}e=H[n+8>>2];H[e+228>>2]=H[e+228>>2]|((f|0)>31?-2147483648:1<<f-1);break o}if((s|0)!=117){break n}l=H[j+8>>2]}e=0;if(!l){k=1;break l}while(1){f=e;v=e+l|0;g=I[v|0];if(!(!g|(g|0)==(q|0)|((g|0)==(k|0)|(g|0)==(z|0)))){e=e+1|0;if((g|0)!=(o|0)){continue}e=I[e+l|0]?f+2|0:e;continue}break}k=1;if((f|0)<=1){e=0;if(I[l|0]==(o|0)|(f|0)!=1){break l}}if(I[v-1|0]==255){break m}x=(g|0)==(q|0)?!I[v+1|0]:x;F:{e=oc(p,117,l);if(!e){break F}g=H[e+8>>2];F[g+f|0]=0;l=0;while(1){if((f|0)>(h|0)){k=(F[g+h|0]==(o|0))+h|0;F[g+l|0]=I[k+g|0];l=l+1|0;h=k+1|0;continue}break}f=g+l|0;F[f|0]=0;G:{if(I[m|0]!=167){break G}if((rc(m)|0)!=66){break G}if(I[m+7|0]&3){break F}m=H[m+44>>2];if(!m|I[m+43|0]!=1){break F}}if(!((Md(g,t,l,1)|0)>0|(l|0)==1&I[g|0]==45)){f=f-1|0;m=I[f|0];F[f|0]=m+1;g=Md(g,t,l,1);F[f|0]=m;if((g|0)<=0){break F}}he(p,e);Uc(u);break f}k=0;if((s|0)!=156){break k}f=H[n+8>>2];g=G[j+32>>1];H[f+228>>2]=H[f+228>>2]|((g|0)>31?-2147483648:1<<g-1);if(!x){break l}if(!I[H[j+8>>2]+1|0]){break k}g=zb(n);Me(n,j,g);if(I[H[f>>2]+87|0]){f=73336}else{f=(H[f+104>>2]+N(H[f+108>>2],20)|0)-20|0}H[f+12>>2]=0;rb(n,g);break k}k=1}e=0}x=0}Uc(u);if(k){break f}j=H[H[i+20>>2]+24>>2];g=jb(r,e,0);H:{m=y&8;if(m|I[H[n>>2]+87|0]){break H}G[d+10>>1]=J[d+10>>1]|1024;d=0;while(1){k=H[e+8>>2]+d|0;f=I[k|0];if(!f){break H}F[k|0]=f&(I[f+31152|0]^-1|223);F[H[g+8>>2]+d|0]=I[f+30768|0];d=d+1|0;continue}}if(!I[r+87|0]){d=H[g+8>>2];f=(bb(d)+d|0)-1|0;d=I[f|0];if(!m){x=(d|0)!=64?x:0;d=I[d+30768|0]}F[f|0]=d+1}d=m?33248:20255;e=ib(n,57,qi(n,jb(r,j,0),d),e);dk(e,i);e=be(b,e,259);d=ib(n,56,qi(n,jb(r,j,0),d),g);dk(d,i);f=be(b,d,259);qg(a,b,e);qg(a,b,f);d=H[b+24>>2]+N(c,48)|0;if(!x){break f}pg(b,e,c);pg(b,f,c)}f=I[i|0]}I:{J:{K:{L:{M:{N:{O:{P:{Q:{R:{e=f&255;switch(e-49|0){case 1:case 2:case 3:break O;case 0:break P;case 4:break Q;default:break R}}if((e|0)!=45){break O}}S:{g=H[i+12>>2];e=Qc(g);if((e|0)<2){break S}j=H[i+16>>2];if((Qc(j)|0)!=(e|0)|(I[j+5|0]&16?I[g+5|0]&16:0)|I[b+8|0]!=44){break S}d=0;while(1){if((d|0)==(e|0)){break N}f=Er(n,H[i+12>>2],d,e);g=Er(n,H[i+16>>2],d,e);f=ib(n,I[i|0],f,g);dk(f,i);qg(a,b,be(b,f,32769));d=d+1|0;continue}}if((f&255)!=49){break O}}if(H[d+28>>2]){break O}d=H[i+12>>2];if(!(I[i+5|0]&16)|I[d|0]!=177){break O}e=H[i+20>>2];if((I[e+5|0]&2?0:H[e+52>>2])|H[e+68>>2]|I[b+8|0]!=44){break O}h=0;while(1){if((Qc(d)|0)<=(h|0)){break I}e=be(b,i,32770);h=h+1|0;H[(H[b+24>>2]+N(e,48)|0)+28>>2]=h;qg(a,b,e);pg(b,e,c);d=H[i+12>>2];continue}}if(I[b+8|0]!=44){break I}T:{d=f&255;if(d-51>>>0<2){break T}o=0;e=0;a=0;h=0;U:{switch(d-171|0){case 0:break T;case 1:break U;default:break J}}e=H[i+20>>2];if(!e|H[e>>2]!=2){break K}V:{a=H[e+24>>2];if(I[a|0]!=167|I[H[a+44>>2]+43|0]!=1){break V}f=H[i+8>>2];d=0;while(1){if((d|0)==4){break V}g=d<<3;d=d+1|0;g=g+50096|0;if(ab(f,H[g>>2])){continue}break}e=H[e+8>>2];o=I[g+4|0];h=1;break J}a=H[e+8>>2];if(I[a|0]!=167){break K}d=H[a+44>>2];if(I[d+43|0]!=1){break K}d=H[zd(r,d)+8>>2];f=H[H[d>>2]+72>>2];if(!f){break K}o=Ia[f|0](d,2,H[i+8>>2],t,t+12|0)|0;if((o|0)<150){break K}e=H[e+24>>2];h=1;break J}d=H[i+16>>2];h=0;e=H[i+12>>2];if(I[e|0]==167){h=I[H[e+44>>2]+43|0]==1}if(!d){a=e;e=0;break L}if(I[d|0]!=167|I[H[d+44>>2]+43|0]!=1){break M}h=h+1|0;a=d;break L}a=H[b+24>>2]+N(c,48)|0;G[a+12>>1]=8192;G[a+10>>1]=J[a+10>>1]|6;break I}a=e;e=d}o=68;W:{X:{d=f&255;switch(d-51|0){case 0:break X;case 1:break J;default:break W}}o=70;break J}if((d|0)!=171){o=0;break J}o=69;break J}o=0;e=0;a=0}while(1){d=a;a=e;if((h|0)<=0){break I}h=h-1|0;e=Ze(w,e);g=Ha;f=e;e=d;if(f&Ze(w,d)|Ha&g){continue}d=ib(n,46,0,jb(r,a,0));if(!(!(F[i+4|0]&1)|!d)){H[d+4>>2]=H[d+4>>2]|1;H[d+36>>2]=H[i+36>>2]}j=be(b,d,3);m=H[b+24>>2]+N(j,48)|0;d=m;H[d+32>>2]=f;H[d+36>>2]=g;H[d+20>>2]=H[e+28>>2];f=G[e+32>>1];F[d+15|0]=o;G[d+12>>1]=64;H[d+24>>2]=f;pg(b,j,c);d=H[b+24>>2]+N(c,48)|0;G[d+10>>1]=J[d+10>>1]|8;f=H[d+44>>2];H[m+40>>2]=H[d+40>>2];H[m+44>>2]=f;continue}}a=H[b+24>>2]+N(c,48)|0;b=H[a+32>>2];c=C|H[a+36>>2];H[a+32>>2]=b|B;H[a+36>>2]=c}Ea=t+16|0}function Me(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;g=Ea-128|0;Ea=g;f=H[a+8>>2];H[g+60>>2]=0;H[g+56>>2]=0;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{while(1){z:{A:{B:{C:{D:{E:{F:{G:{H:{I:{J:{if(!b){break J}if(!(!H[a+72>>2]|I[b+6|0]&128)){d=a+72|0;while(1){K:{e=-1;h=H[d>>2];if(!h){break K}L:{e=H[h+4>>2];if((e|0)<0){break L}l=H[a+52>>2];M:{if(!l){d=e;break M}d=-1;if((e|0)!=(l-1|0)){break L}}if(cc(0,b,H[h>>2],d)){break L}e=rc(b);N:{if(e>>>0<=65){if(I[h+17|0]!=65){break L}break N}d=I[h+17|0];if((e|0)==66){if((d|0)==66){break N}break L}if((d|0)!=67){break L}}d=H[a+8>>2];if(I[h+16|0]){e=H[d+108>>2];Ua(d,20,H[h+8>>2],e+3|0,c);Ua(d,94,H[h+8>>2],H[h+12>>2],c);Qb(d,0);h=H[a+72>>2];H[a+72>>2]=0;ac(a,b,c);H[a+72>>2]=h;h=H[d+108>>2];H[(I[H[d>>2]+87|0]?73336:(H[d+104>>2]+N(e,20)|0)+40|0)+8>>2]=h;e=c;break K}Ua(d,94,H[h+8>>2],H[h+12>>2],c);e=c;break K}d=h+20|0;continue}break}d=e;if((d|0)>=0){break a}}O:{e=I[b|0];switch(e-102|0){case 74:break j;case 69:break n;case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:break p;case 71:break q;case 12:break r;case 73:break s;case 66:break u;case 70:break v;case 36:break w;case 76:break x;case 72:case 79:break A;case 11:break B;case 75:break D;case 77:break E;case 55:break F;case 65:break H;case 67:break I;case 10:case 13:case 14:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:case 32:case 33:case 34:case 35:case 37:case 38:case 39:case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:case 50:case 56:case 57:case 58:case 59:case 60:case 61:case 62:case 63:case 64:case 78:break J;case 53:break d;case 68:break e;case 51:break f;case 15:break g;case 52:break h;case 54:break i;default:break O}}P:{switch(e-19|0){case 17:break k;case 26:break n;case 33:case 34:case 35:case 36:case 37:case 38:break o;case 24:case 25:break p;case 0:break r;case 31:case 32:break t;case 1:break w;case 30:break y;case 29:break z;case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 9:case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 18:case 19:case 20:case 21:case 22:case 23:case 27:case 28:break J;default:break P}}if((e|0)==71){break G}if((e|0)==77){break C}}Sa(f,75,0,c);break b}e=G[b+34>>1];d=H[b+40>>2];if((e|0)<H[d+24>>2]){if(!I[d|0]){d=e+H[d+12>>2]|0;break a}if(I[d+1|0]){a=H[d+20>>2]+(e<<4)|0;b=H[a>>2];Ua(f,94,H[d+8>>2],G[a+14>>1],c);if(!b){break b}a=G[a+12>>1];if((a|0)<0|I[(H[b+4>>2]+N(a,12)|0)+5|0]!=69){break b}_a(f,87,c);break b}if(H[b+44>>2]){break H}Ua(f,94,H[b+28>>2],G[b+32>>1],c);break b}Sa(f,75,0,c);break l}if(I[b+4|0]&32){d=Me(a,H[b+12>>2],c);a=68;c=G[b+32>>1];Q:{if((c|0)<0){break Q}b=H[b+44>>2];if((c|0)>=G[b+34>>1]){break Q}a=F[(H[b+4>>2]+N(c,12)|0)+5|0];if((a|0)<66){break a}}fb(f,96,d,1,0,(a<<1&254)+49580|0,-1);break a}j=H[b+28>>2];if((j|0)<0){d=H[a+52>>2];if((d|0)<0){e=G[b+32>>1];if((e|0)<0){d=d^-1;break a}j=H[b+44>>2];d=Gc(j,e)-d|0;b=H[j+4>>2]+N(e,12)|0;e=J[b+10>>1];if(e&96){if(e&256){H[g>>2]=H[b>>2];Wa(a,29314,g);d=0;break a}c=e|256;G[b+10>>1]=c;if(e&128){wr(a,j,b,d);c=J[b+10>>1]}G[b+10>>1]=c&65151;break a}if(I[b+5|0]!=69){break a}Sa(f,81,d,c);_a(f,87,c);break b}j=d-1|0;break c}e=H[a+76>>2];if(!e){break c}d=G[b+32>>1];while(1){if(!e){break c}if((d|0)!=H[e+12>>2]|H[e+4>>2]!=(j|0)){e=H[e+20>>2];continue}else{k=H[a+8>>2];if(I[e+16|0]){i=_a(k,20,H[e+8>>2])}d=Me(a,H[e>>2],c);fb(H[a+8>>2],96,d,1,0,e+17|0,1);if(i){e=H[k+108>>2];R:{if(I[H[k>>2]+87|0]){H[18336]=e;i=73336;break R}i=H[k+104>>2]+N(i,20)|0;H[i+8>>2]=e}H[i+12>>2]=d}if(d){break a}break c}}}d=H[a+132>>2];if(!(d|I[a+18|0])){d=0;Wa(a,11498,0);break a}S:{T:{U:{e=I[b+1|0];switch(e-2|0){case 0:break T;case 2:break U;default:break S}}fb(f,70,0,4,0,H[b+8>>2],0);break l}j=H[a+128>>2];F[(j?j:a)+21|0]=1}nh(a,d?1811:1,e<<24>>24,H[b+8>>2],0,0);break l}l=H[b+20>>2];k=H[l>>2];i=H[a+56>>2]-1|0;H[a+56>>2]=i;d=H[a>>2];e=0;h=H[b+12>>2];if(h){m=jb(d,h,0);if(I[d+87|0]){eb(d,m);break l}ZA(m,vr(a,m,g+60|0));j=g+72|0;Xa(j,0,52);H[g+84>>2]=m;F[g+72|0]=53;H[g+60>>2]=0}l=l+8|0;n=k-1|0;while(1){if((e|0)<(n|0)){o=l+(e<<4)|0;b=H[o>>2];V:{if(!h){j=b;break V}H[g+88>>2]=b}b=H[a+56>>2]-1|0;H[a+56>>2]=b;wc(a,j,b,16);ac(a,H[o+16>>2],c);Qb(f,i);hb(f,b);e=e+2|0;continue}break}W:{if(k&1){ac(a,H[l+(n<<4)>>2],c);break W}Sa(f,75,0,c)}eb(d,m);YA(f);hb(f,i);break l}e=I[a+23|0];X:{d=H[b+40>>2];if(!d){break X}if(!I[d|0]){c=H[d+12>>2]+G[b+34>>1]|0;break l}if(!I[d+1|0]){break X}Ua(f,94,H[d+8>>2],G[(H[d+20>>2]+(G[b+34>>1]<<4)|0)+14>>1],c);break l}d=Ua(f,20,H[b+28>>2],0,c);F[a+23|0]=0;ac(a,H[b+12>>2],c);F[a+23|0]=e;e=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(d,20)|0)+8>>2]=e;break l}Wa(a,15609,0);break l}d=H[b+44>>2];e=G[b+32>>1];Sa(f,157,(Gc(d,e)+N(H[b+28>>2],G[d+34>>1]+1|0)|0)+1|0,c);if(I[(H[d+4>>2]+N(e,12)|0)+5|0]!=69|(e|0)<0){break l}_a(f,87,c);break l}if(I[b+5|0]&2){break A}ac(a,H[b+12>>2],c);_a(f,180,c);break b}b=H[b+12>>2];continue}break}ur(a,b,c,0,0);break b}e=H[a+56>>2];d=e-2|0;H[a+56>>2]=d;Sa(f,75,0,c);k=a;a=e-1|0;Um(k,b,a,d);Sa(f,71,1,c);hb(f,a);Sa(f,86,c,0);hb(f,d);break b}c=H[b+12>>2];e=H[c+28>>2];if(!(I[a+26|0]<=I[c+2|0]?e:0)){e=jk(a,c);H[c+28>>2]=e;F[c+2|0]=I[a+26|0]}d=H[b+28>>2];j=Qc(c);if((d|0)!=(j|0)){H[g+52>>2]=j;H[g+48>>2]=d;Wa(a,5325,g+48|0);e=H[c+28>>2]}d=e+G[b+32>>1]|0;break a}d=0;if(I[H[a>>2]+87|0]){break a}Y:{if(!(!(I[b+5|0]&16)|(e|0)!=138)){d=H[H[H[b+20>>2]+28>>2]>>2];if((d|0)!=1){break Y}}d=jk(a,b);break a}sr(a,d,1);break l}if(F[b+7|0]&1){d=H[H[b+44>>2]+56>>2];break a}l=H[a>>2];d=I[l+84|0];Z:{if(!I[a+23|0]){break Z}if(!Tm(b)){break Z}d=Sm(a,b,-1);break a}h=H[b+20>>2];if(h){k=H[h>>2]}_:{$:{aa:{d=Te(l,H[b+8>>2],k,d,0);if(!(!d|H[d+20>>2])){e=H[d+4>>2];if(!(!h|!(e&4194304))){e=H[a+8>>2];ba:{switch(H[d+8>>2]){case 0:b=H[h>>2];d=H[a+56>>2]-1|0;H[a+56>>2]=d;ac(a,H[h+8>>2],c);j=(b|0)<=1?1:b;k=h+8|0;b=1;while(1){if((b|0)!=(j|0)){Sa(e,51,c,d);ac(a,H[k+(b<<4)>>2],c);b=b+1|0;continue}break};YA(e);hb(e,d);break b;case 5:b=g+72|0;Xa(b,0,52);H[g+92>>2]=h;F[g+72|0]=157;d=Me(a,b,c);break a;default:d=Me(a,H[h+8>>2],c);break a;case 3:Sa(e,71,cc(0,H[h+8>>2],H[h+24>>2],-1),c);break b;case 2:Sa(e,71,Rm(a,H[h+8>>2],H[h+24>>2],-1),c);break b;case 1:a=H[h+24>>2];if(I[a|0]==167){Sa(e,71,on(H[h+8>>2],H[a+28>>2],1),c);break b}Sa(e,75,0,c);break b;case 4:break ba}}a=rc(H[h+8>>2]);if((a|0)>=65){a=H[(a<<2)+49468>>2]}else{a=13816}Nc(e,c,a);break b}if(e&2621440){XA(a,b,d)}n=(k|0)>0?k:0;i=h+8|0;e=0;while(1){if((e|0)!=(n|0)){ca:{if(e>>>0>31){break ca}if(!ge(H[(e<<4)+i>>2])){break ca}m=1<<e|m}if(!(!(I[d+4|0]&32)|j)){j=md(a,H[(e<<4)+i>>2])}e=e+1|0;continue}break}da:{if(!h){e=0;break da}ea:{if(m){e=H[a+44>>2];H[a+44>>2]=e+k;e=e+1|0;break ea}e=nc(a,k)}n=H[d+4>>2]&192;fa:{if(!n){break fa}ga:{o=H[i>>2];switch(I[o|0]-167|0){case 0:case 2:break ga;default:break fa}}F[o+2|0]=n}Gf(a,h,e,0,2)}if((k|0)>=2){i=F[b+5|0]&1?h+24|0:i;break aa}if((k|0)==1){break aa}break $}H[g+32>>2]=b;Wa(a,26821,g+32|0);break l}i=H[i>>2];H[g+72>>2]=0;H[g+124>>2]=0;if(!i|I[i|0]!=167){break $}i=H[i+44>>2];if(!i|I[i+43|0]!=1){break $}i=H[zd(l,i)+8>>2];h=H[H[i>>2]+72>>2];if(!h){break $}if(!(Ia[h|0](i,k,H[d+32>>2],g+72|0,g+124|0)|0)){break $}i=nb(l,bb(H[d+32>>2])+41|0,0);if(!i){break $}h=Va(i,d,40);n=h+40|0;H[h+32>>2]=n;d=H[d+32>>2];Va(n,d,bb(d)+1|0);H[h+16>>2]=H[g+72>>2];H[h+8>>2]=H[g+124>>2];H[h+4>>2]=H[h+4>>2]|16;break _}i=d}if(I[i+4|0]&32){if(!j){j=H[l+8>>2]}fb(f,85,0,0,0,j,-2)}ik(a,m,e,c,k,i,I[b+2|0]);if(!k|m){break b}Sc(a,e,k);break b}ha:{d=H[b+40>>2];ia:{if(!d){break ia}e=G[b+34>>1];if((e|0)<0){break ia}if((e|0)<H[d+36>>2]){break ha}}H[g+16>>2]=b;Wa(a,26845,g+16|0);break l}d=H[d+24>>2]+(e+H[d+12>>2]|0)|0;break a}Sa(f,71,1,c);b=_a(f,e,Jc(a,H[b+12>>2],g+60|0));Sa(f,71,0,c);d=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(b,20)|0)+8>>2]=d;break l}e=Jc(a,H[b+12>>2],g+60|0);d=hk(H[b+16>>2]);gb(f,91,e,c,d^1,d^I[b+2|0]==45);break l}Sa(f,e,Jc(a,H[b+12>>2],g+60|0),c);break l}ja:{ka:{la:{d=H[b+12>>2];switch(I[d|0]-153|0){case 0:break ka;case 2:break la;default:break ja}}WA(a,d,1,c);break b}rr(f,H[d+8>>2],1,c);break b}H[g+76>>2]=67584;H[g+80>>2]=0;F[g+72|0]=155;d=Jc(a,g+72|0,g+60|0);Ua(f,107,Jc(a,H[b+12>>2],g+56|0),d,c);break l}d=Jc(a,H[b+12>>2],g+60|0);Ua(f,e,Jc(a,H[b+16>>2],g+56|0),d,c);break l}q=1;d=0;break m}e=(e|0)==45?53:52;m=128;d=1}i=H[b+12>>2];if(Ke(i)){h=H[b+16>>2];d=H[a+8>>2];j=Qc(i);f=H[a+56>>2]-1|0;H[a+56>>2]=f;if(H[a+36>>2]){break l}b=H[b+4>>2];if((Qc(h)|0)!=(j|0)){Wa(a,15609,0);break l}r=b>>>10&1;s=UA(a,i);t=UA(a,h);Sa(d,71,1,c);k=(e|0)==52?53:(e|0)==57?54:(e|0)==55?56:e;u=j-2|0;l=j-1|0;j=0;b=0;while(1){H[g+72>>2]=0;H[g+124>>2]=0;H[g+68>>2]=0;H[g+64>>2]=0;if(j){H[(I[H[d>>2]+87|0]?73336:H[d+104>>2]+N(j,20)|0)+8>>2]=H[d+108>>2]}n=TA(a,i,b,s,g+68|0,g+72|0);o=TA(a,h,b,t,g- -64|0,g+124|0);j=H[d+108>>2];p=k&255;Qm(a,H[g+68>>2],H[g+64>>2],p,n,o,f,m,r);rb(a,H[g+72>>2]);rb(a,H[g+124>>2]);ma:{na:{switch(p-54|0){case 0:case 2:break na;default:break ma}}if((b|0)>=(l|0)){break ma}j=Mb(d,58)}oa:{if(!q){Sa(d,71,0,c);break oa}Ua(d,92,n,c,o)}if((b|0)!=(l|0)){pa:{if((p|0)==53){Sa(d,51,c,f);k=53;break pa}Sa(d,9,0,f);k=(b|0)==(u|0)?e:k}b=b+1|0;continue}break}k=H[d+108>>2];H[(I[H[d>>2]+87|0]?73336:H[d+104>>2]+N(j,20)|0)+8>>2]=k;hb(d,f);if((e|0)!=52){break l}Sa(d,19,c,c);break l}j=Jc(a,i,g+60|0);k=Jc(a,H[b+16>>2],g+56|0);Sa(f,71,1,c);Qm(a,i,H[b+16>>2],e,j,k,H[f+108>>2]+2|0,m,H[b+4>>2]>>>10&1);if(d){Sa(f,71,0,c);break l}Ua(f,92,j,c,k)}d=c;rb(a,H[g+60>>2]);rb(a,H[g+56>>2]);break a}ac(a,H[b+12>>2],c);Sa(f,88,c,Mi(H[b+8>>2],0));break b}d=H[b+28>>2];break a}Sa(f,78,G[b+32>>1],c);if(!I[H[b+8>>2]+1|0]){break b}a=H[a+236>>2];b=kw(a,G[b+32>>1]);H[a>>2]=0;xc(f,b,-1);break b}a=H[b+8>>2]+2|0;b=bb(a)-1|0;fb(f,77,(b|0)/2|0,c,0,_s(H[f>>2],a,b),-6);break b}Nc(f,c,H[b+8>>2]);break b}rr(f,H[b+8>>2],0,c);break b}Sa(f,71,hk(b),c);break b}WA(a,b,0,c);break b}d=I[b+2|0];yd(H[a+8>>2],H[b+44>>2],j,G[b+32>>1],c);if(!d){break b}b=73336;a=H[a+8>>2];if(!I[H[a>>2]+87|0]){b=(H[a+104>>2]+N(H[a+108>>2],20)|0)-20|0}a=I[b|0];if((a|0)!=176){if((a|0)!=94){break b}G[b+2>>1]=d;break b}G[b+2>>1]=d&1}d=c}Ea=g+128|0;return d}function De(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=Ea-16|0;Ea=k;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{if(a>>>0<=244){e=H[18341];h=a>>>0<11?16:a+11&504;a=h>>>3|0;b=e>>>a|0;if(b&3){c=a+((b^-1)&1)|0;b=c<<3;a=b+73404|0;b=H[b+73412>>2];d=H[b+8>>2];k:{if((a|0)==(d|0)){m=73364,n=xJ(-2,c)&e,H[m>>2]=n;break k}H[d+12>>2]=a;H[a+8>>2]=d}a=b+8|0;c=c<<3;H[b+4>>2]=c|3;b=b+c|0;H[b+4>>2]=H[b+4>>2]|1;break a}i=H[18343];if(i>>>0>=h>>>0){break j}if(b){c=2<<a;a=rJ((0-c|c)&b<<a);c=a<<3;b=c+73404|0;c=H[c+73412>>2];d=H[c+8>>2];l:{if((b|0)==(d|0)){e=xJ(-2,a)&e;H[18341]=e;break l}H[d+12>>2]=b;H[b+8>>2]=d}H[c+4>>2]=h|3;g=c+h|0;a=a<<3;f=a-h|0;H[g+4>>2]=f|1;H[a+c>>2]=f;if(i){a=(i&-8)+73404|0;d=H[18346];b=1<<(i>>>3);m:{if(!(b&e)){H[18341]=b|e;b=a;break m}b=H[a+8>>2]}H[a+8>>2]=d;H[b+12>>2]=d;H[d+12>>2]=a;H[d+8>>2]=b}a=c+8|0;H[18346]=g;H[18343]=f;break a}l=H[18342];if(!l){break j}c=H[(rJ(l)<<2)+73668>>2];f=(H[c+4>>2]&-8)-h|0;b=c;while(1){n:{a=H[b+16>>2];if(!a){a=H[b+20>>2];if(!a){break n}}d=(H[a+4>>2]&-8)-h|0;b=d>>>0<f>>>0;f=b?d:f;c=b?a:c;b=a;continue}break}j=H[c+24>>2];a=H[c+12>>2];if((c|0)!=(a|0)){b=H[c+8>>2];H[b+12>>2]=a;H[a+8>>2]=b;break b}b=H[c+20>>2];if(b){d=c+20|0}else{b=H[c+16>>2];if(!b){break i}d=c+16|0}while(1){g=d;a=b;d=a+20|0;b=H[a+20>>2];if(b){continue}d=a+16|0;b=H[a+16>>2];if(b){continue}break}H[g>>2]=0;break b}h=-1;if(a>>>0>4294967231){break j}b=a+11|0;h=b&-8;g=H[18342];if(!g){break j}i=31;f=0-h|0;if(a>>>0<=16777204){a=Q(b>>>8|0);i=((h>>>38-a&1)-(a<<1)|0)+62|0}b=H[(i<<2)+73668>>2];o:{p:{q:{if(!b){a=0;break q}a=0;c=h<<((i|0)!=31?25-(i>>>1|0)|0:0);while(1){r:{e=(H[b+4>>2]&-8)-h|0;if(e>>>0>=f>>>0){break r}d=b;f=e;if(f){break r}f=0;a=b;break p}e=H[b+20>>2];b=H[((c>>>29&4)+b|0)+16>>2];a=e?(e|0)==(b|0)?a:e:a;c=c<<1;if(b){continue}break}}if(!(a|d)){d=0;a=2<<i;a=(0-a|a)&g;if(!a){break j}a=H[(rJ(a)<<2)+73668>>2]}if(!a){break o}}while(1){c=(H[a+4>>2]&-8)-h|0;b=c>>>0<f>>>0;f=b?c:f;d=b?a:d;b=H[a+16>>2];if(b){a=b}else{a=H[a+20>>2]}if(a){continue}break}}if(!d|H[18343]-h>>>0<=f>>>0){break j}i=H[d+24>>2];a=H[d+12>>2];if((d|0)!=(a|0)){b=H[d+8>>2];H[b+12>>2]=a;H[a+8>>2]=b;break c}b=H[d+20>>2];if(b){c=d+20|0}else{b=H[d+16>>2];if(!b){break h}c=d+16|0}while(1){e=c;a=b;c=a+20|0;b=H[a+20>>2];if(b){continue}c=a+16|0;b=H[a+16>>2];if(b){continue}break}H[e>>2]=0;break c}d=H[18343];if(d>>>0>=h>>>0){a=H[18346];b=d-h|0;s:{if(b>>>0>=16){c=a+h|0;H[c+4>>2]=b|1;H[a+d>>2]=b;H[a+4>>2]=h|3;break s}H[a+4>>2]=d|3;b=a+d|0;H[b+4>>2]=H[b+4>>2]|1;c=0;b=0}H[18343]=b;H[18346]=c;a=a+8|0;break a}c=H[18344];if(c>>>0>h>>>0){b=c-h|0;H[18344]=b;a=H[18347];c=a+h|0;H[18347]=c;H[c+4>>2]=b|1;H[a+4>>2]=h|3;a=a+8|0;break a}a=0;f=h+47|0;if(H[18459]){b=H[18461]}else{H[18462]=-1;H[18463]=-1;H[18460]=4096;H[18461]=4096;H[18459]=k+12&-16^1431655768;H[18464]=0;H[18452]=0;b=4096}e=f+b|0;g=0-b|0;b=e&g;if(b>>>0<=h>>>0){break a}i=H[18451];if(i){j=H[18449];d=j+b|0;if(d>>>0<=j>>>0|d>>>0>i>>>0){break a}}t:{if(!(I[73808]&4)){u:{v:{w:{x:{d=H[18347];if(d){a=73812;while(1){i=H[a>>2];if(i>>>0<=d>>>0&d>>>0<i+H[a+4>>2]>>>0){break x}a=H[a+8>>2];if(a){continue}break}}c=ai(0);if((c|0)==-1){break u}e=b;a=H[18460];d=a-1|0;if(d&c){e=(b-c|0)+(c+d&0-a)|0}if(e>>>0<=h>>>0){break u}d=H[18451];if(d){g=H[18449];a=g+e|0;if(a>>>0<=g>>>0|a>>>0>d>>>0){break u}}a=ai(e);if((c|0)!=(a|0)){break w}break t}e=g&e-c;c=ai(e);if((c|0)==(H[a>>2]+H[a+4>>2]|0)){break v}a=c}if((a|0)==-1){break u}if(h+48>>>0<=e>>>0){c=a;break t}c=H[18461];c=c+(f-e|0)&0-c;if((ai(c)|0)==-1){break u}e=c+e|0;c=a;break t}if((c|0)!=-1){break t}}H[18452]=H[18452]|4}c=ai(b);a=ai(0);if((c|0)==-1|(a|0)==-1|a>>>0<=c>>>0){break e}e=a-c|0;if(e>>>0<=h+40>>>0){break e}}a=H[18449]+e|0;H[18449]=a;if(a>>>0>K[18450]){H[18450]=a}y:{f=H[18347];if(f){a=73812;while(1){b=H[a>>2];d=H[a+4>>2];if((b+d|0)==(c|0)){break y}a=H[a+8>>2];if(a){continue}break}break g}a=H[18345];if(!(a>>>0<=c>>>0?a:0)){H[18345]=c}a=0;H[18454]=e;H[18453]=c;H[18349]=-1;H[18350]=H[18459];H[18456]=0;while(1){b=a<<3;d=b+73404|0;H[b+73412>>2]=d;H[b+73416>>2]=d;a=a+1|0;if((a|0)!=32){continue}break}a=e-40|0;b=-8-c&7;d=a-b|0;H[18344]=d;b=b+c|0;H[18347]=b;H[b+4>>2]=d|1;H[(a+c|0)+4>>2]=40;H[18348]=H[18463];break f}if(H[a+12>>2]&8|(c>>>0<=f>>>0|b>>>0>f>>>0)){break g}H[a+4>>2]=d+e;a=-8-f&7;b=a+f|0;H[18347]=b;c=H[18344]+e|0;a=c-a|0;H[18344]=a;H[b+4>>2]=a|1;H[(c+f|0)+4>>2]=40;H[18348]=H[18463];break f}a=0;break b}a=0;break c}if(K[18345]>c>>>0){H[18345]=c}d=c+e|0;a=73812;z:{while(1){b=H[a>>2];if((b|0)!=(d|0)){a=H[a+8>>2];if(a){continue}break z}break}if(!(I[a+12|0]&8)){break d}}a=73812;while(1){A:{b=H[a>>2];if(b>>>0<=f>>>0){d=b+H[a+4>>2]|0;if(d>>>0>f>>>0){break A}}a=H[a+8>>2];continue}break}a=e-40|0;b=-8-c&7;g=a-b|0;H[18344]=g;b=b+c|0;H[18347]=b;H[b+4>>2]=g|1;H[(a+c|0)+4>>2]=40;H[18348]=H[18463];a=(d+(39-d&7)|0)-47|0;b=a>>>0<f+16>>>0?f:a;H[b+4>>2]=27;a=H[18456];H[b+16>>2]=H[18455];H[b+20>>2]=a;a=H[18454];H[b+8>>2]=H[18453];H[b+12>>2]=a;H[18455]=b+8;H[18454]=e;H[18453]=c;H[18456]=0;a=b+24|0;while(1){H[a+4>>2]=7;c=a+8|0;a=a+4|0;if(c>>>0<d>>>0){continue}break}if((b|0)==(f|0)){break f}H[b+4>>2]=H[b+4>>2]&-2;c=b-f|0;H[f+4>>2]=c|1;H[b>>2]=c;B:{if(c>>>0<=255){a=(c&-8)+73404|0;b=H[18341];c=1<<(c>>>3);C:{if(!(b&c)){H[18341]=b|c;b=a;break C}b=H[a+8>>2]}H[a+8>>2]=f;H[b+12>>2]=f;d=8;c=12;break B}a=31;if(c>>>0<=16777215){a=Q(c>>>8|0);a=((c>>>38-a&1)-(a<<1)|0)+62|0}H[f+28>>2]=a;H[f+16>>2]=0;H[f+20>>2]=0;b=(a<<2)+73668|0;D:{d=H[18342];e=1<<a;E:{if(!(d&e)){H[18342]=d|e;H[b>>2]=f;break E}a=c<<((a|0)!=31?25-(a>>>1|0)|0:0);d=H[b>>2];while(1){b=d;if((c|0)==(H[b+4>>2]&-8)){break D}d=a>>>29|0;a=a<<1;e=(d&4)+b|0;d=H[e+16>>2];if(d){continue}break}H[e+16>>2]=f}H[f+24>>2]=b;b=f;a=b;d=12;c=8;break B}a=H[b+8>>2];H[a+12>>2]=f;H[b+8>>2]=f;H[f+8>>2]=a;a=0;d=12;c=24}H[d+f>>2]=b;H[c+f>>2]=a}a=H[18344];if(a>>>0<=h>>>0){break e}b=a-h|0;H[18344]=b;a=H[18347];c=a+h|0;H[18347]=c;H[c+4>>2]=b|1;H[a+4>>2]=h|3;a=a+8|0;break a}H[18340]=48;a=0;break a}H[a>>2]=c;H[a+4>>2]=H[a+4>>2]+e;i=(-8-c&7)+c|0;H[i+4>>2]=h|3;e=b+(-8-b&7)|0;f=h+i|0;g=e-f|0;F:{if(H[18347]==(e|0)){H[18347]=f;a=H[18344]+g|0;H[18344]=a;H[f+4>>2]=a|1;break F}if(H[18346]==(e|0)){H[18346]=f;a=H[18343]+g|0;H[18343]=a;H[f+4>>2]=a|1;H[a+f>>2]=a;break F}a=H[e+4>>2];if((a&3)==1){j=a&-8;c=H[e+12>>2];G:{if(a>>>0<=255){b=H[e+8>>2];if((b|0)==(c|0)){m=73364,n=H[18341]&xJ(-2,a>>>3|0),H[m>>2]=n;break G}H[b+12>>2]=c;H[c+8>>2]=b;break G}h=H[e+24>>2];H:{if((c|0)!=(e|0)){a=H[e+8>>2];H[a+12>>2]=c;H[c+8>>2]=a;break H}I:{a=H[e+20>>2];if(a){b=e+20|0}else{a=H[e+16>>2];if(!a){break I}b=e+16|0}while(1){d=b;c=a;b=a+20|0;a=H[a+20>>2];if(a){continue}b=c+16|0;a=H[c+16>>2];if(a){continue}break}H[d>>2]=0;break H}c=0}if(!h){break G}a=H[e+28>>2];b=(a<<2)+73668|0;J:{if(H[b>>2]==(e|0)){H[b>>2]=c;if(c){break J}m=73368,n=H[18342]&xJ(-2,a),H[m>>2]=n;break G}H[h+(H[h+16>>2]==(e|0)?16:20)>>2]=c;if(!c){break G}}H[c+24>>2]=h;a=H[e+16>>2];if(a){H[c+16>>2]=a;H[a+24>>2]=c}a=H[e+20>>2];if(!a){break G}H[c+20>>2]=a;H[a+24>>2]=c}g=g+j|0;e=e+j|0;a=H[e+4>>2]}H[e+4>>2]=a&-2;H[f+4>>2]=g|1;H[f+g>>2]=g;if(g>>>0<=255){a=(g&-8)+73404|0;b=H[18341];c=1<<(g>>>3);K:{if(!(b&c)){H[18341]=b|c;b=a;break K}b=H[a+8>>2]}H[a+8>>2]=f;H[b+12>>2]=f;H[f+12>>2]=a;H[f+8>>2]=b;break F}c=31;if(g>>>0<=16777215){a=Q(g>>>8|0);c=((g>>>38-a&1)-(a<<1)|0)+62|0}H[f+28>>2]=c;H[f+16>>2]=0;H[f+20>>2]=0;a=(c<<2)+73668|0;L:{b=H[18342];d=1<<c;M:{if(!(b&d)){H[18342]=b|d;H[a>>2]=f;break M}c=g<<((c|0)!=31?25-(c>>>1|0)|0:0);b=H[a>>2];while(1){a=b;if((H[a+4>>2]&-8)==(g|0)){break L}b=c>>>29|0;c=c<<1;d=(b&4)+a|0;b=H[d+16>>2];if(b){continue}break}H[d+16>>2]=f}H[f+24>>2]=a;H[f+12>>2]=f;H[f+8>>2]=f;break F}b=H[a+8>>2];H[b+12>>2]=f;H[a+8>>2]=f;H[f+24>>2]=0;H[f+12>>2]=a;H[f+8>>2]=b}a=i+8|0;break a}N:{if(!i){break N}b=H[d+28>>2];c=(b<<2)+73668|0;O:{if(H[c>>2]==(d|0)){H[c>>2]=a;if(a){break O}g=xJ(-2,b)&g;H[18342]=g;break N}H[i+(H[i+16>>2]==(d|0)?16:20)>>2]=a;if(!a){break N}}H[a+24>>2]=i;b=H[d+16>>2];if(b){H[a+16>>2]=b;H[b+24>>2]=a}b=H[d+20>>2];if(!b){break N}H[a+20>>2]=b;H[b+24>>2]=a}P:{if(f>>>0<=15){a=f+h|0;H[d+4>>2]=a|3;a=a+d|0;H[a+4>>2]=H[a+4>>2]|1;break P}H[d+4>>2]=h|3;e=d+h|0;H[e+4>>2]=f|1;H[f+e>>2]=f;if(f>>>0<=255){a=(f&-8)+73404|0;b=H[18341];c=1<<(f>>>3);Q:{if(!(b&c)){H[18341]=b|c;b=a;break Q}b=H[a+8>>2]}H[a+8>>2]=e;H[b+12>>2]=e;H[e+12>>2]=a;H[e+8>>2]=b;break P}a=31;if(f>>>0<=16777215){a=Q(f>>>8|0);a=((f>>>38-a&1)-(a<<1)|0)+62|0}H[e+28>>2]=a;H[e+16>>2]=0;H[e+20>>2]=0;b=(a<<2)+73668|0;R:{c=1<<a;S:{if(!(c&g)){H[18342]=c|g;H[b>>2]=e;H[e+24>>2]=b;break S}a=f<<((a|0)!=31?25-(a>>>1|0)|0:0);b=H[b>>2];while(1){c=b;if((H[b+4>>2]&-8)==(f|0)){break R}g=a>>>29|0;a=a<<1;g=b+(g&4)|0;b=H[g+16>>2];if(b){continue}break}H[g+16>>2]=e;H[e+24>>2]=c}H[e+12>>2]=e;H[e+8>>2]=e;break P}a=H[c+8>>2];H[a+12>>2]=e;H[c+8>>2]=e;H[e+24>>2]=0;H[e+12>>2]=c;H[e+8>>2]=a}a=d+8|0;break a}T:{if(!j){break T}b=H[c+28>>2];d=(b<<2)+73668|0;U:{if(H[d>>2]==(c|0)){H[d>>2]=a;if(a){break U}m=73368,n=xJ(-2,b)&l,H[m>>2]=n;break T}H[j+(H[j+16>>2]==(c|0)?16:20)>>2]=a;if(!a){break T}}H[a+24>>2]=j;b=H[c+16>>2];if(b){H[a+16>>2]=b;H[b+24>>2]=a}b=H[c+20>>2];if(!b){break T}H[a+20>>2]=b;H[b+24>>2]=a}V:{if(f>>>0<=15){a=f+h|0;H[c+4>>2]=a|3;a=a+c|0;H[a+4>>2]=H[a+4>>2]|1;break V}H[c+4>>2]=h|3;g=c+h|0;H[g+4>>2]=f|1;H[f+g>>2]=f;if(i){a=(i&-8)+73404|0;d=H[18346];b=1<<(i>>>3);W:{if(!(b&e)){H[18341]=b|e;b=a;break W}b=H[a+8>>2]}H[a+8>>2]=d;H[b+12>>2]=d;H[d+12>>2]=a;H[d+8>>2]=b}H[18346]=g;H[18343]=f}a=c+8|0}Ea=k+16|0;return a|0}function zn(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0;q=Ea-80|0;Ea=q;M=H[a>>2];a:{if(H[a+36>>2]){break a}i=rh(a,b);if(!i){break a}u=Fb(H[a>>2],H[i+60>>2]);D=ui(a,i,129,c,q+40|0);l=H[b>>2]>=2?H[c>>2]:l;O=I[i+43|0];if(cf(a,i)){break a}if(dn(a,i,D)){break a}v=H[a+40>>2];C=v+1|0;H[a+40>>2]=C;if(I[i+28|0]&128){s=jc(i)}g=C;m=v;E=i+8|0;r=E;while(1){j=H[r>>2];if(j){h=g+1|0;H[a+40>>2]=h;m=(j|0)==(s|0)?g:m;V=V+1|0;r=j+20|0;g=h;continue}break}if(f){C=H[f+44>>2];m=H[f+40>>2];H[a+40>>2]=v}H[b+48>>2]=m;r=Nb(M,((G[i+34>>1]+V<<2)+V|0)+6|0,0);if(!r){r=0;break a}g=0;Q=(G[i+34>>1]<<2)+r|0;o=Q+(V<<2)|0;R=V+1|0;W=Xa(o+4|0,1,R);F[W+R|0]=0;h=G[i+34>>1];h=(h|0)>0?h:0;while(1){if((g|0)!=(h|0)){H[(g<<2)+r>>2]=-1;g=g+1|0;continue}break}h=q- -64|0;H[h>>2]=0;H[h+4>>2]=0;H[q+72>>2]=0;H[q+76>>2]=0;H[q+56>>2]=0;H[q+60>>2]=0;H[q+52>>2]=f;H[q+48>>2]=b;H[q+44>>2]=a;H[q+68>>2]=512;k=wb(a);if(!k){break a}Z=c+8|0;t=-1;j=0;while(1){b:{c:{d:{if(H[c>>2]>(j|0)){h=(j<<4)+Z|0;p=Cg(H[h+4>>2]);if(!l){if(cd(q+44|0,H[h>>2])){break a}}g=0;n=G[i+34>>1];y=(n|0)>0?n:0;while(1){if((g|0)!=(y|0)){e:{n=H[i+4>>2]+N(g,12)|0;if((p|0)!=I[n+7|0]){break e}x=H[n>>2];if(ab(x,H[h+4>>2])){break e}if(G[i+32>>1]==(g|0)){X=H[h>>2];S=1;t=j;break c}if(!s){h=J[n+10>>1];break d}h=J[n+10>>1];if(!(h&1)){break d}ba=1;break c}g=g+1|0;continue}break}g=H[h+4>>2];f:{if(s){break f}if(!fj(g)){break f}X=H[h>>2];x=20349;S=1;g=-1;t=j;break b}H[q>>2]=g;Wa(a,7915,q);F[a+17|0]=1;break a}_=S+ba|0;g:{if(!(I[i+28|0]&96)){break g}h=0;g=0;while(1){j=h;h:{if(G[i+34>>1]>(g|0)){j=(g<<2)+r|0;if(H[j>>2]>=0){break h}n=H[i+4>>2]+N(g,12)|0;if(!(I[n+10|0]&96)){break h}if(!ok(Mc(i,n),r,S)){break h}H[j>>2]=99999;h=1;break h}h=0;g=0;if(j){continue}break g}g=g+1|0;continue}}h=I[i+43|0]==1;H[b+56>>2]=h?-1:0;H[b+60>>2]=h?-1:0;$=_&255;K=ti(a,i,r,$);n=($|0)!=0|(K|0)>1;x=o+5|0;y=(e|0)==5;o=(e|0)!=11;while(1){i:{j:{k:{l:{m:{n:{o:{p:{h=H[E>>2];if(h){if(n|(h|0)==(s|0)){break p}j=H[h+36>>2];if(j){if(ok(j,r,S)){break p}}g=0;while(1){if(J[h+50>>1]<=g>>>0){break j}j=G[H[h+4>>2]+(g<<1)>>1];q:{if((j|0)>=0){j=(H[(j<<2)+r>>2]^-1)>>>31|0;break q}j=ok(H[(H[h+40>>2]+(g<<4)|0)+8>>2],r,S)}g=g+1|0;if(!j){continue}break}g=H[a+44>>2]+1|0;H[a+44>>2]=g+J[h+52>>1];if(o){break k}y=I[h+54|0]==5?1:y;break k}H[q+36>>2]=y;h=H[a+44>>2]+1|0;H[a+44>>2]=h;ca=(z<<2)+Q|0;H[ca>>2]=h;if(y){Xa(W,1,R)}if(!I[a+18|0]){G[k+152>>1]=J[k+152>>1]|16}o=0;kd(a,(D|K)!=0,u);j=0;z=0;g=I[i+43|0];if((g|0)!=1){j=H[a+44>>2];o=j+1|0;T=H[ca>>2];r:{if(!(D|ba)){x=o;if(!K){break r}}z=j+2|0;x=G[i+34>>1]+o|0}h=x;j=h+1|0;h=_&255|D|K;n=h?j:x;H[a+44>>2]=n+G[i+34>>1];P=h?j:o;j=n+1|0}s:{t:{u:{if((O|0)!=2){h=0;R=0;E=0;x=0;if(!l){break u}break s}h=H[a+260>>2];H[a+260>>2]=H[i>>2];E=0;if(l){x=a;break t}Kr(a,i,d,m);x=a}if(cd(q+44|0,d)){R=h;break l}g=I[i+43|0];E=1}R=h}if((g&255)==1){j=H[a+8>>2];m=H[a>>2];v=zd(m,i);f=H[b+48>>2];h=G[i+34>>1];n=H[a+40>>2];H[a+40>>2]=n+1;u=h+2|0;l=Sa(j,118,n,u);h=H[a+44>>2];p=h+u|0;H[a+44>>2]=p;t=h+1|0;v:{w:{x:{y:{if(H[b>>2]>=2){z:{if(!(I[i+28|0]&128)){if(X){s=0;f=jb(m,X,0);break z}s=0;f=ib(a,75,0,0);break z}s=jc(i);f=G[H[s+4>>2]>>1];h=H[(f<<2)+r>>2];if((h|0)>=0){f=jb(m,H[(h<<4)+Z>>2],0);break z}f=nk(a,f)}z=Yc(H[a>>2],f);g=0;while(1){if(G[i+34>>1]<=(g|0)){break y}f=H[(g<<2)+r>>2];A:{if((f|0)>=0){h=jb(m,H[(f<<4)+Z>>2],0);break A}h=nk(a,g);if(!h){h=0;break A}F[h+2|0]=1}g=g+1|0;z=Pb(a,z,h);continue}}C=p+2|0;H[a+44>>2]=C;o=bf(a,b,d,0,0,0,4,0);if(!o){break l}m=h+3|0;g=0;while(1){if((g|0)<G[i+34>>1]){A=H[(g<<2)+r>>2];B:{if((A|0)>=0){ac(a,H[(A<<4)+Z>>2],g+m|0);break B}Ua(j,176,f,g,g+m|0);A=H[j+108>>2];if((A|0)<=0){break B}G[(H[j+104>>2]+N(A,20)|0)-18>>1]=1}g=g+1|0;continue}break}C:{if(!(I[i+28|0]&128)){Sa(j,135,f,t);h=h+2|0;if(X){ac(a,X,h);break C}Sa(j,135,f,h);break C}g=G[H[jc(i)+4>>2]>>1];Ua(j,176,f,g,t);Sa(j,81,g+m|0,h+2|0)}if(I[o+46|0]){break w}f=H[a+128>>2];F[(f?f:a)+20|0]=1;f=p+1|0;Ua(j,97,t,u,f);Sa(j,127,n,C);Ua(j,128,n,f,C);break x}Jr(a,n,s,z,b,d);pb(m,z);o=0}if(H[b>>2]==1){vd(o)}g=0;f=(u|0)>0?u:0;l=_a(j,36,n);while(1)if((f|0)==(g|0)){f=1;break v}else{Ua(j,94,n,g,g+t|0);g=g+1|0;continue}}de(j,l);_a(j,122,f);f=0}cn(a,i);fb(j,7,0,u,t,v,-11);h=H[j+108>>2];if((h|0)>0){G[(H[j+104>>2]+N(h,20)|0)-18>>1]=(e|0)==11?2:e}e=H[a+128>>2];F[(e?e:a)+21|0]=1;if(f){Sa(j,39,n,l+1|0);e=H[j+108>>2];H[(I[H[j>>2]+87|0]?73336:H[j+104>>2]+N(l,20)|0)+8>>2]=e;Sa(j,122,n,0);break l}vd(o);break l}u=H[a+56>>2]-1|0;H[a+56>>2]=u;if(!(H[a+132>>2]|!(F[M+36|0]&1)|(I[a+159|0]|(I[a+18|0]|f)))){Y=H[a+44>>2]+1|0;H[a+44>>2]=Y;Sa(k,71,0,Y)}D:{E:{F:{G:{H:{I:{J:{if(!(!E|I[i+28|0]&128)){h=0;Ua(k,75,0,T,o);w=H[a+40>>2];H[a+40>>2]=w+1;aa=Ua(k,118,w,0,T);n=0;break J}h=H[a+44>>2];A=s?J[s+50>>1]:0;B=A<<16>>16;p=h+B|0;n=(p+l|0)+1|0;H[a+44>>2]=n;h=h+1|0;if(f){break I}g=0;g=(O|0)==2?G[i+34>>1]:g;w=H[a+40>>2];H[a+40>>2]=w+1;if(s){Ua(k,75,0,h,p)}p=(l+B|0)+g|0;aa=Sa(k,118,w,p);K:{if(!s){break K}g=uk(a,s);if(!g){break K}G[g+8>>1]=p;xc(k,g,-8)}if(E){break J}Jr(a,w,s,c,b,d);m=(O|0)==2?w:m}if(!l){break G}B=A<<16>>16;break H}if(!l){break F}}y=1;g=H[a+128>>2];F[(g?g:a)+20|0]=1;p=0;da=1;n=h;break m}if(!f){break E}}wc(a,d,u,16);p=1;break D}g=4;if(!(y|D|(_&255|(I[a+18|0]|K))|(I[d+6|0]&64?d:0))){g=12}U=bf(a,b,d,0,0,0,g,C);if(!U){break l}p=1;da=F[U+48|0]&1;l=H[U+24>>2];L=H[U+20>>2];g=I[U+46|0];if((g|0)==1){break D}p=H[a+128>>2];F[(p?p:a)+20|0]=1;p=2;if((g|0)!=2){p=g;break D}if((l|0)==(m|0)|(l|0)<0){break D}p=!I[(l-v|0)+W|0]<<1}L:{M:{if(I[i+28|0]&128){g=0;B=A<<16>>16;y=(B|0)>0?B:0;while(1){if((g|0)==(y|0)){break M}yd(k,i,m,G[H[s+4>>2]+(g<<1)>>1],g+h|0);g=g+1|0;continue}}Sa(k,135,m,o);if(!p){g=H[a+44>>2]+1|0;H[a+44>>2]=g;H[ca>>2]=g;Ua(k,128,w,T,o);break L}if(!aa){break n}de(k,aa);break n}if(p){y=0;if(!aa){break o}de(k,aa);break o}fb(k,97,h,B,n,jh(M,s),B);gb(k,138,w,n,h,B)}p=0;break n}g=H[a+44>>2]+1|0;H[a+44>>2]=g+J[h+52>>1];break k}n=h;break m}y=0;B=0}T=0;N:{if(f){l=u;break N}if((p|0)!=2&E){vd(U)}O:{if((O|0)==2){break O}g=0;P:{if(!p){break P}if((L|0)>=0){F[(L-v|0)+W|0]=0}if((l|0)>=0){F[(l-v|0)+W|0]=0}g=0;if((p|0)!=2|(((l^-1)>>31)+V|0)<=0){break P}g=Mb(k,15)}sk(a,i,113,0,v,W,q+32|0,q+28|0);if(!g){break O}rk(k,g)}if(p){if(!((m|0)==(L|0)|(l|0)==(m|0))){gb(k,28,m,u,n,B)}l=u;if((p|0)!=1){l=H[a+56>>2]-1|0;H[a+56>>2]=l}Sa(k,50,s?n:o,u);break N}if(!(!s&(y^1))){l=H[a+56>>2]-1|0;H[a+56>>2]=l;Sa(k,36,w,u);T=H[k+108>>2];if(y){if((O|0)==2){break N}if(s){g=0;v=A<<16>>16;L=(v|0)>0?v:0;while(1){if((g|0)!=(L|0)){Ua(k,94,w,g,g+h|0);g=g+1|0;continue}break}gb(k,28,m,l,h,v);break N}Sa(k,135,w,o);Ua(k,31,m,l,o);break N}Sa(k,134,w,n);gb(k,28,m,l,n,0);break N}Sa(k,36,w,u);l=H[a+56>>2]-1|0;H[a+56>>2]=l;T=Sa(k,135,w,o);Ua(k,31,m,l,o)}if(S){Q:{if(E){ac(a,X,P);break Q}Ua(k,94,w,t,P)}_a(k,13,P)}R:{if(!(D|ba|K)){break R}g=0;if(K){h=Ir(a,i)}else{h=g}v=h|an(a,D,c,0,3,i,e);L=(v|0)==-1;while(1){S:{T:{if(G[i+34>>1]>(g|0)){h=J[(H[i+4>>2]+N(g,12)|0)+10>>1];t=Gc(i,g<<16>>16)+z|0;U:{if(L){break U}if(g>>>0<=31){if(v>>>g&1|h&1){break U}break T}if(!(h&1)){break T}}yd(k,i,m,g,t);break S}if(s|S){break R}Sa(k,80,o,P);break R}Sa(k,75,0,t)}g=g+1|0;continue}}v=A<<16>>16;A=an(a,D,c,1,1,i,e);L=(O|0)==2;h=j;g=0;while(1){z=G[i+34>>1];if((g|0)<(z|0)){V:{if(G[i+32>>1]==(g|0)){Sa(k,75,0,h);break V}t=J[(H[i+4>>2]+N(g,12)|0)+10>>1];if(t&96){h=(t<<26>>31)+h|0;break V}t=H[(g<<2)+r>>2];if((t|0)>=0){if(y){Ua(k,94,w,t+(L?z:v)|0,h);break V}ac(a,H[(t<<4)+Z>>2],h);break V}if(A>>>g&1|(!(H[q+40>>2]&1)|g>>>0>31)){yd(k,i,m,g,h);da=0;break V}Sa(k,75,0,h)}h=h+1|0;g=g+1|0;continue}break}if(I[i+28|0]&96){mk(a,j,i)}W:{X:{if(!(F[q+40|0]&1)){break X}yg(k,i,j);si(a,D,129,c,1,i,o,e,l);if((O|0)==2){break W}Y:{if(s){gb(k,28,m,l,n,B);break Y}Ua(k,31,m,l,o)}g=0;h=j;while(1){if((g|0)<G[i+34>>1]){t=J[(H[i+4>>2]+N(g,12)|0)+10>>1];Z:{if(t&96){h=(t<<26>>31)+h|0;break Z}if(G[i+32>>1]==(g|0)|H[(g<<2)+r>>2]>=0){break Z}yd(k,i,m,g,h)}h=h+1|0;g=g+1|0;continue}break}if(!(I[i+28|0]&96)){break X}mk(a,j,i)}if((O|0)==2){break W}h=_&255;qB(a,i,Q,m,C,P,o,h,e&255,l,q+36|0,r,0);_:{if(!(h|H[q+36>>2])){break _}if(s){gb(k,28,m,l,n,B);break _}Ua(k,31,m,l,o)}if(K){$m(a,i,o,0,r,$)}Gr(a,i,m,C,Q,-1);if(da){_a(k,143,m)}if(!(!(_&255)&(K|0)<=1)){Sa(k,130,m,0)}if(K){$m(a,i,0,P,r,$);Fr(a,i,m,C,P,Q,(p|0)==2?6:4,0,0);pB(a,i,c,o,r,$);break W}Fr(a,i,m,C,P,Q,(p|0)==2?6:4,0,0)}if(Y){Sa(k,86,Y,1)}if(D){si(a,D,129,c,2,i,o,e,l)}$:{aa:{switch(p-1|0){case 1:hb(k,l);vd(U);break $;case 0:break $;default:break aa}}hb(k,l);Sa(k,39,w,T)}hb(k,u);if(!(I[a+18|0]|(H[a+132>>2]|f))){pk(a)}if(!Y){break l}bn(k,Y,15588)}if(!x){break a}H[x+260>>2]=R;break a}if(g){break i}}g=0;F[z+x|0]=0}H[(z<<2)+Q>>2]=g;z=z+1|0;E=h+20|0;continue}}if(!(h&96)){break c}H[q+16>>2]=x;Wa(a,29416,q+16|0);break a}H[(g<<2)+r>>2]=j}ba:{switch(Yb(a,23,H[i>>2],x,H[H[M+16>>2]+(u<<4)>>2])-1|0){case 1:H[(g<<2)+r>>2]=-1;break;case 0:break a;default:break ba}}j=j+1|0;continue}}Za(M,r);Cc(M,b);pb(M,c);eb(M,d);Ea=q+80|0}function cJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0;h=Ea-240|0;Ea=h;d=H[a>>2];o=H[d>>2];r=H[b+4>>2];H[b+4>>2]=r|64;j=2;a:{if(I[o+87|0]){break a}if(r&64){j=1;break a}if(J[a+20>>1]){c=H[d+108>>2]+1|0;H[d+108>>2]=c;H[b+16>>2]=c}c=H[b+64>>2];z=H[b+28>>2];x=H[b+32>>2];b:{c:{if(!(!H[d+276>>2]|!(r&2097152))){if(!c){c=nb(o,36,0);H[b+64>>2]=c;if(!c){break a}}H[c+4>>2]=1;break c}if(!c){break b}}if(H[d+36>>2]){break b}H[c+8>>2]=H[d+276>>2];H[d+276>>2]=c}wk(d,x);A=x+8|0;e=A;while(1){d:{e:{f:{g:{h:{i:{j:{k:{if(H[x>>2]>(k|0)){if(H[e+16>>2]){break e}f=H[e+8>>2];if(!f){if(ec(a,H[e+20>>2])){break a}c=H[e+20>>2];f=nb(H[d>>2],64,0);H[e+16>>2]=f;if(!f){break a}H[f+24>>2]=1;i=H[d>>2];g=H[e+12>>2];l:{if(g){i=Tb(i,g);break l}H[h>>2]=e;i=mb(i,19357,h)}H[f>>2]=i;while(1){i=c;c=H[c+52>>2];if(c){continue}break}Jm(d,H[i+28>>2],f+34|0,f+4|0);G[f+38>>1]=200;G[f+32>>1]=65535;H[f+28>>2]=H[f+28>>2]|16896;if(!H[d+36>>2]){break g}break a}m:{p=H[d+276>>2];if(H[d+36>>2]|!p|(H[e+4>>2]|I[e+38|0]&2)){break m}while(1){if(!p){break m}c=0;i=H[p>>2];i=(i|0)>0?i:0;g=p+12|0;n:{o:{while(1){if((c|0)==(i|0)){break o}n=N(c,24);c=c+1|0;n=g+n|0;j=H[n>>2];if(ab(f,j)){continue}break}c=H[n+12>>2];if(!c){break n}H[h+112>>2]=j;Wa(d,c,h+112|0);break f}if(H[p+4>>2]){break m}p=H[p+8>>2];continue}break}c=H[d>>2];j=2;if(rA(d,e)){break a}l=nb(c,64,0);if(!l){break a}g=H[n+16>>2];if(!g){g=nb(c,20,0);H[n+16>>2]=g;p:{if(g){if(id(d,52,g)){break p}}db(c,l);break a}F[g+18|0]=I[n+20|0]}H[e+16>>2]=l;H[l+24>>2]=1;f=Tb(c,H[n>>2]);G[l+38>>1]=200;G[l+32>>1]=65535;H[l>>2]=f;H[l+28>>2]=H[l+28>>2]|16896;f=Ud(c,H[n+8>>2],0);H[e+20>>2]=f;if(I[c+87|0]){break a}H[f+4>>2]=H[f+4>>2]|67108864;c=I[e+37|0]|I[e+38|0]<<8;if(c&2){H[h+96>>2]=H[e+56>>2];Wa(d,29640,h+96|0);break a}H[e+60>>2]=g;c=c|256;F[e+37|0]=c;F[e+38|0]=c>>>8;H[g>>2]=H[g>>2]+1;m=-1;c=I[f|0];g=c;i=f;q:{s=(c&254)!=134;if(s){break q}while(1){if((g&255)!=(c&255)){break q}c=0;g=H[i+32>>2];t=H[g>>2];t=(t|0)>0?t:0;v=g+8|0;while(1){if((c|0)!=(t|0)){g=v+(c<<6)|0;r:{if(H[g+4>>2]){break r}q=H[g+8>>2];if(!q){break r}if(ab(q,H[n>>2])){break r}H[g+16>>2]=l;H[l+24>>2]=H[l+24>>2]+1;q=I[g+37|0]|I[g+38|0]<<8|64;F[g+37|0]=q;F[g+38|0]=q>>>8;q=H[i+4>>2];if(q&8192){break k}H[i+4>>2]=q|8192;if((m|0)<0){m=H[d+40>>2];H[d+40>>2]=m+1}H[g+40>>2]=m}c=c+1|0;continue}break}if(!(I[i+5|0]&32)){break q}c=I[f|0];i=H[i+52>>2];g=I[i|0];continue}}H[n+12>>2]=8540;g=H[d+276>>2];H[d+276>>2]=p;s:{if(I[f+5|0]&32){H[i+64>>2]=H[f+64>>2];c=ec(a,i);H[i+64>>2]=0;if(!c){break s}break d}if(ec(a,f)){break d}}H[d+276>>2]=p;c=f;while(1){i=c;c=H[c+52>>2];if(c){continue}break}i=H[i+28>>2];c=H[n+4>>2];if(!c){c=i;break h}if(!i){break h}i=H[i>>2];m=H[c>>2];if((i|0)==(m|0)){break h}a=H[n>>2];H[h+72>>2]=m;H[h+68>>2]=i;H[h+64>>2]=a;Wa(d,5182,h- -64|0);break d}c=df(d,0,e);H[e+16>>2]=c;j=2;if(!c){break a}f=H[c+24>>2];if(f>>>0>=65535){H[h+16>>2]=H[c>>2];Wa(d,23250,h+16|0);H[e+16>>2]=0;break a}H[c+24>>2]=f+1;if(I[c+43|0]!=1){if(rA(d,e)){break a}if(!I[c+43|0]){break g}}f=I[a+20|0];if(cf(d,c)){break a}t:{u:{switch(I[c+43|0]-1|0){case 1:if(!(I[o+35|0]&128|H[c+60>>2]==H[H[o+16>>2]+28>>2])){H[h+32>>2]=H[c>>2];Wa(d,15534,h+32|0)}P=e,Q=Ud(o,H[c+44>>2],0),H[P+20>>2]=Q;break t;case 0:break u;default:break t}}if(!(I[e+37|0]&128)){break t}i=H[c+52>>2];if(!i|I[i+18|0]<=(H[o+32>>2]>>>7&1)>>>0){break t}H[h+48>>2]=H[c>>2];Wa(d,29557,h+48|0)}i=J[c+34>>1];G[c+34>>1]=65535;G[a+20>>1]=1;ec(a,H[e+20>>2]);G[a+20>>1]=f;G[c+34>>1]=i;break g}if(H[d+36>>2]){break f}c=H[b+32>>2];j=c+72|0;i=c+8|0;m=i;l=0;while(1){if((H[c>>2]-1|0)<=(l|0)){v=0;g=H[z>>2];f=(g|0)>0?g:0;B=z+8|0;c=0;while(1){if((c|0)!=(f|0)){a=H[(c<<4)+B>>2];e=I[a|0];v:{if((e|0)!=141){if((e|0)!=180){break v}break j}if(I[H[a+16>>2]]==180){break j}}c=c+1|0;v=H[a+4>>2]|v;continue}break}m=H[b+28>>2];break i}w:{if(!H[m+16>>2]){break w}n=H[j+16>>2];if(!n){break w}x:{y:{f=I[j+36|0];if(f&4){if(H[j+44>>2]|I[j+38|0]&4){break y}k=0;e=0;while(1){if((e|0)<G[n+34>>1]){a=H[n+4>>2]+N(e,12)|0;z:{if(I[a+10|0]&2){break z}g=H[a>>2];if(!kr(c,0,l,g,0,0,1)){break z}a=Cn(d,k,0);k=0;if(!a){break z}k=Tb(H[d>>2],g);H[a+(H[a>>2]<<3)>>2]=k;k=a}e=e+1|0;continue}break}if(k){H[j+44>>2]=k;a=I[j+37|0]|I[j+38|0]<<8|5120;F[j+37|0]=a;F[j+38|0]=a>>>8}if(H[d+36>>2]){break f}}s=f&32?1:2;f=H[j+44>>2];if(!(I[j+38|0]&4)){break x}v=l+1|0;q=f+8|0;e=H[d>>2];p=0;while(1){if(H[f>>2]<=(p|0)){break w}A:{a=H[q+(p<<3)>>2];t=In(n,a);if((t|0)>=0){if(kr(c,0,l,a,h+236|0,h+232|0,(I[j+37|0]|I[j+38|0]<<8)>>>12&1)){break A}}H[h+128>>2]=a;Wa(d,5684,h+128|0);break f}k=H[h+232>>2];g=jr(e,c,H[h+236>>2],k);fk(i+(H[h+236>>2]<<6)|0,k);k=0;B:{if(!(I[c+44|0]&64)){break B}while(1){C:{if(kr(c,H[h+236>>2]+1|0,l,a,h+236|0,h+232|0,(I[j+37|0]|I[j+38|0]<<8)>>>12&1)){u=i+(H[h+236>>2]<<6)|0;if(I[u+38|0]&4){if((sg(H[u+44>>2],a)|0)>=0){break C}}H[h+144>>2]=a;Wa(d,26872,h+144|0)}if(!k){break B}g=te(d,Pb(d,k,g),49976,0);break B}k=Pb(d,k,g);u=H[h+232>>2];g=jr(e,c,H[h+236>>2],u);fk(i+(H[h+236>>2]<<6)|0,u);continue}}k=jr(e,c,v,t);fk(j,t);a=ib(d,53,g,k);if(a){H[a+4>>2]=s|H[a+4>>2];H[a+36>>2]=H[k+28>>2]}P=b,Q=Td(d,H[b+36>>2],a),H[P+36>>2]=Q;p=p+1|0;continue}}H[h+160>>2]=0;Wa(d,13382,h+160|0);break f}if(!f){break w}kh(f,H[j+40>>2],s);P=b,Q=Td(d,H[b+36>>2],H[j+44>>2]),H[P+36>>2]=Q;H[j+44>>2]=0;a=I[j+37|0]|I[j+38|0]<<8|2048;F[j+37|0]=a;F[j+38|0]=a>>>8}m=m- -64|0;j=j- -64|0;l=l+1|0;continue}}H[h+80>>2]=H[n>>2];Wa(d,8431,h+80|0);break a}t=r&2048;D=H[H[d>>2]+32>>2]&68;m=0;u=0;while(1){D:{if((g|0)>(u|0)){a=(u<<4)+B|0;i=H[a>>2];E=H[i+4>>2];l=0;s=0;e=i;c=I[e|0];if((c|0)!=180){E:{if((c|0)==141){e=H[e+16>>2];if(I[e|0]==180){break E}}m=Pb(d,m,i);if(m){c=(H[m>>2]<<4)+m|0;H[c-4>>2]=H[a+4>>2];f=(I[c+1|0]|I[c+2|0]<<8)&65532|(I[a+9|0]|I[a+10|0]<<8)&3;F[c+1|0]=f;F[c+2|0]=f>>>8;H[a+4>>2]=0}H[a>>2]=0;break D}s=H[H[i+12>>2]+8>>2]}C=H[e+36>>2];f=A;a=0;while(1){F:{G:{H:{I:{k=H[x>>2];if((k|0)<=(a|0)){break I}r=H[f+16>>2];q=H[f+12>>2];if(!q){q=H[r>>2]}if(I[o+87|0]){break I}J:{if(I[f+38|0]&32){p=H[H[f+20>>2]+28>>2];g=0;break J}K:{if(!s){break K}if(!ab(s,q)){break K}a=a+1|0;break F}p=0;e=Fb(o,H[r+60>>2]);g=24876;if((e|0)<0){break J}g=H[H[o+16>>2]+(e<<4)>>2]}e=0;n=a+1|0;if(!(I[f+102|0]&4)|!t|(n|0)>=(k|0)){break H}y=H[f+108>>2];j=y+8|0;c=0;while(1){if(H[y>>2]<=(c|0)){break G}w=H[j+(c<<3)>>2];k=oc(o,59,w);if(!(!k|I[k+4|0]&3)){H[k+36>>2]=C}m=Pb(d,m,k);if(m){k=H[m>>2];H[h+208>>2]=w;k=(k<<4)+m|0;P=k-4|0,Q=mb(o,6443,h+208|0),H[P>>2]=Q;w=(I[k+1|0]|I[k+2|0]<<8)&65404|130;F[k+1|0]=w;F[k+2|0]=w>>>8}c=c+1|0;continue}}if(l){break D}if(s){H[h+224>>2]=s;Wa(d,8413,h+224|0);break D}Wa(d,16341,0);break D}y=0}c=G[r+34>>1]+(!(I[r+29|0]&2)&(t|0)!=0)|0;K=(c|0)>0?c:0;L=!(s|t)&(a|0)!=0;M=a^-1;w=p+8|0;while(1){L:{if((e|0)==(K|0)){break L}a=0;M:{N:{if(G[r+34>>1]==(e|0)){while(1){if((a|0)==3){break M}k=(a<<2)+49984|0;c=0;O:{while(1){if((c|0)==(e|0)){break O}if(Zb(H[k>>2],H[H[r+4>>2]+N(c,12)>>2])){c=c+1|0;continue}break}a=a+1|0;if((c|0)!=(e|0)){continue}}break}j=H[k>>2];break N}c=H[r+4>>2]+N(e,12)|0;j=H[c>>2];P:{if(!p){break P}a=w+(e<<4)|0;if(((I[a+9|0]|I[a+10|0]<<8)&3)==3){break M}if(!s){break P}if(!yA(a,0,s,0,0)){break M}}a=J[c+10>>1];if(!(a&2?I[b+6|0]&2:1)){break M}if(!(a&1024)|s){break N}if(!t){break M}}if(!(!L|!(I[f+38|0]&4))){l=1;if((sg(H[f+44>>2],j)|0)>=0){break M}}l=oc(o,59,j);a=H[x>>2];Q:{R:{if((a|0)>=2){if(t|!(I[f+36|0]&64)){break R}k=a+M|0;a=f;while(1){if((k|0)<=0){break R}c=a;a=c- -64|0;k=k-1|0;if(!(I[c+102|0]&4)){continue}c=H[c+108>>2];if(!c){continue}if((sg(c,j)|0)<0){continue}break}}if(I[d+220|0]<2){break Q}}a=oc(o,59,q);l=ib(d,141,a,l);S:{if(I[d+220|0]<2){break S}c=H[i+12>>2];if(!c){break S}dd(d,a,c)}if(!g){break Q}l=ib(d,141,oc(o,59,g),l)}if(!(!l|I[l+4|0]&3)){H[l+36>>2]=C}m=Pb(d,m,l);if(!m){l=1;m=0;break L}a=((H[m>>2]<<4)+m|0)-8|0;T:{if(!(!t|I[d+220|0]>1)){U:{if(p){c=Tb(o,H[(w+(e<<4)|0)+4>>2]);break U}H[h+200>>2]=j;H[h+196>>2]=q;H[h+192>>2]=g;c=mb(o,6196,h+192|0)}H[a+4>>2]=c;c=(I[a+9|0]|I[a+10|0]<<8)&-4|(G[r+34>>1]==(e|0)?3:2);F[a+9|0]=c;F[a+10|0]=c>>>8;V:{if(I[f+38|0]&4){if((sg(H[f+44>>2],j)|0)>=0){break V}}if(y){if((sg(y,j)|0)>=0){break V}}l=1;if(!(I[(H[r+4>>2]+N(e,12)|0)+11|0]&4)|G[r+34>>1]<=(e|0)){break M}}c=c|256;F[a+9|0]=c;F[a+10|0]=c>>>8;break T}if(!O&(D|0)==4){H[h+180>>2]=j;H[h+176>>2]=q;P=a,Q=mb(o,6437,h+176|0),H[P+4>>2]=Q;c=(I[a+9|0]|I[a+10|0]<<8)&65532;F[a+9|0]=c;F[a+10|0]=c>>>8;break T}P=a,Q=Tb(o,j),H[P+4>>2]=Q;c=(I[a+9|0]|I[a+10|0]<<8)&65532;F[a+9|0]=c;F[a+10|0]=c>>>8}l=1}e=e+1|0;continue}break}a=n}f=f- -64|0;continue}}$f(o,z);H[b+28>>2]=m;break i}v=v|E;u=u+1|0;g=H[z>>2];continue}}j=0;if(!m){break a}if(H[m>>2]>H[o+128>>2]){Wa(d,3323,0);break f}if(!(v&4194312)){break a}H[b+4>>2]=H[b+4>>2]|262144;break a}Jm(d,c,l+34|0,l+4|0);if(!s){H[n+12>>2]=H[f+4>>2]&8192?7632:7423;ec(a,f)}H[n+12>>2]=0;H[d+276>>2]=g}if(!(I[e+37|0]&2)){break e}if(!qA(d,e)){break e}}j=2;break a}e=e- -64|0;k=k+1|0;continue}break}H[d+276>>2]=g}Ea=h+240|0;return j|0}function cy(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0;h=Ea-432|0;Ea=h;H[h+424>>2]=0;y=I[H[e>>2]+3|0];H[h+420>>2]=0;v=tb(H[e+4>>2]);i=tb(H[e+8>>2]);a:{b:{j=(d<<2)-8|0;o=ub(j,0);if(!o){break b}x=Xa(o,0,j);w=ub(j,0);if(!w){break b}B=v+1|0;z=i+1|0;i=0;A=Xa(w,0,j);K=(y|0)!=52;p=3;while(1){c:{d:{e:{f:{g:{h:{i:{j:{if(!((d|0)<=(p|0)|i)){k=H[(p<<2)+e>>2];k:{if(H[h+420>>2]){break k}if(tb(k)>>>0<9){break k}if(yb(k,12818,8)){break k}if(Zp(F[k+8|0])){break k}i=Jx(c,k+9|0,h+420|0,g);H[h+424>>2]=i;break c}i=k;l:{if(K){break l}while(1){j=I[i|0];if(!j){break l}if((j|0)!=61){i=i+1|0;continue}break}H[h+48>>2]=i+1;j=Ab(8863,h+48|0);if(!j){break j}C=i-k|0;ii(j);i=0;m:{n:{while(1){if((i|0)==8){break n}o:{D=i<<3;if(H[D+56372>>2]==(C|0)){if(!yb(k,H[D+56368>>2],C)){break o}}i=i+1|0;continue}break}p:{switch(i|0){case 0:q:{if((tb(j)|0)!=4){break q}if(yb(j,23488,4)){break q}E=1;break m}H[h+16>>2]=j;Sd(g,7888,h+16|0);E=1;H[h+424>>2]=1;break m;case 1:Ta(t);t=j;j=0;break m;case 2:Ta(l);l=j;j=0;break m;case 3:Ta(n);n=j;j=0;break m;case 4:r:{s:{t:{switch(tb(j)-3|0){case 0:if(yb(j,17458,3)){break s}break r;case 1:break t;default:break s}}if(!yb(j,17453,4)){break r}}H[h+32>>2]=j;Sd(g,7865,h+32|0);H[h+424>>2]=1}L=(I[j|0]&223)==68;break m;case 5:Ta(r);r=j;j=0;break m;case 6:Ta(s);s=j;j=0;break m;case 7:break p;default:break n}}H[(u<<2)+A>>2]=j;u=u+1|0;j=0;break m}H[h>>2]=k;Sd(g,7838,h);H[h+424>>2]=1}Ta(j);i=H[h+424>>2];break c}j=tb(k);H[x+(m<<2)>>2]=k;m=m+1|0;q=(j+q|0)+1|0;i=0;break c}if(!r|i){break f}Ta(l);Ta(n);if(m){l=0;i=H[h+424>>2];break g}Ta(x);H[h+400>>2]=H[e+4>>2];H[h+404>>2]=r;m=0;H[h+428>>2]=0;j=Ab(19594,h+400|0);i=7;u:{if(!j){break u}d=kp(b,j,h+428|0);i=0;if(!d){break u}M=h,O=rg(b),H[M+384>>2]=O;Sd(g,8863,h+384|0);i=d}Ta(j);o=0;if(i){break h}i=0;l=H[h+428>>2];if(l){m=J[l+144>>1]}j=0;d=0;while(1){if((i|0)!=(m|0)){k=tb(Lm(l,i))+1|0;j=j+k|0;d=k>>>0>j>>>0?d+1|0:d;i=i+1|0;continue}break}i=m<<2;k=i+j|0;d=i>>>0>k>>>0?d+1|0:d;o=ub(k,d);if(!o){i=7;break i}p=i+o|0;i=0;k=0;while(1){if((k|0)==(m|0)){break i}n=Lm(l,k);d=tb(n)+1|0;n=Va(p,n,d);H[(k<<2)+o>>2]=n;k=k+1|0;p=d+n|0;continue}}i=7;H[h+424>>2]=7;break c}Wc(l);q=j}H[h+424>>2]=i;l=0;if(!s|i){break g}while(1){v:{n=0;if((l|0)==(m|0)){break v}if(Zb(s,H[(l<<2)+o>>2])){l=l+1|0;continue}else{d=(l|0)<(m|0)?m:l;while(1){if((d|0)!=(l|0)){j=(l<<2)+o|0;l=l+1|0;H[j>>2]=H[(l<<2)+o>>2];continue}break}m=m-1|0}}break}l=0;break e}n=0}if(i){break d}}if(!m){H[o>>2]=2831;m=1;q=8}if(!H[h+420>>2]){c=Jx(c,14007,h+420|0,g);H[h+424>>2]=c;if(c){break d}}j=1;w:{if(!t){break w}k=I[t|0];if(!k){break w}j=2;i=t;while(1){c=k&255;x:{if((c|0)!=44){if(c){break x}break w}j=j+1|0}k=I[i+1|0];i=i+1|0;continue}}y:{z:{d=N(j,24);p=ub(d,0);if(!p){c=7;j=0;break z}c=0;x=Xa(p,0,d);if(!t){break z}i=1;k=t;while(1){if((i|0)>=(j|0)){break z}H[h+428>>2]=0;d=Ix(k,h+428|0);if(d){k=d+k|0;d=H[h+428>>2];A:{if(!(d?(d|0)<=1e7:0)){i=i-1|0;j=j-1|0;break A}H[x+N(i,24)>>2]=d}i=i+1|0;k=k+1|0;continue}break}H[h+424>>2]=1;H[h+368>>2]=t;Sd(g,7803,h+368|0);j=0;c=H[h+424>>2];break y}H[h+424>>2]=c}d=0;if(c){break a}k=m<<2;c=k+(((v+z|0)+q|0)+m|0)|0;q=N(j,24);c=(c+q|0)+297|0;d=ub(c,0);if(!d){H[h+424>>2]=7;d=0;break a}i=0;c=Xa(d,0,c);H[c+272>>2]=0;H[c+24>>2]=m;H[c+12>>2]=b;v=c+296|0;H[c+28>>2]=v;b=H[h+420>>2];H[c+268>>2]=1048576;H[c+36>>2]=b;b=(y|0)==52;F[c+238|0]=b&!E;F[c+237|0]=b;F[c+239|0]=L;F[c+236|0]=b;H[c+48>>2]=255;b=k+v|0;H[c+264>>2]=b;H[c+44>>2]=s;H[c+40>>2]=r;Va(b,p,q);H[c+260>>2]=j;k=(j|0)>0?j:0;while(1){b=H[c+264>>2];if((i|0)!=(k|0)){b=b+N(i,24)|0;H[b+8>>2]=0;H[b+12>>2]=0;G[b+4>>1]=257;H[b+16>>2]=0;H[b+20>>2]=0;i=i+1|0;continue}break}b=b+N(j,24)|0;H[c+32>>2]=b;b=b+m|0;H[c+20>>2]=b;b=Va(b,H[e+8>>2],z)+z|0;H[c+16>>2]=b;r=(m|0)>0?m:0;i=Va(b,H[e+4>>2],B)+B|0;k=0;while(1){if((k|0)==(r|0)){b=0;k=(u|0)>0?u:0;e=0;while(1){if((e|0)==(r|0)){B:{i=0;while(1){if((i|0)==(k|0)){break B}e=H[(i<<2)+A>>2];if(e){H[h+352>>2]=e;Sd(g,7915,h+352|0);b=1}i=i+1|0;continue}}}else{i=0;q=e<<2;s=tb(H[q+H[c+28>>2]>>2]);while(1){if((i|0)!=(k|0)){m=(i<<2)+A|0;j=H[m>>2];C:{if(!j){break C}if((tb(j)|0)!=(s|0)){break C}if(yb(H[q+H[c+28>>2]>>2],j,s)){break C}F[H[c+32>>2]+e|0]=1;Ta(j);H[m>>2]=0}i=i+1|0;continue}break}e=e+1|0;continue}break}H[h+424>>2]=b;if(!(!l^(n|0)!=0|b)){H[h+424>>2]=1;H[h+336>>2]=l?4248:4250;Sd(g,8958,h+336|0)}i=0;H[h+428>>2]=0;D:{if(!H[c+40>>2]){E:{if(!n){j=0;b=30558;break E}j=Hx(n);b=j}Ve(h+424|0,h+428|0,15182,0);while(1){if((i|0)<H[c+24>>2]){H[h+72>>2]=H[H[c+28>>2]+(i<<2)>>2];H[h+68>>2]=i;H[h+64>>2]=b;Ve(h+424|0,h+428|0,27305,h- -64|0);i=i+1|0;continue}break}if(H[c+44>>2]){H[h+288>>2]=15164;Ve(h+424|0,h+428|0,19587,h+288|0)}Ta(j);break D}Ve(h+424|0,h+428|0,15085,0);while(1){if((i|0)<H[c+24>>2]){H[h+304>>2]=H[H[c+28>>2]+(i<<2)>>2];Ve(h+424|0,h+428|0,28169,h+304|0);i=i+1|0;continue}break}b=H[c+44>>2];if(!b){break D}H[h+320>>2]=b;Ve(h+424|0,h+428|0,19587,h+320|0)}e=H[c+16>>2];k=30558;j=H[c+40>>2];if(j){b=30558}else{j=H[c+20>>2];b=2830}H[h+280>>2]=b;H[h+276>>2]=j;H[h+272>>2]=e;Ve(h+424|0,h+428|0,1607,h+272|0);H[c+224>>2]=H[h+428>>2];i=0;H[h+428>>2]=0;j=0;if(l){j=Hx(l);k=j}Ve(h+424|0,h+428|0,21710,0);while(1){if((i|0)<H[c+24>>2]){H[h+80>>2]=k;Ve(h+424|0,h+428|0,26293,h+80|0);i=i+1|0;continue}break}if(H[c+44>>2]){Ve(h+424|0,h+428|0,21708,0)}Ta(j);H[c+228>>2]=H[h+428>>2];r=0;F:{if(H[h+424>>2]){break F}if(a){i=0;H[h+428>>2]=0;b=H[c+12>>2];if(!H[c+40>>2]){e=H[c+44>>2];k=Ab(18502,0);G:{H:{while(1){if(!k){break H}if(H[c+24>>2]>(i|0)){H[h+248>>2]=H[H[c+28>>2]+(i<<2)>>2];H[h+244>>2]=i;H[h+240>>2]=k;i=i+1|0;k=Ab(28128,h+240|0);continue}break}if(!e){break G}H[h+260>>2]=e;H[h+256>>2]=k;k=Ab(15160,h+256|0);if(k){break G}}H[h+428>>2]=7;k=0}e=H[c+16>>2];g=H[c+20>>2];H[h+232>>2]=k;H[h+224>>2]=e;H[h+228>>2]=g;Fe(h+428|0,b,25169,h+224|0);Ta(k)}e=H[c+20>>2];H[h+208>>2]=H[c+16>>2];H[h+212>>2]=e;e=h+428|0;Fe(e,b,21837,h+208|0);g=H[c+20>>2];H[h+192>>2]=H[c+16>>2];H[h+196>>2]=g;Fe(e,b,22054,h+192|0);if(I[c+238|0]){g=H[c+20>>2];H[h+176>>2]=H[c+16>>2];H[h+180>>2]=g;Fe(e,b,21909,h+176|0)}if(I[c+237|0]){$p(h+428|0,c)}b=H[h+428>>2];H[h+424>>2]=b;b=!b}else{b=1}if(!((y|0)==52|a)){F[c+237|0]=2}if(b){H[h+160>>2]=H[c+16>>2];a=Ab(12794,h+160|0);I:{if(!a){i=7;break I}i=kp(H[c+12>>2],a,h+428|0);if((i|0)!=23){if(i){break I}b=H[h+428>>2];vb(b);M=c,O=Fd(b,0),H[M+244>>2]=O;i=Wc(b);break I}H[c+244>>2]=1024;i=0}Ta(a);H[h+424>>2]=i;H[c+232>>2]=H[c+244>>2]-35;if(i){break F}a=H[c+44>>2];b=H[c+12>>2];H[h+144>>2]=1;ip(b,1,h+144|0);ip(H[c+12>>2],2,0);H[h+128>>2]=H[H[c+28>>2]>>2];a=a?a:15151;k=Ab(30515,h+128|0);i=1;while(1){if(!(!k|H[c+24>>2]<=(i|0))){H[h+100>>2]=H[H[c+28>>2]+(i<<2)>>2];H[h+96>>2]=k;i=i+1|0;k=Ab(30513,h+96|0);continue}break}b=H[c+20>>2];H[h+120>>2]=a;H[h+116>>2]=b;H[h+112>>2]=k;j=7;a=Ab(26032,h+112|0);if(!(!k|!a)){j=kj(H[c+12>>2],a)}Ta(a);Ta(k);H[h+424>>2]=j;break F}H[c+232>>2]=H[c+244>>2]-35}s=0;break a}H[h+428>>2]=0;e=k<<2;j=Yp(H[e+o>>2],h+428|0);b=H[h+428>>2];if((b|0)>0){Va(i,j,b)}b=b+i|0;F[b|0]=0;ii(i);H[e+H[c+28>>2]>>2]=i;k=k+1|0;i=b+1|0;continue}}p=0;d=0;break a}p=p+1|0;continue}}H[h+424>>2]=7;w=0;d=0}Ta(t);Ta(p);Ta(l);Ta(n);Ta(r);Ta(s);i=0;a=(u|0)>0?u:0;while(1){if((a|0)!=(i|0)){Ta(H[(i<<2)+w>>2]);i=i+1|0;continue}break}Ta(o);Ta(w);b=H[h+424>>2];J:{if(b){if(d){hq(d);break J}a=H[h+420>>2];if(!a){break J}Ia[H[H[a>>2]+8>>2]](a)|0;break J}H[f>>2]=d}Ea=h+432|0;return b}function qB(a,b,c,d,e,f,g,h,i,j,k,l,m){var n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0,$=0,aa=0,ba=0,ca=0,da=0,ea=0,fa=0;L=Ea-16|0;Ea=L;n=J[b+34>>1];o=H[a+8>>2];A=H[a>>2];p=H[b+28>>2];if(p&128){z=jc(b);M=J[z+50>>1]}else{M=1}a:{if(!(p&2048)){break a}n=n<<16>>16;x=(n|0)>0?n:0;p=f+1|0;n=1;while(1){v=n^-1;n=0;while(1){if((n|0)!=(x|0)){w=H[b+4>>2]+N(n,12)|0;q=I[w+4|0]&15;b:{if(!q|G[b+32>>1]==(n|0)){break b}s=J[w+10>>1]&96;y=!s;if(!((y|t)&1)){r=r+1|0;break b}if(!(s|!l)&H[(n<<2)+l>>2]<0){break b}c:{d:{e:{f:{u=(i|0)==11?(q|0)==11?2:q:i;if((u|0)==5){if(!J[w+8>>1]|t&1){break f}q=Gc(b,n<<16>>16)+p|0;s=_a(o,51,q);gk(a,Mc(b,w),q);B=B+1|0;H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(s,20)|0)+8>>2]=H[o+108>>2];break b}if(v&y){break b}E=Gc(b,n<<16>>16)+p|0;switch(u-1|0){case 0:case 2:break d;case 1:break e;default:break c}}E=Gc(b,n<<16>>16)+p|0}q=H[a+128>>2];F[(q?q:a)+21|0]=1;u=2}q=H[b>>2];H[L+4>>2]=H[w>>2];H[L>>2]=q;w=mb(A,6437,L);Ua(o,69,1299,u,E);xc(o,w,-6);w=H[o+108>>2];if((w|0)<=0){break b}G[(H[o+104>>2]+N(w,20)|0)-18>>1]=1;break b}Sa(o,50,E,j)}n=n+1|0;continue}break}if((!(r|B)|t)&1){break a}t=1;n=0;if(!(I[b+28|0]&96)|(B|0)<=0){continue}mk(a,p,b);continue}}w=0;p=H[b+16>>2];if(!(!p|I[A+33|0]&2)){H[a+52>>2]=f^-1;u=(i|0)==11?2:i;t=p+8|0;x=f+1|0;n=0;while(1){if((n|0)<H[p>>2]){v=t+(n<<4)|0;r=H[v>>2];g:{if(l){if(!ok(r,l,h)){break g}}if(!Q){yg(o,b,x);Q=1}q=H[a+56>>2]-1|0;H[a+56>>2]=q;r=jb(A,r,0);if(!I[A+87|0]){Le(a,r,q,16)}eb(A,r);h:{if((u|0)==4){Qb(o,j);u=4;break h}u=(u|0)==5?2:u;nh(a,275,u,H[v+4>>2],0,3)}hb(o,q)}n=n+1|0;continue}break}H[a+52>>2]=0}r=b+8|0;l=H[b+8>>2];V=1;i:{j:{if(!m){m=0;break j}if(!H[m>>2]){n=I[m+20|0];i=n?6:4;m=n?m:0;break j}if(!l){break j}while(1){if(l){w=w+1|0;l=H[l+20>>2];continue}break}q=nb(A,N(w,10),0);if(!q){break i}H[m+24>>2]=q;x=q+(w<<3)|0;t=0;l=m;while(1){if(!(!l|!H[l>>2])){p=0;n=r;v=H[l+28>>2];k:{if(!v){break k}while(1){n=H[n>>2];if(!(!n|(n|0)==(v|0))){p=p+1|0;n=n+20|0;continue}break}v=p+x|0;if(I[v|0]){break k}F[v|0]=1;v=q+(t<<3)|0;H[v+4>>2]=p;H[v>>2]=n;t=t+1|0}l=H[l+16>>2];continue}break}V=0;n=0;p=r;while(1){l=H[p>>2];if(l){if(!I[n+x|0]){p=q+(t<<3)|0;H[p+4>>2]=n;H[p>>2]=l;t=t+1|0}n=n+1|0;p=l+20|0;continue}else{l=w}break}w=q}l:{m:{n=H[A+32>>2];if(n&24576){n:{if(n&8192){O=ui(a,b,128,0,0);n=1;if(O){break n}n=(ti(a,b,0,0)|0)!=0;break n}n=ti(a,b,0,0)}if(n){break m}}v=0;break l}C=H[a+44>>2]+1|0;H[a+44>>2]=C;Sa(o,71,0,C);v=H[a+56>>2]-1|0;H[a+56>>2]=v}o:{if(!h){q=0;break o}q=0;if(z){break o}p=H[a+56>>2]-1|0;H[a+56>>2]=p;n=i;if((n|0)==11){n=I[b+42|0];n=(n|0)==11?2:n}p:{if(!m){break p}q=_m(m,0);if(q){n=I[q+20|0]?6:4}if((m|0)==(q|0)){break p}R=Mb(o,9)}if(!((i|0)==5|(n|0)!=5|(!H[r>>2]|R))){P=Mb(o,9)+1|0}q:{if(!g){break q}Ua(o,53,f,p,g);t=H[o+108>>2];if((t|0)<=0){break q}G[(H[o+104>>2]+N(t,20)|0)-18>>1]=144}Ua(o,31,d,p,f);r:{s:{t:{switch(n-1|0){default:n=2;case 0:case 1:case 2:Cr(a,n,b);break s;case 4:if(C){n=H[a+128>>2];F[(n?n:a)+20|0]=1;qk(a,b,O,d,e,f,1,0,5,1,-1);Sa(o,86,C,1);S=1;n=1;break r}if(!H[r>>2]){S=1;n=0;break r}S=1;n=H[a+128>>2];F[(n?n:a)+20|0]=1;Gr(a,b,d,e,0,-1);n=0;break r;case 5:sz(a,m,b,0,d);break;case 3:break t}}Qb(o,j)}n=0}W=n;hb(o,p);if(!(!m|(m|0)==(q|0))){X=Mb(o,9);break o}if(!P){P=0;break o}ba=Mb(o,9);p=H[o+108>>2];H[(I[H[o>>2]+87|0]?73336:(H[o+104>>2]+N(P,20)|0)-20|0)+8>>2]=p}u:{if(!V){y=H[w+4>>2];p=H[w>>2];break u}y=0;p=l}ca=(g|0)!=0&(O|0)!=0;da=R+1|0;ea=g+1|0;_=f^-1;Y=f+1|0;E=0;x=v;while(1){v:{w:{x:{if(p){r=(y<<2)+c|0;if(!H[r>>2]){break v}y:{if(!m){break y}q=_m(m,p);if(!R|(q|0)!=(m|0)){break y}H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(R,20)|0)+8>>2]=H[o+108>>2]}K=H[a+56>>2]-1|0;H[a+56>>2]=K;if(!Q){yg(o,b,Y);Q=1}if(H[p+36>>2]){Sa(o,75,0,H[r>>2]);H[a+52>>2]=_;oA(a,H[p+36>>2],K);H[a+52>>2]=0}D=e+y|0;$=H[r>>2];t=$+1|0;n=0;while(1){s=J[p+52>>1];if(n>>>0<s>>>0){z:{A:{B:{C:{D:{s=J[H[p+4>>2]+(n<<1)>>1];switch(s-65534|0){case 1:break B;case 0:break D;default:break C}}H[a+52>>2]=_;gk(a,H[(H[p+40>>2]+(n<<4)|0)+8>>2],n+t|0);H[a+52>>2]=0;break z}s=s<<16>>16;if(J[b+32>>1]!=(s&65535)){break A}}Sa(o,82,f,n+t|0);break z}Sa(o,81,Gc(b,s)+Y|0,n+t|0)}n=n+1|0;continue}break}Ua(o,97,t,s,H[r>>2]);if(!(!g|h)&(p|0)==(z|0)){break w}n=I[p+54|0];if(!n){break w}s=q?I[q+20|0]?6:4:(i|0)==11?(n|0)==11?2:n:i;E:{if(H[p+20>>2]|(p|0)!=(z|0)|(s|0)!=5|y){break E}n=H[A+32>>2];if(n&8192){if(ui(a,b,128,0,0)){break E}n=H[A+32>>2]}if(!(n&16384)){break w}if(H[b+48>>2]){break E}if(!xg(b)){break w}}T=gb(o,27,D,K,t,J[p+50>>1]);r=t;U=(p|0)==(z|0);if(!U){r=nc(a,M)}if(!g&(s|0)!=5){break x}if(!(I[b+28|0]&128)){Sa(o,142,D,r);if(!g){break x}Ua(o,53,r,K,g);n=H[o+108>>2];if((n|0)<=0){break x}G[(H[o+104>>2]+N(n,20)|0)-18>>1]=144;break x}n=0;F:{if(U){break F}while(1){if(J[z+50>>1]<=n>>>0){break F}Ua(o,94,D,Re(p,G[H[z+4>>2]+(n<<1)>>1]),n+r|0);n=n+1|0;continue}}if(!g){break x}fa=((I[p+55|0]|I[p+56|0]<<8)&3)==2?t:r;u=J[z+50>>1];B=u+H[o+108>>2]|0;n=0;Z=52;while(1){if((u&65535)>>>0<=n>>>0){break x}u=Fi(a,H[H[z+32>>2]+(n<<2)>>2]);aa=(J[z+50>>1]-1|0)==(n|0);Z=aa?53:Z;B=aa?K:B;fb(o,Z,Gc(b,G[H[z+4>>2]+(n<<1)>>1])+ea|0,B,n+fa|0,u,-2);u=H[o+108>>2];if((u|0)>0){G[(H[o+104>>2]+N(u,20)|0)-18>>1]=144}n=n+1|0;u=J[z+50>>1];continue}}if(P){Qb(o,P);h=H[o+108>>2];H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(ba,20)|0)+8>>2]=h}if(W){Sa(o,17,C,x);G:{if(!z){H:{if(!g){break H}Ua(o,53,f,v,g);e=H[o+108>>2];if((e|0)<=0){break H}G[(H[o+104>>2]+N(e,20)|0)-18>>1]=144}Ua(o,31,d,v,f);Cr(a,2,b);break G}Qb(o,v)}hb(o,x)}I:{if(I[b+28|0]&128){break I}Ua(o,97,Y,G[b+36>>1],H[(y<<2)+c>>2]);if(Q){break I}yg(o,b,0)}H[k>>2]=S;break i}J:{K:{switch(s-1|0){case 0:case 1:case 2:hr(a,s,p);break J;case 5:sz(a,m,b,p,D);case 3:Qb(o,j);break J;default:break K}}n=H[o+108>>2];if(C){s=H[a+128>>2];F[(s?s:a)+20|0]=1;W=W+1|0}L:{if(ca){_a(o,167,d);qk(a,b,O,d,e,r,M<<16>>16,0,5,U,D);_a(o,168,d);break L}qk(a,b,O,d,e,r,M<<16>>16,0,5,U,D)}S=1;if(!C){break J}Sa(o,86,C,1);B=Mb(o,9);hb(o,x);x=H[a+56>>2]-1|0;H[a+56>>2]=x;if(H[p+36>>2]){Sa(o,50,$,x)}u=n-T|0;while(1){if((u|0)>0){n=73336;n=I[H[o>>2]+87|0]?n:H[o+104>>2]+N(T,20)|0;s=I[n|0];M:{if((s|0)==142){break M}D=J[n+2>>1];fb(o,s,H[n+4>>2],F[s+35296|0]&1?x:H[n+8>>2],H[n+12>>2],H[n+16>>2],F[n+1|0]);n=H[o+108>>2];if((n|0)<=0){break M}G[(H[o+104>>2]+N(n,20)|0)-18>>1]=D}T=T+1|0;u=u-1|0;continue}break}hr(a,2,p);p=H[o+108>>2];H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(B,20)|0)+8>>2]=p}hb(o,K);if((r|0)!=(t|0)){Sc(a,r,M)}if(!q){break v}n=q;if(!X){break v}while(1){n=H[n+16>>2];if(!(!n|!H[n>>2]|!H[n+28>>2])){if(I[n+21|0]){continue}break v}break}Qb(o,da);H[(I[H[o>>2]+87|0]?73336:H[o+104>>2]+N(X,20)|0)+8>>2]=H[o+108>>2];X=0;break v}hb(o,K)}if(V){l=H[l+20>>2];p=l;y=y+1|0}else{p=0;E=E+1|0;y=E;if((y|0)>=(l|0)){continue}n=(y<<3)+w|0;p=H[n>>2];y=H[n+4>>2]}continue}}Ea=L+16|0}function kg(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;k=Ea-16|0;Ea=k;g=H[a+12>>2];a:{b:{c:{d:{e:{while(1){f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{h=b+g|0;c=I[h|0];switch(c|0){case 0:break a;case 46:break p;case 45:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:break q;case 43:break r;case 44:break s;case 58:break t;case 9:case 10:case 13:case 32:break u;case 34:break w;case 39:break x;case 1:case 2:case 3:case 4:case 5:case 6:case 7:case 8:case 14:case 15:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:case 33:case 35:case 36:case 37:case 38:case 40:case 41:case 42:break e;case 11:case 12:case 47:break g;default:break y}}d=c-225|0;if(d>>>0<=14){break v}break k}F[a+37|0]=1;c=I[h|0]}i=c&255;j=b+1|0;c=j;f=7;while(1){z:{d=I[c+g|0];if(!I[d+51984|0]){e=c;break z}e=c+1|0;d=I[g+e|0];if(!I[d+51984|0]){break z}e=c+2|0;d=I[g+e|0];if(!I[d+51984|0]){break z}c=c+3|0;continue}if((d|0)!=(i|0)){A:{if((d|0)==92){h=e+g|0;B:{C:{D:{E:{F:{G:{c=e+1|0;d=I[g+c|0];switch(d-110|0){case 1:case 2:case 3:case 5:case 9:break l;case 8:break C;case 10:break D;case 0:case 4:case 6:break E;case 7:break F;default:break G}}H:{switch(d-10|0){case 1:case 2:break l;case 3:break B;case 0:break C;default:break H}}I:{switch(d-47|0){case 1:break C;case 0:break E;default:break I}}J:{switch(d-98|0){case 1:case 2:case 3:break l;case 0:case 4:break E;default:break J}}if((d|0)==34){break E}if((d|0)==39){break C}if((d|0)==92){break E}if((d|0)!=226|I[h+2|0]!=128){break l}if((I[h+3|0]&254)==168){break C}break l}if(!Bq(h+2|0)){break l}}f=(f&255)==7?8:f;break A}if(!Aq(h+2|0)){break l}}F[a+37|0]=1;f=9;break A}d=e+2|0;e=I[d+g|0];F[a+37|0]=1;c=(e|0)==10?d:c;f=9;break A}if(d<<24>>24<=31){H[a+28>>2]=e;break c}c=e;f=(d|0)==34?9:f}c=c+1|0;continue}break}sd(a,f&255,(b^-1)+e|0,g+j|0);c=e+1|0;break a}if(!(1<<d&16391)){break k}break g}b=(Gl(h+1|0,51968)+b|0)+1|0;continue}H[a+28>>2]=b;c=-5;break a}H[a+28>>2]=b;c=-4;break a}F[a+37|0]=1;c=I[h|0]}if(c<<24>>24>48){break n}f=b+1|0;i=f+g|0;d=I[i|0];K:{if((c&255)==48){if(!(!(I[I[h+2|0]+31152|0]&8)|(d|32)!=120)){e=1;F[a+37|0]=1;d=b+3|0;while(1){c=d;d=d+1|0;if(I[I[c+g|0]+31152|0]&8){continue}break}break m}if(d-58>>>0<4294967286){break n}break K}if(d-58>>>0<=4294967285){e=1;if((d|0)==46){break o}if((d|0)!=105&(d|0)!=73){break d}if(yb(i,12639,3)){break d}F[a+37|0]=1;L:{if(I[h|0]==45){sd(a,5,6,22972);break L}sd(a,5,5,22973)}c=(yb(h+4|0,1065,5)?4:9)+b|0;break a}if((d|0)!=48){break n}c=I[h+2|0];if(c-58>>>0>=4294967286){break K}if(!(I[I[h+3|0]+31152|0]&8)|(c|32)!=120){break n}e=1;F[a+37|0]=1;d=b+4|0;while(1){c=d;d=d+1|0;if(I[I[c+g|0]+31152|0]&8){continue}break}break m}H[a+28>>2]=f;break c}if(I[h+1|0]-58>>>0<=4294967285){break d}e=3}F[a+37|0]=1}c=b;i=1;while(1){f=e|2;while(1){d=c;c=d+1|0;j=I[g+c|0];if(j-58>>>0>4294967285){continue}if((j|0)==46){d=e&2;e=f;if(!d){continue}break j}break}l=d+g|0;f=F[l|0];if((j&223)==69){if((f|0)<=47){if((f|0)!=46){break j}f=d-1|0;if(f>>>0<b>>>0|I[g+f|0]-58>>>0<4294967286){break j}F[a+37|0]=1;e=e|1}if(!i){break j}M:{N:{f=d+2|0;d=I[f+g|0];switch(d-43|0){case 0:case 2:break N;default:break M}}d=I[l+3|0];c=f}e=e|2;i=0;if((d-58&255)>>>0>245){continue}break j}break}if((f|0)>47){break m}if((f|0)!=46){break j}d=d-1|0;if(d>>>0<b>>>0|I[d+g|0]-58>>>0<4294967286){break j}F[a+37|0]=1;e=e|1}d=a;a=(I[h|0]==43)+b|0;sd(d,e+3&255,c-a|0,a+g|0);break a}H[a+28>>2]=c;break c}if((c|0)==194){break g}O:{P:{switch(c-91|0){default:Q:{switch(c-123|0){default:if((c|0)==102){break O}if((c|0)==110){break f}if((c|0)!=116){break e}if(_h(h,12960,4)){break d}c=b+4|0;if(I[I[g+c|0]+31152|0]&6){break d}hm(a,1);break a;case 2:break i;case 1:break e;case 0:break Q}}h=H[a+4>>2];sd(a,12,H[a+20>>2]-b|0,0);c=J[a+32>>1]+1|0;G[a+32>>1]=c;if((c&65535)>>>0>=1001){break d}i=g+2|0;f=H[a+4>>2];R:{while(1){S:{j=H[a+4>>2];T:{U:{V:{W:{b=b+1|0;d=kg(a,b);if((d|0)<=0){if((d|0)==-2){b=H[a+28>>2];e=4;if((f|0)==H[a+4>>2]){break T}F[a+37|0]=1;break T}c=im(b+g|0);H[k+12>>2]=7;b=b+c|0;e=g+b|0;c=I[e|0];if(!(I[c+31152|0]&66)){if((c|0)!=92){break W}if(!Qy(e+1|0,k+12|0)){break W}}d=b;while(1){c=d;d=d+1|0;l=g+d|0;m=I[l|0];if(I[m+31152|0]&70){if(!im(l)){continue}}if((m|0)==92){if(Qy(c+i|0,k+12|0)){continue}}break}sd(a,I[k+12|0],d-b|0,e);F[a+37|0]=1}c=-1;if(I[a+35|0]){break a}if((I[j+H[a>>2]|0]&15)-11>>>0<=4294967291){break d}b=I[d+g|0];if((b|0)!=58){break V}d=d+1|0;break U}e=1;if((d|0)==-1){break T}H[a+28>>2]=b;break T}X:{if(!I[b+52320|0]){break X}while(1){b=d;d=d+1|0;c=I[g+d|0];if(I[c+52320|0]){continue}break}if((c|0)!=58){break X}d=b+2|0;break U}Y:{Z:{c=kg(a,d);switch(c+5|0){case 4:break a;case 0:break Y;default:break Z}}H[a+28>>2]=d;break c}d=H[a+28>>2]+1|0}b=kg(a,d);if((b|0)<=0){c=-1;if((b|0)==-1){break a}H[a+28>>2]=d;break a}e=6;d=b+g|0;c=I[d|0];if((c|0)==44){break T}if((c|0)==125){break R}if(I[c+52320|0]){b=(Gl(d+1|0,51968)+b|0)+1|0;c=I[g+b|0];if((c|0)==44){break T}if((c|0)==125){break R}}_:{switch(kg(a,b)+4|0){case 2:break S;case 0:break _;default:break d}}b=H[a+28>>2]}c=-1;switch(e-4|0){case 0:break R;case 2:continue;default:break a}}break}b=H[a+28>>2]}zq(a,h,H[a+4>>2]-f|0);G[a+32>>1]=J[a+32>>1]-1;c=b+1|0;break a;case 1:break e;case 0:break P;case 2:break h}}e=H[a+4>>2];sd(a,11,H[a+20>>2]-b|0,0);c=-1;if(I[a+35|0]){break a}d=H[a+4>>2];c=J[a+32>>1]+1|0;G[a+32>>1]=c;if((c&65535)>>>0>=1001){break d}c=b;$:{while(1){b=c+1|0;c=kg(a,b);if((c|0)<=0){aa:{switch(c+3|0){case 0:c=H[a+28>>2];if((d|0)==H[a+4>>2]){break $}F[a+37|0]=1;break $;case 2:break a;default:break aa}}H[a+28>>2]=b;break c}f=c+g|0;b=I[f|0];if((b|0)==44){continue}if((b|0)==93){break $}if(I[b+52320|0]){c=(Gl(f+1|0,51968)+c|0)+1|0;b=I[g+c|0];if((b|0)==44){continue}if((b|0)==93){break $}}ba:{switch(kg(a,c)+4|0){case 0:c=H[a+28>>2];continue;case 1:break ba;default:break j}}break}c=H[a+28>>2]}zq(a,e,H[a+4>>2]-d|0);G[a+32>>1]=J[a+32>>1]-1;c=c+1|0;break a}if(_h(h,13493,5)){break d}c=b+5|0;if(I[I[g+c|0]+31152|0]&6){break d}hm(a,2);break a}H[a+28>>2]=c;break c}H[a+28>>2]=b;c=-2;break a}H[a+28>>2]=b;c=-3;break a}c=im(h);if(!c){break d}F[a+37|0]=1;b=b+c|0;continue}break}if(_h(h,11625,4)){break e}d=b+4|0;if(!(I[I[d+g|0]+31152|0]&6)){break b}}d=0;while(1){if((d|0)==5){break d}ca:{f=(d<<4)+52240|0;if(I[f|0]!=(c|0)&I[f+1|0]!=(c|0)){break ca}e=F[f+2|0];if(yb(h,H[f+8>>2],e)){break ca}e=b+e|0;if(I[I[e+g|0]+31152|0]&6){break ca}da:{if(I[f+3|0]==5){sd(a,5,5,22973);break da}hm(a,0)}F[a+37|0]=1;c=e;break a}d=d+1|0;continue}}H[a+28>>2]=b}c=-1;break a}hm(a,0);c=d}Ea=k+16|0;return c}function ng(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=O(0),r=0,s=0,t=0,u=0;h=Ea-176|0;Ea=h;e=Xa(d,0,48);a:{b:{if(!b){if(!Zj(a)){break b}o=az(a,e);break a}o=1;d=H[c>>2];c:{if(I[(J[d+16>>1]&63)+31056|0]-1>>>0<=1){$y(e,Db(d));break c}g=$a(d);if(!g){break a}j=I[g|0];H[h+88>>2]=h+112;H[h+84>>2]=h+116;H[h+80>>2]=h+168;d:{d=g+((j|0)==45)|0;if((xf(d,16549,h+80|0)|0)!=3){break d}f=d+10|0;while(1){d=f;f=d+1|0;l=I[d|0];if((l|0)==84|F[l+31152|0]&1){continue}break}if(Hq(d,e)){if(I[d|0]){break d}F[e+43|0]=0}F[e+42|0]=1;F[e+40|0]=0;d=H[h+168>>2];H[e+8>>2]=(j|0)==45?0-d|0:d;H[e+12>>2]=H[h+116>>2];H[e+16>>2]=H[h+112>>2];if(!I[e+44|0]){break c}Ac(e);break c}if(!Hq(g,e)){break c}e:{if(!ab(g,1673)){if(Zj(a)){break e}}if((Md(g,h+120|0,bb(g),1)|0)>0){$y(e,M[h+120>>3]);break c}if(ab(g,17834)){if(ab(g,14907)){break b}}if(!Zj(a)){break b}F[e+47|0]=1}if(az(a,e)){break a}}r=(b|0)<=1?1:b;s=e+8|0;t=h+128|0;n=1;while(1){f:{g:{h:{i:{if((n|0)!=(r|0)){d=(n<<2)+c|0;g=$a(H[d>>2]);xb(H[d>>2]);if(!g){break a}l=I[g|0];d=I[l+30768|0];f=d-43|0;if(f>>>0>14|!(1<<f&32741)){break i}f=1;d=g+1|0;while(1){j:{k=f+g|0;j=I[k|0];k:{if(!j|(j|0)==58|F[j+31152|0]&1){break k}if((j|0)!=45){break j}l:{switch(f-5|0){case 1:H[h+64>>2]=h+116;if((xf(d,12731,h- -64|0)|0)==1){break k}break j;case 0:break l;default:break j}}H[h+48>>2]=h+116;if((xf(d,12735,h+48|0)|0)!=1){break j}}m:{if((Md(g,h+168|0,f,1)|0)<=0){break m}n:{if(I[k|0]!=45){d=g;break n}j=1;o:{switch(l-43|0){case 0:case 2:break o;default:break h}}p:{if((f|0)==5){H[h+24>>2]=h+108;H[h+20>>2]=h+112;H[h+16>>2]=h+116;if((xf(d,16573,h+16|0)|0)!=3){break m}break p}H[h+40>>2]=h+108;H[h+36>>2]=h+112;H[h+32>>2]=h+116;g=d;if((xf(d,16561,h+32|0)|0)!=3){break m}}if(H[h+112>>2]>11|H[h+108>>2]>30){break m}Ye(e);F[e+40|0]=0;d=H[e+12>>2];f=H[e+8>>2];j=H[h+112>>2];k=H[h+116>>2];q:{if((l|0)==45){H[h+108>>2]=0-H[h+108>>2];f=f-k|0;d=d-j|0;break q}f=f+k|0;d=d+j|0}if((d|0)>0){j=(d-1>>>0)/12|0}else{j=0-((12-d>>>0)/12|0)|0}H[e+8>>2]=f+j;H[e+12>>2]=N(j,-12)+d;Ac(e);j=0;G[e+42>>1]=0;k=H[e+4>>2];f=H[e>>2];d=H[h+108>>2];m=sJ(d,d>>31,864e5,0);f=f+m|0;d=Ha+k|0;H[e>>2]=f;H[e+4>>2]=f>>>0<m>>>0?d+1|0:d;d=I[g+11|0];if(!d){break h}j=1;if(!(F[d+31152|0]&1)){break h}H[h+4>>2]=h+100;H[h>>2]=h+104;f=2;d=g+12|0;if((xf(d,14823,h)|0)!=2){break h}}if(I[d+f|0]==58){g=I[d|0];f=h+120|0;Xa(f,0,48);j=1;if(Hq((g-58>>>0<4294967286)+d|0,f)){break h}Ac(f);d=H[h+120>>2];f=H[h+124>>2];Ac(e);j=0;F[e+44|0]=0;G[e+42>>1]=0;k=H[e+4>>2];m=H[e>>2];d=uJ(d-432e5|0,f-(d>>>0<432e5)|0,864e5,0);g=(l|0)==45;l=g?0-d|0:d;f=m+l|0;m=k;k=Ha;d=m+(g?0-(k+((d|0)!=0)|0)|0:k)|0;H[e>>2]=f;H[e+4>>2]=f>>>0<l>>>0?d+1|0:d;break h}f=f+g|0;while(1){d=f;f=d+1|0;if(F[I[d|0]+31152|0]&1){continue}break}j=1;f=bb(d);if(f-11>>>0<4294967288){break h}g=f-1|0;j=I[g+d|0];Ac(e);j=(j&223)==83?g:f;i=M[h+168>>3];u=i<0?-.5:.5;f=0;while(1){r:{if((f|0)==6){j=1}else{g=(f<<4)+51872|0;if((j|0)!=I[g|0]){break r}if(yb(g+1|0,d,j)){break r}q=L[g+8>>2];if(!(+O(-q)<i)|!(+q>i)){break r}s:{t:{u:{switch(f-4|0){case 0:Ye(e);if(P(i)<2147483648){d=~~i}else{d=-2147483648}f=d+H[e+12>>2]|0;v:{if((f|0)>0){j=(f-1>>>0)/12|0;break v}j=0-((12-f>>>0)/12|0)|0}H[e+12>>2]=N(j,-12)+f;H[e+8>>2]=j+H[e+8>>2];break t;case 1:break u;default:break s}}Ye(e);if(P(i)<2147483648){d=~~i}else{d=-2147483648}H[e+8>>2]=d+H[e+8>>2]}F[e+40|0]=0;i=i-+(d|0)}Ac(e);i=i*1e3*+L[g+12>>2]+u;w:{if(P(i)<0x8000000000000000){d=~~i>>>0;if(P(i)>=1){f=~~(i>0?R(T(i*2.3283064365386963e-10),4294967295):U((i-+(~~i>>>0>>>0))*2.3283064365386963e-10))>>>0}else{f=0}break w}d=0;f=-2147483648}j=H[e>>2];g=j+d|0;d=H[e+4>>2]+f|0;H[e>>2]=g;H[e+4>>2]=g>>>0<j>>>0?d+1|0:d;j=0}F[e+44|0]=0;G[e+42>>1]=0;break h}f=f+1|0;continue}}j=1;break h}f=f+1|0;continue}}Ac(e);if(I[e+46|0]){break a}c=H[e+4>>2];if((c|0)==108096&K[e>>2]>275971583|c>>>0>108096){break a}o=0;if(!I[e+42|0]|(b|0)!=1|H[e+16>>2]<29){break a}F[e+42|0]=0;break a}x:{switch(d-115|0){default:y:{switch(d-106|0){default:if((d|0)!=97){break a}if(ab(g,9988)|n>>>0>1){break a}if(I[e+40|0]|!I[e+41|0]){break g}i=M[e+32>>3];if(!(i>=-21086676e4)|!(i<=253402300799)){break f}F[e+44|0]=0;G[e+42>>1]=0;F[e+40|0]=1;i=i*1e3+21086676e7+.5;z:{if(P(i)<0x8000000000000000){d=~~i>>>0;if(P(i)>=1){f=~~(i>0?R(T(i*2.3283064365386963e-10),4294967295):U((i-+(~~i>>>0>>>0))*2.3283064365386963e-10))>>>0}else{f=0}break z}d=0;f=-2147483648}H[e>>2]=d;H[e+4>>2]=f;break g;case 0:if(ab(g,1404)|n>>>0>1|!I[e+40|0]){break a}if(I[e+41|0]){break g}break a;case 1:break a;case 2:break y}}if(ab(g,13853)){break a}if(!Zj(a)){break a}j=_y(e,a);break h;case 2:if(!(ab(g,12372)|!I[e+41|0])){if(n>>>0>1){break a}i=M[e+32>>3]*1e3+21086676e7;if(!(i>=0)|!(i<4642690608e5)){break a}F[e+44|0]=0;H[e+40>>2]=1;i=i+.5;A:{if(P(i)<0x8000000000000000){d=~~i>>>0;if(P(i)>=1){f=~~(i>0?R(T(i*2.3283064365386963e-10),4294967295):U((i-+(~~i>>>0>>>0))*2.3283064365386963e-10))>>>0}else{f=0}break A}d=0;f=-2147483648}H[e>>2]=d;H[e+4>>2]=f;break f}if(ab(g,17449)){break a}if(!Zj(a)){break a}if(I[e+45|0]){break f}Ac(e);g=0;m=0;d=0;j=H[e+4>>2];p=j;l=H[e>>2];f=l;while(1){Xa(t,0,40);F[h+160|0]=1;k=f-g|0;g=j-((f>>>0<g>>>0)+m|0)|0;j=g;f=k;H[h+120>>2]=f;H[h+124>>2]=g;g=h+120|0;if(_y(g,a)){break a}Ac(g);k=H[h+120>>2];g=k-l|0;k=H[h+124>>2]-((k>>>0<l>>>0)+p|0)|0;m=k;if(g|k){k=d>>>0<3;d=d+1|0;if(k){continue}}break};Xa(s,0,40);F[e+45|0]=1;F[e+40|0]=1;H[e>>2]=f;H[e+4>>2]=j;break f;case 4:if(yb(g,29794,8)){break a}d=g+8|0;if((Md(d,h+168|0,bb(d),1)|0)<=0){break a}i=M[h+168>>3];if(!(i>=0)|!(i<7)){break a}if(P(i)<2147483648){d=~~i}else{d=-2147483648}if(+(d|0)!=i){break a}Ye(e);F[e+40|0]=0;F[e+44|0]=0;Ac(e);F[e+44|0]=0;G[e+42>>1]=0;g=d>>31;f=d;j=g;d=H[e+4>>2];k=d;g=H[e>>2];l=g+1296e5|0;d=l>>>0<1296e5?d+1|0:d;d=uJ(tJ(l,d,864e5,0),Ha,7,0);l=Ha;m=(j|0)<=(l|0)&d>>>0>f>>>0|(j|0)<(l|0);p=m?d-7|0:d;f=sJ(f-p|0,j-((f>>>0<p>>>0)+(m?l-(d>>>0<7)|0:l)|0)|0,864e5,0);d=k+Ha|0;f=f+g|0;d=f>>>0<g>>>0?d+1|0:d;H[e>>2]=f;H[e+4>>2]=d;break f;case 1:case 3:break a;case 0:break x}}if(yb(g,29958,9)){if(ab(g,17834)){if(ab(g,14907)){break a}}F[e+47|0]=1;break f}if(!(I[e+40|0]|I[e+42|0]|I[e+43|0])){break a}Kq(e);F[e+43|0]=1;F[e+44|0]=0;H[e+32>>2]=0;H[e+36>>2]=0;H[e+20>>2]=0;H[e+24>>2]=0;G[e+40>>1]=0;d=g+9|0;if(!ab(d,12176)){H[e+16>>2]=1;break f}if(!ab(d,9795)){H[e+12>>2]=1;H[e+16>>2]=1;break f}j=(ab(d,1410)|0)!=0}if(j){break a}break f}F[e+41|0]=0}n=n+1|0;continue}}o=1}Ea=h+176|0;return o}function Kn(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;j=Ea-208|0;Ea=j;a:{if(!(c|e)){break a}g=H[a+248>>2];if(!g){break a}m=H[a>>2];b:{c:{d:{if(!e){if(En(m,H[g>>2])){H[g+28>>2]=H[g+28>>2]|4096}o=m+177|0;if(!I[m+177|0]){break b}f=H[m+172>>2];if(!I[g+43|0]){break c}if(f){break d}H[g+20>>2]=0;break b}if(I[m+177|0]){break d}o=m+177|0;break b}Wa(a,30558,0);break a}H[g+20>>2]=f;if((f|0)!=1){break b}H[g+28>>2]=H[g+28>>2]|1}e:{if(!(d&65536)){break e}H[g+28>>2]=H[g+28>>2]|65536;f=0;while(1){if(G[g+34>>1]<=(f|0)){break e}h=H[g+4>>2]+N(f,12)|0;i=I[h+4|0];if(i>>>0<=15){b=H[h>>2];c=H[g>>2];if(I[h+10|0]&4){v=j,w=ql(h,30558),H[v+168>>2]=w;H[j+164>>2]=b;H[j+160>>2]=c;Wa(a,29660,j+160|0);break a}H[j+148>>2]=b;H[j+144>>2]=c;Wa(a,6205,j+144|0);break a}if((i&240)==16){F[h+5|0]=65}if(!(!(F[h+10|0]&1)|(i&15|G[g+32>>1]==(f|0)))){F[h+4|0]=i|2;H[g+28>>2]=H[g+28>>2]|2048}f=f+1|0;continue}}f:{if(!(d&128)){break f}f=H[g+28>>2];if(f&8){Wa(a,5748,0);break a}if(!(f&4)){H[j+128>>2]=H[g>>2];Wa(a,7010,j+128|0);break a}H[g+28>>2]=f|640;k=H[a+8>>2];n=H[a>>2];if(!(I[n+178|0]&2)){f=0;while(1){if((f|0)<G[g+34>>1]){h=H[g+4>>2]+N(f,12)|0;g:{if(!(F[h+10|0]&1)){break g}i=I[h+4|0];if(i&15){break g}F[h+4|0]=i|2}f=f+1|0;continue}break}H[g+28>>2]=H[g+28>>2]|2048}f=H[a+144>>2];if(f){H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(f,20)|0)+12>>2]=2}f=G[g+32>>1];h:{if((f|0)>=0){f=H[H[g+4>>2]+N(f,12)>>2];H[j+180>>2]=f;v=j,w=bb(f),H[v+184>>2]=w;f=sc(n,59,j+180|0,0);i:{f=Yc(H[a>>2],f);if(f){if(I[a+220|0]>=2){dd(a,H[f+8>>2],g+32|0)}F[f+16|0]=I[a+218|0];G[g+32>>1]=65535;Hi(a,0,0,0,f,I[g+42|0],0,0,0,0,2);if(!H[a+36>>2]){break i}}H[g+28>>2]=H[g+28>>2]&-129;break f}h=jc(g);break h}h=jc(g);f=1;i=1;while(1){if(f>>>0<J[h+50>>1]){j:{if(Ak(h,i,h,f)){G[h+52>>1]=J[h+52>>1]-1;break j}l=H[h+32>>2];H[l+(i<<2)>>2]=H[l+(f<<2)>>2];l=H[h+28>>2];F[l+i|0]=I[f+l|0];l=H[h+4>>2];G[l+(i<<1)>>1]=J[l+(f<<1)>>1];i=i+1|0}f=f+1|0;continue}break}G[h+50>>1]=i}f=I[h+55|0]|I[h+56|0]<<8;i=f|32;F[h+55|0]=i;F[h+56|0]=i>>>8;if(!(I[n+178|0]&2)){f=f|40;F[h+55|0]=f;F[h+56|0]=f>>>8}l=J[h+50>>1];G[h+52>>1]=l;k:{if(!k){break k}f=H[h+44>>2];if(!f){break k}F[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(f,20)|0)|0]=9}H[h+44>>2]=H[g+20>>2];f=g+8|0;while(1){l:{m:{f=H[f>>2];if(!f){f=0;i=G[g+34>>1];i=(i|0)>0?i:0;k=0;while(1){if((f|0)==(i|0)){break m}if(!ms(H[h+4>>2],l,f)){k=!(I[(H[g+4>>2]+N(f,12)|0)+10|0]&32)+k|0}f=f+1|0;continue}}if(((I[f+55|0]|I[f+56|0]<<8)&3)==2){break l}i=0;k=0;while(1){if((i|0)!=(l|0)){k=(Ak(f,J[f+50>>1],h,i)^1)+k|0;i=i+1|0;continue}break}i=J[f+50>>1];if(!k){G[f+52>>1]=i;break l}if(ls(n,f,i+k|0)){break f}k=J[f+50>>1];i=0;while(1){if((i|0)==(l|0)){break l}if(!Ak(f,J[f+50>>1],h,i)){G[H[f+4>>2]+(k<<1)>>1]=J[H[h+4>>2]+(i<<1)>>1];H[H[f+32>>2]+(k<<2)>>2]=H[H[h+32>>2]+(i<<2)>>2];if(I[H[h+28>>2]+i|0]){p=I[f+55|0]|I[f+56|0]<<8|1024;F[f+55|0]=p;F[f+56|0]=p>>>8}k=k+1|0}i=i+1|0;continue}}if(ls(n,h,k+l|0)){break f}f=0;while(1){if((f|0)<G[g+34>>1]){i=H[h+4>>2];if(!(ms(i,l,f)|I[(H[g+4>>2]+N(f,12)|0)+10|0]&32)){G[i+(l<<1)>>1]=f;H[H[h+32>>2]+(l<<2)>>2]=33248;l=l+1|0}f=f+1|0;continue}break}ks(h);break f}f=f+20|0;continue}}l=Fb(m,H[g+60>>2]);f=H[g+16>>2];n:{if(!f){break n}Di(a,g,4,0,f);if(!H[a+36>>2]){break n}pb(m,H[g+16>>2]);H[g+16>>2]=0}o:{if(!(I[g+28|0]&96)){f=G[g+34>>1];break o}k=0;i=0;while(1){f=G[g+34>>1];if((f|0)>(i|0)){f=N(i,12);h=f+H[g+4>>2]|0;p:{if(I[h+10|0]&96){if(!Di(a,g,8,Mc(g,h),0)){break p}vn(a,g,f+H[g+4>>2]|0,sc(m,121,0,0));break p}k=k+1|0}i=i+1|0;continue}break}if(k){break o}Wa(a,11027,0);break a}i=H[g+4>>2];h=0;while(1){if((f|0)>0){f=f-1|0;h=I[i+6|0]+h|0;i=i+12|0;continue}break}v=g,w=Kd((J[g+32>>1]>>>15|0)+h<<2,0),G[v+40>>1]=w;f=g+8|0;while(1){f=H[f>>2];if(f){js(f);f=f+20|0;continue}break}q:{if(!I[o|0]){k=wb(a);if(!k){break a}_a(k,122,0);s=I[g+43|0];r:{if(e){if(I[a+220|0]){H[a+12>>2]=1;H[a+36>>2]=H[a+36>>2]+1;break a}h=H[a+44>>2];i=h+3|0;H[a+44>>2]=i;d=H[a+128>>2];F[(d?d:a)+21|0]=1;Ua(k,113,1,H[a+100>>2],l);f=H[k+108>>2];if((f|0)>0){G[(H[k+104>>2]+N(f,20)|0)-18>>1]=16}H[a+40>>2]=2;o=h+1|0;Ua(k,11,o,0,f+1|0);if(H[a+36>>2]){break a}d=un(a,e,65);if(!d){break a}n=J[d+34>>1];G[g+34>>1]=n;G[g+36>>1]=n;H[g+4>>2]=H[d+4>>2];H[d+4>>2]=0;G[d+34>>1]=0;Cd(m,d);H[j+196>>2]=0;H[j+200>>2]=0;H[j+188>>2]=0;H[j+192>>2]=0;H[j+184>>2]=o;F[j+180|0]=13;Lc(a,e,j+180|0);if(H[a+36>>2]){break a}Ci(k,o);o=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(f,20)|0)+8>>2]=o;f=_a(k,12,H[j+184>>2]);h=h+2|0;Ua(k,97,H[j+192>>2],H[j+196>>2],h);d=0;yg(k,g,0);Sa(k,127,1,i);Ua(k,128,1,h,i);Qb(k,f);h=H[k+108>>2];H[(I[H[k>>2]+87|0]?73336:H[k+104>>2]+N(f,20)|0)+8>>2]=h;_a(k,122,1);f=G[g+34>>1];o=(f|0)>0?f:0;h=H[g+4>>2];i=0;while(1){if((i|0)!=(o|0)){i=i+1|0;d=(is(H[h>>2])+d|0)+5|0;h=h+12|0;continue}break}d=is(H[g>>2])+d|0;p=(d+N(f,6)|0)+35|0;q=bc(p,p>>31);if(!q){Ib(m);break r}d=(d|0)<50;u=d?27576:27575;f=d?24843:30530;n=Bd(p,q,30384,0);v=j,w=bb(n),H[v+180>>2]=w;hs(n,j+180|0,H[g>>2]);h=H[j+180>>2];F[h+n|0]=40;d=d?30558:30531;i=h+1|0;h=H[g+4>>2];o=0;while(1){r=i+n|0;t=p-i|0;if((o|0)<G[g+34>>1]){v=j,w=bb(Bd(t,r,d,0))+i|0,H[v+180>>2]=w;hs(n,j+180|0,H[h>>2]);d=H[j+180>>2];r=H[(F[h+5|0]<<2)+49740>>2];i=bb(r);Va(d+n|0,r,i);i=d+i|0;H[j+180>>2]=i;h=h+12|0;o=o+1|0;d=f;continue}break}H[j+112>>2]=u;Bd(t,r,8863,j+112|0);break r}d=d?a+208|0:c;f=H[d>>2];h=H[a+200>>2];i=f-h|0;i=I[f|0]!=59?H[d+4>>2]+i|0:i;H[j+104>>2]=h;H[j+100>>2]=i;H[j+96>>2]=s?18679:20287;q=mb(m,6001,j+96|0)}f=H[H[m+16>>2]+(l<<4)>>2];d=H[g>>2];h=H[a+100>>2];H[j+88>>2]=H[a+96>>2];H[j+84>>2]=q;H[j+80>>2]=h;H[j+76>>2]=d;H[j+72>>2]=d;H[j+68>>2]=s?1851:14316;H[j+64>>2]=f;kc(a,16784,j- -64|0);Za(m,q);Kf(a,l);s:{if(I[a+220|0]|!(I[g+28|0]&8)){break s}d=H[m+16>>2]+(l<<4)|0;if(H[H[d+12>>2]+72>>2]){break s}H[j+48>>2]=H[d>>2];kc(a,25244,j+48|0)}H[j+32>>2]=H[g>>2];oh(k,l,mb(m,28087,j+32|0),0);if(I[g+28|0]&96){d=H[H[m+16>>2]+(l<<4)>>2];H[j+20>>2]=H[g>>2];H[j+16>>2]=d;fb(k,148,1,0,0,mb(m,29080,j+16|0),-6)}d=H[H[m+16>>2]+(l<<4)>>2];H[j+4>>2]=H[g>>2];H[j>>2]=d;fb(k,148,1,0,0,mb(m,25666,j),-6);if(!I[m+177|0]){break q}}if(od(H[g+60>>2]+8|0,H[g>>2],g)){Ib(m);break a}H[a+248>>2]=0;H[m+24>>2]=H[m+24>>2]|1;if(Tc(H[g>>2],14706)){break q}H[H[g+60>>2]+72>>2]=g}if(I[g+43|0]|e){break a}H[g+44>>2]=(H[(H[b>>2]?b:c)>>2]-H[a+200>>2]|0)+13}Ea=j+208|0}function Hi(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;m=Ea-224|0;Ea=m;o=H[a>>2];H[m+168>>2]=0;H[m+164>>2]=0;a:{if(H[a+36>>2]|I[a+220|0]==1&(k|0)!=2){break a}if(ze(a)){break a}if(Hk(a,e)){break a}b:{c:{d:{if(d){b=Lf(a,b,c,m+168|0);if((b|0)<0){break a}e:{if(I[o+177|0]){break e}n=rh(a,d);if(H[c+4>>2]|!n){break e}b=H[n+60>>2]==H[H[o+16>>2]+28>>2]?1:b}c=H[a>>2];H[m+172>>2]=a;c=H[c+16>>2]+(b<<4)|0;H[m+212>>2]=H[c>>2];H[m+204>>2]=H[c+12>>2];H[m+176>>2]=a;H[m+180>>2]=11;H[m+184>>2]=12;H[m+188>>2]=13;H[m+192>>2]=0;G[m+196>>1]=0;F[m+208|0]=(b|0)==1;H[m+216>>2]=1554;t=H[m+168>>2];H[m+220>>2]=t;c=m+172|0;H[m+200>>2]=c;Fn(c,d);c=df(a,0,d+8|0);if(!c){break a}if(!(H[H[o+16>>2]+28>>2]==H[c+60>>2]|(b|0)!=1)){H[m+144>>2]=H[c>>2];Wa(a,29590,m+144|0);break c}s=0;if(!(I[c+28|0]&128)){break d}s=jc(c);break d}c=H[a+248>>2];if(!c){break a}b=Fb(o,H[c+60>>2]);s=0}l=H[o+16>>2];n=H[c>>2];if(!(yb(n,18214,7)|!d|I[o+177|0])){H[m>>2]=n;Wa(a,15367,m);break c}f:{switch(I[c+43|0]-1|0){case 1:Wa(a,15308,0);break b;case 0:Wa(a,15333,0);break b;default:break f}}p=(b<<4)+l|0;g:{h:{i:{if(t){q=tc(o,t);if(!q){break c}if(Ik(a,q,1554,H[c>>2])){break b}if(I[a+220|0]>1){break g}j:{if(I[o+177|0]){break j}if(!yc(o,q,H[p>>2])){break j}H[m+128>>2]=q;Wa(a,7233,m+128|0);break b}if(!ef(o,q,H[p>>2])){break i}if(!j){H[m+112>>2]=q;Wa(a,3747,m+112|0);break b}ld(a,b);Gk(a);break b}q=c+8|0;j=1;while(1){l=H[q>>2];if(l){j=j+1|0;q=l+20|0;continue}break}H[m+100>>2]=j;H[m+96>>2]=n;q=mb(o,16608,m+96|0);if(!q){break c}if(!I[a+220|0]){break h}F[q+7|0]=I[q+7|0]+1}if(I[a+220|0]>1){break g}}j=(b|0)==1;n=H[p>>2];if(Yb(a,18,j?9192:9211,0,n)){break b}if(Yb(a,j?3:1,q,H[c>>2],n)){break b}}k:{if(!e){e=H[c+4>>2]+N(G[c+34>>1],12)|0;j=e-2|0;G[j>>1]=J[j>>1]|8;e=H[e-12>>2];H[m+156>>2]=e;w=m,x=bb(e),H[w+160>>2]=x;e=sc(o,59,m+156|0,0);e=Yc(H[a>>2],e);if(e){F[(H[e>>2]<<4)+e|0]=(i|0)!=-1?i:0;break k}e=0;break b}zs(a,e,1554);if(H[a+36>>2]){break b}}n=0;l=H[e>>2];r=(l|0)>0?l:0;j=e+8|0;i=0;while(1){if((i|0)!=(r|0)){u=H[(i<<4)+j>>2];if(I[u|0]==113){n=(bb(H[u+8>>2])+n|0)+1|0}i=i+1|0;continue}break}i=bb(q);l=ds(o,l+(s?J[s+50>>1]:1)<<16>>16,(i+n|0)+1|0,m+164|0);l:{if(!I[o+87|0]){r=H[m+164>>2];H[l>>2]=r;i=i+1|0;n=i+r|0;H[m+164>>2]=n;Va(r,q,i);F[l+54|0]=f;H[l+12>>2]=c;i=(I[l+55|0]|I[l+56|0]<<8)&65524|(k&3|((f|0)!=0)<<3);F[l+55|0]=i;F[l+56|0]=i>>>8;H[l+24>>2]=H[(H[o+16>>2]+(b<<4)|0)+12>>2];G[l+50>>1]=H[e>>2];if(h){Di(a,c,2,h,0);H[l+36>>2]=h}h=I[H[p+12>>2]+76|0];if(I[a+220|0]>=2){H[l+40>>2]=e;e=0}u=h>>>0>3;p=0;while(1){if(J[l+50>>1]>p>>>0){es(H[j>>2]);h=0;Di(a,c,32,H[j>>2],0);if(H[a+36>>2]){break l}i=Jf(H[j>>2]);m:{if(I[i|0]!=167){if(H[a+248>>2]==(c|0)){Wa(a,3898,0);break l}if(!H[l+40>>2]){H[l+40>>2]=e;e=0}G[H[l+4>>2]+(p<<1)>>1]=65534;i=(I[l+55|0]|I[l+56|0]<<8)&61431|4096;F[l+55|0]=i;F[l+56|0]=i>>>8;r=-2;break m}r=G[i+32>>1];n:{if((r|0)<0){r=G[c+32>>1];break n}v=N(r,12);i=H[c+4>>2];if(!(I[(v+i|0)+4|0]&15)){i=(I[l+55|0]|I[l+56|0]<<8)&65527;F[l+55|0]=i;F[l+56|0]=i>>>8;i=H[c+4>>2]}if(!(I[(i+v|0)+10|0]&32)){break n}i=I[l+55|0]|I[l+56|0]<<8|6144;F[l+55|0]=i;F[l+56|0]=i>>>8}G[H[l+4>>2]+(p<<1)>>1]=r}i=H[j>>2];o:{if(I[i|0]==113){r=H[i+8>>2];i=bb(r)+1|0;i=Va(n,r,i)+i|0;H[m+164>>2]=i;break o}if((r|0)<0){i=n;n=0;break o}i=n;n=Yf(H[c+4>>2]+N(r,12)|0)}n=n?n:33248;if(!I[o+177|0]){if(!Fi(a,n)){break l}}H[H[l+32>>2]+(p<<2)>>2]=n;F[H[l+28>>2]+p|0]=u?I[j+8|0]:0;j=j+16|0;p=p+1|0;n=i;continue}break}p:{if(s){h=0;while(1){if(J[s+50>>1]<=h>>>0){break p}q:{if(Ak(l,J[l+50>>1],s,h)){G[l+52>>1]=J[l+52>>1]-1;break q}G[H[l+4>>2]+(p<<1)>>1]=J[H[s+4>>2]+(h<<1)>>1];H[H[l+32>>2]+(p<<2)>>2]=H[H[s+32>>2]+(h<<2)>>2];F[H[l+28>>2]+p|0]=I[H[s+28>>2]+h|0];p=p+1|0}h=h+1|0;continue}}G[H[l+4>>2]+(p<<1)>>1]=65535;H[H[l+32>>2]+(p<<2)>>2]=33248}tt(l);if(!H[a+248>>2]){js(l)}ks(l);r:{if(!d|J[l+52>>1]<G[c+34>>1]){break r}i=I[l+55|0]|I[l+56|0]<<8;h=i|32;F[l+55|0]=h;F[l+56|0]=h>>>8;h=0;j=G[c+34>>1];j=(j|0)>0?j:0;while(1){if((h|0)==(j|0)){break r}s:{if(G[c+32>>1]==(h|0)){break s}if((Re(l,h<<16>>16)|0)>=0){break s}h=i&65503;F[l+55|0]=h;F[l+56|0]=h>>>8;break r}h=h+1|0;continue}}t:{u:{v:{w:{if(H[a+248>>2]!=(c|0)){break w}h=c+8|0;while(1){i=H[h>>2];if(!i){break w}x:{j=J[i+50>>1];if((j|0)!=J[l+50>>1]){break x}h=0;y:{while(1){if((h|0)==(j|0)){break y}z:{n=h<<1;if(J[n+H[i+4>>2]>>1]!=J[n+H[l+4>>2]>>1]){break z}n=h<<2;if(ab(H[n+H[i+32>>2]>>2],H[n+H[l+32>>2]>>2])){break z}h=h+1|0;continue}break}if((h|0)!=(j|0)){break x}}b=I[i+54|0];f=I[l+54|0];A:{if((b|0)==(f|0)){break A}if(!((b|0)==11|(f|0)==11)){H[m+80>>2]=0;Wa(a,16299,m+80|0);b=I[i+54|0]}if((b&255)!=11){break A}F[i+54|0]=I[l+54|0]}if((k|0)==2){b=(I[i+55|0]|I[i+56|0]<<8)&65532|2;F[i+55|0]=b;F[i+56|0]=b>>>8}h=0;if(I[a+220|0]<2){break l}H[l+20>>2]=H[a+252>>2];break v}h=i+20|0;continue}}B:{if(I[a+220|0]>1){break B}if(I[o+177|0]){C:{if(!d){break C}H[l+44>>2]=H[o+172>>2];if(!ut(l)){break C}h=0;Wa(a,14544,0);w=a,x=Ya(125033),H[w+12>>2]=x;break l}if(od(H[l+24>>2]+24|0,H[l>>2],l)){Ib(o);h=0;break l}H[o+24>>2]=H[o+24>>2]|1;break B}if(!(H[c+28>>2]&128?d:1)){break B}i=H[a+44>>2]+1|0;H[a+44>>2]=i;h=wb(a);if(!h){break t}kd(a,1,b);w=l,x=Mb(h,187),H[w+44>>2]=x;Ua(h,147,b,i,2);if(g){g=H[a+208>>2];j=H[a+212>>2];k=I[(g+j|0)-1|0];n=H[t>>2];H[m+72>>2]=n;H[m+64>>2]=f?20225:30558;H[m+68>>2]=(j+(g-n|0)|0)-((k|0)==59);f=mb(o,6016,m- -64|0)}else{f=0}g=H[H[o+16>>2]+(b<<4)>>2];j=H[l>>2];k=H[c>>2];H[m+48>>2]=f;H[m+44>>2]=i;H[m+40>>2]=k;H[m+36>>2]=j;H[m+32>>2]=g;kc(a,21778,m+32|0);Za(o,f);if(d){rn(a,l,i);Kf(a,b);H[m+16>>2]=H[l>>2];oh(h,b,mb(o,27713,m+16|0),0);Sa(h,166,0,1)}f=H[h+108>>2];H[(I[H[h>>2]+87|0]?73336:H[h+104>>2]+N(H[l+44>>2],20)|0)+8>>2]=f}if(!(I[o+177|0]?0:d)){H[l+20>>2]=H[c+8>>2];H[c+8>>2]=l;break u}if(I[a+220|0]<2){break t}}H[a+252>>2]=l}h=0;break b}h=0}if(!l){break b}}Zk(o,l);break b}q=0}c=c+8|0;while(1){b=c;f=H[c>>2];if(!f){break a}c=f+20|0;if(I[f+54|0]!=5){continue}break}while(1){a=H[c>>2];if(!a|I[a+54|0]==5){break a}H[b>>2]=a;H[f+20>>2]=H[a+20>>2];H[a+20>>2]=f;b=a+20|0;continue}}eb(o,h);pb(o,e);Cc(o,d);Za(o,q);Ea=m+224|0}
function vb(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;e=Ea-208|0;Ea=e;a:{if(bs(a)){d=Rc(90775);break a}w=a+104|0;s=a+136|0;n=H[a>>2];h=n;while(1){b:{c:{d=I[a+151|0];if((d|0)==2){break c}while(1){d:{switch((d&255)-1|0){case 0:if(I[a+152|0]&3){H[a+36>>2]=17;d=1;if(F[a+150|0]>=0){break b}d=pn(a);break b}d=H[h+184>>2];if(!d){H[h+296>>2]=0}if(!(!H[a+200>>2]|(I[h+177|0]|!(I[h+94|0]&130)))){nn(H[h>>2],s);d=H[h+184>>2]}H[h+184>>2]=d+1;c=J[a+152>>1];if(!(c&64)){H[h+192>>2]=H[h+192>>2]+1;c=J[a+152>>1]}if(c&128){H[h+188>>2]=H[h+188>>2]+1}F[a+151|0]=2;H[a+32>>2]=0;break c;case 2:break d;default:break c}}ob(a);d=I[a+151|0];continue}}e:{f:{g:{h:{c=J[a+152>>1]&12;if(c){j=H[a+88>>2];q=j+40|0;o=H[a>>2];b=1;b=(c|0)!=4?F[o+35|0]&1:b;ki(q,8);if(H[a+36>>2]==7){Ib(o);d=1;break e}g=0;i=0;f=J[a+152>>1]&12;p=H[a+108>>2];i=b?H[a+88>>2]+360|0:i;if(!i){m=0;break h}d=0;m=0;if(I[i+16|0]&16){m=H[i+8>>2];g=H[i+12>>2]>>>2|0}while(1){if((d|0)==(g|0)){break h}p=H[H[(d<<2)+m>>2]+4>>2]+p|0;d=d+1|0;continue}}H[h+196>>2]=H[h+196>>2]+1;d=Rr(a);H[h+196>>2]=H[h+196>>2]-1;if((d|0)!=100){break e}break g}c=H[a+32>>2];x=(f|0)!=8;while(1){l=c+1|0;if((c|0)>=(p|0)){H[a+36>>2]=0;d=101;break f}f=w;i:{d=c;b=H[a+108>>2];if((c|0)<(b|0)){break i}d=c-b|0;b=0;while(1){f=H[(b<<2)+m>>2];k=H[f+4>>2];if((k|0)>(d|0)){break i}b=b+1|0;d=d-k|0;continue}}t=H[f>>2];j:{if(!i){break j}r=t+N(d,20)|0;if(I[r+1|0]!=252){break j}b=0;f=(g|0)>0?g:0;k=g+1|0;u=k<<2;while(1){k:{if((b|0)!=(f|0)){if(H[(b<<2)+m>>2]!=H[r+16>>2]){break k}}else{b=f}if((b|0)!=(g|0)){break j}b=mh(i,u,(g|0)!=0);H[a+36>>2]=b;if(b){d=1;break f}m=H[i+8>>2];H[m+(g<<2)>>2]=H[r+16>>2];H[i+12>>2]=u;G[i+16>>1]=J[i+16>>1]&62016|16;p=H[H[r+16>>2]+4>>2]+p|0;g=k;break j}b=b+1|0;continue}}l:{if(x){break l}b=I[t+N(d,20)|0];if((b|0)==188){break l}f=(c|0)<=0;c=l;if(f|(b|0)!=8){continue}}break}H[a+32>>2]=l;if(H[o+296>>2]){H[a+36>>2]=9;Kc(a,15482,0);d=1;break e}G[e+204>>1]=0;H[e+200>>2]=0;H[e+192>>2]=0;H[e+196>>2]=1e9;H[e+184>>2]=0;H[e+188>>2]=0;b=11540;m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{c=t+N(d,20)|0;switch(I[c+1|0]-241|0){case 11:break n;case 10:break q;case 1:break r;case 4:break s;case 5:break t;case 3:break u;case 12:break v;case 2:break w;case 0:break x;case 8:break y;case 13:break z;case 7:break A;default:break p}}f=H[c+16>>2];H[e+16>>2]=J[f+6>>1];lb(e+184|0,16712,e+16|0);k=f+20|0;b=0;while(1){if(J[f+6>>1]>b>>>0){l=I[H[f+16>>2]+b|0];g=H[k+(b<<2)>>2];if(g){g=H[g>>2]}else{g=30558}y=e,z=Tc(g,33248)?g:20819,H[y+8>>2]=z;H[e+4>>2]=l&2?24837:30558;H[e>>2]=l&1?24841:30558;lb(e+184|0,6098,e);b=b+1|0;continue}break}sb(e+184|0,27576,1);break m}b=H[c+16>>2];f=I[b+4|0];H[e+32>>2]=H[b>>2];H[e+36>>2]=H[(f<<2)+33264>>2];lb(e+184|0,6448,e+32|0);break m}b=H[c+16>>2];f=H[b+32>>2];H[e+52>>2]=F[b|0];H[e+48>>2]=f;lb(e+184|0,25473,e+48|0);break m}b=H[H[c+16>>2]+4>>2];f=H[b+32>>2];H[e+68>>2]=F[b|0];H[e+64>>2]=f;lb(e+184|0,25473,e- -64|0);break m}b=H[c+16>>2];f=H[b+4>>2];H[e+80>>2]=H[b>>2];H[e+84>>2]=f;lb(e+184|0,14968,e+80|0);break m}H[e+96>>2]=H[c+16>>2];lb(e+184|0,17442,e+96|0);break m}M[e+112>>3]=M[H[c+16>>2]>>3];lb(e+184|0,12564,e+112|0);break m}b=H[c+16>>2];f=J[b+16>>1];if(f&2){g=b+8|0;break o}if(f&36){f=H[b+4>>2];H[e+144>>2]=H[b>>2];H[e+148>>2]=f;lb(e+184|0,14968,e+144|0);break m}if(f&8){M[e+128>>3]=M[b>>3];lb(e+184|0,12564,e+128|0);break m}b=f&1?20140:25593;break n}H[e+160>>2]=H[H[c+16>>2]+8>>2];lb(e+184|0,9966,e+160|0);break m}f=H[c+16>>2];g=H[f>>2];b=1;while(1){if(b>>>0<=g>>>0){H[e+180>>2]=H[f+(b<<2)>>2];H[e+176>>2]=(b|0)==1?91:44;lb(e+184|0,1873,e+176|0);b=b+1|0;continue}break}sb(e+184|0,18352,1);break m}g=H[c+16>>2];break o}g=c+16|0}b=H[g>>2];if(!b){break m}}Vd(e+184|0,b)}if(I[e+204|0]&7){Ib(o)}f=Jd(e+184|0);B:{if((J[a+152>>1]&12)==8){b=H[c+4>>2];Bc(q,b,b>>31);b=H[c+8>>2];Bc(j+80|0,b,b>>31);c=H[c+12>>2];Bc(j+120|0,c,c>>31);c=160;break B}Bc(q,d,d>>31);hd(j+80|0,H[(I[c|0]<<2)+33280>>2],-1,-1,1,0);b=H[c+4>>2];Bc(j+120|0,b,b>>31);b=H[c+8>>2];Bc(j+160|0,b,b>>31);b=H[c+12>>2];Bc(j+200|0,b,b>>31);Bc(j+280|0,J[c+2>>1],0);Xb(j+320|0);c=240}d=1;hd(c+j|0,f,-1,-1,1,1);H[a+120>>2]=q;c=I[o+87|0];H[a+36>>2]=c?7:0;if(c){break e}}d=100;H[h+64>>2]=100;break a}H[a+32>>2]=l}c=H[s>>2];b=H[s+4>>2];if((b|0)>0){c=1}else{c=!!c&(b|0)>=0}if(c){Dr(h,a)}H[a+120>>2]=0;C:{if((d|0)==101){if(!I[h+85|0]){d=101;break C}d=0;f=0;while(1){if(H[h+20>>2]>(d|0)){g=H[h+16>>2]+(d<<4)|0;c=H[g+4>>2];D:{if(!c){break D}b=H[c+4>>2];H[b+4>>2]=H[c>>2];c=H[H[b>>2]+232>>2];if(!c){break D}b=H[c+12>>2];H[c+12>>2]=0;if((b|0)<=0){break D}c=H[h+268>>2];if(!c|f){break D}f=Ia[c|0](H[h+272>>2],h,H[g>>2],b)|0}d=d+1|0;continue}break}H[a+36>>2]=f;d=f?1:101;break C}if(F[a+150|0]>=0){break C}d=pn(a)}H[h+64>>2]=d;if((gd(H[a>>2],H[a+36>>2])|0)!=7){break b}H[a+36>>2]=7;d=F[a+150|0]<0?7:d}d=H[h+72>>2]&d;if((d|0)!=17){break a}if((v|0)==50){d=17;break a}l=H[a+32>>2];d=Ea-256|0;Ea=d;b=H[a>>2];g=xk(b,a?H[a+200>>2]:0,-1,I[a+150|0],a,d+12|0,0);E:{if(g){if((g|0)!=7){break E}Ib(b);break E}c=d+16|0;b=H[d+12>>2];Va(c,b,240);b=Va(b,a,240);c=Va(a,c,240);f=H[b+8>>2];H[b+8>>2]=H[c+8>>2];H[c+8>>2]=f;f=H[b+4>>2];H[b+4>>2]=H[c+4>>2];H[c+4>>2]=f;f=H[b+200>>2];H[b+200>>2]=H[c+200>>2];H[c+200>>2]=f;f=H[b+204>>2];H[b+204>>2]=H[c+204>>2];H[c+204>>2]=f;H[c+228>>2]=H[b+228>>2];F[c+150|0]=I[b+150|0];Va(c+164|0,b+164|0,36);H[c+184>>2]=H[c+184>>2]+1;f=0;while(1){if(G[b+16>>1]>(f|0)){k=N(f,40);hw(k+H[c+100>>2]|0,k+H[b+100>>2]|0);f=f+1|0;continue}break}c=H[d+12>>2];H[c+36>>2]=0;Cf(c)}Ea=d+256|0;F:{if(g){c=$a(H[n+288>>2]);Za(n,H[a+124>>2]);if(I[n+87|0]){break F}y=a,z=Tb(n,c),H[y+124>>2]=z;d=gd(n,g);H[a+36>>2]=d;break a}ob(a);if((l|0)>=0){F[a+149|0]=254}v=v+1|0;h=H[a>>2];continue}break}d=7;H[a+36>>2]=7;H[a+124>>2]=0}Ea=e+208|0;return d|0}function Ap(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,A=0,D=0;p=Ea-48|0;Ea=p;C(+a);l=x(1)|0;c=x(0)|0;a:{b:{j=l&2147483647;c:{if(j>>>0<=1074752122){if((l&1048575)==598523){break c}if(j>>>0<=1073928572){if((l|0)>0|(l|0)>=0){a=a+-1.5707963267341256;f=a+-6077100506506192e-26;M[b>>3]=f;M[b+8>>3]=a-f+-6077100506506192e-26;d=1;break a}a=a+1.5707963267341256;f=a+6077100506506192e-26;M[b>>3]=f;M[b+8>>3]=a-f+6077100506506192e-26;d=-1;break a}if((l|0)>0|(l|0)>=0){a=a+-3.1415926534682512;f=a+-1.2154201013012384e-10;M[b>>3]=f;M[b+8>>3]=a-f+-1.2154201013012384e-10;d=2;break a}a=a+3.1415926534682512;f=a+1.2154201013012384e-10;M[b>>3]=f;M[b+8>>3]=a-f+1.2154201013012384e-10;d=-2;break a}if(j>>>0<=1075594811){if(j>>>0<=1075183036){if((j|0)==1074977148){break c}if((l|0)>0|(l|0)>=0){a=a+-4.712388980202377;f=a+-1.8231301519518578e-10;M[b>>3]=f;M[b+8>>3]=a-f+-1.8231301519518578e-10;d=3;break a}a=a+4.712388980202377;f=a+1.8231301519518578e-10;M[b>>3]=f;M[b+8>>3]=a-f+1.8231301519518578e-10;d=-3;break a}if((j|0)==1075388923){break c}if((l|0)>0|(l|0)>=0){a=a+-6.2831853069365025;f=a+-2.430840202602477e-10;M[b>>3]=f;M[b+8>>3]=a-f+-2.430840202602477e-10;d=4;break a}a=a+6.2831853069365025;f=a+2.430840202602477e-10;M[b>>3]=f;M[b+8>>3]=a-f+2.430840202602477e-10;d=-4;break a}if(j>>>0>1094263290){break b}}k=a*.6366197723675814+6755399441055744+-6755399441055744;f=a+k*-1.5707963267341256;m=k*6077100506506192e-26;v=f-m;c=v<-.7853981633974483;if(P(k)<2147483648){d=~~k}else{d=-2147483648}d:{if(c){d=d-1|0;k=k+-1;m=k*6077100506506192e-26;f=a+k*-1.5707963267341256;break d}if(!(v>.7853981633974483)){break d}d=d+1|0;k=k+1;m=k*6077100506506192e-26;f=a+k*-1.5707963267341256}a=f-m;M[b>>3]=a;C(+a);c=x(1)|0;x(0)|0;l=j>>>20|0;e:{if((l-(c>>>20&2047)|0)<17){break e}m=f;a=k*6077100506303966e-26;f=f-a;m=k*20222662487959506e-37-(m-f-a);a=f-m;M[b>>3]=a;C(+a);c=x(1)|0;x(0)|0;if((l-(c>>>20&2047)|0)<50){break e}m=f;a=k*20222662487111665e-37;f=f-a;m=k*84784276603689e-45-(m-f-a);a=f-m;M[b>>3]=a}M[b+8>>3]=f-a-m;break a}if(j>>>0>=2146435072){a=a-a;M[b>>3]=a;M[b+8>>3]=a;break a}d=p+16|0;e=d|8;z(0,c|0);z(1,l&1048575|1096810496);a=+B();c=1;while(1){if(P(a)<2147483648){i=~~a}else{i=-2147483648}f=+(i|0);M[d>>3]=f;a=(a-f)*16777216;i=c;c=0;d=e;if(i){continue}break}M[p+32>>3]=a;d=2;while(1){c=d;d=c-1|0;t=p+16|0;if(M[t+(c<<3)>>3]==0){continue}break}e=0;g=Ea-560|0;Ea=g;d=(j>>>20|0)-1046|0;i=(d-3|0)/24|0;u=(i|0)>0?i:0;i=N(u,-24)+d|0;q=H[15641];r=c+1|0;h=r-1|0;if((q+h|0)>=0){d=q+r|0;c=u-h|0;while(1){M[(g+320|0)+(e<<3)>>3]=(c|0)<0?0:+H[(c<<2)+62576>>2];c=c+1|0;e=e+1|0;if((d|0)!=(e|0)){continue}break}}j=i-24|0;d=0;e=(q|0)>0?q:0;o=(r|0)<=0;while(1){f:{if(o){a=0;break f}n=d+h|0;c=0;a=0;while(1){a=M[(c<<3)+t>>3]*M[(g+320|0)+(n-c<<3)>>3]+a;c=c+1|0;if((r|0)!=(c|0)){continue}break}}M[(d<<3)+g>>3]=a;c=(d|0)==(e|0);d=d+1|0;if(!c){continue}break}A=47-i|0;w=48-i|0;y=(i|0)<25;D=i-25|0;d=q;while(1){g:{a=M[(d<<3)+g>>3];c=0;e=d;n=(d|0)<=0;if(!n){while(1){o=(g+480|0)+(c<<2)|0;f=a*5.960464477539063e-8;h:{if(P(f)<2147483648){h=~~f;break h}h=-2147483648}f=+(h|0);a=f*-16777216+a;i:{if(P(a)<2147483648){h=~~a;break i}h=-2147483648}H[o>>2]=h;e=e-1|0;a=M[(e<<3)+g>>3]+f;c=c+1|0;if((d|0)!=(c|0)){continue}break}}a=Dj(a,j);a=a+T(a*.125)*-8;j:{if(P(a)<2147483648){o=~~a;break j}o=-2147483648}a=a-+(o|0);k:{l:{m:{n:{if(!y){e=(d<<2)+g|0;h=H[e+476>>2];c=h>>w;s=e;e=h-(c<<w)|0;H[s+476>>2]=e;o=c+o|0;h=e>>A;break n}if(j){break m}h=H[((d<<2)+g|0)+476>>2]>>23}if((h|0)<=0){break k}break l}h=2;if(a>=.5){break l}h=0;break k}c=0;e=0;if(!n){while(1){n=(g+480|0)+(c<<2)|0;s=H[n>>2];o:{p:{if(e){e=16777215}else{if(!s){break p}e=16777216}H[n>>2]=e-s;e=1;break o}e=0}c=c+1|0;if((d|0)!=(c|0)){continue}break}}q:{if(y){break q}c=8388607;r:{switch(D|0){case 1:c=4194303;break;case 0:break r;default:break q}}n=(d<<2)+g|0;H[n+476>>2]=H[n+476>>2]&c}o=o+1|0;if((h|0)!=2){break k}a=1-a;h=2;if(!e){break k}a=a-Dj(1,j)}s:{t:{if(a==0){e=0;c=d;if((q|0)>=(c|0)){break s}while(1){c=c-1|0;e=H[(g+480|0)+(c<<2)>>2]|e;if((c|0)>(q|0)){continue}break}if(!e){break s}i=j;while(1){i=i-24|0;d=d-1|0;if(!H[(g+480|0)+(d<<2)>>2]){continue}break}break t}a=Dj(a,24-i|0);u:{if(a>=16777216){j=(g+480|0)+(d<<2)|0;f=a*5.960464477539063e-8;v:{if(P(f)<2147483648){c=~~f;break v}c=-2147483648}a=+(c|0)*-16777216+a;w:{if(P(a)<2147483648){e=~~a;break w}e=-2147483648}H[j>>2]=e;d=d+1|0;break u}if(P(a)<2147483648){c=~~a}else{c=-2147483648}i=j}H[(g+480|0)+(d<<2)>>2]=c}a=Dj(1,i);if((d|0)>=0){c=d;while(1){e=c;M[(c<<3)+g>>3]=a*+H[(g+480|0)+(c<<2)>>2];c=c-1|0;a=a*5.960464477539063e-8;if(e){continue}break}e=d;while(1){a=0;c=0;i=d-e|0;j=(i|0)>(q|0)?q:i;if((j|0)>=0){while(1){a=M[(c<<3)+65344>>3]*M[(c+e<<3)+g>>3]+a;n=(c|0)!=(j|0);c=c+1|0;if(n){continue}break}}M[(g+160|0)+(i<<3)>>3]=a;c=(e|0)>0;e=e-1|0;if(c){continue}break}}a=0;if((d|0)>=0){c=d;while(1){e=c;c=c-1|0;a=a+M[(g+160|0)+(e<<3)>>3];if(e){continue}break}}M[p>>3]=h?-a:a;a=M[g+160>>3]-a;c=1;if((d|0)>0){while(1){a=a+M[(g+160|0)+(c<<3)>>3];e=(c|0)!=(d|0);c=c+1|0;if(e){continue}break}}M[p+8>>3]=h?-a:a;Ea=g+560|0;d=o&7;break g}c=1;while(1){e=c;c=c+1|0;if(!H[(g+480|0)+(q-e<<2)>>2]){continue}break}e=d+e|0;while(1){h=d+r|0;d=d+1|0;M[(g+320|0)+(h<<3)>>3]=H[(u+d<<2)+62576>>2];c=0;a=0;if((r|0)>0){while(1){a=M[(c<<3)+t>>3]*M[(g+320|0)+(h-c<<3)>>3]+a;c=c+1|0;if((r|0)!=(c|0)){continue}break}}M[(d<<3)+g>>3]=a;if((d|0)<(e|0)){continue}break}d=e;continue}break}a=M[p>>3];if((l|0)<0){M[b>>3]=-a;M[b+8>>3]=-M[p+8>>3];d=0-d|0;break a}M[b>>3]=a;M[b+8>>3]=M[p+8>>3]}Ea=p+48|0;return d}function DF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,J=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0;d=Ea-208|0;Ea=d;a:{if((b|0)>=7){Gb(a,26557,-1);break a}if(Rl(a,3415,H[c>>2],d+12|0)){break a}t=15;u=-1;z=21723;G=21729;J=21719;b:{switch(b-2|0){case 4:t=kb(H[c+20>>2]);case 3:u=kb(H[c+16>>2]);case 2:z=$a(H[c+12>>2]);case 1:G=$a(H[c+8>>2]);case 0:J=$a(H[c+4>>2]);break;default:break b}}if(J?!z|!G:1){Ub(a);break a}if(!t){qb(a,30558,-1,0);break a}m=H[d+12>>2];if(Yl(a,m)){break a}M=H[m>>2];H[d+128>>2]=0;H[d+120>>2]=0;H[d+124>>2]=0;if(!H[m+16>>2]){qb(a,30558,0,0);break a}b=(t|0)<=-64?-64:t;b=(b|0)>=64?64:b;T=b-1|0;U=0-b|0;v=1;while(1){w=U;w=(t|0)>=0?(v+T|0)/(v|0)|0:w;A=0;K=0;L=0;B=0;C=0;c:{d:while(1){if((v|0)!=(A|0)){y=(d+16|0)+N(A,24)|0;b=y;H[b>>2]=0;H[b+4>>2]=0;H[b+16>>2]=0;H[b+20>>2]=0;H[b+8>>2]=0;H[b+12>>2]=0;r=0;D=-1;while(1){e:{f:{if(H[M+24>>2]>(r|0)){if((r|0)!=(u|0)&(u|0)>=0){break e}f=Ql(m,d+200|0,0);if(f){break c}b=He(N(H[d+200>>2],40),0);H[d+152>>2]=b;if(!b){f=7;break c}H[d+144>>2]=w;H[d+140>>2]=r;H[d+156>>2]=-1;H[d+148>>2]=H[d+200>>2];H[d+136>>2]=m;f=gg(H[m+16>>2],111,d+136|0);q=H[d+152>>2];if(f){E=0;s=0;b=0;O=0;P=0;Q=0;x=0;break f}l=0;b=H[d+200>>2];g=(b|0)>0?b:0;b=0;while(1){if((b|0)==(g|0)){g=0;h=0;n=0;j=0;b=-1}else{i=H[(N(b,40)+q|0)+16>>2];e=b&63;c=e&31;if((e&63)>>>0>=32){e=1<<c;h=0}else{h=1<<c;e=h-1&1>>>32-c}c=i?h:0;K=c|K;L=L|(i?e:0);b=b+1|0;continue}break}g:while(1){x=b;P=n;Q=j;E=g;s=h;O=l;h:while(1){i:{j:{if(H[d+156>>2]>=0){b=0;c=H[d+148>>2];g=(c|0)>0?c:0;h=2147483647;q=H[d+152>>2];while(1){if((b|0)==(g|0)){break j}e=N(b,40)+q|0;if(H[e+16>>2]){i=H[e+8>>2];o=i;k=h>>>0>i>>>0;e=H[e+12>>2];i=h>>31;h=k&(e|0)<=(i|0)|(e|0)<(i|0)?o:h}b=b+1|0;continue}}b=0;H[d+156>>2]=0;while(1){c=H[d+148>>2];if((c|0)<=(b|0)){break i}c=H[d+152>>2]+N(b,40)|0;Op(c+16|0,c+8|0,H[d+144>>2]);b=b+1|0;continue}}if((h|0)==2147483647){b=r;break f}e=(h-H[d+144>>2]|0)+1|0;H[d+156>>2]=e;i=h+1|0;b=0;while(1){if((b|0)>=(c|0)){break i}c=H[d+152>>2]+N(b,40)|0;Op(c+16|0,c+8|0,i);Op(c+32|0,c+24|0,e);b=b+1|0;c=H[d+148>>2];continue}}l=H[d+156>>2];R=l>>31;q=0;n=0;j=0;g=0;h=0;b=0;while(1){k:{if((c|0)>(q|0)){F=H[d+152>>2]+N(q,40)|0;e=H[F+32>>2];if(!e){break k}H[d+204>>2]=e;c=H[F+28>>2];e=c;i=H[F+24>>2];H[d+160>>2]=i;H[d+164>>2]=c;c=q&63;k=c&31;if((c&63)>>>0>=32){c=1<<k;o=0}else{o=1<<k;c=o-1&1>>>32-k}S=o;k=g|S;V=c;o=h|c;while(1){l:{c=H[d+144>>2]+l|0;p=c>>31;if(!(i>>>0<l>>>0&(e|0)<=(R|0)|(e|0)<(R|0)|((p|0)<=(e|0)&c>>>0<=i>>>0|(e|0)>(p|0)))){W=S&(g|B);X=V&(h|C);c=i-l|0;e=c&31;if((c&63)>>>0>=32){c=1<<e;h=0}else{h=1<<e;c=h-1&1>>>32-e}Y=h;g=c;c=H[F>>2];h=(c|0)>0?c:0;i=0;e=0;while(1){if(!(!e&(h|0)==(i|0))){p=i&31;if((i&63)>>>0>=32){c=0;p=g>>>p|0}else{c=g>>>p|0;p=((1<<p)-1&g)<<32-p|Y>>>p}n=p|n;j=c|j;i=i+1|0;e=i?e:e+1|0;continue}break}b=(W|X?1:1e3)+b|0;if(I[H[d+204>>2]]>=2){break l}h=o;g=k}c=H[d+148>>2];break k}Kj(d+204|0,d+160|0);i=H[d+160>>2];e=H[d+164>>2];g=k;h=o;continue}}if((b|0)<=(x|0)){continue h}continue g}q=q+1|0;continue}}}}A=A+1|0;B=B|H[y+8>>2];C=C|H[y+12>>2];continue d}Ta(q);if(f){break c}if((x|0)<=(D|0)){break e}c=y;H[c+16>>2]=P;H[c+20>>2]=Q;H[c+8>>2]=E;H[c+12>>2]=s;H[c+4>>2]=O;H[c>>2]=b;D=x}r=r+1|0;continue}}break}if(!(((B|0)!=(K|0)|(C|0)!=(L|0))&(v|0)!=4)){y=v-1|0;f=0;l=0;while(1){if(l>>>0>=v>>>0|f){break c}o=H[m>>2];H[d+188>>2]=0;b=(d+16|0)+N(l,24)|0;i=H[b+16>>2];e=H[b+20>>2];h=H[b+4>>2];b=H[b>>2]+1|0;k=$e(H[m+12>>2],b);c=H[m+12>>2];m:{if(!k){f=(hh(c,b)|0)!=5?7:0;break m}x=Nd(c,b);b=H[o+36>>2];r=H[b>>2];f=jg(b,H[m+20>>2],k,x,d+184|0);if(f){break m}c=0;t=H[d+184>>2];u=0;n:while(1){f=0;while(1){o:{if(f){break o}H[d+176>>2]=-1;H[d+172>>2]=0;H[d+168>>2]=0;f=Ia[H[r+20>>2]](t,d+180|0,d+176|0,d+172|0,d+168|0,d+188|0)|0;if(f){if((f|0)!=101){break o}f=sf(d+120|0,k+u|0,-1);break o}f=0;b=H[d+188>>2];if((h|0)>(b|0)){continue}p:{if(c){break p}n=0;j=0;q:{r:{s:{if(!(e|i)){i=0;e=0;break s}f=H[d+172>>2];D=f+k|0;E=H[m+20>>2];while(1){c=n;n=c+1|0;j=n?j:j+1|0;b=0;s=i;g=c&31;if((c&63)>>>0>=32){g=e>>>g|0}else{g=((1<<g)-1&e)<<32-g|s>>>g}if(!(g&1)){continue}break}while(1){g=b;b=b+1|0;s=i;n=(g^-1)+w|0;j=n&31;if((n&63)>>>0>=32){s=e>>>j|0}else{s=((1<<j)-1&e)<<32-j|s>>>j}if(!(s&1)){continue}break}b=c-g|0;c=(b|0)/2|0;if((b|0)<2){break s}H[d+136>>2]=0;g=H[o+36>>2];b=H[g>>2];f=jg(g,E,D,x-f|0,d+160|0);if(f){break r}g=c+w|0;f=0;c=H[d+160>>2];t:{while(1){if(!f){if((g|0)<=H[d+136>>2]){Ia[H[b+16>>2]](c)|0;break t}else{H[d+200>>2]=0;H[d+196>>2]=0;H[d+192>>2]=0;f=Ia[H[b+20>>2]](c,d+204|0,d+200|0,d+196|0,d+192|0,d+136|0)|0;continue}}break}Ia[H[b+16>>2]](c)|0;if((f|0)!=101){break r}}b=H[d+136>>2]+(((f|0)!=0)-w|0)|0;c=(b|0)>0?b:0;h=c+h|0;b=c&31;if((c&63)>>>0>=32){c=0;i=e>>>b|0}else{c=e>>>b|0;i=((1<<b)-1&e)<<32-b|i>>>b}e=c}u:{if(!(!l&(h|0)<=0)){f=sf(d+120|0,z,-1);break u}b=H[d+172>>2];if(!b){break q}f=sf(d+120|0,k,b)}if(!f){break q}}c=1;continue}b=H[d+188>>2];if((h|0)<=(b|0)){break p}c=1;continue n}if((h+w|0)<=(b|0)){f=0;if((l|0)!=(y|0)){break o}f=sf(d+120|0,z,-1)}else{f=0;if((b|0)>(h|0)){f=sf(d+120|0,k+u|0,H[d+172>>2]-u|0)}c=b-h|0;b=c&31;if((c&63)>>>0>=32){j=1<<b;c=0}else{c=1<<b;j=c-1&1>>>32-b}b=c&i;c=e&j;if(!(!(b|c)|f)){f=sf(d+120|0,J,-1)}v:{if(f){break v}g=d+120|0;j=H[d+172>>2];f=sf(g,j+k|0,H[d+168>>2]-j|0);if(f|!(b|c)){break v}f=sf(g,G,-1)}c=1;u=H[d+168>>2];continue}}break}break}Ia[H[r+16>>2]](t)|0}l=l+1|0;continue}}v=v+1|0;continue}break}Ge(M);if(f){Xd(a,f);Ta(H[d+120>>2]);break a}qb(a,H[d+120>>2],-1,1)}Ea=d+208|0}function Md(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0;g=Ea-128|0;Ea=g;H[b>>2]=0;H[b+4>>2]=0;a:{if(!c){break a}b:{if((d|0)==1){f=a;d=1;m=1;break b}f=3-d|0;c=c&-2;while(1){c:{if((c|0)<=(f|0)){m=1}else{if(!I[a+f|0]){break c}m=-100}c=f^1;f=(d&1)+a|0;d=2;break b}f=f+2|0;continue}}n=a+c|0;while(1){if(f>>>0>=n>>>0){break a}o=I[f|0];if(F[o+31152|0]&1){f=d+f|0;continue}break}a=((o|0)==45?d:(o|0)==43?d:0)+f|0;d:{e:{f:while(1){f=1;if(a>>>0>=n>>>0){break e}c=I[a|0];if(c-58>>>0>=4294967286){p=p+1|0;a=a+d|0;j=c<<24>>24;e=sJ(e,h,10,0);c=j+e|0;h=Ha+(j>>31)|0;h=c>>>0<e>>>0?h+1|0:h;e=c-48|0;c=h-(c>>>0<48)|0;h=c;if((c|0)==429496729&e>>>0<2576980376|c>>>0<429496729){continue}while(1){if(I[a|0]-58>>>0<4294967286|a>>>0>=n>>>0){continue f}l=l+1|0;a=a+d|0;continue}}break}g:{if((c|0)!=46){break g}m=m+1|0;while(1){a=a+d|0;if(n>>>0<=a>>>0){break g}c=I[a|0];if(c-58>>>0<4294967286){break g}if((h|0)==429496729&e>>>0>2576980375|h>>>0>429496729){continue}p=p+1|0;l=l-1|0;j=c<<24>>24;e=sJ(e,h,10,0);c=j+e|0;j=Ha+(j>>31)|0;j=c>>>0<e>>>0?j+1|0:j;e=c-48|0;h=j-(c>>>0<48)|0;continue}}if(a>>>0>=n>>>0){break e}h:{if((I[a|0]|32)!=101){q=1;break h}m=m+1|0;a=a+d|0;if(n>>>0<=a>>>0){break d}i:{j:{switch(I[a|0]-43|0){case 2:a=a+d|0;f=-1;break i;case 0:break j;default:break i}}a=a+d|0}while(1){if(a>>>0>=n>>>0){break h}c=I[a|0];if(c-58>>>0<4294967286){break h}k=(k|0)>=1e4?1e4:((c<<24>>24)+N(k,10)|0)-48|0;a=a+d|0;q=1;continue}}while(1){if(!(F[I[a|0]+31152|0]&1)|a>>>0>=n>>>0){break d}a=a+d|0;continue}}q=1}s=b;k:{if(e|h){f=N(f,k)+l|0;while(1){if(!((h|0)==429496729&e>>>0>2576980376|h>>>0>429496729|(f|0)<=0)){f=f-1|0;e=sJ(e,h,10,0);h=Ha;continue}break}while(1){c=vJ(e,h,10,0);d=Ha;if(!((sJ(c,d,10,0)|0)!=(e|0)|(Ha|0)!=(h|0)|(f|0)>=0)){f=f+1|0;e=c;h=d;continue}break}t=b;i=+(e>>>0)+ +(h>>>0)*4294967296;l:{if(!f){break l}m:{n:{if(I[65930]){c=Ea-16|0;Ea=c;o:{if(!(e|h)){e=0;h=0;d=0;b=0;break o}b=Q(h);b=(b|0)==32?Q(e)+32|0:b;Yd(c,e,h,0,0,112-(b^63)|0);j=16446-b<<16;b=0;e=b+H[c+8>>2]|0;h=j+(H[c+12>>2]^65536)|0;h=b>>>0>e>>>0?h+1|0:h;d=H[c+4>>2];b=H[c>>2]}H[g+96>>2]=b;H[g+100>>2]=d;H[g+104>>2]=e;H[g+108>>2]=h;Ea=c+16|0;e=H[g+104>>2];h=H[g+108>>2];b=H[g+96>>2];c=H[g+100>>2];if((f|0)<=0){break n}while(1)if(f>>>0<100){while(1)if(f>>>0<10){while(1){if((f|0)<=0){break m}ne(g+32|0,b,c,e,h,0,0,0,1073889280);f=f-1|0;e=H[g+40>>2];h=H[g+44>>2];b=H[g+32>>2];c=H[g+36>>2];continue}}else{ne(g+16|0,b,c,e,h,0,0,-234881024,1075849733);f=f-10|0;e=H[g+24>>2];h=H[g+28>>2];b=H[g+16>>2];c=H[g+20>>2];continue}}else{ne(g,b,c,e,h,1280106687,-827280776,-765899721,1095443610);f=f-100|0;e=H[g+8>>2];h=H[g+12>>2];b=H[g>>2];c=H[g+4>>2];continue}}i=+(e>>>0)+ +(h>>>0)*4294967296;M[g+112>>3]=i;p:{if(i<0x10000000000000000&i>=0){b=~~i>>>0;if(P(i)>=1){c=~~(i>0?R(T(i*2.3283064365386963e-10),4294967295):U((i-+(~~i>>>0>>>0))*2.3283064365386963e-10))>>>0}else{c=0}break p}b=0;c=0}q:{if((h|0)==(c|0)&b>>>0<=e>>>0|c>>>0<h>>>0){i=+(e-b>>>0)+ +(h-((b>>>0>e>>>0)+c|0)>>>0)*4294967296;break q}i=-(+(b-e>>>0)+ +(c-((b>>>0<e>>>0)+h|0)>>>0)*4294967296)}M[g+120>>3]=i;r:{if((f|0)>0){while(1)if(f>>>0<100){while(1)if(f>>>0<10){while(1){if((f|0)<=0){break r}je(g+112|0,10,0);f=f-1|0;continue}}else{je(g+112|0,1e10,0);f=f-10|0;continue}}else{je(g+112|0,1e100,-15902891109759918e67);f=f-100|0;continue}}while(1)if((f|0)>-100){while(1)if((f|0)>-10){while(1){if((f|0)>=0){break r}je(g+112|0,.1,-5551115123125783e-33);f=f+1|0;continue}}else{je(g+112|0,1e-10,-3643219731549774e-42);f=f+10|0;continue}}else{je(g+112|0,1e-100,-19991899802602883e-133);f=f+100|0;continue}}i=M[g+112>>3]+M[g+120>>3];C(+i);b=x(1)|0;c=x(0)|0;i=(b&2146435072)!=2146435072?i:b&1048575|c?Infinity:i;break l}while(1)if((f|0)>-100){while(1)if((f|0)>-10){while(1){if((f|0)>=0){break m}ne(g+80|0,b,c,e,h,-1717986918,-1717986919,-1717986919,1073453465);f=f+1|0;e=H[g+88>>2];h=H[g+92>>2];b=H[g+80>>2];c=H[g+84>>2];continue}}else{ne(g- -64|0,b,c,e,h,-2011384559,-1417843994,-40010789,1071495117);f=f+10|0;e=H[g+72>>2];h=H[g+76>>2];b=H[g+64>>2];c=H[g+68>>2];continue}}else{ne(g+48|0,b,c,e,h,-61397127,-42290448,-297213870,1051901938);f=f+100|0;e=H[g+56>>2];h=H[g+60>>2];b=H[g+48>>2];c=H[g+52>>2];continue}}u=Bj(b,c,e,h,-98454,-268435457,-1,1140785151);f=Ea-32|0;Ea=f;d=h&65535;j=0;l=h>>>16&32767;s:{if(l-15361>>>0<=2045){d=d<<4|e>>>28;e=e<<4|c>>>28;j=l-15360|0;c=c&268435455;t:{if((c|0)==134217728&(b|0)!=0|c>>>0>134217728){e=e+1|0;d=e?d:d+1|0;break t}if(b|(c|0)!=134217728){break t}c=d;b=e;e=e+(e&1)|0;d=b>>>0>e>>>0?c+1|0:c}b=e;e=d>>>0>1048575;b=e?0:b;c=e?0:d;d=0;e=e+j|0;d=e>>>0<j>>>0?1:d;break s}if(!(!(b|e|(c|d))|((l|0)!=32767|(j|0)!=0))){b=e<<4|c>>>28;c=d<<4|e>>>28|524288;e=2047;d=0;break s}if(l>>>0>17406){b=0;c=0;e=2047;d=0;break s}j=!(j|l);r=j?15360:15361;k=r-l|0;if((k|0)>112){b=0;c=0;e=0;d=0;break s}d=j?d:d|65536;Yd(f+16|0,b,c,e,d,128-k|0);$h(f,b,c,e,d,k);b=H[f+8>>2];e=b<<4;c=H[f+12>>2]<<4|b>>>28;d=H[f>>2];b=H[f+4>>2];k=b;b=b>>>28|e;e=k&268435455;d=d|(l|0)!=(r|0)&(H[f+16>>2]|H[f+24>>2]|(H[f+20>>2]|H[f+28>>2]))!=0;u:{if((e|0)==134217728&(d|0)!=0|e>>>0>134217728){b=b+1|0;c=b?c:c+1|0;break u}if(d|(e|0)!=134217728){break u}d=b;b=b+(b&1)|0;c=d>>>0>b>>>0?c+1|0:c}e=c>>>0>1048575;c=e?c^1048576:c;d=0}Ea=f+32|0;z(0,b|0);z(1,c|(h&-2147483648|e<<20));i=(v=Infinity,w=+B(),y=(u|0)>0,y?v:w)}M[t>>3]=i;if((o|0)!=45){break k}i=-i}else{i=(o|0)==45?-0:0}M[s>>3]=i}if(!(!q|(a|0)!=(n|0)|((p|0)<=0|(m|0)<=0))){k=m;break a}if(!(!q&(m|0)!=3|(m|0)<2)){k=-1;if((p|0)>0){break a}}k=0}Ea=g+128|0;return k}function vj(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;g=Ea-80|0;Ea=g;d=H[a>>2];if(I[d+87|0]){H[a+36>>2]=7}c=H[a+216>>2];if(c){while(1){b=c;c=H[b+4>>2];if(c){continue}break}tu(b);H[a+224>>2]=0;H[a+216>>2]=0}su(a);ki(H[a+88>>2],H[a+20>>2]);while(1){b=H[a+220>>2];if(b){H[a+220>>2]=H[b+4>>2];e=b+88|0;f=e+N(H[b+60>>2],40)|0;c=0;while(1){if(H[b+64>>2]>(c|0)){j=H[f+(c<<2)>>2];if(j){Wi(H[b>>2],j)}c=c+1|0;continue}break}ki(e,H[b+60>>2]);$k(H[H[b>>2]>>2],b+40|0,-1,0);db(H[H[b>>2]>>2],b);continue}break}if(H[a+236>>2]){$k(H[a>>2],a+236|0,-1,0)}a:{b:{if(!(I[a+152|0]&128)){break b}ru(a);c=0;b=H[a+36>>2];c:{d:{if(!b){break d}e:{f:{e=b&255;if(e>>>0>13){break f}b=1;if(!(1<<e&9856)){break f}j=0;f=J[a+152>>1];c=1;if(!(!(f&64)|(e|0)!=9)){break c}if(!(f&32)|(e|0)!=13&(e|0)!=7){break e}j=2;c=0;break c}j=0;if(I[a+148|0]==3){break d}b=0;c=1;break c}Wg(d,516);Gj(d);F[d+85|0]=1;H[a+40>>2]=0;H[a+44>>2]=0;c=1;if(H[a+36>>2]){break c}}b=c;Vi(a,0);j=0;c=1}l=c;g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{if(!(!I[d+85|0]|!H[d+408>>2]&H[d+384>>2]>0|H[d+192>>2]!=(!(I[a+152|0]&64)|0))){c=H[a+36>>2];if(!(I[a+148|0]!=3|b?c:0)){c=1;if(Vi(a,1)){if(I[a+152|0]&64){break a}b=787;break l}b=H[d+32>>2];c=H[d+36>>2];if(c&2){H[d+32>>2]=b;H[d+36>>2]=c&-3;b=11;break l}f=H[d+408>>2];b=0;H[d+408>>2]=0;c=0;while(1){if(!(H[d+384>>2]<=(c|0)|b)){b=0;e=H[H[f+(c<<2)>>2]+8>>2];r:{if(!e){break r}h=H[H[e>>2]+60>>2];if(!h){break r}b=Ia[h|0](e)|0;gf(a,e)}c=c+1|0;continue}break}H[d+408>>2]=f;f=0;c=0;while(1){if(b){break m}if(H[d+20>>2]>(c|0)){b=0;h=H[d+16>>2]+(c<<4)|0;e=H[h+4>>2];if(!(!e|I[e+8|0]!=2)){b=H[e+4>>2];H[b+4>>2]=H[e>>2];b=H[b>>2];if(!(52>>>I[b+5|0]&1|I[h+8|0]==1|I[b+12|0])){i=!I[b+16|0]+i|0}f=1;b=Xu(b)}c=c+1|0;continue}break}s:{if(!f){break s}b=H[d+232>>2];if(!b){break s}if(!(Ia[b|0](H[d+228>>2])|0)){break s}b=531;break l}b=0;t:{e=zv(H[H[d+16>>2]+4>>2]);u:{if(!bb(e)){c=0;break u}c=0;if((i|0)>1){break t}}while(1){if(H[d+20>>2]<=(c|0)|b){break o}b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=pm(b,0)}else{b=0}c=c+1|0;continue}}i=H[d>>2];H[g+76>>2]=0;b=bb(e);H[g+56>>2]=0;H[g+52>>2]=e;H[g+48>>2]=0;n=mb(d,17846,g+48|0);if(!n){b=7;break m}k=n+4|0;e=k+b|0;v:{while(1){w:{if(!c){break w}if(c>>>0>=101){H[g+16>>2]=k;Ec(13,8042,g+16|0);b=H[i+28>>2];if(!b){break v}Ia[b|0](i,k,0)|0;break v}if((c|0)!=1){break w}H[g+32>>2]=k;Ec(13,8494,g+32|0)}we(4,g+68|0);b=H[g+68>>2];H[g>>2]=b>>>8;H[g+4>>2]=b&255;Bd(13,e,18648,g);b=Ia[H[i+32>>2]](i,k,0,g+72|0)|0;if(!b){c=c+1|0;if(H[g+72>>2]){continue}}break}if(b){break p}}c=0;b=qu(i,k,g+76|0,16406,0);if(b){break p}f=0;e=0;h=H[g+76>>2];x:{while(1){if(H[d+20>>2]<=(c|0)){break x}y:{b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];z:{if(!b|I[b+8|0]!=2){break z}m=H[H[H[b+4>>2]>>2]+188>>2];if(!m){break z}b=(p=h,q=m,r=bb(m)+1|0,s=f,t=e,o=H[H[h>>2]+12>>2],Ia[o](p|0,q|0,r|0,s|0,t|0)|0);m=bb(m);if(b){break y}b=m+1|0;f=b+f|0;e=b>>>0>f>>>0?e+1|0:e}c=c+1|0;continue}break}Gh(h);c=H[i+28>>2];if(!c){break p}Ia[c|0](i,k,0)|0;break p}if(Ia[H[H[h>>2]+48>>2]](h)&1024){break q}b=Ia[H[H[h>>2]+20>>2]](h,2)|0;if(!b){break q}Gh(h);c=H[i+28>>2];if(!c){break p}Ia[c|0](i,k,0)|0;break p}if(!((c|0)!=17|H[d+184>>2]<2)){H[a+40>>2]=0;H[a+44>>2]=0;break k}Wg(d,0);H[a+40>>2]=0;H[a+44>>2]=0;break k}if(!l){break j}j=1;if(!H[a+36>>2]){break j}A:{switch(I[a+148|0]-2|0){default:Wg(d,516);Gj(d);j=0;break i;case 1:break j;case 0:break A}}j=2;break j}b=0;c=0;B:{while(1){if(b){break B}if(H[d+20>>2]>(c|0)){b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=pm(b,k)}else{b=0}c=c+1|0;continue}break}Gh(h);b=H[i+28>>2];if(b){b=Ia[b|0](i,k,1)|0}else{b=0}db(d,n);if(b){break m}c=0;b=H[18327];if(b){Ia[b|0]()}while(1){if(H[d+20>>2]>(c|0)){b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];if(b){Xj(b,1)}c=c+1|0;continue}break}b=H[18328];if(!b){break n}Ia[b|0]();break n}Gh(h)}db(d,n);break m}c=0;while(1){if(b){break m}if(H[d+20>>2]<=(c|0)){break n}b=H[(H[d+16>>2]+(c<<4)|0)+4>>2];if(b){b=Xj(b,0)}else{b=0}c=c+1|0;continue}}mu(d,64);H[d+512>>2]=0;H[d+516>>2]=0;H[d+520>>2]=0;H[d+524>>2]=0;c=H[d+36>>2];H[d+32>>2]=H[d+32>>2]&-524289;H[d+36>>2]=c;H[d+24>>2]=H[d+24>>2]&-2;break k}c=5;if((b|0)!=5){break l}b=5;if(I[a+152|0]&64){break a}}Am(d,b);H[a+36>>2]=b;Wg(d,0);H[a+40>>2]=0;H[a+44>>2]=0}H[d+508>>2]=0;b=0;if(l){break g}}if(!H[H[a>>2]+508>>2]|!H[a+48>>2]){break h}c=0;e=0;f=H[a+48>>2]-1|0;b=H[a>>2];h=(j|0)!=2;while(1){if(H[b+20>>2]>(e|0)){l=H[(H[b+16>>2]+(e<<4)|0)+4>>2];if(l){C:{if(!h){i=Ao(l,2,f);if(i){break C}}i=Ao(l,1,f)}c=c?c:i}e=e+1|0;continue}break}H[b+508>>2]=H[b+508>>2]-1;H[a+48>>2]=0;D:{E:{if(!c){if((j|0)==2){c=Ui(b,2,f);if(c){break E}}c=Ui(b,1,f)}if((j|0)!=2){break D}}e=H[a+76>>2];H[b+512>>2]=H[a+72>>2];H[b+516>>2]=e;e=H[a+84>>2];H[b+520>>2]=H[a+80>>2];H[b+524>>2]=e}if(!c){break h}b=H[a+36>>2];if(!((b&255)!=19?b:0)){H[a+36>>2]=c;Za(d,H[a+124>>2]);H[a+124>>2]=0}Wg(d,516);Gj(d)}F[d+85|0]=1;H[a+40>>2]=0;H[a+44>>2]=0}b=j}if(!(I[a+152|0]&16)){break b}f=0;e=0;if((b|0)!=2){e=H[a+44>>2];b=e+H[d+116>>2]|0;f=H[a+40>>2];j=H[d+112>>2];c=f+j|0;H[d+112>>2]=c;H[d+116>>2]=c>>>0<j>>>0?b+1|0:b}H[d+104>>2]=f;H[d+108>>2]=e;H[a+40>>2]=0;H[a+44>>2]=0}H[d+184>>2]=H[d+184>>2]-1;b=J[a+152>>1];if(!(b&64)){H[d+192>>2]=H[d+192>>2]-1;b=J[a+152>>1]}if(b&128){H[d+188>>2]=H[d+188>>2]-1}F[a+151|0]=3;if(!I[d+87|0]){c=H[a+36>>2]==5?5:0;break a}H[a+36>>2]=7;c=0}Ea=g+80|0;return c}function _F(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=Ea-48|0;Ea=h;o=H[a+4>>2];p=101;a:{while(1){g=H[a+12>>2];j=H[a+8>>2];if((g|0)>=(j|0)){break a}b:{while(1){i=j;if((g|0)==(i|0)){break b}i=F[g+o|0];if(!(i&128|(I[i+56208|0]?(i|0)>=48:0))){g=g+1|0;H[a+12>>2]=g;continue}break}i=g}m=i;i=(g|0)>(j|0)?g:j;c:{while(1){if((g|0)==(i|0)){break c}j=F[g+o|0];if(!(!(j&128)&(!I[j+56208|0]|(j|0)<48))){g=g+1|0;H[a+12>>2]=g;continue}break}i=g}q=(i|0)<=(m|0);if(q){continue}k=H[a+20>>2];l=i-m|0;if((l|0)>H[a+24>>2]){g=l+20|0;H[a+24>>2]=g;k=Fc(k,g,g>>31);if(!k){p=7;break a}H[a+20>>2]=k}r=m+o|0;d:{e:{if(l-21>>>0<=4294967277){break e}g=0;i=22;while(1){f:{if((g|0)!=(l|0)){j=I[g+r|0];if((j-65&255)>>>0<=25){j=j|32;break f}if((j-97&255)>>>0<26){break f}break e}F[h+39|0]=0;F[h+40|0]=0;F[h+41|0]=0;F[h+42|0]=0;F[h+43|0]=0;g=h+i|0;H[h+12>>2]=g+17;g:{if(I[g+17|0]!=115){break g}g=h+12|0;if(Ob(g,4243,4466,0)){break g}if(Ob(g,12150,12169,0)){break g}if(Ob(g,4466,4466,0)){break g}H[h+12>>2]=H[h+12>>2]+1}g=H[h+12>>2];i=h+12|0;h:{if(Ob(i,14633,14634,108)){break h}i:{if(!Ob(i,12124,30558,109)){if(!Ob(i,14694,30558,109)){break h}if((g|0)!=H[h+12>>2]){break i}break h}if((g|0)==H[h+12>>2]){break h}}g=h+12|0;if(Ob(g,18092,13203,0)){break h}if(Ob(g,18014,14405,0)){break h}if(Ob(g,12083,12832,0)){break h}j:{g=H[h+12>>2];if(!We(g)){break j}i=I[g|0];if((i|0)!=I[g+1|0]){break j}i=i-108|0;if(1<<i&16513?i>>>0<=14:0){break j}H[h+12>>2]=g+1;break h}if(!fy(g)){break h}if(!ey(g)){break h}g=g-1|0;H[h+12>>2]=g;F[g|0]=101}g=H[h+12>>2];k:{if(I[g|0]!=121){break k}if(!hy(g+1|0)){break k}F[g|0]=105}l:{m:{switch(I[g+1|0]-97|0){case 0:g=h+12|0;if(Ob(g,18064,13203,108)){break l}Ob(g,3105,10785,108);break l;case 2:g=h+12|0;if(Ob(g,13848,14737,108)){break l}Ob(g,18095,14746,108);break l;case 4:Ob(h+12|0,12073,12832,108);break l;case 6:Ob(h+12|0,11578,12436,108);break l;case 11:g=h+12|0;if(Ob(g,18013,14405,108)){break l}if(Ob(g,18191,11854,108)){break l}if(Ob(g,13805,2986,108)){break l}if(Ob(g,14099,14845,108)){break l}Ob(g,9982,3743,108);break l;case 14:g=h+12|0;if(Ob(g,12078,12832,108)){break l}if(Ob(g,18066,13203,108)){break l}Ob(g,18053,13203,108);break l;case 18:g=h+12|0;if(Ob(g,18208,11854,108)){break l}if(Ob(g,12092,12956,108)){break l}if(Ob(g,12585,11562,108)){break l}Ob(g,9974,3743,108);break l;case 19:break m;default:break l}}g=h+12|0;if(Ob(g,18202,11854,108)){break l}if(Ob(g,12086,12956,108)){break l}Ob(g,18017,14405,108)}n:{o:{p:{q:{r:{g=I[H[h+12>>2]];switch(g-105|0){case 1:case 2:break n;case 3:break p;case 0:break q;default:break r}}if((g|0)==115){break o}if((g|0)!=101){break n}g=h+12|0;if(Ob(g,12160,17815,108)){break n}if(Ob(g,18058,30558,108)){break n}Ob(g,18196,11854,108);break n}Ob(h+12|0,12154,17815,108);break n}g=h+12|0;if(Ob(g,12166,17815,108)){break n}Ob(g,12589,30558,108);break n}Ob(h+12|0,11294,30558,108)}s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{g=H[h+12>>2];switch(I[g+1|0]-97|0){case 21:case 25:break t;case 20:break u;case 19:break v;case 18:break w;case 14:break x;case 13:break y;case 11:break z;case 8:break A;case 4:break B;case 2:break C;case 0:break D;default:break s}}if(I[g|0]!=108){break s}g=g+2|0;if(!$d(g)){break s}H[h+12>>2]=g;break s}if(I[g|0]!=101|I[g+2|0]!=110){break s}E:{switch(I[g+3|0]-97|0){case 0:case 4:break E;default:break s}}g=g+4|0;if(!$d(g)){break s}H[h+12>>2]=g;break s}if(I[g|0]!=114){break s}g=g+2|0;if(!$d(g)){break s}H[h+12>>2]=g;break s}if(I[g|0]!=99){break s}g=g+2|0;if(!$d(g)){break s}H[h+12>>2]=g;break s}if(I[g|0]!=101|I[g+2|0]!=98|(I[g+3|0]|8)!=105){break s}g=g+4|0;if(!$d(g)){break s}H[h+12>>2]=g;break s}if(I[g|0]!=116){break s}F:{switch(I[g+2|0]-97|0){case 0:g=g+3|0;if(!$d(g)){break s}H[h+12>>2]=g;break s;case 4:break F;default:break s}}g=h+12|0;if(Ob(g,13894,30558,110)){break s}if(Ob(g,11493,30558,110)){break s}Ob(g,13807,30558,110);break s}if(I[g|0]==117){g=g+2|0;if(!$d(g)){break s}H[h+12>>2]=g;break s}if((I[g+3|0]-115&255)>>>0>1){break s}Ob(h+12|0,12120,30558,110);break s}if(I[g|0]!=109|I[g+2|0]!=105){break s}g=g+3|0;if(!$d(g)){break s}H[h+12>>2]=g;break s}g=h+12|0;if(Ob(g,18072,30558,110)){break s}Ob(g,12100,30558,110);break s}if(I[g|0]!=115|I[g+2|0]!=111){break s}g=g+3|0;if(!$d(g)){break s}H[h+12>>2]=g;break s}if(I[g|0]!=101|I[g+2|0]!=105){break s}g=g+3|0;if(!$d(g)){break s}H[h+12>>2]=g}g=H[h+12>>2];G:{if(I[g|0]!=101){break G}i=g+1|0;if(!$d(i)){if(!fy(i)){break G}if(ey(i)){break G}}H[h+12>>2]=i;g=i}if(!(!$d(g)|I[g|0]!=108|I[g+1|0]!=108)){g=g+1|0;H[h+12>>2]=g}j=tb(g);H[c>>2]=j;i=0;while(1){F[j+k|0]=i;i=I[g|0];if(!i){break d}j=j-1|0;g=g+1|0;continue}}F[(h+16|0)+i|0]=j;i=i-1|0;g=g+1|0;continue}}g=0;i=0;j=(l|0)>0?l:0;while(1){if((g|0)!=(j|0)){n=I[g+r|0];s=(n-65&255)>>>0<26;F[g+k|0]=s?n|32:n;i=s?i:(n-48&255)>>>0<10?1:i;g=g+1|0;continue}break}i=i?3:10;if(i<<1<(l|0)){g=l-i|0;while(1){if((g|0)<(l|0)){F[i+k|0]=I[g+k|0];i=i+1|0;g=g+1|0;continue}break}j=i}F[j+k|0]=0;H[c>>2]=j}H[b>>2]=H[a+20>>2];H[d>>2]=m;H[e>>2]=H[a+12>>2];g=H[a+16>>2];H[a+16>>2]=g+1;H[f>>2]=g;if(q){continue}break}p=0}Ea=h+48|0;return p|0}function Lt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;f=Ea+-64|0;Ea=f;H[f+48>>2]=d;n=H[a+8>>2];a:{b:{if(!(I[a+1|0]&32)){break b}e=hg(H[n+4>>2],H[a+64>>2],a);H[f+52>>2]=e;if(e){break a}if(!d|F[a+68|0]>=0){break b}e=Ya(79417);break a}if(I[a|0]>=3){e=Qf(a);H[f+52>>2]=e;if(e&-17){break a}}c:{e=H[a+112>>2];if(!e){if(I[n+11|0]){ro(n,H[a+64>>2],H[b+8>>2],H[b+12>>2],0)}if(!(!(I[a+1|0]&2)|(H[b+8>>2]!=H[a+32>>2]|H[b+12>>2]!=H[a+36>>2]))){if(!J[a+50>>1]|H[a+44>>2]!=(H[b+32>>2]+H[b+28>>2]|0)){break c}e=xt(a,b);break a}if(d){break c}e=uh(a,H[b+8>>2],H[b+12>>2],c>>>3&1,f+48|0);H[f+52>>2]=e;if(e){break a}break c}if(!(c&2|d)){d=J[b+24>>1];d:{if(d){H[f+8>>2]=e;e=H[b+20>>2];F[f+34|0]=0;F[f+30|0]=0;G[f+28>>1]=d;H[f+12>>2]=e;e=wh(a,f+8|0,f+48|0);break d}e=wt(a,H[b>>2],H[b+8>>2],H[b+12>>2],c>>>3&1,f+48|0)}H[f+52>>2]=e;if(e){break a}d=H[f+48>>2]}if(d){break c}Ig(a);d=H[a+32>>2];if((d|0)!=H[b+8>>2]|H[a+36>>2]!=H[b+12>>2]){break c}b=H[b>>2];H[f+40>>2]=0;H[f+36>>2]=d;H[f+24>>2]=b;e=xt(a,f+8|0);break a}g=H[a+116>>2];if(H[g+20>>2]<0){if(I[a|0]>=2){e=Ya(79540);break a}e=Pf(g);H[f+52>>2]=e;if(e){break a}}d=H[n+4>>2];k=H[d+84>>2];e:{f:{if(c&128){H[f+52>>2]=0;l=H[d+88>>2];if((l|0)<=3){F[k+3|0]=0;l=4;d=H[n+4>>2]}if(!I[d+17|0]|J[g+14>>1]>=l>>>0){break f}Ia[H[g+80>>2]](g,k,f+8|0);if(H[f+20>>2]==J[f+24>>1]){break f}Ad(H[n+4>>2],cb((k+l|0)-4|0),3,H[g+4>>2],f+52|0);e=H[f+52>>2];if(!e){break f}break a}e=I[g+10|0];g:{if(I[g+1|0]){p=H[b+16>>2];h=H[b+28>>2];d=h+H[b+32>>2]|0;h:{if(d>>>0<=127){F[e+k|0]=d;j=1;break h}j=ff(e+k|0,d,d>>31)&255}e=j+e|0;e=ff(e+k|0,H[b+8>>2],H[b+12>>2])+e|0;break g}p=H[b>>2];d=H[b+8>>2];h=d;i:{if(d>>>0<=127){F[e+k|0]=d;j=1;break i}j=ff(e+k|0,d,d>>31)&255}e=j+e|0}m=e+k|0;i=J[g+14>>1];if((i|0)>=(d|0)){l=d+e|0;if((l|0)<=3){F[d+m|0]=0;l=4}Xa(Va(m,p,h)+h|0,0,d-h|0);break f}o=H[g+52>>2];l=H[o+40>>2];j=J[g+16>>1];H[f+60>>2]=0;r=j;j=j+((d-j>>>0)%(l-4>>>0)|0)|0;i=(i|0)<(j|0)?r:j;e=e+i|0;j=e+k|0;l=e+4|0;while(1){e=(d|0)<(i|0)?d:i;j:{if((h|0)>=(e|0)){Va(m,p,e);break j}if((h|0)>0){Va(m,p,h);e=h;break j}Xa(m,0,e)}d=d-e|0;if((d|0)>0){h=h-e|0;p=e+p|0;m=e+m|0;i=i-e|0;if(i){continue}H[f+56>>2]=0;m=H[f+60>>2];e=m;if(I[o+17|0]){r=H[16644];while(1){i=e;e=e+1|0;if((e|0)==(Qd(o,e)|0)|(i|0)==((r>>>0)/K[o+36>>2]|0)){continue}break}H[f+60>>2]=e}e=jf(o,f+56|0,f+60|0,e,0);H[f+8>>2]=e;k:{if(!(!I[o+17|0]|e)){i=H[f+60>>2];Ad(o,i,m?4:3,m,f+8|0);e=H[f+8>>2];if(!e){break k}Eb(H[f+56>>2]);break e}if(e){break e}i=H[f+60>>2]}e=j;j=i<<24|(i&65280)<<8|(i>>>8&65280|i>>>24);F[e|0]=j;F[e+1|0]=j>>>8;F[e+2|0]=j>>>16;F[e+3|0]=j>>>24;Eb(q);q=H[f+56>>2];j=H[q+56>>2];e=j;F[e|0]=0;F[e+1|0]=0;F[e+2|0]=0;F[e+3|0]=0;i=H[o+40>>2]-4|0;m=H[q+56>>2]+4|0;continue}break}Eb(q)}G[a+50>>1]=0;d=J[a+70>>1];e=H[f+48>>2];l:{if(!e){if(J[g+24>>1]<=d>>>0){e=Ya(79582);break a}e=Vb(H[g+72>>2]);if(e){break a}e=H[g+64>>2]+(d<<1)|0;e=H[g+56>>2]+(J[g+26>>1]&(I[e|0]<<8|I[e+1|0]))|0;if(!I[g+8|0]){h=I[e|0]|I[e+1|0]<<8|(I[e+2|0]<<16|I[e+3|0]<<24);F[k|0]=h;F[k+1|0]=h>>>8;F[k+2|0]=h>>>16;F[k+3|0]=h>>>24}h=f+8|0;Ia[H[g+80>>2]](g,e,h);if(H[f+20>>2]!=J[f+24>>1]){j=oo(g,e,h)}else{j=0}H[f+52>>2]=j;F[a+1|0]=I[a+1|0]&251;h=J[f+26>>1];if(!((h|0)!=(l|0)|H[f+20>>2]!=J[f+24>>1]|(J[g+16>>1]<=l>>>0?I[H[n+4>>2]+17|0]:0))){if(e>>>0<(H[g+56>>2]+I[g+9|0]|0)+10>>>0){e=Ya(79609);break a}if(K[g+60>>2]<e+l>>>0){e=Ya(79612);break a}Va(e,k,l);e=0;break a}Tk(g,d,h,f+52|0);e=H[f+52>>2];if(!e){break l}break a}if(!J[g+24>>1]|(e|0)>=0){break l}d=d+1|0;G[a+70>>1]=d;F[a+1|0]=I[a+1|0]&253;d=d&65535}m:{n:{o:{n=l+2|0;p:{if((n|0)>H[g+20>>2]){e=I[g+12|0];F[g+12|0]=e+1;H[((e<<2)+g|0)+36>>2]=k;G[((e<<1)+g|0)+28>>1]=d;break p}e=Vb(H[g+72>>2]);if(e){break m}e=I[g+9|0];j=H[g+56>>2];H[f+8>>2]=0;h=e+j|0;i=I[h+5|0]<<8|I[h+6|0];m=J[g+18>>1]+(J[g+24>>1]<<1)|0;q:{if(i>>>0<m>>>0){e=71945;if(i){break n}i=65536;if(H[H[g+52>>2]+40>>2]==65536){break q}break n}e=71948;if(H[H[g+52>>2]+40>>2]<(i|0)){break n}}r:{s:{t:{if(!I[h+2|0]){if(!I[h+1|0]){break s}if(m+2>>>0<=i>>>0){break t}break s}if(m+2>>>0>i>>>0){break s}}e=no(g,l,f+8|0);if(e){e=e-j|0;if((m|0)>=(e|0)){break o}i=e>>>8|0;break r}e=H[f+8>>2];if(e){break m}}if((m+n|0)>(i|0)){e=H[g+20>>2]-n|0;e=mo(g,(e|0)>=4?4:e);if(e){break m}i=((I[h+6|0]|I[h+5|0]<<8)-1&65535)+1|0}e=i-l|0;i=e<<8|(e&65280)>>>8;F[h+5|0]=i;F[h+6|0]=i>>>8;i=e>>>8|0}H[g+20>>2]=H[g+20>>2]-(n&65535);Va(e+j|0,k,l);h=H[g+64>>2]+(d<<1)|0;Ic(h+2|0,h,J[g+24>>1]-d<<1);F[h+1|0]=e;F[h|0]=i;G[g+24>>1]=J[g+24>>1]+1;e=j+I[g+9|0]|0;d=I[e+4|0]+1|0;F[e+4|0]=d;if((d|0)!=(d&255)){d=j+I[g+9|0]|0;F[d+3|0]=I[d+3|0]+1}if(!I[H[g+52>>2]+17|0]){break p}H[f+8>>2]=0;Yi(g,g,k,f+8|0);e=H[f+8>>2];if(e){break m}}e=0;break m}e=Ya(71965);break m}e=Ya(e)}if(!I[g+12|0]){break a}F[a+1|0]=I[a+1|0]&253;e=lo(a);F[H[a+116>>2]+12|0]=0;F[a|0]=1;if(!(c&2)|e){break a}Ih(a);e=0;u:{if(!H[a+112>>2]){break u}c=bc(H[b+8>>2],H[b+12>>2]);H[a+16>>2]=c;if(!c){e=7;break u}Va(c,H[b>>2],H[b+8>>2])}F[a|0]=3;c=H[b+12>>2];H[a+56>>2]=H[b+8>>2];H[a+60>>2]=c;break a}Eb(q)}Ea=f- -64|0;return e}function vd(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;j=a+760|0;b=I[a+44|0];k=H[a+4>>2];m=H[a>>2];t=H[m>>2];e=H[m+8>>2];w=H[e+108>>2];while(1){if((b|0)>0){f=b-1|0;c=N(f,96)+j|0;g=H[c+56>>2];if(g){hb(e,H[c+24>>2]);H[c+24>>2]=0;H[g+16>>2]=H[e+108>>2];Ua(e,67,H[g+8>>2],H[g+12>>2],1);v=v+1|0}i=H[c+80>>2];a:{if(I[c+61|0]!=187){d=0;b:{if(!(I[i+41|0]&2)|(I[a+47|0]!=2|I[a+44|0]!=(b|0))){break b}b=H[i+32>>2];if(!(I[b+55|0]&128)){break b}g=J[i+30>>1];if(!g|G[H[b+8>>2]+(g<<1)>>1]<36){break b}d=H[m+44>>2]+1|0;b=0;while(1){if((b|0)!=(g|0)){Ua(e,94,H[c+8>>2],b,b+d|0);b=b+1|0;continue}break}H[m+44>>2]=(g+H[m+44>>2]|0)+1;d=gb(e,I[c+61|0]==38?21:24,H[c+8>>2],0,d,g);Sa(e,9,1,H[c+68>>2])}b=H[c+24>>2];if(b){hb(e,b)}Ua(e,I[c+61|0],H[c+64>>2],H[c+68>>2],I[c+62|0]);b=H[e+108>>2];if((b|0)>0){G[(H[e+104>>2]+N(b,20)|0)-18>>1]=I[c+63|0]}if(H[c+36>>2]){hb(e,H[c+40>>2]);Sa(e,61,H[c+36>>2],H[c+68>>2]-1|0)}if(!d){break a}H[(I[H[e>>2]+87|0]?73336:H[e+104>>2]+N(d,20)|0)+8>>2]=H[e+108>>2];break a}b=H[c+24>>2];if(!b){break a}hb(e,b)}c:{if(!(I[i+41|0]&8)|H[c+72>>2]<=0){break c}hb(e,H[c+16>>2]);d=H[c+72>>2];b=H[c+76>>2]+N(d,20)|0;while(1){if((d|0)<=0){break c}n=b-16|0;g=b-20|0;h=I[H[e>>2]+87|0];if(h){l=73336}else{l=(H[e+104>>2]+N(H[n>>2],20)|0)+20|0}o=H[e+108>>2];H[l+8>>2]=o;p=b-4|0;if(I[p|0]!=187){q=b-8|0;d:{if(!H[q>>2]){break d}h=H[i+40>>2]&263168;if(H[c>>2]){Sa(e,25,H[g>>2],(((h|0)==262144)+o|0)+2|0)}if((h|0)!=262144){break d}gb(e,26,H[c+8>>2],H[e+108>>2]+2|0,H[b-12>>2],H[q>>2]);if(I[H[e>>2]+87|0]){b=73336}else{b=(H[e+104>>2]+N(H[n>>2],20)|0)+20|0}H[b+8>>2]=H[e+108>>2]}Sa(e,I[p|0],H[g>>2],H[n>>2]);h=I[H[e>>2]+87|0];o=H[e+108>>2]}if(h){b=73336}else{b=(H[e+104>>2]+N(H[n>>2],20)|0)-20|0}H[b+8>>2]=o;d=d-1|0;b=g;continue}}hb(e,H[c+12>>2]);b=H[c+56>>2];if(b){Ua(e,67,H[b+8>>2],0,1)}b=H[c+20>>2];if(b){Qb(e,b);b=H[e+108>>2];e:{if(I[H[e>>2]+87|0]){H[18336]=b;g=73336;break e}g=H[e+104>>2]+N(H[c+20>>2],20)|0;H[g+8>>2]=b;g=g-40|0}H[g+8>>2]=b}b=H[c+48>>2];if(b){Sa(e,61,H[c+44>>2]>>>1|0,b)}b=f;d=H[c>>2];if(!d){continue}g=H[i+40>>2];f=_a(e,59,d);if(!(g&64)){_a(e,136,H[c+4>>2])}d=g&8192;f:{g:{h:{if(!(g&512)){if(!d){break f}if(H[c+72>>2]){break h}break f}if(!d){break g}}g=H[c+72>>2];Ua(e,101,H[c+8>>2],H[g+44>>2],Fb(t,H[g+24>>2]));Ed(m,g)}_a(e,136,H[c+8>>2])}i:{if(I[c+61|0]==67){Sa(e,10,H[c+64>>2],H[c+28>>2]);break i}Qb(e,H[c+28>>2])}d=H[e+108>>2];H[(I[H[e>>2]+87|0]?73336:H[e+104>>2]+N(f,20)|0)+8>>2]=d;continue}break}g=m+72|0;x=k+8|0;o=0;while(1){if(I[a+44|0]>o>>>0){j:{if(H[j+56>>2]){b=0;h=0;k=0;i=Ea-80|0;Ea=i;q=H[j+80>>2];n=H[j+56>>2];f=H[a>>2];c=H[f+8>>2];d=H[a+4>>2]+(I[j+60|0]<<6)|0;H[i>>2]=H[H[d+24>>2]>>2];gc(f,1,7392,i);u=(o|0)>0?o:0;r=a+760|0;p=d+8|0;while(1){if((b|0)!=(u|0)){l=r+N(b,96)|0;s=H[l+80>>2];d=H[s+8>>2];s=H[s+12>>2];_a(c,136,H[l+4>>2]);l=H[l+8>>2];if(l){_a(c,136,l)}h=d|h;k=k|s;b=b+1|0;continue}break}d=0;k:{if(I[p+36|0]&64){break k}l=(H[q+8>>2]|h)^-1;k=(k|H[q+12>>2])^-1;b=0;while(1){if(H[a+92>>2]<=(b|0)){break k}h=H[a+104>>2]+N(b,48)|0;if(J[h+12>>1]!=8192?J[h+10>>1]&32770:0){break k}l:{if(H[h+40>>2]&l|k&H[h+44>>2]){break l}h=H[h>>2];if(I[h+4|0]&3){break l}d=Td(f,d,jb(H[f>>2],h,0))}b=b+1|0;continue}}H[i+8>>2]=1;H[i+12>>2]=1;Va(i+16|0,p,64);F[i+52|0]=0;F[f+26|0]=I[f+26|0]+1;q=bf(f,i+8|0,d,0,0,0,4096,0);if(q){l=H[j+4>>2];b=H[f+44>>2];h=b+1|0;H[f+44>>2]=h;u=H[q+28>>2];m:{p=H[p+16>>2];if(!(I[p+28|0]&128)){Sa(c,135,l,h);k=1;break m}r=jc(p);k=J[r+50>>1];H[f+44>>2]=b+k;b=0;while(1){if((b|0)==(k|0)){break m}yd(c,p,l,G[H[r+4>>2]+(b<<1)>>1],b+h|0);b=b+1|0;continue}}b=gb(c,64,H[n+4>>2],0,h,k);gb(c,29,H[n>>2],u,h,k);h=H[c+108>>2];H[(I[H[c>>2]+87|0]?73336:H[c+104>>2]+N(b,20)|0)+8>>2]=h;Sa(c,10,H[n+8>>2],H[n+12>>2]);vd(q)}eb(H[f>>2],d);lh(f);F[f+26|0]=I[f+26|0]-1;Ea=i+80|0;break j}b=(I[j+60|0]<<6)+x|0;if(I[b+37|0]&32){Wz(m,H[j+32>>2],H[j+4>>2],H[b+32>>2],0);break j}c=H[b+16>>2];f=I[t+87|0];b=H[j+80>>2];d=H[b+40>>2];n:{if(d&576){b=b+32|0;break n}if(!(d&8192)){break j}b=j+72|0}i=H[b>>2];if(f|!i){break j}d=w;d=!I[a+46|0]|I[H[i+12>>2]+28|0]&128?d:H[a+56>>2];o:{if(!(I[i+56|0]&16)){break o}b=g;while(1){b=H[b>>2];if(!b){break o}if(H[b+8>>2]==H[j+8>>2]){H[b+4>>2]=-1;H[b+8>>2]=-1}b=b+20|0;continue}}b=73336;f=d;d=H[j+32>>2]+1|0;f=N(f-d|0,20);b=I[H[e>>2]+87|0]?b:H[e+104>>2]+N(d,20)|0;n=f+b|0;h=H[j+4>>2];while(1){p:{if((h|0)!=H[b+4>>2]){break p}q:{d=I[b|0];if((d|0)!=20){if((d|0)!=135){if((d|0)!=94){break p}f=H[b+8>>2];k=H[c+28>>2];if(k&128){f=J[H[jc(c)+4>>2]+(f<<1)>>1];break q}d=0;if(!(k&32)){break q}while(1){if(f<<16>>16<(d|0)){break q}f=(J[(H[c+4>>2]+N(d,12)|0)+10>>1]>>>5&1)+f|0;d=d+1|0;continue}}d=H[j+8>>2];F[b|0]=142;H[b+4>>2]=d;break p}H[b+4>>2]=H[j+8>>2];break p}d=Re(i,f<<16>>16);if((d|0)<0){break p}H[b+8>>2]=d;H[b+4>>2]=H[j+8>>2]}b=b+20|0;if(n>>>0>b>>>0){continue}break}}j=j+96|0;o=o+1|0;continue}break}hb(e,H[a+32>>2]);G[m+156>>1]=H[a+36>>2];_z(t,a);F[m+26|0]=I[m+26|0]-v}function gj(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;m=Ea-112|0;Ea=m;a:{b:{c:{if(b){g=I[b|0];if(!Tc(b,22957)){i=!g;break c}if(g){break b}}i=1;if(I[c+86|0]!=2){break b}}p=1;q=e|2;break a}g=f&128;p=g>>>7|0;q=g>>>6|e}h=7;e=td(48,0);d:{if(!e){break d}H[e+36>>2]=1;H[e>>2]=c;F[e+8|0]=0;H[e+32>>2]=e;e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{k=(f&256)>>>8|0?i|p?f&-769|512:f:f;if(!(!(k&64)&p|i|!(k&131072))){f=H[a+8>>2]+1|0;i=bb(b)+1|0;g=bc((f|0)>(i|0)?f:i,0);F[e+9|0]=1;if(!g){break e}p:{if(p){Va(g,b,i);break p}F[g|0]=0;h=Ia[H[a+36>>2]](a,b,f,g)|0;if((h|512)==512){break p}Ta(g);break e}f=73304;q:{while(1){f=H[f>>2];if(!f){break q}r:{i=H[f>>2];if(!(Tc(g,H[i+184>>2])|H[i>>2]!=(a|0))){i=H[c+20>>2];while(1){if((i|0)<=0){break r}i=i-1|0;j=H[(H[c+16>>2]+(i<<4)|0)+4>>2];if(!j|H[j+4>>2]!=(f|0)){continue}break}Ta(g);Ta(e);h=19;break d}f=f+72|0;continue}break}H[e+4>>2]=f;H[f+68>>2]=H[f+68>>2]+1}Ta(g);if(f){break o}}H[m+16>>2]=0;H[m+20>>2]=0;f=td(92,0);if(!f){h=7;break g}H[m+108>>2]=4096;o=H[a+4>>2];i=0;H[f>>2]=0;r=q&2;if(r){if(!b){u=1;n=1;break l}if(!I[b|0]){i=b;n=1;break l}l=Tb(0,b);if(!l){break n}u=1;n=1;j=bb(l);break k}if(!b){u=1;break m}if(!I[b|0]){i=b;break m}g=H[a+8>>2]+1|0;i=g<<1;l=bc(i,i>>31);if(!l){break n}F[l|0]=0;n=k&16777216;g=Ia[H[a+36>>2]](a,b,g,l)|0;j=bb(l);s=(bb(b)+b|0)+1|0;i=s;while(1){if(I[i|0]){i=(tb(i)+i|0)+1|0;i=(tb(i)+i|0)+1|0;continue}break}h=(g|0)==512?n?1550:0:g;if(!h){if(H[a+8>>2]>=(j+8|0)){t=(i-s|0)+1|0;i=b;n=0;break j}h=ie(61504)}Ta(l);break h}if(!I[e+9|0]){break f}break i}h=7;break h}n=0}j=0}t=1}h=7;o=((o|0)<=64?64:o)+7&2147483640;g=td((((N(j,3)+(o<<1)|0)+t|0)+(H[a+4>>2]+7&-8)|0)+322|0,0);if(!g){Za(0,l);break h}h=g+296|0;H[g+64>>2]=h;H[g+228>>2]=g+240;h=h+(H[a+4>>2]+7&-8)|0;H[g+72>>2]=h;h=h+o|0;H[g+68>>2]=h;h=h+o|0;F[h|0]=g;F[h+1|0]=g>>>8;F[h+2|0]=g>>>16;F[h+3|0]=g>>>24;h=h+8|0;H[g+184>>2]=h;s:{if(j){h=Va(h,l,j)+j|0;t:{if(s){h=Va(h+1|0,s,t)+t|0;break t}h=h+2|0}H[g+188>>2]=h;h=Va(h,l,j)+j|0;F[h|0]=45;F[h+1|0]=106;F[h+2|0]=111;F[h+3|0]=117;F[h+4|0]=114;F[h+5|0]=110;F[h+6|0]=97;F[h+7|0]=108;h=h+9|0;H[g+236>>2]=h;j=Va(h,l,j)+j|0;F[j|0]=45;F[j+1|0]=119;F[j+2|0]=97;F[j+3|0]=108;Za(0,l);break s}H[g+236>>2]=0;H[g+188>>2]=0}H[g+152>>2]=k;H[g>>2]=a;j=0;u:{v:{w:{if(!(!I[i|0]|u)){H[m+104>>2]=0;h=Ia[H[a+24>>2]](a,H[g+184>>2],H[g+64>>2],k&17334143,m+104|0)|0;a=1;i=H[m+104>>2];j=i>>>7&1;F[g+16|0]=j;if(h){break v}k=i&1;i=H[g+64>>2];h=H[i>>2];if(h){a=!(Ia[H[h+48>>2]](i)&8192)}x:{if(k){break x}Zo(g);i=H[g+156>>2];if(i>>>0<=K[m+108>>2]){break x}if(i>>>0>=8193){H[m+108>>2]=8192;break x}H[m+108>>2]=i}v=g,w=Wk(H[g+184>>2],11903,0),F[v+13|0]=w;y:{if(!a){break y}if(Wk(H[g+184>>2],14103,0)){break y}a=0;break w}k=1}F[g+13|0]=1;F[g+17|0]=1;F[g+18|0]=4;k=k&1;a=1}h=Rh(g,m+108|0,-1);if(h){break v}l=H[m+108>>2];h=Xa(H[g+228>>2],0,56);H[h+48>>2]=g;H[h+44>>2]=r?0:19;i=2;F[h+41|0]=2;F[h+40|0]=!(r>>>1|0);H[h+32>>2]=1;H[h+36>>2]=88;H[h+24>>2]=100;H[h+28>>2]=1;h=lv(h,l);if(!h){break u}}a=H[g+64>>2];b=H[a>>2];if(b){Ia[H[b+4>>2]](a)|0;H[a>>2]=0}lf(H[g+224>>2]);Ta(g);break h}H[g+160>>2]=-2;F[g+12|0]=a;F[g+19|0]=a;F[g+4|0]=a;F[g+15|0]=n;F[g+14|0]=k;a=q&1;F[g+6|0]=!a;kv(g,35);H[g+176>>2]=-1;H[g+180>>2]=-1;G[g+148>>1]=88;Zo(g);z:{if(!a){i=4;if(!(j|r)){break z}}F[g+5|0]=i}H[g+216>>2]=20;H[g+220>>2]=H[g+44>>2]?6:7;H[f>>2]=g;a=H[c+52>>2];H[g+136>>2]=H[c+48>>2];H[g+140>>2]=a;a=Xa(m,0,100);i=H[g+64>>2];g=H[i>>2];A:{if(!g){break A}h=Ia[H[g+8>>2]](i,a,100,0,0)|0;if((h|0)==522){break A}if(h){break h}}H[f+4>>2]=c;F[f+16|0]=q;i=H[f>>2];H[i+192>>2]=21;H[i+196>>2]=f;g=H[i+64>>2];j=H[g>>2];if(j){Ia[H[j+40>>2]](g,15,i+192|0)|0;i=H[f>>2]}H[e+4>>2]=f;H[f+8>>2]=0;H[f+12>>2]=0;if(I[i+14|0]){G[f+24>>1]=J[f+24>>1]|1}g=I[a+17|0]<<16|I[a+16|0]<<8;H[f+36>>2]=g;j=f+36|0;B:{if(!(!(g&g+131071)&g-65537>>>0>=4294902271)){k=0;H[j>>2]=0;if(!b|p){break B}F[f+17|0]=0;F[f+18|0]=0;break B}k=I[a+20|0];G[f+24>>1]=J[f+24>>1]|2;b=H[a+52>>2];F[f+17|0]=(b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24))!=0;a=H[a+64>>2];F[f+18|0]=(a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24))!=0}h=Rh(i,j,k);if(h){break h}H[f+68>>2]=1;H[f+40>>2]=H[f+36>>2]-k;if(!I[e+9|0]){break f}H[f+72>>2]=H[18326];H[18326]=f}i=0;a=H[c+20>>2];a=(a|0)>0?a:0;while(1){if((a|0)==(i|0)){break f}b=H[(H[c+16>>2]+(i<<4)|0)+4>>2];if(!b|!I[b+9|0]){i=i+1|0;continue}else{while(1){i=b;b=H[i+28>>2];if(b){continue}break}a=H[e+4>>2];C:{if(a>>>0<K[i+4>>2]){a=i+28|0;c=0;b=e;g=24;break C}b=i;while(1){c=b;b=H[b+24>>2];if(!b){a=c+24|0;i=0;b=e;g=24;break C}if(a>>>0>K[b+4>>2]){continue}break}H[e+24>>2]=b;a=c+24|0;i=c;c=e;g=28}H[g+e>>2]=i;H[b+28>>2]=c;H[a>>2]=e;break f}}}a=H[f>>2];if(!a){break g}iv(a,0)}Ta(f);Ta(e);H[d>>2]=0;break d}H[d>>2]=e;a=H[e+4>>2];H[a+4>>2]=H[e>>2];if(!H[a+52>>2]){aj(e,-2e3)}h=0;a=H[H[f>>2]+64>>2];b=H[a>>2];if(!b){break d}Ia[H[b+40>>2]](a,30,f+4|0)|0;break d}Ta(e)}Ea=m+112|0;return h}function Tp(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;l=Ea-96|0;Ea=l;g=hi(a,b,c,d,0,0,1,0,l+8|0);a:{if(g){break a}j=H[l+12>>2];if(!j){break a}b:{c:{if((d|0)==-1){h=c;i=h>>31;m=b;o=b>>31;break c}g=Lb(a,15,l+72|0,0);if(g){break a}e=H[l+72>>2];m=b;h=c;o=b>>31;i=H[a+260>>2];s=sJ(b,o,i,i>>31);n=h+s|0;i=h>>31;f=i+Ha|0;Cb(e,1,n<<10,(n>>>0<s>>>0?f+1|0:f)<<10|n>>>22);f=H[a+260>>2];n=sJ(f,f>>31,b,o);f=i+Ha|0;n=h+n|0;f=n>>>0<h>>>0?f+1|0:f;Cb(e,2,n<<10|1023,f<<10|n>>>22);if((vb(e)|0)==100){p=Xc(e,0);r=Ha}g=ob(e);if(g){break a}if((d|0)!=-2){u=p;s=r;break c}v=1;g=3;if((j|0)!=1){u=p;s=r;break b}u=p;s=r;if(H[H[H[l+8>>2]>>2]+56>>2]){break b}g=101;break a}r=H[a+260>>2];t=r>>31;p=d+1|0;q=p>>31;g=Lb(a,8,l+72|0,0);d:{if(g){break d}n=H[l+72>>2];f=H[a+260>>2];e=sJ(m,o,f,f>>31);f=i+Ha|0;e=e+h|0;f=(e>>>0<h>>>0?f+1|0:f)<<10|e>>>22;e=p+(e<<10)|0;k=f+q|0;Cb(n,1,e,e>>>0<p>>>0?k+1|0:k);j=0;if((vb(n)|0)==100){j=Fd(n,0)}g=ob(n);if(g){break d}g=0;w=j;if((j|0)<16){break d}w=0;g=Tp(a,b,c,p)}if(g){break a}m=sJ(m,o,r,t);i=i+Ha|0;f=h;h=h+m|0;f=(f>>>0>h>>>0?i+1|0:i)<<10|h>>>22;h=p+(h<<10)|0;f=f+q|0;r=h>>>0<p>>>0?f+1|0:f;p=h;g=(d|0)==-1?1:(s|0)>=(r|0)&u>>>0>=h>>>0|(r|0)<(s|0)?1:3}H[l+80>>2]=0;H[l+72>>2]=0;H[l+76>>2]=0;H[l+84>>2]=g;g=Qj(a,l+8|0,l+72|0);e=0;e:{f:{g:{h:{while(1){if(g){break f}i:{g=gi(a,l+8|0);if((g|0)!=100){if(g){break f}if((d|0)==-1){break h}h=H[l+12>>2];i=H[l+8>>2];g=0;H[l+92>>2]=0;j=0;while(1){if((h|0)<=(j|0)|g){break i}g=rx(a,H[i+(j<<2)>>2]);j=j+1|0;continue}}n=H[l+68>>2];z=H[l+64>>2];m=H[l+60>>2];t=H[l+56>>2];if(!e){g=7;e=ub(64,0);if(!e){continue}h=Xa(e,0,64);i=H[a+232>>2];i=ub(i,i>>31);H[h+48>>2]=i;if(!i){continue}H[h+40>>2]=H[a+232>>2];g=Lb(a,10,l+92|0,0);if(g){continue}i=H[l+92>>2];if((vb(i)|0)==100){f=Xc(i,0);H[h+8>>2]=f;j=Ha;H[h+12>>2]=j;H[h+16>>2]=f;H[h+20>>2]=j}g=ob(i);if(g){continue}}o=H[e+44>>2];g=267;q=Lj(H[e+24>>2],H[e+28>>2],t,m);j=m-q|0;if((j|0)<=0){continue}h=n>>31;A=h;f=(Rd(q,q>>31)+(j+n|0)|0)+Rd(j,0)|0;x=Rd(n,h);h=f+x|0;i=h>>31;j:{if((o|0)<=0){break j}f=H[a+232>>2];B=f;k=f>>31;f=i;y=h+o|0;f=y>>>0<o>>>0?f+1|0:f;if((f|0)<=(k|0)&B>>>0>=y>>>0|(f|0)<(k|0)){break j}k=H[e+20>>2];i=k;h=H[e+16>>2];if((h|0)==-1&(i|0)==2147483647){continue}f=h+1|0;k=f?i:i+1|0;H[e+16>>2]=f;H[e+20>>2]=k;g=ig(a,h,i,H[e+48>>2],o);if(g){continue}H[a+52>>2]=H[a+52>>2]+1;g=Sp(a,e,t,q+1|0);if(g){continue}o=0;H[e+28>>2]=0;h=(Rd(m,m>>31)+(x+(m+n|0)|0)|0)+1|0;i=h>>31;j=m;q=0}f=i+H[e+60>>2]|0;k=h+H[e+56>>2]|0;f=k>>>0<h>>>0?f+1|0:f;H[e+56>>2]=k;H[e+60>>2]=f;f=H[e+48>>2];k=H[e+40>>2];g=h>>>0>k>>>0;k=k>>31;if(g&(i|0)>=(k|0)|(i|0)>(k|0)){g=7;f=Fc(f,h,i);if(!f){continue}H[e+40>>2]=h;H[e+48>>2]=f}h=mc(f+o|0,q,q>>31)+o|0;h=h+mc(h+H[e+48>>2]|0,j,j>>31)|0;Va(h+H[e+48>>2]|0,q+t|0,j);h=h+j|0;h=mc(h+H[e+48>>2]|0,n,A)+h|0;Va(h+H[e+48>>2]|0,z,n);H[e+44>>2]=h+n;k:{if((m|0)<=H[e+32>>2]){j=H[e+24>>2];break k}g=7;f=m<<1;j=Fc(H[e+36>>2],f,m>>31<<1|m>>>31);if(!j){continue}H[e+36>>2]=j;H[e+24>>2]=j;H[e+32>>2]=f}Va(j,t,m);H[e+28>>2]=m;g=0;continue}break}if(g){break f}l:{if(v){g=Lb(a,26,l+92|0,0);if(g){break f}g=H[l+92>>2];i=g;h=b;m=h>>31;b=H[a+260>>2];n=sJ(h,m,b,b>>31);b=n+c|0;j=c>>31;f=j+Ha|0;Cb(i,1,b<<10,(b>>>0<n>>>0?f+1|0:f)<<10|b>>>22);b=H[a+260>>2];b=sJ(b,b>>31,h,m);k=j+Ha|0;b=b+c|0;k=b>>>0<c>>>0?k+1|0:k;Cb(i,2,b<<10|1023,k<<10|b>>>22);break l}g=Lb(a,16,l+92|0,0);if(g){break f}g=H[l+92>>2];h=g;m=d>>31;i=H[a+260>>2];f=sJ(i,i>>31,b,b>>31);b=f+c|0;i=Ha+(c>>31)|0;f=(b>>>0<f>>>0?i+1|0:i)<<10|b>>>22;c=b<<10;b=c+d|0;i=f+m|0;Cb(h,1,b,b>>>0<c>>>0?i+1|0:i)}vb(g);g=ob(g);if(g|!e){break f}break g}if(e){break g}g=0;break a}m:{if(H[e>>2]){f=H[e+20>>2];t=f;q=H[e+16>>2];b=q+1|0;f=b?f:f+1|0;H[e+16>>2]=b;H[e+20>>2]=f;g=ig(a,q,t,H[e+48>>2],H[e+44>>2]);if(g){break m}f=H[e+16>>2];n=H[e+20>>2];m=H[e+8>>2];o=H[e+12>>2];j=e;b=1;while(1){j=H[j>>2];if(H[j>>2]){c=j+8|0;g=0;h=f;i=n;while(1){k=H[c>>2];if(!(!k|g)){c=k+4|0;g=px(k,b,m,o);g=ig(a,h,i,g+H[k+36>>2]|0,H[k+32>>2]-g|0);k=H[k+12>>2]+1|0;v=k;m=k+m|0;k=(k>>31)+o|0;o=m>>>0<v>>>0?k+1|0:k;h=h+1|0;i=h?i:i+1|0;continue}break}if(g){break m}b=b+1|0;m=f;o=n;f=h;n=i;continue}break}b=px(j,b,m,o);g=Rp(a,p,r,w,H[e+8>>2],H[e+12>>2],q,t,f-1|0,n-!f|0,H[e+56>>2],H[e+60>>2],b+H[j+36>>2]|0,H[j+32>>2]-b|0);break m}g=Rp(a,p,r,w,0,0,0,0,0,0,H[e+56>>2],H[e+60>>2],H[e+48>>2],H[e+44>>2])}H[a+52>>2]=H[a+52>>2]+1;if(g){break f}if((d|0)!=-1){g=0;if((r|0)>=(s|0)&p>>>0>=u>>>0|(r|0)>(s|0)){break f}}g=ox(a,p,r,H[e+56>>2],H[e+60>>2]);break e}if(!e){break a}}Ta(H[e+48>>2]);Ta(H[e+36>>2]);nx(H[e>>2]);Ta(e)}$g(l+8|0);Ea=l+96|0;return g}function Wq(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0;q=Ea-96|0;Ea=q;r=H[H[a>>2]>>2];a:{if(H[r+36>>2]){i=H[r+12>>2];break a}s=H[r>>2];e=H[a+8>>2];u=J[e+22>>1];x=H[e>>2];y=H[e+4>>2];z=J[e+46>>1];A=J[e+28>>1];B=J[e+26>>1];t=J[e+44>>1];l=J[e+24>>1];v=H[e+40>>2];f=v&32?24:447;h=I[c+55|0]|I[c+56|0]<<8;g=h&4?f&387:f;f=Fm(q,H[a+4>>2],H[b+40>>2],l,h&260?h&256?g&316:g:f,c);G[e+18>>1]=0;C=t+1|0;D=G[H[c+8>>2]>>1];w=Bm(D);h=0;b:{while(1){if(!f|i){break b}c:{n=J[f+12>>1];d:{if(!(!(I[f+10|0]&128)&(n|0)!=256)){i=0;if(mA(c,l)){break d}}i=0;j=H[e+8>>2];k=H[e+12>>2];if(j&H[f+32>>2]|k&H[f+36>>2]|(J[f+10>>1]&256?(n|0)==16:0)){break d}if(I[b+36|0]&88){if(!Yq(f,b)){break d}}e:{if(I[c+54|0]){g=2;if((J[c+50>>1]-1|0)==(l|0)){break e}}g=1}F[a+16|0]=g|I[a+16|0];G[e+44>>1]=t;G[e+28>>1]=A;G[e+26>>1]=B;G[e+24>>1]=l;H[e+40>>2]=v;g=t;if(g>>>0>=J[e+48>>1]){if(oi(s,e,C)){break c}j=H[e+8>>2];k=H[e+12>>2];g=J[e+44>>1]}p=g+1|0;G[e+44>>1]=p;H[H[e+52>>2]+(g<<2)>>2]=f;k=(y|H[f+36>>2])&(k^-1);H[e>>2]=(x|H[f+32>>2])&(j^-1);H[e+4>>2]=k;f:{if(n&1){k=H[f>>2];g:{if(I[k+5|0]&16){g=p&65535;p=(g>>>0<=1?1:g)-1|0;g=0;j=46;while(1){if((g|0)==(p|0)){break g}o=H[H[e+52>>2]+(g<<2)>>2];if(o){j=(k|0)!=H[o>>2]?j:0}g=g+1|0;continue}}j=0;g=H[k+20>>2];if(!g){break g}g=H[g>>2];if(!g){break g}j=Kd(g,g>>31)&65535}h:{if(!(I[c+55|0]&128)|(w|0)<10){break h}if(!(((J[H[c+8>>2]+(l<<1)>>1]-(j+w|0)|0)+Bm(j<<16>>16)|0)+10&32768)){break h}if(I[s+82|0]&2|(d|0)>1){break d}H[e+40>>2]=H[e+40>>2]|1048576}i=H[e+40>>2]|4;H[e+40>>2]=i;break f}if(n&130){g=G[H[c+4>>2]+(l<<1)>>1];k=H[e+40>>2];i=k|1;H[e+40>>2]=i;j=4097;i:{j:{if((g|0)==-1){break j}if((g|0)<0|d){break i}g=J[c+50>>1];if((g-1|0)!=(l|0)){break i}if(!(I[c+54|0]?(g|0)!=1|(n|0)!=2:1)|I[c+55|0]&8){break j}j=65537}i=j|k;H[e+40>>2]=i}j=0;if(I[q+25|0]<2){break f}i=i|2097152;H[e+40>>2]=i;break f}if(n&256){i=H[e+40>>2]|8;H[e+40>>2]=i;j=0;break f}p=H[b+40>>2];g=1;h=Qc(H[H[f>>2]+12>>2]);m=J[c+52>>1]-l|0;h=(h|0)<(m|0)?h:m;m=(h|0)<=1?1:h;k:{while(1){if((g|0)==(m|0)){break k}h=H[f>>2];i=H[h+16>>2];j=i+20|0;k=g<<4;h=H[(k+H[H[h+12>>2]+20>>2]|0)+8>>2];j=I[i+5|0]&16?H[i+20>>2]+28|0:j;l:{if(I[h|0]!=167|(p|0)!=H[h+28>>2]){break l}i=g+l|0;if(J[h+32>>1]!=J[H[c+4>>2]+(i<<1)>>1]){break l}o=H[c+28>>2];if(I[o+i|0]!=I[l+o|0]){break l}o=H[(k+H[j>>2]|0)+8>>2];K=ug(o,rc(h));j=68;k=G[h+32>>1];m:{if((k|0)<0){break m}E=H[c+12>>2];if((k|0)>=G[E+34>>1]){break m}j=I[(H[E+4>>2]+N(k,12)|0)+5|0]}if((K&255)!=(j&255)){break l}h=Zf(r,h,o);if(!h){break l}if(ab(H[h>>2],H[H[c+32>>2]+(i<<2)>>2])){break l}g=g+1|0;continue}break}m=g}h=H[e+40>>2];if(n&36){G[e+26>>1]=m;i=h|34;H[e+40>>2]=i;j=0;h=f;m=0;if(!(F[f+11|0]&1)){break f}if(oi(s,e,J[e+44>>1]+1|0)){break c}h=J[e+44>>1];G[e+44>>1]=h+1;m=f+48|0;H[H[e+52>>2]+(h<<2)>>2]=m;G[e+28>>1]=1;i=H[e+40>>2]|16;H[e+40>>2]=i;h=f;break f}G[e+28>>1]=m;i=h|18;H[e+40>>2]=i;j=0;if(h&32){h=H[(H[e+52>>2]+(J[e+44>>1]<<2)|0)-8>>2]}else{h=0}m=f}n:{o:{if(i&2){g=G[e+22>>1];f=Ez(m,Ez(h,g));g=g+((h?-1:0)-((m|0)!=0)|0)|0;f=(!h|!m|G[h+8>>1]<=0?f:G[m+8>>1]>0?f-20|0:f)<<16>>16;f=(f|0)<=10?10:f;f=(f|0)>(g|0)?g:f;break o}g=J[e+24>>1]+1|0;G[e+24>>1]=g;f=G[f+8>>1];if(!(G[H[c+4>>2]+(l<<1)>>1]<0|(f|0)>0)){f=J[e+22>>1]+(f-j|0)|0;break o}f=H[c+8>>2]+((g&65535)<<1)|0;f=J[e+22>>1]+(J[f>>1]-J[f-2>>1]|0)|0;G[e+22>>1]=f;if(!(n&256)){break n}f=f+10|0}G[e+22>>1]=f}if(((I[c+55|0]|I[c+56|0]<<8)&3)==3){g=f+16|0}else{g=(((N(G[c+48>>1],15)|0)/G[H[b+16>>2]+40>>1]|0)+(f&65535)|0)+1|0}g=ce(w,g<<16>>16);if(!(i&67109184)){g=ce(g,f+16<<16>>16)}j=d+j|0;G[e+22>>1]=j+f;G[e+20>>1]=g+j;Xq(H[a+4>>2],e,D);i=ck(a,e);g=f;f=H[e+40>>2];G[e+22>>1]=f&2?u:g;p:{if(f&16){break p}f=J[e+24>>1];if(f>>>0>=J[c+52>>1]){break p}if(f>>>0>=J[c+50>>1]){if(((I[c+55|0]|I[c+56|0]<<8)&3)==2){break p}}if(f>>>0>=4){Km(r)}Wq(a,b,c,j<<16>>16)}G[e+22>>1]=u}f=pi(q);continue}break}i=0}G[e+46>>1]=z;G[e+28>>1]=A;G[e+26>>1]=B;G[e+24>>1]=l;H[e>>2]=x;H[e+4>>2]=y;H[e+40>>2]=v;G[e+44>>1]=t;G[e+22>>1]=u;if((l|0)!=(z|0)){break a}f=l+1|0;if(I[s+81|0]&64|((l|0)!=(t|0)|f>>>0>=J[c+50>>1]|((I[c+55|0]|I[c+56|0]<<8)&192)!=128)){break a}f=f<<1;if(G[f+H[c+8>>2]>>1]<42){break a}i=oi(s,e,C);if(i){break a}G[e+24>>1]=J[e+24>>1]+1;G[e+46>>1]=J[e+46>>1]+1;h=J[e+44>>1];G[e+44>>1]=h+1;i=0;H[H[e+52>>2]+(h<<2)>>2]=0;H[e+40>>2]=H[e+40>>2]|32768;h=H[c+8>>2];f=J[h+(l<<1)>>1]-J[f+h>>1]|0;G[e+22>>1]=J[e+22>>1]-f;Wq(a,b,c,(d+f|0)+5<<16>>16);G[e+46>>1]=l;G[e+24>>1]=l;G[e+22>>1]=u;H[e+40>>2]=v}Ea=q+96|0;return i}function oe(){var a=0,b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0;a:{if(!H[16532]){H[16534]=1;if(!H[16535]){if(!H[16488]){Pw()}H[18230]=8;if(!(!(!H[16526]|H[16527]<512)&H[16528]>0)){H[16526]=0;H[16527]=0}a=Ia[H[16493]](H[16495])|0;if(a){break a}}H[16535]=1;if(!H[16538]){H[16538]=8}g=H[16537]+1|0;H[16537]=g;if(!(H[16532]|H[16533])){H[16533]=1;Xa(73096,0,92);uj(70128,5);uj(70336,15);uj(70944,10);uj(71344,32);uj(67088,76);b:{if(!H[16536]){q=H[16507];if(!q){vw();q=H[16507]}q=Ia[q|0](H[16506])|0;if(q){break b}}q=1;H[16536]=1;a=lc(10);if(!a){q=7;break b}Ta(a);while(1){if((e|0)!=4){pw(N(e,88)+66224|0,!e);e=e+1|0;continue}break}B=66944,C=Mw(19454),H[B>>2]=C;B=66948,C=Mw(19461),H[B>>2]=C;c=Xl(0);if(!c){break b}a=H[c+4>>2];H[16747]=c;H[16743]=a>>>0<=12?12:a;q=pw(66968,0);if(q){break b}q=0;if(H[18314]){g=H[16526];c=g?H[16528]:0;H[18324]=c;H[18318]=c;a=c?H[16527]&-8:0;H[18317]=a;H[18320]=g;H[18319]=(c|0)>90?10:((c|0)/10|0)+1|0;H[18325]=0;H[18323]=0;e=0;while(1){if(c){H[g>>2]=e;H[18323]=g;c=c-1|0;e=g;g=a+g|0;continue}break}H[18321]=g}H[16532]=1}H[16533]=0;g=H[16537]}H[16537]=g-1;if((g|0)<=1){H[16538]=0}n=Ea-48|0;Ea=n;u=+(q+1|0);Kl(n+32|0,u*.1+1);Kl(n+16|0,u*25+1e18);d=H[n+20>>2];x=d;v=H[n+16>>2];c=v;f=H[n+28>>2];y=f;h=Ea-112|0;Ea=h;w=H[n+24>>2];a=w;l=f&2147483647;r=H[n+44>>2];e=r&2147483647;i=e;c:{d:{g=2147418112;b=H[n+32>>2];k=H[n+36>>2];m=!(b|k);j=H[n+40>>2];if(!(e|j?e-g>>>0<2147549184:m)){e=l-g|0;if(!a&(e|0)==-2147418112?c|d:(e|0)==-2147418112&(a|0)!=0|e>>>0>2147549184){break d}}if(!(!j&(i|0)==2147418112?m:i>>>0<2147418112)){a=j;f=r|32768;c=b;d=k;break c}if(!(!a&(l|0)==2147418112?!(c|d):l>>>0<2147418112)){f=f|32768;break c}if(!(b|j|(i^2147418112|k))){d=!(b^c|a^j|(d^k|f^r^-2147483648));a=d?0:j;f=d?2147450880:r;c=d?0:b;d=d?0:k;break c}g=a|c;if(!(g|(l^2147418112|d))){break c}if(!(b|j|(i|k))){if(d|l|g){break c}c=b&c;d=d&k;a=a&j;f=f&r;break c}if(a|c|(d|l)){break d}c=b;d=k;a=j;f=r;break c}g=(i|0)==(l|0);s=g&(a|0)==(j|0)?(d|0)==(k|0)&b>>>0<c>>>0|d>>>0>k>>>0:g&a>>>0>j>>>0|i>>>0<l>>>0;i=s;m=i?c:b;l=i?d:k;g=i?f:r;z=g;i=i?a:j;t=g&65535;o=s?j:a;e=s?r:f;a=e;e=a>>>16&32767;g=g>>>16&32767;if(!g){p=!(i|t);g=p?m:i;j=p<<6;A=Q(g)+32|0;g=Q(p?l:t);g=j+((g|0)==32?A:g)|0;Yd(h+96|0,m,l,i,t,g-15|0);i=H[h+104>>2];t=H[h+108>>2];l=H[h+100>>2];g=16-g|0;m=H[h+96>>2]}c=s?b:c;d=s?k:d;b=o;o=a&65535;if(!e){e=o;p=!(e|b);k=p?c:b;a=p<<6;o=Q(p?d:e);o=a+((o|0)==32?Q(k)+32|0:o)|0;Yd(h+80|0,c,d,b,e,o-15|0);e=16-o|0;c=H[h+80>>2];d=H[h+84>>2];b=H[h+88>>2];o=H[h+92>>2]}k=b;b=o<<3|b>>>29;k=k<<3|d>>>29;p=b|524288;b=t<<3|i>>>29;i=i<<3|l>>>29;o=b;f=f^r;b=d<<3|c>>>29;a=c<<3;e:{if((g|0)==(e|0)){break e}c=g-e|0;if(c>>>0>127){k=0;p=0;b=0;a=1;break e}Yd(h- -64|0,a,b,k,p,128-c|0);$h(h+48|0,a,b,k,p,c);k=H[h+56>>2];p=H[h+60>>2];b=H[h+52>>2];a=H[h+48>>2]|(H[h+64>>2]|H[h+72>>2]|(H[h+68>>2]|H[h+76>>2]))!=0}e=a;j=b;o=o|524288;b=l<<3|m>>>29;l=m<<3;f:{if((f|0)<0){c=0;d=0;a=0;f=0;if(!(e^l|i^k|(b^j|o^p))){break c}c=l-e|0;d=b-((e>>>0>l>>>0)+j|0)|0;m=i-k|0;f=(b|0)==(j|0)&e>>>0>l>>>0|b>>>0<j>>>0;a=m-f|0;f=(o-((i>>>0<k>>>0)+p|0)|0)-(f>>>0>m>>>0)|0;if(f>>>0>524287){break f}m=!(a|f);b=m?c:a;e=m<<6;j=Q(b)+32|0;b=Q(m?d:f);b=e+((b|0)==32?j:b)|0;e=a;a=b-12|0;Yd(h+32|0,c,d,e,f,a);g=g-a|0;a=H[h+40>>2];f=H[h+44>>2];c=H[h+32>>2];d=H[h+36>>2];break f}b=b+j|0;c=e+l|0;d=c>>>0<l>>>0?b+1|0:b;a=(j|0)==(d|0)&c>>>0<e>>>0|d>>>0<j>>>0;b=o+p|0;f=i+k|0;b=f>>>0<i>>>0?b+1|0:b;a=a+f|0;f=a>>>0<f>>>0?b+1|0:b;if(!(f&1048576)){break f}c=e&1|((d&1)<<31|c>>>1);d=a<<31|d>>>1;g=g+1|0;a=(f&1)<<31|a>>>1;f=f>>>1|0}i=0;b=z&-2147483648;l=b;if((g|0)>=32767){a=i;f=b|2147418112;c=0;d=0;break c}e=0;g:{if((g|0)>0){e=g;break g}Yd(h+16|0,c,d,a,f,g+127|0);$h(h,c,d,a,f,1-g|0);c=H[h>>2]|(H[h+16>>2]|H[h+24>>2]|(H[h+20>>2]|H[h+28>>2]))!=0;d=H[h+4>>2];a=H[h+8>>2];f=H[h+12>>2]}m=(d&7)<<29|c>>>3;d=a<<29|d>>>3;b=f>>>3|0;f=i|((f&7)<<29|a>>>3);a=l|(b&65535|e<<16);h:{i:{e=c&7;if((e|0)!=4){j=f;b=d;c=e>>>0>4;d=c;c=c+m|0;d=d>>>0>c>>>0?b+1|0:b;b=(b|0)==(d|0)&c>>>0<m>>>0|d>>>0<b>>>0;f=a;a=b+j|0;f=a>>>0<b>>>0?f+1|0:f;break i}b=a;a=d;c=m&1;e=c;c=c+m|0;d=e>>>0>c>>>0?a+1|0:a;a=(a|0)==(d|0)&c>>>0<m>>>0|a>>>0>d>>>0;e=a;a=a+f|0;f=e>>>0>a>>>0?b+1|0:b;break h}if(!e){break c}}}H[n>>2]=c;H[n+4>>2]=d;H[n+8>>2]=a;H[n+12>>2]=f;Ea=h+112|0;a=Cj(H[n>>2],H[n+4>>2],H[n+8>>2],H[n+12>>2],v,x,w,y);Ea=n+48|0;F[65930]=(a|0)!=0}return q}H[18236]=0;H[18237]=0;H[18234]=0;H[18235]=0;H[18232]=0;H[18233]=0;H[18230]=0;H[18231]=0;return a}function $x(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;g=Ea-32|0;Ea=g;H[g+4>>2]=0;t=1;s=c;while(1){a:{b:{c:{d:{e:{f:{if(!m){H[g>>2]=0;H[a+24>>2]=0;o=s>>31&s;j=b;h=s;while(1){if((h|0)>0){f=I[j|0]-9|0;if(f>>>0>23|!(1<<f&8388639)){break f}j=j+1|0;h=h-1|0;continue}break}if((s|0)<0){break e}m=101;p=0;break a}j=H[g+4>>2];H[e>>2]=c-s;f=(m|0)==101?j?t?1:m:m:m;a=0;if((f|0)==101){break c}break d}o=h}q=j-b|0;k=0;p=0;h=0;while(1){g:{h:{i:{if((h|0)!=4){f=h<<3;if(I[f+56565|0]>1){break h}i=f+56560|0;f=I[i+4|0];if((o|0)<(f|0)){break h}if(Hb(j,H[i>>2],f)){break h}H[g+28>>2]=10;u=I[i+6|0];if(!((u|0)!=1|I[j+4|0]!=47|(I[j+5|0]-48&255)>>>0>9)){f=f+1|0;f=Ix(f+j|0,g+28|0)+f|0}i=I[f+j|0];j:{if(i>>>0>=42){break j}l=i&31;if((i&63)>>>0>=32){l=773>>>l|0}else{l=((1<<l)-1&773)<<32-l|15873>>>l}if(!(l&1)){break j}m=i&31;if((i&63)>>>0>=32){n=772>>>m|0}else{n=((1<<m)-1&772)<<32-m|1>>>m}l=He(48,0);if(l){H[l>>2]=u;H[l+4>>2]=H[g+28>>2];H[g>>2]=l;p=f+q|0;m=0;k=l;if(n&1){break j}break g}m=7;if(!(n&1)){break a}}f=i-34|0;if(f>>>0>7|!(1<<f&193)){break i}break g}k:{l:{m:{n:{h=I[j|0];switch(h-40|0){case 0:break l;case 1:break m;default:break n}}if((h|0)==34){h=1;f=(o|0)<=1?1:o;while(1){o:{if((h|0)!=(f|0)){if(I[h+j|0]!=34){break o}f=h}m=1;p=(f+q|0)+1|0;if((f|0)==(o|0)){break a}i=H[a>>2];q=H[i>>2];k=0;H[g+28>>2]=0;o=0;l=0;h=0;p:{u=j+1|0;v=f-1|0;m=jg(i,H[a+4>>2],u,v,g+28|0);q:{if(!m){i=0;f=0;m=0;while(1){if(!m){H[g+20>>2]=0;H[g+16>>2]=0;H[g+12>>2]=0;H[g+8>>2]=0;m=Ia[H[q+20>>2]](H[g+28>>2],g+24|0,g+20|0,g+16|0,g+12|0,g+8|0)|0;if(m){i=i+1|0;f=i?f:f+1|0;continue}n=sJ(i,f,24,0);n=n+144|0;k=Vp(k,n&-8,0);if(!k){break q}h=H[g+20>>2]+l|0;o=Vp(o,h,h>>31);if(o){h=N(i,24)+k|0;H[h+136>>2]=0;H[h+140>>2]=0;H[h+128>>2]=0;H[h+132>>2]=0;H[h+120>>2]=0;H[h+124>>2]=0;Va(l+o|0,H[g+24>>2],H[g+20>>2]);w=H[g+20>>2];H[h+124>>2]=w;n=H[g+12>>2];if((v|0)>(n|0)){n=I[n+u|0]==42}else{n=0}H[h+128>>2]=n;l=l+w|0;n=H[g+16>>2];if((n|0)>0){n=I[j+n|0]==94}else{n=0}H[h+132>>2]=n;i=i+1|0;f=i?f:f+1|0;h=i;continue}else{o=0;break q}}break}Ia[H[q+16>>2]](H[g+28>>2])|0;H[g+28>>2]=0}if((m|0)!=101){break k}j=N(h,24);k=Vp(k,(j+l|0)+144|0,0);if(k){break p}k=0}h=H[g+28>>2];if(h){Ia[H[q+16>>2]](h)|0}Ta(o);Ta(k);m=7;k=0;break k}i=Xa(k,0,120);f=i+48|0;H[i+20>>2]=f;H[i>>2]=5;m=H[a+20>>2];H[i+112>>2]=h;H[i+116>>2]=m;h=(j+i|0)+120|0;m=0;if(o){Va(h,o,l);Ta(o);f=H[i+20>>2]}i=H[f+64>>2];i=(i|0)>0?i:0;f=f+72|0;j=0;while(1){if((j|0)==(i|0)){break k}l=f+N(j,24)|0;H[l>>2]=h;j=j+1|0;h=H[l+4>>2]+h|0;continue}}h=h+1|0;continue}}p=0;h=H[a+16>>2];k=(h|0)>0?h:0;f=H[a+20>>2];h=0;while(1){r:{s:{if((h|0)==(k|0)){h=f;break s}m=H[H[a+8>>2]+(h<<2)>>2];i=tb(m);if((i|0)>=(o|0)|I[j+i|0]!=58){break r}if(yb(m,j,i)){break r}p=(i+q|0)+1|0}j=0;o=s-p|0;l=(o|0)>0?o:0;f=b+p|0;i=H[a>>2];q=H[i>>2];while(1){t:{if((j|0)!=(l|0)){k=I[f+j|0]-34|0;if(k>>>0>7|!(1<<k&193)){break t}l=j}k=0;m=jg(i,H[a+4>>2],f,l,g+28|0);if(!m){H[g+20>>2]=0;H[g+16>>2]=0;H[g+12>>2]=0;H[g+8>>2]=0;n=H[g+28>>2];i=Ia[H[q+20>>2]](n,g+24|0,g+20|0,g+16|0,g+12|0,g+8|0)|0;u:{if(!i){k=He(H[g+20>>2]+144|0,0);if(!k){k=0;l=H[g+12>>2];m=7;break u}H[k+116>>2]=h;H[k+112>>2]=1;H[k>>2]=5;H[k+20>>2]=k+48;h=H[g+20>>2];i=k+144|0;H[k+120>>2]=i;H[k+124>>2]=h;Va(i,H[g+24>>2],h);l=H[g+12>>2];if(!((o|0)<=(l|0)|I[f+l|0]!=42)){H[k+128>>2]=1;l=l+1|0;H[g+12>>2]=l}h=f-1|0;f=H[a+12>>2];j=H[g+16>>2];while(1){if(!(!f|(j|0)<=0|I[h+j|0]!=94)){H[k+132>>2]=1;j=j-1|0;continue}break}H[g+16>>2]=j;m=0;break u}m=l?(i|0)!=101?i:0:i}Ia[H[q+16>>2]](n)|0}H[g>>2]=k;p=l+p|0;break g}j=j+1|0;continue}}h=h+1|0;continue}}H[a+32>>2]=H[a+32>>2]-1;p=q+1|0;m=101;break a}H[g+28>>2]=0;m=1;h=H[a+32>>2];H[a+32>>2]=h+1;if((h|0)>999){break g}m=$x(a,j+1|0,o-1|0,g,g+28|0);p=(q+H[g+28>>2]|0)+1|0;k=H[g>>2];break g}H[g>>2]=k;break g}if(!i){break g}}h=h+1|0;continue}break}if(!k|m){break a}v:{w:{x:{i=H[k>>2];if((i|0)==5){h=0;l=(t|0)!=0;j=1;break x}l=(t|0)!=0;f=H[k+12>>2];j=(f|0)!=0;h=!f;if(f|!t){break x}_d(k);break w}y:{if(h|l){if(r){break y}r=0;break b}f=He(48,0);if(!f){_d(k);f=7;break v}H[f>>2]=3;Fx(g+4|0,r,f);r=f}if(!(!((i|0)!=1|j)&H[r>>2]!=5)){if(j^1|(i|0)==5|H[r>>2]!=1){break b}}_d(H[g>>2])}f=1}j=H[g+4>>2]}_d(j);j=0;_d(0);a=f}H[d>>2]=j;Ea=g+32|0;return a}z:{A:{B:{if(j){f=H[g>>2];if(!H[g+4>>2]){break B}H[r+16>>2]=f;H[f+8>>2]=r;break A}Fx(g+4|0,r,H[g>>2]);f=H[g>>2];break z}H[g+4>>2]=f}}r=f;m=0;t=h}b=b+p|0;s=s-p|0;continue}}function yF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;d=Ea-80|0;Ea=d;a:{if(Rl(a,10120,H[c>>2],d+12|0)){break a}if((b|0)>=2){e=$a(H[c+4>>2])}f=H[d+12>>2];b=H[f+16>>2];if(!b){le(a,30558,0,0);break a}o=e?e:1584;p=H[f>>2];H[d+40>>2]=0;H[d+44>>2]=0;H[d+32>>2]=0;H[d+36>>2]=0;H[d+24>>2]=0;H[d+28>>2]=0;H[d+16>>2]=f;H[d+20>>2]=H[p+24>>2];b:{c:{d:{e:{c=H[f+92>>2];if(c){if(!Tc(H[c+12>>2],o)){m=1;break e}Gx(c);H[f+92>>2]=0;b=H[f+16>>2]}H[d+64>>2]=0;gg(b,114,d- -64|0);b=H[d+64>>2];H[f+24>>2]=b;H[d+24>>2]=b;e=0;b=0;while(1){f:{g:{h:{c=I[b+o|0];if(c){g=c<<24>>24;H[d+64>>2]=0;h=c-108|0;if(h>>>0>13){break h}if(1<<h&12432){break f}if(h){if((h|0)!=2){break h}if(I[p+236|0]){break f}break g}if(!I[p+238|0]){break g}break f}b=e>>>29|0;h=tb(o);g=e<<3;c=g+h|0;b=h>>>0>c>>>0?b+1|0:b;c=c+25|0;b=c>>>0<25?b+1|0:b;c=He(c,b);if(c){H[c+16>>2]=20;b=e<<2;H[(b+c|0)+20>>2]=b+24;b=(c+g|0)+24|0;H[c+12>>2]=b;H[c+4>>2]=e;Va(b,o,h+1|0);F[c|0]=1;H[f+88>>2]=1;H[f+92>>2]=c;break e}H[f+88>>2]=1;H[f+92>>2]=0;break d}i:{switch(c-97|0){case 1:case 2:break f;case 0:break i;default:break g}}if(I[p+236|0]){break f}}H[d>>2]=g;Sd(d- -64|0,17936,d);b=a;a=H[d+64>>2];Gb(b,a,-1);Ta(a);break b}b=b+1|0;e=Np(d+16|0,g)+e|0;continue}}j:{if(!I[c+1|0]){F[c+1|0]=1;h=c+20|0;q=115;break j}if(!I[c+2|0]){F[c+2|0]=1;h=((H[c+4>>2]<<2)+c|0)+24|0;q=115;break j}h=ub(H[c+4>>2]<<2,0);if(!h){break d}q=1;if(!H[c+8>>2]){break j}Va(h,c+20|0,H[c+4>>2]<<2)}H[d+44>>2]=h;H[d+24>>2]=H[f+24>>2];r=H[f>>2];H[d+72>>2]=0;v=d+32|0;e=h;c=0;while(1){k:{l:{m:{n:{o:{p:{q:{r:{s:{if(c){break s}u=o+t|0;b=I[u|0];if(!b){break s}c=b<<24>>24;F[d+40|0]=c;t:{u:{v:{w:{switch(b-108|0){default:switch(b-97|0){case 1:break o;case 0:break t;case 2:break v;default:break r};case 0:break l;case 7:break n;case 1:case 3:case 5:case 6:break q;case 2:break u;case 4:break w}}c=0;if(m){break k}H[e>>2]=H[d+24>>2];break k}c=0;if(m){break k}H[e>>2]=H[d+20>>2];break k}if(m){break p}H[d+64>>2]=0;H[d+68>>2]=0;c=Lp(r,d+72|0,d- -64|0,0,0);H[d+76>>2]=c;H[H[d+44>>2]>>2]=H[d+64>>2];break k}if(m){break p}c=Lp(r,d+72|0,d- -64|0,d+60|0,d+56|0);H[d+76>>2]=c;if(c){break k}c=H[d+68>>2];j=c;i=H[d+64>>2];e=tJ(i,c,2,0);g=Ha;c=0;b=0;while(1){if(H[d+20>>2]<=(b|0)){break k}n=zc(H[d+60>>2],d+48|0)+H[d+60>>2]|0;H[d+60>>2]=n;if(n>>>0>K[d+56>>2]){c=267;break m}else{k=H[d+44>>2]+(b<<2)|0;l=e+H[d+48>>2]|0;n=l>>>0<e>>>0?g+1|0:g;w=k,x=tJ(l,n,i,j),H[w>>2]=x;b=b+1|0;continue}}}ob(H[d+72>>2]);if(!m){b=H[f+92>>2];e=b+8|0;H[e>>2]=1;g=e;e=H[b+4>>2]<<2;Va((g+e|0)+16|0,b+20|0,e)}if(c){break c}le(a,h,H[H[f+92>>2]+4>>2]<<2,q);break b}if((b|0)==121){break o}}b=H[f+16>>2];c=Ql(f,0,0);H[d+76>>2]=c;if(c){break k}if(!m){if(H[f+28>>2]){c=Lp(r,d+72|0,v,0,0);H[d+76>>2]=c;if(c){break k}}w=d,x=gg(b,116,d+16|0),H[w+76>>2]=x;dq(f,d+76|0);c=H[d+76>>2];if(c){break k}}gg(b,117,d+16|0)}c=0;break k}b=d+16|0;Xa(e,0,Np(b,c)<<2);c=fx(H[f+16>>2],b);break m}c=Ql(f,0,0);H[d+76>>2]=c;if(c){break k}i=He(H[f+24>>2]<<4,0);if(!i){c=7;break m}gg(H[f+16>>2],118,i);j=0;b=H[d+24>>2];e=(b|0)>0?b:0;b=0;c=0;while(1){if((c|0)!=(e|0)){g=(c<<4)+i|0;b=b-H[H[H[g>>2]+20>>2]+64>>2]|0;H[g+4>>2]=b;c=c+1|0;continue}break}while(1){l=0;k=0;e=0;x:{y:{if(H[d+20>>2]<=(j|0)){c=0;break y}while(1){if(H[d+24>>2]>(e|0)){b=(e<<4)+i|0;c=Pl(f,H[b>>2],j,b+8|0);if(c){break y}if(H[b+8>>2]){H[b+12>>2]=H[b+4>>2];ex(b);if(!H[b+8>>2]){c=267;break y}k=k+1|0}e=e+1|0;continue}break}while(1){if((k|0)<=0){break x}c=0;b=H[d+24>>2];n=(b|0)>0?b:0;g=0;e=0;while(1){if((c|0)!=(n|0)){b=(c<<4)+i|0;z:{if(!H[b+8>>2]){b=0;break z}g=(H[b+12>>2]>=H[g+12>>2]?g:0)?g:b;A:{if(e){s=1;if(H[b+12>>2]!=H[b-4>>2]){break A}}s=e+1|0}b=s;l=(b|0)>(l|0)?b:l}c=c+1|0;e=b;continue}break}k=k-ex(g)|0;continue}}Ta(i);break m}H[H[d+44>>2]+(j<<2)>>2]=l;j=j+1|0;continue}}H[d+76>>2]=c;break k}b=H[f+32>>2];g=H[f+36>>2];H[d+64>>2]=0;c=Lb(r,21,d- -64|0,0);e=H[d+64>>2];B:{C:{if(!c){Cb(e,1,b,g);if((vb(e)|0)==100){if((hh(e,0)|0)==4){break C}}b=ob(e);c=b?b:267;e=0}H[d+76>>2]=c;break B}c=0;H[d+76>>2]=0;b=Ue(e,0);g=b+Nd(e,0)|0;while(1){if(H[d+20>>2]<=(c|0)){break B}b=Vl(b,g,d- -64|0)+b|0;if(g>>>0<b>>>0){H[d+76>>2]=267}else{H[H[d+44>>2]+(c<<2)>>2]=H[d+64>>2];c=c+1|0;continue}break}}ob(e);c=H[d+76>>2]}e=H[d+44>>2]+(Np(d+16|0,F[u|0])<<2)|0;H[d+44>>2]=e;t=t+1|0;continue}}h=0;c=7}Xd(a,c);if(!q){break b}Ia[q|0](h)}Ge(p)}Ea=d+80|0}function ne(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,I=0,J=0,K=0,L=0,M=0,N=0,O=0,P=0,R=0,S=0;k=Ea-96|0;Ea=k;u=i&65535;o=(e^i)&-2147483648;r=e&65535;y=r;R=i>>>16&32767;S=e>>>16&32767;a:{b:{if(R-32767>>>0>4294934529&S-32767>>>0>=4294934530){break b}s=e&2147483647;q=s;j=d;if(!(!d&(q|0)==2147418112?!(b|c):q>>>0<2147418112)){m=d;o=e|32768;break a}s=i&2147483647;p=s;e=h;if(!(!e&(p|0)==2147418112?!(f|g):p>>>0<2147418112)){m=e;o=i|32768;b=f;c=g;break a}if(!(b|j|(q^2147418112|c))){if(!(e|f|(g|p))){o=2147450880;b=0;c=0;break a}o=o|2147418112;b=0;c=0;break a}if(!(e|f|(p^2147418112|g))){e=b|j;d=c|q;b=0;c=0;if(!(d|e)){o=2147450880;break a}o=o|2147418112;break a}if(!(b|j|(c|q))){b=0;c=0;break a}if(!(e|f|(g|p))){b=0;c=0;break a}if((q|0)==65535|q>>>0<65535){j=!(d|r);i=j?b:d;s=j<<6;e=Q(i)+32|0;i=Q(j?c:r);i=s+((i|0)==32?e:i)|0;Yd(k+80|0,b,c,d,r,i-15|0);t=16-i|0;d=H[k+88>>2];y=H[k+92>>2];c=H[k+84>>2];b=H[k+80>>2]}if(p>>>0>65535){break b}i=!(h|u);e=i?f:h;r=i<<6;j=Q(e)+32|0;e=Q(i?g:u);e=r+((e|0)==32?j:e)|0;Yd(k- -64|0,f,g,h,u,e-15|0);t=(t-e|0)+16|0;h=H[k+72>>2];u=H[k+76>>2];f=H[k+64>>2];g=H[k+68>>2]}e=f;f=g<<15|f>>>17;i=e<<15;e=0;v=i&-32768;K=c;s=sJ(v,e,c,0);e=Ha;z=e;L=f;q=b;b=sJ(f,0,b,0);c=b+s|0;f=Ha+e|0;i=b>>>0>c>>>0?f+1|0:f;j=0;b=sJ(q,l,v,l);p=j+b|0;f=c;e=f+Ha|0;e=b>>>0>p>>>0?e+1|0:e;r=e;M=(f|0)==(e|0)&j>>>0>p>>>0|e>>>0<f>>>0;N=d;w=sJ(v,l,d,0);O=Ha;b=sJ(K,l,L,l);x=b+w|0;j=Ha+O|0;j=b>>>0>x>>>0?j+1|0:j;b=u<<15|h>>>17;A=h<<15|g>>>17;d=sJ(A,0,q,l);B=d+x|0;f=Ha+j|0;f=d>>>0>B>>>0?f+1|0:f;C=f;e=i;D=e+B|0;f=((e|0)==(z|0)&c>>>0<s>>>0|e>>>0<z>>>0)+f|0;f=e>>>0>D>>>0?f+1|0:f;u=f;g=D;c=f;E=y|65536;y=sJ(v,l,E,n);P=Ha;d=sJ(N,m,L,l);F=d+y|0;e=Ha+P|0;e=d>>>0>F>>>0?e+1|0:e;i=e;G=b|-2147483648;b=sJ(G,0,q,l);I=b+F|0;f=Ha+e|0;f=b>>>0>I>>>0?f+1|0:f;d=sJ(A,m,K,l);b=d+I|0;J=f;f=f+Ha|0;z=b;s=b>>>0<d>>>0?f+1|0:f;f=b;b=0;q=b+g|0;e=c+f|0;e=b>>>0>q>>>0?e+1|0:e;v=e;f=e;b=q+M|0;c=b>>>0<q>>>0?f+1|0:f;t=((S+R|0)+t|0)-16383|0;d=sJ(G,m,K,l);h=Ha;e=sJ(E,m,L,l);g=e+d|0;f=Ha+h|0;f=e>>>0>g>>>0?f+1|0:f;n=(h|0)==(f|0)&d>>>0>g>>>0|f>>>0<h>>>0;h=f;e=sJ(A,m,N,m);d=e+g|0;f=Ha+f|0;f=d>>>0<e>>>0?f+1|0:f;e=f;g=(f|0)==(h|0)&d>>>0<g>>>0|f>>>0<h>>>0;f=0;h=g;g=g+n|0;f=h>>>0>g>>>0?1:f;h=g;g=sJ(G,m,E,m);h=h+g|0;f=Ha+f|0;M=h;g=g>>>0>h>>>0?f+1|0:f;h=d;l=e;e=(j|0)==(O|0)&w>>>0>x>>>0|j>>>0<O>>>0;f=0;j=(j|0)==(C|0)&x>>>0>B>>>0|j>>>0>C>>>0;n=j;j=e+j|0;e=(n>>>0>j>>>0?1:f)+l|0;f=g;d=d+j|0;e=d>>>0<j>>>0?e+1|0:e;n=e;w=d;d=(e|0)==(l|0)&d>>>0<h>>>0|e>>>0<l>>>0;e=d;d=d+M|0;f=e>>>0>d>>>0?f+1|0:f;j=d;h=f;e=sJ(A,m,E,m);l=Ha;g=sJ(G,m,N,m);d=g+e|0;f=Ha+l|0;f=d>>>0<g>>>0?f+1|0:f;g=f;f=(l|0)==(f|0)&d>>>0<e>>>0|f>>>0<l>>>0;x=g+j|0;e=f+h|0;e=g>>>0>x>>>0?e+1|0:e;l=x;h=e;j=d;e=0;d=e+w|0;f=j+n|0;f=d>>>0<e>>>0?f+1|0:f;e=f;g=(n|0)==(f|0)&d>>>0<w>>>0|f>>>0<n>>>0;f=h;h=g;g=g+l|0;f=h>>>0>g>>>0?f+1|0:f;w=g;g=f;h=d;j=e;e=(s|0)==(J|0)&z>>>0<I>>>0|s>>>0<J>>>0;d=(i|0)==(P|0)&y>>>0>F>>>0|i>>>0<P>>>0;i=(i|0)==(J|0)&F>>>0>I>>>0|i>>>0>J>>>0;d=d+i|0;d=d+e|0;n=s;i=n+h|0;e=d+j|0;f=g;d=i;e=d>>>0<n>>>0?e+1|0:e;h=(e|0)==(j|0)&h>>>0>d>>>0|e>>>0<j>>>0;g=h+w|0;f=h>>>0>g>>>0?f+1|0:f;j=g;g=f;h=d;f=0;i=e;n=(u|0)==(v|0)&q>>>0<D>>>0|u>>>0>v>>>0;l=n;n=n+((u|0)==(C|0)&B>>>0>D>>>0|u>>>0<C>>>0)|0;e=e+(l>>>0>n>>>0?1:f)|0;f=g;d=d+n|0;e=d>>>0<n>>>0?e+1|0:e;h=(e|0)==(i|0)&d>>>0<h>>>0|e>>>0<i>>>0;g=h;h=h+j|0;f=g>>>0>h>>>0?f+1|0:f;i=f;c:{if(f&65536){t=t+1|0;break c}j=r>>>31|0;g=0;f=i<<1|h>>>31;h=h<<1|e>>>31;i=f;f=e<<1|d>>>31;d=d<<1|c>>>31;e=f;f=r<<1|p>>>31;p=p<<1;r=f;f=c<<1|b>>>31;b=b<<1|j;c=f|g}if((t|0)>=32767){o=o|2147418112;b=0;c=0;break a}d:{if((t|0)<=0){g=1-t|0;if(g>>>0<=127){f=t+127|0;Yd(k+48|0,p,r,b,c,f);Yd(k+32|0,d,e,h,i,f);$h(k+16|0,p,r,b,c,g);$h(k,d,e,h,i,g);p=H[k+32>>2]|H[k+16>>2]|(H[k+48>>2]|H[k+56>>2]|(H[k+52>>2]|H[k+60>>2]))!=0;r=H[k+36>>2]|H[k+20>>2];b=H[k+40>>2]|H[k+24>>2];c=H[k+44>>2]|H[k+28>>2];d=H[k>>2];e=H[k+4>>2];g=H[k+8>>2];f=H[k+12>>2];break d}b=0;c=0;break a}g=h;f=i&65535|t<<16}m=g|m;o=f|o;if(!(!b&(c|0)==-2147483648?!(p|r):(c|0)>0|(c|0)>=0)){b=d+1|0;j=b?e:e+1|0;e=o;c=j;d=!(j|b);m=d+m|0;o=d>>>0>m>>>0?e+1|0:e;break a}if(b|p|(c^-2147483648|r)){b=d;c=e;break a}f=e;b=d&1;c=b;b=b+d|0;f=c>>>0>b>>>0?f+1|0:f;c=f;d=(e|0)==(f|0)&b>>>0<d>>>0|e>>>0>f>>>0;f=o;m=d+m|0;o=m>>>0<d>>>0?f+1|0:f}H[a>>2]=b;H[a+4>>2]=c;H[a+8>>2]=m;H[a+12>>2]=o;Ea=k+96|0}function OF(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=Ea-32|0;Ea=f;H[f+16>>2]=0;H[f+12>>2]=0;a:{b:{c:{d:{e:{f:{g:{h:{if((b|0)<2){break h}g=H[a+24>>2];h=J[H[c>>2]+16>>1];e=h&31;i:{if((h&63)>>>0>=32){e=-1431655766>>>e|0}else{e=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}if(!(e&1)){break i}h=H[((g<<2)+c|0)+8>>2];k=J[h+16>>1];e=k&31;if((k&63)>>>0>=32){e=-1431655766>>>e|0}else{e=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}if(e&1){break i}b=$a(h);c=xb(h);if(!b){g=7;break c}j:{switch(c-7|0){case 1:if(yb(b,12827,8)){break f}g=Ux(a,0);break c;case 0:if(yb(b,14973,7)){break f}g=Tx(a,0);if(g){break c}H[f+24>>2]=0;H[f>>2]=H[a+224>>2];b=Ab(7317,f);if(!b){d=7;H[f+28>>2]=7;break e}d=ph(H[a+12>>2],b,-1,f+24|0,0);H[f+28>>2]=d;Ta(b);if(d){break e}b=H[a+24>>2];b=sJ(b,b>>31,12,0);e=Ha;b=b+12|0;e=b>>>0<12?e+1|0:e;g=ub(b,e);if(!g){d=7;H[f+28>>2]=7;break e}d=0;c=Xa(g,0,b);b=(H[a+24>>2]<<2)+4|0;l=c+b|0;m=l+b|0;break d;default:break j}}if((c|0)==15){break g}if((c|0)>=7){break f}g=1;if((c|0)!=5){break c}if(yb(b,12249,5)){break c}g=Oj(a);break c}if(!(kb(H[((g<<2)+c|0)+16>>2])&-2147483648)){break h}H[f+16>>2]=19;break b}g=H[a+24>>2];e=g>>31<<3|g>>>29;g=(g<<3)+8|0;e=g>>>0<8?e+1|0:e;g=ub(g,e);if(!g){H[f+16>>2]=7;break b}k=H[a+24>>2]+1|0;l=Xa(g,0,k<<3);k:{if(H[a+272>>2]){H[f+16>>2]=0;break k}e=Lb(a,16,f+28|0,0);if(e){H[f+16>>2]=e;break a}e=H[f+28>>2];Ae(e,0);vb(e);e=ob(e);H[f+16>>2]=e;if(e){break a}}m=1;h=1;l:{if(H[a+40>>2]|(b|0)<2){break l}i=H[((H[a+24>>2]<<2)+c|0)+12>>2];j=J[i+16>>1];e=j&31;if((j&63)>>>0>=32){e=-1431655766>>>e|0}else{e=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}if(e&1){i=H[c+4>>2];j=J[i+16>>1];e=j&31;if((j&63)>>>0>=32){e=-1431655766>>>e|0}else{e=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}}if(e&1){break l}j=H[c>>2];n=J[j+16>>1];e=n&31;if((n&63)>>>0>=32){e=-1431655766>>>e|0}else{e=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}if(!(e&1)){e=kb(j);j=Ha;if((kb(i)|0)==(e|0)&(Ha|0)==(j|0)){break l}}h=I[H[a+12>>2]+92|0];m:{if((h|0)==5){e=Sx(a,i,f+12|0,l);break m}e=Rx(a,c,d)}H[f+16>>2]=e;if(e){break a}h=(h|0)==5}i=H[c>>2];j=J[i+16>>1];e=j&31;if((j&63)>>>0>=32){e=-1431655766>>>e|0}else{e=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}if(!(e&1)){e=Sx(a,i,f+12|0,l);H[f+16>>2]=e;m=!e}i=l+(k<<2)|0;if(!(!m|(b|0)<2)){b=kb(H[((H[a+24>>2]<<2)+c|0)+16>>2]);n:{o:{if(!h){break o}e=Rx(a,c,d);H[f+16>>2]=e;if(!e){break o}if(H[a+40>>2]|(e|0)!=19){break n}H[f+16>>2]=267;break n}e=b;b=cq(a,0,e,H[d>>2],H[d+4>>2]);H[f+16>>2]=b;if(b){break n}b=2;while(1){p:{if((H[a+24>>2]+2|0)<=(b|0)){d=0;break p}d=b-2|0;if(!I[d+H[a+32>>2]|0]){h=(b<<2)+c|0;d=bq(a,e,$a(H[h>>2]),d,i+(d<<2)|0);if(d){break p}d=xb(H[h>>2]);h=i+(H[a+24>>2]<<2)|0;H[h>>2]=d+H[h>>2]}b=b+1|0;continue}break}H[f+16>>2]=d}if(I[a+238|0]){Qx(f+16|0,a,i)}H[f+12>>2]=H[f+12>>2]+1}if(!I[a+236|0]){break a}Px(f+16|0,a,i,l,H[f+12>>2]);break a}if(yb(b,12020,15)){break f}H[f+28>>2]=0;b=Ox(a,f+28|0);g=b|H[f+28>>2]?b:267;break c}if(!yb(b,21769,6)){H[f+24>>2]=b+6;e=f+24|0;h=aq(e);b=8;d=H[f+24>>2];c=I[d|0];if((c|0)==44){g=1;if(!I[d+1|0]){break c}H[f+24>>2]=d+1;b=aq(e);c=I[H[f+24>>2]]}g=1;if(c&255|(b|0)<2){break c}H[f+28>>2]=0;q:{if(!I[a+237|0]){$p(f+28|0,a);g=H[f+28>>2];if(g){break q}}g=Nx(a,h,b)}Ge(a);break c}g=1;if(c>>>0<11){break c}if(yb(b,21765,10)){break c}H[f+28>>2]=b+10;H[f+24>>2]=0;H[f+20>>2]=0;b=aq(f+28|0);H[a+48>>2]=(b|0)==1?8:(b|0)>16?8:b;if(!I[a+237|0]){$p(f+24|0,a);g=H[f+24>>2];if(g){break c}}g=Lb(a,23,f+20|0,0);if(g){break c}b=H[f+20>>2];Cb(b,1,2,0);Zc(b,2,H[a+48>>2]);vb(b);g=ob(b);break c}g=0}h=H[f+24>>2];while(1){r:{if(d){break r}if((vb(h)|0)!=100){break r}c=0;k=_p(a,h);d=cq(a,0,k,Xc(h,0),Ha);e=Xa(g,0,(H[a+24>>2]<<2)+4|0);while(1){s:{if(d){break s}b=c;if((b|0)>=H[a+24>>2]){break s}c=b+1|0;d=0;if(I[b+H[a+32>>2]|0]){continue}d=bq(a,k,$e(h,c),b,e+(b<<2)|0);b=Nd(h,c);j=e+(H[a+24>>2]<<2)|0;H[j>>2]=b+H[j>>2];continue}break}H[f+28>>2]=d;b=0;if(I[a+238|0]){Qx(f+28|0,a,e);d=H[f+28>>2]}if(d){Wc(h);h=0;d=1}else{while(1){if((b|0)<=H[a+24>>2]){c=b<<2;k=c+l|0;H[k>>2]=H[k>>2]+H[c+e>>2];b=b+1|0;continue}break}i=i+1|0}continue}break}if(I[a+236|0]){Px(f+28|0,a,l,m,i)}Ta(g);if(!h){g=H[f+28>>2];break c}b=Wc(h);c=H[f+28>>2];g=c?c:b}H[f+16>>2]=g}g=0}Ta(g);Ge(a);Ea=f+32|0;return H[f+16>>2]}function gA(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0;g=Ea-16|0;Ea=g;m=I[a+44|0];q=m>>>0<2?1:(m|0)==2?5:10;w=H[a>>2];a:{if(!b){break a}c=H[a+8>>2];if(!c){break a}p=H[c>>2]}f=m<<2;c=N(f+32|0,q)+p<<1;t=Nb(H[w>>2],c,c>>31);if(t){h=p<<1;d=q<<5;e=d+t|0;c=e;H[c>>2]=0;H[c+4>>2]=0;H[c+24>>2]=0;H[c+28>>2]=0;H[c+16>>2]=0;H[c+20>>2]=0;H[c+8>>2]=0;H[c+12>>2]=0;r=c+d|0;c=q<<1;d=t;while(1){if((c|0)>0){H[d+24>>2]=r;d=d+32|0;c=c-1|0;r=f+r|0;continue}break}b:{if(!p){r=0;break b}Xa(r,0,h)}c=G[w+156>>1];G[e+16>>1]=(c|0)>=48?48:c;if(p){F[e+22|0]=m?-1:p}D=b-10|0;E=a+60|0;K=(b|0)>10;c=1;f=t;while(1){h=e;if((m|0)!=(x|0)){e=0;L=(c|0)>0?c:0;B=x<<2;M=x&65535;l=h;z=0;while(1){if((z|0)!=(L|0)){c=E;while(1){k=H[c>>2];if(k){d=H[l+4>>2];u=d;c:{c=H[l>>2];if(H[k>>2]&(c^-1)|H[k+4>>2]&(d^-1)){break c}s=H[k+8>>2];y=H[k+12>>2];if(c&s|d&y){break c}d=G[l+16>>1];if((d|0)<3?I[k+41|0]&64:0){break c}n=ce(ce(G[k+18>>1],d+J[k+20>>1]<<16>>16),G[l+20>>1]);i=J[k+22>>1];o=F[l+22|0];d:{if((o|0)<0){H[g+8>>2]=0;H[g+12>>2]=0;o=Cm(a,H[a+8>>2],l,J[a+40>>1],M,k,g+8|0);break d}j=H[l+12>>2];H[g+8>>2]=H[l+8>>2];H[g+12>>2]=j}O=d+i|0;e:{if(!((o|0)<0|(o|0)>=(p|0))){i=(o<<1)+r|0;d=J[i>>1];if(!d){d=(H[H[H[a+16>>2]+28>>2]>>2]+59|0)/30|0;d=Kd(d,d>>31)+b|0;if(o){j=(N(p-o|0,100)|0)/(p|0)|0;d=(Kd(j,j>>31)+d|0)-66|0}j=J[a+40>>1];f:{if(j&16384){d=(o?16:10)+d|0;j=G[a+42>>1];j=(b|0)>(j|0)?j:b;break f}j=K?(j&256)>>>8|0?D:b:b}d=Bm(j<<16>>16)+d|0;G[i>>1]=d}i=ce(n,d<<16>>16)+3|0;break e}i=n;n=i-2|0}j=c|s;u=u|y;s=O<<16>>16;d=0;y=(e|0)>0?e:0;c=f;g:{h:{while(1){if((d|0)!=(y|0)){if(H[c>>2]==(j|0)&H[c+4>>2]==(u|0)&(I[c+22|0]^o)<<24>>24>=0){break h}c=c+32|0;d=d+1|0;continue}break}c=e;d=(q|0)>(c|0);i:{if(d){break i}if(i<<16>>16>v<<16>>16){break c}c=C;if((i&65535)!=(v&65535)){break i}if(n<<16>>16>=A<<16>>16){break c}}c=(c<<5)+f|0;e=d+e|0;break g}d=G[c+18>>1];if((d|0)<i<<16>>16){break c}if((d&65535)!=(i&65535)){break g}d=G[c+16>>1];if((d|0)<(s|0)){break c}if((d|0)!=(s|0)){break g}if(G[c+20>>1]<=n<<16>>16){break c}}d=H[k+12>>2]|H[l+4>>2];H[c>>2]=H[k+8>>2]|H[l>>2];H[c+4>>2]=d;d=H[g+8>>2];u=H[g+12>>2];F[c+22|0]=o;G[c+20>>1]=n;G[c+18>>1]=i;G[c+16>>1]=s;H[c+8>>2]=d;H[c+12>>2]=u;Va(H[c+24>>2],H[l+24>>2],B);H[H[c+24>>2]+B>>2]=k;if((e|0)<(q|0)){break c}A=J[f+16>>1];v=J[f+18>>1];d=1;C=0;c=f;while(1){if((d|0)==(q|0)){break c}n=G[c+50>>1];j:{if((n|0)>v<<16>>16){i=J[c+52>>1]}else{if((n&65535)!=(v&65535)){break j}i=G[c+52>>1];if((i|0)<=A<<16>>16){break j}}A=i;v=n;C=d}c=c+32|0;d=d+1|0;continue}}c=k+56|0;continue}break}l=l+32|0;z=z+1|0;continue}break}x=x+1|0;c=e;e=f;f=h;continue}break}k:{if(c){f=(c|0)<=1?1:c;d=h;c=1;while(1)if((c|0)==(f|0)){e=a+760|0;c=0;while(1){if((c|0)!=(m|0)){f=e+N(c,96)|0;h=H[H[d+24>>2]+(c<<2)>>2];H[f+80>>2]=h;h=I[h+16|0];F[f+60|0]=h;H[f+4>>2]=H[(H[a+4>>2]+(h<<6)|0)+48>>2];c=c+1|0;continue}break}l:{if(I[a+47|0]|(!b|(J[a+40>>1]&384)!=256)){break l}b=m-1|0;if((Cm(a,H[a+12>>2],d,128,b&65535,H[H[d+24>>2]+(b<<2)>>2],g+8|0)|0)!=H[H[a+12>>2]>>2]){break l}F[a+47|0]=2}e=I[a+48|0];F[a+48|0]=e&251;c=H[a+8>>2];m:{if(!c){break m}b=F[d+22|0];F[a+45|0]=b;f=J[a+40>>1];n:{if(f&128){if((b|0)==H[c>>2]){F[a+47|0]=2}e=H[H[a+16>>2]+48>>2];if(!e){break n}h=b;b=H[e>>2];if((h|0)<=(b|0)){break n}F[a+45|0]=b;break n}h=H[d+12>>2];H[a+72>>2]=H[d+8>>2];H[a+76>>2]=h;if((b|0)<=0){F[a+45|0]=0;if(!m){break n}b=m-1|0;e=H[H[d+24>>2]+(b<<2)>>2];h=H[e+40>>2];if(h&4096|(h&260)==260){break n}H[g+8>>2]=0;H[g+12>>2]=0;b=Cm(a,c,d,2048,b&65535,e,g+8|0);c=H[a+8>>2];if((b|0)==H[c>>2]){F[a+48|0]=I[a+48|0]|4;b=H[g+12>>2];H[a+72>>2]=H[g+8>>2];H[a+76>>2]=b}f=J[a+40>>1];break n}if(!(f&3)|(!m|(b|0)!=1)){break n}F[a+48|0]=e|4}if(!(f&512)|!m|H[c>>2]!=F[a+45|0]){break m}H[g+8>>2]=0;H[g+12>>2]=0;b=m-1|0;if((Cm(a,c,d,0,b&65535,H[H[d+24>>2]+(b<<2)>>2],g+8|0)|0)!=H[H[a+8>>2]>>2]){break m}F[a+48|0]=I[a+48|0]|8;b=H[g+12>>2];H[a+72>>2]=H[g+8>>2];H[a+76>>2]=b}G[a+50>>1]=J[d+16>>1];break k}else{e=h+(c<<5)|0;d=G[d+18>>1]>G[e+18>>1]?e:d;c=c+1|0;continue}}Wa(w,10194,0)}db(H[w>>2],t)}Ea=g+16|0}function Gv(a,b,c,d,e,f,g,h,i,j){var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,L=0,M=0,O=0,P=0,Q=0,R=0;m=Ea-144|0;Ea=m;H[m+12>>2]=0;l=8;if(!I[a+46|0]){t=c;k=Vf(a,1,1);a:{if(k){break a}F[a+45|0]=1;b:{c:{if(!c){t=0;break c}t=0;k=cl(a,d,e,0,1);if((k|0)==5){d=0;break c}if(k){t=c;break b}F[a+44|0]=1;t=c}k=Su(a,m+12|0)}if(k){break a}s=H[a+68>>2];p=J[a+66>>1];p=(p<<16|p)&130560;d:{if(!(!s|(g|0)==(p|0))){k=Ya(68858);break d}u=H[H[a+32>>2]>>2];e:{if(K[u+96>>2]>=s>>>0){k=0}else{q=u+100|0;E=H[a+72>>2];k=0;l=1;while(1){if((l|0)!=5){n=q+(l<<2)|0;g=H[n>>2];f:{if(g>>>0>=s>>>0){break f}o=l+3|0;k=cl(a,d,e,o,1);if((k|0)==5){s=g;d=0;break f}if(k){break e}H[n>>2]=(l|0)!=1?-1:s;xe(a,o,1);k=0}l=l+1|0;continue}break}g:{if(K[u+96>>2]>=s>>>0){break g}o=H[u+96>>2];z=H[a+68>>2];r=z+33>>>12|0;k=0;g=(z>>>0>=4096?4096:z)<<1;n=g;l=(N(r,20)+(z<<1)|0)+28|0;g=g+l|0;k=n>>>0>g>>>0?1:k;A=ub(g,k);if(!A){k=7;A=0;break e}k=0;v=Xa(A,0,l);H[v+4>>2]=r+1;D=v+8|0;y=l+v|0;g=o+34>>>12|0;while(1){if(!(g>>>0>r>>>0|k)){k=jl(a,g,m+16|0);if(!k){h:{if((g|0)==(r|0)){l=H[m+24>>2];o=z-l|0;break h}l=H[m+24>>2];o=H[m+16>>2]-H[m+20>>2]>>2}n=H[v+4>>2];q=l+1|0;H[m+24>>2]=q;w=(N(n,20)+D|0)+(l<<1)|0;l=0;C=(o|0)>0?o:0;while(1){if((l|0)!=(C|0)){G[w+(l<<1)>>1]=l;l=l+1|0;continue}break}x=H[m+20>>2];l=0;H[m+140>>2]=0;H[m+136>>2]=0;Xa(m+32|0,0,104);B=0;while(1){if((B|0)!=(C|0)){H[m+140>>2]=1;H[m+136>>2]=w+(B<<1);l=0;while(1){if(B>>>l&1){n=(m+32|0)+(l<<3)|0;Eu(x,H[n+4>>2],H[n>>2],m+136|0,m+140|0,y);l=l+1|0;continue}break}n=(m+32|0)+(l<<3)|0;H[n+4>>2]=H[m+136>>2];H[n>>2]=H[m+140>>2];B=B+1|0;continue}break}while(1){l=l+1|0;if(l>>>0<=12){if(!(o>>>l&1)){continue}n=(m+32|0)+(l<<3)|0;Eu(x,H[n+4>>2],H[n>>2],m+136|0,m+140|0,y);continue}break}o=N(g,20)+D|0;H[o+12>>2]=H[m+140>>2];H[o+16>>2]=q;H[o+8>>2]=x;H[o+4>>2]=w}g=g+1|0;continue}break}if(k){Ta(v);A=0;break g}k=cl(a,d,e,3,1);if(k){break g}C=H[u+96>>2];H[u+128>>2]=s;i:{j:{x=f>>>2&3;if(!x){break j}f=H[a+8>>2];l=Ia[H[H[f>>2]+20>>2]](f,x)|0;if(!l){break j}break i}L=m,M=sJ(p,0,E,0),H[L+32>>2]=M;H[m+36>>2]=Ha;f=H[a+4>>2];Ia[H[H[f>>2]+40>>2]](f,39,0)|0;f=H[a+4>>2];l=Ia[H[H[f>>2]+24>>2]](f,m+16|0)|0;if(l){break i}l=H[m+20>>2];k=H[m+36>>2];g=H[m+16>>2];f=H[m+32>>2];k:{if((l|0)>=(k|0)&g>>>0>=f>>>0|(k|0)<(l|0)){break k}o=sJ(H[a+68>>2],0,p,0);n=o+g|0;g=Ha+l|0;g=o>>>0>n>>>0?g+1|0:g;o=n+65536|0;g=o>>>0<65536?g+1|0:g;if((g|0)<=(k|0)&f>>>0>o>>>0|(g|0)<(k|0)){l=Ya(66787);break i}g=H[a+4>>2];f=H[g>>2];if(!f){break k}Ia[H[f+40>>2]](g,5,m+32|0)|0}l=0}o=p|24;w=0;while(1){l:{k=l;if(l){break l}y=H[v+4>>2];q=H[v>>2];f=-1;m:while(1){if((y|0)>0){y=y-1|0;r=N(y,20)+D|0;l=H[r>>2];g=H[r+12>>2];n=(g|0)<(l|0)?l:g;while(1){if((l|0)==(n|0)){continue m}k=J[H[r+4>>2]+(l<<1)>>1];g=H[H[r+8>>2]+(k<<2)>>2];if(g>>>0>q>>>0){if(f>>>0<=g>>>0){continue m}w=k+H[r+16>>2]|0;f=g;continue m}else{l=l+1|0;H[r>>2]=l;continue}}}break}H[v>>2]=f;if((f|0)==-1){k=0;break l}if(H[b+296>>2]){k=I[b+87|0]?7:9;break l}l=0;if(s>>>0<w>>>0|w>>>0<=C>>>0|f>>>0>E>>>0){continue}n=H[a+8>>2];g=p;k=sJ(w-1|0,0,o,0);q=Ha;k=k+56|0;q=k>>>0<56?q+1|0:q;k=Ia[H[H[n>>2]+8>>2]](n,h,g,k,q)|0;if(k){break l}g=H[a+4>>2];k=(M=g,O=h,P=p,Q=sJ(p,0,f-1|0,0),R=Ha,L=H[H[g>>2]+12>>2],Ia[L](M|0,O|0,P|0,Q|0,R|0)|0);if(!k){continue}}break}f=H[a+4>>2];b=H[f>>2];if(b){Ia[H[b+40>>2]](f,37,0)|0}n:{if(k){break n}o:{if(H[H[H[a+32>>2]>>2]+16>>2]!=(s|0)){break o}f=H[a+4>>2];k=(R=f,Q=sJ(p,0,H[a+72>>2],0),P=Ha,L=H[H[f>>2]+16>>2],Ia[L](R|0,Q|0,P|0)|0);if(k){break n}if(!x){break o}b=H[a+4>>2];k=Ia[H[H[b>>2]+20>>2]](b,x)|0;if(k){break n}}H[u+96>>2]=s;k=0}xe(a,3,1)}k=(k|0)!=5?k:0}if(k|!t){break e}if(K[u+96>>2]<K[a+68>>2]){k=5;break e}if((t|0)<2){k=0;break e}we(4,m+32|0);k=cl(a,d,e,4,4);if(k){break e}k=0;if((t|0)==3){bv(a,H[m+32>>2]);b=H[a+8>>2];k=Ia[H[H[b>>2]+16>>2]](b,0,0)|0}xe(a,4,4)}Ta(A)}if(k?(k|0)!=5:0){break a}if(i){H[i>>2]=H[a+68>>2]}if(!j){break a}H[j>>2]=H[H[H[a+32>>2]>>2]+96>>2]}if(H[m+12>>2]){Xa(a+52|0,0,48)}Oo(a);if(I[a+45|0]){xe(a,1,1);F[a+45|0]=0}l=(c|0)==(t|0)?k:k?k:5}Ea=m+144|0;return l}function rd(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;l=Ea-128|0;Ea=l;a:{if(H[c>>2]|I[b+32|0]){break a}j=b+32|0;g=I[a+52|0];F[b+33|0]=1;b:{c:{d:{switch(H[b>>2]-1|0){case 0:case 2:j=H[b+16>>2];d=H[b+12>>2];if(I[d+34|0]){rd(a,j,c);a=H[j+28>>2];H[b+24>>2]=H[j+24>>2];H[b+28>>2]=a;F[b+32|0]=I[j+32|0];break a}f=I[j+34|0];rd(a,d,c);if(f){a=H[d+28>>2];H[b+24>>2]=H[d+24>>2];H[b+28>>2]=a;F[b+32|0]=I[d+32|0];break a}rd(a,j,c);while(1){if(I[d+32|0]){f=H[d+28>>2];H[b+24>>2]=H[d+24>>2];H[b+28>>2]=f;f=1;break b}i=I[j+32|0];if(i){f=H[d+24>>2];h=H[d+28>>2];break c}f=H[d+24>>2];h=H[d+28>>2];if(H[c>>2]){break c}e=H[j+24>>2];k=H[j+28>>2];e=e>>>0<f>>>0&(h|0)>=(k|0)|(h|0)>(k|0)?1:(e|0)!=(f|0)|(k|0)!=(h|0)?-1:0;e=g?0-e|0:e;if(!e){break c}rd(a,(e|0)<0?d:j,c);continue};case 3:g=g?-1:1;h=H[b+12>>2];d=H[b+16>>2];f=h;e:{if(I[d+32|0]){break e}f=H[h+24>>2];e=H[d+24>>2];k=H[h+28>>2];i=H[d+28>>2];e=N(g,e>>>0<f>>>0&(i|0)<=(k|0)|(i|0)<(k|0)?1:(f|0)!=(e|0)|(k|0)!=(i|0)?-1:0);k=I[h+32|0];if(!k){f=h;if((e|0)<0){break e}}f=d;if(k){break e}f=d;if((e|0)>0){break e}rd(a,h,c);f=d}rd(a,f,c);F[j|0]=I[h+32|0]?I[d+32|0]!=0:0;a=H[h+24>>2];f=H[h+28>>2];f:{if(!I[d+32|0]){c=H[d+24>>2];d=H[d+28>>2];if(I[h+32|0]|(N(g,(d|0)<=(f|0)&a>>>0>c>>>0|(d|0)<(f|0)?1:(a|0)!=(c|0)|(f|0)!=(d|0)?-1:0)|0)>=0){break f}}H[b+24>>2]=a;H[b+28>>2]=f;break a}H[b+24>>2]=c;H[b+28>>2]=d;break a;case 1:h=H[b+12>>2];j=H[b+16>>2];if(!I[j+33|0]){rd(a,j,c)}rd(a,h,c);d=I[h+32|0];if(!d){while(1){g:{if(H[c>>2]|I[j+32|0]){break g}f=H[h+24>>2];d=H[j+24>>2];e=H[h+28>>2];k=H[j+28>>2];if(((g?f>>>0<d>>>0&(e|0)<=(k|0)|(e|0)<(k|0):d>>>0<f>>>0&(e|0)>=(k|0)|(e|0)>(k|0))|0)!=1){break g}rd(a,j,c);continue}break}d=I[h+32|0]}a=H[h+24>>2];c=H[h+28>>2];F[b+32|0]=d;H[b+24>>2]=a;H[b+28>>2]=c;break a;default:break d}}e=H[b+20>>2];di(e);m=H[a>>2];h:{if(H[e+40>>2]){F[l+127|0]=0;i:{j:{if(H[e+64>>2]==1){k=xx(m,H[e+92>>2],e+16|0,e+28|0,e+32|0);d=!H[e+28>>2];break j}p=I[a+52|0];Xa(l+16|0,0,96);q=p?-1:1;while(1){a=0;f=0;h=0;i=0;if(d){break j}while(1){if(!(I[l+127|0]|(H[e+64>>2]<=(a|0)|k))){g=(l+16|0)+N(a,24)|0;k=wx(m,e,a,g,l+127|0);k:{if(H[g>>2]){break k}d=H[g+8>>2];g=H[g+12>>2];if(!i){i=1;f=d;h=g;break k}i=1;n=d;o=f;f=d>>>0<f>>>0&(h|0)>=(g|0)|(h|0)>(g|0)?1:(d|0)!=(f|0)|(h|0)!=(g|0)?-1:0;d=((p?0-f|0:f)|0)<0;f=d?n:o;h=d?g:h}a=a+1|0;continue}break}a=0;while(1){g=H[e+64>>2];if((a|0)<(g|0)){while(1){l:{if(I[l+127|0]|k){break l}d=(l+16|0)+N(a,24)|0;if(H[d>>2]){break l}g=H[d+8>>2];i=H[d+12>>2];if((N(q,(h|0)<=(i|0)&g>>>0>f>>>0|(h|0)<(i|0)?1:(f|0)!=(g|0)|(h|0)!=(i|0)?-1:0)|0)>=0){break l}k=wx(m,e,a,d,l+127|0);g=H[d+8>>2];i=H[d+12>>2];d=i;d=(N(q,g>>>0>f>>>0&(d|0)>=(h|0)|(d|0)>(h|0)?1:(g|0)!=(f|0)|(d|0)!=(h|0)?-1:0)|0)>0;f=d?g:f;h=d?i:h;a=d?0:a;continue}break}a=a+1|0;continue}break}d=I[l+127|0];if(d){continue}a=H[(N(g,24)+l|0)+12>>2];g=a>>31;i=a+8|0;g=i>>>0<8?g+1|0:g;g=ub(i,g);if(!g){break i}g=Va(g,H[(N(H[e+64>>2],24)+l|0)+8>>2],a+1|0);a=g+a|0;F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;a=0;n=0;m:{while(1){o=H[e+64>>2];i=o-1|0;if((i|0)<=(a|0)){break m}n:{i=(l+16|0)+N(a,24)|0;if(!H[i>>2]){H[l+12>>2]=H[i+16>>2];H[l+8>>2]=g;H[l+4>>2]=g;if(!ci(l+4|0,o+(a^-1)|0,0,1,l+12|0,l+8|0)){break n}n=H[l+4>>2]-g|0}a=a+1|0;continue}break}i=H[e+64>>2]-1|0}if((a|0)!=(i|0)){Ta(g);continue}break}H[e+32>>2]=n;H[e+28>>2]=g;H[e+16>>2]=f;H[e+20>>2]=h;H[e+24>>2]=1;d=0}F[j|0]=d;break h}k=7;break h}o:{p:{d=I[a+52|0];a=I[m+239|0];if((d|0)==(a|0)){break p}f=H[e+4>>2];if(!f){break p}$l(a,H[e>>2],f,e+8|0,e+16|0,e+32|0,j);H[e+28>>2]=H[e+8>>2];break o}vx(m,e,j)}}H[c>>2]=k;a=H[e+20>>2];H[b+24>>2]=H[e+16>>2];H[b+28>>2]=a;break a}H[b+24>>2]=f;H[b+28>>2]=h;f=(i|0)!=0}F[b+32|0]=f;if(!f|H[b>>2]!=1){break a}q:{b=H[j+20>>2];if(!H[b>>2]){break q}while(1){if(H[c>>2]|I[j+32|0]){break q}Xa(H[b+28>>2],0,H[b+32>>2]);rd(a,j,c);continue}}r:{b=H[d+20>>2];if(!b|!H[b>>2]){break r}while(1){if(H[c>>2]|I[d+32|0]){break r}Xa(H[b+28>>2],0,H[b+32>>2]);rd(a,d,c);continue}}F[d+32|0]=1;F[j+32|0]=1}Ea=l+128|0}function jf(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;l=Ea-16|0;Ea=l;H[l+12>>2]=0;o=H[a+12>>2];r=cb(H[o+56>>2]+36|0);q=H[a+48>>2];a:{if(r>>>0>=q>>>0){g=Ya(76524);break a}b:{c:{if(r){d:{e:{switch(e-1|0){case 0:if(d>>>0>q>>>0){break d}g=_i(a,d,l+11|0,0);if(g){break a}h=I[l+11|0]==2;break d;case 1:break e;default:break d}}h=1}g=Vb(H[o+72>>2]);if(g){break a}k=H[o+56>>2];f=r-1|0;f=f<<24|(f&65280)<<8|(f>>>8&65280|f>>>24);F[k+36|0]=f;F[k+37|0]=f>>>8;F[k+38|0]=f>>>16;F[k+39|0]=f>>>24;while(1){k=j;f:{if(j){f=cb(H[j+56>>2]);break f}f=cb(H[o+56>>2]+32|0)}if(!(f>>>0<=q>>>0&r>>>0>=u>>>0)){j=0;g=Ya(76580);break b}j=0;g=Zi(a,f,l+12|0,0);if(g){break b}g:{h:{i:{j:{k:{j=H[l+12>>2];p=H[j+56>>2];n=cb(p+4|0);l:{if(!(n|h)){g=Vb(H[j+72>>2]);if(g){break b}H[c>>2]=f;h=H[o+56>>2];f=H[j+56>>2];f=I[f|0]|I[f+1|0]<<8|(I[f+2|0]<<16|I[f+3|0]<<24);F[h+32|0]=f;F[h+33|0]=f>>>8;F[h+34|0]=f>>>16;F[h+35|0]=f>>>24;H[b>>2]=j;break l}if((H[a+40>>2]>>>2|0)-2>>>0<n>>>0){g=Ya(76609);break b}if(!h|!((e|0)==2&d>>>0>f>>>0)&(d|0)!=(f|0)){break k}H[c>>2]=f;H[b>>2]=j;g=Vb(H[j+72>>2]);if(g){break b}if(!n){if(!k){h=H[o+56>>2];f=H[j+56>>2];f=I[f|0]|I[f+1|0]<<8|(I[f+2|0]<<16|I[f+3|0]<<24);F[h+32|0]=f;F[h+33|0]=f>>>8;F[h+34|0]=f>>>16;F[h+35|0]=f>>>24;break l}g=Vb(H[k+72>>2]);if(g){break b}h=H[k+56>>2];f=H[j+56>>2];f=I[f|0]|I[f+1|0]<<8|(I[f+2|0]<<16|I[f+3|0]<<24);F[h|0]=f;F[h+1|0]=f>>>8;F[h+2|0]=f>>>16;F[h+3|0]=f>>>24;break l}m=cb(H[j+56>>2]+8|0);if(m>>>0>q>>>0){g=Ya(76643);break b}g=Zi(a,m,l+4|0,0);if(g){break b}i=H[l+4>>2];g=Vb(H[i+72>>2]);if(g){Eb(i);break b}h=H[i+56>>2];f=H[j+56>>2];f=I[f|0]|I[f+1|0]<<8|(I[f+2|0]<<16|I[f+3|0]<<24);F[h|0]=f;F[h+1|0]=f>>>8;F[h+2|0]=f>>>16;F[h+3|0]=f>>>24;h=H[i+56>>2];g=n-1|0;f=g<<24|(g&65280)<<8|(g>>>8&65280|g>>>24);F[h+4|0]=f;F[h+5|0]=f>>>8;F[h+6|0]=f>>>16;F[h+7|0]=f>>>24;Va(H[i+56>>2]+8|0,H[j+56>>2]+12|0,g<<2);Eb(i);if(!k){h=H[o+56>>2];f=m<<24|(m&65280)<<8|(m>>>8&65280|m>>>24);F[h+32|0]=f;F[h+33|0]=f>>>8;F[h+34|0]=f>>>16;F[h+35|0]=f>>>24;break l}g=Vb(H[k+72>>2]);if(g){break b}h=H[k+56>>2];f=m<<24|(m&65280)<<8|(m>>>8&65280|m>>>24);F[h|0]=f;F[h+1|0]=f>>>8;F[h+2|0]=f>>>16;F[h+3|0]=f>>>24}j=0;H[l+12>>2]=0;break j}if(!n){break h}m:{if(!d){f=0;break m}s=p+8|0;f=0;g=0;if((e|0)==2){while(1){if((g|0)==(n|0)){break m}if(cb((g<<2)+s|0)>>>0<=d>>>0){f=g;break m}else{g=g+1|0;continue}}}g=cb(s)-d|0;t=(g|0)<0?(g|0)==-2147483648?2147483647:0-g|0:g;g=1;while(1){if((g|0)==(n|0)){break m}i=cb((g<<2)+s|0)-d|0;i=(i|0)<0?(i|0)==-2147483648?2147483647:0-i|0:i;m=(i|0)<(t|0);t=m?i:t;f=m?g:f;g=g+1|0;continue}}i=(f<<2)+p|0;g=cb(i+8|0);if(!(g>>>0<=q>>>0&g>>>0>1)){g=Ya(76708);break b}if(!(!h|(!((e|0)!=2|d>>>0<=g>>>0)|(d|0)==(g|0)))){g=0;h=1;break g}H[c>>2]=g;g=Vb(H[j+72>>2]);if(g){break b}h=n-1|0;if(h>>>0>f>>>0){f=(n<<2)+p|0;f=I[f+4|0]|I[f+5|0]<<8|(I[f+6|0]<<16|I[f+7|0]<<24);F[i+8|0]=f;F[i+9|0]=f>>>8;F[i+10|0]=f>>>16;F[i+11|0]=f>>>24}f=h<<24|(h&65280)<<8|(h>>>8&65280|h>>>24);F[p+4|0]=f;F[p+5|0]=f>>>8;F[p+6|0]=f>>>16;F[p+7|0]=f>>>24;h=0;f=H[c>>2];g=H[a+64>>2];i=0;n:{if(!g){break n}i=1;if(f>>>0>K[g>>2]){break n}i=(kl(g,f)|0)!=0}g=Zi(a,f,b,!i);if(g){break g}g=Vb(H[H[b>>2]+72>>2]);if(g){break i}}h=0;break h}Eb(H[b>>2]);H[b>>2]=0;break g}g=0}u=u+1|0;Eb(k);f=h;h=1;if(f){continue}break}break c}d=I[a+19|0];g=Vb(H[o+72>>2]);if(g){break a}e=H[a+48>>2];g=e+1|0;H[a+48>>2]=g;if((e|0)==(K[16644]/K[a+36>>2]|0)){g=e+2|0;H[a+48>>2]=g}e=!d;o:{if(!I[a+17|0]){break o}if((Qd(a,g)|0)!=(g|0)){break o}H[l>>2]=0;g=Zi(a,g,l,e);if(g){break a}d=H[l>>2];g=Vb(H[d+72>>2]);Eb(d);if(g){break a}d=H[a+48>>2];g=d+1|0;H[a+48>>2]=g;if((d|0)!=(K[16644]/K[a+36>>2]|0)){break o}g=d+2|0;H[a+48>>2]=g}f=H[H[a+12>>2]+56>>2];d=g<<24|(g&65280)<<8|(g>>>8&65280|g>>>24);F[f+28|0]=d;F[f+29|0]=d>>>8;F[f+30|0]=d>>>16;F[f+31|0]=d>>>24;d=c;c=H[a+48>>2];H[d>>2]=c;g=Zi(a,c,b,e);if(g){break a}g=Vb(H[H[b>>2]+72>>2]);if(!g){g=0;break b}Eb(H[b>>2]);H[b>>2]=0}k=0}Eb(j);Eb(k)}Ea=l+16|0;return g}function Cm(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0,M=0,O=0,P=0,Q=0,R=0,S=0,T=0,U=0,V=0,W=0,X=0,Y=0,Z=0,_=0;a:{b:{if(I[H[H[a>>2]>>2]+80|0]&64?e:0){break b}q=J[b>>1];if(q>>>0>63){break b}K=d&2051?387:386;T=a+496|0;U=d&64;V=d&192;W=a+80|0;B=b+8|0;L=d&128;X=d&2048;b=q&31;if((q&63)>>>0>=32){h=-1<<b;b=0}else{h=(1<<b)-1&-1>>>32-b;b=-1<<b;h=h|b}C=b^-1;z=h^-1;M=e;l=1;while(1){c:{d:{e:{f:{g:{h:{if(!(!(l&255)|((o|0)==(z|0)&r>>>0>=C>>>0|o>>>0>z>>>0)|(!w&t>>>0>M>>>0|(w|0)!=0))){if(t|w){O=O|H[m+12>>2];P=P|H[m+8>>2]}m=f;if(!w&t>>>0<M>>>0){m=H[H[c+24>>2]+(t<<2)>>2];if(X){break c}}if(!(I[m+41|0]&4)){break h}a=I[m+29|0];b=(d&640)==128;r=b?r:a?C:r;o=b?o:a?z:o}if((r|0)!=(C|0)|(o|0)!=(z|0)){break g}b=q;break a}if(L){G[m+30>>1]=0}n=P^-1;u=O^-1;v=H[(H[a+4>>2]+(I[m+16|0]<<6)|0)+48>>2];i=0;h=0;while(1){if(!(!h&(i|0)==(q|0))){e=i&31;if((i&63)>>>0>=32){b=1<<e;j=0}else{j=1<<e;b=j-1&1>>>32-e}p=j;i:{if(r&p|b&o){break i}k=(i<<4)+B|0;j=bd(H[k>>2]);if(!j){break i}j:{switch(I[j|0]-167|0){case 0:case 2:break j;default:break i}}if(H[j+28>>2]!=(v|0)){break i}s=er(W,v,G[j+32>>1],n,u,K,0);if(!s){break i}x=J[s+12>>1];if((x|0)==1){y=J[m+44>>1];e=0;while(1){if((e|0)==(y|0)){break i}A=e<<2;e=e+1|0;if((s|0)!=H[A+H[m+52>>2]>>2]){continue}break}}if(!(!(x&130)|G[j+32>>1]<0)){e=H[a>>2];j=Bf(e,H[k>>2]);e=Uh(e,H[s>>2]);if(!e){break i}if(ab(H[j>>2],H[e>>2])){break i}}r=r|p;o=b|o}b=h;i=i+1|0;h=i?b:b+1|0;continue}break}e=H[m+40>>2];if(e&4096){break d}j=0;k:{if(e&256){n=0;A=0;e=1;break k}n=H[m+32>>2];b=0;if(!n|I[n+55|0]&4){break a}l=!(e&32768)&I[n+54|0]!=0;A=J[n+50>>1];e=J[n+52>>1]}h=t&31;if((t&63)>>>0>=32){b=1<<h;k=0}else{k=1<<h;b=k-1&1>>>32-h}Y=k;s=b;Z=e&65535;x=0;Q=0;y=0;while(1){if((j|0)==(Z|0)){break e}e=1;l:{h=J[m+24>>1];m:{if(h>>>0<=j>>>0|J[m+46>>1]>j>>>0){break m}i=H[m+52>>2];e=H[i+(j<<2)>>2];b=J[e+12>>1];if(b&K){l=b&384?0:l;break l}n:{if(!(b&1)){break n}u=h-1|0;p=H[e>>2];b=j;while(1){if((b|0)==(u|0)){break n}e=0;b=b+1|0;if((p|0)!=H[H[i+(b<<2)>>2]>>2]){continue}break}break m}e=1}o:{p:{if(n){b=J[H[n+4>>2]+(j<<1)>>1];i=H[n+12>>2];b=((b|0)==J[i+32>>1]?-1:b)<<16>>16;u=F[H[n+28>>2]+j|0]&1;if(l&255){break p}l=0;break o}u=0;b=-1;l=(l&255)!=0;break o}if((b|0)>=0){l=1;if(h>>>0>j>>>0){break o}l=(I[(H[i+4>>2]+N(b,12)|0)+4|0]&15)!=0;break o}l=(b|0)!=-2}i=0;h=0;while(1){if(!(e&255)){break f}R=!h&i>>>0>=q>>>0|(h|0)!=0;if(R){break f}k=r;p=i&31;q:{if((i&63)>>>0>=32){k=o>>>p|0}else{k=((1<<p)-1&o)<<32-p|k>>>p}if(k&1){break q}p=(i<<4)+B|0;D=H[p>>2];k=bd(D);if(!k){break q}e=V?e:0;r:{s:{if((b|0)>=-1){t:{switch(I[k|0]-167|0){case 0:case 2:break t;default:break q}}if(H[k+28>>2]!=(v|0)|G[k+32>>1]!=(b|0)){break q}if((b|0)!=-1){break s}break r}if(ym(k,H[(H[n+40>>2]+(j<<4)|0)+8>>2],v)){break q}D=H[p>>2]}if(ab(H[Bf(H[a>>2],D)>>2],H[H[n+32>>2]+(j<<2)>>2])){break q}}if(L){G[m+30>>1]=j+1}u:{if(U|R){break u}if(y){y=1;if(((u^Q)&255)==(F[p+8|0]&1)){break u}break f}y=1;e=F[p+8|0]&1;Q=e^u;if((e|0)==(u|0)){break u}h=s|H[g+4>>2];H[g>>2]=Y|H[g>>2];H[g+4>>2]=h}if(I[p+8|0]&2){if(J[m+24>>1]!=(j|0)){break f}H[m+40>>2]=H[m+40>>2]|524288}x=(b|0)==-1?1:x;e=i&31;if((i&63)>>>0>=32){b=1<<e;h=0}else{h=1<<e;b=h-1&1>>>32-e}r=h|r;o=b|o;break l}i=i+1|0;h=i?h:h+1|0;continue}}j=j+1|0;continue}}b=255;if(l&255){break a}while(1){if(q>>>0<2&(E|0)<=0|(E|0)<0){break b}E=E-!q|0;q=q-1|0;a=q&31;if((q&63)>>>0>=32){h=-1<<a;a=0}else{b=(1<<a)-1&-1>>>32-a;a=-1<<a;h=b|a}if(((a|r)&(h|o))!=-1){continue}break}b=q;break a}l=j?j>>>0>=A>>>0?l:0:0}if((l|x)&255){break d}l=0;break c}e=_|H[m+12>>2];_=e;S=S|H[m+8>>2];j=S^-1;l=e^-1;i=0;h=0;while(1){if(!(!h&(i|0)==(q|0))){e=i&31;if((i&63)>>>0>=32){b=1<<e;k=0}else{k=1<<e;b=k-1&1>>>32-e}s=k;v:{if(r&s|b&o){break v}n=H[(i<<4)+B>>2];e=Ze(T,n);v=Ha;if(!(e|v)){if(!ge(n)){break v}}e=!(e&j|l&v);r=r|(e?s:0);o=o|(e?b:0)}b=h;i=i+1|0;h=i?b:b+1|0;continue}break}l=1}t=t+1|0;w=t?w:w+1|0;continue}}b=0}return b<<24>>24}function DE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,A=0;if((b|0)==2){a:{if((Kb(H[c>>2])|0)!=5){if((Kb(H[c+4>>2])|0)!=5){break a}}Rb(a);return}e=Db(H[c>>2]);h=Db(H[c+4>>2]);H[18340]=0;v=a;i=1;C(+h);g=x(1)|0;b:{c:{d:{p=x(0)|0;l=g;j=g&2147483647;e:{if(!(p|j)){break e}C(+e);a=x(1)|0;s=x(0)|0;b=a;if(!s&(a|0)==1072693248){break e}d=e+h;n=a&2147483647;if(!(!(n>>>0>2146435072|(n|0)==2146435072&(s|0)!=0|j>>>0>2146435072)&(!p|(j|0)!=2146435072))){break b}c=0;f:{g:{h:{i:{j:{k:{if((a|0)>0|(a|0)>=0){break k}c=2;if(j>>>0>1128267775){break k}c=0;if(j>>>0<1072693248){break k}r=j>>>20|0;if(j>>>0<1094713344){break j}o=1075-r|0;r=p>>>o|0;if((p|0)!=r<<o){break k}c=2-(r&1)|0}o=c;if(p){break h}if((j|0)!=2146435072){break i}if(!(n-1072693248|s)){break e}if(n>>>0<1072693248){break g}d=(g|0)>0|(g|0)>=0?h:0;break b}if(p){break h}c=1043-r|0;p=j>>>c|0;if((j|0)!=p<<c){break i}o=2-(p&1)|0}if((j|0)==1072693248){d=e;if((g|0)>0|(g|0)>=0){break b}d=1/d;break b}d=e*e;if(!w&(l|0)==1073741824){break b}if((l|0)!=1071644672|w|(a|0)<0){break h}d=W(e);break b}f=P(e);if(s){break f}l:{if((b|0)<0){if((b|0)==-2147483648|(b|0)==-1074790400|(b|0)==-1048576){break l}break f}if(!b|(b|0)==2146435072){break l}if((b|0)!=1072693248){break f}}i=(g|0)<0?1/f:f;if((a|0)>0|(a|0)>=0){break e}if(!(n-1072693248|o)){d=i-i;d=d/d;break b}d=(o|0)==1?-i:i;break b}d=(g|0)>0|(g|0)>=0?0:-h;break b}m:{if((a|0)>0|(a|0)>=0){break m}n:{switch(o|0){case 0:d=e-e;d=d/d;break b;case 1:break n;default:break m}}i=-1}o:{if(j>>>0>=1105199105){if(j>>>0>=1139802113){d=(g|0)<0?Infinity:0;if(n>>>0<=1072693247){break b}d=(l|0)>0?Infinity:0;break b}e=i*1e300*1e300;k=i*1e-300*1e-300;d=(g|0)<0?e:k;if(n>>>0<=1072693246){break b}d=(l|0)>0?e:k;if(n>>>0>=1072693249){break b}d=f+-1;e=d*1.9259629911266175e-8+d*d*(.5-d*(d*-.25+.3333333333333333))*-1.4426950408889634;m=e;e=d*1.4426950216293335;C(+(m+e));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);d=+B();e=m-(d-e);break o}d=f*9007199254740992;a=n>>>0<1048576;e=a?d:f;C(+d);b=x(1)|0;x(0)|0;b=a?b:n;l=b&1048575;c=l|1072693248;b=(b>>20)+(a?-1076:-1023)|0;a=0;p:{if(l>>>0<235663){break p}if(l>>>0<767610){a=1;break p}c=l|1071644672;b=b+1|0}l=((a<<18)+(c>>>1|0)|0)+537395200|0;a=a<<3;y=M[a+58e3>>3];C(+e);x(1)|0;o=0;z(0,x(0)|o);z(1,c|0);f=+B();k=M[a+57984>>3];q=f-k;t=1/(k+f);e=q*t;C(+e);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();A=d;z(0,o|0);z(1,l|0);u=d*d;m=q;q=+B();f=t*(m-d*q-d*(f-(q-k)));m=f*(e+d);d=e*e;k=m+d*d*(d*(d*(d*(d*(d*.20697501780033842+.23066074577556175)+.272728123808534)+.33333332981837743)+.4285714285785502)+.5999999999999946);C(+(u+3+k));c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();q=A*d;e=f*d+e*(k-(d+-3-u));C(+(q+e));c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();e=y+(d*-7.028461650952758e-9+(e-(d-q))*.9617966939259756);m=e;f=M[a+58016>>3];e=d*.9617967009544373;k=+(b|0);C(+(f+(m+e)+k));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);d=+B();e=m-(d-k-f-e)}z(0,0);z(1,g|0);f=+B();e=(h-f)*d+e*h;d=d*f;h=e+d;C(+h);a=x(1)|0;b=x(0)|0;q:{c=a;if((a|0)>=1083179008){if(b|a-1083179008){break d}if(!(e+8008566259537294e-32>h-d)){break q}break d}if((c&2147482624)>>>0<1083231232){break q}if(b|c+1064252416){break c}if(!(e<=h-d)){break q}break c}a=0;g=c&2147483647;if(g>>>0>=1071644673){b=c+(1048576>>>(g>>>20|0)-1022|0)|0;g=b>>>20&2047;a=(b&1048575|1048576)>>>1043-g|0;a=(c|0)<0?0-a|0:a;z(0,0);z(1,b&-1048576>>g-1023);d=d-+B();C(+(e+d));c=x(1)|0;x(0)|0}z(0,0);z(1,c|0);h=+B();f=h*.6931471824645996;h=(e-(h-d))*.6931471805599453+h*-1.904654299957768e-9;d=f+h;e=d*d;e=d-e*(e*(e*(e*(e*4.1381367970572385e-8+-16533902205465252e-22)+6613756321437934e-20)+-.0027777777777015593)+.16666666666666602);m=d*e/(e+-2);e=d;d=h-(d-f);d=e-(m-(e*d+d))+1;C(+d);b=x(1)|0;c=x(0)|0;b=(a<<20)+b|0;r:{if((b|0)<=1048575){e=Dj(d,a);break r}z(0,c|0);z(1,b|0);e=+B()}i=i*e}d=i;break b}d=i*1e300*1e300;break b}d=i*1e-300*1e-300}Sb(v,d);return}Y(23600,17858,546,17563);D()}function zy(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;h=Ea-80|0;Ea=h;H[h+4>>2]=b;a:{if(!d){e=1;break a}f=h+4|0;while(1){H[f>>2]=b;if(b){m=K[b+24>>2]<=c>>>0;f=m?b+16|0:f;e=e+m|0;b=H[b+16>>2];continue}break}b=H[h+4>>2]}H[a+208>>2]=H[a+208>>2]+e;if(H[b+24>>2]==1){jq(b)}q=I[a+11|0];f=H[a+168>>2];m=H[a+172>>2];g=H[a+232>>2];p=H[H[g+32>>2]>>2];if(Hb(g+52|0,p,48)){k=H[p+16>>2]+1|0}else{k=0}b:{if(!J[g+40>>1]){c:{d:{if(!H[p+96>>2]){break d}we(4,h+8|0);e=Vf(g,4,4);if((e|0)==5){break d}if(e){break c}bv(g,H[h+8>>2]);xe(g,4,4)}Kg(g,3);G[g+40>>1]=65535;H[h+16>>2]=0;while(1){e=av(g,h+8|0,1,h+16|0);if((e|0)==-1){continue}break}}if(e){break b}}p=f;n=H[g+68>>2];e:{if(n){break e}H[h+16>>2]=-2113503433;H[h+20>>2]=417475840;F[h+27|0]=f;F[h+26|0]=(m&255)<<24|f>>>8;F[h+25|0]=(m&65535)<<16|f>>>16;F[h+24|0]=(m&16777215)<<8|f>>>24;i=H[g+112>>2];H[h+28>>2]=i<<24|(i&65280)<<8|(i>>>8&65280|i>>>24);if(!i){we(8,g+84|0)}i=H[g+88>>2];H[h+32>>2]=H[g+84>>2];H[h+36>>2]=i;j=h+16|0;Uf(1,j,24,0,h+8|0);i=H[h+8>>2];H[h+40>>2]=i<<24|(i&65280)<<8|(i>>>8&65280|i>>>24);e=H[h+12>>2];H[h+44>>2]=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);H[g+36>>2]=p;H[g+76>>2]=i;H[g+80>>2]=e;F[g+65|0]=0;F[g+47|0]=1;i=H[g+8>>2];e=Ia[H[H[i>>2]+12>>2]](i,j,32,0,0)|0;if(e){break b}if(!I[g+48|0]){break e}i=q>>>2&3;if(!i){break e}e=H[g+8>>2];e=Ia[H[H[e>>2]+20>>2]](e,i)|0;if(e){break b}}if(H[g+36>>2]!=(p|0)){e=Ya(68598);break b}H[h+56>>2]=g;v=H[g+8>>2];H[h+76>>2]=p;H[h+72>>2]=q;H[h+64>>2]=0;H[h+68>>2]=0;H[h+60>>2]=v;f=f+24|0;j=f>>31;r=f;u=j;m=sJ(f,j,n,0);f=Ha;i=m+32|0;m=i>>>0<32?f+1|0:f;f=b;while(1){if(f){j=h+56|0;f:{g:{h:{i:{if(!k){break i}if(!(H[f+16>>2]|!d)){n=n+1|0;e=0;break h}H[h+16>>2]=0;Wo(g,H[f+24>>2],h+16|0);e=H[h+16>>2];if(e>>>0<k>>>0){break i}if(e>>>0<=H[g+104>>2]-1>>>0){H[g+104>>2]=e}j=H[g+8>>2];l=H[f+4>>2];o=sJ(e-1|0,0,r,u);e=Ha;o=o+56|0;e=o>>>0<56?e+1|0:e;e=Ia[H[H[j>>2]+12>>2]](j,l,p,o,e)|0;if(e){break b}G[f+28>>1]=J[f+28>>1]&65471;break f}n=n+1|0;e=0;if(!d){break g}e=H[f+16>>2]}e=e?0:c}e=$u(j,f,e,i,m);if(e){break b}G[f+28>>1]=J[f+28>>1]|64;m=m+u|0;i=i+r|0;m=i>>>0<r>>>0?m+1|0:m;w=f}f=H[f+16>>2];continue}break}j:{if(!d){e=0;l=0;break j}if(H[g+104>>2]){k=H[g+36>>2]+24|0;l=lc(k);if(!l){e=7;break b}f=H[g+104>>2];k:{if((f|0)==1){o=k>>31;e=24;f=0;break k}o=k>>31;e=sJ(k,o,f-2|0,0);f=Ha;e=e+48|0;f=e>>>0<48?f+1|0:f}j=H[g+8>>2];e=Ia[H[H[j>>2]+8>>2]](j,l,8,e,f)|0;z=g,A=cb(l),H[z+76>>2]=A;x=l+4|0;z=g,A=cb(x),H[z+80>>2]=A;f=H[g+104>>2];H[g+104>>2]=0;y=l+24|0;while(1){if(!(f>>>0>n>>>0|e)){s=H[g+8>>2];e=k;t=sJ(e,o,f-1|0,0);j=Ha;t=t+32|0;j=t>>>0<32?j+1|0:j;e=Ia[H[H[s>>2]+8>>2]](s,l,e,t,j)|0;if(!e){e=h+16|0;_u(g,cb(l),cb(x),y,e);s=H[g+8>>2];e=Ia[H[H[s>>2]+12>>2]](s,e,24,t,j)|0}f=f+1|0;continue}break}Ta(l);if(e){break b}}o=q&3;l:{if(!o){l=0;e=0;break l}m:{if(!I[g+49|0]){l=0;break m}f=m;k=dv(H[g+8>>2]);e=k+i|0;l=e-1|0;f=(e>>>0<k>>>0?f+1|0:f)-!e|0;k=uJ(l,f,k,0);j=l-k|0;f=f-(Ha+(l>>>0<k>>>0)|0)|0;q=f;H[h+64>>2]=j;H[h+68>>2]=f;l=0;k=i;f=m;while(1){if((f|0)<=(q|0)&j>>>0>k>>>0|(f|0)<(q|0)){e=$u(h+56|0,w,c,k,f);if(e){break b}l=l+1|0;f=f+u|0;k=k+r|0;f=k>>>0<r>>>0?f+1|0:f;continue}break}if((i|0)==(j|0)&(m|0)==(q|0)){break m}e=0;break l}e=Ia[H[H[v>>2]+20>>2]](v,o)|0}if(!I[g+47|0]){break j}f=H[g+16>>2];m=H[g+20>>2];if((m|0)<0){break j}i=sJ(r,u,l+n|0,0);j=Ha;i=i+32|0;j=i>>>0<32?j+1|0:j;k=f;f=f>>>0<i>>>0&(j|0)>=(m|0)|(j|0)>(m|0);Zu(g,f?i:k,f?j:m);F[g+47|0]=0}n=H[g+68>>2];f=b;while(1){if(!(!f|e)){e=0;if(I[f+28|0]&64){n=n+1|0;e=Vo(g,n,H[f+24>>2])}f=H[f+16>>2];continue}break}while(1){if(!((l|0)<=0|e)){l=l-1|0;n=n+1|0;e=Vo(g,n,H[w+24>>2]);continue}break}if(e){break b}H[g+68>>2]=n;G[g+66>>1]=p&65280|p>>>16;if(d){H[g+72>>2]=c;H[g+60>>2]=H[g+60>>2]+1;Uo(g);H[g+12>>2]=n}e=0;if(!H[a+96>>2]){break b}while(1){if(!b){break b}Yu(H[a+96>>2],H[b+24>>2],H[b+4>>2]);b=H[b+16>>2];continue}}Ea=h+80|0;return e}function oj(a,b){var c=0,d=0,e=0,f=0,g=0;d=1;c=1;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{v:{w:{x:{y:{z:{A:{B:{C:{D:{E:{F:{G:{H:{e=I[a|0];switch(I[e+34592|0]){case 0:break j;case 1:break k;case 4:case 5:break l;case 6:break m;case 9:break n;case 3:break o;case 26:break p;case 8:break q;case 25:break r;case 24:break s;case 23:break t;case 10:break u;case 15:break v;case 13:break w;case 12:break x;case 14:break y;case 22:break z;case 16:break A;case 21:break B;case 20:break C;case 19:break D;case 18:break E;case 17:break F;case 11:break G;case 7:break H;case 2:case 27:break f;case 29:break h;case 30:break i;default:break g}}while(1){c=d;d=c+1|0;if(F[I[a+c|0]+31152|0]&1){continue}break}H[b>>2]=183;return c}I:{c=I[a+1|0];if((c|0)!=62){if((c|0)!=45){break I}c=2;while(1){d=I[a+c|0];if(!(!d|(d|0)==10)){c=c+1|0;continue}break}H[b>>2]=183;return c}H[b>>2]=112;return I[a+2|0]==62?3:2}H[b>>2]=107;break b}H[b>>2]=22;break b}H[b>>2]=23;break b}H[b>>2]=1;break b}H[b>>2]=106;break b}H[b>>2]=108;break b}if(I[a+1|0]!=42){break e}c=I[a+2|0];if(!c){break e}d=3;J:{while(1){e=(c&255)==42;c=I[a+d|0];if(!(e&(c|0)==47)){if(!(c&255)){break J}d=d+1|0;continue}break}d=d+1|0}H[b>>2]=183;return d}H[b>>2]=110;break b}H[b>>2]=53;return I[a+1|0]==61?2:1}K:{switch(I[a+1|0]-60|0){case 1:H[b>>2]=55;break a;case 2:H[b>>2]=52;break a;case 0:H[b>>2]=104;break a;default:break K}}H[b>>2]=56;break b}L:{switch(I[a+1|0]-61|0){case 0:H[b>>2]=57;break a;case 1:H[b>>2]=105;break a;default:break L}}H[b>>2]=54;break b}if(I[a+1|0]!=61){H[b>>2]=184;break b}H[b>>2]=52;break a}if(I[a+1|0]!=124){H[b>>2]=103;break b}H[b>>2]=111;break a}H[b>>2]=25;break b}H[b>>2]=102;break b}H[b>>2]=114;break b}M:{while(1){c=I[a+d|0];if(!c){break M}N:{if((c|0)==(e|0)){d=d+1|0;if(I[d+a|0]!=(e|0)){break N}}d=d+1|0;continue}break}if((e|0)==39){H[b>>2]=117;return d}H[b>>2]=59;return d}H[b>>2]=184;return d}if(I[a+1|0]-58>>>0>4294967285){break o}H[b>>2]=141;break b}H[b>>2]=155;if(!(I[I[a+2|0]+31152|0]&8)|(I[a|0]!=48|(I[a+1|0]|32)!=120)){break d}d=3;while(1){c=d;d=c+1|0;if(I[I[a+c|0]+31152|0]&8){continue}break}break c}O:{while(1){c=59;if((e|0)==93){break O}e=I[a+d|0];if(e){d=d+1|0;continue}break}c=184}H[b>>2]=c;return d}H[b>>2]=156;while(1){c=d;d=c+1|0;if(I[a+c|0]-58>>>0>=4294967286){continue}break}break c}H[b>>2]=156;d=0;P:{while(1){e=I[a+c|0];if(!e){break P}Q:{R:{if(I[e+31152|0]&70){d=d+1|0;break R}if(!((e|0)!=40|(d|0)<=0)){while(1){e=c;c=c+1|0;f=I[c+a|0];if(!f){break Q}g=(f|0)!=41;if(g&!(F[f+31152|0]&1)){continue}break}if(g){break Q}c=e+2|0;break P}if((e|0)!=58){break P}e=c+1|0;if(I[e+a|0]!=58){break P}c=e}c=c+1|0;continue}break}H[b>>2]=184}if(d){break c}H[b>>2]=184;return c}if(I[I[a+1|0]+34592|0]>=3){break f}c=2;while(1){d=c;c=c+1|0;e=I[a+d|0];if(I[e+34592|0]<3){continue}break}if(I[e+31152|0]&70){break f}H[b>>2]=59;return Qv(a,d,b)}if(I[a+1|0]!=39){break f}H[b>>2]=154;d=2;while(1){c=d;d=c+1|0;e=I[a+c|0];if(I[e+31152|0]&8){continue}break}S:{if((e|0)==39){d=1;if(!(c&1)){break S}}H[b>>2]=184;while(1){b=I[a+c|0];if(!(!b|(b|0)==39)){c=c+1|0;continue}break}d=(b|0)!=0}return c+d|0}if(I[a+1|0]!=187|I[a+2|0]!=191){break f}H[b>>2]=183;return 3}H[b>>2]=184;return 0}H[b>>2]=184;break b}while(1){d=c;c=c+1|0;if(I[I[a+d|0]+31152|0]&70){continue}break}H[b>>2]=59;c=d;break c}H[b>>2]=109;break b}d=0;while(1){c=d;d=c+1|0;e=I[a+c|0];if(e-58>>>0>4294967285){continue}break}if((e|0)==46){while(1){c=c+1|0;d=c+a|0;if(I[d|0]-58>>>0>4294967285){continue}break}H[b>>2]=153;e=I[d|0]}T:{if(((e|32)&255)!=101){break T}d=a+c|0;e=I[d+1|0];if(e-58>>>0<=4294967285){U:{switch(e-43|0){case 0:case 2:break U;default:break T}}if(I[d+2|0]-58>>>0<4294967286){break T}}d=c+2|0;while(1){c=d;d=c+1|0;if(I[a+c|0]-58>>>0>4294967285){continue}break}H[b>>2]=153}while(1){if(!(I[I[a+c|0]+31152|0]&70)){break c}H[b>>2]=184;c=c+1|0;continue}}return c}return 1}return 2}function kA(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;h=Ea-96|0;Ea=h;G[h+18>>1]=65535;p=H[a>>2];e=H[a+8>>2];j=H[p+4>>2]+(I[e+16|0]<<6)|0;l=j+8|0;m=H[j+24>>2];r=H[a+4>>2];j=I[j+45|0]|I[j+46|0]<<8;a:{if(j&2){f=H[l+60>>2];break a}if(I[m+28|0]&128){f=H[m+8>>2];break a}f=h+24|0;Xa(f,0,72);H[h+72>>2]=65539;F[h+78|0]=5;F[h+79|0]=3;F[h+80|0]=0;H[h+32>>2]=h+20;H[h+28>>2]=h+18;G[h+76>>1]=1;H[h+36>>2]=m;d=J[m+38>>1];G[h+22>>1]=0;G[h+20>>1]=d;if(j&1){break a}H[h+44>>2]=H[m+8>>2]}b:{if(H[a+12>>2]|J[p+40>>1]&4128|(H[m+28>>2]&128|(j&72|(!(I[H[H[p>>2]>>2]+33|0]&128)|j&3)))){break b}if(I[l+36|0]&16){break b}d=H[r+24>>2];k=d+N(H[r+12>>2],48)|0;j=G[m+38>>1];o=Bm(j);j=j+o|0;i=j-25|0;n=j+28|0;while(1){if(d>>>0>=k>>>0|g){break b}g=0;c:{if(H[e+8>>2]&H[d+32>>2]|H[e+12>>2]&H[d+36>>2]){break c}if(!$q(d,l,0,0)){break c}G[e+24>>1]=1;H[e+44>>2]=1;H[e+32>>2]=0;H[H[e+52>>2]>>2]=d;d:{if(I[m+43|0]!=2){j=n;if(!(I[m+29|0]&64)){break d}}j=i}G[e+22>>1]=43;j=j<<16>>16;G[e+18>>1]=(j|0)>0?j:0;H[e+40>>2]=16384;v=e,w=ce(o,43),G[v+20>>1]=w;g=c|H[d+36>>2];H[e>>2]=b|H[d+32>>2];H[e+4>>2]=g;g=ck(a,e)}d=d+48|0;continue}}j=1;while(1){e:{f:{g:{if(!(!f|g)){d=H[f+36>>2];if(d){if(!Jz(H[l+40>>2],I[l+36|0],r,d)){break f}}if(I[f+56|0]&2){break f}o=J[H[f+8>>2]>>1];G[e+28>>1]=0;H[e+24>>2]=0;H[e+44>>2]=0;G[e+18>>1]=0;F[e+17|0]=0;H[e+32>>2]=f;G[e+22>>1]=o;H[e>>2]=b;H[e+4>>2]=c;g=1;h:{if(I[f+55|0]&4){break h}n=H[H[a>>2]+8>>2];if(!n){break h}k=H[l+40>>2];s=n+8|0;d=0;while(1){g=H[n>>2]<=(d|0);if(g){break h}i:{j:{i=bd(H[s+(d<<4)>>2]);if(!i){break j}if(!(I[i|0]!=167|(k|0)!=H[i+28>>2])){i=G[i+32>>1];if((i|0)<0){break h}q=J[f+50>>1];g=0;i=i&65535;while(1){if((g|0)==(q|0)){break j}t=g<<1;g=g+1|0;if((i|0)!=J[t+H[f+4>>2]>>1]){continue}break}break i}g=H[f+40>>2];if(!g){break j}q=g+8|0;g=0;while(1){if(J[f+50>>1]<=g>>>0){break j}if(J[H[f+4>>2]+(g<<1)>>1]==65534){if(!ym(i,H[q+(g<<4)>>2],k)){break i}}g=g+1|0;continue}}d=d+1|0;continue}break}g=0}n=o<<16>>16;k:{d=I[f+55|0]|I[f+56|0]<<8;if((d&3)==3){H[e+40>>2]=256;G[e+20>>1]=n+16;F[e+17|0]=g?0:j;Xq(r,e,n);break k}l:{m:{n:{if(d&32){H[h+8>>2]=0;H[h+12>>2]=0;break n}i=H[f+68>>2]&H[l+52>>2];d=H[f+64>>2]&H[l+48>>2];H[h+8>>2]=d;H[h+12>>2]=i;k=H[f+36>>2];if(k){dr(H[p>>2],f,k,h+8|0,0,0);i=H[h+12>>2];d=H[h+8>>2]}H[e+40>>2]=512;o:{if(d|(i|0)!=-2147483648){k=I[f+55|0]|I[f+56|0]<<8;if(!(k&4096)|!(d|i)|k&2048){break o}}s=H[l+40>>2];k=0;d=Ea-48|0;Ea=d;q=H[p+16>>2];p:{if(!q){break p}if(!(I[f+56|0]&16)){t=J[f+52>>1];i=0;while(1){if((i|0)==(t|0)){break p}u=i<<1;i=i+1|0;if(G[H[f+4>>2]+u>>1]<63){continue}break}}H[d+16>>2]=0;H[d+20>>2]=0;H[d+24>>2]=0;H[d+28>>2]=0;H[d+16>>2]=46;H[d+8>>2]=0;H[d+12>>2]=0;H[d+40>>2]=s;H[d+36>>2]=f;H[d+12>>2]=89;H[d+32>>2]=d+36;G[d+44>>1]=0;ec(d+8|0,q);k=I[d+45|0]?0:I[d+44|0]?67108864:64}Ea=d+48|0;if(!k){break l}H[h+8>>2]=0;H[h+12>>2]=0;i=H[e+40>>2]|k;break m}if(d|i){break l}}i=576}H[e+40>>2]=i}d=j;q:{if(!g){break q}d=0;if(I[l+37|0]&2|(H[f+36>>2]|I[m+28|0]&128)){break q}if(I[f+55|0]&4|(H[h+8>>2]|H[h+12>>2])|(I[p+40|0]&4|G[f+48>>1]>=G[m+40>>1])){break g}if(!I[65927]|I[H[H[p>>2]>>2]+80|0]&32){break g}}F[e+17|0]=d;G[e+20>>1]=(o+((N(G[f+48>>1],15)|0)/G[m+40>>1]|0)|0)+1;if(H[h+8>>2]|H[h+12>>2]){d=n+16|0;k=H[l+40>>2];g=0;while(1){r:{if(H[p+92>>2]<=(g|0)){break r}o=H[p+104>>2]+N(g,48)|0;if(!$z(H[o>>2],k,f)){break r}g=g+1|0;i=G[o+8>>1];if((i|0)>0){i=I[o+12|0]&130?-20:-1}d=d+i|0;continue}break}v=e,w=ce(G[e+20>>1],d<<16>>16),G[v+20>>1]=w}Xq(r,e,n);if(!(I[l+36|0]&16)|!H[f+40>>2]){break k}G[e+22>>1]=n;break g}g=ck(a,e);G[e+22>>1]=n;if(!g){break g}}Ea=h+96|0;return g}F[a+16|0]=0;g=Wq(a,l,f,0);if(I[a+16|0]!=1){break e}H[m+28>>2]=H[m+28>>2]|256;break e}g=0}j=j+1|0;f=I[l+37|0]&2?0:H[f+20>>2];continue}}function iJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;d=Ea+-64|0;Ea=d;i=1;c=H[b+4>>2];a:{if(c&4){break a}g=H[a>>2];f=H[a+24>>2];if(!(c&64)){ee(g,b,f);i=H[g+36>>2]?2:1;break a}n=H[b+52>>2];k=H[g>>2];c=b;while(1){if(c){H[c+4>>2]=H[c+4>>2]|4;H[d+52>>2]=0;H[d+44>>2]=0;H[d+48>>2]=0;H[d+36>>2]=0;H[d+40>>2]=0;H[d+28>>2]=0;H[d+32>>2]=0;H[d+56>>2]=c;H[d+24>>2]=g;i=2;if(cd(d+24|0,H[c+60>>2])){break a}if(F[c+6|0]&1){H[H[H[c+32>>2]+28>>2]+48>>2]=H[c+48>>2];H[c+48>>2]=0}if(f){H[f+28>>2]=H[f+28>>2]+1}a=0;while(1){h=H[c+32>>2];if(H[h>>2]>(a|0)){h=h+(a<<6)|0;e=H[h+28>>2];b:{if(!e|I[e+4|0]&4){break b}j=f?H[f+16>>2]:0;m=H[g+260>>2];o=H[h+16>>2];if(o){H[g+260>>2]=o}vA(g,e,f);H[g+260>>2]=m;if(H[g+36>>2]){break a}if(!f){break b}e=(I[h+45|0]|I[h+46|0]<<8)&65527|((j|0)<H[f+16>>2])<<3;F[h+45|0]=e;F[h+46|0]=e>>>8}a=a+1|0;continue}break}c:{if(!f){break c}a=H[f+28>>2];if(!a){break c}H[f+28>>2]=a-1}H[d+36>>2]=f;H[d+28>>2]=h;H[d+48>>2]=16385;if(Ne(d+24|0,H[c+28>>2])){break a}h=H[c+40>>2];a=H[d+48>>2];d:{if(h|a&16){H[c+4>>2]=H[c+4>>2]|a&134221824|8;a=a&-16385;break d}a=a&-16402}e=H[c+28>>2];a=a|128;H[d+48>>2]=a;H[d+32>>2]=e;e=H[c+44>>2];if(e){if(!(I[c+4|0]&8)){Wa(g,1202,0);break a}if(cd(d+24|0,e)){break a}a=H[d+48>>2]}H[d+48>>2]=a|1048576;if(cd(d+24|0,H[c+36>>2])){break a}H[d+48>>2]=H[d+48>>2]&-1048577;a=0;while(1){e=H[c+32>>2];if(H[e>>2]>(a|0)){e=e+(a<<6)|0;if(I[e+45|0]&4){if(Ne(d+24|0,H[e+64>>2])){break a}}a=a+1|0;continue}break}e:{if(I[g+220|0]<2){break e}e=c+72|0;while(1){a=H[e>>2];if(!a){break e}j=d+24|0;if(Ne(j,H[a+12>>2])){break a}e=a+36|0;if(!Ne(j,H[a+8>>2])){continue}break}break a}H[d+36>>2]=0;H[d+48>>2]=H[d+48>>2]|16385;if(F[c+6|0]&1){a=H[H[c+32>>2]+28>>2];H[c+48>>2]=H[a+48>>2];H[a+48>>2]=0}a=H[c+48>>2];if(!(!a|!l&(n|0)!=0)){if(uA(d+24|0,c,a,19482)){break a}}if(I[k+87|0]){break a}H[d+48>>2]=H[d+48>>2]&-16385;f:{if(!h){break f}if(uA(d+24|0,c,h,19842)|I[k+87|0]){break a}a=0;e=H[h>>2];j=(e|0)>0?e:0;e=h+8|0;while(1){if((a|0)==(j|0)){break f}if(I[H[e>>2]+4|0]&16){Wa(g,13306,0);break a}else{e=e+16|0;a=a+1|0;continue}}}a=H[c+56>>2];if(!(!a|H[H[c+28>>2]>>2]==H[H[a+28>>2]>>2])){if(I[a+5|0]&2){Wa(g,5228,0);break a}p=d,q=vi(I[a|0]),H[p+16>>2]=q;Wa(g,5039,d+16|0);break a}l=l+1|0;c=H[c+52>>2];continue}break}i=1;if(!n){break a}l=H[b+48>>2];if(!l){break a}a=H[l>>2];j=H[g>>2];g:{if((a|0)<=H[j+128>>2]){c=0;n=(a|0)>0?a:0;h=l+8|0;a=0;while(1){if((a|0)!=(n|0)){i=h+(a<<4)|0;f=(I[i+9|0]|I[i+10|0]<<8)&65531;F[i+9|0]=f;F[i+10|0]=f>>>8;a=a+1|0;continue}break}while(1){f=b;H[f+56>>2]=c;c=f;b=H[c+52>>2];if(b){continue}break}i=1;h:while(1){if(!(i?f:0)){a=0;b=H[l>>2];b=(b|0)>0?b:0;i=1;while(1){if((a|0)==(b|0)){break a}c=a<<4;a=a+1|0;if(I[(c+h|0)+9|0]&4){continue}break}H[d>>2]=a;Wa(g,3354,d);break g}o=H[f+28>>2];a=0;c=h;e=0;while(1){i=a;i:{j:{if(H[l>>2]>(e|0)){H[d+60>>2]=-1;if(I[c+9|0]&4){break j}k=bd(H[c>>2]);if(!k){break j}k:{if(Ff(k,d+60|0)){b=H[d+60>>2];a=H[o>>2];if((b|0)>0&(a|0)>=(b|0)){break k}lr(g,19482,e+1|0,a,k);break g}b=tA(o,k);if(!b){b=0;a=jb(j,k,0);l:{if(I[j+87|0]){break l}b=sA(g,f,a);if(I[g+220|0]<2|(b|0)<=0){break l}sA(g,f,k)}eb(j,a)}a=1;if((b|0)<=0){break i}}if(I[g+220|0]<=1){m=oc(j,155,0);if(!m){break g}H[m+8>>2]=b;H[m+4>>2]=H[m+4>>2]|2048;a=H[c>>2];if((k|0)!=(a|0)){while(1){n=a;a=H[a+12>>2];if(I[a|0]==113){continue}break}a=n+12|0}else{a=c}H[a>>2]=m;he(j,k);G[c+12>>1]=b}a=I[c+9|0]|I[c+10|0]<<8|4;F[c+9|0]=a;F[c+10|0]=a>>>8;break j}f=H[f+56>>2];continue h}a=i}c=c+16|0;e=e+1|0;continue}}}Wa(g,13272,0)}i=2}Ea=d- -64|0;return i|0}function zf(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;a:{b:{if(I[a+9|0]){break b}g=I[a+8|0];if(!g){break b}if(!b|(g|0)!=1){break a}}m=c;k=Ea-16|0;Ea=k;d=H[a+4>>2];c=H[a>>2];H[d+4>>2]=c;e=H[d>>2];j=b;c:{d:{g=a;a=I[a+8|0];if((a|0)==2|!b&(a|0)==1){break d}if(!(I[e+14|0]|!(I[c+35|0]&2))){G[d+24>>1]=J[d+24>>1]&65534}a=J[d+24>>1];if(!(!j|!(a&1))){b=8;break c}e:{f:{g:{if(j){if(a&128|I[d+20|0]==2){break g}if((j|0)<2){break e}a=d+76|0;while(1){b=H[a>>2];if(!b){break e}a=b+12|0;b=H[b>>2];if((g|0)==(b|0)){continue}break}break f}if(!(a&128)){break e}}b=H[d+80>>2]}if(!H[b>>2]){break e}b=262;break c}b=Io(g,1,1);if(b){break c}a=J[d+24>>1];G[d+24>>1]=a&65519;if(!H[d+48>>2]){G[d+24>>1]=a|16}n=d+36|0;a=0;while(1){h:{i:{if(!H[d+12>>2]){b=Du(H[d>>2]);if(b){break h}b=qd(d,1,k+12|0,0);if(b){break h}h=H[d>>2];c=H[h+28>>2];l=H[k+12>>2];f=H[l+56>>2];a=cb(f+28|0);j:{if(a){if((I[f+24|0]|I[f+25|0]<<8|(I[f+26|0]<<16|I[f+27|0]<<24))==(I[f+92|0]|I[f+93|0]<<8|(I[f+94|0]<<16|I[f+95|0]<<24))){break j}}a=c}k:{l:{m:{if(a?I[H[d+4>>2]+35|0]&2:1){h=H[d+40>>2];a=0;break m}b=26;if(Hb(f,33168,16)){break k}if(I[f+18|0]>=3){G[d+24>>1]=J[d+24>>1]|1}i=I[f+19|0];if(i>>>0>2){break k}n:{if(I[d+24|0]&32|(i|0)!=2){break n}H[k+8>>2]=0;h=Cu(h,k+8|0);if(h){break l}if(H[k+8>>2]){break n}Hj(l);b=0;break i}if(Hb(f+21|0,30526,3)){break k}i=I[f+17|0]<<16|I[f+16|0]<<8;if(i-65537>>>0<4294902016|i&i-1){break k}o=I[f+20|0];h=i-o|0;if((i|0)!=H[n>>2]){Hj(l);H[d+36>>2]=i;H[d+40>>2]=h;G[d+24>>1]=J[d+24>>1]|2;$o(d);b=Rh(H[d>>2],n,o);break i}o:{if(a>>>0<=c>>>0){break o}a=c;if((H[H[d+4>>2]+32>>2]&268435457)==1){break o}b=Ya(73493);break k}if(h>>>0<480){break k}H[d+40>>2]=h;H[d+36>>2]=i;G[d+24>>1]=J[d+24>>1]|2;p=d,q=(cb(f+52|0)|0)!=0,F[p+17|0]=q;p=d,q=(cb(f- -64|0)|0)!=0,F[p+18|0]=q}H[d+48>>2]=a;H[d+12>>2]=l;G[d+30>>1]=h-35;a=(((h<<5)-384>>>0)/255|0)-23|0;G[d+32>>1]=a;G[d+28>>1]=a;a=(((h<<6)-768>>>0)/255|0)-23|0;G[d+26>>1]=a;a=a&65535;F[d+21|0]=a>>>0>=127?127:a;b=0;break i}b=h}Hj(l);H[d+12>>2]=0;break h}p:{q:{r:{if(!j){break r}if(a){break r}b=8;if(F[d+24|0]&1){break h}b=H[e+44>>2];if(b){break q}F[e+22|0]=I[H[g>>2]+86|0]==2;if(I[e+17|0]==1){a=H[e+232>>2];s:{if(a){if(!(I[a+43|0]|!I[e+4|0])){b=Sf(e,4);if(b){break q}Ku(H[e+232>>2],1);a=H[e+232>>2]}b=8;if(I[a+46|0]){break h}b=Vf(a,0,1);if(b){break q}F[a+44|0]=1;if(!Hb(a+52|0,H[H[a+32>>2]>>2],48)){break s}xe(a,0,1);F[a+44|0]=0;break p}b=Sf(e,2);if(!(b|(j|0)<2)){b=No(e,4)}if(b){break q}}F[e+17|0]=2;H[e+80>>2]=0;H[e+84>>2]=0;a=H[e+28>>2];H[e+40>>2]=a;H[e+36>>2]=a;H[e+32>>2]=a}a=Oq(d)}b=a;if(b){break h}t:{if(I[g+8|0]){break t}H[d+44>>2]=H[d+44>>2]+1;if(!I[g+9|0]){break t}F[g+40|0]=1;H[g+44>>2]=H[d+76>>2];H[d+76>>2]=g+32}a=j?2:1;F[g+8|0]=a;if(a>>>0>I[d+20|0]){F[d+20|0]=a}if(!j){break d}H[d+80>>2]=g;G[d+24>>1]=J[d+24>>1]&65471|((j|0)>1)<<6;a=H[d+12>>2];if(H[d+48>>2]==(cb(H[a+56>>2]+28|0)|0)){break d}b=Vb(H[a+72>>2]);if(b){break c}a=H[a+56>>2];b=H[d+48>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[a+28|0]=b;F[a+29|0]=b>>>8;F[a+30|0]=b>>>16;F[a+31|0]=b>>>24;break d}if((b|0)!=517){break h}}b=I[d+20|0]?517:5;break h}a=0;if(!b){continue}}Ho(d);if(I[d+20|0]|(b&255)!=5){break c}a=b;if(jv(d)){continue}break}break c}if(m){p=m,q=cb(H[H[d+12>>2]+56>>2]+40|0),H[p>>2]=q}if(!j){b=0;break c}b=Dq(e,H[H[g>>2]+504>>2])}Ea=k+16|0;return b}g=H[a+4>>2];if(c){p=c,q=cb(H[H[g+12>>2]+56>>2]+40|0),H[p>>2]=q}if(!b){return 0}return Dq(H[g>>2],H[H[a>>2]+504>>2])}function yn(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;j=Ea-48|0;Ea=j;H[j+44>>2]=0;H[j+40>>2]=0;r=H[a>>2];a:{if(H[a+36>>2]){break a}h=rh(a,b);if(!h){break a}y=ui(a,h,128,0,0);w=I[h+43|0];m=1;if(!y){m=(ti(a,h,0,0)|0)!=0}if(cf(a,h)){break a}if(dn(a,h,y)){break a}e=H[h>>2];i=H[r+16>>2];g=Fb(r,H[h+60>>2]);s=Yb(a,9,e,0,H[i+(g<<4)>>2]);if((s|0)==1){break a}n=H[a+40>>2];i=n+1|0;H[a+40>>2]=i;H[b+48>>2]=n;e=i;k=h+8|0;f=k;while(1){f=H[f>>2];if(f){e=e+1|0;H[a+40>>2]=e;q=q+1|0;f=f+20|0;continue}break}f=0;if((w|0)==2){A=H[a+260>>2];H[a+260>>2]=H[h>>2];z=a}d=wb(a);b:{if(!d){break b}if(!I[a+18|0]){G[d+152>>1]=J[d+152>>1]|16}kd(a,m,g);if((w|0)==2){Kr(a,h,c,n);H[j+44>>2]=n;H[j+40>>2]=n}H[j+36>>2]=0;H[j+28>>2]=0;H[j+32>>2]=0;H[j+20>>2]=0;H[j+24>>2]=0;H[j+12>>2]=0;H[j+16>>2]=0;H[j+8>>2]=b;H[j+4>>2]=a;if(cd(j+4|0,c)){break b}if(!(I[a+18|0]|!(F[r+36|0]&1)|(H[a+132>>2]|I[a+159|0]))){p=H[a+44>>2]+1|0;H[a+44>>2]=p;Sa(d,71,0,p)}c:{if(!(c|s|m|I[h+43|0]==1)){wd(a,g,H[h+20>>2],1,H[h>>2]);if(!(I[h+28|0]&128)){fb(d,145,H[h+20>>2],g,p?p:-1,H[h>>2],-1)}f=p?p:-1;while(1){e=H[k>>2];if(e){d:{if(!(!(I[h+28|0]&128)|((I[e+55|0]|I[e+56|0]<<8)&3)!=2)){Ua(d,145,H[e+44>>2],g,f);break d}Sa(d,145,H[e+44>>2],g)}k=e+20|0;continue}else{e=0;break c}}}s=(I[j+28|0]&64)>>>6|0?20:m?20:28;e:{if(!(I[h+28|0]&128)){g=1;x=H[a+44>>2]+1|0;H[a+44>>2]=x;m=0;Sa(d,75,0,x);e=0;break e}e=H[a+44>>2];m=jc(h);g=G[m+50>>1];H[a+44>>2]=e+g;u=H[a+40>>2];H[a+40>>2]=u+1;o=Sa(d,118,u,g);Ed(a,m);e=e+1|0}t=bf(a,b,c,0,0,0,s,i);if(!t){break b}i=e;k=H[t+20>>2];s=H[t+24>>2];v=I[t+46|0];if((v|0)!=1){e=H[a+128>>2];F[(e?e:a)+20|0]=1}if(F[t+48|0]&1){_a(d,143,n)}if(p){Sa(d,86,p,1)}f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{if(m){e=0;l=(g|0)>0?g:0;while(1){if((e|0)!=(l|0)){yd(d,h,n,G[H[m+4>>2]+(e<<1)>>1],e+i|0);e=e+1|0;continue}break}if(!v){break p}l=i;break q}i=1;l=H[a+44>>2]+1|0;H[a+44>>2]=l;Sa(d,135,n,l);if(!v){break n}}e=Nb(r,q+2|0,0);if(!e){vd(t);break b}f=q+1|0;i=Xa(e,1,f);F[f+i|0]=0;if((k|0)>=0){F[i+(k-n|0)|0]=0}f=s;if((f|0)>0){f=1}else{f=(f|0)>=0}if(f){F[i+(s-n|0)|0]=0}if(o){de(d,o)}f=H[a+56>>2]-1|0;H[a+56>>2]=f;if((w|0)!=2){break o}i=g;break k}l=H[a+44>>2]+1|0;H[a+44>>2]=l;fb(d,97,i,g,l,jh(H[a>>2],m),g);gb(d,138,u,l,i,g);i=0;break m}q=0;if((v|0)!=2){k=0;i=g;o=0;break l}k=0;q=1;o=Mb(d,15);i=g;break l}Sa(d,156,x,l)}vd(t);k=1;q=0;e=0;o=0;g=0;if((w|0)==2){break j}}sk(a,h,113,8,n,e,j+44|0,j+40|0);if(q){rk(d,o)}q=e;g=f;if(k){break j}}k=0;if(I[h+43|0]==1){o=0;break h}g=H[j+44>>2];if(I[(g-n|0)+e|0]){gb(d,28,g,f,l,i)}o=0;break i}r:{if(m){k=_a(d,36,u);o=1;if(I[h+43|0]==1){Ua(d,94,u,0,l);break r}Sa(d,134,u,l);break r}o=1;k=Ua(d,46,x,0,l)}e=q;f=g}if(I[h+43|0]!=1){break g}}g=zd(r,h);cn(a,h);i=H[a+128>>2];F[(i?i:a)+21|0]=1;s:{if((v|0)!=1){break s}_a(d,122,n);if(H[a+128>>2]){break s}F[a+20|0]=0}fb(d,7,0,1,l,g,-11);g=H[d+108>>2];if((g|0)<=0){break f}G[(H[d+104>>2]+N(g,20)|0)-18>>1]=2;break f}qk(a,h,y,H[j+44>>2],H[j+40>>2],l,i,!I[a+18|0],11,v,s)}if(!o){hb(d,f);vd(t);break c}if(m){Sa(d,39,u,k+1|0);f=H[d+108>>2];H[(I[H[d>>2]+87|0]?73336:H[d+104>>2]+N(k,20)|0)+8>>2]=f;break c}Qb(d,k);f=H[d+108>>2];H[(I[H[d>>2]+87|0]?73336:H[d+104>>2]+N(k,20)|0)+8>>2]=f}if(!(I[a+18|0]|H[a+132>>2])){pk(a)}if(p){bn(d,p,15565)}f=e}if(!z){break a}H[z+260>>2]=A}Cc(r,b);eb(r,c);if(f){Wb(r,f)}Ea=j+48|0}function zh(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0;h=Ea+-64|0;Ea=h;k=H[c+4>>2];a:{b:{c:{d:{e:{if(d){e=F[b+1|0];d=e&255;H[h+16>>2]=d;m=2;if((e|0)<0){m=Od(b+1|0,h+16|0)+1&255;d=H[h+16>>2]}k=k+40|0;n=1;o=I[b|0];d=o+(d>>>0>=128?d-12>>>1|0:I[d+34112|0])|0;break e}d=F[b|0];o=d&255;H[h+60>>2]=o;m=1;if((d|0)<0){m=Od(b,h+60|0);o=H[h+60>>2]}d=o}l=d;f:{if(l>>>0<=a>>>0){q=c+23|0;while(1){g:{h:{i:{j:{k:{e=J[k+16>>1];if(e&36){d=I[b+m|0];if(d>>>0>=10){i=(d|0)==10?-1:1;a=0;break b}if((d|0)==7){break k}i=-1;if(!d){break c}g=b+l|0;r=H[k+4>>2];t=H[k>>2];l:{m:{switch(d-1|0){case 0:e=F[g|0];f=e>>31;break l;case 1:e=I[g+1|0]|F[g|0]<<8;f=e>>31;break l;case 2:e=I[g+2|0]|(I[g+1|0]<<8|F[g|0]<<16);f=e>>31;break l;case 3:e=I[g|0]|I[g+1|0]<<8|(I[g+2|0]<<16|I[g+3|0]<<24);e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);f=e>>31;break l;case 4:e=I[g+3|0];f=e>>>16|0;p=e<<16;j=f;e=I[g+2|0];f=e>>>8|0;p=e<<24|p;j=f|j;e=I[g+4|0];f=e>>>24|0;s=I[g+5|0]|(e<<8|p);j=f|j;f=I[g+1|0]|F[g|0]<<8;e=s;f=f|j;break l;case 5:e=I[g+4|0]|I[g+5|0]<<8|(I[g+6|0]<<16|I[g+7|0]<<24);j=I[g|0]|I[g+1|0]<<8|(I[g+2|0]<<16|I[g+3|0]<<24);p=j<<24|(j&65280)<<8;g=j&16711680;f=g<<24;g=g>>>8|0;w=f;s=j&-16777216;f=s>>>24|0;e=w|s<<8|(((e&255)<<24|j>>>8)&-16777216|((e&16777215)<<8|j>>>24)&16711680|(e>>>8&65280|e>>>24));j=f|g|p;f=0;f=j|(f|f);break l;default:break m}}e=d-8|0;f=0}if(e>>>0<t>>>0&(f|0)<=(r|0)|(f|0)<(r|0)){break c}if((f|0)<=(r|0)&e>>>0<=t>>>0|(f|0)<(r|0)){break g}break d}n:{if(e&8){d=I[b+m|0];if(d>>>0>=10){i=(d|0)==10?-1:1;a=0;break b}i=-1;if((d|0)!=7){if(!d){break c}Wh(b+l|0,d,h+16|0);i=Qi(H[h+16>>2],H[h+20>>2],M[k>>3]);break j}d=1;if(jo(b+l|0,h+16|0)){break c}u=M[h+16>>3];v=M[k>>3];if(u<v){break c}if(u>v){break n}break h}if(e&2){d=b+m|0;f=F[d|0];e=f&255;H[h+12>>2]=e;if((f|0)<0){Od(d,h+12|0);e=H[h+12>>2]}if(e>>>0<12){i=-1;d=e;break c}d=1;if(!(e&1)){break d}f=e-12>>>1|0;H[h+28>>2]=f;o:{if(f+l>>>0<=a>>>0){i=H[c>>2];if(J[i+8>>1]>n>>>0){break o}}x=q,y=Ya(89158),F[x|0]=y;break f}j=H[(i+(n<<2)|0)+20>>2];if(j){F[h+34|0]=I[i+4|0];d=H[i+12>>2];G[h+32>>1]=2;H[h+36>>2]=d;H[h+24>>2]=b+l;d=e;i=Bt(h+16|0,k,j,q);break j}j=H[k+12>>2];i=Hb(b+l|0,H[k+8>>2],(f|0)<(j|0)?f:j);if(i){break c}d=e;i=f-j|0;break j}f=b+m|0;d=I[f|0];if(e&16){H[h+12>>2]=d;i=-1;if(d<<24>>24<0){Od(f,h+12|0);d=H[h+12>>2]}if(d&1|d>>>0<12){break c}e=d-12>>>1|0;if(e+l>>>0<=a>>>0){if(I[k+17|0]&4){if(!io(b+l|0,e)){break n}i=e-H[k>>2]|0;break j}f=H[k+12>>2];i=Hb(b+l|0,H[k+8>>2],(e|0)<(f|0)?e:f);if(i){d=1;break c}i=e-f|0;break j}x=q,y=Ya(89188),F[x|0]=y;break f}i=1;p:{switch(d-7|0){case 3:break g;case 1:case 2:break c;case 0:break p;default:break i}}if(jo(b+l|0,h+16|0)){break h}}d=1;break d}jo(b+l|0,h+16|0);d=7;i=0-Qi(H[k>>2],H[k+4>>2],M[h+16>>3])|0}if(!i){break g}break c}if(d){break c}break g}d=7}q:{n=n+1|0;if((n|0)==J[c+20>>1]){break q}l=(d>>>0>=128?d-12>>>1|0:I[d+34112|0])+l|0;if(l>>>0>a>>>0){break q}m=vh(d,0)+m|0;if(o>>>0<=m>>>0){x=q,y=Ya(89239),F[x|0]=y;break f}k=k+40|0;continue}break}F[c+26|0]=1;i=F[c+22|0];break a}x=c,y=Ya(89077),F[x+23|0]=y}i=0;break a}i=1}a=!d}b=I[H[H[c>>2]+16>>2]+n|0];if(!b){break a}r:{if(!(b&2)){break r}if(a){if(!(b&1)){break r}break a}if((F[k+16|0]&1)==(b&1)){break a}}i=0-i|0}Ea=h- -64|0;return i}function iH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;d=Ea-368|0;Ea=d;a:{if(!b){break a}j=$a(H[c>>2]);if(!j){break a}f=b-1|0;b=d+320|0;if(ng(a,f,c+4|0,b)){break a}c=H[H[H[a>>2]+20>>2]+120>>2];G[d+316>>1]=0;H[d+312>>2]=0;H[d+308>>2]=c;H[d+304>>2]=0;H[d+296>>2]=0;H[d+300>>2]=0;Ac(b);Ye(b);c=0;b=0;while(1){e=I[b+j|0];b:{if((e|0)!=37){if(e){break b}if(b>>>0>c>>>0){sb(d+296|0,c+j|0,b-c|0)}um(a,d+296|0);break a}if(b>>>0>c>>>0){sb(d+296|0,c+j|0,b-c|0)}c=b+2|0;c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{s:{t:{u:{b=b+1|0;g=I[j+b|0];switch(g-70|0){case 19:break g;case 47:case 49:break h;case 14:break i;case 13:break j;case 45:break k;case 12:break l;case 10:case 42:break m;case 7:break n;case 39:break o;case 4:break p;case 17:case 36:break q;case 3:case 38:break r;case 2:case 37:break s;case 0:break t;case 32:break u;case 30:case 31:break d;case 1:case 5:case 6:case 8:case 9:case 11:case 15:case 16:case 18:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 33:case 34:case 35:case 40:case 41:case 43:case 44:case 46:case 48:break e;default:break f}}h=M[d+352>>3];M[d+16>>3]=h>59.999?59.999:h;lb(d+296|0,12719,d+16|0);break b}H[d+32>>2]=H[d+328>>2];e=H[d+336>>2];H[d+36>>2]=H[d+332>>2];H[d+40>>2]=e;lb(d+296|0,16530,d+32|0);break b}H[d+48>>2]=H[d+340>>2];lb(d+296|0,(g|0)==72?16540:16545,d+48|0);break b}e=H[d+340>>2];e=(e|0)>12?e-12|0:e;H[d+64>>2]=e?e:12;lb(d+296|0,(g|0)==73?16540:16545,d- -64|0);break b}e=d+248|0;Va(e,d+320|0,48);H[d+260>>2]=1;H[d+264>>2]=1;F[d+288|0]=0;Ac(e);f=H[d+324>>2];i=H[d+320>>2]+432e5|0;f=i>>>0<432e5?f+1|0:f;e=H[d+248>>2];e=tJ(i-e|0,f-(H[d+252>>2]+(e>>>0>i>>>0)|0)|0,864e5,0);if((g|0)==87){l=d,m=((e-uJ(tJ(i,f,864e5,0),Ha,7,0)|0)+7|0)/7|0,H[l+80>>2]=m;lb(d+296|0,16540,d+80|0);break b}H[d+96>>2]=e+1;lb(d+296|0,16510,d+96|0);break b}M[d+112>>3]=(+K[d+320>>2]+ +H[d+324>>2]*4294967296)/864e5;lb(d+296|0,12564,d+112|0);break b}H[d+128>>2]=H[d+332>>2];lb(d+296|0,16540,d+128|0);break b}H[d+144>>2]=H[d+344>>2];lb(d+296|0,16540,d+144|0);break b}if(H[d+340>>2]>=12){sb(d+296|0,(g|0)==112?19997:11421,2);break b}sb(d+296|0,(g|0)==112?20006:11559,2);break b}e=H[d+344>>2];H[d+160>>2]=H[d+340>>2];H[d+164>>2]=e;lb(d+296|0,16520,d+160|0);break b}e=H[d+320>>2];g=H[d+324>>2];if(I[d+367|0]){M[d+192>>3]=(+(e-1045635584>>>0)+ +(g-((e>>>0<1045635584)+49096|0)|0)*4294967296)/1e3;lb(d+296|0,12726,d+192|0);break b}e=tJ(e,g,1e3,0);H[d+176>>2]=e-413362496;H[d+180>>2]=Ha-((e>>>0<413362496)+49|0);lb(d+296|0,14968,d+176|0);break b}h=M[d+352>>3];v:{if(P(h)<2147483648){f=~~h;break v}f=-2147483648}H[d+208>>2]=f;lb(d+296|0,16540,d+208|0);break b}e=H[d+344>>2];H[d+224>>2]=H[d+340>>2];H[d+228>>2]=e;h=M[d+352>>3];w:{if(P(h)<2147483648){f=~~h;break w}f=-2147483648}H[d+232>>2]=f;lb(d+296|0,16515,d+224|0);break b}f=d+296|0;e=H[d+324>>2];i=H[d+320>>2]+1296e5|0;e=i>>>0<1296e5?e+1|0:e;k=f;e=uJ(tJ(i,e,864e5,0),Ha,7,0);f=e+48|0;Sh(k,1,((g|0)==117?Ha|e?f:55:f)<<24>>24);break b}H[d+240>>2]=H[d+328>>2];lb(d+296|0,16505,d+240|0);break b}if((g|0)==37){break c}}Tf(d+296|0);break a}H[d>>2]=H[d+336>>2];lb(d+296|0,(g|0)==100?16540:16545,d);break b}Sh(d+296|0,1,37)}b=b+1|0;continue}}Ea=d+368|0}function lA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0;l=Ea-16|0;Ea=l;H[l+8>>2]=0;r=H[a+4>>2];f=H[r+12>>2];o=(f|0)>0?f:0;j=H[a>>2];m=H[a+8>>2];f=H[j+4>>2]+(I[m+16|0]<<6)|0;g=f+8|0;q=H[f+24>>2];f=H[r+24>>2];p=H[j+8>>2];s=H[j>>2];while(1){if((h|0)!=(o|0)){i=J[f+10>>1];G[f+10>>1]=i&65471;a:{if(!(J[f+12>>1]&63487)|i&128|(d&H[f+32>>2]|e&H[f+36>>2])|H[f+20>>2]!=H[g+40>>2]){break a}if(I[g+36|0]&88){if(!Yq(f,g)){break a}}G[f+10>>1]=i|64;n=n+1|0}f=f+48|0;h=h+1|0;continue}break}b:{c:{if(!p){break c}e=H[p>>2];h=(e|0)>0?e:0;o=p+8|0;f=0;d:{while(1){if((f|0)==(h|0)){break d}e:{i=o+(f<<4)|0;d=H[i>>2];f:{if(ge(d)){break f}if(I[i+8|0]&2){break e}i=I[d|0];if((i|0)!=113){if((i|0)!=167|H[d+28>>2]!=H[g+40>>2]){break e}break f}i=H[d+12>>2];if(I[i|0]!=167|H[i+28>>2]!=H[g+40>>2]){break e}i=G[i+32>>1];G[d+32>>1]=i;if((i|0)<0){break f}t=H[d+8>>2];d=Yf(H[q+4>>2]+N(i&65535,12)|0);if(Zb(t,d?d:33248)){break e}}f=f+1|0;continue}break}h=f}if((e|0)!=(h|0)){break c}d=J[j+40>>1];if(d&128){d=d>>>9&1|2;break b}d=d>>>6&1;break b}e=0;d=0}f=e<<3;g=nb(H[s>>2],(f+N(n,24)|0)+96|0,0);g:{if(!g){Wa(s,1150,0);f=7;break g}H[g+84>>2]=0;H[g+80>>2]=d;H[g+76>>2]=s;H[g+72>>2]=r;o=((n<<2)+g|0)+92|0;H[g+4>>2]=o;q=o+N(n,12)|0;H[g+12>>2]=q;H[g+16>>2]=f+q;d=H[r+12>>2];t=(d|0)>0?d:0;f=H[r+24>>2];i=0;n=0;h=0;while(1){if((h|0)!=(t|0)){u=J[f+10>>1];if(u&64){j=H[f+24>>2];d=o+N(k,12)|0;H[d+8>>2]=h;H[d>>2]=j;v=J[f+12>>1];j=v&16383;h:{if((j|0)==1){if(u<<16>>16>=0){i=((k|0)<32?1<<k:0)|i;H[g+84>>2]=i}F[d+4|0]=2;break h}if((j|0)==64){F[d+4|0]=I[f+15|0];break h}if(j&384){if((j|0)==256){F[d+4|0]=71;break h}F[d+4|0]=72;break h}F[d+4|0]=v;if(!(j&60)){break h}if(!Ke(H[H[f>>2]+16>>2])){break h}n=((k|0)<16?1<<k:0)|n;if((j|0)!=4){if((j|0)!=16){break h}F[d+4|0]=8;break h}F[d+4|0]=32}k=k+1|0}f=f+48|0;h=h+1|0;continue}break}H[g>>2]=k;h=0;d=(e|0)>0?e:0;e=p+8|0;f=0;while(1){if((d|0)!=(f|0)){k=e+(f<<4)|0;j=H[k>>2];if(!ge(j)){i=q+(h<<3)|0;H[i>>2]=G[j+32>>1];F[i+4|0]=F[k+8|0]&1;h=h+1|0}f=f+1|0;continue}break}H[g+8>>2]=h;G[m+44>>1]=0;H[m+40>>2]=1024;G[m+18>>1]=0;F[m+28|0]=I[m+28|0]&254;d=H[g>>2];if(oi(H[s>>2],m,d)){Kz(H[s>>2],g);f=7;break g}e=n&65535;h=l+12|0;f=ni(a,b,c,-1,-1,0,g,e,h,l+8|0);if(H[l+8>>2]){f=ni(a,b,c,-1,-1,0,g,e,h,0)}i:{if(f){break i}e=H[l+12>>2];p=c^-1;f=p&H[m+4>>2];q=f;o=b^-1;t=o&H[m>>2];if(!(f|t)){f=0;if(!e){break i}}f=0;h=0;u=(d|0)>0?d:0;if(e){f=ni(a,b,c,-1,-1,1,g,n&65535,l+12|0,0);e=p&H[m+4>>2];z=e;w=o&H[m>>2];h=!(e|w)}i=!h;v=n&65535;while(1){if(f){break i}d=-1;e=-1;f=0;while(1){if((f|0)!=(u|0)){k=H[r+24>>2]+N(H[(H[g+4>>2]+N(f,12)|0)+8>>2],48)|0;j=o&H[k+32>>2];k=p&H[k+36>>2];x=(k|0)==(e|0)&d>>>0>j>>>0|e>>>0>k>>>0;A=x?j:d;j=(k|0)==(y|0)&j>>>0>B>>>0|k>>>0>y>>>0;d=j?A:d;e=j?x?k:e:e;f=f+1|0;continue}break}if((d&e)!=-1){f=0;B=d;y=e;if((d|0)==(t|0)&(e|0)==(q|0)|(d|0)==(w|0)&(e|0)==(z|0)){continue}f=ni(a,b,c,b|d,c|e,0,g,v,l+12|0,0);if((b|0)!=H[m>>2]|(c|0)!=H[m+4>>2]){continue}h=H[l+12>>2]?h:1;i=0;continue}break}f=0;if(i){f=ni(a,b,c,b,c,0,g,n&65535,l+12|0,0);h=H[l+12>>2]?h:1}if(f|h){break i}f=ni(a,b,c,b,c,1,g,n&65535,l+12|0,0)}if(H[g+28>>2]){Ta(H[g+24>>2])}Kz(H[s>>2],g)}Ea=l+16|0;return f}function ni(a,b,c,d,e,f,g,h,i,j){var k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,y=0,z=0;n=Ea+-64|0;Ea=n;q=H[g+16>>2];t=H[a+4>>2];k=H[a+8>>2];s=I[k+16|0];l=H[a>>2];u=H[l+4>>2];l=H[l>>2];r=H[g>>2];H[i>>2]=0;H[k>>2]=b;H[k+4>>2]=c;w=(r|0)>0?r:0;b=H[g+4>>2];while(1){if((o|0)!=(w|0)){c=H[t+24>>2];F[b+5|0]=0;c=c+N(H[b+8>>2],48)|0;p=H[c+32>>2];v=(d&p)!=(p|0);p=H[c+36>>2];if(!(v|(e&p)!=(p|0)|J[c+12>>1]&f|!j&(I[c+15|0]-75&255)>>>0>253)){F[b+5|0]=1}b=b+12|0;o=o+1|0;continue}break}p=Xa(q,0,r<<3);H[g+56>>2]=0;H[g+48>>2]=25;H[g+52>>2]=0;H[g+40>>2]=-1568170194;H[g+44>>2]=1416446638;H[g+32>>2]=0;H[g+20>>2]=0;H[g+24>>2]=0;e=u+(s<<6)|0;b=e;c=H[b+56>>2];d=H[b+60>>2];H[g+88>>2]=0;H[g+64>>2]=c;H[g+68>>2]=d;c=H[l>>2];f=H[b+24>>2];d=H[zd(c,f)+8>>2];H[c+56>>2]=H[c+56>>2]+1;c=Ia[H[H[d>>2]+12>>2]](d,g)|0;b=H[l>>2];H[b+56>>2]=H[b+56>>2]-1;a:{if(!c|(c|0)==19){break a}if((c|0)==7){Ib(b);break a}b=H[d+8>>2];if(!b){y=n,z=Sg(c),H[y+32>>2]=z;Wa(l,8863,n+32|0);break a}H[n+48>>2]=b;Wa(l,8863,n+48|0)}b:{if(!I[H[f+52>>2]+17|0]){break b}b=0;f=H[H[l>>2]+20>>2];f=(f|0)>0?f:0;while(1){if((b|0)!=(f|0)){ld(l,b);b=b+1|0;continue}break}if(!H[l+88>>2]){break b}b=0;while(1){if((b|0)==(f|0)){break b}kd(l,0,b);b=b+1|0;continue}}Ta(H[d+8>>2]);b=0;H[d+8>>2]=0;c:{if(c){if((c|0)==19){break c}b=c;break c}Xa(H[k+52>>2],0,r<<2);H[k+32>>2]=0;H[k+36>>2]=0;H[k+24>>2]=0;H[k+28>>2]=0;o=H[g+4>>2];f=-1;while(1){if((b|0)!=(w|0)){d:{q=(b<<3)+p|0;c=H[q>>2];if((c|0)<=0){break d}e:{f:{if((c|0)>(r|0)){break f}d=H[o+8>>2];if((d|0)<0|(d|0)>=H[t+12>>2]){break f}c=c-1|0;s=H[k+52>>2]+(c<<2)|0;if(H[s>>2]){break f}if(I[o+5|0]){break e}}H[n+16>>2]=H[H[e+24>>2]>>2];Wa(l,10337,n+16|0);b=1;break c}d=H[t+24>>2]+N(d,48)|0;u=H[d+32>>2];v=H[k+4>>2]|H[d+36>>2];H[k>>2]=u|H[k>>2];H[k+4>>2]=v;H[s>>2]=d;g:{if(!I[q+4|0]){break g}if(!(h>>>b&1|b>>>0>15)){G[k+30>>1]=J[k+30>>1]|1<<c}if(I[d+15|0]!=74){break g}F[k+28|0]=I[k+28|0]|2}q=(c|0)>(f|0);h:{if(H[g+88>>2]&(b>>>0<32?1<<b:0)){H[k+36>>2]=H[k+36>>2]|1<<c;break h}if(!(F[d+12|0]&1)){break h}H[g+32>>2]=0;H[g+56>>2]=H[g+56>>2]&-2;H[i>>2]=1}f=q?c:f;if(!H[i>>2]|(I[d+15|0]-75&255)>>>0<254){break d}if(H[g+28>>2]){Ta(H[g+24>>2]);H[g+24>>2]=0;H[g+28>>2]=0}H[j>>2]=1;b=0;break c}o=o+12|0;b=b+1|0;continue}break}G[k+44>>1]=f+1;c=((f|0)<0?-1:f)+1|0;b=0;i:{while(1){if((b|0)==(c|0)){break i}d=b<<2;b=b+1|0;if(H[H[k+52>>2]+d>>2]){continue}break}H[n>>2]=H[H[e+24>>2]>>2];Wa(l,10337,n);b=1;break c}H[k+24>>2]=H[g+20>>2];F[k+28|0]=I[k+28|0]&254|F[g+28|0]&1;H[g+28>>2]=0;H[k+32>>2]=H[g+24>>2];b=0;b=H[g+32>>2]?H[g+8>>2]:b;G[k+18>>1]=0;F[k+29|0]=b;m=M[g+40>>3];b=0;j:{if(m<=1){break j}if(m<=2e9){k:{if(m<0x10000000000000000&m>=0){b=~~m>>>0;if(P(m)>=1){c=~~(m>0?R(T(m*2.3283064365386963e-10),4294967295):U((m-+(~~m>>>0>>>0))*2.3283064365386963e-10))>>>0}else{c=0}break k}b=0;c=0}b=Kd(b,c);break j}C(+m);b=x(1)|0;x(0)|0;b=N(b>>>20|0,10)-10220|0}G[k+20>>1]=b<<16>>16;y=k,z=Kd(H[g+48>>2],H[g+52>>2]),G[y+22>>1]=z;H[k+40>>2]=H[k+40>>2]&-4097|H[g+56>>2]<<12&4096;b=ck(a,k);if(!(F[k+28|0]&1)){break c}Ta(H[k+32>>2]);F[k+28|0]=I[k+28|0]&254}Ea=n- -64|0;return b}function qD(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;g=Ea-48|0;Ea=g;H[g+36>>2]=0;H[g+32>>2]=0;H[b>>2]=0;d=oe();if(!d){e=I[65924]?I[65925]:e;d=H[16530]?131078:6;f=d&-655129;H[g+40>>2]=f;c=td(536,0);a:{if(!c){break a}if(e){H[c+12>>2]=8}F[c+97|0]=109;H[c+20>>2]=2;G[c+308>>1]=0;H[c+304>>2]=1;H[c+16>>2]=c+460;H[c+72>>2]=d&33554432?-1:255;Va(c+120|0,32688,48);F[c+90|0]=255;F[c+85|0]=1;H[c+164>>2]=0;e=H[16522];h=H[16523];H[c+180>>2]=67056;H[c+100>>2]=0;H[c+48>>2]=e;H[c+52>>2]=h;h=H[c+36>>2];H[c+32>>2]=H[c+32>>2]|-536575776;H[c+36>>2]=h;H[c+432>>2]=0;H[c+436>>2]=0;H[c+440>>2]=0;H[c+444>>2]=0;H[c+388>>2]=0;H[c+392>>2]=0;H[c+396>>2]=0;H[c+400>>2]=0;hj(c,33248,1,15);hj(c,33248,3,15);hj(c,33248,2,15);hj(c,20255,1,16);hj(c,2e4,1,17);if(I[c+87|0]){break a}H[c+60>>2]=f;b:{if(!(1<<(d&7)&70)){a=Rc(181681);break b}a=Ev(0,a,g+40|0,c,g+36|0,g+32|0)}if(a){if((a|0)==7){Ib(c)}d=H[g+32>>2];H[g>>2]=d;ae(c,a,d?8863:0,g);Ta(d);break a}a=gj(H[c>>2],H[g+36>>2],c,H[c+16>>2]+4|0,0,H[g+40>>2]|256);if(a){Pc(c,(a|0)==3082?7:a);break a}a=H[H[c+16>>2]+4>>2];H[H[a+4>>2]+4>>2]=H[a>>2];a=rl(c,a);H[H[c+16>>2]+12>>2]=a;if(!I[c+87|0]){dp(c,I[a+77|0])}d=rl(c,0);a=H[c+16>>2];F[a+24|0]=1;H[a+16>>2]=9874;F[a+8|0]=3;H[a>>2]=11276;H[a+28>>2]=d;F[c+97|0]=118;if(I[c+87|0]){break a}Pc(c,0);if((Th(c,20189,2)|0)==7){Ib(c)}d=0;e=fp(c);while(1){if(!(d>>>0>2|e)){e=Ia[H[(d<<2)+52924>>2]](c)|0;d=d+1|0;continue}break}c:{if(!e){d=0;d:{if(!H[18271]){break d}a=1;while(1){if(!a){break d}e:{if(K[18271]<=d>>>0){H[g+44>>2]=0;a=0;f=0;break e}e=H[H[18272]+(d<<2)>>2];H[g+44>>2]=0;a=1;f=0;if(!e){break e}e=Ia[e|0](c,g+44|0,0)|0;f=H[g+44>>2];if(!e){break e}H[g+16>>2]=f;ae(c,e,8653,g+16|0);a=0;f=H[g+44>>2]}Ta(f);d=d+1|0;continue}}if(!fp(c)){break c}break a}Pc(c,e)}f=H[16485];d=H[16486];a=0;e=Qk(H[c+332>>2]);h=Qk(H[c+336>>2]);e=Qk(H[c+340>>2])+e|0;k=Qk(H[c+344>>2]);if((H[c+316>>2]-((e+h|0)+k|0)|0)<=0){if(I[c+312|0]){Ta(H[c+352>>2])}h=f&-8;k=(h|0)<5;f:{if(!(k|(d|0)<=0)){d=sJ(d,d>>31,f,f>>31);e=Ha;a=H[18327];if(a){Ia[a|0]()}a=bc(d,e);j=H[18328];if(j){Ia[j|0]()}g:{if(!a){a=0;break g}d=Ia[H[16491]](a)|0;e=d>>31}j=k?0:h;if(f>>>0>=384){f=tJ(d,e,h+384|0,0);i=N(f,h);i=tJ(d-i|0,e-((i>>31)+(d>>>0<i>>>0)|0)|0,128,0);break f}if(f>>>0>=256){f=tJ(d,e,h+128|0,0);i=N(f,h);i=tJ(d-i|0,e-((i>>31)+(d>>>0<i>>>0)|0)|0,128,0);break f}f=tJ(d,e,h,0);break f}f=0}H[c+332>>2]=0;H[c+336>>2]=0;H[c+352>>2]=a;G[c+310>>1]=j;G[c+308>>1]=j;h:{if(a){d=0;h=(f|0)>0?f:0;e=0;while(1){if((e|0)!=(h|0)){H[a>>2]=d;H[c+332>>2]=a;e=e+1|0;d=a;a=a+j|0;continue}break}H[c+348>>2]=a;H[c+340>>2]=0;H[c+344>>2]=0;d=0;h=(i|0)>0?i:0;e=0;while(1){if((e|0)!=(h|0)){H[a>>2]=d;H[c+340>>2]=a;e=e+1|0;d=a;a=a+128|0;continue}break}H[c+304>>2]=0;H[c+356>>2]=a;F[c+312|0]=1;d=f+i|0;break h}H[c+340>>2]=0;H[c+344>>2]=0;F[c+312|0]=0;G[c+308>>1]=0;H[c+304>>2]=1;H[c+356>>2]=0;H[c+348>>2]=0;H[c+352>>2]=0;a=0;d=0}H[c+360>>2]=a;H[c+316>>2]=d}H[c+272>>2]=1e3;H[c+268>>2]=18}d=fp(c);i:{if((d&255)==7){Ov(c,0);c=0;break i}if(!d){break i}F[c+97|0]=186}H[b>>2]=c;cp(H[g+36>>2])}Ea=g+48|0;return d|0}function om(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;i=Ea-16|0;Ea=i;a:{if(d>>>0>=1001){f=b+1|0;break a}H[i+12>>2]=0;k=$b(a,b,i+12|0);if(!k){f=b+1|0;break a}e=b+k|0;h=H[i+12>>2];if((e+h|0)!=(c|0)){f=b+1|0;break a}b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{g=H[a>>2];j=I[g+b|0]&15;switch(j|0){case 10:break a;case 8:case 9:break j;case 7:break k;case 5:case 6:break l;case 4:break m;case 3:break n;case 0:case 1:case 2:break o;case 11:break e;case 12:break f;default:break g}}f=(h+k|0)!=1?b+1|0:0;break a}if(!h){f=b+1|0;break a}if(I[e+g|0]==45){if((h|0)==1){break h}e=e+1|0}a=c>>>0<e>>>0?e:c;while(1){if((a|0)==(e|0)){break d}b=e+g|0;f=e+1|0;e=f;if(I[b|0]-58>>>0>=4294967286){continue}break}break a}if(h>>>0<=2){f=b+1|0;break a}a=I[e+g|0];if((a|0)==45){if((h|0)==3){f=b+1|0;break a}e=e+1|0;a=I[g+e|0]}if((a&255)!=48){f=b+1|0;break a}if((I[(e+g|0)+1|0]|32)!=120){f=e+2|0;break a}e=e+2|0;while(1){if(c>>>0<=e>>>0){break d}a=e+g|0;f=e+1|0;e=f;if(I[I[a|0]+31152|0]&8){continue}break}break a}if(h>>>0<=1){f=b+1|0;break a}f=I[e+g|0];if((f|0)==45){if((h|0)==2){break i}e=e+1|0;f=I[g+e|0]}if((f&255)==46){f=e+1|0;if((j|0)==5|I[g+f|0]-58>>>0<4294967286){break a}f=e+2|0;d=1;break b}d=0;if((j|0)!=5|(f&255)!=48){break c}f=e+1|0;if(e+3>>>0>c>>>0){break a}a=I[f+g|0];if((a|0)==46|(a|0)==101){break b}if((a|0)!=69){break a}break b}a=c>>>0>e>>>0?c:e;while(1){if((a|0)==(e|0)){break d}b=e+g|0;f=e+1|0;e=f;b=I[b|0];if((b|0)==39|I[b+51984|0]){continue}break}break a}d=(j|0)!=8;while(1){if(c>>>0<=e>>>0){break d}p:{q:{b=e+g|0;a=I[b|0];if((a|0)==39|I[a+51984|0]){break q}r:{if((a|0)!=34){if((a|0)==92){break r}f=e+1|0;break a}if(d){break q}f=e+1|0;break a}f=e+1|0;if(f>>>0>=c>>>0){break a}a=I[f+g|0];if(Jw(2539,a,9)){break p}if((a|0)==117){if(e+5>>>0>=c>>>0){break a}if(Bq(b+2|0)){break p}break a}if((j|0)!=9){break a}H[i+8>>2]=0;a=gm(b,c-e|0,i+8|0);if(H[i+8>>2]==629145){break a}f=(a+e|0)-1|0;break p}f=e}e=f+1|0;continue}}f=b+1|0;break a}f=b+1|0;break a}f=b+1|0;break a}h=d+1|0;b=0;while(1){if(c>>>0>e>>>0){H[i+12>>2]=0;d=$b(a,e,i+12|0);if(!d){f=e+1|0;break a}d=H[i+12>>2]+(d+e|0)|0;if(d>>>0>c>>>0){f=e+1|0;break a}if(!(b&1|(I[e+g|0]&15)-11>>>0>4294967291)){f=e+1|0;break a}f=om(a,e,d,h);if(f){break a}b=b+1|0;e=d;continue}break}f=e+1&0-(b&1);break a}d=d+1|0;while(1){if(c>>>0<=e>>>0){break d}H[i+12>>2]=0;b=$b(a,e,i+12|0);if(!b){f=e+1|0;break a}b=H[i+12>>2]+(b+e|0)|0;if(b>>>0>c>>>0){f=e+1|0;break a}f=om(a,e,b,d);e=b;if(!f){continue}break}break a}f=0;break a}f=e}a=c-1|0;j=(j|0)!=5;while(1){s:{t:{if(c>>>0>f>>>0){h=f+g|0;e=I[h|0];if(e-58>>>0>4294967285){break t}u:{if(!((e|0)==101|(e|0)==69)){if((e|0)!=46){break u}if(d&255){f=f+1|0;break a}d=1;if(j){break t}v:{if((a|0)==(f|0)){f=a;break v}e=f;if(I[h+1|0]-58>>>0>4294967285){break s}}f=f+1|0;break a}if((d&255)==2){f=f+1|0;break a}if((a|0)==(f|0)){f=c;break a}d=2;w:{e=f;h=e+1|0;switch(I[h+g|0]-43|0){case 0:case 2:break w;default:break s}}e=h;if((a|0)!=(e|0)){break s}f=f+2|0;break a}f=f+1|0;break a}f=d&255?0:b+1|0;break a}e=f}f=e+1|0;continue}}Ea=i+16|0;return f}function ah(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;g=Ea-16|0;Ea=g;j=$b(a,b,g+12|0);a:{if(!j){F[c+25|0]=I[c+25|0]|2;a=H[a+4>>2]+1|0;break a}b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{o:{p:{q:{r:{h=H[a>>2];switch(I[h+b|0]&15){case 11:break i;case 10:break j;case 9:break k;case 7:case 8:break l;case 6:break m;case 4:break n;case 3:case 5:break o;case 2:break p;case 1:break q;case 0:break r;case 12:break h;default:break g}}$c(c,11625,4);a=b+1|0;break a}$c(c,12960,4);a=b+1|0;break a}$c(c,13493,5);a=b+1|0;break a}f=H[g+12>>2];if(!f){break d}uf(c,(h+j|0)+b|0,f);break b}f=H[g+12>>2];if(!f){break d}a=2;s:{t:{u:{k=(h+j|0)+b|0;switch(I[k|0]-43|0){case 0:break t;case 2:break u;default:break s}}ic(c,45)}a=3}l=a>>>0>f>>>0?a:f;while(1){v:{if((a|0)!=(l|0)){h=I[a+k|0];if(I[h+31152|0]&8){break v}F[c+25|0]=I[c+25|0]|2}H[g>>2]=e;H[g+4>>2]=d;Sj(100,c,i?22979:1868,g);break b}w:{if(d>>>0>268435455){i=1;break w}d=d<<4|e>>>28;e=h+(h<<1<<24>>24>>>7&9)&15|e<<4}a=a+1|0;continue}}f=H[g+12>>2];if(!f){break d}a=0;e=(h+j|0)+b|0;d=I[e|0];if((d|0)==45){ic(c,45);d=I[e+1|0];a=1}if((d&255)!=46){break f}d=0;break e}ic(c,34);f=H[g+12>>2];uf(c,(H[a>>2]+j|0)+b|0,f);ic(c,34);break b}f=H[g+12>>2];ic(c,34);i=(h+j|0)+b|0;e=f;x:{while(1){a=0;if(!e){break x}y:{while(1){if((a|0)==(e|0)){break y}d=a+i|0;h=I[d|0];if(!((h|0)==34|(h|0)==92)){a=a+1|0;continue}break}z:{if(!a){d=i;break z}$c(c,i,a);e=e-a|0}if(I[d|0]==34){$c(c,29742,2);e=e-1|0;i=d+1|0;continue}if(e>>>0<=1){F[c+25|0]=I[c+25|0]|2;break x}A:{B:{C:{D:{E:{a=I[d+1|0];switch(a-10|0){case 0:break A;case 1:case 2:break B;case 3:break D;default:break E}}F:{G:{switch(a-118|0){default:if((a|0)==226){break C}if((a|0)==48){break F}if((a|0)!=39){break B}ic(c,39);break A;case 0:$c(c,23003,6);break A;case 1:break B;case 2:break G}}if(e>>>0<=3){e=2;F[c+25|0]=I[c+25|0]|2;break A}$c(c,24475,4);d=d+2|0;$c(c,d,2);e=e-2|0;break A}$c(c,24625,6);break A}if((e|0)==2){e=2;break A}a=I[d+2|0]==10;d=a?d+1|0:d;e=e-a|0;break A}if(!(!(I[d+2|0]!=128|e>>>0<4)&(I[d+3|0]&254)==168)){e=2;F[c+25|0]=I[c+25|0]|2;break A}d=d+2|0;e=e-2|0;break A}$c(c,d,2)}e=e-2|0;i=d+2|0;continue}break}$c(c,i,e)}ic(c,34);break b}f=H[g+12>>2];lm(c,(h+j|0)+b|0,f);break b}ic(c,91);d=b+j|0;f=H[g+12>>2];e=d+f|0;while(1){if(!(I[c+25|0]|d>>>0>=e>>>0)){d=ah(a,d,c);ic(c,44);continue}break}if(d>>>0>e>>>0){F[c+25|0]=I[c+25|0]|2}if(!(I[c+25|0]|!f)){a=H[c+16>>2];d=H[c+20>>2]-!a|0;a=a-1|0;H[c+16>>2]=a;H[c+20>>2]=d}ic(c,93);break b}ic(c,123);d=b+j|0;f=H[g+12>>2];i=d+f|0;while(1){if(!(I[c+25|0]|d>>>0>=i>>>0)){d=ah(a,d,c);ic(c,e&1?44:58);e=e+1|0;continue}break}if(!(!(e&1)&d>>>0<=i>>>0)){F[c+25|0]=I[c+25|0]|2}if(!(I[c+25|0]|!f)){a=H[c+16>>2];d=H[c+20>>2]-!a|0;a=a-1|0;H[c+16>>2]=a;H[c+20>>2]=d}ic(c,125);break b}f=H[g+12>>2];break c}d=1}while(1){if(!d){ic(c,48);d=1;continue}while(1){if((a|0)==(f|0)){break b}d=a+e|0;ic(c,F[d|0]);a=a+1|0;if((f|0)!=(a|0)&I[a+e|0]-58>>>0>=4294967286|I[d|0]!=46){continue}break}d=0;continue}}f=0}F[c+25|0]=I[c+25|0]|2}a=(b+j|0)+f|0}Ea=g+16|0;return a}function wo(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;f=Ea-144|0;Ea=f;H[f+136>>2]=d;H[f+140>>2]=e;H[f+132>>2]=0;z=H[a+44>>2];A=H[a+40>>2];B=H[a+32>>2];at(a);r=-1;a:{b:{if(!H[a+16>>2]){break b}if(!b){break a}p=H[a>>2];s=H[p+40>>2];if(Tn(a,b)){break a}H[a+40>>2]=b;H[a+32>>2]=30450;g=qd(p,b,f+132|0,0);if(g){H[f+96>>2]=g;Oc(a,16674,f+96|0);if((g|0)!=3082){break b}H[a+24>>2]=7;break b}i=H[f+132>>2];C=I[i|0];F[i|0]=0;g=Oh(i);if(g){H[f+80>>2]=g;Oc(a,17137,f+80|0);break b}g=Pf(i);if(g){H[f+64>>2]=g;Oc(a,10249,f- -64|0);break b}g=I[i+9|0];q=H[i+56>>2];H[a+32>>2]=30424;l=g+q|0;k=(I[l+3|0]<<8|I[l+4|0])-1|0;m=k<<1;j=I[i+8|0];y=(q+(g-(j<<2)|0)|0)+12|0;g=(I[l+6|0]|I[l+5|0]<<8)-1&65535;c:{if(!j){j=cb(l+8|0);if(I[p+17|0]){H[a+32>>2]=30479;Eg(a,j,5,b)}r=wo(a,j,f+136|0,d,e);n=0;break c}h=H[a+72>>2];H[h>>2]=0;n=1}t=m+y|0;D=g+1|0;E=s-5|0;v=s-4|0;w=1;j=k;while(1){if(!(!H[a+16>>2]|(j|0)<0)){H[a+44>>2]=j;o=I[t+1|0]|I[t|0]<<8;d:{if(!(o>>>0>g>>>0&o>>>0<=v>>>0)){H[f+40>>2]=v;H[f+36>>2]=D;H[f+32>>2]=o;Oc(a,1915,f+32|0);w=0;break d}x=o+q|0;Ia[H[i+80>>2]](i,x,f+104|0);if(o+J[f+122>>1]>>>0>s>>>0){w=0;Oc(a,14561,0);break d}if(I[i+1|0]){m=H[f+136>>2];u=H[f+140>>2];d=H[f+104>>2];e=H[f+108>>2];e:{f:{if(n){if(d>>>0>m>>>0&(e|0)>=(u|0)|(e|0)>(u|0)){break f}break e}if(d>>>0<m>>>0&(e|0)<=(u|0)|(e|0)<(u|0)){break e}}H[f+48>>2]=d;H[f+52>>2]=e;Oc(a,9644,f+48|0);d=H[f+104>>2];e=H[f+108>>2]}H[f+136>>2]=d;H[f+140>>2]=e;n=0}d=H[f+116>>2];e=J[f+120>>1];if(d>>>0>e>>>0){e=((d+E|0)-e>>>0)/(v>>>0)|0;d=cb((J[f+122>>1]+x|0)-4|0);if(I[p+17|0]){Eg(a,d,3,b)}Ut(a,0,d,e)}if(!I[i+8|0]){d=cb(x);if(I[p+17|0]){Eg(a,d,5,b)}n=0;d=wo(a,d,f+136|0,H[f+136>>2],H[f+140>>2]);if((d|0)==(r|0)){break d}Oc(a,4763,0);r=d;break d}Sn(h,(o+J[f+122>>1]|0)-1|o<<16)}t=t-2|0;j=j-1|0;continue}break}d=H[f+140>>2];H[c>>2]=H[f+136>>2];H[c+4>>2]=d;H[a+32>>2]=0;if(w){if(H[a+16>>2]<=0){break b}g:{if(I[i+8|0]){break g}h=H[a+72>>2];H[h>>2]=0;while(1){if((k|0)<0){break g}c=(k<<1)+y|0;c=I[c|0]<<8|I[c+1|0];Sn(h,((Ia[H[i+76>>2]](i,c+q|0)|0)+c|0)-1|c<<16);k=k-1|0;continue}}k=l+2|0;c=l+1|0;while(1){d=I[k|0]|I[c|0]<<8;if(d){c=d+q|0;Sn(h,(d+(I[c+2|0]<<8|I[c+3|0])|0)-1|d<<16);k=c+1|0;continue}else{j=H[h>>2];e=0;h:{i:{while(1){if(!j){break i}d=H[h+4>>2];c=(j<<2)+h|0;H[h+4>>2]=H[c>>2];H[c>>2]=-1;j=j-1|0;H[h>>2]=j;k=1;while(1){j:{c=k<<1;if(c>>>0>j>>>0){break j}n=(k<<2)+h|0;m=H[n>>2];k=c|1;k=K[(c<<2)+h>>2]>K[(k<<2)+h>>2]?k:c;c=(k<<2)+h|0;i=H[c>>2];if(m>>>0<i>>>0){break j}H[n>>2]=i;H[c>>2]=m;j=H[h>>2];continue}break}c=g&65535;g=d>>>16|0;if(c>>>0<g>>>0){e=g+((c^-1)+e|0)|0;g=d;continue}break}H[f+20>>2]=b;H[f+16>>2]=g;Oc(a,2106,f+16|0);if(!H[h>>2]){break h}break b}c=g&65535}c=((c^-1)+s|0)+e|0;d=I[l+7|0];if((c|0)==(d|0)){break b}H[f+8>>2]=b;H[f+4>>2]=d;H[f>>2]=c;Oc(a,2015,f);break b}}}F[i|0]=C}Eb(H[f+132>>2]);H[a+44>>2]=z;H[a+40>>2]=A;H[a+32>>2]=B;h=r+1|0}Ea=f+144|0;return h}function fC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;f=Ea-1088|0;Ea=f;o=d&1048320;q=d&4;k=0;a:{if(!q){break a}k=1;if((o|0)==2048){break a}k=1;if((o|0)==16384){break a}k=1;if((o|0)==524288){break a}k=0}if(H[18298]!=42){H[18298]=42;we(0,0)}h=Xa(c,0,52);b:{c:{d:{e:{if((o|0)==256){f:{if(!H[18297]){break f}if(Ia[H[16661]](b,f+16|0)|0){break f}c=73188;i=H[f+104>>2];m=H[f+108>>2];j=H[f+16>>2];while(1){l=H[c>>2];if(!l){break f}if(!((i|0)==H[l+8>>2]&(m|0)==H[l+12>>2]&(j|0)==H[l>>2])){c=l+44|0;continue}break}c=l+32|0;j=d&3;while(1){i=c;g=H[c>>2];if(!g){break f}c=g+8|0;if((j|0)!=H[g+4>>2]){continue}break}H[i>>2]=H[g+8>>2];c=H[g>>2];break e}c=-1;g=ub(12,0);if(g){break e}g=7;break b}c=-1;if(b){break d}i=f+16|0;g=eu(H[a+8>>2],i);if(g){break b}break c}H[h+28>>2]=g}i=b}p=d&1;l=d&8;g:{h:{i:{j:{k:{if((c|0)>=0){break k}H[f+1072>>2]=0;H[f+12>>2]=0;H[f+8>>2]=0;n=d&526336;l:{m:{if(n){c=bb(i);while(1){g=0;if((c|0)<2){break m}n:{c=c-1|0;switch(I[i+c|0]-45|0){case 1:break m;case 0:break n;default:continue}}break}j=f+544|0;Va(j,i,c);F[c+j|0]=0;g=_t(j,f+1072|0,f+12|0,f+8|0);break m}g=384;if(l){break l}g=0;if(!(d&64)){break l}c=Tt(i,12607);if(!c){break l}g=_t(c,f+1072|0,f+12|0,f+8|0)}if(g){break b}g=H[f+1072>>2]}m=d&2;j=m|(d<<3&128|q<<4)|131072;c=xh(i,j,g);if((c|0)<0){if(!(!k|H[18340]!=2)){n=0;p=1544;if(Ia[H[16655]](i,0)|0){break j}}n=1;p=0;if(!m|H[18340]==31){break j}c=xh(i,j&131200,g);if((c|0)<0){break j}n=d&526336;p=1;d=d&-8|1}if(!g|!n){break k}m=H[f+8>>2];j=H[f+12>>2];if(Ia[H[16712]]()|0){break k}Ia[H[16709]](c,j,m)|0}if(e){H[e>>2]=d}e=H[h+28>>2];if(e){H[e>>2]=c;H[e+4>>2]=d&3}if(l){Ia[H[16697]](i)|0}H[h+32>>2]=b;H[h+4>>2]=a;H[h+12>>2]=c;i=d&64;d=l<<2;d=p?d|2:d;d=(o|0)==256?d:d|128;e=k?d|8:d;d=i|e;G[h+18>>1]=d;if(Wk(d<<25>>31&b,1648,1)){G[h+18>>1]=J[h+18>>1]|16}if(!Tc(H[a+16>>2],11743)){G[h+18>>1]=J[h+18>>1]|1}d=32812;o:{if(e&128){break o}d=Ia[H[H[a+20>>2]>>2]](b,h)|0;if((d|0)==32736){if(Ia[H[16664]](H[h+12>>2],f+544|0)|0){a=H[18340];H[h+20>>2]=a;g=(a|0)==61?22:10;break h}H[f+1072>>2]=0;H[f+1076>>2]=0;a=H[f+636>>2];H[f+1080>>2]=H[f+632>>2];H[f+1084>>2]=a;H[f+1072>>2]=H[f+544>>2];d=73188;p:{q:{while(1){d=H[d>>2];if(d){if(!Hb(f+1072|0,d,16)){break q}d=d+44|0;continue}break}d=ub(56,0);if(!d){g=7;break h}c=Xa(d+16|0,0,40);b=f+1080|0;a=H[b+4>>2];H[d+8>>2]=H[b>>2];H[d+12>>2]=a;a=H[f+1076>>2];H[d>>2]=H[f+1072>>2];H[d+4>>2]=a;if(I[65924]){H[c>>2]=8}H[d+36>>2]=1;a=H[18297];H[d+48>>2]=0;H[d+44>>2]=a;if(a){H[a+48>>2]=d}H[18297]=d;break p}H[d+36>>2]=H[d+36>>2]+1}H[h+8>>2]=d;d=32736;break o}if((d|0)!=32888){break o}d=tb(b)+6|0;a=ub(d,d>>31);if(!a){break i}H[f>>2]=b;r=h,s=Bd(d,a,11929,f),H[r+24>>2]=s;d=32888}H[h>>2]=d;g=0;H[h+20>>2]=0;Dt(h);break b}g=(r=Id(ie(44382),11299,i,44382),s=p,t=n,t?r:s);break g}H[h+20>>2]=0;H[h+24>>2]=0;Of(h,c,43941);g=7;break g}Of(h,c,43856);H[h+20>>2]=0}Ta(H[h+28>>2])}Ea=f+1088|0;return g|0}function gi(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;e=Ea-32|0;Ea=e;t=H[b+4>>2];a:{if(!t){break a}w=I[a+239|0]?104:105;m=H[b>>2];x=(t|0)<=1?1:t;u=H[b+12>>2];c=H[u+12>>2];z=c&34;A=c&2;y=c&1;B=c&4;C=c&16;D=c&32;E=!(c&8);b:while(1){g=0;while(1){c=H[b+8>>2];if((c|0)>(g|0)){c=H[(g<<2)+m>>2];c:{if(I[c+4|0]){iq(c);break c}d=py(a,c);if(d){break a}}g=g+1|0;continue}break}fi(m,t,c,106);d=0;H[b+8>>2]=0;c=H[m>>2];if(!H[c+40>>2]){break a}i=H[c+60>>2];H[b+52>>2]=i;k=H[c+64>>2];H[b+48>>2]=k;c=H[u>>2];if(!(!c|C)){f=H[u+4>>2];if((f|0)>(i|0)|(f|0)<(i|0)&E){break a}if(Hb(k,c,f)){break a}}j=1;while(1){d:{if((j|0)==(x|0)){j=x;break d}c=H[(j<<2)+m>>2];if(!H[c+40>>2]|(i|0)!=H[c+60>>2]){break d}if(Hb(k,H[c+64>>2],i)){break d}j=j+1|0;continue}break}e:{if((j|0)!=1|z){break e}f=H[m>>2];c=H[f+56>>2];f:{g:{h:{i:{if(I[a+239|0]){if(c){break e}H[b+60>>2]=H[f+76>>2];break i}a=H[f+76>>2];H[b+60>>2]=a;if(c){break h}}H[b+56>>2]=H[f+72>>2];break g}d=my(b,H[f+72>>2],a,a>>31);H[b+56>>2]=H[b+16>>2];if(d){break f}}d=100}H[b+8>>2]=1;break a}g=0;while(1){if((g|0)!=(j|0)){ly(a,H[(g<<2)+m>>2]);g=g+1|0;continue}break}fi(m,j,j,w);k=0;n=0;h=0;while(1){j:{c=H[m>>2];if(H[c+80>>2]){H[e+12>>2]=0;H[e+8>>2]=0;f=H[c+88>>2];o=H[c+92>>2];am(a,c,e+12|0,e+8|0);g=1;while(1){if((g|0)==(j|0)){g=j;break j}i=H[(g<<2)+m>>2];if(!H[i+80>>2]|((f|0)!=H[i+88>>2]|(o|0)!=H[i+92>>2])){break j}am(a,i,0,0);g=g+1|0;continue}}if((h|0)>0){d=ky(b,h+20|0,0);if(d){break a}a=H[b+16>>2]+h|0;F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;F[a+16|0]=0;F[a+17|0]=0;F[a+18|0]=0;F[a+19|0]=0;F[a+8|0]=0;F[a+9|0]=0;F[a+10|0]=0;F[a+11|0]=0;F[a+12|0]=0;F[a+13|0]=0;F[a+14|0]=0;F[a+15|0]=0;H[b+60>>2]=h;H[b+8>>2]=j;H[b+56>>2]=H[b+16>>2];d=100;break a}H[b+8>>2]=j;continue b}if(B){jy(H[u+8>>2],0,e+12|0,e+8|0)}k:{r=H[e+8>>2];l:{if((r|0)<=0?A:0){break l}v=h>>31;m:{if(!(!I[a+239|0]|(h|0)<=0)){if((n|0)<=(o|0)&f>>>0>=k>>>0|(n|0)<(o|0)){break k}s=n-((f>>>0>k>>>0)+o|0)|0;l=k-f|0;break m}if((f>>>0<=k>>>0&(n|0)>=(o|0)|(n|0)>(o|0))&(h|0)>0){break k}s=o-((f>>>0<k>>>0)+n|0)|0;l=f-k|0}i=l;c=Rd(i,s)+(y?r+1|0:0)|0;l=c;q=c+h|0;c=(c>>31)+v|0;c=q>>>0<l>>>0?c+1|0:c;l=q+20|0;c=l>>>0<20?c+1|0:c;d=ky(b,l,c);if(d){break a}p=H[b+16>>2]+h|0;if(D){l=H[e+12>>2];H[e+28>>2]=l;q=0;d=0;n:{switch(I[l|0]-1|0){case 1:c=mc(p,i,s);F[c+p|0]=2;q=1;d=c+1|0;default:tf(0,e+28|0);break;case 0:break n}}v=l+r|0;while(1){c=H[e+28>>2];if(v>>>0>c>>>0){c=c+1|0;c=zc(c,e+16|0)+c|0;H[e+28>>2]=c;if(I[c|0]==2){if(!q){d=mc(d+p|0,i,s)+d|0}F[d+p|0]=1;c=d+1|0;c=mc(c+p|0,H[e+16>>2],H[e+20>>2])+c|0;F[c+p|0]=2;d=c+1|0;q=1}tf(0,e+28|0);continue}break}if(q){F[d+p|0]=0;d=d+1|0}k=d?f:k;n=d?o:n;h=d+h|0;break l}h=mc(p,i,s)+h|0;if(y){Va(H[b+16>>2]+h|0,H[e+12>>2],r);c=h+r|0;F[c+H[b+16>>2]|0]=0;h=c+1|0}k=f;n=o}fi(m,j,g,w);continue}break}break}d=267}Ea=e+32|0;return d}function Ce(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(!a){break a}d=a-8|0;b=H[a-4>>2];a=b&-8;f=d+a|0;b:{if(b&1){break b}if(!(b&2)){break a}b=H[d>>2];d=d-b|0;if(d>>>0<K[18345]){break a}a=a+b|0;c:{d:{e:{if(H[18346]!=(d|0)){c=H[d+12>>2];if(b>>>0<=255){e=H[d+8>>2];if((e|0)!=(c|0)){break e}i=73364,j=H[18341]&xJ(-2,b>>>3|0),H[i>>2]=j;break b}h=H[d+24>>2];if((c|0)!=(d|0)){b=H[d+8>>2];H[b+12>>2]=c;H[c+8>>2]=b;break c}e=H[d+20>>2];if(e){b=d+20|0}else{e=H[d+16>>2];if(!e){break d}b=d+16|0}while(1){g=b;c=e;b=c+20|0;e=H[c+20>>2];if(e){continue}b=c+16|0;e=H[c+16>>2];if(e){continue}break}H[g>>2]=0;break c}b=H[f+4>>2];if((b&3)!=3){break b}H[18343]=a;H[f+4>>2]=b&-2;H[d+4>>2]=a|1;H[f>>2]=a;return}H[e+12>>2]=c;H[c+8>>2]=e;break b}c=0}if(!h){break b}b=H[d+28>>2];e=(b<<2)+73668|0;f:{if(H[e>>2]==(d|0)){H[e>>2]=c;if(c){break f}i=73368,j=H[18342]&xJ(-2,b),H[i>>2]=j;break b}H[h+(H[h+16>>2]==(d|0)?16:20)>>2]=c;if(!c){break b}}H[c+24>>2]=h;b=H[d+16>>2];if(b){H[c+16>>2]=b;H[b+24>>2]=c}b=H[d+20>>2];if(!b){break b}H[c+20>>2]=b;H[b+24>>2]=c}if(d>>>0>=f>>>0){break a}b=H[f+4>>2];if(!(b&1)){break a}g:{h:{i:{j:{if(!(b&2)){if((f|0)==H[18347]){H[18347]=d;a=H[18344]+a|0;H[18344]=a;H[d+4>>2]=a|1;if(H[18346]!=(d|0)){break a}H[18343]=0;H[18346]=0;return}if((f|0)==H[18346]){H[18346]=d;a=H[18343]+a|0;H[18343]=a;H[d+4>>2]=a|1;H[a+d>>2]=a;return}a=(b&-8)+a|0;c=H[f+12>>2];if(b>>>0<=255){e=H[f+8>>2];if((e|0)==(c|0)){i=73364,j=H[18341]&xJ(-2,b>>>3|0),H[i>>2]=j;break h}H[e+12>>2]=c;H[c+8>>2]=e;break h}h=H[f+24>>2];if((c|0)!=(f|0)){b=H[f+8>>2];H[b+12>>2]=c;H[c+8>>2]=b;break i}e=H[f+20>>2];if(e){b=f+20|0}else{e=H[f+16>>2];if(!e){break j}b=f+16|0}while(1){g=b;c=e;b=c+20|0;e=H[c+20>>2];if(e){continue}b=c+16|0;e=H[c+16>>2];if(e){continue}break}H[g>>2]=0;break i}H[f+4>>2]=b&-2;H[d+4>>2]=a|1;H[a+d>>2]=a;break g}c=0}if(!h){break h}b=H[f+28>>2];e=(b<<2)+73668|0;k:{if((f|0)==H[e>>2]){H[e>>2]=c;if(c){break k}i=73368,j=H[18342]&xJ(-2,b),H[i>>2]=j;break h}H[h+((f|0)==H[h+16>>2]?16:20)>>2]=c;if(!c){break h}}H[c+24>>2]=h;b=H[f+16>>2];if(b){H[c+16>>2]=b;H[b+24>>2]=c}b=H[f+20>>2];if(!b){break h}H[c+20>>2]=b;H[b+24>>2]=c}H[d+4>>2]=a|1;H[a+d>>2]=a;if(H[18346]!=(d|0)){break g}H[18343]=a;return}if(a>>>0<=255){b=(a&-8)+73404|0;e=H[18341];a=1<<(a>>>3);l:{if(!(e&a)){H[18341]=a|e;a=b;break l}a=H[b+8>>2]}H[b+8>>2]=d;H[a+12>>2]=d;H[d+12>>2]=b;H[d+8>>2]=a;return}c=31;if(a>>>0<=16777215){b=Q(a>>>8|0);c=((a>>>38-b&1)-(b<<1)|0)+62|0}H[d+28>>2]=c;H[d+16>>2]=0;H[d+20>>2]=0;g=(c<<2)+73668|0;m:{n:{b=H[18342];e=1<<c;o:{if(!(b&e)){H[18342]=b|e;c=24;b=g;break o}c=a<<((c|0)!=31?25-(c>>>1|0)|0:0);b=H[g>>2];while(1){e=b;if((H[b+4>>2]&-8)==(a|0)){break n}b=c>>>29|0;c=c<<1;g=((b&4)+e|0)+16|0;b=H[g>>2];if(b){continue}break}c=24;b=e}e=d;f=d;a=8;break m}b=H[e+8>>2];H[b+12>>2]=d;c=8;g=e+8|0;f=0;a=24}H[g>>2]=d;H[c+d>>2]=b;H[d+12>>2]=e;H[a+d>>2]=f;a=H[18349]-1|0;H[18349]=a?a:-1}}function Su(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0;f=Ea-80|0;Ea=f;c=hl(a,0,f+16|0);a:{if(c){if((c|0)!=1288){break a}F[a+43|0]=2;F[a+50|0]=1;H[b>>2]=1}b:{c:{d:{e:{if(H[f+16>>2]){if(!Qu(a,b)){break e}}if(!(I[a+50|0]|!(I[a+46|0]&2))){c=Mh(a,0);if(c){break d}Kg(a,0);c=264;if(!I[a+50|0]){break a}break c}o=I[a+44|0];if(!o){c=Vf(a,0,1);if(c){break d}}F[a+44|0]=1;c=hl(a,0,f+16|0);d=0;f:{if(c){break f}if(!Qu(a,b)){c=0;d=1;break f}d=I[a+45|0];p=d+1|0;q=2-d|0;c=Vf(a,p,q);if(!c){Xa(a+52|0,0,48);d=H[a+8>>2];c=Ia[H[H[d>>2]+24>>2]](d,f+72|0)|0;g:{if(c){break g}d=H[f+72>>2];h:{e=H[f+76>>2];if((e|0)<0){c=1}else{c=d>>>0<33&(e|0)<=0}if(c){break h}d=H[a+8>>2];h=f+32|0;c=Ia[H[H[d>>2]+8>>2]](d,h,32,0,0)|0;if(c){break g}e=I[f+35|0];if((e&254|(I[f+33|0]<<16|I[f+32|0]<<24|I[f+34|0]<<8))!=931071618){break h}k=I[f+42|0]<<8;c=I[f+41|0]<<16|I[f+40|0]<<24;d=k|(c|I[f+43|0]);if(d-1&d|d-65537>>>0<4294902271){break h}H[a+36>>2]=d;g=e&1;F[a+65|0]=g;e=H[f+44>>2];H[a+112>>2]=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);e=H[f+52>>2];H[a+84>>2]=H[f+48>>2];H[a+88>>2]=e;Uf(!g,h,24,0,a+76|0);e=H[f+56>>2];if(H[a+76>>2]!=(e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24))){break h}e=H[f+60>>2];if(H[a+80>>2]!=(e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24))){break h}e=H[f+36>>2];if((e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24))!=3007e3){c=ie(65977);break g}g=ub(d+32792|0,0);if(!g){c=7;break g}w=k|c>>>16;r=g+24|0;s=d+r|0;e=H[f+72>>2];h=d+24|0;k=tJ(e-32|0,H[f+76>>2]-(e>>>0<32)|0,h,0);x=(k+33>>>12|0)+1|0;c=0;while(1){i:{if((j|0)==(x|0)){break i}c=hl(a,j,f+28|0);n=H[f+28>>2];if(!n){break i}t=j<<2;H[t+H[a+32>>2]>>2]=s;e=j<<12;d=e|4062;y=d>>>0<k>>>0?d:k;d=j?e-33|0:1;e=0;while(1){j:{u=!e&d>>>0>y>>>0|(e|0)!=0;if(u){break j}v=H[a+8>>2];c=h;l=sJ(d-1|0,e-!d|0,c,0);m=Ha;l=l+32|0;m=l>>>0<32?m+1|0:m;c=Ia[H[H[v>>2]+8>>2]](v,g,c,l,m)|0;if(c){break j}if(!Ru(a,f+24|0,f+20|0,r,g)){c=0;break j}c=Vo(a,d,H[f+24>>2]);if(c){break j}c=H[f+20>>2];if(c){H[a+72>>2]=c;H[a+68>>2]=d;G[a+66>>1]=w;z=H[a+80>>2];i=H[a+76>>2]}d=d+1|0;e=d?e:e+1|0;c=0;continue}break}H[t+H[a+32>>2]>>2]=n;d=j?0:136;Va(d+n|0,d+s|0,32768-d|0);if(!u){break i}j=j+1|0;continue}break}Ta(g);if(c){break g}break h}H[a+80>>2]=z;H[a+76>>2]=i;Uo(a);c=0;d=H[H[a+32>>2]>>2];H[d+96>>2]=0;H[d+128>>2]=H[a+68>>2];H[d+100>>2]=0;e=d+100|0;i=1;while(1){if((i|0)!=5){h=i+3|0;c=Vf(a,h,1);if((c|0)!=5){if(c){break g}k:{l:{if((i|0)!=1){break l}g=H[a+68>>2];if(!g){break l}H[d+104>>2]=g;break k}H[e+(i<<2)>>2]=-1}xe(a,h,1)}i=i+1|0;continue}break}if(!H[a+72>>2]){break g}d=H[a+68>>2];H[f+4>>2]=H[a+108>>2];H[f>>2]=d;Ec(283,6973,f)}xe(a,p,q)}H[b>>2]=1;d=0}if(!o){F[a+44|0]=0;xe(a,0,1)}if(!d){break d}}if(H[a+52>>2]==3007e3){break d}c=ie(67231)}if(!I[a+50|0]){break a}if(c){break c}c=0;break b}Po(a,0);F[a+50|0]=0;c=(c|0)==522?-1:c}F[a+43|0]=0}Ea=f+80|0;return c}function vy(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;n=Ea-32|0;Ea=n;a:{b:{if((d|0)>=0){H[n+16>>2]=0;k=Lb(a,12,n+16|0,0);j=H[n+16>>2];if(k){break b}k=H[a+260>>2];k=sJ(k,k>>31,b,b>>31);b=k+c|0;c=Ha+(c>>31)|0;q=d;d=(b>>>0<k>>>0?c+1|0:c)<<10|b>>>22;c=b<<10;k=q+c|0;b=d;Cb(j,1,k,c>>>0>k>>>0?b+1|0:b);k=0;break b}j=H[a+264>>2];c:{if(!j|H[a+288>>2]!=(b|0)){break c}s=4;j=(j+N(c,24)|0)+4|0;d:{e:{f:{t=g|h;g:{if(t){j=j+8|0;s=0;while(1){j=H[j>>2];H[n+16>>2]=j;h:{if(j){if(f){if(H[j+16>>2]<(f|0)){continue}if(Hb(H[j+12>>2],e,f)){continue}}if((m|0)!=(s|0)){k=q;break h}m=m+16|0;k=Fc(q,m<<2,0);if(k){break h}break f}if(s>>>0>=2){m=q;l=Ea-208|0;Ea=l;H[l+8>>2]=1;H[l+12>>2]=0;r=s<<2;i:{if(!r){break i}H[l+16>>2]=4;H[l+20>>2]=4;j=4;o=4;p=2;while(1){k=j;j=(o+4|0)+j|0;H[(l+16|0)+(p<<2)>>2]=j;p=p+1|0;o=k;if(j>>>0<r>>>0){continue}break}r=(m+r|0)-4|0;j:{if(r>>>0<=m>>>0){p=1;j=1;k=0;break j}p=1;j=1;while(1){k:{if((p&3)==3){xp(m,j,l+16|0);Jl(l+8|0,2);j=j+2|0;break k}k=l+16|0;o=j-1|0;l:{if(K[k+(o<<2)>>2]>=r-m>>>0){Il(m,p,H[l+12>>2],j,0,k);break l}xp(m,j,l+16|0)}if((j|0)==1){Hl(l+8|0,1);j=0;break k}Hl(l+8|0,o);j=1}p=H[l+8>>2]|1;H[l+8>>2]=p;m=m+4|0;if(r>>>0>m>>>0){continue}break}k=H[l+12>>2]}Il(m,p,k,j,0,l+16|0);o=H[l+12>>2];p=H[l+8>>2];if(!(o|((j|0)!=1|(p|0)!=1))){break i}while(1){m:{if((j|0)<=1){k=Iw(p,o);Jl(l+8|0,k);k=j+k|0;break m}p=l+8|0;Hl(p,2);H[l+8>>2]=H[l+8>>2]^7;Jl(p,1);o=m-4|0;r=l+16|0;k=j-2|0;Il(o-H[r+(k<<2)>>2]|0,H[l+8>>2],H[l+12>>2],j-1|0,1,r);Hl(p,1);j=H[l+8>>2]|1;H[l+8>>2]=j;Il(o,j,H[l+12>>2],k,1,r)}j=k;m=m-4|0;o=H[l+12>>2];p=H[l+8>>2];if(o|((j|0)!=1|(p|0)!=1)){continue}break}}Ea=l+208|0;s=s<<2;break g}m=1;k=0;if((s|0)!=1){break e}s=4;break g}H[(s<<2)+k>>2]=j;s=s+1|0;j=H[n+16>>2];q=k;continue}}j=sy(j,e,f);H[n+16>>2]=j;if(!j){break c}q=n+16|0}o=s+100|0;j=ub(o,0);if(!j){break f}k=0;m=Xa(j,0,o);o=m+96|0;H[m+56>>2]=o;H[m>>2]=2147483647;Va(o,q,s);m=1;break d}m=0;k=7}j=0}if(t){Ta(q)}if(!j|m^1){break c}k=ry(i,j)}j=0;if((d|0)==-1){break a}if(k){break b}k=0;H[n+16>>2]=0;d=Lb(a,13,n+16|0,0);j=H[n+16>>2];if(d){k=d;break b}q=c;t=b>>31;d=H[a+260>>2];m=sJ(b,t,d,d>>31);d=m+c|0;o=c>>31;r=o+Ha|0;c=d;d=(c>>>0<m>>>0?r+1|0:r)<<10|c>>>22;Cb(j,1,c<<10,d);c=H[a+260>>2];b=sJ(c,c>>31,b,t);c=o+Ha|0;b=b+q|0;c=b>>>0<q>>>0?c+1|0:c;Cb(j,2,b<<10|1023,c<<10|b>>>22)}o=g?n+8|0:0;q=g|h;h=!q;while(1){if(k){break a}k=vb(j);if((k|0)!=100){break a}H[n+28>>2]=0;u=n,v=Xc(j,1),H[u+16>>2]=v;H[n+20>>2]=Ha;u=n,v=Xc(j,2),H[u+8>>2]=v;H[n+12>>2]=Ha;c=Xc(j,3);g=Ha;m=Nd(j,4);t=Ue(j,4);b=H[n+16>>2];d=H[n+20>>2];n:{if(!t|(!e|!(b|d))){break n}k=kq(a,e,f,t,m,n+16|0,o);if(k){break a}b=H[n+16>>2];d=H[n+20>>2];if(q){break n}H[n+8>>2]=b;H[n+12>>2]=d}k=qy(H[i+4>>2]+1|0,h,b,d,H[n+8>>2],H[n+12>>2],c,g,t,m,n+28|0);if(k){break a}k=ry(i,H[n+28>>2]);continue}}a=ob(j);Ea=n+32|0;return(k|0)==101?a:k}function Lo(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=Ea-48|0;Ea=f;e=H[a>>2];H[f+16>>2]=0;H[f+12>>2]=1;H[f+8>>2]=H[a+168>>2];a:{b:{c=H[a+68>>2];c=Ia[H[H[c>>2]+24>>2]](c,f+24|0)|0;if(c){break b}d=H[a+224>>2];c=Ko(H[a+68>>2],d,H[H[a>>2]+8>>2]+1|0);c:{if(c){break c}if(!I[d|0]){c=0;break c}c=Ia[H[e+32>>2]](e,d,0,f+12|0)|0}d:{e:{if(!H[f+12>>2]|c){break e}H[a+80>>2]=0;H[a+84>>2]=0;j=a+80|0;i=b;f:while(1){c=Ju(a,b,H[f+24>>2],H[f+28>>2],f+20|0,f+16|0);if(c){if((c|0)==101){break d}break b}c=H[a+156>>2];e=H[f+20>>2];if((e|0)==-1){e=H[f+24>>2];g=e-c|0;e=H[f+28>>2]-(c>>>0>e>>>0)|0;d=H[a+172>>2];h=H[a+168>>2]+8|0;d=h>>>0<8?d+1|0:d;e=tJ(g,e,h,d);H[f+20>>2]=e}d=H[j>>2];g=H[j+4>>2];g:{if(b|e){break g}h=H[a+92>>2];k=H[a+88>>2];l=k+c|0;if((d|0)!=(l|0)|(g|0)!=((k>>>0>l>>>0?h+1|0:h)|0)){break g}e=H[f+24>>2];h=e-d|0;l=H[f+28>>2]-((d>>>0>e>>>0)+g|0)|0;e=H[a+172>>2];k=H[a+168>>2]+8|0;e=k>>>0<8?e+1|0:e;e=tJ(h,l,k,e);H[f+20>>2]=e}h:{if((c|0)!=(d|0)|g){break h}d=H[f+16>>2];c=fq(a,d);if(c){break b}H[a+28>>2]=d;if(d>>>0<=K[a+160>>2]){break h}H[a+160>>2]=d}d=e+m|0;g=0;while(1){if((e|0)==(g|0)){m=d;continue f}if(i){Lg(a)}i:{c=el(a,j,0,1,0);if(c){if((c|0)==101){break i}if((c|0)==522){break d}break e}g=g+1|0;m=m+1|0;i=0;continue}break}c=H[f+28>>2];H[j>>2]=H[f+24>>2];H[j+4>>2]=c;i=0;continue}}if(c){break b}}c=Rh(a,f+8|0,-1);F[a+19|0]=I[a+12|0];if(c){break a}l=H[a+224>>2]+4|0;c=Ko(H[a+68>>2],l,H[H[a>>2]+8>>2]+1|0);if(c){break a}if((I[a+17|0]-4&255)>>>0<=252){c=Iq(a,0);if(c){break a}}c=Pj(a,I[l|0]!=0,0);if(c){break a}if(!(!I[l|0]|!H[f+12>>2])){e=0;c=H[a+224>>2];F[c|0]=0;F[c+1|0]=0;F[c+2|0]=0;F[c+3|0]=0;c=7;h=H[a>>2];d=H[h+4>>2]<<1;g=td(d,d>>31);j:{if(!g){break j}d=Ia[H[h+24>>2]](h,l,g,16385,0)|0;if(d){c=d;break j}j=H[h+4>>2];d=Ia[H[H[g>>2]+24>>2]](g,f+40|0)|0;if(d){c=d;break j}n=H[h+8>>2]+1|0;d=H[f+44>>2]+(n>>31)|0;i=n+H[f+40>>2]|0;d=i>>>0<n>>>0?d+1|0:d;i=i+6|0;d=i>>>0<6?d+1|0:d;d=bc(i,d);if(!d){break j}F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;k:{i=d+4|0;e=H[f+40>>2];c=Ia[H[H[g>>2]+8>>2]](g,i,e,0,0)|0;l:{if(c){break l}k=g+j|0;p=(e+i|0)+2|0;F[i+H[f+40>>2]|0]=0;F[(i+H[f+40>>2]|0)+1|0]=0;e=i;while(1){c=e-i|0;o=c>>>0<K[f+40>>2];j=H[f+44>>2];c=c>>31;if(o&(j|0)>=(c|0)|(c|0)<(j|0)){c=Ia[H[h+32>>2]](h,e,0,f+36|0)|0;if(c){break l}m:{if(!H[f+36>>2]){break m}j=Ia[H[h+24>>2]](h,e,k,16385,0)|0;if(j){break k}j=Ko(k,p,n);o=H[k>>2];if(o){Ia[H[o+4>>2]](k)|0;H[k>>2]=0}if(j){break k}if(!I[p|0]){break m}if(!Tc(p,l)){break l}}e=(bb(e)+e|0)+1|0;continue}break}c=H[g>>2];if(c){Ia[H[c+4>>2]](g)|0;H[g>>2]=0}c=H[h+28>>2];if(!c){c=0;break l}c=Ia[c|0](h,l,0)|0}e=d;break j}e=d;c=j}Ta(e);if(!g){break a}e=H[g>>2];if(e){Ia[H[e+4>>2]](g)|0;H[g>>2]=0}Ta(g);break a}c=0;break a}F[a+19|0]=I[a+12|0]}if(!(!b|!m)){H[f+4>>2]=H[a+188>>2];H[f>>2]=m;Ec(539,6754,f)}Zo(a);Ea=f+48|0;return c}function Pm(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;q=Ea-32|0;Ea=q;m=wb(a);p=H[a+40>>2];H[a+40>>2]=p+1;a:{if(!d){d=0;break a}if(!(I[b+5|0]&16)){break a}g=H[H[b+20>>2]+28>>2];r=H[g>>2];k=(r|0)>0?r:0;o=g+8|0;while(1){b:{if((h|0)!=(k|0)){if(!af(H[o+(h<<4)>>2])){break b}}else{h=k}d=(h|0)!=(r|0)?d:0;break a}h=h+1|0;continue}}w=c&4;c:{d:{if(H[a+36>>2]|(H[b+4>>2]&4160)!=4096){break d}k=H[b+20>>2];if(H[k+52>>2]|I[k+4|0]&9|(H[k+60>>2]|H[k+36>>2])){break d}g=H[k+32>>2];if(H[g>>2]!=1|H[g+28>>2]){break d}h=H[g+24>>2];if(I[h+43|0]==1){break d}g=H[k+28>>2];n=H[g>>2];x=(n|0)>0?n:0;s=g+8|0;while(1){if((j|0)!=(x|0)){g=j<<4;j=j+1|0;if(I[H[g+s>>2]]==167){continue}break d}break}if(!k){break d}t=Fb(H[a>>2],H[h+60>>2]);ld(a,t);wd(a,t,H[h+20>>2],0,H[h>>2]);if(!((n|0)!=1|G[H[s>>2]+32>>1]>=0)){c=Mb(m,15);Hd(a,p,t,h,112);H[q>>2]=H[h>>2];gc(a,0,19392,q);a=H[m+108>>2];H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(c,20)|0)+8>>2]=a;i=1;break c}j=1;while(1){if(!(!(j&1)|(i|0)>=(n|0))){k=tg(H[b+12>>2],i);j=68;g=G[H[(i<<4)+s>>2]+32>>1];if(!((g|0)<0|(g|0)>=G[h+34>>1])){j=I[(H[h+4>>2]+N(g,12)|0)+5|0]}g=j<<24>>24;j=(g|0)>66|(ug(k,g)-65&255)>>>0<2;i=i+1|0;continue}break}if(!(j&1)){break d}j=h+8|0;g=n&31;if((n&63)>>>0>=32){k=-1<<g;h=0}else{h=(1<<g)-1&-1>>>32-g;g=-1<<g;k=h|g;h=g}r=h;i=0;while(1){l=H[j>>2];if(!(!l|i)){i=0;g=J[l+52>>1];e:{if(H[l+36>>2]|((g|0)<(n|0)|g>>>0>62)){break e}f:{if(!w){break f}if(J[l+50>>1]>(n|0)){break e}if(g>>>0<=n>>>0){break f}if(!I[l+54|0]){break e}}j=0;u=0;v=0;while(1){g:{if((j|0)==(x|0)){break g}i=0;g=tg(H[b+12>>2],j);h=H[(j<<4)+s>>2];o=Zf(a,g,h);while(1){g=(i|0)==(n|0);if(g){break g}h:{if(J[H[l+4>>2]+(i<<1)>>1]==J[h+32>>1]){if(!o){break h}if(!ab(H[o>>2],H[H[l+32>>2]+(i<<2)>>2])){break h}}i=i+1|0;continue}break}if(g){break g}h=i&31;if((i&63)>>>0>=32){g=1<<h;h=0}else{o=1<<h;g=o-1&1>>>32-h;h=o}if(u&h|g&v){break g}if(e){H[(j<<2)+e>>2]=i}u=h|u;v=g|v;j=j+1|0;continue}break}i=0;if(((r^u)&(k^v))!=-1){break e}o=Mb(m,15);H[q+16>>2]=H[l>>2];gc(a,0,19361,q+16|0);Ua(m,112,p,H[l+44>>2],t);Ed(a,l);h=I[H[l+28>>2]];i:{if(!d){break i}g=H[a+44>>2]+1|0;H[a+44>>2]=g;H[d>>2]=g;if((n|0)!=1){break i}JA(m,p,g)}g=H[m+108>>2];i=h+3|0;H[(I[H[m>>2]+87|0]?73336:H[m+104>>2]+N(o,20)|0)+8>>2]=g}j=l+20|0;continue}break}if(i){break c}}j:{if(!(c&1)|I[b+5|0]&16){break j}g=H[b+12>>2];H[b+12>>2]=0;c=ge(b);H[b+12>>2]=g;if(H[H[b+20>>2]>>2]>2?c:0){break j}p=-1;H[a+40>>2]=H[a+40>>2]-1;i=5;break c}c=J[a+156>>1];k:{if(w){h=0;G[a+156>>1]=0;break k}if(!d){h=0;break k}h=H[a+44>>2]+1|0;H[a+44>>2]=h;H[d>>2]=h}IA(a,b,p);if(h){JA(m,p,h)}G[a+156>>1]=c;i=2}l:{if(!e|i-5>>>0>4294967293){break l}h=0;a=Qc(H[b+12>>2]);a=(a|0)>0?a:0;while(1){if((a|0)==(h|0)){break l}H[(h<<2)+e>>2]=h;h=h+1|0;continue}}H[f>>2]=p;Ea=q+32|0;return i}function Ml(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=a+b|0;c=H[a+4>>2];a:{b:{if(c&1){break b}if(!(c&2)){break a}c=H[a>>2];b=c+b|0;c:{d:{e:{a=a-c|0;if((a|0)!=H[18346]){d=H[a+12>>2];if(c>>>0<=255){e=H[a+8>>2];if((e|0)!=(d|0)){break e}i=73364,j=H[18341]&xJ(-2,c>>>3|0),H[i>>2]=j;break b}g=H[a+24>>2];if((a|0)!=(d|0)){c=H[a+8>>2];H[c+12>>2]=d;H[d+8>>2]=c;break c}e=H[a+20>>2];if(e){c=a+20|0}else{e=H[a+16>>2];if(!e){break d}c=a+16|0}while(1){h=c;d=e;c=d+20|0;e=H[d+20>>2];if(e){continue}c=d+16|0;e=H[d+16>>2];if(e){continue}break}H[h>>2]=0;break c}c=H[f+4>>2];if((c&3)!=3){break b}H[18343]=b;H[f+4>>2]=c&-2;H[a+4>>2]=b|1;H[f>>2]=b;return}H[e+12>>2]=d;H[d+8>>2]=e;break b}d=0}if(!g){break b}c=H[a+28>>2];e=(c<<2)+73668|0;f:{if(H[e>>2]==(a|0)){H[e>>2]=d;if(d){break f}i=73368,j=H[18342]&xJ(-2,c),H[i>>2]=j;break b}H[g+(H[g+16>>2]==(a|0)?16:20)>>2]=d;if(!d){break b}}H[d+24>>2]=g;c=H[a+16>>2];if(c){H[d+16>>2]=c;H[c+24>>2]=d}c=H[a+20>>2];if(!c){break b}H[d+20>>2]=c;H[c+24>>2]=d}g:{h:{i:{j:{c=H[f+4>>2];if(!(c&2)){if(H[18347]==(f|0)){H[18347]=a;b=H[18344]+b|0;H[18344]=b;H[a+4>>2]=b|1;if(H[18346]!=(a|0)){break a}H[18343]=0;H[18346]=0;return}if(H[18346]==(f|0)){H[18346]=a;b=H[18343]+b|0;H[18343]=b;H[a+4>>2]=b|1;H[a+b>>2]=b;return}b=(c&-8)+b|0;d=H[f+12>>2];if(c>>>0<=255){e=H[f+8>>2];if((e|0)==(d|0)){i=73364,j=H[18341]&xJ(-2,c>>>3|0),H[i>>2]=j;break h}H[e+12>>2]=d;H[d+8>>2]=e;break h}g=H[f+24>>2];if((d|0)!=(f|0)){c=H[f+8>>2];H[c+12>>2]=d;H[d+8>>2]=c;break i}e=H[f+20>>2];if(e){c=f+20|0}else{e=H[f+16>>2];if(!e){break j}c=f+16|0}while(1){h=c;d=e;c=d+20|0;e=H[d+20>>2];if(e){continue}c=d+16|0;e=H[d+16>>2];if(e){continue}break}H[h>>2]=0;break i}H[f+4>>2]=c&-2;H[a+4>>2]=b|1;H[a+b>>2]=b;break g}d=0}if(!g){break h}c=H[f+28>>2];e=(c<<2)+73668|0;k:{if(H[e>>2]==(f|0)){H[e>>2]=d;if(d){break k}i=73368,j=H[18342]&xJ(-2,c),H[i>>2]=j;break h}H[g+(H[g+16>>2]==(f|0)?16:20)>>2]=d;if(!d){break h}}H[d+24>>2]=g;c=H[f+16>>2];if(c){H[d+16>>2]=c;H[c+24>>2]=d}c=H[f+20>>2];if(!c){break h}H[d+20>>2]=c;H[c+24>>2]=d}H[a+4>>2]=b|1;H[a+b>>2]=b;if(H[18346]!=(a|0)){break g}H[18343]=b;return}if(b>>>0<=255){c=(b&-8)+73404|0;d=H[18341];b=1<<(b>>>3);l:{if(!(d&b)){H[18341]=b|d;b=c;break l}b=H[c+8>>2]}H[c+8>>2]=a;H[b+12>>2]=a;H[a+12>>2]=c;H[a+8>>2]=b;return}d=31;if(b>>>0<=16777215){c=Q(b>>>8|0);d=((b>>>38-c&1)-(c<<1)|0)+62|0}H[a+28>>2]=d;H[a+16>>2]=0;H[a+20>>2]=0;c=(d<<2)+73668|0;m:{e=H[18342];h=1<<d;n:{if(!(e&h)){H[18342]=e|h;H[c>>2]=a;H[a+24>>2]=c;break n}d=b<<((d|0)!=31?25-(d>>>1|0)|0:0);c=H[c>>2];while(1){e=c;if((H[c+4>>2]&-8)==(b|0)){break m}c=d>>>29|0;d=d<<1;h=e+(c&4)|0;c=H[h+16>>2];if(c){continue}break}H[h+16>>2]=a;H[a+24>>2]=e}H[a+12>>2]=a;H[a+8>>2]=a;return}b=H[e+8>>2];H[b+12>>2]=a;H[e+8>>2]=a;H[a+24>>2]=0;H[a+12>>2]=e;H[a+8>>2]=b}}function Yg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=Ea-16|0;Ea=g;d=1;a:{if(H[c>>2]){break a}b:{c:{switch(H[b>>2]-1|0){case 0:case 2:if(!Yg(a,H[b+12>>2],c)){break b}if(!Yg(a,H[b+16>>2],c)){break b}if(H[c>>2]|H[b>>2]!=1){break a}f=H[b+8>>2];if(H[f>>2]==1?f:0){break a}d=b;while(1){f=H[d+12>>2];if(f){d=H[H[H[d+16>>2]+20>>2]+32>>2];e=d;h=e+h|0;d=(e>>31)+j|0;j=h>>>0<e>>>0?d+1|0:d;d=f;continue}break};f=H[H[d+20>>2]+32>>2];h=f+h|0;j=(f>>31)+j|0;j=ub(h<<1,(h>>>0<f>>>0?j+1|0:j)<<1|h>>>31);if(!j){H[c>>2]=7;Ta(0);break b}c=H[d+20>>2];H[g+8>>2]=H[c+28>>2];H[g+4>>2]=H[c+64>>2];h=1;while(1){d:{if(!h){break d}d=H[d+8>>2];if(!d|H[d>>2]!=1){break d}h=tx(H[d+4>>2],j,g+8|0,g+4|0,H[H[d+16>>2]+20>>2]);continue}break};c=H[H[b+16>>2]+20>>2];H[g+8>>2]=H[c+28>>2];H[g+4>>2]=H[c+64>>2];c=b;while(1){c=H[c+12>>2];if(!(!c|!h)){h=tx(H[H[c+8>>2]+4>>2],j,g+8|0,g+4|0,H[(H[c>>2]==1?H[c+16>>2]:c)+20>>2]);continue}break};Ta(j);if(!h){break b}d=1;break a;case 3:d=(Yg(a,H[b+12>>2],c)|Yg(a,H[b+16>>2],c))!=0;break a;case 1:if(!Yg(a,H[b+12>>2],c)){d=0;break a}d=!Yg(a,H[b+16>>2],c);break a;default:break c}}e:{f:{g:{if(!H[a+28>>2]){break g}if(I[b+34|0]){break f}if(H[b+24>>2]!=H[a+32>>2]|H[b+28>>2]!=H[a+36>>2]){break g}e=H[b+20>>2];if(H[e+28>>2]){break e}}d=0;if(I[b+32|0]|(H[b+24>>2]!=H[a+32>>2]|H[b+28>>2]!=H[a+36>>2])){break a}d=H[H[b+20>>2]+32>>2]>0;break a}e=H[b+20>>2];di(e)}l=H[e+24>>2]?H[e+28>>2]:l;m=e+72|0;j=-1;d=0;h:{i:{j:{k:{while(1){if(H[e+64>>2]>(d|0)){f=H[(m+N(d,24)|0)+16>>2];if(f){l:{i=H[f+12>>2];if(i){i=H[i>>2];n=ub(i,i>>31);if(n){break l}break i}Ta(h);Ta(l);H[e+28>>2]=0;H[e+32>>2]=0;d=0;break h}o=g+8|0;k=zc(H[H[f+12>>2]+4>>2],o);f=H[f+12>>2];i=H[f>>2]-k|0;f=Va(n,k+H[f+4>>2]|0,i);if(h){H[g+8>>2]=f;H[g+4>>2]=h;H[g>>2]=f;ci(o,d-j|0,0,1,g+4|0,g);Ta(h);i=H[g+8>>2]-f|0;if(!i){break k}}j=d;h=f}d=d+1|0;continue}break}d=0;m:{if((j|0)<0){break m}f=H[e+44>>2];if((f|0)<0){H[e+32>>2]=i;H[e+28>>2]=h;h=H[a+32>>2];j=H[a+36>>2];H[e+24>>2]=1;H[e+16>>2]=h;H[e+20>>2]=j;break m}m=H[e+28>>2];k=f>>>0>j>>>0;H[g+4>>2]=k?m:h;H[g+8>>2]=k?h:m;i=i+8|0;i=He(i,i>>31);H[g>>2]=i;if(!i){break j}H[e+28>>2]=i;i=0;n:{if(ci(g,k?f-j|0:j-f|0,0,1,g+8|0,g+4|0)){H[e+24>>2]=1;i=H[g>>2]-H[e+28>>2]|0;break n}Ta(H[g>>2]);H[e+28>>2]=0}H[e+32>>2]=i;Ta(h)}if(H[e+28>>2]==(l|0)){break h}Ta(l);break h}Ta(f);Ta(l);H[e+28>>2]=0;H[e+32>>2]=0;d=0;break h}Ta(h)}d=7}H[c>>2]=d;c=H[e+28>>2];d=H[a+36>>2];H[b+24>>2]=H[a+32>>2];H[b+28>>2]=d;d=(c|0)!=0;break a}d=0;if(H[b>>2]!=1){break a}c=H[b+8>>2];if(H[c>>2]==1?c:0){break a}while(1){c=H[b+20>>2];if(!c){c=H[b+16>>2];if(H[c+24>>2]==H[a+32>>2]&H[c+28>>2]==H[a+36>>2]){di(H[c+20>>2])}b=H[b+12>>2];continue}break}if(H[b+24>>2]!=H[a+32>>2]|H[b+28>>2]!=H[a+36>>2]){break a}di(c)}Ea=g+16|0;return d}function Pl(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=Ea-48|0;Ea=e;g=H[a>>2];o=H[b+20>>2];H[d>>2]=0;j=H[o+68>>2];a:{if((j|0)!=(c|0)&(j|0)<H[g+24>>2]){break a}h=H[b+28>>2];i=h;j=H[b+24>>2];H[e+16>>2]=j;H[e+20>>2]=h;h=H[o+28>>2];H[e+28>>2]=h;b:{if(!I[b+32|0]&((j|0)==H[a+32>>2]&(i|0)==H[a+36>>2])){break b}H[e+12>>2]=0;n=I[g+239|0];h=0;j=b;while(1){b=H[b+8>>2];if(b){h=I[b+32|0]?1:h;g=H[b>>2];j=(g|0)==1?b:j;f=(g|0)==4?1:f;continue}break}if(!f){f=0;break a}b=j;while(1){if(I[b+34|0]){b=H[b+8>>2];continue}break}c:{if(!H[o+40>>2]){break c}g=I[b+32|0];Ol(a,b,e+12|0);d:{while(1){f=H[e+12>>2];if(f){break a}f=I[b+32|0];if(f){break d}rd(a,b,e+12|0);if(H[b+24>>2]!=H[e+16>>2]|H[b+28>>2]!=H[e+20>>2]|g){continue}break}f=H[e+12>>2];if(f){break a}f=I[b+32|0]}if((g|0)==(f&255)){break c}f=267;break a}e:{if(!(h&255)){break e}while(1){if(I[b+32|0]){break e}rd(a,b,e+12|0);f=H[e+12>>2];if(!f){continue}break}break a}h=1;while(1){f:{if(j){i=H[(H[j>>2]==1?H[j+16>>2]:j)+20>>2];b=H[i+48>>2];H[e+28>>2]=b;f=H[i+60>>2];H[e+16>>2]=H[i+56>>2];H[e+20>>2]=f;f=H[i+4>>2];g:{if(I[a+52|0]==(n|0)){if(!f){f=0;break g}k=f+H[i>>2]>>>0<=b>>>0;f=1;break g}g=1;h:{if(!f){break h}g=0;if(!b){break h}g=K[i>>2]>=b>>>0}F[e+44|0]=g;while(1){i:{if(b){k=I[e+44|0];f=H[e+16>>2];g=H[a+32>>2];m=H[e+20>>2];l=H[a+36>>2];if(k|((n?f>>>0<g>>>0&(m|0)<=(l|0)|(l|0)>(m|0):(l|0)<=(m|0)&f>>>0>g>>>0|(l|0)<(m|0))|0)!=1){break f}break i}k=I[e+44|0];if(!k){break i}b=0;break f}$l(n,H[i>>2],H[i+4>>2],e+28|0,e+16|0,e+32|0,e+44|0);b=H[e+28>>2];continue}}while(1){j:{if(!f){k=1;break j}k:{l:{m:{n:{if(b){f=H[e+16>>2];g=H[a+32>>2];m=H[e+20>>2];l=H[a+36>>2];g=(l|0)<=(m|0)&f>>>0>g>>>0|(l|0)<(m|0)?1:(f|0)!=(g|0)|(m|0)!=(l|0)?-1:0;if(((n?0-g|0:g)|0)>=0|k){break l}g=H[i+4>>2];l=H[i>>2];H[e+44>>2]=b;qe(0,e+44|0);g=g+l|0;b=H[e+44>>2];while(1){if(b>>>0>=g>>>0){break k}if(I[b|0]){break n}b=b+1|0;continue}}if(k){break l}b=H[i>>2];b=zc(b,e+16|0)+b|0;break m}l=zc(b,e+32|0);g=H[e+32>>2];p=n?0-g|0:g;k=p+f|0;f=H[e+36>>2];f=(n?0-(f+((g|0)!=0)|0)|0:f)+m|0;H[e+16>>2]=k;H[e+20>>2]=k>>>0<p>>>0?f+1|0:f;b=b+l|0}k=0;break j}H[e+28>>2]=b;break f}f=0;continue}f=1;continue}}h=h?H[o+48>>2]:0;H[e+28>>2]=h;break b}H[i+48>>2]=b;f=H[e+20>>2];b=H[e+16>>2];H[i+56>>2]=b;H[i+60>>2]=f;h=!k&(H[a+32>>2]==(b|0)&H[a+36>>2]==(f|0))?h:0;j=H[j+12>>2];continue}}f=0;if(!h){break a}o:{if(I[h|0]==1){a=h+1|0;H[e+28>>2]=a;b=F[h+1|0];p:{if((b|0)<0){b=qc(a,e+32|0);break p}H[e+32>>2]=b;b=1}h=b+a|0;H[e+28>>2]=h;break o}H[e+32>>2]=0}while(1){a=H[e+32>>2];if((a|0)<(c|0)){tf(0,e+28|0);a=H[e+28>>2];if(!I[a|0]){break a}b=a+1|0;a=F[a+1|0];q:{if((a|0)<0){a=qc(b,e+32|0);break q}H[e+32>>2]=a;a=1}h=a+b|0;H[e+28>>2]=h;continue}break}H[d>>2]=(a|0)==(c|0)?I[h|0]?h:0:0}Ea=e+48|0;return f}function Pd(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;if(!(I[a+16|0]&2)){F[a+18|0]=b;return 0}if(I[a+18|0]!=(b|0)){f=a;a:{b:{k=b&255;if(!((k|0)==1|I[a+18|0]==1)){if(fg(a)){break b}b=H[a+8>>2];c=b+(H[a+12>>2]&-2)|0;while(1){if(b>>>0<c>>>0){a=I[b+1|0];F[b+1|0]=I[b|0];F[b|0]=a;b=b+2|0;continue}break}F[f+18|0]=k;a=0;break a}b=H[f+12>>2];c:{if((k|0)==1){b=b&-2;H[f+12>>2]=b;c=b>>31<<1|b>>>31;a=b<<1|1;break c}c=b>>31<<1|b>>>31;a=(b<<1)+2|0;c=a>>>0<2?c+1|0:c}g=a;a=H[f+8>>2];g=nd(H[f+20>>2],g,c);if(!g){break b}i=a+b|0;b=g;d:{e:{f:{g:{h:{switch(I[f+18|0]-1|0){case 0:if((k|0)!=2){break f}c=g;i:while(1){if(a>>>0>=i>>>0){break e}b=a+1|0;j:{e=I[a|0];if(e>>>0<192){a=b;break j}d=I[e+32992|0];while(1){k:{if((b|0)==(i|0)){a=i}else{a=I[b|0];if((a&192)==128){break k}a=b}e=65533;if((d&-2)==65534|d>>>0<128|(d&-2048)==55296){break j}if(d>>>0<=65535){e=d;break j}F[c+2|0]=d;F[c+3|0]=d>>>8&3|220;b=d-65536|0;F[c+1|0]=b>>>18&3|216;F[c|0]=b>>>10&192|d>>>10&63;c=c+4|0;continue i}d=a&63|d<<6;b=b+1|0;continue}}F[c|0]=e;F[c+1|0]=e>>>8;c=c+2|0;continue};default:while(1){if(a>>>0>=i>>>0){break g}h=I[a+1|0];e=I[a|0];j=h|e<<8;c=a+2|0;if(!((e&248)!=216|c>>>0>=i>>>0)){l=I[a+2|0];d=I[a+3|0];F[b+3|0]=d&63|128;e=(j<<10&983040)+65536|0;F[b|0]=e>>>18|240;c=h<<10;F[b+1|0]=(e|c&61440)>>>12&63|128;F[b+2|0]=(c|(d|l<<8&768))>>>6&63|128;b=b+4|0;a=a+4|0;continue}if(j>>>0<=127){F[b|0]=h;b=b+1|0}else{if(e>>>0<=7){F[b+1|0]=h&63|128;F[b|0]=j>>>6|192;b=b+2|0}else{F[b+2|0]=h&63|128;F[b|0]=e>>>4|224;F[b+1|0]=j>>>6&63|128;b=b+3|0}}a=c;continue};case 1:break h}}while(1){if(a>>>0>=i>>>0){break g}h=I[a|0];e=I[a+1|0];j=h|e<<8;c=a+2|0;if(!((e&248)!=216|c>>>0>=i>>>0)){l=I[a+3|0];d=I[a+2|0];F[b+3|0]=d&63|128;e=(j<<10&983040)+65536|0;F[b|0]=e>>>18|240;c=h<<10;F[b+1|0]=(e|c&61440)>>>12&63|128;F[b+2|0]=(c|(d|l<<8&768))>>>6&63|128;b=b+4|0;a=a+4|0;continue}if(j>>>0<=127){F[b|0]=h;b=b+1|0}else{if(e>>>0<=7){F[b+1|0]=h&63|128;F[b|0]=j>>>6|192;b=b+2|0}else{F[b+2|0]=h&63|128;F[b|0]=e>>>4|224;F[b+1|0]=j>>>6&63|128;b=b+3|0}}a=c;continue}}H[f+12>>2]=b-g;break d}c=g;while(1){if(a>>>0>=i>>>0){break e}b=a+1|0;d=I[a|0];l:{m:{if(d>>>0<192){a=b;break m}d=I[d+32992|0];while(1){n:{o:{if((b|0)==(i|0)){a=i}else{a=I[b|0];if((a&192)==128){break o}a=b}if((d&-2)==65534|d>>>0<128|(d&-2048)==55296){break n}if(d>>>0<=65535){break m}F[c+2|0]=d>>>8&3|220;b=d-65536|0;F[c+1|0]=b>>>10&192|d>>>10&63;F[c|0]=b>>>18&3|216;e=4;b=c+3|0;break l}d=a&63|d<<6;b=b+1|0;continue}break}d=65533}F[c|0]=d>>>8;e=2;b=c+1|0}F[b|0]=d;c=c+e|0;continue}}H[f+12>>2]=c-g;F[c|0]=0;b=c+1|0}F[b|0]=0;a=J[f+16>>1];_c(f);F[f+18|0]=k;H[f+32>>2]=g;H[f+8>>2]=g;G[f+16>>1]=a&2109|514;m=f,n=mf(H[f+20>>2],g),H[m+24>>2]=n;a=0;break a}a=7}}else{a=0}return a}function Em(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;o=Ea-16|0;Ea=o;r=H[a+8>>2];a:{b:{c:{d:{e:{f:{g:{k=H[b>>2];g=I[k|0];switch(g-50|0){case 1:case 2:break d;case 0:break e;case 3:break f;default:break g}}if((g|0)!=45){break d}}f=Me(a,H[k+16>>2],f);break c}Sa(r,75,0,f);break c}l=H[c+80>>2];h:{if(I[l+41|0]&4){break h}g=H[l+32>>2];if(!g|!I[H[g+28>>2]+d|0]){break h}e=!e}g=0;i=(d|0)>0?d:0;while(1){i:{if((g|0)==(i|0)){g=J[l+44>>1];i=(d|0)>(g|0)?d:g;h=0;g=d;while(1){if((g|0)==(i|0)){break i}h=(H[H[H[l+52>>2]+(g<<2)>>2]>>2]==(k|0))+h|0;g=g+1|0;continue}}h=H[H[l+52>>2]+(g<<2)>>2];if(H[h>>2]==(k|0)?h:0){break b}g=g+1|0;continue}break}H[o+12>>2]=0;g=H[k+4>>2];j:{if(!(H[H[H[k+20>>2]+28>>2]>>2]!=1?g&4096:0)){v=Pm(a,k,4,0,0,o+12|0);break j}if(!(H[k+28>>2]?g&33554432:0)){q=H[a>>2];p=jb(q,k,0);v=5;k:{if(I[q+87|0]){break k}g=p+20|0;while(1){s=H[g>>2];if(s){x=H[s+28>>2];j=0;m=0;m=(s|0)==H[p+20>>2]?H[H[p+12>>2]+20>>2]:m;t=m+8|0;w=x+8|0;g=d;y=0;while(1){if((g|0)<J[l+44>>1]){i=H[H[l+52>>2]+(g<<2)>>2];l:{if(H[i>>2]!=(k|0)){break l}n=H[i+28>>2]-1<<4;u=n+w|0;i=H[u>>2];if(!i){break l}y=Pb(a,y,i);H[u>>2]=0;if(!m){break l}i=n+t|0;j=Pb(a,j,H[i>>2]);H[i>>2]=0}g=g+1|0;continue}break}pb(q,x);if(m){$f(q,m);H[H[p+12>>2]+20>>2]=j}H[s+28>>2]=y;if(!(!j|H[j>>2]!=1)){g=H[j+8>>2];H[j+8>>2]=0;eb(q,H[p+12>>2]);H[p+12>>2]=g}m:{n=H[s+48>>2];if(!n){break m}g=0;i=H[n>>2];u=(i|0)>0?i:0;i=n+8|0;while(1){if((g|0)==(u|0)){break m}G[(i+(g<<4)|0)+12>>1]=0;g=g+1|0;continue}}g=s+52|0;continue}break}j=0;if(I[q+87|0]){break k}j=nb(H[a>>2],h<<2,0);v=Pm(a,p,4,0,j,o+12|0);H[k+28>>2]=H[o+12>>2]}eb(q,p);break j}x=H[a>>2];g=Qc(H[k+12>>2]);j=nb(x,((g|0)<(h|0)?h:g)<<2,0);v=Pm(a,k,4,0,j,o+12|0)}i=(v|0)==4?!e:e;t=H[o+12>>2];Sa(r,i?32:36,t,0);g=H[l+40>>2];H[l+40>>2]=g|2048;if(!H[c+72>>2]){e=H[a+56>>2]-1|0;H[a+56>>2]=e;H[c+16>>2]=e}if(!(g&1048576|(d|0)<=0)){H[l+40>>2]=g|264192}g=H[c+72>>2];e=g+h|0;H[c+72>>2]=e;n:{o:{h=H[c+76>>2];e=cr(H[H[b+4>>2]>>2],N(e,20));p:{if(!(!h|!e)){z=c,A=Va(e,h,H[h-8>>2]),H[z+76>>2]=A;break p}H[c+76>>2]=e;if(!e){break o}}u=i?38:39;n=f-d|0;h=e+N(g,20)|0;i=(v|0)!=1;g=d;m=0;while(1){if((g|0)<J[l+44>>1]){if(H[H[H[l+52>>2]+(g<<2)>>2]>>2]==(k|0)){w=g+n|0;q:{if(!i){e=Sa(r,135,t,w);break q}r:{if(!j){e=0;break r}e=H[(m<<2)+j>>2];m=m+1|0}e=Ua(r,94,t,e,w)}H[h+4>>2]=e;_a(r,50,w);s:{if((d|0)==(g|0)){F[h+16|0]=u;H[h>>2]=t;if((d|0)>0){H[h+12>>2]=d;H[h+8>>2]=n;break s}H[h+12>>2]=0;break s}F[h+16|0]=187}h=h+20|0}g=g+1|0;continue}break}if((I[l+41|0]|I[l+42|0]<<8)&4100|(d|0)<=0){break n}Ua(r,125,H[c+8>>2],0,d);break n}H[c+72>>2]=0}Za(H[a>>2],j)}if(!(I[H[c+80>>2]+42|0]&32)){break b}if(I[b+13|0]&8){break a}}fh(c,b)}Ea=o+16|0;return f}function Hf(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;r=Ea-16|0;Ea=r;q=e?I[e+1|0]:q;n=H[f+4>>2];o=I[f|0];i=H[a+8>>2];l=d?H[d>>2]?d:0:l;if(!(q|l)){yi(i,H[b+12>>2],g)}k=H[H[b+28>>2]>>2];j=H[f+12>>2];a:{b:{if(!j){if(l){p=H[H[l>>2]>>2]+((I[l+32|0]^-1)&1)|0;d=p+H[a+44>>2]|0}else{d=H[a+44>>2]}j=d+1|0;H[f+12>>2]=j;m=a+44|0;break b}d=H[a+44>>2];if((d|0)>=(j+k|0)){break a}m=a+44|0}H[m>>2]=d+k}H[f+16>>2]=k;d=0;c:{d:{if((c|0)>=0){m=(k|0)>0?k:0;while(1){if((d|0)==(m|0)){break d}Ua(i,94,c,d,d+j|0);d=d+1|0;continue}}m=1;e:{if(o-9>>>0<2){break e}if((o|0)==3){break d}if((o|0)==13){break e}m=0}f:{if(!(!l|q|(o&253)==12)){d=H[l+4>>2];while(1){c=H[l>>2];if(H[c>>2]>(d|0)){c=J[(c+(d<<4)|0)+20>>1];if(c){d=d+1|0;G[(H[b+28>>2]+(c<<4)|0)+4>>1]=d-H[l+4>>2]}else{d=d+1|0}continue}break}c=H[b+28>>2];d=H[c>>2];t=(d|0)>0?d:0;u=c+8|0;c=j;d=0;while(1){if((d|0)!=(t|0)){s=J[((d<<4)+u|0)+12>>1];c=s?0:c;d=d+1|0;k=k-((s|0)!=0)|0;continue}break}m=m|12;break f}c=j}F[r+12|0]=m;H[r+8>>2]=j;if(!(!H[b+8>>2]|!(m&8)|(p|0)<=0)){H[l+36>>2]=r+8;c=0;break c}Zz(a,b,r+8|0);break c}c=j}g:{if(!q){break g}d=I[e+1|0];m=Yz(a,d,H[e+4>>2],g,H[b+28>>2],j);ln(a,d,m,H[e+8>>2]);if(l){break g}yi(i,H[b+12>>2],g)}h:{i:{j:{k:{l:{switch(o-1|0){case 0:c=zb(a);Ua(i,97,j,k,c);gb(i,138,n,c,j,k);rb(a,c);break k;case 1:Ua(i,140,n,j,k);break k;case 4:case 7:case 11:case 13:e=p+1|0;d=nc(a,e);f=d+p|0;Ua(i,97,j,k,f);if((o|0)==5){g=n+1|0;gb(i,29,g,H[i+108>>2]+4|0,d,0);gb(i,138,g,d,j,k)}m:{if(l){Xz(a,l,b,f,c,1,p);break m}c=zb(a);Sa(i,127,n,c);Ua(i,128,n,d,c);f=H[i+108>>2];if((f|0)>0){G[(H[i+104>>2]+N(f,20)|0)-18>>1]=8}rb(a,c)}Sc(a,d,e);break k;case 14:if(l){break i}c=H[f+8>>2];a=zb(a);Sa(i,50,j,h);d=c>>>31|0;Ua(i,97,d+j|0,k-d|0,a);if((c|0)<0){Ua(i,128,n,a,j);break j}gb(i,138,n,a,j,c);break j;case 10:if(l){break i}c=zb(a);fb(i,97,j,k,c,H[f+20>>2],k);gb(i,138,n,c,j,k);rb(a,c);break j;case 2:Sa(i,71,1,n);break k;case 9:if(l){break i}break j;case 8:case 12:if(l){break i}if((o|0)==13){_a(i,12,H[f+4>>2]);break j}Sa(i,84,j,k);break j;case 5:case 6:break l;default:break k}}m=H[f+24>>2];c=H[m>>2];f=zb(a);g=c+2|0;e=nc(a,g);q=e+c|0;d=q+1|0;p=0;o=(o|0)!=6;if(!o){p=gb(i,29,n+1|0,0,j,k)}Ua(i,97,j,k,d);n:{if(o){break n}Sa(i,138,n+1|0,d);d=H[i+108>>2];if((d|0)<=0){break n}G[(H[i+104>>2]+N(d,20)|0)-18>>1]=16}d=0;c=(c|0)>0?c:0;j=j-1|0;k=m+8|0;while(1){if((c|0)!=(d|0)){Sa(i,81,j+J[(k+(d<<4)|0)+12>>1]|0,d+e|0);d=d+1|0;continue}break}Sa(i,126,n,q);Ua(i,97,e,g,f);gb(i,138,n,f,e,g);if(p){d=H[i+108>>2];H[(I[H[i>>2]+87|0]?73336:H[i+104>>2]+N(p,20)|0)+8>>2]=d}rb(a,f);Sc(a,e,g)}if(l){break h}}a=H[b+8>>2];if(!a){break h}Sa(i,61,a,h);break h}Xz(a,l,b,j,c,k,p)}Ea=r+16|0}function Ie(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;g=Ea-128|0;Ea=g;h=-3;a:{b:{c:{e=I[c|0];d:{if((e|0)!=91){if((e|0)!=46){if(e){break a}e:{f:{if(!I[a+39|0]){break f}if(!km(a,H[a+44>>2])){break f}c=$b(a,b,g+124|0)+H[g+124>>2]|0;h=b;g:{switch(I[a+39|0]-1|0){case 0:h=d?d:b;Xe(a,h,c+(d?b-d|0:0)|0,0,0);break e;case 2:break e;default:break g}}Xe(a,b,c,H[a+52>>2],H[a+44>>2])}h=b}H[a+48>>2]=d;break a}e=c+1|0;k=H[a>>2];i=I[k+b|0];h:{i:{f=I[c+1|0];if((f|0)!=34){d=0;while(1){c=f&255;if(!c|(c|0)==46|(c|0)==91){break i}d=d+1|0;f=I[e+d|0];continue}}c=c+2|0;f=1;while(1){d=I[f+e|0];if(!d){break a}if((d|0)!=34){f=f+1|0;continue}break}j=f+1|0;d=f-1|0;o=!Jw(c,92,d);break h}o=1;c=e;j=d;if(!d){break a}}h=-2;if((i&15)!=12){break a}f=$b(a,b,g+124|0)+b|0;m=f+H[g+124>>2]|0;while(1){if(f>>>0<m>>>0){h=-1;l=I[f+k|0]&15;if(l-11>>>0<4294967292){break a}p=g+124|0;i=$b(a,f,p);if(!i){break a}n=H[g+124>>2];q=f+i|0;i=n+q|0;if(i>>>0>=m>>>0){break a}n=Ty(c,d,o,k+q|0,n,(l|0)==7|(l|0)==10);k=H[a>>2];l=I[i+k|0]&15;if(n){if(l>>>0>12){break a}c=$b(a,i,p);if(!c|H[g+124>>2]+(c+i|0)>>>0>m>>>0){break a}h=Ie(a,i,e+j|0,f);if(H[a+40>>2]){break d}break a}if(l>>>0>12){break a}f=$b(a,i,g+124|0);if(!f){break a}f=H[g+124>>2]+(f+i|0)|0;continue}break}if(f>>>0>m>>>0){break b}h=-2;if(I[a+39|0]<3){break a}h=g+12|0;Xa(h,0,56);H[g+28>>2]=H[a+16>>2];sd(h,o?10:9,d,0);F[a+35|0]=I[a+35|0]|I[g+47|0];h=Sy(a,g+68|0,e+j|0);j:{if(h>>>0>4294967292){break j}e=H[g+16>>2];j=e+d|0;if(!km(a,j+H[g+72>>2]|0)){break j}Xe(a,f,0,0,j+H[g+72>>2]|0);if(I[a+35|0]){break j}Va(H[a>>2]+f|0,H[g+12>>2],e);e=f+e|0;Va(e+H[a>>2]|0,c,d);Va((e+H[a>>2]|0)+d|0,H[g+68>>2],H[g+72>>2]);if(!H[a+40>>2]){break j}Cq(a,b)}vf(g+68|0);vf(g+12|0);break a}if((I[H[a>>2]+b|0]&15)!=11){break c}d=0;j=$b(a,b,g+124|0);f=1;while(1){e=I[c+f|0];if(e-58>>>0>=4294967286){f=f+1|0;d=((e<<24>>24)+N(d,10)|0)-48|0;continue}break}if(!((e|0)==93&f>>>0>=2)){if(I[c+1|0]!=35){break a}d=Zy(a,b);f=2;e=I[c+2|0];if((e|0)==45){e=I[c+3|0];if(e-58>>>0<4294967286){break a}f=3;while(1){k=((e<<24>>24)+N(k,10)|0)-48|0;f=f+1|0;e=I[f+c|0];if(e-58>>>0>4294967285){continue}break}if(d>>>0<k>>>0){break c}d=d-k|0}if((e|0)!=93){break a}}e=b+j|0;h=e+H[g+124>>2]|0;while(1){if(e>>>0<h>>>0){if(!d){h=Ie(a,e,(c+f|0)+1|0,0);if(H[a+40>>2]){break d}break a}j=$b(a,e,g+124|0);if(!j){break b}d=d-1|0;e=H[g+124>>2]+(e+j|0)|0;continue}break}if(e>>>0>h>>>0){break b}if(d){break c}h=-2;if(I[a+39|0]<3){break a}h=Sy(a,g+68|0,(c+f|0)+1|0);k:{if(h>>>0>4294967292){break k}if(!km(a,H[g+72>>2])){break k}Xe(a,e,0,H[g+68>>2],H[g+72>>2])}vf(g+68|0);if(!H[a+40>>2]){break a}}Cq(a,b);break a}h=-2;break a}h=-1}Ea=g+128|0;return h}function Eo(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;h=Ea-32|0;Ea=h;l=H[b+4>>2];a:{if(l>>>0<=2){g=Ya(74016);break a}i=H[b+72>>2];j=H[a>>2];if(I[j+12|0]){g=Vb(i);if(g){break a}}g=J[i+28>>1];if(g&2){g=fm(i);if(g){break a}g=J[i+28>>1]}if(!(!(g&8)|f)){k=H[i+24>>2]}G[i+28>>1]=g&65527;f=Lh(j,e);b:{if(!f){break b}g=H[f+32>>2];m=H[f+36>>2];if((m|0)>0){g=1}else{g=(m|0)>=0&g>>>0>=2}if(g){Af(f);g=Ya(63919);break a}G[i+28>>1]=J[i+28>>1]|J[f+28>>1]&8;if(I[j+12|0]){Hh(f,H[j+28>>2]+1|0);break b}gl(f)}g=H[i+24>>2];Hh(i,e);dl(i);if(!(!f|!I[j+12|0])){Hh(f,g);Af(f)}if(k){g=Ia[H[j+220>>2]](j,k,h+8|0,0)|0;if(g){if(K[j+32>>2]<k>>>0){break a}d=H[j+224>>2];c:{b=H[j+60>>2];if(!b){break c}a=k-1|0;while(1){c=H[b+8>>2];if(c){e=c;c=(a>>>0)/(c>>>0)|0;a=a-N(e,c)|0;b=H[((c<<2)+b|0)+12>>2];if(b){continue}break c}break}if(K[b>>2]<=4e3){b=(a>>>3|0)+b|0;c=I[b+12|0];n=b,o=xJ(-2,a&7)&c,F[n+12|0]=o;break c}c=b+12|0;d=Va(d,c,500);e=Xa(c,0,500);H[b+4>>2]=0;f=a+1|0;c=0;while(1){if((c|0)==125){break c}i=d+(c<<2)|0;a=H[i>>2];if(!(!a|(a|0)==(f|0))){H[b+4>>2]=H[b+4>>2]+1;a=(a-1>>>0)%125|0;while(1){j=e+(a<<2)|0;if(H[j>>2]){a=a+1|0;a=a>>>0<=124?a:0;continue}break}H[j>>2]=H[i>>2]}c=c+1|0;continue}}break a}f=H[h+8>>2];G[f+28>>1]=J[f+28>>1]|8;dl(f);Af(H[h+8>>2])}H[h>>2]=0;H[b+4>>2]=e;d:{if((c&251)==1){g=uu(b);if(g){break a}g=0;if((c|0)!=1){break d}break a}b=cb(H[b+56>>2]);if(!b){break d}Ad(a,b,4,e,h);g=H[h>>2];if(g){break a}}g=qd(a,d,h+4|0,0);if(g){break a}b=H[h+4>>2];g=Vb(H[b+72>>2]);if(g){Eb(b);break a}e:{f:{if((c|0)==4){f=H[b+56>>2];if((cb(f)|0)!=(l|0)){g=Ya(73941);break e}g=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);F[f|0]=g;F[f+1|0]=g>>>8;F[f+2|0]=g>>>16;F[f+3|0]=g>>>24;break f}if(!I[b|0]){g=Oh(b);if(g){break e}}i=J[b+24>>1];g=0;j=(c|0)!=3;g:{while(1){if((g|0)==(i|0)){break g}k=H[b+56>>2];f=H[b+64>>2]+(g<<1)|0;f=k+(J[b+26>>1]&(I[f|0]<<8|I[f+1|0]))|0;h:{i:{if(!j){Ia[H[b+80>>2]](b,f,h+8|0);if(K[h+20>>2]<=J[h+24>>1]){break i}f=f+J[h+26>>1]|0;if(f>>>0>H[b+56>>2]+H[H[b+52>>2]+40>>2]>>>0){g=Ya(73960);break e}k=f-4|0;if((cb(k)|0)!=(l|0)){break i}F[k|0]=e>>>24;F[f-1|0]=e;F[f-2|0]=e>>>8;F[f-3|0]=e>>>16;break f}if(f+4>>>0>k+H[H[b+52>>2]+40>>2]>>>0){g=Ya(73969);break e}if((cb(f)|0)==(l|0)){break h}}g=g+1|0;continue}break}g=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);F[f|0]=g;F[f+1|0]=g>>>8;F[f+2|0]=g>>>16;F[f+3|0]=g>>>24;break f}j:{if((c|0)==5){f=H[b+56>>2]+I[b+9|0]|0;if((cb(f+8|0)|0)==(l|0)){break j}}g=Ya(73981);break e}g=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);F[f+8|0]=g;F[f+9|0]=g>>>8;F[f+10|0]=g>>>16;F[f+11|0]=g>>>24}g=0}H[h>>2]=g;Eb(b);if(g){break a}Ad(a,e,c,d,h);g=H[h>>2]}Ea=h+32|0;return g}function Nu(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;j=Ea-16|0;Ea=j;e=H[a+44>>2];a:{if(e){break a}e=0;f=H[a+104>>2];if((f|0)<=(c|0)){break a}d=((b|0)!=1)+c|0;c=d;while(1){if((c|0)<(f|0)){Xf(H[(H[a+100>>2]+N(c,48)|0)+16>>2]);c=c+1|0;f=H[a+104>>2];continue}break}H[a+104>>2]=d;if((b|0)==1){d=H[a+100>>2]+N(d,48)|0;if(!H[d+28>>2]){break a}b=H[a+72>>2];c=H[b>>2];if(!c){break a}if((c|0)==33048){i=H[d+24>>2];c=H[a+172>>2];e=H[a+168>>2]+4|0;c=e>>>0<4?c+1|0:c;e=So(b,sJ(i,0,e,c),Ha)}H[a+56>>2]=H[d+24>>2];break a}if(!(H[a+232>>2]|H[H[a+68>>2]>>2])){break a}b:{c:{if(!d){break c}b=H[a+100>>2]+N(d,48)|0;h=b-48|0;if(!h){break c}c=b-28|0;m=ej(H[c>>2]);if(!m){e=7;break a}b=0;break b}c=a+32|0;h=0;b=1}H[a+28>>2]=H[c>>2];F[a+19|0]=I[a+12|0];d:{e:{f:{i=b;if(b){d=H[a+232>>2];if(!d){f=a+80|0;d=H[a+80>>2];k=H[a+84>>2];break f}H[a+28>>2]=H[a+32>>2];g:{if(!I[d+44|0]){break g}i=H[d+68>>2];Va(d+52|0,H[H[d+32>>2]>>2],48);c=H[d+68>>2];while(1){h:{if(e){break h}b=c+1|0;if(b>>>0>i>>>0){break h}c=c+34|0;if(c>>>0<=4095){c=(H[H[d+32>>2]>>2]+(b<<2)|0)+132|0}else{c=H[H[d+32>>2]+(c>>>10&4194300)>>2]+((c&4095)<<2)|0}e=Iu(a,H[c>>2]);c=b;continue}break}if((i|0)==H[d+68>>2]){break g}Ro(d)}c=mq(H[a+228>>2]);while(1){if(!c|e){break a}b=H[c+16>>2];e=Iu(a,H[c+24>>2]);c=b;continue}}f=a+80|0;d=H[a+80>>2];k=H[a+84>>2];if(H[a+232>>2]){break f}b=H[h+8>>2];c=H[h+12>>2];g=H[h+4>>2];H[f>>2]=H[h>>2];H[f+4>>2]=g;g=!(b|c);b=g?d:b;c=g?k:c;while(1){if(e){break d}g=H[f+4>>2];if((c|0)<=(g|0)&b>>>0<=K[f>>2]|(c|0)<(g|0)){break e}e=el(a,f,m,1,1);continue}}H[f>>2]=0;H[f+4>>2]=0}e=0}i:while(1){j:{if(e){break j}c=H[f+4>>2];if((k|0)<=(c|0)&d>>>0<=K[f>>2]|(c|0)>(k|0)){break j}H[j>>2]=0;e=Ju(a,0,d,k,j,j+12|0);b=H[j>>2];k:{if(b){break k}b=0;g=H[a+92>>2];l=H[a+156>>2];c=l+H[a+88>>2]|0;g=c>>>0<l>>>0?g+1|0:g;if((c|0)!=H[a+80>>2]|(g|0)!=H[a+84>>2]){break k}l=d-c|0;c=k-(g+(c>>>0>d>>>0)|0)|0;b=H[a+172>>2];g=H[a+168>>2]+8|0;b=g>>>0<8?b+1|0:b;b=tJ(l,c,g,b)}c=0;while(1){if(b>>>0<=c>>>0|e){continue i}l=H[f+4>>2];if((k|0)<=(l|0)&d>>>0<=K[f>>2]|(k|0)<(l|0)){continue i}c=c+1|0;e=el(a,f,m,1,1);continue}}break}l:{if(i){break l}c=H[h+24>>2];b=H[a+172>>2];i=H[a+168>>2]+4|0;b=i>>>0<4?b+1|0:b;n=j,o=sJ(c,0,i,b),H[n>>2]=o;H[j+4>>2]=Ha;b=H[a+232>>2];m:{if(!b){break m}if(H[h+44>>2]==H[b+112>>2]){i=H[h+32>>2]}else{H[h+32>>2]=0;H[h+44>>2]=H[b+112>>2];i=0}e=0;if(i>>>0>=K[b+68>>2]){break m}H[b+68>>2]=i;H[b+76>>2]=H[h+36>>2];H[b+80>>2]=H[h+40>>2];Ro(b);c=H[h+24>>2]}while(1){if(K[a+56>>2]<=c>>>0|e){break l}c=c+1|0;e=el(a,j,m,0,1);continue}}Xf(m);if(e){break a}H[f>>2]=d;H[f+4>>2]=k;e=0}Ea=j+16|0;return e}function _g(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;q=Ea-16|0;Ea=q;r=a+252|0;g=H[a+252>>2];a:{b:{if(g){l=Ea-16|0;Ea=l;c:{if(!g){a=Rc(102236);break c}p=H[g+20>>2];a=H[g+16>>2];d:{if(!a){a=4;break d}H[a+36>>2]=0;a=cw(g,b,c,l+12|0);if(!a){break d}b=H[l+12>>2];H[l>>2]=b;ae(p,a,b?8863:0,l);Za(p,b)}a=gd(p,a)}Ea=l+16|0;break b}e:{g=H[a+248>>2];if(g){break e}H[q>>2]=H[a+20>>2];g=Ab(4053,q);H[a+248>>2]=g;if(g){break e}a=7;break a}h=H[a+12>>2];l=H[a+16>>2];p=g;f=Ea-352|0;Ea=f;H[f+348>>2]=0;H[r>>2]=0;i=nb(h,32,0);f:{g:{h:{i:{j:while(1){k:{a=f- -64|0;vm(a,h);if(!i){break k}Za(h,H[f+348>>2]);H[f+348>>2]=0;ye(h);l:{j=of(a,0,p,l);if(j){a=I[j+43|0];g=8383;m:{if((a|0)==1){break m}g=8563;if(I[j+28|0]&128){break m}if((a|0)!=2){break l}g=7573}H[f+16>>2]=p;Wa(f- -64|0,g,f+16|0)}m=1;if(!H[f+68>>2]){break h}Za(h,0);H[f+348>>2]=H[f+68>>2];H[f+68>>2]=0;break h}H[i+28>>2]=j;t=i,u=H[H[h+16>>2]+(Fb(h,H[j+60>>2])<<4)>>2],H[t+24>>2]=u;a=0;n=G[j+34>>1];g=(n|0)>0?n:0;while(1){n:{if((a|0)!=(g|0)){if(ab(H[H[j+4>>2]+N(a,12)>>2],11923)){break n}g=a}o:{p:{if((g|0)==(n|0)){Za(h,0);H[f+32>>2]=11923;t=f,u=mb(h,29721,f+32|0),H[t+348>>2]=u;break p}break o}m=1;break i}k=ew(f- -64|0);H[i+16>>2]=k;q:{r:{if(k){a=H[j+60>>2];n=Fb(h,a);gb(k,2,n,0,H[a>>2],H[a+4>>2]);a=H[k+108>>2];if((a|0)>0){G[(H[k+104>>2]+N(a,20)|0)-18>>1]=1}o=ag(k,6,31120);ke(k,n);if(I[h+87|0]){break r}H[o+4>>2]=n;a=H[j+20>>2];H[o+12>>2]=0;H[o+8>>2]=a;Wd(k,2,H[j>>2],0);if(I[h+87|0]){break r}a=H[j+20>>2];H[o+32>>2]=n;H[o+28>>2]=a;F[o+21|0]=253;H[o+36>>2]=G[j+34>>1]+1;H[o+68>>2]=G[j+34>>1];G[f+280>>1]=0;H[f+104>>2]=1;H[f+108>>2]=1;dw(k,f- -64|0)}a=I[h+87|0];H[i+20>>2]=h;G[i+8>>1]=g;if(a){break q}m=cw(i,b,c,f+348|0);if((m|0)!=17|s>>>0>48){break q}s=s+1|0;mi(f- -64|0);m=17;continue j}H[i+20>>2]=h;G[i+8>>1]=g}if(m){break h}break k}a=a+1|0;continue}}break}m=0;if(I[h+87|0]){break i}H[r>>2]=i;break f}if(!i){break g}}a=H[i+16>>2];if(!a){break g}Cf(a)}Za(h,i)}a=H[f+348>>2];H[f>>2]=a;ae(h,m,a?8863:0,f);Za(h,a);mi(f- -64|0);a=gd(h,m);Ea=f+352|0}if(!a){a=0;c=H[r>>2];b=0;s:{if(!c){break s}b=0;if(!H[c+16>>2]){break s}b=H[c>>2]}H[e>>2]=b;if(!d){break a}c=b>>31;a=b+20|0;c=a>>>0<20?c+1|0:c;e=ub(a,c);t:{if(!e){e=0;a=7;break t}a=Zv(H[r>>2],e,b,0);b=b+e|0;F[b+16|0]=0;F[b+17|0]=0;F[b+18|0]=0;F[b+19|0]=0;F[b+8|0]=0;F[b+9|0]=0;F[b+10|0]=0;F[b+11|0]=0;F[b+12|0]=0;F[b+13|0]=0;F[b+14|0]=0;F[b+15|0]=0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;F[b+4|0]=0;F[b+5|0]=0;F[b+6|0]=0;F[b+7|0]=0;if(!a){a=0;break t}Ta(e);e=0}H[d>>2]=e;break a}a=(a|0)==1?267:a}Ea=q+16|0;return a}function Ev(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;m=Ea+-64|0;Ea=m;i=bb(b);a:{b:{c:{d:{e:{f:{o=H[c>>2];g:{if(!(o&64)){if(!I[65926]){break f}if(i>>>0>4){break g}break f}if(i>>>0<5){break f}}if(Hb(b,22966,5)){break f}k=i+8|0;while(1){if((h|0)!=(i|0)){l=I[b+h|0]==38;k=k+l|0;g=l>>>0>k>>>0?g+1|0:g;h=h+1|0;continue}break}g=ub(k,g);if(!g){break d}o=o|64;F[g|0]=0;F[g+1|0]=0;F[g+2|0]=0;F[g+3|0]=0;l=g+4|0;g=5;h:{if(I[b+5|0]!=47|I[b+6|0]!=47){break h}h=7;while(1){g=I[b+h|0];if(!(!g|(g|0)==47)){h=h+1|0;continue}break}if((h|0)==7){g=h;break h}g=16;if((h|0)==16){if(!Hb(2267,b+7|0,9)){break h}}H[m+4>>2]=b+7;H[m>>2]=h-7;h=1;g=Ab(6036,m);break c}s=b+2|0;while(1){p=l+n|0;t=p-1|0;h=I[b+g|0];i:{j:{k:{l:{m:{n:while(1){i=h&255;if(!i|(i|0)==35){break i}k=g+1|0;o:{if((i|0)!=37){break o}q=I[b+k|0];if(!(I[q+31152|0]&8)){break o}r=I[g+s|0];if(!(I[r+31152|0]&8)){break o}g=g+3|0;h=(r<<1<<24>>24>>>7&9)+r&15|q+(q<<1<<24>>24>>>7&9)<<4;if(h&255){break j}while(1){h=I[b+g|0];if(!h|(h|0)==35|!j&(h|0)==63){continue n}p:{if((j|0)==1){if((h|0)==38|(h|0)==61){continue n}break p}if((j|0)!=2){break p}if((h|0)==38){continue n}}g=g+1|0;continue}}if((j|0)!=1){break m}if(!((i|0)==61|(i|0)==38)){j=1;break k}if(!I[t|0]){g=k;while(1){j=1;k=b+g|0;h=I[k|0];if(!h|(h|0)==35|I[k-1|0]==38){continue n}g=g+1|0;continue}}break}j=2;if((i|0)!=38){break l}h=0;F[p|0]=0;j=1;n=n+1|0;break k}if(!(!j&(i|0)==63)&((j|0)!=2|(i|0)!=38)){break k}j=1}h=0}g=k}F[l+n|0]=h;n=n+1|0;continue}break}if((j|0)==1){F[p|0]=0;n=n+1|0}b=l+n|0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;h=bb(l)+l|0;while(1){if(!I[h+1|0]){break e}g=h+1|0;h=bb(g);b=(g+h|0)+1|0;k=bb(b);q:{r:{s:{switch(h-3|0){case 0:if(Hb(5321,g,3)){break q}a=b;break q;case 2:j=14475;if(Hb(14475,g,5)){break q}n=393216;i=-393217;g=50704;break r;case 1:break s;default:break q}}if((I[g|0]|I[g+1|0]<<8|(I[g+2|0]<<16|I[g+3|0]<<24))!=1701080941){break q}n=o&135;i=-136;j=4462;g=50736}h=0;t:{u:{while(1){q=g+(h<<3)|0;p=H[q>>2];if(!p){break u}v:{if((bb(p)|0)==(k|0)){if(!Hb(b,p,k)){break v}}h=h+1|0;continue}break}g=H[q+4>>2];if(g){break t}}H[m+36>>2]=b;H[m+32>>2]=j;h=1;g=Ab(8474,m+32|0);break c}if((g&-129)>(n|0)){H[m+52>>2]=b;H[m+48>>2]=j;h=3;g=Ab(8599,m+48|0);break c}o=g|i&o}h=b+k|0;continue}}g=ub(i+8|0,0);if(!g){break d}F[g|0]=0;F[g+1|0]=0;F[g+2|0]=0;F[g+3|0]=0;l=g+4|0;if(i){Va(l,b,i)}b=i+l|0;F[b|0]=0;F[b+1|0]=0;F[b+2|0]=0;F[b+3|0]=0;o=o&-65}b=Xl(a);H[d>>2]=b;h=0;if(b){break b}H[m+16>>2]=a;h=1;g=Ab(7616,m+16|0);break c}h=7;break a}H[f>>2]=g;cp(l);l=0}H[c>>2]=o;H[e>>2]=l}Ea=m- -64|0;return h}function wh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;k=32;f=H[b>>2];a:{if(J[f+8>>1]>13){break a}d=H[b+4>>2];e=J[d+16>>1];h=I[H[f+16>>2]];b:{if(!h){i=255;h=1;break b}if(h&2){break a}i=1;h=255}F[b+25|0]=h;F[b+24|0]=i;if(e&4){f=H[d+4>>2];H[b+8>>2]=H[d>>2];H[b+12>>2]=f;k=33;break a}if(H[f+20>>2]|e&57){break a}H[b+8>>2]=H[d+8>>2];H[b+16>>2]=H[d+12>>2];k=34}F[b+23|0]=0;c:{d:{e:{f:{if(I[a|0]){break f}d=H[a+116>>2];if(!I[d+8|0]){break f}f=0;e=F[a+68|0];e=(e|0)>0?e:0;h=a+72|0;i=a+120|0;while(1){if((e|0)!=(f|0)){j=f<<1;g=f<<2;f=f+1|0;if(J[h+j>>1]>=J[H[g+i>>2]+24>>1]){continue}break f}break}g:{e=J[d+24>>1]-1|0;d=J[a+70>>1];if((e|0)!=(d|0)){break g}d=yt(a,d,b,k);if((d|0)>0|I[b+23|0]){break g}H[c>>2]=d;return 0}h:{if(F[a+68|0]<=0){break h}if((yt(a,0,b,k)|0)>0|I[b+23|0]){break h}F[a+1|0]=I[a+1|0]&251;f=H[a+116>>2];if(I[f|0]){break e}return Ya(76079)}F[b+23|0]=0}e=Qf(a);if((e|0)==16){break c}if(e){break d}f=H[a+116>>2]}m=a+120|0;p=a+72|0;n=a+32|0;o=a+116|0;e=J[f+24>>1];i:{j:{while(1){e=(e&65535)-1|0;h=e;i=0;k:{while(1){d=H[f+64>>2]+(e&-2)|0;d=H[f+68>>2]+(J[f+26>>1]&(I[d|0]<<8|I[d+1|0]))|0;g=d+1|0;j=e>>1;e=I[d|0];l:{if(e>>>0<=I[f+11|0]){e=Ia[k|0](e,g,b)|0;break l}m:{g=F[g|0];if((g|0)<0){break m}e=g|e<<7&16256;if(e>>>0>J[f+14>>1]){break m}e=Ia[k|0](e,d+2|0,b)|0;break l}Ia[H[f+80>>2]](f,d-I[f+10|0]|0,n);n:{d=H[n>>2];l=d;if((d|0)>=2){e=H[a+20>>2];if((d>>>0)/K[e+40>>2]>>>0<=K[e+48>>2]){break n}}e=Ya(76166);break i}d=d+18|0;g=bc(d,0);if(!g){e=7;break i}G[a+70>>1]=j;e=yl(a,0,l,g);d=g+l|0;F[d+16|0]=0;F[d+17|0]=0;F[d+8|0]=0;F[d+9|0]=0;F[d+10|0]=0;F[d+11|0]=0;F[d+12|0]=0;F[d+13|0]=0;F[d+14|0]=0;F[d+15|0]=0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;F[a+1|0]=I[a+1|0]&251;if(e){Ta(g);break i}e=Ri(l,g,b);Ta(g)}o:{p:{if((e|0)<0){i=j+1|0;break p}if(!e){break o}h=j-1|0}if((i|0)>(h|0)){break k}e=i+h|0;continue}break}e=0;H[c>>2]=0;G[a+70>>1]=j;if(!I[b+23|0]){break i}e=Ya(76198);break i}if(I[f+8|0]){G[a+70>>1]=j;H[c>>2]=e;e=0;break i}d=H[f+56>>2];q:{if(J[f+24>>1]<=(i|0)){d=cb((d+I[f+9|0]|0)+8|0);break q}e=J[f+26>>1];f=H[f+64>>2]+(i<<1)|0;d=cb(d+(e&(I[f|0]<<8|I[f+1|0]))|0)}G[a+50>>1]=0;F[a+1|0]=I[a+1|0]&249;f=F[a+68|0];if((f|0)>=19){return Ya(76229)}G[(f<<1)+p>>1]=i;H[(f<<2)+m>>2]=H[a+116>>2];F[a+68|0]=f+1;G[a+70>>1]=0;e=Oi(H[a+20>>2],d,o,I[a+2|0]);if(e){break j}f=H[o>>2];e=J[f+24>>1];if(I[f+1|0]==I[a+69|0]?e:0){continue}break}Eb(f);e=Ya(76240)}b=I[a+68|0]-1|0;F[a+68|0]=b;H[a+116>>2]=H[(b<<24>>24<<2)+m>>2]}G[a+50>>1]=0}return e}H[c>>2]=-1;return 0}function av(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;h=Ea+-64|0;Ea=h;f=H[d>>2];H[d>>2]=f+1;a:{if((f|0)>=5){e=15;if(f>>>0>99){break a}g=H[a>>2];d=f-8|0;Ia[H[g+60>>2]](g,f>>>0<=8?1:N(N(d,d),39))|0}b:{c:{d:{e:{f:{g:{if(!c){if(!I[a+50|0]){e=Su(a,b);if(e){if((e|0)!=5){break a}e=-1;if(!H[H[a+32>>2]>>2]){break a}b=Mh(a,2);if(!b){Kg(a,2);break a}e=(b|0)==5?261:b;break a}if(!I[a+50|0]){break g}}c=Mh(a,3);if(c){e=(c|0)==5?-1:c;d=0;break b}d=0;G[a+40>>1]=0;c=H[a+4>>2];e=Ia[H[H[c>>2]+52>>2]](c,0,32768,0,h+12|0)|0;if((e|0)==8){break e}if((e|0)!=1288){break b}Va(a+52|0,H[H[a+32>>2]>>2],48);c=H[a+8>>2];e=Ia[H[H[c>>2]+24>>2]](c,h+56|0)|0;if(e){break b}g=H[h+56>>2];c=H[h+60>>2];if((c|0)<0){c=1}else{c=(c|0)<=0&g>>>0<=31}if(c){H[b>>2]=1;e=H[a+68>>2]?-1:0;break b}c=H[a+8>>2];e=Ia[H[H[c>>2]+8>>2]](c,h+16|0,32,0,0)|0;if(e){break b}if(H[h+32>>2]!=(I[a+84|0]|I[a+85|0]<<8|(I[a+86|0]<<16|I[a+87|0]<<24))|H[h+36>>2]!=(I[a+88|0]|I[a+89|0]<<8|(I[a+90|0]<<16|I[a+91|0]<<24))){e=-1;break b}j=H[a+36>>2]+24|0;c=j>>31;m=c;d=ub(j,c);if(!d){e=7;d=0;break b}n=d+24|0;c=sJ(H[a+68>>2],0,H[a+36>>2]+24|0,0);f=Ha;k=c+32|0;f=k>>>0<32?f+1|0:f;o=H[a+80>>2];l=H[a+76>>2];while(1){c=f+m|0;g=j+k|0;c=g>>>0<j>>>0?c+1|0:c;i=H[h+60>>2];if(K[h+56>>2]<g>>>0&(i|0)<=(c|0)|(c|0)>(i|0)){break d}i=H[a+8>>2];e=Ia[H[H[i>>2]+8>>2]](i,d,j,k,f)|0;if(e){break c}if(!Ru(a,h+8|0,h+4|0,n,d)){break d}if(H[h+4>>2]){e=-1;break c}else{k=g;f=c;continue}}}j=a+32|0;l=H[H[a+32>>2]>>2]+96|0;e=0;break f}j=a+32|0;b=H[H[a+32>>2]>>2];l=b+96|0;e=0;if(H[b+96>>2]!=H[a+68>>2]){break f}e=Mh(a,3);il(a);if((e|0)==5){break f}if(e){break a}if(Hb(H[H[a+32>>2]>>2],a+52|0,48)){Kg(a,3);e=-1;break a}e=0;G[a+40>>1]=0;break a}i=l+4|0;g=H[a+68>>2];b=0;d=1;c=0;while(1){if((d|0)!=5){k=H[i+(d<<2)>>2];f=k>>>0>g>>>0|c>>>0>k>>>0;c=f?c:k;b=f?b:d;d=d+1|0;continue}break}h:{i:{if(I[a+46|0]&2){break i}d=1;if(b?c>>>0>=g>>>0:0){break h}while(1){if((d|0)==5){break i}f=d+3|0;e=Vf(a,f,1);if((e|0)!=5){if(e){break a}H[i+(d<<2)>>2]=g;xe(a,f,1);c=g;b=d;break h}else{d=d+1|0;e=5;continue}}}if(b){break h}e=(e|0)==5?-1:1288;break a}d=b+3|0;g=Mh(a,d);if(g){e=(g&255)==5?-1:g;break a}H[a+100>>2]=H[l>>2]+1;il(a);j:{if(H[i+(b<<2)>>2]==(c|0)){if(!Hb(H[H[j>>2]>>2],a+52|0,48)){break j}}Kg(a,d);e=-1;break a}G[a+40>>1]=b;e=0;break a}e=-1;break b}e=0}H[a+80>>2]=o;H[a+76>>2]=l}Ta(d);if(!e){break a}d=0;while(1){if((d|0)<H[a+24>>2]){c=d<<2;Ta(H[c+H[a+32>>2]>>2]);H[c+H[a+32>>2]>>2]=0;d=d+1|0;continue}break}F[a+50|0]=0;Qo(a);H[b>>2]=1}Ea=h- -64|0;return e}function rz(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;p=e+9|0;if((p|0)>H[a+44>>2]){H[a+44>>2]=p}r=H[a>>2];g=wb(a);a:{if(!b|!g|I[b+43|0]){break a}i=H[b>>2];if(i){h=Vh(29052,i,31148,92)}else{h=1}if(!h){break a}h=H[r+16>>2];t=Fb(r,H[b+60>>2]);if(Yb(a,28,i,0,H[h+(t<<4)>>2])){break a}u=e+8|0;y=e+7|0;z=e+5|0;l=e+4|0;A=e+3|0;s=e+2|0;v=e+1|0;wd(a,t,H[b+20>>2],0,H[b>>2]);i=H[a+40>>2];h=f+2|0;H[a+40>>2]=(h|0)<(i|0)?i:h;Hd(a,f,t,b,112);w=e+6|0;Nc(g,w,H[b>>2]);h=b+8|0;n=f+1|0;x=1;while(1){j=H[h>>2];if(j){b:{if((c|0)!=(j|0)?c:0){break b}c:{d:{i=I[j+55|0]|I[j+56|0]<<8;e:{if(!(!(I[b+28|0]&128)|(i&3)!=2)){k=H[b>>2];h=J[j+50>>1];break e}k=H[j>>2];h=J[j+52>>1];if(i&8){break d}}i=h;break c}i=J[j+50>>1]}o=H[j+36>>2];Nc(g,y,k);k=i-1|0;q=k+p|0;if((q|0)>H[a+44>>2]){H[a+44>>2]=q}x=o?x:0;Ua(g,112,n,H[j+44>>2],t);Ed(a,j);Sa(g,71,h,s);Sa(g,71,J[j+50>>1],A);B=_a(g,36,n);Ua(g,98,n,l,1);Sa(g,71,H[r+496>>2],z);ik(a,0,s,v,4,50840,0);Sa(g,71,0,s);f:{if(i>>>0<2){i=H[g+108>>2];break f}o=H[a+56>>2]-1|0;H[a+56>>2]=o;q=Nb(r,k<<2,0);if(!q){break b}Mb(g,9);i=H[g+108>>2];if(!(!I[j+54|0]|((k|0)!=1|J[j+50>>1]!=1))){Sa(g,51,p,o)}h=0;while(1){if((h|0)!=(k|0)){m=h<<2;C=Fi(a,H[m+H[j+32>>2]>>2]);Sa(g,71,h,s);Ua(g,94,n,h,l);D=q+m|0,E=fb(g,52,l,0,h+p|0,C,-2),H[D>>2]=E;m=H[g+108>>2];if((m|0)>0){G[(H[g+104>>2]+N(m,20)|0)-18>>1]=128}h=h+1|0;continue}break}Sa(g,71,k,s);Qb(g,o);m=H[g+108>>2];H[(I[H[g>>2]+87|0]?73336:(H[g+104>>2]+N(i,20)|0)-20|0)+8>>2]=m;h=0;while(1){if((h|0)!=(k|0)){if(I[H[g>>2]+87|0]){m=73336}else{m=H[g+104>>2]+N(H[q+(h<<2)>>2],20)|0}H[m+8>>2]=H[g+108>>2];Ua(g,94,n,h,h+p|0);h=h+1|0;continue}break}hb(g,o);db(r,q)}ik(a,1,v,l,2,50880,0);g:{if(H[r+496>>2]){h=_a(g,50,l);k=_a(g,16,l);o=gb(g,24,n,0,p,1);H[(I[H[g>>2]+87|0]?73336:H[g+104>>2]+N(h,20)|0)+8>>2]=H[g+108>>2];Sa(g,39,n,i);i=H[g+108>>2];h:{if(I[H[g>>2]+87|0]){H[18336]=i;h=73336;break h}h=H[g+104>>2];H[(h+N(k,20)|0)+8>>2]=i;h=h+N(o,20)|0}H[h+8>>2]=i;break g}Sa(g,39,n,i)}ik(a,0,v,u,1,50920,0);fb(g,97,w,3,l,20817,0);Sa(g,127,d,e);Ua(g,128,d,l,e);i=H[g+108>>2];if((i|0)>0){G[(H[g+104>>2]+N(i,20)|0)-18>>1]=8}H[(I[H[g>>2]+87|0]?73336:H[g+104>>2]+N(B,20)|0)+8>>2]=i}h=j+20|0;continue}break}if(!(x&255)|c){break a}Sa(g,98,f,u);b=_a(g,17,u);Sa(g,75,0,y);fb(g,97,w,3,l,20817,0);Sa(g,127,d,e);Ua(g,128,d,l,e);a=H[g+108>>2];if((a|0)>0){G[(H[g+104>>2]+N(a,20)|0)-18>>1]=8}H[(I[H[g>>2]+87|0]?73336:H[g+104>>2]+N(b,20)|0)+8>>2]=a}}function SF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=Ea-128|0;Ea=f;d=1;g=H[a>>2];a:{if(H[g+56>>2]){break a}i=b&65535;if(i){k=H[e>>2];d=1}else{d=0}if(b&65536){j=H[(d<<2)+e>>2];d=d+1|0}if(b&131072){m=H[(d<<2)+e>>2];d=d+1|0}l=b&262144?H[(d<<2)+e>>2]:l;gq(a);o=a,p=ay(m,0,-2147483648),H[o+72>>2]=p;H[a+76>>2]=Ha;o=a,p=ay(l,-1,2147483647),H[o+80>>2]=p;H[a+84>>2]=Ha;if(c){c=I[c|0]==68}else{c=I[g+239|0]}G[a+4>>1]=b;F[a+52|0]=c;b:{if(i>>>0>=2){h=$a(k);if(!h){d=J[k+16>>1];c=d&31;if((d&63)>>>0>=32){c=-1431655766>>>c|0}else{c=((1<<c)-1&-1431655766)<<32-c|-1431655766>>>c}if(!(c&1)){break b}}H[a+20>>2]=0;d=0;if(j){d=kb(j);H[a+20>>2]=d}c=I[g+236|0];e=H[g+36>>2];j=H[g+28>>2];n=H[g+24>>2];H[f+108>>2]=0;H[f+100>>2]=0;H[f+104>>2]=0;H[f+96>>2]=i-2;H[f+92>>2]=n;H[f+84>>2]=j;H[f+80>>2]=d;H[f+76>>2]=e;H[f+88>>2]=c;e=a+16|0;c:{if(!h){c=0;H[e>>2]=0;break c}i=g+8|0;d=$x(f+76|0,h,tb(h),e,f+124|0);c=H[e>>2];d:{if(!(!H[f+108>>2]|d)){_d(c);H[e>>2]=0;break d}e:{if(d){break e}if(!c){c=0;break c}d=Zl(e,12);c=H[e>>2];if(d){break e}d=_x(c,12);if(!d){break c}}_d(c);H[e>>2]=0;if((d|0)==1){break d}if((d|0)!=18){break a}H[f+64>>2]=12;Sd(i,25493,f- -64|0);d=1;break a}H[f+48>>2]=h;Sd(i,18311,f+48|0);d=1;break a}d=H[a>>2];H[f+76>>2]=0;H[f+124>>2]=0;H[f+120>>2]=0;Zx(a,c,f+124|0,f+120|0,f+76|0);f:{if(H[f+76>>2]){break f}c=H[f+124>>2];if(!I[d+236|0]|(c|0)<2){break f}d=N(c,24);c=ub(d+(H[f+120>>2]<<3)|0,0);if(!c){H[f+76>>2]=7;break f}H[f+116>>2]=c;h=c+d|0;H[f+112>>2]=h;d=0;Yx(a,0,H[a+16>>2],f+116|0,f+112|0,f+76|0);i=(H[f+116>>2]-c|0)/24|0;if(!H[f+76>>2]){j=H[f+112>>2]-h>>2;e=Xx(a,0,c,i);while(1){if(!((d|0)>=(j|0)|e)){e=Xx(a,H[h+(d<<2)>>2],c,i);d=d+1|0;continue}break}H[f+76>>2]=e}Ta(c)}eq(a,H[a+16>>2],f+76|0);d=H[f+76>>2];Ge(g);if(d){break a}H[a+32>>2]=0;H[a+36>>2]=0;H[a+40>>2]=H[a+44>>2]}g:{h:{i:{switch(b&65535){case 0:b=H[g+224>>2];j:{if(l|m){c=H[a+72>>2];d=H[a+76>>2];e=I[a+52|0];h=H[a+84>>2];H[f+16>>2]=H[a+80>>2];H[f+20>>2]=h;H[f+24>>2]=e?20380:20794;H[f+8>>2]=c;H[f+12>>2]=d;H[f>>2]=b;b=Ab(7104,f);break j}c=I[a+52|0];H[f+32>>2]=b;H[f+36>>2]=c?20380:20794;b=Ab(7076,f+32|0)}if(!b){break b}H[g+56>>2]=H[g+56>>2]+1;d=jp(H[g+12>>2],b,1,a+12|0);H[g+56>>2]=H[g+56>>2]-1;Ta(b);break h;case 1:break i;default:break g}}d=Wx(a);if(d){break a}d=pp(H[a+12>>2],1,k)}if(d){break a}}d=Vx(a);break a}d=7}Ea=f+128|0;return d|0}function NH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;b=Ea-336|0;Ea=b;i=H[H[a>>2]+20>>2];m=$a(H[c>>2]);j=$a(H[c+12>>2]);l=$a(H[c+16>>2]);d=kb(H[c+20>>2]);n=$a(H[c+24>>2]);o=kb(H[c+28>>2]);g=kb(H[c+32>>2]);a:{if(!n|(!m|!l)){break a}h=d;if((d|0)<0){break a}p=H[i+364>>2];ye(i);f=yc(i,l,j);if(!f|(d|0)>=G[f+34>>1]){break a}k=H[H[f+4>>2]+N(d,12)>>2];H[b+328>>2]=0;H[b+320>>2]=0;H[b+324>>2]=0;H[b+312>>2]=0;H[b+316>>2]=0;H[b+320>>2]=(d|0)==G[f+32>>1]?-1:d;H[i+364>>2]=0;d=b+28|0;e=ak(d,j,i,m,g);H[b+20>>2]=0;H[b+12>>2]=0;H[b+16>>2]=0;H[b+8>>2]=92;H[b+4>>2]=93;H[b+324>>2]=f;H[b+24>>2]=b+312;H[b>>2]=d;b:{if(e){break b}c:{d:{d=H[b+276>>2];if(d){e:{switch(I[d+43|0]){case 2:d=H[d+44>>2];H[d+4>>2]=H[d+4>>2]&-2097153;H[b+40>>2]=0;ee(b+28|0,d,0);e=I[i+87|0]?7:H[b+40>>2];if(e){break b}ec(b,d);break c;case 0:break e;default:break c}}j=Zb(l,H[d>>2]);H[b+324>>2]=d;if(j){break d}if((h|0)<G[d+34>>1]){Vc(b+28|0,b+312|0,H[H[d+4>>2]+N(h,12)>>2]);d=H[b+276>>2]}if(H[b+320>>2]<0){Vc(b+28|0,b+312|0,d+32|0);d=H[b+276>>2]}hc(b,H[d+16>>2]);e=H[b+276>>2]+8|0;while(1){d=H[e>>2];if(d){hc(b,H[d+40>>2]);e=d+20|0;continue}break}e=b+280|0;while(1){d=H[e>>2];if(d){hc(b,H[d+40>>2]);e=d+20|0;continue}else{e=0;while(1){d=H[b+276>>2];if(G[d+34>>1]<=(e|0)){break d}Jb(b,Mc(d,H[d+4>>2]+N(e,12)|0));e=e+1|0;continue}}}}d=H[b+280>>2];if(d){hc(b,H[d+40>>2]);Jb(b,H[H[b+280>>2]+36>>2]);break c}e=sm(b+28|0);if(e){break b}e=H[b+284>>2]+28|0;while(1){h=H[e>>2];if(h){d=H[h+12>>2];f:{if(!d){break f}g=b+28|0;if((of(g,0,d,j)|0)!=(f|0)){break f}d=H[h+32>>2];if(d){kz(g,b+312|0,H[d+8>>2],k)}g=b+28|0;d=b+312|0;jz(g,d,H[h+28>>2],k);kz(g,d,H[h+24>>2],k)}e=h+40|0;continue}break}d=H[b+284>>2];if((f|0)==H[b+160>>2]){jz(b+28|0,b+312|0,H[d+16>>2],k);d=H[b+284>>2]}Nq(b,d);break c}e=d+48|0;while(1){f=H[e>>2];if(!f){break c}g=f+36|0;e=0;while(1){if((e|0)<H[f+20>>2]){g:{if(j){break g}d=g+(e<<3)|0;if((h|0)!=H[d>>2]){break g}Vc(b+28|0,b+312|0,d)}h:{if(Zb(H[f+8>>2],l)){break h}d=H[(g+(e<<3)|0)+4>>2];if(Zb(d,k)){break h}Vc(b+28|0,b+312|0,d)}e=e+1|0;continue}break}e=f+4|0;continue}}e=Mq(a,b+312|0,m,n,o)}i:{j:{k:{switch(e|0){case 0:break i;case 1:break k;default:break j}}if((H[i+32>>2]&268435457)!=1){break j}Be(a,H[c>>2]);break i}if(H[b+32>>2]){Lq(a,30558,H[c+4>>2],H[c+8>>2],b+28|0);break i}Xd(a,e)}_j(b+28|0);rm(i,H[b+312>>2]);H[i+364>>2]=p}Ea=b+336|0}function Vh(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;e=Ea-16|0;Ea=e;H[e+8>>2]=b;H[e+12>>2]=a;k=I[c|0];i=I[c+1|0];l=I[c+3|0];a:{b:{c:while(1){b=H[e+12>>2];a=F[b|0];d:{if((a|0)>=0){H[e+12>>2]=b+1;break d}a=pd(e+12|0)}e:{f:{g:{if(a){if((a|0)==(k|0)){while(1){b=H[e+12>>2];a=F[b|0];h:{if((a|0)>=0){H[e+12>>2]=b+1;break h}a=pd(e+12|0)}if(!(!((a|0)==(i|0)&(i|0)!=0)&(a|0)!=(k|0))){if((a|0)!=(i|0)){continue}if(pd(e+8|0)){continue}break b}break}if(!a){g=0;break a}if((a|0)==(d|0)){if(I[c+2|0]){b=H[e+12>>2]-1|0;f=H[e+8>>2];while(1){h=I[f|0];if(!h){break b}g=Vh(b,f,c,d);if((g|0)!=1){break a}f=f+1|0;a=f;if(h>>>0<192){continue}while(1){g=I[a|0];f=a;a=a+1|0;if((g&192)==128){continue}break}continue}}a=pd(e+12|0);if(!a){break b}}if(a>>>0<128){break e}f=H[e+12>>2];while(1){g=H[e+8>>2];b=F[g|0];i:{if((b|0)>=0){H[e+8>>2]=g+1;break i}b=pd(e+8|0)}if(!b){break b}if((a|0)!=(b|0)){continue}g=Vh(f,H[e+8>>2],c,d);if((g|0)==1){continue}break}break a}if((a|0)==(d|0)){j:{if(!I[c+2|0]){a=pd(e+12|0);if(a){break j}g=1;break a}g=1;j=pd(e+8|0);if(!j){break a}a=0;m=0;h=0;b=e+12|0;f=pd(b);if((f|0)==94){m=1;f=pd(b)}if((f|0)!=93){break g}h=(j|0)==93;b=0;break f}o=H[e+12>>2]}f=H[e+8>>2];b=F[f|0];k:{if((b|0)>=0){H[e+8>>2]=f+1;break k}b=pd(e+8|0)}if((a|0)==(b|0)){continue}if(!(!l|(a|b)>>>0>127)){if(I[(a&255)+30768|0]==I[(b&255)+30768|0]){continue}}g=1;if(!b|(a|0)!=(i|0)){break a}if(H[e+12>>2]!=(o|0)){continue}break a}g=I[H[e+8>>2]]!=0;break a}b=1}while(1){l:{m:{n:{o:{if(!b){a=0;break o}b=a;a=f;p:{if((a|0)!=45){if((a|0)==93){break m}if(!a){break a}break p}n=I[H[e+12>>2]];if(!b|(n|0)==93){break p}if(n){break n}}h=(a|0)==(j|0)?1:h}f=pd(e+12|0);b=1;continue}h=(p=h,q=pd(e+12|0)>>>0>=j>>>0?1:h,r=b>>>0>j>>>0,r?p:q);break l}if((h|0)!=(m|0)){continue c}break a}b=0;continue}}break}q:{if(l){F[e+7|0]=0;f=I[a+30768|0];a=(I[a+31152|0]^-1|-33)&a;break q}f=0}F[e+6|0]=f;F[e+5|0]=a;h=H[e+12>>2];a=H[e+8>>2];while(1){g=Ea-32|0;Ea=g;b=e+5|0;f=F[b|0];r:{if(!(I[b+1|0]?f:0)){b=Lw(a,f);break r}Xa(g,0,32);f=I[b|0];if(f){while(1){i=g+(f>>>3&28)|0;H[i>>2]=H[i>>2]|1<<f;f=I[b+1|0];b=b+1|0;if(f){continue}break}}b=a;f=I[a|0];if(!f){break r}while(1){if(H[g+(f>>>3&28)>>2]>>>f&1){break r}f=I[b+1|0];b=b+1|0;if(f){continue}break}}Ea=g+32|0;a=(b-a|0)+a|0;if(!I[a|0]){break b}a=a+1|0;g=Vh(h,a,c,d);if((g|0)==1){continue}break}break a}g=2}Ea=e+16|0;return g}function OI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=Ea+-64|0;Ea=e;b=H[H[a>>2]+20>>2];H[e+60>>2]=0;H[e+56>>2]=0;H[e+48>>2]=0;d=$a(H[c>>2]);i=d?d:30558;c=$a(H[c+4>>2]);a:{b:{c:{d:{e:{f:{g:{h:{i:{if(I[b+178|0]&4){H[e+52>>2]=0;c=Xl(18024);H[e+44>>2]=c;if(!c){break a}c=gj(c,50700,b,e+52|0,0,256);if(c){break b}c=H[e+52>>2];f=rl(b,c);if(f){d=H[b+16>>2]+(I[b+176|0]<<4)|0;g=H[d+4>>2];if(g){rf(g)}H[d+12>>2]=f;H[d+4>>2]=c;F[b+95|0]=0;break i}rf(c);c=7;break b}j:{d=H[b+20>>2];f=H[b+148>>2];k:{if((d|0)<(f+2|0)){f=c?c:30558;c=0;g=(d|0)>0?d:0;while(1){if((c|0)==(g|0)){break j}h=Nk(b,c,f);c=c+1|0;if(!h){continue}break}H[e+16>>2]=f;d=mb(b,13432,e+16|0);break k}H[e+32>>2]=f;d=mb(b,16981,e+32|0)}H[e+48>>2]=d;c=0;break e}c=H[b+16>>2];l:{if((c|0)==(b+460|0)){c=Nb(b,48,0);if(!c){break a}d=H[b+16>>2];g=H[d+4>>2];H[c>>2]=H[d>>2];H[c+4>>2]=g;g=H[d+28>>2];H[c+24>>2]=H[d+24>>2];H[c+28>>2]=g;g=H[d+20>>2];H[c+16>>2]=H[d+16>>2];H[c+20>>2]=g;g=H[d+12>>2];H[c+8>>2]=H[d+8>>2];H[c+12>>2]=g;break l}c=ed(b,c,(d<<4)+16|0,0);if(!c){break a}}H[b+16>>2]=c;d=(H[b+20>>2]<<4)+c|0;H[d>>2]=0;H[d+4>>2]=0;H[d+8>>2]=0;H[d+12>>2]=0;H[e+52>>2]=H[b+60>>2];c=Ev(H[H[b>>2]+16>>2],i,e+52|0,e+44|0,e+60|0,e+56|0);if(c){if((c|0)==7){Ib(b)}b=a;a=H[e+56>>2];Gb(b,a,-1);Ta(a);break a}c=H[e+52>>2]|256;H[e+52>>2]=c;h=H[e+60>>2];c=gj(H[e+44>>2],h,b,d+4|0,0,c);H[b+20>>2]=H[b+20>>2]+1;k=d,l=Tb(b,f),H[k>>2]=l;F[b+95|0]=0;if((c|0)==19){break h}if(c){break g}c=H[d+4>>2]}f=rl(b,c);H[d+12>>2]=f;m:{if(!f){g=0;c=7;break m}g=1;c=0;if(!I[f+76|0]|I[f+77|0]==I[b+84|0]){break m}g=0;k=e,l=mb(b,13553,0),H[k+48>>2]=l;c=1}f=H[d+4>>2];j=H[f+4>>2];H[j+4>>2]=H[f>>2];Br(H[j>>2],I[b+89|0]);Wm(H[d+4>>2],Wm(H[H[b+16>>2]+4>>2],-1));go(H[d+4>>2],H[b+32>>2]&56|3);F[d+8|0]=3;if(!g){break f}c=H[d>>2]?0:7;break f}k=e,l=mb(b,16361,0),H[k+48>>2]=l;c=1}F[d+8|0]=3}cp(h);if(!c){ye(b);F[b+176|0]=0;H[b+24>>2]=H[b+24>>2]&-17;if(I[b+178|0]&4){break a}c=bp(b,e+48|0);if(!c){break a}}if(I[b+178|0]&4){d=H[e+48>>2];break e}d=H[b+20>>2]-1|0;f=H[(H[b+16>>2]+(d<<4)|0)+4>>2];if(f){rf(f);f=H[b+16>>2]+(d<<4)|0;H[f+12>>2]=0;H[f+4>>2]=0}yf(b);H[b+20>>2]=d;n:{if(!((c|0)!=3082&(c|0)!=7)){Ib(b);Za(b,H[e+48>>2]);d=mb(b,1150,0);break n}d=H[e+48>>2];if(d){break d}H[e>>2]=i;d=mb(b,8173,e)}H[e+48>>2]=d}if(!d){break c}}Gb(a,d,-1);Za(b,H[e+48>>2])}if(!c){break a}}Xd(a,c)}Ea=e- -64|0}function Ox(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0;c=Ea-128|0;Ea=c;H[c+20>>2]=0;a:{d=Lb(a,27,c+20|0,0);if(d){break a}e=H[c+20>>2];Zc(e,1,H[a+288>>2]);Zc(e,2,H[a+260>>2]);d=0;while(1){b:{c:{if(d){break c}if((vb(e)|0)!=100){break c}d=0;m=Fd(e,0);e=0;while(1){if(H[a+260>>2]<=(e|0)){break b}j=0;k=0;if(!d){H[c+120>>2]=0;H[c+112>>2]=0;H[c+116>>2]=0;f=c+48|0;Xa(f,0,64);H[c+124>>2]=19;d:{d=hi(a,m,e,-2,0,0,0,1,f);if(d){break d}d=Qj(a,f,c+112|0);if(d){break d}e:while(1){d=gi(a,c+48|0);if((d|0)!=100){break d}h=H[c+108>>2];d=H[c+104>>2];f=0;g=0;H[c+40>>2]=0;H[c+44>>2]=0;H[c+32>>2]=0;H[c+36>>2]=0;l=d+h|0;d=zc(d,c+40|0)+d|0;while(1){if(d>>>0>=l>>>0){continue e}H[c+24>>2]=0;H[c+28>>2]=0;d=zc(d,c+24|0)+d|0;if(l>>>0<=d>>>0){continue}i=H[c+28>>2];h=H[c+24>>2];if(!i&h>>>0<=1){H[c+32>>2]=0;H[c+36>>2]=0;if(h|i){d=zc(d,c+32|0)+d|0;f=0;g=0;continue}d=zc(d,c+24|0)+d|0;h=H[c+24>>2];g=H[c+28>>2];f=H[c+40>>2];i=H[c+44>>2];if(I[a+239|0]){H[c+40>>2]=f-h;H[c+44>>2]=i-((f>>>0<h>>>0)+g|0);f=0;g=0;continue}g=g+i|0;i=f;f=f+h|0;g=i>>>0>f>>>0?g+1|0:g;H[c+40>>2]=f;H[c+44>>2]=g;f=0;g=0}else{n=H[c+96>>2];o=H[c+100>>2];p=H[c+40>>2];q=H[c+44>>2];r=H[c+32>>2];g=g+i|0;i=h;h=f+h|0;g=(i>>>0>h>>>0?g+1|0:g)-(h>>>0<2)|0;f=h-2|0;j=Qp(n,o,m,e,p,q,r,f)^j;k=k^Ha}continue}}}$g(c+48|0)}e=e+1|0;t=j^t;u=k^u;continue}}j=0;k=0;e=ob(e);if(d){break a}if(e){d=e;break a}n=H[H[a+36>>2]>>2];H[c+48>>2]=0;H[c>>2]=H[a+224>>2];e=Ab(7317,c);f:{if(!e){d=7;e=0;break f}d=ph(H[a+12>>2],e,-1,c+48|0,0);Ta(e);e=H[c+48>>2]}g:while(1){h:{if(d){break h}if((vb(e)|0)!=100){break h}d=0;m=Xc(e,0);o=Ha;l=_p(a,e);h=0;while(1){if(d){continue g}f=h;if((f|0)>=H[a+24>>2]){continue g}h=f+1|0;d=0;if(I[f+H[a+32>>2]|0]){continue}d=$e(e,h);H[c+112>>2]=0;g=jg(H[a+36>>2],l,d,-1,c+112|0);i=H[c+112>>2];i:while(1){if(!g){H[c+32>>2]=0;H[c+24>>2]=0;H[c+16>>2]=0;H[c+12>>2]=0;g=Ia[H[n+20>>2]](i,c+40|0,c+32|0,c+24|0,c+16|0,c+12|0)|0;if(g){continue}p=H[c+40>>2];q=H[c+32>>2];r=H[c+12>>2];j=Qp(p,q,l,0,m,o,f,r)^j;k=k^Ha;d=1;s=H[a+260>>2];s=(s|0)<=1?1:s;while(1){if((d|0)==(s|0)){continue i}v=H[H[a+264>>2]+N(d,24)>>2];if((v|0)<=(q|0)){j=Qp(p,v,l,d,m,o,f,r)^j;k=k^Ha}d=d+1|0;continue}}break}if(i){Ia[H[n+16>>2]](i)|0}d=(g|0)!=101?g:0;continue}}break}Wc(e);break a}e=H[c+20>>2];continue}}H[b>>2]=!d&((j|0)==(t|0)&(k|0)==(u|0));Ea=c+128|0;return d}function pB(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0,K=0,L=0;j=Ea-48|0;Ea=j;a:{if(!(I[H[a>>2]+33|0]&64)){break a}y=c?-127:-128;z=b+32|0;A=H[12576];B=H[12577];C=H[12574];D=H[12575];k=xg(b);v=(c|0)!=0;E=v<<2;while(1){if(!k){break a}b:{if(e){if(!Tq(b,k,e,f)){break b}}g=H[a>>2];q=H[g+36>>2]&8?0:I[(k+v|0)+25|0];if(!!(H[g+32>>2]&524288)&(q|0)==7){break b}w=k+E|0;i=H[w+28>>2];c:{if(!(i|!q)){H[j+44>>2]=0;H[j+40>>2]=0;if(ri(a,b,k,j+44|0,j+40|0)){break b}l=0;m=(q|0)!=7;r=m&((c|0)!=0|(q|0)!=10);n=k+36|0;t=q-9|0;s=0;i=0;o=0;while(1){if(H[k+20>>2]>(i|0)){H[j+32>>2]=C;H[j+36>>2]=D;H[j+24>>2]=A;H[j+28>>2]=B;h=H[j+40>>2];p=H[(h?h+(i<<2)|0:n)>>2];h=z;u=H[b+4>>2];x=H[j+44>>2];if(x){h=H[x+4>>2]+(i<<1)|0}h=H[N(G[h>>1],12)+u>>2];H[j+8>>2]=h;K=j,L=bb(h),H[K+12>>2]=L;p=N(p,12);h=H[p+H[H[k>>2]+4>>2]>>2];H[j+16>>2]=h;K=j,L=bb(h),H[K+20>>2]=L;u=j+32|0;h=j+8|0;l=Td(a,l,ib(a,53,ib(a,141,sc(g,59,u,0),sc(g,59,h,0)),sc(g,59,j+16|0,0)));if(c){o=Td(a,o,ib(a,45,ib(a,141,sc(g,59,u,0),sc(g,59,h,0)),ib(a,141,sc(g,59,j+24|0,0),sc(g,59,h,0))))}if(r){d:{e:{f:{switch(t|0){case 1:h=ib(a,141,sc(g,59,j+24|0,0),sc(g,59,j+8|0,0));break d;case 0:break f;default:break e}}h=H[k>>2];p=H[h+4>>2]+p|0;if(I[p+10|0]&96){break e}h=Mc(h,p);if(!h){break e}h=jb(g,h,0);break d}h=sc(g,121,0,0)}s=Pb(a,s,h);zg(a,s,j+16|0,0)}i=i+1|0;continue}break}Za(g,H[j+40>>2]);r=0;n=H[H[k>>2]>>2];t=bb(n);g:{if(m){h=l;l=0;break g}h=Fb(g,H[b+60>>2]);m=oc(g,71,15982);if(m){F[m+1|0]=2}i=Gd(a,0,0,0);if(i){K=i,L=Tb(g,n),H[K+16>>2]=L;K=i,L=Tb(g,H[H[g+16>>2]+(h<<4)>>2]),H[K+12>>2]=L}h=0;l=xd(a,Yc(H[a>>2],m),i,l,0,0,0,0,0)}G[g+308>>1]=0;H[g+304>>2]=H[g+304>>2]+1;i=nb(g,t+85|0,0);h:{if(!i){break h}m=i+84|0;H[i+48>>2]=m;r=i+36|0;H[i+28>>2]=r;Va(m,n,t);K=i,L=jb(g,h,1),H[K+56>>2]=L;K=i,L=pc(g,s,1),H[K+60>>2]=L;K=i,L=Ud(g,l,1),H[K+44>>2]=L;if(!o){o=0;break h}o=ib(a,19,o,0);K=i,L=jb(g,o,1),H[K+12>>2]=L}n=H[g+304>>2]-1|0;H[g+304>>2]=n;G[g+308>>1]=n?0:J[g+310>>1];eb(g,h);eb(g,o);pb(g,s);fc(g,l);if(I[g+87|0]==1){Pi(g,i);break b}l=138;i:{j:{k:{switch(q-7|0){case 0:break i;case 3:break k;default:break j}}if(c){break j}l=128;break i}l=129}H[r+4>>2]=i;F[r|0]=l;h=H[b+60>>2];H[i+24>>2]=h;H[i+20>>2]=h;H[w+28>>2]=i;F[i+8|0]=y;break c}if(!i){break b}}xz(a,i,b,d,2,0)}k=H[k+12>>2];continue}}Ea=j+48|0}function bD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;l=Ea-112|0;Ea=l;o=Ia[H[16724]]()|0;j=H[a+36>>2];a:{b:{if(j){f=H[j>>2];break b}k=ub(16,0);if(!k){g=7;break a}H[k>>2]=0;H[k+4>>2]=0;H[k+8>>2]=0;H[k+12>>2]=0;c:{m=H[a+8>>2];f=H[m+40>>2];if(f){break c}p=H[a+32>>2];d:{if(Ia[H[16664]](H[a+12>>2],l+16|0)|0){g=1802;break d}j=tb(p);i=j+74|0;f=ub(i,0);if(!f){g=7;break d}h=Xa(f,0,i);i=h+68|0;H[h+8>>2]=i;H[l>>2]=p;i=Bd(j+6|0,i,11486,l);H[h+12>>2]=-1;j=H[a+8>>2];H[j+40>>2]=h;H[h>>2]=j;if(I[65924]){H[h+4>>2]=8}if(I[m+29|0]){break c}e:{if(!Wk(H[a+32>>2],11473,0)){g=xh(i,131138,H[l+20>>2]&511);H[h+12>>2]=g;break e}g=H[h+12>>2]}if((g|0)<0){g=xh(i,131072,H[l+20>>2]&511);H[h+12>>2]=g;if((g|0)<0){g=Id(ie(42737),11299,i,42737);break d}F[h+22|0]=1}m=H[l+32>>2];j=H[l+28>>2];if(!(Ia[H[16712]]()|0)){Ia[H[16709]](g,j,m)|0}g=qv(a,h);if((g|0)==1288|!g){break c}}pv(a);Ta(k);break a}H[k>>2]=f;H[f+28>>2]=H[f+28>>2]+1;H[a+36>>2]=k;H[k+4>>2]=H[f+32>>2];H[f+32>>2]=k;if(g){break a}}f:{if(I[f+23|0]){n=qv(a,f);if(n){break f}F[f+23|0]=0}n=0;h=(o|0)<32768?1:o>>>15|0;a=h+b|0;k=a-((a|0)%(h|0)|0)|0;if((k|0)<=J[f+20>>1]){break f}H[f+16>>2]=c;g:{h:{a=H[f+12>>2];if((a|0)<0){break h}if(Ia[H[16664]](a,l+16|0)|0){n=4874;break f}m=H[l+44>>2];i=N(c,k);j=i>>31;a=H[l+40>>2];if((m|0)>=(j|0)&i>>>0<=a>>>0|(j|0)<(m|0)){break h}if(!d){break f}d=tJ(a,m,4096,0);a=(i|0)/4096|0;j=(a|0)>(d|0)?a:d;i=j>>31;a=d>>31;while(1){if((d|0)==(j|0)&(a|0)==(i|0)){break h}if((ov(H[f+12>>2],d<<12|4095,a<<12|d>>>20,30558,1,l+12|0)|0)!=1){break g}d=d+1|0;a=d?a:a+1|0;continue}}d=H[f+24>>2];if(oe()){a=0}else{a=k<<2;a=Ld(d,(a|0)>0?a:0,0)}if(!a){n=3082;break f}H[f+24>>2]=a;o=(h|0)>0?h:0;d=N(c,h);p=d>>31;a=J[f+20>>1];i=c>>31;while(1){a=a&65535;if((k|0)<=(a|0)){break f}m=H[f+12>>2];i:{if((m|0)>=0){g=(r=0,s=d,t=I[f+22|0]?1:3,u=1,v=m,w=sJ(a,0,c,i),x=Ha,q=H[16715],Ia[q](r|0,s|0,t|0,u|0,v|0,w|0,x|0)|0);if((g|0)!=-1){break i}n=5386;Id(5386,9934,H[f+8>>2],42908);break f}g=ub(d,p);if(!g){n=7;break f}Xa(g,0,d)}a=0;while(1){if((a|0)!=(o|0)){H[(H[f+24>>2]+(a<<2)|0)+(J[f+20>>1]<<2)>>2]=N(a,c)+g;a=a+1|0;continue}break}a=h+J[f+20>>1]|0;G[f+20>>1]=a;continue}}n=4874;Id(4874,13070,H[f+8>>2],42881)}H[e>>2]=J[f+20>>1]>(b|0)?H[H[f+24>>2]+(b<<2)>>2]:0;g=n?n:I[f+22|0]?8:n}Ea=l+112|0;return g|0}function Du(a){var b=0,c=0,d=0,e=0,f=0,g=0;c=Ea-32|0;Ea=c;a:{b:{b=H[a+232>>2];c:{d:{e:{if(!b){f:{if(I[a+17|0]){break f}b=No(a,1);if(b){break c}g:{if(I[a+18|0]<=1){d=H[a>>2];H[c>>2]=1;h:{i:{j:{g=H[H[a+68>>2]>>2];if(!g){b=Ia[H[d+32>>2]](d,H[a+188>>2],0,c)|0;if(b|!H[c>>2]){break j}}H[c+28>>2]=0;b=H[a+64>>2];b=Ia[H[H[b>>2]+36>>2]](b,c+28|0)|0;if(b|H[c+28>>2]){break h}b=Go(a,c+24|0);if(b){break h}if(!(H[c+24>>2]|g)){b=H[18327];if(b){Ia[b|0]()}k:{if(Sf(a,2)){break k}b=H[d+28>>2];if(b){Ia[b|0](d,H[a+188>>2],0)|0}if(I[a+4|0]){break k}Jg(a,1)}b=H[18328];if(!b){break i}Ia[b|0]();break i}l:{if(!g){H[c+20>>2]=2049;b=Ia[H[d+24>>2]](d,H[a+188>>2],H[a+68>>2],2049,c+20|0)|0;if((b|0)==14){break l}if(b){break h}}F[c+20|0]=0;b=H[a+68>>2];d=Ia[H[H[b>>2]+8>>2]](b,c+20|0,1,0,0)|0;f=(d|0)==522;m:{if(g){break m}b=H[a+68>>2];g=H[b>>2];if(!g){break m}Ia[H[g+4>>2]](b)|0;H[b>>2]=0}b=f?0:d;f=I[c+20|0]!=0;break h}b=0;f=1;break h}if(b){break c}break g}b=0}if(b){break c}if(!f){break g}}b=776;if(I[a+14|0]){break c}b=Sf(a,4);if(b){break c}n:{o:{p:{if(!H[H[a+68>>2]>>2]){b=0;if(I[a+5|0]==2){break p}d=H[a>>2];b=Ia[H[d+32>>2]](d,H[a+188>>2],0,c)|0;f=H[a+68>>2];if(!(!H[c>>2]|b)){H[c+28>>2]=0;b=Ia[H[d+24>>2]](d,H[a+188>>2],f,2050,c+28|0)|0;q:{if(b){break q}b=0;if(!(F[c+28|0]&1)){break q}b=ie(62025);d=H[a+68>>2];f=H[d>>2];if(!f){break q}Ia[H[f+4>>2]](d)|0;H[d>>2]=0}f=H[a+68>>2]}if(!H[f>>2]){break p}}b=fv(a);if(b){break n}b=Lo(a,!I[a+12|0]);F[a+17|0]=0;break o}if(I[a+4|0]){break o}Jg(a,1)}if(!b){break g}}b=Nj(a,b);break c}if(I[a+12|0]){break f}if(I[a+24|0]){b=H[a+64>>2];b=Ia[H[H[b>>2]+8>>2]](b,c,16,24,0)|0;if(b){if((b|0)!=522){break d}H[c+8>>2]=0;H[c+12>>2]=0;H[c>>2]=0;H[c+4>>2]=0}if(Hb(a+112|0,c,16)){Lg(a)}if(I[a+12|0]){break f}}b=H[a>>2];e=Ia[H[b+32>>2]](b,H[a+236>>2],0,c)|0;if(e){break f}r:{if(H[c>>2]){e=Go(a,c+28|0);if(e){break f}if(!H[c+28>>2]){b=H[a>>2];e=H[b+28>>2];if(e){break r}e=0;break f}e=Cu(a,0);break f}if(I[a+5|0]!=5){break f}F[a+5|0]=0;break f}e=Ia[e|0](b,H[a+236>>2],0)|0}b=H[a+232>>2];if(!b){break e}}H[c+28>>2]=0;Qo(b);b=H[a+232>>2];H[c>>2]=0;while(1){e=av(b,c+28|0,0,c);if((e|0)==-1){continue}break}if(!(H[c+28>>2]|e)){break e}Lg(a)}if(!(I[a+12|0]|I[a+17|0])){b=e;if(b){break d}b=Go(a,a+28|0);break d}b=e}if(!b){break b}}ml(a);break a}F[a+24|0]=1;F[a+17|0]=1;b=0}Ea=c+32|0;return b}function ci(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;g=Ea-48|0;Ea=g;H[g+44>>2]=H[a>>2];h=H[e>>2];H[g+40>>2]=h;i=H[f>>2];H[g+36>>2]=i;H[g+32>>2]=0;H[g+28>>2]=0;if(I[h|0]==1){n=h+1|0;h=F[h+1|0];a:{if((h|0)<0){k=qc(n,g+32|0);break a}H[g+32>>2]=h;k=1}H[g+40>>2]=k+n}if(I[i|0]==1){l=1;h=i+1|0;i=F[i+1|0];b:{if((i|0)<0){l=qc(h,g+28|0);break b}H[g+28>>2]=i}H[g+36>>2]=h+l}p=b;r=b>>31;s=(c|0)!=0;while(1){c:{b=H[g+32>>2];h=H[g+28>>2];if((b|0)==(h|0)){l=H[g+44>>2];H[g+16>>2]=0;H[g+20>>2]=0;H[g+8>>2]=0;H[g+12>>2]=0;H[g>>2]=0;H[g+4>>2]=0;if(b){F[l|0]=1;h=l+1|0;t=g,u=mc(h,b,b>>31)+h|0,H[t+44>>2]=u}bi(g+40|0,g+8|0);i=H[g+8>>2];h=i-2|0;j=H[g+12>>2];b=j-(i>>>0<2)|0;k=b;H[g+8>>2]=h;H[g+12>>2]=b;bi(g+36|0,g);n=H[g>>2];b=n-2|0;o=H[g+4>>2];m=o-(n>>>0<2)|0;H[g>>2]=b;H[g+4>>2]=m;if(i>>>0<2&(j|0)<=0|(j|0)<0|(n>>>0<2&(o|0)<=0|(o|0)<0)){break c}while(1){i=k+r|0;n=h+p|0;i=n>>>0<p>>>0?i+1|0:i;d:{while(1){if(!((m|0)<=(k|0)&b>>>0<=h>>>0|(m|0)<(k|0)|d|((i|0)<=(m|0)&b>>>0>n>>>0|(i|0)<(m|0))?(b|0)!=(n|0)|(i|0)!=(m|0):0)){o=g+44|0;l=g+16|0;j=c?k:m;q=(c?h:b)+2|0;j=q>>>0<2?j+1|0:j;yx(o,l,q,j);j=H[g+16>>2];o=H[g+20>>2]-(j>>>0<2)|0;j=j-2|0;H[g+16>>2]=j;H[g+20>>2]=o;l=0}if(!(((i|0)<=(m|0)&b>>>0>n>>>0|(i|0)<(m|0)|s)&(b>>>0>h>>>0&(m|0)>=(k|0)|(m|0)>(k|0)))){if(I[H[g+36>>2]]<2){break d}bi(g+36|0,g);j=H[g>>2];b=j-2|0;j=H[g+4>>2]-(j>>>0<2)|0;m=j;H[g>>2]=b;H[g+4>>2]=j;continue}break}if(I[H[g+40>>2]]<2){break d}bi(g+40|0,g+8|0);i=H[g+8>>2];h=i-2|0;i=H[g+12>>2]-(i>>>0<2)|0;k=i;H[g+8>>2]=h;H[g+12>>2]=i;continue}break}if(l){H[g+44>>2]=l}tf(0,g+40|0);tf(0,g+36|0);b=H[g+40>>2];if(!I[b|0]){break c}h=H[g+36>>2];if(!I[h|0]){break c}i=b+1|0;b=F[b+1|0];e:{if((b|0)<0){b=qc(i,g+32|0);break e}H[g+32>>2]=b;b=1}H[g+40>>2]=b+i;b=h+1|0;h=F[h+1|0];f:{if((h|0)<0){k=qc(b,g+28|0);break f}H[g+28>>2]=h;k=1}H[g+36>>2]=k+b;continue}if((b|0)<(h|0)){tf(0,g+40|0);b=H[g+40>>2];if(!I[b|0]){break c}h=b+1|0;b=F[b+1|0];g:{if((b|0)<0){b=qc(h,g+32|0);break g}H[g+32>>2]=b;b=1}H[g+40>>2]=b+h;continue}tf(0,g+36|0);b=H[g+36>>2];if(!I[b|0]){break c}h=b+1|0;b=F[b+1|0];h:{if((b|0)<0){b=qc(h,g+28|0);break h}H[g+28>>2]=b;b=1}H[g+36>>2]=b+h;continue}break}l=0;qe(0,g+36|0);qe(0,g+40|0);H[e>>2]=H[g+40>>2];H[f>>2]=H[g+36>>2];Ea=g+48|0;b=H[g+44>>2];if((b|0)!=H[a>>2]){F[b|0]=0;H[a>>2]=b+1;l=1}return l}function lm(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(!b){break a}h=H[a+8>>2];e=H[a+12>>2];g=H[a+20>>2];d=g;f=H[a+16>>2];j=c+f|0;d=j>>>0<c>>>0?d+1|0:d;j=j+2|0;d=j>>>0<2?d+1|0:d;if((d|0)==(e|0)&h>>>0<=j>>>0|d>>>0>e>>>0){if(ji(a,c+2|0)){break a}g=H[a+20>>2];f=H[a+16>>2]}e=f+1|0;if(!e){g=g+1|0}H[a+16>>2]=e;H[a+20>>2]=g;F[H[a+4>>2]+f|0]=34;while(1){g=0;b:{c:{d:{e:{while(1){f:{f=g|3;if(f>>>0>=c>>>0){e=g;while(1){if(c>>>0<=e>>>0){break f}if(!I[I[b+e|0]+51984|0]){break e}e=e+1|0;continue}}if(!I[I[b+g|0]+51984|0]){e=g;break e}e=g|1;if(!I[I[e+b|0]+51984|0]){break e}e=g|2;if(!I[I[e+b|0]+51984|0]){break e}e=f;if(!I[I[e+b|0]+51984|0]){break e}g=g+4|0;continue}break}f=H[a+16>>2];e=c>>>0>g>>>0?c:g;d=H[a+20>>2];if(!e){break c}break d}if(c>>>0>e>>>0){break b}f=H[a+16>>2]}Va(H[a+4>>2]+f|0,b,e);d=H[a+20>>2];f=e+H[a+16>>2]|0;d=f>>>0<e>>>0?d+1|0:d}b=f+1|0;d=b?d:d+1|0;H[a+16>>2]=b;H[a+20>>2]=d;F[f+H[a+4>>2]|0]=34;break a}if(e){Va(H[a+4>>2]+H[a+16>>2]|0,b,e);g=H[a+20>>2];f=e+H[a+16>>2]|0;g=f>>>0<e>>>0?g+1|0:g;H[a+16>>2]=f;H[a+20>>2]=g;c=c-e|0;b=b+e|0}g:{h:{i:{h=I[b|0];if((h|0)!=92){if((h|0)==39){e=h;break g}if((h|0)!=34){break i}}e=h;break h}e=I[h+52592|0];if(e){break h}j=H[a+8>>2];e=H[a+12>>2];g=H[a+20>>2];d=g;f=H[a+16>>2];i=c+f|0;d=i>>>0<c>>>0?d+1|0:d;i=i+7|0;d=i>>>0<7?d+1|0:d;if((d|0)==(e|0)&j>>>0<i>>>0|d>>>0>e>>>0){if(ji(a,c+7|0)){break a}g=H[a+20>>2];f=H[a+16>>2]}d=g;e=f+1|0;d=e?d:d+1|0;H[a+16>>2]=e;H[a+20>>2]=d;F[H[a+4>>2]+f|0]=92;e=H[a+20>>2];f=H[a+16>>2];d=f+1|0;e=d?e:e+1|0;H[a+16>>2]=d;H[a+20>>2]=e;F[f+H[a+4>>2]|0]=117;d=H[a+20>>2];f=H[a+16>>2];e=f+1|0;d=e?d:d+1|0;H[a+16>>2]=e;H[a+20>>2]=d;F[f+H[a+4>>2]|0]=48;d=H[a+20>>2];f=H[a+16>>2];e=f+1|0;d=e?d:d+1|0;H[a+16>>2]=e;H[a+20>>2]=d;F[f+H[a+4>>2]|0]=48;e=H[a+20>>2];f=H[a+16>>2];d=f+1|0;e=d?e:e+1|0;H[a+16>>2]=d;H[a+20>>2]=e;F[f+H[a+4>>2]|0]=I[(h>>>4|0)+12672|0];e=I[(h&15)+12672|0];break g}j=H[a+8>>2];h=H[a+12>>2];g=H[a+20>>2];d=g;f=H[a+16>>2];i=c+f|0;d=i>>>0<c>>>0?d+1|0:d;i=i+3|0;d=i>>>0<3?d+1|0:d;if((d|0)==(h|0)&j>>>0<i>>>0|d>>>0>h>>>0){if(ji(a,c+3|0)){break a}g=H[a+20>>2];f=H[a+16>>2]}d=f+1|0;if(!d){g=g+1|0}H[a+16>>2]=d;H[a+20>>2]=g;F[H[a+4>>2]+f|0]=92}d=H[a+20>>2];f=H[a+16>>2];g=f+1|0;d=g?d:d+1|0;H[a+16>>2]=g;H[a+20>>2]=d;F[f+H[a+4>>2]|0]=e;c=c-1|0;b=b+1|0;continue}}}function us(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Ea-80|0;Ea=g;j=H[a>>2];a:{if(I[j+87|0]){break a}if(ze(a)){break a}if(d){F[j+91|0]=I[j+91|0]+1}e=df(a,c,b+8|0);b:{if(!d){if(!e){break a}break b}F[j+91|0]=I[j+91|0]-1;if(e){break b}Ji(a,H[b+12>>2]);Gk(a);break a}h=Fb(j,H[e+60>>2]);if(I[e+43|0]==1){if(cf(a,e)){break a}}d=(h|0)==1;f=H[H[j+16>>2]+(h<<4)>>2];if(Yb(a,9,d?9192:9211,0,f)){break a}c:{if(c){d=d?15:17}else{if(I[e+43|0]==1){d=30;i=H[H[zd(j,e)+4>>2]+4>>2];break c}d=(h|0)==1?13:11}i=0}if(Yb(a,d,H[e>>2],i,f)){break a}if(Yb(a,9,H[e>>2],0,f)){break a}d:{d=H[e>>2];e:{f:{if(!yb(d,18214,7)){f=d+7|0;if(!yb(f,3601,4)){break d}f=(yb(f,4469,10)|0)!=0;break f}f=H[e+28>>2];if(f&4096){if(qh(j)){break e}}f=f>>>15&1}if(!f){break d}}H[g+64>>2]=d;Wa(a,15861,g- -64|0);break a}f=I[e+43|0];g:{if(c){if((f|0)==2){break g}H[g+48>>2]=d;Wa(a,7042,g+48|0);break a}if((f|0)!=2){break g}H[g>>2]=d;Wa(a,6488,g);break a}if(!wb(a)){break a}kd(a,1,h);h:{if(c){break h}Is(a,h,11753,H[e>>2]);i=H[a>>2];if(I[e+43|0]|!(I[i+33|0]&64)){break h}f=wb(a);d=0;if(!xg(e)){d=e+48|0;while(1){d=H[d>>2];if(!d){break h}if(!I[d+24|0]){d=d+4|0;if(!(I[i+34|0]&8)){continue}}break}d=H[a+56>>2]-1|0;H[a+56>>2]=d;Sa(f,49,1,d)}F[a+161|0]=1;yn(a,sh(i,b,0),0);F[a+161|0]=0;if(!(I[i+34|0]&8)){Sa(f,49,0,H[f+108>>2]+2|0);nh(a,787,2,0,-1,4)}if(!d){break h}hb(f,d)}i=H[a>>2];d=H[i+16>>2];k=wb(a);kd(a,1,h);if(I[e+43|0]==1){Mb(k,170)}f=d+(h<<4)|0;d=cs(a,e);while(1){if(d){Ls(a,d);d=H[d+32>>2];continue}break}if(I[e+28|0]&8){d=H[f>>2];H[g+36>>2]=H[e>>2];H[g+32>>2]=d;kc(a,19542,g+32|0)}d=H[f>>2];H[g+20>>2]=H[e>>2];H[g+16>>2]=d;kc(a,28020,g+16|0);d=I[e+43|0];i:{j:{if(!c){if((d|0)==1){break j}f=e+8|0;m=H[e+20>>2];d=0;while(1){n=d-1|0;d=n>>>0>=m>>>0?m:0;c=f;while(1){c=H[c>>2];if(c){l=H[c+44>>2];d=l>>>0>n>>>0?d:d>>>0<l>>>0?l:d;c=c+20|0;continue}break}if(d){Hs(a,d,Fb(H[a>>2],H[e+60>>2]));continue}break}d=I[e+43|0]}if((d&255)!=1){break i}}fb(k,172,h,0,0,H[e>>2],0);c=H[a+128>>2];F[(c?c:a)+21|0]=1}fb(k,151,h,0,0,H[e>>2],0);Kf(a,h);a=H[(H[i+16>>2]+(h<<4)|0)+12>>2];if(!(I[a+78|0]&2)){break a}a=a+16|0;while(1){a=H[a>>2];if(a){c=H[a+8>>2];if(I[c+43|0]!=2){continue}On(i,c);continue}break}a=H[(H[i+16>>2]+(h<<4)|0)+12>>2];G[a+78>>1]=J[a+78>>1]&65533}Cc(j,b);Ea=g+80|0}function mg(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;l=Ea-16|0;Ea=l;d=J[b+16>>1];f=d&31;if((d&63)>>>0>=32){h=-1431655766>>>f|0}else{h=((1<<f)-1&-1431655766)<<32-f|-1431655766>>>f}a:{if(h&1){break a}h=d&63;f=h;d=f&31;if((f&63)>>>0>=32){d=262144>>>d|0}else{d=((1<<d)-1&262144)<<32-d|262148>>>d}b:{if(!(d&1)){break b}m=$a(b);if(!m){break b}n=xb(b);j=sp(a);if(!j){break b}d=H[j+4>>2];o=(d|0)>0?d:0;f=j+8|0;c:{while(1){d:{if((e|0)==(o|0)){while(1){if((i|0)==(o|0)){break c}e:{g=H[f+(i<<2)>>2];if((n|0)!=H[g+20>>2]){break e}if(Hb(H[g+12>>2],m,n)){break e}e=i;break d}i=i+1|0;continue}}g=H[f+(e<<2)>>2];if((m|0)==H[g+12>>2]){break d}e=e+1|0;continue}break}if((d|0)<=(e|0)){break c}if((d-1|0)>(e|0)){i=f+(e<<2)|0;Ic(i,i+4|0,d+(e^-1)<<2);H[(f+(H[j+4>>2]<<2)|0)-4>>2]=g}H[g+24>>2]=H[g+24>>2]+1;i=g;if(!(c&1)){break a}break b}g=0}f=c&2;m=f?0:a;j=c&1;c=h&31;if((h&63)>>>0>=32){c=65536>>>c|0}else{c=((1<<c)-1&65536)<<32-c|65537>>>c}n=c&1;o=0;e=H[H[a>>2]+20>>2];f:{g:{while(1){i=nb(e,56,0);if(!i){break g}c=Xa(i,0,56);H[c+24>>2]=1;H[c+16>>2]=e;if(g){b=H[g+4>>2];e=nd(e,b,0);H[c>>2]=e;if(!e){break g}Va(e,H[g>>2],b);H[c+8>>2]=b;H[c+4>>2]=b;F[c+37|0]=I[g+37|0];ad(g);break a}h:{i:{j:{k:{l:{if(!(n|o)){break l}H[l+12>>2]=0;q=c,r=fd(b),H[q>>2]=r;d=xb(b);H[c+4>>2]=d;if(!d){H[c>>2]=0;break l}h=H[c>>2];if(!h){break l}h=I[h|0]&15;m:{if(h>>>0>12){break m}k=$b(c,0,l+12|0);if(!k){break m}p=d;d=H[l+12>>2];if((p|0)!=(d+k|0)){break m}if(!d|h>>>0>2){break k}}H[c>>2]=0;H[c+4>>2]=0}q=c,r=$a(b),H[q+12>>2]=r;d=xb(b);H[c+20>>2]=d;if(I[e+87|0]){break g}if(!d){break h}if(!nm(c,m)){break i}if(!f){break j}F[c+34|0]=1;break a}if(!j){break a}if(km(c,0)){break a}break g}ad(c);break f}n:{o:{p:{if(!b){break p}d=J[b+16>>1];if(!(d&18)|!(d&4096)){break p}if(H[b+36>>2]==9){break o}}d=H[c+20>>2];d=so(d,d>>31);if(!d){break g}d=Va(d,H[c+12>>2],H[c+20>>2]);H[c+12>>2]=d;F[d+H[c+20>>2]|0]=0;break n}d=H[c+12>>2]-8|0;h=d;k=H[d>>2];d=H[d+4>>2];k=k+1|0;d=k?d:d+1|0;H[h>>2]=k;H[h+4>>2]=d}F[c+36|0]=1;if((Uy(a,c)|0)==7){break g}g=c;if(j){continue}break a}break}if(f){F[c+34|0]=1;break a}ad(c);Gb(a,19873,-1);break f}ad(g);ad(i);Ub(a)}i=0}Ea=l+16|0;return i}function qG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;k=H[a+4>>2];o=k+H[a+8>>2]|0;k=k+H[a+12>>2]|0;p=H[a>>2];while(1){q=k;if(k>>>0>=o>>>0){return 101}k=q+1|0;g=I[q|0];if(g>>>0>=192){h=I[g+32992|0];while(1){a:{if((k|0)==(o|0)){k=o;break a}g=I[k|0];if((g&192)!=128){break a}h=g&63|h<<6;k=k+1|0;continue}break}g=(h&-2)==65534?65533:h>>>0<128?65533:(h&-2048)==55296?65533:h}if(!By(p,g)){continue}break}i=H[a+20>>2];j=i;while(1){h=H[a+24>>2];if((h-4|0)<=(j-i|0)){h=h- -64|0;h=Fc(i,h,h>>31);if(!h){return 7}i=H[a+20>>2];H[a+20>>2]=h;H[a+24>>2]=H[a+24>>2]- -64;j=h+(j-i|0)|0}b:{c:{d:{e:{f:{if((g|0)<=127){if(g-65>>>0>=26){break f}g=g|32;break e}if(g>>>0>65535){break d}r=H[p+4>>2];h=162;l=-1;i=0;while(1){if((h|0)>=(i|0)){m=(h+i|0)/2|0;n=J[(m<<2)+54720>>1]>(g|0);h=n?m-1|0:h;l=n?l:m;i=n?i:m+1|0;continue}break}i=l<<2;l=i+54720|0;h=J[l>>1];g:{if((h+I[i+54723|0]|0)<=(g|0)){break g}i=g^h;h=I[l+2|0];if(i&h&1){break g}g=J[(h&254)+55376>>1]+g&65535}if(!r){break f}s=g<<3|7;h=125;l=0;i=0;while(1){if((h|0)>=(i|0)){m=(h+i|0)/2|0;n=J[(m<<1)+55536>>1]>s>>>0;i=n?i:m+1|0;h=n?m-1|0:h;l=n?l:m;continue}break}i=l+55792|0;if((r|0)!=2&F[i|0]<0){break f}h=J[(l<<1)+55536>>1];if(((h>>>3|0)+(h&7)|0)<(g|0)){break e}g=I[i|0]&127}if(!g){break b}}if((g|0)<=127){F[j|0]=g;j=j+1|0;break b}if(g>>>0<=2047){F[j+1|0]=g&63|128;F[j|0]=g>>>6|192;j=j+2|0;break b}if(g>>>0>65535){break c}F[j+2|0]=g&63|128;F[j|0]=g>>>12|224;F[j+1|0]=g>>>6&63|128;j=j+3|0;break b}g=g-66560>>>0<40?g+40|0:g}F[j+3|0]=g&63|128;F[j+2|0]=g>>>6&63|128;F[j+1|0]=g>>>12&63|128;F[j|0]=g>>>18&7|240;j=j+4|0}h:{if(k>>>0>=o>>>0){h=k;break h}h=k+1|0;g=I[k|0];if(g>>>0>=192){i=I[g+32992|0];while(1){i:{if((h|0)==(o|0)){h=o;break i}g=I[h|0];if((g&192)!=128){break i}i=g&63|i<<6;h=h+1|0;continue}break}g=(i&-2)==65534?65533:i>>>0<128?65533:(i&-2048)==55296?65533:i}if(!By(p,g)){if(!oq(g)){break h}}i=H[a+20>>2];k=h;continue}break}H[a+12>>2]=h-H[a+4>>2];h=b;b=H[a+20>>2];H[h>>2]=b;H[c>>2]=j-b;b=H[a+4>>2];H[d>>2]=q-b;H[e>>2]=k-b;b=a;a=H[a+16>>2];H[b+16>>2]=a+1;H[f>>2]=a;return 0}function KG(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;k=Ea-16|0;Ea=k;i=b+8|0;j=a-8|0;a:{if(!j){d=De(i);break a}if(i>>>0>=4294967232){H[18340]=48;d=0;break a}f=i>>>0<11?16:i+11&-8;a=0;e=j-8|0;h=H[e+4>>2];c=h&-8;b:{if(!(h&3)){if(f>>>0<256){break b}if(c>>>0>=f+4>>>0){a=e;if(c-f>>>0<=H[18461]<<1>>>0){break b}}a=0;break b}g=c+e|0;c:{if(c>>>0>=f>>>0){a=c-f|0;if(a>>>0<16){break c}H[e+4>>2]=h&1|f|2;d=e+f|0;H[d+4>>2]=a|3;H[g+4>>2]=H[g+4>>2]|1;Ml(d,a);break c}if(H[18347]==(g|0)){d=c+H[18344]|0;if(d>>>0<=f>>>0){break b}H[e+4>>2]=h&1|f|2;a=e+f|0;d=d-f|0;H[a+4>>2]=d|1;H[18344]=d;H[18347]=a;break c}if(H[18346]==(g|0)){c=c+H[18343]|0;if(c>>>0<f>>>0){break b}a=c-f|0;d:{if(a>>>0>=16){H[e+4>>2]=h&1|f|2;d=e+f|0;H[d+4>>2]=a|1;c=c+e|0;H[c>>2]=a;H[c+4>>2]=H[c+4>>2]&-2;break d}H[e+4>>2]=c|h&1|2;a=c+e|0;H[a+4>>2]=H[a+4>>2]|1;a=0}H[18346]=d;H[18343]=a;break c}d=H[g+4>>2];if(d&2){break b}l=c+(d&-8)|0;if(l>>>0<f>>>0){break b}n=l-f|0;c=H[g+12>>2];e:{if(d>>>0<=255){a=H[g+8>>2];if((a|0)==(c|0)){p=73364,q=H[18341]&xJ(-2,d>>>3|0),H[p>>2]=q;break e}H[a+12>>2]=c;H[c+8>>2]=a;break e}m=H[g+24>>2];f:{if((c|0)!=(g|0)){a=H[g+8>>2];H[a+12>>2]=c;H[c+8>>2]=a;break f}g:{a=H[g+20>>2];if(a){d=g+20|0}else{a=H[g+16>>2];if(!a){break g}d=g+16|0}while(1){o=d;c=a;d=a+20|0;a=H[a+20>>2];if(a){continue}d=c+16|0;a=H[c+16>>2];if(a){continue}break}H[o>>2]=0;break f}c=0}if(!m){break e}a=H[g+28>>2];d=(a<<2)+73668|0;h:{if(H[d>>2]==(g|0)){H[d>>2]=c;if(c){break h}p=73368,q=H[18342]&xJ(-2,a),H[p>>2]=q;break e}H[(H[m+16>>2]==(g|0)?16:20)+m>>2]=c;if(!c){break e}}H[c+24>>2]=m;a=H[g+16>>2];if(a){H[c+16>>2]=a;H[a+24>>2]=c}a=H[g+20>>2];if(!a){break e}H[c+20>>2]=a;H[a+24>>2]=c}if(n>>>0<=15){H[e+4>>2]=h&1|l|2;a=e+l|0;H[a+4>>2]=H[a+4>>2]|1;break c}H[e+4>>2]=h&1|f|2;a=e+f|0;H[a+4>>2]=n|3;d=e+l|0;H[d+4>>2]=H[d+4>>2]|1;Ml(a,n)}a=e}d=a+8|0;if(a){break a}e=De(i);d=0;if(!e){break a}a=H[j-4>>2];a=(a&3?-4:-8)+(a&-8)|0;Va(e,j,a>>>0<i>>>0?a:i);Ce(j);d=e}a=d;i:{if(a){H[a>>2]=b;H[a+4>>2]=b>>31;a=a+8|0;break i}a=H[j>>2];H[k+4>>2]=b;H[k>>2]=a;Ec(7,5384,k);a=0}Ea=k+16|0;return a|0}function mm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ea-208|0;Ea=e;j=H[H[c>>2]+20>>2];f=$b(a,b,e+20|0);a:{if(!f){Gb(c,19873,-1);break a}b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{l:{m:{n:{h=H[a>>2];g=h+b|0;switch(I[g|0]&15){case 7:case 10:break i;case 5:case 6:break j;case 3:case 4:break k;case 2:break l;case 1:break m;case 0:break n;case 11:case 12:break g;case 8:case 9:break h;default:break c}}if(H[e+20>>2]){break c}Rb(c);break a}if(H[e+20>>2]){break c}uc(c,1);break a}if(H[e+20>>2]){break c}uc(c,0);break a}H[e+24>>2]=0;H[e+28>>2]=0;d=H[e+20>>2];if(!d){break c}g=I[(f+h|0)+b|0];if((g|0)==45){if((d|0)==1){break c}f=f+1|0;d=d-1|0}i=Dd(j,(f+h|0)+b|0,d,d>>31);if(!i){break d}h=Wf(i,e+24|0);db(j,i);if(!h){a=H[e+24>>2];b=(g|0)==45;g=b?0-a|0:a;d=(a|0)!=0;a=H[e+28>>2];i=b?0-(d+a|0)|0:a;break b}k=(g|0)!=45;if(!k){g=0;i=-2147483648;if((h|0)==3){break b}}if(k|(h|0)==1){break f}d=d+1|0;f=f-1|0;break e}d=H[e+20>>2];if(!d){break c}break e}qb(c,(f+h|0)+b|0,H[e+20>>2],-1);break a}i=H[e+20>>2];g=nd(j,i+1|0,0);if(!g){break d}j=(f+h|0)+b|0;a=0;b=0;while(1){if(b>>>0<i>>>0){d=b+j|0;f=I[d|0];o:{if((f|0)==92){h=gm(d,i-b|0,e+24|0);d=H[e+24>>2];p:{if(d>>>0<=127){F[a+g|0]=d;a=a+1|0;break p}if(d>>>0<=2047){f=a+g|0;F[f+1|0]=d&63|128;F[f|0]=d>>>6|192;a=a+2|0;break p}if(d>>>0<=65535){f=a+g|0;F[f+2|0]=d&63|128;F[f|0]=d>>>12|224;F[f+1|0]=d>>>6&63|128;a=a+3|0;break p}if((d|0)==629145){break p}f=a+g|0;F[f+3|0]=d&63|128;F[f|0]=d>>>18|240;F[f+2|0]=d>>>6&63|128;F[f+1|0]=d>>>12&63|128;a=a+4|0}b=(b+h|0)-1|0;break o}F[a+g|0]=f;a=a+1|0}b=b+1|0;continue}break}F[a+g|0]=0;qb(c,g,a,5);break a}if(!(!(I[H[c+4>>2]+8|0]&8)|d)){le(c,g,H[e+20>>2]+f|0,-1);break a}a=H[e+20>>2];Xa(e+160|0,0,48);H[e+156>>2]=a+f;H[e+152>>2]=g;H[e+24>>2]=c;G[e+48>>1]=1;H[e+40>>2]=0;H[e+44>>2]=0;H[e+32>>2]=100;H[e+36>>2]=0;H[e+28>>2]=e+50;a=e+24|0;ah(e+152|0,0,a);wf(a,0,0);break a}if((h|0)==1){break c}}a=Dd(j,(H[a>>2]+f|0)+b|0,d,d>>31);if(!a){break d}b=Md(a,e+8|0,bb(a),1);db(j,a);if((b|0)<=0){break c}Sb(c,M[e+8>>3]);break a}Ub(c);break a}Gb(c,19873,-1);break a}_b(c,g,i)}Ea=e+208|0}function el(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=Ea-16|0;Ea=h;k=H[a+224>>2];i=H[(d?68:72)+a>>2];f=kf(i,H[b>>2],H[b+4>>2],h+8|0);a:{if(f){break a}g=H[a+168>>2];f=H[b+4>>2];j=H[b>>2]+4|0;f=j>>>0<4?f+1|0:f;f=Ia[H[H[i>>2]+8>>2]](i,k,g,j,f)|0;if(f){break a}l=H[b>>2];f=H[a+172>>2];g=(d<<2)+4|0;j=g;g=g+H[a+168>>2]|0;j=H[b+4>>2]+(j>>>0>g>>>0?f+1|0:f)|0;l=g+l|0;j=l>>>0<g>>>0?j+1|0:j;H[b>>2]=l;H[b+4>>2]=j;f=101;g=H[h+8>>2];if(!g|H[a+164>>2]==(g|0)){break a}f=0;if(K[a+28>>2]<g>>>0){break a}if(Cv(c,g)){break a}b:{if(!d){break b}f=kf(i,l-4|0,j-(l>>>0<4)|0,h+4|0);if(f){break a}if(e){break b}f=101;if((Hu(a,k)|0)!=H[h+4>>2]){break a}}if(c){f=Og(c,g);if(f){break a}}c:{if((g|0)!=1){break c}c=I[k+20|0];if((c|0)==G[a+150>>1]){break c}G[a+150>>1]=c}d:{e:{f:{g:{if(!H[a+232>>2]){c=Lh(a,g);H[h+12>>2]=c;if(!d){break g}break f}c=0;H[h+12>>2]=0;if(d){break f}break e}if(!c){c=0;b=1;break d}b=!(I[c+28|0]&8);break d}if(I[a+7|0]){break e}e=H[b+4>>2];i=H[a+92>>2];b=(e|0)<=(i|0)&K[b>>2]<=K[a+88>>2]|(e|0)<(i|0);break d}b=1}h:{i:{e=H[a+64>>2];i=H[e>>2];if(!i){break i}f=I[a+17|0];j:{if(f>>>0<=3){if(b&!f){break j}break i}if(!b){break i}}b=H[a+168>>2];d=sJ(b,H[a+172>>2],g-1|0,0);f=Ia[H[i+12>>2]](e,k,b,d,Ha)|0;if(K[a+36>>2]<g>>>0){H[a+36>>2]=g}b=H[a+96>>2];if(!b){break h}Uu(b,g,k);break h}f=0;if(c|d){break h}F[a+21|0]=I[a+21|0]|2;f=Ia[H[a+220>>2]](a,g,h+12|0,1)|0;F[a+21|0]=I[a+21|0]&253;if(f){break a}dl(H[h+12>>2]);c=H[h+12>>2];f=0}if(!c){break a}b=Va(H[c+4>>2],k,H[a+168>>2]);Ia[H[a+216>>2]](H[h+12>>2]);if((g|0)==1){c=I[b+28|0]|I[b+29|0]<<8|(I[b+30|0]<<16|I[b+31|0]<<24);d=I[b+24|0]|I[b+25|0]<<8|(I[b+26|0]<<16|I[b+27|0]<<24);F[a+112|0]=d;F[a+113|0]=d>>>8;F[a+114|0]=d>>>16;F[a+115|0]=d>>>24;F[a+116|0]=c;F[a+117|0]=c>>>8;F[a+118|0]=c>>>16;F[a+119|0]=c>>>24;c=I[b+36|0]|I[b+37|0]<<8|(I[b+38|0]<<16|I[b+39|0]<<24);b=I[b+32|0]|I[b+33|0]<<8|(I[b+34|0]<<16|I[b+35|0]<<24);F[a+120|0]=b;F[a+121|0]=b>>>8;F[a+122|0]=b>>>16;F[a+123|0]=b>>>24;F[a+124|0]=c;F[a+125|0]=c>>>8;F[a+126|0]=c>>>16;F[a+127|0]=c>>>24}nl(H[h+12>>2])}Ea=h+16|0;return f}function pt(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;g=Ea-16|0;Ea=g;H[g+12>>2]=0;a:{if(!(c>>>0>=2&K[a+48>>2]>=c>>>0)){d=Ya(76835);break a}h=H[a+12>>2];b:{if(b){d=H[b+72>>2];f=H[d+32>>2];e=H[d+36>>2];f=f+1|0;e=f?e:e+1|0;H[d+32>>2]=f;H[d+36>>2]=e;d=H[d+12>>2];e=d;f=H[d+16>>2];d=H[d+20>>2];f=f+1|0;d=f?d:d+1|0;H[e+16>>2]=f;H[e+20>>2]=d;break b}b=qt(a,c)}H[g+8>>2]=b;d=Vb(H[h+72>>2]);H[g+4>>2]=d;c:{d:{e:{if(d){break e}d=H[h+56>>2];f=cb(d+36|0);e=f+1|0;e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);F[d+36|0]=e;F[d+37|0]=e>>>8;F[d+38|0]=e>>>16;F[d+39|0]=e>>>24;if(I[a+24|0]&4){if(!b){d=qd(a,c,g+8|0,0);b=H[g+8>>2];if(d){break e}}d=Vb(H[b+72>>2]);H[g+4>>2]=d;if(d){break d}Xa(H[b+56>>2],0,H[H[b+52>>2]+36>>2])}if(I[a+17|0]){Ad(a,c,2,0,g+4|0);d=H[g+4>>2];if(d){break e}}f:{if(!f){e=0;break f}e=cb(H[h+56>>2]+32|0);if(e>>>0>K[a+48>>2]){d=Ya(76882);break e}d=qd(a,e,g+12|0,0);if(d){break e}f=H[g+12>>2];i=cb(H[f+56>>2]+4|0);d=H[a+40>>2]>>>2|0;if(i>>>0>d-2>>>0){d=Ya(76893);break e}if(d-8>>>0<=i>>>0){break f}d=Vb(H[f+72>>2]);if(d){break e}d=H[f+56>>2];e=i+1|0;e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);F[d+4|0]=e;F[d+5|0]=e>>>8;F[d+6|0]=e>>>16;F[d+7|0]=e>>>24;d=H[f+56>>2]+(i<<2)|0;e=c<<24|(c&65280)<<8|(c>>>8&65280|c>>>24);F[d+8|0]=e;F[d+9|0]=e>>>8;F[d+10|0]=e>>>16;F[d+11|0]=e>>>24;g:{if(!b|I[a+24|0]&4){break g}d=H[b+72>>2];e=H[d+20>>2];if(I[e+12|0]){break g}h=J[d+28>>1];if(H[e+104>>2]|!(h&2)){break g}G[d+28>>1]=h&65515|16}h:{d=H[a+64>>2];if(d){break h}d=ej(H[a+48>>2]);H[a+64>>2]=d;if(d){break h}d=7;break e}if(K[d>>2]<c>>>0){d=0;break e}d=Og(d,c);break e}if(!b){d=qd(a,c,g+8|0,0);b=H[g+8>>2];if(d){break e}}d=Vb(H[b+72>>2]);if(d){break d}a=H[b+56>>2];d=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);F[a|0]=d;F[a+1|0]=d>>>8;F[a+2|0]=d>>>16;F[a+3|0]=d>>>24;d=0;a=H[b+56>>2];F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;a=H[h+56>>2];c=c<<24|(c&65280)<<8|(c>>>8&65280|c>>>24);F[a+32|0]=c;F[a+33|0]=c>>>8;F[a+34|0]=c>>>16;F[a+35|0]=c>>>24;break d}if(b){break d}b=0;break c}F[b|0]=0}Eb(b);Eb(H[g+12>>2])}Ea=g+16|0;return d}function Um(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;j=Ea-16|0;Ea=j;H[j+12>>2]=0;H[j+4>>2]=0;o=H[b+12>>2];l=I[a+23|0];if(!SA(a,b)){q=RA(a,b);g=H[a>>2];k=Qc(H[b+12>>2]);r=nb(g,N(k,5)+1|0,0);a:{if(I[H[a>>2]+87|0]){break a}f=H[a+8>>2];m=(c|0)!=(d|0);n=Pm(a,b,3,m?j+12|0:0,r,j+4|0);F[a+23|0]=0;s=vr(a,o,j+8|0);F[a+23|0]=l;l=(k|0)>0?k:0;while(1){b:{if((e|0)==(l|0)){e=l;break b}if(H[(e<<2)+r>>2]!=(e|0)){break b}e=e+1|0;continue}break}i=s;c:{if((e|0)==(k|0)){break c}i=nc(a,k);e=0;while(1){if((e|0)==(l|0)){break c}Ua(f,80,e+s|0,H[(e<<2)+r>>2]+i|0,0);e=e+1|0;continue}}d:{if((n|0)==5){p=H[a+56>>2]-1|0;H[a+56>>2]=p;o=H[b+20>>2];e=0;l=md(a,H[b+12>>2]);b=0;if((c|0)!=(d|0)){b=zb(a);Ua(f,102,i,i,b)}n=o+8|0;while(1){if((e|0)<H[o>>2]){g=n+(e<<4)|0;h=Jc(a,H[g>>2],j);e:{if(!b){break e}if(!af(H[g>>2])){break e}Ua(f,102,b,h,b)}rb(a,H[j>>2]);f:{g:{if(!(!m&(H[o>>2]-1|0)<=(e|0))){fb(f,(i|0)==(h|0)?51:53,i,p,h,l,-2);h=H[f+108>>2];if((h|0)<=0){break f}g=I[q|0];break g}fb(f,(i|0)==(h|0)?50:52,i,c,h,l,-2);h=H[f+108>>2];if((h|0)<=0){break f}g=I[q|0]|16}G[(H[f+104>>2]+N(h,20)|0)-18>>1]=g<<24>>24}e=e+1|0;continue}break}if(b){Sa(f,50,b,d);Qb(f,c)}hb(f,p);rb(a,b);break d}e=0;g=c;if((c|0)!=(d|0)){h=H[a+56>>2]-1|0;H[a+56>>2]=h;g=h}while(1){if((e|0)!=(l|0)){if(H[a+36>>2]){break a}if(af(tg(H[b+12>>2],e))){Sa(f,50,e+i|0,g)}e=e+1|0;continue}break}h:{if((n|0)==1){g=H[j+4>>2];Ua(f,30,g,c,i);n=Mb(f,9);break h}fb(f,96,i,k,0,q,k);g=H[j+4>>2];if(!m){gb(f,28,g,c,i,k);break d}n=gb(f,29,g,0,i,k)}i:{if((k|0)!=1){break i}b=H[j+12>>2];if(!b){break i}Sa(f,51,b,c)}if(!m){Qb(f,c)}if(h){hb(f,h)}p=Sa(f,36,g,c);b=c;if((k|0)>=2){b=H[a+56>>2]-1|0;H[a+56>>2]=b}e=0;while(1){if((e|0)!=(l|0)){m=zb(a);h=md(a,tg(o,e));Ua(f,94,g,e,m);fb(f,52,e+i|0,b,m,h,-2);rb(a,m);e=e+1|0;continue}break}Sa(f,9,0,d);if((k|0)>=2){hb(f,b);Sa(f,39,g,p+1|0);Sa(f,9,0,c)}b=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(n,20)|0)+8>>2]=b}if((i|0)==(s|0)){break a}rb(a,i)}Za(H[a>>2],r);Za(H[a>>2],q)}Ea=j+16|0}function $m(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;k=Ea-16|0;Ea=k;a:{m=H[a>>2];if(I[b+43|0]|!(I[m+33|0]&64)){break a}t=c+1|0;h=b+48|0;g=H[m+16>>2];o=Fb(m,H[b+60>>2]);r=H[g+(o<<4)>>2];s=I[a+161|0];while(1){j=H[h>>2];if(j){H[k+12>>2]=0;H[k+8>>2]=0;b:{c:{if(!e){break c}if(!Zb(H[b>>2],H[j+8>>2])){break c}if(!zz(b,j,e,f)){break b}}i=H[j+8>>2];d:{e:{f:{if(I[a+161|0]){g=yc(m,i,r);break f}g=of(a,0,i,r)}if(g){if(!ri(a,g,j,k+12|0,k+8|0)){break e}}if(I[m+87|0]|!s){break a}if(g){break b}l=j+36|0;i=wb(a);g=H[j+20>>2];n=(g+H[i+108>>2]|0)+1|0;h=0;while(1){if((h|0)>=(g|0)){break d}Sa(i,50,Gc(H[j>>2],G[l+(h<<3)>>1])+t|0,n);h=h+1|0;g=H[j+20>>2];continue}}n=H[k+8>>2];if(!n){H[k+4>>2]=H[j+36>>2];n=k+4|0}l=g+32|0;i=0;p=H[k+12>>2];h=0;while(1){if(H[j+20>>2]>(h|0)){q=(h<<2)+n|0;if(H[q>>2]==G[b+32>>1]){H[q>>2]=-1}if(H[m+364>>2]){i=l;q=H[g>>2];u=H[g+4>>2];if(p){i=H[p+4>>2]+(h<<1)|0}i=(wA(a,q,H[N(G[i>>1],12)+u>>2],o)|0)==2}h=h+1|0;continue}break}wd(a,o,H[g+20>>2],0,H[g>>2]);H[a+40>>2]=H[a+40>>2]+1;if(c){wz(a,o,g,p,j,n,c,-1,i)}g:{if(!d){break g}l=H[a+128>>2];l=H[(l?l:a)+136>>2];h:{if(!l){break h}l=H[l>>2];if((l|0)==H[j+28>>2]&I[j+25|0]==8){break g}if((l|0)!=H[j+32>>2]){break h}if(I[j+26|0]==8){break g}}wz(a,o,g,p,j,n,d,1,i)}Za(m,H[k+8>>2]);break b}Sa(i,158,I[j+24|0],-1)}h=j+4|0;continue}break}l=(e|0)!=0;h=xg(b);while(1){if(!h){break a}H[k+12>>2]=0;H[k+8>>2]=0;i:{if(e){if(!Tq(b,h,e,f)){break i}}if(!(H[a+128>>2]|(I[h+24|0]|I[m+34|0]&8))){if(!I[a+20|0]){break i}}if(ri(a,b,h,k+12|0,k+8|0)){if(!s){break a}if(!I[m+87|0]){break i}break a}i=Gd(a,0,0,0);if(i){g=H[h>>2];H[i+24>>2]=g;H[i+16>>2]=H[g>>2];H[g+24>>2]=H[g+24>>2]+1;g=H[a+40>>2];H[a+40>>2]=g+1;H[i+48>>2]=g;if(d){vz(a,i,b,H[k+12>>2],h,H[k+8>>2],d,-1)}j:{if(!c){break j}g=I[(h+l|0)+25|0];j=H[m+36>>2];vz(a,i,b,H[k+12>>2],h,H[k+8>>2],c,1);if(I[h+24|0]|!((j&8)>>>3|(g&253)!=8)){break j}g=H[a+128>>2];F[(g?g:a)+21|0]=1}H[i+16>>2]=0;Cc(m,i)}Za(m,H[k+8>>2])}h=H[h+12>>2];continue}}Ea=k+16|0}function Nt(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=Ea-32|0;Ea=e;i=H[a+8>>2];g=H[i+4>>2];a:{b:{c:{c=I[a|0];if(c){if(c>>>0<3){break c}c=mj(a);if(c){break a}c=0;if(I[a|0]){break a}}d=H[a+116>>2];c=J[d+24>>1];j=J[a+70>>1];if(c>>>0<=j>>>0){c=Ya(79844);break a}k=F[a+68|0];h=H[d+64>>2];f=h+(j<<1)|0;l=I[f|0];f=I[f+1|0];m=J[d+26>>1];n=H[d+56>>2];if(H[d+20>>2]<0){if(Pf(d)){break b}h=H[d+64>>2];c=J[d+24>>1]}f=(m&(f|l<<8))+n|0;if(f>>>0<(c&65535)+h>>>0){c=Ya(79851);break a}h=0;l=b&2;d:{if(!l){break d}e:{if(!I[d+8|0]){break e}h=1;if(((H[d+20>>2]+(Ia[H[d+76>>2]](d,f)|0)|0)+2|0)>((H[g+40>>2]<<1>>>0)/3|0)){break e}if(J[d+24>>1]!=1){break d}}c=xu(a);H[e+28>>2]=c;h=0;if(c){break a}}if(!I[d+8|0]){c=Xk(a);if(c){break a}}if(I[a+1|0]&32){c=hg(g,H[a+64>>2],a);if(c){break a}}if(!(H[a+112>>2]|!I[i+11|0])){ro(i,H[a+64>>2],H[a+32>>2],H[a+36>>2],0)}c=Vb(H[d+72>>2]);if(c){break a}Ia[H[d+80>>2]](d,f,e);if(H[e+12>>2]!=J[e+16>>1]){b=oo(d,f,e)}else{b=0}H[e+28>>2]=b;Tk(d,j,J[e+18>>1],e+28|0);c=H[e+28>>2];if(c){break a}if(!I[d+8|0]){f=a+116|0;b=H[f>>2];if(H[b+20>>2]<0){c=Pf(b);if(c){break a}}c=H[b+64>>2]+(J[b+24>>1]<<1)|0;c=J[b+26>>1]&(I[c-2|0]<<8|I[c-1|0]);if(c>>>0<=3){c=Ya(79942);break a}f=H[H[((F[a+68|0]-1|0)>(k|0)?((k<<2)+a|0)+124|0:f)>>2]+4>>2];i=c+H[b+56>>2]|0;c=Ia[H[b+76>>2]](b,i)|0;g=H[g+84>>2];m=Vb(H[b+72>>2]);H[e+28>>2]=m;if(!m){o=e,p=ko(d,j,i-4|0,c+4|0,g,f),H[o+28>>2]=p}Tk(b,J[b+24>>1]-1|0,c,e+28|0);c=H[e+28>>2];if(c){break a}}if((N(H[H[a+116>>2]+20>>2],3)|0)>H[H[a+20>>2]+40>>2]<<1){c=lo(a);if(c){break a}}if(F[a+68|0]>(k|0)){hf(H[a+116>>2]);c=I[a+68|0]-1|0;F[a+68|0]=c;b=a+120|0;while(1){g=c<<24>>24;if((k|0)<(g|0)){F[a+68|0]=c-1;Eb(H[b+(g<<2)>>2]);c=I[a+68|0];continue}break}H[a+116>>2]=H[b+(g<<2)>>2];c=lo(a);if(c){break a}}if(h){F[a|0]=2;b=J[d+24>>1];if(b>>>0<=j>>>0){H[a+4>>2]=-1;G[a+70>>1]=b-1;c=0;break a}H[a+4>>2]=1;c=0;break a}b=Qf(a);if(l){Ih(a);F[a|0]=3}c=(b|0)!=16?b:0;break a}c=Ya(79835);break a}c=Ya(79848)}Ea=e+32|0;return c}function $H(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=H[c+4>>2];d=J[f+16>>1];e=d&31;a:{if((d&63)>>>0>=32){d=-1431655766>>>e|0}else{d=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}b:{if(d&1){break b}if((b|0)==3){d=J[H[c+8>>2]+16>>1];e=d&31;if((d&63)>>>0>=32){d=-1431655766>>>e|0}else{d=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}if(d&1){break b}}d=J[H[c>>2]+16>>1];g=kb(f);h=H[c>>2];e=0;f=d&31;if((d&63)>>>0>=32){d=65536>>>f|0}else{d=((1<<f)-1&65536)<<32-f|65537>>>f}l=d&1;c:{if(e|l){j=xb(h);h=fd(H[c>>2]);if(!h){break b}break c}h=$a(h);if(!h){break b}if((g|0)>=0){break c}e=h;while(1){f=I[e|0];if(!f){break c}d=e+1|0;e=d;if(f>>>0>=192){while(1){e=d;d=e+1|0;if((I[e|0]&192)==128){continue}break}}j=j+1|0;continue}}d:{if((b|0)==3){c=kb(H[c+8>>2]);b=0-c|0;e=!(c&-2147483648);b=e?c:b;f=c>>31;f=e?f:0-(((c|0)!=0)+f|0)|0;break d}e=1;b=H[H[H[a>>2]+20>>2]+120>>2];f=b>>31}c=g;d=c>>31;e:{if((c|0)<0){c=(j>>31)+d|0;g=g+j|0;c=g>>>0<j>>>0?c+1|0:c;if((c|0)>=0|(c|0)>0){break e}f=c+f|0;b=b+g|0;f=b>>>0<g>>>0?f+1|0:f;g=0;c=0;d=!!b&(f|0)>=0|(f|0)>0;b=d?b:0;f=d?f:0;break e}if(g){g=c-1|0;c=d-!c|0;break e}g=0;c=0;i=f;d=b;f=!!d&(f|0)>=0|(f|0)>0;b=d-f|0;f=i-(f>>>0>d>>>0)|0}i=c-((b>>>0>g>>>0)+f|0)|0;n=i;d=g-b|0;k=!!d&(i|0)>=0|(i|0)>0;d=e?g:k?d:0;i=e?c:k?i:0;k=g;g=(n|0)<0;b=e?b:g?k:b;f=e?f:g?c:f;if(!(m|l)){while(1){c=I[h|0];if(!c|!(d|i)){break a}e=h+1|0;h=e;if(c>>>0>=192){while(1){h=e;e=e+1|0;if((I[h|0]&192)==128){continue}break}}c=d;d=c-1|0;i=i-!c|0;continue}}e=d+h|0;c=j-d|0;k=c;h=j>>31;g=h-((d>>>0>j>>>0)+i|0)|0;c=!!c&(g|0)>=0|(g|0)>0;m=c?k:0;g=c?g:0;c=f+i|0;i=d;d=b+d|0;c=i>>>0>d>>>0?c+1|0:c;c=d>>>0>j>>>0&(c|0)>=(h|0)|(c|0)>(h|0);b=c?m:b;c=c?g:f;f:{if(!c&b>>>0>=2147483648|c){uw(e,-1,a);break f}sj(a,e,b,0,-1)}}return}e=h;while(1){c=c&255;if(!(!c|!(b|f))){e=e+1|0;g:{if(c>>>0>191){d=e;while(1){e=d;d=e+1|0;c=I[e|0];if((c&192)==128){continue}break}break g}c=I[e|0]}d=b;b=d-1|0;f=f-!d|0;continue}break}b=e-h|0;eg(a,h,b,b>>31,-1)}function we(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0;x=Ea+-64|0;Ea=x;a:{if(oe()){break a}if(!(b?(a|0)>0:0)){H[18238]=0;break a}if(H[18238]){d=I[73080]}else{d=Xl(0);c=H[7691];H[18240]=H[7690];H[18241]=c;c=H[7689];H[18238]=H[7688];H[18239]=c;b:{if(!d){Xa(72968,0,44);break b}c=H[16549];if(c){Xa(72972,0,40);H[18242]=c;break b}Ia[H[d+56>>2]](d,44,72968)|0;g=H[18250]}H[18253]=g;F[73080]=0;H[18250]=0;d=0}c:while(1){d=d&255;if((d|0)>=(a|0)){Va(b,(d-a|0)+73016|0,a);F[73080]=I[73080]-a;break a}if(d){b=Va(b,73016,d);d=I[73080];b=b+d|0;a=a-d|0}d=0;H[18250]=H[18250]+1;c=Va(x,72952,64);e=H[c+44>>2];k=H[c+60>>2];n=H[c+12>>2];g=H[c+28>>2];h=H[c+40>>2];s=H[c+56>>2];o=H[c+8>>2];i=H[c+24>>2];t=H[c+36>>2];p=H[c+52>>2];u=H[c+4>>2];j=H[c+20>>2];q=H[c+32>>2];l=H[c+48>>2];r=H[c>>2];m=H[c+16>>2];while(1)if((d|0)==10){H[c+48>>2]=l;H[c>>2]=r;H[c+16>>2]=m;H[c+32>>2]=q;H[c+20>>2]=j;H[c+52>>2]=p;H[c+4>>2]=u;H[c+36>>2]=t;H[c+24>>2]=i;H[c+56>>2]=s;H[c+8>>2]=o;H[c+40>>2]=h;H[c+28>>2]=g;H[c+60>>2]=k;H[c+12>>2]=n;H[c+44>>2]=e;d=0;while(1){if((d|0)!=16){g=d<<2;H[g+73016>>2]=H[g+72952>>2]+H[c+g>>2];d=d+1|0;continue}break}d=64;F[73080]=64;continue c}else{f=m;v=q;m=m+r|0;q=xJ(m^l,16);l=v+q|0;r=xJ(f^l,12);f=r;r=m+r|0;v=xJ(r^q,8);q=l+v|0;m=xJ(f^q,7);f=e;e=g+n|0;k=xJ(e^k,16);l=f+k|0;g=xJ(l^g,12);f=i;i=i+o|0;n=xJ(i^s,16);h=n+h|0;w=xJ(f^h,12);i=w+i|0;o=g+e|0;s=o+m|0;y=xJ(i^n,8);e=xJ(s^y,16);f=j;j=j+u|0;n=xJ(j^p,16);t=n+t|0;z=xJ(f^t,12);j=z+j|0;f=m;p=xJ(j^n,8);A=p+t|0;m=e+A|0;u=xJ(f^m,12);n=u+s|0;s=xJ(e^n,8);t=s+m|0;m=xJ(t^u,7);f=i;k=xJ(k^o,8);i=k+l|0;e=xJ(i^g,7);o=f+e|0;p=xJ(o^p,16);g=p+q|0;e=xJ(g^e,12);o=e+o|0;p=xJ(p^o,8);q=g+p|0;g=xJ(q^e,7);f=j;j=h+y|0;e=xJ(j^w,7);h=f+e|0;l=xJ(h^v,16);i=l+i|0;f=h;h=xJ(e^i,12);u=f+h|0;l=xJ(l^u,8);e=i+l|0;i=xJ(e^h,7);f=k;k=xJ(z^A,7);h=k+r|0;v=xJ(f^h,16);j=v+j|0;w=xJ(j^k,12);r=w+h|0;k=xJ(v^r,8);h=j+k|0;j=xJ(h^w,7);d=d+1|0;continue}}}Ea=x- -64|0}function KH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;b=Ea-368|0;Ea=b;h=H[H[a>>2]+20>>2];e=$a(H[c>>2]);j=$a(H[c+12>>2]);i=$a(H[c+16>>2]);k=$a(H[c+20>>2]);d=kb(H[c+24>>2]);if(!(!k|(!j|!i))){m=H[h+364>>2];H[h+364>>2]=0;ye(h);H[b+80>>2]=0;H[b+72>>2]=0;H[b+76>>2]=0;H[b+64>>2]=0;H[b+68>>2]=0;f=yc(h,i,e);H[b+56>>2]=0;H[b+48>>2]=0;H[b+52>>2]=0;H[b+76>>2]=f;H[b+44>>2]=94;H[b+40>>2]=95;H[b+60>>2]=b- -64;g=b+84|0;H[b+36>>2]=g;d=ak(g,e,h,j,d);a:{if(d){break a}d=H[h+32>>2];f=d&67108864;b:{c:{e=H[b+332>>2];if(e){l=I[e+43|0];if((l|0)==2){if(f){break b}d=H[e+44>>2];H[b+28>>2]=0;H[b+32>>2]=0;H[b+20>>2]=0;H[b+24>>2]=0;H[b+12>>2]=0;H[b+16>>2]=0;H[b+4>>2]=0;H[b+8>>2]=0;H[b>>2]=g;H[d+4>>2]=H[d+4>>2]&-2097153;ee(g,H[e+44>>2],b);if(H[b+120>>2]){break c}ec(b+36|0,H[e+44>>2]);break b}d:{if(!(d&16384)&(f|0)!=0|(l|0)==1){break d}d=e+48|0;while(1){d=H[d>>2];if(!d){break d}g=H[d+8>>2];if(!Zb(g,i)){Vc(b+84|0,b- -64|0,g)}d=d+4|0;continue}}d=H[e>>2];if(Zb(i,d)){break b}H[b+76>>2]=e;i=b+84|0;g=b- -64|0;if(!f){hc(b+36|0,H[e+16>>2]);d=H[e>>2]}Vc(i,g,d);break b}d=H[b+336>>2];if(d){Vc(b+84|0,b- -64|0,H[d>>2]);if(f){break b}Jb(b+36|0,H[H[b+336>>2]+36>>2]);break b}e=H[b+340>>2];d=H[e+4>>2];if(!(Zb(d,i)|H[H[b+76>>2]+60>>2]!=H[e+24>>2])){Vc(b+84|0,b- -64|0,d)}if(f){break b}d=sm(b+84|0);if(d){break a}Nq(b+36|0,e);d=e+28|0;while(1){e=H[d>>2];if(!e){break b}d=H[e+12>>2];e:{if(!d){break e}if(ab(d,i)){break e}Vc(b+84|0,b- -64|0,d)}d=0;f:{f=H[e+16>>2];if(!f){break f}while(1){if(H[f>>2]<=(d|0)){break f}g=H[((d<<6)+f|0)+16>>2];if(!Zb(g,i)){Vc(b+84|0,b- -64|0,g);f=H[e+16>>2]}d=d+1|0;continue}}d=e+40|0;continue}}d=H[b+96>>2];if(d){break a}}d=Mq(a,b- -64|0,j,k,1)}g:{h:{i:{switch(d|0){case 0:break g;case 1:break i;default:break h}}if((H[h+32>>2]&268435457)!=1){break h}Be(a,H[c+12>>2]);break g}if(H[b+88>>2]){Lq(a,30558,H[c+4>>2],H[c+8>>2],b+84|0);break g}Xd(a,d)}_j(b+84|0);rm(h,H[b+64>>2]);H[h+364>>2]=m}Ea=b+368|0}function ap(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ea-112|0;Ea=e;F[a+177|0]=1;f=H[a+24>>2];H[e+100>>2]=0;H[e+96>>2]=25001;H[e+92>>2]=24033;j=(b|0)==1?9192:9211;H[e+88>>2]=j;H[e+84>>2]=j;H[e+80>>2]=14316;H[e+32>>2]=0;H[e+28>>2]=b;H[e+20>>2]=a;H[e+40>>2]=0;H[e+44>>2]=0;H[e+36>>2]=d;H[e+24>>2]=c;Qt(e+20|0,e,e+80|0,e);H[a+24>>2]=H[a+24>>2]&(f|-65);d=H[e+32>>2];a:{b:{if(d){break b}i=H[a+16>>2];g=i+(b<<4)|0;d=H[g+4>>2];if(!d){b=H[i+28>>2];G[b+78>>1]=J[b+78>>1]|1;d=0;break a}H[H[d+4>>2]+4>>2]=H[d>>2];c:{k=I[d+8|0];if(k){break c}d=zf(d,0,0);if(!d){break c}Nf(c,a,Sg(d));break b}d=0;while(1){if((d|0)!=5){f=d+1|0;Bh(H[g+4>>2],f,(e+48|0)+(d<<2)|0);d=f;continue}break}d:{e:{if(I[a+35|0]&2){H[e- -64>>2]=0;H[e+56>>2]=0;H[e+60>>2]=0;H[e+48>>2]=0;H[e+52>>2]=0;d=H[g+12>>2];H[d>>2]=0;break e}f=H[e+64>>2];d=H[g+12>>2];H[d>>2]=H[e+48>>2];if(!f){break e}f:{if(b){break f}h=H[a+24>>2];if(h&64){break f}d=f&3;f=d?d:1;if(!(h&4|H[a+184>>2]<=0)){d=6;if((f|0)!=I[a+84|0]){break d}}dp(a,f);d=H[g+12>>2];break e}if(I[a+84|0]==(f&3)){break e}Nf(c,a,13553);d=1;break d}F[d+77|0]=I[a+84|0];if(!H[d+80>>2]){f=d;d=H[e+56>>2];d=(d|0)<0?(d|0)==-2147483648?2147483647:0-d|0:d;d=d?d:-2e3;H[f+80>>2]=d;aj(H[g+4>>2],d);d=H[g+12>>2]}f=H[e+52>>2];F[d+76|0]=f;g:{h=f&255;if(!h){F[d+76|0]=1;break g}if(h>>>0<5){break g}Nf(c,a,3606);d=1;break d}if(!((f|0)<4|b)){d=H[a+36>>2];H[a+32>>2]=H[a+32>>2]&-3;H[a+36>>2]=d}H[e+44>>2]=H[H[H[g+4>>2]+4>>2]+48>>2];c=H[H[a+16>>2]+(b<<4)>>2];H[e+4>>2]=j;H[e>>2]=c;c=mb(a,15014,e);f=H[a+364>>2];H[a+364>>2]=0;d=fe(a,c,4,e+20|0,0);H[a+364>>2]=f;f=H[e+32>>2];Za(a,c);h:{i:{d=d?d:f;j:{if(!d){Rt(a,b);if(I[a+87|0]){break j}break h}if(!I[a+87|0]){break i}}yf(a);i=H[a+16>>2];d=7;break d}if(!(I[a+35|0]&8)|(d|0)==7){break d}}c=H[(H[a+16>>2]+(b<<4)|0)+12>>2];G[c+78>>1]=J[c+78>>1]|1;d=0}if(k){break b}ho(H[((b<<4)+i|0)+4>>2])}if(!d){break a}if(!((d|0)!=3082&(d|0)!=7)){Ib(a)}lj(a,b)}F[a+177|0]=0;Ea=e+112|0;return d}function BF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;d=Ea-176|0;Ea=d;a:{if(Rl(a,4196,H[c>>2],d+28|0)){break a}e=H[d+28>>2];if(Yl(a,e)){break a}j=H[e>>2];m=H[H[j+36>>2]>>2];H[d+168>>2]=0;H[d+160>>2]=0;H[d+164>>2]=0;if(!H[e+16>>2]){qb(a,30558,0,0);break a}H[d+152>>2]=0;H[d+156>>2]=0;H[d+144>>2]=0;H[d+148>>2]=0;H[d+136>>2]=0;H[d+140>>2]=0;H[d+128>>2]=0;H[d+132>>2]=0;c=Ql(e,0,d+172|0);b:{if(c){break b}b=He(N(H[d+172>>2],24),0);H[d+152>>2]=b;c:{if(!b){break c}b=H[e+36>>2];c=H[e+32>>2];H[d+128>>2]=e;H[d+144>>2]=c;H[d+148>>2]=b;b=0;while(1){if(H[j+24>>2]<=(b|0)){c=0;break b}H[d+116>>2]=0;H[d+112>>2]=0;H[d+108>>2]=0;H[d+136>>2]=0;H[d+132>>2]=b;H[d+104>>2]=0;c=gg(H[e+16>>2],113,d+128|0);if(c){break b}k=b+1|0;c=$e(H[e+12>>2],k);f=Nd(H[e+12>>2],k);d:{if(!c){if((hh(H[e+12>>2],k)|0)!=5){break c}break d}c=jg(H[j+36>>2],H[e+20>>2],c,f,d+124|0);if(c){break b}l=H[d+124>>2];c=Ia[H[m+20>>2]](l,d+120|0,d+116|0,d+112|0,d+108|0,d+104|0)|0;while(1){f=H[d+172>>2];p=(f|0)>0?f:0;q=H[d+152>>2];e:{while(1){if(c){break e}c=0;g=2147483647;h=0;while(1){if((c|0)!=(p|0)){f=N(c,24)+q|0;if(H[f>>2]){n=H[f+8>>2];o=H[f+16>>2];i=n-o|0;r=i;s=g;t=g>>>0>i>>>0;i=H[f+12>>2]-(H[f+20>>2]+(n>>>0<o>>>0)|0)|0;g=g>>31;i=t&(i|0)<=(g|0)|(g|0)>(i|0);g=i?r:s;h=i?f:h}c=c+1|0;continue}break}c=101;if(!h){continue}break}f:{if(I[H[h>>2]]<=1){H[h>>2]=0;break f}Kj(h,h+8|0)}c=0;l=H[d+124>>2];while(1){if(!(H[d+104>>2]>=(g|0)|c)){c=Ia[H[m+20>>2]](l,d+120|0,d+116|0,d+112|0,d+108|0,d+104|0)|0;continue}break}if(!c){H[d>>2]=b;c=H[d+112>>2];H[d+8>>2]=c;H[d+12>>2]=H[d+108>>2]-c;H[d+4>>2]=(h-H[d+152>>2]|0)/24;c=sf(d+160|0,Bd(64,d+32|0,29968,d),-1);continue}if((c|0)!=101){continue}c=H[j+40>>2]?101:267;continue}break}Ia[H[m+16>>2]](l)|0;if((c|0)!=101){break b}}b=k;continue}}c=7}Ta(H[d+152>>2]);Ge(j);if(c){Xd(a,c);Ta(H[d+160>>2]);break a}qb(a,H[d+160>>2],H[d+164>>2]-1|0,1)}Ea=d+176|0}function yz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;e=Ea-368|0;Ea=e;f=H[a+128>>2];l=f?f:a;h=l;f=h+136|0;a:{while(1){f=H[f>>2];if(f){if(H[f>>2]==(b|0)&H[f+12>>2]==(d|0)){break a}f=f+4|0;continue}break}f=0;g=H[a>>2];i=nb(g,24,0);b:{if(!i){break b}H[i+4>>2]=H[h+136>>2];H[h+136>>2]=i;h=nb(g,28,0);H[i+8>>2]=h;if(!h){break b}f=H[l+8>>2];H[h+24>>2]=H[f+232>>2];H[f+232>>2]=h;H[i+16>>2]=-1;H[i+20>>2]=-1;H[i+12>>2]=d;H[i>>2]=b;f=e+20|0;vm(f,g);H[e+332>>2]=0;H[e+336>>2]=0;H[e+324>>2]=0;H[e+328>>2]=0;H[e+316>>2]=0;H[e+320>>2]=0;H[e+308>>2]=0;H[e+312>>2]=0;H[e+152>>2]=c;H[e+148>>2]=l;H[e+304>>2]=f;H[e+280>>2]=H[b>>2];F[e+178|0]=I[b+8|0];G[e+176>>1]=J[a+156>>1];F[e+45|0]=I[a+25|0];j=wb(f);c:{if(j){c=H[b>>2];if(c){H[e+16>>2]=c;Wd(j,-1,mb(g,7378,e+16|0),-6)}c=H[b+12>>2];if(c){c=jb(g,c,0);d:{if(I[g+87|0]){break d}if(cd(e+304|0,c)){break d}m=H[e+76>>2]-1|0;H[e+76>>2]=m;wc(e+20|0,c,m,16)}eb(g,c)}f=b+28|0;g=H[e+20>>2];n=H[e+28>>2];o=(d|0)!=11;while(1){f=H[f>>2];if(f){F[e+180|0]=o?d:I[f+1|0];c=H[f+36>>2];if(c){H[e>>2]=c;fb(n,184,2147483647,1,0,mb(g,8821,e),-6)}e:{f:{switch(I[f|0]-127|0){case 2:c=e+20|0;k=xm(c,f);zn(c,k,pc(g,H[f+24>>2],0),jb(g,H[f+20>>2],0),I[e+180|0],0);Mb(n,131);break e;case 0:c=e+20|0;k=xm(c,f);Bn(c,k,Ud(g,H[f+8>>2],0),EA(g,H[f+28>>2]),I[e+180|0],uz(g,H[f+32>>2]));Mb(n,131);break e;case 1:c=e+20|0;k=xm(c,f);yn(c,k,jb(g,H[f+20>>2],0));Mb(n,131);break e;default:break f}}c=Ud(g,H[f+8>>2],0);F[e+340|0]=4;H[e+360>>2]=0;H[e+352>>2]=0;H[e+356>>2]=0;H[e+344>>2]=0;H[e+348>>2]=0;Lc(e+20|0,c,e+340|0);fc(g,c)}f=f+40|0;continue}break}if(m){hb(j,m)}Mb(j,70);tz(a,e+20|0);if(!H[a+36>>2]){c=H[j+104>>2];_v(j,l+104|0);H[h+4>>2]=H[j+108>>2];H[j+104>>2]=0;H[h>>2]=c}H[h+8>>2]=H[e+64>>2];c=H[e+60>>2];H[h+20>>2]=b;H[h+12>>2]=c;H[i+16>>2]=H[e+168>>2];H[i+20>>2]=H[e+172>>2];zo(j);break c}tz(a,e+20|0)}mi(e+20|0);f=i}H[H[a>>2]+68>>2]=-1}Ea=e+368|0;return f}function dw(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;o=Ea-16|0;Ea=o;H[a+128>>2]=H[b+236>>2];H[b+236>>2]=0;s=G[b+216>>1];p=H[a>>2];c=H[b+44>>2];q=H[b+40>>2];H[o+12>>2]=H[b+104>>2];h=H[a+104>>2];f=H[b+48>>2];d=H[a+108>>2];_v(a,o+12|0);j=N(d,20)+7&-8;f=f-j&-8;c=c+q|0;l=(!q&(c|0)>0)+c|0;c=J[a+152>>1]&-33|(I[b+20|0]?(I[b+21|0]!=0)<<5:0);G[a+152>>1]=c;b=I[b+219|0];if(b){b=b<<2&12;G[a+144>>1]=b^12;l=(l|0)<=10?10:l;c=b|c&-13}G[a+152>>1]=c&65532;c=f;m=N(l,40);d=c-m|0;e=c>>31;g=e-(c>>>0<m>>>0)|0;b=h+j|0;k=c>>>0<m>>>0&(e|0)<=0|(e|0)<0;H[a+88>>2]=k?0:d+b|0;c=k?c:d;f=N(s,40);d=c-f|0;e=k?e:g;h=e-(c>>>0<f>>>0)|0;r=c>>>0<f>>>0&(e|0)<=0|(e|0)<0;H[a+100>>2]=r?0:b+d|0;c=r?c:d;d=r?e:h;e=0;h=(H[o+12>>2]<<2)+7|0;e=h>>>0<7?1:e;h=h&-8;i=c-h|0;j=e&1;e=j;g=c>>>0<h>>>0;n=d-(e+g|0)|0;g=(d|0)<=(e|0)&g|(d|0)<(e|0);H[a+92>>2]=g?0:b+i|0;c=g?c:i;e=g?d:n;d=0;t=q<<2;i=t+7|0;d=i>>>0<7?1:d;i=i&-8;u=(c-i|0)+b|0;n=d&1;d=n;b=c>>>0<i>>>0&(d|0)>=(e|0)|(d|0)>(e|0);H[a+96>>2]=b?0:u;d=k?m:0;c=d+(r?f:0)|0;e=0;e=c>>>0<d>>>0?e+1|0:e;k=g?h:0;c=k+c|0;d=(g?j:0)+e|0;d=(c>>>0<k>>>0?d+1|0:d)+(b?n:0)|0;a:{b:{e=b?i:0;c=e+c|0;d=c>>>0<e>>>0?d+1|0:d;c:{if(c|d){e=Nb(p,c,d);H[a+212>>2]=e;if(I[p+87|0]){break c}b=H[a+88>>2];d:{if(b){break d}b=0;g=c>>>0<m>>>0;if(g&!d){break d}d=d-g|0;c=c-m|0;b=c+e|0}H[a+88>>2]=b;b=H[a+100>>2];e:{if(b){break e}b=0;if(c>>>0<f>>>0&(d|0)<=0|(d|0)<0){break e}d=d-(c>>>0<f>>>0)|0;c=c-f|0;b=c+e|0}H[a+100>>2]=b;b=H[a+92>>2];f:{if(b){break f}b=0;f=c>>>0<h>>>0;if(f&(d|0)<=(j|0)|(d|0)<(j|0)){break f}d=d-(f+j|0)|0;c=c-h|0;b=c+e|0}H[a+92>>2]=b;b=H[a+96>>2];g:{if(b){break g}b=0;if(c>>>0<i>>>0&(d|0)<=(n|0)|(d|0)<(n|0)){break g}b=(c-i|0)+e|0}H[a+96>>2]=b;break b}if(!I[p+87|0]){break b}}G[a+16>>1]=0;H[a+20>>2]=0;H[a+24>>2]=0;break a}G[a+16>>1]=s;H[a+24>>2]=q;mp(H[a+100>>2],s,p,1);H[a+20>>2]=l;mp(H[a+88>>2],l,p,0);Xa(H[a+96>>2],0,t)}VA(a);Ea=o+16|0}function CG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;d=H[a+56>>2]+((b>>>0)%K[a+52>>2]<<2)|0;a:{b:{while(1){d=H[d>>2];if(!d){break b}if(H[d+8>>2]!=(b|0)){d=d+16|0;continue}break}if(!H[d+24>>2]){break a}return em(d)|0}if(!c){return 0}h=b;b=0;d=H[a>>2];c:{d:{if((c|0)!=1){break d}e=H[a+48>>2]-H[a+44>>2]|0;if(e>>>0>=K[d+12>>2]|e>>>0>=K[a+32>>2]){break c}if(!Iy(a)){break d}if(e>>>0>K[a+44>>2]){break c}}if(K[a+48>>2]>=K[a+52>>2]){My(a)}e:{f:{g:{if(!H[a+20>>2]){break g}b=H[d+48>>2];if(J[b+14>>1]){break g}if(K[a+28>>2]>H[a+48>>2]+1>>>0){if(!Iy(a)){break g}b=H[d+48>>2]}uq(b,0);b=em(b);e=H[b+20>>2];if(H[e+16>>2]==H[a+16>>2]){break f}tq(b)}h:{i:{b=H[a+60>>2];j:{if(b){break j}if(H[a+48>>2]){break i}b=H[18316];if(!b|K[a+28>>2]<3){break i}d=H[18327];if(d){Ia[d|0]();b=H[18316]}k:{if((b|0)>0){d=H[a+16>>2];f=d>>31;b=sJ(d,f,b,0);e=Ha;break k}d=H[a+16>>2];f=d>>31;e=b>>31<<10|b>>>22;g=b<<10;b=0-g|0;e=0-(e+((g|0)!=0)|0)|0}g=b;d=sJ(d,f,H[a+28>>2],0);f=d;d=b>>>0<d>>>0;b=Ha;d=d&(e|0)<=(b|0)|(b|0)>(e|0);d=bc(d?g:f,d?e:b);H[a+64>>2]=d;b=H[18328];if(b){Ia[b|0]()}if(d){b=Ia[H[16491]](d)|0;f=H[a+16>>2];e=(b|0)/(f|0)|0;c=H[a+60>>2];g=H[a+8>>2];while(1){b=d+g|0;H[b+28>>2]=0;H[b+16>>2]=c;H[b+12>>2]=1;H[b>>2]=d;H[b+4>>2]=b+32;d=d+f|0;c=b;e=e-1|0;if(e){continue}break}break j}b=H[a+60>>2];if(!b){break i}}H[a+60>>2]=H[b+16>>2];c=b+16|0;break h}b=(c|0)!=1;l:{if(b){break l}c=H[18327];if(!c){break l}Ia[c|0]()}c=$i(H[a+16>>2]);m:{if(b){break m}b=H[18328];if(!b){break m}Ia[b|0]()}b=0;if(!c){break c}b=c+H[a+8>>2]|0;H[b+12>>2]=0;H[b>>2]=c;H[b+4>>2]=b+32;c=b+28|0}H[c>>2]=0;c=H[a+4>>2];H[c>>2]=H[c>>2]+1;break e}H[d+16>>2]=H[d+16>>2]+(H[a+20>>2]-H[e+20>>2]|0)}H[a+48>>2]=H[a+48>>2]+1;c=H[a+52>>2];H[b+8>>2]=h;c=(h>>>0)%(c>>>0)<<2;d=H[c+H[a+56>>2]>>2];H[b+24>>2]=0;H[b+20>>2]=a;H[b+16>>2]=d;H[H[b+4>>2]>>2]=0;H[c+H[a+56>>2]>>2]=b;if(h>>>0<=K[a+36>>2]){break c}H[a+36>>2]=h}d=b}return d|0}function YI(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;g=Ea+-64|0;Ea=g;d=H[a+24>>2];h=H[d+8>>2];e=H[d+4>>2];f=H[d>>2];a:{b:{c:{d:{e:{f:{g:{c=I[b|0];switch(c-167|0){case 1:break c;case 0:case 2:break f;default:break g}}if((c|0)==179){break f}if(!(I[d+26|0]&2)){break e}d=H[f+72>>2];if(!d){break e}while(1){if(!d){break e}h:{a=H[d+4>>2];if((a|0)>=0){if(!cc(0,b,H[d>>2],a)){break h}}d=H[d+20>>2];continue}break}if(I[b+7|0]&3){break e}a=0;c=H[e>>2];c=(c|0)>0?c:0;while(1){if((a|0)==(c|0)){break e}a=a+1|0;if(H[e+48>>2]!=H[d+4>>2]){continue}break}if(H[b+40>>2]){break e}c=2;if(H[f+36>>2]){break a}a=g+12|0;Xa(a,0,52);F[g+12|0]=169;H[g+40>>2]=H[d+8>>2];G[g+44>>1]=H[d+12>>2];Bz(f,h,a);if(H[f+36>>2]){break a}a=G[g+46>>1];H[(H[h+20>>2]+(a<<4)|0)+4>>2]=b;G[b+34>>1]=a;H[b+40>>2]=h;break b}if(e){break d}}c=0;break a}c=0;a=H[e>>2];i=(a|0)>0?a:0;a=e+8|0;d=0;while(1){if((d|0)==(i|0)){break a}if(H[b+28>>2]==H[a+40>>2]){Bz(f,h,b);break a}else{a=a- -64|0;d=d+1|0;continue}}}c=0;if(H[b+40>>2]|(I[d+26|0]&2|H[a+16>>2]!=I[b+2|0])){break a}e=h+36|0;a=H[h+32>>2];d=0;while(1){i:{c=H[e>>2];j:{if((c|0)<=(d|0)){break j}i=H[a>>2];if((i|0)==(b|0)){break j}if(cc(0,i,b,-1)){break i}c=H[e>>2]}k:{if((c|0)>(d|0)){break k}a=H[f>>2];i=I[a+84|0];c=Az(a,H[h+32>>2],24,e,g+12|0);H[h+32>>2]=c;a=0;d=H[g+12>>2];if((d|0)<0){break k}c=c+N(d,24)|0;H[c>>2]=b;e=H[b+20>>2];if(e){a=H[e>>2]}e=Te(H[f>>2],H[b+8>>2],a,i,0);H[c+4>>2]=e;i=H[b+12>>2];l:{if(!(!i|I[e+4|0]&32)){e=H[f+40>>2];H[f+40>>2]=e+1;H[c+16>>2]=e;m:{n:{if((a|0)!=1){break n}a=H[i+20>>2];if(H[a>>2]!=1){break n}if(cc(0,H[a+8>>2],H[H[b+20>>2]+8>>2],0)){break n}F[c+20|0]=0;F[c+21|0]=I[b+4|0]>>>2&1;break m}F[c+20|0]=1}F[c+22|0]=H[H[c+4>>2]+4>>2]>>>20&1;break l}H[c+16>>2]=-1}a=-1;if(!(I[c+21|0]|!(I[b+4|0]&4))){a=H[f+40>>2];H[f+40>>2]=a+1}H[c+8>>2]=a}H[b+40>>2]=h;G[b+34>>1]=d;break b}a=a+24|0;d=d+1|0;continue}}c=1}Ea=g- -64|0;return c|0}function Qr(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=H[a>>2];c=H[a+8>>2];a:{f=H[a+4>>2];if(H[f+88>>2]){b=H[f+12>>2];if(b){d=H[b>>2]}g=H[f+60>>2];b=H[e+56>>2];j=b-2|0;H[e+56>>2]=j;h=zb(e);i=zb(e);if(d){l=nc(e,d);m=nc(e,d)}k=b-1|0;Sa(c,135,H[f+48>>2],h);bk(a,H[f+48>>2],l);b=f;while(1){if(b){Sa(c,75,0,H[b+52>>2]);b=H[b+36>>2];continue}break}Ua(c,23,g,j,H[f+88>>2]);o=H[c+108>>2];Sa(c,135,g,i);Ua(c,54,H[f+92>>2],j,i);b=I[f+20|0];b:{if((b|0)==66){break b}if((b|0)==85){Ua(c,53,h,k,i);break b}j=0;p=H[f+12>>2];if(p){n=Oe(e,p,0,0);b=I[f+20|0]}if((b&255)==94){j=Ua(c,53,h,0,i)}c:{if(n){bk(a,g,m);Ua(c,90,m,l,d);xc(c,n,-8);b=H[c+108>>2]+1|0;Ua(c,14,b,k,b);break c}Sa(c,9,0,k)}if(!j){break b}n=H[c+108>>2];H[(I[H[c>>2]+87|0]?73336:H[c+104>>2]+N(j,20)|0)+8>>2]=n}Vq(a,f,g,0,H[a+20>>2]);hb(c,k);Sa(c,39,g,o);b=H[c+108>>2];d:{if(I[H[c>>2]+87|0]){H[18336]=b;f=73336;break d}f=H[c+104>>2]+N(o,20)|0;H[f-12>>2]=b;f=f+20|0}H[f+8>>2]=b;rb(e,i);rb(e,h);if(d){Sc(e,m,d);Sc(e,l,d)}jn(a,1);break a}b=f;while(1){if(!b){break a}h=H[b+44>>2];d=H[h+32>>2];e:{f:{if(!((d|0)!=50064&(d|0)!=50074)){i=H[b+60>>2];g=H[e+56>>2]-1|0;H[e+56>>2]=g;d=zb(e);Sa(c,75,0,H[b+56>>2]);g:{if(H[h+32>>2]==50064){Ua(c,94,H[f+48>>2],H[b+80>>2]+1|0,d);kn(e,d,2);break g}Sa(c,71,1,d)}Ua(c,106,d,H[b+64>>2],d);Ua(c,54,H[b+64>>2]+1|0,g,d);Ua(c,30,i,0,d);Ua(c,94,i,H[b+80>>2],H[b+56>>2]);break f}if((d|0)!=49830&(d|0)!=49835){break e}k=H[b+60>>2];l=H[H[H[b+72>>2]+20>>2]>>2];g=H[e+56>>2]-1|0;H[e+56>>2]=g;d=zb(e);i=H[f+48>>2];h:{if((l|0)<=2){Sa(c,75,0,H[b+56>>2]);break h}Ua(c,94,i,H[b+80>>2]+2|0,H[b+56>>2])}Sa(c,135,i,d);m=H[h+32>>2];i:{if((l|0)<=1){Sa(c,86,d,(m|0)==49830?1:-1);break i}h=zb(e);Ua(c,94,i,H[b+80>>2]+1|0,h);Ua(c,(m|0)==49830?106:107,h,d,d);rb(e,h)}Ua(c,30,k,g,d);Ua(c,94,k,H[b+80>>2],H[b+56>>2])}hb(c,g);rb(e,d)}b=H[b+36>>2];continue}}Sa(c,10,H[a+16>>2],H[a+12>>2])}
function si(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;m=Ea-192|0;Ea=m;v=(c|0)!=129;while(1){if(b){k=I[b+8|0];a:{if((k|0)!=(c|0)&(!I[b+10|0]|v|(k|0)!=127)|I[b+9|0]!=(e|0)){break a}if(!Sq(H[b+16>>2],d)){break a}if(!I[b+10|0]){xz(a,b,f,g,h,i);break a}if(H[a+128>>2]|!I[a+159|0]){break a}q=H[a+144>>2];if((q+8|0)!=(b|0)){break a}s=H[a>>2];t=H[a+8>>2];k=m+116|0;Xa(k,0,76);j=m+40|0;Xa(j,0,72);w=m,x=pc(s,H[q+4>>2],0),H[w+144>>2]=x;H[m+88>>2]=-1;H[m+64>>2]=f;H[m+40>>2]=1;H[m+148>>2]=j;ee(a,k,0);if(!H[a+36>>2]){$r(a,k)}pb(s,H[m+144>>2]);r=H[q+4>>2];u=r+8|0;n=H[a>>2];o=0;k=0;while(1){if((o|0)<H[r>>2]){l=u+(o<<4)|0;j=H[l>>2];b:{if(!j){break b}c:{p=I[j|0];if((p|0)!=180){if((p|0)!=141|I[H[j+16>>2]]!=180){break c}Wa(a,5941,0)}j=0;while(1){if(G[f+34>>1]<=(j|0)){break b}p=N(j,12);l=p+H[f+4>>2]|0;d:{if(I[l+10|0]&2){break d}k=Pb(a,k,oc(n,59,H[l>>2]));if(I[n+87|0]){break d}l=(H[k>>2]<<4)+k|0;w=l-4|0,x=Tb(n,H[p+H[f+4>>2]>>2]),H[w>>2]=x;p=(I[l+1|0]|I[l+2|0]<<8)&65532;F[l+1|0]=p;F[l+2|0]=p>>>8}j=j+1|0;continue}}k=Pb(a,k,jb(n,j,0));if(I[n+87|0]){break b}p=H[l+4>>2];if(!p){break b}j=(H[k>>2]<<4)+k|0;w=j-4|0,x=Tb(n,p),H[w>>2]=x;l=(I[j+1|0]|I[j+2|0]<<8)&65532|(I[l+9|0]|I[l+10|0]<<8)&3;F[j+1|0]=l;F[j+2|0]=l>>>8}o=o+1|0;continue}break}e:{if(H[a+36>>2]){break e}Xa(m+4|0,0,36);if(!H[q+96>>2]){H[q+96>>2]=H[k>>2];j=H[a+40>>2];H[a+40>>2]=j+1;H[q+92>>2]=j}H[m+28>>2]=1024;H[m+12>>2]=g;H[m+4>>2]=a;j=I[b+8|0];H[a+132>>2]=f;F[a+158|0]=j;if(Ne(m+4|0,k)|I[s+87|0]){break e}o=H[k>>2];j=H[a+44>>2];H[a+44>>2]=(o+j|0)+2;n=j+1|0;H[q+100>>2]=n;j=0;o=(o|0)>0?o:0;l=k+8|0;while(1){if((j|0)!=(o|0)){r=H[l+(j<<4)>>2];u=j+n|0;lk(a,r,u);if((rc(r)|0)==69){_a(t,87,u)}j=j+1|0;continue}break}j=n+o|0;Ua(t,97,n,o,j);n=j+1|0;Sa(t,127,H[q+92>>2],n);Ua(t,128,H[q+92>>2],j,n)}pb(s,k);H[a+132>>2]=0;F[a+158|0]=0}b=H[b+32>>2];continue}break}Ea=m+192|0}function Wv(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0;h=Ea-320|0;Ea=h;Xa(h+36|0,0,160);Xa(h+240|0,0,76);H[h+228>>2]=H[a+264>>2];H[a+264>>2]=h+32;H[h+32>>2]=a;if(e){H[h+272>>2]=e;F[h+251|0]=I[e+152|0]>>>2&3}a:{if(I[a+87|0]){Wa(h+32|0,1150,0);i=7;H[a+64>>2]=7;break a}if(d&1){F[h+56|0]=1;G[a+308>>1]=0;H[a+304>>2]=H[a+304>>2]+1}F[h+57|0]=d;b:{if(I[a+95|0]){break b}e=0;while(1){if(H[a+20>>2]<=(e|0)){break b}c:{i=H[(H[a+16>>2]+(e<<4)|0)+4>>2];if(!i){break c}H[H[i+4>>2]+4>>2]=H[i>>2];i=Io(i,1,1);if(!i){break c}H[h>>2]=H[H[a+16>>2]+(e<<4)>>2];ae(a,i,8721,h);break a}e=e+1|0;continue}}if(H[a+412>>2]){jm(a)}d:{e:{f:{g:{if(!((c|0)<0|(I[(b+c|0)-1|0]?0:c))){if(H[a+124>>2]<(c|0)){break f}e=Dd(a,b,c,0);if(e){jj(h+32|0,e);H[h+276>>2]=(H[h+276>>2]-e|0)+b;db(a,e);break g}H[h+276>>2]=b+c;break g}jj(h+32|0,b)}if(g){H[g>>2]=H[h+276>>2]}h:{if(I[a+177|0]){break h}c=H[h+40>>2];if(!c){break h}e=H[h+276>>2]-b|0;F[c+150|0]=d;if(d<<24>>24>=0){H[c+228>>2]=0}j=c,k=Dd(H[c>>2],b,e,e>>31),H[j+200>>2]=k}i:{j:{if(I[a+87|0]){F[h+49|0]=0;H[h+44>>2]=7;break j}b=H[h+44>>2];if(!b|(b|0)==101){break i}}if(I[a+177|0]|!I[h+49|0]){break e}b=H[h+32>>2];e=0;while(1){if(H[b+20>>2]<=(e|0)){break e}f=e<<4;c=H[(f+H[b+16>>2]|0)+4>>2];k:{if(!c){break k}l:{g=I[c+8|0];if(g){break l}d=zf(c,0,0);if(!d){break l}if((d|0)!=3082&(d|0)!=7){break e}Ib(b);H[h+44>>2]=7;break e}Bh(c,1,h+316|0);d=H[(f+H[b+16>>2]|0)+12>>2];if(H[h+316>>2]!=H[d>>2]){if(F[d+78|0]&1){H[h+44>>2]=17}lj(b,e)}if(g){break k}ho(c)}e=e+1|0;continue}}H[f>>2]=H[h+40>>2];H[a+64>>2]=0;H[a+68>>2]=-1;i=0;b=H[a+288>>2];if(!b){break d}Xb(b);break d}ae(a,18,12440,0);i=gd(a,18);break a}b=H[h+40>>2];if(b){Cf(b)}i=H[h+44>>2];b=H[h+36>>2];if(b){H[h+16>>2]=b;ae(a,i,8863,h+16|0);Za(a,H[h+36>>2]);break d}Pc(a,i)}while(1){b=H[h+168>>2];if(!b){break a}H[h+168>>2]=H[b+4>>2];db(a,b);continue}}mi(h+32|0);Ea=h+320|0;return i}function Eq(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0,y=0,z=0,A=0,B=0,C=0,D=0,E=0;f=Ea-32|0;Ea=f;H[f+28>>2]=0;H[f+24>>2]=0;H[f+20>>2]=0;a:{b:{c:{e=H[c>>2]+d|0;d:{if((I[e|0]&15)!=12){k=c;c=f+28|0;d=$b(k,d,c);g=H[f+28>>2];H[f+28>>2]=0;Xe(a,b,$b(a,b,c)+H[f+28>>2]|0,e,d+g|0);w=a+35|0;break d}if((I[H[a>>2]+b|0]&15)!=12){Xe(a,$b(a,b,f+28|0)+b|0,H[f+28>>2],0,0);e=H[a>>2]+b|0;F[e|0]=I[e|0]&240|12}e=f+28|0;g=$b(c,d,e);if(!g){break b}l=H[f+28>>2];e=$b(a,b,e);if(!e){h=1;break a}m=d+g|0;o=l+m|0;w=a+35|0;k=b+e|0;D=k+H[f+28>>2]|0;l=0;while(1){g=m;if(o>>>0>g>>>0){d=I[H[c>>2]+g|0]&15;if(d-11>>>0<4294967292){break b}p=$b(c,g,f+16|0);if(!p){break b}q=H[f+16>>2];x=g+p|0;j=q+x|0;if(o>>>0<=j>>>0){break b}r=$b(c,j,f+12|0);if(!r){break b}y=H[f+12>>2];m=y+(j+r|0)|0;if(m>>>0>o>>>0){break b}E=(d|0)==7|(d|0)==10;i=H[a+40>>2]+D|0;e=k;while(1){d=e;z=d>>>0>=i>>>0;if(!z){h=1;A=H[a>>2];s=I[d+A|0]&15;if(s-11>>>0<4294967292){break a}t=$b(a,d,f+24|0);if(!t){break a}u=H[f+24>>2];B=d+t|0;n=u+B|0;if(n>>>0>=i>>>0){break a}v=$b(a,n,f+20|0);if(!v){break a}C=H[f+20>>2];e=C+(n+v|0)|0;if(i>>>0<e>>>0){break a}l=d;if(!Ty(H[c>>2]+x|0,q,E,A+B|0,u,(s|0)==7|(s|0)==10)){continue}}break}e=I[H[c>>2]+j|0]&15;if(!z){if(!e){Xe(a,l,((t+v|0)+u|0)+C|0,0,0);h=3;if(!I[a+35|0]){continue}break a}d=H[a+40>>2];H[a+40>>2]=0;h=Eq(a,n,c,j);if(h){break a}H[a+40>>2]=d+H[a+40>>2];continue}if(!e){continue}d=p+q|0;if((e|0)!=12){e=r+y|0;Xe(a,i,0,0,e+d|0);if(I[a+35|0]){break c}Va(H[a>>2]+i|0,H[c>>2]+g|0,d);Va(d+(H[a>>2]+i|0)|0,H[c>>2]+j|0,e);continue}Xe(a,i,0,0,d+1|0);if(I[a+35|0]){break c}Va(H[a>>2]+i|0,H[c>>2]+g|0,d);d=d+i|0;F[d+H[a>>2]|0]=0;e=H[a+40>>2];H[a+40>>2]=0;h=Eq(a,d,c,j);if(h){break a}H[a+40>>2]=e+H[a+40>>2];continue}break}if(!H[a+40>>2]){break d}Cq(a,b)}h=I[w|0]?3:0;break a}h=3;break a}h=2}Ea=f+32|0;return h}function Pj(a,b,c){var d=0,e=0,f=0,g=0,h=0;h=Ea-16|0;Ea=h;a:{if(I[a+17|0]<=1){e=0;if(I[a+18|0]<2){break a}}Mu(a);g=H[a+68>>2];f=H[g>>2];b:{if(!f){break b}if((f|0)==33048){Vu(g);H[g>>2]=0;break b}c:{d:{e:{f:{g:{h:{d=I[a+5|0];switch(d-1|0){case 2:break h;case 0:break f;default:break g}}if(!(H[a+80>>2]|H[a+84>>2])){break d}d=Ia[H[f+16>>2]](g,0,0)|0;if(d){break c}if(!I[a+8|0]){break d}d=0;b=I[a+10|0];if(!b){break c}d=H[a+68>>2];d=Ia[H[H[d>>2]+20>>2]](d,b)|0;break c}if(!I[a+4|0]|(d|0)==5){break e}}d=1;d=b?d:I[a+12|0]!=0;i:{if(!(H[a+80>>2]|H[a+84>>2])){d=0;break i}e=H[a+176>>2];b=H[a+180>>2];j:{if((!(e|b)|d)==1){d=Ia[H[f+16>>2]](g,0,0)|0;break j}d=Ia[H[f+12>>2]](g,33136,28,0,0)|0}if(d){break i}d=0;if(!I[a+7|0]){d=H[a+68>>2];d=Ia[H[H[d>>2]+20>>2]](d,I[a+10|0]|16)|0}if(!e&(b|0)<=0|(b|0)<0|d){break i}d=H[a+68>>2];d=Ia[H[H[d>>2]+24>>2]](d,h+8|0)|0;if(d){break i}d=0;f=H[h+12>>2];if((b|0)>=(f|0)&e>>>0>=K[h+8>>2]|(b|0)>(f|0)){break i}d=H[a+68>>2];d=Ia[H[H[d>>2]+16>>2]](d,e,b)|0}H[a+80>>2]=0;H[a+84>>2]=0;break b}b=I[a+12|0];Ia[H[f+4>>2]](g)|0;d=0;H[g>>2]=0;if(b){break b}b=H[a>>2];e=H[b+28>>2];if(!e){break b}d=Ia[e|0](b,H[a+188>>2],I[a+9|0])|0;break b}d=0}H[a+80>>2]=0;H[a+84>>2]=0}Xf(H[a+60>>2]);H[a+48>>2]=0;H[a+60>>2]=0;if(!d){k:{l:{if(!I[a+15|0]){if(!Hy(a,c)){break l}}lq(H[a+228>>2]);e=H[a+228>>2];break k}e=H[a+228>>2];b=e;while(1){b=H[b>>2];if(b){G[b+28>>1]=J[b+28>>1]&65523;b=b+40|0;continue}break}H[e+8>>2]=H[e+4>>2]}Lu(e,H[a+28>>2])}b=H[a+232>>2];m:{if(b){Oo(b);break m}if(!c|d){break m}d=0;b=H[a+28>>2];if(b>>>0>=K[a+36>>2]){break m}d=fq(a,b)}n:{if(!c|d){break n}b=H[a+64>>2];c=H[b>>2];if(c){d=Ia[H[c+40>>2]](b,22,0)|0;if((d|0)!=12){break n}}d=0}b=0;o:{if(I[a+4|0]){break o}c=H[a+232>>2];if(c){b=0;if(!Ku(c,0)){break o}}b=Jg(a,1)}F[a+20|0]=0;F[a+17|0]=1;e=d?d:b}Ea=h+16|0;return e}function Xx(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;g=Ea-32|0;Ea=g;a:{m=H[a>>2];if(H[m+40>>2]){break a}p=(d|0)>0?d:0;d=0;while(1){if((d|0)!=(p|0)){e=N(d,24)+c|0;if(H[e+12>>2]==(b|0)){n=n+1|0;f=H[e+16>>2]+f|0}d=d+1|0;continue}break}e=0;if(!f|(n|0)<2){break a}j=H[a+60>>2];b:{if(j){break b}H[g+16>>2]=0;H[g+20>>2]=0;H[g+8>>2]=0;H[g+12>>2]=0;c:{e=Ex(m,g+28|0);if(!e){i=H[g+28>>2];d=Ue(i,0);d:{if(!d){break d}f=Nd(i,0)+d|0;d=Vl(d,f,g+16|0)+d|0;while(1){if(d>>>0<f>>>0){d=Vl(d,f,g+8|0)+d|0;continue}break}f=H[g+20>>2];h=f;d=H[g+16>>2];if(!(f|d)){break d}e=H[g+8>>2];j=H[g+12>>2];if(e|j){break c}}ob(i);e=267}j=0;break b}H[a+64>>2]=d;H[a+68>>2]=h;f=H[m+244>>2];h=tJ(e,j,d,h);e=f+h|0;j=f>>31;d=j+Ha|0;s=a,t=tJ(e,e>>>0<h>>>0?d+1|0:d,f,j),H[s+60>>2]=t;e=ob(i);j=H[a+60>>2]}q=n-1|0;i=1;while(1){if((k|0)>=(n|0)){break a}d=0;f=0;if(e){break a}while(1){if((d|0)!=(p|0)){e=N(d,24)+c|0;if(!(!H[e+8>>2]|H[e+12>>2]!=(b|0)|(H[e+16>>2]>=H[f+16>>2]?f:0))){f=e}d=d+1|0;continue}break}e:{f:{if(!k){i=i<<2;break f}d=(i|0)/4|0;if(H[f+16>>2]>=(N(((d+o|0)-1|0)/(d|0)|0,j)|0)){e=H[f+20>>2];h=H[f+8>>2];d=ub(16,0);if(d){H[d+4>>2]=0;H[d+8>>2]=0;H[d>>2]=h;H[d+12>>2]=0;l=H[a+28>>2];H[d+4>>2]=e;H[d+8>>2]=l;H[a+28>>2]=d;H[h+16>>2]=d;e=0}else{e=7}Xp(H[h+20>>2]);H[h+20>>2]=0;break e}i=k>>>0<12?i<<2:i;e=0;if((k|0)==(q|0)|H[H[f>>2]+64>>2]<2){break e}}d=H[f+8>>2];H[g+8>>2]=0;H[g+28>>2]=0;e=Dx(m,d,H[f+20>>2],g+8|0,g+28|0);if(e){break e}e=Cx(m,H[f>>2],H[f+4>>2],H[g+28>>2],H[g+8>>2]);if(e){break e}e=0;h=0;g:{l=H[f>>2];d=H[l>>2];if(!d){break g}l=H[l+4>>2]+d|0;while(1){if(d>>>0>=l>>>0){break g}while(1){r=F[d|0];d=d+1|0;if((r|0)<0){continue}break}H[g+16>>2]=d;qe(0,g+16|0);h=h+1|0;d=H[g+16>>2];continue}}o=k?(h|0)<(o|0)?h:o:h}H[f+8>>2]=0;k=k+1|0;continue}}Ea=g+32|0;return e}function cc(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;i=Ea-16|0;Ea=i;a:{if(!(c?b:0)){e=((b|0)!=(c|0))<<1;break a}b:{c:{d:{e:{if(!a|I[b|0]!=156){break e}H[i+12>>2]=0;ij(H[a>>2],c,1,65,i+12|0);h=H[i+12>>2];if(!h){break e}e=H[a+8>>2];g=e;j=H[e+228>>2];e=G[b+32>>1];H[g+228>>2]=j|((e|0)>31?-2147483648:1<<e-1);e=PA(H[a+240>>2],e);if(e){g=J[e+16>>1];f=g&31;if((g&63)>>>0>=32){g=262144>>>f|0}else{g=((1<<f)-1&262144)<<32-f|262148>>>f}if(g&1){$a(e)}f=!Dh(e,h,0)}Uc(h);Uc(e);if(f){break d}}e=H[c+4>>2];f=H[b+4>>2];h=e|f;if(h&2048){if(!(e&f&2048)){break b}if(H[b+8>>2]==H[c+8>>2]){break d}break b}f=I[b|0];e=I[c|0];if(!((f|0)!=71&(e|0)==(f|0))){if((f|0)==113){if(cc(a,H[b+12>>2],c,d)>>>0<2){break c}e=I[c|0]}if((e|0)==113){if(cc(a,b,H[c+12>>2],d)>>>0<2){break c}}e=2;if(I[b|0]!=169|I[c|0]!=167|H[c+28>>2]>=0){break a}f=169;if(H[b+28>>2]!=(d|0)){break a}}g=H[b+8>>2];f:{if(!g){break f}g:{h:{i:{switch(f-168|0){default:if((f|0)==113){break h}if((f|0)==121){break d}case 1:case 2:case 3:e=H[c+8>>2];if(!e){break f}switch(f-167|0){case 0:case 2:break f;default:break g};case 0:case 4:break i}}e=2;if(ab(g,H[c+8>>2])){break a}f=H[b+4>>2]&16777216;if((F[c+7|0]&1)!=(f>>>24|0)){break a}if(!f){break f}if(!OA(a,H[b+44>>2],H[c+44>>2],1)){break f}break a}if(Zb(g,H[c+8>>2])){break b}break f}if(Tc(g,e)){break b}}e=2;if((H[c+4>>2]^H[b+4>>2])&1028){break a}if(h&65536){break d}if(h&4096){break a}if(!(h&32)){if(cc(a,H[b+12>>2],H[c+12>>2],d)){break a}}if(cc(a,H[b+16>>2],H[c+16>>2],d)){break a}if(If(H[b+20>>2],H[c+20>>2],d)){break a}a=I[b|0];if(h&16384|((a|0)==117|(a|0)==170)){break d}if((a|0)==175&I[b+2|0]!=I[c+2|0]|J[b+32>>1]!=J[c+32>>1]){break a}if((a|0)==49){break d}a=H[b+28>>2];if((a|0)==(d|0)){break d}if((a|0)!=H[c+28>>2]){break a}}e=0;break a}e=1;break a}e=2}Ea=i+16|0;return e}function oC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;h=Ea-32|0;Ea=h;m=H[a+8>>2];l=(m|0)<=0;f=m;i=e+(c>>31)|0;a:{b:{c:{g=c+d|0;i=g>>>0<d>>>0?i+1|0:i;if((i|0)<0){f=1}else{f=(i|0)<=0&f>>>0>=g>>>0}if(!(f|l)){l=H[a+16>>2];n=H[a+20>>2];o=H[a+12>>2];r=H[a+4>>2];v=H[a>>2];f=H[a+44>>2];H[h+24>>2]=H[a+40>>2];H[h+28>>2]=f;f=H[a+36>>2];H[h+16>>2]=H[a+32>>2];H[h+20>>2]=f;f=H[a+28>>2];H[h+8>>2]=H[a+24>>2];H[h+12>>2]=f;w=H[a+60>>2];s=H[a+48>>2];d:{p=H[a+52>>2];t=H[a+56>>2];g=Xa(a,0,64);j=Ia[H[p+24>>2]](p,t,g,s&17334143,0)|0;if(j){break d}f=r;a=o;while(1){if(!a){break c}i=l-k|0;j=(f>>31)+q|0;u=f+k|0;j=u>>>0<f>>>0?j+1|0:j;f=l>>>0<u>>>0&(j|0)>=(n|0)|(j|0)>(n|0)?i:f;j=Ia[H[H[g>>2]+12>>2]](g,a+4|0,f,k,q)|0;if(j){break d}i=(f>>31)+q|0;k=f+k|0;q=k>>>0<f>>>0?i+1|0:i;a=H[a>>2];continue}}a=H[g>>2];if(a){Ia[H[a+4>>2]](g)|0}H[g+16>>2]=l;H[g+20>>2]=n;H[g+12>>2]=o;H[g+8>>2]=m;H[g+4>>2]=r;H[g>>2]=v;b=H[h+28>>2];a=g+24|0;H[a+16>>2]=H[h+24>>2];H[a+20>>2]=b;b=H[h+20>>2];H[a+8>>2]=H[h+16>>2];H[a+12>>2]=b;b=H[h+12>>2];H[a>>2]=H[h+8>>2];H[a+4>>2]=b;H[g+60>>2]=w;H[g+56>>2]=t;H[g+52>>2]=p;H[g+48>>2]=s;break a}if(!!d&(e|0)>=0|(e|0)>0){if((d|0)==H[a+16>>2]&(e|0)==H[a+20>>2]){break b}So(a,d,e);break b}if(d|e){break b}d=H[a+12>>2];if(!d){break b}Va(d+4|0,b,c);break a}To(o);j=Ia[H[H[g>>2]+12>>2]](g,b,c,d,e)|0;break a}k=a+12|0;while(1){if((c|0)<=0){break a}d=H[a+24>>2];i=H[a+4>>2];e=i;e=uJ(H[a+16>>2],H[a+20>>2],e,e>>31);e:{if(e|Ha){f=d;break e}f=lc(i+4|0);if(!f){j=3082;break a}H[f>>2]=0;H[(d?d:k)>>2]=f;H[a+24>>2]=f}d=i-e|0;d=(c|0)<(d|0)?c:d;Va((e+f|0)+4|0,b,d);e=H[a+20>>2]+(d>>31)|0;f=d+H[a+16>>2]|0;e=f>>>0<d>>>0?e+1|0:e;H[a+16>>2]=f;H[a+20>>2]=e;c=c-d|0;b=b+d|0;continue}}Ea=h+32|0;return j|0}function jA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0,x=0;f=Ea-608|0;Ea=f;k=H[a>>2];j=H[a+8>>2];m=H[a+4>>2];l=H[m+24>>2];g=H[m+12>>2];Xa(f+112|0,0,56);a:{p=H[k+4>>2]+(I[j+16|0]<<6)|0;if(I[p+44|0]&16){break a}t=N(g,48)+l|0;u=H[p+48>>2];v=f+8|0;r=f- -64|0;q=f+120|0;while(1){if(l>>>0>=t>>>0|h){break a}h=0;b:{if(!(I[l+13|0]&2)){break b}g=H[l+24>>2];if(!(H[j+8>>2]&H[g+416>>2]|H[j+12>>2]&H[g+420>>2])){break b}k=H[g+24>>2];g=H[g+12>>2];i=H[a+12>>2];H[f+176>>2]=H[a+8>>2];H[f+180>>2]=i;i=H[a+20>>2];H[f+184>>2]=H[a+16>>2];H[f+188>>2]=i;i=H[a+4>>2];H[f+168>>2]=H[a>>2];H[f+172>>2]=i;w=N(g,48)+k|0;H[f+180>>2]=f+56;g=1;while(1){c:{d:{e:{if(k>>>0<w>>>0){if(I[k+13|0]&4){h=H[k+24>>2]}else{if(H[k+20>>2]!=(u|0)){break c}h=H[m>>2];H[f+216>>2]=k;H[f+212>>2]=1;H[f+204>>2]=1;F[f+200|0]=44;H[f+196>>2]=m;H[f+192>>2]=h;h=f+192|0}G[f+56>>1]=0;H[f+172>>2]=h;f:{if(I[H[p+24>>2]+43|0]==1){h=lA(f+168|0,b,c,d,e);break f}h=kA(f+168|0,b,c)}if(!h){h=jA(f+168|0,b,c,d,e)}i=J[f+56>>1];if(!i){G[f+112>>1]=0;k=0;break e}if(g){G[f+112>>1]=i;Va(q,r,i<<4);break d}s=J[f+112>>1];x=Va(v,q,s<<4);n=0;G[f+112>>1]=0;while(1){if((n|0)==(s|0)){break d}o=(n<<4)+x|0;g=0;while(1){if(g>>>0<i>>>0){i=(g<<4)+r|0;Iz(f+112|0,H[i>>2]|H[o>>2],H[i+4>>2]|H[o+4>>2],ce(G[o+8>>1],G[i+8>>1]),ce(G[o+10>>1],G[i+10>>1]));g=g+1|0;i=J[f+56>>1];continue}break}n=n+1|0;continue}}k=J[f+112>>1]}G[j+44>>1]=1;H[H[j+52>>2]>>2]=l;g=0;G[j+18>>1]=0;H[j+40>>2]=8192;F[j+17|0]=0;H[j+32>>2]=0;H[j+36>>2]=0;H[j+24>>2]=0;H[j+28>>2]=0;while(1){if(g>>>0>=k>>>0|h){break b}h=(g<<4)+q|0;G[j+20>>1]=J[h+8>>1]+1;G[j+22>>1]=J[h+10>>1];i=H[h+4>>2];H[j>>2]=H[h>>2];H[j+4>>2]=i;g=g+1|0;h=ck(a,j);continue}}g=0}k=k+48|0;continue}}l=l+48|0;continue}}Ea=f+608|0;return h}function Pv(a,b){var c=0;c=Ea-16|0;Ea=c;a:{if(!(!H[16532]|(((a&63)>>>0<32?1<<a:0)&16842752)!=0&a>>>0<=63)){Rc(178679);break a}H[c+12>>2]=b;b:{switch(a-4|0){case 0:a=H[c+12>>2];H[c+12>>2]=a+4;a=H[a>>2];b=H[a+4>>2];H[16488]=H[a>>2];H[16489]=b;b=H[a+28>>2];H[16494]=H[a+24>>2];H[16495]=b;b=H[a+20>>2];H[16492]=H[a+16>>2];H[16493]=b;b=H[a+12>>2];H[16490]=H[a+8>>2];H[16491]=b;break a;case 1:if(!H[16488]){Pw()}a=H[c+12>>2];H[c+12>>2]=a+4;b=H[16489];a=H[a>>2];H[a>>2]=H[16488];H[a+4>>2]=b;b=H[16495];H[a+24>>2]=H[16494];H[a+28>>2]=b;b=H[16493];H[a+16>>2]=H[16492];H[a+20>>2]=b;b=H[16491];H[a+8>>2]=H[16490];H[a+12>>2]=b;break a;case 5:a=H[c+12>>2];H[c+12>>2]=a+4;H[16480]=H[a>>2];break a;case 23:a=H[c+12>>2];H[c+12>>2]=a+4;F[65928]=H[a>>2];break a;case 3:a=H[c+12>>2];H[c+12>>2]=a+4;H[16526]=H[a>>2];H[16527]=H[a+4>>2];H[c+12>>2]=a+12;H[16528]=H[a+8>>2];break a;case 20:a=H[c+12>>2];H[c+12>>2]=a+4;H[H[a>>2]>>2]=168;break a;case 14:a=H[c+12>>2];H[c+12>>2]=a+4;Va(66020,H[a>>2],52);break a;case 15:if(!H[16507]){vw()}a=H[c+12>>2];H[c+12>>2]=a+4;Va(H[a>>2],66020,52);break a;case 9:a=H[c+12>>2];H[c+12>>2]=a+4;H[16485]=H[a>>2];H[c+12>>2]=a+8;H[16486]=H[a+4>>2];break a;case 12:a=H[c+12>>2];H[c+12>>2]=a+4;b=H[a>>2];H[c+12>>2]=a+8;H[16540]=H[a+4>>2];H[16539]=b;break a;case 13:a=H[c+12>>2];H[c+12>>2]=a+4;F[65926]=H[a>>2];break a;case 16:a=H[c+12>>2];H[c+12>>2]=a+4;F[65927]=H[a>>2];break a;case 18:H[16522]=0;H[16523]=0;H[16524]=0;H[16525]=0;H[c+12>>2]=(H[c+12>>2]+7&-8)+16;break a;case 21:a=H[c+12>>2];H[c+12>>2]=a+4;H[16531]=H[a>>2];break a;case 22:a=H[c+12>>2];H[c+12>>2]=a+4;H[16487]=H[a>>2];break a;case 25:a=H[c+12>>2]+7&-8;H[c+12>>2]=a+8;b=H[a+4>>2];H[16542]=H[a>>2];H[16543]=b;break;case 10:break a;default:break b}}}Ea=c+16|0}function xD(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=Ea-16|0;Ea=g;a:{if(!a){break a}b=H[a+204>>2];if(b){break a}b=0;m=H[a+200>>2];if(!m){break a}i=H[a>>2];H[g+12>>2]=-1;b=ub(24,0);if(b){f=i?H[i+120>>2]:1e9;G[b+20>>1]=0;H[b+16>>2]=0;H[b+12>>2]=f;H[b+8>>2]=0;H[b>>2]=0;H[b+4>>2]=0}else{b=66200}c=b;f=-1;while(1){b=f;b:{d=n+m|0;h=I[d|0];if(!(I[c+20|0]|!h)){j=oj(d,g+12|0);f=H[g+12>>2];if((j|0)>0){break b}b=f}if((b|0)!=1){sb(c,22955,1)}b=a;a=0;if(!(!c|(c|0)==66200)){a=Jd(c);Ta(c)}f=b;b=a;H[f+204>>2]=b;break a}l=(b|0)==183?l:b;c:{d:{e:{if(f-153>>>0<4){break e}f:{g:{h:{i:{switch(f-22|0){default:j:{switch(f-117|0){default:if((f|0)==59){break h}if((f|0)==138){break g}if((f|0)!=183){break f}break c;case 0:break e;case 1:case 2:case 3:break f;case 4:break j}}if((l|0)!=45&(l|0)!=19){break e}sb(c,20139,5);break c;case 0:k=k+1|0;if((l|0)==49){e=H[c+16>>2];o=k}sb(c,27597,1);break c;case 1:break i}}if(!((k|0)!=(o|0)|(e|0)<=0)){H[c+16>>2]=e+1;sb(c,21072,5);e=0}sb(c,27576,1);k=k-1|0;break c}b=H[c+16>>2];k:{if(F[h+31152|0]<0){e=Dd(i,d,j,0);H[g+8>>2]=0;if(!e){break d}pf(e);l:{m:{n:{o:{if(I[d|0]!=34){break o}d=H[a+208>>2];if(!d){break o}while(1){if(!d){break o}if(!Tc(e,d+4|0)){break n}d=H[d>>2];continue}}d=bb(e);if((oj(e,g+8|0)|0)!=(d|0)|H[g+8>>2]!=59){break m}op(c);sb(c,e,d);break l}sb(c,21710,1);db(i,e);break d}H[g>>2]=e;lb(c,29232,g)}db(i,e);break k}op(c);sb(c,d,j)}while(1){if(K[c+16>>2]<=b>>>0){break d}e=H[c+4>>2]+b|0;F[e|0]=I[I[e|0]+30768|0];b=b+1|0;continue}}e=0}if(I[h+31152|0]&70){op(c)}b=H[c+16>>2];sb(c,d,j);while(1){if(K[c+16>>2]<=b>>>0){break c}h=H[c+4>>2]+b|0;d=I[h|0];F[h|0]=d&(I[d+31152|0]^-1|223);b=b+1|0;continue}}sb(c,21710,1);break c}e=0}n=j+n|0;continue}}Ea=g+16|0;return b|0}function yl(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=Ea-16|0;Ea=h;i=H[a+116>>2];a:{if(J[a+70>>1]>=J[i+24>>1]){b=Ya(75181);break a}l=H[a+20>>2];Ig(a);e=H[a+40>>2];k=e-H[i+56>>2]|0;i=J[a+48>>1];if(k>>>0>H[l+40>>2]-i>>>0){b=Ya(75196);break a}b:{if(b>>>0<i>>>0){f=i>>>0<b+c>>>0?i-b|0:c;c=c-f|0;i=d+f|0;b=wu(b+e|0,d,f);break b}g=b-i|0;i=d;b=0}c:{if(b|!c){break c}b=H[l+40>>2];k=e;e=J[a+48>>1];n=h,o=cb(k+e|0),H[n+8>>2]=o;m=b-4|0;d:{if(!(I[a+1|0]&4)){f=((H[a+44>>2]+(b-e|0)|0)-5>>>0)/(m>>>0)|0;b=H[a+12>>2];e:{f:{if(!b){b=0;break f}j=Ia[H[16491]](b)|0;b=H[a+12>>2];e=f<<2;if((j|0)>=(e|0)){break e}}b=Ld(b,f<<3,0);if(!b){b=7;break a}H[a+12>>2]=b;e=f<<2}j=0;Xa(b,0,e);F[a+1|0]=I[a+1|0]|4;break d}j=(g>>>0)/(m>>>0)|0;b=H[H[a+12>>2]+(j<<2)>>2];if(!b){j=0;break d}H[h+8>>2]=b;g=g-N(j,m)|0}while(1){b=H[h+8>>2];if(!b){b=0;break c}if(b>>>0>K[l+48>>2]){b=Ya(75258);break a}e=H[a+12>>2]+(j<<2)|0;H[e>>2]=b;g:{if(g>>>0>=m>>>0){e=H[e+4>>2];h:{if(e){H[h+8>>2]=e;b=0;break h}b=vu(l,b,0,h+8|0)}g=g-m|0;break g}k=m>>>0<c+g>>>0?m-g|0:c;i:{j:{k:{e=H[l>>2];if(!H[H[e+64>>2]>>2]|g|H[H[e+228>>2]>>2]){break k}f=H[e+232>>2];if(f){H[h+12>>2]=0;Wo(f,b,h+12|0);e=H[l>>2];if(H[h+12>>2]){break k}}f=i-4|0;if(f>>>0<d>>>0){break k}g=I[f|0]|I[f+1|0]<<8|(I[f+2|0]<<16|I[f+3|0]<<24);e=H[e+64>>2];b=(o=e,p=f,q=k+4|0,r=sJ(H[l+36>>2],0,b-1|0,0),s=Ha,n=H[H[e>>2]+8>>2],Ia[n](o|0,p|0,q|0,r|0,s|0)|0);n=h,s=cb(f),H[n+8>>2]=s;F[f|0]=g;F[f+1|0]=g>>>8;F[f+2|0]=g>>>16;F[f+3|0]=g>>>24;break j}b=Ia[H[e+220>>2]](e,b,h+4|0,2)|0;if(b){break i}b=H[H[h+4>>2]+4>>2];n=h,s=cb(b),H[n+8>>2]=s;b=wu((b+g|0)+4|0,i,k);jd(H[h+4>>2])}g=0}c=c-k|0;if(!c){break a}i=i+k|0}j=j+1|0;if(!b){continue}break}}if(!c|b){break a}b=Ya(75342)}Ea=h+16|0;return b}function Jq(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Ea-16|0;Ea=g;d=H[a+44>>2];a:{if(d){break a}e=H[16544];if(e){d=10;if(Ia[e|0](400)|0){break a}}b:{if(I[a+17|0]<3){break b}c:{if(!Hy(a,1)){qq(H[a+96>>2]);break c}d:{if(H[a+232>>2]){H[g+8>>2]=0;d=mq(H[a+228>>2]);if(!d){Ia[H[a+220>>2]](a,1,g+8|0,0)|0;d=H[g+8>>2];H[d+16>>2]=0}d=zy(a,d,H[a+28>>2],1);jd(H[g+8>>2]);if(d){break d}lq(H[a+228>>2]);break d}if(!(I[a+19|0]|!H[a+28>>2])){d=Ia[H[a+220>>2]](a,1,g+8|0,0)|0;e:{if(d){break e}d=Vb(H[g+8>>2]);if(d){break e}jq(H[g+8>>2]);F[a+19|0]=1;d=0}jd(H[g+8>>2]);if(d){break a}}f:{if(!b|I[a+5|0]==4){break f}d=H[a+68>>2];if(!H[d>>2]){break f}F[a+20|0]=1;while(1){e=F[b+h|0];if(e){h=h+1|0;i=e+i|0;continue}break}g:{if(!I[a+8|0]){f=H[a+80>>2];e=H[a+84>>2];break g}f=bm(a);H[a+80>>2]=f;e=Ha;H[a+84>>2]=e}d=ei(d,f,e,H[a+164>>2]);if(d){break a}d=H[a+68>>2];f=f+4|0;e=f>>>0<4?e+1|0:e;d=Ia[H[H[d>>2]+12>>2]](d,b,h,f,e)|0;if(d){break a}d=H[a+68>>2];f=f+h|0;e=f>>>0<h>>>0?e+1|0:e;d=ei(d,f,e,h);if(d){break a}d=e;j=f+4|0;d=j>>>0<4?d+1|0:d;d=ei(H[a+68>>2],j,d,i);if(d){break a}d=H[a+68>>2];f=f+8|0;e=f>>>0<8?e+1|0:e;d=Ia[H[H[d>>2]+12>>2]](d,33124,8,f,e)|0;if(d){break a}e=H[a+84>>2];f=h+20|0;d=f;f=f+H[a+80>>2]|0;e=d>>>0>f>>>0?e+1|0:e;H[a+80>>2]=f;H[a+84>>2]=e;e=H[a+68>>2];d=Ia[H[H[e>>2]+24>>2]](e,g+8|0)|0;if(d){break a}f=H[a+84>>2];h=H[g+12>>2];e=H[a+80>>2];if((f|0)>=(h|0)&e>>>0>=K[g+8>>2]|(f|0)>(h|0)){break f}h=H[a+68>>2];d=Ia[H[H[h>>2]+16>>2]](h,e,f)|0;if(d){break a}}d=gy(a,0);if(d){break a}d=by(a,mq(H[a+228>>2]));if(d){break a}lq(H[a+228>>2]);e=H[a+28>>2];if(e>>>0>K[a+36>>2]){d=fq(a,e-((e|0)==H[a+164>>2])|0);if(d){break a}}if(c){break c}d=Iq(a,b)}if(d){break a}}if(H[a+232>>2]){break b}F[a+17|0]=5}d=0}Ea=g+16|0;return d}function kq(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;h=Ea-32|0;Ea=h;j=F[d|0];a:{if((j|0)<0){qc(d,h+12|0);break a}H[h+12>>2]=j}i=267;b:{j=h+24|0;l=zc(d,j)+d|0;k=zc(l,j)+l|0;p=d+e|0;if(k>>>0>p>>>0){break b}l=g;e=0;j=0;m=f;while(1){c:{d:{if(k>>>0<p>>>0){if(!(l|m)){i=0;break d}i=0;H[h+16>>2]=0;e:{if(e&1){i=F[k|0];f:{if((i|0)<0){e=qc(k,h+16|0);i=H[h+16>>2];break f}H[h+16>>2]=i;e=1}if((i|0)>(j|0)){break e}k=e+k|0}e=F[k|0];g:{if((e|0)<0){e=qc(k,h+20|0);break g}H[h+20>>2]=e;e=1}o=e+k|0;if((o-d|0)<(i|0)){break e}k=H[h+20>>2];if((k|0)>(p-o|0)|!k){break e}e=(k>>31)+(i>>31)|0;j=i+k|0;e=j>>>0<i>>>0?e+1|0:e;if((e|0)<=(r|0)&j>>>0<=s>>>0|(e|0)<(r|0)){j=n;break c}e=e<<1|j>>>31;r=e;s=j<<1;j=Fc(n,s,e);if(j){break c}i=7;break d}i=267;break d}if(m){d=H[h+28>>2];H[m>>2]=H[h+24>>2];H[m+4>>2]=d}i=0;if(!l){break d}d=H[h+28>>2];H[l>>2]=H[h+24>>2];H[l+4>>2]=d}Ta(n);break b}Va(i+j|0,o,k);n=j;j=i+k|0;q=Hb(b,n,(c|0)>(j|0)?j:c);e=H[h+24>>2];i=H[h+28>>2];h:{if(m){if(q|(c|0)>=(j|0)?(q|0)>=0:0){break h}H[m>>2]=e;H[m+4>>2]=i;i=H[h+28>>2];e=H[h+24>>2]}m=0;if(!l|(q|0)>=0){break h}H[l>>2]=e;H[l+4>>2]=i;l=0}k=k+o|0;e=e+1|0;i=e?i:i+1|0;H[h+24>>2]=e;H[h+28>>2]=i;e=1;continue}}i:{if(i){break i}n=H[h+12>>2];if((n|0)<2){break i}H[h+24>>2]=0;H[h+20>>2]=0;j:{k:{if(!f|!g){break k}d=H[f>>2];e=H[f+4>>2];if((d|0)==H[g>>2]&(e|0)==H[g+4>>2]){break k}i=_g(a,d,e,h+24|0,h+20|0);if(!i){i=kq(a,b,c,H[h+24>>2],H[h+20>>2],f,0)}Ta(H[h+24>>2]);H[h+24>>2]=0;f=0;d=0;if(i){break j}}d=f?f:g;i=_g(a,H[d>>2],H[d+4>>2],h+24|0,h+20|0);d=H[h+24>>2];l:{if(i){break l}H[h+16>>2]=0;i=267;e=F[d|0];if((e|0)<0){qc(d,h+16|0);e=H[h+16>>2]}if((e|0)>=(n|0)){break l}i=kq(a,b,c,d,H[h+20>>2],f,g);d=H[h+24>>2]}}Ta(d)}Ea=h+32|0;return i}function Tr(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;a:{if(H[a+36>>2]){break a}j=H[a+8>>2];F[c|0]=1;g=H[c+32>>2];while(1){if(H[c+36>>2]>(p|0)){e=H[g>>2];n=H[e+20>>2];m=0;if(F[e+7|0]&1){e=H[H[e+44>>2]+40>>2];if(!(!(H[H[g+4>>2]+4>>2]&32)|(!H[c+28>>2]|!b))){if(!l){l=H[a+44>>2]+1|0;H[a+44>>2]=l}Sa(j,80,b,l)}m=H[a+56>>2]-1|0;H[a+56>>2]=m;wc(a,e,m,16)}b:{if(H[g+16>>2]>=0){f=H[H[H[g>>2]+12>>2]+20>>2];i=H[n>>2];o=(((H[f>>2]+!I[g+21|0]|0)+(I[g+20|0]?i:0)|0)+(I[g+22|0]?i:0)|0)+1|0;e=nc(a,o);Gf(a,f,e,0,1);h=H[f>>2];if(!I[g+21|0]){Sa(j,126,H[g+16>>2],e+h|0);h=h+1|0}c:{if(!I[g+20|0]){f=e;break c}f=e+h|0;Gf(a,n,f,0,1);h=h+i|0}if(!I[g+22|0]){break b}q=I[g+20|0]?f:e;k=0;r=(i|0)>0?i:0;while(1){if((k|0)==(r|0)){break b}Sa(j,181,k+q|0,e+h|0);h=h+1|0;k=k+1|0;continue}}if(!n){i=0;e=0;o=0;f=0;break b}o=0;i=H[n>>2];e=nc(a,i);Gf(a,n,e,0,1);f=e}h=H[g+8>>2];if(!(!n|(h|0)<0)){if(!m){m=H[a+56>>2]-1|0;H[a+56>>2]=m}s=g,t=Yz(a,d,h,m,n,f),H[s+8>>2]=t}d:{if(H[g+16>>2]>=0){f=o-1|0;i=f+e|0;Ua(j,97,e,f,i);gb(j,138,H[g+16>>2],i,e,f);break d}if(I[H[g+4>>2]+4|0]&32){h=n+8|0;f=0;k=0;while(1){if(!((k|0)>=(i|0)|f)){k=k+1|0;f=md(a,H[h>>2]);h=h+16|0;continue}break}f=f?f:H[H[a>>2]+8>>2];e:{if(l){break e}if(!H[c+28>>2]){l=0;break e}l=H[a+44>>2]+1|0;H[a+44>>2]=l}fb(j,85,l,0,0,f,-2)}Ua(j,162,0,e,H[c+24>>2]+(H[c+12>>2]+p|0)|0);xc(j,H[g+4>>2],-7);f=H[j+108>>2];if((f|0)>0){G[(H[j+104>>2]+N(f,20)|0)-18>>1]=i&255}o=i}Sc(a,e,o);if(m){hb(j,m)}g=g+24|0;p=p+1|0;continue}break}f:{if(!l){e=0;if(!b){break f}l=b;if(!H[c+28>>2]){break f}}e=_a(j,16,l)}h=H[c+20>>2];k=0;while(1){if((k|0)<H[c+28>>2]){ac(a,H[h+4>>2],H[c+12>>2]+k|0);h=h+16|0;k=k+1|0;continue}break}F[c|0]=0;if(!e){break a}rk(j,e)}}function gm(a,b,c){var d=0,e=0,f=0,g=0;a:{b:{c:{while(1){if(b>>>0<=1){H[c>>2]=629145;break a}d:{e:{d=I[a+1|0];switch(d-10|0){case 1:case 2:break c;case 0:case 3:break d;default:break e}}if((d|0)==226){break d}f:{g:{h:{i:{j:{k:{l:{m:{n:{switch(d-110|0){default:o:{p:{switch(d-47|0){case 0:break o;case 1:break g;default:break p}}q:{switch(d-98|0){case 4:break l;case 0:break m;case 1:case 2:case 3:break c;default:break q}}if((d|0)==34|(d|0)==39){break o}if((d|0)!=92){break c}}H[c>>2]=d;break b;case 8:break h;case 6:break i;case 4:break j;case 0:break k;case 7:break n;case 1:case 2:case 3:case 5:case 9:break c;case 10:break f}}if(b>>>0<=5){H[c>>2]=629145;break a}r:{d=Py(a+2|0);if((d&64512)!=55296|b>>>0<12|I[a+6|0]!=92|I[a+7|0]!=117){break r}a=Py(a+8|0);if((a&64512)!=56320){break r}H[c>>2]=(d<<10&1047552|a&1023)+65536;b=12;break a}H[c>>2]=d;b=6;break a}H[c>>2]=8;break b}H[c>>2]=12;break b}H[c>>2]=10;break b}H[c>>2]=13;break b}H[c>>2]=9;break b}H[c>>2]=11;break b}H[c>>2]=0;break b}if(b>>>0<=3){H[c>>2]=629145;break a}b=4;e=c;c=I[a+3|0];a=I[a+2|0];H[e>>2]=((c<<1<<24>>24>>>7&9)+c&15|(a<<1<<24>>24>>>7&9)+a<<4)&255;break a}d=0;while(1){s:{e=d;d=d+1|0;if(d>>>0>=b>>>0){break s}f=a+e|0;if(I[f|0]!=92){break s}t:{u:{v:{d=I[a+d|0];switch(d-10|0){case 1:case 2:break s;case 3:break u;case 0:break v;default:break t}}d=e+2|0;continue}d=e+2|0;if(d>>>0>=b>>>0){continue}d=I[a+d|0]==10?e+3|0:d;continue}if((d|0)!=226){break s}d=e+3|0;if(I[f+2|0]!=128|d>>>0>=b>>>0|(I[a+d|0]&254)!=168){break s}d=e+4|0;continue}break}if(!e){H[c>>2]=629145;break a}if((b|0)==(e|0)){H[c>>2]=0;break a}b=b-e|0;a=a+e|0;if(I[a|0]==92){g=e+g|0;continue}break}b=yq(a,b,c)+e|0;break a}H[c>>2]=629145}b=2}return b+g|0}function IA(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;e=Ea-48|0;Ea=e;f=H[a+8>>2];d=H[b+4>>2];a:{if(!(H[a+52>>2]|d&64)){if(d&33554432){d=Mb(f,15);if(I[b+5|0]&16){H[e+16>>2]=H[H[b+20>>2]+16>>2];gc(a,0,17338,e+16|0)}Sa(f,10,H[b+48>>2],H[b+44>>2]);Sa(f,115,c,H[b+28>>2]);b=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(d,20)|0)+8>>2]=b;break a}H[b+4>>2]=d|33554432;d=H[a+44>>2]+1|0;H[a+44>>2]=d;H[b+48>>2]=d;n=b,o=Sa(f,74,0,d)+1|0,H[n+44>>2]=o;j=Mb(f,15)}k=H[b+12>>2];g=Qc(k);H[b+28>>2]=c;m=Sa(f,118,c,g);l=Ef(H[a>>2],g,1);d=H[b+20>>2];b:{if(I[b+5|0]&16){i=H[d+28>>2];H[e+4>>2]=H[d+16>>2];H[e>>2]=j?30558:30404;gc(a,1,17319,e);if((g|0)!=H[i>>2]){break b}H[e+36>>2]=0;H[e+28>>2]=0;H[e+32>>2]=0;H[e+24>>2]=c;F[e+20|0]=11;n=e,o=RA(a,b),H[n+40>>2]=o;H[d+8>>2]=0;d=Ud(H[a>>2],d,0);h=H[a>>2];c:{if(!I[h+87|0]){h=Lc(a,d,e+20|0);fc(H[a>>2],d);Za(H[a>>2],H[e+40>>2]);if(h){break c}d=0;g=(g|0)>0?g:0;h=l+20|0;i=i+8|0;while(1){if((d|0)==(g|0)){break b}n=h+(d<<2)|0,o=Zf(a,tg(k,d),H[i+(d<<4)>>2]),H[n>>2]=o;d=d+1|0;continue}}fc(h,d);Za(H[a>>2],H[e+40>>2])}Xi(l);break a}if(!d){break b}g=rc(k);F[e+20|0]=g;d:{if((g|0)<=64){F[e+20|0]=65;break d}if((g|0)!=69){break d}F[e+20|0]=67}if(l){n=l,o=md(a,H[b+12>>2]),H[n+20>>2]=o}k=d+8|0;g=zb(a);i=zb(a);d=H[d>>2];while(1){if((d|0)>0){h=H[k>>2];e:{if(j){if(ge(h)){break e}de(f,j-1|0);de(f,j);H[b+4>>2]=H[b+4>>2]&-33554433}j=0}ac(a,h,g);fb(f,97,g,1,i,e+20|0,1);gb(f,138,c,i,g,1);k=k+16|0;d=d-1|0;continue}break}rb(a,g);rb(a,i)}if(l){Wd(f,m,l,-8)}if(!j){break a}_a(f,136,c);d=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(j,20)|0)+8>>2]=d;Ua(f,67,H[b+48>>2],H[b+44>>2],1);H[a+28>>2]=0;F[a+19|0]=0}Ea=e+48|0}function py(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;h=Ea-16|0;Ea=h;a:{b:{c=H[b+72>>2];if(c){d=c+H[b+76>>2]|0}else{d=H[b+40>>2]}if(!(H[b+40>>2]+H[b+44>>2]>>>0>d>>>0?d:0)){c=H[b+56>>2];if(c){g=H[c>>2];Ta(H[b+40>>2]);a=0;H[b+40>>2]=0;if(!g){break a}d=H[g+8>>2];c=H[d>>2];a=H[b+64>>2];f=H[g+16>>2];if((f|0)>=H[b+68>>2]){Ta(a);a=f>>31<<1|f>>>31;e=(f<<1)+2|0;a=e>>>0<2?a+1|0:a;a=ub(e,a);H[b+64>>2]=a;if(!a){break b}H[b+68>>2]=(f<<1)+2}Va(a,H[g+12>>2],f);a=0;F[f+H[b+64>>2]|0]=0;H[b+60>>2]=f;e=c+1|0;c=ub(e,e>>31);if(!c){break b}c=Va(c,H[d+4>>2],e);H[b+72>>2]=c;H[b+44>>2]=e;H[b+76>>2]=e;H[b+40>>2]=c;H[b+56>>2]=H[b+56>>2]+4;break a}iq(b);d=H[b+36>>2];e=H[b+20>>2];c=H[b+32>>2];if((d|0)>=(e|0)&c>>>0>=K[b+16>>2]|(d|0)>(e|0)){a=0;break a}c=c+1|0;d=c?d:d+1|0;H[b+32>>2]=c;H[b+36>>2]=d;a=_g(a,c,d,b+40|0,b+44|0);if(a){break a}d=H[b+40>>2]}a=cm(b,d,20);if(a){break a}a=F[d|0];c:{if((a|0)<0){a=qc(d,h+12|0);break c}H[h+12>>2]=a;a=1}c=a+d|0;d=F[c|0];d:{if((d|0)<0){a=qc(c,h+8|0);d=H[h+8>>2];break d}H[h+8>>2]=d;a=1}e:{if((d|0)<=0){break e}g=a+c|0;if(((H[b+40>>2]+H[b+44>>2]|0)-g|0)<(d|0)){break e}f=H[h+12>>2];if((f|0)>H[b+60>>2]){break e}a=f>>31;c=d+f|0;a=c>>>0<d>>>0?a+1|0:a;e=H[b+68>>2];i=e>>>0<c>>>0;e=e>>31;if(i&(e|0)<=(a|0)|(a|0)>(e|0)){a=a<<1|c>>>31;c=c<<1;a=Fc(H[b+64>>2],c,a);if(!a){break b}H[b+68>>2]=c;H[b+64>>2]=a}a=cm(b,g,d+10|0);if(a){break a}Va(f+H[b+64>>2]|0,g,d);H[b+60>>2]=d+f;c=d+g|0;d=F[c|0];f:{if((d|0)<0){a=qc(c,b+76|0);d=H[b+76>>2];break f}H[b+76>>2]=d;a=1}H[b+80>>2]=0;c=a+c|0;H[b+72>>2]=c;if((H[b+40>>2]+(H[b+44>>2]-c|0)|0)<(d|0)){break e}if(!H[b+48>>2]){a=267;if(I[(d+c|0)-1|0]){break a}}a=d?0:267;break a}a=267;break a}a=7}Ea=h+16|0;return a}function Xy(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;f=Ea+-64|0;Ea=f;h=mg(a,H[c>>2],(b|0)!=1);a:{if(!h){break a}l=b-1|0;m=d-2|0;b=1;b:{while(1){if((b|0)<(l|0)){i=(b<<2)+c|0;j=H[i>>2];k=J[j+16>>1];e=k&31;if((k&63)>>>0>=32){e=-1431655766>>>e|0}else{e=((1<<e)-1&-1431655766)<<32-e|-1431655766>>>e}c:{if(e&1){break c}j=$a(j);if(!j){Ub(a);ad(h);break a}if(I[j|0]!=36){break b}e=H[i+4>>2];g=J[e+16>>1];Xa(f+8|0,0,56);H[f+24>>2]=H[H[a>>2]+20>>2];d:{e:{f:{g:{h:{switch(I[(g&63)+31056|0]-1|0){case 3:if(Vj(e)){n=f,o=fd(e),H[n+8>>2]=o;n=f,o=xb(e),H[n+12>>2]=o;break g}Gb(a,5355,-1);break f;case 2:g=$a(e);i=xb(e);if(!g){break f}if(!(!(I[e+17|0]&8)|I[e+19|0]!=74)){H[f+28>>2]=i;H[f+20>>2]=g;e=f+8|0;if(!nm(e,a)){break g}Gb(a,19873,-1);Za(H[f+24>>2],H[f+8>>2]);Xa(e,0,56);break f}sd(f+8|0,10,i,g);break g;case 1:C(+Db(e));g=x(1)|0;i=x(0)|0;if(!(!(g&1048575|i)|(g&2146435072)!=2146435072)){sd(f+8|0,0,0,0);break g}g=xb(e);e=$a(e);if(!e){break f}i:{i=I[e|0];if((i|0)!=45){if((i|0)!=73){break i}sd(f+8|0,5,5,22973);break g}if(I[e+1|0]!=73){break i}sd(f+8|0,5,6,22972);break g}sd(f+8|0,5,g,e);break g;case 0:break h;default:break e}}g=xb(e);e=$a(e);if(!e){break f}sd(f+8|0,3,g,e)}if(!I[f+43|0]){break d}Ub(a)}vf(f+8|0);ad(h);break a}H[f+12>>2]=1;H[f+8>>2]=73356}j:{if(!I[j+1|0]){g=0;k:{switch(m|0){case 0:case 2:break k;default:break j}}Xe(h,0,H[h+4>>2],H[f+8>>2],H[f+12>>2]);break j}F[h+39|0]=d;H[h+44>>2]=H[f+12>>2];e=H[f+8>>2];H[h+40>>2]=0;H[h+52>>2]=e;g=Ie(h,0,j+1|0,0)}vf(f+8|0);if((g|0)==-2){break c}if(g>>>0>4294967292){break b}}b=b+2|0;continue}break}Gq(a,h);ad(h);break a}ad(h);if((g|0)==-1){Gb(a,19873,-1);break a}Yj(a,j)}Ea=f- -64|0}function Ln(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0;j=Ea-32|0;Ea=j;h=H[a>>2];a:{b:{if(!(!I[h+177|0]|H[h+172>>2]!=1)){i=I[h+176|0];c=Tb(h,(i|0)==1?9192:9211);break b}b=Lf(a,b,c,j+28|0);if((b|0)<0){break a}c:{if(!d){i=b;break c}i=1;if(!H[c+4>>2]|(b|0)==1){break c}Wa(a,16229,0);break a}b=H[j+28>>2];c=tc(h,b);if(I[a+220|0]<2){break b}c=ue(a,c,b)}k=H[b+4>>2];H[a+200>>2]=H[b>>2];H[a+204>>2]=k;if(!c){break a}d:{if(Ik(a,c,e?1851:14316,c)){break d}d=I[h+176|0]==1?1:d;k=H[H[h+16>>2]+(i<<4)>>2];if(Yb(a,18,(d|0)==1?9192:9211,0,k)){break d}if(!f){if(Yb(a,I[(d+(e<<1)|0)+49764|0],c,0,k)){break d}}e:{f:{if(I[a+220|0]){break f}d=H[H[h+16>>2]+(i<<4)>>2];if(ze(a)){break d}k=yc(h,c,d);if(k){if(g){break e}d=I[k+43|0];H[j+20>>2]=b;H[j+16>>2]=(d|0)==2?1851:14316;Wa(a,3798,j+16|0);break d}if(!ef(h,c,d)){break f}H[j>>2]=c;Wa(a,7166,j);break d}b=nb(h,64,0);if(!b){H[a+12>>2]=7;H[a+36>>2]=H[a+36>>2]+1;break d}G[b+32>>1]=65535;H[b>>2]=c;c=H[(H[h+16>>2]+(i<<4)|0)+12>>2];G[b+38>>1]=200;H[b+24>>2]=1;H[b+60>>2]=c;H[a+248>>2]=b;if(I[h+177|0]){break a}b=wb(a);if(!b){break a}kd(a,1,i);if(f){Mb(b,170)}c=H[a+44>>2];d=c+2|0;H[a+100>>2]=d;g=c+1|0;H[a+96>>2]=g;c=c+3|0;H[a+44>>2]=c;Ua(b,99,i,c,2);ke(b,i);k=_a(b,16,c);Ua(b,100,i,2,H[h+32>>2]&2?1:4);Ua(b,100,i,5,I[h+84|0]);h=H[b+108>>2];H[(I[H[b>>2]+87|0]?73336:H[b+104>>2]+N(k,20)|0)+8>>2]=h;g:{if(e|f){Sa(b,71,0,d);break g}l=a,m=Ua(b,147,i,d,1),H[l+144>>2]=m}d=wb(a);wd(a,i,1,1,9211);gb(d,113,0,1,i,5);if(!H[a+40>>2]){H[a+40>>2]=1}Sa(b,127,0,g);fb(b,77,6,c,0,49768,-1);Ua(b,128,0,c,g);a=H[b+108>>2];if((a|0)>0){G[(H[b+104>>2]+N(a,20)|0)-18>>1]=8}Mb(b,122);break a}ld(a,i);Gk(a)}F[a+17|0]=1;db(h,c)}Ea=j+32|0}function $G(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=Ea-128|0;Ea=d;a:{if((b|0)<2){break a}g=mg(a,H[c>>2],0);if(!g){break a}j=H[H[a+4>>2]+8>>2];H[d>>2]=a;G[d+24>>1]=1;H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=100;H[d+12>>2]=0;l=d+26|0;H[d+4>>2]=l;m=(b|0)==2;if(!m){ic(d,91)}n=j&10;o=j&1;p=j&3;k=1;while(1){b:{c:{d:{e:{f:{g:{h:{i:{j:{if((b|0)!=(k|0)){f=$a(H[(k<<2)+c>>2]);if(!f){break b}h=bb(f);if(I[f|0]==36){e=Ie(g,0,f+1|0,0);break f}if(!p){break e}H[d>>2]=a;G[d+24>>1]=1;H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=100;H[d+12>>2]=0;H[d+4>>2]=l;e=0;while(1){if((e|0)==(h|0)){break j}i=e+f|0;e=e+1|0;if(I[i|0]-58>>>0>=4294967286){continue}break}e=0;while(1){if((e|0)==(h|0)){break i}i=e+f|0;e=e+1|0;i=I[i|0];if((i|0)==95|I[i+31152|0]&6){continue}break}if(!(I[f|0]!=91|h>>>0<=2)&I[(f+h|0)-1|0]==93){break h}$c(d,29791,2);uf(d,f,h);$c(d,29792,1);break g}if((b|0)==2){break b}ic(d,93);wf(d,0,0);if(j&8){break b}a=H[a>>2];F[a+19|0]=74;G[a+16>>1]=J[a+16>>1]|2048;break b}$c(d,18354,1);uf(d,f,h);$c(d,18352,2);break g}$c(d,24838,1)}uf(d,f,h)}Fq(d);e=Ie(g,0,H[d+4>>2],0);lg(d)}if(K[g+4>>2]>e>>>0){if((b|0)!=2){break d}if(o){G[d+24>>1]=1;H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=100;H[d+12>>2]=0;H[d+4>>2]=l;H[d>>2]=a;ah(g,e,d);wf(d,0,0);lg(d);e=H[a>>2];F[e+19|0]=74;G[e+16>>1]=J[e+16>>1]|2048;break c}mm(g,e,a,0);if((I[H[g>>2]+e|0]&15)>>>0<11|n){break c}e=H[a>>2];F[e+19|0]=74;G[e+16>>1]=J[e+16>>1]|2048;break c}k:{switch(e+2|0){case 0:if(m){break b}qm(d);$c(d,11625,4);break c;case 1:break k;default:break e}}Gb(a,19873,-1);break b}Yj(a,f);break b}qm(d);ah(g,e,d)}k=k+1|0;continue}break}lg(d);ad(g)}Ea=d+128|0}function yy(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;i=Ea-16|0;Ea=i;j=H[H[a>>2]+12>>2];b=H[a+108>>2];f=H[a+104>>2]+1|0;b=f?b:b+1|0;H[a+104>>2]=f;H[a+108>>2]=b;b=H[a+116>>2];g=H[a+112>>2];f=g+1|0;f=(b|0)>(f|0)?b:f;a:{b:{while(1){g=g+1|0;if((b|0)<=(g|0)){break b}d=H[a+120>>2]+(g<<4)|0;e=H[d>>2];d=H[d+4>>2];if((d|0)<0){h=1}else{h=!e&(d|0)<=0}if(h){continue}break}H[a+112>>2]=g;j=0;break a}H[a+112>>2]=f;j=gi(j,a+8|0);if((j|0)==100){l=H[a+64>>2];m=H[a+68>>2];c:{b=H[a+88>>2];if(!b){break c}j=0;h=b;b=H[a+92>>2];f=H[a+60>>2];g=Hb(h,H[a+56>>2],(b|0)<(f|0)?b:f);if(g|(b|0)>=(f|0)?(g|0)>=0:0){break c}H[a+100>>2]=1;break a}j=7;if(xy(a,2)){break a}g=0;Xa(H[a+120>>2],0,H[a+116>>2]<<4);d=0;f=0;while(1){if((g|0)<(m|0)){H[i+8>>2]=0;H[i+12>>2]=0;n=zc(g+l|0,i+8|0);d:{e:{f:{g:{h:{switch(c|0){case 2:b=H[i+8>>2];e=H[i+12>>2];break g;case 0:b=H[a+120>>2];d=b;c=H[b>>2];b=H[b+4>>2];c=c+1|0;b=c?b:b+1|0;H[d>>2]=c;H[d+4>>2]=b;c=1;d=0;break d;case 1:break h;default:break f}}c=H[i+12>>2];e=c;b=H[i+8>>2];if(b>>>0<2&(c|0)<=0|(c|0)<0){break g}c=H[a+120>>2];h=c;k=H[c+16>>2];c=H[c+20>>2];k=k+1|0;c=k?c:c+1|0;H[h+16>>2]=k;H[h+20>>2]=c}if(!e&b>>>0<=1){c=0;if(b-1|0){break d}c=3;break d}b=H[a+120>>2];c=b+(d<<4)|0;e=c+24|0;h=H[c+24>>2];c=H[c+28>>2];h=h+1|0;c=h?c:c+1|0;H[e>>2]=h;H[e+4>>2]=c;c=H[b+12>>2];e=H[b+8>>2]+1|0;c=e?c:c+1|0;H[b+8>>2]=e;H[b+12>>2]=c;break e}d=H[i+8>>2];if((d|0)<=0){f=267;break d}if(xy(a,d+2|0)){break a}b=H[a+120>>2]+(d<<4)|0;c=b;e=H[b+16>>2];b=H[b+20>>2];e=e+1|0;b=e?b:b+1|0;H[c+16>>2]=e;H[c+20>>2]=b}c=2}g=g+n|0;continue}break}H[a+112>>2]=0;j=f;break a}H[a+100>>2]=1}Ea=i+16|0;return j|0}function eD(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;f=Ea-128|0;Ea=f;e=12;a:{b:{c:{switch(b-1|0){case 0:H[c>>2]=I[a+16|0];break b;case 3:H[c>>2]=H[a+20>>2];break b;case 5:H[a+40>>2]=H[c>>2];break b;case 4:if(H[a+40>>2]<=0){break b}e=H[c>>2];c=H[c+4>>2];if(Ia[H[16664]](H[a+12>>2],f+32|0)|0){e=1802;break a}b=H[a+40>>2];e=b+e|0;j=c;c=b>>31;d=j+c|0;g=e-1|0;d=(b>>>0>e>>>0?d+1|0:d)-!e|0;e=uJ(g,d,b,c);c=g-e|0;k=d-(Ha+(e>>>0>g>>>0)|0)|0;g=k;l=H[f+60>>2];e=l;j=c;d=H[f+56>>2];if((g|0)<=(e|0)&c>>>0<=d>>>0|(e|0)>(g|0)){break b}e=c-1|0;h=H[f+64>>2];c=e+h|0;n=g-!j|0;m=h>>31;g=n+m|0;g=c>>>0<h>>>0?g+1|0:g;i=uJ(d,l,h,m)^-1;b=i+d|0;d=(Ha^-1)+l|0;d=b>>>0<i>>>0?d+1|0:d;while(1){d=d+m|0;b=b+h|0;d=b>>>0<h>>>0?d+1|0:d;if((g|0)<=(d|0)&b>>>0>=c>>>0|(d|0)>(g|0)){break b}i=b>>>0<j>>>0&(d|0)<=(k|0)|(d|0)<(k|0);b=i?b:e;d=i?d:n;if((vv(a,b,d,30558,1)|0)==1){continue}break};e=778;break a;case 9:tv(a,4,c);break b;case 12:tv(a,16,c);break b;case 11:H[f>>2]=H[H[a+4>>2]+16>>2];o=c,p=Ab(8863,f),H[o>>2]=p;break b;case 15:e=0;b=H[H[a+4>>2]+8>>2];b=ub(b,b>>31);if(!b){break a}eu(H[H[a+4>>2]+8>>2],b);H[c>>2]=b;break a;case 19:o=c,p=sv(a),H[o>>2]=p;break b;case 1:case 2:case 6:case 7:case 8:case 10:case 13:case 14:case 16:case 17:case 18:break a;default:break c}}if((b|0)!=40){break a}e=0;H[c>>2]=0;a=H[a+36>>2];if(!a){break a}a=H[a>>2];H[f+56>>2]=0;H[f+60>>2]=0;H[f+48>>2]=5;H[f+52>>2]=0;H[f+40>>2]=123;H[f+44>>2]=0;H[f+32>>2]=0;H[f+36>>2]=0;G[f+32>>1]=1;a=H[a+12>>2];H[f+16>>2]=f+32;if((Ia[H[16670]](a,12,f+16|0)|0)<0){e=3850;break a}H[c>>2]=J[f+32>>1]!=2;break a}e=0}Ea=f+128|0;return e|0}function hH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=Ea-160|0;Ea=b;d=b+112|0;a:{if(ng(a,1,c,d)){break a}h=c+4|0;c=b- -64|0;if(ng(a,1,h,c)){break a}Ye(d);Ye(c);i=H[b+116>>2];d=i;e=H[b+68>>2];f=H[b+112>>2];b:{if((d|0)>=(e|0)&f>>>0>=K[b+64>>2]|(d|0)>(e|0)){d=H[b+120>>2];e=H[b+72>>2];if((d|0)!=(e|0)){F[b+104|0]=0;H[b+72>>2]=d;Ac(c)}g=H[b+124>>2];c=g-H[b+76>>2]|0;j=c>>31;c=(c|0)<0?c+12|0:c;if(c){F[b+104|0]=0;H[b+76>>2]=g;Ac(b- -64|0)}g=(d-e|0)+j|0;while(1){e=H[b+64>>2];h=H[b+68>>2];d=h;if(f>>>0<e>>>0&(i|0)<=(d|0)|(d|0)>(i|0)){d=H[b+76>>2];H[b+76>>2]=d-1;if((d|0)<=1){H[b+76>>2]=12;H[b+72>>2]=H[b+72>>2]-1}d=(c|0)<=0;c=d?11:c-1|0;g=g-d|0;F[b+104|0]=0;Ac(b- -64|0);continue}break}j=43;d=f-e|0;f=i-((f>>>0<e>>>0)+h|0)|0;break b}e=H[b+72>>2];d=H[b+120>>2];if((e|0)!=(d|0)){F[b+104|0]=0;H[b+72>>2]=d;Ac(b- -64|0)}g=H[b+124>>2];c=H[b+76>>2]-g|0;j=c>>31;c=(c|0)<0?c+12|0:c;if(c){F[b+104|0]=0;H[b+76>>2]=g;Ac(b- -64|0)}g=(e-d|0)+j|0;while(1){e=H[b+64>>2];h=H[b+68>>2];d=h;if(e>>>0<f>>>0&(d|0)<=(i|0)|(d|0)<(i|0)){d=H[b+76>>2];H[b+76>>2]=d+1;if((d|0)>=12){H[b+76>>2]=1;H[b+72>>2]=H[b+72>>2]+1}d=(c|0)<=0;c=d?11:c-1|0;g=g-d|0;F[b+104|0]=0;Ac(b- -64|0);continue}break}j=45;d=e-f|0;f=h-((f>>>0>e>>>0)+i|0)|0}F[b+156|0]=0;G[b+154>>1]=0;f=f+34621|0;d=d-816922112|0;f=d>>>0<3478045184?f+1|0:f;H[b+112>>2]=d;H[b+116>>2]=f;Ye(b+112|0);d=H[b+136>>2];H[b+16>>2]=H[b+132>>2];H[b+20>>2]=d;M[b+24>>3]=M[b+144>>3];G[b+60>>1]=0;H[b+56>>2]=0;H[b+48>>2]=0;H[b+52>>2]=100;H[b+40>>2]=0;H[b+44>>2]=0;H[b>>2]=j;H[b+4>>2]=g;H[b+8>>2]=c;H[b+12>>2]=H[b+128>>2]-1;c=b+40|0;lb(c,12692,b);um(a,c)}Ea=b+160|0}function hp(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=Ea-16|0;Ea=h;H[h+12>>2]=0;a:{while(1){b:{c:{d:{g=I[b|0];switch(g-174|0){case 1:break a;case 2:break b;case 0:break c;default:break d}}if((g|0)!=181){break a}}b=H[b+12>>2];continue}break}g=I[b+2|0]}e:{f:{g:{h:{i:{if((g|0)!=173){if((g|0)!=36){j=30558;k=1;break i}f=Mi(H[b+8>>2],0)&255;i=hp(a,H[b+12>>2],c,f,e);a=H[e>>2];if(!a){break e}iu(a,f,c);ve(H[e>>2],d<<24>>24,c);break e}j=24841;k=-1;l=-1;j:{b=H[b+12>>2];g=I[b|0];switch(g-153|0){case 0:case 2:break i;default:break j}}a=hp(a,b,c,d,h+12|0);f=H[h+12>>2];if(a|!f){break h}Ct(f);b=J[f+16>>1];k:{if(b&8){M[f>>3]=-M[f>>3];break k}a=H[f>>2];g=H[f+4>>2];if(!a&(g|0)==-2147483648){H[f>>2]=0;H[f+4>>2]=1138753536;G[f+16>>1]=b&62016|8;break k}H[f>>2]=0-a;H[f+4>>2]=0-(g+((a|0)!=0)|0)}ve(f,d<<24>>24,c);break h}l:{m:{n:{o:{p:{switch(g-153|0){case 1:break m;case 0:case 2:break o;default:break p}}switch(g-117|0){case 4:break n;case 0:break o;case 1:case 2:case 3:break h;default:break l}}f=og(a);if(!f){break g}q:{if(I[b+5|0]&8){a=H[b+8>>2];Bc(f,sJ(k,l,a,a>>31),Ha);break q}H[h+4>>2]=H[b+8>>2];H[h>>2]=j;b=mb(a,6113,h);if(!b){break f}wm(f,b,5)}ve(f,((d|0)==65?(g&253)==153?67:d:d)<<24>>24,1);a=J[f+16>>1];if(a&44){G[f+16>>1]=a&65533}if((c|0)==1){break h}i=Pd(f,c);break h}f=og(a);if(!f){break g}Xb(f);break h}f=og(a);if(!f){break g}b=H[b+8>>2]+2|0;c=bb(b)-1|0;d=(c|0)/2|0;hd(f,_s(a,b,c),d,0,0,5);break h}if((g|0)!=170){break h}f=og(a);if(!f){f=0;break h}G[f+16>>1]=4;H[f>>2]=!I[H[b+8>>2]+4|0];H[f+4>>2]=0;ve(f,d<<24>>24,c)}H[e>>2]=f;break e}f=0}Ib(a);Za(a,0);Uc(f);i=7}Ea=h+16|0;return i}function Vq(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;n=d?161:162;o=e+1|0;k=H[a>>2];f=wb(k);g=b;while(1){if(g){a=0;l=H[g+44>>2];i=0;a:{if(I[g+96|0]){break a}h=H[H[g+72>>2]+20>>2];i=0;if(!h){break a}i=H[h>>2]}h=(i|0)>0?i:0;while(1){if((a|0)!=(h|0)){b:{if(!((a|0)==1&H[l+32>>2]==50064)){Ua(f,94,c,H[g+80>>2]+a|0,a+e|0);break b}Ua(f,94,H[b+48>>2],H[g+80>>2]+1|0,o)}a=a+1|0;continue}break}c:{if(!(H[b+88>>2]|!(I[l+5|0]&16)|I[g+17|0]==90)){l=_a(f,50,e);d:{if(!d){Sa(f,86,H[g+64>>2]+1|0,1);Sa(f,81,e,H[g+64>>2]);a=H[g+64>>2];Ua(f,97,a,2,a+2|0);Sa(f,138,H[g+60>>2],H[g+64>>2]+2|0);a=H[f+108>>2];h=I[H[f>>2]+87|0];break d}gb(f,23,H[g+60>>2],0,e,1);_a(f,130,H[g+60>>2]);a=H[f+108>>2];h=I[H[f>>2]+87|0];H[(h?73336:(H[f+104>>2]+N(a,20)|0)-40|0)+8>>2]=a}H[(h?73336:H[f+104>>2]+N(l,20)|0)+8>>2]=a;break c}a=H[g+64>>2];if(a){Sa(f,86,(a-d|0)+1|0,1);break c}if(H[l+16>>2]==90){break c}e:{if(!H[g+40>>2]){m=0;break e}a=zb(k);Ua(f,94,c,H[g+80>>2]+i|0,a);m=Ua(f,17,a,0,1);rb(k,a)}h=e;f:{if(!I[g+96|0]){break f}a=H[f+108>>2];i=H[H[H[g+72>>2]+20>>2]>>2];h=nc(k,i);Gf(k,H[H[g+72>>2]+20>>2],h,0,0);j=H[f+108>>2];p=(a|0)>(j|0)?a:j;while(1){if((a|0)==(p|0)){break f}j=73336;j=I[H[f>>2]+87|0]?j:H[f+104>>2]+N(a,20)|0;if(!(I[j|0]!=94|H[j+4>>2]!=H[b+48>>2])){H[j+4>>2]=c}a=a+1|0;continue}}if(I[l+4|0]&32){fb(f,85,0,0,0,Bf(k,H[H[H[g+72>>2]+20>>2]+8>>2]),-2)}Ua(f,n,d,h,H[g+52>>2]);xc(f,l,-7);a=H[f+108>>2];if((a|0)>0){G[(H[f+104>>2]+N(a,20)|0)-18>>1]=i&255}if(I[g+96|0]){Sc(k,h,i)}if(!m){break c}H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(m,20)|0)+8>>2]=H[f+108>>2]}g=H[g+36>>2];continue}break}}function ss(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;m=Ea-32|0;Ea=m;o=H[a>>2];k=H[a+248>>2];a:{if(!k|I[a+220|0]==1){break a}b:{if(!b){j=1;f=G[k+34>>1];if((f|0)<=0){break a}if(!d|H[d>>2]==1){break b}e=H[(H[k+4>>2]+N(f,12)|0)-12>>2];H[m+20>>2]=c;H[m+16>>2]=e;Wa(a,18968,m+16|0);break a}j=H[b>>2];if(!d|(j|0)==H[d>>2]){break b}Wa(a,14228,0);break a}g=(H[c+4>>2]+(j<<3)|0)+37|0;f=0;c:{if(!d){break c}l=H[d>>2];p=(l|0)>0?l:0;n=d+8|0;while(1){if((h|0)==(p|0)){break c}l=bb(H[(n+(h<<4)|0)+4>>2])+1|0;g=g+l|0;f=l>>>0>g>>>0?f+1|0:f;h=h+1|0;continue}}f=nb(o,g,f);if(!f){break a}H[f>>2]=k;i=H[k+48>>2];l=f+36|0;g=l+(j<<3)|0;H[f+8>>2]=g;H[f+4>>2]=i;if(I[a+220|0]>=2){ue(a,g,c)}i=0;g=Va(g,H[c>>2],H[c+4>>2]);F[g+H[c+4>>2]|0]=0;pf(g);p=H[c+4>>2];H[f+20>>2]=j;d:{e:{if(b){n=(j|0)>0?j:0;r=b+8|0;while(1){if((i|0)==(n|0)){break e}h=0;c=G[k+34>>1];s=(c|0)>0?c:0;c=(i<<4)+r|0;while(1){if((h|0)==(s|0)){break d}q=H[c+4>>2];if(ab(H[H[k+4>>2]+N(h,12)>>2],q)){h=h+1|0;continue}break}c=l+(i<<3)|0;H[c>>2]=h;if(I[a+220|0]>=2){dd(a,c,q)}i=i+1|0;continue}}H[l>>2]=G[k+34>>1]-1}f:{if(!d){break f}c=(g+p|0)+1|0;j=(j|0)>0?j:0;p=d+8|0;h=0;while(1){if((h|0)==(j|0)){break f}n=p+(h<<4)|0;g=H[n+4>>2];i=bb(g);H[(l+(h<<3)|0)+4>>2]=c;if(I[a+220|0]>=2){dd(a,c,g);g=H[n+4>>2]}c=Va(c,g,i)+i|0;F[c|0]=0;h=h+1|0;c=c+1|0;continue}}F[f+25|0]=e;F[f+24|0]=0;F[f+26|0]=e>>>8;a=od(H[k+60>>2]+56|0,H[f+8>>2],f);if((a|0)==(f|0)){Ib(o);i=f;break a}if(a){H[f+12>>2]=a;H[a+16>>2]=f}H[k+48>>2]=f;i=0;break a}H[m>>2]=H[c+4>>2];Wa(a,10291,m);i=f}Za(o,i);pb(o,b);pb(o,d);Ea=m+32|0}function np(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;g=Ea-80|0;Ea=g;i=H[b+44>>2];H[g+60>>2]=0;h=a+404|0;j=H[b+48>>2];a:{b:{while(1){f=H[h>>2];if(!f){break b}h=f+8|0;if(H[f+4>>2]!=(b|0)){continue}break}H[g+48>>2]=H[b>>2];n=e,o=mb(a,7461,g+48|0),H[n>>2]=o;h=6;break a}h=7;k=Tb(a,H[b>>2]);if(!k){break a}f=td(28,0);c:{if(!f){Ib(a);break c}F[f+18|0]=1;H[f+4>>2]=c;H[f>>2]=a;n=H[b+48>>2],o=H[H[a+16>>2]+(Fb(a,H[b+60>>2])<<4)>>2],H[n+4>>2]=o;H[g+64>>2]=f;H[g+68>>2]=b;h=H[a+404>>2];H[g+76>>2]=0;H[g+72>>2]=h;H[a+404>>2]=g- -64;H[b+24>>2]=H[b+24>>2]+1;h=Ia[d|0](a,H[c+12>>2],i,j,f+8|0,g+60|0)|0;Cd(a,b);H[a+404>>2]=H[g+72>>2];if(h){if((h|0)==7){Ib(a)}b=H[g+60>>2];d:{if(!b){H[g>>2]=k;n=e,o=mb(a,8623,g),H[n>>2]=o;break d}H[g+16>>2]=b;n=e,o=mb(a,8863,g+16|0),H[n>>2]=o;Ta(H[g+60>>2])}db(a,f);break c}h=0;d=H[f+8>>2];if(!d){break c}H[d>>2]=0;H[d+4>>2]=0;H[d+8>>2]=0;H[H[f+8>>2]>>2]=H[c>>2];h=1;H[c+8>>2]=H[c+8>>2]+1;H[f+12>>2]=1;if(!H[g+76>>2]){H[g+32>>2]=H[b>>2];n=e,o=mb(a,8751,g+32|0),H[n>>2]=o;Rf(f);break c}H[f+24>>2]=H[b+52>>2];H[b+52>>2]=f;d=0;c=0;while(1){if((d|0)<G[b+34>>1]){h=0;l=N(d,12);i=ql(l+H[b+4>>2]|0,30558);j=bb(i);e:{f:{while(1){if((h|0)==(j|0)){break f}g:{f=h+i|0;if(!(yb(11331,f,6)|(I[f-1|0]!=32?h:0))){e=I[f+6|0];if((e|32)==32){break g}}h=h+1|0;continue}break}c=e?7:6;e=h;while(1){m=c+e|0;if(m>>>0<=j>>>0){F[e+i|0]=I[i+m|0];e=e+1|0;continue}break}if(!(I[f|0]|!h)){F[f-1|0]=0}c=H[b+4>>2]+l|0;G[c+10>>1]=J[c+10>>1]|2;c=1024;e=2;break e}e=c}H[b+28>>2]=e|H[b+28>>2];d=d+1|0;continue}break}h=0}db(a,k)}Ea=g+80|0;return h}function zx(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;d=Ea-48|0;Ea=d;H[d+44>>2]=H[a>>2];h=H[b>>2];H[d+40>>2]=h;H[d+36>>2]=H[c>>2];while(1){a:{b:{c:{d:{e:{f:{g:{e=I[h|0];h:{i:{if(!e){f=H[d+36>>2];if(!I[f|0]){break e}f=2147483647;break i}f=0;if((e|0)!=1){break i}f=F[h+1|0];if((f|0)<0){qc(h+1|0,d+32|0);f=H[d+32>>2]}if(!f){break h}}e=2147483647;j:{g=H[d+36>>2];switch(I[g|0]){case 1:break j;case 0:break f;default:break g}}e=F[g+1|0];if((e|0)<0){qc(g+1|0,d+28|0);e=H[d+28>>2]}if(e){break f}}e=267;break a}e=0}if((e|0)!=(f|0)){break c}H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=0;H[d+12>>2]=0;H[d>>2]=0;H[d+4>>2]=0;f=Up(d+44|0,f);H[d+36>>2]=f+g;H[d+40>>2]=f+h;bi(d+40|0,d+16|0);bi(d+36|0,d+8|0);e=H[d+20>>2];h=e;f=H[d+16>>2];if((e|0)>=0&f>>>0>=2|(e|0)>0){e=H[d+8>>2];g=H[d+12>>2];if(e>>>0>1&(g|0)>=0|(g|0)>0){break d}}f=H[d+36>>2];h=H[d+40>>2]}g=H[d+44>>2];H[d+44>>2]=g+1;e=0;F[g|0]=0;H[a>>2]=H[d+44>>2];H[b>>2]=h+1;H[c>>2]=f+1;break a}while(1){i=(h|0)<=(g|0)&e>>>0>f>>>0|(h|0)<(g|0);yx(d+44|0,d,i?f:e,i?h:g);i=H[d>>2];j=H[d+4>>2]-(i>>>0<2)|0;i=i-2|0;H[d>>2]=i;H[d+4>>2]=j;k:{if((e|0)==(f|0)&(h|0)==(g|0)){Tl(d+40|0,d+16|0);Tl(d+36|0,d+8|0);break k}if((h|0)<=(g|0)&e>>>0>f>>>0|(h|0)<(g|0)){Tl(d+40|0,d+16|0);break k}Tl(d+36|0,d+8|0)}f=H[d+16>>2];h=H[d+20>>2];e=H[d+8>>2];g=H[d+12>>2];if((f|0)!=-1|(h|0)!=2147483647|((e|0)!=-1|(g|0)!=2147483647)){continue}break}break b}if((e|0)>(f|0)){e=d+44|0;k=d,l=Up(e,f)+h|0,H[k+40>>2]=l;tf(e,d+40|0);break b}f=d+44|0;k=d,l=Up(f,e)+g|0,H[k+36>>2]=l;tf(f,d+36|0)}h=H[d+40>>2];continue}break}Ea=d+48|0;return e}function Zl(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Ea-16|0;Ea=g;c=H[a>>2];a:{b:{c:{if(!b){f=1;break c}j=H[c>>2];d:{if(j-3>>>0<=1){d=b<<2;h=ub(d,0);if(!h){f=7;break c}k=Xa(h,0,d);e=c;while(1)if(H[e>>2]!=(j|0)){H[g+12>>2]=e;m=b-1|0;d=0;e:{f:{while(1){i=H[e+8>>2];H[e+8>>2]=0;h=0;if(i){H[i+12>>2]=0;h=c}g:{f=Zl(g+12|0,m);if(!f){e=0;c=H[g+12>>2];while(1){if(!(!c|(b|0)<=(e|0))){l=(e<<2)+k|0;f=H[l>>2];h:{if(!f){f=c;c=0;break h}H[d+16>>2]=c;H[d+12>>2]=f;H[f+8>>2]=d;H[c+8>>2]=d;n=H[d+8>>2];f=0;H[d+8>>2]=0;c=d;d=n}H[l>>2]=f;e=e+1|0;continue}break}if(!c){break g}_d(c);f=18}e=0;b=(b|0)>0?b:0;while(1){if((b|0)==(e|0)){break f}_d(H[(e<<2)+k>>2]);e=e+1|0;continue}}if(i){c=i+16|0;while(1){e=H[c>>2];c=e+12|0;if(H[e>>2]==(j|0)){continue}break}H[g+12>>2]=e;c=H[i+16>>2];f=H[i+8>>2];H[c+8>>2]=f;if(f){H[f+12>>2]=c;c=h}H[i+8>>2]=d;d=i;continue}break}f=0;h=(b|0)>0?b:0;c=0;e=0;while(1){if((e|0)==(h|0)){break e}i=(e<<2)+k|0;b=H[i>>2];if(b){i:{if(!c){c=b;break i}H[d+16>>2]=c;b=H[i>>2];H[d+12>>2]=b;H[b+8>>2]=d;H[c+8>>2]=d;c=d;d=H[c+8>>2]}H[c+8>>2]=0}e=e+1|0;continue}}while(1){if(d){b=H[d+8>>2];Ta(d);d=b;continue}break}c=h}Ta(k);break d}else{e=H[e+12>>2];continue}}if((j|0)!=2){break b}h=H[c+12>>2];H[g+8>>2]=h;d=H[c+16>>2];H[g+4>>2]=d;H[c+12>>2]=0;H[c+16>>2]=0;H[h+8>>2]=0;H[d+8>>2]=0;j:{b=b-1|0;f=Zl(g+8|0,b);if(!f){f=Zl(g+4|0,b);d=H[g+4>>2];if(!f){break j}}_d(d);_d(H[g+8>>2]);break d}b=H[g+8>>2];H[c+12>>2]=b;H[b+8>>2]=c;H[c+16>>2]=d;H[d+8>>2]=c;f=0}if(!f){break b}}_d(c);c=0;break a}f=0}H[a>>2]=c;Ea=g+16|0;return f}function Jm(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Ea-48|0;Ea=f;j=H[a>>2];H[f+32>>2]=0;H[f+36>>2]=0;H[f+24>>2]=0;H[f+28>>2]=0;if(b){h=H[b>>2];e=(h|0)>=32767?32767:h;h=nb(j,N(h,12),0)}else{h=0}G[c>>1]=e;H[d>>2]=h;n=(e|0)>0?e:0;o=b+8|0;i=h;while(1){a:{b:{c:{d:{e:{f:{if((l|0)!=(n|0)){if(!H[a+36>>2]){break f}n=l}qf(f+24|0);if(!H[a+36>>2]){break d}e=0;while(1){if((e|0)==(n|0)){break e}Za(j,H[N(e,12)+h>>2]);e=e+1|0;continue}}k=(l<<4)+o|0;g=H[k+4>>2];if(I[k+9|0]&3?0:g){break c}e=bd(H[k>>2]);while(1){b=I[e|0];if((b|0)!=141){g:{h:{if((b|0)!=59){if(I[e+7|0]&3|(b|0)!=167){break g}b=H[e+44>>2];if(!b){break g}i:{e=G[e+32>>1];if((e|0)>=0){break i}e=G[b+32>>1];if((e|0)>=0){break i}g=15085;break c}b=H[b+4>>2]+N(e,12)|0;break h}b=e+8|0}g=H[b>>2]}if(!g){break b}break c}else{e=H[e+16>>2];continue}}}Za(j,h);H[d>>2]=0;G[c>>1]=0}Ea=f+48|0;return}if(fs(g)){break b}b=Tb(j,g);break a}H[f+16>>2]=l+1;b=mb(j,16599,f+16|0)}H[f+44>>2]=0;while(1){j:{if(!b){break j}m=Hc(f+24|0,b);if(!m){break j}if(I[m+9|0]&128){G[i+10>>1]=J[i+10>>1]|1024}m=bb(b);e=m;if(e){while(1){k:{if(e>>>0<=1){g=I[b|0];e=0;break k}e=e-1|0;g=I[e+b|0];if(g-58>>>0>4294967285){continue}}break}e=(g&255)==58?e:m}else{e=0}H[f>>2]=e;H[f+4>>2]=b;b=H[f+44>>2]+1|0;H[f+44>>2]=b;H[f+8>>2]=b;b=mb(j,1907,f);Km(a);if(K[f+44>>2]<4){continue}we(4,f+44|0);continue}break}H[i>>2]=b;p=i,q=Cg(b),F[p+7|0]=q;if(F[k+10|0]&1){G[i+10>>1]=J[i+10>>1]|1024}l:{if(!b){break l}if((od(f+24|0,b,k)|0)!=(k|0)){break l}Ib(j)}i=i+12|0;l=l+1|0;continue}}function ko(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0;i=Ea-16|0;Ea=i;a:{b:{c:{d:{e:{if(!I[a+12|0]){l=d+2|0;if((l|0)<=H[a+20>>2]){break e}}f:{if(!e){e=c;break f}Va(e,c,d)}c=f<<24|(f&65280)<<8|(f>>>8&65280|f>>>24);F[e|0]=c;F[e+1|0]=c>>>8;F[e+2|0]=c>>>16;F[e+3|0]=c>>>24;c=I[a+12|0];F[a+12|0]=c+1;H[((c<<2)+a|0)+36>>2]=e;G[((c<<1)+a|0)+28>>1]=b;break d}e=Vb(H[a+72>>2]);if(e){break a}e=I[a+9|0];j=H[a+56>>2];H[i+12>>2]=0;h=e+j|0;g=I[h+5|0]<<8|I[h+6|0];k=J[a+18>>1]+(J[a+24>>1]<<1)|0;g:{if(g>>>0<k>>>0){e=71945;if(g){break b}g=65536;if(H[H[a+52>>2]+40>>2]==65536){break g}break b}e=71948;if(H[H[a+52>>2]+40>>2]<(g|0)){break b}}h:{i:{j:{if(!I[h+2|0]){if(!I[h+1|0]){break i}if(k+2>>>0<=g>>>0){break j}break i}if(k+2>>>0>g>>>0){break i}}e=no(a,d,i+12|0);if(e){e=e-j|0;if((k|0)>=(e|0)){break c}h=e>>>8|0;break h}e=H[i+12>>2];if(e){break a}}if((k+l|0)>(g|0)){e=H[a+20>>2]-l|0;e=mo(a,(e|0)>=4?4:e);if(e){break a}g=((I[h+6|0]|I[h+5|0]<<8)-1&65535)+1|0}e=g-d|0;g=e<<8|(e&65280)>>>8;F[h+5|0]=g;F[h+6|0]=g>>>8;h=e>>>8|0}H[a+20>>2]=H[a+20>>2]-(l&65535);g=e+j|0;Va(g+4|0,c+4|0,d-4|0);d=f<<24|(f&65280)<<8|(f>>>8&65280|f>>>24);F[g|0]=d;F[g+1|0]=d>>>8;F[g+2|0]=d>>>16;F[g+3|0]=d>>>24;d=H[a+64>>2]+(b<<1)|0;Ic(d+2|0,d,J[a+24>>1]-b<<1);F[d+1|0]=e;F[d|0]=h;G[a+24>>1]=J[a+24>>1]+1;d=I[a+9|0]+j|0;b=I[d+4|0]+1|0;F[d+4|0]=b;if((b|0)!=(b&255)){b=I[a+9|0]+j|0;F[b+3|0]=I[b+3|0]+1}if(!I[H[a+52>>2]+17|0]){break d}H[i+8>>2]=0;Yi(a,a,c,i+8|0);e=H[i+8>>2];if(e){break a}}e=0;break a}e=Ya(71965);break a}e=Ya(e)}Ea=i+16|0;return e}function Wu(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;e=H[a+104>>2];g=(e|0)>0?e:0;f=H[a+156>>2];e=H[a+168>>2];c=H[a+224>>2];while(1){if((b|0)!=(g|0)){d=H[a+100>>2]+N(b,48)|0;if(!(H[d+8>>2]|H[d+12>>2])){h=H[a+84>>2];H[d+8>>2]=H[a+80>>2];H[d+12>>2]=h}b=b+1|0;continue}break}b=bm(a);H[a+88>>2]=b;d=Ha;H[a+92>>2]=d;H[a+80>>2]=b;H[a+84>>2]=d;g=e>>>0>f>>>0;a:{b:{if(!(I[a+7|0]|I[a+5|0]==4)){b=H[a+64>>2];d=H[b>>2];if(!d){break b}if(!(Ia[H[d+48>>2]](b)&512)){break b}}F[c+8|0]=255;F[c+9|0]=255;F[c+10|0]=255;F[c+11|0]=255;F[c|0]=217;F[c+1|0]=213;F[c+2|0]=5;F[c+3|0]=249;F[c+4|0]=32;F[c+5|0]=161;F[c+6|0]=99;F[c+7|0]=215;break a}F[c|0]=0;F[c+1|0]=0;F[c+2|0]=0;F[c+3|0]=0;F[c+4|0]=0;F[c+5|0]=0;F[c+6|0]=0;F[c+7|0]=0;F[c+8|0]=0;F[c+9|0]=0;F[c+10|0]=0;F[c+11|0]=0}if(I[a+5|0]!=4){we(4,a+52|0)}b=H[a+52>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[c+12|0]=b;F[c+13|0]=b>>>8;F[c+14|0]=b>>>16;F[c+15|0]=b>>>24;b=H[a+32>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[c+16|0]=b;F[c+17|0]=b>>>8;F[c+18|0]=b>>>16;F[c+19|0]=b>>>24;b=H[a+156>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[c+20|0]=b;F[c+21|0]=b>>>8;F[c+22|0]=b>>>16;F[c+23|0]=b>>>24;b=H[a+168>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[c+24|0]=b;F[c+25|0]=b>>>8;F[c+26|0]=b>>>16;F[c+27|0]=b>>>24;d=0;e=g?f:e;Xa(c+28|0,0,e-28|0);b=0;while(1){if(!(K[a+156>>2]<=b>>>0|d)){f=H[a+68>>2];d=Ia[H[H[f>>2]+12>>2]](f,c,e,H[a+80>>2],H[a+84>>2])|0;f=H[a+84>>2];g=H[a+80>>2]+e|0;f=e>>>0>g>>>0?f+1|0:f;H[a+80>>2]=g;H[a+84>>2]=f;b=b+e|0;continue}break}return d}function fA(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ea-240|0;Ea=e;f=H[a+128>>2];a:{if(I[(f?f:a)+219|0]!=2){break a}f=H[c+80>>2];g=H[f+40>>2];if(g&8192|d&32){break a}i=(I[c+60|0]<<6)+b|0;b=i+8|0;h=H[a>>2];c=1;j=g&48;c=j|!(J[f+24>>1]?g&1024:1)?c:(d&3)!=0;k=H[a+8>>2];G[e+236>>1]=256;H[e+232>>2]=0;H[e+224>>2]=100;H[e+228>>2]=1e9;H[e+216>>2]=h;H[e+100>>2]=b;H[e+96>>2]=c?20195:19968;H[e+220>>2]=e+112;lb(e+216|0,19203,e+96|0);b:{if(!(g&1280)){d=H[f+32>>2];c:{d:{if(I[H[i+24>>2]+28|0]&128){if(((I[d+55|0]|I[d+56|0]<<8)&3)==2){break d}}b=18590;if(g&131072){break c}b=18623;if(g&16384){break c}b=g&64?7299:7308;break c}if(!c){break b}b=18516}h=e+216|0;c=h;sb(c,30353,7);H[e+16>>2]=H[d>>2];lb(c,b,e+16|0);c=J[f+46>>1];g=H[f+32>>2];b=J[f+24>>1];if(!(b|I[f+40|0]&48)){break b}sb(h,27596,2);d=0;while(1){if((b|0)!=(d|0)){h=_q(g,d);if(d){sb(e+216|0,30398,5)}H[e>>2]=h;lb(e+216|0,c>>>0>d>>>0?25122:20954,e);d=d+1|0;continue}break}c=b;d=H[f+40>>2];if(d&32){Rz(e+216|0,g,J[f+26>>1],c,c,21739);d=H[f+40>>2];c=1}if(d&16){Rz(e+216|0,g,J[f+28>>1],b,c,21776)}sb(e+216|0,27576,1);break b}if(!(!(g&256)|!(g&15))){H[e+80>>2]=15085;c=e+216|0;lb(c,6457,e+80|0);b=61;e:{if(g&5){break e}if((j|0)==48){H[e+64>>2]=15085;lb(c,7406,e- -64|0);b=60;break e}b=g&32?62:60}H[e+48>>2]=b;lb(e+216|0,26093,e+48|0);break b}if(!(g&1024)){break b}b=H[f+24>>2];H[e+36>>2]=H[f+32>>2];H[e+32>>2]=b;lb(e+216|0,6165,e+32|0)}if(I[i+44|0]&8){lb(e+216|0,19924,0)}b=Jd(e+216|0);fb(k,188,H[k+108>>2],H[a+232>>2],0,b,-6)}Ea=e+240|0}function dF(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0;c=Ea-32|0;Ea=c;Jj(a);a:{b:{if(!b){break b}f=Xa(a+168|0,0,56);H[a+192>>2]=1;H[a+184>>2]=H[a+36>>2];g=Vj(H[e>>2]);d=H[e>>2];c:{d:{if(g){h=a,i=xb(d),H[h+172>>2]=i;h=a,i=fd(H[e>>2]),H[h+168>>2]=i;break d}h=a,i=$a(d),H[h+180>>2]=i;h=a,i=xb(H[e>>2]),H[h+188>>2]=i;if(!H[a+180>>2]){H[a+8>>2]=0;H[a+12>>2]=0;break b}if(!nm(f,0)){break d}if(I[a+203|0]){break c}Ta(H[H[a>>2]+8>>2]);b=Ab(19873,0);H[H[a>>2]+8>>2]=b;Jj(a);e=H[H[a>>2]+8>>2]?1:7;break a}e:{if((b|0)==3){d=$a(H[e+4>>2]);if(!d){break b}if(I[d|0]!=36){Ta(H[H[a>>2]+8>>2]);H[c+16>>2]=d;b=Ab(19818,c+16|0);H[H[a>>2]+8>>2]=b;Jj(a);e=H[H[a>>2]+8>>2]?1:7;break a}h=a,i=bb(d),H[h+16>>2]=i;f:{g:{if(!I[d+1|0]){b=0;F[a+20|0]=0;break g}b=Ie(f,0,d+1|0,0);if(b>>>0>=4294967293){if((b|0)==-2){e=0;F[a+20|0]=0;H[a+8>>2]=0;H[a+12>>2]=0;break a}Ta(H[H[a>>2]+8>>2]);H[c>>2]=d;b=Ab(19818,c);H[H[a>>2]+8>>2]=b;Jj(a);e=H[H[a>>2]+8>>2]?1:7;break a}e=H[a+216>>2];if(e){F[a+20|0]=12;H[a+8>>2]=e;break f}F[a+20|0]=11}H[a+8>>2]=b}uf(a+40|0,d,H[a+16>>2]);break e}b=0;F[a+20|0]=0;H[a+8>>2]=0;H[a+16>>2]=1;uf(a+40|0,29062,1)}e=0;H[a+24>>2]=0;d=$b(f,b,c+28|0)+b|0;H[a+12>>2]=d+H[c+28>>2];f=H[a+168>>2]+b|0;if(I[a+21|0]|(I[f|0]&15)>>>0<11){break a}H[a+8>>2]=d;F[a+20|0]=I[f|0]&15;d=nb(H[a+36>>2],24,0);H[a+32>>2]=d;if(!d){break c}H[a+24>>2]=1;H[a+28>>2]=1;H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=H[a+12>>2];a=H[a+8>>2];H[d+4>>2]=b;H[d>>2]=a;break a}e=7;break a}e=0}Ea=c+32|0;return e|0}function mo(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;l=J[a+18>>1];k=J[a+24>>1];n=l+(k<<1)|0;f=H[a+52>>2];d=H[f+40>>2];a:{b:{g=H[a+56>>2];h=g+I[a+9|0]|0;if(I[h+7|0]>(b|0)){j=d-4|0;break b}j=d-4|0;i=I[h+2|0]|I[h+1|0]<<8;if((j|0)<(i|0)){return Ya(71745)}if(!i){break b}b=g+i|0;e=I[b|0]<<8|I[b+1|0];if(e>>>0>j>>>0){return Ya(71748)}if(e){c=e+g|0;if(I[c|0]|I[c+1|0]){break b}}c=I[h+6|0]|I[h+5|0]<<8;if(c>>>0>=i>>>0){return Ya(71756)}f=I[b+3|0]|I[b+2|0]<<8;b=i+f|0;c:{d:{if(e){if(b>>>0>e>>>0){return Ya(71759)}m=d;d=e+g|0;j=I[d+2|0]<<8|I[d+3|0];if((m|0)>=(e+j|0)){break d}return Ya(71761)}j=0;if((b|0)<=(d|0)){break c}return Ya(71765)}d=b+g|0;Ic(d+j|0,d,e-b|0);f=f+j|0}o=g+n|0;d=c+f|0;Ic(g+d|0,c+g|0,i-c|0);c=g+l|0;while(1){if(c>>>0<o>>>0){b=f;k=I[c+1|0]|I[c|0]<<8;e:{if(k>>>0>=i>>>0){b=j;if(e>>>0<=k>>>0){break e}}b=b+k|0;b=b<<8|(b&65280)>>>8;F[c|0]=b;F[c+1|0]=b>>>8}c=c+2|0;continue}break}b=I[h+7|0];break a}f:{if(!k){break f}o=I[h+6|0]|I[h+5|0]<<8;m=Va(H[H[f>>2]+224>>2],g,d);l=g+l|0;c=0;b=d;while(1){if((c|0)==(k|0)){d=b;break f}f=(c<<1)+l|0;e=I[f|0]<<8|I[f+1|0];if((e|0)>(j|0)){return Ya(71798)}p=e+m|0;i=Ia[H[a+76>>2]](a,p)|0;b=b-i|0;if((o|0)<=(b|0)&(e+i|0)<=(d|0)){e=b<<8|(b&65280)>>>8;F[f|0]=e;F[f+1|0]=e>>>8;Va(b+g|0,p,i);c=c+1|0;continue}else{return Ya(71804)}}}F[h+7|0]=0;b=0}m=H[a+20>>2];a=d-n|0;if((m|0)!=(a+b|0)){return Ya(71818)}F[h+1|0]=0;F[h+2|0]=0;b=d<<8|(d&65280)>>>8;F[h+5|0]=b;F[h+6|0]=b>>>8;Xa(g+n|0,0,a);return 0}function uh(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;j=Ea-16|0;Ea=j;a:{b:{if(I[a|0]){break b}h=I[a+1|0];if(!(h&2)){break b}g=H[a+32>>2];f=H[a+36>>2];if((g|0)==(b|0)&(f|0)==(c|0)){f=0;H[e>>2]=0;break a}if((c|0)<=(f|0)&b>>>0<=g>>>0|(c|0)<(f|0)){break b}if(h&8){H[e>>2]=-1;f=0;break a}g=g+1|0;f=g?f:f+1|0;if((b|0)!=(g|0)|(c|0)!=(f|0)){break b}H[e>>2]=0;f=qj(a);if((f|0)==101){break b}if(f){break a}Ig(a);f=0;if((b|0)==H[a+32>>2]&(c|0)==H[a+36>>2]){break a}}f=Qf(a);if((f|0)!=16){if(f){break a}p=1-d|0;while(1){i=H[a+116>>2];m=J[i+24>>1];k=m-1|0;g=k>>p;n=H[i+64>>2];o=J[i+26>>1];q=H[i+68>>2];h=0;r=I[i+2|0];c:{d:{e:{f:{while(1){d=(g<<1)+n|0;f=((I[d|0]<<8|I[d+1|0])&o)+q|0;g:{if(!r){break g}while(1){d=f+1|0;if(F[f|0]>=0){f=d;break g}f=d;if(f>>>0<K[i+60>>2]){continue}break}f=Ya(75883);break a}Kh(f,j+8|0);h:{d=H[j+8>>2];l=H[j+12>>2];f=l;i:{if(d>>>0<b>>>0&(f|0)<=(c|0)|(c|0)>(f|0)){h=g+1|0;if((g|0)<(k|0)){break i}d=-1;break e}if((c|0)>=(l|0)&b>>>0>=d>>>0|(c|0)>(l|0)){break h}if((g|0)<=(h|0)){break f}k=g-1|0}g=h+k>>1;continue}break}G[a+70>>1]=g;if(!I[i+8|0]){h=g;break d}f=0;G[a+50>>1]=0;H[a+32>>2]=d;H[a+36>>2]=l;F[a+1|0]=I[a+1|0]|2;H[e>>2]=0;break a}d=1}if(!I[i+8|0]){break d}G[a+70>>1]=g;H[e>>2]=d;f=0;break c}d=H[i+56>>2];j:{if((h|0)>=(m|0)){d=cb((d+I[i+9|0]|0)+8|0);break j}f=(h<<1)+n|0;d=cb(d+((I[f|0]<<8|I[f+1|0])&o)|0)}G[a+70>>1]=h;f=Dg(a,d);if(!f){continue}}break}G[a+50>>1]=0;break a}H[e>>2]=-1;f=0}Ea=j+16|0;return f}function Ky(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;c=H[a+20>>2];a:{if(I[c+17|0]==2){b=H[c+44>>2];if(b){break a}b:{if(H[c+232>>2]|I[c+5|0]==2){break b}d=H[c>>2];b=ej(H[c+28>>2]);H[c+60>>2]=b;if(!b){return 7}b=H[c+68>>2];c:{d:{if(H[b>>2]){break d}if(I[c+5|0]==4){Xa(b+8|0,0,56);H[b>>2]=33048;H[b+4>>2]=1020;H[b+8>>2]=-1;break d}g=H[16487];e=I[c+12|0];b=hv(c);if(!b){b=cv(d,H[c+188>>2],H[c+68>>2],e?4126:2054,e?g:0)}if(b){break c}}H[c+80>>2]=0;H[c+84>>2]=0;F[c+20|0]=0;H[c+48>>2]=0;H[c+88>>2]=0;H[c+92>>2]=0;b=Wu(c);if(!b){break b}}Xf(H[c+60>>2]);H[c+80>>2]=0;H[c+84>>2]=0;H[c+60>>2]=0;return b}F[c+17|0]=3}dl(a);b=H[c+60>>2];e:{if(!b){break e}d=b;b=H[a+24>>2];if(kl(d,b)){break e}if(b>>>0<=K[c+32>>2]){e=H[a+20>>2];b=H[e+84>>2];f=H[e+80>>2];g=H[a+4>>2];h=Hu(e,g);G[a+28>>1]=J[a+28>>1]|8;d=ei(H[e+68>>2],f,b,H[a+24>>2]);f:{if(d){break f}d=H[e+68>>2];f=f+4|0;b=f>>>0<4?b+1|0:b;d=Ia[H[H[d>>2]+12>>2]](d,g,H[e+168>>2],f,b)|0;if(d){break f}b=H[e+172>>2]+b|0;d=f;f=H[e+168>>2];d=d+f|0;d=ei(H[e+68>>2],d,d>>>0<f>>>0?b+1|0:b,h);if(d){break f}H[e+48>>2]=H[e+48>>2]+1;g=H[e+80>>2];d=g+H[e+168>>2]|0;b=H[e+172>>2]+H[e+84>>2]|0;b=d>>>0<g>>>0?b+1|0:b;d=d+8|0;b=d>>>0<8?b+1|0:b;H[e+80>>2]=d;H[e+84>>2]=b;d=Og(H[e+60>>2],H[a+24>>2])|Xo(e,H[a+24>>2])}b=d;if(!b){break e}break a}if(I[c+17|0]==4){break e}G[a+28>>1]=J[a+28>>1]|8}G[a+28>>1]=J[a+28>>1]|4;if(H[c+104>>2]<=0){b=0}else{b=fm(a)}a=H[a+24>>2];if(a>>>0<=K[c+28>>2]){break a}H[c+28>>2]=a}return b}function Dx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;g=Ea-160|0;Ea=g;l=H[b+20>>2];Xa(g+24|0,0,128);f=H[b+8>>2];h=H[b+12>>2];j=H[a+24>>2];H[g+16>>2]=c;H[g+20>>2]=((h|0)!=0)<<5|(f?11:3)|((c|0)<(j|0))<<2;H[g+8>>2]=H[b>>2];H[g+12>>2]=H[b+4>>2];m=g+88|0;f=Qj(a,l,g+8|0);a:while(1){b:{c:{d:{e:{if(f){break e}f=gi(a,l);if((f|0)==100){break b}if(f){break e}c=f;while(1){if((c|0)==16){break d}f:{i=c<<2;j=i+(g+24|0)|0;h=H[j>>2];g:{if(!h){break g}if(!k){f=H[i+m>>2];H[j>>2]=0;k=h;break g}f=Ax(I[a+239|0],h,H[i+m>>2],k,f,g+152|0,g+156|0);if(f){break f}Ta(H[j>>2]);Ta(k);H[j>>2]=0;f=H[g+156>>2];k=H[g+152>>2]}c=c+1|0;continue}break}Ta(k)}c=0;while(1){if((c|0)==16){break c}Ta(H[(g+24|0)+(c<<2)>>2]);c=c+1|0;continue}}H[e>>2]=k;H[d>>2]=f;f=0}Xp(l);H[b+20>>2]=0;Ea=g+160|0;return f}i=H[l+60>>2];j=H[l+56>>2];c=0;h:{if(H[g+24>>2]){h=j;while(1){if((c|0)==16){break h}f=c<<2;n=f+(g+24|0)|0;o=H[n>>2];if(!o){H[n>>2]=h;H[f+m>>2]=i;break h}p=f+m|0;f=Ax(I[a+239|0],h,i,o,H[p>>2],g+156|0,g+152|0);if(f){if((h|0)==(j|0)){continue a}Ta(h);continue a}if((h|0)!=(j|0)){Ta(h)}Ta(o);H[n>>2]=0;i=H[g+152>>2];h=H[g+156>>2];if((c|0)==15){H[n>>2]=h;H[p>>2]=i}c=c+1|0;continue}}c=i>>31;f=i+11|0;c=f>>>0<11?c+1|0:c;c=ub(f,c);H[g+88>>2]=i;H[g+24>>2]=c;f=7;if(!c){continue}c=Va(c,j,i)+i|0;F[c|0]=0;F[c+1|0]=0;F[c+2|0]=0;F[c+3|0]=0;F[c+4|0]=0;F[c+5|0]=0;F[c+6|0]=0;F[c+7|0]=0;f=0;F[c+8|0]=0;F[c+9|0]=0;continue}f=0;continue}}function wz(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;j=wb(a);m=H[a+56>>2]-1|0;H[a+56>>2]=m;k=H[a+40>>2];if((h|0)<0){Sa(j,49,I[e+24|0],m)}n=k-1|0;o=g+1|0;k=0;while(1){l=H[e+20>>2];if((k|0)<(l|0)){Sa(j,50,Gc(H[e>>2],G[(k<<2)+f>>1])+o|0,m);k=k+1|0;continue}break}a:{if(i){break a}if(!d){d=zb(a);Sa(j,81,Gc(H[e>>2],G[f>>1])+o|0,d);f=Sa(j,13,d,0);b:{if((h|0)!=1|H[e>>2]!=(c|0)){break b}Ua(j,53,g,m,d);g=H[j+108>>2];if((g|0)<=0){break b}G[(H[j+104>>2]+N(g,20)|0)-18>>1]=144}Hd(a,n,b,c,112);Ua(j,31,n,0,d);Qb(j,m);b=H[j+108>>2];c:{if(I[H[j>>2]+87|0]){H[18336]=b;c=73336;break c}c=H[j+104>>2];H[(c+N(b,20)|0)-32>>2]=b;c=c+N(f,20)|0}H[c+8>>2]=b;rb(a,d);break a}i=nc(a,l);Ua(j,112,n,H[d+44>>2],b);Ed(a,d);k=0;b=(l|0)>0?l:0;while(1){q=H[e>>2];if((b|0)!=(k|0)){Sa(j,80,Gc(q,G[(k<<2)+f>>1])+o|0,i+k|0);k=k+1|0;continue}break}if(!((h|0)!=1|(c|0)!=(q|0))){q=(H[j+108>>2]+l|0)+1|0;k=0;while(1){if((b|0)!=(k|0)){r=Gc(H[e>>2],G[(k<<2)+f>>1])+o|0;p=J[H[d+4>>2]+(k<<1)>>1];Ua(j,52,r,q,(s=g,t=Gc(H[d+12>>2],p<<16>>16)+o|0,u=(p|0)==J[c+32>>1],u?s:t));p=H[j+108>>2];if((p|0)>0){G[(H[j+104>>2]+N(p,20)|0)-18>>1]=16}k=k+1|0;continue}break}Qb(j,m)}fb(j,96,i,l,0,jh(H[a>>2],d),l);gb(j,29,n,m,i,l);Sc(a,i,l)}b=I[e+24|0];d:{e:{if(b){break e}if(!(I[a+20|0]|(H[a+128>>2]|I[H[a>>2]+34|0]&8))){nh(a,787,2,0,-1,4);break d}if((h|0)<=0){break e}c=H[a+128>>2];F[(c?c:a)+21|0]=1}Sa(j,158,b,h)}hb(j,m);_a(j,122,n)}function dc(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=H[a+8>>2];g=H[a+4>>2];k=I[g+16|0];h=H[a>>2];i=H[h+56>>2]-1|0;H[h+56>>2]=i;f=(b|0)==2;if(!(f&I[g+17|0]==90)){a:{b:{if((c|0)<=0){break b}if((k|0)==89){l=H[e+108>>2];if(f){if(I[g+17|0]==86){wi(a,55,H[a+40>>2],c,H[a+32>>2],i);break a}wi(a,57,H[a+32>>2],c,H[a+40>>2],i);break a}wi(a,54,H[a+48>>2],c,H[a+40>>2],i);break b}Ua(e,59,c,i,1)}if(H[g+88>>2]|(b|0)!=1){break a}jn(a,0)}m=H[e+108>>2];if(!(!c|I[g+17|0]!=I[g+18|0]|I[g+16|0]!=89)){j=zb(h);c=zb(h);c:{d:{if((b|0)==2){Sa(e,135,H[a+32>>2],j);Sa(e,135,H[a+48>>2],c);f=c;break d}if(!H[a+28>>2]){break c}Sa(e,135,H[a+48>>2],j);f=H[a+28>>2]}Ua(e,57,f,i,j)}rb(h,j);rb(h,c)}e:{f:{switch(b-1|0){case 0:j=H[a+44>>2];c=H[a+40>>2];Qr(a);break e;case 1:j=H[a+36>>2];c=H[a+32>>2];f=H[g+88>>2];if(f){Sa(e,86,f,1);break e}Vq(a,g,c,1,H[a+20>>2]);break e;default:break f}}j=H[a+52>>2];c=H[a+48>>2];if(H[g+88>>2]){Sa(e,86,H[g+92>>2],1);break e}Vq(a,g,c,0,H[a+20>>2])}g:{if(H[a+24>>2]!=(b|0)){b=H[e+108>>2];break g}_a(e,130,c);b=H[e+108>>2];if((b|0)<=0){break g}G[(H[e+104>>2]+N(b,20)|0)-18>>1]=2}h:{i:{if(!d){d=b;b=(k|0)==76;Sa(e,39,c,d+(b?1:2)|0);if(b){break h}Sa(e,9,0,i);break i}Sa(e,39,c,b+2|0);n=Mb(e,9);if((k|0)==76){break h}}d=0;b=a;f=H[g+12>>2];a=0;j:{if(!f){break j}f=H[f>>2];a=0;if(!f){break j}d=f;a=nc(h,f)}bk(b,c,a);Pr(h,H[g+12>>2],a,j,m);Sc(h,a,d)}if(l){Sa(e,9,0,l)}hb(e,i)}return n}function Xz(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;n=H[b>>2];p=H[n>>2];j=F[b+32|0]&1;k=p+!j|0;o=k+f|0;m=H[b+4>>2];if(g){i=d-g|0}else{i=H[a+44>>2];H[a+44>>2]=i+o;i=i+1|0}l=H[c+12>>2];a:{if(l){l=l+1|0;break a}l=H[c+8>>2]}h=H[a+8>>2];q=H[a+56>>2]-1|0;H[a+56>>2]=q;H[b+24>>2]=q;Gf(a,n,i,e,e?5:1);if(!j){Sa(h,126,H[b+8>>2],i+p|0)}if(!((f|0)<=0|g)){xi(a,d,i+k|0,f)}g=0;f=0;b:{if((m|0)>0){f=Cz(a,b,c,i,o);k=H[b+4>>2];d=H[a+44>>2];H[a+44>>2]=k+d;n=d+1|0;c:{if(!j){d=_a(h,17,i+p|0);break c}d=_a(h,120,H[b+8>>2])}Ua(h,90,n,i,H[b+4>>2]);e=73336;e=I[H[h>>2]+87|0]?e:H[h+104>>2]+N(H[b+20>>2],20)|0;if(I[H[a>>2]+87|0]){break b}H[e+8>>2]=o-k;j=H[e+16>>2];Xa(H[j+16>>2],0,J[j+6>>1]);Wd(h,-1,j,-8);r=e,s=Oe(a,H[b>>2],m,J[j+8>>1]+(J[j+6>>1]^-1)|0),H[r+16>>2]=s;k=H[h+108>>2];e=k+1|0;Ua(h,14,e,0,e);e=H[a+56>>2]-1|0;H[a+56>>2]=e;H[b+16>>2]=e;j=H[a+44>>2]+1|0;H[a+44>>2]=j;H[b+12>>2]=j;Sa(h,10,j,e);_a(h,146,H[b+8>>2]);if(l){Sa(h,17,l,H[b+24>>2])}e=H[h+108>>2];H[(I[H[h>>2]+87|0]?73336:H[h+104>>2]+N(d,20)|0)+8>>2]=e;xi(a,i,n,H[b+4>>2]);e=H[h+108>>2];H[(I[H[h>>2]+87|0]?73336:H[h+104>>2]+N(k,20)|0)+8>>2]=e}if(l){d=H[b+8>>2];Sa(h,60,l,H[h+108>>2]+4|0);Sa(h,32,d,0);g=gb(h,40,d,0,i+m|0,p-m|0);_a(h,130,d)}if(!f){f=Cz(a,b,c,i,o)}gb(h,F[b+32|0]&1?139:138,H[b+8>>2],f,i+m|0,o-m|0);if(!g){break b}b=H[b+28>>2];if(!b){b=H[h+108>>2]}H[(I[H[h>>2]+87|0]?73336:H[h+104>>2]+N(g,20)|0)+8>>2]=b}}function wc(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;g=Ea-16|0;Ea=g;f=H[a+8>>2];H[g+12>>2]=0;H[g+8>>2]=0;if(!(!b|!f)){e=I[b|0];h=e^1;a:{b:{c:{d:{e:{f:{g:{h:{i:{switch(e-43|0){default:j:{switch(e-171|0){case 1:case 2:case 3:break b;case 0:break g;case 4:break h;default:break j}}if((e|0)!=19){break b}Le(a,H[b+12>>2],c,d);e=0;break a;case 0:case 1:break i;case 3:case 4:break b;case 6:break c;case 5:break d;case 7:case 8:break e;case 9:case 10:case 11:case 12:case 13:case 14:break f;case 2:break g}}h=Om(b);if((h|0)!=(b|0)){wc(a,h,c,d);e=0;break a}if((e|0)==44){wc(a,H[b+12>>2],c,d);wc(a,H[b+16>>2],c,d);e=0;break a}e=H[a+56>>2]-1|0;H[a+56>>2]=e;Le(a,H[b+12>>2],e,d^16);wc(a,H[b+16>>2],c,d);hb(f,e);e=0;break a}f=I[b+2|0];d=((f|0)!=171)<<4;e=H[b+12>>2];if((hk(H[b+16>>2])|0)!=((f|0)==171|0)){wc(a,e,c,d);e=0;break a}Le(a,e,c,d);e=0;break a}h=(e|0)==45?52:53;d=128}e=H[b+12>>2];if(Ke(e)){break b}e=Jc(a,e,g+12|0);f=Jc(a,H[b+16>>2],g+8|0);Qm(a,H[b+12>>2],H[b+16>>2],h,e,f,c,d,H[b+4>>2]>>>10&1);e=H[g+8>>2];break a}b=Jc(a,H[b+12>>2],g+12|0);zr(f,b);Sa(f,h,b,c);e=0;break a}ur(a,b,c,74,d);e=0;break a}if(d){Um(a,b,c,c);e=0;break a}d=H[a+56>>2]-1|0;H[a+56>>2]=d;Um(a,b,c,d);hb(f,d);e=0;break a}h=H[b+4>>2];if((h&536870913)==536870912){Qb(f,c);e=0;break a}e=0;if((h&268435457)==268435456){break a}Ua(f,17,Jc(a,b,g+12|0),c,(d|0)!=0);e=0}rb(a,H[g+12>>2]);rb(a,e)}Ea=g+16|0}function dq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;c=Ea-32|0;Ea=c;h=H[b>>2];H[c>>2]=h;if(!h){j=a+28|0;a:{if(!H[a+28>>2]){break a}d=Yl(0,a);H[c>>2]=d;if(d){break a}b:{if(!H[j>>2]){break b}l=H[a>>2];q=H[l+36>>2];r=H[q>>2];s=Xc(H[a+12>>2],0);t=Ha;while(1){h=H[l+24>>2];i=h>>31;d=f;c:{while(1){if(h>>>0<=g>>>0&(e|0)>=(i|0)|(e|0)>(i|0)|d){break c}if(I[H[l+32>>2]+g|0]){g=g+1|0;e=g?e:e+1|0;d=0;continue}break}d=H[a+12>>2];i=g+1|0;h=i?e:e+1|0;d=$e(d,i);H[c+24>>2]=0;f=jg(q,H[a+20>>2],d,-1,c+24|0);n=H[c+24>>2];d:while(1){if(!f){H[c+16>>2]=0;H[c+12>>2]=0;H[c+8>>2]=0;H[c+4>>2]=0;f=Ia[H[r+20>>2]](n,c+20|0,c+16|0,c+12|0,c+8|0,c+4|0)|0;H[c+28>>2]=f;d=j;while(1){k=H[d>>2];if(!k|f){continue d}m=H[k>>2];f=0;d=H[k+4>>2];e:{if(((g|0)!=(d|0)|(e|0)!=0)&(d|0)<H[l+24>>2]){break e}o=H[c+4>>2];if(o?H[m+12>>2]:0){break e}p=H[m+4>>2];d=H[c+16>>2];if((p|0)!=(d|0)&(!H[m+8>>2]|(d|0)<=(p|0))){break e}if(Hb(H[c+20>>2],H[m>>2],p)){break e}ux(k+12|0,s,t,g,e,o,o>>31,c+28|0);f=H[c+28>>2]}d=k+8|0;continue}}break}if(n){Ia[H[r+16>>2]](n)|0}if((f|0)==101){H[c+28>>2]=0;f=0}g=i;e=h;continue}break}d=j;while(1){e=H[d>>2];if(!e|f){break b}if(H[e+12>>2]){f=Mj(e+12|0,0,0)}else{f=0}d=e+8|0;continue}}H[c>>2]=f}e=Yg(a,H[a+16>>2],c);while(1){a=H[j>>2];if(a){Ta(H[a+12>>2]);H[a+12>>2]=0;j=a+8|0;continue}break}a=H[c>>2];H[b>>2]=a;d=!(a|e)}Ea=c+32|0;return d}function sm(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Ea-48|0;Ea=d;g=H[a>>2];c=H[a+256>>2];H[d+40>>2]=0;H[d+44>>2]=0;H[d+32>>2]=0;H[d+36>>2]=0;H[d+24>>2]=0;H[d+28>>2]=0;H[d+16>>2]=0;H[d+20>>2]=0;H[d+12>>2]=a;b=yc(g,H[c+4>>2],H[H[g+16>>2]+(Fb(g,H[c+24>>2])<<4)>>2]);H[a+132>>2]=b;F[a+158|0]=I[c+8|0];a:{if(b){b=cf(a,b);if(b){break a}}b=H[c+12>>2];if(!b){b=0;break a}b=cd(d+12|0,b)}f=c+28|0;while(1){b:{if(b){break b}e=H[f>>2];if(!e){break b}c=H[e+8>>2];c:{d:{if(!c){break d}ee(a,c,d+12|0);if(!H[a+36>>2]){break d}b=H[a+12>>2];if(b){break c}}if(!H[e+12>>2]){b=0;break c}h=xm(a,e);if(!h){b=7;break c}c=xd(a,H[e+24>>2],h,0,0,0,0,0,0);e:{if(!c){h=0;H[e+24>>2]=0;c=7;break e}iz(H[e+24>>2],1);ee(a,c,0);iz(H[e+24>>2],0);b=H[a+36>>2];if(H[e+24>>2]){H[c+28>>2]=0}H[c+32>>2]=0;fc(g,c);c=(b|0)!=0}f:{f=H[e+16>>2];if(!f){break f}b=0;if(c){break f}while(1){if(H[f>>2]<=(b|0)){break f}i=H[((b<<6)+f|0)+28>>2];if(i){ee(a,i,0);f=H[e+16>>2]}b=b+1|0;continue}}b=I[g+87|0];H[d+16>>2]=h;b=b?7:c;g:{if(b){break g}c=H[e+20>>2];if(c){b=1;if(cd(d+12|0,c)){break g}}b=Ne(d+12|0,H[e+24>>2])}h:{if(b){break h}c=H[e+32>>2];if(!c){break h}H[c+32>>2]=h;H[d+36>>2]=512;H[d+20>>2]=c;f=d+12|0;b=Ne(f,H[c>>2]);i:{if(b){break i}b=Ne(f,H[c+8>>2]);if(b){break i}b=1;if(cd(f,H[c+12>>2])){break i}b=cd(f,H[c+4>>2])}H[d+36>>2]=0}H[d+16>>2]=0;Cc(g,h)}f=e+40|0;continue}break}Ea=d+48|0;return b}function Le(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;g=Ea-16|0;Ea=g;f=H[a+8>>2];H[g+12>>2]=0;H[g+8>>2]=0;if(!(!b|!f)){a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{e=I[b|0];switch(e-43|0){case 0:case 1:break i;case 3:case 4:break b;case 6:break c;case 5:break d;case 7:case 8:break e;case 9:case 10:case 11:case 12:case 13:case 14:break f;case 2:break g;default:break j}}k:{switch(e-171|0){case 1:case 2:case 3:break b;case 0:break g;case 4:break h;default:break k}}if((e|0)!=19){break b}wc(a,H[b+12>>2],c,d);e=0;break a}h=Om(b);if((h|0)!=(b|0)){Le(a,h,c,d);e=0;break a}if((e|0)==44){e=H[a+56>>2]-1|0;H[a+56>>2]=e;wc(a,H[b+12>>2],e,d^16);Le(a,H[b+16>>2],c,d);hb(f,e);e=0;break a}Le(a,H[b+12>>2],c,d);Le(a,H[b+16>>2],c,d);e=0;break a}f=I[b+2|0]==171;d=f<<4;e=H[b+12>>2];if((hk(H[b+16>>2])|0)!=(f|0)){Le(a,e,c,d);e=0;break a}wc(a,e,c,d);e=0;break a}e=(e|0)==45?53:52;d=128}h=H[b+12>>2];if(Ke(h)){break b}f=Jc(a,h,g+12|0);h=Jc(a,H[b+16>>2],g+8|0);Qm(a,H[b+12>>2],H[b+16>>2],e,f,h,c,d,H[b+4>>2]>>>10&1);e=H[g+8>>2];break a}b=Jc(a,H[b+12>>2],g+12|0);zr(f,b);Sa(f,e,b,c);e=0;break a}ur(a,b,c,80,d);e=0;break a}e=H[a+56>>2]-1|0;H[a+56>>2]=e;Um(a,b,e,d?c:e);Qb(f,c);hb(f,e);e=0;break a}h=H[b+4>>2];if((h&268435457)==268435456){Qb(f,c);e=0;break a}e=0;if((h&536870913)==536870912){break a}Ua(f,16,Jc(a,b,g+12|0),c,(d|0)!=0);e=0}rb(a,H[g+12>>2]);rb(a,e)}Ea=g+16|0}function VE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;if((b|0)==2){a:{if((Kb(H[c>>2])|0)!=5){if((Kb(H[c+4>>2])|0)!=5){break a}}Rb(a);return}k=a;e=Db(H[c>>2]);C(+e);a=x(1)|0;a=a&2147483647;b=!(x(0)|0)&(a|0)==2146435072|a>>>0<2146435072;g=Db(H[c+4>>2]);C(+g);a=x(1)|0;a=a&2147483647;b:{if(!(b&(!(x(0)|0)&(a|0)==2146435072|a>>>0<2146435072))){d=e+g;break b}C(+g);b=x(1)|0;a=x(0)|0;c=a;if(!(a|b-1072693248)){d=Cp(e);break b}C(+e);a=x(1)|0;f=x(0)|0;j=b>>>30&2;h=j|a>>>31;a=a&2147483647;c:{if(!(a|f)){d:{switch(h-2|0){case 0:d=3.141592653589793;break b;case 1:break d;default:break c}}d=-3.141592653589793;break b}C(1.5707963267948966);f=x(1)|0;i=x(0)|0;C(+e);l=x(1)|0;x(0)|0;z(0,i|0);z(1,f&2147483647|l&-2147483648);b=b&2147483647;d=+B();if(!(b|c)){break b}e:{if((b|0)==2146435072){if((a|0)!=2146435072){break e}d=M[(h<<3)+62496>>3];break b}C(1.5707963267948966);c=x(1)|0;i=x(0)|0;C(+e);f=x(1)|0;x(0)|0;z(0,i|0);z(1,c&2147483647|f&-2147483648);d=+B();if(!((a|0)!=2146435072&a>>>0<=b+67108864>>>0)){break b}f:{if(j){d=0;if(b>>>0>a+67108864>>>0){break f}}d=Cp(P(e/g))}e=d;g:{switch(h-1|0){case 0:d=-e;break b;case 1:d=3.141592653589793-(e+-12246467991473532e-32);break b;case 2:break g;default:break c}}d=e+-12246467991473532e-32+-3.141592653589793;break b}e=M[(h<<3)+62528>>3]}d=e}Sb(k,d);return}Y(23600,17858,570,17787);D()}function gD(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=Ea-32|0;Ea=c;f=I[a+16|0];a:{if((f|0)>=(b|0)){break a}b:{c:{d:{e:{f:{g:{h:{i:{j:{k:{e=H[a+8>>2];g=I[e+28|0];l:{if((f|0)!=(g|0)){d=5;if(b>>>0>1){break a}if(g>>>0<=2){break l}break a}if((b|0)!=1){break k}}if((g-1&255)>>>0<=1){F[a+16|0]=1;H[e+20>>2]=H[e+20>>2]+1;H[e+24>>2]=H[e+24>>2]+1;break b}d=0;G[c+2>>1]=0;H[c+16>>2]=1;H[c+20>>2]=0;break j}G[c+2>>1]=0;H[c+16>>2]=1;H[c+20>>2]=0;if((b|0)!=4){break f}d=1;if((f|0)!=2){break i}}G[c>>1]=d;f=H[16644];H[c+8>>2]=f;H[c+12>>2]=f>>31;if(Ng(a,c)){d=5;e=H[18340];b=ol(e);if((b|0)==5){break a}H[a+20>>2]=e;d=b;break a}if((b|0)!=4){break h}F[a+16|0]=3;F[e+28|0]=3;if(!d){break g}}d=5;if(H[e+20>>2]>1){break a}G[c>>1]=1;d=510;g=2;f=0;break e}if(d){break f}}H[c+16>>2]=510;H[c+20>>2]=0;d=H[16644]+2|0;H[c+8>>2]=d;H[c+12>>2]=d>>31;d=0;f=0;if(Ng(a,c)){f=H[18340];d=ol(f)}H[c+16>>2]=1;H[c+20>>2]=0;G[c>>1]=2;g=H[16644];H[c+8>>2]=g;H[c+12>>2]=g>>31;m:{if(!(!Ng(a,c)|d)){f=H[18340];d=2058;break m}if(!d){break d}if((d|0)==5){break a}}H[a+20>>2]=f;break a}g=(b|0)==2;d=g?1:510;G[c>>1]=1;g=g?1:2;f=0}H[c+16>>2]=d;H[c+20>>2]=f;d=g+H[16644]|0;H[c+8>>2]=d;H[c+12>>2]=d>>31;if(!Ng(a,c)){break c}d=5;e=H[18340];b=ol(e);if((b|0)==5){break a}H[a+20>>2]=e;d=b;break a}H[e+20>>2]=1;H[e+24>>2]=H[e+24>>2]+1}F[a+16|0]=b;F[e+28|0]=b}d=0}Ea=c+32|0;return d|0}function ck(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;c=H[a+20>>2];a:{if(!c){c=101;a=H[a+12>>2];if(!a){break a}G[a>>1]=0;return 101}f=H[a>>2];g=H[H[f>>2]>>2];H[a+20>>2]=c-1;c=H[f+60>>2];if(!(!c|!(H[b+40>>2]&512))){h=I[b+16|0];while(1){b:{if(!(I[c+41|0]&2)|I[c+16|0]!=(h|0)){break b}c:{if(Gz(c,b)){e=G[c+20>>1];d=G[b+20>>1];G[b+20>>1]=(e|0)<(d|0)?e:d;e=G[b+22>>1];d=G[c+22>>1];d=(e|0)<(d|0)?e:d-1|0;break c}if(!Gz(b,c)){break b}e=G[c+20>>1];d=G[b+20>>1];G[b+20>>1]=(e|0)>(d|0)?e:d;e=G[b+22>>1];d=G[c+22>>1];d=(e|0)>(d|0)?e:d+1|0}G[b+22>>1]=d}c=H[c+56>>2];if(c){continue}break}}a=H[a+12>>2];if(a){c=0;if(!J[b+44>>1]){break a}Iz(a,H[b>>2],H[b+4>>2],G[b+20>>1],G[b+22>>1]);return 0}c=Fz(f+60|0,b);if(!c){return 0}d:{e:{a=H[c>>2];if(!a){a=Nb(g,72,0);H[c>>2]=a;if(a){break e}return 7}c=a+56|0;while(1){if(!H[c>>2]){break d}c=Fz(c,b);if(!c){break d}f=H[c>>2];if(!f){break d}H[c>>2]=H[f+56>>2];Pz(g,f);continue}}G[a+48>>1]=3;G[a+44>>1]=0;H[a+56>>2]=0;H[a+40>>2]=0;H[a+52>>2]=a+60}Hz(g,a);f:{g:{c=J[b+44>>1];if(c>>>0<=J[a+48>>1]){break g}if(!oi(g,a,c)){break g}Xa(a,0,48);c=7;break f}c=Va(a,b,48);Va(H[c+52>>2],H[b+52>>2],J[c+44>>1]<<2);g=H[b+40>>2];if(g&1024){F[b+28|0]=I[b+28|0]&254;c=0;break f}c=0;if(!(g&16384)){break f}H[b+32>>2]=0;c=0}if(I[a+41|0]&4){break a}b=H[a+32>>2];if(!b|((I[b+55|0]|I[b+56|0]<<8)&3)!=3){break a}H[a+32>>2]=0}return c}function WF(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;if(H[a+56>>2]){return 1}H[b+40>>2]=0;H[b+44>>2]=1095963344;H[b+20>>2]=0;c=H[b>>2];m=(c|0)>0?c:0;h=-1;i=-1;j=-1;f=-1;c=0;while(1){a:{b:{c:{if((c|0)!=(m|0)){d=H[b+4>>2]+N(c,12)|0;if(!I[d+5|0]){if(I[d+4|0]!=64){break a}H[b+48>>2]=0;H[b+52>>2]=262144;H[b+40>>2]=-981572454;H[b+44>>2]=1246829326;H[b+20>>2]=0;return 0}g=H[d>>2];l=(g|0)<0;if(l){k=1}else{k=(H[a+24>>2]+1|0)==(g|0)}d=I[d+4|0];if(!(!k|((d|0)!=2|(f|0)>=0))){H[b+40>>2]=0;H[b+44>>2]=1072693248;e=1;H[b+20>>2]=1;f=c;break c}if((d|0)==2){break c}if((d|0)!=64){break b}d=64;if(H[a+24>>2]<(g|0)|l){break b}H[b+40>>2]=0;H[b+44>>2]=1073741824;e=g+2|0;H[b+20>>2]=e;f=c;break b}c=1;if((e|0)==1){H[b+56>>2]=H[b+56>>2]|1}if((f|0)>=0){c=H[b+16>>2]+(f<<3)|0;F[c+4|0]=1;H[c>>2]=1;c=2}if((h|0)>=0){e=e|65536;H[b+20>>2]=e;H[H[b+16>>2]+(h<<3)>>2]=c;c=c+1|0}if((i|0)>=0){e=e|131072;H[b+20>>2]=e;H[H[b+16>>2]+(i<<3)>>2]=c;c=c+1|0}if((j|0)>=0){H[b+20>>2]=e|262144;H[H[b+16>>2]+(j<<3)>>2]=c}if(H[b+8>>2]!=1){return 0}c=H[b+12>>2];f=H[c>>2];if(!((f|0)>=0&(f|0)!=(H[a+24>>2]+1|0))){a=I[c+4|0];H[b+32>>2]=1;H[b+24>>2]=a?20380:20794}return 0}d=2;h=(H[a+24>>2]+2|0)==(g|0)?c:h}if(!k){break a}d:{switch(xJ(d-4|0,30)|0){case 1:case 3:j=c;break a;case 0:case 7:break d;default:break a}}i=c}c=c+1|0;continue}}function gy(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;e=Ea-32|0;Ea=e;c=Xu(a);a:{if(c){break a}b:{if(I[a+7|0]){break b}c=H[a+68>>2];h=H[c>>2];if(!(!h|I[a+5|0]==4)){f=H[a+64>>2];g=H[f>>2];c:{d:{if(!g){f=0;break d}f=Ia[H[g+48>>2]](f)|0;d=1;if(f&512){break c}c=H[a+68>>2];h=H[c>>2]}H[e+8>>2]=-117058087;H[e+12>>2]=-681336544;d=H[a+48>>2];H[e+16>>2]=d<<24|(d&65280)<<8|(d>>>8&65280|d>>>24);d=bm(a);g=Ha;c=Ia[H[h+8>>2]](c,e+24|0,8,d,g)|0;e:{if(!c){if((I[e+24|0]|I[e+25|0]<<8|(I[e+26|0]<<16|I[e+27|0]<<24))!=-117058087|(I[e+28|0]|I[e+29|0]<<8|(I[e+30|0]<<16|I[e+31|0]<<24))!=-681336544){break e}c=H[a+68>>2];c=Ia[H[H[c>>2]+12>>2]](c,33132,1,d,g)|0}if((c|0)==522){break e}if(c){break a}}f:{if(!I[a+8|0]|f&1024){break f}d=I[a+10|0];if(!d){break f}c=H[a+68>>2];c=Ia[H[H[c>>2]+20>>2]](c,d)|0;if(c){break a}}c=H[a+68>>2];c=Ia[H[H[c>>2]+12>>2]](c,e+8|0,12,H[a+88>>2],H[a+92>>2])|0;if(c){break a}d=0}g:{if(f&1024){break g}c=I[a+10|0];c=((c|0)==3)<<4|c;if(!c){break g}f=H[a+68>>2];c=Ia[H[H[f>>2]+20>>2]](f,c)|0;if(c){break a}}c=H[a+84>>2];H[a+88>>2]=H[a+80>>2];H[a+92>>2]=c;if(d|!b){break b}H[a+48>>2]=0;c=Wu(a);if(!c){break b}break a}b=H[a+84>>2];H[a+88>>2]=H[a+80>>2];H[a+92>>2]=b}d=H[a+228>>2];c=d;while(1){b=H[c>>2];if(b){G[b+28>>1]=J[b+28>>1]&65527;c=b+40|0;continue}break}H[d+8>>2]=H[d+4>>2];F[a+17|0]=4;c=0}Ea=e+32|0;return c}function wj(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;a:{b:{c:{C(+a);b=x(1)|0;x(0)|0;d:{e:{e=b&2147483647;if(e>>>0>=1078159482){C(+a);e=x(1)|0;e=e&2147483647;if((e|0)==2146435072&(x(0)|0)!=0|e>>>0>2146435072){break a}if((b|0)<0){return-1}if(!(a>709.782712893384)){break e}return a*898846567431158e293}if(e>>>0<1071001155){break c}if(e>>>0>1072734897){break e}if((b|0)>0|(b|0)>=0){b=1;c=1.9082149292705877e-10;g=a+-.6931471803691238;break d}b=-1;c=-1.9082149292705877e-10;g=a+.6931471803691238;break d}C(.5);b=x(1)|0;h=x(0)|0;C(+a);e=x(1)|0;x(0)|0;z(0,h|0);z(1,b&2147483647|e&-2147483648);c=a*1.4426950408889634+ +B();f:{if(P(c)<2147483648){b=~~c;break f}b=-2147483648}d=+(b|0);c=d*1.9082149292705877e-10;g=a+d*-.6931471803691238}a=g;a=a-c;c=g-a-c;break b}if(e>>>0<1016070144){break a}b=0}f=a*.5;d=a*f;g=d*(d*(d*(d*(d*-2.0109921818362437e-7+4008217827329362e-21)+-793650757867488e-19)+.0015873015872548146)+-.03333333333333313)+1;f=3-g*f;f=d*((g-f)/(6-a*f));if(!b){return a-(a*f-d)}c=a*(f-c)-c-d;g:{switch(b+1|0){case 0:return(a-c)*.5+-.5;case 2:if(a<-.25){return(c-(a+.5))*-2}a=a-c;return a+a+1;default:break g}}z(0,0);z(1,b+1023<<20);d=+B();if(b>>>0>=57){a=a-c+1;return((b|0)==1024?(a+a)*898846567431158e293:a*d)+-1}z(0,0);z(1,1023-b<<20);f=+B();a=(b>>>0<=19?1-f+(a-c):a-(c+f)+1)*d}return a}function wI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;i=1;e=J[H[c+4>>2]+16>>1];g=H[c>>2];b=J[g+16>>1];d=b&31;if((b&63)>>>0>=32){h=-1431655766>>>d|0}else{h=((1<<d)-1&-1431655766)<<32-d|-1431655766>>>d}d=e&31;if((e&63)>>>0>=32){d=-1431655766>>>d|0}else{d=((1<<d)-1&-1431655766)<<32-d|-1431655766>>>d}if(!((h|d)&1)){d=xb(g);a:{b:{g=xb(H[c+4>>2]);if((g|0)<=0){c=0;break b}c:{d:{e:{f:{g:{h:{f=b&63;b=f&31;if((f&63)>>>0>=32){b=65536>>>b|0}else{b=((1<<b)-1&65536)<<32-b|65537>>>b}h=b;e=e&63;b=e&31;if((e&63)>>>0>=32){b=65536>>>b|0}else{b=((1<<b)-1&65536)<<32-b|65537>>>b}h=h&b;i:{if(h&1){b=fd(H[c>>2]);e=fd(H[c+4>>2]);break i}k=H[c>>2];b=f&31;if((f&63)>>>0>=32){b=-65537>>>b|0}else{b=((1<<b)-1&-65537)<<32-b|-65538>>>b}f=!(b&1);b=e&31;if((e&63)>>>0>=32){b=-65537>>>b|0}else{b=((1<<b)-1&-65537)<<32-b|-65538>>>b}if(f|!(b&1)){break h}b=$a(k);e=$a(H[c+4>>2])}if(e){break e}break g}j=tj(k);b=$a(j);if(b){break f}}c=0;break c}d=xb(j);c=tj(H[c+4>>2]);e=$a(c);if(!e){break c}g=xb(c);break d}if(!d){c=0;break d}c=0;if(!b){break c}}f=I[e|0];j:while(1){if((d|0)<(g|0)){i=0;break b}k:{if(I[b|0]!=(f|0)){break k}if(Hb(b,e,g)){break k}break b}i=i+1|0;while(1){b=b+1|0;d=d-1|0;if(h&1){continue j}if((I[b|0]&192)==128){continue}break}continue}}Ub(a);break a}uc(a,i)}Uc(j);Uc(c)}}function pi(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;i=a+28|0;j=a+72|0;c=I[a+25|0];e=H[a+4>>2];f=H[a+16>>2];while(1){b=(c&255)-1|0;k=H[(b<<2)+i>>2];l=G[(b<<1)+j>>1];m=(l|0)!=-2;while(1){c=H[e+24>>2]+N(f,48)|0;while(1){if(H[e+12>>2]>(f|0)){a:{if(H[c+20>>2]!=(k|0)|H[c+24>>2]!=(l|0)){break a}if(!m){if(ym(H[H[c>>2]+12>>2],H[a+12>>2],k)){break a}}if(F[H[c>>2]+4|0]&1&I[a+25|0]>=2){break a}g=J[c+12>>1];b:{if(!(g&2048)){break b}h=I[a+26|0];if(h>>>0>10){break b}b=bd(H[H[c>>2]+16>>2]);if(!b|I[b|0]!=167|I[b+4|0]&32){break b}d=0;c:{while(1){if((d|0)==(h|0)){break c}if(!(H[(d<<2)+i>>2]==H[b+28>>2]&J[(d<<1)+j>>1]==J[b+32>>1])){d=d+1|0;continue}break}if((d|0)!=(h|0)){break b}}H[(h<<2)+i>>2]=H[b+28>>2];G[(h<<1)+j>>1]=J[b+32>>1];F[a+26|0]=h+1;g=J[c+12>>1]}if(!(g&H[a+20>>2])){break a}if(!(!H[a+8>>2]|g&256)){d=H[H[e>>2]>>2];b=H[c>>2];if(!Lz(b,F[a+24|0])){break a}b=Uh(d,b);if(!b){b=H[H[d>>2]+8>>2]}if(ab(H[b>>2],H[a+8>>2])){break a}g=J[c+12>>1]}d:{if(!(g&130)){break d}b=H[H[c>>2]+16>>2];if(!b|I[b|0]!=167|H[b+28>>2]!=H[i>>2]){break d}if(J[b+32>>1]==J[j>>1]){break a}}H[a+4>>2]=e;H[a+16>>2]=f+1;return c}c=c+48|0;f=f+1|0;continue}break}f=0;e=H[e+4>>2];if(e){continue}break}b=I[a+25|0];if(b>>>0<I[a+26|0]){c=b+1|0;F[a+25|0]=c;e=H[a>>2];continue}break}return 0}function by(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;h=Ea-16|0;Ea=h;d=H[a+64>>2];a:{if(!H[d>>2]){e=H[a>>2];e=Ia[H[e+24>>2]](e,0,d,H[a+152>>2]&17334113|30,0)|0;if(e){break a}}e=0;c=H[a+40>>2];d=H[a+28>>2];if(c>>>0>=d>>>0|!H[b+16>>2]&c>>>0>=K[b+24>>2]){break a}k=h,l=sJ(H[a+168>>2],H[a+172>>2],d,0),H[k+8>>2]=l;H[h+12>>2]=Ha;c=H[a+64>>2];f=H[c>>2];if(f){Ia[H[f+40>>2]](c,5,h+8|0)|0;d=H[a+28>>2]}H[a+40>>2]=d}while(1){if(!(!b|e)){e=0;f=H[b+24>>2];if(!(I[b+28|0]&16|f>>>0>K[a+28>>2])){d=H[a+168>>2];e=sJ(d,H[a+172>>2],f-1|0,0);g=Ha;i=(f|0)!=1;if(!i){jq(b);d=H[a+168>>2]}j=H[a+64>>2];c=H[b+4>>2];e=Ia[H[H[j>>2]+12>>2]](j,c,d,e,g)|0;if(!i){d=I[c+28|0]|I[c+29|0]<<8|(I[c+30|0]<<16|I[c+31|0]<<24);g=I[c+24|0]|I[c+25|0]<<8|(I[c+26|0]<<16|I[c+27|0]<<24);F[a+112|0]=g;F[a+113|0]=g>>>8;F[a+114|0]=g>>>16;F[a+115|0]=g>>>24;F[a+116|0]=d;F[a+117|0]=d>>>8;F[a+118|0]=d>>>16;F[a+119|0]=d>>>24;d=I[c+36|0]|I[c+37|0]<<8|(I[c+38|0]<<16|I[c+39|0]<<24);c=I[c+32|0]|I[c+33|0]<<8|(I[c+34|0]<<16|I[c+35|0]<<24);F[a+120|0]=c;F[a+121|0]=c>>>8;F[a+122|0]=c>>>16;F[a+123|0]=c>>>24;F[a+124|0]=d;F[a+125|0]=d>>>8;F[a+126|0]=d>>>16;F[a+127|0]=d>>>24}if(f>>>0>K[a+36>>2]){H[a+36>>2]=f}H[a+208>>2]=H[a+208>>2]+1;Yu(H[a+96>>2],f,H[b+4>>2])}b=H[b+16>>2];continue}break}Ea=h+16|0;return e}function gh(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=Ea+-64|0;Ea=e;a:{if(!b){b=0;break a}c=H[b+4>>2];if(!(!(c&3)|H[b+36>>2]!=H[a+4>>2])){H[b+36>>2]=H[a+8>>2]}b:{c:{d=I[b|0];d:{if((d|0)!=179){if(c&32|(d|0)!=167|H[b+28>>2]!=H[a+4>>2]){break d}d=H[a>>2];h=G[b+32>>1];c=H[(H[a+16>>2]+(h<<4)|0)+8>>2];if(Ke(c)){KA(d,c);break a}f=H[d>>2];e:{if(!H[a+12>>2]){break e}f:{if(I[c|0]!=167){g=H[a+8>>2];break f}g=H[a+8>>2];if((g|0)==H[c+28>>2]){break e}}d=e+12|0;Xa(d,0,52);G[e+44>>1]=65437;H[e+40>>2]=g;H[e+24>>2]=c;F[e+12|0]=179;H[e+16>>2]=262144;c=d}c=jb(f,c,0);if(!I[f+87|0]){if(H[a+12>>2]){H[c+4>>2]=H[c+4>>2]|2097152}d=H[b+4>>2]&3;if(d){kh(c,H[b+36>>2],d)}he(f,b);if(I[c|0]==170){b=hk(c);F[c|0]=155;H[c+8>>2]=b;H[c+4>>2]=H[c+4>>2]|2048}d=md(H[a>>2],c);b=md(H[a>>2],H[(H[a+20>>2]+(h<<4)|0)+8>>2]);if((d|0)==(b|0)){d=I[c|0];if((d|0)==113|(d|0)==167){break c}}b=qi(H[a>>2],c,b?H[b>>2]:33248);break b}eb(f,c);break a}if(H[b+28>>2]!=H[a+4>>2]){break d}H[b+28>>2]=H[a+8>>2]}i=b,j=gh(a,H[b+12>>2]),H[i+12>>2]=j;i=b,j=gh(a,H[b+16>>2]),H[i+16>>2]=j;c=H[b+20>>2];g:{if(I[b+5|0]&16){en(a,c,1);break g}eh(a,c)}if(!(F[b+7|0]&1)){break a}c=H[b+44>>2];i=c,j=gh(a,H[c+40>>2]),H[i+40>>2]=j;eh(a,H[c+8>>2]);eh(a,H[c+12>>2]);break a}b=c}H[b+4>>2]=H[b+4>>2]&-513}Ea=e- -64|0;return b}function Cx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Ea-48|0;Ea=f;a:{if(!d){Ta(H[b>>2]);H[b>>2]=0;H[b+4>>2]=0;e=0;break a}g=H[b+44>>2];if((g|0)<0){H[b+4>>2]=e;H[b>>2]=d;e=0;break a}k=H[b>>2];if(!k){Ta(d);e=0;break a}j=H[b+4>>2];b:{if((c|0)>(g|0)){n=c-g|0;g=d;h=e;break b}n=g-c|0;g=k;h=j;k=d;j=e}i=I[a+239|0];H[f+40>>2]=0;H[f+44>>2]=0;H[f+32>>2]=0;H[f+36>>2]=0;H[f+24>>2]=0;H[f+28>>2]=0;H[f+20>>2]=k;H[f+16>>2]=g;H[f+8>>2]=0;a=g;c:{d:{if(!i){break d}a=h>>31;d=h+10|0;a=d>>>0<10?a+1|0:a;a=ub(d,a);if(a){break d}e=7;break c}H[f+12>>2]=a;j=j+k|0;pe(f+20|0,j,0,f+40|0);h=g+h|0;pe(f+16|0,h,0,f+32|0);while(1){if(!(!H[f+20>>2]|!H[f+16>>2])){d=H[f+40>>2];e=H[f+32>>2];m=H[f+44>>2];l=H[f+36>>2];e=(l|0)<=(m|0)&d>>>0>e>>>0|(l|0)<(m|0)?1:(d|0)!=(e|0)|(m|0)!=(l|0)?-1:0;e=i?0-e|0:e;if(!e){e=H[f+8>>2];l=H[f+24>>2];p=H[f+28>>2];q=H[f+12>>2];o=f+12|0;Ul(o,i,f+24|0,f+8|0,d,m);if(!ci(o,n,0,1,f+20|0,f+16|0)){H[f+24>>2]=l;H[f+28>>2]=p;H[f+12>>2]=q;H[f+8>>2]=e}pe(f+20|0,j,i,f+40|0);pe(f+16|0,h,i,f+32|0);continue}if((e|0)<0){d=f+20|0;qe(0,d);pe(d,j,i,f+40|0)}else{d=f+16|0;qe(0,d);pe(d,h,i,f+32|0)}continue}break}h=H[f+12>>2]-a|0;e=0;if(!i){break c}Ta(g);g=a}Ta(k);H[b+4>>2]=h;H[b>>2]=g}if(H[b+44>>2]<(c|0)){H[b+44>>2]=c}Ea=f+48|0;return e}function aF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;e=Ea-16|0;Ea=e;a:{b:{switch(c|0){case 0:c=H[a+24>>2];if(!c){if(H[a+16>>2]==1){break a}d=Yw(a);c=H[a+16>>2];if((d|0)==(c|0)){break a}c=c-d|0;a=d+H[a+44>>2]|0;if(I[a|0]==91){bg(a+1|0,e+8|0,c-1|0,1);_b(b,H[e+8>>2],H[e+12>>2]);break a}d=a+1|0;if(I[d|0]==34){qb(b,a+2|0,c-3|0,-1);break a}qb(b,d,c-1|0,-1);break a}if(I[a+20|0]==12){mm(a+168|0,H[a+8>>2],b,1);break a}a=(H[a+32>>2]+N(c,24)|0)-8|0;_b(b,H[a>>2],H[a+4>>2]);break a;case 1:c=Ij(a);mm(a+168|0,c,b,1);if((I[c+H[a+168>>2]|0]&15)>>>0<11){break a}a=H[b>>2];F[a+19|0]=74;G[a+16>>1]=J[a+16>>1]|2048;break a;case 2:qb(b,H[((I[Ij(a)+H[a+168>>2]|0]&15)<<2)+52624>>2],-1,0);break a;case 3:c=Ij(a);if((I[c+H[a+168>>2]|0]&15)>>>0>10){break a}mm(a+168|0,c,b,1);break a;case 4:_b(b,H[a+8>>2],0);break a;case 5:c=H[a+24>>2];if(!c|!I[a+21|0]){break a}_b(b,H[(H[a+32>>2]+N(c,24)|0)-24>>2],0);break a;case 6:d=H[a+60>>2];f=d;c=H[a+56>>2];g=c;if(H[a+24>>2]){Zw(a);d=H[a+60>>2];c=H[a+56>>2]}eg(b,H[a+44>>2],c,d,-1);H[a+56>>2]=g;H[a+60>>2]=f;break a;case 7:c=Yw(a);eg(b,H[a+44>>2],c,0,-1);break a;default:qb(b,H[a+44>>2],H[a+16>>2],0);break a;case 8:break b}}c=H[a+180>>2];if(!c){le(b,H[a+168>>2],H[a+172>>2],-1);break a}qb(b,c,-1,-1)}Ea=e+16|0;return 0}function vF(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=Ea-16|0;Ea=f;j=H[c+28>>2]+N(N(H[c+4>>2],b),12)|0;d=H[c>>2];h=H[d>>2];a:{if(!(!I[a+34|0]|H[H[a+8>>2]>>2]==1)){b=0;while(1){if(H[h+24>>2]<=(b|0)){break a}a=N(b,12)+j|0;c=H[d+64>>2];H[a+8>>2]=c;H[a+4>>2]=c;b=b+1|0;continue}}if(!H[a+40>>2]){g=H[d+32>>2];l=H[d+36>>2];b=a;while(1){c=b;b=H[c+8>>2];if(I[c+34|0]|H[b>>2]==1?b:0){continue}break}i=I[c+32|0];b=H[c+24>>2];m=H[c+28>>2];e=gg(c,119,h);H[f+12>>2]=e;if(e){break a}Ol(d,c,f+12|0);while(1){e=H[f+12>>2];if(!(e|I[d+6|0])){while(1){if(!I[d+7|0]){ob(H[d+12>>2])}k=f+12|0;rd(d,c,k);e=I[c+32|0];H[d+88>>2]=1;F[d+7|0]=1;F[d+6|0]=e;n=H[c+28>>2];H[d+32>>2]=H[c+24>>2];H[d+36>>2]=n;if(!(H[c>>2]!=1|e)){if(dq(d,k)){continue}}break}if(H[f+12>>2]|I[d+6|0]){continue}bx(c,H[h+24>>2]);continue}break}H[d+32>>2]=g;H[d+36>>2]=l;F[d+6|0]=0;b:{if(i){F[c+32|0]=i;break b}Ol(d,c,f+12|0);while(1){rd(d,c,f+12|0);if(I[c+32|0]){H[f+12>>2]=267;e=267}else{e=H[f+12>>2]}if(H[c+24>>2]==(b|0)&(m|0)==H[c+28>>2]){break b}if(!e){continue}break}}if(e){break a}}e=0;c=0;while(1){if(H[h+24>>2]<=(c|0)){break a}b=N(c,12);g=b+4|0;i=g+j|0;d=g;g=H[a+40>>2];H[i>>2]=H[d+g>>2];b=b+8|0;H[b+j>>2]=H[b+g>>2];c=c+1|0;continue}}Ea=f+16|0;return e|0}function FI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;a:{f=H[c>>2];e=J[f+16>>1];d=e&31;if((e&63)>>>0>=32){d=-1431655766>>>d|0}else{d=((1<<d)-1&-1431655766)<<32-d|-1431655766>>>d}if(d&1){break a}j=$a(f);if(!j){break a}f=xb(H[c>>2]);b:{c:{d:{if((b|0)==1){k=51784;h=51788;g=1;break d}d=$a(H[c+4>>2]);if(!d){break a}c=d;while(1){h=I[c|0];if(h){e=c+1|0;c=e;if(h>>>0>=192){while(1){c=e;e=c+1|0;if((I[c|0]&192)==128){continue}break}}g=g+1|0;continue}break}if(!g){break c}h=ch(a,g<<3,g>>>29|0);if(!h){break a}k=(g<<2)+h|0;g=0;while(1){if(I[d|0]){i=g<<2;H[i+h>>2]=d;e=d+1|0;c=e;if(I[d|0]>=192){while(1){c=e;e=c+1|0;if((I[c|0]&192)==128){continue}break}}H[i+k>>2]=c-d;g=g+1|0;d=c;continue}break}if(!g){break c}}d=H[H[a+4>>2]+8>>2];e:{if(!(d&1)|!f){break e}while(1){c=0;e=0;while(1){f:{if((c|0)==(g|0)){break f}i=c<<2;e=H[i+k>>2];if(f>>>0>=e>>>0){if(!Hb(j,H[h+i>>2],e)){break f}}c=c+1|0;continue}break}if(c>>>0>=g>>>0){break e}j=e+j|0;f=f-e|0;if(f){continue}break}f=0}g:{if(!(!(d&2)|!f)){while(1){d=f;c=0;while(1){if((c|0)==(g|0)){break g}h:{i=c<<2;e=H[i+k>>2];if(e>>>0<=d>>>0){f=d-e|0;if(!Hb(j+f|0,H[h+i>>2],e)){break h}}c=c+1|0;continue}break}d=0;if(f){continue}break g}}d=f}if((b|0)==1){break b}Ta(h);break b}d=f}qb(a,j,d,-1)}}function fe(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;g=Ea-16|0;Ea=g;H[g+8>>2]=0;a:{if(!QA(a)){b=Rc(135389);break a}Pc(a,0);b=b?b:30558;b:{c:{while(1){if(!(!I[b|0]|h)){H[g+8>>2]=0;h=ph(a,b,-1,g+8|0,g+12|0);if(h){continue}i=0;b=0;j=0;k=0;f=H[g+8>>2];if(!f){h=0;b=H[g+12>>2];continue}while(1){d:{h=vb(f);e:{if(!c){break e}f:{g:{h:{if((h|0)!=100){if((h|0)!=101|b){break d}if(F[a+33|0]&1){break h}break d}if(b){break g}}b=0;j=0;j=f?J[f+144>>1]:j;i=nd(a,j<<3|4,0);if(!i){break c}while(1){if((b|0)!=(j|0)){m=(b<<2)+i|0,n=Lm(f,b),H[m>>2]=n;b=b+1|0;continue}break}if((h|0)!=100){break f}}b=0;k=(j<<2)+i|0;while(1){if((b|0)!=(j|0)){f=$e(H[g+8>>2],b);H[(b<<2)+k>>2]=f;i:{if(f){break i}f=H[g+8>>2];if((hh(f,b)|0)==5){break i}Ib(a);h=100;b=i;break c}b=b+1|0;continue}break}H[(j<<2)+k>>2]=0}b=1;l=Ia[c|0](d,j,k,i)|0;f=H[g+8>>2];if(!l){break e}Cf(f);H[g+8>>2]=0;h=4;Pc(a,4);break b}if((h|0)==100){continue}}break}h=Cf(f);H[g+8>>2]=0;f=H[g+12>>2];while(1){b=f;f=b+1|0;if(F[I[b|0]+31152|0]&1){continue}break}Za(a,i);continue}break}b=0;f=H[g+8>>2]}if(f){Cf(f)}i=b}Za(a,i);b=gd(a,h);if(!(!e|!b)){c=Tb(0,rg(a));H[e>>2]=c;if(c){break a}b=7;Pc(a,7);break a}if(!e){break a}H[e>>2]=0}Ea=g+16|0;return b|0}function pm(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;if(I[a+8|0]==2){d=H[a+4>>2];H[d+4>>2]=H[a>>2];a:{if(!I[d+17|0]){break a}l=H[d>>2];Wp(d);if(I[d+18|0]){break a}b:{e=H[d+48>>2];if((e|0)!=(Qd(d,e)|0)){i=H[d+36>>2];if(((K[16644]/(i>>>0)|0)+1|0)!=(e|0)){break b}}return Ya(74285)}g=cb(H[H[d+12>>2]+56>>2]+36|0);c=g;c:{h=H[a>>2];j=H[h+260>>2];if(!j){break c}c=H[h+20>>2];c=(c|0)>0?c:0;k=H[h+16>>2];while(1){d:{m=H[h+252>>2];if((c|0)!=(f|0)){if(H[((f<<4)+k|0)+4>>2]!=(a|0)){break d}c=f}a=Ia[j|0](m,H[(c<<4)+k>>2],e,g,i)|0;c=a>>>0<g>>>0?a:g;if(!c){break a}break c}f=f+1|0;continue}}a=qx(d,e,c);if(a>>>0>e>>>0){return Ya(74312)}f=0;if(a>>>0<e>>>0){f=hg(d,0,0)}h=(c|0)==(g|0);while(1){if(!(a>>>0>=e>>>0|f)){f=gx(d,a,e,h);e=e-1|0;continue}break}if(!(!g|(f|0)!=101&(f|0)!=0)){f=Vb(H[H[d+12>>2]+72>>2]);if((c|0)==(g|0)){c=H[H[d+12>>2]+56>>2];F[c+32|0]=0;F[c+33|0]=0;F[c+34|0]=0;F[c+35|0]=0;c=H[H[d+12>>2]+56>>2];F[c+36|0]=0;F[c+37|0]=0;F[c+38|0]=0;F[c+39|0]=0}c=H[H[d+12>>2]+56>>2];e=a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24);F[c+28|0]=e;F[c+29|0]=e>>>8;F[c+30|0]=e>>>16;F[c+31|0]=e>>>24;H[d+48>>2]=a;F[d+19|0]=1}if(!f){break a}Mp(l);return f}a=H[d>>2];if(I[d+19|0]){H[a+28>>2]=H[d+48>>2]}a=Jq(a,b,0)}else{a=0}return a}function cf(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{if(I[b+43|0]!=1){c=0;if(G[b+34>>1]>0){break a}}e=Ea-48|0;Ea=e;c=H[a>>2];b:{if(I[b+43|0]==1){H[c+56>>2]=H[c+56>>2]+1;c:{if(zd(c,b)){break c}d=Hc(c+388|0,H[H[b+48>>2]>>2]);if(!d){H[e>>2]=H[H[b+48>>2]>>2];Wa(a,8337,e);d=1;break c}H[e+44>>2]=0;d=np(c,b,d,H[H[d>>2]+8>>2],e+44|0);b=H[e+44>>2];if(d){H[e+16>>2]=b;Wa(a,8863,e+16|0);H[a+12>>2]=d}Za(c,b)}H[c+56>>2]=H[c+56>>2]-1;break b}if(G[b+34>>1]<0){H[e+32>>2]=H[b>>2];Wa(a,15889,e+32|0);d=1;break b}g=Ud(c,H[b+44>>2],0);d:{if(!g){d=1;break d}j=I[a+220|0];F[a+220|0]=0;k=H[a+40>>2];l=H[a+108>>2];wk(a,H[g+32>>2]);h=b+34|0;G[h>>1]=65535;G[c+308>>1]=0;i=H[c+364>>2];H[c+364>>2]=0;d=1;H[c+304>>2]=H[c+304>>2]+1;f=un(a,g,64);H[c+364>>2]=i;H[a+108>>2]=l;H[a+40>>2]=k;e:{if(!f){G[h>>1]=0;break e}d=H[b+16>>2];if(d){Jm(a,d,h,b+4|0);d=0;if(H[a+36>>2]|H[H[g+28>>2]>>2]!=G[h>>1]){break e}or(a,b,g,64);break e}G[b+34>>1]=J[f+34>>1];H[b+4>>2]=H[f+4>>2];H[b+28>>2]=H[b+28>>2]|H[f+28>>2]&98;d=0;H[f+4>>2]=0;G[f+34>>1]=0}G[b+36>>1]=J[b+34>>1];Cd(c,f);fc(c,g);i=H[c+304>>2]-1|0;H[c+304>>2]=i;G[c+308>>1]=i?0:J[c+310>>1];F[a+220|0]=j}a=H[b+60>>2];G[a+78>>1]=J[a+78>>1]|2;if(!I[c+87|0]){break b}On(c,b)}Ea=e+48|0;c=d}return c}function Bx(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=Ea-16|0;Ea=f;g=H[a>>2];d=0;a:{if(!b){break a}d=0;if(I[a+52|0]!=I[g+239|0]){break a}a=H[c+64>>2];d=0;if((a|0)>4){break a}d=(a|0)>0}i=c+72|0;a=0;b:{c:{while(1){if((d|0)!=1){break c}if(H[c+64>>2]>(a|0)){e=N(a,24)+i|0;b=H[e+20>>2];d=0;d:{if(H[e+12>>2]){break d}if(!b){b=0;d=1;break d}d=H[b+44>>2]!=0}h=b?1:h;a=a+1|0;continue}break}if(!h){break c}a=H[c+68>>2];m=(a|0)>=H[g+24>>2]?-1:a;h=0;n=1;d=0;while(1){if(H[c+64>>2]<=(h|0)|d){break b}a=N(h,24)+i|0;b=H[a+20>>2];e:{if(b){j=I[g+239|0];e=H[b+4>>2];k=H[a>>2];l=H[a+4>>2];d=uy(g,b,k,l);if(d){break e}j=j?104:105;a=0;d=(e|0)>0?e:0;f:{while(1){if((a|0)==(d|0)){break f}g:{e=H[H[b>>2]+(a<<2)>>2];if(!H[e+40>>2]){break g}if(oy(e,k,l)){break g}a=a+1|0;continue}break}d=a}H[b+8>>2]=d;a=0;while(1){h:{e=H[b>>2];if((a|0)>=(d|0)){break h}d=ly(g,H[e+(a<<2)>>2]);if(d){break e}a=a+1|0;d=H[b+8>>2];continue}break}fi(e,a,a,j);H[b+32>>2]=m}d=0}h=h+1|0;continue}}d=0;a=0;while(1){if(H[c+64>>2]<=(a|0)|d){break b}b=N(a,24)+i|0;i:{if(!H[b+20>>2]){d=0;break i}H[f+12>>2]=0;H[f+8>>2]=0;d=Dx(g,b,H[c+68>>2],f+12|0,f+8|0);if(d){break i}d=Cx(g,c,a,H[f+8>>2],H[f+12>>2])}a=a+1|0;continue}}H[c+40>>2]=n;Ea=f+16|0;return d}function im(a){var b=0,c=0,d=0,e=0;while(1){a:{b:{c:{d:{e:{f:{g:{h:{i:{d=a+c|0;b=I[d|0];if(b-9>>>0>=5){j:{switch(b-225|0){case 2:break e;case 1:break f;case 0:break g;default:break j}}if((b|0)==239){break d}if((b|0)==47){break i}if((b|0)==194){break h}if((b|0)!=32){break c}}c=c+1|0;continue}b=I[d+1|0];if((b|0)!=47){if(!I[d+2|0]|(b|0)!=42){break c}e=c+3|0;while(1){k:{d=a+e|0;b=I[d|0];l:{if((b|0)!=47){if(b){break l}break c}if(I[d-1|0]==42){break k}}e=e+1|0;continue}break}c=e+1|0;continue}c=c+2|0;while(1){b=a+c|0;e=I[b|0];m:{if((e|0)!=226){b=c;n:{switch(e-10|0){case 1:case 2:break m;case 0:case 3:break a;default:break n}}if(e){break m}break a}if(I[b+1|0]!=128){break m}b=c+2|0;e=I[b+a|0];if((e&254)==168){break a}}c=c+1|0;continue}}if(I[d+1|0]!=160){break c}c=c+2|0;continue}if(I[d+1|0]!=154|I[d+2|0]!=128){break c}break b}o:{switch(I[d+1|0]-128|0){case 0:b=I[d+2|0];if(b<<24>>24>=0){break c}if(b>>>0<139){break b}b=b-168|0;if(b>>>0>7){break c}if(1<<b&131){break b}break c;case 1:break o;default:break c}}if(I[d+2|0]==159){break b}break c}if(I[d+1|0]!=128){break c}if(I[d+2|0]==128){break b}break c}if(I[d+1|0]!=187){break c}if(I[d+2|0]==191){break b}}return c}c=c+3|0;continue}c=((e|0)!=0)+b|0;continue}}function Wh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;a:{switch(b|0){case 10:H[c+12>>2]=0;G[c+16>>1]=1025;H[c>>2]=0;return;case 0:case 11:G[c+16>>1]=1;return;case 1:a=F[a|0];b=a>>31;G[c+16>>1]=4;H[c>>2]=a;H[c+4>>2]=b;return;case 2:b=I[a+1|0];a=F[a|0];G[c+16>>1]=4;a=b|a<<8;H[c>>2]=a;H[c+4>>2]=a>>31;return;case 3:b=I[a+2|0];e=I[a+1|0];a=F[a|0];G[c+16>>1]=4;a=b|(e<<8|a<<16);H[c>>2]=a;H[c+4>>2]=a>>31;return;case 4:a=I[a|0]|I[a+1|0]<<8|(I[a+2|0]<<16|I[a+3|0]<<24);G[c+16>>1]=4;a=a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24);H[c>>2]=a;H[c+4>>2]=a>>31;return;case 5:h=I[a+1|0];i=F[a|0];d=I[a+5|0];b=I[a+4|0];f=I[a+3|0];e=I[a+2|0];G[c+16>>1]=4;g=d;d=f;a=d>>>16|0;f=d<<16;d=a;a=e;e=a>>>8|0;f=a<<24|f;a=b>>>24|0;H[c>>2]=g|(f|b<<8);H[c+4>>2]=a|(e|d)|(h|i<<8);return;case 6:case 7:d=I[a+5|0];e=d>>>16|0;h=d<<16;f=e;d=I[a+4|0];e=d>>>8|0;h=d<<24|h;i=e|f;d=I[a+1|0];e=d>>>16|0;g=d<<16;d=I[a|0];g=d<<24|g;d=I[a+2|0];d=I[a+3|0]|d<<8;e=d|g;d=h|I[a+7|0];f=e|i;e=I[a+6|0];a=e>>>24|0;e=e<<8|d;a=a|f;G[c+16>>1]=(b|0)==6?4:(g&2146435072)!=2146435072?8:e|a&1048575?1:8;H[c>>2]=e;H[c+4>>2]=a;return;case 8:case 9:G[c+16>>1]=4;H[c>>2]=b-8;H[c+4>>2]=0;return;default:break a}}H[c+8>>2]=a;H[c+12>>2]=b-12>>>1;G[c+16>>1]=J[((b&1)<<1)+34240>>1]}function rn(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;l=Ea-16|0;Ea=l;g=H[b+12>>2];i=H[a+40>>2];H[a+40>>2]=i+2;d=H[b>>2];f=H[a>>2];e=H[f+16>>2];j=Fb(f,H[b+24>>2]);a:{if(Yb(a,27,d,0,H[e+(j<<4)>>2])){break a}wd(a,j,H[g+20>>2],1,H[g>>2]);d=wb(a);if(!d){break a}f=(c|0)<0?H[b+44>>2]:c;k=uk(a,b);h=H[a+40>>2];H[a+40>>2]=h+1;e=J[b+50>>1];if(k){H[k>>2]=H[k>>2]+1}fb(d,119,h,0,e,k,-8);Hd(a,i,j,g,112);e=Sa(d,36,i,0);g=zb(a);m=H[a+128>>2];F[(m?m:a)+20|0]=1;Vm(a,b,i,g,0,l+12|0,0,0);Sa(d,139,h,g);xr(a,H[l+12>>2]);Sa(d,39,i,e+1|0);m=H[d+108>>2];H[(I[H[d>>2]+87|0]?73336:H[d+104>>2]+N(e,20)|0)+8>>2]=m;if((c|0)<0){Sa(d,145,f,j)}e=i+1|0;fb(d,113,e,f,j,k,-8);f=H[d+108>>2];if((f|0)>0){G[(H[d+104>>2]+N(f,20)|0)-18>>1]=(c|0)>=0?17:1}k=Sa(d,34,h,0);b:{if(I[b+54|0]){c=Qb(d,1);f=H[d+108>>2];gb(d,132,h,c,g,J[b+50>>1]);hr(a,2,b);j=H[d+108>>2];H[(I[H[d>>2]+87|0]?73336:H[d+104>>2]+N(c,20)|0)+8>>2]=j;break b}c=H[a+128>>2];F[(c?c:a)+21|0]=1;f=H[d+108>>2]}Ua(d,133,h,g,e);if(!(I[b+56|0]&4)){_a(d,137,e)}Sa(d,138,e,g);b=H[d+108>>2];if((b|0)>0){G[(H[d+104>>2]+N(b,20)|0)-18>>1]=16}rb(a,g);Sa(d,37,h,f);b=H[d+108>>2];H[(I[H[d>>2]+87|0]?73336:H[d+104>>2]+N(k,20)|0)+8>>2]=b;_a(d,122,i);_a(d,122,e);_a(d,122,h)}Ea=l+16|0}function qJ(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{b:{c:{d:{e:{f:{g:{h:{i:{j:{e=b;if(e){if(!c){break j}if(!d){break i}e=Q(d)-Q(e)|0;if(e>>>0<=31){break h}break b}if((d|0)==1|d>>>0>1){break b}b=(a>>>0)/(c>>>0)|0;Fa=a-N(b,c)|0;Ga=0;Ha=0;return b}if(!a){break g}if(!d){break f}f=d-1|0;if(f&d){break f}Fa=a;Ga=e&f;a=e>>>rJ(d)|0;Ha=0;return a}f=c-1|0;if(!(f&c)){break e}k=(Q(c)+33|0)-Q(e)|0;g=0-k|0;break c}k=e+1|0;g=63-e|0;break c}Fa=0;a=(e>>>0)/(d>>>0)|0;Ga=e-N(a,d)|0;Ha=0;return a}e=Q(d)-Q(e)|0;if(e>>>0<31){break d}break b}Fa=a&f;Ga=0;if((c|0)==1){break a}c=rJ(c);d=c&31;if((c&63)>>>0>=32){e=0;a=b>>>d|0}else{e=b>>>d|0;a=((1<<d)-1&b)<<32-d|a>>>d}Ha=e;return a}k=e+1|0;g=63-e|0}f=a;e=k&63;h=e&31;if((e&63)>>>0>=32){e=0;f=b>>>h|0}else{e=b>>>h|0;f=((1<<h)-1&b)<<32-h|f>>>h}h=g&63;g=a;i=h&31;if((h&63)>>>0>=32){j=a<<i;a=0}else{j=(1<<i)-1&g>>>32-i|b<<i;a=g<<i}b=j;if(k){g=d-1|0;l=c-1|0;g=(l|0)!=-1?g+1|0:g;h=l;while(1){e=e<<1|f>>>31;f=f<<1|b>>>31;l=e;i=g-(e+(f>>>0>h>>>0)|0)|0;m=i>>31;j=m;e=f;i=c&j;f=e-i|0;e=l-((d&j)+(e>>>0<i>>>0)|0)|0;j=b<<1|a>>>31;a=n|a<<1;b=j|o;l=m&1;n=l;k=k-1|0;if(k){continue}break}}Fa=f;Ga=e;j=b<<1|a>>>31;a=l|a<<1;Ha=j|o;return a}Fa=a;Ga=b;a=0;b=0}Ha=b;return a}function Ju(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0;g=Ea-16|0;Ea=g;j=bm(a);H[a+80>>2]=j;i=Ha;H[a+84>>2]=i;h=101;k=H[a+156>>2];l=k+j|0;k=k>>>0>l>>>0?i+1|0:i;a:{if(c>>>0<l>>>0&(d|0)<=(k|0)|(d|0)<(k|0)){break a}if(!(!b&(H[a+88>>2]==(j|0)&H[a+92>>2]==(i|0)))){b=H[a+68>>2];h=Ia[H[H[b>>2]+8>>2]](b,g+8|0,8,j,i)|0;if(h){break a}h=101;if((I[g+8|0]|I[g+9|0]<<8|(I[g+10|0]<<16|I[g+11|0]<<24))!=-117058087|(I[g+12|0]|I[g+13|0]<<8|(I[g+14|0]<<16|I[g+15|0]<<24))!=-681336544){break a}}c=H[a+68>>2];b=i;d=j+8|0;b=d>>>0<8?b+1|0:b;h=kf(c,d,b,e);if(h){break a}c=H[a+68>>2];b=i;d=j+12|0;b=d>>>0<12?b+1|0:b;h=kf(c,d,b,a+52|0);if(h){break a}b=H[a+68>>2];c=j+16|0;k=c>>>0<16?i+1|0:i;h=kf(b,c,k,f);if(h){break a}b=H[a+84>>2];d=b;c=H[a+80>>2];b:{if(b|c){b=H[a+156>>2];h=0;break b}c=H[a+68>>2];b=i;d=j+20|0;b=d>>>0<20?b+1|0:b;h=kf(c,d,b,g);if(h){break a}b=H[a+68>>2];c=j+24|0;i=c>>>0<24?i+1|0:i;h=kf(b,c,i,g+4|0);if(h){break a}e=H[g+4>>2];if(!e){e=H[a+168>>2];H[g+4>>2]=e}h=101;if(e-65537>>>0<4294902271){break a}b=H[g>>2];if(e+131071&e|b-65537>>>0<4294901791|b+131071&b){break a}h=Rh(a,g+4|0,-1);H[a+156>>2]=b;c=H[a+80>>2];d=H[a+84>>2]}e=b;b=b+c|0;k=e>>>0>b>>>0?d+1|0:d;H[a+80>>2]=b;H[a+84>>2]=k}Ea=g+16|0;return h}function hd(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if(!b){Xb(a);return 0}m=H[a+20>>2];if(m){l=H[m+120>>2];i=l>>31}else{l=1e9;i=0}a:{b:{c:{if((d|0)<0){j=1;if((e|0)==1){break c}while(1){k=514;if(g>>>0>l>>>0&(h|0)>=(i|0)|(h|0)>(i|0)){break b}c=b+g|0;if(!(I[c+1|0]|I[c|0])){break b}g=g+2|0;h=g>>>0<2?h+1|0:h;continue}}k=e?2:16;j=e>>>0<=1?1:e;g=c;h=d;break a}g=tb(b);k=514;break a}j=e}if(g>>>0>l>>>0&(h|0)>=(i|0)|(h|0)>(i|0)){d:{if(f+1>>>0<2){break d}if((f|0)==5){db(m,b);break d}Ia[f|0](b)}Xb(a);up(H[a+20>>2],18);return 18}e:{f:{if((f|0)==-1){d=(d|0)<0;c=d?(j|0)==1?1:2:0;d=h;c=c+g|0;d=c>>>0<g>>>0?d+1|0:d;if(Yh(a,(d|0)<=0&c>>>0<=32|(d|0)<0?32:c)){break e}Va(H[a+8>>2],b,c);break f}_c(a);H[a+8>>2]=b;if((f|0)==5){H[a+32>>2]=b;n=a,o=mf(H[a+20>>2],b),H[n+24>>2]=o;break f}H[a+36>>2]=f;k=(f?4096:8192)|k}F[a+18|0]=j;G[a+16>>1]=k;b=g&2147483647;H[a+12>>2]=b;g:{if(j>>>0<2|b>>>0<2){break g}b=H[a+8>>2];c=I[b+1|0];b=I[b|0];if((b|0)!=255|(c|0)!=254){if((b|0)!=254|(c|0)!=255){break g}d=3}else{d=2}if(fg(a)){break e}c=H[a+12>>2]-2|0;H[a+12>>2]=c;b=H[a+8>>2];Ic(b,b+2|0,c);F[H[a+8>>2]+H[a+12>>2]|0]=0;F[(H[a+8>>2]+H[a+12>>2]|0)+1|0]=0;F[a+18|0]=d;G[a+16>>1]=J[a+16>>1]|512}return 0}return 7}function bg(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;a:{if((d|0)==1){g=1;d=a;break a}e=3-d|0;c=c&-2;while(1){if(!(I[a+e|0]|(c|0)<=(e|0))){e=e+2|0;continue}break}k=(c|0)>(e|0);c=e^1;g=2;d=(d&1)+a|0}a=a+c|0;b:{while(1){j=1;if(a>>>0<=d>>>0){break b}c=I[d|0];if(F[c+31152|0]&1){d=d+g|0;continue}break}c:{switch(c-43|0){case 2:d=d+g|0;j=0;break b;case 0:break c;default:break b}}d=d+g|0}e=d;while(1){if(I[e|0]==48&a>>>0>e>>>0){e=e+g|0;continue}else{c=0;while(1){d:{f=c+e|0;l=f>>>0>=a>>>0;if(l){break d}f=I[f|0];if((f-48&255)>>>0>9){break d}c=c+g|0;i=sJ(h,i,10,0);h=f&255;i=i+h|0;f=Ha;f=h>>>0>i>>>0?f+1|0:f;h=i-48|0;i=f-(i>>>0<48)|0;continue}break}f=j?i:0-(((h|0)!=0)+i|0)|0;m=j?h:0-h|0;h=(i|0)<0;H[b>>2]=h?j?-1:0:m;H[b+4>>2]=h?j?2147483647:-2147483648:f;e:{if(!((d|0)!=(e|0)|c)){k=-1;break e}if(k|l){break e}d=c;while(1){k=1;if(!(F[I[d+e|0]+31152|0]&1)){break e}d=d+g|0;if(a>>>0>e+d>>>0){continue}break}k=0}d=N(g,19);f:{if(d>>>0>c>>>0){break f}a=1;if(c>>>0<=d>>>0){d=0;a=0;while(1){if(!(d>>>0>17|a)){a=N(F[N(d,g)+e|0]-F[d+24409|0]|0,10);d=d+1|0;continue}break}a=a?a:F[N(g,18)+e|0]-56|0;if((a|0)<0){break f}}H[b>>2]=j?-1:0;H[b+4>>2]=j?2147483647:-2147483648;k=a?2:j?3:k}}break}return k}function cF(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;e=Ea-16|0;Ea=e;f=a+168|0;a:{b:{if(I[a+21|0]){H[e+12>>2]=0;c=Ij(a);b=I[c+H[a+168>>2]|0];g=$b(f,c,e+12|0);c:{h=(b&15)-13>>>0<4294967294;d:{if(!h){b=H[a+24>>2];d=H[a+28>>2];e:{if(b>>>0<d>>>0){d=H[a+32>>2];break e}b=(d<<1)+3|0;d=ed(H[a+36>>2],H[a+32>>2],sJ(b,0,24,0),Ha);if(!d){break c}H[a+32>>2]=d;H[a+28>>2]=b;b=H[a+24>>2]}i=H[a+8>>2];d=N(b,24)+d|0;H[d+4>>2]=c;H[d>>2]=i;i=H[e+12>>2];H[d+16>>2]=-1;H[d+20>>2]=-1;c=c+g|0;H[d+8>>2]=i+c;H[d+12>>2]=H[a+56>>2];d=0;if(!(!b|!I[a+20|0])){Zw(a);d=I[a+65|0]?7:0;b=H[a+24>>2]}H[a+8>>2]=c;b=b+1|0;H[a+24>>2]=b;break d}c=H[e+12>>2]+(c+g|0)|0;H[a+8>>2]=c;b=H[a+24>>2]}f:{g:{while(1){if(b){g=H[a+32>>2]+N(b,24)|0;if(K[g-16>>2]>c>>>0){break g}b=b-1|0;H[a+24>>2]=b;H[a+56>>2]=H[g-12>>2];H[a+60>>2]=0;h=0;continue}break}c=0;if(!h){break f}break b}if(h){break b}c=I[H[f>>2]+H[g-20>>2]|0]&15}F[a+20|0]=c;break b}d=7;break a}H[e+8>>2]=0;b=Ij(a);j=a,k=($b(f,b,e+8|0)+b|0)+H[e+8>>2]|0,H[j+8>>2]=k}h:{if(I[a+20|0]!=11){break h}b=H[a+24>>2];if(!b){break h}b=(H[a+32>>2]+N(b,24)|0)-8|0;c=b;f=H[b>>2];b=H[b+4>>2];f=f+1|0;b=f?b:b+1|0;H[c>>2]=f;H[c+4>>2]=b}H[a+4>>2]=H[a+4>>2]+1}Ea=e+16|0;return d|0}function Wn(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;d=Ea+-64|0;Ea=d;H[d+8>>2]=0;H[d+12>>2]=0;f=H[a+4>>2];b=H[a+12>>2];a:{if((f|0)>=(b|0)&K[a>>2]>=K[a+8>>2]|(b|0)<(f|0)){b:{c=H[a+48>>2];c:{if(c){o=H[c+4>>2];b=H[c+12>>2];p=b;l=H[c+8>>2];it(H[c+48>>2],d+24|0,H[H[H[c>>2]+12>>2]+12>>2],l,b);f=c+48|0;while(1){d:{if(e){break d}m=H[o+12>>2]+N(H[H[o+8>>2]+4>>2],56)|0;if(!H[m+24>>2]){break d}b=H[d+40>>2];k=b;g=b>>31;j=H[m+20>>2];b=H[d+48>>2];i=j+b|0;n=j>>31;h=n+H[d+52>>2]|0;h=(b>>>0>i>>>0?h+1|0:h)+g|0;b=i+k|0;h=b>>>0<i>>>0?h+1|0:h;k=b;b=vh(j,n);g=b;k=k+b|0;b=(b>>31)+h|0;b=g>>>0>k>>>0?b+1|0:b;g=H[c+16>>2];h=g+l|0;i=(g>>31)+p|0;i=h>>>0<g>>>0?i+1|0:i;if(h>>>0<k>>>0&(i|0)<=(b|0)|(b|0)>(i|0)){break d}b=d+24|0;Yn(b,j,n);Xn(b,H[m+32>>2],j);e=Kt(H[c+4>>2],d+20|0);continue}break}l=ht(d+24|0,c+56|0);j=H[f+12>>2];g=H[f+8>>2];H[c+40>>2]=g;H[c+44>>2]=j;b=H[f+4>>2];H[c+32>>2]=H[f>>2];H[c+36>>2]=b;e=e?e:l;b=H[c+8>>2];f=H[c+12>>2];if((b|0)==(g|0)&(f|0)==(j|0)){H[c+20>>2]=1}if(e){break c}if(!H[c+20>>2]){break b}}e=0}ou(a);break a}e=ft(H[c>>2],a,c+32|0,b,f);if(e){break a}}e=et(a,d+8|0);if(e){break a}b=H[d+8>>2];H[a+20>>2]=b;e=Vn(a,b,a+32|0)}Ea=d- -64|0;return e}function $n(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;e=b+c|0;d=I[a+9|0];l=d+1|0;a:{h=H[a+56>>2];j=d+h|0;b:{if(!(I[j+2|0]|I[h+l|0])){i=l;d=c;break b}d=l;c:{while(1){i=d;m=d&65535;n=m+h|0;g=I[n|0];o=I[n+1|0];d=o|g<<8;if(d>>>0>=b>>>0){break c}if(d>>>0>m>>>0){continue}break}if(!(d&65535)){break c}return Ya(72044)}d=d&65535;p=H[H[a+52>>2]+40>>2];if(d>>>0>p-4>>>0){return Ya(72049)}d:{if(!(!d|d>>>0>e+3>>>0)){if(d>>>0<e>>>0){return Ya(72061)}g=d+h|0;f=d+(I[g+2|0]<<8|I[g+3|0])|0;if(p>>>0<f>>>0){return Ya(72064)}k=d-e|0;o=I[g+1|0];g=I[g|0];d=f-b|0;break d}f=e;d=c}e:{if(l>>>0>=m>>>0){break e}e=(I[n+3|0]|I[n+2|0]<<8)+m|0;if(e+3>>>0<b>>>0){break e}if(b>>>0<e>>>0){break a}d=f-i|0;k=(b-e|0)+k|0;b=i}e=I[j+7|0];if(e>>>0<(k&255)>>>0){return Ya(72083)}F[j+7|0]=e-k;e=f}f=b&65535;k=I[j+6|0]|I[j+5|0]<<8;if(I[H[a+52>>2]+24|0]&12){Xa(f+h|0,0,d&65535)}f:{if(f>>>0<=k>>>0){if(f>>>0<k>>>0){return Ya(72097)}if((i&65535)!=(l|0)){return Ya(72098)}b=h+l|0;F[b+1|0]=o;F[b|0]=g;F[j+6|0]=e;F[j+5|0]=e>>>8;break f}i=(i&65535)+h|0;b=b<<8|(b&65280)>>>8;F[i|0]=b;F[i+1|0]=b>>>8;b=f+h|0;F[b+3|0]=d;F[b+2|0]=d>>>8;F[b+1|0]=o;F[b|0]=g}H[a+20>>2]=H[a+20>>2]+c;return 0}return Ya(72077)}function Ac(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(I[a+40|0]){break a}b:{c:{d:{if(!I[a+42|0]){b=2e3;c=1;d=1;break d}b=H[a+8>>2];if(b-1e4>>>0<4294952583){break c}c=H[a+16>>2];d=H[a+12>>2]}if(!I[a+41|0]){break b}}i=Xa(a,0,48),j=1,F[i+46|0]=j;return}F[a+40|0]=1;f=(d|0)<3;g=b-f|0;b=g<<16>>16;e=(+((((b|0)/-100|0)+2<<16>>16)+(((b|0)/400<<16>>16)+((((N(f?d+12|0:d,306001)+306001|0)/1e4|0)+c|0)+((N(g,36525)+172251900>>>0)/100|0)|0)|0)|0)+-1524.5)*864e5;e:{if(P(e)<0x8000000000000000){d=~~e>>>0;if(P(e)>=1){b=~~(e>0?R(T(e*2.3283064365386963e-10),4294967295):U((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}break e}d=0;b=-2147483648}H[a>>2]=d;H[a+4>>2]=b;if(!I[a+43|0]){break a}c=N(H[a+24>>2],6e4)+N(H[a+20>>2],36e5)|0;g=c;f=c>>31;e=M[a+32>>3]*1e3+.5;f:{if(P(e)<0x8000000000000000){c=~~e>>>0;if(P(e)>=1){h=~~(e>0?R(T(e*2.3283064365386963e-10),4294967295):U((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0}else{h=0}break f}c=0;h=-2147483648}b=h+b|0;c=d+c|0;d=(c>>>0<d>>>0?b+1|0:b)+f|0;b=c+g|0;d=b>>>0<c>>>0?d+1|0:d;H[a>>2]=b;H[a+4>>2]=d;if(!I[a+44|0]){break a}F[a+44|0]=0;G[a+42>>1]=0;c=N(H[a+28>>2],6e4);H[a>>2]=b-c;H[a+4>>2]=d-((c>>31)+(b>>>0<c>>>0)|0)}}function Vn(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;k=Ea-16|0;Ea=k;e=H[a>>2];h=H[a+4>>2];d=H[a+44>>2];a:{b:{if(d){H[c>>2]=d+e;d=(b>>31)+h|0;c=b;b=b+e|0;d=c>>>0>b>>>0?d+1|0:d;H[a>>2]=b;H[a+4>>2]=d;break b}f=H[a+40>>2];d=f;g=d>>31;d=uJ(e,h,d,g);if(!(d|Ha)){l=H[a+24>>2];m=f;i=H[a+8>>2];j=i-e|0;n=f>>>0<j>>>0;f=H[a+12>>2]-(h+(e>>>0>i>>>0)|0)|0;e=Ia[H[H[l>>2]+8>>2]](l,H[a+36>>2],n&(f|0)>=(g|0)|(f|0)>(g|0)?m:j,e,h)|0;if(e){break a}f=H[a+40>>2]}h=d;g=f-d|0;if((g|0)>=(b|0)){H[c>>2]=d+H[a+36>>2];c=H[a+4>>2]+(b>>31)|0;f=b;b=b+H[a>>2]|0;c=f>>>0>b>>>0?c+1|0:c;H[a>>2]=b;H[a+4>>2]=c;break b}d=H[a+16>>2];c:{if((d|0)>=(b|0)){e=H[a+28>>2];break c}e=d>>31<<1|d>>>31;f=(d|0)<64;d=f?128:d<<1;e=f?0:e;j=b>>31;while(1){i=e;f=d;e=e<<1|d>>>31;d=d<<1;if((i|0)<=(j|0)&b>>>0>f>>>0|(i|0)<(j|0)){continue}break}e=Ld(H[a+28>>2],f,i);if(!e){e=7;break a}H[a+28>>2]=e;H[a+16>>2]=f}Va(e,h+H[a+36>>2]|0,g);d=H[a+4>>2]+(g>>31)|0;e=g+H[a>>2]|0;d=e>>>0<g>>>0?d+1|0:d;H[a>>2]=e;H[a+4>>2]=d;d=b-g|0;while(1){if((d|0)>0){e=H[a+40>>2];f=(d|0)<(e|0)?d:e;e=Vn(a,f,k+12|0);if(e){break a}Va(H[a+28>>2]+(b-d|0)|0,H[k+12>>2],f);d=d-f|0;continue}break}H[c>>2]=H[a+28>>2]}e=0}Ea=k+16|0;return e}function Qt(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0;f=Ea-16|0;Ea=f;e=H[a+8>>2];b=H[a>>2];H[b+24>>2]=H[b+24>>2]|64;d=0;a:{if(!c){break a}d=1;H[a+20>>2]=H[a+20>>2]+1;if(I[b+87|0]){th(a,c,0);break a}b:{h=H[c+12>>2];if(!h){break b}d=H[c+16>>2];c:{if(d){g=I[d|0];if(!((g&223)!=67|(I[d+1|0]&223)!=82)){g=I[b+176|0];F[b+176|0]=e;d:{e:{if(vt(h,b+172|0)){d=H[a+24>>2];if(d>>>0>=K[b+172>>2]|!d){break d}if(I[65929]){break e}break d}if(!I[65929]){break d}}th(a,c,14544)}H[b+180>>2]=c;F[b+178|0]=I[b+178|0]&254;d=0;H[f+12>>2]=0;Wv(b,H[c+16>>2],-1,0,0,f+12|0,0);F[b+176|0]=g;e=H[b+64>>2];f:{if(!e|F[b+178|0]&1){break f}if((e|0)>H[a+12>>2]){H[a+12>>2]=e}g:{switch(e-7|0){case 0:Ib(b);break f;case 2:break f;default:break g}}if((e&255)==6){break f}th(a,c,rg(b))}H[b+180>>2]=67056;Wc(H[f+12>>2]);break a}d=H[c+4>>2];if(g|!d){break b}break c}d=H[c+4>>2];if(!d){break b}}b=ef(b,d,H[H[b+16>>2]+(e<<4)>>2]);h:{if(!b){th(a,c,1547);break h}i:{j:{if(!vt(H[c+12>>2],b+44|0)){break j}d=H[b+44>>2];if(d>>>0<2|d>>>0>K[a+24>>2]){break j}d=0;if(!ut(b)){break a}if(I[65929]){break i}break a}d=0;if(!I[65929]){break a}}th(a,c,14544)}d=0;break a}d=0;th(a,c,0)}Ea=f+16|0;return d|0}function jk(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;d=Ea-48|0;Ea=d;a:{if(H[a+36>>2]){break a}f=H[a+8>>2];e=H[b+20>>2];c=H[b+4>>2];if(c&33554432){H[d+16>>2]=H[e+16>>2];gc(a,0,17382,d+16|0);Sa(f,10,H[b+48>>2],H[b+44>>2]);g=H[b+28>>2];break a}H[b+4>>2]=c|33554432;g=1;c=H[a+44>>2]+1|0;H[a+44>>2]=c;H[b+48>>2]=c;k=b,l=Sa(f,74,0,c)+1|0,H[k+44>>2]=l;if(!(I[b+4|0]&64)){j=Mb(f,15)}H[d+4>>2]=H[e+16>>2];H[d>>2]=j?30558:30404;gc(a,1,17361,d);h=I[b|0]!=138;g=h?g:H[H[e+28>>2]>>2];c=H[a+44>>2];H[d+36>>2]=0;H[d+40>>2]=0;H[d+28>>2]=0;H[d+32>>2]=0;i=c+1|0;H[d+24>>2]=i;c=c+g|0;H[a+44>>2]=c;b:{if(!h){H[d+36>>2]=g;H[d+32>>2]=i;Ua(f,75,0,i,c);c=10;break b}Sa(f,71,0,i);c=3}F[d+20|0]=c;h=H[a>>2];c:{if(H[e+60>>2]){c=oc(h,155,24816);if(c){F[c+1|0]=67;c=ib(a,52,jb(h,H[H[e+60>>2]+12>>2],0),c)}else{c=0}kk(a,H[H[e+60>>2]+12>>2]);H[H[e+60>>2]+12>>2]=c;break c}k=e,l=ib(a,148,oc(h,155,24033),0),H[k+60>>2]=l}g=0;H[e+8>>2]=0;if(Lc(a,e,d+20|0)){F[b+2|0]=I[b|0];F[b|0]=182;break a}g=H[d+24>>2];H[b+28>>2]=g;if(j){c=H[f+108>>2];H[(I[H[f>>2]+87|0]?73336:H[f+104>>2]+N(j,20)|0)+8>>2]=c}Ua(f,67,H[b+48>>2],H[b+44>>2],1);H[a+28>>2]=0;F[a+19|0]=0}Ea=d+48|0;return g}function Mq(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0;k=Ea-32|0;Ea=k;r=bb(d);j=bb(c);g=j;m=H[H[a>>2]+20>>2];a:{b:{c:{d:{e:{if(d){H[k+16>>2]=d;o=mb(m,30520,k+16|0);if(o){break e}f=7;break a}h=g>>>31|0;g=g<<1|1;f=nb(m,sJ(g,h,3,0),Ha);if(f){break d}f=7;break b}h=H[b+4>>2];q=bb(o)-1|0;f=q;f=sJ(h,h>>31,f,f>>31);h=f+g|0;g=Ha;g=f>>>0>h>>>0?g+1|0:g;f=h+1|0;g=f?g:g+1|0;f=nb(m,f,g);p=0;if(f){break c}f=7;break b}s=((j<<2)+f|0)+2|0;p=g+f|0}l=Va(f,c,j);t=j<<1;f:while(1){g:{f=H[b>>2];g=f;if(!f){break g}while(1){g=H[g+12>>2];if(g){f=K[g+4>>2]>K[f+4>>2]?g:f;continue}else{g=b;while(1){h=g;i=H[g>>2];g=i+12|0;if((f|0)!=(i|0)){continue}break}H[h>>2]=H[f+12>>2];i=H[f+4>>2];h:{if(d){if(!(!(I[I[i|0]+31152|0]&70)|e)){g=r;h=d;break h}g=(I[H[f+8>>2]+i|0]==34)+q|0;h=o;break h}g=Va(p,i,H[f+8>>2]);F[g+H[f+8>>2]|0]=0;pf(g);h=I[H[f+4>>2]+H[f+8>>2]|0];H[k>>2]=g;H[k+4>>2]=(h|0)==39?30533:30558;h=Bd(t,s,6160,k);g=bb(h);i=H[f+4>>2]}i=i-c|0;n=H[f+8>>2];if((n|0)!=(g|0)){n=i+n|0;Ic((g+i|0)+l|0,n+l|0,j-n|0);j=(g-H[f+8>>2]|0)+j|0;F[l+j|0]=0}Va(i+l|0,h,g);Za(m,f);continue f}}}break}qb(a,l,-1,-1);db(m,l);f=0}Ta(o)}Ea=k+32|0;return f}function Pu(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;e=Ea-16|0;Ea=e;c=H[a+20>>2];H[e+12>>2]=0;a:{b:{c:{b=H[c+232>>2];if(!b){break c}b=Wo(b,H[a+24>>2],e+12|0);if(b){break a}d=H[e+12>>2];if(!d){break c}b=H[c+232>>2];f=H[b+8>>2];h=H[a+4>>2];b=J[b+66>>1];b=(b<<16|b)&130560;g=H[c+168>>2];g=(b|0)<(g|0)?b:g;d=sJ(b|24,0,d-1|0,0);b=Ha;d=d+56|0;b=d>>>0<56?b+1|0:b;b=Ia[H[H[f>>2]+8>>2]](f,h,g,d,b)|0;break b}b=H[c+64>>2];f=H[a+4>>2];d=H[c+168>>2];h=sJ(d,H[c+172>>2],H[a+24>>2]-1|0,0);b=Ia[H[H[b>>2]+8>>2]](b,f,d,h,Ha)|0;b=(b|0)!=522?b:0}if(H[a+24>>2]!=1){break a}if(b){H[c+112>>2]=-1;H[c+116>>2]=-1;H[c+120>>2]=-1;H[c+124>>2]=-1;break a}a=H[a+4>>2];b=I[a+28|0]|I[a+29|0]<<8|(I[a+30|0]<<16|I[a+31|0]<<24);d=I[a+24|0]|I[a+25|0]<<8|(I[a+26|0]<<16|I[a+27|0]<<24);F[c+112|0]=d;F[c+113|0]=d>>>8;F[c+114|0]=d>>>16;F[c+115|0]=d>>>24;F[c+116|0]=b;F[c+117|0]=b>>>8;F[c+118|0]=b>>>16;F[c+119|0]=b>>>24;b=I[a+36|0]|I[a+37|0]<<8|(I[a+38|0]<<16|I[a+39|0]<<24);a=I[a+32|0]|I[a+33|0]<<8|(I[a+34|0]<<16|I[a+35|0]<<24);F[c+120|0]=a;F[c+121|0]=a>>>8;F[c+122|0]=a>>>16;F[c+123|0]=a>>>24;F[c+124|0]=b;F[c+125|0]=b>>>8;F[c+126|0]=b>>>16;F[c+127|0]=b>>>24;b=0}Ea=e+16|0;return b}function Qi(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;f=Ea-32|0;Ea=f;e=1;C(+c);d=x(1)|0;g=x(0)|0;a:{if((d&2146435072)==2146435072&(d&1048575|g)!=0){break a}if(I[65930]){e=0;g=0;d=Ea-16|0;Ea=d;if(a|b){e=a;a=b>>31;g=e^a;h=g-a|0;a=(a^b)-(a+(a>>>0>g>>>0)|0)|0;e=a;a=Q(a);a=(a|0)==32?Q(h)+32|0:a;Yd(d,h,e,0,0,a+49|0);h=0;e=h+H[d+8>>2]|0;a=(H[d+12>>2]^65536)+(16446-a<<16)|0;a=e>>>0<h>>>0?a+1|0:a;g=b&-2147483648|a;b=H[d+4>>2];a=H[d>>2]}else{b=0;a=0}H[f+16>>2]=a;H[f+20>>2]=b;H[f+24>>2]=e;H[f+28>>2]=g;Ea=d+16|0;Kl(f,c);a=H[f+16>>2];g=H[f+20>>2];b=H[f+24>>2];h=H[f+28>>2];d=H[f>>2];i=H[f+4>>2];e=H[f+8>>2];j=H[f+12>>2];l=Cj(a,g,b,h,d,i,e,j);e=(m=-1,n=(Bj(a,g,b,h,d,i,e,j)|0)>0,o=(l|0)<0,o?m:n);break a}if(c<-0x8000000000000000){break a}e=-1;if(c>=0x8000000000000000){break a}b:{if(P(c)<0x8000000000000000){g=~~c>>>0;if(P(c)>=1){d=~~(c>0?R(T(c*2.3283064365386963e-10),4294967295):U((c-+(~~c>>>0>>>0))*2.3283064365386963e-10))>>>0}else{d=0}break b}g=0;d=-2147483648}if(a>>>0<g>>>0&(b|0)<=(d|0)|(b|0)<(d|0)){break a}e=1;if(a>>>0>g>>>0&(b|0)>=(d|0)|(b|0)>(d|0)){break a}k=+(a>>>0)+ +(b|0)*4294967296;e=c>k?-1:k>c}Ea=f+32|0;return e}function BC(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0;if(!b){return Ya(62238)|0}e=H[a+228>>2];e=Ia[H[16512]](H[e+52>>2],b,I[e+41|0]&3)|0;a:{if(!e){g=7;f=H[a+228>>2];if(I[f+41|0]==2){break a}b:{if((Ia[H[16511]](H[f+52>>2])|0)<=H[f+28>>2]){break b}e=f+8|0;c:{d:{while(1){e=H[e>>2];if(e){if(!(H[e+32>>2]|H[e+36>>2]|I[e+28|0]&8)){break d}e=e+44|0;continue}break}H[f+8>>2]=0;e=f+4|0;while(1){e=H[e>>2];if(!e){break b}if(!(H[e+32>>2]|H[e+36>>2])){break c}e=e+44|0;continue}}H[f+8>>2]=e}g=Ia[H[f+44>>2]](H[f+48>>2],e)|0;if((g|0)==5){break b}if(g){break a}}g=7;e=Ia[H[16512]](H[f+52>>2],b,2)|0;if(!e){break a}}e=Mo(H[a+228>>2],b,e);H[c>>2]=e;e:{d=d&1;f:{if(!(d|!H[e+20>>2])){H[a+200>>2]=H[a+200>>2]+1;break f}if(H[a+164>>2]==(b|0)){g=Ya(62270);break e}H[e+20>>2]=a;if(!(!(d|!H[H[a+64>>2]>>2])&K[a+28>>2]>=b>>>0)){if(K[a+160>>2]<b>>>0){g=13;if(K[a+28>>2]<b>>>0){break e}nl(e);break a}g:{if(!d){break g}c=H[18327];if(c){Ia[c|0]()}if(K[a+32>>2]>=b>>>0){Og(H[a+60>>2],b)}Xo(a,b);b=H[18328];if(!b){break g}Ia[b|0]()}Xa(H[e+4>>2],0,H[a+168>>2]);return 0}H[a+204>>2]=H[a+204>>2]+1;g=Pu(e);if(g){break e}}return 0}gl(e)}Ou(a);H[c>>2]=0;return g|0}function pr(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;i=Ea-16|0;Ea=i;a:{if(d){k=134217728;f=-1;e=H[d>>2];break a}b:{if(c){f=-1;e=CA(b);break b}e=56;if(I[b+5|0]&8){break b}g=H[b+8>>2];if(!g){break b}e=tb(g)&1073741823;f=e+1|0;e=e+60&2147483640}e=Nb(a,e,e>>31)}H[i+12>>2]=e;c:{if(!e){break c}j=BA(b,c);d:{if((f|0)>=0){break d}f=0;if(I[b+5|0]&8){break d}g=H[b+8>>2];if(!g){break d}f=bb(g)+1|0}e:{if(c){g=j&4095;Va(e,b,g);break e}g=52;h=H[b+4>>2];h=h&65536?12:h&16384?28:52;l=Va(e,b,h);if(h>>>0>51){break e}Xa(h+l|0,0,52-h|0)}h=H[e+4>>2]&-134299649|(j&81920|k);H[e+4>>2]=h;if(f){h=e+g|0;H[e+8>>2]=h;Va(h,H[b+8>>2],f);h=H[e+4>>2];g=f+g|0}H[i+12>>2]=(g+7&-8)+e;g=H[b+4>>2];if((g|h)&8454144){break c}f=H[b+20>>2];f:{if(g&4096){f=Ud(a,f,c);break f}f=pc(a,f,I[b|0]!=145?c:0)}H[e+20>>2]=f;if(F[b+7|0]&1){m=e,n=FA(a,e,H[b+44>>2]),H[m+44>>2]=n}f=H[b+12>>2];g=I[b|0];g:{if(c){h:{if((g|0)==178){break h}if(!f){f=0;break h}f=pr(a,f,1,i+12|0)}H[e+12>>2]=f;b=H[b+16>>2];c=0;if(!b){break g}c=pr(a,b,1,i+12|0);break g}c=e;if((g|0)!=178){f=jb(a,f,0)}H[c+12>>2]=f;c=jb(a,H[b+16>>2],0)}H[e+16>>2]=c}if(d){H[d>>2]=H[i+12>>2]}Ea=i+16|0;return e}function or(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;i=Ea-48|0;Ea=i;k=H[a>>2];if(!(I[k+87|0]|I[a+220|0]>1)){while(1){l=c;c=H[c+52>>2];if(c){continue}break}c=H[l+28>>2];Xa(i+12|0,0,36);H[i+16>>2]=H[l+32>>2];n=c+8|0;f=H[b+4>>2];while(1){if(G[b+34>>1]>(m|0)){H[b+28>>2]=H[b+28>>2]|J[f+10>>1]&98;h=m<<4;j=H[h+n>>2];c=rc(j);e=(c|0)<65?d:c;F[f+5|0]=e;a:{if((e|0)<66){break a}g=0;c=H[l+56>>2];if(!c){break a}while(1){if(c){g=pA(H[(h+H[c+28>>2]|0)+8>>2])|g;c=H[c+56>>2];continue}break}c=65;e=F[f+5|0];b:{if(g&1&(e|0)==66){break b}h=(e|0)<67;if(!(g&2?h:1)){break b}if(h){break a}c=70;if(I[j|0]!=36){break a}}F[f+5|0]=c;e=c}g=Hm(i+12|0,j);c:{d:{if(g){if((Mi(g,0)|0)==(e|0)){break d}e=I[f+5|0]}g=19993;c=1;e:{e=e&255;switch(e-67|0){case 0:case 3:break d;default:break e}}while(1){if((c|0)==6){break c}if((e|0)!=I[c+49968|0]){c=c+1|0;continue}break}g=H[(c<<2)+67056>>2];if(!g){break c}}c=H[f>>2];e=bb(g);h=bb(c);c=Ti(k,c,(e+h|0)+2|0,0);H[f>>2]=c;G[f+10>>1]=J[f+10>>1]&65019;if(!c){break c}Va((c+h|0)+1|0,g,e+1|0);G[f+10>>1]=J[f+10>>1]|4}c=md(a,j);if(c){ns(k,f,H[c>>2])}f=f+12|0;m=m+1|0;continue}break}G[b+40>>1]=1}Ea=i+48|0}function bz(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=Ea-80|0;Ea=d;e=b;b=d+32|0;a:{if(ng(a,e,c,b)){break a}Ye(b);F[d+5|0]=45;F[d+8|0]=45;F[d+11|0]=32;F[d+14|0]=58;b=H[d+44>>2];c=(b|0)/10|0;F[d+6|0]=((c|0)%10|0)+48;e=H[d+48>>2];f=(e|0)/10|0;F[d+9|0]=((f|0)%10|0)+48;h=H[d+52>>2];i=(h|0)/10|0;F[d+12|0]=((i|0)%10|0)+48;F[d+7|0]=(b-N(c,10)|0)+48;F[d+10|0]=(e-N(f,10)|0)+48;F[d+13|0]=(h-N(i,10)|0)+48;f=H[d+40>>2];b=f>>31;b=(b^f)-b|0;c=(b>>>0)/10|0;F[d+3|0]=(c>>>0)%10|48;F[d+2|0]=((b>>>0)/100>>>0)%10|48;F[d+1|0]=((b>>>0)/1e3>>>0)%10|48;F[d+4|0]=b-N(c,10)|48;b=H[d+56>>2];F[d+17|0]=58;c=b;b=(b|0)/10|0;F[d+16|0]=(c-N(b,10)|0)+48;F[d+15|0]=((b|0)%10|0)+48;g=M[d+64>>3];b:{if(I[d+79|0]){F[d+24|0]=0;g=g*1e3+.5;c:{if(P(g)<2147483648){c=~~g;break c}c=-2147483648}F[d+21|0]=(((c|0)/100|0)%10|0)+48;b=(c|0)/10|0;F[d+22|0]=((b|0)%10|0)+48;F[d+23|0]=(c-N(b,10)|0)+48;b=(c|0)/1e3|0;e=24;h=46;c=(c|0)/1e4|0;break b}e=20;h=0;if(P(g)<2147483648){b=~~g}else{b=-2147483648}c=(b|0)/10|0}F[d+20|0]=h;F[d+19|0]=((b|0)%10|0)+48;F[d+18|0]=((c|0)%10|0)+48;if((f|0)<0){F[d|0]=45;qb(a,d,e,-1);break a}qb(a,d|1,e-1|0,-1)}Ea=d+80|0}function Rx(a,b,c){var d=0,e=0,f=0,g=0;f=Ea-16|0;Ea=f;g=c;a:{b:{if(H[a+40>>2]){a=H[((H[a+24>>2]<<2)+b|0)+12>>2];c=J[a+16>>1];d=c&31;e=c&63;if((c&63)>>>0>=32){d=-1431655766>>>d|0}else{d=((1<<d)-1&-1431655766)<<32-d|-1431655766>>>d}c=e;c:{if(!(d&1)){break c}a=H[b+4>>2];c=J[a+16>>1]&63}b=c;if((b&63)>>>0>=32){b=0}else{b=1347440720>>>b|0}if(!(b&1)){c=19;break a}c=0;a=kb(a);b=Ha;break b}c=Lb(a,18,f+12|0,b+4|0);if(c){break a}if(H[a+44>>2]){c=H[f+12>>2];d=H[a+24>>2];e=kb(H[((d<<2)+b|0)+16>>2]);c=Zc(c,d+2|0,e);if(c){break a}}d=H[((H[a+24>>2]<<2)+b|0)+12>>2];e=J[d+16>>1];c=e&31;if((e&63)>>>0>=32){c=-1431655766>>>c|0}else{c=((1<<c)-1&-1431655766)<<32-c|-1431655766>>>c}d:{if(c&1){b=H[f+12>>2];break d}e=J[H[b>>2]+16>>1];c=e&31;e:{if((e&63)>>>0>=32){c=-1431655766>>>c|0}else{c=((1<<c)-1&-1431655766)<<32-c|-1431655766>>>c}if(!(c&1)){break e}c=J[H[b+4>>2]+16>>1];b=c&31;if((c&63)>>>0>=32){b=-1431655766>>>b|0}else{b=((1<<b)-1&-1431655766)<<32-b|-1431655766>>>b}if(b&1){break e}c=1;break a}b=H[f+12>>2];c=pp(b,1,d);if(c){break a}}vb(b);c=ob(b);b=H[a+12>>2];a=H[b+40>>2];b=H[b+44>>2]}H[g>>2]=a;H[g+4>>2]=b}Ea=f+16|0;return c}function ri(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=Ea-16|0;Ea=j;m=H[c+40>>2];a:{b:{h=H[c+20>>2];c:{d:{if((h|0)==1){e=G[b+32>>1];if((e|0)<0){break d}if(!m){break c}if(ab(H[H[b+4>>2]+N(e,12)>>2],m)){break d}break a}if(!e){break d}f=Nb(H[a>>2],h<<2,0);if(!f){break b}H[e>>2]=f}o=c+36|0;n=(h|0)>0?h:0;e=b+8|0;while(1){e:{f:{g:{h:{g=H[e>>2];if(g){if(H[g+36>>2]|(!I[g+54|0]|J[g+50>>1]!=(h|0))){break f}if(!m){break h}i=0;i:while(1){if((i|0)==(n|0)){i=n;break g}e=G[H[g+4>>2]+(i<<1)>>1];if((e|0)<0){break g}p=i<<2;k=H[p+H[g+32>>2]>>2];e=H[b+4>>2]+N(e,12)|0;l=Yf(e);if(ab(k,l?l:33248)){break g}l=H[e>>2];e=0;while(1){k=(e|0)==(h|0);if(k){break g}q=(e<<3)+o|0;if(ab(H[q+4>>2],l)){e=e+1|0;continue}else{if(f){H[f+p>>2]=H[q>>2]}if(k){break g}i=i+1|0;continue i}}}}if(!I[a+161|0]){b=H[H[c>>2]>>2];H[j+4>>2]=H[c+8>>2];H[j>>2]=b;Wa(a,29157,j)}Za(H[a>>2],f);break b}if(((I[g+55|0]|I[g+56|0]<<8)&3)!=2){break f}if(!f){break e}e=0;while(1){if((e|0)==(n|0)){break e}H[(e<<2)+f>>2]=H[(e<<3)+o>>2];e=e+1|0;continue}}if((i|0)==(h|0)){break e}}e=g+20|0;continue}break}H[d>>2]=g}f=0;break a}f=1}Ea=j+16|0;return f}function dC(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=(I[b|0]&63)+b|0;a:{b:{switch(I[b+1|0]-1|0){case 1:e=I[d+1|0]|F[d|0]<<8;f=e>>31;break a;case 2:e=I[d+2|0]|(I[d+1|0]<<8|F[d|0]<<16);f=e>>31;break a;case 3:e=I[d|0]|I[d+1|0]<<8|(I[d+2|0]<<16|I[d+3|0]<<24);e=e<<24|(e&65280)<<8|(e>>>8&65280|e>>>24);f=e>>31;break a;case 4:e=I[d+3|0];g=e>>>16|0;h=e<<16;f=g;e=I[d+2|0];g=e>>>8|0;h=e<<24|h;f=f|g;e=I[d+4|0];g=e>>>24|0;i=I[d+5|0]|(e<<8|h);f=f|g;g=I[d+1|0]|F[d|0]<<8;e=i;f=f|g;break a;case 5:e=I[d+4|0]|I[d+5|0]<<8|(I[d+6|0]<<16|I[d+7|0]<<24);f=I[d|0]|I[d+1|0]<<8|(I[d+2|0]<<16|I[d+3|0]<<24);h=f<<24|(f&65280)<<8;d=f&16711680;g=d<<24;d=d>>>8|0;j=g;i=f&-16777216;g=i>>>24|0;e=j|i<<8|(((e&255)<<24|f>>>8)&-16777216|((e&16777215)<<8|f>>>24)&16711680|(e>>>8&65280|e>>>24));j=d|g|h;g=0;f=j|(g|g);break a;case 8:e=1;break a;default:return Ri(a,b,c)|0;case 7:break a;case 0:break b}}e=F[d|0];f=e>>31}g=H[c+8>>2];d=H[c+12>>2];if(g>>>0>e>>>0&(d|0)>=(f|0)|(d|0)>(f|0)){return F[c+24|0]}if((d|0)<=(f|0)&e>>>0>g>>>0|(d|0)<(f|0)){return F[c+25|0]}if(J[c+20>>1]>=2){return zh(a,b,c,1)|0}F[c+26|0]=1;return F[c+22|0]}function fI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;b=Ea-96|0;Ea=b;d=H[H[a>>2]+20>>2];e=H[d+120>>2];G[b+84>>1]=0;H[b+80>>2]=0;H[b+76>>2]=e;H[b+64>>2]=d;H[b+68>>2]=0;H[b+72>>2]=0;a:{b:{c:{d:{e:{f:{c=H[c>>2];switch(I[(J[c+16>>1]&63)+31056|0]-1|0){case 2:break c;case 3:break d;case 0:break e;case 1:break f;default:break b}}g=Db(c);M[b+16>>3]=g;c=b- -64|0;lb(c,12570,b+16|0);d=H[b+80>>2];if(!d){break a}e=H[b+68>>2];F[e+d|0]=0;Md(e,b+88|0,d,1);if(M[b+88>>3]==g){break a}Tf(c);M[b>>3]=g;lb(c,14839,b);break a}k=b,l=kb(c),H[k+32>>2]=l;H[b+36>>2]=Ha;lb(b- -64|0,14968,b+32|0);break a}j=fd(c);h=b- -64|0;d=xb(c);c=d>>31<<1|d>>>31;e=d<<1;f=e+4|0;c=f>>>0<4?c+1|0:c;pl(h,f,c);if(I[b+84|0]){break a}c=0;h=(d|0)>0?d:0;d=H[b+68>>2];while(1){if((c|0)!=(h|0)){f=d+(c<<1)|0;i=c+j|0;F[f+2|0]=I[(I[i|0]>>>4|0)+51824|0];F[f+3|0]=I[(I[i|0]&15)+51824|0];c=c+1|0;continue}break}c=d+e|0;F[c+2|0]=39;F[c+3|0]=0;F[d|0]=88;F[d+1|0]=39;H[b+80>>2]=e+3;break a}k=b,l=$a(c),H[k+48>>2]=l;lb(b- -64|0,19833,b+48|0);break a}sb(b- -64|0,20140,4)}qb(a,Jd(b- -64|0),H[b+80>>2],5);c=I[b+84|0];if(c){Rb(a);Xd(a,c)}Ea=b+96|0}function Xr(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Ea-32|0;Ea=h;a:{if(!c|H[b+4>>2]&33562624){break a}i=(e<<6)+d|0;if(I[(i+8|0)+36|0]&80){break a}b:{c:{if(H[b+52>>2]){f=b;while(1){if(f){d:{switch(I[f|0]-135|0){default:g=1;break;case 0:case 3:break d}}if(H[f+68>>2]){break b}f=H[f+52>>2];continue}break}if(!g){break c}g=b;while(1){if(!g){break c}j=H[g+28>>2];l=j+8|0;f=0;while(1){if(H[j>>2]>(f|0)){k=md(a,H[(f<<4)+l>>2]);if(H[k+12>>2]!=15?k:0){break b}f=f+1|0;continue}break}g=H[g+52>>2];continue}}f=H[b+68>>2];if(!f){break c}if(!H[f+8>>2]){break b}}f=0;if(H[b+60>>2]){break a}while(1){if(I[c|0]==44){f=Xr(a,b,H[c+16>>2],d,e)+f|0;c=H[c+12>>2];continue}break}if(!gr(c,d,e)){break a}H[b+4>>2]=H[b+4>>2]|16777216;d=f+1|0;while(1){if(!b){f=d;break a}g=jb(H[a>>2],c,0);Ai(g,-1,1);H[h+8>>2]=a;e=H[i+48>>2];H[h+20>>2]=0;H[h+16>>2]=e;H[h+12>>2]=e;H[h+24>>2]=H[b+28>>2];m=h,n=Lr(b),H[m+28>>2]=n;e=gh(h+8|0,g);e:{g=H[b+68>>2];if(!g){break e}if(nA(a,e,H[g+8>>2])){break e}eb(H[a>>2],e);break a}g=(H[b+4>>2]&8)+b|0;m=g,n=Td(a,H[g+36>>2],e),H[m+36>>2]=n;b=H[b+52>>2];continue}}f=0}Ea=h+32|0;return f}function WI(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;h=I[b|0];g=H[a>>2];a:{b:{c:{d=H[a+24>>2];if(!H[d+16>>2]){break c}if((h|0)!=167){break b}a=0;e=H[d+4>>2];f=H[e>>2];c=(f|0)>0?f:0;e=e+8|0;while(1){d:{if((a|0)!=(c|0)){if(H[b+28>>2]!=H[(e+(a<<6)|0)+40>>2]){break d}}else{a=c}if((a|0)==(f|0)){break b}break c}a=a+1|0;continue}}e:{f:{switch(h-167|0){case 5:if(!(F[b+7|0]&1)){break b}c=d;while(1){a=H[c>>2];if(!a){break e}c=a+36|0;f=1;if((a|0)!=H[b+44>>2]){continue}break};break a;case 2:case 3:case 4:break b;case 0:case 1:break e;default:break f}}if((h|0)!=179){break b}}f=2;a=H[g>>2];if(I[a+87|0]){break a}g:{h:{c=H[d+8>>2];if(c){a=0;while(1){if(H[c>>2]>(a|0)){if(!cc(0,H[((a<<4)+c|0)+8>>2],b,-1)){break h}a=a+1|0;c=H[d+8>>2];continue}break}a=H[g>>2]}a=jb(a,b,0);if(!(!a|I[a|0]!=168)){F[a|0]=172}c=Pb(g,H[d+8>>2],a);H[d+8>>2]=c;a=-1;e=1;break g}c=H[d+8>>2];e=0}if(c){c=H[b+4>>2];H[b+4>>2]=c|134217728;he(H[g>>2],b);b=Xa(b,0,52);F[b|0]=167;if(e){a=H[H[d+8>>2]>>2]-1|0}G[b+32>>1]=a;H[b+28>>2]=H[H[d>>2]+48>>2];a=H[d+12>>2];H[b+4>>2]=c&512;H[b+44>>2]=a}if(I[H[g>>2]+87|0]){break a}}f=0}return f|0}function Sp(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=Ea-16|0;Ea=g;a:{b:{c:{d:{e:{f=H[b>>2];if(!f){k=H[a+232>>2];break e}e=H[f+32>>2];j=H[f+16>>2];i=Lj(j,H[f+20>>2],c,d);h=d-i|0;if((h|0)<=0){d=267;break a}m=i>>31;l=(Rd(i,m)+(e+h|0)|0)+Rd(h,0)|0;k=H[a+232>>2];if((l|0)>(k|0)){if(j){break e}a=ub(l,l>>31);H[f+36>>2]=a;if(!a){break d}j=H[f+16>>2]}if(j){e=mc(H[f+36>>2]+e|0,i,m)+e|0}a=mc(H[f+36>>2]+e|0,h,0)+e|0;Va(a+H[f+36>>2]|0,c+i|0,h);H[f+32>>2]=a+h;H[f+12>>2]=H[f+12>>2]+1;e=H[f+28>>2];if(H[f+24>>2]<(d|0)){a=d<<1;e=Fc(e,a,d>>31<<1|d>>>31);if(!e){break d}H[f+28>>2]=e;H[f+24>>2]=a}H[f+16>>2]=e;Va(e,c,d);H[f+20>>2]=d;d=0;break a}e=ub(k+40|0,0);H[g+12>>2]=e;if(!e){break d}H[e>>2]=0;H[e+4>>2]=0;H[e+32>>2]=11;H[e+24>>2]=0;H[e+28>>2]=0;H[e+16>>2]=0;H[e+20>>2]=0;H[e+8>>2]=0;H[e+12>>2]=0;H[e+36>>2]=e+40;if(!f){break c}H[g+8>>2]=H[f>>2];d=Sp(a,g+8|0,c,d);a=H[g+8>>2];if(!H[f>>2]){H[f>>2]=a}H[f+4>>2]=e;c=H[f+8>>2];H[e>>2]=a;H[e+8>>2]=c;H[e+28>>2]=H[f+28>>2];H[e+24>>2]=H[f+24>>2];H[f+28>>2]=0;break b}d=7;break a}H[e+8>>2]=e;d=Sp(a,g+12|0,c,d);e=H[g+12>>2]}H[b>>2]=e}Ea=g+16|0;return d}function Ax(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Ea-48|0;Ea=h;H[h+40>>2]=0;H[h+44>>2]=0;H[h+32>>2]=0;H[h+36>>2]=0;H[h+24>>2]=0;H[h+28>>2]=0;H[h+20>>2]=b;H[h+16>>2]=d;H[h+8>>2]=0;H[f>>2]=0;H[g>>2]=0;i=(c>>31)+(e>>31)|0;j=c+e|0;i=j>>>0<e>>>0?i+1|0:i;j=j+17|0;i=j>>>0<17?i+1|0:i;i=ub(j,i);a:{if(!i){b=7;break a}H[h+12>>2]=i;j=b+c|0;pe(h+20|0,j,0,h+40|0);d=d+e|0;pe(h+16|0,d,0,h+32|0);b:{c:{while(1){e=H[h+20>>2];n=H[h+16>>2];if(!(e|n)){break c}d:{b=H[h+40>>2];c=H[h+32>>2];k=H[h+44>>2];m=H[h+36>>2];l=b>>>0>c>>>0&(k|0)>=(m|0)|(k|0)>(m|0)?1:(b|0)!=(c|0)|(k|0)!=(m|0)?-1:0;l=a?0-l|0:l;if(!(l|(!e|!n))){c=h+12|0;Ul(c,a,h+24|0,h+8|0,b,k);b=c;c=h+20|0;e=h+16|0;b=zx(b,c,e);if(b){break d}pe(c,j,a,h+40|0);pe(e,d,a,h+32|0);continue}if(!((e|0)!=0&(l|0)<0?0:n)){c=h+12|0;Ul(c,a,h+24|0,h+8|0,b,k);b=h+20|0;qe(c,b);pe(b,j,a,h+40|0);continue}b=h+12|0;Ul(b,a,h+24|0,h+8|0,c,m);c=b;b=h+16|0;qe(c,b);pe(b,d,a,h+32|0);continue}break}Ta(i);a=0;i=0;break b}a=H[h+12>>2];F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;b=0}H[f>>2]=i;H[g>>2]=a-i}Ea=h+48|0;return b}function mk(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Ea-32|0;Ea=g;yg(H[a+8>>2],c,b);a:{if(!(I[c+28|0]&64)){break a}d=73336;e=H[a+8>>2];if(!I[H[e>>2]+87|0]){d=(H[e+104>>2]+N(H[e+108>>2],20)|0)-20|0}b:{switch(I[d|0]-95|0){case 1:e=H[d+16>>2];d=0;while(1){h=e+f|0;if(!I[h|0]){break a}i=J[(H[c+4>>2]+N(d,12)|0)+10>>1];if(!(i&32)){if(i&64){F[h|0]=64}f=f+1|0}d=d+1|0;continue};case 0:break b;default:break a}}H[d+12>>2]=1}d=0;h=G[c+34>>1];e=(h|0)>0?h:0;while(1){if((d|0)!=(e|0)){i=H[c+4>>2]+N(d,12)|0;f=J[i+10>>1];if(f&96){G[i+10>>1]=f|128}d=d+1|0;continue}break}H[g+12>>2]=0;H[g+16>>2]=0;H[g+8>>2]=78;H[g+28>>2]=c;H[a+52>>2]=0-b;e=0;d=0;f=0;c:while(1){j=h<<16>>16;while(1){i=d;h=e;if((f|0)<(j|0)){d=H[c+4>>2]+N(f,12)|0;e=J[d+10>>1];d:{if(e&128){G[d+10>>1]=e|256;G[g+24>>1]=0;Jb(g+4|0,Mc(c,d));G[d+10>>1]=J[d+10>>1]&65279;if(I[g+24|0]&128){e=h;break d}wr(a,c,d,Gc(c,f<<16>>16)+b|0);G[d+10>>1]=J[d+10>>1]&65407;e=1}else{e=h}d=i}f=f+1|0;h=J[c+34>>1];continue c}if(i){e=0;d=0;f=0;if(h){continue}}break}break}if(i){H[g>>2]=H[i>>2];Wa(a,29314,g)}H[a+52>>2]=0;Ea=g+32|0}function Ss(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;d=Ea+-64|0;Ea=d;e=H[a+248>>2];a:{if(!e){break a}f=H[a>>2];Ts(a);H[a+264>>2]=0;if(H[e+44>>2]<=0){break a}if(!I[f+177|0]){c=H[a+128>>2];F[(c?c:a)+21|0]=1;if(b){H[a+204>>2]=H[b+4>>2]+(H[b>>2]-H[a+200>>2]|0)}H[d+48>>2]=a+200;c=mb(f,19031,d+48|0);b=H[f+16>>2];g=Fb(f,H[e+60>>2]);h=H[b+(g<<4)>>2];b=H[e>>2];H[d+32>>2]=H[a+96>>2];H[d+28>>2]=c;H[d+24>>2]=b;H[d+20>>2]=b;H[d+16>>2]=h;kc(a,16882,d+16|0);b=wb(a);Kf(a,g);Mb(b,166);h=H[e>>2];H[d+4>>2]=c;H[d>>2]=h;oh(b,g,mb(f,19523,d),0);Za(f,c);c=a;a=H[a+44>>2]+1|0;H[c+44>>2]=a;Nc(b,a,H[e>>2]);Sa(b,171,g,a);break a}j=H[e>>2];k=H[e+60>>2];b:{g=Hc(f+388|0,H[H[e+48>>2]>>2]);if(!g){break b}b=H[g>>2];if(!b|H[b>>2]<3|!H[b+92>>2]){break b}h=bb(H[e>>2]);b=H[e+60>>2]+16|0;while(1){b=H[b>>2];if(!b){break b}c=H[b+8>>2];if(I[c+43|0]|I[c+29|0]&16){continue}i=H[c>>2];if(yb(i,H[e>>2],h)){continue}i=h+i|0;if(I[i|0]!=95){continue}if(!(Ia[H[H[g>>2]+92>>2]](i+1|0)|0)){continue}H[c+28>>2]=H[c+28>>2]|4096;continue}}if(od(k+8|0,j,e)){Ib(f);break a}H[a+248>>2]=0}Ea=d- -64|0}function Ud(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=Ea-32|0;Ea=f;H[f>>2]=0;i=f;while(1){a:{b:{if(!b){break b}d=Nb(a,76,0);if(!d){break b}k=d,l=pc(a,H[b+28>>2],c),H[k+28>>2]=l;k=d,l=sh(a,H[b+32>>2],c),H[k+32>>2]=l;k=d,l=jb(a,H[b+36>>2],c),H[k+36>>2]=l;k=d,l=pc(a,H[b+40>>2],c),H[k+40>>2]=l;k=d,l=jb(a,H[b+44>>2],c),H[k+44>>2]=l;k=d,l=pc(a,H[b+48>>2],c),H[k+48>>2]=l;h=I[b|0];H[d+56>>2]=e;F[d|0]=h;H[d+52>>2]=0;e=jb(a,H[b+60>>2],c);H[d+8>>2]=0;H[d+12>>2]=0;H[d+60>>2]=e;e=H[b+4>>2];H[d+20>>2]=-1;H[d+24>>2]=-1;H[d+4>>2]=e&-33;G[d+2>>1]=J[b+2>>1];e=GA(a,H[b+64>>2]);H[d+68>>2]=0;H[d+64>>2]=e;e=H[b+72>>2];H[f+4>>2]=0;h=d+52|0;g=f+4|0;while(1){c:{if(!e){break c}j=g;g=FA(a,0,e);H[j>>2]=g;if(!g){break c}g=g+36|0;e=H[e+36>>2];continue}break}H[d+72>>2]=H[f+4>>2];e=I[a+87|0];d:{if(H[b+68>>2]){if(e&255){H[d+16>>2]=H[b+16>>2];break d}H[f+16>>2]=0;H[f+12>>2]=39;H[f+8>>2]=40;H[f+28>>2]=d;H[f+4>>2]=0;ec(f+4|0,d);e=I[a+87|0]}H[d+16>>2]=H[b+16>>2];if(!(e&255)){break a}}H[d+56>>2]=0;fc(a,d)}Ea=f+32|0;return H[f>>2]}H[i>>2]=d;b=H[b+52>>2];i=h;e=d;continue}}function Pt(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=Ea-32|0;Ea=d;f=H[a+4>>2];H[f+4>>2]=H[a>>2];a:{b:{c:{if(I[f+17|0]){Wp(f);Bh(a,4,d+24|0);g=H[d+24>>2];if(g>>>0>K[f+48>>2]){break b}h=H[16644];while(1){e=g;g=e+1|0;if((g|0)==(Qd(f,g)|0)|(e|0)==((h>>>0)/K[f+36>>2]|0)){continue}break}H[d+24>>2]=g;e=jf(f,d+12|0,d+16|0,g,1);H[d+20>>2]=e;if(e){break a}h=H[d+16>>2];d:{if((h|0)!=(g|0)){F[d+11|0]=0;H[d+4>>2]=0;e=hg(f,0,0);Eb(H[d+12>>2]);if(e){break a}e=qd(f,g,d+28|0,0);if(e){break a}e=_i(f,g,d+11|0,d+4|0);e:{i=I[d+11|0];f:{if((i-1&255)>>>0<=1){e=Ya(80106);break f}if(!e){break e}}Eb(H[d+28>>2]);break a}j=H[d+28>>2];e=Eo(f,j,i,H[d+4>>2],h,0);Eb(j);if(e){break a}e=qd(f,g,d+28|0,0);if(e){break a}h=H[d+28>>2];e=Vb(H[h+72>>2]);H[d+20>>2]=e;if(!e){break d}hf(h);break a}h=H[d+12>>2];H[d+28>>2]=h}Ad(f,g,1,0,d+20|0);e=H[d+20>>2];if(!e){e=$j(a,4,g);H[d+20>>2]=e;if(!e){break c}}Eb(h);break a}e=jf(f,d+28|0,d+24|0,1,0);H[d+20>>2]=e;if(e){break a}h=H[d+28>>2]}Jh(h,c&1?13:10);jd(H[h+72>>2]);H[b>>2]=H[d+24>>2];e=0;break a}e=Ya(80058)}Ea=d+32|0;return e}function Dh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;d=J[b+16>>1];f=J[a+16>>1];e=d|f;if(e&1){return(d&1)-(f&1)|0}a:{b:{c:{if(e&44){c=d&f;if(c&36){c=H[a>>2];d=H[b>>2];a=H[a+4>>2];b=H[b+4>>2];if(c>>>0<d>>>0&(a|0)<=(b|0)|(a|0)<(b|0)){break a}return c>>>0>d>>>0&(a|0)>=(b|0)|(a|0)>(b|0)}if(c&8){g=M[a>>3];h=M[b>>3];if(g<h){break a}return g>h}if(f&36){if(d&8){return Qi(H[a>>2],H[a+4>>2],M[b>>3])}c=-1;if(!(d&36)){break c}d=H[a>>2];f=H[b>>2];a=H[a+4>>2];b=H[b+4>>2];if(d>>>0<f>>>0&(a|0)<=(b|0)|(a|0)<(b|0)){break c}return d>>>0>f>>>0&(a|0)>=(b|0)|(a|0)>(b|0)}if(!(f&8)){break b}if(!(d&36)){break a}return 0-Qi(H[b>>2],H[b+4>>2],M[a>>3])|0}d:{if(!(e&2)){break d}if(!(f&2)){break b}if(!(d&2)){break a}if(!c){break d}return Bt(a,b,c,0)}d=H[b+12>>2];f=H[a+12>>2];c=J[b+16>>1];e=J[a+16>>1];e:{if((c|e)&1024){i=c;c=e&1024;e=H[a>>2]-H[b>>2]|0;if(i&c){break e}if(c){e=-1;if(!io(H[b+8>>2],d)){break e}e=H[a>>2]-d|0;break e}e=1;if(!io(H[a+8>>2],f)){break e}e=f-H[b>>2]|0;break e}a=Hb(H[a+8>>2],H[b+8>>2],(d|0)>(f|0)?f:d);e=a?a:f-d|0}c=e}return c}return 1}return-1}function Nr(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=H[a+8>>2];l=H[i+108>>2];j=H[a+56>>2]-1|0;H[a+56>>2]=j;if(f){m=_a(i,17,f);n=H[c+16>>2];k=H[c+12>>2];if(g){H[g>>2]=H[g>>2]+1}o=k;k=f+1|0;g=fb(i,90,o,k,n,g,-8)+2|0;Ua(i,14,g,j,g);g=H[i+108>>2];H[(I[H[i>>2]+87|0]?73336:H[i+104>>2]+N(m,20)|0)+8>>2]=g;Ua(i,80,H[c+12>>2],k,H[c+16>>2]-1|0);Sa(i,71,1,f)}if(I[H[a>>2]+87|0]){l=0}else{yi(i,H[b+12>>2],j);a:{b:{switch(I[d|0]-10|0){case 2:g=zb(a);f=zb(a);Ua(i,97,H[c+12>>2],H[c+16>>2],g);Sa(i,127,H[d+4>>2],f);Ua(i,128,H[d+4>>2],g,f);c=H[i+108>>2];if((c|0)>0){G[(H[i+104>>2]+N(c,20)|0)-18>>1]=8}rb(a,f);rb(a,g);break a;case 1:g=zb(a);f=H[c+16>>2];fb(i,97,H[c+12>>2],f,g,H[d+20>>2],f);gb(i,138,H[d+4>>2],g,H[c+12>>2],H[c+16>>2]);rb(a,g);break a;case 0:xi(a,H[c+12>>2],H[d+4>>2],H[c+16>>2]);break a;case 3:f=H[c+16>>2];g=H[d+12>>2];if(!g){g=nc(a,f);H[d+12>>2]=g;f=H[c+16>>2];H[d+16>>2]=f}xi(a,H[c+12>>2],g,f);_a(i,12,H[d+4>>2]);break a;default:break b}}Sa(i,84,H[c+12>>2],H[c+16>>2])}a=H[b+8>>2];if(a){Sa(i,61,a,h)}hb(i,j);_a(i,67,e)}return l}function Dy(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;h=c+d|0;f=c;while(1){a:{if(f>>>0<h>>>0){d=f+1|0;e=I[f|0];if(e>>>0<192){f=d;break a}e=I[e+32992|0];while(1){b:{if((d|0)==(h|0)){d=h}else{f=I[d|0];if((f&192)==128){break b}}f=d;e=(e&-2)==65534?65533:e>>>0<128?65533:(e&-2048)==55296?65533:e;break a}e=f&63|e<<6;d=d+1|0;continue}}c:{if(!g){break c}i=Fc(H[a+12>>2],H[a+8>>2]+g<<2,0);if(!i){return 7}f=H[a+8>>2];d:while(1){e:{if(c>>>0<h>>>0){d=c+1|0;e=I[c|0];if(e>>>0<192){c=d;break e}e=I[e+32992|0];while(1){f:{if((d|0)==(h|0)){c=h}else{c=I[d|0];if((c&192)==128){break f}c=d}e=(e&-2)==65534?65533:e>>>0<128?65533:(e&-2048)==55296?65533:e;break e}e=c&63|e<<6;d=d+1|0;continue}}H[a+8>>2]=f;H[a+12>>2]=i;break c}if((nq(e)|0)==(b|0)){continue}if(oq(e)){continue}d=0;g=(f|0)>0?f:0;while(1){g:{if((d|0)!=(g|0)){if(H[(d<<2)+i>>2]<(e|0)){break g}g=d}d=f;while(1){if((d|0)>(g|0)){j=(d<<2)+i|0;H[j>>2]=H[j-4>>2];d=d-1|0;continue}break}H[(g<<2)+i>>2]=e;f=f+1|0;continue d}d=d+1|0;continue}}}return 0}if((nq(e)|0)==(b|0)){continue}g=!oq(e)+g|0;continue}}function $l(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Ea-16|0;Ea=h;i=H[d>>2];a:{if(!i){i=1;g=a?-1:1;l=a?-1:0;H[h+4>>2]=b;c=b+c|0;a=0;while(1){if(b>>>0<c>>>0){a=zc(b,h+8|0)+b|0;H[h+4>>2]=a;b=H[h+8>>2];n=H[h+12>>2];qe(0,h+4|0);i=sJ(i,j,b,n);b=m+Ha|0;j=k;k=i+k|0;m=j>>>0>k>>>0?b+1|0:b;b=H[h+4>>2];while(1){if(!(I[b|0]|b>>>0>=c>>>0)){b=b+1|0;continue}break}H[h+4>>2]=b;i=g;j=l;continue}break}H[f>>2]=c-a;H[d>>2]=a;H[e>>2]=k;H[e+4>>2]=m;break a}j=i-2|0;while(1){if(!(b>>>0>j>>>0|F[j|0]>=0)){j=j-1|0;continue}break}i=j+1|0;zc(i,h+8|0);c=H[h+8>>2];l=0-c|0;k=a?c:l;l=k+H[e>>2]|0;m=H[h+12>>2];a=H[e+4>>2]+(a?m:0-(m+((c|0)!=0)|0)|0)|0;H[e>>2]=l;H[e+4>>2]=l>>>0<k>>>0?a+1|0:a;b:{if((b|0)!=(i|0)){e=-1;while(1){c:{a=e+j|0;if(a>>>0<=b>>>0){c=0;break c}e=e-1|0;c=I[a|0];if(!c){continue}}break}d:{e:{while(1){a=e+j|0;if(b>>>0<a>>>0){g=c<<24>>24;c=I[a|0];if(!(g|c&128)){break e}e=e-1|0;continue}break}if(c&255|(e|0)>-2){break d}}a=a+2|0}while(1){b=F[a|0];a=a+1|0;if((b|0)<0){continue}break}H[f>>2]=i-a;i=a;break b}F[g|0]=1}H[d>>2]=i}Ea=h+16|0}function Zn(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=Ea-4208|0;Ea=e;while(1){f=c;while(1){h=b+f|0;d=I[h|0];if(!(!d|(d|0)==47)){f=f+1|0;continue}break}a:{if((c|0)>=(f|0)){break a}g=f-c|0;b:{d=b+c|0;if(I[d|0]!=46){c=H[a+16>>2];break b}if((g|0)==1){break a}c=H[a+16>>2];if((g|0)!=2|I[d+1|0]!=46){break b}if((c|0)<2){break a}d=H[a+8>>2];while(1){c=c-1|0;H[a+16>>2]=c;if(I[c+d|0]!=47){continue}break}break a}if(H[a+12>>2]<=((c+g|0)+2|0)){H[a>>2]=1;break a}H[a+16>>2]=c+1;F[H[a+8>>2]+c|0]=47;Va(H[a+8>>2]+H[a+16>>2]|0,d,g);c=H[a+16>>2]+g|0;H[a+16>>2]=c;if(H[a>>2]){break a}F[c+H[a+8>>2]|0]=0;d=H[a+8>>2];if(Ia[H[16730]](d,e+4112|0)|0){if(H[18340]==44){break a}i=a,j=Id(ie(44627),3573,d,44627),H[i>>2]=j;break a}if((H[e+4116>>2]&61440)!=40960){break a}c=H[a+4>>2];H[a+4>>2]=c+1;c:{d:{if((c|0)>=201){c=ie(44633);break d}c=Ia[H[16727]](d,e,4096)|0;if(c-4096>>>0>4294963200){break c}c=Id(ie(44638),11870,d,44638)}H[a>>2]=c;break a}F[c+e|0]=0;H[a+16>>2]=I[e|0]!=47?H[a+16>>2]+(g^-1)|0:0;Zn(a,e)}c=f+1|0;if(I[h|0]){continue}break}Ea=e+4208|0}function Hq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=Ea+-64|0;Ea=c;H[c+32>>2]=c+52;H[c+36>>2]=c+48;a:{b:{if((xf(a,14823,c+32|0)|0)!=2){break b}c:{if(I[a+5|0]==58){H[c+16>>2]=c+44;d=1;if((xf(a+6|0,14843,c+16|0)|0)!=1){break a}d=a+8|0;f=0;if(I[a+8|0]!=46){break c}e=I[a+9|0];f=0;if(e-58>>>0<4294967286){break c}d=a+9|0;f=1;while(1){if(e-58>>>0>=4294967286){f=f*10;g=g*10+ +(e<<24>>24)+-48;e=I[d+1|0];d=d+1|0;continue}break}f=g/f;break c}d=a+5|0;H[c+44>>2]=0;f=0}F[b+43|0]=1;G[b+40>>1]=0;H[b+20>>2]=H[c+52>>2];H[b+24>>2]=H[c+48>>2];M[b+32>>3]=f+ +H[c+44>>2];while(1){a=d;d=a+1|0;if(F[I[a|0]+31152|0]&1){continue}break}H[b+28>>2]=0;h=-1;d:{e:{f:{g:{h:{e=I[a|0];switch(e-43|0){case 2:break f;case 0:break g;default:break h}}if((e&223)==90){break e}break d}h=1}H[c+4>>2]=c+56;H[c>>2]=c+60;if((xf(d,14831,c)|0)!=2){break b}e=H[c+56>>2]+N(H[c+60>>2],60)|0;H[b+28>>2]=N(e,h);d=a+6|0;i=(e|0)!=0}while(1){a=d;d=a+1|0;if(F[I[a|0]+31152|0]&1){continue}break}F[b+45|0]=1;e=I[a|0]}if(e){break b}F[b+44|0]=i;d=0;break a}d=1}Ea=c- -64|0;return d}function _y(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Ea-96|0;Ea=d;Xa(d+52|0,0,44);Ac(a);c=H[a>>2];f=c-947587585|0;e=H[a+4>>2];g=e-((c>>>0<947587585)+49596|0)|0;a:{if((g|0)==-500&f>>>0<=98047998|g>>>0<4294966796){c=Va(d,a,48);Ye(c);F[c+40|0]=0;e=H[c+8>>2];g=((e|0)%4|0)+2e3|0;H[c+8>>2]=g;Ac(c);c=tJ(H[c>>2],H[c+4>>2],1e3,0);f=Ha;e=(e-g|0)+1900|0;break a}c=vJ(c,e,1e3,0);f=Ha;e=1900}H[d>>2]=c-413362496;H[d+4>>2]=f-((c>>>0<413362496)+49|0);if(!(F[73924]&1)){ua(73908,73912,73936,73968);H[18480]=73968;H[18479]=73936;F[73924]=1}ha(H[d>>2],H[d+4>>2],73864);H[18476]=H[(H[18474]?73920:73916)>>2];c=73864;b:{c:{d:{if(H[16545]){f=H[16546];if(!f){break d}c=d+52|0;if(Ia[f|0](d,c)|0){break d}break c}break c}Gb(b,14322,-1);a=1;break b}Va(d+52|0,c,44);H[a+8>>2]=e+H[d+72>>2];H[a+12>>2]=H[d+68>>2]+1;H[a+16>>2]=H[d+64>>2];H[a+20>>2]=H[d+60>>2];H[a+24>>2]=H[d+56>>2];b=H[d+52>>2];F[a+46|0]=0;F[a+44|0]=0;H[a+40>>2]=16842752;h=a,i=(+(uJ(H[a>>2],H[a+4>>2],1e3,0)>>>0)+ +(Ha|0)*4294967296)*.001+ +(b|0),M[h+32>>3]=i;a=0}Ea=d+96|0;return a}function dA(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;l=H[b+80>>2];f=J[l+46>>1];h=H[l+32>>2];g=J[l+24>>1];o=g+d|0;k=H[a+44>>2];H[a+44>>2]=o+k;j=k+1|0;i=H[a+8>>2];d=H[a>>2];m=Tb(d,jh(d,h));a:{if(!f){f=0;break a}n=H[b+8>>2];d=0;Ua(i,75,0,j,f+k|0);_a(i,c?32:36,n);k=Mb(i,9);p=b,q=gb(i,c?21:24,n,0,j,f),H[p+20>>2]=q;h=H[i+108>>2];H[(I[H[i>>2]+87|0]?73336:H[i+104>>2]+N(k,20)|0)+8>>2]=h;while(1){if((d|0)==(f|0)){break a}Ua(i,94,n,d,d+j|0);d=d+1|0;continue}}k=f>>>0>g>>>0?f:g;while(1){if((f|0)!=(k|0)){g=H[H[l+52>>2]+(f<<2)>>2];h=f+j|0;d=Em(a,g,b,f,c,h);b:{if((d|0)==(h|0)){break b}if((o|0)==1){rb(a,j);j=d;break b}Sa(i,80,d,h)}d=J[g+12>>1];c:{d:{if(d&1){if(!(I[H[g>>2]+5|0]&16)|!m){break c}d=f+m|0;break d}if(d&256){break c}h=H[H[g>>2]+16>>2];e:{if(I[g+11|0]&8){break e}if(!af(h)){break e}Sa(i,50,f+j|0,H[b+12>>2])}if(H[a+36>>2]){break c}d=f+m|0;f:{if((ug(h,F[d|0])|0)!=65){g=I[d|0];break f}F[d|0]=65;g=65}if(!Dz(h,g<<24>>24)){break c}}F[d|0]=65}f=f+1|0;continue}break}H[e>>2]=m;return j}function EE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;if((b|0)==1){if((Kb(H[c>>2])|0)==5){Rb(a);return}e=Db(H[c>>2]);H[18340]=0;n=a;C(+e);a=x(1)|0;c=x(0)|0;a:{b:{c:{d:{if((a|0)<1048575|(a|0)<=1048575){d=-1/(e*e);if(e==0){break a}if((a|0)>0|(a|0)>=0){break d}d=(e-e)/0;break a}if(a>>>0>2146435071){break b}b=-1023;if((a|0)!=1072693248){break c}a=1072693248;if(c){break c}d=0;break a}b=-1077;C(+(e*0x40000000000000));a=x(1)|0;c=x(0)|0}a=a+614242|0;m=+((a>>>20|0)+b|0);h=m*.30102999566361177;d=h;z(0,c|0);z(1,(a&1048575)+1072079006|0);f=+B()+-1;i=f*(f*.5);j=f/(f+2);k=j*j;g=k*k;C(+(f-i));a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);l=+B();e=l*.4342944818781689;d=d+e;o=d;h=e+(h-d);d=j*(i+(g*(g*(g*.15313837699209373+.22222198432149784)+.3999999999940942)+k*(g*(g*(g*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+(f-l-i);e=o+(h+(d*.4342944818781689+(m*3694239077158931e-28+(d+l)*25082946711645275e-27)))}d=e}Sb(n,d);return}Y(23738,17858,473,17796);D()}function of(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;g=Ea-48|0;Ea=g;e=H[a>>2];a:{b:{if(!(I[e+24|0]&16)){if(ze(a)){break b}}f=yc(e,c,d);c:{if(!f){d:{e:{f:{if(I[e+177|0]|I[a+25|0]&4){break f}f=Hc(e+388|0,c);if(!f){if(yb(c,18222,7)){break f}f=bw(c+7|0);if(!f|!(I[f+5|0]&48)){break f}f=aw(e,c,35488,f,0);if(!f){break f}}i=H[f>>2];H[g+44>>2]=0;if(H[f+20>>2]){break d}h=H[a>>2];e=H[i+4>>2];if((e|0)!=H[i+8>>2]?e:0){break f}e=nb(h,64,0);if(!e){break f}j=Tb(h,H[f+4>>2]);H[e>>2]=j;if(j){break e}db(h,e)}if(b&2){break b}F[a+17|0]=1;break c}H[f+20>>2]=e;F[e+43|0]=1;H[e+24>>2]=1;b=H[H[h+16>>2]+12>>2];G[e+32>>1]=65535;H[e+60>>2]=b;H[e+28>>2]=H[e+28>>2]|32768;Qg(a,e,Tb(h,j));Qg(a,e,0);Qg(a,e,Tb(h,H[e>>2]));if(!np(h,e,f,H[i+8>>2],g+44|0)){break d}b=H[g+44>>2];H[g+32>>2]=b;Wa(a,8863,g+32|0);Za(h,b);Ep(h,f)}f=H[f+20>>2];break a}if(!(I[a+25|0]&4)|I[f+43|0]!=1){break a}}b=b&1?1754:14214;if(d){H[g+24>>2]=c;H[g+20>>2]=d;H[g+16>>2]=b;Wa(a,6405,g+16|0);break b}H[g+4>>2]=c;H[g>>2]=b;Wa(a,7774,g)}f=0}Ea=g+48|0;return f}function Yx(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0;k=Ea-16|0;Ea=k;while(1){a:{b:{c:{if(H[f>>2]){break c}d:{switch(H[c>>2]-2|0){case 2:break b;case 0:break c;case 3:break d;default:break a}}l=H[c+20>>2];r=l+72|0;c=0;e:while(1){if(H[l+64>>2]<=(m|0)|c){break c}g=H[d>>2];H[d>>2]=g+24;H[g+12>>2]=b;H[g+4>>2]=m;H[g>>2]=l;c=N(m,24)+r|0;H[g+8>>2]=c;H[g+20>>2]=H[l+68>>2];o=H[c+20>>2];p=H[a>>2];q=H[p+244>>2];c=0;e=0;n=0;while(1){f:{g:{if(!(H[o+4>>2]<=(e|0)|c)){h=H[H[o>>2]+(e<<2)>>2];if(H[h+56>>2]|I[h+5|0]){break g}j=H[h+8>>2];i=H[h+12>>2];while(1){c=H[h+20>>2];if(K[h+16>>2]<j>>>0&(c|0)<=(i|0)|(c|0)<(i|0)){break g}c=_g(p,j,i,0,k+12|0);if(c){break f}c=H[k+12>>2];if((c+35|0)>(q|0)){n=((c+34|0)/(q|0)|0)+n|0}j=j+1|0;i=j?i:i+1|0;continue}}H[g+16>>2]=n;H[f>>2]=c;m=m+1|0;continue e}c=0}e=e+1|0;continue}}}Ea=k+16|0;return}b=H[c+12>>2];H[H[e>>2]>>2]=b;H[e>>2]=H[e>>2]+4}Yx(a,b,H[c+12>>2],d,e,f);if(H[c>>2]==4){b=H[c+16>>2];H[H[e>>2]>>2]=b;H[e>>2]=H[e>>2]+4}c=H[c+16>>2];continue}}function mC(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;d=F[b|0];i=d&255;a:{if((d|0)>=0){g=b;break a}i=i&127;while(1){d=f+1|0;g=d+b|0;e=F[g|0];i=e&127|i<<7;if(f>>>0>6){break a}f=d;if((e|0)<0){continue}break}}e=F[g+1|0];d=e&255;f=0;h=g+1|0;b:{if((e|0)>=0){break b}f=d>>>25|0;e=F[g+2|0];d=e&255^d<<7;if((e|0)<0){f=f<<7|d>>>25;e=F[g+3|0];d=e&255^d<<7;if((e|0)<0){f=f<<7|d>>>25;e=F[g+4|0];d=e&255^d<<7^270548992;h=g+4|0;if((e|0)>=0){break b}f=f<<7|d>>>25;e=F[g+5|0];d=e&255^d<<7^16384;h=g+5|0;if((e|0)>=0){break b}f=f<<7|d>>>25;e=F[g+6|0];d=e&255^d<<7^16384;h=g+6|0;if((e|0)>=0){break b}f=f<<7|d>>>25;e=F[g+7|0];d=e&255^d<<7^16384;h=g+7|0;if((e|0)>=0){break b}f=f<<7|d>>>25;e=F[g+8|0];d=e&255^d<<7^16384;h=g+8|0;if((e|0)>=0){break b}f=f<<8|d>>>24;d=(I[g+9|0]|d<<8)^32768;h=g+9|0;break b}d=d^2113536;h=g+3|0;break b}d=d&16383;f=0;h=g+2|0}e=h;H[c+12>>2]=i;H[c>>2]=d;H[c+4>>2]=f;f=e+1|0;H[c+8>>2]=f;if(J[a+14>>1]>=i>>>0){G[c+16>>1]=i;a=(f-b|0)+i|0;G[c+18>>1]=a&65532?a:4;return}Fu(a,b,c)}function Gt(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;i=Ea-16|0;Ea=i;H[b+4>>2]=a;c=H[b>>2];l=(c|0)>0?c:0;a:{while(1){if((h|0)!=(l|0)){k=H[b+12>>2]+N(h,56)|0;d=H[k+48>>2];if(d){e=H[d>>2];f=H[H[e+12>>2]+24>>2];c=Gt(e,H[d+4>>2]);if(c){break a}g=H[d+16>>2];m=g>>31;c=H[e+64>>2];b:{if(c){j=H[e+76>>2];f=H[e+72>>2];break b}c=f;f=e- -64|0;c=jt(c,f);H[e+72>>2]=0;H[e+76>>2]=0;if(c){break a}c=H[f>>2];j=0;f=0}H[d+8>>2]=f;H[d+12>>2]=j;H[d+48>>2]=c;c=j+m|0;d=f+g|0;c=d>>>0<f>>>0?c+1|0:c;H[e+72>>2]=d;H[e+76>>2]=c;c=Wn(k);if(c){break a}}h=h+1|0;continue}break}c=H[b>>2];while(1){if((c|0)>=2){e=c-1|0;d=c;c=H[b>>2]/2|0;c:{if((d|0)>(c|0)){d=e-c<<1;c=d|1;break c}c=H[b+8>>2]+(e<<3)|0;d=H[c>>2];c=H[c+4>>2]}g=H[b+12>>2];f=g+N(d,56)|0;d:{if(!H[f+24>>2]){break d}g=g+N(c,56)|0;if(!H[g+24>>2]){c=d;break d}h=H[b+4>>2];H[i+12>>2]=0;c=(Ia[H[h+40>>2]](h,i+12|0,H[f+32>>2],H[f+20>>2],H[g+32>>2],H[g+20>>2])|0)<=0?d:c}H[H[b+8>>2]+(e<<2)>>2]=c;c=e;continue}break}c=I[H[a+16>>2]+23|0]}Ea=i+16|0;return c}function md(a,b){var c=0,d=0,e=0,f=0,g=0;f=H[a>>2];a:{b:while(1){c=b;d=0;if(!c){break a}c:{b=I[c|0];if((b|0)==176){b=I[c+2|0]}d:{e:{f:{g:{h:{b=b&255;switch(b-174|0){case 0:break e;case 1:case 2:break f;case 3:break g;default:break h}}i:{j:{switch(b-167|0){default:if((b|0)==36){break e}if((b|0)==77){break i}if((b|0)!=113){break f}c=Nn(a,I[f+84|0],0,H[c+8>>2]);break c;case 0:break i;case 2:break j;case 1:break f}}if(!H[c+44>>2]){break f}}b=G[c+32>>1];d=0;if((b|0)<0){break a}c=nf(f,I[f+84|0],Yf(H[H[c+44>>2]+4>>2]+N(b,12)|0),0);break c}b=H[c+20>>2]+8|0;break d}e=H[c+4>>2];d=0;if(!(e&512)){break a}b=H[c+12>>2];if(I[b+5|0]&2?b:0){continue}d=H[c+16>>2];b=d;if(e&4096){continue}e=H[c+20>>2];if(I[f+87|0]|!e){continue}c=0;b=H[e>>2];g=(b|0)>0?b:0;e=e+8|0;while(1){if((c|0)==(g|0)){b=d;continue b}b=c<<4;c=c+1|0;b=H[b+e>>2];if(!(I[b+5|0]&2)){continue}break}continue}b=c+12|0}b=H[b>>2];continue}break}d=0;if(!c){break a}if(H[c+12>>2]){return c}d=Nn(a,I[H[a>>2]+84|0],c,H[c>>2])?c:0}return d}function bI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0,v=0,w=0;s=H[H[a>>2]+20>>2];a:{k=$a(H[c>>2]);if(!k){break a}i=xb(H[c>>2]);l=$a(H[c+4>>2]);if(!l){break a}if(!I[l|0]){qb(a,k,i,-1);return}j=xb(H[c+4>>2]);q=$a(H[c+8>>2]);if(!q){break a}m=xb(H[c+8>>2]);f=i+1|0;g=f>>31;b=ch(a,f,g);if(!b){break a}t=j-1|0;u=i-j|0;n=i^-1;v=n>>31;o=m-j|0;w=o>>31;c=0;while(1){b:{c:{d:{if((c|0)<=(u|0)){e:{d=c+k|0;e=I[d|0];if((e|0)==I[l|0]){if(!Hb(d,l,j)){break e}}F[b+h|0]=e;h=h+1|0;break b}if((j|0)>=(m|0)){break d}d=H[s+120>>2];e=d;d=d>>31;g=g+w|0;f=f+o|0;g=f>>>0<o>>>0?g+1|0:g;p=f-1>>>0>e>>>0;e=g-!f|0;if(p&(e|0)>=(d|0)|(d|0)<(e|0)){Ug(a);Ta(b);return}d=r;r=d+1|0;if(r&d){break d}d=g+v|0;e=f+n|0;d=(f>>31)+(e>>>0<n>>>0?d+1|0:d)|0;p=e;e=e+f|0;d=p>>>0>e>>>0?d+1|0:d;d=Ld(b,e,d);if(d){break c}Ub(a);Ta(b);return}d=c+k|0;c=i-c|0;Va(b+h|0,d,c);c=c+h|0;F[c+b|0]=0;qb(a,b,c,1);break a}d=b}Va(d+h|0,q,m);c=c+t|0;b=d;h=h+m|0}c=c+1|0;continue}}}function Fp(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;a:{b:{c=Ej(a)&2047;e=Ej(5551115123125783e-32);if(c-e>>>0<Ej(512)-e>>>0){h=c;break b}if(c>>>0<e>>>0){return a+1}if(Ej(1024)>>>0>c>>>0){break b}C(+a);e=x(1)|0;b=0;if(!(x(0)|0)&(e|0)==-1048576){break a}if(Ej(Infinity)>>>0<=c>>>0){return a+1}if((e|0)<0){return Nw(12882297539194267e-247)}return Nw(3105036184601418e216)}b=M[7255];f=M[7254]*a+b;b=f-b;a=b*M[7257]+(b*M[7256]+a);b=a*a;g=b*b*(a*M[7261]+M[7260]);b=b*(a*M[7259]+M[7258]);C(+f);x(1)|0;c=x(0)|0;d=c<<4&2032;a=g+(b+(M[d+58144>>3]+a));d=d+58152|0;e=0+H[d>>2]|0;d=H[d+4>>2]+(c<<13)|0;d=e>>>0<i>>>0?d+1|0:d;if(!h){c:{if(!(c&-2147483648)){z(0,e|0);z(1,d-1058013184|0);b=+B();a=(b*a+b)*5486124068793689e288;break c}z(0,e|0);z(1,d+1071644672|0);b=+B();f=b*a;a=f+b;if(a<1){c=Ea-16|0;H[c+8>>2]=0;H[c+12>>2]=1048576;M[c+8>>3]=M[c+8>>3]*22250738585072014e-324;g=a+1;a=g+(f+(b-a)+(a+(1-g)))+-1;a=a==0?0:a}a=a*22250738585072014e-324}return a}z(0,e|0);z(1,d|0);b=+B();b=b*a+b}return b}function Xq(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;g=Ea-16|0;Ea=g;j=(H[b+8>>2]|H[b>>2])^-1;k=(H[b+12>>2]|H[b+4>>2])^-1;e=H[a+24>>2];h=H[a+20>>2];while(1){if((h|0)>0){d=H[e+40>>2];f=H[e+44>>2];a:{if(j&d|k&f|(!(d&H[b+8>>2]|f&H[b+12>>2])|I[e+10|0]&2)){break a}d=J[b+44>>1];while(1){if(d){d=d-1|0;f=H[H[b+52>>2]+(d<<2)>>2];if(!f){continue}if((e|0)==(f|0)){break a}f=H[f+16>>2];if((f|0)<0|(H[a+24>>2]+N(f,48)|0)!=(e|0)){continue}break a}break}Km(H[H[a>>2]>>2]);b:{if(H[b+8>>2]!=H[e+40>>2]|H[b+12>>2]!=H[e+44>>2]){break b}if(!(I[e+12|0]&63)){if(I[(H[H[a>>2]+4>>2]+(I[b+16|0]<<6)|0)+44|0]&72){break b}}H[b+40>>2]=H[b+40>>2]|8388608}d=J[b+22>>1];f=G[e+8>>1];if((f|0)<=0){G[b+22>>1]=d+f;break a}G[b+22>>1]=d-1;if(!(I[e+12|0]&130)){break a}d=H[H[e>>2]+16>>2];H[g+12>>2]=0;d=Ff(d,g+12|0);d=d?H[g+12>>2]+1>>>0<3?10:20:20;if(d>>>0<=(i&65535)>>>0){break a}G[e+10>>1]=J[e+10>>1]|8192;i=d}e=e+48|0;h=h-1|0;continue}break}a=c-(i&65535)|0;if((a|0)<G[b+22>>1]){G[b+22>>1]=a}Ea=g+16|0}function od(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=Ea-16|0;Ea=f;e=dt(a,b,f+12|0);d=H[e+8>>2];a:{if(d){if(!c){g=H[f+12>>2];c=H[e+4>>2];b=H[e>>2];H[(c?c:a+8|0)>>2]=b;if(b){H[b+4>>2]=c}c=H[a+12>>2];if(c){c=c+(g<<3)|0;if((e|0)==H[c+4>>2]){H[c+4>>2]=b}H[c>>2]=H[c>>2]-1}Ta(e);b=H[a+4>>2]-1|0;H[a+4>>2]=b;if(b){break a}qf(a);break a}H[e+12>>2]=b;H[e+8>>2]=c;break a}if(!c){d=0;break a}e=bc(16,0);if(!e){d=c;break a}H[e+8>>2]=c;H[e+12>>2]=b;c=H[a+4>>2]+1|0;H[a+4>>2]=c;b:{if(c>>>0<10){break b}d=H[a>>2];if(c>>>0<=d<<1>>>0){break b}c=c<<4>>>0>1024?128:c<<1;if((c|0)==(d|0)){break b}d=H[18327];if(d){Ia[d|0]()}c=bc(c<<3,0);d=H[18328];if(d){Ia[d|0]()}if(!c){break b}Ta(H[a+12>>2]);H[a+12>>2]=c;d=Ia[H[16491]](c)|0;g=d>>>3|0;H[a>>2]=g;h=Xa(c,0,d&-8);c=H[a+8>>2];H[a+8>>2]=0;while(1){if(c){d=H[c>>2];ct(a,((Un(H[c+12>>2])>>>0)%(g>>>0)<<3)+h|0,c);c=d;continue}break}i=f,j=(Un(b)>>>0)%K[a>>2]|0,H[i+12>>2]=j}d=0;b=a;a=H[a+12>>2];ct(b,a?a+(H[f+12>>2]<<3)|0:0,e)}Ea=f+16|0;return d}function Zx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;a:{while(1){if(H[e>>2]|!b){break a}b:{f=H[b>>2];if((f|0)==5){d=c;f=H[c>>2];c=H[H[b+20>>2]+64>>2];H[d>>2]=f+c;o=(c|0)>0?c:0;while(1){c=H[b+20>>2];if((m|0)==(o|0)){break b}j=c+N(m,24)|0;n=H[j+80>>2];i=H[j+76>>2];l=H[j+72>>2];g=lc(64);c:{if(!g){H[j+92>>2]=0;h=7;break c}f=H[a>>2];d:{e:{if(!n){break e}h=7;k=0;c=1;d=1;while(1){f:{if(!k){if(H[f+260>>2]>(d|0)){break f}c=0}d=1;k=i+1|0;while(1){if(c){break d}if(H[f+260>>2]<=(d|0)){break e}c=0;g:{if((k|0)!=H[H[f+264>>2]+N(d,24)>>2]){break g}c=1;h=hi(f,H[a+20>>2],d,-2,l,i,1,0,g);if(h){break g}h=vy(f,H[a+20>>2],0,-2,l,i,0,0,g)}d=d+1|0;continue}}k=0;if(H[H[f+264>>2]+N(d,24)>>2]==(i|0)){h=hi(f,H[a+20>>2],d,-2,l,i,0,0,g);H[g+44>>2]=1;k=1}d=d+1|0;continue}}h=hi(f,H[a+20>>2],0,-2,l,i,n,0,g);H[g+44>>2]=!n}H[j+92>>2]=g;m=m+1|0;if(!h){continue}}break}H[e>>2]=h;return}H[d>>2]=H[d>>2]+((f|0)==4);Zx(a,H[b+12>>2],c,d,e);b=H[b+16>>2];continue}break}H[c+44>>2]=-1}}function Sl(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0;e=Ea-16|0;Ea=e;h=H[a+28>>2];H[e+12>>2]=0;H[e+8>>2]=0;H[e+4>>2]=0;b=H[a+16>>2];c=H[a+20>>2];if(!(!h|!(b|c))){b=b+1|0;c=b?c:c+1|0;H[a+16>>2]=b;H[a+20>>2]=c}c=H[a+8>>2];d=H[a+4>>2];a:{if((c|0)>=(d|0)){c=0;H[a>>2]=0;break a}g=H[a>>2];if(h){f=c+g|0;b=F[f|0];b:{if((b|0)<0){b=qc(f,e+12|0);break b}H[e+12>>2]=b;b=1}c=b+c|0;H[a+8>>2]=c}f=c+g|0;b=F[f|0];c:{if((b|0)<0){b=qc(f,e+8|0);break c}H[e+8>>2]=b;b=1}b=b+c|0;H[a+8>>2]=b;c=267;g=H[e+12>>2];if((g|0)>(h|0)){break a}b=d-b|0;d=H[e+8>>2];if((b|0)<(d|0)|!d){break a}f=d+g|0;Zd(a+24|0,f,e+4|0);c=H[e+4>>2];if(c){break a}c=0;b=H[a+24>>2];if(!b){break a}Va(b+g|0,H[a>>2]+H[a+8>>2]|0,d);H[a+28>>2]=f;f=d+H[a+8>>2]|0;H[a+8>>2]=f;if(H[a+16>>2]|H[a+20>>2]){break a}c=H[a>>2]+f|0;d=F[c|0];d:{if((d|0)<0){c=qc(c,a+40|0);d=H[a+40>>2];f=H[a+8>>2];break d}H[a+40>>2]=d;c=1}b=c+f|0;H[a+8>>2]=b;c=267;if((H[a+4>>2]-b|0)<(d|0)){break a}H[a+8>>2]=b+d;H[a+36>>2]=b+H[a>>2];c=0}Ea=e+16|0;return c}function FH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;b=Ea-336|0;Ea=b;f=H[H[a>>2]+20>>2];d=$a(H[c>>2]);g=$a(H[c+4>>2]);i=H[f+364>>2];H[f+364>>2]=0;ye(f);if(!(!d|!g)){h=b+52|0;d=ak(h,d,f,g,0);a:{if(!d){H[b+40>>2]=0;H[b+44>>2]=0;H[b+48>>2]=0;H[b+24>>2]=0;H[b+32>>2]=0;H[b+36>>2]=0;H[b+16>>2]=0;H[b+20>>2]=0;H[b+12>>2]=92;H[b+8>>2]=96;H[b+28>>2]=b+32;H[b+4>>2]=h;d=H[b+300>>2];b:{c:{if(d){if(I[d+43|0]==2){e=H[d+44>>2];H[e+4>>2]=H[e+4>>2]&-2097153;H[b+64>>2]=0;ee(h,e,0);d=I[f+87|0]?7:H[b+64>>2];if(d){break b}ec(b+4|0,e);break c}hc(b+4|0,H[d+16>>2]);d=0;while(1){e=H[b+300>>2];if(G[e+34>>1]<=(d|0)){break c}Jb(b+4|0,Mc(e,H[e+4>>2]+N(d,12)|0));d=d+1|0;continue}}d=H[b+304>>2];if(d){e=b+4|0;hc(e,H[d+40>>2]);Jb(e,H[H[b+304>>2]+36>>2]);break c}d=sm(b+52|0);if(d){break b}Nq(b+4|0,H[b+308>>2])}d=Mq(a,b+32|0,g,0,0)}rm(f,H[b+32>>2]);if(!d){break a}}if(!((d|0)!=1|(H[f+32>>2]&268435457)!=1)){Be(a,H[c+4>>2]);break a}Xd(a,d)}_j(b+52|0)}H[f+364>>2]=i;Ea=b+336|0}function Px(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;i=Ea-16|0;Ea=i;a:{if(H[a>>2]){break a}j=H[b+24>>2]+2|0;g=ub(sJ(j,j>>31,14,0),Ha);if(!g){H[a>>2]=7;break a}f=Lb(b,22,i+4|0,0);if(f){Ta(g);H[a>>2]=f;break a}k=H[i+4>>2];Cb(k,1,0,0);b:{if((vb(k)|0)==100){l=Ue(k,0);f=0;c:{m=Nd(k,0);if(!m|F[(l+m|0)-1|0]<0){break c}while(1){if((f|0)>=(j|0)|(h|0)>=(m|0)){break c}n=zc(h+l|0,i+8|0);H[(f<<2)+g>>2]=H[i+8>>2];f=f+1|0;h=h+n|0;continue}}h=(f|0)>(j|0)?f:j;while(1){if((f|0)==(h|0)){break b}H[(f<<2)+g>>2]=0;f=f+1|0;continue}}Xa(g,0,j<<2)}f=ob(k);if(f){Ta(g);H[a>>2]=f;break a}k=(j<<2)+g|0;f=H[g>>2];h=f+e|0;H[g>>2]=(e|0)<0?f>>>0>=0-e>>>0?h:0:h;f=0;while(1){if((f|0)<=H[b+24>>2]){e=f<<2;f=f+1|0;h=(f<<2)+g|0;l=H[e+c>>2]+H[h>>2]|0;e=l-H[d+e>>2]|0;H[h>>2]=e>>>0<=l>>>0?e:0;continue}break}sx(j,g,k,i+8|0);b=Lb(b,23,i+4|0,0);if(b){Ta(g);H[a>>2]=b;break a}b=H[i+4>>2];Cb(b,1,0,0);dg(b,2,k,H[i+8>>2],0);vb(b);o=a,p=ob(b),H[o>>2]=p;Ae(b,1);Ta(g)}Ea=i+16|0}function aD(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0,f=0,g=0,h=0,i=0;e=5130;a:{f=H[a+36>>2];if(!f){break a}g=H[f>>2];if(!g){break a}h=b+c|0;i=(1<<h)+(-1<<b)|0;g=g+36|0;b:{c:{d:{e:{f:{g:{if(d&1){e=J[f+10>>1];if((e|J[f+12>>1])&i){break g}}e=0;switch(d-6|0){case 0:break e;case 4:break f;default:break a}}h:{if(!(d&4)){break h}d=g+(b<<2)|0;h=H[d>>2];if((h|0)<2){break h}H[d>>2]=h-1;G[f+10>>1]=e&(i^-1);break b}e=cj(a,2,b+120|0,c);if(e){break a}Xa(g+(b<<2)|0,0,c<<2);a=i^-1;G[f+10>>1]=a&J[f+10>>1];G[f+12>>1]=a&J[f+12>>1];return 0}d=(b|0)>(h|0)?b:h;e=b;while(1){if((d|0)!=(e|0)){h=e<<2;e=e+1|0;if(!H[g+h>>2]){continue}break d}break}e=cj(a,1,b+120|0,c);if(e){break a}G[f+12>>1]=J[f+12>>1]|i;while(1){if((b|0)==(d|0)){break b}H[g+(b<<2)>>2]=-1;b=b+1|0;continue}}d=J[f+10>>1];if(d&i){break a}g=g+(b<<2)|0;e=H[g>>2];if((e|0)>=0){break c}}return 5}if(!e){e=cj(a,0,b+120|0,c);if(e){break a}e=H[g>>2];d=J[f+10>>1]}G[f+10>>1]=d|i;H[g>>2]=e+1}return 0}return e|0}function mt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0,t=0,u=0;k=H[d+64>>2];e=H[d+52>>2];n=H[H[e>>2]+224>>2];l=H[d+56>>2];h=l+I[d+9|0]|0;f=I[h+5|0]<<8|I[h+6|0];e=H[e+40>>2];f=e>>>0>=f>>>0?f:0;o=f+l|0;Va(n+f|0,o,e-f|0);p=a+40|0;s=b+c|0;f=e+l|0;while(1){if(!((j|0)==6|H[(j<<2)+p>>2]>(b|0))){j=j+1|0;continue}break}t=a+16|0;e=f;while(1){g=j<<2;u=g+p|0;q=H[g+t>>2];a:{while(1){g=H[H[a+8>>2]+(b<<2)>>2];m=J[H[a+12>>2]+(b<<1)>>1];i=g+m|0;b:{c:{if(!(g>>>0<o>>>0|f>>>0<=g>>>0)){if(f>>>0>=i>>>0){break c}return Ya(77664)}if(i>>>0<=q>>>0|g>>>0>=q>>>0){break b}return Ya(77669)}g=(g-l|0)+n|0}e=e-m|0;i=e-l|0;r=i<<8|(i&65280)>>>8;F[k|0]=r;F[k+1|0]=r>>>8;k=k+2|0;if(k>>>0>e>>>0){return Ya(77675)}Ic(e,g,m);b=b+1|0;if((s|0)<=(b|0)){break a}if(H[u>>2]>(b|0)){continue}break}j=j+1|0;continue}break}F[d+12|0]=0;G[d+24>>1]=c;F[h+1|0]=0;F[h+2|0]=0;F[h+3|0]=I[d+25|0];a=I[d+24|0];F[h+7|0]=0;F[h+6|0]=i;F[h+5|0]=i>>>8;F[h+4|0]=a;return 0}function HH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;b=Ea-320|0;Ea=b;d=H[H[a>>2]+20>>2];j=$a(H[c>>2]);l=$a(H[c+4>>2]);g=kb(H[c+16>>2]);h=H[d+32>>2];m=$a(H[c+20>>2]);f=kb(H[c+24>>2]);n=H[d+364>>2];H[d+364>>2]=0;if(!(!j|!l)){e=H[d+32>>2];i=H[d+36>>2];if(f){H[d+32>>2]=e&-1610612737;H[d+36>>2]=i}k=b+36|0;g=ak(k,j,d,l,g);f=H[d+36>>2];H[d+32>>2]=H[d+32>>2]|e&1610612736;H[d+36>>2]=f;i=1;a:{b:{if(g){break b}e=0;g=e;c:{h=h&67108864;if(e|h){break c}e=H[b+284>>2];if(!e|I[e+43|0]!=2){break c}H[b+28>>2]=0;H[b+32>>2]=0;H[b+20>>2]=0;H[b+24>>2]=0;H[b+12>>2]=0;H[b+16>>2]=0;H[b+4>>2]=0;H[b+8>>2]=0;H[b>>2]=k;ee(k,H[e+44>>2],b);i=H[b+72>>2]!=0&H[b+48>>2]!=0;break b}f=H[b+292>>2];if(!f){break a}e=d;if(!(g|h)){if(sm(b+36|0)){break b}f=H[b+292>>2]}if((Fb(e,H[f+24>>2])|0)!=(Bg(d,j)|0)){break a}uc(a,1);break a}if(!i|!m|(H[d+32>>2]&268435457)==1){break a}Lq(a,m,H[c+8>>2],H[c+12>>2],b+36|0)}_j(b+36|0)}H[d+364>>2]=n;Ea=b+320|0}function Cp(a){var b=0,c=0,d=0,e=0,f=0,g=0;C(+a);e=x(1)|0;x(0)|0;d=e&2147483647;if(d>>>0>=1141899264){C(1.5707963267948966);e=x(1)|0;d=x(0)|0;C(+a);b=x(1)|0;x(0)|0;z(0,d|0);z(1,e&2147483647|b&-2147483648);g=+B();C(+a);b=x(1)|0;e=x(0)|0;b=b&2147483647;return(b|0)==2146435072&(e|0)!=0|b>>>0>2146435072?a:g}a:{b:{if(d>>>0<=1071382527){b=-1;if(d>>>0>=1044381696){break b}break a}a=P(a);if(d>>>0<=1072889855){if(d>>>0<=1072037887){a=(a+a+-1)/(a+2);b=0;break b}a=(a+-1)/(a+1);b=1;break b}if(d>>>0<=1073971199){a=(a+-1.5)/(a*1.5+1);b=2;break b}a=-1/a;b=3}f=a*a;c=f*f;g=c*(c*(c*(c*(c*-.036531572744216916+-.058335701337905735)+-.0769187620504483)+-.11111110405462356)+-.19999999999876483);f=f*(c*(c*(c*(c*(c*.016285820115365782+.049768779946159324)+.06661073137387531)+.09090887133436507)+.14285714272503466)+.3333333333333293);if(d>>>0<=1071382527){return a-a*(g+f)}b=b<<3;a=M[b+62432>>3]-(a*(g+f)-M[b+62464>>3]-a);a=(e|0)<0?-a:a}return a}function Vb(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=H[a+20>>2];if(!(!(I[a+28|0]&4)|K[b+28>>2]<K[a+24>>2])){if(!H[b+104>>2]){return 0}return fm(a)}c=H[b+44>>2];if(!c){if(K[b+156>>2]>K[b+168>>2]){i=Ea-16|0;Ea=i;d=H[a+20>>2];F[d+21|0]=I[d+21|0]|4;e=H[a+24>>2];c=tJ(H[d+156>>2],0,H[d+168>>2],H[d+172>>2]);g=e-1&0-c;b=H[d+28>>2];if(b>>>0<e>>>0){c=e-g|0}else{c=b>>>0<c+g>>>0?b-g|0:c}g=g+1|0;while(1){if(!((c|0)<=(f|0)|h)){a:{b:{b=f+g|0;if((b|0)!=H[a+24>>2]){if(Cv(H[d+60>>2],b)){break b}}h=0;if((b|0)==H[d+164>>2]){break a}h=Ia[H[d+220>>2]](d,b,i+12|0,0)|0;if(h){break a}h=Ky(H[i+12>>2]);e=H[i+12>>2];b=J[e+28>>1];Af(e);j=b&8?1:j;break a}e=Lh(d,b);H[i+12>>2]=e;h=0;if(!e){break a}b=J[e+28>>1];Af(e);j=b&8?1:j}f=f+1|0;continue}break}c:{if(!j|h){break c}f=0;a=(c|0)>0?c:0;while(1){if((a|0)==(f|0)){break c}c=Lh(d,f+g|0);if(c){G[c+28>>1]=J[c+28>>1]|8;Af(c)}f=f+1|0;continue}}F[d+21|0]=I[d+21|0]&251;Ea=i+16|0;return h}c=Ky(a)}return c}function vz(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0,n=0,o=0;i=Ea-48|0;Ea=i;l=H[a>>2];m=wb(a);if((h|0)<0){o=Sa(m,49,I[e+24|0],0)}n=e+36|0;while(1){if((j|0)<H[e+20>>2]){k=Td(a,k,ib(a,53,Rq(a,c,g,(d?J[H[d+4>>2]+(j<<1)>>1]:65535)<<16>>16),oc(l,59,H[H[H[e>>2]+4>>2]+N(G[(f?(j<<2)+f|0:n)>>1],12)>>2])));j=j+1|0;continue}break}if(!(H[e>>2]!=(c|0)|(h|0)<=0)){a:{b:{if(I[c+28|0]&128){f=0;j=0;while(1){if(J[d+50>>1]<=j>>>0){break b}n=f;f=G[H[d+4>>2]+(j<<1)>>1];f=Td(a,n,ib(a,45,Rq(a,c,g,f),oc(l,59,H[H[c+4>>2]+N(f,12)>>2])));j=j+1|0;continue}}f=Rq(a,c,g,-1);g=H[b+48>>2];d=oc(l,167,0);if(d){G[d+32>>1]=65535;H[d+28>>2]=g;H[d+44>>2]=c}c=ib(a,52,f,d);break a}c=ib(a,19,f,0)}k=Td(a,k,c)}H[i+44>>2]=0;H[i+36>>2]=0;H[i+40>>2]=0;H[i+28>>2]=0;H[i+32>>2]=0;H[i+20>>2]=0;H[i+24>>2]=0;H[i+16>>2]=b;H[i+12>>2]=a;cd(i+12|0,k);c:{if(H[a+36>>2]){break c}a=bf(a,b,k,0,0,0,0,0);Sa(m,158,I[e+24|0],h);if(!a){break c}vd(a)}eb(l,k);if(o){rk(m,o)}Ea=i+48|0}function Ko(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;d=Ea-32|0;Ea=d;F[b|0]=0;e=Ia[H[H[a>>2]+24>>2]](a,d+16|0)|0;a:{if(e){break a}f=H[d+16>>2];h=f>>>0<16;g=H[d+20>>2];if(h&(g|0)<=0|(g|0)<0){break a}e=kf(a,f-16|0,g-h|0,d+28|0);if(e){break a}e=0;f=H[d+28>>2];if(f>>>0>=c>>>0|!f){break a}c=H[d+16>>2];g=c-16|0;h=H[d+20>>2];i=h-(c>>>0<16)|0;if((i|0)<0){g=1}else{g=(i|0)<=0&f>>>0>g>>>0}if(g){break a}e=kf(a,c-12|0,h-(c>>>0<12)|0,d+12|0);if(e){break a}c=H[d+16>>2];e=Ia[H[H[a>>2]+8>>2]](a,d+4|0,8,c-8|0,H[d+20>>2]-(c>>>0<8)|0)|0;if(e){break a}e=0;if((I[d+4|0]|I[d+5|0]<<8|(I[d+6|0]<<16|I[d+7|0]<<24))!=-117058087|(I[d+8|0]|I[d+9|0]<<8|(I[d+10|0]<<16|I[d+11|0]<<24))!=-681336544){break a}c=H[d+16>>2];g=c-f|0;e=Ia[H[H[a>>2]+8>>2]](a,b,f,g-16|0,(H[d+20>>2]-(c>>>0<f>>>0)|0)-(g>>>0<16)|0)|0;if(e){break a}a=0;c=H[d+12>>2];while(1){if((a|0)!=(f|0)){c=c-F[a+b|0]|0;a=a+1|0;continue}break}e=0;a=(c?0:f)+b|0;F[a|0]=0;F[a+1|0]=0}Ea=d+32|0;return e}function sh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;a:{if(!b){break a}d=H[b>>2];d=(d|0)<=0?72:d<<6|8;h=Nb(a,d,d>>31);if(!h){break a}d=H[b>>2];H[h>>2]=d;H[h+4>>2]=d;j=b+8|0;k=h+8|0;while(1){if((d|0)<=(i|0)){return h}e=i<<6;d=e+k|0;f=e+j|0;H[d>>2]=H[f>>2];l=d,m=Tb(a,H[f+4>>2]),H[l+4>>2]=m;l=d,m=Tb(a,H[f+8>>2]),H[l+8>>2]=m;l=d,m=Tb(a,H[f+12>>2]),H[l+12>>2]=m;e=H[f+36>>2];H[d+36>>2]=e;H[d+40>>2]=H[f+40>>2];H[d+24>>2]=H[f+24>>2];H[d+28>>2]=H[f+28>>2];e=e>>>8|0;if(e&2){l=d,m=Tb(a,H[f+56>>2]),H[l+56>>2]=m;e=I[d+37|0]|I[d+38|0]<<8}g=H[f+60>>2];H[d+60>>2]=g;if(e&256){H[g>>2]=H[g>>2]+1;e=I[d+37|0]|I[d+38|0]<<8}if(e&4){l=d,m=pc(a,H[f+56>>2],c),H[l+56>>2]=m}e=H[f+16>>2];H[d+16>>2]=e;if(e){H[e+24>>2]=H[e+24>>2]+1}l=d,m=Ud(a,H[f+20>>2],c),H[l+20>>2]=m;e=H[f+44>>2];b:{if(I[f+38|0]&4){g=EA(a,e);break b}g=jb(a,e,c)}H[d+44>>2]=g;e=H[f+52>>2];H[d+48>>2]=H[f+48>>2];H[d+52>>2]=e;i=i+1|0;d=H[b>>2];continue}}return 0}function UD(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;d=Ea-128|0;Ea=d;a:{b:{switch(b-1|0){default:if((b|0)==9){break a}break;case 0:case 2:break a;case 1:break b}}H[d+120>>2]=c+4;e=H[c>>2]}c:{d:{if(b>>>0>16){break d}if(!(1<<b&110592)){if((b|0)!=9){if((b|0)!=14){break d}H[d+16>>2]=e;H[d+20>>2]=0;a=vc(Z(a|0,14,d+16|0)|0);break c}H[d+48>>2]=d+120;H[d+52>>2]=0;b=Z(a|0,16,d+48|0)|0;if((b|0)==-28){H[d+32>>2]=e;H[d+36>>2]=0;b=Z(a|0,9,d+32|0)|0}if(b){a=vc(b);break c}a=H[d+124>>2];a=H[d+120>>2]==2?0-a|0:a;break c}H[d+112>>2]=e;H[d+116>>2]=0;a=vc(Z(a|0,b|0,d+112|0)|0);break c}if((b|0)!=1030){H[d>>2]=(b|0)==4?e|32768:e;H[d+4>>2]=0;a=vc(Z(a|0,b|0,d|0)|0);break c}H[d+96>>2]=e;H[d+100>>2]=0;b=Z(a|0,1030,d+96|0)|0;if((b|0)!=-28){a=vc(b);break c}H[d+80>>2]=0;H[d+84>>2]=0;b=Z(a|0,1030,d+80|0)|0;if((b|0)!=-28){if((b|0)>=0){aa(b|0)|0}a=vc(-28);break c}H[d+64>>2]=e;H[d+68>>2]=0;a=vc(Z(a|0,0,d- -64|0)|0)}Ea=d+128|0;return a|0}function jE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0;if((b|0)==1){d=Rg(H[c>>2]);if((d|0)!=5){a:{b:{c:{a=Bb(a,64);d:{if(!H[a+56>>2]){b=Ll(12);H[a+56>>2]=b;if((d|0)!=1){break c}H[b+4>>2]=429;H[a+48>>2]=0;H[a+52>>2]=0;b=H[a+20>>2];d=H[a+16>>2]+1|0;b=d?b:b+1|0;H[a+16>>2]=d;H[a+20>>2]=b;break d}b=H[a+20>>2];d=H[a+16>>2]+1|0;b=d?b:b+1|0;H[a+16>>2]=d;H[a+20>>2]=b;if(H[a+48>>2]|H[a+52>>2]){break b}}b=kb(H[c>>2]);d=Ha;c=Ll(8);H[c>>2]=b;H[c+4>>2]=d;break a}H[a+48>>2]=1;H[a+52>>2]=0;H[b+4>>2]=430;b=H[a+20>>2];d=H[a+16>>2]+1|0;b=d?b:b+1|0;H[a+16>>2]=d;H[a+20>>2]=b}e=Db(H[c>>2]);c=Ll(8);M[c>>3]=e}a=H[a+56>>2];b=H[a+4>>2];while(1){e:{d=H[a>>2];if(!d){b=Ll(24);H[b+16>>2]=1;H[b+20>>2]=0;H[b+8>>2]=c;H[a>>2]=b;break e}d=Ia[b|0](H[d+8>>2],c)|0;if(d){a=H[a>>2]+(((d|0)<=0)<<2)|0;continue}else{a=H[a>>2];d=H[a+16>>2];b=H[a+20>>2];d=d+1|0;b=d?b:b+1|0;H[a+16>>2]=d;H[a+20>>2]=b;Ce(c)}}break}}return}Y(23738,17858,1418,9905);D()}function $r(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;d=Ea+-64|0;Ea=d;a:{if(I[a+16|0]){break a}g=H[a>>2];f=H[a+8>>2];while(1){c=b;b=H[b+52>>2];if(b){continue}break}k=H[c+32>>2];h=H[c+28>>2];F[a+16|0]=1;b=H[g+32>>2];Ym(f,H[h>>2]);j=h+8|0;l=b&68;m=b&4;b=0;while(1){c=H[h>>2];if((b|0)<(c|0)){i=(b<<4)+j|0;c=H[i>>2];e=H[i+4>>2];b:{if(!(!e|I[i+9|0]&3)){Df(f,b,0,e,-1);break b}if(!(!(n|l)|I[c|0]!=167)){e=H[c+44>>2];c:{d:{c=G[c+32>>1];if((c|0)>=0){break d}c=G[e+32>>1];if((c|0)>=0){break d}c=15085;break c}c=H[H[e+4>>2]+N(c,12)>>2]}if(n|m){e=H[e>>2];H[d+20>>2]=c;H[d+16>>2]=e;Df(f,b,0,mb(g,6437,d+16|0),5);break b}Df(f,b,0,c,-1);break b}e:{if(!e){H[d>>2]=b+1;c=mb(g,16599,d);break e}c=Tb(g,e)}Df(f,b,0,c,5)}b=b+1|0;continue}break}f=H[a+8>>2];b=0;H[d+40>>2]=0;H[d+28>>2]=a;H[d+32>>2]=k;while(1){if((b|0)>=(c|0)){break a}Df(f,b,1,Hm(d+28|0,H[(b<<4)+j>>2]),-1);b=b+1|0;c=H[h>>2];continue}}Ea=d- -64|0}function lt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;f=Ea-96|0;Ea=f;c=b+c|0;o=(b|0)>(c|0)?b:c;k=H[a+56>>2];m=H[H[a+52>>2]+40>>2];p=k+m|0;q=(I[a+10|0]+(I[a+9|0]+k|0)|0)+8|0;while(1){a:{b:{c:{d:{if((b|0)==(o|0)){c=0;b=(e|0)>0?e:0;while(1){if((b|0)==(c|0)){break d}d=c<<2;e=H[d+(f+48|0)>>2];$n(a,e&65535,H[d+f>>2]-e&65535);c=c+1|0;continue}}c=H[H[d+8>>2]+(b<<2)>>2];if(c>>>0<q>>>0|c>>>0>=p>>>0){break a}h=c-k&65535;i=h+J[H[d+12>>2]+(b<<1)>>1]|0;c=0;j=(e|0)>0?e:0;e:{while(1){if((c|0)==(j|0)){break e}g=c<<2;n=g+(f+48|0)|0;if(H[n>>2]==(i|0)){H[n>>2]=h;break b}c=c+1|0;g=f+g|0;if(H[g>>2]!=(h|0)){continue}break}H[g>>2]=i;break b}c=0;if((e|0)>=10){while(1){if((c|0)!=(e|0)){j=c<<2;g=H[j+(f+48|0)>>2];$n(a,g&65535,H[f+j>>2]-g&65535);c=c+1|0;continue}break}e=0}c=e<<2;H[c+f>>2]=i;H[c+(f+48|0)>>2]=h;if((i|0)<=(m|0)){break c}l=0}Ea=f+96|0;return l}e=e+1|0}l=l+1|0}b=b+1|0;continue}}function SH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;a:{e=J[H[c>>2]+16>>1];d=e&31;if((e&63)>>>0>=32){d=-1431655766>>>d|0}else{d=((1<<d)-1&-1431655766)<<32-d|-1431655766>>>d}if(d&1){break a}d=Bb(a,36);if(!d){break a}e=H[d+12>>2];H[d+12>>2]=H[H[H[a>>2]+20>>2]+120>>2];b:{if((b|0)==1){if(e){Sh(d,1,44);break b}H[d+28>>2]=1;break b}a=H[c+4>>2];c:{d:{e:{if(e){a=$a(a);e=xb(H[c+4>>2]);f:{if(!a){e=0;break f}sb(d,a,e)}a=H[d+32>>2];if(H[d+28>>2]==(e|0)){if(!a){break b}f=d+32|0;break e}f=d+32|0;if(a){break e}b=ub((H[d+24>>2]<<2)+4|0,0);if(!b){break c}a=H[d+24>>2];g=((a|0)<=1?1:a)-1|0;a=0;while(1){if((a|0)==(g|0)){break d}H[(a<<2)+b>>2]=H[d+28>>2];a=a+1|0;continue}}h=d,i=xb(a),H[h+28>>2]=i;break b}b=Fc(a,H[d+24>>2]<<2,0);if(!b){break c}}a=H[d+24>>2];if((a|0)>0){H[((a<<2)+b|0)-4>>2]=e}H[f>>2]=b;break b}Nh(d,7)}H[d+24>>2]=H[d+24>>2]+1;a=$a(H[c>>2]);b=xb(H[c>>2]);if(!a){break a}sb(d,a,b)}}function qk(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0,o=0,p=0,q=0,r=0,s=0;n=H[a+56>>2]-1|0;H[a+56>>2]=n;s=I[b+28|0]&128?28:31;l=H[a+8>>2];if(!j){gb(l,s,d,n,f,g)}if(ti(a,b,0,0)|c){p=an(a,c,0,0,3,b,i);r=Ir(a,b);q=H[a+44>>2];o=q+1|0;H[a+44>>2]=o+G[b+34>>1];Sa(l,80,f,o);q=q+2|0;p=p|r;r=(p|0)==-1;while(1){if(G[b+34>>1]>(m|0)){if(!(!r&(!(p>>>m&1)|m>>>0>31))){yd(l,b,d,m,Gc(b,m<<16>>16)+q|0)}m=m+1|0;continue}break}m=H[l+108>>2];si(a,c,128,0,1,b,o,i,n);if((m|0)<H[l+108>>2]){gb(l,s,d,n,f,g);k=-1}$m(a,b,o,0,0,0)}a:{if(I[b+43|0]==2){break a}Gr(a,b,d,e,0,k);Sa(l,130,d,(h|0)!=0);b:{if(I[a+18|0]){if(Zb(H[b>>2],23663)){break b}}xc(l,b,-5)}c:{if(!j){break c}e=H[l+108>>2];if((e|0)<=0){break c}G[(H[l+104>>2]+N(e,20)|0)-18>>1]=4}if(!((d|0)==(k|0)|(k|0)<0)){_a(l,130,k)}d=H[l+108>>2];if((d|0)<=0){break a}G[(H[l+104>>2]+N(d,20)|0)-18>>1]=((j|0)==2)<<1}pB(a,b,0,o,0,0);if(c){si(a,c,128,0,2,b,o,i,n)}hb(l,n)}function aG(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;m=H[a>>2]+4|0;l=H[a+4>>2];a:while(1){g=H[a+12>>2];h=H[a+8>>2];if((g|0)>=(h|0)){return 101}i=0-g|0;b:{while(1){j=h;if((g|0)==(h|0)){break b}j=F[g+l|0];if(!((j|0)<0|!I[j+m|0])){g=g+1|0;H[a+12>>2]=g;i=i-1|0;continue}break}j=g}h=(g|0)>(h|0)?g:h;i=g+i|0;c:{while(1){d:{e:{if((g|0)!=(h|0)){k=F[g+l|0];if((k|0)<0|!I[k+m|0]){break e}h=g}k=(h|0)<=(j|0);if(k){continue a}h=h-j|0;if((h|0)<=H[a+24>>2]){break c}g=h+20|0;H[a+24>>2]=g;g=Fc(H[a+20>>2],g,g>>31);if(g){break d}return 7}g=g+1|0;H[a+12>>2]=g;i=i+1|0;continue}break}H[a+20>>2]=g}g=0;n=(i|0)>0?i:0;o=j+l|0;while(1){if((g|0)!=(n|0)){i=I[g+o|0];F[H[a+20>>2]+g|0]=(i-65&255)>>>0<26?i+32|0:i;g=g+1|0;continue}break}H[b>>2]=H[a+20>>2];H[c>>2]=h;H[d>>2]=j;H[e>>2]=H[a+12>>2];j=H[a+16>>2];H[a+16>>2]=j+1;H[f>>2]=j;if(k){continue}break}return 0}function qj(a){var b=0,c=0,d=0;G[a+50>>1]=0;F[a+1|0]=I[a+1|0]&249;a:{if(I[a|0]){break a}b=J[a+70>>1];c=b+1|0;G[a+70>>1]=c;d=H[a+116>>2];if(J[d+24>>1]<=(c&65535)>>>0){G[a+70>>1]=b;break a}if(I[d+8|0]){a=0}else{a=po(a)}return a}c=I[a|0];b:{c:{if(!c){break c}if(c>>>0>=3){b=mj(a);if(b){break b}c=I[a|0]}b=101;d:{switch(c-1|0){case 1:break d;case 0:break b;default:break c}}b=0;F[a|0]=0;if(H[a+4>>2]>0){break b}}d=J[a+70>>1]+1|0;G[a+70>>1]=d;b=H[a+116>>2];e:{f:{g:{c=H[16544];if(!c){break g}if(!(Ia[c|0](412)|0)){break g}F[b|0]=0;break f}if(I[b|0]){break e}}b=Ya(76341);break b}c=I[b+8|0];h:{i:{if(J[b+24>>1]<=(d&65535)>>>0){if(!c){b=Dg(a,cb((H[b+56>>2]+I[b+9|0]|0)+8|0));if(!b){break i}break b}while(1){if(!I[a+68|0]){F[a|0]=1;b=101;break b}to(a);b=H[a+116>>2];if(J[a+70>>1]>=J[b+24>>1]){continue}break}if(!I[b+1|0]){break h}b=qj(a);break b}if(c){break h}}b=po(a);break b}b=0}return b}function gx(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;f=Ea-32|0;Ea=f;a:{b:{if((Qd(a,c)|0)==(c|0)|((K[16644]/K[a+36>>2]|0)+1|0)==(c|0)){break b}if(!cb(H[H[a+12>>2]+56>>2]+36|0)){e=101;break a}e=_i(a,c,f+31|0,f+24|0);if(e){break a}c:{d:{e:{g=I[f+31|0];switch(g-1|0){case 1:break d;case 0:break e;default:break c}}e=Ya(74114);break a}if(d){break b}e=jf(a,f+16|0,f+20|0,c,1);if(e){break a}Eb(H[f+16>>2]);break b}e=qd(a,c,f+16|0,0);if(e){break a}h=d?0:b;i=!d<<1;while(1){j=H[a+48>>2];e=jf(a,f+12|0,f+20|0,h,i);if(e){Eb(H[f+16>>2]);break a}Eb(H[f+12>>2]);e=H[f+20>>2];if(e>>>0>j>>>0){Eb(H[f+16>>2]);e=Ya(74166);break a}if(b>>>0<e>>>0?d:0){continue}break}b=H[f+16>>2];e=Eo(a,b,g,H[f+24>>2],e,d);Eb(b);if(e){break a}}e=0;if(d){break a}b=(K[16644]/K[a+36>>2]|0)+2|0;while(1){d=(b|0)==(c|0);c=c-1|0;if(d){continue}if((Qd(a,c)|0)==(c|0)){continue}break}H[a+48>>2]=c;F[a+19|0]=1}Ea=f+32|0;return e}function Sx(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=Ea-16|0;Ea=e;H[e+4>>2]=b;H[e+12>>2]=b;f=Lb(a,7,e+8|0,e+12|0);g=H[e+8>>2];a:{b:{c:{if(f){break c}j=(vb(g)|0)!=100;if(j){break b}k=_p(a,g);f=cq(a,1,k,Xc(g,0),Ha);h=1;while(1){if(f){break c}if(H[a+24>>2]<(h|0)){break b}f=0;i=h-1|0;if(!I[i+H[a+32>>2]|0]){f=bq(a,k,$e(g,h),-1,(i<<2)+d|0);i=Nd(g,h);l=(H[a+24>>2]<<2)+d|0;H[l>>2]=i+H[l>>2]}h=h+1|0;continue}}ob(g);H[e>>2]=f;break a}f=ob(g);H[e>>2]=f;if(f|j){break a}H[e+12>>2]=b;d:{if(H[a+40>>2]){H[e>>2]=0;H[c>>2]=H[c>>2]-1;break d}f=1;b=Lb(a,1,e+8|0,e+12|0);if(b){H[e>>2]=b;break a}b=H[e+8>>2];if((vb(b)|0)==100){f=!Fd(b,0)}b=ob(b);H[e>>2]=b;if(b){break a}if(!f){m=e,n=Tx(a,1),H[m>>2]=n;H[c>>2]=0;Xa(d,0,(H[a+24>>2]<<3)+8|0);break a}b=H[a+40>>2];H[c>>2]=H[c>>2]-1;if(b){break d}Xg(e,a,0,e+4|0)}if(!I[a+238|0]){break a}Xg(e,a,19,e+4|0)}Ea=e+16|0;return H[e>>2]}function cg(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;a:{b:{c:{g=I[a|0];if((g|0)==45){a=a+1|0;h=-1;break c}if((g|0)!=48){if((g|0)!=43){break c}a=a+1|0;break c}if(!(I[I[a+2|0]+31152|0]&8)|(I[a+1|0]|32)!=120){break c}c=a+2|0;while(1){e=c;c=c+1|0;if(I[e|0]==48){continue}break}c=0;a=0;while(1){d:{if((c|0)==8){break d}d=I[c+e|0];if(!(I[d+31152|0]&8)){break d}a=d+(d<<1<<24>>24>>>7&9)&15|a<<4;c=c+1|0;continue}break}if((a|0)<0){break a}if(!(I[I[c+e|0]+31152|0]&8)){break b}break a}c=I[a|0];if(c-58>>>0<4294967286){break a}while(1){if((c&255)!=48){e:{c=0;while(1){if((c|0)==11){break e}f=I[a+c|0];if((f-48&255)>>>0>9){break e}f=f&15;e=sJ(e,d,10,0)+f|0;d=Ha;d=e>>>0<f>>>0?d+1|0:d;c=c+1|0;continue}}}else{c=I[a+1|0];a=a+1|0;continue}break}f=0;c=c>>>0>10;a=d+h|0;d=e+h|0;a=d>>>0<h>>>0?a+1|0:a;if(d>>>0>2147483647&(a|0)>=0|(a|0)>0|c){break a}a=(g|0)==45?0-e|0:e}H[b>>2]=a;f=1}return f}function yc(a,b,c){var d=0,e=0,f=0;a:{b:{c:{if(c){d=H[a+20>>2];f=(d|0)>0?d:0;d:{while(1){if((e|0)!=(f|0)){d=H[a+16>>2];if(!ab(c,H[d+(e<<4)>>2])){break d}e=e+1|0;continue}break}d=0;if(ab(c,11276)){break a}d=H[a+16>>2];e=0}d=Hc(H[((e<<4)+d|0)+12>>2]+8|0,b);if(d){break a}d=0;if(yb(b,18214,7)){break a}b=b+7|0;if((e|0)==1){e:{if(!ab(b,18107)){break e}if(!ab(b,18126)){break e}if(ab(b,9218)){break a}}e=H[a+16>>2]+28|0;break c}if(ab(b,18126)){break a}e=(H[a+16>>2]+(e<<4)|0)+12|0;a=9211;break b}d=Hc(H[H[a+16>>2]+28>>2]+8|0,b);if(d){break a}d=Hc(H[H[a+16>>2]+12>>2]+8|0,b);if(d){break a}e=2;while(1){if(H[a+20>>2]>(e|0)){c=e<<4;e=e+1|0;d=Hc(H[(H[a+16>>2]+c|0)+12>>2]+8|0,b);if(!d){continue}break a}break}d=0;if(yb(b,18214,7)){break a}b=b+7|0;if(!ab(b,18126)){e=H[a+16>>2]+12|0;a=9211;break b}if(ab(b,18107)){break a}e=H[a+16>>2]+28|0}a=9192}d=Hc(H[e>>2]+8|0,a)}return d}function qo(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;g=Ea-32|0;Ea=g;a:{if(K[a+48>>2]<b>>>0){e=Ya(80196);break a}e=Oi(a,b,g+28|0,0);if(e){break a}f=H[g+28>>2];b:{if(!(I[a+16|0]&4|H[H[f+72>>2]+32>>2]==(((b|0)==1?2:1)|0))){e=Ya(80203);break b}i=I[f+9|0];b=0;while(1){e=J[f+24>>1];if(e>>>0>b>>>0){e=H[f+64>>2]+(b<<1)|0;h=H[f+56>>2]+(J[f+26>>1]&(I[e|0]<<8|I[e+1|0]))|0;if(!I[f+8|0]){e=qo(a,cb(h),1,d);if(e){break b}}Ia[H[f+80>>2]](f,h,g);if(H[g+12>>2]!=J[g+16>>1]){e=oo(f,h,g);if(e){break b}}b=b+1|0;continue}break}H[g+24>>2]=0;c:{d:{if(!I[f+8|0]){e=qo(a,cb((H[f+56>>2]+i|0)+8|0),1,d);H[g+24>>2]=e;if(e){break b}if(I[f+1|0]|!d){break c}e=J[f+24>>1];break d}if(!d){break c}}a=H[d+4>>2];b=e&65535;e=b+H[d>>2]|0;a=e>>>0<b>>>0?a+1|0:a;H[d>>2]=e;H[d+4>>2]=a}if(c){Ah(f,g+24|0);e=H[g+24>>2];break b}e=Vb(H[f+72>>2]);if(e){break b}Jh(f,I[H[f+56>>2]+i|0]|8);e=0}Eb(f)}Ea=g+32|0;return e}function pA(a){var b=0,c=0,d=0,e=0,f=0;while(1){a:{b=a;b:{if(!b){a=0;break b}c:{d:{e:{f:{g:{h:{i:{c=I[b|0];switch(c-154|0){case 13:case 15:case 23:case 24:break h;case 20:case 25:break a;case 1:case 4:case 5:case 6:case 7:case 8:case 9:case 10:case 11:case 12:case 16:case 17:case 19:case 21:case 22:break c;case 2:case 14:case 18:break d;case 0:break f;case 3:break g;default:break i}}a=2;j:{switch(c-111|0){case 2:break a;case 6:break b;case 1:case 3:case 4:case 5:break c;case 0:break e;default:break j}}a=0;if((c|0)==121){continue}if((c|0)==36){break h}if((c|0)!=138){break c}}a=rc(b);a=(a|0)>66?5:(a|0)==66?6:7;break b}e=H[b+20>>2];c=e+8|0;b=1;a=0;while(1){d=H[e>>2];if((b|0)<(d|0)){a=pA(H[c+(b<<4)>>2])|a;b=b+2|0;continue}break}if(!(d&1)){break b}f=a|f;a=H[(c+(d<<4)|0)-16>>2];continue}a=4;break b}a=6;break b}a=7;break b}a=1}return a|f}a=H[b+12>>2];continue}}function Dm(a){var b=0,c=0,d=0,e=0,f=0;a:{if(I[a+97|0]!=167){break a}if(Vw(a)){break a}Wg(a,0);Gj(a);while(1){c=H[a+16>>2];if((b|0)<H[a+20>>2]){d=c+(b<<4)|0;c=H[d+4>>2];b:{if(!c){break b}rf(c);H[d+4>>2]=0;if((b|0)==1){break b}H[d+12>>2]=0}b=b+1|0;continue}break}c=H[c+28>>2];if(c){Uj(c)}jm(a);xq(a);d=a+424|0;while(1){d=H[d>>2];if(d){b=H[d+8>>2];while(1){Rw(a,b);c=H[b+12>>2];Za(a,b);b=c;if(b){continue}break}continue}break}qf(a+416|0);e=a+440|0;while(1){e=H[e>>2];if(e){f=H[e+8>>2];b=0;while(1){if((b|0)!=3){d=N(b,20)+f|0;c=H[d+16>>2];if(c){Ia[c|0](H[d+8>>2])}b=b+1|0;continue}break}Za(a,f);continue}break}qf(a+432|0);b=a+396|0;while(1){b=H[b>>2];if(b){c=H[b+8>>2];Ep(a,c);Bp(a,c);continue}break}qf(a+388|0);Pc(a,0);Uc(H[a+288>>2]);F[a+97|0]=213;Za(a,H[H[a+16>>2]+28>>2]);c=H[a+256>>2];if(c){Ia[c|0](H[a+252>>2])}F[a+97|0]=206;if(I[a+312|0]){Ta(H[a+352>>2])}Ta(a)}}function ui(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;a:{b:{c:{if(!H[b+56>>2]){h=H[H[H[a>>2]+16>>2]+28>>2];if(!h|!H[h+48>>2]){break c}}if(!I[a+161|0]){break b}}a=0;if(!e){break a}H[e>>2]=0;return 0}k=d;i=Ea-16|0;Ea=i;d=b;d:{e:{b=cs(a,b);if(!b){break e}h=a;f:{if(I[H[a>>2]+34|0]&4){break f}f=H[d+56>>2];if(!f){break f}if((b|0)==(f|0)){break e}a=b;while(1){g=a;a=H[a+32>>2];if((a|0)!=(f|0)?a:0){continue}break}H[g+32>>2]=0}l=(c|0)==128?20233:20240;g=0;m=(c|0)==127;n=(c|0)!=129;a=b;while(1){g:{h:{f=I[a+8|0];if((f|0)!=(c|0)){break h}if(!Sq(H[a+16>>2],k)){break h}g=I[a+9|0]|g;break g}if((f|0)==150){F[a+8|0]=c;j=I[d+43|0]!=1;f=j?2:1;if(!(m|j)){H[i>>2]=l;Wa(h,5636,i);f=1}F[a+9|0]=f;g=g|f;break g}if(H[h+128>>2]|(!I[a+10|0]|n|(f|0)!=127)){break g}g=I[a+9|0]|g}a=H[a+32>>2];if(a){continue}break}break d}b=0}if(e){H[e>>2]=g}Ea=i+16|0;a=g?b:0}return a}function am(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=Ea-16|0;Ea=f;e=H[b+80>>2];H[f+12>>2]=e;a:{if(!(!I[a+239|0]|!H[b+56>>2])){F[f+11|0]=0;if(c){H[c>>2]=e;H[d>>2]=H[b+84>>2]-1}$l(0,H[b+72>>2],H[b+76>>2],f+12|0,b+88|0,b+84|0,f+11|0);H[b+80>>2]=I[f+11|0]?0:H[f+12>>2];break a}h=H[b+72>>2]+H[b+76>>2]|0;while(1){g=I[e|0];if(g|i){i=g&128;e=e+1|0;continue}if(!(!H[b+52>>2]|H[b+40>>2]+H[b+48>>2]>>>0>e>>>0)){g=ny(b);if(!g){continue}break a}break}e=e+1|0;H[f+12>>2]=e;if(c){g=c;c=H[b+80>>2];H[g>>2]=c;H[d>>2]=(c^-1)+e}b:{while(1){if(e>>>0<h>>>0){if(I[e|0]){break b}e=e+1|0;continue}break}g=0;H[b+80>>2]=0;break a}H[f+12>>2]=e;g=cm(b,e,10);if(g){break a}j=b,k=zc(e,f)+e|0,H[j+80>>2]=k;c=H[f>>2];a=I[a+239|0];e=a?0-c|0:c;d=e+H[b+88>>2]|0;g=(c|0)!=0;c=H[f+4>>2];a=H[b+92>>2]+(a?0-(g+c|0)|0:c)|0;H[b+88>>2]=d;H[b+92>>2]=d>>>0<e>>>0?a+1|0:a;g=0}Ea=f+16|0;return g}function qF(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;h=Ea-16|0;Ea=h;H[h+12>>2]=0;a=kj(a,25286);if(!a){j=14007;g=c-3|0;a:{b:{if(!g){break b}k=d+12|0;d=0;l=(g|0)>0?g:0;a=0;while(1){if((a|0)!=(l|0)){d=(tb(H[(a<<2)+k>>2])+d|0)+1|0;a=a+1|0;continue}break}a=g<<2;i=ub(a+d|0,0);if(!i){i=0;a=7;break a}d=a+i|0;a=0;while(1){if((a|0)!=(l|0)){g=a<<2;m=g+k|0;n=tb(H[m>>2]);H[g+i>>2]=d;g=d;d=n+1|0;g=Va(g,H[m>>2],d);ii(g);a=a+1|0;d=d+g|0;continue}break}if((c|0)<4){break b}j=H[i>>2]}a=1;d=_l(b,j,tb(j)+1|0);if(!d){H[h>>2]=j;Sd(f,7781,h);break a}c:{a=(c|0)>4;a=Ia[H[d+4>>2]](a?c-4|0:0,a?i+4|0:0,h+12|0)|0;d:{if(a){c=H[h+12>>2];break d}b=lc(20);c=H[h+12>>2];if(b){break c}a=7}if(!c){break a}Ia[H[d+8>>2]](c)|0;break a}H[b>>2]=0;H[b+4>>2]=0;H[b+16>>2]=c;H[b+12>>2]=d;a=0;H[b+8>>2]=0;H[e>>2]=b}Ta(i)}Ea=h+16|0;return a|0}function Mm(a,b,c,d,e){var f=0,g=0;while(1){if(!cc(a,b,c,d)){return I[c|0]!=121}g=0;a:{b:{c:{d:{e:{f:{g:{h:{f=I[b|0];switch(f-102|0){case 11:break a;case 12:break b;case 10:break c;case 0:case 6:case 7:case 8:break f;case 1:case 2:case 3:case 4:case 5:case 9:break g;default:break h}}i:{switch(f-48|0){default:switch(f-173|0){case 0:case 1:case 8:break a;case 3:case 4:case 5:case 6:case 7:break c;case 2:break e;default:break d};case 1:if(!e){break b}e=1;if(I[b+5|0]&16){break c}break a;case 0:break i;case 2:case 3:break c;case 4:case 5:case 6:case 7:case 8:case 9:break g}}if(e){break c}g=1;f=H[b+20>>2];if(Mm(a,H[f+8>>2],c,d,1)){break c}e=1;if(!Mm(a,H[f+24>>2],c,d,1)){break a}break c}e=1}if(!Mm(a,H[b+16>>2],c,d,e)){break a}return 1}if(e){break c}e=1;if(I[b+2|0]==45){break a}break c}if((f|0)==19){break b}}return g}e=1}b=H[b+12>>2];continue}}function ps(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;j=Ea-16|0;Ea=j;f=H[a+248>>2];a:{if(!f){break a}g=H[f+28>>2];if(g&4){H[j>>2]=H[f>>2];Wa(a,1293,j);break a}H[f+28>>2]=g|4;b:{if(!b){g=G[f+34>>1]-1|0;k=H[f+4>>2]+N(g,12)|0;sn(a,k);h=1;break b}l=H[b>>2];n=(l|0)>0?l:0;o=b+8|0;g=-1;while(1){c:{if((m|0)!=(n|0)){i=Jf(H[(m<<4)+o>>2]);es(i);if(I[i|0]!=59){break c}g=0;h=G[f+34>>1];h=(h|0)>0?h:0;p=H[i+8>>2];while(1){if((g|0)==(h|0)){g=h;break c}i=H[f+4>>2]+N(g,12)|0;if(ab(p,H[i>>2])){g=g+1|0;continue}else{sn(a,i);k=i;break c}}}h=(l|0)==1;break b}m=m+1|0;continue}}if(!(!h|!k|(e|0)==1|(I[k+4|0]&-16)!=64)){if(!(!b|I[a+220|0]<2)){dd(a,f+32|0,Jf(H[b+8>>2]))}F[f+42|0]=c;G[f+32>>1]=g;H[f+28>>2]=H[f+28>>2]|d<<3;if(b){F[a+218|0]=I[b+16|0]}Hk(a,b);break a}if(d){Wa(a,18446,0);break a}Hi(a,0,0,0,b,c,0,0,e,0,2);b=0}pb(H[a>>2],b);Ea=j+16|0}function ux(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0;k=Ea-16|0;Ea=k;i=H[a>>2];H[k+12>>2]=i;m=k+12|0;a:{b:{if(i){j=H[i+16>>2];l=H[i+20>>2];if((j|0)==(b|0)&(l|0)==(c|0)){break b}H[i>>2]=H[i>>2]+1;i=b-j|0;j=c-((b>>>0<j>>>0)+l|0)|0}else{i=b;j=c}j=Mj(m,i,j);i=H[k+12>>2];if(j){break a}H[i+32>>2]=0;H[i+36>>2]=0;H[i+24>>2]=-1;H[i+28>>2]=-1;H[i+16>>2]=b;H[i+20>>2]=c}c:{d:{if(!!d&(e|0)>=0|(e|0)>0){if((d|0)==H[i+24>>2]&(e|0)==H[i+28>>2]){break d}j=Mj(k+12|0,1,0);if(j){i=H[k+12>>2];break a}j=Mj(k+12|0,d,e);i=H[k+12>>2];if(j){break a}H[i+32>>2]=0;H[i+36>>2]=0;H[i+24>>2]=d;H[i+28>>2]=e;break d}if((e|0)<0){break c}}c=k+12|0;b=H[i+32>>2];d=f-b|0;b=g-(H[i+36>>2]+(b>>>0>f>>>0)|0)|0;d=d+2|0;b=d>>>0<2?b+1|0:b;j=Mj(c,d,b);i=H[k+12>>2];if(j){break a}H[i+32>>2]=f;H[i+36>>2]=g}j=0}H[h>>2]=j;Ea=k+16|0;if(H[a>>2]==(i|0)){a=0}else{H[a>>2]=i;a=1}return a}function Sr(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c=H[b+32>>2];d=H[a+8>>2];while(1){if(H[b+36>>2]>(i|0)){k=H[H[c>>2]+20>>2];if(H[c+16>>2]>=0){h=H[k>>2];j=nc(a,h);g=I[c+20|0]?H[H[H[H[c>>2]+12>>2]+20>>2]>>2]+!I[c+21|0]|0:0;l=_a(d,36,H[c+16>>2]);f=h-1|0;e=f;while(1){if((e|0)>=0){Ua(d,94,H[c+16>>2],e+g|0,e+j|0);e=e-1|0;continue}break}if(I[c+22|0]){e=zb(a);g=!(I[c+20|0]?1:I[c+21|0])+(g+h|0)|0;while(1){if((f|0)>=0){Ua(d,94,H[c+16>>2],f+g|0,e);Sa(d,182,e,f+j|0);f=f-1|0;continue}break}rb(a,e)}Ua(d,162,0,j,H[b+24>>2]+(H[b+12>>2]+i|0)|0);xc(d,H[c+4>>2],-7);g=H[d+108>>2];if((g|0)>0){G[(H[d+104>>2]+N(g,20)|0)-18>>1]=h&255}Sa(d,39,H[c+16>>2],l+1|0);f=H[d+108>>2];H[(I[H[d>>2]+87|0]?73336:H[d+104>>2]+N(l,20)|0)+8>>2]=f;Sc(a,j,h)}Sa(d,165,H[b+24>>2]+(H[b+12>>2]+i|0)|0,k?H[k>>2]:0);xc(d,H[c+4>>2],-7);c=c+24|0;i=i+1|0;continue}break}}function Cd(a,b){var c=0,d=0,e=0;a:{if(!b){break a}if(!H[a+528>>2]){c=H[b+24>>2]-1|0;H[b+24>>2]=c;if(c){break a}}c=a;d=b;a=H[d+8>>2];while(1){if(a){b=H[a+20>>2];if(!(H[c+528>>2]|I[d+43|0]==1)){od(H[a+24>>2]+24|0,H[a>>2],0)}Zk(c,a);a=b;continue}break}b:{c:{switch(I[d+43|0]){case 0:a=H[d+48>>2];while(1){if(!a){break b}d:{if(H[c+528>>2]){break d}b=H[a+12>>2];e=H[a+16>>2];e:{if(e){H[e+12>>2]=b;break e}od(H[d+60>>2]+56|0,H[(b?b:a)+8>>2],b);b=H[a+12>>2]}if(!b){break d}H[b+16>>2]=H[a+16>>2]}Pi(c,H[a+28>>2]);Pi(c,H[a+32>>2]);b=H[a+4>>2];db(c,a);a=b;continue};case 1:if(!H[c+528>>2]){du(0,d)}if(!H[d+48>>2]){break b}a=0;while(1){if(H[d+44>>2]>(a|0)){if((a|0)!=1){Za(c,H[H[d+48>>2]+(a<<2)>>2])}a=a+1|0;continue}break};Za(c,H[d+48>>2]);break b;default:break c}}fc(c,H[d+44>>2])}On(c,d);Za(c,H[d>>2]);Za(c,H[d+12>>2]);pb(c,H[d+16>>2]);db(c,d)}}function Bz(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;i=Ea-16|0;Ea=i;d=H[b+24>>2];j=(d|0)>0?d:0;f=b+24|0;h=H[b+20>>2];d=h;a:{b:{while(1){if((g|0)!=(j|0)){if(H[d+4>>2]==(c|0)){break a}if(!(H[d+8>>2]!=H[c+28>>2]|J[d+12>>1]!=J[c+32>>1])){e=I[c|0];if((e|0)!=179){break b}}d=d+16|0;g=g+1|0;continue}break}a=Az(H[a>>2],h,16,f,i+12|0);H[b+20>>2]=a;g=H[i+12>>2];if((g|0)<0){break a}a=a+(g<<4)|0;H[a>>2]=H[c+44>>2];h=H[c+28>>2];H[a+8>>2]=h;j=J[c+32>>1];H[a+4>>2]=c;G[a+12>>1]=j;e=H[b+16>>2];c:{d:{if(!e|I[c|0]==179){break d}d=0;f=H[e>>2];k=(f|0)>0?f:0;e=e+8|0;while(1){if((d|0)==(k|0)){break d}f=H[e>>2];if(!(!(I[f|0]!=167|(h|0)!=H[f+28>>2])&(j|0)==J[f+32>>1])){e=e+16|0;d=d+1|0;continue}break}G[a+14>>1]=d;if(d<<16>>16>=0){break c}}d=J[b+2>>1];G[b+2>>1]=d+1;G[a+14>>1]=d}e=I[c|0]}H[c+40>>2]=b;if((e|0)==167){F[c|0]=169}G[c+34>>1]=g}Ea=i+16|0}function fx(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=Ea-16|0;Ea=f;a:{while(1){d=0;if(I[a+32|0]){break a}c=H[b>>2];if(H[a+24>>2]!=H[c+32>>2]|H[a+28>>2]!=H[c+36>>2]){break a}d=H[a+12>>2];if(d){d=fx(d,b);if(d){break a}a=H[a+16>>2];continue}break}i=H[c>>2];h=H[a+20>>2];c=H[h+28>>2];H[f+12>>2]=c;d=0;H[f+8>>2]=0;a=H[a+36>>2];e=H[b+4>>2];j=(e+31|0)/32|0;g=e;e=I[b+24|0];g=(e|0)!=121?j:g;if(!c){break a}d=N(a,g);a=0;g=(e|0)!=121;while(1){c=cx(f+12|0);e=H[h+68>>2];b:{if((e|0)!=(a|0)&(e|0)<H[i+24>>2]){break b}if(!g){H[(H[b+28>>2]+(d<<2)|0)+(a<<2)>>2]=c;break b}if(!c){break b}c=(H[b+28>>2]+(d<<2)|0)+((a+1|0)/32<<2)|0;H[c>>2]=H[c>>2]|1<<a}a=H[f+12>>2];if(I[a|0]!=1){d=0;break a}c=a+1|0;a=F[a+1|0];c:{if((a|0)<0){e=qc(c,f+8|0);a=H[f+8>>2];break c}H[f+8>>2]=a;e=1}H[f+12>>2]=c+e;if(H[b+4>>2]>(a|0)){continue}break}d=267}Ea=f+16|0;return d}function oG(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(H[b+8>>2]!=1){break a}a=H[b+12>>2];if(H[a>>2]|I[a+4|0]){break a}H[b+32>>2]=1}a=H[b>>2];j=(a|0)>0?a:0;g=-1;h=-1;f=-1;i=-1;while(1){if((c|0)!=(j|0)){d=H[b+4>>2]+N(c,12)|0;if(I[d+5|0]){a=I[d+4|0];d=H[d>>2];if(!d){h=(a|0)==8?c:(a|0)==16?c:h;i=(a|0)==2?c:i;g=(a|0)==32?c:(a|0)==4?c:g}f=(d|0)==4?(a|0)==2?c:f:f}c=c+1|0;continue}break}b:{if((i|0)>=0){H[b+20>>2]=1;H[H[b+16>>2]+(i<<3)>>2]=1;H[b+40>>2]=0;H[b+44>>2]=1075052544;c=2;e=5;break b}H[b+40>>2]=0;H[b+44>>2]=1087604736;H[b+20>>2]=0;c:{if((g|0)<0){c=1;e=2e4;a=4;break c}c=2;H[b+20>>2]=2;H[H[b+16>>2]+(g<<3)>>2]=1;H[b+40>>2]=0;H[b+44>>2]=1086556160;e=1e4;a=6}if((h|0)<0){break b}H[b+20>>2]=a;H[H[b+16>>2]+(h<<3)>>2]=c;e=e*.5;M[b+40>>3]=e;c=c+1|0}if((f|0)>=0){H[H[b+16>>2]+(f<<3)>>2]=c;M[b+40>>3]=e+-1}return 0}function rI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;e=Ea-32|0;Ea=e;a:{if((b|0)==2){f=H[c+4>>2];g=J[f+16>>1];b=g&31;if((g&63)>>>0>=32){b=-1431655766>>>b|0}else{b=((1<<b)-1&-1431655766)<<32-b|-1431655766>>>b}if(b&1){break a}b=kb(f);b=(b|0)>=30?30:b;f=(b|0)>0?b:0}c=H[c>>2];g=J[c+16>>1];b=g&31;if((g&63)>>>0>=32){b=-1431655766>>>b|0}else{b=((1<<b)-1&-1431655766)<<32-b|-1431655766>>>b}if(b&1){break a}d=Db(c);M[e+24>>3]=d;b:{if(P(d)>4503599627370496){break b}if(!f){d=d+(d<0?-.5:.5);c:{if(P(d)<0x8000000000000000){b=~~d>>>0;if(P(d)>=1){c=~~(d>0?R(T(d*2.3283064365386963e-10),4294967295):U((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0}else{c=0}break c}b=0;c=-2147483648}d=+(b>>>0)+ +(c|0)*4294967296;break b}M[e+8>>3]=d;H[e>>2]=f;b=Ab(12739,e);if(!b){Ub(a);break a}Md(b,e+24|0,bb(b),1);Ta(b);d=M[e+24>>3]}Sb(a,d)}Ea=e+32|0}function ox(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0;g=Ea-32|0;Ea=g;f=Lb(a,37,g+28|0,0);a:{if(f){break a}i=H[g+28>>2];h=c;f=b+1|0;h=f?h:h+1|0;Cb(i,1,f,h);h=tJ(b,c,1024,0);Cb(i,2,h<<10|1023,Ha<<10|h>>>22);e=tJ(sJ(d,e,3,0),Ha,2,0);k=Ha;while(1){b:{h=j;if((vb(i)|0)!=100){break b}H[g+16>>2]=0;H[g+20>>2]=0;mx(i,2,g+8|0,g+16|0);h=0;j=H[g+20>>2];f=j;d=H[g+16>>2];if(!d&(f|0)<=0|(f|0)<0){break b}j=1;if((f|0)<=(k|0)&d>>>0<=e>>>0|(f|0)<(k|0)){continue}}break}f=ob(i);if(!h){break a}H[g+16>>2]=0;H[g+8>>2]=0;if(f){break a}f=Lb(a,38,g+16|0,0);if(f){break a}f=Lb(a,39,g+8|0,0);if(f){break a}Cb(i,1,b,c);a=H[g+16>>2];h=0;c:{while(1){if((vb(i)|0)!=100){break c}Zc(a,1,h);Zc(a,2,Fd(i,0));Zc(a,3,Fd(i,1));vb(a);h=h+1|0;f=ob(a);if(!f){continue}break}ob(i);break a}f=ob(i);if(f){break a}a=H[g+8>>2];Cb(a,1,b,c);vb(a);f=ob(a)}Ea=g+32|0;return f}function Rj(a,b,c,d){var e=0,f=0,g=0;if(I[a|0]==1){g=sq(b,c)}else{g=rq(b,c)}a:{f=g&H[a+12>>2]-1;e=Gy(a,b,c,f);if(e){g=H[e+8>>2];if(!d){b=H[e+4>>2];c=H[e>>2];H[(b?b:a+8|0)>>2]=c;if(c){H[c+4>>2]=b}b=H[a+16>>2]+(f<<3)|0;if((e|0)==H[b+4>>2]){H[b+4>>2]=c}c=H[b>>2];H[b>>2]=c-1;if((c|0)<=1){H[b+4>>2]=0}b:{if(!I[a+1|0]){break b}b=H[e+12>>2];if(!b){break b}Ta(b)}Ta(e);b=H[a+4>>2];H[a+4>>2]=b-1;if((b|0)>1){break a}dm(a);break a}H[e+8>>2]=d;break a}c:{if(d){d:{e=H[a+12>>2];e:{if(!e){if(Fy(a,8)){break e}e=H[a+12>>2]}if(H[a+4>>2]<(e|0)){break d}if(!Fy(a,e<<1)){break d}}H[a+4>>2]=0;return d}e=He(20,0);if(!e){break c}f:{if(!(!b|!I[a+1|0])){f=He(c,c>>31);H[e+12>>2]=f;if(!f){Ta(e);return d}Va(f,b,c);break f}H[e+12>>2]=b}H[e+16>>2]=c;H[a+4>>2]=H[a+4>>2]+1;Ey(a,H[a+16>>2]+((g&H[a+12>>2]-1)<<3)|0,e);H[e+8>>2]=d}d=0}return d}return g}function lJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;d=1;c=H[b+4>>2];a:{if(c&1|(J[a+22>>1]?c&2:0)){break a}b:{c:{d:{e:{f:{g:{e=I[b|0];switch(e-43|0){case 2:case 7:case 8:break a;case 3:case 4:break b;case 9:case 10:case 11:case 12:case 13:case 14:break c;case 5:break d;case 6:break e;case 0:case 1:break f;default:break g}}c=e-157|0;if(c>>>0>20){break b}if(1<<c&1359873){break a}if((c|0)!=10){break b}if(H[a+24>>2]!=H[b+28>>2]){break a}G[a+20>>1]=1;return 2}LA(a,H[b+12>>2],H[b+16>>2]);return 1}if(c&4096|H[H[b+20>>2]>>2]<=0){break a}Jb(a,H[b+12>>2]);return 1}Jb(a,H[b+12>>2]);c=a;a=H[b+20>>2];LA(c,H[a+8>>2],H[a+24>>2]);return 1}a=H[b+16>>2];b=H[b+12>>2];h:{if(I[b|0]!=167){break h}b=H[b+44>>2];if(!b){break h}if(I[b+43|0]==1){break a}}if(I[a|0]!=167){break b}a=H[a+44>>2];if(!a){break b}if(I[a+43|0]==1){break a}}d=0}return d|0}function UB(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0;c=Ea-272|0;Ea=c;G[c+268>>1]=0;H[c+260>>2]=0;H[c+264>>2]=0;H[c+256>>2]=200;H[c+248>>2]=0;H[c+252>>2]=c+48;Vd(c+248|0,1630);d=I[b+6|0];g=40;while(1){if(h>>>0<I[b+7|0]){H[c>>2]=g;H[c+4>>2]=H[(d<<2)+36656>>2];lb(c+248|0,29283,c);d=d+1|0;h=h+1|0;g=44;continue}break}if(!h){H[c+32>>2]=H[b>>2];lb(c+248|0,29290,c+32|0);h=1}g=0;d=I[b+5|0];if(d&32){Vd(c+248|0,19941);g=1;d=I[b+5|0]}if((d&255)>>>0>=64){Vd(c+248|0,19953);g=g+1|0}d=c+248|0;sb(d,27576,1);Jd(d);i=kj(a,c+48|0);a:{b:{if(!i){d=lc(24);if(!d){i=7;break b}f=d+16|0;H[f>>2]=0;H[f+4>>2]=0;H[d+8>>2]=0;H[d+12>>2]=0;H[d>>2]=0;H[d+4>>2]=0;H[d+16>>2]=b;F[d+21|0]=h;H[d+12>>2]=a;F[d+20|0]=g;i=0;break a}j=c,k=rg(a),H[j+16>>2]=k;j=f,k=Ab(8863,c+16|0),H[j>>2]=k}d=0}H[e>>2]=d;Ea=c+272|0;return i|0}function lz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;h=Ea-16|0;Ea=h;e=H[H[H[a+24>>2]+4>>2]+36>>2];f=H[H[a+4>>2]+4>>2];j=H[f+36>>2];p=(e|0)<(j|0)?e:j;q=e;k=e>>31;l=sJ(e,k,b,0);i=l-e|0;m=Ha;e=m-((e>>>0>l>>>0)+k|0)|0;o=H[f>>2];n=j>>31;b=0;while(1){if(!((e|0)>=(m|0)&i>>>0>=l>>>0|(e|0)>(m|0)|b)){b=0;H[h+12>>2]=0;f=tJ(i,e,j,n);g=Ha;if((f|0)!=(K[16644]/K[H[H[a+4>>2]+4>>2]+36>>2]|0)){b=Ia[H[o+220>>2]](o,f+1|0,h+12|0,0)|0;a:{if(b){break a}b=Vb(H[h+12>>2]);if(b){break a}f=Va(H[H[h+12>>2]+4>>2]+(i-sJ(j,n,f,g)|0)|0,uJ(i,e,q,k)+c|0,p);b=0;F[H[H[h+12>>2]+8>>2]]=0;if(e|i|d){break a}g=H[H[H[a+24>>2]+4>>2]+48>>2];g=g<<24|(g&65280)<<8|(g>>>8&65280|g>>>24);F[f+28|0]=g;F[f+29|0]=g>>>8;F[f+30|0]=g>>>16;F[f+31|0]=g>>>24}jd(H[h+12>>2])}e=e+n|0;i=i+j|0;e=i>>>0<j>>>0?e+1|0:e;continue}break}Ea=h+16|0;return b}function bt(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0;while(1){a:{f=I[a|0];if(!f){break a}e=0;g=0;if((b|0)<=(h|0)){break a}while(1){if((f-48&255)>>>0<=9){g=sJ(e,g,10,0);e=f&255;f=g+e|0;g=Ha;g=f>>>0<e>>>0?g+1|0:g;e=f-48|0;g=g-(f>>>0<48)|0;f=I[a+1|0];a=a+1|0;continue}break}i=(h<<1)+c|0,j=Kd(e,g),G[i>>1]=j;h=h+1|0;a=(I[a|0]==32)+a|0;continue}break}e=(I[d+55|0]|I[d+56|0]<<8)&-69;F[d+55|0]=e;F[d+56|0]=e>>>8;h=I[a|0];b:while(1){if(h&255){c:{if(lp(24857,a)){if(!lp(24868,a)){f=Se(a+3|0);i=d,j=Kd((f|0)<=2?2:f,0),G[i+48>>1]=j;break c}if(lp(24845,a)){break c}e=e|64}else{e=e|4}F[d+55|0]=e;F[d+56|0]=e>>>8}while(1)if((I[a|0]|32)==32){f=a;while(1){a=f;f=a+1|0;h=I[a|0];if((h|0)==32){continue}break}continue b}else{a=a+1|0;continue}}break}a=G[c>>1];if(!((a|0)<67|(a|0)>G[((b<<1)+c|0)-2>>1])){a=e|256;F[d+55|0]=a;F[d+56|0]=a>>>8}}function Uf(a,b,c,d,e){var f=0,g=0;if(d){f=H[d+4>>2];d=H[d>>2]}else{d=0}g=b+c|0;a:{if(!a){while(1){a=H[b>>2];d=(d+f|0)+(a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24))|0;a=H[b+4>>2];f=d+((a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24))+f|0)|0;b=b+8|0;if(g>>>0>b>>>0){continue}break a}}if(!(c&63)){while(1){a=H[b>>2]+(d+f|0)|0;c=a+(H[b+4>>2]+f|0)|0;a=c+(a+H[b+8>>2]|0)|0;c=(c+H[b+12>>2]|0)+a|0;a=c+(a+H[b+16>>2]|0)|0;c=(c+H[b+20>>2]|0)+a|0;a=c+(a+H[b+24>>2]|0)|0;c=(c+H[b+28>>2]|0)+a|0;a=c+(a+H[b+32>>2]|0)|0;c=(c+H[b+36>>2]|0)+a|0;a=c+(a+H[b+40>>2]|0)|0;c=(c+H[b+44>>2]|0)+a|0;d=c+H[b+52>>2]|0;c=c+(a+H[b+48>>2]|0)|0;a=d+c|0;d=a+(c+H[b+56>>2]|0)|0;f=d+(a+H[b+60>>2]|0)|0;b=b- -64|0;if(g>>>0>b>>>0){continue}break a}}while(1){d=H[b>>2]+(d+f|0)|0;f=d+(H[b+4>>2]+f|0)|0;b=b+8|0;if(g>>>0>b>>>0){continue}break}}H[e+4>>2]=f;H[e>>2]=d}function Rh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;g=Ea-16|0;Ea=g;f=H[b>>2];a:{b:{c:{if(H[a+28>>2]?I[a+15|0]:0){break c}e=H[a+228>>2];if(!f|(H[e+16>>2]|H[e+20>>2])|H[a+168>>2]==(f|0)){break c}H[g+8>>2]=0;H[g+12>>2]=0;d:{if(!I[a+17|0]){break d}e=H[a+64>>2];d=H[e>>2];if(!d){break d}d=Ia[H[d+24>>2]](e,g+8|0)|0;if(!d){break d}e=0;break b}e=$i(f+8|0);if(!e){e=0;d=7;break b}d=e+f|0;F[d|0]=0;F[d+1|0]=0;F[d+2|0]=0;F[d+3|0]=0;F[d+4|0]=0;F[d+5|0]=0;F[d+6|0]=0;F[d+7|0]=0;Lg(a);d=lv(H[a+228>>2],f);if(d){break b}lf(H[a+224>>2]);H[a+224>>2]=e;e=H[g+8>>2];d=H[g+12>>2];H[a+168>>2]=f;H[a+172>>2]=0;h=e;e=e+f|0;d=h>>>0>e>>>0?d+1|0:d;i=a,j=tJ(e-1|0,d-!e|0,f,0),H[i+28>>2]=j;H[a+164>>2]=(K[16644]/(f>>>0)|0)+1}H[b>>2]=H[a+168>>2];if((c|0)<0){c=J[a+150>>1]}G[a+150>>1]=c;d=0;break a}lf(e);H[b>>2]=H[a+168>>2]}Ea=g+16|0;return d}function Xk(a){var b=0,c=0,d=0;G[a+50>>1]=0;F[a+1|0]=I[a+1|0]&241;a:{b:{if(I[a|0]){break b}b=J[a+70>>1];if(!b){break b}if(I[H[a+116>>2]+8|0]){break a}}c=I[a|0];c:{d:{if(!c){break d}if(c>>>0>=3){b=mj(a);if(b){break c}c=I[a|0]}b=101;e:{switch(c-1|0){case 0:break c;case 1:break e;default:break d}}b=0;F[a|0]=0;if(H[a+4>>2]<0){break c}}b=H[a+116>>2];f:{g:{h:{c=H[16544];if(!c){break h}if(!(Ia[c|0](412)|0)){break h}F[b|0]=0;break g}if(I[b|0]){break f}}b=Ya(76434);break c}if(!I[b+8|0]){c=H[b+56>>2];d=J[b+26>>1];b=H[b+64>>2]+(J[a+70>>1]<<1)|0;b=Dg(a,cb(c+(d&(I[b|0]<<8|I[b+1|0]))|0));if(b){break c}b=ot(a);break c}i:{while(1){b=J[a+70>>1];if(b){break i}if(I[a+68|0]){to(a);continue}break}F[a|0]=1;b=101;break c}G[a+70>>1]=b-1;b=0;c=H[a+116>>2];if(!I[c+1|0]|I[c+8|0]){break c}b=Xk(a)}return b}G[a+70>>1]=b-1;return 0}function kj(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;c=Ea-288|0;Ea=c;g=H[a+404>>2];a:{if(!(H[g+12>>2]?0:g)){Pc(a,Rc(155039));a=Rc(155041);break a}d=H[g+4>>2];f=c+4|0;vm(f,a);e=1;F[c+165|0]=1;F[c+224|0]=1;h=I[a+177|0];F[a+177|0]=0;G[c+160>>1]=1;b:{c:{if(jj(f,b)){break c}b=H[c+252>>2];if(I[a+87|0]|!b|I[b+43|0]){break c}e=0;d:{if(H[d+4>>2]){break d}H[d+4>>2]=H[b+4>>2];pb(a,H[b+52>>2]);e=J[b+34>>1];G[d+36>>1]=e;G[d+34>>1]=e;H[d+28>>2]=H[d+28>>2]|H[b+28>>2]&640;e=0;H[b+4>>2]=0;G[b+34>>1]=0;if(!(!(I[b+28|0]&128)|!H[H[H[H[g>>2]+4>>2]>>2]+52>>2])){e=J[jc(b)+50>>1]!=1}f=H[b+8>>2];if(!f){break d}H[d+8>>2]=f;H[b+8>>2]=0;H[f+12>>2]=d}H[g+12>>2]=1;break b}b=H[c+8>>2];H[c>>2]=b;ae(a,1,b?8863:0,c);Za(a,H[c+8>>2])}F[c+224|0]=0;b=H[c+12>>2];if(b){Cf(b)}Cd(a,H[c+252>>2]);mi(c+4|0);F[a+177|0]=h;a=gd(a,e)}Ea=c+288|0;return a}function FB(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=Ea-16|0;Ea=g;e=H[a+24>>2];h=H[H[e>>2]>>2];k=Bg(h,H[e+40>>2]);i=H[b+32>>2];a:{if(!i){break a}l=e+4|0;j=i+8|0;c=j;b:{while(1){if(H[i>>2]>(f|0)){if(!I[e+36|0]){d=H[c+4>>2];c:{if(!d){d=I[c+37|0]|I[c+38|0]<<8;break c}if((Bg(h,d)|0)!=(k|0)){a=H[e>>2];b=H[e+48>>2];c=H[e+44>>2];H[g+8>>2]=d;H[g>>2]=c;H[g+4>>2]=b;Wa(a,6812,g);break b}Za(h,d);H[c+4>>2]=0;d=I[c+37|0]|I[c+38|0]<<8|512;F[c+37|0]=d;F[c+38|0]=d>>>8}m=H[e+32>>2];d=d|128;F[c+37|0]=d;F[c+38|0]=d>>>8;H[c>>2]=m}d=(f<<6)+j|0;if(!(I[d+38|0]&4)){if(Jb(l,H[d+44>>2])){break b}}c=c- -64|0;f=f+1|0;continue}break}d=0;if(!H[b+64>>2]){break a}f=0;while(1){c=H[b+64>>2];if(H[c>>2]<=(f|0)){break a}e=N(f,24);f=f+1|0;if(!ec(a,H[(c+e|0)+20>>2])){continue}break}}d=2}Ea=g+16|0;return d|0}function Dp(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;a:{C(+a);b=x(1)|0;e=x(0)|0;b:{c:{d:{if((b|0)<1071284857|(b|0)<=1071284857){if((b|0)==-1074790400|b>>>0>3220176896){d=-Infinity;if(a==-1){break b}return(a-a)/0}if(((b&2147483647)<<1|e>>>31)>>>0<2034237440){break a}if((b|0)==-1076707643|b>>>0>3218259653){break d}d=0;break c}if(b>>>0>2146435071){break a}}c=a+1;C(+c);b=x(1)|0;e=x(0)|0;b=b+614242|0;h=b>>>0<=1129316351?(b>>>0>1074790399?a-c+1:a-(c+-1))/c:0;z(0,e|0);z(1,(b&1048575)+1072079006|0);a=+B()+-1;d=+((b>>>20|0)-1023|0)}f=a/(a+2);g=f*f;c=g*g;i=a;a=a*(a*.5);d=d*.6931471803691238+(i+(f*(a+(c*(c*(c*.15313837699209373+.22222198432149784)+.3999999999940942)+g*(c*(c*(c*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+(d*1.9082149292705877e-10+h)-a))}return d}return a}function AC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;H[c>>2]=0;H[c+4>>2]=0;H[c+8>>2]=0;a:{b:{c:{h=bb(b);if(h>>>0<2){break c}a=I[b|0];if((a|0)!=92&(a|0)!=47){break c}a=H[18299];g=(a|0)>0?a:0;i=H[18300];d:{while(1){if((f|0)==(g|0)){break d}a=f<<2;f=f+1|0;a=H[a+i>>2];if(Tc(H[a+52>>2],b)){continue}break}H[a+48>>2]=H[a+48>>2]+1;break b}a=bc(h+59|0,0);f=7;if(!a){break a}f=Ld(H[18300],(H[18299]<<2)+4|0,0);if(!f){Ta(a);return 7}g=H[18299];H[18299]=g+1;H[f+(g<<2)>>2]=a;H[18300]=f;f=Xa(a,0,56);H[f+36>>2]=3;g=H[16543];i=H[16542];j=f+56|0;H[f+52>>2]=j;H[f+16>>2]=i;H[f+20>>2]=g;Va(j,b,h+1|0);H[f+48>>2]=1;H[f+28>>2]=8;break b}a=bc(56,0);if(!a){return 7}b=Xa(a,0,56);H[b+36>>2]=3;f=H[16543];H[b+16>>2]=H[16542];H[b+20>>2]=f}H[c+4>>2]=a;if(e){H[e>>2]=d|128}H[c>>2]=32964;f=0}return f|0}function Mi(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;f=Ea-16|0;Ea=f;d=67;a:{b:{c:{d:{e:while(1){h=d-67|0;while(1){f:{g=I[a|0];if(g){a=a+1|0;g:{c=I[g+30768|0]|c<<8;if((c|0)!=1651273570){if((c|0)==1667785074){d=66;e=a;continue e}if((c|0)!=1952807028&(c|0)!=1668050786){break g}d=66;continue e}h:{switch(h|0){case 0:case 2:break h;default:break g}}e=I[a|0]==40?a:e;d=65;continue e}if((c|0)!=1919246700&(c|0)!=1718382433&(c|0)!=1685026146|(d|0)!=67){break f}d=69;continue e}if(!b){break a}a=0;H[f+12>>2]=0;if(d>>>0>66){break b}if(e){break d}a=4;break b}if((c&16777215)!=6909556){continue}break}break}if(b){break c}d=68;break a}while(1){c=I[e|0];if(!c){break b}if(c-58>>>0>=4294967286){cg(e,f+12|0);a=H[f+12>>2]/4|0;break b}else{e=e+1|0;continue}}}a=0;d=68}F[b+6|0]=((a|0)>=254?254:a)+1}Ea=f+16|0;return d<<24>>24}function vE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{b:{c:{if((b&-2)==2){d:{if((Kb(H[c>>2])|0)!=5){if((Kb(H[c+4>>2])|0)!=5){break d}}Rb(a);return}f=$a(H[c>>2]);if(!f){break a}d=$a(H[c+4>>2]);if((b|0)==3){b=kb(H[c+8>>2]);i=((b|0)<=1?1:b)-1|0}if(!I[f|0]){break b}while(1){if(!Ee(d)|(e|0)==(i|0)){break c}e=e+1|0;while(1){b=I[d+1|0];d=d+1|0;if((b&192)==128){continue}break}continue}}Y(23590,17858,1038,17494);D()}e=0;while(1){c=f;b=d;if(!Ee(b)){break b}while(1){g=Ee(c);j=Ee(b);while(1){h=I[c+1|0];k=c+1|0;c=k;if((h&192)==128){continue}break}c=b;while(1){h=I[c+1|0];b=c+1|0;c=b;if((h&192)==128){continue}break}if(!(!j|!g)){c=k;if((g|0)==(j|0)){continue}}break}if(g){while(1){b=I[d+1|0];d=d+1|0;if((b&192)==128){continue}break}l=l+1|0;continue}break}e=(i+l|0)+1|0}uc(a,e)}}function Jr(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0;g=Ea-32|0;Ea=g;h=H[e+24>>2];j=H[a>>2];i=sh(j,e,0);k=jb(j,f,0);if(i){H[i+48>>2]=-1;e=H[i+24>>2];H[e+24>>2]=H[e+24>>2]-1;H[i+24>>2]=0}a:{if(c){e=0;f=0;while(1){if(f>>>0<J[c+50>>1]){e=Pb(a,e,nk(a,G[H[c+4>>2]+(f<<1)>>1]));f=f+1|0;continue}break}h=I[h+43|0]==1?14:15;break a}e=I[h+43|0];if((e|0)==2){e=0;f=0;while(1)if(G[h+34>>1]<=(f|0)){h=14;break a}else{e=Pb(a,e,nk(a,f));f=f+1|0;continue}}h=(e|0)==1?14:15;e=ib(a,75,0,0);e=Yc(H[a>>2],e)}b:{if(!d){break b}l=d+8|0;f=0;while(1){if(H[d>>2]<=(f|0)){break b}e=Pb(a,e,jb(j,H[(f<<4)+l>>2],0));f=f+1|0;continue}}d=xd(a,e,i,k,0,0,0,276955136,0);if(d){H[d+4>>2]=H[d+4>>2]|134217728}H[g+24>>2]=0;H[g+16>>2]=0;H[g+20>>2]=0;H[g+8>>2]=b;F[g+4|0]=h;H[g+12>>2]=c?J[c+50>>1]:-1;Lc(a,d,g+4|0);fc(j,d);Ea=g+32|0}function _u(a,b,c,d,e){F[e+7|0]=c;F[e+3|0]=b;F[e+6|0]=c>>>8;F[e+5|0]=c>>>16;F[e+4|0]=c>>>24;F[e+2|0]=b>>>8;F[e+1|0]=b>>>16;F[e|0]=b>>>24;if(!H[a+104>>2]){b=H[a+88>>2];c=H[a+84>>2];F[e+8|0]=c;F[e+9|0]=c>>>8;F[e+10|0]=c>>>16;F[e+11|0]=c>>>24;F[e+12|0]=b;F[e+13|0]=b>>>8;F[e+14|0]=b>>>16;F[e+15|0]=b>>>24;c=!I[a+65|0];b=a+76|0;Uf(c,e,8,b,b);Uf(c,d,H[a+36>>2],b,b);b=H[a+76>>2];b=b<<24|(b&65280)<<8|(b>>>8&65280|b>>>24);F[e+16|0]=b;F[e+17|0]=b>>>8;F[e+18|0]=b>>>16;F[e+19|0]=b>>>24;a=H[a+80>>2];a=a<<24|(a&65280)<<8|(a>>>8&65280|a>>>24);F[e+20|0]=a;F[e+21|0]=a>>>8;F[e+22|0]=a>>>16;F[e+23|0]=a>>>24;return}F[e+8|0]=0;F[e+9|0]=0;F[e+10|0]=0;F[e+11|0]=0;F[e+12|0]=0;F[e+13|0]=0;F[e+14|0]=0;F[e+15|0]=0;F[e+16|0]=0;F[e+17|0]=0;F[e+18|0]=0;F[e+19|0]=0;F[e+20|0]=0;F[e+21|0]=0;F[e+22|0]=0;F[e+23|0]=0}function wi(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=H[a>>2];g=wb(h);m=H[H[a+4>>2]+12>>2];i=zb(h);j=zb(h);l=H[h+44>>2]+1|0;H[h+44>>2]=l;k=H[h+56>>2]-1|0;H[h+56>>2]=k;bk(a,c,i);bk(a,e,j);c=I[m+16|0];e=c&1;a=e?(b|0)==57?55:(b|0)==54?56:57:b;if(c&2){c=_a(g,51,i);a:{b:{switch(a-54|0){case 3:Sa(g,9,0,f);break a;case 0:Sa(g,51,j,f);break a;case 1:break b;default:break a}}Sa(g,50,j,f)}Sa(g,9,0,k);H[(I[H[g>>2]+87|0]?73336:H[g+104>>2]+N(c,20)|0)+8>>2]=H[g+108>>2];Sa(g,50,j,(a|0)==54?k:(a|0)==57?k:f)}fb(g,117,0,l,0,30558,-1);c=Ua(g,57,l,0,i);if((b|0)==57){Ua(g,a,j,f,i)}Ua(g,e?107:106,d,i,i);d=H[g+108>>2];H[(I[H[g>>2]+87|0]?73336:H[g+104>>2]+N(c,20)|0)+8>>2]=d;Ua(g,a,j,f,i);xc(g,Bf(h,H[m+8>>2]),-2);a=H[g+108>>2];if((a|0)>0){G[(H[g+104>>2]+N(a,20)|0)-18>>1]=128}hb(g,k);rb(h,i);rb(h,j)}function oE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;a:{if((b|0)==2){if((Kb(H[c>>2])|0)==5){Rb(a);return}i=$a(H[c>>2]);g=kb(H[c+4>>2]);b=Ha;h=b;if((b|0)<0){Gb(a,9065,-1);return}b=Ip(i);j=b;l=b>>31;c=l;b:{if((h|0)<=(c|0)&g>>>0<=b>>>0|(c|0)>(h|0)){b=Nl(i);if(!b){break a}qb(a,b,-1,-1);break b}m=tb(i);b=lc((m+(g-b|0)|0)+1|0);if(!b){break a}e=g-j|0;c=h-(l+(g>>>0<j>>>0)|0)|0;d=c>>>1|0;f=((c&1)<<31|e>>>1)+1|0;k=f?d:d+1|0;e=1;d=0;c=b;while(1){if((e|0)!=(f|0)|(d|0)!=(k|0)){F[c|0]=32;e=e+1|0;d=e?d:d+1|0;c=c+1|0;continue}break}e=f;d=0;c=Vg(c,i)+m|0;while(1){f=d+l|0;k=e+j|0;f=k>>>0<j>>>0?f+1|0:f;if((f|0)<=(h|0)&g>>>0>=k>>>0|(f|0)<(h|0)){F[c|0]=32;e=e+1|0;d=e?d:d+1|0;c=c+1|0;continue}break}F[c|0]=0}qb(a,b,-1,-1);Ta(b);return}Y(23600,17858,880,17778);D()}Ub(a)}function Ut(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=Ea-48|0;Ea=e;k=H[a+20>>2];f=d;a:{while(1){b:{if(!c|!H[a+16>>2]){break b}if(Tn(a,c)){break b}h=f-1|0;g=H[a+4>>2];if(Ia[H[g+220>>2]](g,c,e+44|0,0)|0){H[e+32>>2]=c;Oc(a,1968,e+32|0);break a}else{i=H[H[e+44>>2]+4>>2];c:{d:{e:{if(b){j=cb(i+4|0);g=H[a>>2];if(I[g+17|0]){Eg(a,c,2,0);g=H[a>>2]}if((H[g+40>>2]>>>2|0)-2>>>0<j>>>0){break e}c=0;g=(j|0)>0?j:0;l=i+8|0;while(1){if((c|0)!=(g|0)){f=cb((c<<2)+l|0);if(I[H[a>>2]+17|0]){Eg(a,f,2,0)}Tn(a,f);c=c+1|0;continue}break}f=h-j|0;break c}if(!I[H[a>>2]+17|0]|!h){break d}Eg(a,cb(i),4,c);break d}H[e+16>>2]=c;Oc(a,2067,e+16|0);f=f-2|0;break c}f=h}c=cb(i);jd(H[e+44>>2]);continue}}break}h=f}if(!(!h|H[a+20>>2]!=(k|0))){H[e>>2]=b?12809:12213;H[e+8>>2]=d;H[e+4>>2]=d-h;Oc(a,2143,e)}Ea=e+48|0}function fm(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=H[a+20>>2];b=H[d+104>>2];h=(b|0)>0?b:0;f=H[a+24>>2];a:{while(1){if((e|0)==(h|0)){break a}b:{c:{g=H[d+100>>2];i=g+N(e,48)|0;if(K[i+20>>2]<f>>>0){break c}if(kl(H[i+16>>2],f)){break c}while(1){e=e+1|0;if((b|0)<=(e|0)){break b}H[(N(e,48)+g|0)+28>>2]=0;continue}}e=e+1|0;continue}break}e=I[d+5|0];if((e|0)!=2){c=H[d+72>>2];if(!H[c>>2]){f=H[d>>2];if(I[d+22|0]|(e|0)==4){b=-1}else{b=H[16487]}c=cv(f,0,c,8222,b);if(c){break a}f=H[a+24>>2];c=H[d+72>>2]}e=H[a+4>>2];h=H[d+56>>2];b=H[d+172>>2];g=H[d+168>>2]+4|0;b=g>>>0<4?b+1|0:b;h=sJ(h,0,g,b);b=Ha;c=ei(c,h,b,f);if(c){break a}f=H[d+72>>2];g=H[d+168>>2];c=b;b=h+4|0;c=b>>>0<4?c+1|0:c;c=Ia[H[H[f>>2]+12>>2]](f,e,g,b,c)|0;if(c){break a}f=H[a+24>>2]}H[d+56>>2]=H[d+56>>2]+1;c=Xo(d,f)}return c}function Dw(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;C(+a);h=x(1)|0;x(0)|0;g=h&2147483640;g=(g|0)==1072010279|g>>>0<1072010279;if(!g){i=(h|0)>0|(h|0)>=0;a=.7853981633974483-P(a)+(3061616997868383e-32-(i?b:-b));b=0}e=a*a;d=a*e;j=d*.3333333333333341;f=d;d=e*e;e=j+(e*(f*(d*(d*(d*(d*(d*-18558637485527546e-21+7817944429395571e-20)+.0005880412408202641)+.0035920791075913124)+.021869488294859542)+.13333333333320124+e*(d*(d*(d*(d*(d*2590730518636337e-20+7140724913826082e-20)+.0002464631348184699)+.0014562094543252903)+.0088632398235993)+.05396825397622605))+b)+b);b=a+e;if(!g){f=b*b;d=b;b=+(1-(c<<1)|0);a=a+(e-f/(d+b));a=b-(a+a);return i?a:-a}if(c){f=-1/b;C(+f);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);d=+B();C(+b);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);b=+B();b=f*(d*(e-(b-a))+(d*b+1))+d}return b}function Vx(a){a=a|0;var b=0,c=0,d=0,e=0,f=0,g=0,h=0;e=Ea-16|0;Ea=e;a:{if(J[a+4>>1]<=1){c=H[a>>2];H[c+56>>2]=H[c+56>>2]+1;b:{if((vb(H[a+12>>2])|0)!=100){F[a+6|0]=1;b=ob(H[a+12>>2]);break b}g=a,h=Xc(H[a+12>>2],0),H[g+32>>2]=h;H[a+36>>2]=Ha;b=0}H[c+56>>2]=H[c+56>>2]-1;break a}H[e+12>>2]=0;b=H[a+16>>2];c:{if(b){while(1){if(!I[a+7|0]){ob(H[a+12>>2])}d=e+12|0;rd(a,b,d);c=I[b+32|0];H[a+88>>2]=1;F[a+7|0]=1;F[a+6|0]=c;f=H[b+28>>2];H[a+32>>2]=H[b+24>>2];H[a+36>>2]=f;if(!c){if(dq(a,d)){continue}}break}b=H[e+12>>2];if(b){break a}break c}F[a+6|0]=1}b=H[a+32>>2];c=H[a+36>>2];d:{e:{if(!I[a+52|0]){d=K[a+80>>2]<b>>>0;b=H[a+84>>2];if(d&(b|0)<=(c|0)|(b|0)<(c|0)){break e}break d}d=H[a+76>>2];if((d|0)<=(c|0)&K[a+72>>2]<=b>>>0|(c|0)>(d|0)){break d}}F[a+6|0]=1}b=0}Ea=e+16|0;return b|0}function cw(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;g=Ea-48|0;Ea=g;f=H[a+16>>2];Bc(H[f+88>>2]+40|0,b,c);a:{if(H[f+32>>2]>=5){H[f+32>>2]=4;e=Rr(f);break a}e=vb(H[a+16>>2])}b:{if((e|0)==100){e=11625;c:{c=J[a+8>>1];f=H[H[f+96>>2]>>2];if(c>>>0<J[f+54>>1]){b=f+84|0;e=H[b+(c<<2)>>2];if(e>>>0>11){break c}e=e?(e|0)==7?11847:9628:11625}b=H[a+20>>2];H[g>>2]=e;b=mb(b,6920,g);Wc(H[a+16>>2]);H[a+16>>2]=0;e=1;break b}H[a+4>>2]=H[(G[f+52>>1]+c<<2)+b>>2];H[a>>2]=e>>>0>=128?e-12>>>1|0:I[e+34112|0];b=a;a=H[f+36>>2];H[b+12>>2]=a;F[a+1|0]=I[a+1|0]|16;F[H[a+8>>2]+11|0]=1;b=0;e=0;break b}f=H[a+16>>2];if(!f){b=0;break b}e=Wc(f);H[a+16>>2]=0;a=H[a+20>>2];if(!e){H[g+16>>2]=b;H[g+20>>2]=c;e=1;b=mb(a,14953,g+16|0);break b}h=g,i=rg(a),H[h+32>>2]=i;b=mb(a,8863,g+32|0)}H[d>>2]=b;Ea=g+48|0;return e}function Sv(a,b,c){a=H[a+4>>2];a:{switch(b-204|0){case 0:case 35:case 36:case 48:fc(H[a>>2],H[c>>2]);return;case 12:case 13:case 42:case 44:case 63:case 74:case 76:case 79:case 86:case 91:case 107:eb(H[a>>2],H[c>>2]);return;case 17:case 27:case 28:case 40:case 43:case 45:case 49:case 50:case 57:case 64:case 73:case 75:case 106:pb(H[a>>2],H[c>>2]);return;case 34:case 41:case 52:case 53:case 58:Cc(H[a>>2],H[c>>2]);return;case 37:Pk(H[a>>2],H[c>>2]);return;case 47:case 102:ao(H[a>>2],H[c>>2]);return;case 59:case 66:re(H[a>>2],H[c>>2]);return;case 69:case 103:case 104:case 105:case 108:Rk(H[a>>2],H[c>>2]);return;case 82:case 87:Hn(H[a>>2],H[c>>2]);return;case 84:re(H[a>>2],H[c+4>>2]);return;case 110:case 111:case 112:eb(H[a>>2],H[c+4>>2]);break;default:break a}}}function Oz(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;e=I[c|0];if(!((e|0)!=177|d-54>>>0>3)){c=H[H[c+20>>2]+8>>2];e=I[c|0]}a:{if((e|0)!=167){d=H[a>>2];f=(d|0)>0?d:0;e=a+8|0;while(1){if((f|0)==(g|0)){break a}d=H[(e+(g<<6)|0)+16>>2]+8|0;b:{while(1){h=H[d>>2];if(!h){break b}d=h+20|0;if(!H[h+40>>2]){continue}break}i=a+8|0;c:{while(1){e=i+(g<<6)|0;d=H[e+16>>2]+8|0;e=H[e+40>>2];while(1){f=H[d>>2];if(f){d:{if(!H[f+40>>2]){break d}d=0;while(1){if(J[f+50>>1]<=d>>>0){break d}e:{if(J[H[f+4>>2]+(d<<1)>>1]!=65534){break e}if(ym(c,H[(H[f+40>>2]+(d<<4)|0)+8>>2],e)|I[c|0]==117){break e}H[b+4>>2]=-2;H[b>>2]=e;a=1;break c}d=d+1|0;continue}}d=f+20|0;continue}break}g=g+1|0;if((g|0)<H[a>>2]){continue}break}a=0}return a}g=g+1|0;continue}}H[b>>2]=H[c+28>>2];H[b+4>>2]=G[c+32>>1];i=1}return i}function Hm(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;d=Ea-48|0;Ea=d;a:{b:{c=I[b|0];if((c|0)!=138){if((c|0)!=167){break b}while(1){c=0;c:{while(1){if(!a|c){break c}c=0;e=H[a+4>>2];f=H[e>>2];f=(f|0)>0?f:0;h=e+8|0;d:{while(1){if((c|0)==(f|0)){break d}e=(c<<6)+h|0;if(H[e+40>>2]!=H[b+28>>2]){c=c+1|0;continue}break}g=H[e+20>>2];c=H[e+16>>2];continue}break}a=H[a+12>>2];continue}break}if(!c){break b}b=G[b+32>>1];if(g){c=0;if((b|0)<0){break a}e=H[g+28>>2];if(H[e>>2]<=(b|0)){break a}b=H[(e+(b<<4)|0)+8>>2];H[d+16>>2]=H[g+32>>2];H[d+24>>2]=a;H[d+12>>2]=H[a>>2];c=Hm(d+12|0,b);break a}if((b|0)<0){c=19474;break a}c=ql(H[c+4>>2]+N(b,12)|0,0);break a}b=H[b+20>>2];c=H[H[b+28>>2]+8>>2];H[d+16>>2]=H[b+32>>2];H[d+24>>2]=a;H[d+12>>2]=H[a>>2];c=Hm(d+12|0,c);break a}c=0}Ea=d+48|0;return c}function Og(a,b){var c=0,d=0,e=0;a:{b:{if(a){c=b-1|0;c:{while(1){if(K[a>>2]>=4001){d=H[a+8>>2];if(!d){break c}b=(c>>>0)/(d>>>0)|0;c=c-N(b,d)|0;b=(b<<2)+a|0;a=H[b+12>>2];if(a){continue}a=ej(d);H[b+12>>2]=a;if(a){continue}break a}break}a=(c>>>3|0)+a|0;F[a+12|0]=I[a+12|0]|1<<(c&7);return 0}d=c+1|0;e=a+12|0;b=(c>>>0)%125|0;c=H[e+(b<<2)>>2];d:{if(c){while(1){if((c|0)==(d|0)){return 0}b=b+1|0;b=b>>>0<=124?b:0;c=H[e+(b<<2)>>2];if(c){continue}break}c=H[a+4>>2];if(c>>>0<62){break d}break b}c=H[a+4>>2];if(c>>>0>=124){break b}}H[a+4>>2]=c+1;H[e+(b<<2)>>2]=d}return 0}b=bc(500,0);if(!b){break a}c=Va(b,e,500);b=0;Xa(e,0,500);H[a+8>>2]=(H[a>>2]+124>>>0)/125;e=Og(a,d);while(1){if((b|0)!=125){d=H[c+(b<<2)>>2];if(d){e=Og(a,d)|e}b=b+1|0;continue}break}Ta(c);return e}return 7}function Kh(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;d=I[a|0];e=d<<24>>24;a:{if((e|0)>=0){a=0;c=1;break a}c=F[a+1|0];if((c|0)>=0){d=e&127;a=d>>>25|0;d=c&255|d<<7;c=2;break a}c=c&255;e=F[a+2|0];d=(e&127|d<<14)&2080895;if((e|0)>=0){d=d|c<<7&16256;a=0;c=3;break a}e=F[a+3|0];c=(e&127|c<<14)&2080895;if((e|0)>=0){d=c|d<<7;a=0;c=4;break a}g=I[a+4|0];e=g|d<<14;h=g<<24>>24;if((h|0)>=0){a=d>>>18|0;d=c<<7|e;c=5;break a}f=F[a+5|0];g=f&255|c<<14;d=c|d<<7;if((f|0)>=0){a=d>>>18|0;d=e<<7&266354560|g;c=6;break a}f=F[a+6|0];c=f&255|e<<14;if((f|0)>=0){a=d>>>11|0;d=c&-266354561|g<<7&266354560;c=7;break a}f=F[a+7|0];e=f&255|g<<14;c=c&2080895;if((f|0)>=0){a=d>>>4|0;d=e&-266354561|c<<7;c=8;break a}c=e<<8&532709120|(I[a+8|0]|c<<15);a=h>>>3&15|d<<4;d=c|0;c=9}H[b>>2]=d;H[b+4>>2]=a;return c}function $b(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{b:{g=H[a+4>>2];if(g>>>0<b>>>0){break b}j=H[a>>2];e=j+b|0;f=I[e|0];d=f>>>4|0;i=1;c:{if(f>>>0<=191){break c}d:{switch(d-12|0){case 0:f=0;d=b+1|0;if(d>>>0>=g>>>0){break a}d=I[d+j|0];i=2;break c;case 1:f=0;d=b+2|0;if(d>>>0>=g>>>0){break a}d=I[d+j|0]|I[e+1|0]<<8;i=3;break c;case 2:f=0;d=b+4|0;if(d>>>0>=g>>>0){break a}d=I[d+j|0]|(I[e+2|0]<<16|I[e+1|0]<<24|I[e+3|0]<<8);i=5;break c;default:break d}}d=b+8|0;if(I[e+1|0]|d>>>0>=g>>>0|(I[e+2|0]|I[e+3|0])){break b}f=0;if(I[e+4|0]){break a}d=I[d+j|0]|(I[e+6|0]<<16|I[e+5|0]<<24|I[e+7|0]<<8);i=9}f=i;e=b+d|0;b=e>>>0<b>>>0?1:h;h=e+f|0;b=h>>>0<e>>>0?b+1|0:b;if(!b&h>>>0<=g>>>0){h=d;break a}a=!b&g-H[a+40>>2]>>>0<h>>>0|(b|0)!=0;f=a?0:f;h=a?0:d;break a}f=0}H[c>>2]=h;return f}function Ur(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0;f=Ea-32|0;Ea=f;a:{c=H[b+24>>2]+H[b+36>>2]|0;if(H[a+36>>2]|!c){break a}h=H[a+8>>2];d=H[b+12>>2];Ua(h,75,0,d,(c+d|0)-1|0);c=H[b+32>>2];while(1){if(H[b+36>>2]<=(i|0)){break a}b:{if(H[c+8>>2]<0){break b}d=H[H[c>>2]+20>>2];if(!(H[d>>2]==1?d:0)){Wa(a,2846,0);H[c+8>>2]=-1;break b}d=Oe(a,d,0,0);j=c,k=fb(h,118,H[c+8>>2],0,0,d,-8),H[j+12>>2]=k;H[f+16>>2]=H[H[c+4>>2]+32>>2];gc(a,0,25633,f+16|0)}if(H[c+16>>2]>=0){d=!I[c+21|0];e=H[c>>2];g=H[e+12>>2];d=I[c+20|0]?H[H[e+20>>2]>>2]+d|0:d;g=H[g+20>>2];d=I[c+22|0]?H[H[e+20>>2]>>2]+d|0:d;e=Oe(a,g,0,d);if(!(I[c+21|0]|H[a+36>>2])){G[e+6>>1]=J[e+6>>1]+1}fb(h,118,H[c+16>>2],H[g>>2]+d|0,0,e,-8);H[f>>2]=H[H[c+4>>2]+32>>2];gc(a,0,25600,f)}c=c+24|0;i=i+1|0;continue}}Ea=f+32|0}function Qw(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;if(a>>>0<=8){return De(b)|0}c=16;d=a>>>0<=16?16:a;a:{if(!(d-1&d)){a=d;break a}while(1){a=c;c=a<<1;if(a>>>0<d>>>0){continue}break}}b:{if(-64-a>>>0<=b>>>0){H[18340]=48;b=0;break b}d=b>>>0<11?16:b+11&-8;c=De((d+a|0)+12|0);b=0;if(!c){break b}b=c-8|0;c:{if(!(c&a-1)){a=b;break c}f=c-4|0;g=H[f>>2];e=a;a=((a+c|0)-1&0-a)-8|0;a=(a-b>>>0<=15?e:0)+a|0;c=a-b|0;e=(g&-8)-c|0;if(!(g&3)){b=H[b>>2];H[a+4>>2]=e;H[a>>2]=b+c;break c}H[a+4>>2]=e|H[a+4>>2]&1|2;e=a+e|0;H[e+4>>2]=H[e+4>>2]|1;H[f>>2]=c|H[f>>2]&1|2;e=b+c|0;H[e+4>>2]=H[e+4>>2]|1;Ml(b,c)}b=H[a+4>>2];d:{if(!(b&3)){break d}c=b&-8;if(c>>>0<=d+16>>>0){break d}H[a+4>>2]=d|b&1|2;b=a+d|0;d=c-d|0;H[b+4>>2]=d|3;c=a+c|0;H[c+4>>2]=H[c+4>>2]|1;Ml(b,d)}b=a+8|0}return b|0}function kG(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0;c=Ea-32|0;Ea=c;h=1;i=H[H[a>>2]+12>>2];f=a+8|0;$g(f);Ta(H[a+72>>2]);Ta(H[a+120>>2]);Ta(H[a+88>>2]);j=Xa(f,0,120);k=(b|0)==1;a:{if(k){f=-1;b=3;break a}m=1;g=b>>>1&1;b=b&4;h=b?g?2:1:g;f=b?g:-1;b=19}H[a+84>>2]=b;l=a+72|0;b:{c:{d:{if(!(g|k)){break d}b=$a(H[e>>2]);if(!b){break d}H[c+16>>2]=b;b=Ab(8863,c+16|0);H[l>>2]=b;if(!b){break c}n=a,o=tb(b),H[n+76>>2]=o}b=0;if((f|0)>=0){n=c,o=$a(H[(f<<2)+e>>2]),H[n>>2]=o;f=Ab(8863,c);H[a+88>>2]=f;if(!f){break c}n=a,o=tb(f),H[n+92>>2]=o}if((d|0)>(h|0)){b=kb(H[(h<<2)+e>>2]);b=(b|0)>0?b:0}H[a+96>>2]=b;b=hi(i,b,0,-2,H[a+72>>2],H[a+76>>2],0,m,j);if(b){break b}b=Qj(i,j,l);if(b){break b}b=yy(a);break b}b=7}Ea=c+32|0;return b|0}function Fh(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;e=Ea-48|0;Ea=e;a:{if(Yh(a,32)){F[a+18|0]=0;a=7;break a}j=H[a+8>>2];d=J[a+16>>1];b:{if(d&4){g=H[a>>2];d=H[a+4>>2];l=d;F[e+37|0]=0;h=d;i=g;d=d>>31;g=d;f=i^d;d=f-d|0;h=(g^h)-((f>>>0<g>>>0)+g|0)|0;f=20;while(1){g=vJ(d,h,10,0);i=Ha;m=(e+16|0)+f|0,n=d-sJ(g,i,10,0)|48,F[m|0]=n;if(!(!h&d>>>0<10)){f=f-1|0;d=g;h=i;continue}break}if((l|0)<0){f=f-1|0;F[f+(e+16|0)|0]=45}Va(j,(e+16|0)+f|0,22-f|0);f=21-f|0;break b}G[e+36>>1]=0;H[e+28>>2]=0;H[e+32>>2]=0;H[e+16>>2]=0;H[e+20>>2]=j;H[e+24>>2]=32;if(d&32){k=+K[a>>2]+ +H[a+4>>2]*4294967296}else{k=M[a>>3]}M[e>>3]=k;lb(e+16|0,12578,e);f=H[e+32>>2];F[j+f|0]=0}H[a+12>>2]=f;F[a+18|0]=1;d=J[a+16>>1]|514;G[a+16>>1]=c?d&65491:d;Pd(a,b);a=0}Ea=e+48|0;return a}function Oh(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;d=H[a+52>>2];b=H[a+56>>2]+I[a+9|0]|0;if(Gu(a,I[b|0])){return Ya(72326)}c=H[d+36>>2];F[a+12|0]=0;G[a+26>>1]=c-1;e=H[a+56>>2];f=I[a+10|0];H[a+68>>2]=e+f;H[a+60>>2]=c+e;H[a+64>>2]=(b+f|0)+8;G[a+18>>1]=(f+I[a+9|0]|0)+8;b=I[b+3|0]|I[b+4|0]<<8;b=b<<8|b>>>8;G[a+24>>1]=b;if((c-8>>>0)/6>>>0<(b&65535)>>>0){return Ya(72340)}F[a|0]=1;H[a+20>>2]=-1;if(I[H[d+4>>2]+34|0]&32){b=0;e=H[H[a+52>>2]+40>>2];f=e+(I[a+8|0]?-4:-5)|0;h=H[a+56>>2];c=J[a+18>>1];i=h+c|0;j=c+(J[a+24>>1]<<1)|0;c=0;a:{b:{while(1){if(J[a+24>>1]<=c>>>0){break a}d=(c<<1)+i|0;d=I[d|0]<<8|I[d+1|0];g=72289;if(d>>>0<j>>>0|(d|0)>(f|0)){break b}c=c+1|0;if((e|0)>=((Ia[H[a+76>>2]](a,d+h|0)|0)+d|0)){continue}break}g=72294}b=Ya(g)}}else{b=0}return b}function Kt(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;g=Ea-16|0;Ea=g;i=H[a+4>>2];h=H[H[a+8>>2]+4>>2];d=Wn(H[a+12>>2]+N(h,56)|0);if(!d){H[g+12>>2]=0;c=H[a+12>>2];e=c+N(h|1,56)|0;f=N(h&65534,56)+c|0;d=(H[a>>2]+h|0)/2|0;while(1){if((d|0)>0){a:{b:{if(!H[f+24>>2]){break b}c:{d:{if(!H[e+24>>2]){break d}c=Ia[H[i+40>>2]](i,g+12|0,H[f+32>>2],H[f+20>>2],H[e+32>>2],H[e+20>>2])|0;if((c|0)<0){break d}if(c|e>>>0<=f>>>0){break c}}e=H[a+8>>2];c=H[a+12>>2];H[e+(d<<2)>>2]=(f-c|0)/56;e=H[e+((d^1)<<2)>>2];H[g+12>>2]=0;e=N(e,56)+c|0;break a}if(!H[f+24>>2]){break b}H[g+12>>2]=0}f=H[a+8>>2];c=H[a+12>>2];H[f+(d<<2)>>2]=(e-c|0)/56;f=N(H[f+((d^1)<<2)>>2],56)+c|0}d=d>>>1|0;continue}break}H[b>>2]=!H[(N(H[H[a+8>>2]+4>>2],56)+c|0)+24>>2];d=I[H[i+16>>2]+23|0]}Ea=g+16|0;return d}function dJ(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;e=Ea-16|0;Ea=e;a:{if(!H[b+52>>2]){break a}d=H[b+48>>2];if(!d){break a}c=b;while(1){if(!c){break a}b:{switch(I[c|0]-135|0){case 0:case 3:c=H[c+52>>2];continue;default:break b}}break}if(J[d+20>>1]){break a}f=d+8|0;c=H[d>>2];while(1){if((c|0)<=0){break a}c=c-1|0;if(!(I[H[f+(c<<4)>>2]+5|0]&2)){continue}break}g=2;c=H[a>>2];d=H[c>>2];a=nb(d,76,0);if(!a){break a}H[e+8>>2]=0;H[e+12>>2]=0;f=Pe(c,0,0,0,e+8|0,a,0);if(!f){break a}a=Va(a,b,76);H[b+32>>2]=f;d=oc(d,180,0);c=Yc(H[c>>2],d);H[b+36>>2]=0;F[b|0]=138;H[b+28>>2]=c;H[a+48>>2]=0;H[a+40>>2]=0;H[a+44>>2]=0;H[b+72>>2]=0;H[b+64>>2]=0;H[b+52>>2]=0;H[b+56>>2]=0;H[b+4>>2]=H[b+4>>2]&-65793|65536;H[H[a+52>>2]+56>>2]=a;H[a+60>>2]=0;g=0}Ea=e+16|0;return g|0}function xv(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;c=Ea-32|0;Ea=c;d=I[a+16|0];a:{if((d|0)<=(b|0)){break a}e=H[a+8>>2];b:{if(d>>>0>=2){c:{if((b|0)!=1){break c}H[c+16>>2]=510;H[c+20>>2]=0;H[c>>2]=0;d=H[16644]+2|0;H[c+8>>2]=d;H[c+12>>2]=d>>31;if(!Ng(a,c)){break c}H[a+20>>2]=H[18340];g=2314;break a}H[c>>2]=2;H[c+16>>2]=2;H[c+20>>2]=0;d=H[16644];H[c+8>>2]=d;H[c+12>>2]=d>>31;if(Ng(a,c)){break b}F[e+28|0]=1}d=a+16|0;if(!b){f=H[e+20>>2]-1|0;H[e+20>>2]=f;if(f){f=1}else{H[c+16>>2]=0;H[c+20>>2]=0;H[c+8>>2]=0;H[c+12>>2]=0;H[c>>2]=2;f=Ng(a,c);if(f){H[a+20>>2]=H[18340];F[e+28|0]=0;g=2058;h=d}else{h=e+28|0}F[h|0]=0;f=!f}h=e;e=H[e+24>>2]-1|0;H[h+24>>2]=e;if(!e){wv(a)}if(!f){break a}}F[d|0]=b;g=0;break a}H[a+20>>2]=H[18340];g=2058}Ea=c+32|0;return g|0}function PB(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;b=Ea-80|0;Ea=b;f=H[a>>2];Pn(a);c=0;i=(d|0)>0?d:0;h=a+16|0;d=!(I[H[f+16>>2]+5|0]&32);a:{b:{while(1){if((c|0)!=(i|0)){g=$a(H[(c<<2)+e>>2]);if(g){H[b+48>>2]=g;g=Ab(8863,b+48|0);H[(d<<2)+h>>2]=g;if(!g){break b}}d=d+1|0;c=c+1|0;continue}break}c=H[H[f+12>>2]+124>>2];G[b+76>>1]=0;H[b+72>>2]=0;H[b+68>>2]=c;H[b+64>>2]=0;H[b+56>>2]=0;H[b+60>>2]=0;c=b+56|0;Vd(c,30416);d=H[a+20>>2];if(d){H[b+32>>2]=d;lb(c,24833,b+32|0)}c=b+56|0;Vd(c,H[H[f+16>>2]>>2]);d=H[h>>2];if(d){H[b+16>>2]=d;lb(c,19583,b+16|0)}d=Jd(b+56|0);if(!d){break b}c=ph(H[f+12>>2],d,-1,a+4|0,0);Ta(d);if(c){j=b,k=rg(H[f+12>>2]),H[j>>2]=k;j=f,k=Ab(8863,b),H[j+8>>2]=k;break a}c=$s(a);break a}c=7}Ea=b+80|0;return c|0}function Kq(a){var b=0,c=0,d=0,e=0,f=0;if(!I[a+42|0]){a:{b:{if(!I[a+40|0]){H[a+8>>2]=2e3;H[a+12>>2]=1;e=16;b=1;break b}c=H[a+4>>2];b=H[a>>2];if((c|0)==108096&b>>>0>=275971584|c>>>0>108096){a=Xa(a,0,48)+46|0;break a}b=b+432e5|0;c=b>>>0<432e5?c+1|0:c;b=vJ(b,c,864e5,0);d=(+(b>>>0)+-1867216.25)/36524.25;c:{if(P(d)<2147483648){c=~~d;break c}c=-2147483648}b=((c+b|0)+((c|0)/-4|0)|0)+1525|0;d=(+(b|0)+-122.1)/365.25;d:{if(P(d)<2147483648){c=~~d;break d}c=-2147483648}b=b-((N(c&32767,36525)>>>0)/100|0)|0;d=+(b|0)/30.6001;e:{if(P(d)<2147483648){e=~~d;break e}e=-2147483648}f=((e|0)<14?-1:-13)+e|0;H[a+12>>2]=f;d=+(e|0)*30.6001;f:{if(P(d)<2147483648){e=~~d;break f}e=-2147483648}H[a+16>>2]=b-e;e=8;b=c+((f|0)>2?-4716:-4715)|0}H[a+e>>2]=b;a=a+42|0}F[a|0]=1}}function Pe(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0;i=Ea-16|0;Ea=i;j=H[a>>2];a:{b:{c:{d:{if(!g|b){break d}if(H[g>>2]){b=19921}else{if(!H[g+4>>2]){break d}b=20202}H[i>>2]=b;Wa(a,6884,i);break c}b=Gd(a,b,c,d);if(b){h=((H[b>>2]<<6)+b|0)-56|0;e:{if(I[a+220|0]<2){break e}k=H[h+8>>2];if(!k){break e}ue(a,k,(H[d>>2]?d:0)?d:c)}if(H[e+4>>2]){l=h,m=tc(j,e),H[l+12>>2]=m}f:{if(!f){break f}H[h+20>>2]=f;if(!(I[f+5|0]&8)){break f}a=I[h+37|0]|I[h+38|0]<<8|8192;F[h+37|0]=a;F[h+38|0]=a>>>8}if(!g){H[h+44>>2]=0;break a}if(H[g+4>>2]){a=I[h+37|0]|I[h+38|0]<<8|1024;F[h+37|0]=a;F[h+38|0]=a>>>8;H[h+44>>2]=H[g+4>>2];break a}H[h+44>>2]=H[g>>2];break a}if(!g){break b}}a=H[g>>2];if(a){he(j,a);break b}a=H[g+4>>2];if(!a){break b}re(j,a)}fc(j,f);b=0}Ea=i+16|0;return b}function sl(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0,n=0;a:{if(!(!b|(h?f:0)|((!h|0)==((g|0)!=0|0)|c-128>>>0<4294967167|!i^!j))){if(bb(b)>>>0<256){break a}}return Rc(180122)}m=d&20449280;b:{c:{d:{e:{f:{d=d&7;switch(d-1|0){case 0:case 1:case 2:break c;case 4:break e;case 3:break f;default:break d}}d=2;break c}l=sl(a,b,c,m|1,e,f,g,h,i,j,k);if(l){break b}l=sl(a,b,c,m|2,e,f,g,h,i,j,k);if(l){break b}d=3;break c}d=1}l=0;n=Te(a,b,c,d,0);g:{if(!(!n|(H[n+4>>2]&3)!=(d|0)|F[n|0]!=(c|0))){if(H[a+184>>2]){ae(a,5,4065,0);return 5}_f(a,0);break g}if(!(f|h)){break b}}b=Te(a,b,c,d,1);if(!b){return 7}Rw(a,b);if(k){H[k>>2]=H[k>>2]+1}H[b+36>>2]=k;H[b+28>>2]=j;H[b+24>>2]=i;H[b+20>>2]=h;H[b+8>>2]=e;F[b|0]=c;H[b+16>>2]=f?f:g;H[b+4>>2]=(H[b+4>>2]&3|m)^2097152}return l}function Oq(a){var b=0,c=0,d=0,e=0,f=0;a:{if(H[a+48>>2]){break a}e=H[a+12>>2];b=H[e+56>>2];f=Vb(H[e+72>>2]);if(f){break a}f=0;c=H[8295];d=H[8294];F[b+8|0]=d;F[b+9|0]=d>>>8;F[b+10|0]=d>>>16;F[b+11|0]=d>>>24;F[b+12|0]=c;F[b+13|0]=c>>>8;F[b+14|0]=c>>>16;F[b+15|0]=c>>>24;c=H[8293];d=H[8292];F[b|0]=d;F[b+1|0]=d>>>8;F[b+2|0]=d>>>16;F[b+3|0]=d>>>24;F[b+4|0]=c;F[b+5|0]=c>>>8;F[b+6|0]=c>>>16;F[b+7|0]=c>>>24;F[b+16|0]=H[a+36>>2]>>>8;F[b+17|0]=J[a+38>>1];F[b+18|0]=1;F[b+19|0]=1;c=H[a+40>>2];d=H[a+36>>2];F[b+21|0]=64;F[b+22|0]=32;F[b+23|0]=32;F[b+20|0]=d-c;Xa(b+24|0,0,76);Jh(e,13);G[a+24>>1]=J[a+24>>1]|2;F[b+55|0]=I[a+17|0];F[b+54|0]=0;F[b+52|0]=0;F[b+53|0]=0;F[b+67|0]=I[a+18|0];F[b+66|0]=0;F[b+64|0]=0;F[b+65|0]=0;H[a+48>>2]=1;F[b+31|0]=1}return f}function bc(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;a:{b=b-(a>>>0<2147483392)|0;b:{if((b|0)==-1&a-2147483392>>>0<2147483905|(b|0)!=-1){break b}if(H[16480]){d=Ia[H[16492]](a)|0;if(a>>>0>K[18223]){H[18223]=a}a=H[18233];f=a;c=H[18232];c:{if(!c&(a|0)<=0|(a|0)<0){break c}a=H[18208];b=c-d|0;e=f;f=d>>31;c=e-(f+(c>>>0<d>>>0)|0)|0;if((c|0)<0){b=1}else{b=(c|0)<=0&a>>>0>=b>>>0}if(b){H[18236]=1;e=H[18234];b=e-d|0;c=H[18235];g=!(c|e);c=c-((d>>>0>e>>>0)+f|0)|0;if((c|0)>0){a=1}else{a=a>>>0<b>>>0&(c|0)>=0}if(g|a){break c}break b}H[18236]=0}b=Ia[H[16488]](d)|0;if(!b){break b}a=(Ia[H[16491]](b)|0)+H[18208]|0;H[18208]=a;if(a>>>0>K[18218]){H[18218]=a}a=H[18217]+1|0;H[18217]=a;if(a>>>0<=K[18227]){break a}H[18227]=a;break a}h=Ia[H[16488]](a)|0}return h}return b}function NA(a,b){a=a|0;b=b|0;var c=0,d=0,e=0;a:{d=J[a+20>>1];b:{c:{if(!(!(F[b+4|0]&1)|(d|0)!=2)){break c}d:{e:{f:{g:{h:{e=I[b|0];switch(e-167|0){case 3:case 4:case 6:case 7:case 8:case 10:case 11:break b;case 9:case 12:break c;case 0:case 1:case 2:break e;case 5:break g;default:break h}}if((e|0)==59){break f}if((e|0)==141){break c}if((e|0)==156){break d}break a}c=H[b+4>>2];if(!(!(c&1048576)&d>>>0<=3|c&16777216)){if((d|0)!=5){break a}H[b+4>>2]=c|1073741824;break a}break c}c=1;if(Ek(b)){break b}}d=J[a+20>>1];if(I[b+4|0]&32){c=0;if((d|0)==2){break c}break b}if((d|0)!=3){break c}c=0;if(H[b+28>>2]==H[a+24>>2]){break b}break c}i:{switch(d-4|0){case 1:F[b|0]=121;break a;case 0:break i;default:break b}}}G[a+20>>1]=0;c=2}return c|0}return 0}function ec(a,b){var c=0,d=0,e=0,f=0;a:{if(!b|!H[a+8>>2]){break a}while(1){c=Ia[H[a+8>>2]](a,b)|0;if(c){return c&2}f=2;if(hc(a,H[b+28>>2])){break a}if(Jb(a,H[b+36>>2])){break a}if(hc(a,H[b+40>>2])){break a}if(Jb(a,H[b+44>>2])){break a}if(hc(a,H[b+48>>2])){break a}if(Jb(a,H[b+60>>2])){break a}d=H[b+72>>2];b:{if(!d){break b}c=H[a+12>>2];c:{if((c|0)==13){break c}e=H[a>>2];if(e){if((c|0)==41|I[e+220|0]>1){break c}break b}if((c|0)!=41){break b}}if(MA(a,d,0)){break a}}d:{d=H[b+32>>2];if(!d){break d}c=d+8|0;d=H[d>>2];while(1){if((d|0)<=0){break d}e=H[c+20>>2];if(e){if(ec(a,e)){break a}}if(I[c+37|0]&4){if(hc(a,H[c+56>>2])){break a}}c=c- -64|0;d=d-1|0;continue}}c=H[a+12>>2];if(c){Ia[c|0](a,b)}f=0;b=H[b+52>>2];if(b){continue}break}}return f}function bq(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;f=Ea-32|0;Ea=f;H[f+28>>2]=0;H[f+24>>2]=0;H[f+20>>2]=0;H[f+12>>2]=0;a:{if(!c){H[e>>2]=0;break a}g=H[a+36>>2];j=H[g>>2];g=jg(g,b,c,-1,f+8|0);if(g){break a}m=H[j+20>>2];k=H[f+8>>2];b=0;c=0;b:while(1){c:{if(c){break c}c=Ia[m|0](k,f+16|0,f+12|0,f+28|0,f+24|0,f+20|0)|0;if(c){break c}c=1;h=H[f+20>>2];b=(b|0)>(h|0)?b:h+1|0;if((h|0)<0){break c}i=H[f+16>>2];if(!i){break c}l=H[f+12>>2];if((l|0)<=0){break c}g=1;c=lx(a,d,h,H[a+264>>2]+4|0,i,l);while(1){if(H[a+260>>2]<=(g|0)|c){continue b}c=0;h=H[a+264>>2]+N(g,24)|0;i=H[h>>2];if((i|0)<=H[f+12>>2]){c=lx(a,d,H[f+20>>2],h+4|0,H[f+16>>2],i)}g=g+1|0;continue}}break}Ia[H[j+16>>2]](k)|0;H[e>>2]=H[e>>2]+b;g=(c|0)!=101?c:0}Ea=f+32|0;return g}function nI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;e=Ea-16|0;Ea=e;d=$a(H[c>>2]);H[e+8>>2]=d;f=xb(H[c>>2]);a:{if((b|0)!=2){h=30558;b=0;break a}h=$a(H[c+4>>2]);b=xb(H[c+4>>2])}b:{if(!d|!h){break b}c:{c=((f|0)/2|0)+1|0;g=ch(a,c,c>>31);if(!g){f=0;break c}i=b+h|0;f=g;while(1){b=I[d|0];if(!b){break c}d:{if(!(I[b+31152|0]&8)){e:{if(b<<24>>24>=0){H[e+8>>2]=d+1;break e}b=pd(e+8|0)}H[e+12>>2]=h;while(1){c=H[e+12>>2];if(c>>>0>=i>>>0){break d}d=F[c|0];f:{if((d|0)>=0){H[e+12>>2]=c+1;break f}d=pd(e+12|0)}if((b|0)!=(d|0)){continue}break}d=H[e+8>>2];continue}c=d+2|0;H[e+8>>2]=c;d=I[d+1|0];if(!(I[d+31152|0]&8)){break d}F[f|0]=d+(d<<25>>31&9)&15|(b<<25>>31&9)+b<<4;f=f+1|0;d=c;continue}break}Ta(g);break b}le(a,g,f-g|0,1)}Ea=e+16|0}function GH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=Ea-304|0;Ea=b;e=H[H[a>>2]+20>>2];d=kb(H[c>>2]);h=$a(H[c+4>>2]);f=kb(H[c+8>>2]);c=H[H[e+16>>2]+(d<<4)>>2];j=H[e+364>>2];H[e+364>>2]=0;c=ak(b+20|0,c,e,h,(d|0)==1);a:{if(c){break a}b:{c=H[b+268>>2];c:{if(!c){break c}d=G[c+34>>1];if((d|0)==1){break c}if((d|0)>(f|0)){break b}}c=Ya(117565);break a}g=b+20|0;i=N(f,12);d=Vc(g,0,H[i+H[c+4>>2]>>2]);d:{if((f|0)<(G[c+34>>1]-1|0)){f=H[Vc(g,0,H[(i+H[c+4>>2]|0)+12>>2])+4>>2];c=H[d+4>>2];break d}f=H[c+44>>2]+h|0;c=H[d+4>>2];while(1){g=I[c|0];if(!g|(g|0)==44){break d}c=c-1|0;H[d+4>>2]=c;continue}}H[b+8>>2]=f;H[b+4>>2]=h;H[b>>2]=c-h;c=mb(e,6091,b);qb(a,c,-1,-1);Ta(c);c=0}_j(b+20|0);H[e+364>>2]=j;if(c){Xd(a,c)}Ea=b+304|0}function xx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=Ea-16|0;Ea=h;a:{b:{j=H[b+8>>2];if(!j){break b}m=I[a+239|0]?104:105;i=H[b>>2];g=i;while(1){if(!H[H[g>>2]+80>>2]){break b}f=H[i>>2];k=H[f+88>>2];l=H[f+92>>2];g=1;f=am(a,f,h+12|0,h+8|0);c:{while(1){if(!((g|0)>=(j|0)|f)){f=H[(g<<2)+i>>2];if(!H[f+80>>2]|(H[f+88>>2]!=(k|0)|(l|0)!=H[f+92>>2])){break c}g=g+1|0;f=am(a,f,0,0);continue}break}if(f){break a}}fi(H[b>>2],j,g,m);g=H[h+8>>2];if(!(!H[H[i>>2]+56>>2]|(g|0)<=0)){f=my(b,H[h+12>>2],g+1|0,0);if(f){break a}H[h+12>>2]=H[b+16>>2]}f=H[b+32>>2];if((f|0)>=0){jy(f,1,h+12|0,h+8|0);g=H[h+8>>2]}if((g|0)>0){H[d>>2]=H[h+12>>2];H[c>>2]=k;H[c+4>>2]=l;H[e>>2]=g;f=0;break a}else{g=H[b>>2];continue}}}f=0;H[d>>2]=0}Ea=h+16|0;return f}function MC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=H[a+4>>2];i=H[f+36>>2];if(i&4){return 778}a=e+(c>>31)|0;k=c+d|0;a=k>>>0<d>>>0?a+1|0:a;g=H[f>>2];h=H[f+4>>2];a:{if(g>>>0<k>>>0&(h|0)<=(a|0)|(a|0)>(h|0)){j=H[f+12>>2];if(k>>>0>K[f+8>>2]&(a|0)>=(j|0)|(a|0)>(j|0)){h=13;if(!(i&2)|H[f+32>>2]>0){break a}g=H[f+16>>2];i=H[f+20>>2];if(k>>>0>g>>>0&(a|0)>=(i|0)|(a|0)>(i|0)){break a}j=k<<1;h=j;l=g;j=g>>>0>j>>>0;g=a<<1|k>>>31;j=j&(g|0)<=(i|0)|(g|0)<(i|0);h=j?h:l;g=j?g:i;i=Ld(H[f+24>>2],h,g);if(!i){return 3082}H[f+8>>2]=h;H[f+12>>2]=g;H[f+24>>2]=i;h=H[f+4>>2];g=H[f>>2]}if(d>>>0>g>>>0&(e|0)>=(h|0)|(e|0)>(h|0)){Xa(H[f+24>>2]+g|0,0,d-g|0)}H[f>>2]=k;H[f+4>>2]=a}Va(H[f+24>>2]+d|0,b,c);h=0}return h|0}function xt(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=H[a+116>>2];d=H[a+40>>2];e=J[a+48>>1];if(!(K[c+60>>2]>=d+e>>>0&d>>>0>=H[c+56>>2]+J[c+18>>1]>>>0)){return Ya(79336)}f=e;e=H[b+32>>2]+H[b+28>>2]|0;if((f|0)==(e|0)){return Ok(c,d,b,0,e)}e=Ea-16|0;Ea=e;d=H[b+32>>2];g=H[b+28>>2];f=H[a+116>>2];H[e+12>>2]=f;c=Ok(f,H[a+40>>2],b,0,J[a+48>>1]);a:{if(c){break a}g=d+g|0;d=J[a+48>>1];h=cb(d+H[a+40>>2]|0);i=H[f+52>>2];f=H[i+40>>2]-4|0;while(1){c=qd(i,h,e+12|0,0);if(c){break a}a=H[e+12>>2];b:{if(!(H[H[a+72>>2]+32>>2]==1&!I[a|0])){c=Ya(79308);break b}c:{if(g>>>0>d+f>>>0){c=H[a+56>>2];h=cb(c);break c}f=g-d|0;c=H[a+56>>2]}c=Ok(a,c+4|0,b,d,f)}jd(H[a+72>>2]);if(c){break a}d=d+f|0;if((g|0)>(d|0)){continue}break}c=0}Ea=e+16|0;return c}function Wi(a,b){var c=0,d=0,e=0;if(I[b+5|0]&16){c=H[b+80>>2];H[b+80>>2]=0;F[b+5|0]=I[b+5|0]&239;d=H[c>>2];if(d){Tg(d);H[c>>2]=0}db(H[a>>2],c);Wi(a,b);return}a:{b:{switch(I[b|0]){case 1:c=H[b+36>>2];if(!c){break a}a=H[a>>2];pu(a,c);Ta(H[c+44>>2]);db(a,c);H[b+36>>2]=0;return;case 0:c=H[b+36>>2];e=H[c+8>>2];if(!e){break a}d=H[c+20>>2];H[H[e+4>>2]+4>>2]=H[e>>2];a=H[d+8>>2];c:{if((c|0)==(a|0)){H[d+8>>2]=H[c+24>>2];break c}while(1){b=H[a+24>>2];if((b|0)==(c|0)){H[a+24>>2]=H[c+24>>2];break c}a=b;if(b){continue}break}}Ih(c);Ho(d);Ta(H[c+12>>2]);Ta(H[c+16>>2]);if(!(H[d+8>>2]|!(I[d+16|0]&4))){rf(e)}H[c+8>>2]=0;return;case 2:break b;default:break a}}b=H[b+36>>2];a=H[b>>2];H[a+4>>2]=H[a+4>>2]-1;Ia[H[H[a>>2]+28>>2]](b)|0}}function xG(a){a=a|0;var b=0,c=0;c=Uv(a,1414,55920);a:{if(c){break a}b=lc(24);if(!b){return 7}H[b+4>>2]=0;H[b+8>>2]=0;G[b>>1]=257;H[b+12>>2]=0;H[b+16>>2]=0;H[b+20>>2]=0;c=7;b:{if(Rj(b,14007,7,56192)){break b}if(Rj(b,9225,7,56220)){break b}if(Rj(b,23746,10,53036)){break b}c=tl(a,9147,1,524289,b,98,0,0);if(c){break b}c=tl(a,9147,2,524289,b,98,0,0);if(c){break b}c=Th(a,3415,-1);if(c){break b}c=Th(a,4196,1);if(c){break b}c=Th(a,10120,1);if(c){break b}c=Th(a,10120,2);if(c){break b}c=Th(a,12827,1);if(c){break b}H[b+20>>2]=H[b+20>>2]+1;c=wl(a,23488,52936,b,99);if(c){break a}H[b+20>>2]=H[b+20>>2]+1;c=wl(a,23359,52936,b,99);if(c){break a}H[b+20>>2]=H[b+20>>2]+1;return wl(a,12814,56644,b,99)|0}dm(b);Ta(b)}return c|0}function _v(a,b){var c=0,d=0,e=0,f=0,g=0,h=0;e=H[b>>2];f=H[a+12>>2];h=H[f+64>>2];G[a+152>>1]=J[a+152>>1]&65343|64;g=H[a+104>>2]+N(H[a+108>>2],20)|0;while(1){c=g;g=c-20|0;d=I[g|0];if(d>>>0>64){continue}a:{b:{c:{d:{e:{f:{g:{switch(d|0){case 8:break a;case 6:break c;case 7:break d;case 3:case 4:case 5:break e;case 0:case 1:break f;case 2:break g;default:break b}}if(!H[c-12>>2]){break f}G[a+152>>1]=J[a+152>>1]&65471}G[a+152>>1]=J[a+152>>1]|128;continue}G[a+152>>1]=J[a+152>>1]&65343|128;continue}c=H[c-12>>2];e=(c|0)>(e|0)?c:e;continue}d=H[c-36>>2];e=(e|0)<(d|0)?d:e}c=c-12|0;d=H[c>>2];if((d|0)>=0){continue}H[c>>2]=H[((d^-1)<<2)+h>>2];continue}break}if(h){Wb(H[a>>2],H[f+64>>2]);H[f+64>>2]=0}H[f+56>>2]=0;H[b>>2]=e}function rc(a){var b=0,c=0;a:{b:while(1){b=I[a|0];while(1){c:{d:{e:{f:{g:{h:{i:{j:{switch(b-167|0){default:k:{switch(b-177|0){case 0:break f;case 1:break g;default:break k}}if((b|0)==36){break h}if((b|0)!=138){break e}a=H[H[a+20>>2]+28>>2]+8|0;break d;case 0:c=H[a+44>>2];break i;case 2:break j;case 1:break e}}c=H[a+44>>2];if(!c){break e}}a=G[a+32>>1];b=68;if((a|0)<0|(a|0)>=G[c+34>>1]){break a}b=I[(H[c+4>>2]+N(a,12)|0)+5|0];break a}b=Mi(H[a+8>>2],0);break a}a=(H[H[H[a+12>>2]+20>>2]+28>>2]+(G[a+32>>1]<<4)|0)+8|0;break d}a=H[a+20>>2]+8|0;break d}if(!((I[a+5|0]|I[a+6|0]<<8)&1056)){break c}a=a+12|0}a=H[a>>2];continue b}if((b|0)==176){b=I[a+2|0];if((b|0)!=176){continue}}break}break}b=I[a+1|0]}return b<<24>>24}function Ld(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;if(!a){return bc(b,c)}if(!(b|c)){Ta(a);return 0}a:{b:{if(!c&b>>>0>2147483391|c){break b}h=Ia[H[16491]](a)|0;f=Ia[H[16492]](b)|0;if((h|0)==(f|0)){return a}if(H[16480]){if(b>>>0>K[18223]){H[18223]=b}c=f-h|0;c:{if((c|0)<=0){break c}b=H[18208];d=H[18232];e=d-c|0;d=H[18233]-(c>>>0>d>>>0)|0;if((d|0)>0){g=1}else{g=b>>>0<e>>>0&(d|0)>=0}if(g){break c}d=H[18235];g=d;e=H[18234];if(!e&(d|0)<=0|(d|0)<0){break c}d=e-c|0;c=g-(c>>>0>e>>>0)|0;if((c|0)<0){b=1}else{b=(c|0)<=0&b>>>0>=d>>>0}if(b){break b}}a=Ia[H[16490]](a,f)|0;if(!a){break b}b=Ia[H[16491]](a)|0;b=H[18208]+(b-h|0)|0;H[18208]=b;if(b>>>0<=K[18218]){break a}H[18218]=b;break a}i=Ia[H[16490]](a,f)|0}return i}return a}function uA(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;e=Ea-48|0;Ea=e;h=c+8|0;k=H[a>>2];l=H[H[b+28>>2]>>2];a:{while(1){if(H[c>>2]>(j|0)){i=H[h>>2];f=bd(i);b:{if(!f){break b}c:{if(I[d|0]!=71){g=tA(H[b+28>>2],f);H[e+12>>2]=g;if((g|0)>0){break c}}if(Ff(f,e+12|0)){g=H[e+12>>2];if(g-65536>>>0>4294901760){break c}lr(k,d,j+1|0,l,f);f=1;break a}g=0;G[h+12>>1]=0;f=1;if(cd(a,i)){break a}while(1){f=H[b+28>>2];if(H[f>>2]<=(g|0)){break b}if(!cc(0,i,H[(f+(g<<4)|0)+8>>2],-1)){if(H[b+68>>2]){H[e+32>>2]=0;H[e+36>>2]=0;H[e+24>>2]=0;H[e+28>>2]=0;H[e+16>>2]=0;H[e+20>>2]=0;H[e+40>>2]=b;H[e+20>>2]=85;Jb(e+16|0,i)}G[h+12>>1]=g+1}g=g+1|0;continue}}G[h+12>>1]=g}h=h+16|0;j=j+1|0;continue}break}f=gn(k,b,c,d)}Ea=e+48|0;return f}function fq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;e=Ea-16|0;Ea=e;f=H[a+64>>2];d=H[f>>2];a:{if(!d|(I[a+17|0]-4&255)>>>0>252){break a}g=H[a+168>>2];c=Ia[H[d+24>>2]](f,e+8|0)|0;j=g>>31;f=sJ(g,j,b,0);d=Ha;h=d;H[e>>2]=f;H[e+4>>2]=d;if(c){break a}c=0;d=H[e+8>>2];i=H[e+12>>2];if((f|0)==(d|0)&(h|0)==(i|0)){break a}b:{c:{if(f>>>0<d>>>0&(h|0)<=(i|0)|(h|0)<(i|0)){g=H[a+64>>2];c=Ia[H[H[g>>2]+16>>2]](g,f,h)|0;break c}c=i+j|0;i=d;d=d+g|0;c=i>>>0>d>>>0?c+1|0:c;if(f>>>0<d>>>0&(c|0)>=(h|0)|(c|0)>(h|0)){break b}f=Xa(H[a+224>>2],0,g);c=H[a+64>>2];Ia[H[H[c>>2]+40>>2]](c,5,e)|0;h=H[a+64>>2];c=H[e>>2];c=Ia[H[H[h>>2]+12>>2]](h,f,g,c-g|0,H[e+4>>2]-(j+(c>>>0<g>>>0)|0)|0)|0}if(c){break a}}H[a+36>>2]=b;c=0}Ea=e+16|0;return c}function Qf(a){var b=0,c=0;a:{b:{c:{c=F[a+68|0];d:{if((c|0)>=0){b=H[a+116>>2];if(!c){break d}hf(b);c=a+120|0;while(1){b=I[a+68|0]-1|0;F[a+68|0]=b;if(!(b&255)){break c}hf(H[c+(b<<24>>24<<2)>>2]);continue}}b=H[a+64>>2];if(!b){break a}c=I[a|0];if(c>>>0>=3){if((c|0)==4){return H[a+4>>2]}al(a);b=H[a+64>>2]}b=Oi(H[a+20>>2],b,a+116|0,I[a+2|0]);if(b){F[a|0]=1;return b}F[a+68|0]=0;b=H[a+116>>2];F[a+69|0]=I[b+1|0]}if(I[b+1|0]==(!H[a+112>>2]|0)?I[b|0]:0){break b}return Ya(75629)}b=H[a+120>>2];H[a+116>>2]=b}G[a+50>>1]=0;G[a+70>>1]=0;F[a+1|0]=I[a+1|0]&241;if(J[b+24>>1]){F[a|0]=0;return 0}if(!I[b+8|0]){if(H[b+4>>2]!=1){return Ya(75641)}b=cb((H[b+56>>2]+I[b+9|0]|0)+8|0);F[a|0]=0;return Dg(a,b)}}F[a|0]=1;return 16}function ft(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0;f=H[16544];a:{if(f){g=266;if(Ia[f|0](201)|0){break a}}if(H[b+44>>2]){H[b+44>>2]=0}H[b>>2]=d;H[b+4>>2]=e;f=H[c+12>>2];g=H[c+8>>2];H[b+8>>2]=g;H[b+12>>2]=f;c=H[c>>2];H[b+24>>2]=c;i=g;g=H[a+12>>2];h=H[H[g+24>>2]+168>>2];i=i>>>0>h>>>0;h=h>>31;if(!(i&(h|0)<=(f|0)|(f|0)>(h|0)|H[H[c>>2]>>2]<3)){H[b+44>>2]=0;g=H[a+12>>2]}f=H[g+12>>2];a=d;d=f>>31;a=uJ(a,e,f,d);e=Ha;g=0;c=H[b+36>>2];if(!c){c=bc(f,d);H[b+40>>2]=f;H[b+36>>2]=c;g=c?0:7}if(!(a|e)|g){break a}h=H[b+24>>2];i=a+c|0;c=H[b+8>>2];d=H[b>>2];e=c-d|0;g=H[b+12>>2];j=H[b+4>>2];b=f-a|0;a=(b>>31)+j|0;f=b+d|0;a=f>>>0<b>>>0?a+1|0:a;g=Ia[H[H[h>>2]+8>>2]](h,i,c>>>0<f>>>0&(a|0)>=(g|0)|(a|0)>(g|0)?e:b,d,j)|0}return g}function XE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if((b|0)==1){if((Kb(H[c>>2])|0)==5){Rb(a);return}e=Db(H[c>>2]);H[18340]=0;h=a;C(+e);a=x(1)|0;c=x(0)|0;b=a&2147483647;a:{if(b>>>0>=1072693248){d=e*1.5707963267948966+752316384526264e-51;if(!(b-1072693248|c)){break a}d=0/(e-e);break a}b:{if(b>>>0<=1071644671){if(b+-1048576>>>0<1044381696){break b}d=e*Aj(e*e)+e;break a}d=(1-P(e))*.5;f=W(d);e=Aj(d);c:{if(b>>>0>=1072640819){d=f*e+f;d=1.5707963267948966-(d+d+-6123233995736766e-32);break c}C(+f);c=x(1)|0;x(0)|0;z(0,0);z(1,c|0);g=+B();d=(d-g*g)/(f+g);d=.7853981633974483-(g+g)-((f+f)*e-(6123233995736766e-32-(d+d)))+.7853981633974483}e=(a|0)<0?-d:d}d=e}Sb(h,d);return}Y(23738,17858,379,17615);D()}function Uy(a,b){var c=0,d=0,e=0,f=0,g=0;c=sp(a);a:{if(!c){f=7;c=H[H[a>>2]+20>>2];e=nb(c,24,0);if(!e){break a}H[e>>2]=c;d=H[a+12>>2];c=d+236|0;b:{c:{d:{e:{while(1){c=H[c>>2];if(c){if(H[c+4>>2]==-429938){break e}c=c+16|0;continue}break}c=nb(H[d>>2],20,0);if(!c){break c}g=H[a+16>>2];H[c+4>>2]=-429938;H[c>>2]=g;H[c+16>>2]=H[d+236>>2];H[d+236>>2]=c;if(H[a+20>>2]){break d}H[a+20>>2]=-1;break d}d=H[c+12>>2];if(!d){break d}Ia[d|0](H[c+8>>2])}H[c+12>>2]=97;H[c+8>>2]=e;break b}Ry(e)}c=sp(a);if(!c){break a}}a=H[c+4>>2];if((a|0)>=4){ad(H[c+8>>2]);a=H[c+16>>2];H[c+8>>2]=H[c+12>>2];H[c+12>>2]=a;H[c+16>>2]=H[c+20>>2];a=3}G[b+38>>1]=1;H[b+24>>2]=H[b+24>>2]+1;H[((a<<2)+c|0)+8>>2]=b;H[c+4>>2]=a+1;f=0}return f}function dr(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;a:{g=I[c|0];if((g|0)==44){dr(a,b,H[c+16>>2],d,e,f);c=H[c+12>>2];g=I[c|0]}if((g|0)!=53&(g|0)!=45){break a}g=H[c+12>>2];if(I[g|0]!=167){break a}h=H[c+16>>2];if(!ge(h)){break a}c=Uh(a,c);if(H[c+12>>2]!=15?c:0){break a}c=G[g+32>>1];if((c|0)<0){break a}i=I[(H[H[b+12>>2]+4>>2]+N(c,12)|0)+5|0];if(i>>>0<66){break a}if(f){c=H[a>>2];b=nd(c,24,0);if(!b){break a}d=I[f+36|0];j=b,k=jb(c,h,0),H[j>>2]=k;c=H[f+40>>2];H[b+8>>2]=e;H[b+4>>2]=c;c=G[g+32>>1];F[b+16|0]=(d&72)!=0;H[b+12>>2]=c;c=H[a+76>>2];F[b+17|0]=i;H[b+20>>2]=c;H[a+76>>2]=b;if(c){break a}id(a,87,a+76|0);return}if(c>>>0>62){break a}a=H[d>>2];b=H[d+4>>2];j=d,k=yJ(-2,-1,c)&a,H[j>>2]=k;H[d+4>>2]=Ha&b}}function sz(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;h=H[b+40>>2];i=H[a>>2];g=H[a+8>>2];j=_m(b,d);a:{if(!d|(e|0)==(h|0)){break a}if(!(I[c+28|0]&128)){d=zb(a);Sa(g,142,e,d);Ua(g,30,h,0,d);rb(a,d);break a}f=H[a+44>>2];l=jc(c);k=J[l+50>>1];H[a+44>>2]=f+k;m=f+1|0;f=0;while(1){if((f|0)!=(k|0)){Ua(g,94,e,Re(d,G[H[l+4>>2]+(f<<1)>>1]),f+m|0);f=f+1|0;continue}break}d=gb(g,29,h,0,m,k);fb(g,70,11,2,0,13536,-1);e=H[a+128>>2];F[(e?e:a)+21|0]=1;e=H[g+108>>2];H[(I[H[g>>2]+87|0]?73336:H[g+104>>2]+N(d,20)|0)+8>>2]=e}f=0;d=sh(i,H[b+32>>2],0);while(1){if(G[c+34>>1]>(f|0)){if(I[(H[c+4>>2]+N(f,12)|0)+5|0]==69){_a(g,87,H[b+36>>2]+f|0)}f=f+1|0;continue}break}zn(a,d,pc(i,H[j+8>>2],0),jb(i,H[j+12>>2],0),2,j)}function JI(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;b=Ea-48|0;Ea=b;f=fd(H[c>>2]);d=H[f+32>>2];c=0;G[b+44>>1]=0;H[b+40>>2]=0;H[b+32>>2]=0;H[b+24>>2]=0;H[b+28>>2]=0;H[b+36>>2]=N(d,100)+100;d=(I[f+36|0]?8:16)+f|0;e=H[d+4>>2];H[b+16>>2]=H[d>>2];H[b+20>>2]=e;lb(b+24|0,1868,b+16|0);while(1){if((c|0)<H[f+32>>2]){e=H[f+20>>2];h=e;l=H[f+16>>2];i=sJ(l,e,10,0);g=Ha;d=H[f+40>>2]+(c<<3)|0;e=H[d>>2];d=H[d+4>>2];n=d;j=e+1|0;d=j?d:d+1|0;k=sJ(j,d,11,0);m=Ha;i=(m|0)==(g|0)&i>>>0>k>>>0|g>>>0>m>>>0?2:1;k=0;g=h+n|0;h=e;e=e+l|0;g=h>>>0>e>>>0?g+1|0:g;d=vJ(e,g,j,d);h=d;e=Ha;d=!e&(d|0)==2;H[b>>2]=d?i:h;H[b+4>>2]=d?k:e;lb(b+24|0,1867,b);c=c+1|0;continue}break}um(a,b+24|0);Ea=b+48|0}function Fj(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;C(+a);b=x(1)|0;e=x(0)|0;a:{b:{c:{if((b|0)<1048575|(b|0)<=1048575){if(a==0){return-1/(a*a)}if((b|0)>0|(b|0)>=0){break c}return(a-a)/0}if(b>>>0>2146435071){break a}f=-1023;if((b|0)!=1072693248){break b}b=1072693248;if(e){break b}return 0}f=-1077;C(+(a*0x40000000000000));b=x(1)|0;e=x(0)|0}b=b+614242|0;g=+((b>>>20|0)+f|0);d=g*.6931471803691238;z(0,e|0);z(1,(b&1048575)+1072079006|0);a=+B()+-1;c=a/(a+2);h=d;i=a;j=c;d=a*(a*.5);c=c*c;a=c*c;a=h+(i+(j*(d+(a*(a*(a*.15313837699209373+.22222198432149784)+.3999999999940942)+c*(a*(a*(a*.14798198605116586+.1818357216161805)+.2857142874366239)+.6666666666666735)))+g*1.9082149292705877e-10-d))}return a}function Au(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0;e=Ea-16|0;Ea=e;a:{if(I[a+4|0]){c=zu(a);if(c){break a}h=(I[a+4|0]!=0)<<1}c=H[a+176>>2];i=H[a+180>>2];g=H[a+236>>2];f=H[a+64>>2];d=H[a>>2];H[a+232>>2]=0;b=td(H[d+4>>2]+120|0,0);if(!b){c=7;break a}H[b>>2]=d;G[b+40>>1]=65535;H[b+4>>2]=f;H[b+108>>2]=g;H[b+16>>2]=c;H[b+20>>2]=i;G[b+48>>1]=257;F[b+43|0]=h;c=b+120|0;H[b+8>>2]=c;H[e+12>>2]=524294;c=Ia[H[d+24>>2]](d,g,c,524294,e+12|0)|0;if(!c){if(F[e+12|0]&1){F[b+46|0]=1}c=H[f>>2];b:{if(!c){break b}c=Ia[H[c+48>>2]](f)|0;if(c&1024){F[b+48|0]=0}if(!(c&4096)){break b}F[b+49|0]=0}H[a+232>>2]=b;c=0;break a}Po(b,0);a=H[b+8>>2];d=H[a>>2];if(d){Ia[H[d+4>>2]](a)|0;H[a>>2]=0}Ta(b)}Ea=e+16|0;return c}function yo(a,b){var c=0,d=0;c=I[a+5|0];a:{b:{if(!I[a+15|0]){break b}switch(b-2|0){case 0:case 2:break b;default:break a}}if((b|0)==(c|0)){break a}F[a+5|0]=b;if(!(I[a+4|0]|(b&1|(c&5)!=1))){c=H[a+68>>2];b=H[c>>2];if(b){Ia[H[b+4>>2]](c)|0;H[c>>2]=0}if(I[a+18|0]>=2){c=H[a>>2];b=H[c+28>>2];if(!b){break a}Ia[b|0](c,H[a+188>>2],0)|0;break a}b=0;d=I[a+17|0];if(d){c=d}else{b=Du(a);c=I[a+17|0]}if((c|0)==1){b=Sf(a,2)}c:{if(b){break c}c=H[a>>2];b=H[c+28>>2];if(b){Ia[b|0](c,H[a+188>>2],0)|0}if((d|0)!=1){break c}Jg(a,1);break a}if(d){break a}ml(a);break a}d:{switch(b-2|0){case 0:case 2:break d;default:break a}}c=H[a+68>>2];b=H[c>>2];if(!b){break a}Ia[H[b+4>>2]](c)|0;H[c>>2]=0}return I[a+5|0]}function pC(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0,k=0;h=(c>>31)+e|0;j=c+d|0;h=j>>>0<d>>>0?h+1|0:h;g=H[a+20>>2];if((h|0)<=(g|0)&K[a+16>>2]>=j>>>0|(h|0)<(g|0)){a:{if(!(!!(d|e)&((d|0)==H[a+32>>2]&(e|0)==H[a+36>>2]))){f=a+12|0;while(1){f=H[f>>2];if(!f){f=0;break a}g=H[a+4>>2];k=g+k|0;i=(g>>31)+i|0;i=g>>>0>k>>>0?i+1|0:i;if((e|0)>=(i|0)&d>>>0>=k>>>0|(e|0)>(i|0)){continue}break}break a}f=H[a+40>>2]}g=d;d=H[a+4>>2];d=uJ(g,e,d,d>>31);while(1){b:{g=(d+f|0)+4|0;e=H[a+4>>2]-d|0;d=(c|0)<(e|0)?c:e;b=Va(b,g,d);c=c-e|0;if((c|0)<0){break b}f=H[f>>2];if(!c){break b}b=b+d|0;d=0;if(f){continue}}break}H[a+40>>2]=f;H[a+32>>2]=f?j:0;H[a+36>>2]=f?h:0;a=0}else{a=522}return a|0}function JF(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;c=Ea-80|0;Ea=c;f=H[a+12>>2];d=Lx(a);H[c+76>>2]=d;if(!d){h=c,i=Oj(a),H[h+76>>2]=i}F[a+240|0]=1;if(!H[a+40>>2]){d=H[a+20>>2];e=H[a+16>>2];H[c+72>>2]=b;H[c+64>>2]=e;H[c+68>>2]=d;Fe(c+76|0,f,22698,c- -64|0)}if(I[a+238|0]){d=H[a+20>>2];e=H[a+16>>2];H[c+56>>2]=b;H[c+48>>2]=e;H[c+52>>2]=d;Fe(c+76|0,f,22904,c+48|0)}if(I[a+237|0]){d=H[a+20>>2];e=H[a+16>>2];H[c+40>>2]=b;H[c+32>>2]=e;H[c+36>>2]=d;Fe(c+76|0,f,22751,c+32|0)}d=H[a+20>>2];e=H[a+16>>2];H[c+24>>2]=b;H[c+16>>2]=e;H[c+20>>2]=d;d=c+76|0;Fe(d,f,22798,c+16|0);e=H[a+20>>2];g=H[a+16>>2];H[c+8>>2]=b;H[c>>2]=g;H[c+4>>2]=e;Fe(d,f,22852,c);F[a+240|0]=0;Ea=c+80|0;return H[c+76>>2]}function dz(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0;d=Ea+-64|0;Ea=d;e=b;b=d+16|0;if(!ng(a,e,c,b)){cz(b);F[d+2|0]=58;F[d+5|0]=58;b=H[d+36>>2];c=(b|0)/10|0;F[d|0]=((c|0)%10|0)+48;e=H[d+40>>2];g=(e|0)/10|0;F[d+3|0]=((g|0)%10|0)+48;F[d+1|0]=(b-N(c,10)|0)+48;F[d+4|0]=(e-N(g,10)|0)+48;f=M[d+48>>3];a:{if(I[d+63|0]){F[d+12|0]=0;f=f*1e3+.5;b:{if(P(f)<2147483648){c=~~f;break b}c=-2147483648}F[d+9|0]=(((c|0)/100|0)%10|0)+48;b=(c|0)/10|0;F[d+10|0]=((b|0)%10|0)+48;F[d+11|0]=(c-N(b,10)|0)+48;b=(c|0)/1e3|0;e=12;g=46;c=(c|0)/1e4|0;break a}e=8;g=0;if(P(f)<2147483648){b=~~f}else{b=-2147483648}c=(b|0)/10|0}F[d+8|0]=g;F[d+7|0]=((b|0)%10|0)+48;F[d+6|0]=((c|0)%10|0)+48;qb(a,d,e,-1)}Ea=d- -64|0}function VB(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0;a=Ea-16|0;Ea=a;c=Xa(c,0,b);H[18298]=42;d=xh(11441,0,0);a:{if((d|0)>=0){while(1){if((Ia[H[16673]](d,c,b)|0)<0&H[18340]==27){continue}break}Of(0,d,44803);break a}f=a+8|0;e=+$()/1e3;b:{if(P(e)<0x8000000000000000){d=~~e>>>0;if(P(e)>=1){b=~~(e>0?R(T(e*2.3283064365386963e-10),4294967295):U((e-+(~~e>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}break b}d=0;b=-2147483648}if(f){H[f>>2]=d;H[f+4>>2]=b}b=H[a+12>>2];d=H[a+8>>2];F[c|0]=d;F[c+1|0]=d>>>8;F[c+2|0]=d>>>16;F[c+3|0]=d>>>24;F[c+4|0]=b;F[c+5|0]=b>>>8;F[c+6|0]=b>>>16;F[c+7|0]=b>>>24;b=H[18298];F[c+8|0]=b;F[c+9|0]=b>>>8;F[c+10|0]=b>>>16;F[c+11|0]=b>>>24;b=12}Ea=a+16|0;return b|0}function Jt(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0;f=Ea-256|0;Ea=f;c=H[a+12>>2];a:{if(!H[a+16>>2]){e=Vk(H[c+28>>2]);H[a+16>>2]=e;d=7;if(!e){break a}c=H[a+12>>2];d=J[H[c+28>>2]+6>>1];F[e+23|0]=0;G[e+20>>1]=d}e=H[b>>2];d=I[c+68|0];H[a+40>>2]=(d|0)==1?35:(d|0)==2?36:37;i=Xa(f,0,256);while(1){if(e){c=H[b+4>>2];b:{if(c){d=0;if((c|0)==(e|0)){break b}d=c+H[e+4>>2]|0;break b}d=H[e+4>>2]}c=0;H[e+4>>2]=0;while(1){g=(c<<2)+i|0;j=H[g>>2];if(j){e=kt(a,e,j);H[g>>2]=0;c=c+1|0;continue}break}H[g>>2]=e;e=d;continue}else{c=0;while(1){if((h|0)!=64){d=H[(h<<2)+i>>2];c:{if(!d){break c}if(!c){c=d;break c}c=kt(a,c,d)}h=h+1|0;continue}break}H[b>>2]=c;d=I[H[a+16>>2]+23|0]}break}}Ea=f+256|0;return d}function Nn(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;h=Ea-16|0;Ea=h;e=H[a>>2];a:{b:{if(!c){c=nf(e,b,d,0);if(!c){break b}}if(H[c+12>>2]){break a}}c:{if(H[e+276>>2]){c=Tb(e,d);if(!c){break c}Ia[H[e+276>>2]](H[e+284>>2],e,b,c);db(e,c)}if(!H[e+280>>2]){break c}c=og(e);wm(c,d,0);f=Fl(c,2);if(f){Ia[H[e+280>>2]](H[e+284>>2],e,I[e+84|0],f)}Uc(c)}c=0;d:{e:{f=nf(e,b,d,0);if(!f){break e}if(H[f+12>>2]){break d}i=H[f>>2];b=0;while(1){if((b|0)==3){break e}g=b+36884|0;b=b+1|0;g=nf(e,I[g|0],i,0);if(!H[g+12>>2]){continue}break}a=H[g+4>>2];H[f>>2]=H[g>>2];H[f+4>>2]=a;a=H[g+12>>2];H[f+8>>2]=H[g+8>>2];H[f+12>>2]=a;H[f+16>>2]=0;break d}H[h>>2]=d;Wa(a,8509,h);H[a+12>>2]=257;break a}c=f}Ea=h+16|0;return c}function Uk(a,b,c,d,e){var f=0;if(I[a+9|0]){H[H[a+4>>2]+4>>2]=H[a>>2]}f=H[a+4>>2];a:{if(b>>>0<=1){if(!b){a=Ya(74776);break a}b=H[f+48>>2]!=0}H[e+112>>2]=d;F[e+68|0]=255;H[e+64>>2]=b;H[e+20>>2]=f;H[e+8>>2]=a;d=0;F[e+1|0]=0;a=f+8|0;while(1){a=H[a>>2];if(a){if(H[a+64>>2]==(b|0)){F[a+1|0]=I[a+1|0]|32;F[e+1|0]=32;d=32}a=a+24|0;continue}break}F[e|0]=1;H[e+24>>2]=H[f+8>>2];H[f+8>>2]=e;b:{if(c){F[e+2|0]=0;F[e+1|0]=d|1;if(H[f+84>>2]){break b}a=$i(H[f+36>>2]);H[f+84>>2]=a;c:{if(!a){a=H[f+8>>2];H[f+8>>2]=H[a+24>>2];Xa(a,0,200);a=7;break c}F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;H[f+84>>2]=H[f+84>>2]+4;a=0}break a}F[e+2|0]=2}a=0}return a}function Sm(a,b,c){var d=0,e=0,f=0;a:{e=H[a+68>>2];if(!e|(c|0)>=0){break a}d=e+8|0;f=H[e>>2];while(1){if((f|0)<=0){break a}b:{if(I[d+9|0]&8){if(!cc(0,H[d>>2],b,-1)){break b}}f=f-1|0;d=d+16|0;continue}break}return H[d+12>>2]}d=jb(H[a>>2],b,0);if(!(!d|!(I[d+4|0]&8))){e=H[a+8>>2];f=Mb(e,15);F[a+23|0]=0;b=H[a>>2];if(!I[b+87|0]){if((c|0)<0){c=H[a+44>>2]+1|0;H[a+44>>2]=c}ac(a,d,c);b=H[a>>2]}F[a+23|0]=1;he(b,d);b=H[e+108>>2];H[(I[H[e>>2]+87|0]?73336:H[e+104>>2]+N(f,20)|0)+8>>2]=b;return c}b=Pb(a,e,d);if(b){d=b+(H[b>>2]<<4)|0;e=d+1|0;f=(I[d+1|0]|I[d+2|0]<<8)&65527|c>>>28&8;F[e|0]=f;F[e+1|0]=f>>>8;if((c|0)<0){c=H[a+44>>2]+1|0;H[a+44>>2]=c}H[(d-8|0)+12>>2]=c}H[a+68>>2]=b;return c}function Te(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0;k=bb(b);l=a+416|0;f=Hc(l,b);while(1){if(f){i=Jv(f,c,d);j=(i|0)>(h|0);h=j?i:h;g=j?f:g;f=H[f+12>>2];continue}break}a:{b:{c:{d:{if(e){break d}if(g){f=0;if(!(I[a+24|0]&2)){break c}}h=0;f=Iv((I[I[b|0]+30768|0]+k>>>0)%23|0,b);while(1){if(!f){break d}i=Jv(f,c,d);j=(i|0)>(h|0);h=j?i:h;g=j?f:g;f=H[f+12>>2];continue}}if(!(!e|(h|0)>5)){e=nb(a,k+41|0,0);if(!e){break b}H[e+4>>2]=d;F[e|0]=c;f=e+40|0;H[e+32>>2]=f;Va(f,b,k+1|0);while(1){b=I[f|0];if(b){F[f|0]=I[b+30768|0];f=f+1|0;continue}break}b=od(l,H[e+32>>2],e);if((b|0)==(e|0)){db(a,e);Ib(a);break b}H[e+12>>2]=b;return e}if(!g){break b}f=e}if(f|H[g+16>>2]){break a}}g=0}return g}function zq(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0;a:{if(I[a+35|0]){break a}g=H[a>>2];e=g+b|0;d=I[e|0];f=d>>>4|0;f=d>>>0>=192?(f|0)==12?-1:(f|0)==13?-2:-4:0;d=0;b:{if(c>>>0<12){break b}if(c>>>0<256){j=1;d=1;break b}i=c>>>0<65536;d=i?2:4}d=d+f|0;if(d){f=H[a+4>>2];h=d+f|0;c:{if((d|0)>0){if(K[a+8>>2]<h>>>0){if(Tj(a,h)){break a}g=H[a>>2];f=H[a+4>>2]}e=b+g|0;g=e+1|0;Ic(g+d|0,g,(b^-1)+f|0);break c}Ic(e+1|0,(e-d|0)+1|0,(d+(b^-1)|0)+f|0)}H[a+4>>2]=h}a=I[e|0]&15;if(c>>>0<=11){F[e|0]=a|c<<4;return d}if(j){F[e+1|0]=c;F[e|0]=a|192;return d}if(i){F[e+2|0]=c;F[e+1|0]=c>>>8;F[e|0]=a|208;return d}F[e+4|0]=c;F[e+3|0]=c>>>8;F[e+2|0]=c>>>16;F[e+1|0]=c>>>24;F[e|0]=a|224;return d}return 0}function os(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0;h=Ea-16|0;Ea=h;a:{b:{c:{e=H[a+248>>2];d:{if(!e){break d}if(I[a+220|0]==1){Wa(a,5121,0);break d}i=H[e+4>>2]+N(G[e+34>>1],12)|0;d=i-12|0;e:{if(J[i-4>>1]){break e}if(!c){break c}f:{switch(H[c+4>>2]-6|0){case 0:if(yb(15685,H[c>>2],6)){break e}g=64;break b;case 1:break f;default:break e}}if(!yb(11761,H[c>>2],7)){break c}}H[h>>2]=H[d>>2];Wa(a,29385,h)}c=b;break a}G[e+36>>1]=J[e+36>>1]-1;g=32}c=i-2|0;f=J[c>>1];G[c>>1]=f|g;H[e+28>>2]=g|H[e+28>>2];if(f&1){sn(a,d)}c=0;g=d;d=0;g:{if(!b){break g}f=I[b|0];if((f|0)==59){b=ib(a,174,b,0);d=0;if(!b){break g}f=I[b|0]}if((f&255)!=71){F[b+1|0]=I[i-7|0]}d=b}vn(a,e,g,d)}eb(H[a>>2],c);Ea=h+16|0}function YE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;if((b|0)==1){if((Kb(H[c>>2])|0)==5){Rb(a);return}e=Db(H[c>>2]);H[18340]=0;g=a;C(+e);a=x(1)|0;b=x(0)|0;c=a&2147483647;a:{if(c>>>0>=1072693248){f=(a|0)>0|(a|0)>=0?0:3.141592653589793;if(!(c-1072693248|b)){break a}f=0/(e-e);break a}b:{if(c>>>0<=1071644671){f=1.5707963267948966;if(c>>>0<1012924417){break b}f=6123233995736766e-32-e*Aj(e*e)-e+1.5707963267948966;break a}if((a|0)<0){d=(e+1)*.5;e=W(d);d=1.5707963267948966-(e+(e*Aj(d)+-6123233995736766e-32));f=d+d;break a}d=(1-e)*.5;e=W(d);h=e*Aj(d);C(+e);a=x(1)|0;x(0)|0;z(0,0);z(1,a|0);f=d;d=+B();d=h+(f-d*d)/(e+d)+d;f=d+d}}Sb(g,f);return}Y(23738,17858,378,17544);D()}function Gf(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0;m=d-1|0;d=b+8|0;k=e&1;l=k^81;e=I[a+23|0]?e:e&253;n=e&2;o=e&8;p=e&4;h=H[b>>2];g=H[a+8>>2];e=0;while(1){if((e|0)<(h|0)){b=H[d>>2];a:{b:{if(!p){break b}f=J[d+12>>1];if(!f){break b}if(o){h=h-1|0;e=e-1|0;break a}Sa(g,l,f+m|0,c+e|0);break a}c:{if(!n){break c}if(!Tm(b)){break c}Sm(a,b,c+e|0);break a}f=c+e|0;i=Me(a,b,f);if((i|0)==(f|0)){break a}d:{if(!k){break d}b=73336;if(!I[H[g>>2]+87|0]){b=(H[g+104>>2]+N(H[g+108>>2],20)|0)-20|0}if(I[b|0]!=80){break d}j=H[b+12>>2]+1|0;if(J[b+2>>1]|((j+H[b+4>>2]|0)!=(i|0)|(f|0)!=(H[b+8>>2]+j|0))){break d}H[b+12>>2]=j;break a}Sa(g,l,i,f)}d=d+16|0;e=e+1|0;continue}break}}function Gu(a,b){var c=0;c=H[a+52>>2];F[a+11|0]=I[c+21|0];a:{b:{if((b|0)>=10){F[a+8|0]=1;F[a+10|0]=0;c:{switch(b-10|0){case 3:H[a+80>>2]=23;H[a+76>>2]=24;F[a+1|0]=1;F[a+2|0]=1;break b;case 0:H[a+80>>2]=25;H[a+76>>2]=26;break a;default:break c}}H[a+80>>2]=25;H[a+76>>2]=26;F[a+1|0]=0;F[a+2|0]=0;return Ya(72152)}F[a+8|0]=0;F[a+10|0]=4;d:{switch(b-2|0){case 0:H[a+80>>2]=25;H[a+76>>2]=27;break a;case 3:H[a+80>>2]=28;H[a+76>>2]=29;F[a+1|0]=1;F[a+2|0]=0;break b;default:break d}}H[a+80>>2]=25;H[a+76>>2]=27;F[a+1|0]=0;F[a+2|0]=0;return Ya(72176)}G[a+14>>1]=J[c+30>>1];G[a+16>>1]=J[c+32>>1];return 0}F[a+1|0]=0;F[a+2|0]=0;G[a+14>>1]=J[c+26>>1];G[a+16>>1]=J[c+28>>1];return 0}function Vm(a,b,c,d,e,f,g,h){var i=0,j=0,k=0;j=H[a+8>>2];if(f){i=H[b+36>>2];if(i){g=H[a+56>>2]-1|0;H[a+56>>2]=g;H[f>>2]=g;H[a+52>>2]=c+1;oA(a,i,H[f>>2]);g=0;f=a+52|0}H[f>>2]=0}a:{if(e){e=50;if(I[b+55|0]&8){break a}}e=52}k=J[e+b>>1];i=nc(a,k);e=0;b:{if(!g){break b}if((h|0)==(i|0)){e=g;if(!H[g+36>>2]){break b}}e=0}f=0;while(1){if((f|0)!=(k|0)){c:{d:{if(!e){break d}g=f<<1;h=J[g+H[e+4>>2]>>1];if((h|0)==65534){break d}if((h|0)==J[g+H[b+4>>2]>>1]){break c}}yr(a,b,c,f,f+i|0);if(G[H[b+4>>2]+(f<<1)>>1]<0){break c}g=H[j+108>>2];if((g|0)<=0){break c}g=g-1|0;if(I[H[j+104>>2]+N(g,20)|0]!=87){break c}de(j,g)}f=f+1|0;continue}break}if(d){Ua(j,97,i,k,d)}Sc(a,i,k);return i}function Lb(a,b,c,d){var e=0,f=0,g=0,h=0;e=Ea-48|0;Ea=e;h=(b<<2)+a|0;f=H[h+60>>2];H[e+44>>2]=f;a:{b:{c:{if(!f){d:{e:{if((b|0)!=7){if((b|0)!=18){break e}b=H[a+20>>2];f=H[a+16>>2];H[e+24>>2]=H[a+228>>2];H[e+16>>2]=f;H[e+20>>2]=b;g=5;b=Ab(25130,e+16|0);break d}H[e+32>>2]=H[a+224>>2];g=1;b=Ab(20959,e+32|0);break d}f=H[a+20>>2];H[e>>2]=H[a+16>>2];H[e+4>>2]=f;g=5;b=Ab(H[(b<<2)+56032>>2],e)}if(!b){break c}g=jp(H[a+12>>2],b,g,e+44|0);Ta(b);f=H[e+44>>2];H[h+60>>2]=f}if(!d){break a}if(!f){f=0;h=0;break b}h=G[f+16>>1];break b}f=0;g=7;h=0;if(!d){break a}}b=0;while(1){if((b|0)>=(h|0)|g){break a}a=b+1|0;g=pp(f,a,H[(b<<2)+d>>2]);b=a;continue}}H[c>>2]=f;Ea=e+48|0;return g}function pl(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;a:{if(I[a+20|0]){b=0}else{e=H[a+12>>2];if(!e){Nh(a,18);return H[a+8>>2]+(H[a+16>>2]^-1)|0}g=I[a+21|0]&4?H[a+4>>2]:g;f=H[a+16>>2];d=f+b|0;c=d>>>0<f>>>0?c+1|0:c;d=d+1|0;c=d?c:c+1|0;h=d;i=c;d=d+f|0;c=h>>>0>d>>>0?c+1|0:c;f=c;j=d;d=d>>>0>e>>>0&(c|0)>=0|(c|0)>0;c=d?h:j;d=d?i:f;if((d|0)>0){d=1}else{d=c>>>0>e>>>0&(d|0)>=0}if(d){Tf(a);Nh(a,18);return 0}H[a+8>>2]=c;e=0;d=H[a>>2];b:{if(d){c=ed(d,g,c,e);break b}c=Ld(g,c,e)}if(!c){break a}c:{if(I[a+21|0]&4){break c}e=H[a+16>>2];if(!e){break c}Va(c,H[a+4>>2],e)}H[a+4>>2]=c;k=a,l=mf(H[a>>2],c),H[k+8>>2]=l;F[a+21|0]=I[a+21|0]|4}return b}Tf(a);Nh(a,7);return 0}function Sz(a,b,c){var d=0,e=0,f=0,g=0;d=Ea-176|0;Ea=d;g=H[a+8>>2];b=H[b+4>>2];e=I[c+60|0];f=H[a>>2];G[d+172>>1]=256;H[d+168>>2]=0;H[d+160>>2]=100;H[d+164>>2]=1e9;H[d+152>>2]=f;e=b+(e<<6)|0;H[d+32>>2]=e+8;H[d+156>>2]=d+48;f=d+152|0;lb(f,27578,d+32|0);a:{b:{b=H[c+80>>2];if(F[b+41|0]&1){b=H[e+24>>2];c=G[b+32>>1];if((c|0)<0){break b}H[d+16>>2]=H[H[b+4>>2]+N(c,12)>>2];lb(f,20954,d+16|0);break a}c=J[b+46>>1];while(1){if(J[b+24>>1]<=c>>>0){break a}e=_q(H[b+32>>2],c);if(J[b+46>>1]<c>>>0){sb(d+152|0,30398,5)}H[d>>2]=e;lb(d+152|0,20954,d);c=c+1|0;continue}}lb(d+152|0,20975,0)}b=d+152|0;sb(b,27576,1);b=Jd(b);fb(g,188,H[g+108>>2],H[a+232>>2],0,b,-6);Ea=d+176|0}function no(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;f=H[a+56>>2];h=I[a+9|0];g=h+1|0;d=f+g|0;d=I[d|0]<<8|I[d+1|0];i=H[H[a+52>>2]+40>>2];j=i-b|0;a:{b:{while(1){a=d;if((d|0)>(j|0)){break b}d=d+f|0;e=(I[d+2|0]<<8|I[d+3|0])-b|0;if((e|0)>=0){if(e>>>0<=3){a=f+h|0;if(I[a+7|0]>57){break a}b=f+g|0;c=I[d|0]|I[d+1|0]<<8;F[b|0]=c;F[b+1|0]=c>>>8;F[a+7|0]=I[a+7|0]+e;return d}a=a+e|0;if(a>>>0>j>>>0){k=c,l=Ya(71875),H[k>>2]=l;return 0}b=e<<8|(e&65280)>>>8;F[d+2|0]=b;F[d+3|0]=b>>>8;return a+f|0}g=a;d=I[d+1|0]|I[d|0]<<8;if(a>>>0<d>>>0){continue}break}if(!d){break a}k=c,l=Ya(71890),H[k>>2]=l;return 0}if((a|0)<=(i-4|0)){break a}k=c,l=Ya(71897),H[k>>2]=l}return 0}function Pq(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0;f=Ea-48|0;Ea=f;m=H[a>>2];i=wb(a);a:{if(!i){break a}l=H[m+16>>2]+(b<<4)|0;while(1){if((h|0)!=3){g=(f+33|0)+h|0;F[g|0]=0;n=(h<<3)+50816|0;j=H[n>>2];k=yc(m,j,H[l>>2]);b:{if(!k){if(h){break b}k=H[l>>2];H[f+8>>2]=H[n+4>>2];H[f+4>>2]=j;H[f>>2]=k;kc(a,25073,f);H[f+36>>2]=H[a+100>>2];F[g|0]=16;break b}g=H[k+20>>2];H[(f+36|0)+(h<<2)>>2]=g;wd(a,b,g,1,j);if(d){g=H[l>>2];H[f+28>>2]=d;H[f+24>>2]=e;H[f+20>>2]=j;H[f+16>>2]=g;kc(a,19493,f+16|0);break b}Sa(i,145,g,b)}h=h+1|0;continue}break}gb(i,113,c,H[f+36>>2],b,3);a=H[i+108>>2];if((a|0)<=0){break a}G[(H[i+104>>2]+N(a,20)|0)-18>>1]=I[f+33|0]}Ea=f+48|0}function zc(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;c=F[a|0];if((c|0)>=0){H[b>>2]=c&255;H[b+4>>2]=0;return 1}d=F[a+1|0];c=c&127|(d&255)<<7;if((d|0)>=0){H[b>>2]=c;H[b+4>>2]=0;return 2}d=F[a+2|0];c=c&16383|(d&255)<<14;if((d|0)>=0){H[b>>2]=c;H[b+4>>2]=0;return 3}d=F[a+3|0];c=c&2097151|(d&255)<<21;if((d|0)>=0){H[b>>2]=c;H[b+4>>2]=0;return 4}l=a+10|0;g=a+4|0;d=c&268435455;f=28;c=0;while(1){a:{if(!c&f>>>0>63|c){g=l;break a}j=F[g|0];e=j&127;i=f&31;if((f&63)>>>0>=32){k=e<<i;e=0}else{k=(1<<i)-1&e>>>32-i;e=e<<i}e=e+d|0;h=h+k|0;h=d>>>0>e>>>0?h+1|0:h;d=e;f=f+7|0;c=f>>>0<7?c+1|0:c;g=g+1|0;if((j|0)<0){continue}}break}H[b>>2]=d;H[b+4>>2]=h;return g-a|0}function _n(a,b,c,d,e,f,g){var h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;j=Ea-16|0;Ea=j;a:{if((f|0)>0){q=e+f|0;i=H[c>>2];k=H[a+56>>2];o=g+40|0;f=0;while(1){if(!((f|0)==6|H[(f<<2)+o>>2]>(e|0))){f=f+1|0;continue}break}p=g+16|0;l=H[p+(f<<2)>>2];while(1){h=J[H[g+12>>2]+(e<<1)>>1];b:{c:{d:{if(I[k+1|0]|I[k+2|0]){m=no(a,h,j+12|0);if(m){break d}}if((h|0)>(i-b|0)){break c}i=i-h|0;m=i}n=H[H[g+8>>2]+(e<<2)>>2];if(n>>>0>=l>>>0|h+n>>>0<=l>>>0){break b}Ya(77760)}a=1;break a}h=Ic(m,n,h)-k|0;h=h<<8|(h&65280)>>>8;F[d|0]=h;F[d+1|0]=h>>>8;e=e+1|0;if((q|0)>(e|0)){if(H[(f<<2)+o>>2]<=(e|0)){f=f+1|0;l=H[(f<<2)+p>>2]}d=d+2|0;continue}break}H[c>>2]=i}a=0}Ea=j+16|0;return a}function SB(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0;d=Ea-16|0;H[b+40>>2]=0;H[b+44>>2]=1072693248;a:{if(!I[a+20|0]){break a}c=H[b+4>>2];H[d+8>>2]=0;H[d+12>>2]=0;e=H[b>>2];e=(e|0)>0?e:0;while(1){if((e|0)!=(f|0)){b:{if(!I[c+5|0]|I[c+4|0]!=2){break b}g=H[c>>2];h=I[a+21|0];if((g|0)<(h|0)){break b}H[(d+8|0)+(g-h<<2)>>2]=f+1}c=c+12|0;f=f+1|0;continue}break}a=H[d+8>>2];if(!a){H[b+48>>2]=2147483647;H[b+52>>2]=0;H[b+40>>2]=-4194304;H[b+44>>2]=1105199103;break a}c=a<<3;a=H[b+16>>2];c=(c+a|0)-8|0;F[c+4|0]=1;H[c>>2]=1;d=H[d+12>>2];if(!d){break a}H[b+48>>2]=20;H[b+52>>2]=0;H[b+40>>2]=0;H[b+44>>2]=1077149696;a=(a+(d<<3)|0)-8|0;F[a+4|0]=1;H[a>>2]=2}return 0}function nj(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;f=Ea-16|0;Ea=f;g=H[a+8>>2];h=H[a+12>>2];i=I[a+18|0];c=Md(g,f+8|0,h,i);if((c|0)>0){d=M[f+8>>3];a:{b:{if((c|0)!=1){break b}c:{d:{if(d<-0x7ffffffffffffc00){break d}c=-1;e=2147483647;if(d>0x7ffffffffffffc00){break c}if(!(P(d)<0x8000000000000000)){break d}c=~~d>>>0;if(P(d)>=1){e=~~(d>0?R(T(d*2.3283064365386963e-10),4294967295):U((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0}else{e=0}break c}c=0;e=-2147483648}e:{if(gw(d,c,e)){H[a>>2]=c;H[a+4>>2]=e;break e}if(bg(g,a,h,i)){break b}}c=J[a+16>>1]|4;break a}M[a>>3]=d;c=J[a+16>>1]|8;G[a+16>>1]=c;if(!b){break a}fw(a);c=J[a+16>>1]}G[a+16>>1]=c&65533}Ea=f+16|0}function gF(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0,h=0,i=0;d=Ea-16|0;H[d+8>>2]=-1;H[d+12>>2]=-1;a=H[b>>2];i=(a|0)>0?a:0;a=H[b+4>>2];while(1){if((c|0)!=(i|0)){e=H[a>>2];a:{if((e|0)<8){break a}f=e-8|0;e=1<<f;if(!I[a+5|0]){g=e|g;break a}if(I[a+4|0]!=2){break a}H[(d+8|0)+(f<<2)>>2]=c;h=e|h}a=a+12|0;c=c+1|0;continue}break}b:{if(H[b+8>>2]<=0){break b}a=H[b+12>>2];if(H[a>>2]>=0|I[a+4|0]){break b}H[b+32>>2]=1}a=19;if(!((h^-1)&g)){a=0;e=H[d+8>>2];c=0;c:{if((e|0)<0){break c}H[b+40>>2]=0;H[b+44>>2]=1072693248;c=e<<3;e=H[b+16>>2];c=c+e|0;F[c+4|0]=1;H[c>>2]=1;d=H[d+12>>2];c=1;if((d|0)<0){break c}d=e+(d<<3)|0;F[d+4|0]=1;H[d>>2]=2;c=3}H[b+20>>2]=c}return a|0}function Fg(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;f=H[a+88>>2];f=(b|0)>0?N(H[a+20>>2]-b|0,40)+f|0:f;h=(c<<3)+88|0;g=h+(d?0:200)|0;e=b<<2;i=H[e+H[a+96>>2]>>2];if(i){Wi(a,i);H[e+H[a+96>>2]>>2]=0}e=H[f+24>>2];a:{if((e|0)>=(g|0)){e=H[f+32>>2];break a}if((e|0)>0){db(H[f+20>>2],H[f+32>>2])}e=nd(H[f+20>>2],g,g>>31);H[f+8>>2]=e;H[f+32>>2]=e;if(!e){H[f+24>>2]=0;return 0}H[f+24>>2]=g}H[H[a+96>>2]+(b<<2)>>2]=e;H[e>>2]=0;H[e+4>>2]=0;H[e+24>>2]=0;H[e+28>>2]=0;H[e+16>>2]=0;H[e+20>>2]=0;H[e+8>>2]=0;H[e+12>>2]=0;H[e+64>>2]=((c<<2)+e|0)+84;G[e+52>>1]=c;F[e|0]=d;if(!d){a=H[f+8>>2]+h|0;H[e+36>>2]=a;H[a+16>>2]=0;H[a+8>>2]=0;H[a+12>>2]=0;H[a>>2]=0;H[a+4>>2]=0}return e}function Fr(a,b,c,d,e,f,g,h,i){var j=0,k=0,l=0,m=0,n=0,o=0,p=0,q=0;o=((i|0)!=0)<<4;q=o|g&2|1;j=b+8|0;k=H[a+8>>2];while(1){m=H[j>>2];if(m){l=(n<<2)+f|0;j=H[l>>2];a:{if(!j){break a}if(H[m+36>>2]){Sa(k,50,j,H[k+108>>2]+2|0)}j=o;p=I[m+55|0]|I[m+56|0]<<8;j=(p&3)==2?I[b+28|0]&128?q:j:j;l=H[l>>2];gb(k,138,d+n|0,l,l+1|0,J[(p&8?50:52)+m>>1]);l=H[k+108>>2];if((l|0)<=0){break a}G[(H[k+104>>2]+N(l,20)|0)-18>>1]=j}n=n+1|0;j=m+20|0;continue}break}b:{if(I[b+28|0]&128){break b}d=I[a+18|0];Ua(k,128,c,H[(n<<2)+f>>2],e);if(!I[a+18|0]){xc(k,b,-5)}a=H[k+108>>2];if((a|0)<=0){break b}b=(H[k+104>>2]+N(a,20)|0)-18|0;a=d?0:g?g|1:33;a=h?a|8:a;G[b>>1]=(i?a|16:a)&255}}function sk(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0,m=0;if(I[b+43|0]==1){H[h>>2]=-999;H[g>>2]=-999;return 0}j=H[a>>2];k=Fb(j,H[b+60>>2]);l=H[a+8>>2];e=(e|0)<0?H[a+40>>2]:e;H[g>>2]=e;i=e+1|0;a:{if(!(I[b+28|0]&128|(I[f|0]?0:f))){Hd(a,e,k,b,c);break a}if(I[j+95|0]){break a}wd(a,k,H[b+20>>2],(c|0)==113,H[b>>2])}H[h>>2]=i;j=f+1|0;e=b+8|0;h=0;while(1){e=H[e>>2];if(e){if(!(!(I[b+28|0]&128)|((I[e+55|0]|I[e+56|0]<<8)&3)!=2)){H[g>>2]=i;d=0}b:{if(I[h+j|0]?0:f){break b}Ua(l,c,i,H[e+44>>2],k);Ed(a,e);m=H[l+108>>2];if((m|0)<=0){break b}G[(H[l+104>>2]+N(m,20)|0)-18>>1]=d&255}i=i+1|0;h=h+1|0;e=e+20|0;continue}break}if(H[a+40>>2]<(i|0)){H[a+40>>2]=i}return h}function mh(a,b,c){var d=0,e=0,f=0,g=0;d=H[a+24>>2];a:{b:{c:{if(!(!c|(d|0)<=0)){d=H[a+32>>2];e=H[a+8>>2];if((d|0)!=(e|0)){break c}c=b>>31;d=H[a+20>>2];d:{if(d){d=Ti(d,e,b,c);H[a+32>>2]=d;break d}d=Ld(e,b,c);H[a+32>>2]=d;if(d){break d}Ta(H[a+8>>2]);d=H[a+32>>2]}H[a+8>>2]=d;b=1;break a}if((d|0)<=0){break b}d=H[a+32>>2]}db(H[a+20>>2],d)}d=nd(H[a+20>>2],b,b>>31);H[a+32>>2]=d;b=!c}if(!d){Xb(a);H[a+24>>2]=0;H[a+8>>2]=0;return 7}f=a,g=mf(H[a+20>>2],d),H[f+24>>2]=g;e:{if(b){break e}b=H[a+8>>2];if(!b){break e}Va(H[a+32>>2],b,H[a+12>>2])}b=J[a+16>>1];if(b&4096){Ia[H[a+36>>2]](H[a+8>>2]);b=J[a+16>>1]}G[a+16>>1]=b&36863;H[a+8>>2]=H[a+32>>2];return 0}function Dq(a,b){var c=0,d=0,e=0,f=0,g=0,h=0,i=0;if(!I[a+6|0]|H[a+104>>2]>=(b|0)){a=c}else{c=H[a+104>>2];g=7;a:{e=Ld(H[a+100>>2],N(b,48),0);if(!e){break a}Xa(N(c,48)+e|0,0,N(b-c|0,48));H[a+100>>2]=e;i=(b|0)<(c|0)?c:b;while(1){if((c|0)==(i|0)){g=0;break a}d=N(c,48)+e|0;h=H[a+28>>2];H[d+20>>2]=h;b:{if(H[H[a+68>>2]>>2]){b=H[a+80>>2];f=H[a+84>>2];if(!!b&(f|0)>=0|(f|0)>0){break b}}b=H[a+156>>2];f=0}H[d>>2]=b;H[d+4>>2]=f;H[d+24>>2]=H[a+56>>2];b=ej(h);H[d+28>>2]=1;H[d+16>>2]=b;if(!b){break a}b=H[a+232>>2];if(b){H[d+32>>2]=H[b+68>>2];H[d+36>>2]=H[b+76>>2];H[d+40>>2]=H[b+80>>2];H[d+44>>2]=H[b+112>>2]}c=c+1|0;H[a+104>>2]=c;continue}}a=g}return a}function yg(a,b,c){var d=0,e=0,f=0,g=0;if(F[b+30|0]&1){if(!c){xc(a,b,-5);e=73336;if(!I[H[a>>2]+87|0]){e=(H[a+104>>2]+N(H[a+108>>2],20)|0)-20|0}F[e|0]=95;Ua(a,97,H[e+4>>2],H[e+8>>2],H[e+12>>2]);return}Sa(a,95,c,G[b+36>>1]);xc(a,b,-5);return}a:{d=H[b+12>>2];if(d){break a}f=G[b+34>>1];d=f>>31;f=f+1|0;d=f?d:d+1|0;d=bc(f,d);if(d){while(1)if(G[b+34>>1]<=(e|0)){while(1){b:{F[d+g|0]=0;if((g|0)<=0){break b}g=g-1|0;if(F[g+d|0]<66){continue}}break}H[b+12>>2]=d;break a}else{f=H[b+4>>2]+N(e,12)|0;if(!(I[f+10|0]&32)){F[d+g|0]=I[f+5|0];g=g+1|0}e=e+1|0;continue}}Ib(H[a>>2]);return}b=tb(d)&1073741823;if(b){if(c){fb(a,96,c,b,0,d,b);return}Wd(a,-1,d,b)}}function lD(a,b,c,d,e){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;var f=0,g=0,h=0,i=0,j=0;h=b;g=c;while(1){a:{b:{Kw(H[a+12>>2],d,e);c:{d:{e:{f:{f=Ha;if((f|0)>0){f=1}else{f=(f|0)>=0}if(f){f=Ia[H[16673]](H[a+12>>2],h,g)|0;g:{if((g|0)==(f|0)){f=g;break g}if((f|0)<0){j=H[18340];if((j|0)==27){continue}H[a+20>>2]=j;i=0;break g}if(f){break b}f=0}d=f+i|0;if((d|0)!=(c|0)){break f}break a}f=H[18340];H[a+20>>2]=f;if((c|0)==-1){break a}break e}if((d|0)>=0){break d}f=H[a+20>>2]}a=8458;if((f|0)==29|(f|0)==60|(f|0)==68){break c}return 266}H[a+20>>2]=0;Xa(b+d|0,0,c-d|0);a=522}return a|0}h=f+h|0;i=f+i|0;g=g-f|0;d=d+f|0;e=d>>>0<f>>>0?e+1|0:e;continue}break}return 0}function hl(a,b,c){var d=0,e=0,f=0;a:{if(H[a+24>>2]>(b|0)){d=H[H[a+32>>2]+(b<<2)>>2];H[c>>2]=d;e=0;if(d){break a}}e=c;b:{if(H[a+24>>2]<=(b|0)){c=b+1|0;d=Ld(H[a+32>>2],c<<2,0);if(!d){c=7;a=0;break b}f=H[a+24>>2];Xa(d+(f<<2)|0,0,c-f<<2);H[a+24>>2]=c;H[a+32>>2]=d}c:{if(I[a+43|0]==2){c=td(32768,0);d=b<<2;H[d+H[a+32>>2]>>2]=c;c=H[d+H[a+32>>2]>>2]?0:7;break c}c=H[a+4>>2];c=Ia[H[H[c>>2]+52>>2]](c,b,32768,I[a+44|0],H[a+32>>2]+(b<<2)|0)|0;if(!c){c=0;if((b|0)<=0){break c}d=H[16544];if(!d){break c}if(!(Ia[d|0](600)|0)){break c}c=7;break c}if((c&255)!=8){break c}F[a+46|0]=I[a+46|0]|2;c=(c|0)!=8?c:0}a=H[H[a+32>>2]+(b<<2)>>2]}H[e>>2]=a;e=c}return e}function tx(a,b,c,d,e){var f=0,g=0,h=0,i=0,j=0,k=0;f=Ea-32|0;Ea=f;j=H[d>>2];g=H[e+64>>2];h=H[e+28>>2];H[f+12>>2]=h;H[f+8>>2]=h;H[f+28>>2]=b;k=H[c>>2];H[f+24>>2]=b;i=f+12|0;ci(f+24|0,a+g|0,0,0,c,i);g=H[f+24>>2];H[f+20>>2]=g;H[f+16>>2]=g;H[c>>2]=k;H[f+12>>2]=h;ci(f+20|0,a+j|0,1,0,i,c);a=H[f+20>>2];a:{b:{c:{if((b|0)!=(g|0)){if((a|0)==(g|0)){break c}zx(f+8|0,f+28|0,f+16|0);break b}if((a|0)!=(b|0)){qe(f+8|0,f+16|0);break b}a=0;break a}qe(f+8|0,f+28|0)}b=H[e+28>>2];a=H[f+8>>2]+(b^-1)|0;d:{if((a|0)<0){break d}g=H[e+32>>2];if((g|0)<(a|0)){break d}Xa(a+b|0,0,g-a|0);H[e+32>>2]=a;b=H[e+28>>2]}H[c>>2]=b;H[d>>2]=H[e+64>>2];a=1}Ea=f+32|0;return a}function ix(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0;g=Ea-80|0;Ea=g;H[g+24>>2]=0;H[g+16>>2]=0;H[g+20>>2]=0;H[g+12>>2]=0;a:{if((b|0)<=0){h=267;break a}i=I[a|0];Zd(c,b,g+12|0);h=H[g+12>>2];if(h){break a}H[c+4>>2]=0;h=Pp(g+32|0,a,b);k=(i|0)!=0;while(1){b:{if(!H[g+32>>2]|h){break b}b=H[g+60>>2];h=H[g+56>>2];c:{if(!H[c+4>>2]){i=kx(h,b,d,e);if((i|0)<0|!i&k){break c}i=H[g+48>>2];j=H[g+52>>2];hx(c,F[a|0],i,j);H[f>>2]=i;H[f+4>>2]=j}h=jx(c,g+16|0,h,b,H[g+68>>2],H[g+72>>2]);if(h){break b}}h=Sl(g+32|0);continue}break}if(!H[c+4>>2]){d=F[a|0];b=H[g+48>>2];a=H[g+52>>2];hx(c,d,b,a);H[f>>2]=b;H[f+4>>2]=a}Ta(H[g+56>>2]);Ta(H[g+16>>2])}Ea=g+80|0;return h}function bC(a,b,c,d){a=a|0;b=b|0;c=c|0;d=d|0;var e=0;d=Ea-80|0;Ea=d;a:{if(!c){break a}b=H[c>>2];if(!b|!H[c+8>>2]){break a}b=yc(H[a>>2],b,H[a+4>>2]);if(!b){break a}b:{e=H[c+4>>2];if(!e){c=H[c+8>>2];break b}c:{if(!Zb(H[c>>2],e)){a=jc(b);break c}a=ef(H[a>>2],e,H[a+4>>2])}c=H[c+8>>2];if(!a){break b}e=(I[a+55|0]|I[a+56|0]<<8)&65531;F[a+55|0]=e;F[a+56|0]=e>>>8;bt(c,J[a+50>>1]+1|0,H[a+8>>2],a);c=I[a+55|0]|I[a+56|0]<<8|128;F[a+55|0]=c;F[a+56|0]=c>>>8;if(H[a+36>>2]){break a}G[b+38>>1]=J[H[a+8>>2]>>1];H[b+28>>2]=H[b+28>>2]|16;break a}G[d+56>>1]=J[b+40>>1];bt(c,1,b+38|0,d+8|0);G[b+40>>1]=J[d+56>>1];H[b+28>>2]=H[b+28>>2]|16}Ea=d+80|0;return 0}function Ct(a){var b=0,c=0,d=0,e=0;e=Ea-16|0;Ea=e;d=J[a+16>>1];if(!(d&45)){a:{b:{c:{if(Md(H[a+8>>2],a,H[a+12>>2],I[a+18|0])>>>0>1){break c}if((bg(H[a+8>>2],e+8|0,H[a+12>>2],I[a+18|0])|0)>1){break c}d=H[e+8>>2];b=H[e+12>>2];break b}d:{e:{c=M[a>>3];if(c<-0x7ffffffffffffc00){break e}d=-1;b=2147483647;if(c>0x7ffffffffffffc00){break d}if(!(P(c)<0x8000000000000000)){break e}d=~~c>>>0;if(P(c)>=1){b=~~(c>0?R(T(c*2.3283064365386963e-10),4294967295):U((c-+(~~c>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}break d}d=0;b=-2147483648}if(gw(c,d,b)){break b}b=8;break a}H[a>>2]=d;H[a+4>>2]=b;b=4}d=b|J[a+16>>1]&-3520}G[a+16>>1]=d&64493;Ea=e+16|0}function lC(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;c=F[b|0];e=c&255;a:{if((c|0)>=0){c=b;break a}e=e&127;while(1){f=d+1|0;c=f+b|0;g=F[c|0];e=g&127|e<<7;if(d>>>0>6){break a}d=f;if((g|0)<0){continue}break}}d=c+2|0;b:{if(F[c+1|0]>=0){break b}d=c+3|0;if(F[c+2|0]>=0){break b}d=c+4|0;if(F[c+3|0]>=0){break b}d=c+5|0;if(F[c+4|0]>=0){break b}d=c+6|0;if(F[c+5|0]>=0){break b}d=c+7|0;if(F[c+6|0]>=0){break b}d=c+8|0;if(F[c+7|0]>=0){break b}d=(F[c+8|0]<0?10:9)+c|0}f=J[a+14>>1];c:{if(f>>>0>=e>>>0){a=(e-b|0)+d|0;a=a>>>0<=4?4:a;break c}c=J[a+16>>1];a=((e-c>>>0)%(H[H[a+52>>2]+40>>2]-4>>>0)|0)+c|0;a=((d-b|0)+(a>>>0>f>>>0?c:a)|0)+4|0}return a&65535}function Uj(a){a=a|0;var b=0,c=0,d=0;c=Ea-576|0;Ea=c;Xa(c+8|0,0,536);b=H[a+20>>2];H[c+568>>2]=H[a+16>>2];H[c+572>>2]=b;b=H[a+12>>2];H[c+560>>2]=H[a+8>>2];H[c+564>>2]=b;d=H[a+52>>2];b=c+552|0;H[b>>2]=H[a+48>>2];H[b+4>>2]=d;d=H[a+44>>2];H[c+544>>2]=H[a+40>>2];H[c+548>>2]=d;H[a+40>>2]=0;H[a+44>>2]=0;H[a+48>>2]=0;H[a+52>>2]=0;qf(a+24|0);while(1){b=H[b>>2];if(b){Qh(c+8|0,H[b+8>>2]);continue}break}qf(c+544|0);H[a+8>>2]=0;H[a+12>>2]=0;H[a+16>>2]=0;H[a+20>>2]=0;b=c+568|0;while(1){b=H[b>>2];if(b){Cd(c+8|0,H[b+8>>2]);continue}break}qf(c+560|0);qf(a+56|0);H[a+72>>2]=0;b=J[a+78>>1];if(b&1){H[a+4>>2]=H[a+4>>2]+1}G[a+78>>1]=b&65526;Ea=c+576|0}function oH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;a:{e=Bb(a,16);if(!e){break a}b:{c:{d:{switch(Rg(H[c+4>>2])-1|0){case 0:g=kb(H[c+4>>2]);b=Ha;break c;case 1:break d;default:break b}}d=Db(H[c+4>>2]);e:{if(P(d)<0x8000000000000000){g=~~d>>>0;if(P(d)>=1){b=~~(d>0?R(T(d*2.3283064365386963e-10),4294967295):U((d-+(~~d>>>0>>>0))*2.3283064365386963e-10))>>>0}else{b=0}break e}b=-2147483648}if(+(g>>>0)+ +(b|0)*4294967296!=d){break b}}if(!g&(b|0)<=0|(b|0)<0){break b}f=H[e+4>>2];h=H[e>>2]+1|0;f=h?f:f+1|0;H[e>>2]=h;H[e+4>>2]=f;if((g|0)!=(h|0)|(b|0)!=(f|0)){break a}b=tj(H[c>>2]);H[e+8>>2]=b;if(b){break a}Ub(a);return}Gb(a,9431,-1)}}function Ov(a,b){var c=0,d=0,e=0;if(a){if(!xl(a)){return Rc(179467)}if(I[a+94|0]&8){Ia[H[a+212>>2]](8,H[a+216>>2],a,0)|0}ye(a);while(1){if((d|0)<H[a+20>>2]){a:{c=H[(H[a+16>>2]+(d<<4)|0)+12>>2];if(!c){break a}c=c+16|0;while(1){c=H[c>>2];if(!c){break a}e=H[c+8>>2];if(I[e+43|0]!=1){continue}Nv(a,e);continue}}d=d+1|0;continue}break}c=a+396|0;while(1){c=H[c>>2];if(c){d=H[H[c+8>>2]+20>>2];if(!d){continue}Nv(a,d);continue}break}jm(a);Mv(a);b:{if(b){break b}if(!Vw(a)){break b}ae(a,5,4788,0);return 5}while(1){b=H[a+532>>2];if(b){H[a+532>>2]=H[b>>2];c=H[b+8>>2];if(c){Ia[c|0](H[b+4>>2])}Ta(b);continue}break}F[a+97|0]=167;Dm(a)}return 0}function wf(a,b,c){var d=0,e=0,f=0,g=0;d=I[a+25|0];a:{if(!d){d=H[a>>2];if(I[H[d+4>>2]+8|0]&8){wq(a);break a}if(I[a+24|0]){eg(d,H[a+4>>2],H[a+16>>2],H[a+20>>2],-1);break a}b:{if(Fq(a)){if(!(!H[b+8>>2]|(I[b+36|0]|!b))){e=H[a+4>>2];d=e-8|0;f=d;g=H[d>>2];d=H[d+4>>2];g=g+1|0;d=g?d:d+1|0;H[f>>2]=g;H[f+4>>2]=d;H[b+12>>2]=e;d=H[a+16>>2];F[b+36|0]=1;H[b+20>>2]=d;if((Uy(c,b)|0)==7){break b}}d=H[a>>2];f=H[a+4>>2];b=f-8|0;c=b;e=H[b>>2];b=H[b+4>>2];e=e+1|0;b=e?b:b+1|0;H[c>>2]=e;H[c+4>>2]=b;eg(d,f,H[a+16>>2],H[a+20>>2],9);break a}Ub(H[a>>2]);break a}Ub(c);break a}if(d&1){Ub(H[a>>2]);break a}if(!(d&2)){break a}Gb(H[a>>2],19873,-1)}lg(a)}function Kx(a){var b=0,c=0,d=0,e=0;c=H[a>>2];b=H[a+4>>2];F[b+19|0]=0;a:{if(!I[a+8|0]){break a}if(H[c+188>>2]>=2){b:{if(H[b+80>>2]!=(a|0)){break b}H[b+80>>2]=0;G[b+24>>1]=J[b+24>>1]&65343;d=b+76|0;while(1){c=H[d>>2];if(!c){break b}F[c+8|0]=1;d=c+12|0;continue}}F[a+8|0]=1;return}c=b+76|0;while(1){d=H[c>>2];if(d){if(H[d>>2]!=(a|0)){c=d+12|0;continue}H[c>>2]=H[d+12>>2];if(H[d+4>>2]==1){continue}Ta(d);continue}break}c:{d:{if(H[b+80>>2]==(a|0)){H[b+80>>2]=0;c=H[b+44>>2];e=65343;break d}c=2;e=65407;d=H[b+44>>2];if((d|0)!=2){break c}}G[b+24>>1]=J[b+24>>1]&e;d=c}c=d-1|0;H[b+44>>2]=c;if(c){break a}F[b+20|0]=0}F[a+8|0]=0;Ho(b)}function Ol(a,b,c){var d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;while(1){if(!(H[c>>2]|!b)){d=H[b+20>>2];if(d){di(d);if(H[d+40>>2]){g=0;f=H[d+64>>2];i=(f|0)>0?f:0;j=d+72|0;while(1){if((g|0)!=(i|0)){a:{f=H[(N(g,24)+j|0)+20>>2];if(!f){break a}H[f+36>>2]=1;h=0;H[f+8>>2]=0;e=H[f+4>>2];k=(e|0)>0?e:0;while(1){if((h|0)==(k|0)){break a}e=H[f>>2]+(h<<2)|0;H[H[e>>2]+80>>2]=0;e=H[e>>2];H[e+88>>2]=0;H[e+92>>2]=0;H[e+84>>2]=0;h=h+1|0;continue}}g=g+1|0;continue}break}l=c,m=Bx(a,0,d),H[l>>2]=m}H[d+48>>2]=0;H[d+16>>2]=0;H[d+20>>2]=0;H[d+8>>2]=0}G[b+32>>1]=0;H[b+24>>2]=0;H[b+28>>2]=0;Ol(a,H[b+12>>2],c);b=H[b+16>>2];continue}break}}function ji(a,b){var c=0,d=0,e=0,f=0,g=0;d=H[a+12>>2];c=d;e=H[a+8>>2];d=c<<1|e>>>31;g=d;f=b+e|0;d=f>>>0<e>>>0?c+1|0:c;f=f+10|0;d=f>>>0<10?d+1|0:d;c=!c&b>>>0<e>>>0|(c|0)!=0;b=c?e<<1:f;d=c?g:d;a:{b:{c:{if(I[a+24|0]){c=1;if(I[a+25|0]){break a}c=so(b,d);if(c){break c}F[a+25|0]=I[a+25|0]|1;b=H[a>>2];if(b){Ub(b)}lg(a);return 7}e=H[a+4>>2]-8|0;c=d;g=b+9|0;c=g>>>0<9?c+1|0:c;c=Fc(e,g,c);if(c){H[a+4>>2]=c+8;break b}Ta(e);F[a+24|0]=1;H[a+16>>2]=0;H[a+20>>2]=0;H[a+8>>2]=100;H[a+12>>2]=0;H[a+4>>2]=a+26;F[a+25|0]=I[a+25|0]|1;return 7}c=Va(c,H[a+4>>2],H[a+16>>2]);F[a+24|0]=0;H[a+4>>2]=c}H[a+8>>2]=b;H[a+12>>2]=d;c=0}return c}function UG(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0;e=Ea+-64|0;Ea=e;d=1;a:{b:{if((b|0)==2){b=kb(H[c+4>>2]);d=b-1|0;f=Ha-!b|0;if(!f&d>>>0>14|f){break b}d=b}c:{d:{e:{b=H[c>>2];switch(I[(J[b+16>>1]&63)+31056|0]-4|0){case 1:break a;case 0:break e;default:break d}}if(!Vj(b)){break d}if(d&4){b=1;break c}if(!(d&8)){b=0;break c}Xa(e+16|0,0,48);g=e,h=fd(H[c>>2]),H[g+8>>2]=h;b=xb(H[c>>2]);H[e+12>>2]=b;b=!om(e+8|0,0,b,1);break c}b=0;if(!(d&3)){break c}c=mg(a,H[c>>2],2);if(c){f:{if(I[c+35|0]){Ub(a);break f}if(I[c+34|0]|!(I[c+37|0]?d&2:1)){break f}b=1}ad(c);break c}Ub(a)}uc(a,b);break a}Gb(a,23289,-1)}Ea=e- -64|0}function aH(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0,j=0;b=Ea+-64|0;Ea=b;e=b+8|0;Xa(e,0,56);H[b+24>>2]=H[H[a>>2]+20>>2];g=Vj(H[c>>2]);d=H[c>>2];a:{b:{if(g){i=b,j=fd(d),H[i+8>>2]=j;c=xb(H[c>>2]);H[b+12>>2]=c;c=om(e,0,c,1);d=0;break b}d=$a(d);H[b+20>>2]=d;if(!d){break a}i=b,j=xb(H[c>>2]),H[i+28>>2]=j;c=0;d=0;if(!nm(b+8|0,0)){break b}c=-1;d=-1;if(I[b+43|0]){break b}c=0;e=H[b+20>>2];g=H[b+36>>2];while(1){c:{if((c|0)==(g|0)){break c}d=I[c+e|0];if(!d){break c}c=c+1|0;d=(d&192)!=128;h=d+h|0;f=d>>>0>h>>>0?f+1|0:f;continue}break}c=h+1|0;d=c?f:f+1|0}vf(b+8|0);if((d|0)<0){Ub(a);break a}_b(a,c,d)}Ea=b- -64|0}function Qp(a,b,c,d,e,f,g,h){var i=0,j=0;i=f+(c>>31)|0;c=c+e|0;i=c>>>0<e>>>0?i+1|0:i;j=c;c=f<<3|e>>>29;f=e<<3;e=j+f|0;c=c+i|0;c=e>>>0<f>>>0?c+1|0:c;f=c+(d>>31)|0;j=d;d=d+e|0;f=j>>>0>d>>>0?f+1|0:f;c=c<<3|e>>>29;e=e<<3;d=e+d|0;c=c+f|0;c=d>>>0<e>>>0?c+1|0:c;i=c+(g>>31)|0;e=d+g|0;i=e>>>0<g>>>0?i+1|0:i;c=c<<3|d>>>29;f=e;e=d<<3;d=f+e|0;c=c+i|0;c=d>>>0<e>>>0?c+1|0:c;f=c+(h>>31)|0;e=d+h|0;f=e>>>0<h>>>0?f+1|0:f;c=c<<3|d>>>29;d=d<<3;e=d+e|0;c=c+f|0;f=d>>>0>e>>>0?c+1|0:c;c=0;g=(b|0)>0?b:0;while(1){if((c|0)!=(g|0)){d=F[a+c|0];b=sJ(e,f,9,0);e=d+b|0;i=Ha+(d>>31)|0;f=b>>>0>e>>>0?i+1|0:i;c=c+1|0;continue}break}Ha=f;return e}function Pf(a){var b=0,c=0,d=0,e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0;j=J[a+24>>1];k=I[a+10|0];f=H[a+56>>2];g=I[a+9|0];b=f+g|0;c=(I[b+5|0]<<8|I[b+6|0])-1&65535;d=(c+I[b+7|0]|0)+1|0;e=H[H[a+52>>2]+40>>2];a:{b:{b=I[b+2|0]|I[b+1|0]<<8;if(!b){break b}if(b>>>0<=c>>>0){break a}l=e-4|0;while(1){if((b|0)>(l|0)){return Ya(72232)}c=b+f|0;h=I[c+2|0]<<8|I[c+3|0];i=b+h|0;d=d+h|0;b=I[c+1|0]|I[c|0]<<8;if(b>>>0>i+3>>>0){continue}break}if(b){return Ya(72242)}if(e>>>0>=i>>>0){break b}return Ya(72246)}c:{if((d|0)<=(e|0)){b=((k+g|0)+(j<<1)|0)+8|0;if((b|0)<=(d|0)){break c}}return Ya(72258)}H[a+20>>2]=d-b&65535;return 0}return Ya(72227)}function Cj(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0;k=1;i=d&2147483647;j=i;l=(i|0)==2147418112;a:{if(l&!c?a|b:l&(c|0)!=0|i>>>0>2147418112){break a}i=h&2147483647;if(!g&(i|0)==2147418112?e|f:(i|0)==2147418112&(g|0)!=0|i>>>0>2147418112){break a}if(!(a|e|(c|g)|(b|f|(i|j)))){return 0}i=d&h;if((i|0)>0){j=1}else{j=(i|0)>=0}if(j){if((c|0)==(g|0)&(d|0)==(h|0)?(b|0)==(f|0)&a>>>0<e>>>0|b>>>0<f>>>0:c>>>0<g>>>0&(d|0)<=(h|0)|(d|0)<(h|0)){return-1}return(a^e|c^g|(b^f|d^h))!=0}if((c|0)==(g|0)&(d|0)==(h|0)?(b|0)==(f|0)&a>>>0>e>>>0|b>>>0>f>>>0:c>>>0>g>>>0&(d|0)>=(h|0)|(d|0)>(h|0)){return-1}k=(a^e|c^g|(b^f|d^h))!=0}return k}function Bj(a,b,c,d,e,f,g,h){var i=0,j=0,k=0,l=0;k=-1;i=d&2147483647;j=i;l=(i|0)==2147418112;a:{if(l&!c?a|b:l&(c|0)!=0|i>>>0>2147418112){break a}i=h&2147483647;if(!g&(i|0)==2147418112?e|f:(i|0)==2147418112&(g|0)!=0|i>>>0>2147418112){break a}if(!(a|e|(c|g)|(b|f|(i|j)))){return 0}i=d&h;if((i|0)>0){j=1}else{j=(i|0)>=0}if(j){if((c|0)==(g|0)&(d|0)==(h|0)?(b|0)==(f|0)&a>>>0<e>>>0|b>>>0<f>>>0:c>>>0<g>>>0&(d|0)<=(h|0)|(d|0)<(h|0)){break a}return(a^e|c^g|(b^f|d^h))!=0}if((c|0)==(g|0)&(d|0)==(h|0)?(b|0)==(f|0)&a>>>0>e>>>0|b>>>0>f>>>0:c>>>0>g>>>0&(d|0)>=(h|0)|(d|0)>(h|0)){break a}k=(a^e|c^g|(b^f|d^h))!=0}return k}function Yz(a,b,c,d,e,f){var g=0,h=0,i=0,j=0,k=0,l=0,m=0;g=H[a+8>>2];h=H[e>>2];a:{switch(b-1|0){case 1:c=H[a+44>>2];H[a+44>>2]=c+h;b=0;j=(h|0)>0?h:0;i=h-1|0;k=e+8|0;c=c+1|0;l=h+H[g+108>>2]|0;while(1){if((b|0)!=(j|0)){e=b+c|0;h=b+f|0;m=md(a,H[(b<<4)+k>>2]);b:{if((b|0)<(i|0)){Ua(g,52,h,l,e);break b}Ua(g,53,h,d,e)}Wd(g,-1,m,-2);e=H[g+108>>2];if((e|0)>0){G[(H[g+104>>2]+N(e,20)|0)-18>>1]=128}b=b+1|0;continue}break};Ua(g,80,f,c,i);return c;default:b=zb(a);gb(g,29,c,d,f,h);Ua(g,97,f,h,b);gb(g,138,c,b,f,h);d=H[g+108>>2];if((d|0)>0){G[(H[g+104>>2]+N(d,20)|0)-18>>1]=16}rb(a,b);i=c;break;case 0:break a}}return i}function fn(a,b,c,d){var e=0,f=0,g=0,h=0,i=0;f=Ea-16|0;Ea=f;a:{e=H[b>>2];g=e+c|0;if(g>>>0>K[b+4>>2]){b:{c:{if((g|0)>=200){H[f>>2]=200;Wa(a,17409,f);break c}g=H[a>>2];h=e>>31<<1|e>>>31;i=e<<1;e=i+c|0;a=h+(c>>31)|0;a=e>>>0<i>>>0?a+1|0:a;h=(a|0)>=0&e>>>0>=200|(a|0)>0;e=h?200:e;b=ed(g,b,e<<6|8,(h?0:a)<<6|e>>>26);if(b){break b}}b=0;break a}H[b+4>>2]=e;e=H[b>>2]}a=b+8|0;while(1){if((d|0)<(e|0)){e=e-1|0;Va(a+(e+c<<6)|0,a+(e<<6)|0,64);continue}break}H[b>>2]=H[b>>2]+c;Xa(a+(d<<6)|0,0,c<<6);c=c+d|0;c=(c|0)<(d|0)?d:c;while(1){if((c|0)==(d|0)){break a}H[(a+(d<<6)|0)+40>>2]=-1;d=d+1|0;continue}}Ea=f+16|0;return b}function Jx(a,b,c,d){var e=0,f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0;e=Ea-32|0;Ea=e;H[e+16>>2]=b;H[e+28>>2]=0;b=7;g=Ab(8863,e+16|0);a:{if(!g){break a}j=tb(g);b=Yp(g,e+28|0);f=b?b:g;h=f+H[e+28>>2]|0;F[h|0]=0;ii(f);b=1;k=_l(a,f,tb(f)+1|0);b:{if(k){j=g+j|0;c:{while(1){d:{b=l;a=h+1|0;if(a>>>0>=j>>>0){break d}f=Yp(a,e+28|0);if(!f){break d}l=b+1|0;m=l?m:m+1|0;a=Fc(i,l<<2&-4,0);if(!a){break c}H[a+(b<<2)>>2]=f;h=f+H[e+28>>2]|0;F[h|0]=0;ii(f);i=a;continue}break}b=Ia[H[k+4>>2]](b,i,c)|0;e:{if(b){Sd(d,9162,0);break e}H[H[c>>2]>>2]=k}Ta(i);break b}Ta(g);Ta(i);b=7;break a}H[e>>2]=f;Sd(d,7781,e)}Ta(g)}Ea=e+32|0;return b}function YB(a,b,c,d,e,f){a=a|0;b=b|0;c=c|0;d=d|0;e=e|0;f=f|0;var g=0,h=0,i=0,j=0,k=0,l=0;k=I[e|0]+e|0;l=I[c|0]+c|0;a:{j=I[c+1|0];h=I[e+1|0];b:{c:{if((j|0)==(h|0)){j=I[j+34276|0];while(1){if((g|0)==(j|0)){break b}h=g+k|0;i=g+l|0;g=g+1|0;i=I[i|0]-I[h|0]|0;if(!i){continue}break}g=F[l|0];if((g^I[k|0])<<24>>24>=0){break c}g=g>>31|1;break a}i=j-h|0;h=h>>>0>7;if(h&j>>>0>=8){break c}g=1;i=j>>>0>7?-1:i;h=h?1:i;if((h|0)>0){i=F[l|0]<0?-1:h;break c}if(F[k|0]<0){break a}}g=i;if(g){break a}}if(J[H[H[a+12>>2]+28>>2]+6>>1]>=2){a=gt(a,b,c,d,e,f)}else{a=0}return a|0}return(I[H[H[H[a+12>>2]+28>>2]+16>>2]]?0-g|0:g)|0}function gv(a,b,c,d,e){var f=0,g=0,h=0;g=Ea-16|0;Ea=g;if(a){a:{b:{if(!e){break b}f=H[a+4>>2];f=Ia[H[H[f>>2]+28>>2]](f,4)|0;if(f){break a}if(!I[a+43|0]){F[a+43|0]=1}f=Gv(a,b,0,0,0,c,d,e,0,0);if(f){break a}H[g+12>>2]=-1;b=H[a+4>>2];c=H[b>>2];if(!c){h=1;break b}Ia[H[c+40>>2]](b,10,g+12|0)|0;h=1;if(H[g+12>>2]!=1){break b}h=0;if(H[a+20>>2]<0){break b}Zu(a,0,0)}f=0}Po(a,h);b=H[a+8>>2];c=H[b>>2];if(c){Ia[H[c+4>>2]](b)|0;H[b>>2]=0}c:{if(!h){break c}b=H[18327];if(b){Ia[b|0]()}b=H[a>>2];c=H[b+28>>2];if(c){Ia[c|0](b,H[a+108>>2],0)|0}b=H[18328];if(!b){break c}Ia[b|0]()}Ta(H[a+32>>2]);Ta(a)}Ea=g+16|0;return f}function nE(a,b,c){a=a|0;b=b|0;c=c|0;var d=0,e=0,f=0,g=0,h=0,i=0;a:{if((b|0)==2){b:{if((Kb(H[c>>2])|0)!=5){if((Kb(H[c+4>>2])|0)!=5){break b}}Rb(a);return}d=$a(H[c>>2]);i=$a(H[c+4>>2]);e=lc(tb(d)+1|0);if(!e){break a}g=e;while(1){c=i;f=Ee(d);if(f){while(1){h=Ee(c);if(!(!h|(f|0)==(h|0))){while(1){b=I[c+1|0];c=c+1|0;if((b&192)==128){continue}break}continue}break}b=c;if(h){while(1){f=I[b+1|0];b=b+1|0;if((f&192)==128){continue}break}b=b-c|0;g=Fw(g,c,b)+b|0}while(1){b=I[d+1|0];d=d+1|0;if((b&192)==128){continue}break}continue}break}F[g|0]=0;qb(a,e,-1,-1);Ta(e);return}Y(23600,17858,939,17573);D()}Ub(a)}function qy(a,b,c,d,e,f,g,h,i,j,k){var l=0,m=0;if(!(c|d)){if(e|f){return 267}m=j+20|0}l=ub(m+96|0,0);if(!l){return 7}l=Xa(l,0,96);H[l+24>>2]=g;H[l+28>>2]=h;H[l+16>>2]=e;H[l+20>>2]=f;H[l+8>>2]=c;H[l+12>>2]=d;F[l+4|0]=(b|0)!=0;H[l>>2]=a;a:{if(m){H[l+44>>2]=j;F[l+5|0]=1;a=l+96|0;H[l+40>>2]=a;if(j){Va(a,i,j)}a=a+j|0;F[a|0]=0;F[a+1|0]=0;F[a+2|0]=0;F[a+3|0]=0;F[a+4|0]=0;F[a+5|0]=0;F[a+6|0]=0;F[a+7|0]=0;F[a+16|0]=0;F[a+17|0]=0;F[a+18|0]=0;F[a+19|0]=0;F[a+8|0]=0;F[a+9|0]=0;F[a+10|0]=0;F[a+11|0]=0;F[a+12|0]=0;F[a+13|0]=0;F[a+14|0]=0;F[a+15|0]=0;break a}H[l+32>>2]=c-1;H[l+36>>2]=d-!c}H[k>>2]=l;return 0}function oo(a,b,c){var d=0,e=0;d=Ea-16|0;Ea=d;a:{b=J[c+18>>1]+b|0;if(b>>>0>K[a+60>>2]){c=Ya(76982);break a}b=cb(b-4|0);e=H[a+52>>2];a=H[e+40>>2]-4|0;a=((a+H[c+12>>2]|0)+(J[c+16>>1]^-1)>>>0)/(a>>>0)|0;while(1){if(!a){c=0;break a}H[d+12>>2]=0;H[d+8>>2]=0;if(!(b>>>0>=2&K[e+48>>2]>=b>>>0)){c=Ya(76999);break a}b:{c:{d:{a=a-1|0;if(a){c=vu(e,b,d+8|0,d+12|0);if(c){break a}c=H[d+8>>2];if(c){break d}}c=qt(e,b);H[d+8>>2]=c;if(c){break d}c=0;break c}if(H[H[c+72>>2]+32>>2]==1){break c}c=Ya(77019);break b}c=pt(e,c,b)}b=H[d+8>>2];if(b){jd(H[b+72>>2])}if(c){break a}b=H[d+12>>2];continue}}Ea=d+16|0;return c}function Rt(a,b){var c=0,d=0,e=0,f=0,g=0;f=Ea-16|0;Ea=f;c=H[(H[a+16>>2]+(b<<4)|0)+12>>2];d=c+16|0;while(1){d=H[d>>2];if(d){e=H[d+8>>2];H[e+28>>2]=H[e+28>>2]&-17;continue}break}d=c+32|0;c=d;while(1){c=H[c>>2];if(c){e=H[c+8>>2];g=(I[e+55|0]|I[e+56|0]<<8)&65407;F[e+55|0]=g;F[e+56|0]=g>>>8;continue}break}H[f+8>>2]=a;c=H[H[a+16>>2]+(b<<4)>>2];H[f+12>>2]=c;b=0;e=yc(a,23663,c);a:{if(!e|I[e+43|0]){break a}H[f>>2]=c;c=mb(a,23635,f);if(!c){b=7;break a}b=fe(a,c,31,f+8|0,0);db(a,c)}while(1){d=H[d>>2];if(d){c=H[d+8>>2];if(I[c+55|0]&128){continue}tt(c);continue}break}if((b|0)==7){Ib(a)}Ea=f+16|0;return b}function Ty(a,b,c,d,e,f){var g=0,h=0,i=0;a:{if(!(!c|!f)){if((b|0)!=(e|0)){break a}return!Hb(a,d,b)}h=Ea-16|0;Ea=h;b:{while(1){c:{if(!b){b=0;H[h+12>>2]=0;break c}g=I[a|0];if(!(!c&(g|0)==92)){H[h+12>>2]=g;if(g>>>0>=192){g=yq(a,b,h+12|0);b=b-g|0;a=a+g|0;break c}b=b-1|0;a=a+1|0;break c}g=gm(a,b,h+12|0);b=b-g|0;a=a+g|0}d:{if(!e){e=0;H[h+8>>2]=0;break d}g=I[d|0];if(!(!f&(g|0)==92)){H[h+8>>2]=g;if(g>>>0>=192){g=yq(d,e,h+8|0);e=e-g|0;d=d+g|0;break d}e=e-1|0;d=d+1|0;break d}g=gm(d,e,h+8|0);e=e-g|0;d=d+g|0}g=H[h+12>>2];i=0;if((g|0)!=H[h+8>>2]){break b}if(g){continue}break}i=1}g=i;Ea=h+16|0}return g}function Zs(a,b){a=a|0;b=b|0;var c=0,d=0,e=0,f=0,g=0;a=Ea-16|0;Ea=a;f=+$();e=f/1e3;a:{if(P(e)<0x8000000000000000){c=~~e>>>0;if(P